/*
 * Decompiled with CFR 0.152.
 */
package ccl.swing;

import ccl.swing.MainJFrame;
import ccl.swing.RunnableAction;
import ccl.util.FileObject;
import ccl.util.Init;
import ccl.util.Util;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class MainJMenuBar
extends JMenuBar {
    public static final String S_HELP_CONTENTS = "&Contents...";
    private MainJFrame _pMainJFrame = null;

    public MainJMenuBar(Vector vMenus_, MainJFrame pMainJFrame_) {
        Util.panicIf(vMenus_ == null || pMainJFrame_ == null);
        Util.debug("MainJMenuBar: init");
        this._pMainJFrame = pMainJFrame_;
        Enumeration e = vMenus_.elements();
        while (e.hasMoreElements()) {
            Vector vMenu = (Vector)e.nextElement();
            MainJMenu pMainJMenu = new MainJMenu(vMenu, pMainJFrame_);
            Util.debug("MainJMenuBar: pMainMenu: " + pMainJMenu);
            this.add(pMainJMenu);
        }
    }

    public synchronized void updateMenu() {
        MainJMenu pFileJMenu = (MainJMenu)this.getMenu(0);
        Util.debug(this, "updateMenu().pFileJMenu: " + pFileJMenu);
        pFileJMenu.removeOldFileItems();
        pFileJMenu.insertOldFiles(this._pMainJFrame);
    }

    class MainJMenu
    extends JMenu {
        private int _oldFilesStartIndex = -1;
        private int _oldFilesCount = 0;

        private Vector _getOldFileItems(Init pInit_) {
            int nr;
            Vector<String> vRetVal = new Vector<String>();
            Enumeration eOldFiles = pInit_.getOldFilesElements();
            if (eOldFiles.hasMoreElements()) {
                vRetVal.addElement("--------");
            }
            this._oldFilesCount = nr = pInit_.getOldFilesSize();
            while (eOldFiles.hasMoreElements()) {
                vRetVal.insertElementAt("" + nr + " " + Util.firstCharToUpperCase(((FileObject)eOldFiles.nextElement()).getName()), 0);
                --nr;
            }
            return vRetVal;
        }

        private Enumeration _getMenuBodyElements(Vector vMenu_, Init pInit_) {
            Enumeration eRetVal = null;
            String sLabel = (String)vMenu_.elementAt(0);
            if (sLabel.equals("Datei") || sLabel.equals("File") || sLabel.equals("&Datei") || sLabel.equals("&File")) {
                Vector vFileMenu = (Vector)vMenu_.clone();
                int menuSlot = vFileMenu.size() - 1;
                if (menuSlot > 1) {
                    vFileMenu.insertElementAt("--------", menuSlot);
                    ++menuSlot;
                }
                this._oldFilesStartIndex = menuSlot - 1;
                Vector vOldFileItems = this._getOldFileItems(pInit_);
                vFileMenu = Util.insert(vFileMenu, vOldFileItems, menuSlot);
                eRetVal = vFileMenu.elements();
            } else {
                eRetVal = vMenu_.elements();
            }
            eRetVal.nextElement();
            return eRetVal;
        }

        public MainJMenu(Vector vMenu_, MainJFrame pMainJFrame_) {
            super((String)vMenu_.elementAt(0));
            this.setName(this.getText());
            if (this.getText().equals("File")) {
                this.setMnemonic('F');
            }
            if (this.getText().equals("Edit")) {
                this.setMnemonic('E');
            }
            if (this.getText().equals("Help")) {
                this.setMnemonic('H');
            }
            Util.panicIf(vMenu_ == null || vMenu_.size() < 2);
            Util.panicIf(pMainJFrame_ == null);
            Enumeration e = this._getMenuBodyElements(vMenu_, pMainJFrame_.getInit());
            while (e.hasMoreElements()) {
                String sActionCommand;
                Object oNext = e.nextElement();
                if (oNext instanceof Vector) {
                    MainJMenu mSub = new MainJMenu((Vector)oNext, pMainJFrame_);
                    this.add(mSub);
                    continue;
                }
                if (oNext instanceof RunnableAction) {
                    KeyStroke ksAccelerator;
                    RunnableAction pRunnableAction = (RunnableAction)oNext;
                    pRunnableAction.setMainFrame(pMainJFrame_);
                    JMenuItem miTemp = this.add(pRunnableAction);
                    Character charMnemonic = pRunnableAction.getMnemonic();
                    if (charMnemonic != null) {
                        miTemp.setMnemonic(charMnemonic.charValue());
                    }
                    if ((ksAccelerator = pRunnableAction.getAccelerator()) != null) {
                        miTemp.setAccelerator(ksAccelerator);
                    }
                    miTemp.setName(miTemp.getText());
                    Util.debug(this, "<init>.miTemp.name: " + miTemp.getName());
                    continue;
                }
                String sMenuItem = sActionCommand = (String)oNext;
                int indexMnemonic = sMenuItem.indexOf(38);
                char cMnemonic = '&';
                if (indexMnemonic != -1 && indexMnemonic < sMenuItem.length()) {
                    cMnemonic = sMenuItem.charAt(indexMnemonic + 1);
                    sMenuItem = Util.replace(sMenuItem, "&", "");
                }
                Util.debug(sMenuItem);
                if (sMenuItem.charAt(0) == '-') {
                    Util.debug("---");
                    this.addSeparator();
                    continue;
                }
                JMenuItem miTemp = null;
                miTemp = sMenuItem.equals("Save") || sMenuItem.equals("Speichern") ? new JMenuItem(sMenuItem, 83) : new JMenuItem(sMenuItem);
                if (indexMnemonic != 38) {
                    miTemp.setMnemonic(cMnemonic);
                }
                miTemp.setActionCommand(sActionCommand);
                miTemp.setName(miTemp.getText());
                if (sActionCommand.equals(MainJMenuBar.S_HELP_CONTENTS)) {
                    Util.debug(this, "pMainJFrame_: " + pMainJFrame_);
                    HelpBroker pHelpBroker = pMainJFrame_.getHelpBroker();
                    miTemp.addActionListener((ActionListener)new CSH.DisplayHelpFromSource(pHelpBroker));
                    Util.debug(this, "<init>(..).HELP BROKER IS SET");
                } else {
                    miTemp.addActionListener(pMainJFrame_);
                }
                this.add(miTemp);
            }
        }

        public void removeOldFileItems() {
            if (this._oldFilesCount == 0) {
                return;
            }
            int i = 0;
            while (i < this._oldFilesCount + 1) {
                this.remove(this._oldFilesStartIndex);
                ++i;
            }
            this._oldFilesCount = 0;
        }

        public void insertOldFiles(MainJFrame pMainJFrame_) {
            Vector vOldFileItems = this._getOldFileItems(pMainJFrame_.getInit());
            int i = 0;
            while (i < vOldFileItems.size()) {
                String sItem = (String)vOldFileItems.elementAt(i);
                if (sItem.charAt(0) == '-') {
                    this.insertSeparator(this._oldFilesStartIndex + i);
                } else {
                    JMenuItem miTemp = new JMenuItem(sItem);
                    miTemp.setMnemonic(sItem.charAt(0));
                    miTemp.addActionListener(pMainJFrame_);
                    this.insert(miTemp, this._oldFilesStartIndex + i);
                }
                ++i;
            }
        }
    }
}

