/*
 * Decompiled with CFR 0.152.
 */
package ccl.util;

import ccl.util.ClassPathUtil;
import ccl.util.FileUtil;
import ccl.util.StreamCopier;
import ccl.util.Util;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class FileUtil {
    private static final String S_SWINGALL_JAR = "swingall.jar";
    private static final String S_SWING_JAR = "swing.jar";

    private FileUtil() {
    }

    public static String getPackagePath(String sPackageName_) {
        return FileUtil.getPackagePath(sPackageName_, System.getProperty("java.class.path"));
    }

    public static String getPackagePath(String sPackageName_, String sClassPath_) {
        Util.debug("ccl.util.FileUtil.getPackagePath(..).sPackageName_: " + sPackageName_);
        Util.panicIf(Util.isEmpty(sPackageName_));
        Util.panicIf(Util.isEmpty(sClassPath_));
        int index = Util.indexOfNot(sPackageName_, '.');
        String sPackagePath = "";
        if (index > -1) {
            sPackagePath = sPackageName_.substring(index);
        }
        sPackagePath = sPackagePath.replace('.', File.separatorChar);
        Vector vClassPaths = Util.stringToLines(sClassPath_, File.pathSeparatorChar);
        if (vClassPaths.size() == 0) {
            vClassPaths.addElement(".");
        }
        Enumeration eClassPaths = vClassPaths.elements();
        while (eClassPaths.hasMoreElements()) {
            String sNextPath = (String)eClassPaths.nextElement();
            sNextPath = FileUtil.concatPath(sNextPath, sPackagePath);
            Util.debug("ccl.util.FileUtil.getPackagePath(..).sNextPath: " + sNextPath);
            if (!FileUtil.existsDir(sNextPath)) continue;
            return sNextPath;
        }
        return "";
    }

    public static String getClassPath(Object oClass_) {
        Util.debug("ccl.util.FileUtil.getClassPath(..).oClass_: " + String.valueOf(oClass_));
        if (oClass_ == null) {
            return null;
        }
        String sClassName = oClass_.getClass().getName();
        int index = sClassName.lastIndexOf(46);
        String sPackageName = ".";
        if (index != -1) {
            sPackageName = sClassName.substring(0, sClassName.lastIndexOf(46));
        }
        Util.debug("ccl.util.FileUtil.getClassPath(..).sPackageName: " + sPackageName);
        String sPackagePath = FileUtil.getPackagePath(sPackageName);
        return sPackagePath;
    }

    public static String getClassPath(String sFullClassName_) {
        String sPackageName;
        Util.debug("FileUtil.getClassPath(..).sFullClassName_: " + sFullClassName_);
        if (Util.isEmpty(sFullClassName_)) {
            return null;
        }
        int indexLastDot = sFullClassName_.lastIndexOf(46);
        if (indexLastDot == -1) {
            indexLastDot = 0;
        }
        if (Util.isEmpty(sPackageName = sFullClassName_.substring(0, indexLastDot))) {
            sPackageName = ".";
        }
        String sPackagePath = FileUtil.getPackagePath(sPackageName);
        return sPackagePath;
    }

    public static String getSwingHome() {
        String sRetVal = null;
        Vector vClasspath = Util.stringToLines(System.getProperty("java.class.path"), File.pathSeparatorChar);
        Enumeration eClasspath = vClasspath.elements();
        while (eClasspath.hasMoreElements()) {
            String sClasspathElement = (String)eClasspath.nextElement();
            Util.debug("FileUtil.getSwingHome().sClasspathElement: " + sClasspathElement);
            if (Util.endsWith(sClasspathElement, S_SWINGALL_JAR)) {
                sRetVal = sClasspathElement.substring(0, sClasspathElement.length() - S_SWINGALL_JAR.length());
                return sRetVal;
            }
            if (!Util.endsWith(sClasspathElement, S_SWING_JAR)) continue;
            sRetVal = sClasspathElement.substring(0, sClasspathElement.length() - S_SWING_JAR.length());
            return sRetVal;
        }
        sRetVal = FileUtil.getPackagePath("com.sun.java.swing");
        if (!Util.isEmpty(sRetVal)) {
            sRetVal = sRetVal.substring(0, sRetVal.length() - 18 + 1);
        }
        Util.debug("FileUtil.getSwingHome().sRetVal: " + sRetVal);
        return sRetVal;
    }

    public static String concatPath(String sPath_, String sFile_) {
        Util.panicIf(sPath_ == null);
        Util.debug("ccl.util.FileUtil.concatPath(..).sPath_: --->" + sPath_ + "<---");
        Util.debug("ccl.util.FileUtil.concatPath(..).sFile_: " + sFile_);
        String sRetVal = sPath_;
        if (!Util.isEmpty(sFile_)) {
            if (sPath_.length() > 0 && !Util.endsWith(sPath_, File.separatorChar)) {
                sRetVal = sRetVal + File.separator;
            }
            sRetVal = sRetVal + sFile_;
        }
        return sRetVal;
    }

    public static DataInputStream openFile(String sFile) {
        try {
            FileInputStream fis = new FileInputStream(sFile);
            if (fis != null) {
                DataInputStream dis = new DataInputStream(fis);
                return dis;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static DataOutputStream openOutputFile(String sFile) {
        try {
            FileOutputStream fos = new FileOutputStream(sFile);
            if (fos != null) {
                DataOutputStream dos = new DataOutputStream(fos);
                return dos;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String readStream(InputStream stream_) throws IOException, FileNotFoundException {
        StringBuffer sFileContent = new StringBuffer(100000);
        InputStreamReader streamReader = new InputStreamReader(stream_);
        if (streamReader != null) {
            BufferedReader brIni = new BufferedReader(streamReader);
            if (brIni != null) {
                while (brIni.ready()) {
                    String sLine = brIni.readLine();
                    if (sLine == null) break;
                    sFileContent.append(sLine).append('\n');
                }
                brIni.close();
            }
            streamReader.close();
        }
        return sFileContent.toString();
    }

    public static String readFile(String sFileName_) throws IOException, FileNotFoundException {
        StringBuffer sFileContent = new StringBuffer(100000);
        FileReader frIni = new FileReader(sFileName_);
        if (frIni != null) {
            BufferedReader brIni = new BufferedReader(frIni);
            if (brIni != null) {
                while (brIni.ready()) {
                    String sLine = brIni.readLine();
                    if (sLine == null) break;
                    sFileContent.append(sLine).append('\n');
                }
                brIni.close();
            }
            frIni.close();
        }
        return sFileContent.toString();
    }

    public static Byte[] readBinaryFile(String sFileName_) {
        Util.panicIf(true, "Method ccl.util.FileUtil.readBinaryFile(..): has no implementation!");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static String readFile(URL location) throws MalformedURLException, IOException {
        int oneChar;
        InputStream is = location.openStream();
        StringBuffer sb = new StringBuffer();
        while ((oneChar = is.read()) != -1) {
            void var2_3;
            if ((char)var2_3 == '\r') continue;
            sb.append((char)var2_3);
        }
        is.close();
        return sb.toString();
    }

    public static void appendFile(String sFileName_, String sAddedContent_) throws IOException {
        Util.debug("ccl.util.FileUtil.appendFile(..).sFileName_: " + sFileName_);
        FileWriter writer = new FileWriter(sFileName_, true);
        writer.write(sAddedContent_);
        writer.close();
    }

    public static void writeFile(String sFileName, String sContent) throws IOException {
        FileOutputStream fos = new FileOutputStream(sFileName);
        int i = 0;
        while (i < sContent.length()) {
            fos.write(sContent.charAt(i));
            ++i;
        }
        fos.close();
    }

    public static void writeFileWithBackup(String sFileName_, String sContent_) throws IOException {
        Util.panicIf(Util.isEmpty(sFileName_));
        FileUtil.move(sFileName_, sFileName_ + ".bak");
        FileUtil.writeFile(sFileName_, sContent_);
    }

    public static void createBackupFile(String sFileName_) throws IOException {
        Util.panicIf(Util.isEmpty(sFileName_));
        if (FileUtil.existsFile(sFileName_)) {
            FileUtil.copy(sFileName_, sFileName_ + ".bak");
        }
    }

    public static void writeDosFile(String sFileName_, String sContent_) throws IOException {
        sContent_ = Util.replace(sContent_, "\n", new Character('\r').toString() + "\n");
        FileUtil.writeFile(sFileName_, sContent_);
    }

    public static boolean equalsFile(String sFileNameA_, String sFileNameB_) {
        String sFileContentA = "";
        String sFileContentB = "";
        try {
            sFileContentA = FileUtil.readFile(sFileNameA_);
            sFileContentB = FileUtil.readFile(sFileNameB_);
        }
        catch (Exception e) {
            return false;
        }
        return sFileContentA.equals(sFileContentB);
    }

    public static boolean existsFile(String sFileName_) {
        Util.panicIf(sFileName_ == null, "FileUtil: existsFile");
        File pFile = new File(sFileName_);
        return pFile.isFile();
    }

    public static boolean existsDir(String sDirName_) {
        Util.panicIf(sDirName_ == null, "FileUtil: existsDir(String)");
        File pFile = new File(sDirName_);
        return pFile.isDirectory();
    }

    public static boolean exists(String sFileOrDirName_) {
        Util.panicIf(sFileOrDirName_ == null, "Util: exists");
        return FileUtil.existsFile(sFileOrDirName_) || FileUtil.existsDir(sFileOrDirName_);
    }

    public static Vector getFilteredDirContent(String sDir_, FilenameFilter pFilenameFilter_) {
        Util.debug("ccl.util.FileUtil.getFilteredDirContent(..).sDir_: " + sDir_);
        Util.panicIf(sDir_ == null);
        File pFile = new File(sDir_);
        Util.panicIf(!pFile.isDirectory());
        String[] asDirContent = pFile.list(pFilenameFilter_);
        Util.debug("ccl.util.FileUtil.getFilteredDirContent(..).asDirContent.length: " + asDirContent.length);
        Vector<String> vRetVal = new Vector<String>();
        int index = 0;
        while (index < asDirContent.length) {
            vRetVal.addElement(asDirContent[index]);
            ++index;
        }
        Util.debug("ccl.util.FileUtil.getFilteredDirContent(..).vRetVal: " + vRetVal);
        return vRetVal;
    }

    public static Vector _getFilteredDirContent(String sDir_, FilenameFilter pFilenameFilter_) {
        return FileUtil.getFilteredDirContent(sDir_, pFilenameFilter_);
    }

    public static Vector getSubDirs(String sDir_) {
        class DirFilter
        implements FilenameFilter {
            DirFilter() {
            }

            public boolean accept(File flDir_, String sName_) {
                File flTemp = new File(flDir_, sName_);
                return flTemp.isDirectory();
            }
        }
        return FileUtil.getFilteredDirContent(sDir_, new DirFilter());
    }

    public static Vector getFiles(String sDir_) {
        FilenameFilter pFilenameFilter = new FilenameFilter(){

            public boolean accept(File flDir_, String sName_) {
                File flTemp = new File(flDir_, sName_);
                return flTemp.isFile();
            }
        };
        return FileUtil.getFilteredDirContent(sDir_, pFilenameFilter);
    }

    public static Vector getFiles(String sDir_, String sSuffix_) {
        Util.panicIf(sSuffix_ == null);
        Vector vFinalSuffixes = Util.stringToLines(sSuffix_, File.pathSeparatorChar);
        class SuffixFilter
        implements FilenameFilter {
            private final /* synthetic */ Vector val$vFinalSuffixes;

            SuffixFilter(Vector val$vFinalSuffixes) {
                this.val$vFinalSuffixes = val$vFinalSuffixes;
            }

            public boolean accept(File flDir_, String sName_) {
                if (this.val$vFinalSuffixes.size() == 0) {
                    return true;
                }
                Enumeration<E> e = this.val$vFinalSuffixes.elements();
                while (e.hasMoreElements()) {
                    String sSuffix = (String)e.nextElement();
                    if (!sName_.endsWith(sSuffix)) continue;
                    return true;
                }
                return false;
            }
        }
        return FileUtil.getFilteredDirContent(sDir_, new SuffixFilter(vFinalSuffixes));
    }

    public static Vector getFiles(String sDir_, String sPrefix_, String sSuffix_) {
        Util.panicIf(sPrefix_ == null);
        Util.panicIf(sSuffix_ == null);
        Vector vFinalSuffixes = Util.stringToLines(sSuffix_, File.pathSeparatorChar);
        class SuffixFilter
        implements FilenameFilter {
            private final /* synthetic */ String val$sPrefix_;
            private final /* synthetic */ Vector val$vFinalSuffixes;

            SuffixFilter(String val$sPrefix_, Vector val$vFinalSuffixes) {
                this.val$sPrefix_ = val$sPrefix_;
                this.val$vFinalSuffixes = val$vFinalSuffixes;
            }

            public boolean accept(File flDir_, String sName_) {
                Util.debug(this, "accept(..).sName_: " + sName_);
                boolean bRetVal = false;
                if (sName_.startsWith(this.val$sPrefix_)) {
                    if (this.val$vFinalSuffixes.size() == 0) {
                        bRetVal = true;
                    }
                    Enumeration<E> e = this.val$vFinalSuffixes.elements();
                    while (e.hasMoreElements()) {
                        String sSuffix = (String)e.nextElement();
                        if (!sName_.endsWith(sSuffix)) continue;
                        bRetVal = true;
                        break;
                    }
                }
                Util.debug(this, "accept(..).bRetVal: " + bRetVal);
                return bRetVal;
            }
        }
        return FileUtil.getFilteredDirContent(sDir_, new SuffixFilter(sPrefix_, vFinalSuffixes));
    }

    public static boolean equalsPath(String sFirstPath_, String sSecondPath_) {
        Util.panicIf(sFirstPath_ == null || sSecondPath_ == null);
        if (sFirstPath_.equals(sSecondPath_)) {
            return true;
        }
        if (sFirstPath_.equals("") || sSecondPath_.equals("")) {
            return false;
        }
        sFirstPath_ = sFirstPath_.replace('\\', '/').toLowerCase();
        sSecondPath_ = sSecondPath_.replace('\\', '/').toLowerCase();
        if (sFirstPath_.charAt(sFirstPath_.length() - 1) != '/') {
            sFirstPath_ = sFirstPath_ + "/";
        }
        if (sSecondPath_.charAt(sSecondPath_.length() - 1) != '/') {
            sSecondPath_ = sSecondPath_ + "/";
        }
        return sFirstPath_.equals(sSecondPath_);
    }

    public static boolean delete(String sFileName_) {
        Util.panicIf(sFileName_ == null);
        boolean bRetVal = false;
        boolean bExists = FileUtil.exists(sFileName_);
        if (!bExists) {
            return bRetVal;
        }
        try {
            File flTemp = new File(sFileName_);
            bRetVal = !flTemp.delete();
        }
        catch (SecurityException pSecurityException) {
            return true;
        }
        return bRetVal;
    }

    public static boolean deleteRecursively(String sFileName_) {
        Util.panicIf(sFileName_ == null);
        Util.debug("ccl.util.FileUtil.deleteRecursively(..).sFileName_: " + sFileName_);
        boolean bRetVal = false;
        boolean bExists = FileUtil.exists(sFileName_);
        if (!bExists) {
            return bRetVal;
        }
        if (FileUtil.existsFile(sFileName_)) {
            return FileUtil.delete(sFileName_);
        }
        try {
            File flTemp = new File(sFileName_);
            String[] asList = flTemp.list();
            int file = 0;
            while (file < asList.length) {
                bRetVal = FileUtil.deleteRecursively(FileUtil.concatPath(sFileName_, asList[file]));
                if (bRetVal) {
                    return bRetVal;
                }
                ++file;
            }
            bRetVal = !flTemp.delete();
        }
        catch (SecurityException pSecurityException) {
            return true;
        }
        return bRetVal;
    }

    public static boolean move(String sSource_, String sDest_) {
        Util.panicIf(sSource_ == null || sDest_ == null);
        try {
            File flSource = new File(sSource_);
            File flDest = new File(sDest_);
            FileUtil.delete(sDest_);
            return !flSource.renameTo(flDest);
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static boolean md(String sFullDirName) {
        boolean bError = false;
        try {
            File flDir = new File(sFullDirName);
            bError = !flDir.mkdirs();
        }
        catch (Exception e) {
            bError = true;
        }
        return bError;
    }

    public static String getAbsoluteFileName(String sFileName_) {
        String sRetVal = null;
        try {
            File pFile = new File(sFileName_);
            sRetVal = pFile.getCanonicalPath();
        }
        catch (Exception e) {
            return null;
        }
        return sRetVal;
    }

    public static String getAbsolutePath(String sFileName_) {
        return FileUtil.getAbsoluteFileName(sFileName_);
    }

    public static String normalizeFileName(String sFile) {
        return FileUtil.normalizeFileName(sFile, (String)((Hashtable)System.getProperties()).get("user.dir"));
    }

    public static String normalizeFileName(String sFile, String sUserDir) {
        if (Util.isEmpty(sFile = sFile.trim()) || sFile.equals(".")) {
            sFile = sUserDir;
        } else if (!FileUtil.isAbsolute(sFile)) {
            sFile = FileUtil.concatPath(sUserDir, sFile);
        }
        sFile = FileUtil.getAbsoluteFileName(sFile);
        return sFile;
    }

    public static String getTempFileName() {
        String sRetVal = null;
        int tries = 0;
        while (sRetVal == null) {
            sRetVal = "~" + Util.rnd(10000);
            if (FileUtil.exists(sRetVal)) {
                ++tries;
                sRetVal = null;
            }
            if (tries >= 5) break;
        }
        return sRetVal;
    }

    public static String getTempDir() {
        String tempDir = System.getProperty("java.io.tmpdir");
        if (tempDir == null) {
            tempDir = System.getProperty("user.home");
            if (FileUtil.existsFile(tempDir = FileUtil.concatPath(tempDir, "tmp"))) {
                FileUtil.delete(tempDir);
            }
            if (!FileUtil.existsDir(tempDir)) {
                FileUtil.md(tempDir);
            }
        }
        return tempDir;
    }

    public static String createTempDir() throws IOException {
        String sTempDir = File.createTempFile("ccl", null, null).getPath();
        Util.debug("ccl.util.FileUtil.createTempFile().sTempDir: " + sTempDir);
        FileUtil.delete(sTempDir);
        FileUtil.md(sTempDir);
        return sTempDir;
    }

    public static boolean isAbsolute(String sFileName_) {
        Util.panicIf(Util.isEmpty(sFileName_), "File is empty! Therefore can't test if the file is absolute.");
        return new File(sFileName_).isAbsolute();
    }

    public static boolean areAllPathsAbsolute(String sPathList_) {
        boolean bRetVal = false;
        if (Util.isEmpty(sPathList_)) {
            return bRetVal;
        }
        Vector vPaths = Util.stringToLines(sPathList_, File.pathSeparatorChar);
        int path = 0;
        while (path < vPaths.size()) {
            String sSinglePath = (String)vPaths.elementAt(path);
            if (!Util.isEmpty(sSinglePath)) {
                if (!FileUtil.isAbsolute(sSinglePath)) {
                    return false;
                }
                bRetVal = true;
            }
            ++path;
        }
        return bRetVal;
    }

    public static String getAbsolutePathList(String sPathList_) {
        String sStartPath = System.getProperty("user.dir");
        Vector vPaths = Util.stringToLines(sPathList_, File.pathSeparatorChar);
        int path = 0;
        while (path < vPaths.size()) {
            String sSinglePath = (String)vPaths.elementAt(path);
            if (!FileUtil.isAbsolute(sSinglePath)) {
                sSinglePath = FileUtil.concatPath(sStartPath, sSinglePath);
                try {
                    File flSinglePath = new File(sSinglePath);
                    sSinglePath = flSinglePath.getAbsolutePath();
                }
                catch (Exception e) {
                    Util.printlnErr("FileUtil.getAbsolutePath(..).e: " + e);
                }
                vPaths.setElementAt(sSinglePath, path);
            }
            ++path;
        }
        String sRetVal = Util.concat(vPaths, File.pathSeparatorChar);
        if (sRetVal.length() > 0 && !Util.endsWith(sRetVal, File.pathSeparatorChar)) {
            sRetVal = sRetVal + Util.cToS(File.pathSeparatorChar);
        }
        return sRetVal;
    }

    public static Vector getRecursiveDir(String sFileName_) {
        Vector vsRetVal = new Vector();
        if (!FileUtil.exists(sFileName_)) {
            return vsRetVal;
        }
        vsRetVal.addElement(sFileName_);
        if (!FileUtil.existsDir(sFileName_)) {
            return vsRetVal;
        }
        Vector vFiles = FileUtil.getFiles(sFileName_);
        Enumeration eFiles = vFiles.elements();
        while (eFiles.hasMoreElements()) {
            String sNextFile = (String)eFiles.nextElement();
            vsRetVal.addElement(FileUtil.concatPath(sFileName_, sNextFile));
        }
        Vector vDirs = FileUtil.getSubDirs(sFileName_);
        Enumeration eDirs = vDirs.elements();
        while (eDirs.hasMoreElements()) {
            String sNextDir = (String)eDirs.nextElement();
            Vector vsNextDir = FileUtil.getRecursiveDir(FileUtil.concatPath(sFileName_, sNextDir));
            vsRetVal = Util.concat(vsRetVal, vsNextDir);
        }
        return vsRetVal;
    }

    public static boolean copyDir(String sDir_, String sDestination_) {
        boolean bRetVal = false;
        String sLastDirElement = FileUtil.getBaseName(sDir_);
        String sNewDir = FileUtil.concatPath(sDestination_, sLastDirElement);
        if (!FileUtil.existsDir(sNewDir) && (bRetVal = FileUtil.md(sNewDir))) {
            Util.printlnErr("ccl.util.FileUtil.copyDir(..).sNewDir: " + sNewDir);
            return bRetVal;
        }
        Vector vFiles = FileUtil.getFiles(sDir_);
        Enumeration eFiles = vFiles.elements();
        while (eFiles.hasMoreElements()) {
            String sNextFile = (String)eFiles.nextElement();
            bRetVal = FileUtil.copy(FileUtil.concatPath(sDir_, sNextFile), FileUtil.concatPath(sNewDir, sNextFile));
            if (!bRetVal) continue;
            Util.printlnErr("ccl.util.FileUtil.copyDir(..).sNextFile: " + sNextFile);
            return bRetVal;
        }
        Vector vDirs = FileUtil.getSubDirs(sDir_);
        Enumeration eDirs = vDirs.elements();
        while (eDirs.hasMoreElements()) {
            String sNextDir = (String)eDirs.nextElement();
            bRetVal = FileUtil.copyDir(FileUtil.concatPath(sDir_, sNextDir), sNewDir);
            if (!bRetVal) continue;
            Util.printlnErr("ccl.util.FileUtil.copyDir(..).sNextDir: " + FileUtil.concatPath(sDir_, sNextDir));
            return bRetVal;
        }
        return bRetVal;
    }

    public static boolean copy(String sSourceFile_, String sDestinationFile_) {
        boolean bError = false;
        String sDestDir = new File(sDestinationFile_).getParent();
        if (!Util.isEmpty(sDestDir) && !FileUtil.existsDir(sDestDir)) {
            FileUtil.md(sDestDir);
        }
        try {
            BufferedInputStream pBufferedInputStream = new BufferedInputStream(new FileInputStream(sSourceFile_));
            BufferedOutputStream pBufferedOutputStream = new BufferedOutputStream(new FileOutputStream(sDestinationFile_));
            bError = StreamCopier.copy(pBufferedInputStream, pBufferedOutputStream);
            pBufferedOutputStream.close();
            pBufferedInputStream.close();
        }
        catch (Exception pException) {
            bError = true;
        }
        return bError;
    }

    public static boolean copy(InputStream pInputStream_, OutputStream pOutputStream_) {
        boolean bError = false;
        try {
            BufferedInputStream pBufferedInputStream = new BufferedInputStream(pInputStream_);
            BufferedOutputStream pBufferedOutputStream = new BufferedOutputStream(pOutputStream_);
            bError = StreamCopier.copy(pBufferedInputStream, pBufferedOutputStream);
            pBufferedOutputStream.close();
            pBufferedInputStream.close();
        }
        catch (Exception pException) {
            Util.printlnErr("FileUtil.copy(..).pException: " + pException);
            return true;
        }
        return bError;
    }

    public static boolean copy(BufferedInputStream pBufferedInputStream_, BufferedOutputStream pBufferedOutputStream_) {
        boolean bError = false;
        try {
            bError = StreamCopier.copy(pBufferedInputStream_, pBufferedOutputStream_);
            pBufferedOutputStream_.close();
            pBufferedInputStream_.close();
        }
        catch (Exception pException) {
            Util.printlnErr("FileUtil.copy(..).pException: " + pException);
            return true;
        }
        return bError;
    }

    public static InputStream getResourceAsStream(Object pObject_, String sRecourceName_) {
        InputStream isResource = pObject_.getClass().getResourceAsStream(sRecourceName_);
        if (isResource == null) {
            String sPath = FileUtil.getClassPath(pObject_);
            Util.debug("ccl.util.FileUtil.getResourceAsStream(..).sPath: " + sPath);
            if (sPath.equals("classes")) {
                sPath = "src";
            } else if (Util.endsWith(sPath, File.separator + "classes")) {
                sPath = sPath.substring(0, sPath.length() - 7) + "src";
            } else if (sPath.startsWith("classes" + File.separator)) {
                sPath = "src" + sPath.substring(7);
            } else {
                int index = sPath.lastIndexOf(File.separator + "classes" + File.separator);
                if (index != -1) {
                    sPath = sPath.substring(0, index + 1) + "src" + sPath.substring(index + 8);
                }
            }
            try {
                isResource = new FileInputStream(FileUtil.concatPath(sPath, sRecourceName_));
            }
            catch (Exception pException) {
                isResource = null;
            }
        }
        return isResource;
    }

    public static String getResourceAsString(Object pObject_, String sRecourceName_) throws IOException {
        InputStream isResource = FileUtil.getResourceAsStream(pObject_, sRecourceName_);
        return FileUtil.readStream(isResource);
    }

    public static void printAndWaitUntilQuit() {
        Util.println("Type 'quit' <return> to exit!");
        while (true) {
            try {
                if (System.in.available() > 0) {
                    String sInput = "";
                    while (System.in.available() > 0) {
                        sInput = sInput + (char)System.in.read();
                    }
                    if (!sInput.equals("quit\r\n") && !sInput.equals("quit\n")) continue;
                    break;
                }
                Util.sleep(1);
            }
            catch (IOException pIOException) {
                Util.printlnErr("ccl.util.FileUtil.printAndWaitUntilQuit().pIOException: " + pIOException);
                return;
            }
        }
    }

    public static boolean isQuitInStdin() {
        try {
            if (System.in.available() > 0) {
                String sInput = "";
                while (System.in.available() > 0) {
                    sInput = sInput + (char)System.in.read();
                }
                if (sInput.equals("quit\r\n") || sInput.equals("quit\n")) {
                    return true;
                }
            }
        }
        catch (IOException pIOException) {
            Util.printlnErr("ccl.util.FileUtil.printAndWaitUntilQuit().pIOException: " + pIOException);
        }
        return false;
    }

    public static String getDir(String sFile_) {
        File pFile = new File(sFile_);
        return pFile.getPath();
    }

    public static boolean isFileReadable(String sFileName_) {
        try {
            File file = new File(sFileName_);
            if (!file.isFile() || !file.canRead()) {
                Util.debug("ccl.util.FileUtil.isFileReadable(..).NOT_A_FILE_OR_NOT_READABLE");
                return false;
            }
            FileInputStream inputStream = new FileInputStream(file);
            if (inputStream == null) {
                Util.debug("ccl.util.FileUtil.isFileReadable(..).inputStream: " + inputStream);
                return false;
            }
            FileDescriptor descriptor = inputStream.getFD();
            if (!descriptor.valid()) {
                Util.debug("ccl.util.FileUtil.isFileReadable(..).descriptor " + descriptor);
                return false;
            }
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkRead(descriptor);
            }
        }
        catch (Exception exception) {
            Util.debug("ccl.util.FileUtil.isFileReadable(..).exception: " + exception);
            return false;
        }
        return true;
    }

    public static String getBaseFileName(String sFileName_) {
        return new File(sFileName_).getName();
    }

    public static String getBaseName(String sFileName_) {
        return new File(sFileName_).getName();
    }

    public static String getDirName(String sFileName) {
        String sRetVal = new File(sFileName).getParent();
        if (sRetVal == null) {
            sRetVal = ".";
        }
        return sRetVal;
    }

    public static String getApplicationHome(Object oClass) {
        return ClassPathUtil.getApplicationHome(oClass);
    }
}

