/*
 * Decompiled with CFR 0.152.
 */
package org.outerj.daisy.diff.html;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.outerj.daisy.diff.html.ancestor.AncestorComparator;
import org.outerj.daisy.diff.html.ancestor.AncestorComparatorResult;
import org.outerj.daisy.diff.html.dom.BodyNode;
import org.outerj.daisy.diff.html.dom.DomTree;
import org.outerj.daisy.diff.html.dom.Node;
import org.outerj.daisy.diff.html.dom.TextNode;
import org.outerj.daisy.diff.html.dom.helper.LastCommonParentResult;
import org.outerj.daisy.diff.html.modification.Modification;
import org.outerj.daisy.diff.html.modification.ModificationType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextNodeComparator
implements IRangeComparator,
Iterable<TextNode> {
    private List<TextNode> textNodes = new ArrayList<TextNode>(50);
    private List<Modification> lastModified = new ArrayList<Modification>();
    private BodyNode bodyNode;
    private Locale locale;
    private long newID = 0L;
    private long changedID = 0L;
    private boolean changedIDUsed = false;
    private boolean whiteAfterLastChangedPart = false;
    private long deletedID = 0L;

    public TextNodeComparator(DomTree domTree, Locale locale) {
        this.locale = locale;
        this.textNodes = domTree.getTextNodes();
        this.bodyNode = domTree.getBodyNode();
    }

    public BodyNode getBodyNode() {
        return this.bodyNode;
    }

    @Override
    public int getRangeCount() {
        return this.textNodes.size();
    }

    public TextNode getTextNode(int n) {
        return this.textNodes.get(n);
    }

    public void markAsNew(int n, int n2) {
        if (n2 <= n) {
            return;
        }
        if (this.whiteAfterLastChangedPart) {
            this.getTextNode(n).setWhiteBefore(false);
        }
        ArrayList<Modification> arrayList = new ArrayList<Modification>();
        for (int i = n; i < n2; ++i) {
            Modification modification = new Modification(ModificationType.ADDED);
            modification.setID(this.newID);
            if (this.lastModified.size() > 0) {
                modification.setPrevious(this.lastModified.get(0));
                if (this.lastModified.get(0).getNext() == null) {
                    for (Modification modification2 : this.lastModified) {
                        modification2.setNext(modification);
                    }
                }
            }
            arrayList.add(modification);
            this.getTextNode(i).setModification(modification);
        }
        this.getTextNode(n).getModification().setFirstOfID(true);
        ++this.newID;
        this.lastModified = arrayList;
    }

    @Override
    public boolean rangesEqual(int n, IRangeComparator iRangeComparator, int n2) {
        TextNodeComparator textNodeComparator;
        try {
            textNodeComparator = (TextNodeComparator)iRangeComparator;
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
        return this.getTextNode(n).isSameText(textNodeComparator.getTextNode(n2));
    }

    @Override
    public boolean skipRangeComparison(int n, int n2, IRangeComparator iRangeComparator) {
        return false;
    }

    public void handlePossibleChangedPart(int n, int n2, int n3, int n4, TextNodeComparator textNodeComparator) {
        int n5 = n3;
        int n6 = n;
        if (this.changedIDUsed) {
            ++this.changedID;
            this.changedIDUsed = false;
        }
        ArrayList<Modification> arrayList = new ArrayList<Modification>();
        String string = null;
        while (n5 < n4) {
            AncestorComparator ancestorComparator;
            AncestorComparator ancestorComparator2 = new AncestorComparator(this.getTextNode(n5).getParentTree());
            AncestorComparatorResult ancestorComparatorResult = ancestorComparator2.getResult(ancestorComparator = new AncestorComparator(textNodeComparator.getTextNode(n6).getParentTree()), this.locale);
            if (ancestorComparatorResult.isChanged()) {
                Modification modification = new Modification(ModificationType.CHANGED);
                if (!this.changedIDUsed) {
                    modification.setFirstOfID(true);
                    if (arrayList.size() > 0) {
                        this.lastModified = arrayList;
                        arrayList = new ArrayList();
                    }
                } else if (ancestorComparatorResult.getChanges() != null && !ancestorComparatorResult.getChanges().equals(string)) {
                    ++this.changedID;
                    modification.setFirstOfID(true);
                    if (arrayList.size() > 0) {
                        this.lastModified = arrayList;
                        arrayList = new ArrayList();
                    }
                }
                if (this.lastModified.size() > 0) {
                    modification.setPrevious(this.lastModified.get(0));
                    if (this.lastModified.get(0).getNext() == null) {
                        for (Modification modification2 : this.lastModified) {
                            modification2.setNext(modification);
                        }
                    }
                }
                arrayList.add(modification);
                modification.setChanges(ancestorComparatorResult.getChanges());
                modification.setHtmlLayoutChanges(ancestorComparatorResult.getHtmlLayoutChanges());
                modification.setID(this.changedID);
                this.getTextNode(n5).setModification(modification);
                string = ancestorComparatorResult.getChanges();
                this.changedIDUsed = true;
            } else if (this.changedIDUsed) {
                ++this.changedID;
                this.changedIDUsed = false;
            }
            ++n5;
            ++n6;
        }
        if (arrayList.size() > 0) {
            this.lastModified = arrayList;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void markAsDeleted(int n, int n2, TextNodeComparator textNodeComparator, int n3) {
        Object object;
        if (n2 <= n) {
            return;
        }
        this.whiteAfterLastChangedPart = n3 > 0 && this.getTextNode(n3 - 1).isWhiteAfter();
        ArrayList<Modification> arrayList = new ArrayList<Modification>();
        for (int i = n; i < n2; ++i) {
            object = new Modification(ModificationType.REMOVED);
            ((Modification)object).setID(this.deletedID);
            if (this.lastModified.size() > 0) {
                ((Modification)object).setPrevious(this.lastModified.get(0));
                if (this.lastModified.get(0).getNext() == null) {
                    for (Modification object2 : this.lastModified) {
                        object2.setNext((Modification)object);
                    }
                }
            }
            arrayList.add((Modification)object);
            textNodeComparator.getTextNode(i).setModification((Modification)object);
        }
        textNodeComparator.getTextNode(n).getModification().setFirstOfID(true);
        List<Node> list = textNodeComparator.getBodyNode().getMinimalDeletedSet(this.deletedID);
        object = null;
        if (n3 > 0) {
            object = this.getTextNode(n3 - 1);
        }
        Object object3 = null;
        if (n3 < this.getRangeCount()) {
            object3 = this.getTextNode(n3);
        }
        while (list.size() > 0) {
            void var9_14;
            LastCommonParentResult lastCommonParentResult;
            if (object != null) {
                LastCommonParentResult lastCommonParentResult2 = ((Node)object).getLastCommonParent(list.get(0));
            } else {
                LastCommonParentResult lastCommonParentResult3 = new LastCommonParentResult();
                lastCommonParentResult3.setLastCommonParent(this.getBodyNode());
                lastCommonParentResult3.setIndexInLastCommonParent(-1);
            }
            if (object3 != null) {
                lastCommonParentResult = ((Node)object3).getLastCommonParent(list.get(list.size() - 1));
            } else {
                lastCommonParentResult = new LastCommonParentResult();
                lastCommonParentResult.setLastCommonParent(this.getBodyNode());
                lastCommonParentResult.setIndexInLastCommonParent(this.getBodyNode().getNbChildren());
            }
            if (var9_14.getLastCommonParentDepth() == lastCommonParentResult.getLastCommonParentDepth()) {
                if (list.get(0).getParent() == list.get(list.size() - 1).getParent() && var9_14.getLastCommonParent() == lastCommonParentResult.getLastCommonParent()) {
                    var9_14.setLastCommonParentDepth(var9_14.getLastCommonParentDepth() + 1);
                } else {
                    double d;
                    double d2 = list.get(0).getParent().getMatchRatio(var9_14.getLastCommonParent());
                    if (d2 <= (d = list.get(list.size() - 1).getParent().getMatchRatio(lastCommonParentResult.getLastCommonParent()))) {
                        var9_14.setLastCommonParentDepth(var9_14.getLastCommonParentDepth() + 1);
                    } else {
                        lastCommonParentResult.setLastCommonParentDepth(lastCommonParentResult.getLastCommonParentDepth() + 1);
                    }
                }
            }
            if (var9_14.getLastCommonParentDepth() > lastCommonParentResult.getLastCommonParentDepth()) {
                if (var9_14.isSplittingNeeded()) {
                    ((Node)object).getParent().splitUntill(var9_14.getLastCommonParent(), (Node)object, true);
                }
                object = list.remove(0).copyTree();
                ((Node)object).setParent(var9_14.getLastCommonParent());
                var9_14.getLastCommonParent().addChild(var9_14.getIndexInLastCommonParent() + 1, (Node)object);
                continue;
            }
            if (var9_14.getLastCommonParentDepth() < lastCommonParentResult.getLastCommonParentDepth()) {
                boolean bl;
                if (lastCommonParentResult.isSplittingNeeded() && (bl = ((Node)object3).getParent().splitUntill(lastCommonParentResult.getLastCommonParent(), (Node)object3, false))) {
                    lastCommonParentResult.setIndexInLastCommonParent(lastCommonParentResult.getIndexInLastCommonParent() + 1);
                }
                object3 = list.remove(list.size() - 1).copyTree();
                ((Node)object3).setParent(lastCommonParentResult.getLastCommonParent());
                lastCommonParentResult.getLastCommonParent().addChild(lastCommonParentResult.getIndexInLastCommonParent(), (Node)object3);
                continue;
            }
            throw new IllegalStateException();
        }
        this.lastModified = arrayList;
        ++this.deletedID;
    }

    public void expandWhiteSpace() {
        this.getBodyNode().expandWhiteSpace();
    }

    @Override
    public Iterator<TextNode> iterator() {
        return this.textNodes.iterator();
    }
}

