/*
 * Decompiled with CFR 0.152.
 */
package org.outerj.daisy.diff.html.dom;

import java.util.ArrayList;
import java.util.List;
import org.outerj.daisy.diff.html.dom.Node;
import org.outerj.daisy.diff.html.dom.TagNode;
import org.outerj.daisy.diff.html.modification.Modification;
import org.outerj.daisy.diff.html.modification.ModificationType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextNode
extends Node
implements Cloneable {
    private String s;
    private Modification modification = new Modification(ModificationType.NONE);

    public TextNode(TagNode tagNode, String string) {
        super(tagNode);
        this.s = string;
    }

    @Override
    public Node copyTree() {
        try {
            Node node = (Node)this.clone();
            node.setParent(null);
            return node;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    public Node getLeftMostChild() {
        return this;
    }

    @Override
    public List<Node> getMinimalDeletedSet(long l) {
        ArrayList<Node> arrayList = new ArrayList<Node>(1);
        if (this.getModification().getType() == ModificationType.REMOVED && this.getModification().getID() == l) {
            arrayList.add(this);
        }
        return arrayList;
    }

    public Modification getModification() {
        return this.modification;
    }

    @Override
    public Node getRightMostChild() {
        return this;
    }

    public String getText() {
        return this.s;
    }

    public boolean isSameText(Object object) {
        TextNode textNode;
        if (object == null) {
            return false;
        }
        try {
            textNode = (TextNode)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return this.getText().replace('\n', ' ').equals(textNode.getText().replace('\n', ' '));
    }

    public void setModification(Modification modification) {
        this.modification = modification;
    }

    public String toString() {
        return this.getText();
    }
}

