var frontend = (function () {
'use strict';

var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

function getDefaultExportFromCjs (x) {
	return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
}

function getAugmentedNamespace(n) {
  if (n.__esModule) return n;
  var f = n.default;
	if (typeof f == "function") {
		var a = function a () {
			if (this instanceof a) {
				var args = [null];
				args.push.apply(args, arguments);
				var Ctor = Function.bind.apply(f, args);
				return new Ctor();
			}
			return f.apply(this, arguments);
		};
		a.prototype = f.prototype;
  } else a = {};
  Object.defineProperty(a, '__esModule', {value: true});
	Object.keys(n).forEach(function (k) {
		var d = Object.getOwnPropertyDescriptor(n, k);
		Object.defineProperty(a, k, d.get ? d : {
			enumerable: true,
			get: function () {
				return n[k];
			}
		});
	});
	return a;
}

var frontend = {};

/******************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */
/* global Reflect, Promise */

var extendStatics = function(d, b) {
    extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
    return extendStatics(d, b);
};

function __extends(d, b) {
    if (typeof b !== "function" && b !== null)
        throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
    extendStatics(d, b);
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}

var __assign = function() {
    __assign = Object.assign || function __assign(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};

function __rest(s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
}

function __decorate(decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
}

function __param(paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
}

function __esDecorate(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.push(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.push(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
}
function __runInitializers(thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
}
function __propKey(x) {
    return typeof x === "symbol" ? x : "".concat(x);
}
function __setFunctionName(f, name, prefix) {
    if (typeof name === "symbol") name = name.description ? "[".concat(name.description, "]") : "";
    return Object.defineProperty(f, "name", { configurable: true, value: prefix ? "".concat(prefix, " ", name) : name });
}
function __metadata(metadataKey, metadataValue) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(metadataKey, metadataValue);
}

function __awaiter(thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
}

function __generator(thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
}

var __createBinding = Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
});

function __exportStar(m, o) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(o, p)) __createBinding(o, m, p);
}

function __values(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
}

function __read(o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
}

/** @deprecated */
function __spread() {
    for (var ar = [], i = 0; i < arguments.length; i++)
        ar = ar.concat(__read(arguments[i]));
    return ar;
}

/** @deprecated */
function __spreadArrays() {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
}

function __spreadArray(to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
}

function __await(v) {
    return this instanceof __await ? (this.v = v, this) : new __await(v);
}

function __asyncGenerator(thisArg, _arguments, generator) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var g = generator.apply(thisArg, _arguments || []), i, q = [];
    return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i;
    function verb(n) { if (g[n]) i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; }
    function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
    function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
    function fulfill(value) { resume("next", value); }
    function reject(value) { resume("throw", value); }
    function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
}

function __asyncDelegator(o) {
    var i, p;
    return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
    function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: false } : f ? f(v) : v; } : f; }
}

function __asyncValues(o) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var m = o[Symbol.asyncIterator], i;
    return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
}

function __makeTemplateObject(cooked, raw) {
    if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
    return cooked;
}
var __setModuleDefault = Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
};

function __importStar(mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
}

function __importDefault(mod) {
    return (mod && mod.__esModule) ? mod : { default: mod };
}

function __classPrivateFieldGet(receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
}

function __classPrivateFieldSet(receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
}

function __classPrivateFieldIn(state, receiver) {
    if (receiver === null || (typeof receiver !== "object" && typeof receiver !== "function")) throw new TypeError("Cannot use 'in' operator on non-object");
    return typeof state === "function" ? receiver === state : state.has(receiver);
}

var tslib_es6 = /*#__PURE__*/Object.freeze({
__proto__: null,
__extends: __extends,
get __assign () { return __assign; },
__rest: __rest,
__decorate: __decorate,
__param: __param,
__esDecorate: __esDecorate,
__runInitializers: __runInitializers,
__propKey: __propKey,
__setFunctionName: __setFunctionName,
__metadata: __metadata,
__awaiter: __awaiter,
__generator: __generator,
__createBinding: __createBinding,
__exportStar: __exportStar,
__values: __values,
__read: __read,
__spread: __spread,
__spreadArrays: __spreadArrays,
__spreadArray: __spreadArray,
__await: __await,
__asyncGenerator: __asyncGenerator,
__asyncDelegator: __asyncDelegator,
__asyncValues: __asyncValues,
__makeTemplateObject: __makeTemplateObject,
__importStar: __importStar,
__importDefault: __importDefault,
__classPrivateFieldGet: __classPrivateFieldGet,
__classPrivateFieldSet: __classPrivateFieldSet,
__classPrivateFieldIn: __classPrivateFieldIn
});

var require$$0$1 = /*@__PURE__*/getAugmentedNamespace(tslib_es6);

var query_result = {};

var minimalExports = {};
var minimal$1 = {
  get exports(){ return minimalExports; },
  set exports(v){ minimalExports = v; },
};

var indexMinimal = {};

var minimal = {};

var aspromise;
var hasRequiredAspromise;

function requireAspromise () {
	if (hasRequiredAspromise) return aspromise;
	hasRequiredAspromise = 1;
	aspromise = asPromise;

	/**
	 * Callback as used by {@link util.asPromise}.
	 * @typedef asPromiseCallback
	 * @type {function}
	 * @param {Error|null} error Error, if any
	 * @param {...*} params Additional arguments
	 * @returns {undefined}
	 */

	/**
	 * Returns a promise from a node-style callback function.
	 * @memberof util
	 * @param {asPromiseCallback} fn Function to call
	 * @param {*} ctx Function context
	 * @param {...*} params Function arguments
	 * @returns {Promise<*>} Promisified function
	 */
	function asPromise(fn, ctx/*, varargs */) {
	    var params  = new Array(arguments.length - 1),
	        offset  = 0,
	        index   = 2,
	        pending = true;
	    while (index < arguments.length)
	        params[offset++] = arguments[index++];
	    return new Promise(function executor(resolve, reject) {
	        params[offset] = function callback(err/*, varargs */) {
	            if (pending) {
	                pending = false;
	                if (err)
	                    reject(err);
	                else {
	                    var params = new Array(arguments.length - 1),
	                        offset = 0;
	                    while (offset < params.length)
	                        params[offset++] = arguments[offset];
	                    resolve.apply(null, params);
	                }
	            }
	        };
	        try {
	            fn.apply(ctx || null, params);
	        } catch (err) {
	            if (pending) {
	                pending = false;
	                reject(err);
	            }
	        }
	    });
	}
	return aspromise;
}

var base64 = {};

var hasRequiredBase64;

function requireBase64 () {
	if (hasRequiredBase64) return base64;
	hasRequiredBase64 = 1;
	(function (exports) {

		/**
		 * A minimal base64 implementation for number arrays.
		 * @memberof util
		 * @namespace
		 */
		var base64 = exports;

		/**
		 * Calculates the byte length of a base64 encoded string.
		 * @param {string} string Base64 encoded string
		 * @returns {number} Byte length
		 */
		base64.length = function length(string) {
		    var p = string.length;
		    if (!p)
		        return 0;
		    var n = 0;
		    while (--p % 4 > 1 && string.charAt(p) === "=")
		        ++n;
		    return Math.ceil(string.length * 3) / 4 - n;
		};

		// Base64 encoding table
		var b64 = new Array(64);

		// Base64 decoding table
		var s64 = new Array(123);

		// 65..90, 97..122, 48..57, 43, 47
		for (var i = 0; i < 64;)
		    s64[b64[i] = i < 26 ? i + 65 : i < 52 ? i + 71 : i < 62 ? i - 4 : i - 59 | 43] = i++;

		/**
		 * Encodes a buffer to a base64 encoded string.
		 * @param {Uint8Array} buffer Source buffer
		 * @param {number} start Source start
		 * @param {number} end Source end
		 * @returns {string} Base64 encoded string
		 */
		base64.encode = function encode(buffer, start, end) {
		    var parts = null,
		        chunk = [];
		    var i = 0, // output index
		        j = 0, // goto index
		        t;     // temporary
		    while (start < end) {
		        var b = buffer[start++];
		        switch (j) {
		            case 0:
		                chunk[i++] = b64[b >> 2];
		                t = (b & 3) << 4;
		                j = 1;
		                break;
		            case 1:
		                chunk[i++] = b64[t | b >> 4];
		                t = (b & 15) << 2;
		                j = 2;
		                break;
		            case 2:
		                chunk[i++] = b64[t | b >> 6];
		                chunk[i++] = b64[b & 63];
		                j = 0;
		                break;
		        }
		        if (i > 8191) {
		            (parts || (parts = [])).push(String.fromCharCode.apply(String, chunk));
		            i = 0;
		        }
		    }
		    if (j) {
		        chunk[i++] = b64[t];
		        chunk[i++] = 61;
		        if (j === 1)
		            chunk[i++] = 61;
		    }
		    if (parts) {
		        if (i)
		            parts.push(String.fromCharCode.apply(String, chunk.slice(0, i)));
		        return parts.join("");
		    }
		    return String.fromCharCode.apply(String, chunk.slice(0, i));
		};

		var invalidEncoding = "invalid encoding";

		/**
		 * Decodes a base64 encoded string to a buffer.
		 * @param {string} string Source string
		 * @param {Uint8Array} buffer Destination buffer
		 * @param {number} offset Destination offset
		 * @returns {number} Number of bytes written
		 * @throws {Error} If encoding is invalid
		 */
		base64.decode = function decode(string, buffer, offset) {
		    var start = offset;
		    var j = 0, // goto index
		        t;     // temporary
		    for (var i = 0; i < string.length;) {
		        var c = string.charCodeAt(i++);
		        if (c === 61 && j > 1)
		            break;
		        if ((c = s64[c]) === undefined)
		            throw Error(invalidEncoding);
		        switch (j) {
		            case 0:
		                t = c;
		                j = 1;
		                break;
		            case 1:
		                buffer[offset++] = t << 2 | (c & 48) >> 4;
		                t = c;
		                j = 2;
		                break;
		            case 2:
		                buffer[offset++] = (t & 15) << 4 | (c & 60) >> 2;
		                t = c;
		                j = 3;
		                break;
		            case 3:
		                buffer[offset++] = (t & 3) << 6 | c;
		                j = 0;
		                break;
		        }
		    }
		    if (j === 1)
		        throw Error(invalidEncoding);
		    return offset - start;
		};

		/**
		 * Tests if the specified string appears to be base64 encoded.
		 * @param {string} string String to test
		 * @returns {boolean} `true` if probably base64 encoded, otherwise false
		 */
		base64.test = function test(string) {
		    return /^(?:[A-Za-z0-9+/]{4})*(?:[A-Za-z0-9+/]{2}==|[A-Za-z0-9+/]{3}=)?$/.test(string);
		};
} (base64));
	return base64;
}

var eventemitter;
var hasRequiredEventemitter;

function requireEventemitter () {
	if (hasRequiredEventemitter) return eventemitter;
	hasRequiredEventemitter = 1;
	eventemitter = EventEmitter;

	/**
	 * Constructs a new event emitter instance.
	 * @classdesc A minimal event emitter.
	 * @memberof util
	 * @constructor
	 */
	function EventEmitter() {

	    /**
	     * Registered listeners.
	     * @type {Object.<string,*>}
	     * @private
	     */
	    this._listeners = {};
	}

	/**
	 * Registers an event listener.
	 * @param {string} evt Event name
	 * @param {function} fn Listener
	 * @param {*} [ctx] Listener context
	 * @returns {util.EventEmitter} `this`
	 */
	EventEmitter.prototype.on = function on(evt, fn, ctx) {
	    (this._listeners[evt] || (this._listeners[evt] = [])).push({
	        fn  : fn,
	        ctx : ctx || this
	    });
	    return this;
	};

	/**
	 * Removes an event listener or any matching listeners if arguments are omitted.
	 * @param {string} [evt] Event name. Removes all listeners if omitted.
	 * @param {function} [fn] Listener to remove. Removes all listeners of `evt` if omitted.
	 * @returns {util.EventEmitter} `this`
	 */
	EventEmitter.prototype.off = function off(evt, fn) {
	    if (evt === undefined)
	        this._listeners = {};
	    else {
	        if (fn === undefined)
	            this._listeners[evt] = [];
	        else {
	            var listeners = this._listeners[evt];
	            for (var i = 0; i < listeners.length;)
	                if (listeners[i].fn === fn)
	                    listeners.splice(i, 1);
	                else
	                    ++i;
	        }
	    }
	    return this;
	};

	/**
	 * Emits an event by calling its listeners with the specified arguments.
	 * @param {string} evt Event name
	 * @param {...*} args Arguments
	 * @returns {util.EventEmitter} `this`
	 */
	EventEmitter.prototype.emit = function emit(evt) {
	    var listeners = this._listeners[evt];
	    if (listeners) {
	        var args = [],
	            i = 1;
	        for (; i < arguments.length;)
	            args.push(arguments[i++]);
	        for (i = 0; i < listeners.length;)
	            listeners[i].fn.apply(listeners[i++].ctx, args);
	    }
	    return this;
	};
	return eventemitter;
}

var float;
var hasRequiredFloat;

function requireFloat () {
	if (hasRequiredFloat) return float;
	hasRequiredFloat = 1;

	float = factory(factory);

	/**
	 * Reads / writes floats / doubles from / to buffers.
	 * @name util.float
	 * @namespace
	 */

	/**
	 * Writes a 32 bit float to a buffer using little endian byte order.
	 * @name util.float.writeFloatLE
	 * @function
	 * @param {number} val Value to write
	 * @param {Uint8Array} buf Target buffer
	 * @param {number} pos Target buffer offset
	 * @returns {undefined}
	 */

	/**
	 * Writes a 32 bit float to a buffer using big endian byte order.
	 * @name util.float.writeFloatBE
	 * @function
	 * @param {number} val Value to write
	 * @param {Uint8Array} buf Target buffer
	 * @param {number} pos Target buffer offset
	 * @returns {undefined}
	 */

	/**
	 * Reads a 32 bit float from a buffer using little endian byte order.
	 * @name util.float.readFloatLE
	 * @function
	 * @param {Uint8Array} buf Source buffer
	 * @param {number} pos Source buffer offset
	 * @returns {number} Value read
	 */

	/**
	 * Reads a 32 bit float from a buffer using big endian byte order.
	 * @name util.float.readFloatBE
	 * @function
	 * @param {Uint8Array} buf Source buffer
	 * @param {number} pos Source buffer offset
	 * @returns {number} Value read
	 */

	/**
	 * Writes a 64 bit double to a buffer using little endian byte order.
	 * @name util.float.writeDoubleLE
	 * @function
	 * @param {number} val Value to write
	 * @param {Uint8Array} buf Target buffer
	 * @param {number} pos Target buffer offset
	 * @returns {undefined}
	 */

	/**
	 * Writes a 64 bit double to a buffer using big endian byte order.
	 * @name util.float.writeDoubleBE
	 * @function
	 * @param {number} val Value to write
	 * @param {Uint8Array} buf Target buffer
	 * @param {number} pos Target buffer offset
	 * @returns {undefined}
	 */

	/**
	 * Reads a 64 bit double from a buffer using little endian byte order.
	 * @name util.float.readDoubleLE
	 * @function
	 * @param {Uint8Array} buf Source buffer
	 * @param {number} pos Source buffer offset
	 * @returns {number} Value read
	 */

	/**
	 * Reads a 64 bit double from a buffer using big endian byte order.
	 * @name util.float.readDoubleBE
	 * @function
	 * @param {Uint8Array} buf Source buffer
	 * @param {number} pos Source buffer offset
	 * @returns {number} Value read
	 */

	// Factory function for the purpose of node-based testing in modified global environments
	function factory(exports) {

	    // float: typed array
	    if (typeof Float32Array !== "undefined") (function() {

	        var f32 = new Float32Array([ -0 ]),
	            f8b = new Uint8Array(f32.buffer),
	            le  = f8b[3] === 128;

	        function writeFloat_f32_cpy(val, buf, pos) {
	            f32[0] = val;
	            buf[pos    ] = f8b[0];
	            buf[pos + 1] = f8b[1];
	            buf[pos + 2] = f8b[2];
	            buf[pos + 3] = f8b[3];
	        }

	        function writeFloat_f32_rev(val, buf, pos) {
	            f32[0] = val;
	            buf[pos    ] = f8b[3];
	            buf[pos + 1] = f8b[2];
	            buf[pos + 2] = f8b[1];
	            buf[pos + 3] = f8b[0];
	        }

	        /* istanbul ignore next */
	        exports.writeFloatLE = le ? writeFloat_f32_cpy : writeFloat_f32_rev;
	        /* istanbul ignore next */
	        exports.writeFloatBE = le ? writeFloat_f32_rev : writeFloat_f32_cpy;

	        function readFloat_f32_cpy(buf, pos) {
	            f8b[0] = buf[pos    ];
	            f8b[1] = buf[pos + 1];
	            f8b[2] = buf[pos + 2];
	            f8b[3] = buf[pos + 3];
	            return f32[0];
	        }

	        function readFloat_f32_rev(buf, pos) {
	            f8b[3] = buf[pos    ];
	            f8b[2] = buf[pos + 1];
	            f8b[1] = buf[pos + 2];
	            f8b[0] = buf[pos + 3];
	            return f32[0];
	        }

	        /* istanbul ignore next */
	        exports.readFloatLE = le ? readFloat_f32_cpy : readFloat_f32_rev;
	        /* istanbul ignore next */
	        exports.readFloatBE = le ? readFloat_f32_rev : readFloat_f32_cpy;

	    // float: ieee754
	    })(); else (function() {

	        function writeFloat_ieee754(writeUint, val, buf, pos) {
	            var sign = val < 0 ? 1 : 0;
	            if (sign)
	                val = -val;
	            if (val === 0)
	                writeUint(1 / val > 0 ? /* positive */ 0 : /* negative 0 */ 2147483648, buf, pos);
	            else if (isNaN(val))
	                writeUint(2143289344, buf, pos);
	            else if (val > 3.4028234663852886e+38) // +-Infinity
	                writeUint((sign << 31 | 2139095040) >>> 0, buf, pos);
	            else if (val < 1.1754943508222875e-38) // denormal
	                writeUint((sign << 31 | Math.round(val / 1.401298464324817e-45)) >>> 0, buf, pos);
	            else {
	                var exponent = Math.floor(Math.log(val) / Math.LN2),
	                    mantissa = Math.round(val * Math.pow(2, -exponent) * 8388608) & 8388607;
	                writeUint((sign << 31 | exponent + 127 << 23 | mantissa) >>> 0, buf, pos);
	            }
	        }

	        exports.writeFloatLE = writeFloat_ieee754.bind(null, writeUintLE);
	        exports.writeFloatBE = writeFloat_ieee754.bind(null, writeUintBE);

	        function readFloat_ieee754(readUint, buf, pos) {
	            var uint = readUint(buf, pos),
	                sign = (uint >> 31) * 2 + 1,
	                exponent = uint >>> 23 & 255,
	                mantissa = uint & 8388607;
	            return exponent === 255
	                ? mantissa
	                ? NaN
	                : sign * Infinity
	                : exponent === 0 // denormal
	                ? sign * 1.401298464324817e-45 * mantissa
	                : sign * Math.pow(2, exponent - 150) * (mantissa + 8388608);
	        }

	        exports.readFloatLE = readFloat_ieee754.bind(null, readUintLE);
	        exports.readFloatBE = readFloat_ieee754.bind(null, readUintBE);

	    })();

	    // double: typed array
	    if (typeof Float64Array !== "undefined") (function() {

	        var f64 = new Float64Array([-0]),
	            f8b = new Uint8Array(f64.buffer),
	            le  = f8b[7] === 128;

	        function writeDouble_f64_cpy(val, buf, pos) {
	            f64[0] = val;
	            buf[pos    ] = f8b[0];
	            buf[pos + 1] = f8b[1];
	            buf[pos + 2] = f8b[2];
	            buf[pos + 3] = f8b[3];
	            buf[pos + 4] = f8b[4];
	            buf[pos + 5] = f8b[5];
	            buf[pos + 6] = f8b[6];
	            buf[pos + 7] = f8b[7];
	        }

	        function writeDouble_f64_rev(val, buf, pos) {
	            f64[0] = val;
	            buf[pos    ] = f8b[7];
	            buf[pos + 1] = f8b[6];
	            buf[pos + 2] = f8b[5];
	            buf[pos + 3] = f8b[4];
	            buf[pos + 4] = f8b[3];
	            buf[pos + 5] = f8b[2];
	            buf[pos + 6] = f8b[1];
	            buf[pos + 7] = f8b[0];
	        }

	        /* istanbul ignore next */
	        exports.writeDoubleLE = le ? writeDouble_f64_cpy : writeDouble_f64_rev;
	        /* istanbul ignore next */
	        exports.writeDoubleBE = le ? writeDouble_f64_rev : writeDouble_f64_cpy;

	        function readDouble_f64_cpy(buf, pos) {
	            f8b[0] = buf[pos    ];
	            f8b[1] = buf[pos + 1];
	            f8b[2] = buf[pos + 2];
	            f8b[3] = buf[pos + 3];
	            f8b[4] = buf[pos + 4];
	            f8b[5] = buf[pos + 5];
	            f8b[6] = buf[pos + 6];
	            f8b[7] = buf[pos + 7];
	            return f64[0];
	        }

	        function readDouble_f64_rev(buf, pos) {
	            f8b[7] = buf[pos    ];
	            f8b[6] = buf[pos + 1];
	            f8b[5] = buf[pos + 2];
	            f8b[4] = buf[pos + 3];
	            f8b[3] = buf[pos + 4];
	            f8b[2] = buf[pos + 5];
	            f8b[1] = buf[pos + 6];
	            f8b[0] = buf[pos + 7];
	            return f64[0];
	        }

	        /* istanbul ignore next */
	        exports.readDoubleLE = le ? readDouble_f64_cpy : readDouble_f64_rev;
	        /* istanbul ignore next */
	        exports.readDoubleBE = le ? readDouble_f64_rev : readDouble_f64_cpy;

	    // double: ieee754
	    })(); else (function() {

	        function writeDouble_ieee754(writeUint, off0, off1, val, buf, pos) {
	            var sign = val < 0 ? 1 : 0;
	            if (sign)
	                val = -val;
	            if (val === 0) {
	                writeUint(0, buf, pos + off0);
	                writeUint(1 / val > 0 ? /* positive */ 0 : /* negative 0 */ 2147483648, buf, pos + off1);
	            } else if (isNaN(val)) {
	                writeUint(0, buf, pos + off0);
	                writeUint(2146959360, buf, pos + off1);
	            } else if (val > 1.7976931348623157e+308) { // +-Infinity
	                writeUint(0, buf, pos + off0);
	                writeUint((sign << 31 | 2146435072) >>> 0, buf, pos + off1);
	            } else {
	                var mantissa;
	                if (val < 2.2250738585072014e-308) { // denormal
	                    mantissa = val / 5e-324;
	                    writeUint(mantissa >>> 0, buf, pos + off0);
	                    writeUint((sign << 31 | mantissa / 4294967296) >>> 0, buf, pos + off1);
	                } else {
	                    var exponent = Math.floor(Math.log(val) / Math.LN2);
	                    if (exponent === 1024)
	                        exponent = 1023;
	                    mantissa = val * Math.pow(2, -exponent);
	                    writeUint(mantissa * 4503599627370496 >>> 0, buf, pos + off0);
	                    writeUint((sign << 31 | exponent + 1023 << 20 | mantissa * 1048576 & 1048575) >>> 0, buf, pos + off1);
	                }
	            }
	        }

	        exports.writeDoubleLE = writeDouble_ieee754.bind(null, writeUintLE, 0, 4);
	        exports.writeDoubleBE = writeDouble_ieee754.bind(null, writeUintBE, 4, 0);

	        function readDouble_ieee754(readUint, off0, off1, buf, pos) {
	            var lo = readUint(buf, pos + off0),
	                hi = readUint(buf, pos + off1);
	            var sign = (hi >> 31) * 2 + 1,
	                exponent = hi >>> 20 & 2047,
	                mantissa = 4294967296 * (hi & 1048575) + lo;
	            return exponent === 2047
	                ? mantissa
	                ? NaN
	                : sign * Infinity
	                : exponent === 0 // denormal
	                ? sign * 5e-324 * mantissa
	                : sign * Math.pow(2, exponent - 1075) * (mantissa + 4503599627370496);
	        }

	        exports.readDoubleLE = readDouble_ieee754.bind(null, readUintLE, 0, 4);
	        exports.readDoubleBE = readDouble_ieee754.bind(null, readUintBE, 4, 0);

	    })();

	    return exports;
	}

	// uint helpers

	function writeUintLE(val, buf, pos) {
	    buf[pos    ] =  val        & 255;
	    buf[pos + 1] =  val >>> 8  & 255;
	    buf[pos + 2] =  val >>> 16 & 255;
	    buf[pos + 3] =  val >>> 24;
	}

	function writeUintBE(val, buf, pos) {
	    buf[pos    ] =  val >>> 24;
	    buf[pos + 1] =  val >>> 16 & 255;
	    buf[pos + 2] =  val >>> 8  & 255;
	    buf[pos + 3] =  val        & 255;
	}

	function readUintLE(buf, pos) {
	    return (buf[pos    ]
	          | buf[pos + 1] << 8
	          | buf[pos + 2] << 16
	          | buf[pos + 3] << 24) >>> 0;
	}

	function readUintBE(buf, pos) {
	    return (buf[pos    ] << 24
	          | buf[pos + 1] << 16
	          | buf[pos + 2] << 8
	          | buf[pos + 3]) >>> 0;
	}
	return float;
}

var inquire_1;
var hasRequiredInquire;

function requireInquire () {
	if (hasRequiredInquire) return inquire_1;
	hasRequiredInquire = 1;
	inquire_1 = inquire;

	/**
	 * Requires a module only if available.
	 * @memberof util
	 * @param {string} moduleName Module to require
	 * @returns {?Object} Required module if available and not empty, otherwise `null`
	 */
	function inquire(moduleName) {
	    try {
	        var mod = undefined; // eslint-disable-line no-eval
	        if (mod && (mod.length || Object.keys(mod).length))
	            return mod;
	    } catch (e) {} // eslint-disable-line no-empty
	    return null;
	}
	return inquire_1;
}

var utf8 = {};

var hasRequiredUtf8;

function requireUtf8 () {
	if (hasRequiredUtf8) return utf8;
	hasRequiredUtf8 = 1;
	(function (exports) {

		/**
		 * A minimal UTF8 implementation for number arrays.
		 * @memberof util
		 * @namespace
		 */
		var utf8 = exports;

		/**
		 * Calculates the UTF8 byte length of a string.
		 * @param {string} string String
		 * @returns {number} Byte length
		 */
		utf8.length = function utf8_length(string) {
		    var len = 0,
		        c = 0;
		    for (var i = 0; i < string.length; ++i) {
		        c = string.charCodeAt(i);
		        if (c < 128)
		            len += 1;
		        else if (c < 2048)
		            len += 2;
		        else if ((c & 0xFC00) === 0xD800 && (string.charCodeAt(i + 1) & 0xFC00) === 0xDC00) {
		            ++i;
		            len += 4;
		        } else
		            len += 3;
		    }
		    return len;
		};

		/**
		 * Reads UTF8 bytes as a string.
		 * @param {Uint8Array} buffer Source buffer
		 * @param {number} start Source start
		 * @param {number} end Source end
		 * @returns {string} String read
		 */
		utf8.read = function utf8_read(buffer, start, end) {
		    var len = end - start;
		    if (len < 1)
		        return "";
		    var parts = null,
		        chunk = [],
		        i = 0, // char offset
		        t;     // temporary
		    while (start < end) {
		        t = buffer[start++];
		        if (t < 128)
		            chunk[i++] = t;
		        else if (t > 191 && t < 224)
		            chunk[i++] = (t & 31) << 6 | buffer[start++] & 63;
		        else if (t > 239 && t < 365) {
		            t = ((t & 7) << 18 | (buffer[start++] & 63) << 12 | (buffer[start++] & 63) << 6 | buffer[start++] & 63) - 0x10000;
		            chunk[i++] = 0xD800 + (t >> 10);
		            chunk[i++] = 0xDC00 + (t & 1023);
		        } else
		            chunk[i++] = (t & 15) << 12 | (buffer[start++] & 63) << 6 | buffer[start++] & 63;
		        if (i > 8191) {
		            (parts || (parts = [])).push(String.fromCharCode.apply(String, chunk));
		            i = 0;
		        }
		    }
		    if (parts) {
		        if (i)
		            parts.push(String.fromCharCode.apply(String, chunk.slice(0, i)));
		        return parts.join("");
		    }
		    return String.fromCharCode.apply(String, chunk.slice(0, i));
		};

		/**
		 * Writes a string as UTF8 bytes.
		 * @param {string} string Source string
		 * @param {Uint8Array} buffer Destination buffer
		 * @param {number} offset Destination offset
		 * @returns {number} Bytes written
		 */
		utf8.write = function utf8_write(string, buffer, offset) {
		    var start = offset,
		        c1, // character 1
		        c2; // character 2
		    for (var i = 0; i < string.length; ++i) {
		        c1 = string.charCodeAt(i);
		        if (c1 < 128) {
		            buffer[offset++] = c1;
		        } else if (c1 < 2048) {
		            buffer[offset++] = c1 >> 6       | 192;
		            buffer[offset++] = c1       & 63 | 128;
		        } else if ((c1 & 0xFC00) === 0xD800 && ((c2 = string.charCodeAt(i + 1)) & 0xFC00) === 0xDC00) {
		            c1 = 0x10000 + ((c1 & 0x03FF) << 10) + (c2 & 0x03FF);
		            ++i;
		            buffer[offset++] = c1 >> 18      | 240;
		            buffer[offset++] = c1 >> 12 & 63 | 128;
		            buffer[offset++] = c1 >> 6  & 63 | 128;
		            buffer[offset++] = c1       & 63 | 128;
		        } else {
		            buffer[offset++] = c1 >> 12      | 224;
		            buffer[offset++] = c1 >> 6  & 63 | 128;
		            buffer[offset++] = c1       & 63 | 128;
		        }
		    }
		    return offset - start;
		};
} (utf8));
	return utf8;
}

var pool_1;
var hasRequiredPool;

function requirePool () {
	if (hasRequiredPool) return pool_1;
	hasRequiredPool = 1;
	pool_1 = pool;

	/**
	 * An allocator as used by {@link util.pool}.
	 * @typedef PoolAllocator
	 * @type {function}
	 * @param {number} size Buffer size
	 * @returns {Uint8Array} Buffer
	 */

	/**
	 * A slicer as used by {@link util.pool}.
	 * @typedef PoolSlicer
	 * @type {function}
	 * @param {number} start Start offset
	 * @param {number} end End offset
	 * @returns {Uint8Array} Buffer slice
	 * @this {Uint8Array}
	 */

	/**
	 * A general purpose buffer pool.
	 * @memberof util
	 * @function
	 * @param {PoolAllocator} alloc Allocator
	 * @param {PoolSlicer} slice Slicer
	 * @param {number} [size=8192] Slab size
	 * @returns {PoolAllocator} Pooled allocator
	 */
	function pool(alloc, slice, size) {
	    var SIZE   = size || 8192;
	    var MAX    = SIZE >>> 1;
	    var slab   = null;
	    var offset = SIZE;
	    return function pool_alloc(size) {
	        if (size < 1 || size > MAX)
	            return alloc(size);
	        if (offset + size > SIZE) {
	            slab = alloc(SIZE);
	            offset = 0;
	        }
	        var buf = slice.call(slab, offset, offset += size);
	        if (offset & 7) // align to 32 bit
	            offset = (offset | 7) + 1;
	        return buf;
	    };
	}
	return pool_1;
}

var longbits;
var hasRequiredLongbits;

function requireLongbits () {
	if (hasRequiredLongbits) return longbits;
	hasRequiredLongbits = 1;
	longbits = LongBits;

	var util = requireMinimal$1();

	/**
	 * Constructs new long bits.
	 * @classdesc Helper class for working with the low and high bits of a 64 bit value.
	 * @memberof util
	 * @constructor
	 * @param {number} lo Low 32 bits, unsigned
	 * @param {number} hi High 32 bits, unsigned
	 */
	function LongBits(lo, hi) {

	    // note that the casts below are theoretically unnecessary as of today, but older statically
	    // generated converter code might still call the ctor with signed 32bits. kept for compat.

	    /**
	     * Low bits.
	     * @type {number}
	     */
	    this.lo = lo >>> 0;

	    /**
	     * High bits.
	     * @type {number}
	     */
	    this.hi = hi >>> 0;
	}

	/**
	 * Zero bits.
	 * @memberof util.LongBits
	 * @type {util.LongBits}
	 */
	var zero = LongBits.zero = new LongBits(0, 0);

	zero.toNumber = function() { return 0; };
	zero.zzEncode = zero.zzDecode = function() { return this; };
	zero.length = function() { return 1; };

	/**
	 * Zero hash.
	 * @memberof util.LongBits
	 * @type {string}
	 */
	var zeroHash = LongBits.zeroHash = "\0\0\0\0\0\0\0\0";

	/**
	 * Constructs new long bits from the specified number.
	 * @param {number} value Value
	 * @returns {util.LongBits} Instance
	 */
	LongBits.fromNumber = function fromNumber(value) {
	    if (value === 0)
	        return zero;
	    var sign = value < 0;
	    if (sign)
	        value = -value;
	    var lo = value >>> 0,
	        hi = (value - lo) / 4294967296 >>> 0;
	    if (sign) {
	        hi = ~hi >>> 0;
	        lo = ~lo >>> 0;
	        if (++lo > 4294967295) {
	            lo = 0;
	            if (++hi > 4294967295)
	                hi = 0;
	        }
	    }
	    return new LongBits(lo, hi);
	};

	/**
	 * Constructs new long bits from a number, long or string.
	 * @param {Long|number|string} value Value
	 * @returns {util.LongBits} Instance
	 */
	LongBits.from = function from(value) {
	    if (typeof value === "number")
	        return LongBits.fromNumber(value);
	    if (util.isString(value)) {
	        /* istanbul ignore else */
	        if (util.Long)
	            value = util.Long.fromString(value);
	        else
	            return LongBits.fromNumber(parseInt(value, 10));
	    }
	    return value.low || value.high ? new LongBits(value.low >>> 0, value.high >>> 0) : zero;
	};

	/**
	 * Converts this long bits to a possibly unsafe JavaScript number.
	 * @param {boolean} [unsigned=false] Whether unsigned or not
	 * @returns {number} Possibly unsafe number
	 */
	LongBits.prototype.toNumber = function toNumber(unsigned) {
	    if (!unsigned && this.hi >>> 31) {
	        var lo = ~this.lo + 1 >>> 0,
	            hi = ~this.hi     >>> 0;
	        if (!lo)
	            hi = hi + 1 >>> 0;
	        return -(lo + hi * 4294967296);
	    }
	    return this.lo + this.hi * 4294967296;
	};

	/**
	 * Converts this long bits to a long.
	 * @param {boolean} [unsigned=false] Whether unsigned or not
	 * @returns {Long} Long
	 */
	LongBits.prototype.toLong = function toLong(unsigned) {
	    return util.Long
	        ? new util.Long(this.lo | 0, this.hi | 0, Boolean(unsigned))
	        /* istanbul ignore next */
	        : { low: this.lo | 0, high: this.hi | 0, unsigned: Boolean(unsigned) };
	};

	var charCodeAt = String.prototype.charCodeAt;

	/**
	 * Constructs new long bits from the specified 8 characters long hash.
	 * @param {string} hash Hash
	 * @returns {util.LongBits} Bits
	 */
	LongBits.fromHash = function fromHash(hash) {
	    if (hash === zeroHash)
	        return zero;
	    return new LongBits(
	        ( charCodeAt.call(hash, 0)
	        | charCodeAt.call(hash, 1) << 8
	        | charCodeAt.call(hash, 2) << 16
	        | charCodeAt.call(hash, 3) << 24) >>> 0
	    ,
	        ( charCodeAt.call(hash, 4)
	        | charCodeAt.call(hash, 5) << 8
	        | charCodeAt.call(hash, 6) << 16
	        | charCodeAt.call(hash, 7) << 24) >>> 0
	    );
	};

	/**
	 * Converts this long bits to a 8 characters long hash.
	 * @returns {string} Hash
	 */
	LongBits.prototype.toHash = function toHash() {
	    return String.fromCharCode(
	        this.lo        & 255,
	        this.lo >>> 8  & 255,
	        this.lo >>> 16 & 255,
	        this.lo >>> 24      ,
	        this.hi        & 255,
	        this.hi >>> 8  & 255,
	        this.hi >>> 16 & 255,
	        this.hi >>> 24
	    );
	};

	/**
	 * Zig-zag encodes this long bits.
	 * @returns {util.LongBits} `this`
	 */
	LongBits.prototype.zzEncode = function zzEncode() {
	    var mask =   this.hi >> 31;
	    this.hi  = ((this.hi << 1 | this.lo >>> 31) ^ mask) >>> 0;
	    this.lo  = ( this.lo << 1                   ^ mask) >>> 0;
	    return this;
	};

	/**
	 * Zig-zag decodes this long bits.
	 * @returns {util.LongBits} `this`
	 */
	LongBits.prototype.zzDecode = function zzDecode() {
	    var mask = -(this.lo & 1);
	    this.lo  = ((this.lo >>> 1 | this.hi << 31) ^ mask) >>> 0;
	    this.hi  = ( this.hi >>> 1                  ^ mask) >>> 0;
	    return this;
	};

	/**
	 * Calculates the length of this longbits when encoded as a varint.
	 * @returns {number} Length
	 */
	LongBits.prototype.length = function length() {
	    var part0 =  this.lo,
	        part1 = (this.lo >>> 28 | this.hi << 4) >>> 0,
	        part2 =  this.hi >>> 24;
	    return part2 === 0
	         ? part1 === 0
	           ? part0 < 16384
	             ? part0 < 128 ? 1 : 2
	             : part0 < 2097152 ? 3 : 4
	           : part1 < 16384
	             ? part1 < 128 ? 5 : 6
	             : part1 < 2097152 ? 7 : 8
	         : part2 < 128 ? 9 : 10;
	};
	return longbits;
}

var hasRequiredMinimal$1;

function requireMinimal$1 () {
	if (hasRequiredMinimal$1) return minimal;
	hasRequiredMinimal$1 = 1;
	(function (exports) {
		var util = exports;

		// used to return a Promise where callback is omitted
		util.asPromise = requireAspromise();

		// converts to / from base64 encoded strings
		util.base64 = requireBase64();

		// base class of rpc.Service
		util.EventEmitter = requireEventemitter();

		// float handling accross browsers
		util.float = requireFloat();

		// requires modules optionally and hides the call from bundlers
		util.inquire = requireInquire();

		// converts to / from utf8 encoded strings
		util.utf8 = requireUtf8();

		// provides a node-like buffer pool in the browser
		util.pool = requirePool();

		// utility to work with the low and high bits of a 64 bit value
		util.LongBits = requireLongbits();

		/**
		 * Whether running within node or not.
		 * @memberof util
		 * @type {boolean}
		 */
		util.isNode = Boolean(typeof commonjsGlobal !== "undefined"
		                   && commonjsGlobal
		                   && commonjsGlobal.process
		                   && commonjsGlobal.process.versions
		                   && commonjsGlobal.process.versions.node);

		/**
		 * Global object reference.
		 * @memberof util
		 * @type {Object}
		 */
		util.global = util.isNode && commonjsGlobal
		           || typeof window !== "undefined" && window
		           || typeof self   !== "undefined" && self
		           || commonjsGlobal; // eslint-disable-line no-invalid-this

		/**
		 * An immuable empty array.
		 * @memberof util
		 * @type {Array.<*>}
		 * @const
		 */
		util.emptyArray = Object.freeze ? Object.freeze([]) : /* istanbul ignore next */ []; // used on prototypes

		/**
		 * An immutable empty object.
		 * @type {Object}
		 * @const
		 */
		util.emptyObject = Object.freeze ? Object.freeze({}) : /* istanbul ignore next */ {}; // used on prototypes

		/**
		 * Tests if the specified value is an integer.
		 * @function
		 * @param {*} value Value to test
		 * @returns {boolean} `true` if the value is an integer
		 */
		util.isInteger = Number.isInteger || /* istanbul ignore next */ function isInteger(value) {
		    return typeof value === "number" && isFinite(value) && Math.floor(value) === value;
		};

		/**
		 * Tests if the specified value is a string.
		 * @param {*} value Value to test
		 * @returns {boolean} `true` if the value is a string
		 */
		util.isString = function isString(value) {
		    return typeof value === "string" || value instanceof String;
		};

		/**
		 * Tests if the specified value is a non-null object.
		 * @param {*} value Value to test
		 * @returns {boolean} `true` if the value is a non-null object
		 */
		util.isObject = function isObject(value) {
		    return value && typeof value === "object";
		};

		/**
		 * Checks if a property on a message is considered to be present.
		 * This is an alias of {@link util.isSet}.
		 * @function
		 * @param {Object} obj Plain object or message instance
		 * @param {string} prop Property name
		 * @returns {boolean} `true` if considered to be present, otherwise `false`
		 */
		util.isset =

		/**
		 * Checks if a property on a message is considered to be present.
		 * @param {Object} obj Plain object or message instance
		 * @param {string} prop Property name
		 * @returns {boolean} `true` if considered to be present, otherwise `false`
		 */
		util.isSet = function isSet(obj, prop) {
		    var value = obj[prop];
		    if (value != null && obj.hasOwnProperty(prop)) // eslint-disable-line eqeqeq, no-prototype-builtins
		        return typeof value !== "object" || (Array.isArray(value) ? value.length : Object.keys(value).length) > 0;
		    return false;
		};

		/**
		 * Any compatible Buffer instance.
		 * This is a minimal stand-alone definition of a Buffer instance. The actual type is that exported by node's typings.
		 * @interface Buffer
		 * @extends Uint8Array
		 */

		/**
		 * Node's Buffer class if available.
		 * @type {Constructor<Buffer>}
		 */
		util.Buffer = (function() {
		    try {
		        var Buffer = util.inquire("buffer").Buffer;
		        // refuse to use non-node buffers if not explicitly assigned (perf reasons):
		        return Buffer.prototype.utf8Write ? Buffer : /* istanbul ignore next */ null;
		    } catch (e) {
		        /* istanbul ignore next */
		        return null;
		    }
		})();

		// Internal alias of or polyfull for Buffer.from.
		util._Buffer_from = null;

		// Internal alias of or polyfill for Buffer.allocUnsafe.
		util._Buffer_allocUnsafe = null;

		/**
		 * Creates a new buffer of whatever type supported by the environment.
		 * @param {number|number[]} [sizeOrArray=0] Buffer size or number array
		 * @returns {Uint8Array|Buffer} Buffer
		 */
		util.newBuffer = function newBuffer(sizeOrArray) {
		    /* istanbul ignore next */
		    return typeof sizeOrArray === "number"
		        ? util.Buffer
		            ? util._Buffer_allocUnsafe(sizeOrArray)
		            : new util.Array(sizeOrArray)
		        : util.Buffer
		            ? util._Buffer_from(sizeOrArray)
		            : typeof Uint8Array === "undefined"
		                ? sizeOrArray
		                : new Uint8Array(sizeOrArray);
		};

		/**
		 * Array implementation used in the browser. `Uint8Array` if supported, otherwise `Array`.
		 * @type {Constructor<Uint8Array>}
		 */
		util.Array = typeof Uint8Array !== "undefined" ? Uint8Array /* istanbul ignore next */ : Array;

		/**
		 * Any compatible Long instance.
		 * This is a minimal stand-alone definition of a Long instance. The actual type is that exported by long.js.
		 * @interface Long
		 * @property {number} low Low bits
		 * @property {number} high High bits
		 * @property {boolean} unsigned Whether unsigned or not
		 */

		/**
		 * Long.js's Long class if available.
		 * @type {Constructor<Long>}
		 */
		util.Long = /* istanbul ignore next */ util.global.dcodeIO && /* istanbul ignore next */ util.global.dcodeIO.Long
		         || /* istanbul ignore next */ util.global.Long
		         || util.inquire("long");

		/**
		 * Regular expression used to verify 2 bit (`bool`) map keys.
		 * @type {RegExp}
		 * @const
		 */
		util.key2Re = /^true|false|0|1$/;

		/**
		 * Regular expression used to verify 32 bit (`int32` etc.) map keys.
		 * @type {RegExp}
		 * @const
		 */
		util.key32Re = /^-?(?:0|[1-9][0-9]*)$/;

		/**
		 * Regular expression used to verify 64 bit (`int64` etc.) map keys.
		 * @type {RegExp}
		 * @const
		 */
		util.key64Re = /^(?:[\\x00-\\xff]{8}|-?(?:0|[1-9][0-9]*))$/;

		/**
		 * Converts a number or long to an 8 characters long hash string.
		 * @param {Long|number} value Value to convert
		 * @returns {string} Hash
		 */
		util.longToHash = function longToHash(value) {
		    return value
		        ? util.LongBits.from(value).toHash()
		        : util.LongBits.zeroHash;
		};

		/**
		 * Converts an 8 characters long hash string to a long or number.
		 * @param {string} hash Hash
		 * @param {boolean} [unsigned=false] Whether unsigned or not
		 * @returns {Long|number} Original value
		 */
		util.longFromHash = function longFromHash(hash, unsigned) {
		    var bits = util.LongBits.fromHash(hash);
		    if (util.Long)
		        return util.Long.fromBits(bits.lo, bits.hi, unsigned);
		    return bits.toNumber(Boolean(unsigned));
		};

		/**
		 * Merges the properties of the source object into the destination object.
		 * @memberof util
		 * @param {Object.<string,*>} dst Destination object
		 * @param {Object.<string,*>} src Source object
		 * @param {boolean} [ifNotSet=false] Merges only if the key is not already set
		 * @returns {Object.<string,*>} Destination object
		 */
		function merge(dst, src, ifNotSet) { // used by converters
		    for (var keys = Object.keys(src), i = 0; i < keys.length; ++i)
		        if (dst[keys[i]] === undefined || !ifNotSet)
		            dst[keys[i]] = src[keys[i]];
		    return dst;
		}

		util.merge = merge;

		/**
		 * Converts the first character of a string to lower case.
		 * @param {string} str String to convert
		 * @returns {string} Converted string
		 */
		util.lcFirst = function lcFirst(str) {
		    return str.charAt(0).toLowerCase() + str.substring(1);
		};

		/**
		 * Creates a custom error constructor.
		 * @memberof util
		 * @param {string} name Error name
		 * @returns {Constructor<Error>} Custom error constructor
		 */
		function newError(name) {

		    function CustomError(message, properties) {

		        if (!(this instanceof CustomError))
		            return new CustomError(message, properties);

		        // Error.call(this, message);
		        // ^ just returns a new error instance because the ctor can be called as a function

		        Object.defineProperty(this, "message", { get: function() { return message; } });

		        /* istanbul ignore next */
		        if (Error.captureStackTrace) // node
		            Error.captureStackTrace(this, CustomError);
		        else
		            Object.defineProperty(this, "stack", { value: new Error().stack || "" });

		        if (properties)
		            merge(this, properties);
		    }

		    (CustomError.prototype = Object.create(Error.prototype)).constructor = CustomError;

		    Object.defineProperty(CustomError.prototype, "name", { get: function() { return name; } });

		    CustomError.prototype.toString = function toString() {
		        return this.name + ": " + this.message;
		    };

		    return CustomError;
		}

		util.newError = newError;

		/**
		 * Constructs a new protocol error.
		 * @classdesc Error subclass indicating a protocol specifc error.
		 * @memberof util
		 * @extends Error
		 * @template T extends Message<T>
		 * @constructor
		 * @param {string} message Error message
		 * @param {Object.<string,*>} [properties] Additional properties
		 * @example
		 * try {
		 *     MyMessage.decode(someBuffer); // throws if required fields are missing
		 * } catch (e) {
		 *     if (e instanceof ProtocolError && e.instance)
		 *         console.log("decoded so far: " + JSON.stringify(e.instance));
		 * }
		 */
		util.ProtocolError = newError("ProtocolError");

		/**
		 * So far decoded message instance.
		 * @name util.ProtocolError#instance
		 * @type {Message<T>}
		 */

		/**
		 * A OneOf getter as returned by {@link util.oneOfGetter}.
		 * @typedef OneOfGetter
		 * @type {function}
		 * @returns {string|undefined} Set field name, if any
		 */

		/**
		 * Builds a getter for a oneof's present field name.
		 * @param {string[]} fieldNames Field names
		 * @returns {OneOfGetter} Unbound getter
		 */
		util.oneOfGetter = function getOneOf(fieldNames) {
		    var fieldMap = {};
		    for (var i = 0; i < fieldNames.length; ++i)
		        fieldMap[fieldNames[i]] = 1;

		    /**
		     * @returns {string|undefined} Set field name, if any
		     * @this Object
		     * @ignore
		     */
		    return function() { // eslint-disable-line consistent-return
		        for (var keys = Object.keys(this), i = keys.length - 1; i > -1; --i)
		            if (fieldMap[keys[i]] === 1 && this[keys[i]] !== undefined && this[keys[i]] !== null)
		                return keys[i];
		    };
		};

		/**
		 * A OneOf setter as returned by {@link util.oneOfSetter}.
		 * @typedef OneOfSetter
		 * @type {function}
		 * @param {string|undefined} value Field name
		 * @returns {undefined}
		 */

		/**
		 * Builds a setter for a oneof's present field name.
		 * @param {string[]} fieldNames Field names
		 * @returns {OneOfSetter} Unbound setter
		 */
		util.oneOfSetter = function setOneOf(fieldNames) {

		    /**
		     * @param {string} name Field name
		     * @returns {undefined}
		     * @this Object
		     * @ignore
		     */
		    return function(name) {
		        for (var i = 0; i < fieldNames.length; ++i)
		            if (fieldNames[i] !== name)
		                delete this[fieldNames[i]];
		    };
		};

		/**
		 * Default conversion options used for {@link Message#toJSON} implementations.
		 *
		 * These options are close to proto3's JSON mapping with the exception that internal types like Any are handled just like messages. More precisely:
		 *
		 * - Longs become strings
		 * - Enums become string keys
		 * - Bytes become base64 encoded strings
		 * - (Sub-)Messages become plain objects
		 * - Maps become plain objects with all string keys
		 * - Repeated fields become arrays
		 * - NaN and Infinity for float and double fields become strings
		 *
		 * @type {IConversionOptions}
		 * @see https://developers.google.com/protocol-buffers/docs/proto3?hl=en#json
		 */
		util.toJSONOptions = {
		    longs: String,
		    enums: String,
		    bytes: String,
		    json: true
		};

		// Sets up buffer utility according to the environment (called in index-minimal)
		util._configure = function() {
		    var Buffer = util.Buffer;
		    /* istanbul ignore if */
		    if (!Buffer) {
		        util._Buffer_from = util._Buffer_allocUnsafe = null;
		        return;
		    }
		    // because node 4.x buffers are incompatible & immutable
		    // see: https://github.com/dcodeIO/protobuf.js/pull/665
		    util._Buffer_from = Buffer.from !== Uint8Array.from && Buffer.from ||
		        /* istanbul ignore next */
		        function Buffer_from(value, encoding) {
		            return new Buffer(value, encoding);
		        };
		    util._Buffer_allocUnsafe = Buffer.allocUnsafe ||
		        /* istanbul ignore next */
		        function Buffer_allocUnsafe(size) {
		            return new Buffer(size);
		        };
		};
} (minimal));
	return minimal;
}

var writer;
var hasRequiredWriter;

function requireWriter () {
	if (hasRequiredWriter) return writer;
	hasRequiredWriter = 1;
	writer = Writer;

	var util      = requireMinimal$1();

	var BufferWriter; // cyclic

	var LongBits  = util.LongBits,
	    base64    = util.base64,
	    utf8      = util.utf8;

	/**
	 * Constructs a new writer operation instance.
	 * @classdesc Scheduled writer operation.
	 * @constructor
	 * @param {function(*, Uint8Array, number)} fn Function to call
	 * @param {number} len Value byte length
	 * @param {*} val Value to write
	 * @ignore
	 */
	function Op(fn, len, val) {

	    /**
	     * Function to call.
	     * @type {function(Uint8Array, number, *)}
	     */
	    this.fn = fn;

	    /**
	     * Value byte length.
	     * @type {number}
	     */
	    this.len = len;

	    /**
	     * Next operation.
	     * @type {Writer.Op|undefined}
	     */
	    this.next = undefined;

	    /**
	     * Value to write.
	     * @type {*}
	     */
	    this.val = val; // type varies
	}

	/* istanbul ignore next */
	function noop() {} // eslint-disable-line no-empty-function

	/**
	 * Constructs a new writer state instance.
	 * @classdesc Copied writer state.
	 * @memberof Writer
	 * @constructor
	 * @param {Writer} writer Writer to copy state from
	 * @ignore
	 */
	function State(writer) {

	    /**
	     * Current head.
	     * @type {Writer.Op}
	     */
	    this.head = writer.head;

	    /**
	     * Current tail.
	     * @type {Writer.Op}
	     */
	    this.tail = writer.tail;

	    /**
	     * Current buffer length.
	     * @type {number}
	     */
	    this.len = writer.len;

	    /**
	     * Next state.
	     * @type {State|null}
	     */
	    this.next = writer.states;
	}

	/**
	 * Constructs a new writer instance.
	 * @classdesc Wire format writer using `Uint8Array` if available, otherwise `Array`.
	 * @constructor
	 */
	function Writer() {

	    /**
	     * Current length.
	     * @type {number}
	     */
	    this.len = 0;

	    /**
	     * Operations head.
	     * @type {Object}
	     */
	    this.head = new Op(noop, 0, 0);

	    /**
	     * Operations tail
	     * @type {Object}
	     */
	    this.tail = this.head;

	    /**
	     * Linked forked states.
	     * @type {Object|null}
	     */
	    this.states = null;

	    // When a value is written, the writer calculates its byte length and puts it into a linked
	    // list of operations to perform when finish() is called. This both allows us to allocate
	    // buffers of the exact required size and reduces the amount of work we have to do compared
	    // to first calculating over objects and then encoding over objects. In our case, the encoding
	    // part is just a linked list walk calling operations with already prepared values.
	}

	var create = function create() {
	    return util.Buffer
	        ? function create_buffer_setup() {
	            return (Writer.create = function create_buffer() {
	                return new BufferWriter();
	            })();
	        }
	        /* istanbul ignore next */
	        : function create_array() {
	            return new Writer();
	        };
	};

	/**
	 * Creates a new writer.
	 * @function
	 * @returns {BufferWriter|Writer} A {@link BufferWriter} when Buffers are supported, otherwise a {@link Writer}
	 */
	Writer.create = create();

	/**
	 * Allocates a buffer of the specified size.
	 * @param {number} size Buffer size
	 * @returns {Uint8Array} Buffer
	 */
	Writer.alloc = function alloc(size) {
	    return new util.Array(size);
	};

	// Use Uint8Array buffer pool in the browser, just like node does with buffers
	/* istanbul ignore else */
	if (util.Array !== Array)
	    Writer.alloc = util.pool(Writer.alloc, util.Array.prototype.subarray);

	/**
	 * Pushes a new operation to the queue.
	 * @param {function(Uint8Array, number, *)} fn Function to call
	 * @param {number} len Value byte length
	 * @param {number} val Value to write
	 * @returns {Writer} `this`
	 * @private
	 */
	Writer.prototype._push = function push(fn, len, val) {
	    this.tail = this.tail.next = new Op(fn, len, val);
	    this.len += len;
	    return this;
	};

	function writeByte(val, buf, pos) {
	    buf[pos] = val & 255;
	}

	function writeVarint32(val, buf, pos) {
	    while (val > 127) {
	        buf[pos++] = val & 127 | 128;
	        val >>>= 7;
	    }
	    buf[pos] = val;
	}

	/**
	 * Constructs a new varint writer operation instance.
	 * @classdesc Scheduled varint writer operation.
	 * @extends Op
	 * @constructor
	 * @param {number} len Value byte length
	 * @param {number} val Value to write
	 * @ignore
	 */
	function VarintOp(len, val) {
	    this.len = len;
	    this.next = undefined;
	    this.val = val;
	}

	VarintOp.prototype = Object.create(Op.prototype);
	VarintOp.prototype.fn = writeVarint32;

	/**
	 * Writes an unsigned 32 bit value as a varint.
	 * @param {number} value Value to write
	 * @returns {Writer} `this`
	 */
	Writer.prototype.uint32 = function write_uint32(value) {
	    // here, the call to this.push has been inlined and a varint specific Op subclass is used.
	    // uint32 is by far the most frequently used operation and benefits significantly from this.
	    this.len += (this.tail = this.tail.next = new VarintOp(
	        (value = value >>> 0)
	                < 128       ? 1
	        : value < 16384     ? 2
	        : value < 2097152   ? 3
	        : value < 268435456 ? 4
	        :                     5,
	    value)).len;
	    return this;
	};

	/**
	 * Writes a signed 32 bit value as a varint.
	 * @function
	 * @param {number} value Value to write
	 * @returns {Writer} `this`
	 */
	Writer.prototype.int32 = function write_int32(value) {
	    return value < 0
	        ? this._push(writeVarint64, 10, LongBits.fromNumber(value)) // 10 bytes per spec
	        : this.uint32(value);
	};

	/**
	 * Writes a 32 bit value as a varint, zig-zag encoded.
	 * @param {number} value Value to write
	 * @returns {Writer} `this`
	 */
	Writer.prototype.sint32 = function write_sint32(value) {
	    return this.uint32((value << 1 ^ value >> 31) >>> 0);
	};

	function writeVarint64(val, buf, pos) {
	    while (val.hi) {
	        buf[pos++] = val.lo & 127 | 128;
	        val.lo = (val.lo >>> 7 | val.hi << 25) >>> 0;
	        val.hi >>>= 7;
	    }
	    while (val.lo > 127) {
	        buf[pos++] = val.lo & 127 | 128;
	        val.lo = val.lo >>> 7;
	    }
	    buf[pos++] = val.lo;
	}

	/**
	 * Writes an unsigned 64 bit value as a varint.
	 * @param {Long|number|string} value Value to write
	 * @returns {Writer} `this`
	 * @throws {TypeError} If `value` is a string and no long library is present.
	 */
	Writer.prototype.uint64 = function write_uint64(value) {
	    var bits = LongBits.from(value);
	    return this._push(writeVarint64, bits.length(), bits);
	};

	/**
	 * Writes a signed 64 bit value as a varint.
	 * @function
	 * @param {Long|number|string} value Value to write
	 * @returns {Writer} `this`
	 * @throws {TypeError} If `value` is a string and no long library is present.
	 */
	Writer.prototype.int64 = Writer.prototype.uint64;

	/**
	 * Writes a signed 64 bit value as a varint, zig-zag encoded.
	 * @param {Long|number|string} value Value to write
	 * @returns {Writer} `this`
	 * @throws {TypeError} If `value` is a string and no long library is present.
	 */
	Writer.prototype.sint64 = function write_sint64(value) {
	    var bits = LongBits.from(value).zzEncode();
	    return this._push(writeVarint64, bits.length(), bits);
	};

	/**
	 * Writes a boolish value as a varint.
	 * @param {boolean} value Value to write
	 * @returns {Writer} `this`
	 */
	Writer.prototype.bool = function write_bool(value) {
	    return this._push(writeByte, 1, value ? 1 : 0);
	};

	function writeFixed32(val, buf, pos) {
	    buf[pos    ] =  val         & 255;
	    buf[pos + 1] =  val >>> 8   & 255;
	    buf[pos + 2] =  val >>> 16  & 255;
	    buf[pos + 3] =  val >>> 24;
	}

	/**
	 * Writes an unsigned 32 bit value as fixed 32 bits.
	 * @param {number} value Value to write
	 * @returns {Writer} `this`
	 */
	Writer.prototype.fixed32 = function write_fixed32(value) {
	    return this._push(writeFixed32, 4, value >>> 0);
	};

	/**
	 * Writes a signed 32 bit value as fixed 32 bits.
	 * @function
	 * @param {number} value Value to write
	 * @returns {Writer} `this`
	 */
	Writer.prototype.sfixed32 = Writer.prototype.fixed32;

	/**
	 * Writes an unsigned 64 bit value as fixed 64 bits.
	 * @param {Long|number|string} value Value to write
	 * @returns {Writer} `this`
	 * @throws {TypeError} If `value` is a string and no long library is present.
	 */
	Writer.prototype.fixed64 = function write_fixed64(value) {
	    var bits = LongBits.from(value);
	    return this._push(writeFixed32, 4, bits.lo)._push(writeFixed32, 4, bits.hi);
	};

	/**
	 * Writes a signed 64 bit value as fixed 64 bits.
	 * @function
	 * @param {Long|number|string} value Value to write
	 * @returns {Writer} `this`
	 * @throws {TypeError} If `value` is a string and no long library is present.
	 */
	Writer.prototype.sfixed64 = Writer.prototype.fixed64;

	/**
	 * Writes a float (32 bit).
	 * @function
	 * @param {number} value Value to write
	 * @returns {Writer} `this`
	 */
	Writer.prototype.float = function write_float(value) {
	    return this._push(util.float.writeFloatLE, 4, value);
	};

	/**
	 * Writes a double (64 bit float).
	 * @function
	 * @param {number} value Value to write
	 * @returns {Writer} `this`
	 */
	Writer.prototype.double = function write_double(value) {
	    return this._push(util.float.writeDoubleLE, 8, value);
	};

	var writeBytes = util.Array.prototype.set
	    ? function writeBytes_set(val, buf, pos) {
	        buf.set(val, pos); // also works for plain array values
	    }
	    /* istanbul ignore next */
	    : function writeBytes_for(val, buf, pos) {
	        for (var i = 0; i < val.length; ++i)
	            buf[pos + i] = val[i];
	    };

	/**
	 * Writes a sequence of bytes.
	 * @param {Uint8Array|string} value Buffer or base64 encoded string to write
	 * @returns {Writer} `this`
	 */
	Writer.prototype.bytes = function write_bytes(value) {
	    var len = value.length >>> 0;
	    if (!len)
	        return this._push(writeByte, 1, 0);
	    if (util.isString(value)) {
	        var buf = Writer.alloc(len = base64.length(value));
	        base64.decode(value, buf, 0);
	        value = buf;
	    }
	    return this.uint32(len)._push(writeBytes, len, value);
	};

	/**
	 * Writes a string.
	 * @param {string} value Value to write
	 * @returns {Writer} `this`
	 */
	Writer.prototype.string = function write_string(value) {
	    var len = utf8.length(value);
	    return len
	        ? this.uint32(len)._push(utf8.write, len, value)
	        : this._push(writeByte, 1, 0);
	};

	/**
	 * Forks this writer's state by pushing it to a stack.
	 * Calling {@link Writer#reset|reset} or {@link Writer#ldelim|ldelim} resets the writer to the previous state.
	 * @returns {Writer} `this`
	 */
	Writer.prototype.fork = function fork() {
	    this.states = new State(this);
	    this.head = this.tail = new Op(noop, 0, 0);
	    this.len = 0;
	    return this;
	};

	/**
	 * Resets this instance to the last state.
	 * @returns {Writer} `this`
	 */
	Writer.prototype.reset = function reset() {
	    if (this.states) {
	        this.head   = this.states.head;
	        this.tail   = this.states.tail;
	        this.len    = this.states.len;
	        this.states = this.states.next;
	    } else {
	        this.head = this.tail = new Op(noop, 0, 0);
	        this.len  = 0;
	    }
	    return this;
	};

	/**
	 * Resets to the last state and appends the fork state's current write length as a varint followed by its operations.
	 * @returns {Writer} `this`
	 */
	Writer.prototype.ldelim = function ldelim() {
	    var head = this.head,
	        tail = this.tail,
	        len  = this.len;
	    this.reset().uint32(len);
	    if (len) {
	        this.tail.next = head.next; // skip noop
	        this.tail = tail;
	        this.len += len;
	    }
	    return this;
	};

	/**
	 * Finishes the write operation.
	 * @returns {Uint8Array} Finished buffer
	 */
	Writer.prototype.finish = function finish() {
	    var head = this.head.next, // skip noop
	        buf  = this.constructor.alloc(this.len),
	        pos  = 0;
	    while (head) {
	        head.fn(head.val, buf, pos);
	        pos += head.len;
	        head = head.next;
	    }
	    // this.head = this.tail = null;
	    return buf;
	};

	Writer._configure = function(BufferWriter_) {
	    BufferWriter = BufferWriter_;
	    Writer.create = create();
	    BufferWriter._configure();
	};
	return writer;
}

var writer_buffer;
var hasRequiredWriter_buffer;

function requireWriter_buffer () {
	if (hasRequiredWriter_buffer) return writer_buffer;
	hasRequiredWriter_buffer = 1;
	writer_buffer = BufferWriter;

	// extends Writer
	var Writer = requireWriter();
	(BufferWriter.prototype = Object.create(Writer.prototype)).constructor = BufferWriter;

	var util = requireMinimal$1();

	/**
	 * Constructs a new buffer writer instance.
	 * @classdesc Wire format writer using node buffers.
	 * @extends Writer
	 * @constructor
	 */
	function BufferWriter() {
	    Writer.call(this);
	}

	BufferWriter._configure = function () {
	    /**
	     * Allocates a buffer of the specified size.
	     * @function
	     * @param {number} size Buffer size
	     * @returns {Buffer} Buffer
	     */
	    BufferWriter.alloc = util._Buffer_allocUnsafe;

	    BufferWriter.writeBytesBuffer = util.Buffer && util.Buffer.prototype instanceof Uint8Array && util.Buffer.prototype.set.name === "set"
	        ? function writeBytesBuffer_set(val, buf, pos) {
	          buf.set(val, pos); // faster than copy (requires node >= 4 where Buffers extend Uint8Array and set is properly inherited)
	          // also works for plain array values
	        }
	        /* istanbul ignore next */
	        : function writeBytesBuffer_copy(val, buf, pos) {
	          if (val.copy) // Buffer values
	            val.copy(buf, pos, 0, val.length);
	          else for (var i = 0; i < val.length;) // plain array values
	            buf[pos++] = val[i++];
	        };
	};


	/**
	 * @override
	 */
	BufferWriter.prototype.bytes = function write_bytes_buffer(value) {
	    if (util.isString(value))
	        value = util._Buffer_from(value, "base64");
	    var len = value.length >>> 0;
	    this.uint32(len);
	    if (len)
	        this._push(BufferWriter.writeBytesBuffer, len, value);
	    return this;
	};

	function writeStringBuffer(val, buf, pos) {
	    if (val.length < 40) // plain js is faster for short strings (probably due to redundant assertions)
	        util.utf8.write(val, buf, pos);
	    else if (buf.utf8Write)
	        buf.utf8Write(val, pos);
	    else
	        buf.write(val, pos);
	}

	/**
	 * @override
	 */
	BufferWriter.prototype.string = function write_string_buffer(value) {
	    var len = util.Buffer.byteLength(value);
	    this.uint32(len);
	    if (len)
	        this._push(writeStringBuffer, len, value);
	    return this;
	};


	/**
	 * Finishes the write operation.
	 * @name BufferWriter#finish
	 * @function
	 * @returns {Buffer} Finished buffer
	 */

	BufferWriter._configure();
	return writer_buffer;
}

var reader;
var hasRequiredReader;

function requireReader () {
	if (hasRequiredReader) return reader;
	hasRequiredReader = 1;
	reader = Reader;

	var util      = requireMinimal$1();

	var BufferReader; // cyclic

	var LongBits  = util.LongBits,
	    utf8      = util.utf8;

	/* istanbul ignore next */
	function indexOutOfRange(reader, writeLength) {
	    return RangeError("index out of range: " + reader.pos + " + " + (writeLength || 1) + " > " + reader.len);
	}

	/**
	 * Constructs a new reader instance using the specified buffer.
	 * @classdesc Wire format reader using `Uint8Array` if available, otherwise `Array`.
	 * @constructor
	 * @param {Uint8Array} buffer Buffer to read from
	 */
	function Reader(buffer) {

	    /**
	     * Read buffer.
	     * @type {Uint8Array}
	     */
	    this.buf = buffer;

	    /**
	     * Read buffer position.
	     * @type {number}
	     */
	    this.pos = 0;

	    /**
	     * Read buffer length.
	     * @type {number}
	     */
	    this.len = buffer.length;
	}

	var create_array = typeof Uint8Array !== "undefined"
	    ? function create_typed_array(buffer) {
	        if (buffer instanceof Uint8Array || Array.isArray(buffer))
	            return new Reader(buffer);
	        throw Error("illegal buffer");
	    }
	    /* istanbul ignore next */
	    : function create_array(buffer) {
	        if (Array.isArray(buffer))
	            return new Reader(buffer);
	        throw Error("illegal buffer");
	    };

	var create = function create() {
	    return util.Buffer
	        ? function create_buffer_setup(buffer) {
	            return (Reader.create = function create_buffer(buffer) {
	                return util.Buffer.isBuffer(buffer)
	                    ? new BufferReader(buffer)
	                    /* istanbul ignore next */
	                    : create_array(buffer);
	            })(buffer);
	        }
	        /* istanbul ignore next */
	        : create_array;
	};

	/**
	 * Creates a new reader using the specified buffer.
	 * @function
	 * @param {Uint8Array|Buffer} buffer Buffer to read from
	 * @returns {Reader|BufferReader} A {@link BufferReader} if `buffer` is a Buffer, otherwise a {@link Reader}
	 * @throws {Error} If `buffer` is not a valid buffer
	 */
	Reader.create = create();

	Reader.prototype._slice = util.Array.prototype.subarray || /* istanbul ignore next */ util.Array.prototype.slice;

	/**
	 * Reads a varint as an unsigned 32 bit value.
	 * @function
	 * @returns {number} Value read
	 */
	Reader.prototype.uint32 = (function read_uint32_setup() {
	    var value = 4294967295; // optimizer type-hint, tends to deopt otherwise (?!)
	    return function read_uint32() {
	        value = (         this.buf[this.pos] & 127       ) >>> 0; if (this.buf[this.pos++] < 128) return value;
	        value = (value | (this.buf[this.pos] & 127) <<  7) >>> 0; if (this.buf[this.pos++] < 128) return value;
	        value = (value | (this.buf[this.pos] & 127) << 14) >>> 0; if (this.buf[this.pos++] < 128) return value;
	        value = (value | (this.buf[this.pos] & 127) << 21) >>> 0; if (this.buf[this.pos++] < 128) return value;
	        value = (value | (this.buf[this.pos] &  15) << 28) >>> 0; if (this.buf[this.pos++] < 128) return value;

	        /* istanbul ignore if */
	        if ((this.pos += 5) > this.len) {
	            this.pos = this.len;
	            throw indexOutOfRange(this, 10);
	        }
	        return value;
	    };
	})();

	/**
	 * Reads a varint as a signed 32 bit value.
	 * @returns {number} Value read
	 */
	Reader.prototype.int32 = function read_int32() {
	    return this.uint32() | 0;
	};

	/**
	 * Reads a zig-zag encoded varint as a signed 32 bit value.
	 * @returns {number} Value read
	 */
	Reader.prototype.sint32 = function read_sint32() {
	    var value = this.uint32();
	    return value >>> 1 ^ -(value & 1) | 0;
	};

	/* eslint-disable no-invalid-this */

	function readLongVarint() {
	    // tends to deopt with local vars for octet etc.
	    var bits = new LongBits(0, 0);
	    var i = 0;
	    if (this.len - this.pos > 4) { // fast route (lo)
	        for (; i < 4; ++i) {
	            // 1st..4th
	            bits.lo = (bits.lo | (this.buf[this.pos] & 127) << i * 7) >>> 0;
	            if (this.buf[this.pos++] < 128)
	                return bits;
	        }
	        // 5th
	        bits.lo = (bits.lo | (this.buf[this.pos] & 127) << 28) >>> 0;
	        bits.hi = (bits.hi | (this.buf[this.pos] & 127) >>  4) >>> 0;
	        if (this.buf[this.pos++] < 128)
	            return bits;
	        i = 0;
	    } else {
	        for (; i < 3; ++i) {
	            /* istanbul ignore if */
	            if (this.pos >= this.len)
	                throw indexOutOfRange(this);
	            // 1st..3th
	            bits.lo = (bits.lo | (this.buf[this.pos] & 127) << i * 7) >>> 0;
	            if (this.buf[this.pos++] < 128)
	                return bits;
	        }
	        // 4th
	        bits.lo = (bits.lo | (this.buf[this.pos++] & 127) << i * 7) >>> 0;
	        return bits;
	    }
	    if (this.len - this.pos > 4) { // fast route (hi)
	        for (; i < 5; ++i) {
	            // 6th..10th
	            bits.hi = (bits.hi | (this.buf[this.pos] & 127) << i * 7 + 3) >>> 0;
	            if (this.buf[this.pos++] < 128)
	                return bits;
	        }
	    } else {
	        for (; i < 5; ++i) {
	            /* istanbul ignore if */
	            if (this.pos >= this.len)
	                throw indexOutOfRange(this);
	            // 6th..10th
	            bits.hi = (bits.hi | (this.buf[this.pos] & 127) << i * 7 + 3) >>> 0;
	            if (this.buf[this.pos++] < 128)
	                return bits;
	        }
	    }
	    /* istanbul ignore next */
	    throw Error("invalid varint encoding");
	}

	/* eslint-enable no-invalid-this */

	/**
	 * Reads a varint as a signed 64 bit value.
	 * @name Reader#int64
	 * @function
	 * @returns {Long} Value read
	 */

	/**
	 * Reads a varint as an unsigned 64 bit value.
	 * @name Reader#uint64
	 * @function
	 * @returns {Long} Value read
	 */

	/**
	 * Reads a zig-zag encoded varint as a signed 64 bit value.
	 * @name Reader#sint64
	 * @function
	 * @returns {Long} Value read
	 */

	/**
	 * Reads a varint as a boolean.
	 * @returns {boolean} Value read
	 */
	Reader.prototype.bool = function read_bool() {
	    return this.uint32() !== 0;
	};

	function readFixed32_end(buf, end) { // note that this uses `end`, not `pos`
	    return (buf[end - 4]
	          | buf[end - 3] << 8
	          | buf[end - 2] << 16
	          | buf[end - 1] << 24) >>> 0;
	}

	/**
	 * Reads fixed 32 bits as an unsigned 32 bit integer.
	 * @returns {number} Value read
	 */
	Reader.prototype.fixed32 = function read_fixed32() {

	    /* istanbul ignore if */
	    if (this.pos + 4 > this.len)
	        throw indexOutOfRange(this, 4);

	    return readFixed32_end(this.buf, this.pos += 4);
	};

	/**
	 * Reads fixed 32 bits as a signed 32 bit integer.
	 * @returns {number} Value read
	 */
	Reader.prototype.sfixed32 = function read_sfixed32() {

	    /* istanbul ignore if */
	    if (this.pos + 4 > this.len)
	        throw indexOutOfRange(this, 4);

	    return readFixed32_end(this.buf, this.pos += 4) | 0;
	};

	/* eslint-disable no-invalid-this */

	function readFixed64(/* this: Reader */) {

	    /* istanbul ignore if */
	    if (this.pos + 8 > this.len)
	        throw indexOutOfRange(this, 8);

	    return new LongBits(readFixed32_end(this.buf, this.pos += 4), readFixed32_end(this.buf, this.pos += 4));
	}

	/* eslint-enable no-invalid-this */

	/**
	 * Reads fixed 64 bits.
	 * @name Reader#fixed64
	 * @function
	 * @returns {Long} Value read
	 */

	/**
	 * Reads zig-zag encoded fixed 64 bits.
	 * @name Reader#sfixed64
	 * @function
	 * @returns {Long} Value read
	 */

	/**
	 * Reads a float (32 bit) as a number.
	 * @function
	 * @returns {number} Value read
	 */
	Reader.prototype.float = function read_float() {

	    /* istanbul ignore if */
	    if (this.pos + 4 > this.len)
	        throw indexOutOfRange(this, 4);

	    var value = util.float.readFloatLE(this.buf, this.pos);
	    this.pos += 4;
	    return value;
	};

	/**
	 * Reads a double (64 bit float) as a number.
	 * @function
	 * @returns {number} Value read
	 */
	Reader.prototype.double = function read_double() {

	    /* istanbul ignore if */
	    if (this.pos + 8 > this.len)
	        throw indexOutOfRange(this, 4);

	    var value = util.float.readDoubleLE(this.buf, this.pos);
	    this.pos += 8;
	    return value;
	};

	/**
	 * Reads a sequence of bytes preceeded by its length as a varint.
	 * @returns {Uint8Array} Value read
	 */
	Reader.prototype.bytes = function read_bytes() {
	    var length = this.uint32(),
	        start  = this.pos,
	        end    = this.pos + length;

	    /* istanbul ignore if */
	    if (end > this.len)
	        throw indexOutOfRange(this, length);

	    this.pos += length;
	    if (Array.isArray(this.buf)) // plain array
	        return this.buf.slice(start, end);
	    return start === end // fix for IE 10/Win8 and others' subarray returning array of size 1
	        ? new this.buf.constructor(0)
	        : this._slice.call(this.buf, start, end);
	};

	/**
	 * Reads a string preceeded by its byte length as a varint.
	 * @returns {string} Value read
	 */
	Reader.prototype.string = function read_string() {
	    var bytes = this.bytes();
	    return utf8.read(bytes, 0, bytes.length);
	};

	/**
	 * Skips the specified number of bytes if specified, otherwise skips a varint.
	 * @param {number} [length] Length if known, otherwise a varint is assumed
	 * @returns {Reader} `this`
	 */
	Reader.prototype.skip = function skip(length) {
	    if (typeof length === "number") {
	        /* istanbul ignore if */
	        if (this.pos + length > this.len)
	            throw indexOutOfRange(this, length);
	        this.pos += length;
	    } else {
	        do {
	            /* istanbul ignore if */
	            if (this.pos >= this.len)
	                throw indexOutOfRange(this);
	        } while (this.buf[this.pos++] & 128);
	    }
	    return this;
	};

	/**
	 * Skips the next element of the specified wire type.
	 * @param {number} wireType Wire type received
	 * @returns {Reader} `this`
	 */
	Reader.prototype.skipType = function(wireType) {
	    switch (wireType) {
	        case 0:
	            this.skip();
	            break;
	        case 1:
	            this.skip(8);
	            break;
	        case 2:
	            this.skip(this.uint32());
	            break;
	        case 3:
	            while ((wireType = this.uint32() & 7) !== 4) {
	                this.skipType(wireType);
	            }
	            break;
	        case 5:
	            this.skip(4);
	            break;

	        /* istanbul ignore next */
	        default:
	            throw Error("invalid wire type " + wireType + " at offset " + this.pos);
	    }
	    return this;
	};

	Reader._configure = function(BufferReader_) {
	    BufferReader = BufferReader_;
	    Reader.create = create();
	    BufferReader._configure();

	    var fn = util.Long ? "toLong" : /* istanbul ignore next */ "toNumber";
	    util.merge(Reader.prototype, {

	        int64: function read_int64() {
	            return readLongVarint.call(this)[fn](false);
	        },

	        uint64: function read_uint64() {
	            return readLongVarint.call(this)[fn](true);
	        },

	        sint64: function read_sint64() {
	            return readLongVarint.call(this).zzDecode()[fn](false);
	        },

	        fixed64: function read_fixed64() {
	            return readFixed64.call(this)[fn](true);
	        },

	        sfixed64: function read_sfixed64() {
	            return readFixed64.call(this)[fn](false);
	        }

	    });
	};
	return reader;
}

var reader_buffer;
var hasRequiredReader_buffer;

function requireReader_buffer () {
	if (hasRequiredReader_buffer) return reader_buffer;
	hasRequiredReader_buffer = 1;
	reader_buffer = BufferReader;

	// extends Reader
	var Reader = requireReader();
	(BufferReader.prototype = Object.create(Reader.prototype)).constructor = BufferReader;

	var util = requireMinimal$1();

	/**
	 * Constructs a new buffer reader instance.
	 * @classdesc Wire format reader using node buffers.
	 * @extends Reader
	 * @constructor
	 * @param {Buffer} buffer Buffer to read from
	 */
	function BufferReader(buffer) {
	    Reader.call(this, buffer);

	    /**
	     * Read buffer.
	     * @name BufferReader#buf
	     * @type {Buffer}
	     */
	}

	BufferReader._configure = function () {
	    /* istanbul ignore else */
	    if (util.Buffer)
	        BufferReader.prototype._slice = util.Buffer.prototype.slice;
	};


	/**
	 * @override
	 */
	BufferReader.prototype.string = function read_string_buffer() {
	    var len = this.uint32(); // modifies pos
	    return this.buf.utf8Slice
	        ? this.buf.utf8Slice(this.pos, this.pos = Math.min(this.pos + len, this.len))
	        : this.buf.toString("utf-8", this.pos, this.pos = Math.min(this.pos + len, this.len));
	};

	/**
	 * Reads a sequence of bytes preceeded by its length as a varint.
	 * @name BufferReader#bytes
	 * @function
	 * @returns {Buffer} Value read
	 */

	BufferReader._configure();
	return reader_buffer;
}

var rpc = {};

var service;
var hasRequiredService;

function requireService () {
	if (hasRequiredService) return service;
	hasRequiredService = 1;
	service = Service;

	var util = requireMinimal$1();

	// Extends EventEmitter
	(Service.prototype = Object.create(util.EventEmitter.prototype)).constructor = Service;

	/**
	 * A service method callback as used by {@link rpc.ServiceMethod|ServiceMethod}.
	 *
	 * Differs from {@link RPCImplCallback} in that it is an actual callback of a service method which may not return `response = null`.
	 * @typedef rpc.ServiceMethodCallback
	 * @template TRes extends Message<TRes>
	 * @type {function}
	 * @param {Error|null} error Error, if any
	 * @param {TRes} [response] Response message
	 * @returns {undefined}
	 */

	/**
	 * A service method part of a {@link rpc.Service} as created by {@link Service.create}.
	 * @typedef rpc.ServiceMethod
	 * @template TReq extends Message<TReq>
	 * @template TRes extends Message<TRes>
	 * @type {function}
	 * @param {TReq|Properties<TReq>} request Request message or plain object
	 * @param {rpc.ServiceMethodCallback<TRes>} [callback] Node-style callback called with the error, if any, and the response message
	 * @returns {Promise<Message<TRes>>} Promise if `callback` has been omitted, otherwise `undefined`
	 */

	/**
	 * Constructs a new RPC service instance.
	 * @classdesc An RPC service as returned by {@link Service#create}.
	 * @exports rpc.Service
	 * @extends util.EventEmitter
	 * @constructor
	 * @param {RPCImpl} rpcImpl RPC implementation
	 * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
	 * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
	 */
	function Service(rpcImpl, requestDelimited, responseDelimited) {

	    if (typeof rpcImpl !== "function")
	        throw TypeError("rpcImpl must be a function");

	    util.EventEmitter.call(this);

	    /**
	     * RPC implementation. Becomes `null` once the service is ended.
	     * @type {RPCImpl|null}
	     */
	    this.rpcImpl = rpcImpl;

	    /**
	     * Whether requests are length-delimited.
	     * @type {boolean}
	     */
	    this.requestDelimited = Boolean(requestDelimited);

	    /**
	     * Whether responses are length-delimited.
	     * @type {boolean}
	     */
	    this.responseDelimited = Boolean(responseDelimited);
	}

	/**
	 * Calls a service method through {@link rpc.Service#rpcImpl|rpcImpl}.
	 * @param {Method|rpc.ServiceMethod<TReq,TRes>} method Reflected or static method
	 * @param {Constructor<TReq>} requestCtor Request constructor
	 * @param {Constructor<TRes>} responseCtor Response constructor
	 * @param {TReq|Properties<TReq>} request Request message or plain object
	 * @param {rpc.ServiceMethodCallback<TRes>} callback Service callback
	 * @returns {undefined}
	 * @template TReq extends Message<TReq>
	 * @template TRes extends Message<TRes>
	 */
	Service.prototype.rpcCall = function rpcCall(method, requestCtor, responseCtor, request, callback) {

	    if (!request)
	        throw TypeError("request must be specified");

	    var self = this;
	    if (!callback)
	        return util.asPromise(rpcCall, self, method, requestCtor, responseCtor, request);

	    if (!self.rpcImpl) {
	        setTimeout(function() { callback(Error("already ended")); }, 0);
	        return undefined;
	    }

	    try {
	        return self.rpcImpl(
	            method,
	            requestCtor[self.requestDelimited ? "encodeDelimited" : "encode"](request).finish(),
	            function rpcCallback(err, response) {

	                if (err) {
	                    self.emit("error", err, method);
	                    return callback(err);
	                }

	                if (response === null) {
	                    self.end(/* endedByRPC */ true);
	                    return undefined;
	                }

	                if (!(response instanceof responseCtor)) {
	                    try {
	                        response = responseCtor[self.responseDelimited ? "decodeDelimited" : "decode"](response);
	                    } catch (err) {
	                        self.emit("error", err, method);
	                        return callback(err);
	                    }
	                }

	                self.emit("data", response, method);
	                return callback(null, response);
	            }
	        );
	    } catch (err) {
	        self.emit("error", err, method);
	        setTimeout(function() { callback(err); }, 0);
	        return undefined;
	    }
	};

	/**
	 * Ends this service and emits the `end` event.
	 * @param {boolean} [endedByRPC=false] Whether the service has been ended by the RPC implementation.
	 * @returns {rpc.Service} `this`
	 */
	Service.prototype.end = function end(endedByRPC) {
	    if (this.rpcImpl) {
	        if (!endedByRPC) // signal end to rpcImpl
	            this.rpcImpl(null, null, null);
	        this.rpcImpl = null;
	        this.emit("end").off();
	    }
	    return this;
	};
	return service;
}

var hasRequiredRpc;

function requireRpc () {
	if (hasRequiredRpc) return rpc;
	hasRequiredRpc = 1;
	(function (exports) {

		/**
		 * Streaming RPC helpers.
		 * @namespace
		 */
		var rpc = exports;

		/**
		 * RPC implementation passed to {@link Service#create} performing a service request on network level, i.e. by utilizing http requests or websockets.
		 * @typedef RPCImpl
		 * @type {function}
		 * @param {Method|rpc.ServiceMethod<Message<{}>,Message<{}>>} method Reflected or static method being called
		 * @param {Uint8Array} requestData Request data
		 * @param {RPCImplCallback} callback Callback function
		 * @returns {undefined}
		 * @example
		 * function rpcImpl(method, requestData, callback) {
		 *     if (protobuf.util.lcFirst(method.name) !== "myMethod") // compatible with static code
		 *         throw Error("no such method");
		 *     asynchronouslyObtainAResponse(requestData, function(err, responseData) {
		 *         callback(err, responseData);
		 *     });
		 * }
		 */

		/**
		 * Node-style callback as used by {@link RPCImpl}.
		 * @typedef RPCImplCallback
		 * @type {function}
		 * @param {Error|null} error Error, if any, otherwise `null`
		 * @param {Uint8Array|null} [response] Response data or `null` to signal end of stream, if there hasn't been an error
		 * @returns {undefined}
		 */

		rpc.Service = requireService();
} (rpc));
	return rpc;
}

var roots;
var hasRequiredRoots;

function requireRoots () {
	if (hasRequiredRoots) return roots;
	hasRequiredRoots = 1;
	roots = {};

	/**
	 * Named roots.
	 * This is where pbjs stores generated structures (the option `-r, --root` specifies a name).
	 * Can also be used manually to make roots available accross modules.
	 * @name roots
	 * @type {Object.<string,Root>}
	 * @example
	 * // pbjs -r myroot -o compiled.js ...
	 *
	 * // in another module:
	 * require("./compiled.js");
	 *
	 * // in any subsequent module:
	 * var root = protobuf.roots["myroot"];
	 */
	return roots;
}

var hasRequiredIndexMinimal;

function requireIndexMinimal () {
	if (hasRequiredIndexMinimal) return indexMinimal;
	hasRequiredIndexMinimal = 1;
	(function (exports) {
		var protobuf = exports;

		/**
		 * Build type, one of `"full"`, `"light"` or `"minimal"`.
		 * @name build
		 * @type {string}
		 * @const
		 */
		protobuf.build = "minimal";

		// Serialization
		protobuf.Writer       = requireWriter();
		protobuf.BufferWriter = requireWriter_buffer();
		protobuf.Reader       = requireReader();
		protobuf.BufferReader = requireReader_buffer();

		// Utility
		protobuf.util         = requireMinimal$1();
		protobuf.rpc          = requireRpc();
		protobuf.roots        = requireRoots();
		protobuf.configure    = configure;

		/* istanbul ignore next */
		/**
		 * Reconfigures the library according to the environment.
		 * @returns {undefined}
		 */
		function configure() {
		    protobuf.util._configure();
		    protobuf.Writer._configure(protobuf.BufferWriter);
		    protobuf.Reader._configure(protobuf.BufferReader);
		}

		// Set up buffer utility according to the environment
		configure();
} (indexMinimal));
	return indexMinimal;
}

var hasRequiredMinimal;

function requireMinimal () {
	if (hasRequiredMinimal) return minimalExports;
	hasRequiredMinimal = 1;
	(function (module) {
		module.exports = requireIndexMinimal();
} (minimal$1));
	return minimalExports;
}

var deferred = {};

var hasRequiredDeferred;

function requireDeferred () {
	if (hasRequiredDeferred) return deferred;
	hasRequiredDeferred = 1;
	// Copyright (C) 2018 The Android Open Source Project
	//
	// Licensed under the Apache License, Version 2.0 (the "License");
	// you may not use this file except in compliance with the License.
	// You may obtain a copy of the License at
	//
	//      http://www.apache.org/licenses/LICENSE-2.0
	//
	// Unless required by applicable law or agreed to in writing, software
	// distributed under the License is distributed on an "AS IS" BASIS,
	// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	// See the License for the specific language governing permissions and
	// limitations under the License.
	Object.defineProperty(deferred, "__esModule", { value: true });
	deferred.defer = void 0;
	// Create a promise with exposed resolve and reject callbacks.
	function defer() {
	    let resolve = null;
	    let reject = null;
	    const p = new Promise((res, rej) => [resolve, reject] = [res, rej]);
	    return Object.assign(p, { resolve, reject });
	}
	deferred.defer = defer;
	
	return deferred;
}

var logging = {};

var perfetto_version = {};

var hasRequiredPerfetto_version;

function requirePerfetto_version () {
	if (hasRequiredPerfetto_version) return perfetto_version;
	hasRequiredPerfetto_version = 1;
	Object.defineProperty(perfetto_version, "__esModule", { value: true });
	perfetto_version.SCM_REVISION = perfetto_version.VERSION = void 0;
	perfetto_version.VERSION = "v34.0-16f63abe3";
	perfetto_version.SCM_REVISION = "16f63abe33753ce31d9b29e3a4281a5435773fc7";
	
	return perfetto_version;
}

var hasRequiredLogging;

function requireLogging () {
	if (hasRequiredLogging) return logging;
	hasRequiredLogging = 1;
	// Copyright (C) 2018 The Android Open Source Project
	//
	// Licensed under the Apache License, Version 2.0 (the "License");
	// you may not use this file except in compliance with the License.
	// You may obtain a copy of the License at
	//
	//      http://www.apache.org/licenses/LICENSE-2.0
	//
	// Unless required by applicable law or agreed to in writing, software
	// distributed under the License is distributed on an "AS IS" BASIS,
	// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	// See the License for the specific language governing permissions and
	// limitations under the License.
	Object.defineProperty(logging, "__esModule", { value: true });
	logging.assertUnreachable = logging.reportError = logging.setErrorHandler = logging.assertFalse = logging.assertTrue = logging.assertExists = void 0;
	const perfetto_version_1 = requirePerfetto_version();
	let errorHandler = (_) => { };
	function assertExists(value) {
	    if (value === null || value === undefined) {
	        throw new Error('Value doesn\'t exist');
	    }
	    return value;
	}
	logging.assertExists = assertExists;
	function assertTrue(value, optMsg) {
	    if (!value) {
	        throw new Error(optMsg ?? 'Failed assertion');
	    }
	}
	logging.assertTrue = assertTrue;
	function assertFalse(value, optMsg) {
	    assertTrue(!value, optMsg);
	}
	logging.assertFalse = assertFalse;
	function setErrorHandler(handler) {
	    errorHandler = handler;
	}
	logging.setErrorHandler = setErrorHandler;
	function reportError(err) {
	    let errLog = '';
	    let errorObj = undefined;
	    if (err instanceof ErrorEvent) {
	        errLog = err.message;
	        errorObj = err.error;
	    }
	    else if (err instanceof PromiseRejectionEvent) {
	        errLog = `${err.reason}`;
	        errorObj = err.reason;
	    }
	    else {
	        errLog = `${err}`;
	    }
	    if (errorObj !== undefined && errorObj !== null) {
	        const errStack = errorObj.stack;
	        errLog += '\n';
	        errLog += errStack !== undefined ? errStack : JSON.stringify(errorObj);
	    }
	    errLog += '\n\n';
	    errLog += `${perfetto_version_1.VERSION} ${perfetto_version_1.SCM_REVISION}\n`;
	    errLog += `UA: ${navigator.userAgent}\n`;
	    console.error(errLog, err);
	    errorHandler(errLog);
	}
	logging.reportError = reportError;
	// This function serves two purposes.
	// 1) A runtime check - if we are ever called, we throw an exception.
	// This is useful for checking that code we suspect should never be reached is
	// actually never reached.
	// 2) A compile time check where typescript asserts that the value passed can be
	// cast to the "never" type.
	// This is useful for ensuring we exhastively check union types.
	function assertUnreachable(_x) {
	    throw new Error('This code should not be reachable');
	}
	logging.assertUnreachable = assertUnreachable;
	
	return logging;
}

var string_utils = {};

var hasRequiredString_utils;

function requireString_utils () {
	if (hasRequiredString_utils) return string_utils;
	hasRequiredString_utils = 1;
	// Copyright (C) 2019 The Android Open Source Project
	//
	// Licensed under the Apache License, Version 2.0 (the "License");
	// you may not use this file except in compliance with the License.
	// You may obtain a copy of the License at
	//
	//      http://www.apache.org/licenses/LICENSE-2.0
	//
	// Unless required by applicable law or agreed to in writing, software
	// distributed under the License is distributed on an "AS IS" BASIS,
	// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	// See the License for the specific language governing permissions and
	// limitations under the License.
	Object.defineProperty(string_utils, "__esModule", { value: true });
	string_utils.sqliteString = string_utils.binaryDecode = string_utils.binaryEncode = string_utils.utf8Decode = string_utils.utf8Encode = string_utils.hexEncode = string_utils.base64Decode = string_utils.base64Encode = void 0;
	const base64_1 = requireBase64();
	const utf8_1 = requireUtf8();
	const logging_1 = requireLogging();
	// TextDecoder/Decoder requires the full DOM and isn't available in all types
	// of tests. Use fallback implementation from protbufjs.
	let Utf8Decoder;
	let Utf8Encoder;
	try {
	    Utf8Decoder = new TextDecoder('utf-8');
	    Utf8Encoder = new TextEncoder();
	}
	catch (_) {
	    if (typeof process === 'undefined') {
	        // Silence the warning when we know we are running under NodeJS.
	        console.warn('Using fallback UTF8 Encoder/Decoder, This should happen only in ' +
	            'tests and NodeJS-based environments, not in browsers.');
	    }
	    Utf8Decoder = { decode: (buf) => (0, utf8_1.read)(buf, 0, buf.length) };
	    Utf8Encoder = {
	        encode: (str) => {
	            const arr = new Uint8Array((0, utf8_1.length)(str));
	            const written = (0, utf8_1.write)(str, arr, 0);
	            (0, logging_1.assertTrue)(written === arr.length);
	            return arr;
	        },
	    };
	}
	function base64Encode(buffer) {
	    return (0, base64_1.encode)(buffer, 0, buffer.length);
	}
	string_utils.base64Encode = base64Encode;
	function base64Decode(str) {
	    // if the string is in base64url format, convert to base64
	    const b64 = str.replace(/-/g, '+').replace(/_/g, '/');
	    const arr = new Uint8Array((0, base64_1.length)(b64));
	    const written = (0, base64_1.decode)(b64, arr, 0);
	    (0, logging_1.assertTrue)(written === arr.length);
	    return arr;
	}
	string_utils.base64Decode = base64Decode;
	// encode binary array to hex string
	function hexEncode(bytes) {
	    return bytes.reduce((prev, cur) => prev + ('0' + cur.toString(16)).slice(-2), '');
	}
	string_utils.hexEncode = hexEncode;
	function utf8Encode(str) {
	    return Utf8Encoder.encode(str);
	}
	string_utils.utf8Encode = utf8Encode;
	// Note: not all byte sequences can be converted to<>from UTF8. This can be
	// used only with valid unicode strings, not arbitrary byte buffers.
	function utf8Decode(buffer) {
	    return Utf8Decoder.decode(buffer);
	}
	string_utils.utf8Decode = utf8Decode;
	// The binaryEncode/Decode functions below allow to encode an arbitrary binary
	// buffer into a string that can be JSON-encoded. binaryEncode() applies
	// UTF-16 encoding to each byte individually.
	// Unlike utf8Encode/Decode, any arbitrary byte sequence can be converted into a
	// valid string, and viceversa.
	// This should be only used when a byte array needs to be transmitted over an
	// interface that supports only JSON serialization (e.g., postmessage to a
	// chrome extension).
	function binaryEncode(buf) {
	    let str = '';
	    for (let i = 0; i < buf.length; i++) {
	        str += String.fromCharCode(buf[i]);
	    }
	    return str;
	}
	string_utils.binaryEncode = binaryEncode;
	function binaryDecode(str) {
	    const buf = new Uint8Array(str.length);
	    const strLen = str.length;
	    for (let i = 0; i < strLen; i++) {
	        buf[i] = str.charCodeAt(i);
	    }
	    return buf;
	}
	string_utils.binaryDecode = binaryDecode;
	// A function used to interpolate strings into SQL query. The only replacement
	// is done is that single quote replaced with two single quotes, according to
	// SQLite documentation:
	// https://www.sqlite.org/lang_expr.html#literal_values_constants_
	//
	// The purpose of this function is to use in simple comparisons, to escape
	// strings used in GLOB clauses see escapeQuery function.
	function sqliteString(str) {
	    return `'${str.replace(/'/g, '\'\'')}'`;
	}
	string_utils.sqliteString = sqliteString;
	
	return string_utils;
}

var hasRequiredQuery_result;

function requireQuery_result () {
	if (hasRequiredQuery_result) return query_result;
	hasRequiredQuery_result = 1;
	(function (exports) {
		// Copyright (C) 2021 The Android Open Source Project
		//
		// Licensed under the Apache License, Version 2.0 (the "License");
		// you may not use this file except in compliance with the License.
		// You may obtain a copy of the License at
		//
		//      http://www.apache.org/licenses/LICENSE-2.0
		//
		// Unless required by applicable law or agreed to in writing, software
		// distributed under the License is distributed on an "AS IS" BASIS,
		// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
		// See the License for the specific language governing permissions and
		// limitations under the License.
		Object.defineProperty(exports, "__esModule", { value: true });
		exports.createQueryResult = exports.QueryError = exports.decodeInt64Varint = exports.LONG_NULL = exports.LONG = exports.BLOB_NULL = exports.BLOB = exports.STR_NULL = exports.NUM_NULL = exports.STR = exports.NUM = void 0;
		const tslib_1 = require$$0$1;
		// This file deals with deserialization and iteration of the proto-encoded
		// byte buffer that is returned by TraceProcessor when invoking the
		// TPM_QUERY_STREAMING method. The returned |query_result| buffer is optimized
		// for being moved cheaply across workers and decoded on-the-flight as we step
		// through the iterator.
		// See comments around QueryResult in trace_processor.proto for more details.
		// The classes in this file are organized as follows:
		//
		// QueryResultImpl:
		// The object returned by the Engine.query(sql) method.
		// This object is a holder of row data. Batches of raw get appended
		// incrementally as they are received by the remote TraceProcessor instance.
		// QueryResultImpl also deals with asynchronicity of queries and allows callers
		// to obtain a promise that waits for more (or all) rows.
		// At any point in time the following objects hold a reference to QueryResult:
		// - The Engine: for appending row batches.
		// - UI code, typically controllers, who make queries.
		//
		// ResultBatch:
		// Hold the data, returned by the remote TraceProcessor instance, for a number
		// of rows (TP typically chunks the results in batches of 128KB).
		// A QueryResultImpl holds exclusively ResultBatches for a given query.
		// ResultBatch is not exposed externally, it's just an internal representation
		// that helps with proto decoding. ResultBatch is immutable after it gets
		// appended and decoded. The iteration state is held by the RowIteratorImpl.
		//
		// RowIteratorImpl:
		// Decouples the data owned by QueryResultImpl (and its ResultBatch(es)) from
		// the iteration state. The iterator effectively is the union of a ResultBatch
		// and the row number in it. Rows within the batch are decoded as the user calls
		// next(). When getting at the end of the batch, it takes care of switching to
		// the next batch (if any) within the QueryResultImpl.
		// This object is part of the API exposed to tracks / controllers.
		const minimal_1 = tslib_1.__importDefault(requireMinimal());
		// Disable Long.js support in protobuf. This seems to be enabled only in tests
		// but not in production code. In any case, for now we want casting to number
		// accepting the 2**53 limitation. This is consistent with passing
		// --force-number in the protobuf.js codegen invocation in //ui/BUILD.gn .
		// See also https://github.com/protobufjs/protobuf.js/issues/1253 .
		minimal_1.default.util.Long = undefined;
		minimal_1.default.configure();
		const deferred_1 = requireDeferred();
		const logging_1 = requireLogging();
		const string_utils_1 = requireString_utils();
		exports.NUM = 0;
		exports.STR = 'str';
		exports.NUM_NULL = 1;
		exports.STR_NULL = 'str_null';
		exports.BLOB = new Uint8Array();
		exports.BLOB_NULL = new Uint8Array();
		exports.LONG = 0n;
		exports.LONG_NULL = 1n;
		const SHIFT_32BITS = 32n;
		// Fast decode varint int64 into a bigint
		// Inspired by
		// https://github.com/protobufjs/protobuf.js/blob/56b1e64979dae757b67a21d326e16acee39f2267/src/reader.js#L123
		function decodeInt64Varint(buf, pos) {
		    let hi = 0;
		    let lo = 0;
		    let i = 0;
		    if (buf.length - pos > 4) { // fast route (lo)
		        for (; i < 4; ++i) {
		            // 1st..4th
		            lo = (lo | (buf[pos] & 127) << i * 7) >>> 0;
		            if (buf[pos++] < 128) {
		                return BigInt(lo);
		            }
		        }
		        // 5th
		        lo = (lo | (buf[pos] & 127) << 28) >>> 0;
		        hi = (hi | (buf[pos] & 127) >> 4) >>> 0;
		        if (buf[pos++] < 128) {
		            return BigInt(hi) << SHIFT_32BITS | BigInt(lo);
		        }
		        i = 0;
		    }
		    else {
		        for (; i < 3; ++i) {
		            if (pos >= buf.length) {
		                throw Error('Index out of range');
		            }
		            // 1st..3rd
		            lo = (lo | (buf[pos] & 127) << i * 7) >>> 0;
		            if (buf[pos++] < 128) {
		                return BigInt(lo);
		            }
		        }
		        // 4th
		        lo = (lo | (buf[pos++] & 127) << i * 7) >>> 0;
		        return BigInt(hi) << SHIFT_32BITS | BigInt(lo);
		    }
		    if (buf.length - pos > 4) { // fast route (hi)
		        for (; i < 5; ++i) {
		            // 6th..10th
		            hi = (hi | (buf[pos] & 127) << i * 7 + 3) >>> 0;
		            if (buf[pos++] < 128) {
		                const big = BigInt(hi) << SHIFT_32BITS | BigInt(lo);
		                return BigInt.asIntN(64, big);
		            }
		        }
		    }
		    else {
		        for (; i < 5; ++i) {
		            if (pos >= buf.length) {
		                throw Error('Index out of range');
		            }
		            // 6th..10th
		            hi = (hi | (buf[pos] & 127) << i * 7 + 3) >>> 0;
		            if (buf[pos++] < 128) {
		                const big = BigInt(hi) << SHIFT_32BITS | BigInt(lo);
		                return BigInt.asIntN(64, big);
		            }
		        }
		    }
		    throw Error('invalid varint encoding');
		}
		exports.decodeInt64Varint = decodeInt64Varint;
		class QueryError extends Error {
		    constructor(message, info) {
		        super(message);
		        this.query = info.query;
		    }
		    toString() {
		        return `Query: ${this.query}\n` + super.toString();
		    }
		}
		exports.QueryError = QueryError;
		function columnTypeToString(t) {
		    switch (t) {
		        case exports.NUM:
		            return 'NUM';
		        case exports.NUM_NULL:
		            return 'NUM_NULL';
		        case exports.STR:
		            return 'STR';
		        case exports.STR_NULL:
		            return 'STR_NULL';
		        case exports.BLOB:
		            return 'BLOB';
		        case exports.BLOB_NULL:
		            return 'BLOB_NULL';
		        case exports.LONG:
		            return 'LONG';
		        case exports.LONG_NULL:
		            return 'LONG_NULL';
		        default:
		            return `INVALID(${t})`;
		    }
		}
		function isCompatible(actual, expected) {
		    switch (actual) {
		        case CellType.CELL_NULL:
		            return expected === exports.NUM_NULL || expected === exports.STR_NULL ||
		                expected === exports.BLOB_NULL || expected === exports.LONG_NULL;
		        case CellType.CELL_VARINT:
		            return expected === exports.NUM || expected === exports.NUM_NULL || expected === exports.LONG ||
		                expected === exports.LONG_NULL;
		        case CellType.CELL_FLOAT64:
		            return expected === exports.NUM || expected === exports.NUM_NULL;
		        case CellType.CELL_STRING:
		            return expected === exports.STR || expected === exports.STR_NULL;
		        case CellType.CELL_BLOB:
		            return expected === exports.BLOB || expected === exports.BLOB_NULL;
		        default:
		            throw new Error(`Unknown CellType ${actual}`);
		    }
		}
		// This has to match CellType in trace_processor.proto.
		var CellType;
		(function (CellType) {
		    CellType[CellType["CELL_NULL"] = 1] = "CELL_NULL";
		    CellType[CellType["CELL_VARINT"] = 2] = "CELL_VARINT";
		    CellType[CellType["CELL_FLOAT64"] = 3] = "CELL_FLOAT64";
		    CellType[CellType["CELL_STRING"] = 4] = "CELL_STRING";
		    CellType[CellType["CELL_BLOB"] = 5] = "CELL_BLOB";
		})(CellType || (CellType = {}));
		const CELL_TYPE_NAMES = ['UNKNOWN', 'NULL', 'VARINT', 'FLOAT64', 'STRING', 'BLOB'];
		const TAG_LEN_DELIM = 2;
		// The actual implementation, which bridges together the reader side and the
		// writer side (the one exposed to the Engine). This is the same object so that
		// when the engine pumps new row batches we can resolve pending promises that
		// readers (e.g. track code) are waiting for.
		class QueryResultImpl {
		    constructor(errorInfo) {
		        this.columnNames = [];
		        this._numRows = 0;
		        this._isComplete = false;
		        this._statementCount = 0;
		        this._statementWithOutputCount = 0;
		        // --- QueryResult implementation.
		        // TODO(primiano): for the moment new batches are appended but old batches
		        // are never removed. This won't work with abnormally large result sets, as
		        // it will stash all rows in memory. We could switch to a model where the
		        // iterator is destructive and deletes batch objects once iterating past the
		        // end of each batch. If we do that, than we need to assign monotonic IDs to
		        // batches. Also if we do that, we should prevent creating more than one
		        // iterator for a QueryResult.
		        this.batches = [];
		        this._errorInfo = errorInfo;
		    }
		    isComplete() {
		        return this._isComplete;
		    }
		    numRows() {
		        return this._numRows;
		    }
		    error() {
		        return this._error;
		    }
		    columns() {
		        return this.columnNames;
		    }
		    statementCount() {
		        return this._statementCount;
		    }
		    statementWithOutputCount() {
		        return this._statementWithOutputCount;
		    }
		    iter(spec) {
		        const impl = new RowIteratorImplWithRowData(spec, this);
		        return impl;
		    }
		    firstRow(spec) {
		        const impl = new RowIteratorImplWithRowData(spec, this);
		        (0, logging_1.assertTrue)(impl.valid());
		        return impl;
		    }
		    // Can be called only once.
		    waitAllRows() {
		        (0, logging_1.assertTrue)(this.allRowsPromise === undefined);
		        this.allRowsPromise = (0, deferred_1.defer)();
		        if (this._isComplete) {
		            this.resolveOrReject(this.allRowsPromise, this);
		        }
		        return this.allRowsPromise;
		    }
		    waitMoreRows() {
		        if (this.moreRowsPromise !== undefined) {
		            return this.moreRowsPromise;
		        }
		        const moreRowsPromise = (0, deferred_1.defer)();
		        if (this._isComplete) {
		            this.resolveOrReject(moreRowsPromise, this);
		        }
		        else {
		            this.moreRowsPromise = moreRowsPromise;
		        }
		        return moreRowsPromise;
		    }
		    // --- WritableQueryResult implementation.
		    // Called by the engine when a new QueryResult is available. Note that a
		    // single Query() call can yield >1 QueryResult due to result batching
		    // if more than ~64K of data are returned, e.g. when returning O(M) rows.
		    // |resBytes| is a proto-encoded trace_processor.QueryResult message.
		    // It is fine to retain the resBytes without slicing a copy, because
		    // ProtoRingBuffer does the slice() for us (or passes through the buffer
		    // coming from postMessage() (Wasm case) of fetch() (HTTP+RPC case).
		    appendResultBatch(resBytes) {
		        const reader = minimal_1.default.Reader.create(resBytes);
		        (0, logging_1.assertTrue)(reader.pos === 0);
		        const columnNamesEmptyAtStartOfBatch = this.columnNames.length === 0;
		        const columnNamesSet = new Set();
		        while (reader.pos < reader.len) {
		            const tag = reader.uint32();
		            switch (tag >>> 3) {
		                case 1: // column_names
		                    // Only the first batch should contain the column names. If this fires
		                    // something is going wrong in the handling of the batch stream.
		                    (0, logging_1.assertTrue)(columnNamesEmptyAtStartOfBatch);
		                    const origColName = reader.string();
		                    let colName = origColName;
		                    // In some rare cases two columns can have the same name (b/194891824)
		                    // e.g. `select 1 as x, 2 as x`. These queries don't happen in the
		                    // UI code, but they can happen when the user types a query (e.g.
		                    // with a join). The most practical thing we can do here is renaming
		                    // the columns with a suffix. Keeping the same name will break when
		                    // iterating, because column names become iterator object keys.
		                    for (let i = 1; columnNamesSet.has(colName); ++i) {
		                        colName = `${origColName}_${i}`;
		                        (0, logging_1.assertTrue)(i < 100); // Give up at some point;
		                    }
		                    columnNamesSet.add(colName);
		                    this.columnNames.push(colName);
		                    break;
		                case 2: // error
		                    // The query has errored only if the |error| field is non-empty.
		                    // In protos, we don't distinguish between non-present and empty.
		                    // Make sure we don't propagate ambiguous empty strings to JS.
		                    const err = reader.string();
		                    this._error = (err !== undefined && err.length) ? err : undefined;
		                    break;
		                case 3: // batch
		                    const batchLen = reader.uint32();
		                    const batchRaw = resBytes.subarray(reader.pos, reader.pos + batchLen);
		                    reader.pos += batchLen;
		                    // The ResultBatch ctor parses the CellsBatch submessage.
		                    const parsedBatch = new ResultBatch(batchRaw);
		                    this.batches.push(parsedBatch);
		                    this._isComplete = parsedBatch.isLastBatch;
		                    // In theory one could construct a valid proto serializing the column
		                    // names after the cell batches. In practice the QueryResultSerializer
		                    // doesn't do that so it's not worth complicating the code.
		                    const numColumns = this.columnNames.length;
		                    if (numColumns !== 0) {
		                        (0, logging_1.assertTrue)(parsedBatch.numCells % numColumns === 0);
		                        this._numRows += parsedBatch.numCells / numColumns;
		                    }
		                    else {
		                        // numColumns == 0 is  plausible for queries like CREATE TABLE ... .
		                        (0, logging_1.assertTrue)(parsedBatch.numCells === 0);
		                    }
		                    break;
		                case 4:
		                    this._statementCount = reader.uint32();
		                    break;
		                case 5:
		                    this._statementWithOutputCount = reader.uint32();
		                    break;
		                default:
		                    console.warn(`Unexpected QueryResult field ${tag >>> 3}`);
		                    reader.skipType(tag & 7);
		                    break;
		            } // switch (tag)
		        } // while (pos < end)
		        if (this.moreRowsPromise !== undefined) {
		            this.resolveOrReject(this.moreRowsPromise, this);
		            this.moreRowsPromise = undefined;
		        }
		        if (this._isComplete && this.allRowsPromise !== undefined) {
		            this.resolveOrReject(this.allRowsPromise, this);
		        }
		    }
		    ensureAllRowsPromise() {
		        if (this.allRowsPromise === undefined) {
		            this.waitAllRows(); // Will populate |this.allRowsPromise|.
		        }
		        return (0, logging_1.assertExists)(this.allRowsPromise);
		    }
		    resolveOrReject(promise, arg) {
		        if (this._error === undefined) {
		            promise.resolve(arg);
		        }
		        else {
		            promise.reject(new QueryError(this._error, this._errorInfo));
		        }
		    }
		}
		// This class holds onto a received result batch (a Uint8Array) and does some
		// partial parsing to tokenize the various cell groups. This parsing mainly
		// consists of identifying and caching the offsets of each cell group and
		// initializing the varint decoders. This half parsing is done to keep the
		// iterator's next() fast, without decoding everything into memory.
		// This is an internal implementation detail and is not exposed outside. The
		// RowIteratorImpl uses this class to iterate through batches (this class takes
		// care of iterating within a batch, RowIteratorImpl takes care of switching
		// batches when needed).
		// Note: at any point in time there can be more than one ResultIterator
		// referencing the same batch. The batch must be immutable.
		class ResultBatch {
		    // batchBytes is a trace_processor.QueryResult.CellsBatch proto.
		    constructor(batchBytes) {
		        this.isLastBatch = false;
		        this.cellTypesOff = 0;
		        this.cellTypesLen = 0;
		        this.varintOff = 0;
		        this.varintLen = 0;
		        this.float64Cells = new Float64Array();
		        this.blobCells = [];
		        this.stringCells = [];
		        this.batchBytes = batchBytes;
		        const reader = minimal_1.default.Reader.create(batchBytes);
		        (0, logging_1.assertTrue)(reader.pos === 0);
		        const end = reader.len;
		        // Here we deconstruct the proto by hand. The CellsBatch is carefully
		        // designed to allow a very fast parsing from the TS side. We pack all cells
		        // of the same types together, so we can do only one call (per batch) to
		        // TextDecoder.decode(), we can overlay a memory-aligned typedarray for
		        // float values and can quickly tell and type-check the cell types.
		        // One row = N cells (we know the number upfront from the outer message).
		        // Each bach contains always an integer multiple of N cells (i.e. rows are
		        // never fragmented across different batches).
		        while (reader.pos < end) {
		            const tag = reader.uint32();
		            switch (tag >>> 3) {
		                case 1: // cell types, a packed array containing one CellType per cell.
		                    (0, logging_1.assertTrue)((tag & 7) === TAG_LEN_DELIM); // Must be packed varint.
		                    this.cellTypesLen = reader.uint32();
		                    this.cellTypesOff = reader.pos;
		                    reader.pos += this.cellTypesLen;
		                    break;
		                case 2: // varint_cells, a packed varint buffer.
		                    (0, logging_1.assertTrue)((tag & 7) === TAG_LEN_DELIM); // Must be packed varint.
		                    const packLen = reader.uint32();
		                    this.varintOff = reader.pos;
		                    this.varintLen = packLen;
		                    (0, logging_1.assertTrue)(reader.buf === batchBytes);
		                    (0, logging_1.assertTrue)(this.varintOff + this.varintLen <=
		                        batchBytes.byteOffset + batchBytes.byteLength);
		                    reader.pos += packLen;
		                    break;
		                case 3: // float64_cells, a 64-bit aligned packed fixed64 buffer.
		                    (0, logging_1.assertTrue)((tag & 7) === TAG_LEN_DELIM); // Must be packed varint.
		                    const f64Len = reader.uint32();
		                    (0, logging_1.assertTrue)(f64Len % 8 === 0);
		                    // Float64Array's constructor is evil: the offset is in bytes but the
		                    // length is in 8-byte words.
		                    const f64Words = f64Len / 8;
		                    const f64Off = batchBytes.byteOffset + reader.pos;
		                    if (f64Off % 8 === 0) {
		                        this.float64Cells =
		                            new Float64Array(batchBytes.buffer, f64Off, f64Words);
		                    }
		                    else {
		                        // When using the production code in trace_processor's rpc.cc, the
		                        // float64 should be 8-bytes aligned. The slow-path case is only for
		                        // tests.
		                        const slice = batchBytes.buffer.slice(f64Off, f64Off + f64Len);
		                        this.float64Cells = new Float64Array(slice);
		                    }
		                    reader.pos += f64Len;
		                    break;
		                case 4: // blob_cells: one entry per blob.
		                    (0, logging_1.assertTrue)((tag & 7) === TAG_LEN_DELIM);
		                    // protobufjs's bytes() under the hoods calls slice() and creates
		                    // a copy. Fine here as blobs are rare and not a fastpath.
		                    this.blobCells.push(new Uint8Array(reader.bytes()));
		                    break;
		                case 5: // string_cells: all the string cells concatenated with \0s.
		                    (0, logging_1.assertTrue)((tag & 7) === TAG_LEN_DELIM);
		                    const strLen = reader.uint32();
		                    (0, logging_1.assertTrue)(reader.pos + strLen <= end);
		                    const subArr = batchBytes.subarray(reader.pos, reader.pos + strLen);
		                    (0, logging_1.assertTrue)(subArr.length === strLen);
		                    // The reason why we do this split rather than creating one string
		                    // per entry is that utf8 decoding has some non-negligible cost. See
		                    // go/postmessage-benchmark .
		                    this.stringCells = (0, string_utils_1.utf8Decode)(subArr).split('\0');
		                    reader.pos += strLen;
		                    break;
		                case 6: // is_last_batch (boolean).
		                    this.isLastBatch = !!reader.bool();
		                    break;
		                case 7: // padding for realignment, skip silently.
		                    reader.skipType(tag & 7);
		                    break;
		                default:
		                    console.warn(`Unexpected QueryResult.CellsBatch field ${tag >>> 3}`);
		                    reader.skipType(tag & 7);
		                    break;
		            } // switch(tag)
		        } // while (pos < end)
		    }
		    get numCells() {
		        return this.cellTypesLen;
		    }
		}
		class RowIteratorImpl {
		    constructor(querySpec, rowData, res) {
		        // All the member variables in the group below point to the identically-named
		        // members in result.batch[batchIdx]. This is to avoid indirection layers in
		        // the next() hotpath, so we can do this.float64Cells vs
		        // this.resultObj.batch[this.batchIdx].float64Cells.
		        // These are re-set every time tryMoveToNextBatch() is called (and succeeds).
		        this.batchIdx = -1; // The batch index within |result.batches[]|.
		        this.batchBytes = new Uint8Array();
		        this.columnNames = [];
		        this.numColumns = 0;
		        this.cellTypesEnd = -1; // -1 so the 1st next() hits tryMoveToNextBatch().
		        this.float64Cells = new Float64Array();
		        this.varIntReader = minimal_1.default.Reader.create(this.batchBytes);
		        this.blobCells = [];
		        this.stringCells = [];
		        // These members instead are incremented as we read cells from next(). They
		        // are the mutable state of the iterator.
		        this.nextCellTypeOff = 0;
		        this.nextFloat64Cell = 0;
		        this.nextStringCell = 0;
		        this.nextBlobCell = 0;
		        this.isValid = false;
		        Object.assign(this, querySpec);
		        this.rowData = rowData;
		        this.rowSpec = { ...querySpec }; // ... -> Copy all the key/value pairs.
		        this.resultObj = res;
		        this.next();
		    }
		    valid() {
		        return this.isValid;
		    }
		    get(columnName) {
		        const res = this.rowData[columnName];
		        if (res === undefined) {
		            throw new Error(`Column '${columnName}' doesn't exist. ` +
		                `Actual columns: [${this.columnNames.join(',')}]`);
		        }
		        return res;
		    }
		    // Moves the cursor next by one row and updates |isValid|.
		    // When this fails to move, two cases are possible:
		    // 1. We reached the end of the result set (this is the case if
		    //    QueryResult.isComplete() == true when this fails).
		    // 2. We reached the end of the current batch, but more rows might come later
		    //    (if QueryResult.isComplete() == false).
		    next() {
		        // At some point we might reach the end of the current batch, but the next
		        // batch might be available already. In this case we want next() to
		        // transparently move on to the next batch.
		        while (this.nextCellTypeOff + this.numColumns > this.cellTypesEnd) {
		            // If TraceProcessor is behaving well, we should never end up in a
		            // situation where we have leftover cells. TP is expected to serialize
		            // whole rows in each QueryResult batch and NOT truncate them midway.
		            // If this assert fires the TP RPC logic has a bug.
		            (0, logging_1.assertTrue)(this.nextCellTypeOff === this.cellTypesEnd ||
		                this.cellTypesEnd === -1);
		            if (!this.tryMoveToNextBatch()) {
		                this.isValid = false;
		                return;
		            }
		        }
		        const rowData = this.rowData;
		        const numColumns = this.numColumns;
		        // Read the current row.
		        for (let i = 0; i < numColumns; i++) {
		            const cellType = this.batchBytes[this.nextCellTypeOff++];
		            const colName = this.columnNames[i];
		            const expType = this.rowSpec[colName];
		            switch (cellType) {
		                case CellType.CELL_NULL:
		                    rowData[colName] = null;
		                    break;
		                case CellType.CELL_VARINT:
		                    if (expType === exports.NUM || expType === exports.NUM_NULL) {
		                        // This is very subtle. The return type of int64 can be either a
		                        // number or a Long.js {high:number, low:number} if Long.js is
		                        // installed. The default state seems different in node and browser.
		                        // We force-disable Long.js support in the top of this source file.
		                        const val = this.varIntReader.int64();
		                        rowData[colName] = val;
		                    }
		                    else {
		                        // LONG, LONG_NULL, or unspecified - return as bigint
		                        const value = decodeInt64Varint(this.batchBytes, this.varIntReader.pos);
		                        rowData[colName] = value;
		                        this.varIntReader.skip(); // Skips a varint
		                    }
		                    break;
		                case CellType.CELL_FLOAT64:
		                    rowData[colName] = this.float64Cells[this.nextFloat64Cell++];
		                    break;
		                case CellType.CELL_STRING:
		                    rowData[colName] = this.stringCells[this.nextStringCell++];
		                    break;
		                case CellType.CELL_BLOB:
		                    const blob = this.blobCells[this.nextBlobCell++];
		                    rowData[colName] = blob;
		                    break;
		                default:
		                    throw new Error(`Invalid cell type ${cellType}`);
		            }
		        } // For (cells)
		        this.isValid = true;
		    }
		    tryMoveToNextBatch() {
		        const nextBatchIdx = this.batchIdx + 1;
		        if (nextBatchIdx >= this.resultObj.batches.length) {
		            return false;
		        }
		        this.columnNames = this.resultObj.columnNames;
		        this.numColumns = this.columnNames.length;
		        this.batchIdx = nextBatchIdx;
		        const batch = (0, logging_1.assertExists)(this.resultObj.batches[nextBatchIdx]);
		        this.batchBytes = batch.batchBytes;
		        this.nextCellTypeOff = batch.cellTypesOff;
		        this.cellTypesEnd = batch.cellTypesOff + batch.cellTypesLen;
		        this.float64Cells = batch.float64Cells;
		        this.blobCells = batch.blobCells;
		        this.stringCells = batch.stringCells;
		        this.varIntReader = minimal_1.default.Reader.create(batch.batchBytes);
		        this.varIntReader.pos = batch.varintOff;
		        this.varIntReader.len = batch.varintOff + batch.varintLen;
		        this.nextFloat64Cell = 0;
		        this.nextStringCell = 0;
		        this.nextBlobCell = 0;
		        // Check that all the expected columns are present.
		        for (const expectedCol of Object.keys(this.rowSpec)) {
		            if (this.columnNames.indexOf(expectedCol) < 0) {
		                throw new Error(`Column ${expectedCol} not found in the SQL result ` +
		                    `set {${this.columnNames.join(' ')}}`);
		            }
		        }
		        // Check that the cells types are consistent.
		        const numColumns = this.numColumns;
		        if (batch.numCells === 0) {
		            // This can happen if the query result contains just an error. In this
		            // an empty batch with isLastBatch=true is appended as an EOF marker.
		            // In theory TraceProcessor could return an empty batch in the middle and
		            // that would be fine from a protocol viewpoint. In practice, no code path
		            // does that today so it doesn't make sense trying supporting it with a
		            // recursive call to tryMoveToNextBatch().
		            (0, logging_1.assertTrue)(batch.isLastBatch);
		            return false;
		        }
		        (0, logging_1.assertTrue)(numColumns > 0);
		        for (let i = this.nextCellTypeOff; i < this.cellTypesEnd; i++) {
		            const col = (i - this.nextCellTypeOff) % numColumns;
		            const colName = this.columnNames[col];
		            const actualType = this.batchBytes[i];
		            const expType = this.rowSpec[colName];
		            // If undefined, the caller doesn't want to read this column at all, so
		            // it can be whatever.
		            if (expType === undefined)
		                continue;
		            let err = '';
		            if (!isCompatible(actualType, expType)) {
		                if (actualType === CellType.CELL_NULL) {
		                    err = 'SQL value is NULL but that was not expected' +
		                        ` (expected type: ${columnTypeToString(expType)}). ` +
		                        'Did you mean NUM_NULL, LONG_NULL, STR_NULL or BLOB_NULL?';
		                }
		                else {
		                    err = `Incompatible cell type. Expected: ${columnTypeToString(expType)} actual: ${CELL_TYPE_NAMES[actualType]}`;
		                }
		            }
		            if (err.length > 0) {
		                throw new Error(`Error @ row: ${Math.floor(i / numColumns)} col: '` +
		                    `${colName}': ${err}`);
		            }
		        }
		        return true;
		    }
		}
		// This is the object ultimately returned to the client when calling
		// QueryResult.iter(...).
		// The only reason why this is disjoint from RowIteratorImpl is to avoid
		// naming collisions between the members variables required by RowIteratorImpl
		// and the column names returned by the iterator.
		class RowIteratorImplWithRowData {
		    constructor(querySpec, res) {
		        const thisAsRow = this;
		        Object.assign(thisAsRow, querySpec);
		        this._impl = new RowIteratorImpl(querySpec, thisAsRow, res);
		        this.next = this._impl.next.bind(this._impl);
		        this.valid = this._impl.valid.bind(this._impl);
		        this.get = this._impl.get.bind(this._impl);
		    }
		}
		// This is a proxy object that wraps QueryResultImpl, adding await-ability.
		// This is so that:
		// 1. Clients that just want to await for the full result set can just call
		//    await engine.query('...') and will get a QueryResult that is guaranteed
		//    to be complete.
		// 2. Clients that know how to handle the streaming can use it straight away.
		class WaitableQueryResultImpl {
		    constructor(errorInfo) {
		        this.thenCalled = false;
		        this.impl = new QueryResultImpl(errorInfo);
		    }
		    // QueryResult implementation. Proxies all calls to the impl object.
		    iter(spec) {
		        return this.impl.iter(spec);
		    }
		    firstRow(spec) {
		        return this.impl.firstRow(spec);
		    }
		    waitAllRows() {
		        return this.impl.waitAllRows();
		    }
		    waitMoreRows() {
		        return this.impl.waitMoreRows();
		    }
		    isComplete() {
		        return this.impl.isComplete();
		    }
		    numRows() {
		        return this.impl.numRows();
		    }
		    columns() {
		        return this.impl.columns();
		    }
		    error() {
		        return this.impl.error();
		    }
		    statementCount() {
		        return this.impl.statementCount();
		    }
		    statementWithOutputCount() {
		        return this.impl.statementWithOutputCount();
		    }
		    // WritableQueryResult implementation.
		    appendResultBatch(resBytes) {
		        return this.impl.appendResultBatch(resBytes);
		    }
		    // PromiseLike<QueryResult> implementaton.
		    then(onfulfilled, onrejected) {
		        (0, logging_1.assertFalse)(this.thenCalled);
		        this.thenCalled = true;
		        return this.impl.ensureAllRowsPromise().then(onfulfilled, onrejected);
		    }
		    catch(error) {
		        return this.impl.ensureAllRowsPromise().catch(error);
		    }
		    finally(callback) {
		        return this.impl.ensureAllRowsPromise().finally(callback);
		    }
		    // eslint and clang-format disagree on how to format get[foo](). Let
		    // clang-format win:
		    // eslint-disable-next-line keyword-spacing
		    get [Symbol.toStringTag]() {
		        return 'Promise<WaitableQueryResult>';
		    }
		}
		function createQueryResult(errorInfo) {
		    return new WaitableQueryResultImpl(errorInfo);
		}
		exports.createQueryResult = createQueryResult;
		
} (query_result));
	return query_result;
}

var distExports = {};
var dist = {
  get exports(){ return distExports; },
  set exports(v){ distExports = v; },
};

var immer_cjs_production_min = {};

var hasRequiredImmer_cjs_production_min;

function requireImmer_cjs_production_min () {
	if (hasRequiredImmer_cjs_production_min) return immer_cjs_production_min;
	hasRequiredImmer_cjs_production_min = 1;
	function n(n){for(var r=arguments.length,t=Array(r>1?r-1:0),e=1;e<r;e++)t[e-1]=arguments[e];throw Error("[Immer] minified error nr: "+n+(t.length?" "+t.map((function(n){return "'"+n+"'"})).join(","):"")+". Find the full error at: https://bit.ly/3cXEKWf")}function r(n){return !!n&&!!n[H]}function t(n){var r;return !!n&&(function(n){if(!n||"object"!=typeof n)return !1;var r=Object.getPrototypeOf(n);if(null===r)return !0;var t=Object.hasOwnProperty.call(r,"constructor")&&r.constructor;return t===Object||"function"==typeof t&&Function.toString.call(t)===Q}(n)||Array.isArray(n)||!!n[G]||!!(null===(r=n.constructor)||void 0===r?void 0:r[G])||c(n)||v(n))}function e(n,r,t){void 0===t&&(t=!1),0===i(n)?(t?Object.keys:T)(n).forEach((function(e){t&&"symbol"==typeof e||r(e,n[e],n);})):n.forEach((function(t,e){return r(e,t,n)}));}function i(n){var r=n[H];return r?r.t>3?r.t-4:r.t:Array.isArray(n)?1:c(n)?2:v(n)?3:0}function u(n,r){return 2===i(n)?n.has(r):Object.prototype.hasOwnProperty.call(n,r)}function o(n,r){return 2===i(n)?n.get(r):n[r]}function f(n,r,t){var e=i(n);2===e?n.set(r,t):3===e?n.add(t):n[r]=t;}function a(n,r){return n===r?0!==n||1/n==1/r:n!=n&&r!=r}function c(n){return W&&n instanceof Map}function v(n){return X&&n instanceof Set}function s(n){return n.i||n.u}function p(n){if(Array.isArray(n))return Array.prototype.slice.call(n);var r=U(n);delete r[H];for(var t=T(r),e=0;e<t.length;e++){var i=t[e],u=r[i];!1===u.writable&&(u.writable=!0,u.configurable=!0),(u.get||u.set)&&(r[i]={configurable:!0,writable:!0,enumerable:u.enumerable,value:n[i]});}return Object.create(Object.getPrototypeOf(n),r)}function l(n,u){return void 0===u&&(u=!1),h(n)||r(n)||!t(n)||(i(n)>1&&(n.set=n.add=n.clear=n.delete=d),Object.freeze(n),u&&e(n,(function(n,r){return l(r,!0)}),!0)),n}function d(){n(2);}function h(n){return null==n||"object"!=typeof n||Object.isFrozen(n)}function y(r){var t=V[r];return t||n(18,r),t}function _(n,r){V[n]||(V[n]=r);}function b(){return I}function m(n,r){r&&(y("Patches"),n.o=[],n.v=[],n.s=r);}function j(n){O(n),n.p.forEach(w),n.p=null;}function O(n){n===I&&(I=n.l);}function x(n){return I={p:[],l:I,h:n,_:!0,m:0}}function w(n){var r=n[H];0===r.t||1===r.t?r.j():r.O=!0;}function S(r,e){e.m=e.p.length;var i=e.p[0],u=void 0!==r&&r!==i;return e.h.S||y("ES5").P(e,r,u),u?(i[H].g&&(j(e),n(4)),t(r)&&(r=P(e,r),e.l||M(e,r)),e.o&&y("Patches").M(i[H].u,r,e.o,e.v)):r=P(e,i,[]),j(e),e.o&&e.s(e.o,e.v),r!==B?r:void 0}function P(n,r,t){if(h(r))return r;var i=r[H];if(!i)return e(r,(function(e,u){return g(n,i,r,e,u,t)}),!0),r;if(i.A!==n)return r;if(!i.g)return M(n,i.u,!0),i.u;if(!i.R){i.R=!0,i.A.m--;var u=4===i.t||5===i.t?i.i=p(i.k):i.i,o=u,f=!1;3===i.t&&(o=new Set(u),u.clear(),f=!0),e(o,(function(r,e){return g(n,i,u,r,e,t,f)})),M(n,u,!1),t&&n.o&&y("Patches").F(i,t,n.o,n.v);}return i.i}function g(n,e,i,o,a,c,v){if(r(a)){var s=P(n,a,c&&e&&3!==e.t&&!u(e.N,o)?c.concat(o):void 0);if(f(i,o,s),!r(s))return;n._=!1;}else v&&i.add(a);if(t(a)&&!h(a)){if(!n.h.D&&n.m<1)return;P(n,a),e&&e.A.l||M(n,a);}}function M(n,r,t){void 0===t&&(t=!1),!n.l&&n.h.D&&n._&&l(r,t);}function A(n,r){var t=n[H];return (t?s(t):n)[r]}function z(n,r){if(r in n)for(var t=Object.getPrototypeOf(n);t;){var e=Object.getOwnPropertyDescriptor(t,r);if(e)return e;t=Object.getPrototypeOf(t);}}function E(n){n.g||(n.g=!0,n.l&&E(n.l));}function R(n){n.i||(n.i=p(n.u));}function k(n,r,t){var e=c(r)?y("MapSet").K(r,t):v(r)?y("MapSet").$(r,t):n.S?function(n,r){var t=Array.isArray(n),e={t:t?1:0,A:r?r.A:b(),g:!1,R:!1,N:{},l:r,u:n,k:null,i:null,j:null,C:!1},i=e,u=Y;t&&(i=[e],u=Z);var o=Proxy.revocable(i,u),f=o.revoke,a=o.proxy;return e.k=a,e.j=f,a}(r,t):y("ES5").I(r,t);return (t?t.A:b()).p.push(e),e}function F(u){return r(u)||n(22,u),function n(r){if(!t(r))return r;var u,a=r[H],c=i(r);if(a){if(!a.g&&(a.t<4||!y("ES5").J(a)))return a.u;a.R=!0,u=N(r,c),a.R=!1;}else u=N(r,c);return e(u,(function(r,t){a&&o(a.u,r)===t||f(u,r,n(t));})),3===c?new Set(u):u}(u)}function N(n,r){switch(r){case 2:return new Map(n);case 3:return Array.from(n)}return p(n)}function D(){function n(n,r){var t=f[n];return t?t.enumerable=r:f[n]=t={configurable:!0,enumerable:r,get:function(){return Y.get(this[H],n)},set:function(r){Y.set(this[H],n,r);}},t}function t(n){for(var r=n.length-1;r>=0;r--){var t=n[r][H];if(!t.g)switch(t.t){case 5:o(t)&&E(t);break;case 4:i(t)&&E(t);}}}function i(n){for(var r=n.u,t=n.k,e=T(t),i=e.length-1;i>=0;i--){var o=e[i];if(o!==H){var f=r[o];if(void 0===f&&!u(r,o))return !0;var c=t[o],v=c&&c[H];if(v?v.u!==f:!a(c,f))return !0}}var s=!!r[H];return e.length!==T(r).length+(s?0:1)}function o(n){var r=n.k;if(r.length!==n.u.length)return !0;var t=Object.getOwnPropertyDescriptor(r,r.length-1);if(t&&!t.get)return !0;for(var e=0;e<r.length;e++)if(!r.hasOwnProperty(e))return !0;return !1}var f={};_("ES5",{I:function(r,t){var e=Array.isArray(r),i=function(r,t){if(r){for(var e=Array(t.length),i=0;i<t.length;i++)Object.defineProperty(e,""+i,n(i,!0));return e}var u=U(t);delete u[H];for(var o=T(u),f=0;f<o.length;f++){var a=o[f];u[a]=n(a,r||!!u[a].enumerable);}return Object.create(Object.getPrototypeOf(t),u)}(e,r),u={t:e?5:4,A:t?t.A:b(),g:!1,R:!1,N:{},l:t,u:r,k:i,i:null,O:!1,C:!1};return Object.defineProperty(i,H,{value:u,writable:!0}),i},P:function(n,i,f){f?r(i)&&i[H].A===n&&t(n.p):(n.o&&function n(r){if(r&&"object"==typeof r){var t=r[H];if(t){var i=t.u,f=t.k,a=t.N,c=t.t;if(4===c)e(f,(function(r){r!==H&&(void 0!==i[r]||u(i,r)?a[r]||n(f[r]):(a[r]=!0,E(t)));})),e(i,(function(n){void 0!==f[n]||u(f,n)||(a[n]=!1,E(t));}));else if(5===c){if(o(t)&&(E(t),a.length=!0),f.length<i.length)for(var v=f.length;v<i.length;v++)a[v]=!1;else for(var s=i.length;s<f.length;s++)a[s]=!0;for(var p=Math.min(f.length,i.length),l=0;l<p;l++)f.hasOwnProperty(l)||(a[l]=!0),void 0===a[l]&&n(f[l]);}}}}(n.p[0]),t(n.p));},J:function(n){return 4===n.t?i(n):o(n)}});}function K(){function f(n){if(!t(n))return n;if(Array.isArray(n))return n.map(f);if(c(n))return new Map(Array.from(n.entries()).map((function(n){return [n[0],f(n[1])]})));if(v(n))return new Set(Array.from(n).map(f));var r=Object.create(Object.getPrototypeOf(n));for(var e in n)r[e]=f(n[e]);return u(n,G)&&(r[G]=n[G]),r}function a(n){return r(n)?f(n):n}var s="add";_("Patches",{W:function(r,t){return t.forEach((function(t){for(var e=t.path,u=t.op,a=r,c=0;c<e.length-1;c++){var v=i(a),p=e[c];"string"!=typeof p&&"number"!=typeof p&&(p=""+p),0!==v&&1!==v||"__proto__"!==p&&"constructor"!==p||n(24),"function"==typeof a&&"prototype"===p&&n(24),"object"!=typeof(a=o(a,p))&&n(15,e.join("/"));}var l=i(a),d=f(t.value),h=e[e.length-1];switch(u){case"replace":switch(l){case 2:return a.set(h,d);case 3:n(16);default:return a[h]=d}case s:switch(l){case 1:return "-"===h?a.push(d):a.splice(h,0,d);case 2:return a.set(h,d);case 3:return a.add(d);default:return a[h]=d}case"remove":switch(l){case 1:return a.splice(h,1);case 2:return a.delete(h);case 3:return a.delete(t.value);default:return delete a[h]}default:n(17,u);}})),r},F:function(n,r,t,i){switch(n.t){case 0:case 4:case 2:return function(n,r,t,i){var f=n.u,c=n.i;e(n.N,(function(n,e){var v=o(f,n),p=o(c,n),l=e?u(f,n)?"replace":s:"remove";if(v!==p||"replace"!==l){var d=r.concat(n);t.push("remove"===l?{op:l,path:d}:{op:l,path:d,value:p}),i.push(l===s?{op:"remove",path:d}:"remove"===l?{op:s,path:d,value:a(v)}:{op:"replace",path:d,value:a(v)});}}));}(n,r,t,i);case 5:case 1:return function(n,r,t,e){var i=n.u,u=n.N,o=n.i;if(o.length<i.length){var f=[o,i];i=f[0],o=f[1];var c=[e,t];t=c[0],e=c[1];}for(var v=0;v<i.length;v++)if(u[v]&&o[v]!==i[v]){var p=r.concat([v]);t.push({op:"replace",path:p,value:a(o[v])}),e.push({op:"replace",path:p,value:a(i[v])});}for(var l=i.length;l<o.length;l++){var d=r.concat([l]);t.push({op:s,path:d,value:a(o[l])});}i.length<o.length&&e.push({op:"replace",path:r.concat(["length"]),value:i.length});}(n,r,t,i);case 3:return function(n,r,t,e){var i=n.u,u=n.i,o=0;i.forEach((function(n){if(!u.has(n)){var i=r.concat([o]);t.push({op:"remove",path:i,value:n}),e.unshift({op:s,path:i,value:n});}o++;})),o=0,u.forEach((function(n){if(!i.has(n)){var u=r.concat([o]);t.push({op:s,path:u,value:n}),e.unshift({op:"remove",path:u,value:n});}o++;}));}(n,r,t,i)}},M:function(n,r,t,e){t.push({op:"replace",path:[],value:r===B?void 0:r}),e.push({op:"replace",path:[],value:n});}});}function $(){function r(n,r){function t(){this.constructor=n;}f(n,r),n.prototype=(t.prototype=r.prototype,new t);}function i(n){n.i||(n.N=new Map,n.i=new Map(n.u));}function u(n){n.i||(n.i=new Set,n.u.forEach((function(r){if(t(r)){var e=k(n.A.h,r,n);n.p.set(r,e),n.i.add(e);}else n.i.add(r);})));}function o(r){r.O&&n(3,JSON.stringify(s(r)));}var f=function(n,r){return (f=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(n,r){n.__proto__=r;}||function(n,r){for(var t in r)r.hasOwnProperty(t)&&(n[t]=r[t]);})(n,r)},a=function(){function n(n,r){return this[H]={t:2,l:r,A:r?r.A:b(),g:!1,R:!1,i:void 0,N:void 0,u:n,k:this,C:!1,O:!1},this}r(n,Map);var u=n.prototype;return Object.defineProperty(u,"size",{get:function(){return s(this[H]).size}}),u.has=function(n){return s(this[H]).has(n)},u.set=function(n,r){var t=this[H];return o(t),s(t).has(n)&&s(t).get(n)===r||(i(t),E(t),t.N.set(n,!0),t.i.set(n,r),t.N.set(n,!0)),this},u.delete=function(n){if(!this.has(n))return !1;var r=this[H];return o(r),i(r),E(r),r.u.has(n)?r.N.set(n,!1):r.N.delete(n),r.i.delete(n),!0},u.clear=function(){var n=this[H];o(n),s(n).size&&(i(n),E(n),n.N=new Map,e(n.u,(function(r){n.N.set(r,!1);})),n.i.clear());},u.forEach=function(n,r){var t=this;s(this[H]).forEach((function(e,i){n.call(r,t.get(i),i,t);}));},u.get=function(n){var r=this[H];o(r);var e=s(r).get(n);if(r.R||!t(e))return e;if(e!==r.u.get(n))return e;var u=k(r.A.h,e,r);return i(r),r.i.set(n,u),u},u.keys=function(){return s(this[H]).keys()},u.values=function(){var n,r=this,t=this.keys();return (n={})[L]=function(){return r.values()},n.next=function(){var n=t.next();return n.done?n:{done:!1,value:r.get(n.value)}},n},u.entries=function(){var n,r=this,t=this.keys();return (n={})[L]=function(){return r.entries()},n.next=function(){var n=t.next();if(n.done)return n;var e=r.get(n.value);return {done:!1,value:[n.value,e]}},n},u[L]=function(){return this.entries()},n}(),c=function(){function n(n,r){return this[H]={t:3,l:r,A:r?r.A:b(),g:!1,R:!1,i:void 0,u:n,k:this,p:new Map,O:!1,C:!1},this}r(n,Set);var t=n.prototype;return Object.defineProperty(t,"size",{get:function(){return s(this[H]).size}}),t.has=function(n){var r=this[H];return o(r),r.i?!!r.i.has(n)||!(!r.p.has(n)||!r.i.has(r.p.get(n))):r.u.has(n)},t.add=function(n){var r=this[H];return o(r),this.has(n)||(u(r),E(r),r.i.add(n)),this},t.delete=function(n){if(!this.has(n))return !1;var r=this[H];return o(r),u(r),E(r),r.i.delete(n)||!!r.p.has(n)&&r.i.delete(r.p.get(n))},t.clear=function(){var n=this[H];o(n),s(n).size&&(u(n),E(n),n.i.clear());},t.values=function(){var n=this[H];return o(n),u(n),n.i.values()},t.entries=function(){var n=this[H];return o(n),u(n),n.i.entries()},t.keys=function(){return this.values()},t[L]=function(){return this.values()},t.forEach=function(n,r){for(var t=this.values(),e=t.next();!e.done;)n.call(r,e.value,e.value,this),e=t.next();},n}();_("MapSet",{K:function(n,r){return new a(n,r)},$:function(n,r){return new c(n,r)}});}var C;Object.defineProperty(immer_cjs_production_min,"__esModule",{value:!0});var I,J="undefined"!=typeof Symbol&&"symbol"==typeof Symbol("x"),W="undefined"!=typeof Map,X="undefined"!=typeof Set,q="undefined"!=typeof Proxy&&void 0!==Proxy.revocable&&"undefined"!=typeof Reflect,B=J?Symbol.for("immer-nothing"):((C={})["immer-nothing"]=!0,C),G=J?Symbol.for("immer-draftable"):"__$immer_draftable",H=J?Symbol.for("immer-state"):"__$immer_state",L="undefined"!=typeof Symbol&&Symbol.iterator||"@@iterator",Q=""+Object.prototype.constructor,T="undefined"!=typeof Reflect&&Reflect.ownKeys?Reflect.ownKeys:void 0!==Object.getOwnPropertySymbols?function(n){return Object.getOwnPropertyNames(n).concat(Object.getOwnPropertySymbols(n))}:Object.getOwnPropertyNames,U=Object.getOwnPropertyDescriptors||function(n){var r={};return T(n).forEach((function(t){r[t]=Object.getOwnPropertyDescriptor(n,t);})),r},V={},Y={get:function(n,r){if(r===H)return n;var e=s(n);if(!u(e,r))return function(n,r,t){var e,i=z(r,t);return i?"value"in i?i.value:null===(e=i.get)||void 0===e?void 0:e.call(n.k):void 0}(n,e,r);var i=e[r];return n.R||!t(i)?i:i===A(n.u,r)?(R(n),n.i[r]=k(n.A.h,i,n)):i},has:function(n,r){return r in s(n)},ownKeys:function(n){return Reflect.ownKeys(s(n))},set:function(n,r,t){var e=z(s(n),r);if(null==e?void 0:e.set)return e.set.call(n.k,t),!0;if(!n.g){var i=A(s(n),r),o=null==i?void 0:i[H];if(o&&o.u===t)return n.i[r]=t,n.N[r]=!1,!0;if(a(t,i)&&(void 0!==t||u(n.u,r)))return !0;R(n),E(n);}return n.i[r]===t&&(void 0!==t||r in n.i)||Number.isNaN(t)&&Number.isNaN(n.i[r])||(n.i[r]=t,n.N[r]=!0),!0},deleteProperty:function(n,r){return void 0!==A(n.u,r)||r in n.u?(n.N[r]=!1,R(n),E(n)):delete n.N[r],n.i&&delete n.i[r],!0},getOwnPropertyDescriptor:function(n,r){var t=s(n),e=Reflect.getOwnPropertyDescriptor(t,r);return e?{writable:!0,configurable:1!==n.t||"length"!==r,enumerable:e.enumerable,value:t[r]}:e},defineProperty:function(){n(11);},getPrototypeOf:function(n){return Object.getPrototypeOf(n.u)},setPrototypeOf:function(){n(12);}},Z={};e(Y,(function(n,r){Z[n]=function(){return arguments[0]=arguments[0][0],r.apply(this,arguments)};})),Z.deleteProperty=function(n,r){return Z.set.call(this,n,r,void 0)},Z.set=function(n,r,t){return Y.set.call(this,n[0],r,t,n[0])};var nn=function(){function e(r){var e=this;this.S=q,this.D=!0,this.produce=function(r,i,u){if("function"==typeof r&&"function"!=typeof i){var o=i;i=r;var f=e;return function(n){var r=this;void 0===n&&(n=o);for(var t=arguments.length,e=Array(t>1?t-1:0),u=1;u<t;u++)e[u-1]=arguments[u];return f.produce(n,(function(n){var t;return (t=i).call.apply(t,[r,n].concat(e))}))}}var a;if("function"!=typeof i&&n(6),void 0!==u&&"function"!=typeof u&&n(7),t(r)){var c=x(e),v=k(e,r,void 0),s=!0;try{a=i(v),s=!1;}finally{s?j(c):O(c);}return "undefined"!=typeof Promise&&a instanceof Promise?a.then((function(n){return m(c,u),S(n,c)}),(function(n){throw j(c),n})):(m(c,u),S(a,c))}if(!r||"object"!=typeof r){if(void 0===(a=i(r))&&(a=r),a===B&&(a=void 0),e.D&&l(a,!0),u){var p=[],d=[];y("Patches").M(r,a,p,d),u(p,d);}return a}n(21,r);},this.produceWithPatches=function(n,r){if("function"==typeof n)return function(r){for(var t=arguments.length,i=Array(t>1?t-1:0),u=1;u<t;u++)i[u-1]=arguments[u];return e.produceWithPatches(r,(function(r){return n.apply(void 0,[r].concat(i))}))};var t,i,u=e.produce(n,r,(function(n,r){t=n,i=r;}));return "undefined"!=typeof Promise&&u instanceof Promise?u.then((function(n){return [n,t,i]})):[u,t,i]},"boolean"==typeof(null==r?void 0:r.useProxies)&&this.setUseProxies(r.useProxies),"boolean"==typeof(null==r?void 0:r.autoFreeze)&&this.setAutoFreeze(r.autoFreeze);}var i=e.prototype;return i.createDraft=function(e){t(e)||n(8),r(e)&&(e=F(e));var i=x(this),u=k(this,e,void 0);return u[H].C=!0,O(i),u},i.finishDraft=function(n,r){var t=(n&&n[H]).A;return m(t,r),S(void 0,t)},i.setAutoFreeze=function(n){this.D=n;},i.setUseProxies=function(r){r&&!q&&n(20),this.S=r;},i.applyPatches=function(n,t){var e;for(e=t.length-1;e>=0;e--){var i=t[e];if(0===i.path.length&&"replace"===i.op){n=i.value;break}}e>-1&&(t=t.slice(e+1));var u=y("Patches").W;return r(n)?u(n,t):this.produce(n,(function(n){return u(n,t)}))},e}(),rn=new nn,tn=rn.produce,en=rn.produceWithPatches.bind(rn),un=rn.setAutoFreeze.bind(rn),on=rn.setUseProxies.bind(rn),fn=rn.applyPatches.bind(rn),an=rn.createDraft.bind(rn),cn=rn.finishDraft.bind(rn);immer_cjs_production_min.Immer=nn,immer_cjs_production_min.applyPatches=fn,immer_cjs_production_min.castDraft=function(n){return n},immer_cjs_production_min.castImmutable=function(n){return n},immer_cjs_production_min.createDraft=an,immer_cjs_production_min.current=F,immer_cjs_production_min.default=tn,immer_cjs_production_min.enableAllPlugins=function(){D(),$(),K();},immer_cjs_production_min.enableES5=D,immer_cjs_production_min.enableMapSet=$,immer_cjs_production_min.enablePatches=K,immer_cjs_production_min.finishDraft=cn,immer_cjs_production_min.freeze=l,immer_cjs_production_min.immerable=G,immer_cjs_production_min.isDraft=r,immer_cjs_production_min.isDraftable=t,immer_cjs_production_min.nothing=B,immer_cjs_production_min.original=function(t){return r(t)||n(23,t),t[H].u},immer_cjs_production_min.produce=tn,immer_cjs_production_min.produceWithPatches=en,immer_cjs_production_min.setAutoFreeze=un,immer_cjs_production_min.setUseProxies=on;
	
	return immer_cjs_production_min;
}

var hasRequiredDist;

function requireDist () {
	if (hasRequiredDist) return distExports;
	hasRequiredDist = 1;
	(function (module) {

		{
		  module.exports = requireImmer_cjs_production_min();
		}
} (dist));
	return distExports;
}

var vnode;
var hasRequiredVnode;

function requireVnode () {
	if (hasRequiredVnode) return vnode;
	hasRequiredVnode = 1;

	function Vnode(tag, key, attrs, children, text, dom) {
		return {tag: tag, key: key, attrs: attrs, children: children, text: text, dom: dom, domSize: undefined, state: undefined, events: undefined, instance: undefined}
	}
	Vnode.normalize = function(node) {
		if (Array.isArray(node)) return Vnode("[", undefined, undefined, Vnode.normalizeChildren(node), undefined, undefined)
		if (node == null || typeof node === "boolean") return null
		if (typeof node === "object") return node
		return Vnode("#", undefined, undefined, String(node), undefined, undefined)
	};
	Vnode.normalizeChildren = function(input) {
		var children = [];
		if (input.length) {
			var isKeyed = input[0] != null && input[0].key != null;
			// Note: this is a *very* perf-sensitive check.
			// Fun fact: merging the loop like this is somehow faster than splitting
			// it, noticeably so.
			for (var i = 1; i < input.length; i++) {
				if ((input[i] != null && input[i].key != null) !== isKeyed) {
					throw new TypeError(
						isKeyed && (input[i] != null || typeof input[i] === "boolean")
							? "In fragments, vnodes must either all have keys or none have keys. You may wish to consider using an explicit keyed empty fragment, m.fragment({key: ...}), instead of a hole."
							: "In fragments, vnodes must either all have keys or none have keys."
					)
				}
			}
			for (var i = 0; i < input.length; i++) {
				children[i] = Vnode.normalize(input[i]);
			}
		}
		return children
	};

	vnode = Vnode;
	return vnode;
}

var hyperscriptVnode;
var hasRequiredHyperscriptVnode;

function requireHyperscriptVnode () {
	if (hasRequiredHyperscriptVnode) return hyperscriptVnode;
	hasRequiredHyperscriptVnode = 1;

	var Vnode = requireVnode();

	// Call via `hyperscriptVnode.apply(startOffset, arguments)`
	//
	// The reason I do it this way, forwarding the arguments and passing the start
	// offset in `this`, is so I don't have to create a temporary array in a
	// performance-critical path.
	//
	// In native ES6, I'd instead add a final `...args` parameter to the
	// `hyperscript` and `fragment` factories and define this as
	// `hyperscriptVnode(...args)`, since modern engines do optimize that away. But
	// ES5 (what Mithril.js requires thanks to IE support) doesn't give me that luxury,
	// and engines aren't nearly intelligent enough to do either of these:
	//
	// 1. Elide the allocation for `[].slice.call(arguments, 1)` when it's passed to
	//    another function only to be indexed.
	// 2. Elide an `arguments` allocation when it's passed to any function other
	//    than `Function.prototype.apply` or `Reflect.apply`.
	//
	// In ES6, it'd probably look closer to this (I'd need to profile it, though):
	// module.exports = function(attrs, ...children) {
	//     if (attrs == null || typeof attrs === "object" && attrs.tag == null && !Array.isArray(attrs)) {
	//         if (children.length === 1 && Array.isArray(children[0])) children = children[0]
	//     } else {
	//         children = children.length === 0 && Array.isArray(attrs) ? attrs : [attrs, ...children]
	//         attrs = undefined
	//     }
	//
	//     if (attrs == null) attrs = {}
	//     return Vnode("", attrs.key, attrs, children)
	// }
	hyperscriptVnode = function() {
		var attrs = arguments[this], start = this + 1, children;

		if (attrs == null) {
			attrs = {};
		} else if (typeof attrs !== "object" || attrs.tag != null || Array.isArray(attrs)) {
			attrs = {};
			start = this;
		}

		if (arguments.length === start + 1) {
			children = arguments[start];
			if (!Array.isArray(children)) children = [children];
		} else {
			children = [];
			while (start < arguments.length) children.push(arguments[start++]);
		}

		return Vnode("", attrs.key, attrs, children)
	};
	return hyperscriptVnode;
}

var hasOwn;
var hasRequiredHasOwn;

function requireHasOwn () {
	if (hasRequiredHasOwn) return hasOwn;
	hasRequiredHasOwn = 1;

	hasOwn = {}.hasOwnProperty;
	return hasOwn;
}

var hyperscript_1$1;
var hasRequiredHyperscript$1;

function requireHyperscript$1 () {
	if (hasRequiredHyperscript$1) return hyperscript_1$1;
	hasRequiredHyperscript$1 = 1;

	var Vnode = requireVnode();
	var hyperscriptVnode = requireHyperscriptVnode();
	var hasOwn = requireHasOwn();

	var selectorParser = /(?:(^|#|\.)([^#\.\[\]]+))|(\[(.+?)(?:\s*=\s*("|'|)((?:\\["'\]]|.)*?)\5)?\])/g;
	var selectorCache = {};

	function isEmpty(object) {
		for (var key in object) if (hasOwn.call(object, key)) return false
		return true
	}

	function compileSelector(selector) {
		var match, tag = "div", classes = [], attrs = {};
		while (match = selectorParser.exec(selector)) {
			var type = match[1], value = match[2];
			if (type === "" && value !== "") tag = value;
			else if (type === "#") attrs.id = value;
			else if (type === ".") classes.push(value);
			else if (match[3][0] === "[") {
				var attrValue = match[6];
				if (attrValue) attrValue = attrValue.replace(/\\(["'])/g, "$1").replace(/\\\\/g, "\\");
				if (match[4] === "class") classes.push(attrValue);
				else attrs[match[4]] = attrValue === "" ? attrValue : attrValue || true;
			}
		}
		if (classes.length > 0) attrs.className = classes.join(" ");
		return selectorCache[selector] = {tag: tag, attrs: attrs}
	}

	function execSelector(state, vnode) {
		var attrs = vnode.attrs;
		var hasClass = hasOwn.call(attrs, "class");
		var className = hasClass ? attrs.class : attrs.className;

		vnode.tag = state.tag;
		vnode.attrs = {};

		if (!isEmpty(state.attrs) && !isEmpty(attrs)) {
			var newAttrs = {};

			for (var key in attrs) {
				if (hasOwn.call(attrs, key)) newAttrs[key] = attrs[key];
			}

			attrs = newAttrs;
		}

		for (var key in state.attrs) {
			if (hasOwn.call(state.attrs, key) && key !== "className" && !hasOwn.call(attrs, key)){
				attrs[key] = state.attrs[key];
			}
		}
		if (className != null || state.attrs.className != null) attrs.className =
			className != null
				? state.attrs.className != null
					? String(state.attrs.className) + " " + String(className)
					: className
				: state.attrs.className != null
					? state.attrs.className
					: null;

		if (hasClass) attrs.class = null;

		for (var key in attrs) {
			if (hasOwn.call(attrs, key) && key !== "key") {
				vnode.attrs = attrs;
				break
			}
		}

		return vnode
	}

	function hyperscript(selector) {
		if (selector == null || typeof selector !== "string" && typeof selector !== "function" && typeof selector.view !== "function") {
			throw Error("The selector must be either a string or a component.");
		}

		var vnode = hyperscriptVnode.apply(1, arguments);

		if (typeof selector === "string") {
			vnode.children = Vnode.normalizeChildren(vnode.children);
			if (selector !== "[") return execSelector(selectorCache[selector] || compileSelector(selector), vnode)
		}

		vnode.tag = selector;
		return vnode
	}

	hyperscript_1$1 = hyperscript;
	return hyperscript_1$1;
}

var trust;
var hasRequiredTrust;

function requireTrust () {
	if (hasRequiredTrust) return trust;
	hasRequiredTrust = 1;

	var Vnode = requireVnode();

	trust = function(html) {
		if (html == null) html = "";
		return Vnode("<", undefined, undefined, html, undefined, undefined)
	};
	return trust;
}

var fragment;
var hasRequiredFragment;

function requireFragment () {
	if (hasRequiredFragment) return fragment;
	hasRequiredFragment = 1;

	var Vnode = requireVnode();
	var hyperscriptVnode = requireHyperscriptVnode();

	fragment = function() {
		var vnode = hyperscriptVnode.apply(0, arguments);

		vnode.tag = "[";
		vnode.children = Vnode.normalizeChildren(vnode.children);
		return vnode
	};
	return fragment;
}

var hyperscript_1;
var hasRequiredHyperscript;

function requireHyperscript () {
	if (hasRequiredHyperscript) return hyperscript_1;
	hasRequiredHyperscript = 1;

	var hyperscript = requireHyperscript$1();

	hyperscript.trust = requireTrust();
	hyperscript.fragment = requireFragment();

	hyperscript_1 = hyperscript;
	return hyperscript_1;
}

var promiseExports = {};
var promise = {
  get exports(){ return promiseExports; },
  set exports(v){ promiseExports = v; },
};

var polyfill;
var hasRequiredPolyfill;

function requirePolyfill () {
	if (hasRequiredPolyfill) return polyfill;
	hasRequiredPolyfill = 1;
	/** @constructor */
	var PromisePolyfill = function(executor) {
		if (!(this instanceof PromisePolyfill)) throw new Error("Promise must be called with 'new'.")
		if (typeof executor !== "function") throw new TypeError("executor must be a function.")

		var self = this, resolvers = [], rejectors = [], resolveCurrent = handler(resolvers, true), rejectCurrent = handler(rejectors, false);
		var instance = self._instance = {resolvers: resolvers, rejectors: rejectors};
		var callAsync = typeof setImmediate === "function" ? setImmediate : setTimeout;
		function handler(list, shouldAbsorb) {
			return function execute(value) {
				var then;
				try {
					if (shouldAbsorb && value != null && (typeof value === "object" || typeof value === "function") && typeof (then = value.then) === "function") {
						if (value === self) throw new TypeError("Promise can't be resolved with itself.")
						executeOnce(then.bind(value));
					}
					else {
						callAsync(function() {
							if (!shouldAbsorb && list.length === 0) console.error("Possible unhandled promise rejection:", value);
							for (var i = 0; i < list.length; i++) list[i](value);
							resolvers.length = 0, rejectors.length = 0;
							instance.state = shouldAbsorb;
							instance.retry = function() {execute(value);};
						});
					}
				}
				catch (e) {
					rejectCurrent(e);
				}
			}
		}
		function executeOnce(then) {
			var runs = 0;
			function run(fn) {
				return function(value) {
					if (runs++ > 0) return
					fn(value);
				}
			}
			var onerror = run(rejectCurrent);
			try {then(run(resolveCurrent), onerror);} catch (e) {onerror(e);}
		}

		executeOnce(executor);
	};
	PromisePolyfill.prototype.then = function(onFulfilled, onRejection) {
		var self = this, instance = self._instance;
		function handle(callback, list, next, state) {
			list.push(function(value) {
				if (typeof callback !== "function") next(value);
				else try {resolveNext(callback(value));} catch (e) {if (rejectNext) rejectNext(e);}
			});
			if (typeof instance.retry === "function" && state === instance.state) instance.retry();
		}
		var resolveNext, rejectNext;
		var promise = new PromisePolyfill(function(resolve, reject) {resolveNext = resolve, rejectNext = reject;});
		handle(onFulfilled, instance.resolvers, resolveNext, true), handle(onRejection, instance.rejectors, rejectNext, false);
		return promise
	};
	PromisePolyfill.prototype.catch = function(onRejection) {
		return this.then(null, onRejection)
	};
	PromisePolyfill.prototype.finally = function(callback) {
		return this.then(
			function(value) {
				return PromisePolyfill.resolve(callback()).then(function() {
					return value
				})
			},
			function(reason) {
				return PromisePolyfill.resolve(callback()).then(function() {
					return PromisePolyfill.reject(reason);
				})
			}
		)
	};
	PromisePolyfill.resolve = function(value) {
		if (value instanceof PromisePolyfill) return value
		return new PromisePolyfill(function(resolve) {resolve(value);})
	};
	PromisePolyfill.reject = function(value) {
		return new PromisePolyfill(function(resolve, reject) {reject(value);})
	};
	PromisePolyfill.all = function(list) {
		return new PromisePolyfill(function(resolve, reject) {
			var total = list.length, count = 0, values = [];
			if (list.length === 0) resolve([]);
			else for (var i = 0; i < list.length; i++) {
				(function(i) {
					function consume(value) {
						count++;
						values[i] = value;
						if (count === total) resolve(values);
					}
					if (list[i] != null && (typeof list[i] === "object" || typeof list[i] === "function") && typeof list[i].then === "function") {
						list[i].then(consume, reject);
					}
					else consume(list[i]);
				})(i);
			}
		})
	};
	PromisePolyfill.race = function(list) {
		return new PromisePolyfill(function(resolve, reject) {
			for (var i = 0; i < list.length; i++) {
				list[i].then(resolve, reject);
			}
		})
	};

	polyfill = PromisePolyfill;
	return polyfill;
}

/* global window */

var hasRequiredPromise;

function requirePromise () {
	if (hasRequiredPromise) return promiseExports;
	hasRequiredPromise = 1;

	var PromisePolyfill = requirePolyfill();

	if (typeof window !== "undefined") {
		if (typeof window.Promise === "undefined") {
			window.Promise = PromisePolyfill;
		} else if (!window.Promise.prototype.finally) {
			window.Promise.prototype.finally = PromisePolyfill.prototype.finally;
		}
		promise.exports = window.Promise;
	} else if (typeof commonjsGlobal !== "undefined") {
		if (typeof commonjsGlobal.Promise === "undefined") {
			commonjsGlobal.Promise = PromisePolyfill;
		} else if (!commonjsGlobal.Promise.prototype.finally) {
			commonjsGlobal.Promise.prototype.finally = PromisePolyfill.prototype.finally;
		}
		promise.exports = commonjsGlobal.Promise;
	} else {
		promise.exports = PromisePolyfill;
	}
	return promiseExports;
}

var render$1;
var hasRequiredRender$1;

function requireRender$1 () {
	if (hasRequiredRender$1) return render$1;
	hasRequiredRender$1 = 1;

	var Vnode = requireVnode();

	render$1 = function($window) {
		var $doc = $window && $window.document;
		var currentRedraw;

		var nameSpace = {
			svg: "http://www.w3.org/2000/svg",
			math: "http://www.w3.org/1998/Math/MathML"
		};

		function getNameSpace(vnode) {
			return vnode.attrs && vnode.attrs.xmlns || nameSpace[vnode.tag]
		}

		//sanity check to discourage people from doing `vnode.state = ...`
		function checkState(vnode, original) {
			if (vnode.state !== original) throw new Error("'vnode.state' must not be modified.")
		}

		//Note: the hook is passed as the `this` argument to allow proxying the
		//arguments without requiring a full array allocation to do so. It also
		//takes advantage of the fact the current `vnode` is the first argument in
		//all lifecycle methods.
		function callHook(vnode) {
			var original = vnode.state;
			try {
				return this.apply(original, arguments)
			} finally {
				checkState(vnode, original);
			}
		}

		// IE11 (at least) throws an UnspecifiedError when accessing document.activeElement when
		// inside an iframe. Catch and swallow this error, and heavy-handidly return null.
		function activeElement() {
			try {
				return $doc.activeElement
			} catch (e) {
				return null
			}
		}
		//create
		function createNodes(parent, vnodes, start, end, hooks, nextSibling, ns) {
			for (var i = start; i < end; i++) {
				var vnode = vnodes[i];
				if (vnode != null) {
					createNode(parent, vnode, hooks, ns, nextSibling);
				}
			}
		}
		function createNode(parent, vnode, hooks, ns, nextSibling) {
			var tag = vnode.tag;
			if (typeof tag === "string") {
				vnode.state = {};
				if (vnode.attrs != null) initLifecycle(vnode.attrs, vnode, hooks);
				switch (tag) {
					case "#": createText(parent, vnode, nextSibling); break
					case "<": createHTML(parent, vnode, ns, nextSibling); break
					case "[": createFragment(parent, vnode, hooks, ns, nextSibling); break
					default: createElement(parent, vnode, hooks, ns, nextSibling);
				}
			}
			else createComponent(parent, vnode, hooks, ns, nextSibling);
		}
		function createText(parent, vnode, nextSibling) {
			vnode.dom = $doc.createTextNode(vnode.children);
			insertNode(parent, vnode.dom, nextSibling);
		}
		var possibleParents = {caption: "table", thead: "table", tbody: "table", tfoot: "table", tr: "tbody", th: "tr", td: "tr", colgroup: "table", col: "colgroup"};
		function createHTML(parent, vnode, ns, nextSibling) {
			var match = vnode.children.match(/^\s*?<(\w+)/im) || [];
			// not using the proper parent makes the child element(s) vanish.
			//     var div = document.createElement("div")
			//     div.innerHTML = "<td>i</td><td>j</td>"
			//     console.log(div.innerHTML)
			// --> "ij", no <td> in sight.
			var temp = $doc.createElement(possibleParents[match[1]] || "div");
			if (ns === "http://www.w3.org/2000/svg") {
				temp.innerHTML = "<svg xmlns=\"http://www.w3.org/2000/svg\">" + vnode.children + "</svg>";
				temp = temp.firstChild;
			} else {
				temp.innerHTML = vnode.children;
			}
			vnode.dom = temp.firstChild;
			vnode.domSize = temp.childNodes.length;
			// Capture nodes to remove, so we don't confuse them.
			vnode.instance = [];
			var fragment = $doc.createDocumentFragment();
			var child;
			while (child = temp.firstChild) {
				vnode.instance.push(child);
				fragment.appendChild(child);
			}
			insertNode(parent, fragment, nextSibling);
		}
		function createFragment(parent, vnode, hooks, ns, nextSibling) {
			var fragment = $doc.createDocumentFragment();
			if (vnode.children != null) {
				var children = vnode.children;
				createNodes(fragment, children, 0, children.length, hooks, null, ns);
			}
			vnode.dom = fragment.firstChild;
			vnode.domSize = fragment.childNodes.length;
			insertNode(parent, fragment, nextSibling);
		}
		function createElement(parent, vnode, hooks, ns, nextSibling) {
			var tag = vnode.tag;
			var attrs = vnode.attrs;
			var is = attrs && attrs.is;

			ns = getNameSpace(vnode) || ns;

			var element = ns ?
				is ? $doc.createElementNS(ns, tag, {is: is}) : $doc.createElementNS(ns, tag) :
				is ? $doc.createElement(tag, {is: is}) : $doc.createElement(tag);
			vnode.dom = element;

			if (attrs != null) {
				setAttrs(vnode, attrs, ns);
			}

			insertNode(parent, element, nextSibling);

			if (!maybeSetContentEditable(vnode)) {
				if (vnode.children != null) {
					var children = vnode.children;
					createNodes(element, children, 0, children.length, hooks, null, ns);
					if (vnode.tag === "select" && attrs != null) setLateSelectAttrs(vnode, attrs);
				}
			}
		}
		function initComponent(vnode, hooks) {
			var sentinel;
			if (typeof vnode.tag.view === "function") {
				vnode.state = Object.create(vnode.tag);
				sentinel = vnode.state.view;
				if (sentinel.$$reentrantLock$$ != null) return
				sentinel.$$reentrantLock$$ = true;
			} else {
				vnode.state = void 0;
				sentinel = vnode.tag;
				if (sentinel.$$reentrantLock$$ != null) return
				sentinel.$$reentrantLock$$ = true;
				vnode.state = (vnode.tag.prototype != null && typeof vnode.tag.prototype.view === "function") ? new vnode.tag(vnode) : vnode.tag(vnode);
			}
			initLifecycle(vnode.state, vnode, hooks);
			if (vnode.attrs != null) initLifecycle(vnode.attrs, vnode, hooks);
			vnode.instance = Vnode.normalize(callHook.call(vnode.state.view, vnode));
			if (vnode.instance === vnode) throw Error("A view cannot return the vnode it received as argument")
			sentinel.$$reentrantLock$$ = null;
		}
		function createComponent(parent, vnode, hooks, ns, nextSibling) {
			initComponent(vnode, hooks);
			if (vnode.instance != null) {
				createNode(parent, vnode.instance, hooks, ns, nextSibling);
				vnode.dom = vnode.instance.dom;
				vnode.domSize = vnode.dom != null ? vnode.instance.domSize : 0;
			}
			else {
				vnode.domSize = 0;
			}
		}

		//update
		/**
		 * @param {Element|Fragment} parent - the parent element
		 * @param {Vnode[] | null} old - the list of vnodes of the last `render()` call for
		 *                               this part of the tree
		 * @param {Vnode[] | null} vnodes - as above, but for the current `render()` call.
		 * @param {Function[]} hooks - an accumulator of post-render hooks (oncreate/onupdate)
		 * @param {Element | null} nextSibling - the next DOM node if we're dealing with a
		 *                                       fragment that is not the last item in its
		 *                                       parent
		 * @param {'svg' | 'math' | String | null} ns) - the current XML namespace, if any
		 * @returns void
		 */
		// This function diffs and patches lists of vnodes, both keyed and unkeyed.
		//
		// We will:
		//
		// 1. describe its general structure
		// 2. focus on the diff algorithm optimizations
		// 3. discuss DOM node operations.

		// ## Overview:
		//
		// The updateNodes() function:
		// - deals with trivial cases
		// - determines whether the lists are keyed or unkeyed based on the first non-null node
		//   of each list.
		// - diffs them and patches the DOM if needed (that's the brunt of the code)
		// - manages the leftovers: after diffing, are there:
		//   - old nodes left to remove?
		// 	 - new nodes to insert?
		// 	 deal with them!
		//
		// The lists are only iterated over once, with an exception for the nodes in `old` that
		// are visited in the fourth part of the diff and in the `removeNodes` loop.

		// ## Diffing
		//
		// Reading https://github.com/localvoid/ivi/blob/ddc09d06abaef45248e6133f7040d00d3c6be853/packages/ivi/src/vdom/implementation.ts#L617-L837
		// may be good for context on longest increasing subsequence-based logic for moving nodes.
		//
		// In order to diff keyed lists, one has to
		//
		// 1) match nodes in both lists, per key, and update them accordingly
		// 2) create the nodes present in the new list, but absent in the old one
		// 3) remove the nodes present in the old list, but absent in the new one
		// 4) figure out what nodes in 1) to move in order to minimize the DOM operations.
		//
		// To achieve 1) one can create a dictionary of keys => index (for the old list), then iterate
		// over the new list and for each new vnode, find the corresponding vnode in the old list using
		// the map.
		// 2) is achieved in the same step: if a new node has no corresponding entry in the map, it is new
		// and must be created.
		// For the removals, we actually remove the nodes that have been updated from the old list.
		// The nodes that remain in that list after 1) and 2) have been performed can be safely removed.
		// The fourth step is a bit more complex and relies on the longest increasing subsequence (LIS)
		// algorithm.
		//
		// the longest increasing subsequence is the list of nodes that can remain in place. Imagine going
		// from `1,2,3,4,5` to `4,5,1,2,3` where the numbers are not necessarily the keys, but the indices
		// corresponding to the keyed nodes in the old list (keyed nodes `e,d,c,b,a` => `b,a,e,d,c` would
		//  match the above lists, for example).
		//
		// In there are two increasing subsequences: `4,5` and `1,2,3`, the latter being the longest. We
		// can update those nodes without moving them, and only call `insertNode` on `4` and `5`.
		//
		// @localvoid adapted the algo to also support node deletions and insertions (the `lis` is actually
		// the longest increasing subsequence *of old nodes still present in the new list*).
		//
		// It is a general algorithm that is fireproof in all circumstances, but it requires the allocation
		// and the construction of a `key => oldIndex` map, and three arrays (one with `newIndex => oldIndex`,
		// the `LIS` and a temporary one to create the LIS).
		//
		// So we cheat where we can: if the tails of the lists are identical, they are guaranteed to be part of
		// the LIS and can be updated without moving them.
		//
		// If two nodes are swapped, they are guaranteed not to be part of the LIS, and must be moved (with
		// the exception of the last node if the list is fully reversed).
		//
		// ## Finding the next sibling.
		//
		// `updateNode()` and `createNode()` expect a nextSibling parameter to perform DOM operations.
		// When the list is being traversed top-down, at any index, the DOM nodes up to the previous
		// vnode reflect the content of the new list, whereas the rest of the DOM nodes reflect the old
		// list. The next sibling must be looked for in the old list using `getNextSibling(... oldStart + 1 ...)`.
		//
		// In the other scenarios (swaps, upwards traversal, map-based diff),
		// the new vnodes list is traversed upwards. The DOM nodes at the bottom of the list reflect the
		// bottom part of the new vnodes list, and we can use the `v.dom`  value of the previous node
		// as the next sibling (cached in the `nextSibling` variable).


		// ## DOM node moves
		//
		// In most scenarios `updateNode()` and `createNode()` perform the DOM operations. However,
		// this is not the case if the node moved (second and fourth part of the diff algo). We move
		// the old DOM nodes before updateNode runs because it enables us to use the cached `nextSibling`
		// variable rather than fetching it using `getNextSibling()`.
		//
		// The fourth part of the diff currently inserts nodes unconditionally, leading to issues
		// like #1791 and #1999. We need to be smarter about those situations where adjascent old
		// nodes remain together in the new list in a way that isn't covered by parts one and
		// three of the diff algo.

		function updateNodes(parent, old, vnodes, hooks, nextSibling, ns) {
			if (old === vnodes || old == null && vnodes == null) return
			else if (old == null || old.length === 0) createNodes(parent, vnodes, 0, vnodes.length, hooks, nextSibling, ns);
			else if (vnodes == null || vnodes.length === 0) removeNodes(parent, old, 0, old.length);
			else {
				var isOldKeyed = old[0] != null && old[0].key != null;
				var isKeyed = vnodes[0] != null && vnodes[0].key != null;
				var start = 0, oldStart = 0;
				if (!isOldKeyed) while (oldStart < old.length && old[oldStart] == null) oldStart++;
				if (!isKeyed) while (start < vnodes.length && vnodes[start] == null) start++;
				if (isOldKeyed !== isKeyed) {
					removeNodes(parent, old, oldStart, old.length);
					createNodes(parent, vnodes, start, vnodes.length, hooks, nextSibling, ns);
				} else if (!isKeyed) {
					// Don't index past the end of either list (causes deopts).
					var commonLength = old.length < vnodes.length ? old.length : vnodes.length;
					// Rewind if necessary to the first non-null index on either side.
					// We could alternatively either explicitly create or remove nodes when `start !== oldStart`
					// but that would be optimizing for sparse lists which are more rare than dense ones.
					start = start < oldStart ? start : oldStart;
					for (; start < commonLength; start++) {
						o = old[start];
						v = vnodes[start];
						if (o === v || o == null && v == null) continue
						else if (o == null) createNode(parent, v, hooks, ns, getNextSibling(old, start + 1, nextSibling));
						else if (v == null) removeNode(parent, o);
						else updateNode(parent, o, v, hooks, getNextSibling(old, start + 1, nextSibling), ns);
					}
					if (old.length > commonLength) removeNodes(parent, old, start, old.length);
					if (vnodes.length > commonLength) createNodes(parent, vnodes, start, vnodes.length, hooks, nextSibling, ns);
				} else {
					// keyed diff
					var oldEnd = old.length - 1, end = vnodes.length - 1, map, o, v, oe, ve, topSibling;

					// bottom-up
					while (oldEnd >= oldStart && end >= start) {
						oe = old[oldEnd];
						ve = vnodes[end];
						if (oe.key !== ve.key) break
						if (oe !== ve) updateNode(parent, oe, ve, hooks, nextSibling, ns);
						if (ve.dom != null) nextSibling = ve.dom;
						oldEnd--, end--;
					}
					// top-down
					while (oldEnd >= oldStart && end >= start) {
						o = old[oldStart];
						v = vnodes[start];
						if (o.key !== v.key) break
						oldStart++, start++;
						if (o !== v) updateNode(parent, o, v, hooks, getNextSibling(old, oldStart, nextSibling), ns);
					}
					// swaps and list reversals
					while (oldEnd >= oldStart && end >= start) {
						if (start === end) break
						if (o.key !== ve.key || oe.key !== v.key) break
						topSibling = getNextSibling(old, oldStart, nextSibling);
						moveNodes(parent, oe, topSibling);
						if (oe !== v) updateNode(parent, oe, v, hooks, topSibling, ns);
						if (++start <= --end) moveNodes(parent, o, nextSibling);
						if (o !== ve) updateNode(parent, o, ve, hooks, nextSibling, ns);
						if (ve.dom != null) nextSibling = ve.dom;
						oldStart++; oldEnd--;
						oe = old[oldEnd];
						ve = vnodes[end];
						o = old[oldStart];
						v = vnodes[start];
					}
					// bottom up once again
					while (oldEnd >= oldStart && end >= start) {
						if (oe.key !== ve.key) break
						if (oe !== ve) updateNode(parent, oe, ve, hooks, nextSibling, ns);
						if (ve.dom != null) nextSibling = ve.dom;
						oldEnd--, end--;
						oe = old[oldEnd];
						ve = vnodes[end];
					}
					if (start > end) removeNodes(parent, old, oldStart, oldEnd + 1);
					else if (oldStart > oldEnd) createNodes(parent, vnodes, start, end + 1, hooks, nextSibling, ns);
					else {
						// inspired by ivi https://github.com/ivijs/ivi/ by Boris Kaul
						var originalNextSibling = nextSibling, vnodesLength = end - start + 1, oldIndices = new Array(vnodesLength), li=0, i=0, pos = 2147483647, matched = 0, map, lisIndices;
						for (i = 0; i < vnodesLength; i++) oldIndices[i] = -1;
						for (i = end; i >= start; i--) {
							if (map == null) map = getKeyMap(old, oldStart, oldEnd + 1);
							ve = vnodes[i];
							var oldIndex = map[ve.key];
							if (oldIndex != null) {
								pos = (oldIndex < pos) ? oldIndex : -1; // becomes -1 if nodes were re-ordered
								oldIndices[i-start] = oldIndex;
								oe = old[oldIndex];
								old[oldIndex] = null;
								if (oe !== ve) updateNode(parent, oe, ve, hooks, nextSibling, ns);
								if (ve.dom != null) nextSibling = ve.dom;
								matched++;
							}
						}
						nextSibling = originalNextSibling;
						if (matched !== oldEnd - oldStart + 1) removeNodes(parent, old, oldStart, oldEnd + 1);
						if (matched === 0) createNodes(parent, vnodes, start, end + 1, hooks, nextSibling, ns);
						else {
							if (pos === -1) {
								// the indices of the indices of the items that are part of the
								// longest increasing subsequence in the oldIndices list
								lisIndices = makeLisIndices(oldIndices);
								li = lisIndices.length - 1;
								for (i = end; i >= start; i--) {
									v = vnodes[i];
									if (oldIndices[i-start] === -1) createNode(parent, v, hooks, ns, nextSibling);
									else {
										if (lisIndices[li] === i - start) li--;
										else moveNodes(parent, v, nextSibling);
									}
									if (v.dom != null) nextSibling = vnodes[i].dom;
								}
							} else {
								for (i = end; i >= start; i--) {
									v = vnodes[i];
									if (oldIndices[i-start] === -1) createNode(parent, v, hooks, ns, nextSibling);
									if (v.dom != null) nextSibling = vnodes[i].dom;
								}
							}
						}
					}
				}
			}
		}
		function updateNode(parent, old, vnode, hooks, nextSibling, ns) {
			var oldTag = old.tag, tag = vnode.tag;
			if (oldTag === tag) {
				vnode.state = old.state;
				vnode.events = old.events;
				if (shouldNotUpdate(vnode, old)) return
				if (typeof oldTag === "string") {
					if (vnode.attrs != null) {
						updateLifecycle(vnode.attrs, vnode, hooks);
					}
					switch (oldTag) {
						case "#": updateText(old, vnode); break
						case "<": updateHTML(parent, old, vnode, ns, nextSibling); break
						case "[": updateFragment(parent, old, vnode, hooks, nextSibling, ns); break
						default: updateElement(old, vnode, hooks, ns);
					}
				}
				else updateComponent(parent, old, vnode, hooks, nextSibling, ns);
			}
			else {
				removeNode(parent, old);
				createNode(parent, vnode, hooks, ns, nextSibling);
			}
		}
		function updateText(old, vnode) {
			if (old.children.toString() !== vnode.children.toString()) {
				old.dom.nodeValue = vnode.children;
			}
			vnode.dom = old.dom;
		}
		function updateHTML(parent, old, vnode, ns, nextSibling) {
			if (old.children !== vnode.children) {
				removeHTML(parent, old);
				createHTML(parent, vnode, ns, nextSibling);
			}
			else {
				vnode.dom = old.dom;
				vnode.domSize = old.domSize;
				vnode.instance = old.instance;
			}
		}
		function updateFragment(parent, old, vnode, hooks, nextSibling, ns) {
			updateNodes(parent, old.children, vnode.children, hooks, nextSibling, ns);
			var domSize = 0, children = vnode.children;
			vnode.dom = null;
			if (children != null) {
				for (var i = 0; i < children.length; i++) {
					var child = children[i];
					if (child != null && child.dom != null) {
						if (vnode.dom == null) vnode.dom = child.dom;
						domSize += child.domSize || 1;
					}
				}
				if (domSize !== 1) vnode.domSize = domSize;
			}
		}
		function updateElement(old, vnode, hooks, ns) {
			var element = vnode.dom = old.dom;
			ns = getNameSpace(vnode) || ns;

			if (vnode.tag === "textarea") {
				if (vnode.attrs == null) vnode.attrs = {};
			}
			updateAttrs(vnode, old.attrs, vnode.attrs, ns);
			if (!maybeSetContentEditable(vnode)) {
				updateNodes(element, old.children, vnode.children, hooks, null, ns);
			}
		}
		function updateComponent(parent, old, vnode, hooks, nextSibling, ns) {
			vnode.instance = Vnode.normalize(callHook.call(vnode.state.view, vnode));
			if (vnode.instance === vnode) throw Error("A view cannot return the vnode it received as argument")
			updateLifecycle(vnode.state, vnode, hooks);
			if (vnode.attrs != null) updateLifecycle(vnode.attrs, vnode, hooks);
			if (vnode.instance != null) {
				if (old.instance == null) createNode(parent, vnode.instance, hooks, ns, nextSibling);
				else updateNode(parent, old.instance, vnode.instance, hooks, nextSibling, ns);
				vnode.dom = vnode.instance.dom;
				vnode.domSize = vnode.instance.domSize;
			}
			else if (old.instance != null) {
				removeNode(parent, old.instance);
				vnode.dom = undefined;
				vnode.domSize = 0;
			}
			else {
				vnode.dom = old.dom;
				vnode.domSize = old.domSize;
			}
		}
		function getKeyMap(vnodes, start, end) {
			var map = Object.create(null);
			for (; start < end; start++) {
				var vnode = vnodes[start];
				if (vnode != null) {
					var key = vnode.key;
					if (key != null) map[key] = start;
				}
			}
			return map
		}
		// Lifted from ivi https://github.com/ivijs/ivi/
		// takes a list of unique numbers (-1 is special and can
		// occur multiple times) and returns an array with the indices
		// of the items that are part of the longest increasing
		// subsequence
		var lisTemp = [];
		function makeLisIndices(a) {
			var result = [0];
			var u = 0, v = 0, i = 0;
			var il = lisTemp.length = a.length;
			for (var i = 0; i < il; i++) lisTemp[i] = a[i];
			for (var i = 0; i < il; ++i) {
				if (a[i] === -1) continue
				var j = result[result.length - 1];
				if (a[j] < a[i]) {
					lisTemp[i] = j;
					result.push(i);
					continue
				}
				u = 0;
				v = result.length - 1;
				while (u < v) {
					// Fast integer average without overflow.
					// eslint-disable-next-line no-bitwise
					var c = (u >>> 1) + (v >>> 1) + (u & v & 1);
					if (a[result[c]] < a[i]) {
						u = c + 1;
					}
					else {
						v = c;
					}
				}
				if (a[i] < a[result[u]]) {
					if (u > 0) lisTemp[i] = result[u - 1];
					result[u] = i;
				}
			}
			u = result.length;
			v = result[u - 1];
			while (u-- > 0) {
				result[u] = v;
				v = lisTemp[v];
			}
			lisTemp.length = 0;
			return result
		}

		function getNextSibling(vnodes, i, nextSibling) {
			for (; i < vnodes.length; i++) {
				if (vnodes[i] != null && vnodes[i].dom != null) return vnodes[i].dom
			}
			return nextSibling
		}

		// This covers a really specific edge case:
		// - Parent node is keyed and contains child
		// - Child is removed, returns unresolved promise in `onbeforeremove`
		// - Parent node is moved in keyed diff
		// - Remaining children still need moved appropriately
		//
		// Ideally, I'd track removed nodes as well, but that introduces a lot more
		// complexity and I'm not exactly interested in doing that.
		function moveNodes(parent, vnode, nextSibling) {
			var frag = $doc.createDocumentFragment();
			moveChildToFrag(parent, frag, vnode);
			insertNode(parent, frag, nextSibling);
		}
		function moveChildToFrag(parent, frag, vnode) {
			// Dodge the recursion overhead in a few of the most common cases.
			while (vnode.dom != null && vnode.dom.parentNode === parent) {
				if (typeof vnode.tag !== "string") {
					vnode = vnode.instance;
					if (vnode != null) continue
				} else if (vnode.tag === "<") {
					for (var i = 0; i < vnode.instance.length; i++) {
						frag.appendChild(vnode.instance[i]);
					}
				} else if (vnode.tag !== "[") {
					// Don't recurse for text nodes *or* elements, just fragments
					frag.appendChild(vnode.dom);
				} else if (vnode.children.length === 1) {
					vnode = vnode.children[0];
					if (vnode != null) continue
				} else {
					for (var i = 0; i < vnode.children.length; i++) {
						var child = vnode.children[i];
						if (child != null) moveChildToFrag(parent, frag, child);
					}
				}
				break
			}
		}

		function insertNode(parent, dom, nextSibling) {
			if (nextSibling != null) parent.insertBefore(dom, nextSibling);
			else parent.appendChild(dom);
		}

		function maybeSetContentEditable(vnode) {
			if (vnode.attrs == null || (
				vnode.attrs.contenteditable == null && // attribute
				vnode.attrs.contentEditable == null // property
			)) return false
			var children = vnode.children;
			if (children != null && children.length === 1 && children[0].tag === "<") {
				var content = children[0].children;
				if (vnode.dom.innerHTML !== content) vnode.dom.innerHTML = content;
			}
			else if (children != null && children.length !== 0) throw new Error("Child node of a contenteditable must be trusted.")
			return true
		}

		//remove
		function removeNodes(parent, vnodes, start, end) {
			for (var i = start; i < end; i++) {
				var vnode = vnodes[i];
				if (vnode != null) removeNode(parent, vnode);
			}
		}
		function removeNode(parent, vnode) {
			var mask = 0;
			var original = vnode.state;
			var stateResult, attrsResult;
			if (typeof vnode.tag !== "string" && typeof vnode.state.onbeforeremove === "function") {
				var result = callHook.call(vnode.state.onbeforeremove, vnode);
				if (result != null && typeof result.then === "function") {
					mask = 1;
					stateResult = result;
				}
			}
			if (vnode.attrs && typeof vnode.attrs.onbeforeremove === "function") {
				var result = callHook.call(vnode.attrs.onbeforeremove, vnode);
				if (result != null && typeof result.then === "function") {
					// eslint-disable-next-line no-bitwise
					mask |= 2;
					attrsResult = result;
				}
			}
			checkState(vnode, original);

			// If we can, try to fast-path it and avoid all the overhead of awaiting
			if (!mask) {
				onremove(vnode);
				removeChild(parent, vnode);
			} else {
				if (stateResult != null) {
					var next = function () {
						// eslint-disable-next-line no-bitwise
						if (mask & 1) { mask &= 2; if (!mask) reallyRemove(); }
					};
					stateResult.then(next, next);
				}
				if (attrsResult != null) {
					var next = function () {
						// eslint-disable-next-line no-bitwise
						if (mask & 2) { mask &= 1; if (!mask) reallyRemove(); }
					};
					attrsResult.then(next, next);
				}
			}

			function reallyRemove() {
				checkState(vnode, original);
				onremove(vnode);
				removeChild(parent, vnode);
			}
		}
		function removeHTML(parent, vnode) {
			for (var i = 0; i < vnode.instance.length; i++) {
				parent.removeChild(vnode.instance[i]);
			}
		}
		function removeChild(parent, vnode) {
			// Dodge the recursion overhead in a few of the most common cases.
			while (vnode.dom != null && vnode.dom.parentNode === parent) {
				if (typeof vnode.tag !== "string") {
					vnode = vnode.instance;
					if (vnode != null) continue
				} else if (vnode.tag === "<") {
					removeHTML(parent, vnode);
				} else {
					if (vnode.tag !== "[") {
						parent.removeChild(vnode.dom);
						if (!Array.isArray(vnode.children)) break
					}
					if (vnode.children.length === 1) {
						vnode = vnode.children[0];
						if (vnode != null) continue
					} else {
						for (var i = 0; i < vnode.children.length; i++) {
							var child = vnode.children[i];
							if (child != null) removeChild(parent, child);
						}
					}
				}
				break
			}
		}
		function onremove(vnode) {
			if (typeof vnode.tag !== "string" && typeof vnode.state.onremove === "function") callHook.call(vnode.state.onremove, vnode);
			if (vnode.attrs && typeof vnode.attrs.onremove === "function") callHook.call(vnode.attrs.onremove, vnode);
			if (typeof vnode.tag !== "string") {
				if (vnode.instance != null) onremove(vnode.instance);
			} else {
				var children = vnode.children;
				if (Array.isArray(children)) {
					for (var i = 0; i < children.length; i++) {
						var child = children[i];
						if (child != null) onremove(child);
					}
				}
			}
		}

		//attrs
		function setAttrs(vnode, attrs, ns) {
			// If you assign an input type that is not supported by IE 11 with an assignment expression, an error will occur.
			//
			// Also, the DOM does things to inputs based on the value, so it needs set first.
			// See: https://github.com/MithrilJS/mithril.js/issues/2622
			if (vnode.tag === "input" && attrs.type != null) vnode.dom.setAttribute("type", attrs.type);
			var isFileInput = attrs != null && vnode.tag === "input" && attrs.type === "file";
			for (var key in attrs) {
				setAttr(vnode, key, null, attrs[key], ns, isFileInput);
			}
		}
		function setAttr(vnode, key, old, value, ns, isFileInput) {
			if (key === "key" || key === "is" || value == null || isLifecycleMethod(key) || (old === value && !isFormAttribute(vnode, key)) && typeof value !== "object" || key === "type" && vnode.tag === "input") return
			if (key[0] === "o" && key[1] === "n") return updateEvent(vnode, key, value)
			if (key.slice(0, 6) === "xlink:") vnode.dom.setAttributeNS("http://www.w3.org/1999/xlink", key.slice(6), value);
			else if (key === "style") updateStyle(vnode.dom, old, value);
			else if (hasPropertyKey(vnode, key, ns)) {
				if (key === "value") {
					// Only do the coercion if we're actually going to check the value.
					/* eslint-disable no-implicit-coercion */
					//setting input[value] to same value by typing on focused element moves cursor to end in Chrome
					//setting input[type=file][value] to same value causes an error to be generated if it's non-empty
					if ((vnode.tag === "input" || vnode.tag === "textarea") && vnode.dom.value === "" + value && (isFileInput || vnode.dom === activeElement())) return
					//setting select[value] to same value while having select open blinks select dropdown in Chrome
					if (vnode.tag === "select" && old !== null && vnode.dom.value === "" + value) return
					//setting option[value] to same value while having select open blinks select dropdown in Chrome
					if (vnode.tag === "option" && old !== null && vnode.dom.value === "" + value) return
					//setting input[type=file][value] to different value is an error if it's non-empty
					// Not ideal, but it at least works around the most common source of uncaught exceptions for now.
					if (isFileInput && "" + value !== "") { console.error("`value` is read-only on file inputs!"); return }
					/* eslint-enable no-implicit-coercion */
				}
				vnode.dom[key] = value;
			} else {
				if (typeof value === "boolean") {
					if (value) vnode.dom.setAttribute(key, "");
					else vnode.dom.removeAttribute(key);
				}
				else vnode.dom.setAttribute(key === "className" ? "class" : key, value);
			}
		}
		function removeAttr(vnode, key, old, ns) {
			if (key === "key" || key === "is" || old == null || isLifecycleMethod(key)) return
			if (key[0] === "o" && key[1] === "n") updateEvent(vnode, key, undefined);
			else if (key === "style") updateStyle(vnode.dom, old, null);
			else if (
				hasPropertyKey(vnode, key, ns)
				&& key !== "className"
				&& key !== "title" // creates "null" as title
				&& !(key === "value" && (
					vnode.tag === "option"
					|| vnode.tag === "select" && vnode.dom.selectedIndex === -1 && vnode.dom === activeElement()
				))
				&& !(vnode.tag === "input" && key === "type")
			) {
				vnode.dom[key] = null;
			} else {
				var nsLastIndex = key.indexOf(":");
				if (nsLastIndex !== -1) key = key.slice(nsLastIndex + 1);
				if (old !== false) vnode.dom.removeAttribute(key === "className" ? "class" : key);
			}
		}
		function setLateSelectAttrs(vnode, attrs) {
			if ("value" in attrs) {
				if(attrs.value === null) {
					if (vnode.dom.selectedIndex !== -1) vnode.dom.value = null;
				} else {
					var normalized = "" + attrs.value; // eslint-disable-line no-implicit-coercion
					if (vnode.dom.value !== normalized || vnode.dom.selectedIndex === -1) {
						vnode.dom.value = normalized;
					}
				}
			}
			if ("selectedIndex" in attrs) setAttr(vnode, "selectedIndex", null, attrs.selectedIndex, undefined);
		}
		function updateAttrs(vnode, old, attrs, ns) {
			if (old && old === attrs) {
				console.warn("Don't reuse attrs object, use new object for every redraw, this will throw in next major");
			}
			if (attrs != null) {
				// If you assign an input type that is not supported by IE 11 with an assignment expression, an error will occur.
				//
				// Also, the DOM does things to inputs based on the value, so it needs set first.
				// See: https://github.com/MithrilJS/mithril.js/issues/2622
				if (vnode.tag === "input" && attrs.type != null) vnode.dom.setAttribute("type", attrs.type);
				var isFileInput = vnode.tag === "input" && attrs.type === "file";
				for (var key in attrs) {
					setAttr(vnode, key, old && old[key], attrs[key], ns, isFileInput);
				}
			}
			var val;
			if (old != null) {
				for (var key in old) {
					if (((val = old[key]) != null) && (attrs == null || attrs[key] == null)) {
						removeAttr(vnode, key, val, ns);
					}
				}
			}
		}
		function isFormAttribute(vnode, attr) {
			return attr === "value" || attr === "checked" || attr === "selectedIndex" || attr === "selected" && vnode.dom === activeElement() || vnode.tag === "option" && vnode.dom.parentNode === $doc.activeElement
		}
		function isLifecycleMethod(attr) {
			return attr === "oninit" || attr === "oncreate" || attr === "onupdate" || attr === "onremove" || attr === "onbeforeremove" || attr === "onbeforeupdate"
		}
		function hasPropertyKey(vnode, key, ns) {
			// Filter out namespaced keys
			return ns === undefined && (
				// If it's a custom element, just keep it.
				vnode.tag.indexOf("-") > -1 || vnode.attrs != null && vnode.attrs.is ||
				// If it's a normal element, let's try to avoid a few browser bugs.
				key !== "href" && key !== "list" && key !== "form" && key !== "width" && key !== "height"// && key !== "type"
				// Defer the property check until *after* we check everything.
			) && key in vnode.dom
		}

		//style
		var uppercaseRegex = /[A-Z]/g;
		function toLowerCase(capital) { return "-" + capital.toLowerCase() }
		function normalizeKey(key) {
			return key[0] === "-" && key[1] === "-" ? key :
				key === "cssFloat" ? "float" :
					key.replace(uppercaseRegex, toLowerCase)
		}
		function updateStyle(element, old, style) {
			if (old === style) ; else if (style == null) {
				// New style is missing, just clear it.
				element.style.cssText = "";
			} else if (typeof style !== "object") {
				// New style is a string, let engine deal with patching.
				element.style.cssText = style;
			} else if (old == null || typeof old !== "object") {
				// `old` is missing or a string, `style` is an object.
				element.style.cssText = "";
				// Add new style properties
				for (var key in style) {
					var value = style[key];
					if (value != null) element.style.setProperty(normalizeKey(key), String(value));
				}
			} else {
				// Both old & new are (different) objects.
				// Update style properties that have changed
				for (var key in style) {
					var value = style[key];
					if (value != null && (value = String(value)) !== String(old[key])) {
						element.style.setProperty(normalizeKey(key), value);
					}
				}
				// Remove style properties that no longer exist
				for (var key in old) {
					if (old[key] != null && style[key] == null) {
						element.style.removeProperty(normalizeKey(key));
					}
				}
			}
		}

		// Here's an explanation of how this works:
		// 1. The event names are always (by design) prefixed by `on`.
		// 2. The EventListener interface accepts either a function or an object
		//    with a `handleEvent` method.
		// 3. The object does not inherit from `Object.prototype`, to avoid
		//    any potential interference with that (e.g. setters).
		// 4. The event name is remapped to the handler before calling it.
		// 5. In function-based event handlers, `ev.target === this`. We replicate
		//    that below.
		// 6. In function-based event handlers, `return false` prevents the default
		//    action and stops event propagation. We replicate that below.
		function EventDict() {
			// Save this, so the current redraw is correctly tracked.
			this._ = currentRedraw;
		}
		EventDict.prototype = Object.create(null);
		EventDict.prototype.handleEvent = function (ev) {
			var handler = this["on" + ev.type];
			var result;
			if (typeof handler === "function") result = handler.call(ev.currentTarget, ev);
			else if (typeof handler.handleEvent === "function") handler.handleEvent(ev);
			if (this._ && ev.redraw !== false) (0, this._)();
			if (result === false) {
				ev.preventDefault();
				ev.stopPropagation();
			}
		};

		//event
		function updateEvent(vnode, key, value) {
			if (vnode.events != null) {
				vnode.events._ = currentRedraw;
				if (vnode.events[key] === value) return
				if (value != null && (typeof value === "function" || typeof value === "object")) {
					if (vnode.events[key] == null) vnode.dom.addEventListener(key.slice(2), vnode.events, false);
					vnode.events[key] = value;
				} else {
					if (vnode.events[key] != null) vnode.dom.removeEventListener(key.slice(2), vnode.events, false);
					vnode.events[key] = undefined;
				}
			} else if (value != null && (typeof value === "function" || typeof value === "object")) {
				vnode.events = new EventDict();
				vnode.dom.addEventListener(key.slice(2), vnode.events, false);
				vnode.events[key] = value;
			}
		}

		//lifecycle
		function initLifecycle(source, vnode, hooks) {
			if (typeof source.oninit === "function") callHook.call(source.oninit, vnode);
			if (typeof source.oncreate === "function") hooks.push(callHook.bind(source.oncreate, vnode));
		}
		function updateLifecycle(source, vnode, hooks) {
			if (typeof source.onupdate === "function") hooks.push(callHook.bind(source.onupdate, vnode));
		}
		function shouldNotUpdate(vnode, old) {
			do {
				if (vnode.attrs != null && typeof vnode.attrs.onbeforeupdate === "function") {
					var force = callHook.call(vnode.attrs.onbeforeupdate, vnode, old);
					if (force !== undefined && !force) break
				}
				if (typeof vnode.tag !== "string" && typeof vnode.state.onbeforeupdate === "function") {
					var force = callHook.call(vnode.state.onbeforeupdate, vnode, old);
					if (force !== undefined && !force) break
				}
				return false
			} while (false); // eslint-disable-line no-constant-condition
			vnode.dom = old.dom;
			vnode.domSize = old.domSize;
			vnode.instance = old.instance;
			// One would think having the actual latest attributes would be ideal,
			// but it doesn't let us properly diff based on our current internal
			// representation. We have to save not only the old DOM info, but also
			// the attributes used to create it, as we diff *that*, not against the
			// DOM directly (with a few exceptions in `setAttr`). And, of course, we
			// need to save the children and text as they are conceptually not
			// unlike special "attributes" internally.
			vnode.attrs = old.attrs;
			vnode.children = old.children;
			vnode.text = old.text;
			return true
		}

		var currentDOM;

		return function(dom, vnodes, redraw) {
			if (!dom) throw new TypeError("DOM element being rendered to does not exist.")
			if (currentDOM != null && dom.contains(currentDOM)) {
				throw new TypeError("Node is currently being rendered to and thus is locked.")
			}
			var prevRedraw = currentRedraw;
			var prevDOM = currentDOM;
			var hooks = [];
			var active = activeElement();
			var namespace = dom.namespaceURI;

			currentDOM = dom;
			currentRedraw = typeof redraw === "function" ? redraw : undefined;
			try {
				// First time rendering into a node clears it out
				if (dom.vnodes == null) dom.textContent = "";
				vnodes = Vnode.normalizeChildren(Array.isArray(vnodes) ? vnodes : [vnodes]);
				updateNodes(dom, dom.vnodes, vnodes, hooks, null, namespace === "http://www.w3.org/1999/xhtml" ? undefined : namespace);
				dom.vnodes = vnodes;
				// `document.activeElement` can return null: https://html.spec.whatwg.org/multipage/interaction.html#dom-document-activeelement
				if (active != null && activeElement() !== active && typeof active.focus === "function") active.focus();
				for (var i = 0; i < hooks.length; i++) hooks[i]();
			} finally {
				currentRedraw = prevRedraw;
				currentDOM = prevDOM;
			}
		}
	};
	return render$1;
}

var render;
var hasRequiredRender;

function requireRender () {
	if (hasRequiredRender) return render;
	hasRequiredRender = 1;

	render = requireRender$1()(typeof window !== "undefined" ? window : null);
	return render;
}

var mountRedraw$1;
var hasRequiredMountRedraw$1;

function requireMountRedraw$1 () {
	if (hasRequiredMountRedraw$1) return mountRedraw$1;
	hasRequiredMountRedraw$1 = 1;

	var Vnode = requireVnode();

	mountRedraw$1 = function(render, schedule, console) {
		var subscriptions = [];
		var pending = false;
		var offset = -1;

		function sync() {
			for (offset = 0; offset < subscriptions.length; offset += 2) {
				try { render(subscriptions[offset], Vnode(subscriptions[offset + 1]), redraw); }
				catch (e) { console.error(e); }
			}
			offset = -1;
		}

		function redraw() {
			if (!pending) {
				pending = true;
				schedule(function() {
					pending = false;
					sync();
				});
			}
		}

		redraw.sync = sync;

		function mount(root, component) {
			if (component != null && component.view == null && typeof component !== "function") {
				throw new TypeError("m.mount expects a component, not a vnode.")
			}

			var index = subscriptions.indexOf(root);
			if (index >= 0) {
				subscriptions.splice(index, 2);
				if (index <= offset) offset -= 2;
				render(root, []);
			}

			if (component != null) {
				subscriptions.push(root, component);
				render(root, Vnode(component), redraw);
			}
		}

		return {mount: mount, redraw: redraw}
	};
	return mountRedraw$1;
}

var mountRedraw;
var hasRequiredMountRedraw;

function requireMountRedraw () {
	if (hasRequiredMountRedraw) return mountRedraw;
	hasRequiredMountRedraw = 1;

	var render = requireRender();

	mountRedraw = requireMountRedraw$1()(render, typeof requestAnimationFrame !== "undefined" ? requestAnimationFrame : null, typeof console !== "undefined" ? console : null);
	return mountRedraw;
}

var build$1;
var hasRequiredBuild$1;

function requireBuild$1 () {
	if (hasRequiredBuild$1) return build$1;
	hasRequiredBuild$1 = 1;

	build$1 = function(object) {
		if (Object.prototype.toString.call(object) !== "[object Object]") return ""

		var args = [];
		for (var key in object) {
			destructure(key, object[key]);
		}

		return args.join("&")

		function destructure(key, value) {
			if (Array.isArray(value)) {
				for (var i = 0; i < value.length; i++) {
					destructure(key + "[" + i + "]", value[i]);
				}
			}
			else if (Object.prototype.toString.call(value) === "[object Object]") {
				for (var i in value) {
					destructure(key + "[" + i + "]", value[i]);
				}
			}
			else args.push(encodeURIComponent(key) + (value != null && value !== "" ? "=" + encodeURIComponent(value) : ""));
		}
	};
	return build$1;
}

var assign;
var hasRequiredAssign;

function requireAssign () {
	if (hasRequiredAssign) return assign;
	hasRequiredAssign = 1;

	var hasOwn = requireHasOwn();

	assign = Object.assign || function(target, source) {
		for (var key in source) {
			if (hasOwn.call(source, key)) target[key] = source[key];
		}
	};
	return assign;
}

var build;
var hasRequiredBuild;

function requireBuild () {
	if (hasRequiredBuild) return build;
	hasRequiredBuild = 1;

	var buildQueryString = requireBuild$1();
	var assign = requireAssign();

	// Returns `path` from `template` + `params`
	build = function(template, params) {
		if ((/:([^\/\.-]+)(\.{3})?:/).test(template)) {
			throw new SyntaxError("Template parameter names must be separated by either a '/', '-', or '.'.")
		}
		if (params == null) return template
		var queryIndex = template.indexOf("?");
		var hashIndex = template.indexOf("#");
		var queryEnd = hashIndex < 0 ? template.length : hashIndex;
		var pathEnd = queryIndex < 0 ? queryEnd : queryIndex;
		var path = template.slice(0, pathEnd);
		var query = {};

		assign(query, params);

		var resolved = path.replace(/:([^\/\.-]+)(\.{3})?/g, function(m, key, variadic) {
			delete query[key];
			// If no such parameter exists, don't interpolate it.
			if (params[key] == null) return m
			// Escape normal parameters, but not variadic ones.
			return variadic ? params[key] : encodeURIComponent(String(params[key]))
		});

		// In case the template substitution adds new query/hash parameters.
		var newQueryIndex = resolved.indexOf("?");
		var newHashIndex = resolved.indexOf("#");
		var newQueryEnd = newHashIndex < 0 ? resolved.length : newHashIndex;
		var newPathEnd = newQueryIndex < 0 ? newQueryEnd : newQueryIndex;
		var result = resolved.slice(0, newPathEnd);

		if (queryIndex >= 0) result += template.slice(queryIndex, queryEnd);
		if (newQueryIndex >= 0) result += (queryIndex < 0 ? "?" : "&") + resolved.slice(newQueryIndex, newQueryEnd);
		var querystring = buildQueryString(query);
		if (querystring) result += (queryIndex < 0 && newQueryIndex < 0 ? "?" : "&") + querystring;
		if (hashIndex >= 0) result += template.slice(hashIndex);
		if (newHashIndex >= 0) result += (hashIndex < 0 ? "" : "&") + resolved.slice(newHashIndex);
		return result
	};
	return build;
}

var request$1;
var hasRequiredRequest$1;

function requireRequest$1 () {
	if (hasRequiredRequest$1) return request$1;
	hasRequiredRequest$1 = 1;

	var buildPathname = requireBuild();
	var hasOwn = requireHasOwn();

	request$1 = function($window, Promise, oncompletion) {
		var callbackCount = 0;

		function PromiseProxy(executor) {
			return new Promise(executor)
		}

		// In case the global Promise is some userland library's where they rely on
		// `foo instanceof this.constructor`, `this.constructor.resolve(value)`, or
		// similar. Let's *not* break them.
		PromiseProxy.prototype = Promise.prototype;
		PromiseProxy.__proto__ = Promise; // eslint-disable-line no-proto

		function makeRequest(factory) {
			return function(url, args) {
				if (typeof url !== "string") { args = url; url = url.url; }
				else if (args == null) args = {};
				var promise = new Promise(function(resolve, reject) {
					factory(buildPathname(url, args.params), args, function (data) {
						if (typeof args.type === "function") {
							if (Array.isArray(data)) {
								for (var i = 0; i < data.length; i++) {
									data[i] = new args.type(data[i]);
								}
							}
							else data = new args.type(data);
						}
						resolve(data);
					}, reject);
				});
				if (args.background === true) return promise
				var count = 0;
				function complete() {
					if (--count === 0 && typeof oncompletion === "function") oncompletion();
				}

				return wrap(promise)

				function wrap(promise) {
					var then = promise.then;
					// Set the constructor, so engines know to not await or resolve
					// this as a native promise. At the time of writing, this is
					// only necessary for V8, but their behavior is the correct
					// behavior per spec. See this spec issue for more details:
					// https://github.com/tc39/ecma262/issues/1577. Also, see the
					// corresponding comment in `request/tests/test-request.js` for
					// a bit more background on the issue at hand.
					promise.constructor = PromiseProxy;
					promise.then = function() {
						count++;
						var next = then.apply(promise, arguments);
						next.then(complete, function(e) {
							complete();
							if (count === 0) throw e
						});
						return wrap(next)
					};
					return promise
				}
			}
		}

		function hasHeader(args, name) {
			for (var key in args.headers) {
				if (hasOwn.call(args.headers, key) && key.toLowerCase() === name) return true
			}
			return false
		}

		return {
			request: makeRequest(function(url, args, resolve, reject) {
				var method = args.method != null ? args.method.toUpperCase() : "GET";
				var body = args.body;
				var assumeJSON = (args.serialize == null || args.serialize === JSON.serialize) && !(body instanceof $window.FormData || body instanceof $window.URLSearchParams);
				var responseType = args.responseType || (typeof args.extract === "function" ? "" : "json");

				var xhr = new $window.XMLHttpRequest(), aborted = false, isTimeout = false;
				var original = xhr, replacedAbort;
				var abort = xhr.abort;

				xhr.abort = function() {
					aborted = true;
					abort.call(this);
				};

				xhr.open(method, url, args.async !== false, typeof args.user === "string" ? args.user : undefined, typeof args.password === "string" ? args.password : undefined);

				if (assumeJSON && body != null && !hasHeader(args, "content-type")) {
					xhr.setRequestHeader("Content-Type", "application/json; charset=utf-8");
				}
				if (typeof args.deserialize !== "function" && !hasHeader(args, "accept")) {
					xhr.setRequestHeader("Accept", "application/json, text/*");
				}
				if (args.withCredentials) xhr.withCredentials = args.withCredentials;
				if (args.timeout) xhr.timeout = args.timeout;
				xhr.responseType = responseType;

				for (var key in args.headers) {
					if (hasOwn.call(args.headers, key)) {
						xhr.setRequestHeader(key, args.headers[key]);
					}
				}

				xhr.onreadystatechange = function(ev) {
					// Don't throw errors on xhr.abort().
					if (aborted) return

					if (ev.target.readyState === 4) {
						try {
							var success = (ev.target.status >= 200 && ev.target.status < 300) || ev.target.status === 304 || (/^file:\/\//i).test(url);
							// When the response type isn't "" or "text",
							// `xhr.responseText` is the wrong thing to use.
							// Browsers do the right thing and throw here, and we
							// should honor that and do the right thing by
							// preferring `xhr.response` where possible/practical.
							var response = ev.target.response, message;

							if (responseType === "json") {
								// For IE and Edge, which don't implement
								// `responseType: "json"`.
								if (!ev.target.responseType && typeof args.extract !== "function") {
									// Handle no-content which will not parse.
									try { response = JSON.parse(ev.target.responseText); }
									catch (e) { response = null; }
								}
							} else if (!responseType || responseType === "text") {
								// Only use this default if it's text. If a parsed
								// document is needed on old IE and friends (all
								// unsupported), the user should use a custom
								// `config` instead. They're already using this at
								// their own risk.
								if (response == null) response = ev.target.responseText;
							}

							if (typeof args.extract === "function") {
								response = args.extract(ev.target, args);
								success = true;
							} else if (typeof args.deserialize === "function") {
								response = args.deserialize(response);
							}
							if (success) resolve(response);
							else {
								var completeErrorResponse = function() {
									try { message = ev.target.responseText; }
									catch (e) { message = response; }
									var error = new Error(message);
									error.code = ev.target.status;
									error.response = response;
									reject(error);
								};

								if (xhr.status === 0) {
									// Use setTimeout to push this code block onto the event queue
									// This allows `xhr.ontimeout` to run in the case that there is a timeout
									// Without this setTimeout, `xhr.ontimeout` doesn't have a chance to reject
									// as `xhr.onreadystatechange` will run before it
									setTimeout(function() {
										if (isTimeout) return
										completeErrorResponse();
									});
								} else completeErrorResponse();
							}
						}
						catch (e) {
							reject(e);
						}
					}
				};

				xhr.ontimeout = function (ev) {
					isTimeout = true;
					var error = new Error("Request timed out");
					error.code = ev.target.status;
					reject(error);
				};

				if (typeof args.config === "function") {
					xhr = args.config(xhr, args, url) || xhr;

					// Propagate the `abort` to any replacement XHR as well.
					if (xhr !== original) {
						replacedAbort = xhr.abort;
						xhr.abort = function() {
							aborted = true;
							replacedAbort.call(this);
						};
					}
				}

				if (body == null) xhr.send();
				else if (typeof args.serialize === "function") xhr.send(args.serialize(body));
				else if (body instanceof $window.FormData || body instanceof $window.URLSearchParams) xhr.send(body);
				else xhr.send(JSON.stringify(body));
			}),
			jsonp: makeRequest(function(url, args, resolve, reject) {
				var callbackName = args.callbackName || "_mithril_" + Math.round(Math.random() * 1e16) + "_" + callbackCount++;
				var script = $window.document.createElement("script");
				$window[callbackName] = function(data) {
					delete $window[callbackName];
					script.parentNode.removeChild(script);
					resolve(data);
				};
				script.onerror = function() {
					delete $window[callbackName];
					script.parentNode.removeChild(script);
					reject(new Error("JSONP request failed"));
				};
				script.src = url + (url.indexOf("?") < 0 ? "?" : "&") +
					encodeURIComponent(args.callbackKey || "callback") + "=" +
					encodeURIComponent(callbackName);
				$window.document.documentElement.appendChild(script);
			}),
		}
	};
	return request$1;
}

var request;
var hasRequiredRequest;

function requireRequest () {
	if (hasRequiredRequest) return request;
	hasRequiredRequest = 1;

	var PromisePolyfill = requirePromise();
	var mountRedraw = requireMountRedraw();

	request = requireRequest$1()(typeof window !== "undefined" ? window : null, PromisePolyfill, mountRedraw.redraw);
	return request;
}

var parse$2;
var hasRequiredParse$2;

function requireParse$2 () {
	if (hasRequiredParse$2) return parse$2;
	hasRequiredParse$2 = 1;

	function decodeURIComponentSave(str) {
		try {
			return decodeURIComponent(str)
		} catch(err) {
			return str
		}
	}

	parse$2 = function(string) {
		if (string === "" || string == null) return {}
		if (string.charAt(0) === "?") string = string.slice(1);

		var entries = string.split("&"), counters = {}, data = {};
		for (var i = 0; i < entries.length; i++) {
			var entry = entries[i].split("=");
			var key = decodeURIComponentSave(entry[0]);
			var value = entry.length === 2 ? decodeURIComponentSave(entry[1]) : "";

			if (value === "true") value = true;
			else if (value === "false") value = false;

			var levels = key.split(/\]\[?|\[/);
			var cursor = data;
			if (key.indexOf("[") > -1) levels.pop();
			for (var j = 0; j < levels.length; j++) {
				var level = levels[j], nextLevel = levels[j + 1];
				var isNumber = nextLevel == "" || !isNaN(parseInt(nextLevel, 10));
				if (level === "") {
					var key = levels.slice(0, j).join();
					if (counters[key] == null) {
						counters[key] = Array.isArray(cursor) ? cursor.length : 0;
					}
					level = counters[key]++;
				}
				// Disallow direct prototype pollution
				else if (level === "__proto__") break
				if (j === levels.length - 1) cursor[level] = value;
				else {
					// Read own properties exclusively to disallow indirect
					// prototype pollution
					var desc = Object.getOwnPropertyDescriptor(cursor, level);
					if (desc != null) desc = desc.value;
					if (desc == null) cursor[level] = desc = isNumber ? [] : {};
					cursor = desc;
				}
			}
		}
		return data
	};
	return parse$2;
}

var parse$1;
var hasRequiredParse$1;

function requireParse$1 () {
	if (hasRequiredParse$1) return parse$1;
	hasRequiredParse$1 = 1;

	var parseQueryString = requireParse$2();

	// Returns `{path, params}` from `url`
	parse$1 = function(url) {
		var queryIndex = url.indexOf("?");
		var hashIndex = url.indexOf("#");
		var queryEnd = hashIndex < 0 ? url.length : hashIndex;
		var pathEnd = queryIndex < 0 ? queryEnd : queryIndex;
		var path = url.slice(0, pathEnd).replace(/\/{2,}/g, "/");

		if (!path) path = "/";
		else {
			if (path[0] !== "/") path = "/" + path;
			if (path.length > 1 && path[path.length - 1] === "/") path = path.slice(0, -1);
		}
		return {
			path: path,
			params: queryIndex < 0
				? {}
				: parseQueryString(url.slice(queryIndex + 1, queryEnd)),
		}
	};
	return parse$1;
}

var compileTemplate;
var hasRequiredCompileTemplate;

function requireCompileTemplate () {
	if (hasRequiredCompileTemplate) return compileTemplate;
	hasRequiredCompileTemplate = 1;

	var parsePathname = requireParse$1();

	// Compiles a template into a function that takes a resolved path (without query
	// strings) and returns an object containing the template parameters with their
	// parsed values. This expects the input of the compiled template to be the
	// output of `parsePathname`. Note that it does *not* remove query parameters
	// specified in the template.
	compileTemplate = function(template) {
		var templateData = parsePathname(template);
		var templateKeys = Object.keys(templateData.params);
		var keys = [];
		var regexp = new RegExp("^" + templateData.path.replace(
			// I escape literal text so people can use things like `:file.:ext` or
			// `:lang-:locale` in routes. This is all merged into one pass so I
			// don't also accidentally escape `-` and make it harder to detect it to
			// ban it from template parameters.
			/:([^\/.-]+)(\.{3}|\.(?!\.)|-)?|[\\^$*+.()|\[\]{}]/g,
			function(m, key, extra) {
				if (key == null) return "\\" + m
				keys.push({k: key, r: extra === "..."});
				if (extra === "...") return "(.*)"
				if (extra === ".") return "([^/]+)\\."
				return "([^/]+)" + (extra || "")
			}
		) + "$");
		return function(data) {
			// First, check the params. Usually, there isn't any, and it's just
			// checking a static set.
			for (var i = 0; i < templateKeys.length; i++) {
				if (templateData.params[templateKeys[i]] !== data.params[templateKeys[i]]) return false
			}
			// If no interpolations exist, let's skip all the ceremony
			if (!keys.length) return regexp.test(data.path)
			var values = regexp.exec(data.path);
			if (values == null) return false
			for (var i = 0; i < keys.length; i++) {
				data.params[keys[i].k] = keys[i].r ? values[i + 1] : decodeURIComponent(values[i + 1]);
			}
			return true
		}
	};
	return compileTemplate;
}

var censor;
var hasRequiredCensor;

function requireCensor () {
	if (hasRequiredCensor) return censor;
	hasRequiredCensor = 1;

	// Note: this is mildly perf-sensitive.
	//
	// It does *not* use `delete` - dynamic `delete`s usually cause objects to bail
	// out into dictionary mode and just generally cause a bunch of optimization
	// issues within engines.
	//
	// Ideally, I would've preferred to do this, if it weren't for the optimization
	// issues:
	//
	// ```js
	// const hasOwn = require("./hasOwn")
	// const magic = [
	//     "key", "oninit", "oncreate", "onbeforeupdate", "onupdate",
	//     "onbeforeremove", "onremove",
	// ]
	// module.exports = (attrs, extras) => {
	//     const result = Object.assign(Object.create(null), attrs)
	//     for (const key of magic) delete result[key]
	//     if (extras != null) for (const key of extras) delete result[key]
	//     return result
	// }
	// ```

	var hasOwn = requireHasOwn();
	// Words in RegExp literals are sometimes mangled incorrectly by the internal bundler, so use RegExp().
	var magic = new RegExp("^(?:key|oninit|oncreate|onbeforeupdate|onupdate|onbeforeremove|onremove)$");

	censor = function(attrs, extras) {
		var result = {};

		if (extras != null) {
			for (var key in attrs) {
				if (hasOwn.call(attrs, key) && !magic.test(key) && extras.indexOf(key) < 0) {
					result[key] = attrs[key];
				}
			}
		} else {
			for (var key in attrs) {
				if (hasOwn.call(attrs, key) && !magic.test(key)) {
					result[key] = attrs[key];
				}
			}
		}

		return result
	};
	return censor;
}

var router$1;
var hasRequiredRouter$1;

function requireRouter$1 () {
	if (hasRequiredRouter$1) return router$1;
	hasRequiredRouter$1 = 1;

	var Vnode = requireVnode();
	var m = requireHyperscript$1();
	var Promise = requirePromise();

	var buildPathname = requireBuild();
	var parsePathname = requireParse$1();
	var compileTemplate = requireCompileTemplate();
	var assign = requireAssign();
	var censor = requireCensor();

	var sentinel = {};

	function decodeURIComponentSave(component) {
		try {
			return decodeURIComponent(component)
		} catch(e) {
			return component
		}
	}

	router$1 = function($window, mountRedraw) {
		var callAsync = $window == null
			// In case Mithril.js' loaded globally without the DOM, let's not break
			? null
			: typeof $window.setImmediate === "function" ? $window.setImmediate : $window.setTimeout;
		var p = Promise.resolve();

		var scheduled = false;

		// state === 0: init
		// state === 1: scheduled
		// state === 2: done
		var ready = false;
		var state = 0;

		var compiled, fallbackRoute;

		var currentResolver = sentinel, component, attrs, currentPath, lastUpdate;

		var RouterRoot = {
			onbeforeupdate: function() {
				state = state ? 2 : 1;
				return !(!state || sentinel === currentResolver)
			},
			onremove: function() {
				$window.removeEventListener("popstate", fireAsync, false);
				$window.removeEventListener("hashchange", resolveRoute, false);
			},
			view: function() {
				if (!state || sentinel === currentResolver) return
				// Wrap in a fragment to preserve existing key semantics
				var vnode = [Vnode(component, attrs.key, attrs)];
				if (currentResolver) vnode = currentResolver.render(vnode[0]);
				return vnode
			},
		};

		var SKIP = route.SKIP = {};

		function resolveRoute() {
			scheduled = false;
			// Consider the pathname holistically. The prefix might even be invalid,
			// but that's not our problem.
			var prefix = $window.location.hash;
			if (route.prefix[0] !== "#") {
				prefix = $window.location.search + prefix;
				if (route.prefix[0] !== "?") {
					prefix = $window.location.pathname + prefix;
					if (prefix[0] !== "/") prefix = "/" + prefix;
				}
			}
			// This seemingly useless `.concat()` speeds up the tests quite a bit,
			// since the representation is consistently a relatively poorly
			// optimized cons string.
			var path = prefix.concat()
				.replace(/(?:%[a-f89][a-f0-9])+/gim, decodeURIComponentSave)
				.slice(route.prefix.length);
			var data = parsePathname(path);

			assign(data.params, $window.history.state);

			function reject(e) {
				console.error(e);
				setPath(fallbackRoute, null, {replace: true});
			}

			loop(0);
			function loop(i) {
				// state === 0: init
				// state === 1: scheduled
				// state === 2: done
				for (; i < compiled.length; i++) {
					if (compiled[i].check(data)) {
						var payload = compiled[i].component;
						var matchedRoute = compiled[i].route;
						var localComp = payload;
						var update = lastUpdate = function(comp) {
							if (update !== lastUpdate) return
							if (comp === SKIP) return loop(i + 1)
							component = comp != null && (typeof comp.view === "function" || typeof comp === "function")? comp : "div";
							attrs = data.params, currentPath = path, lastUpdate = null;
							currentResolver = payload.render ? payload : null;
							if (state === 2) mountRedraw.redraw();
							else {
								state = 2;
								mountRedraw.redraw.sync();
							}
						};
						// There's no understating how much I *wish* I could
						// use `async`/`await` here...
						if (payload.view || typeof payload === "function") {
							payload = {};
							update(localComp);
						}
						else if (payload.onmatch) {
							p.then(function () {
								return payload.onmatch(data.params, path, matchedRoute)
							}).then(update, path === fallbackRoute ? null : reject);
						}
						else update("div");
						return
					}
				}

				if (path === fallbackRoute) {
					throw new Error("Could not resolve default route " + fallbackRoute + ".")
				}
				setPath(fallbackRoute, null, {replace: true});
			}
		}

		// Set it unconditionally so `m.route.set` and `m.route.Link` both work,
		// even if neither `pushState` nor `hashchange` are supported. It's
		// cleared if `hashchange` is used, since that makes it automatically
		// async.
		function fireAsync() {
			if (!scheduled) {
				scheduled = true;
				// TODO: just do `mountRedraw.redraw()` here and elide the timer
				// dependency. Note that this will muck with tests a *lot*, so it's
				// not as easy of a change as it sounds.
				callAsync(resolveRoute);
			}
		}

		function setPath(path, data, options) {
			path = buildPathname(path, data);
			if (ready) {
				fireAsync();
				var state = options ? options.state : null;
				var title = options ? options.title : null;
				if (options && options.replace) $window.history.replaceState(state, title, route.prefix + path);
				else $window.history.pushState(state, title, route.prefix + path);
			}
			else {
				$window.location.href = route.prefix + path;
			}
		}

		function route(root, defaultRoute, routes) {
			if (!root) throw new TypeError("DOM element being rendered to does not exist.")

			compiled = Object.keys(routes).map(function(route) {
				if (route[0] !== "/") throw new SyntaxError("Routes must start with a '/'.")
				if ((/:([^\/\.-]+)(\.{3})?:/).test(route)) {
					throw new SyntaxError("Route parameter names must be separated with either '/', '.', or '-'.")
				}
				return {
					route: route,
					component: routes[route],
					check: compileTemplate(route),
				}
			});
			fallbackRoute = defaultRoute;
			if (defaultRoute != null) {
				var defaultData = parsePathname(defaultRoute);

				if (!compiled.some(function (i) { return i.check(defaultData) })) {
					throw new ReferenceError("Default route doesn't match any known routes.")
				}
			}

			if (typeof $window.history.pushState === "function") {
				$window.addEventListener("popstate", fireAsync, false);
			} else if (route.prefix[0] === "#") {
				$window.addEventListener("hashchange", resolveRoute, false);
			}

			ready = true;
			mountRedraw.mount(root, RouterRoot);
			resolveRoute();
		}
		route.set = function(path, data, options) {
			if (lastUpdate != null) {
				options = options || {};
				options.replace = true;
			}
			lastUpdate = null;
			setPath(path, data, options);
		};
		route.get = function() {return currentPath};
		route.prefix = "#!";
		route.Link = {
			view: function(vnode) {
				// Omit the used parameters from the rendered element - they are
				// internal. Also, censor the various lifecycle methods.
				//
				// We don't strip the other parameters because for convenience we
				// let them be specified in the selector as well.
				var child = m(
					vnode.attrs.selector || "a",
					censor(vnode.attrs, ["options", "params", "selector", "onclick"]),
					vnode.children
				);
				var options, onclick, href;

				// Let's provide a *right* way to disable a route link, rather than
				// letting people screw up accessibility on accident.
				//
				// The attribute is coerced so users don't get surprised over
				// `disabled: 0` resulting in a button that's somehow routable
				// despite being visibly disabled.
				if (child.attrs.disabled = Boolean(child.attrs.disabled)) {
					child.attrs.href = null;
					child.attrs["aria-disabled"] = "true";
					// If you *really* do want add `onclick` on a disabled link, use
					// an `oncreate` hook to add it.
				} else {
					options = vnode.attrs.options;
					onclick = vnode.attrs.onclick;
					// Easier to build it now to keep it isomorphic.
					href = buildPathname(child.attrs.href, vnode.attrs.params);
					child.attrs.href = route.prefix + href;
					child.attrs.onclick = function(e) {
						var result;
						if (typeof onclick === "function") {
							result = onclick.call(e.currentTarget, e);
						} else if (onclick == null || typeof onclick !== "object") ; else if (typeof onclick.handleEvent === "function") {
							onclick.handleEvent(e);
						}

						// Adapted from React Router's implementation:
						// https://github.com/ReactTraining/react-router/blob/520a0acd48ae1b066eb0b07d6d4d1790a1d02482/packages/react-router-dom/modules/Link.js
						//
						// Try to be flexible and intuitive in how we handle links.
						// Fun fact: links aren't as obvious to get right as you
						// would expect. There's a lot more valid ways to click a
						// link than this, and one might want to not simply click a
						// link, but right click or command-click it to copy the
						// link target, etc. Nope, this isn't just for blind people.
						if (
							// Skip if `onclick` prevented default
							result !== false && !e.defaultPrevented &&
							// Ignore everything but left clicks
							(e.button === 0 || e.which === 0 || e.which === 1) &&
							// Let the browser handle `target=_blank`, etc.
							(!e.currentTarget.target || e.currentTarget.target === "_self") &&
							// No modifier keys
							!e.ctrlKey && !e.metaKey && !e.shiftKey && !e.altKey
						) {
							e.preventDefault();
							e.redraw = false;
							route.set(href, null, options);
						}
					};
				}
				return child
			},
		};
		route.param = function(key) {
			return attrs && key != null ? attrs[key] : attrs
		};

		return route
	};
	return router$1;
}

var route$1;
var hasRequiredRoute$1;

function requireRoute$1 () {
	if (hasRequiredRoute$1) return route$1;
	hasRequiredRoute$1 = 1;

	var mountRedraw = requireMountRedraw();

	route$1 = requireRouter$1()(typeof window !== "undefined" ? window : null, mountRedraw);
	return route$1;
}

var mithril;
var hasRequiredMithril;

function requireMithril () {
	if (hasRequiredMithril) return mithril;
	hasRequiredMithril = 1;

	var hyperscript = requireHyperscript();
	var request = requireRequest();
	var mountRedraw = requireMountRedraw();

	var m = function m() { return hyperscript.apply(this, arguments) };
	m.m = hyperscript;
	m.trust = hyperscript.trust;
	m.fragment = hyperscript.fragment;
	m.Fragment = "[";
	m.mount = mountRedraw.mount;
	m.route = requireRoute$1();
	m.render = requireRender();
	m.redraw = mountRedraw.redraw;
	m.request = request.request;
	m.jsonp = request.jsonp;
	m.parseQueryString = requireParse$2();
	m.buildQueryString = requireBuild$1();
	m.parsePathname = requireParse$1();
	m.buildPathname = requireBuild();
	m.vnode = requireVnode();
	m.PromisePolyfill = requirePolyfill();
	m.censor = requireCensor();

	mithril = m;
	return mithril;
}

var actions = {};

var globals = {};

var conversion_jobs = {};

var hasRequiredConversion_jobs;

function requireConversion_jobs () {
	if (hasRequiredConversion_jobs) return conversion_jobs;
	hasRequiredConversion_jobs = 1;
	(function (exports) {
		// Copyright (C) 2021 The Android Open Source Project
		//
		// Licensed under the Apache License, Version 2.0 (the "License");
		// you may not use this file except in compliance with the License.
		// You may obtain a copy of the License at
		//
		//      http://www.apache.org/licenses/LICENSE-2.0
		//
		// Unless required by applicable law or agreed to in writing, software
		// distributed under the License is distributed on an "AS IS" BASIS,
		// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
		// See the License for the specific language governing permissions and
		// limitations under the License.
		Object.defineProperty(exports, "__esModule", { value: true });
		exports.ConversionJobStatus = void 0;
		(function (ConversionJobStatus) {
		    ConversionJobStatus["InProgress"] = "InProgress";
		    ConversionJobStatus["NotRunning"] = "NotRunning";
		})(exports.ConversionJobStatus || (exports.ConversionJobStatus = {}));
		
} (conversion_jobs));
	return conversion_jobs;
}

var empty_state$1 = {};

var record_config_types = {};

var validators = {};

var hasRequiredValidators;

function requireValidators () {
	if (hasRequiredValidators) return validators;
	hasRequiredValidators = 1;
	// Copyright (C) 2021 The Android Open Source Project
	//
	// Licensed under the Apache License, Version 2.0 (the "License");
	// you may not use this file except in compliance with the License.
	// You may obtain a copy of the License at
	//
	//      http://www.apache.org/licenses/LICENSE-2.0
	//
	// Unless required by applicable law or agreed to in writing, software
	// distributed under the License is distributed on an "AS IS" BASIS,
	// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	// See the License for the specific language governing permissions and
	// limitations under the License.
	Object.defineProperty(validators, "__esModule", { value: true });
	validators.arrayOf = validators.oneOf = validators.record = validators.bool = validators.num = validators.requiredStr = validators.str = validators.runValidator = validators.ValidationError = void 0;
	// Helper function to flatten array of path chunks into a single string
	// Example: ["config", "androidLogBuffers", "1"] is mapped to
	// "config.androidLogBuffers[1]".
	function renderPath(path) {
	    let result = '';
	    for (let i = 0; i < path.length; i++) {
	        if (i > 0 && !path[i].startsWith('[')) {
	            result += '.';
	        }
	        result += path[i];
	    }
	    return result;
	}
	class ValidationError extends Error {
	}
	validators.ValidationError = ValidationError;
	// Abstract class for validating simple values, such as strings and booleans.
	// Allows to avoid repetition of most of the code related to validation of
	// these.
	class PrimitiveValidator {
	    constructor(defaultValue, required) {
	        this.defaultValue = defaultValue;
	        this.required = required;
	    }
	    validate(input, context) {
	        if (this.predicate(input)) {
	            return input;
	        }
	        if (this.required) {
	            throw new ValidationError(renderPath(context.path));
	        }
	        if (input !== undefined) {
	            // The value is defined, but does not conform to the expected type;
	            // proceed with returning the default value but report the key.
	            context.invalidKeys.push(renderPath(context.path));
	        }
	        return this.defaultValue;
	    }
	}
	class StringValidator extends PrimitiveValidator {
	    predicate(input) {
	        return typeof input === 'string';
	    }
	}
	class NumberValidator extends PrimitiveValidator {
	    predicate(input) {
	        return typeof input === 'number';
	    }
	}
	class BooleanValidator extends PrimitiveValidator {
	    predicate(input) {
	        return typeof input === 'boolean';
	    }
	}
	// Combinator for validators: takes a record of validators, and returns a
	// validator for a record where record's fields passed to validator with the
	// same name.
	//
	// Generic parameter T is instantiated to type of record of validators, and
	// should be provided implicitly by type inference due to verbosity of its
	// instantiations.
	class RecordValidator {
	    constructor(validators) {
	        this.validators = validators;
	    }
	    validate(input, context) {
	        // If value is missing or of incorrect type, empty record is still processed
	        // in the loop below to initialize default fields of the nested object.
	        let o = {};
	        if (typeof input === 'object' && input !== null) {
	            o = input;
	        }
	        else if (input !== undefined) {
	            context.invalidKeys.push(renderPath(context.path));
	        }
	        const result = {};
	        // Separate declaration is required to avoid assigning `string` type to `k`.
	        for (const k in this.validators) {
	            if (this.validators.hasOwnProperty(k)) {
	                context.path.push(k);
	                const validator = this.validators[k];
	                // Accessing value of `k` of `o` is safe because `undefined` values are
	                // considered to indicate a missing value and handled appropriately by
	                // every provided validator.
	                const valid = validator.validate(o[k], context);
	                result[k] = valid;
	                context.path.pop();
	            }
	        }
	        // Check if passed object has any extra keys to be reported as such.
	        for (const key of Object.keys(o)) {
	            if (!this.validators.hasOwnProperty(key)) {
	                context.path.push(key);
	                context.extraKeys.push(renderPath(context.path));
	                context.path.pop();
	            }
	        }
	        return result;
	    }
	}
	// Validator checking whether a value is one of preset values. Used in order to
	// provide easy validation for union of literal types.
	class OneOfValidator {
	    constructor(validValues, defaultValue) {
	        this.defaultValue = defaultValue;
	        this.validValues = validValues;
	    }
	    validate(input, context) {
	        if (this.validValues.includes(input)) {
	            return input;
	        }
	        else if (input !== undefined) {
	            context.invalidKeys.push(renderPath(context.path));
	        }
	        return this.defaultValue;
	    }
	}
	// Validator for an array of elements, applying the same element validator for
	// each element of an array. Uses empty array as a default value.
	class ArrayValidator {
	    constructor(elementValidator) {
	        this.elementValidator = elementValidator;
	    }
	    validate(input, context) {
	        const result = [];
	        if (Array.isArray(input)) {
	            for (let i = 0; i < input.length; i++) {
	                context.path.push(`[${i}]`);
	                result.push(this.elementValidator.validate(input[i], context));
	                context.path.pop();
	            }
	        }
	        else if (input !== undefined) {
	            context.invalidKeys.push(renderPath(context.path));
	        }
	        return result;
	    }
	}
	// Wrapper for running a validator initializing the context.
	function runValidator(validator, input) {
	    const context = {
	        path: [],
	        invalidKeys: [],
	        extraKeys: [],
	    };
	    const result = validator.validate(input, context);
	    return {
	        result,
	        invalidKeys: context.invalidKeys,
	        extraKeys: context.extraKeys,
	    };
	}
	validators.runValidator = runValidator;
	// Shorthands for the validator classes above enabling concise notation.
	function str(defaultValue = '') {
	    return new StringValidator(defaultValue, false);
	}
	validators.str = str;
	validators.requiredStr = new StringValidator('', true);
	function num(defaultValue = 0) {
	    return new NumberValidator(defaultValue, false);
	}
	validators.num = num;
	function bool(defaultValue = false) {
	    return new BooleanValidator(defaultValue, false);
	}
	validators.bool = bool;
	function record(validators) {
	    return new RecordValidator(validators);
	}
	validators.record = record;
	function oneOf(values, defaultValue) {
	    return new OneOfValidator(values, defaultValue);
	}
	validators.oneOf = oneOf;
	function arrayOf(elementValidator) {
	    return new ArrayValidator(elementValidator);
	}
	validators.arrayOf = arrayOf;
	
	return validators;
}

var hasRequiredRecord_config_types;

function requireRecord_config_types () {
	if (hasRequiredRecord_config_types) return record_config_types;
	hasRequiredRecord_config_types = 1;
	(function (exports) {
		// Copyright (C) 2021 The Android Open Source Project
		//
		// Licensed under the Apache License, Version 2.0 (the "License");
		// you may not use this file except in compliance with the License.
		// You may obtain a copy of the License at
		//
		//      http://www.apache.org/licenses/LICENSE-2.0
		//
		// Unless required by applicable law or agreed to in writing, software
		// distributed under the License is distributed on an "AS IS" BASIS,
		// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
		// See the License for the specific language governing permissions and
		// limitations under the License.
		Object.defineProperty(exports, "__esModule", { value: true });
		exports.createEmptyRecordConfig = exports.namedRecordConfigValidator = exports.recordConfigValidator = void 0;
		const validators_1 = requireValidators();
		const recordModes = ['STOP_WHEN_FULL', 'RING_BUFFER', 'LONG_TRACE'];
		exports.recordConfigValidator = (0, validators_1.record)({
		    mode: (0, validators_1.oneOf)(recordModes, 'STOP_WHEN_FULL'),
		    durationMs: (0, validators_1.num)(10000.0),
		    maxFileSizeMb: (0, validators_1.num)(100),
		    fileWritePeriodMs: (0, validators_1.num)(2500),
		    bufferSizeMb: (0, validators_1.num)(64.0),
		    cpuSched: (0, validators_1.bool)(),
		    cpuFreq: (0, validators_1.bool)(),
		    cpuFreqPollMs: (0, validators_1.num)(1000),
		    cpuSyscall: (0, validators_1.bool)(),
		    gpuFreq: (0, validators_1.bool)(),
		    gpuMemTotal: (0, validators_1.bool)(),
		    ftrace: (0, validators_1.bool)(),
		    atrace: (0, validators_1.bool)(),
		    ftraceEvents: (0, validators_1.arrayOf)((0, validators_1.str)()),
		    ftraceExtraEvents: (0, validators_1.str)(),
		    atraceCats: (0, validators_1.arrayOf)((0, validators_1.str)()),
		    allAtraceApps: (0, validators_1.bool)(true),
		    atraceApps: (0, validators_1.str)(),
		    ftraceBufferSizeKb: (0, validators_1.num)(0),
		    ftraceDrainPeriodMs: (0, validators_1.num)(0),
		    androidLogs: (0, validators_1.bool)(),
		    androidLogBuffers: (0, validators_1.arrayOf)((0, validators_1.str)()),
		    androidFrameTimeline: (0, validators_1.bool)(),
		    androidGameInterventionList: (0, validators_1.bool)(),
		    androidNetworkTracing: (0, validators_1.bool)(),
		    androidNetworkTracingPollMs: (0, validators_1.num)(250),
		    cpuCoarse: (0, validators_1.bool)(),
		    cpuCoarsePollMs: (0, validators_1.num)(1000),
		    batteryDrain: (0, validators_1.bool)(),
		    batteryDrainPollMs: (0, validators_1.num)(1000),
		    boardSensors: (0, validators_1.bool)(),
		    memHiFreq: (0, validators_1.bool)(),
		    meminfo: (0, validators_1.bool)(),
		    meminfoPeriodMs: (0, validators_1.num)(1000),
		    meminfoCounters: (0, validators_1.arrayOf)((0, validators_1.str)()),
		    vmstat: (0, validators_1.bool)(),
		    vmstatPeriodMs: (0, validators_1.num)(1000),
		    vmstatCounters: (0, validators_1.arrayOf)((0, validators_1.str)()),
		    heapProfiling: (0, validators_1.bool)(),
		    hpSamplingIntervalBytes: (0, validators_1.num)(4096),
		    hpProcesses: (0, validators_1.str)(),
		    hpContinuousDumpsPhase: (0, validators_1.num)(),
		    hpContinuousDumpsInterval: (0, validators_1.num)(),
		    hpSharedMemoryBuffer: (0, validators_1.num)(8 * 1048576),
		    hpBlockClient: (0, validators_1.bool)(true),
		    hpAllHeaps: (0, validators_1.bool)(),
		    javaHeapDump: (0, validators_1.bool)(),
		    jpProcesses: (0, validators_1.str)(),
		    jpContinuousDumpsPhase: (0, validators_1.num)(),
		    jpContinuousDumpsInterval: (0, validators_1.num)(),
		    memLmk: (0, validators_1.bool)(),
		    procStats: (0, validators_1.bool)(),
		    procStatsPeriodMs: (0, validators_1.num)(1000),
		    chromeCategoriesSelected: (0, validators_1.arrayOf)((0, validators_1.str)()),
		    chromeHighOverheadCategoriesSelected: (0, validators_1.arrayOf)((0, validators_1.str)()),
		    chromePrivacyFiltering: (0, validators_1.bool)(),
		    chromeLogs: (0, validators_1.bool)(),
		    taskScheduling: (0, validators_1.bool)(),
		    ipcFlows: (0, validators_1.bool)(),
		    jsExecution: (0, validators_1.bool)(),
		    webContentRendering: (0, validators_1.bool)(),
		    uiRendering: (0, validators_1.bool)(),
		    inputEvents: (0, validators_1.bool)(),
		    navigationAndLoading: (0, validators_1.bool)(),
		    symbolizeKsyms: (0, validators_1.bool)(),
		});
		exports.namedRecordConfigValidator = (0, validators_1.record)({ title: validators_1.requiredStr, key: validators_1.requiredStr, config: exports.recordConfigValidator });
		function createEmptyRecordConfig() {
		    return (0, validators_1.runValidator)(exports.recordConfigValidator, {}).result;
		}
		exports.createEmptyRecordConfig = createEmptyRecordConfig;
		
} (record_config_types));
	return record_config_types;
}

var record_config = {};

var state = {};

var hasRequiredState;

function requireState () {
	if (hasRequiredState) return state;
	hasRequiredState = 1;
	(function (exports) {
		// Copyright (C) 2018 The Android Open Source Project
		//
		// Licensed under the Apache License, Version 2.0 (the "License");
		// you may not use this file except in compliance with the License.
		// You may obtain a copy of the License at
		//
		//      http://www.apache.org/licenses/LICENSE-2.0
		//
		// Unless required by applicable law or agreed to in writing, software
		// distributed under the License is distributed on an "AS IS" BASIS,
		// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
		// See the License for the specific language governing permissions and
		// limitations under the License.
		Object.defineProperty(exports, "__esModule", { value: true });
		exports.getContainingTrackId = exports.getBuiltinChromeCategoryList = exports.getDefaultRecordingTargets = exports.hasActiveProbes = exports.isAdbTarget = exports.isLinuxTarget = exports.isCrOSTarget = exports.isChromeTarget = exports.isAndroidTarget = exports.isAndroidP = exports.defaultTraceTime = exports.ProfileType = exports.InThreadTrackSortKey = exports.PrimaryTrackSortKey = exports.SCROLLING_TRACK_GROUP = exports.STATE_VERSION = exports.MAX_TIME = void 0;
		exports.MAX_TIME = 180;
		// 3: TrackKindPriority and related sorting changes.
		// 5: Move a large number of items off frontendLocalState and onto state.
		// 6: Common PivotTableConfig and pivot table specific PivotTableState.
		// 7: Split Chrome categories in two and add 'symbolize ksyms' flag.
		// 8: Rename several variables
		// "[...]HeapProfileFlamegraph[...]" -> "[...]Flamegraph[...]".
		// 9: Add a field to track last loaded recording profile name
		// 10: Change last loaded profile tracking type to accommodate auto-save.
		// 11: Rename updateChromeCategories to fetchChromeCategories.
		// 12: Add a field to cache mapping from UI track ID to trace track ID in order
		//     to speed up flow arrows rendering.
		// 13: FlamegraphState changed to support area selection.
		// 14: Changed the type of uiTrackIdByTraceTrackId from `Map` to an object with
		// typed key/value because a `Map` does not preserve type during
		// serialisation+deserialisation.
		// 15: Added state for Pivot Table V2
		// 16: Added boolean tracking if the flamegraph modal was dismissed
		// 17:
		// - add currentEngineId to track the id of the current engine
		// - remove nextNoteId, nextAreaId and use nextId as a unique counter for all
		//   indexing except the indexing of the engines
		// 18: areaSelection change see b/235869542
		// 19: Added visualisedArgs state.
		// 20: Refactored thread sorting order.
		// 21: Updated perf sample selection to include a ts range instead of single ts
		// 22: Add log selection kind.
		// 23: Add log filtering criteria for Android log entries.
		// 24: Store only a single Engine.
		// 25: Move omnibox state off VisibleState.
		// 26: Add tags for filtering Android log entries.
		// 27. Add a text entry for filtering Android log entries.
		// 28. Add a boolean indicating if non matching log entries are hidden.
		// 29. Add ftrace state. <-- Borked, state contains a non-serializable object.
		// 30. Convert ftraceFilter.excludedNames from Set<string> to string[].
		exports.STATE_VERSION = 30;
		exports.SCROLLING_TRACK_GROUP = 'ScrollingTracks';
		(function (PrimaryTrackSortKey) {
		    PrimaryTrackSortKey[PrimaryTrackSortKey["DEBUG_SLICE_TRACK"] = 0] = "DEBUG_SLICE_TRACK";
		    PrimaryTrackSortKey[PrimaryTrackSortKey["NULL_TRACK"] = 1] = "NULL_TRACK";
		    PrimaryTrackSortKey[PrimaryTrackSortKey["PROCESS_SCHEDULING_TRACK"] = 2] = "PROCESS_SCHEDULING_TRACK";
		    PrimaryTrackSortKey[PrimaryTrackSortKey["PROCESS_SUMMARY_TRACK"] = 3] = "PROCESS_SUMMARY_TRACK";
		    PrimaryTrackSortKey[PrimaryTrackSortKey["EXPECTED_FRAMES_SLICE_TRACK"] = 4] = "EXPECTED_FRAMES_SLICE_TRACK";
		    PrimaryTrackSortKey[PrimaryTrackSortKey["ACTUAL_FRAMES_SLICE_TRACK"] = 5] = "ACTUAL_FRAMES_SLICE_TRACK";
		    PrimaryTrackSortKey[PrimaryTrackSortKey["PERF_SAMPLES_PROFILE_TRACK"] = 6] = "PERF_SAMPLES_PROFILE_TRACK";
		    PrimaryTrackSortKey[PrimaryTrackSortKey["HEAP_PROFILE_TRACK"] = 7] = "HEAP_PROFILE_TRACK";
		    PrimaryTrackSortKey[PrimaryTrackSortKey["MAIN_THREAD"] = 8] = "MAIN_THREAD";
		    PrimaryTrackSortKey[PrimaryTrackSortKey["RENDER_THREAD"] = 9] = "RENDER_THREAD";
		    PrimaryTrackSortKey[PrimaryTrackSortKey["GPU_COMPLETION_THREAD"] = 10] = "GPU_COMPLETION_THREAD";
		    PrimaryTrackSortKey[PrimaryTrackSortKey["CHROME_IO_THREAD"] = 11] = "CHROME_IO_THREAD";
		    PrimaryTrackSortKey[PrimaryTrackSortKey["CHROME_COMPOSITOR_THREAD"] = 12] = "CHROME_COMPOSITOR_THREAD";
		    PrimaryTrackSortKey[PrimaryTrackSortKey["ORDINARY_THREAD"] = 13] = "ORDINARY_THREAD";
		    PrimaryTrackSortKey[PrimaryTrackSortKey["COUNTER_TRACK"] = 14] = "COUNTER_TRACK";
		    PrimaryTrackSortKey[PrimaryTrackSortKey["ASYNC_SLICE_TRACK"] = 15] = "ASYNC_SLICE_TRACK";
		    PrimaryTrackSortKey[PrimaryTrackSortKey["ORDINARY_TRACK"] = 16] = "ORDINARY_TRACK";
		})(exports.PrimaryTrackSortKey || (exports.PrimaryTrackSortKey = {}));
		(function (InThreadTrackSortKey) {
		    InThreadTrackSortKey[InThreadTrackSortKey["THREAD_COUNTER_TRACK"] = 0] = "THREAD_COUNTER_TRACK";
		    InThreadTrackSortKey[InThreadTrackSortKey["THREAD_SCHEDULING_STATE_TRACK"] = 1] = "THREAD_SCHEDULING_STATE_TRACK";
		    InThreadTrackSortKey[InThreadTrackSortKey["CPU_STACK_SAMPLES_TRACK"] = 2] = "CPU_STACK_SAMPLES_TRACK";
		    InThreadTrackSortKey[InThreadTrackSortKey["VISUALISED_ARGS_TRACK"] = 3] = "VISUALISED_ARGS_TRACK";
		    InThreadTrackSortKey[InThreadTrackSortKey["ORDINARY"] = 4] = "ORDINARY";
		    InThreadTrackSortKey[InThreadTrackSortKey["DEFAULT_TRACK"] = 5] = "DEFAULT_TRACK";
		})(exports.InThreadTrackSortKey || (exports.InThreadTrackSortKey = {}));
		(function (ProfileType) {
		    ProfileType["HEAP_PROFILE"] = "heap_profile";
		    ProfileType["NATIVE_HEAP_PROFILE"] = "heap_profile:libc.malloc";
		    ProfileType["JAVA_HEAP_SAMPLES"] = "heap_profile:com.android.art";
		    ProfileType["JAVA_HEAP_GRAPH"] = "graph";
		    ProfileType["PERF_SAMPLE"] = "perf";
		})(exports.ProfileType || (exports.ProfileType = {}));
		exports.defaultTraceTime = {
		    startSec: 0,
		    endSec: 10,
		};
		function isAndroidP(target) {
		    return target.os === 'P';
		}
		exports.isAndroidP = isAndroidP;
		function isAndroidTarget(target) {
		    return ['Q', 'P', 'O'].includes(target.os);
		}
		exports.isAndroidTarget = isAndroidTarget;
		function isChromeTarget(target) {
		    return ['C', 'CrOS'].includes(target.os);
		}
		exports.isChromeTarget = isChromeTarget;
		function isCrOSTarget(target) {
		    return target.os === 'CrOS';
		}
		exports.isCrOSTarget = isCrOSTarget;
		function isLinuxTarget(target) {
		    return target.os === 'L';
		}
		exports.isLinuxTarget = isLinuxTarget;
		function isAdbTarget(target) {
		    return !!target.serial;
		}
		exports.isAdbTarget = isAdbTarget;
		function hasActiveProbes(config) {
		    const fieldsWithEmptyResult = new Set(['hpBlockClient', 'allAtraceApps', 'chromePrivacyFiltering']);
		    let key;
		    for (key in config) {
		        if (typeof (config[key]) === 'boolean' && config[key] === true &&
		            !fieldsWithEmptyResult.has(key)) {
		            return true;
		        }
		    }
		    if (config.chromeCategoriesSelected.length > 0) {
		        return true;
		    }
		    return config.chromeHighOverheadCategoriesSelected.length > 0;
		}
		exports.hasActiveProbes = hasActiveProbes;
		function getDefaultRecordingTargets() {
		    return [
		        { os: 'Q', name: 'Android Q+ / 10+' },
		        { os: 'P', name: 'Android P / 9' },
		        { os: 'O', name: 'Android O- / 8-' },
		        { os: 'C', name: 'Chrome' },
		        { os: 'CrOS', name: 'Chrome OS (system trace)' },
		        { os: 'L', name: 'Linux desktop' },
		    ];
		}
		exports.getDefaultRecordingTargets = getDefaultRecordingTargets;
		function getBuiltinChromeCategoryList() {
		    // List of static Chrome categories, last updated at 2023-04-04 from HEAD of
		    // Chromium's //base/trace_event/builtin_categories.h.
		    return [
		        'accessibility',
		        'AccountFetcherService',
		        'android_webview',
		        'aogh',
		        'audio',
		        'base',
		        'benchmark',
		        'blink',
		        'blink.animations',
		        'blink.bindings',
		        'blink.console',
		        'blink.net',
		        'blink.resource',
		        'blink.user_timing',
		        'blink.worker',
		        'blink_style',
		        'Blob',
		        'browser',
		        'browsing_data',
		        'CacheStorage',
		        'Calculators',
		        'CameraStream',
		        'cppgc',
		        'camera',
		        'cast_app',
		        'cast_perf_test',
		        'cast.mdns',
		        'cast.mdns.socket',
		        'cast.stream',
		        'cc',
		        'cc.debug',
		        'cdp.perf',
		        'chromeos',
		        'cma',
		        'compositor',
		        'content',
		        'content_capture',
		        'delegated_ink_trails',
		        'device',
		        'devtools',
		        'devtools.contrast',
		        'devtools.timeline',
		        'disk_cache',
		        'download',
		        'download_service',
		        'drm',
		        'drmcursor',
		        'dwrite',
		        'DXVA_Decoding',
		        'evdev',
		        'event',
		        'event_latency',
		        'exo',
		        'extensions',
		        'explore_sites',
		        'FileSystem',
		        'file_system_provider',
		        'fledge',
		        'fonts',
		        'GAMEPAD',
		        'gpu',
		        'gpu.angle',
		        'gpu.angle.texture_metrics',
		        'gpu.capture',
		        'headless',
		        'history',
		        'hwoverlays',
		        'identity',
		        'ime',
		        'IndexedDB',
		        'input',
		        'io',
		        'ipc',
		        'Java',
		        'jni',
		        'jpeg',
		        'latency',
		        'latencyInfo',
		        'leveldb',
		        'loading',
		        'log',
		        'login',
		        'media',
		        'media_router',
		        'memory',
		        'midi',
		        'mojom',
		        'mus',
		        'native',
		        'navigation',
		        'net',
		        'netlog',
		        'offline_pages',
		        'omnibox',
		        'oobe',
		        'openscreen',
		        'ozone',
		        'partition_alloc',
		        'passwords',
		        'p2p',
		        'page-serialization',
		        'paint_preview',
		        'pepper',
		        'PlatformMalloc',
		        'power',
		        'ppapi',
		        'ppapi_proxy',
		        'print',
		        'raf_investigation',
		        'rail',
		        'renderer',
		        'renderer_host',
		        'renderer.scheduler',
		        'resources',
		        'RLZ',
		        'ServiceWorker',
		        'SiteEngagement',
		        'safe_browsing',
		        'scheduler',
		        'scheduler.long_tasks',
		        'screenlock_monitor',
		        'segmentation_platform',
		        'sequence_manager',
		        'service_manager',
		        'sharing',
		        'shell',
		        'shortcut_viewer',
		        'shutdown',
		        'skia',
		        'sql',
		        'stadia_media',
		        'stadia_rtc',
		        'startup',
		        'sync',
		        'system_apps',
		        'test_gpu',
		        'toplevel',
		        'toplevel.flow',
		        'ui',
		        'v8',
		        'v8.execute',
		        'v8.wasm',
		        'ValueStoreFrontend::Backend',
		        'views',
		        'views.frame',
		        'viz',
		        'vk',
		        'wakeup.flow',
		        'wayland',
		        'webaudio',
		        'webengine.fidl',
		        'weblayer',
		        'WebCore',
		        'webrtc',
		        'webrtc_stats',
		        'xr',
		        'disabled-by-default-android_view_hierarchy',
		        'disabled-by-default-animation-worklet',
		        'disabled-by-default-audio',
		        'disabled-by-default-audio-worklet',
		        'disabled-by-default-audio.latency',
		        'disabled-by-default-base',
		        'disabled-by-default-blink.debug',
		        'disabled-by-default-blink.debug.display_lock',
		        'disabled-by-default-blink.debug.layout',
		        'disabled-by-default-blink.debug.layout.scrollbars',
		        'disabled-by-default-blink.debug.layout.trees',
		        'disabled-by-default-blink.feature_usage',
		        'disabled-by-default-blink.image_decoding',
		        'disabled-by-default-blink.invalidation',
		        'disabled-by-default-identifiability',
		        'disabled-by-default-identifiability.high_entropy_api',
		        'disabled-by-default-cc',
		        'disabled-by-default-cc.debug',
		        'disabled-by-default-cc.debug.cdp-perf',
		        'disabled-by-default-cc.debug.display_items',
		        'disabled-by-default-cc.debug.lcd_text',
		        'disabled-by-default-cc.debug.picture',
		        'disabled-by-default-cc.debug.scheduler',
		        'disabled-by-default-cc.debug.scheduler.frames',
		        'disabled-by-default-cc.debug.scheduler.now',
		        'disabled-by-default-content.verbose',
		        'disabled-by-default-cpu_profiler',
		        'disabled-by-default-cppgc',
		        'disabled-by-default-cpu_profiler.debug',
		        'disabled-by-default-devtools.screenshot',
		        'disabled-by-default-devtools.timeline',
		        'disabled-by-default-devtools.timeline.frame',
		        'disabled-by-default-devtools.timeline.inputs',
		        'disabled-by-default-devtools.timeline.invalidationTracking',
		        'disabled-by-default-devtools.timeline.layers',
		        'disabled-by-default-devtools.timeline.picture',
		        'disabled-by-default-devtools.timeline.stack',
		        'disabled-by-default-file',
		        'disabled-by-default-fonts',
		        'disabled-by-default-gpu_cmd_queue',
		        'disabled-by-default-gpu.dawn',
		        'disabled-by-default-gpu.debug',
		        'disabled-by-default-gpu.decoder',
		        'disabled-by-default-gpu.device',
		        'disabled-by-default-gpu.service',
		        'disabled-by-default-gpu.vulkan.vma',
		        'disabled-by-default-histogram_samples',
		        'disabled-by-default-java-heap-profiler',
		        'disabled-by-default-layer-element',
		        'disabled-by-default-layout_shift.debug',
		        'disabled-by-default-lifecycles',
		        'disabled-by-default-loading',
		        'disabled-by-default-mediastream',
		        'disabled-by-default-memory-infra',
		        'disabled-by-default-memory-infra.v8.code_stats',
		        'disabled-by-default-mojom',
		        'disabled-by-default-net',
		        'disabled-by-default-network',
		        'disabled-by-default-paint-worklet',
		        'disabled-by-default-power',
		        'disabled-by-default-renderer.scheduler',
		        'disabled-by-default-renderer.scheduler.debug',
		        'disabled-by-default-sequence_manager',
		        'disabled-by-default-sequence_manager.debug',
		        'disabled-by-default-sequence_manager.verbose_snapshots',
		        'disabled-by-default-skia',
		        'disabled-by-default-skia.gpu',
		        'disabled-by-default-skia.gpu.cache',
		        'disabled-by-default-skia.shaders',
		        'disabled-by-default-SyncFileSystem',
		        'disabled-by-default-system_stats',
		        'disabled-by-default-thread_pool_diagnostics',
		        'disabled-by-default-toplevel.ipc',
		        'disabled-by-default-user_action_samples',
		        'disabled-by-default-v8.compile',
		        'disabled-by-default-v8.cpu_profiler',
		        'disabled-by-default-v8.gc',
		        'disabled-by-default-v8.gc_stats',
		        'disabled-by-default-v8.ic_stats',
		        'disabled-by-default-v8.inspector',
		        'disabled-by-default-v8.runtime',
		        'disabled-by-default-v8.runtime_stats',
		        'disabled-by-default-v8.runtime_stats_sampling',
		        'disabled-by-default-v8.stack_trace',
		        'disabled-by-default-v8.turbofan',
		        'disabled-by-default-v8.wasm.detailed',
		        'disabled-by-default-v8.wasm.turbofan',
		        'disabled-by-default-video_and_image_capture',
		        'disabled-by-default-viz.gpu_composite_time',
		        'disabled-by-default-viz.debug.overlay_planes',
		        'disabled-by-default-viz.hit_testing_flow',
		        'disabled-by-default-viz.overdraw',
		        'disabled-by-default-viz.quads',
		        'disabled-by-default-viz.surface_id_flow',
		        'disabled-by-default-viz.surface_lifetime',
		        'disabled-by-default-viz.triangles',
		        'disabled-by-default-webaudio.audionode',
		        'disabled-by-default-webgpu',
		        'disabled-by-default-webrtc',
		        'disabled-by-default-worker.scheduler',
		        'disabled-by-default-xr.debug',
		    ];
		}
		exports.getBuiltinChromeCategoryList = getBuiltinChromeCategoryList;
		function getContainingTrackId(state, trackId) {
		    const track = state.tracks[trackId];
		    if (!track) {
		        return null;
		    }
		    const parentId = track.trackGroup;
		    if (!parentId) {
		        return null;
		    }
		    return parentId;
		}
		exports.getContainingTrackId = getContainingTrackId;
		
} (state));
	return state;
}

var hasRequiredRecord_config;

function requireRecord_config () {
	if (hasRequiredRecord_config) return record_config;
	hasRequiredRecord_config = 1;
	// Copyright (C) 2020 The Android Open Source Project
	//
	// Licensed under the Apache License, Version 2.0 (the "License");
	// you may not use this file except in compliance with the License.
	// You may obtain a copy of the License at
	//
	//      http://www.apache.org/licenses/LICENSE-2.0
	//
	// Unless required by applicable law or agreed to in writing, software
	// distributed under the License is distributed on an "AS IS" BASIS,
	// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	// See the License for the specific language governing permissions and
	// limitations under the License.
	Object.defineProperty(record_config, "__esModule", { value: true });
	record_config.recordTargetStore = record_config.RecordTargetStore = record_config.autosaveConfigStore = record_config.AutosaveConfigStore = record_config.recordConfigStore = record_config.RecordConfigStore = void 0;
	const state_1 = requireState();
	const record_config_types_1 = requireRecord_config_types();
	const validators_1 = requireValidators();
	const LOCAL_STORAGE_RECORD_CONFIGS_KEY = 'recordConfigs';
	const LOCAL_STORAGE_AUTOSAVE_CONFIG_KEY = 'autosaveConfig';
	const LOCAL_STORAGE_RECORD_TARGET_OS_KEY = 'recordTargetOS';
	class RecordConfigStore {
	    constructor() {
	        this.recordConfigs = [];
	        this.recordConfigNames = new Set();
	        this.reloadFromLocalStorage();
	    }
	    _save() {
	        window.localStorage.setItem(LOCAL_STORAGE_RECORD_CONFIGS_KEY, JSON.stringify(this.recordConfigs.map((x) => x.result)));
	    }
	    save(recordConfig, title) {
	        // We reload from local storage in case of concurrent
	        // modifications of local storage from a different tab.
	        this.reloadFromLocalStorage();
	        const savedTitle = title ? title : new Date().toJSON();
	        const config = {
	            title: savedTitle,
	            config: recordConfig,
	            key: new Date().toJSON(),
	        };
	        this.recordConfigs.push({ result: config, invalidKeys: [], extraKeys: [] });
	        this.recordConfigNames.add(savedTitle);
	        this._save();
	    }
	    overwrite(recordConfig, key) {
	        // We reload from local storage in case of concurrent
	        // modifications of local storage from a different tab.
	        this.reloadFromLocalStorage();
	        const found = this.recordConfigs.find((e) => e.result.key === key);
	        if (found === undefined) {
	            throw new Error('trying to overwrite non-existing config');
	        }
	        found.result.config = recordConfig;
	        this._save();
	    }
	    delete(key) {
	        // We reload from local storage in case of concurrent
	        // modifications of local storage from a different tab.
	        this.reloadFromLocalStorage();
	        let idx = -1;
	        for (let i = 0; i < this.recordConfigs.length; ++i) {
	            if (this.recordConfigs[i].result.key === key) {
	                idx = i;
	                break;
	            }
	        }
	        if (idx !== -1) {
	            this.recordConfigNames.delete(this.recordConfigs[idx].result.title);
	            this.recordConfigs.splice(idx, 1);
	            this._save();
	        }
	        else {
	            // TODO(bsebastien): Show a warning message to the user in the UI.
	            console.warn('The config selected doesn\'t exist any more');
	        }
	    }
	    clearRecordConfigs() {
	        this.recordConfigs = [];
	        this.recordConfigNames.clear();
	        this._save();
	    }
	    reloadFromLocalStorage() {
	        const configsLocalStorage = window.localStorage.getItem(LOCAL_STORAGE_RECORD_CONFIGS_KEY);
	        if (configsLocalStorage) {
	            this.recordConfigNames.clear();
	            try {
	                const validConfigLocalStorage = [];
	                const parsedConfigsLocalStorage = JSON.parse(configsLocalStorage);
	                // Check if it's an array.
	                if (!Array.isArray(parsedConfigsLocalStorage)) {
	                    this.clearRecordConfigs();
	                    return;
	                }
	                for (let i = 0; i < parsedConfigsLocalStorage.length; ++i) {
	                    try {
	                        validConfigLocalStorage.push((0, validators_1.runValidator)(record_config_types_1.namedRecordConfigValidator, parsedConfigsLocalStorage[i]));
	                    }
	                    catch {
	                        // Parsing failed with unrecoverable error (e.g. title or key are
	                        // missing), ignore the result.
	                        console.log('Validation of saved record config has failed: ' +
	                            JSON.stringify(parsedConfigsLocalStorage[i]));
	                    }
	                }
	                this.recordConfigs = validConfigLocalStorage;
	                this._save();
	            }
	            catch (e) {
	                this.clearRecordConfigs();
	            }
	        }
	        else {
	            this.clearRecordConfigs();
	        }
	    }
	    canSave(title) {
	        return !this.recordConfigNames.has(title);
	    }
	}
	record_config.RecordConfigStore = RecordConfigStore;
	// This class is a singleton to avoid many instances
	// conflicting as they attempt to edit localStorage.
	record_config.recordConfigStore = new RecordConfigStore();
	class AutosaveConfigStore {
	    constructor() {
	        this.hasSavedConfig = false;
	        this.config = (0, record_config_types_1.createEmptyRecordConfig)();
	        const savedItem = window.localStorage.getItem(LOCAL_STORAGE_AUTOSAVE_CONFIG_KEY);
	        if (savedItem === null) {
	            return;
	        }
	        const parsed = JSON.parse(savedItem);
	        if (parsed !== null && typeof parsed === 'object') {
	            this.config = (0, validators_1.runValidator)(record_config_types_1.recordConfigValidator, parsed).result;
	            this.hasSavedConfig = true;
	        }
	    }
	    get() {
	        return this.config;
	    }
	    save(newConfig) {
	        window.localStorage.setItem(LOCAL_STORAGE_AUTOSAVE_CONFIG_KEY, JSON.stringify(newConfig));
	        this.config = newConfig;
	        this.hasSavedConfig = true;
	    }
	}
	record_config.AutosaveConfigStore = AutosaveConfigStore;
	record_config.autosaveConfigStore = new AutosaveConfigStore();
	class RecordTargetStore {
	    constructor() {
	        this.recordTargetOS =
	            window.localStorage.getItem(LOCAL_STORAGE_RECORD_TARGET_OS_KEY);
	    }
	    get() {
	        return this.recordTargetOS;
	    }
	    getValidTarget() {
	        const validTargets = (0, state_1.getDefaultRecordingTargets)();
	        const savedOS = this.get();
	        const validSavedTarget = validTargets.find((el) => el.os === savedOS);
	        return validSavedTarget || validTargets[0];
	    }
	    save(newTargetOS) {
	        window.localStorage.setItem(LOCAL_STORAGE_RECORD_TARGET_OS_KEY, newTargetOS);
	        this.recordTargetOS = newTargetOS;
	    }
	}
	record_config.RecordTargetStore = RecordTargetStore;
	record_config.recordTargetStore = new RecordTargetStore();
	
	return record_config;
}

var feature_flags = {};

var hasRequiredFeature_flags;

function requireFeature_flags () {
	if (hasRequiredFeature_flags) return feature_flags;
	hasRequiredFeature_flags = 1;
	(function (exports) {
		// Copyright (C) 2021 The Android Open Source Project
		//
		// Licensed under the Apache License, Version 2.0 (the "License");
		// you may not use this file except in compliance with the License.
		// You may obtain a copy of the License at
		//
		//      http://www.apache.org/licenses/LICENSE-2.0
		//
		// Unless required by applicable law or agreed to in writing, software
		// distributed under the License is distributed on an "AS IS" BASIS,
		// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
		// See the License for the specific language governing permissions and
		// limitations under the License.
		Object.defineProperty(exports, "__esModule", { value: true });
		exports.RECORDING_V2_FLAG = exports.PERF_SAMPLE_FLAG = exports.featureFlags = exports.FlagsForTesting = exports.OverrideState = void 0;
		var OverrideState;
		(function (OverrideState) {
		    OverrideState["DEFAULT"] = "DEFAULT";
		    OverrideState["TRUE"] = "OVERRIDE_TRUE";
		    OverrideState["FALSE"] = "OVERRIDE_FALSE";
		})(OverrideState = exports.OverrideState || (exports.OverrideState = {}));
		// Check if the given object is a valid FlagOverrides.
		// This is necessary since someone could modify the persisted flags
		// behind our backs.
		function isFlagOverrides(o) {
		    const states = [OverrideState.TRUE.toString(), OverrideState.FALSE.toString()];
		    for (const v of Object.values(o)) {
		        if (typeof v !== 'string' || !states.includes(v)) {
		            return false;
		        }
		    }
		    return true;
		}
		class Flags {
		    constructor(store) {
		        this.store = store;
		        this.flags = new Map();
		        this.overrides = {};
		        this.load();
		    }
		    register(settings) {
		        const id = settings.id;
		        if (this.flags.has(id)) {
		            throw new Error(`Flag with id "${id}" is already registered.`);
		        }
		        const saved = this.overrides[id];
		        const state = saved === undefined ? OverrideState.DEFAULT : saved;
		        const flag = new FlagImpl(this, state, settings);
		        this.flags.set(id, flag);
		        return flag;
		    }
		    allFlags() {
		        const includeDevFlags = ['127.0.0.1', '::1', 'localhost'].includes(window.location.hostname);
		        let flags = [...this.flags.values()];
		        flags = flags.filter((flag) => includeDevFlags || !flag.devOnly);
		        flags.sort((a, b) => a.name.localeCompare(b.name));
		        return flags;
		    }
		    resetAll() {
		        for (const flag of this.flags.values()) {
		            flag.state = OverrideState.DEFAULT;
		        }
		        this.save();
		    }
		    load() {
		        const o = this.store.load();
		        if (isFlagOverrides(o)) {
		            this.overrides = o;
		        }
		    }
		    save() {
		        for (const flag of this.flags.values()) {
		            if (flag.isOverridden()) {
		                this.overrides[flag.id] = flag.state;
		            }
		            else {
		                delete this.overrides[flag.id];
		            }
		        }
		        this.store.save(this.overrides);
		    }
		}
		class FlagImpl {
		    constructor(registry, state, settings) {
		        this.registry = registry;
		        this.id = settings.id;
		        this.state = state;
		        this.description = settings.description;
		        this.defaultValue = settings.defaultValue;
		        this.name = settings.name || settings.id;
		        this.devOnly = settings.devOnly || false;
		    }
		    get() {
		        switch (this.state) {
		            case OverrideState.TRUE:
		                return true;
		            case OverrideState.FALSE:
		                return false;
		            case OverrideState.DEFAULT:
		            default:
		                return this.defaultValue;
		        }
		    }
		    set(value) {
		        const next = value ? OverrideState.TRUE : OverrideState.FALSE;
		        if (this.state === next) {
		            return;
		        }
		        this.state = next;
		        this.registry.save();
		    }
		    overriddenState() {
		        return this.state;
		    }
		    reset() {
		        this.state = OverrideState.DEFAULT;
		        this.registry.save();
		    }
		    isOverridden() {
		        return this.state !== OverrideState.DEFAULT;
		    }
		}
		class LocalStorageStore {
		    load() {
		        const s = localStorage.getItem(LocalStorageStore.KEY);
		        let parsed;
		        try {
		            parsed = JSON.parse(s || '{}');
		        }
		        catch (e) {
		            return {};
		        }
		        if (typeof parsed !== 'object' || parsed === null) {
		            return {};
		        }
		        return parsed;
		    }
		    save(o) {
		        const s = JSON.stringify(o);
		        localStorage.setItem(LocalStorageStore.KEY, s);
		    }
		}
		LocalStorageStore.KEY = 'perfettoFeatureFlags';
		exports.FlagsForTesting = Flags;
		exports.featureFlags = new Flags(new LocalStorageStore());
		exports.PERF_SAMPLE_FLAG = exports.featureFlags.register({
		    id: 'perfSampleFlamegraph',
		    name: 'Perf Sample Flamegraph',
		    description: 'Show flamegraph generated by a perf sample.',
		    defaultValue: true,
		});
		exports.RECORDING_V2_FLAG = exports.featureFlags.register({
		    id: 'recordingv2',
		    name: 'Recording V2',
		    description: 'Record using V2 interface',
		    defaultValue: false,
		});
		
} (feature_flags));
	return feature_flags;
}

var hasRequiredEmpty_state$1;

function requireEmpty_state$1 () {
	if (hasRequiredEmpty_state$1) return empty_state$1;
	hasRequiredEmpty_state$1 = 1;
	(function (exports) {
		// Copyright (C) 2021 The Android Open Source Project
		//
		// Licensed under the Apache License, Version 2.0 (the "License");
		// you may not use this file except in compliance with the License.
		// You may obtain a copy of the License at
		//
		//      http://www.apache.org/licenses/LICENSE-2.0
		//
		// Unless required by applicable law or agreed to in writing, software
		// distributed under the License is distributed on an "AS IS" BASIS,
		// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
		// See the License for the specific language governing permissions and
		// limitations under the License.
		Object.defineProperty(exports, "__esModule", { value: true });
		exports.createEmptyState = exports.createEmptyNonSerializableState = exports.COUNT_AGGREGATION = exports.keyedMap = void 0;
		const record_config_types_1 = requireRecord_config_types();
		const record_config_1 = requireRecord_config();
		const feature_flags_1 = requireFeature_flags();
		const state_1 = requireState();
		const AUTOLOAD_STARTED_CONFIG_FLAG = feature_flags_1.featureFlags.register({
		    id: 'autoloadStartedConfig',
		    name: 'Auto-load last used recording config',
		    description: 'Starting a recording automatically saves its configuration. ' +
		        'This flag controls whether this config is automatically loaded.',
		    defaultValue: true,
		});
		function keyedMap(keyFn, ...values) {
		    const result = new Map();
		    for (const value of values) {
		        result.set(keyFn(value), value);
		    }
		    return result;
		}
		exports.keyedMap = keyedMap;
		exports.COUNT_AGGREGATION = {
		    aggregationFunction: 'COUNT',
		    // Exact column is ignored for count aggregation because it does not matter
		    // what to count, use empty strings.
		    column: { kind: 'regular', table: '', column: '' },
		};
		function createEmptyNonSerializableState() {
		    return {
		        pivotTable: {
		            queryResult: null,
		            selectedPivots: [{ kind: 'regular', table: 'slice', column: 'name' }],
		            selectedAggregations: [
		                {
		                    aggregationFunction: 'SUM',
		                    column: { kind: 'regular', table: 'slice', column: 'dur' },
		                    sortDirection: 'DESC',
		                },
		                {
		                    aggregationFunction: 'SUM',
		                    column: { kind: 'regular', table: 'slice', column: 'thread_dur' },
		                },
		                exports.COUNT_AGGREGATION,
		            ],
		            constrainToArea: true,
		            queryRequested: false,
		            argumentNames: [],
		        },
		    };
		}
		exports.createEmptyNonSerializableState = createEmptyNonSerializableState;
		function createEmptyState() {
		    return {
		        version: state_1.STATE_VERSION,
		        nextId: '-1',
		        newEngineMode: 'USE_HTTP_RPC_IF_AVAILABLE',
		        traceTime: { ...state_1.defaultTraceTime },
		        tracks: {},
		        uiTrackIdByTraceTrackId: {},
		        utidToThreadSortKey: {},
		        aggregatePreferences: {},
		        trackGroups: {},
		        visibleTracks: [],
		        pinnedTracks: [],
		        scrollingTracks: [],
		        areas: {},
		        queries: {},
		        metrics: {},
		        permalink: {},
		        notes: {},
		        visualisedArgs: [],
		        recordConfig: AUTOLOAD_STARTED_CONFIG_FLAG.get() ?
		            record_config_1.autosaveConfigStore.get() :
		            (0, record_config_types_1.createEmptyRecordConfig)(),
		        displayConfigAsPbtxt: false,
		        lastLoadedConfig: { type: 'NONE' },
		        frontendLocalState: {
		            visibleState: {
		                ...state_1.defaultTraceTime,
		                lastUpdate: 0,
		                resolution: 0,
		            },
		        },
		        omniboxState: {
		            omnibox: '',
		            mode: 'SEARCH',
		        },
		        logsPagination: {
		            offset: 0,
		            count: 0,
		        },
		        ftracePagination: {
		            offset: 0,
		            count: 0,
		        },
		        ftraceFilter: {
		            excludedNames: [],
		        },
		        status: { msg: '', timestamp: 0 },
		        currentSelection: null,
		        currentFlamegraphState: null,
		        traceConversionInProgress: false,
		        perfDebug: false,
		        sidebarVisible: true,
		        hoveredUtid: -1,
		        hoveredPid: -1,
		        hoverCursorTimestamp: -1,
		        hoveredNoteTimestamp: -1,
		        highlightedSliceId: -1,
		        focusedFlowIdLeft: -1,
		        focusedFlowIdRight: -1,
		        searchIndex: -1,
		        recordingInProgress: false,
		        recordingCancelled: false,
		        extensionInstalled: false,
		        flamegraphModalDismissed: false,
		        recordingTarget: record_config_1.recordTargetStore.getValidTarget(),
		        availableAdbDevices: [],
		        fetchChromeCategories: false,
		        chromeCategories: undefined,
		        nonSerializableState: createEmptyNonSerializableState(),
		        logFilteringCriteria: {
		            // The first two log priorities are ignored.
		            minimumLevel: 2,
		            tags: [],
		            textEntry: '',
		            hideNonMatching: true,
		        },
		    };
		}
		exports.createEmptyState = createEmptyState;
		
} (empty_state$1));
	return empty_state$1;
}

var time = {};

var hasRequiredTime;

function requireTime () {
	if (hasRequiredTime) return time;
	hasRequiredTime = 1;
	// Copyright (C) 2018 The Android Open Source Project
	//
	// Licensed under the Apache License, Version 2.0 (the "License");
	// you may not use this file except in compliance with the License.
	// You may obtain a copy of the License at
	//
	//      http://www.apache.org/licenses/LICENSE-2.0
	//
	// Unless required by applicable law or agreed to in writing, software
	// distributed under the License is distributed on an "AS IS" BASIS,
	// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	// See the License for the specific language governing permissions and
	// limitations under the License.
	Object.defineProperty(time, "__esModule", { value: true });
	time.TimeSpan = time.currentDateHourAndMinute = time.timeToCode = time.formatTimestamp = time.toNs = time.toNsCeil = time.toNsFloor = time.fromNs = time.timeToString = void 0;
	const logging_1 = requireLogging();
	const EPSILON = 0.0000000001;
	// TODO(hjd): Combine with timeToCode.
	function timeToString(sec) {
	    const units = ['s', 'ms', 'us', 'ns'];
	    const sign = Math.sign(sec);
	    let n = Math.abs(sec);
	    let u = 0;
	    while (n < 1 && n !== 0 && u < units.length - 1) {
	        n *= 1000;
	        u++;
	    }
	    return `${sign < 0 ? '-' : ''}${Math.round(n * 10) / 10} ${units[u]}`;
	}
	time.timeToString = timeToString;
	function fromNs(ns) {
	    return ns / 1e9;
	}
	time.fromNs = fromNs;
	function toNsFloor(seconds) {
	    return Math.floor(seconds * 1e9);
	}
	time.toNsFloor = toNsFloor;
	function toNsCeil(seconds) {
	    return Math.ceil(seconds * 1e9);
	}
	time.toNsCeil = toNsCeil;
	function toNs(seconds) {
	    return Math.round(seconds * 1e9);
	}
	time.toNs = toNs;
	// 1000000023ns -> "1.000 000 023"
	function formatTimestamp(sec) {
	    const parts = sec.toFixed(9).split('.');
	    parts[1] = parts[1].replace(/\B(?=(\d{3})+(?!\d))/g, ' ');
	    return parts.join('.');
	}
	time.formatTimestamp = formatTimestamp;
	// TODO(hjd): Rename to formatTimestampWithUnits
	// 1000000023ns -> "1s 23ns"
	function timeToCode(sec) {
	    let result = '';
	    let ns = Math.round(sec * 1e9);
	    if (ns < 1)
	        return '0s';
	    const unitAndValue = [
	        ['m', 60000000000],
	        ['s', 1000000000],
	        ['ms', 1000000],
	        ['us', 1000],
	        ['ns', 1],
	    ];
	    unitAndValue.forEach((pair) => {
	        const unit = pair[0];
	        const val = pair[1];
	        if (ns >= val) {
	            const i = Math.floor(ns / val);
	            ns -= i * val;
	            result += i.toLocaleString() + unit + ' ';
	        }
	    });
	    return result.slice(0, -1);
	}
	time.timeToCode = timeToCode;
	function currentDateHourAndMinute() {
	    const date = new Date();
	    return `${date.toISOString().substr(0, 10)}-${date.getHours()}-${date.getMinutes()}`;
	}
	time.currentDateHourAndMinute = currentDateHourAndMinute;
	class TimeSpan {
	    constructor(start, end) {
	        (0, logging_1.assertTrue)(start <= end);
	        this.start = start;
	        this.end = end;
	    }
	    clone() {
	        return new TimeSpan(this.start, this.end);
	    }
	    equals(other) {
	        return Math.abs(this.start - other.start) < EPSILON &&
	            Math.abs(this.end - other.end) < EPSILON;
	    }
	    get duration() {
	        return this.end - this.start;
	    }
	    isInBounds(sec) {
	        return this.start <= sec && sec <= this.end;
	    }
	    add(sec) {
	        return new TimeSpan(this.start + sec, this.end + sec);
	    }
	    contains(other) {
	        return this.start <= other.start && other.end <= this.end;
	    }
	}
	time.TimeSpan = TimeSpan;
	
	return time;
}

var analytics = {};

var channels = {};

var hasRequiredChannels;

function requireChannels () {
	if (hasRequiredChannels) return channels;
	hasRequiredChannels = 1;
	(function (exports) {
		// Copyright (C) 2021 The Android Open Source Project
		//
		// Licensed under the Apache License, Version 2.0 (the "License");
		// you may not use this file except in compliance with the License.
		// You may obtain a copy of the License at
		//
		//      http://www.apache.org/licenses/LICENSE-2.0
		//
		// Unless required by applicable law or agreed to in writing, software
		// distributed under the License is distributed on an "AS IS" BASIS,
		// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
		// See the License for the specific language governing permissions and
		// limitations under the License.
		Object.defineProperty(exports, "__esModule", { value: true });
		exports.setChannel = exports.channelChanged = exports.getNextChannel = exports.getCurrentChannel = exports.DEFAULT_CHANNEL = void 0;
		const globals_1 = requireGlobals();
		exports.DEFAULT_CHANNEL = 'stable';
		const CHANNEL_KEY = 'perfettoUiChannel';
		let currentChannel = undefined;
		let nextChannel = undefined;
		// This is the channel the UI is currently running. It doesn't change once the
		// UI has been loaded.
		function getCurrentChannel() {
		    if (currentChannel === undefined) {
		        currentChannel = localStorage.getItem(CHANNEL_KEY) || exports.DEFAULT_CHANNEL;
		    }
		    return currentChannel;
		}
		exports.getCurrentChannel = getCurrentChannel;
		// This is the channel that will be applied on reload.
		function getNextChannel() {
		    if (nextChannel !== undefined) {
		        return nextChannel;
		    }
		    return getCurrentChannel();
		}
		exports.getNextChannel = getNextChannel;
		function channelChanged() {
		    return getCurrentChannel() !== getNextChannel();
		}
		exports.channelChanged = channelChanged;
		function setChannel(channel) {
		    getCurrentChannel(); // Cache the current channel before mangling next one.
		    nextChannel = channel;
		    localStorage.setItem(CHANNEL_KEY, channel);
		    globals_1.globals.rafScheduler.scheduleFullRedraw();
		}
		exports.setChannel = setChannel;
		
} (channels));
	return channels;
}

var router = {};

var hasRequiredRouter;

function requireRouter () {
	if (hasRequiredRouter) return router;
	hasRequiredRouter = 1;
	(function (exports) {
		// Copyright (C) 2018 The Android Open Source Project
		//
		// Licensed under the Apache License, Version 2.0 (the "License");
		// you may not use this file except in compliance with the License.
		// You may obtain a copy of the License at
		//
		//      http://www.apache.org/licenses/LICENSE-2.0
		//
		// Unless required by applicable law or agreed to in writing, software
		// distributed under the License is distributed on an "AS IS" BASIS,
		// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
		// See the License for the specific language governing permissions and
		// limitations under the License.
		Object.defineProperty(exports, "__esModule", { value: true });
		exports.Router = exports.ROUTE_PREFIX = void 0;
		const tslib_1 = require$$0$1;
		const mithril_1 = tslib_1.__importDefault(requireMithril());
		const logging_1 = requireLogging();
		exports.ROUTE_PREFIX = '#!';
		const DEFAULT_ROUTE = '/';
		// This router does two things:
		// 1) Maps fragment paths (#!/page/subpage) to Mithril components.
		// The route map is passed to the ctor and is later used when calling the
		// resolve() method.
		//
		// 2) Handles the (optional) args, e.g. #!/page?arg=1&arg2=2.
		// Route args are carry information that is orthogonal to the page (e.g. the
		// trace id).
		// local_cache_key has some special treatment: once a URL has a local_cache_key,
		// it gets automatically appended to further navigations that don't have one.
		// For instance if the current url is #!/viewer?local_cache_key=1234 and a later
		// action (either user-initiated or code-initited) navigates to #!/info, the
		// rotuer will automatically replace the history entry with
		// #!/info?local_cache_key=1234.
		// This is to keep propagating the trace id across page changes, for handling
		// tab discards (b/175041881).
		//
		// This class does NOT deal with the "load a trace when the url contains ?url=
		// or ?local_cache_key=". That logic lives in trace_url_handler.ts, which is
		// triggered by Router.onRouteChanged().
		class Router {
		    constructor(routes) {
		        this.recentChanges = [];
		        // frontend/index.ts calls maybeOpenTraceFromRoute() + redraw here.
		        // This event is decoupled for testing and to avoid circular deps.
		        this.onRouteChanged = () => { };
		        (0, logging_1.assertExists)(routes[DEFAULT_ROUTE]);
		        this.routes = routes;
		        window.onhashchange = (e) => this.onHashChange(e);
		    }
		    onHashChange(e) {
		        this.crashIfLivelock();
		        const oldRoute = Router.parseUrl(e.oldURL);
		        const newRoute = Router.parseUrl(e.newURL);
		        if (newRoute.args.local_cache_key === undefined &&
		            oldRoute.args.local_cache_key) {
		            // Propagate `local_cache_key across` navigations. When a trace is loaded,
		            // the URL becomes #!/viewer?local_cache_key=123. `local_cache_key` allows
		            // reopening the trace from cache in the case of a reload or discard.
		            // When using the UI we can hit "bare" links (e.g. just '#!/info') which
		            // don't have the trace_uuid:
		            // - When clicking on an <a> element from the sidebar.
		            // - When the code calls Router.navigate().
		            // - When the user pastes a URL from docs page.
		            // In all these cases we want to keep propagating the `local_cache_key`.
		            // We do so by re-setting the `local_cache_key` and doing a
		            // location.replace which overwrites the history entry (note
		            // location.replace is NOT just a String.replace operation).
		            newRoute.args.local_cache_key = oldRoute.args.local_cache_key;
		        }
		        const args = mithril_1.default.buildQueryString(newRoute.args);
		        let normalizedFragment = `#!${newRoute.page}${newRoute.subpage}`;
		        normalizedFragment += args.length > 0 ? '?' + args : '';
		        if (!e.newURL.endsWith(normalizedFragment)) {
		            location.replace(normalizedFragment);
		            return;
		        }
		        this.onRouteChanged(newRoute);
		    }
		    // Returns the component for the current route in the URL.
		    // If no route matches the URL, returns a component corresponding to
		    // |this.defaultRoute|.
		    resolve() {
		        const route = Router.parseFragment(location.hash);
		        let component = this.routes[route.page];
		        if (component === undefined) {
		            component = (0, logging_1.assertExists)(this.routes[DEFAULT_ROUTE]);
		        }
		        return (0, mithril_1.default)(component, { subpage: route.subpage });
		    }
		    static navigate(newHash) {
		        (0, logging_1.assertTrue)(newHash.startsWith(exports.ROUTE_PREFIX));
		        window.location.hash = newHash;
		    }
		    // Breaks down a fragment into a Route object.
		    // Sample input:
		    // '#!/record/gpu?local_cache_key=abcd-1234'
		    // Sample output:
		    // {page: '/record', subpage: '/gpu', args: {local_cache_key: 'abcd-1234'}}
		    static parseFragment(hash) {
		        const prefixLength = exports.ROUTE_PREFIX.length;
		        let route = '';
		        if (hash.startsWith(exports.ROUTE_PREFIX)) {
		            route = hash.substring(prefixLength).split('?')[0];
		        }
		        let page = route;
		        let subpage = '';
		        const splittingPoint = route.indexOf('/', 1);
		        if (splittingPoint > 0) {
		            page = route.substring(0, splittingPoint);
		            subpage = route.substring(splittingPoint);
		        }
		        const argsStart = hash.indexOf('?');
		        const argsStr = argsStart < 0 ? '' : hash.substring(argsStart + 1);
		        const args = argsStr ? mithril_1.default.parseQueryString(hash.substring(argsStart)) : {};
		        return { page, subpage, args };
		    }
		    // Like parseFragment() but takes a full URL.
		    static parseUrl(url) {
		        const hashPos = url.indexOf('#');
		        const fragment = hashPos < 0 ? '' : url.substring(hashPos);
		        return Router.parseFragment(fragment);
		    }
		    // Throws if EVENT_LIMIT onhashchange events occur within WINDOW_MS.
		    crashIfLivelock() {
		        const WINDOW_MS = 1000;
		        const EVENT_LIMIT = 20;
		        const now = Date.now();
		        while (this.recentChanges.length > 0 &&
		            now - this.recentChanges[0] > WINDOW_MS) {
		            this.recentChanges.shift();
		        }
		        this.recentChanges.push(now);
		        if (this.recentChanges.length > EVENT_LIMIT) {
		            throw new Error('History rewriting livelock');
		        }
		    }
		}
		exports.Router = Router;
		
} (router));
	return router;
}

var hasRequiredAnalytics;

function requireAnalytics () {
	if (hasRequiredAnalytics) return analytics;
	hasRequiredAnalytics = 1;
	// Copyright (C) 2020 The Android Open Source Project
	//
	// Licensed under the Apache License, Version 2.0 (the "License");
	// you may not use this file except in compliance with the License.
	// You may obtain a copy of the License at
	//
	//      http://www.apache.org/licenses/LICENSE-2.0
	//
	// Unless required by applicable law or agreed to in writing, software
	// distributed under the License is distributed on an "AS IS" BASIS,
	// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	// See the License for the specific language governing permissions and
	// limitations under the License.
	Object.defineProperty(analytics, "__esModule", { value: true });
	analytics.NullAnalytics = analytics.initAnalytics = void 0;
	const channels_1 = requireChannels();
	const perfetto_version_1 = requirePerfetto_version();
	const globals_1 = requireGlobals();
	const router_1 = requireRouter();
	const ANALYTICS_ID = 'UA-137828855-1';
	const PAGE_TITLE = 'no-page-title';
	function initAnalytics() {
	    // Only initialize logging on the official site and on localhost (to catch
	    // analytics bugs when testing locally).
	    // Skip analytics is the fragment has "testing=1", this is used by UI tests.
	    // Skip analytics in embeddedMode since iFrames do not have the same access to
	    // local storage.
	    if ((window.location.origin.startsWith('http://localhost:') ||
	        window.location.origin.endsWith('.perfetto.dev')) &&
	        !globals_1.globals.testing && !globals_1.globals.embeddedMode) {
	        return new AnalyticsImpl();
	    }
	    return new NullAnalytics();
	}
	analytics.initAnalytics = initAnalytics;
	const gtagGlobals = window;
	class NullAnalytics {
	    initialize() { }
	    updatePath(_) { }
	    logEvent(_x, _y) { }
	    logError(_x) { }
	    isEnabled() {
	        return false;
	    }
	}
	analytics.NullAnalytics = NullAnalytics;
	class AnalyticsImpl {
	    constructor() {
	        this.initialized_ = false;
	        // The code below is taken from the official Google Analytics docs [1] and
	        // adapted to TypeScript. We have it here rather than as an inline script
	        // in index.html (as suggested by GA's docs) because inline scripts don't
	        // play nicely with the CSP policy, at least in Firefox (Firefox doesn't
	        // support all CSP 3 features we use).
	        // [1] https://developers.google.com/analytics/devguides/collection/gtagjs .
	        gtagGlobals.dataLayer = gtagGlobals.dataLayer || [];
	        function gtagFunction(..._) {
	            // This needs to be a function and not a lambda. |arguments| behaves
	            // slightly differently in a lambda and breaks GA.
	            gtagGlobals.dataLayer.push(arguments);
	        }
	        gtagGlobals.gtag = gtagFunction;
	        gtagGlobals.gtag('js', new Date());
	    }
	    // This is callled only after the script that sets isInternalUser loads.
	    // It is fine to call updatePath() and log*() functions before initialize().
	    // The gtag() function internally enqueues all requests into |dataLayer|.
	    initialize() {
	        if (this.initialized_)
	            return;
	        this.initialized_ = true;
	        const script = document.createElement('script');
	        script.src = 'https://www.googletagmanager.com/gtag/js?id=' + ANALYTICS_ID;
	        script.defer = true;
	        document.head.appendChild(script);
	        const route = router_1.Router.parseUrl(window.location.href).page || '/';
	        console.log(`GA initialized. route=${route}`, `isInternalUser=${globals_1.globals.isInternalUser}`);
	        // GA's reccomendation for SPAs is to disable automatic page views and
	        // manually send page_view events. See:
	        // https://developers.google.com/analytics/devguides/collection/gtagjs/pages#manual_pageviews
	        gtagGlobals.gtag('config', ANALYTICS_ID, {
	            allow_google_signals: false,
	            anonymize_ip: true,
	            page_path: route,
	            referrer: document.referrer.split('?')[0],
	            send_page_view: false,
	            page_title: PAGE_TITLE,
	            dimension1: globals_1.globals.isInternalUser ? '1' : '0',
	            dimension2: perfetto_version_1.VERSION,
	            dimension3: (0, channels_1.getCurrentChannel)(),
	        });
	        this.updatePath(route);
	    }
	    updatePath(path) {
	        gtagGlobals.gtag('event', 'page_view', { page_path: path, page_title: PAGE_TITLE });
	    }
	    logEvent(category, event) {
	        gtagGlobals.gtag('event', event, { event_category: category });
	    }
	    logError(description, fatal = true) {
	        gtagGlobals.gtag('event', 'exception', { description, fatal });
	    }
	    isEnabled() {
	        return true;
	    }
	}
	
	return analytics;
}

var frontend_local_state = {};

var rate_limiters = {};

var hasRequiredRate_limiters;

function requireRate_limiters () {
	if (hasRequiredRate_limiters) return rate_limiters;
	hasRequiredRate_limiters = 1;
	// Copyright (C) 2020 The Android Open Source Project
	//
	// Licensed under the Apache License, Version 2.0 (the "License");
	// you may not use this file except in compliance with the License.
	// You may obtain a copy of the License at
	//
	//      http://www.apache.org/licenses/LICENSE-2.0
	//
	// Unless required by applicable law or agreed to in writing, software
	// distributed under the License is distributed on an "AS IS" BASIS,
	// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	// See the License for the specific language governing permissions and
	// limitations under the License.
	Object.defineProperty(rate_limiters, "__esModule", { value: true });
	rate_limiters.debounce = rate_limiters.ratelimit = void 0;
	// Returns a wrapper around |f| which calls f at most once every |ms|ms.
	function ratelimit(f, ms) {
	    let inProgess = false;
	    return () => {
	        if (inProgess) {
	            return;
	        }
	        inProgess = true;
	        setTimeout(() => {
	            f();
	            inProgess = false;
	        }, ms);
	    };
	}
	rate_limiters.ratelimit = ratelimit;
	// Returns a wrapper around |f| which waits for a |ms|ms pause in calls
	// before calling |f|.
	function debounce(f, ms) {
	    let timerId;
	    return () => {
	        if (timerId) {
	            clearTimeout(timerId);
	        }
	        timerId = setTimeout(() => {
	            f();
	            timerId = undefined;
	        }, ms);
	    };
	}
	rate_limiters.debounce = debounce;
	
	return rate_limiters;
}

var time_scale = {};

var hasRequiredTime_scale;

function requireTime_scale () {
	if (hasRequiredTime_scale) return time_scale;
	hasRequiredTime_scale = 1;
	// Copyright (C) 2018 The Android Open Source Project
	//
	// Licensed under the Apache License, Version 2.0 (the "License");
	// you may not use this file except in compliance with the License.
	// You may obtain a copy of the License at
	//
	//      http://www.apache.org/licenses/LICENSE-2.0
	//
	// Unless required by applicable law or agreed to in writing, software
	// distributed under the License is distributed on an "AS IS" BASIS,
	// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	// See the License for the specific language governing permissions and
	// limitations under the License.
	Object.defineProperty(time_scale, "__esModule", { value: true });
	time_scale.computeZoom = time_scale.TimeScale = void 0;
	const logging_1 = requireLogging();
	const time_1 = requireTime();
	const MAX_ZOOM_SPAN_SEC = 1e-8; // 10 ns.
	/**
	 * Defines a mapping between number and seconds for the entire application.
	 * Linearly scales time values from boundsMs to pixel values in boundsPx and
	 * back.
	 */
	class TimeScale {
	    constructor(timeBounds, boundsPx) {
	        this.secPerPx = 0;
	        this.timeBounds = timeBounds;
	        this._startPx = boundsPx[0];
	        this._endPx = boundsPx[1];
	        this.updateSlope();
	    }
	    updateSlope() {
	        this.secPerPx = this.timeBounds.duration / (this._endPx - this._startPx);
	    }
	    deltaTimeToPx(time) {
	        return Math.round(time / this.secPerPx);
	    }
	    timeToPx(time) {
	        return this._startPx + (time - this.timeBounds.start) / this.secPerPx;
	    }
	    pxToTime(px) {
	        return this.timeBounds.start + (px - this._startPx) * this.secPerPx;
	    }
	    deltaPxToDuration(px) {
	        return px * this.secPerPx;
	    }
	    setTimeBounds(timeBounds) {
	        this.timeBounds = timeBounds;
	        this.updateSlope();
	    }
	    setLimitsPx(pxStart, pxEnd) {
	        (0, logging_1.assertFalse)(pxStart === pxEnd);
	        (0, logging_1.assertTrue)(pxStart >= 0 && pxEnd >= 0);
	        this._startPx = pxStart;
	        this._endPx = pxEnd;
	        this.updateSlope();
	    }
	    timeInBounds(time) {
	        return this.timeBounds.isInBounds(time);
	    }
	    get startPx() {
	        return this._startPx;
	    }
	    get endPx() {
	        return this._endPx;
	    }
	    get widthPx() {
	        return this._endPx - this._startPx;
	    }
	    get timeSpan() {
	        return this.timeBounds;
	    }
	}
	time_scale.TimeScale = TimeScale;
	function computeZoom(scale, span, zoomFactor, zoomPx) {
	    const startPx = scale.startPx;
	    const endPx = scale.endPx;
	    const deltaPx = endPx - startPx;
	    const deltaTime = span.end - span.start;
	    const newDeltaTime = Math.max(deltaTime * zoomFactor, MAX_ZOOM_SPAN_SEC);
	    const clampedZoomPx = Math.max(startPx, Math.min(endPx, zoomPx));
	    const zoomTime = scale.pxToTime(clampedZoomPx);
	    const r = (clampedZoomPx - startPx) / deltaPx;
	    const newStartTime = zoomTime - newDeltaTime * r;
	    const newEndTime = newStartTime + newDeltaTime;
	    return new time_1.TimeSpan(newStartTime, newEndTime);
	}
	time_scale.computeZoom = computeZoom;
	
	return time_scale;
}

var hasRequiredFrontend_local_state;

function requireFrontend_local_state () {
	if (hasRequiredFrontend_local_state) return frontend_local_state;
	hasRequiredFrontend_local_state = 1;
	// Copyright (C) 2018 The Android Open Source Project
	//
	// Licensed under the Apache License, Version 2.0 (the "License");
	// you may not use this file except in compliance with the License.
	// You may obtain a copy of the License at
	//
	//      http://www.apache.org/licenses/LICENSE-2.0
	//
	// Unless required by applicable law or agreed to in writing, software
	// distributed under the License is distributed on an "AS IS" BASIS,
	// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	// See the License for the specific language governing permissions and
	// limitations under the License.
	Object.defineProperty(frontend_local_state, "__esModule", { value: true });
	frontend_local_state.FrontendLocalState = void 0;
	const logging_1 = requireLogging();
	const actions_1 = requireActions();
	const time_1 = requireTime();
	const globals_1 = requireGlobals();
	const rate_limiters_1 = requireRate_limiters();
	const time_scale_1 = requireTime_scale();
	function chooseLatest(current, next) {
	    if (next !== current && next.lastUpdate > current.lastUpdate) {
	        // |next| is from state. Callers may mutate the return value of
	        // this function so we need to clone |next| to prevent bad mutations
	        // of state:
	        return Object.assign({}, next);
	    }
	    return current;
	}
	function capBetween(t, start, end) {
	    return Math.min(Math.max(t, start), end);
	}
	// Calculate the space a scrollbar takes up so that we can subtract it from
	// the canvas width.
	function calculateScrollbarWidth() {
	    const outer = document.createElement('div');
	    outer.style.overflowY = 'scroll';
	    const inner = document.createElement('div');
	    outer.appendChild(inner);
	    document.body.appendChild(outer);
	    const width = outer.getBoundingClientRect().width - inner.getBoundingClientRect().width;
	    document.body.removeChild(outer);
	    return width;
	}
	/**
	 * State that is shared between several frontend components, but not the
	 * controller. This state is updated at 60fps.
	 */
	class FrontendLocalState {
	    constructor() {
	        this.visibleWindowTime = new time_1.TimeSpan(0, 10);
	        this.timeScale = new time_scale_1.TimeScale(this.visibleWindowTime, [0, 0]);
	        this.showPanningHint = false;
	        this.showCookieConsent = false;
	        this.visibleTracks = new Set();
	        this.prevVisibleTracks = new Set();
	        this.httpRpcState = { connected: false };
	        this.newVersionAvailable = false;
	        // This is used to calculate the tracks within a Y range for area selection.
	        this.areaY = {};
	        this._visibleState = {
	            lastUpdate: 0,
	            startSec: 0,
	            endSec: 10,
	            resolution: 1,
	        };
	        this.ratelimitedUpdateVisible = (0, rate_limiters_1.ratelimit)(() => {
	            globals_1.globals.dispatch(actions_1.Actions.setVisibleTraceTime(this._visibleState));
	        }, 50);
	    }
	    // TODO: there is some redundancy in the fact that both |visibleWindowTime|
	    // and a |timeScale| have a notion of time range. That should live in one
	    // place only.
	    getScrollbarWidth() {
	        if (this.scrollBarWidth === undefined) {
	            this.scrollBarWidth = calculateScrollbarWidth();
	        }
	        return this.scrollBarWidth;
	    }
	    setHttpRpcState(httpRpcState) {
	        this.httpRpcState = httpRpcState;
	        globals_1.globals.rafScheduler.scheduleFullRedraw();
	    }
	    addVisibleTrack(trackId) {
	        this.visibleTracks.add(trackId);
	    }
	    // Called when beginning a canvas redraw.
	    clearVisibleTracks() {
	        this.visibleTracks.clear();
	    }
	    // Called when the canvas redraw is complete.
	    sendVisibleTracks() {
	        if (this.prevVisibleTracks.size !== this.visibleTracks.size ||
	            ![...this.prevVisibleTracks].every((value) => this.visibleTracks.has(value))) {
	            globals_1.globals.dispatch(actions_1.Actions.setVisibleTracks({ tracks: Array.from(this.visibleTracks) }));
	            this.prevVisibleTracks = new Set(this.visibleTracks);
	        }
	    }
	    mergeState(state) {
	        // This is unfortunately subtle. This class mutates this._visibleState.
	        // Since we may not mutate |state| (in order to make immer's immutable
	        // updates work) this means that we have to make a copy of the visibleState.
	        // when updating it. We don't want to have to do that unnecessarily so
	        // chooseLatest returns a shallow clone of state.visibleState *only* when
	        // that is the newer state. All of these complications should vanish when
	        // we remove this class.
	        const previousVisibleState = this._visibleState;
	        this._visibleState = chooseLatest(this._visibleState, state.visibleState);
	        const visibleStateWasUpdated = previousVisibleState !== this._visibleState;
	        if (visibleStateWasUpdated) {
	            this.updateLocalTime(new time_1.TimeSpan(this._visibleState.startSec, this._visibleState.endSec));
	        }
	    }
	    selectArea(startSec, endSec, tracks = this._selectedArea ? this._selectedArea.tracks : []) {
	        (0, logging_1.assertTrue)(endSec >= startSec, `Impossible select area: startSec [${startSec}] >= endSec [${endSec}]`);
	        this.showPanningHint = true;
	        this._selectedArea = { startSec, endSec, tracks };
	        globals_1.globals.rafScheduler.scheduleFullRedraw();
	    }
	    deselectArea() {
	        this._selectedArea = undefined;
	        globals_1.globals.rafScheduler.scheduleRedraw();
	    }
	    get selectedArea() {
	        return this._selectedArea;
	    }
	    updateLocalTime(ts) {
	        const traceTime = globals_1.globals.state.traceTime;
	        const startSec = capBetween(ts.start, traceTime.startSec, traceTime.endSec);
	        const endSec = capBetween(ts.end, traceTime.startSec, traceTime.endSec);
	        this.visibleWindowTime = new time_1.TimeSpan(startSec, endSec);
	        this.timeScale.setTimeBounds(this.visibleWindowTime);
	        this.updateResolution();
	    }
	    updateResolution() {
	        this._visibleState.lastUpdate = Date.now() / 1000;
	        this._visibleState.resolution = globals_1.globals.getCurResolution();
	        this.ratelimitedUpdateVisible();
	    }
	    updateVisibleTime(ts) {
	        this.updateLocalTime(ts);
	        this._visibleState.lastUpdate = Date.now() / 1000;
	        this._visibleState.startSec = this.visibleWindowTime.start;
	        this._visibleState.endSec = this.visibleWindowTime.end;
	        this._visibleState.resolution = globals_1.globals.getCurResolution();
	        this.ratelimitedUpdateVisible();
	    }
	    getVisibleStateBounds() {
	        return [this.visibleWindowTime.start, this.visibleWindowTime.end];
	    }
	    // Whenever start/end px of the timeScale is changed, update
	    // the resolution.
	    updateLocalLimits(pxStart, pxEnd) {
	        // Numbers received here can be negative or equal, but we should fix that
	        // before updating the timescale.
	        pxStart = Math.max(0, pxStart);
	        pxEnd = Math.max(0, pxEnd);
	        if (pxStart === pxEnd)
	            pxEnd = pxStart + 1;
	        this.timeScale.setLimitsPx(pxStart, pxEnd);
	        this.updateResolution();
	    }
	}
	frontend_local_state.FrontendLocalState = FrontendLocalState;
	
	return frontend_local_state;
}

var raf_scheduler = {};

var perf = {};

var hasRequiredPerf;

function requirePerf () {
	if (hasRequiredPerf) return perf;
	hasRequiredPerf = 1;
	(function (exports) {
		// Copyright (C) 2018 The Android Open Source Project
		//
		// Licensed under the Apache License, Version 2.0 (the "License");
		// you may not use this file except in compliance with the License.
		// You may obtain a copy of the License at
		//
		//      http://www.apache.org/licenses/LICENSE-2.0
		//
		// Unless required by applicable law or agreed to in writing, software
		// distributed under the License is distributed on an "AS IS" BASIS,
		// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
		// See the License for the specific language governing permissions and
		// limitations under the License.
		Object.defineProperty(exports, "__esModule", { value: true });
		exports.perfDisplay = exports.runningStatStr = exports.RunningStatistics = exports.measure = exports.debugNow = exports.perfDebug = void 0;
		const tslib_1 = require$$0$1;
		const mithril_1 = tslib_1.__importDefault(requireMithril());
		const actions_1 = requireActions();
		const globals_1 = requireGlobals();
		// Shorthand for if globals perf debug mode is on.
		const perfDebug = () => globals_1.globals.state.perfDebug;
		exports.perfDebug = perfDebug;
		// Returns performance.now() if perfDebug is enabled, otherwise 0.
		// This is needed because calling performance.now is generally expensive
		// and should not be done for every frame.
		const debugNow = () => (0, exports.perfDebug)() ? performance.now() : 0;
		exports.debugNow = debugNow;
		// Returns execution time of |fn| if perf debug mode is on. Returns 0 otherwise.
		function measure(fn) {
		    const start = (0, exports.debugNow)();
		    fn();
		    return (0, exports.debugNow)() - start;
		}
		exports.measure = measure;
		// Stores statistics about samples, and keeps a fixed size buffer of most recent
		// samples.
		class RunningStatistics {
		    constructor(_maxBufferSize = 10) {
		        this._maxBufferSize = _maxBufferSize;
		        this._count = 0;
		        this._mean = 0;
		        this._lastValue = 0;
		        this._ptr = 0;
		        this.buffer = [];
		    }
		    addValue(value) {
		        this._lastValue = value;
		        if (this.buffer.length >= this._maxBufferSize) {
		            this.buffer[this._ptr++] = value;
		            if (this._ptr >= this.buffer.length) {
		                this._ptr -= this.buffer.length;
		            }
		        }
		        else {
		            this.buffer.push(value);
		        }
		        this._mean = (this._mean * this._count + value) / (this._count + 1);
		        this._count++;
		    }
		    get mean() {
		        return this._mean;
		    }
		    get count() {
		        return this._count;
		    }
		    get bufferMean() {
		        return this.buffer.reduce((sum, v) => sum + v, 0) / this.buffer.length;
		    }
		    get bufferSize() {
		        return this.buffer.length;
		    }
		    get maxBufferSize() {
		        return this._maxBufferSize;
		    }
		    get last() {
		        return this._lastValue;
		    }
		}
		exports.RunningStatistics = RunningStatistics;
		// Returns a summary string representation of a RunningStatistics object.
		function runningStatStr(stat) {
		    return `Last: ${stat.last.toFixed(2)}ms | ` +
		        `Avg: ${stat.mean.toFixed(2)}ms | ` +
		        `Avg${stat.maxBufferSize}: ${stat.bufferMean.toFixed(2)}ms`;
		}
		exports.runningStatStr = runningStatStr;
		// Globals singleton class that renders performance stats for the whole app.
		class PerfDisplay {
		    constructor() {
		        this.containers = [];
		    }
		    addContainer(container) {
		        this.containers.push(container);
		    }
		    removeContainer(container) {
		        const i = this.containers.indexOf(container);
		        this.containers.splice(i, 1);
		    }
		    renderPerfStats() {
		        if (!(0, exports.perfDebug)())
		            return;
		        const perfDisplayEl = document.querySelector('.perf-stats');
		        if (!perfDisplayEl)
		            return;
		        mithril_1.default.render(perfDisplayEl, [
		            (0, mithril_1.default)('section', globals_1.globals.rafScheduler.renderPerfStats()),
		            (0, mithril_1.default)('button.close-button', {
		                onclick: () => globals_1.globals.dispatch(actions_1.Actions.togglePerfDebug({})),
		            }, (0, mithril_1.default)('i.material-icons', 'close')),
		            this.containers.map((c, i) => (0, mithril_1.default)('section', c.renderPerfStats(i))),
		        ]);
		    }
		}
		exports.perfDisplay = new PerfDisplay();
		
} (perf));
	return perf;
}

var hasRequiredRaf_scheduler;

function requireRaf_scheduler () {
	if (hasRequiredRaf_scheduler) return raf_scheduler;
	hasRequiredRaf_scheduler = 1;
	// Copyright (C) 2018 The Android Open Source Project
	//
	// Licensed under the Apache License, Version 2.0 (the "License");
	// you may not use this file except in compliance with the License.
	// You may obtain a copy of the License at
	//
	//      http://www.apache.org/licenses/LICENSE-2.0
	//
	// Unless required by applicable law or agreed to in writing, software
	// distributed under the License is distributed on an "AS IS" BASIS,
	// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	// See the License for the specific language governing permissions and
	// limitations under the License.
	Object.defineProperty(raf_scheduler, "__esModule", { value: true });
	raf_scheduler.RafScheduler = void 0;
	const tslib_1 = require$$0$1;
	const mithril_1 = tslib_1.__importDefault(requireMithril());
	const logging_1 = requireLogging();
	const globals_1 = requireGlobals();
	const perf_1 = requirePerf();
	function statTableHeader() {
	    return (0, mithril_1.default)('tr', (0, mithril_1.default)('th', ''), (0, mithril_1.default)('th', 'Last (ms)'), (0, mithril_1.default)('th', 'Avg (ms)'), (0, mithril_1.default)('th', 'Avg-10 (ms)'));
	}
	function statTableRow(title, stat) {
	    return (0, mithril_1.default)('tr', (0, mithril_1.default)('td', title), (0, mithril_1.default)('td', stat.last.toFixed(2)), (0, mithril_1.default)('td', stat.mean.toFixed(2)), (0, mithril_1.default)('td', stat.bufferMean.toFixed(2)));
	}
	// This class orchestrates all RAFs in the UI. It ensures that there is only
	// one animation frame handler overall and that callbacks are called in
	// predictable order. There are two types of callbacks here:
	// - actions (e.g. pan/zoon animations), which will alter the "fast"
	//  (main-thread-only) state (e.g. update visible time bounds @ 60 fps).
	// - redraw callbacks that will repaint canvases.
	// This class guarantees that, on each frame, redraw callbacks are called after
	// all action callbacks.
	class RafScheduler {
	    constructor() {
	        this.actionCallbacks = new Set();
	        this.canvasRedrawCallbacks = new Set();
	        this._syncDomRedraw = (_) => { };
	        this.hasScheduledNextFrame = false;
	        this.requestedFullRedraw = false;
	        this.isRedrawing = false;
	        this._shutdown = false;
	        this.perfStats = {
	            rafActions: new perf_1.RunningStatistics(),
	            rafCanvas: new perf_1.RunningStatistics(),
	            rafDom: new perf_1.RunningStatistics(),
	            rafTotal: new perf_1.RunningStatistics(),
	            domRedraw: new perf_1.RunningStatistics(),
	        };
	    }
	    start(cb) {
	        this.actionCallbacks.add(cb);
	        this.maybeScheduleAnimationFrame();
	    }
	    stop(cb) {
	        this.actionCallbacks.delete(cb);
	    }
	    addRedrawCallback(cb) {
	        this.canvasRedrawCallbacks.add(cb);
	    }
	    removeRedrawCallback(cb) {
	        this.canvasRedrawCallbacks.delete(cb);
	    }
	    // Schedule re-rendering of canvas only.
	    scheduleRedraw() {
	        this.maybeScheduleAnimationFrame(true);
	    }
	    shutdown() {
	        this._shutdown = true;
	    }
	    set domRedraw(cb) {
	        this._syncDomRedraw = cb;
	    }
	    // Schedule re-rendering of virtual DOM and canvas.
	    scheduleFullRedraw() {
	        this.requestedFullRedraw = true;
	        this.maybeScheduleAnimationFrame(true);
	    }
	    syncDomRedraw(nowMs) {
	        const redrawStart = (0, perf_1.debugNow)();
	        this._syncDomRedraw(nowMs);
	        if ((0, perf_1.perfDebug)()) {
	            this.perfStats.domRedraw.addValue((0, perf_1.debugNow)() - redrawStart);
	        }
	    }
	    get hasPendingRedraws() {
	        return this.isRedrawing || this.hasScheduledNextFrame;
	    }
	    syncCanvasRedraw(nowMs) {
	        const redrawStart = (0, perf_1.debugNow)();
	        if (this.isRedrawing)
	            return;
	        globals_1.globals.frontendLocalState.clearVisibleTracks();
	        this.isRedrawing = true;
	        for (const redraw of this.canvasRedrawCallbacks)
	            redraw(nowMs);
	        this.isRedrawing = false;
	        globals_1.globals.frontendLocalState.sendVisibleTracks();
	        if ((0, perf_1.perfDebug)()) {
	            this.perfStats.rafCanvas.addValue((0, perf_1.debugNow)() - redrawStart);
	        }
	    }
	    maybeScheduleAnimationFrame(force = false) {
	        if (this.hasScheduledNextFrame)
	            return;
	        if (this.actionCallbacks.size !== 0 || force) {
	            this.hasScheduledNextFrame = true;
	            window.requestAnimationFrame(this.onAnimationFrame.bind(this));
	        }
	    }
	    onAnimationFrame(nowMs) {
	        if (this._shutdown)
	            return;
	        const rafStart = (0, perf_1.debugNow)();
	        this.hasScheduledNextFrame = false;
	        const doFullRedraw = this.requestedFullRedraw;
	        this.requestedFullRedraw = false;
	        const actionTime = (0, perf_1.measure)(() => {
	            for (const action of this.actionCallbacks)
	                action(nowMs);
	        });
	        const domTime = (0, perf_1.measure)(() => {
	            if (doFullRedraw)
	                this.syncDomRedraw(nowMs);
	        });
	        const canvasTime = (0, perf_1.measure)(() => this.syncCanvasRedraw(nowMs));
	        const totalRafTime = (0, perf_1.debugNow)() - rafStart;
	        this.updatePerfStats(actionTime, domTime, canvasTime, totalRafTime);
	        perf_1.perfDisplay.renderPerfStats();
	        this.maybeScheduleAnimationFrame();
	    }
	    updatePerfStats(actionsTime, domTime, canvasTime, totalRafTime) {
	        if (!(0, perf_1.perfDebug)())
	            return;
	        this.perfStats.rafActions.addValue(actionsTime);
	        this.perfStats.rafDom.addValue(domTime);
	        this.perfStats.rafCanvas.addValue(canvasTime);
	        this.perfStats.rafTotal.addValue(totalRafTime);
	    }
	    renderPerfStats() {
	        (0, logging_1.assertTrue)((0, perf_1.perfDebug)());
	        return (0, mithril_1.default)('div', (0, mithril_1.default)('div', [
	            (0, mithril_1.default)('button', { onclick: () => this.scheduleRedraw() }, 'Do Canvas Redraw'),
	            '   |   ',
	            (0, mithril_1.default)('button', { onclick: () => this.scheduleFullRedraw() }, 'Do Full Redraw'),
	        ]), (0, mithril_1.default)('div', 'Raf Timing ' +
	            '(Total may not add up due to imprecision)'), (0, mithril_1.default)('table', statTableHeader(), statTableRow('Actions', this.perfStats.rafActions), statTableRow('Dom', this.perfStats.rafDom), statTableRow('Canvas', this.perfStats.rafCanvas), statTableRow('Total', this.perfStats.rafTotal)), (0, mithril_1.default)('div', 'Dom redraw: ' +
	            `Count: ${this.perfStats.domRedraw.count} | ` +
	            (0, perf_1.runningStatStr)(this.perfStats.domRedraw)));
	    }
	}
	raf_scheduler.RafScheduler = RafScheduler;
	
	return raf_scheduler;
}

var service_worker_controller = {};

var errors = {};

var hasRequiredErrors;

function requireErrors () {
	if (hasRequiredErrors) return errors;
	hasRequiredErrors = 1;
	// Copyright (C) 2022 The Android Open Source Project
	//
	// Licensed under the Apache License, Version 2.0 (the "License");
	// you may not use this file except in compliance with the License.
	// You may obtain a copy of the License at
	//
	//      http://www.apache.org/licenses/LICENSE-2.0
	//
	// Unless required by applicable law or agreed to in writing, software
	// distributed under the License is distributed on an "AS IS" BASIS,
	// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	// See the License for the specific language governing permissions and
	// limitations under the License.
	Object.defineProperty(errors, "__esModule", { value: true });
	errors.ignoreCacheUnactionableErrors = errors.getErrorMessage = void 0;
	// Attempt to coerce an error object into a string message.
	// Sometimes an error message is wrapped in an Error object, sometimes not.
	function getErrorMessage(e) {
	    if (e && typeof e === 'object') {
	        const errorObject = e;
	        if (errorObject.message) { // regular Error Object
	            return String(errorObject.message);
	        }
	        else if (errorObject.error?.message) { // API result
	            return String(errorObject.error.message);
	        }
	    }
	    const asString = String(e);
	    if (asString === '[object Object]') {
	        try {
	            return JSON.stringify(e);
	        }
	        catch (stringifyError) {
	            // ignore failures and just fall through
	        }
	    }
	    return asString;
	}
	errors.getErrorMessage = getErrorMessage;
	// Occasionally operations using the cache API throw:
	// 'UnknownError: Unexpected internal error. {}'
	// It's not clear under which circumstances this can occur. A dive of
	// the Chromium code didn't shed much light:
	// https://source.chromium.org/chromium/chromium/src/+/main:third_party/blink/renderer/modules/cache_storage/cache_storage_error.cc;l=26;drc=4cfe86482b000e848009077783ba35f83f3c3cfe
	// https://source.chromium.org/chromium/chromium/src/+/main:content/browser/cache_storage/cache_storage_cache.cc;l=1686;drc=ab68c05beb790d04d1cb7fd8faa0a197fb40d399
	// Given the error is not actionable at present and caching is 'best
	// effort' in any case ignore this error. We will want to throw for
	// errors in general though so as not to hide errors we actually could
	// fix.
	// See b/227785665 for an example.
	function ignoreCacheUnactionableErrors(e, result) {
	    if (getErrorMessage(e).includes('UnknownError')) {
	        return result;
	    }
	    else {
	        throw e;
	    }
	}
	errors.ignoreCacheUnactionableErrors = ignoreCacheUnactionableErrors;
	
	return errors;
}

var hasRequiredService_worker_controller;

function requireService_worker_controller () {
	if (hasRequiredService_worker_controller) return service_worker_controller;
	hasRequiredService_worker_controller = 1;
	// Copyright (C) 2020 The Android Open Source Project
	//
	// Licensed under the Apache License, Version 2.0 (the "License");
	// you may not use this file except in compliance with the License.
	// You may obtain a copy of the License at
	//
	//      http://www.apache.org/licenses/LICENSE-2.0
	//
	// Unless required by applicable law or agreed to in writing, software
	// distributed under the License is distributed on an "AS IS" BASIS,
	// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	// See the License for the specific language governing permissions and
	// limitations under the License.
	Object.defineProperty(service_worker_controller, "__esModule", { value: true });
	service_worker_controller.ServiceWorkerController = void 0;
	// Handles registration, unregistration and lifecycle of the service worker.
	// This class contains only the controlling logic, all the code in here runs in
	// the main thread, not in the service worker thread.
	// The actual service worker code is in src/service_worker.
	// Design doc: http://go/perfetto-offline.
	const logging_1 = requireLogging();
	const errors_1 = requireErrors();
	const globals_1 = requireGlobals();
	// We use a dedicated |caches| object to share a global boolean beween the main
	// thread and the SW. SW cannot use local-storage or anything else other than
	// IndexedDB (which would be overkill).
	const BYPASS_ID = 'BYPASS_SERVICE_WORKER';
	class BypassCache {
	    static async isBypassed() {
	        try {
	            return await caches.has(BYPASS_ID);
	        }
	        catch (e) {
	            return (0, errors_1.ignoreCacheUnactionableErrors)(e, false);
	        }
	    }
	    static async setBypass(bypass) {
	        try {
	            if (bypass) {
	                await caches.open(BYPASS_ID);
	            }
	            else {
	                await caches.delete(BYPASS_ID);
	            }
	        }
	        catch (e) {
	            (0, errors_1.ignoreCacheUnactionableErrors)(e, undefined);
	        }
	    }
	}
	class ServiceWorkerController {
	    constructor() {
	        this._initialWorker = null;
	        this._bypassed = false;
	        this._installing = false;
	    }
	    // Caller should reload().
	    async setBypass(bypass) {
	        if (!('serviceWorker' in navigator))
	            return; // Not supported.
	        this._bypassed = bypass;
	        if (bypass) {
	            await BypassCache.setBypass(true); // Create the entry.
	            for (const reg of await navigator.serviceWorker.getRegistrations()) {
	                await reg.unregister();
	            }
	        }
	        else {
	            await BypassCache.setBypass(false);
	            if (window.localStorage) {
	                window.localStorage.setItem('bypassDisabled', '1');
	            }
	            this.install();
	        }
	        globals_1.globals.rafScheduler.scheduleFullRedraw();
	    }
	    onStateChange(sw) {
	        globals_1.globals.rafScheduler.scheduleFullRedraw();
	        if (sw.state === 'installing') {
	            this._installing = true;
	        }
	        else if (sw.state === 'activated') {
	            this._installing = false;
	            // Don't show the notification if the site was served straight
	            // from the network (e.g., on the very first visit or after
	            // Ctrl+Shift+R). In these cases, we are already at the last
	            // version.
	            if (sw !== this._initialWorker && this._initialWorker) {
	                globals_1.globals.frontendLocalState.newVersionAvailable = true;
	            }
	        }
	    }
	    monitorWorker(sw) {
	        if (!sw)
	            return;
	        sw.addEventListener('error', (e) => (0, logging_1.reportError)(e));
	        sw.addEventListener('statechange', () => this.onStateChange(sw));
	        this.onStateChange(sw); // Trigger updates for the current state.
	    }
	    async install() {
	        if (!('serviceWorker' in navigator))
	            return; // Not supported.
	        if (location.pathname !== '/') {
	            // Disable the service worker when the UI is loaded from a non-root URL
	            // (e.g. from the CI artifacts GCS bucket). Supporting the case of a
	            // nested index.html is too cumbersome and has no benefits.
	            return;
	        }
	        // If this is localhost disable the service worker by default, unless the
	        // user manually re-enabled it (in which case bypassDisabled = '1').
	        const hostname = location.hostname;
	        const isLocalhost = ['127.0.0.1', '::1', 'localhost'].includes(hostname);
	        const bypassDisabled = window.localStorage &&
	            window.localStorage.getItem('bypassDisabled') === '1';
	        if (isLocalhost && !bypassDisabled) {
	            await this.setBypass(true); // Will cause the check below to bail out.
	        }
	        if (await BypassCache.isBypassed()) {
	            this._bypassed = true;
	            console.log('Skipping service worker registration, disabled by the user');
	            return;
	        }
	        // In production cases versionDir == VERSION. We use this here for ease of
	        // testing (so we can have /v1.0.0a/ /v1.0.0b/ even if they have the same
	        // version code).
	        const versionDir = globals_1.globals.root.split('/').slice(-2)[0];
	        const swUri = `/service_worker.js?v=${versionDir}`;
	        navigator.serviceWorker.register(swUri).then((registration) => {
	            this._initialWorker = registration.active;
	            // At this point there are two options:
	            // 1. This is the first time we visit the site (or cache was cleared) and
	            //    no SW is installed yet. In this case |installing| will be set.
	            // 2. A SW is already installed (though it might be obsolete). In this
	            //    case |active| will be set.
	            this.monitorWorker(registration.installing);
	            this.monitorWorker(registration.active);
	            // Setup the event that shows the "Updated to v1.2.3" notification.
	            registration.addEventListener('updatefound', () => {
	                this.monitorWorker(registration.installing);
	            });
	        });
	    }
	    get bypassed() {
	        return this._bypassed;
	    }
	    get installing() {
	        return this._installing;
	    }
	}
	service_worker_controller.ServiceWorkerController = ServiceWorkerController;
	
	return service_worker_controller;
}

var hasRequiredGlobals;

function requireGlobals () {
	if (hasRequiredGlobals) return globals;
	hasRequiredGlobals = 1;
	(function (exports) {
		// Copyright (C) 2018 The Android Open Source Project
		//
		// Licensed under the Apache License, Version 2.0 (the "License");
		// you may not use this file except in compliance with the License.
		// You may obtain a copy of the License at
		//
		//      http://www.apache.org/licenses/LICENSE-2.0
		//
		// Unless required by applicable law or agreed to in writing, software
		// distributed under the License is distributed on an "AS IS" BASIS,
		// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
		// See the License for the specific language governing permissions and
		// limitations under the License.
		Object.defineProperty(exports, "__esModule", { value: true });
		exports.globals = void 0;
		const logging_1 = requireLogging();
		const actions_1 = requireActions();
		const conversion_jobs_1 = requireConversion_jobs();
		const empty_state_1 = requireEmpty_state$1();
		const time_1 = requireTime();
		const analytics_1 = requireAnalytics();
		const frontend_local_state_1 = requireFrontend_local_state();
		const raf_scheduler_1 = requireRaf_scheduler();
		const service_worker_controller_1 = requireService_worker_controller();
		function getRoot() {
		    // Works out the root directory where the content should be served from
		    // e.g. `http://origin/v1.2.3/`.
		    const script = document.currentScript;
		    // Needed for DOM tests, that do not have script element.
		    if (script === null) {
		        return '';
		    }
		    let root = script.src;
		    root = root.substr(0, root.lastIndexOf('/') + 1);
		    return root;
		}
		/**
		 * Global accessors for state/dispatch in the frontend.
		 */
		class Globals {
		    constructor() {
		        this.root = getRoot();
		        this.bottomTabList = undefined;
		        this._testing = false;
		        this._dispatch = undefined;
		        this._state = undefined;
		        this._frontendLocalState = undefined;
		        this._rafScheduler = undefined;
		        this._serviceWorkerController = undefined;
		        this._logging = undefined;
		        this._isInternalUser = undefined;
		        // TODO(hjd): Unify trackDataStore, queryResults, overviewStore, threads.
		        this._trackDataStore = undefined;
		        this._queryResults = undefined;
		        this._overviewStore = undefined;
		        this._aggregateDataStore = undefined;
		        this._threadMap = undefined;
		        this._sliceDetails = undefined;
		        this._threadStateDetails = undefined;
		        this._connectedFlows = undefined;
		        this._selectedFlows = undefined;
		        this._visibleFlowCategories = undefined;
		        this._counterDetails = undefined;
		        this._flamegraphDetails = undefined;
		        this._cpuProfileDetails = undefined;
		        this._numQueriesQueued = 0;
		        this._bufferUsage = undefined;
		        this._recordingLog = undefined;
		        this._traceErrors = undefined;
		        this._metricError = undefined;
		        this._metricResult = undefined;
		        this._jobStatus = undefined;
		        this._router = undefined;
		        this._embeddedMode = undefined;
		        this._hideSidebar = undefined;
		        this._ftraceCounters = undefined;
		        this._ftracePanelData = undefined;
		        // TODO(hjd): Remove once we no longer need to update UUID on redraw.
		        this._publishRedraw = undefined;
		        this._currentSearchResults = {
		            sliceIds: new Float64Array(0),
		            tsStarts: new Float64Array(0),
		            utids: new Float64Array(0),
		            trackIds: [],
		            sources: [],
		            totalResults: 0,
		        };
		        this.searchSummary = {
		            tsStarts: new Float64Array(0),
		            tsEnds: new Float64Array(0),
		            count: new Uint8Array(0),
		        };
		        this.engines = new Map();
		    }
		    initialize(dispatch, router) {
		        this._dispatch = dispatch;
		        this._router = router;
		        this._state = (0, empty_state_1.createEmptyState)();
		        this._frontendLocalState = new frontend_local_state_1.FrontendLocalState();
		        this._rafScheduler = new raf_scheduler_1.RafScheduler();
		        this._serviceWorkerController = new service_worker_controller_1.ServiceWorkerController();
		        this._testing =
		            self.location && self.location.search.indexOf('testing=1') >= 0;
		        this._logging = (0, analytics_1.initAnalytics)();
		        // TODO(hjd): Unify trackDataStore, queryResults, overviewStore, threads.
		        this._trackDataStore = new Map();
		        this._queryResults = new Map();
		        this._overviewStore = new Map();
		        this._aggregateDataStore = new Map();
		        this._threadMap = new Map();
		        this._sliceDetails = {};
		        this._connectedFlows = [];
		        this._selectedFlows = [];
		        this._visibleFlowCategories = new Map();
		        this._counterDetails = {};
		        this._threadStateDetails = {};
		        this._flamegraphDetails = {};
		        this._cpuProfileDetails = {};
		        this.engines.clear();
		    }
		    get router() {
		        return (0, logging_1.assertExists)(this._router);
		    }
		    get publishRedraw() {
		        return this._publishRedraw || (() => { });
		    }
		    set publishRedraw(f) {
		        this._publishRedraw = f;
		    }
		    get state() {
		        return (0, logging_1.assertExists)(this._state);
		    }
		    set state(state) {
		        this._state = (0, logging_1.assertExists)(state);
		    }
		    get dispatch() {
		        return (0, logging_1.assertExists)(this._dispatch);
		    }
		    dispatchMultiple(actions) {
		        const dispatch = this.dispatch;
		        for (const action of actions) {
		            dispatch(action);
		        }
		    }
		    get frontendLocalState() {
		        return (0, logging_1.assertExists)(this._frontendLocalState);
		    }
		    get rafScheduler() {
		        return (0, logging_1.assertExists)(this._rafScheduler);
		    }
		    get logging() {
		        return (0, logging_1.assertExists)(this._logging);
		    }
		    get serviceWorkerController() {
		        return (0, logging_1.assertExists)(this._serviceWorkerController);
		    }
		    // TODO(hjd): Unify trackDataStore, queryResults, overviewStore, threads.
		    get overviewStore() {
		        return (0, logging_1.assertExists)(this._overviewStore);
		    }
		    get trackDataStore() {
		        return (0, logging_1.assertExists)(this._trackDataStore);
		    }
		    get queryResults() {
		        return (0, logging_1.assertExists)(this._queryResults);
		    }
		    get threads() {
		        return (0, logging_1.assertExists)(this._threadMap);
		    }
		    get sliceDetails() {
		        return (0, logging_1.assertExists)(this._sliceDetails);
		    }
		    set sliceDetails(click) {
		        this._sliceDetails = (0, logging_1.assertExists)(click);
		    }
		    get threadStateDetails() {
		        return (0, logging_1.assertExists)(this._threadStateDetails);
		    }
		    set threadStateDetails(click) {
		        this._threadStateDetails = (0, logging_1.assertExists)(click);
		    }
		    get connectedFlows() {
		        return (0, logging_1.assertExists)(this._connectedFlows);
		    }
		    set connectedFlows(connectedFlows) {
		        this._connectedFlows = (0, logging_1.assertExists)(connectedFlows);
		    }
		    get selectedFlows() {
		        return (0, logging_1.assertExists)(this._selectedFlows);
		    }
		    set selectedFlows(selectedFlows) {
		        this._selectedFlows = (0, logging_1.assertExists)(selectedFlows);
		    }
		    get visibleFlowCategories() {
		        return (0, logging_1.assertExists)(this._visibleFlowCategories);
		    }
		    set visibleFlowCategories(visibleFlowCategories) {
		        this._visibleFlowCategories = (0, logging_1.assertExists)(visibleFlowCategories);
		    }
		    get counterDetails() {
		        return (0, logging_1.assertExists)(this._counterDetails);
		    }
		    set counterDetails(click) {
		        this._counterDetails = (0, logging_1.assertExists)(click);
		    }
		    get aggregateDataStore() {
		        return (0, logging_1.assertExists)(this._aggregateDataStore);
		    }
		    get flamegraphDetails() {
		        return (0, logging_1.assertExists)(this._flamegraphDetails);
		    }
		    set flamegraphDetails(click) {
		        this._flamegraphDetails = (0, logging_1.assertExists)(click);
		    }
		    get traceErrors() {
		        return this._traceErrors;
		    }
		    setTraceErrors(arg) {
		        this._traceErrors = arg;
		    }
		    get metricError() {
		        return this._metricError;
		    }
		    setMetricError(arg) {
		        this._metricError = arg;
		    }
		    get metricResult() {
		        return this._metricResult;
		    }
		    setMetricResult(result) {
		        this._metricResult = result;
		    }
		    get cpuProfileDetails() {
		        return (0, logging_1.assertExists)(this._cpuProfileDetails);
		    }
		    set cpuProfileDetails(click) {
		        this._cpuProfileDetails = (0, logging_1.assertExists)(click);
		    }
		    set numQueuedQueries(value) {
		        this._numQueriesQueued = value;
		    }
		    get numQueuedQueries() {
		        return this._numQueriesQueued;
		    }
		    get bufferUsage() {
		        return this._bufferUsage;
		    }
		    get recordingLog() {
		        return this._recordingLog;
		    }
		    get currentSearchResults() {
		        return this._currentSearchResults;
		    }
		    set currentSearchResults(results) {
		        this._currentSearchResults = results;
		    }
		    get hasFtrace() {
		        return Boolean(this._ftraceCounters && this._ftraceCounters.length > 0);
		    }
		    get ftraceCounters() {
		        return this._ftraceCounters;
		    }
		    set ftraceCounters(value) {
		        this._ftraceCounters = value;
		    }
		    getConversionJobStatus(name) {
		        return this.getJobStatusMap().get(name) || conversion_jobs_1.ConversionJobStatus.NotRunning;
		    }
		    setConversionJobStatus(name, status) {
		        const map = this.getJobStatusMap();
		        if (status === conversion_jobs_1.ConversionJobStatus.NotRunning) {
		            map.delete(name);
		        }
		        else {
		            map.set(name, status);
		        }
		    }
		    getJobStatusMap() {
		        if (!this._jobStatus) {
		            this._jobStatus = new Map();
		        }
		        return this._jobStatus;
		    }
		    get embeddedMode() {
		        return !!this._embeddedMode;
		    }
		    set embeddedMode(value) {
		        this._embeddedMode = value;
		    }
		    get hideSidebar() {
		        return !!this._hideSidebar;
		    }
		    set hideSidebar(value) {
		        this._hideSidebar = value;
		    }
		    setBufferUsage(bufferUsage) {
		        this._bufferUsage = bufferUsage;
		    }
		    setTrackData(id, data) {
		        this.trackDataStore.set(id, data);
		    }
		    setRecordingLog(recordingLog) {
		        this._recordingLog = recordingLog;
		    }
		    setAggregateData(kind, data) {
		        this.aggregateDataStore.set(kind, data);
		    }
		    getCurResolution() {
		        // Truncate the resolution to the closest power of 2 (in nanosecond space).
		        // We choose to work in ns space because resolution is consumed be track
		        // controllers for quantization and they rely on resolution to be a power
		        // of 2 in nanosecond form. This is property does not hold if we work in
		        // second space.
		        //
		        // This effectively means the resolution changes approximately every 6 zoom
		        // levels. Logic: each zoom level represents a delta of 0.1 * (visible
		        // window span). Therefore, zooming out by six levels is 1.1^6 ~= 2.
		        // Similarily, zooming in six levels is 0.9^6 ~= 0.5.
		        const pxToSec = this.frontendLocalState.timeScale.deltaPxToDuration(1);
		        // TODO(b/186265930): Remove once fixed:
		        if (!isFinite(pxToSec)) {
		            // Resolution is in pixels per second so 1000 means 1px = 1ms.
		            console.error(`b/186265930: Bad pxToSec suppressed ${pxToSec}`);
		            return (0, time_1.fromNs)(Math.pow(2, Math.floor(Math.log2((0, time_1.toNs)(1000)))));
		        }
		        const pxToNs = Math.max((0, time_1.toNs)(pxToSec), 1);
		        const resolution = (0, time_1.fromNs)(Math.pow(2, Math.floor(Math.log2(pxToNs))));
		        const log2 = Math.log2((0, time_1.toNs)(resolution));
		        if (log2 % 1 !== 0) {
		            throw new Error(`Resolution should be a power of two.
        pxToSec: ${pxToSec},
        pxToNs: ${pxToNs},
        resolution: ${resolution},
        log2: ${Math.log2((0, time_1.toNs)(resolution))}`);
		        }
		        return resolution;
		    }
		    getCurrentEngine() {
		        return this.state.engine;
		    }
		    get ftracePanelData() {
		        return this._ftracePanelData;
		    }
		    set ftracePanelData(data) {
		        this._ftracePanelData = data;
		    }
		    makeSelection(action, tabToOpen = 'current_selection') {
		        // A new selection should cancel the current search selection.
		        exports.globals.dispatch(actions_1.Actions.setSearchIndex({ index: -1 }));
		        const tab = action.type === 'deselect' ? undefined : tabToOpen;
		        exports.globals.dispatch(actions_1.Actions.setCurrentTab({ tab }));
		        exports.globals.dispatch(action);
		    }
		    resetForTesting() {
		        this._dispatch = undefined;
		        this._state = undefined;
		        this._frontendLocalState = undefined;
		        this._rafScheduler = undefined;
		        this._serviceWorkerController = undefined;
		        // TODO(hjd): Unify trackDataStore, queryResults, overviewStore, threads.
		        this._trackDataStore = undefined;
		        this._queryResults = undefined;
		        this._overviewStore = undefined;
		        this._threadMap = undefined;
		        this._sliceDetails = undefined;
		        this._threadStateDetails = undefined;
		        this._aggregateDataStore = undefined;
		        this._numQueriesQueued = 0;
		        this._metricResult = undefined;
		        this._currentSearchResults = {
		            sliceIds: new Float64Array(0),
		            tsStarts: new Float64Array(0),
		            utids: new Float64Array(0),
		            trackIds: [],
		            sources: [],
		            totalResults: 0,
		        };
		    }
		    // This variable is set by the is_internal_user.js script if the user is a
		    // googler. This is used to avoid exposing features that are not ready yet
		    // for public consumption. The gated features themselves are not secret.
		    // If a user has been detected as a Googler once, make that sticky in
		    // localStorage, so that we keep treating them as such when they connect over
		    // public networks.
		    get isInternalUser() {
		        if (this._isInternalUser === undefined) {
		            this._isInternalUser = localStorage.getItem('isInternalUser') === '1';
		        }
		        return this._isInternalUser;
		    }
		    set isInternalUser(value) {
		        localStorage.setItem('isInternalUser', value ? '1' : '0');
		        this._isInternalUser = value;
		    }
		    get testing() {
		        return this._testing;
		    }
		    // Used when switching to the legacy TraceViewer UI.
		    // Most resources are cleaned up by replacing the current |window| object,
		    // however pending RAFs and workers seem to outlive the |window| and need to
		    // be cleaned up explicitly.
		    shutdown() {
		        this._rafScheduler.shutdown();
		    }
		}
		exports.globals = new Globals();
		
} (globals));
	return globals;
}

var pivot_table_types = {};

var comparator_builder = {};

var hasRequiredComparator_builder;

function requireComparator_builder () {
	if (hasRequiredComparator_builder) return comparator_builder;
	hasRequiredComparator_builder = 1;
	// Copyright (C) 2022 The Android Open Source Project
	//
	// Licensed under the Apache License, Version 2.0 (the "License");
	// you may not use this file except in compliance with the License.
	// You may obtain a copy of the License at
	//
	//      http://www.apache.org/licenses/LICENSE-2.0
	//
	// Unless required by applicable law or agreed to in writing, software
	// distributed under the License is distributed on an "AS IS" BASIS,
	// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	// See the License for the specific language governing permissions and
	// limitations under the License.
	Object.defineProperty(comparator_builder, "__esModule", { value: true });
	comparator_builder.EqualsBuilder = void 0;
	// Simple builder-style class to implement object equality more succinctly.
	class EqualsBuilder {
	    constructor(first, second) {
	        this.result = true;
	        this.first = first;
	        this.second = second;
	    }
	    comparePrimitive(getter) {
	        if (this.result) {
	            this.result = getter(this.first) === getter(this.second);
	        }
	        return this;
	    }
	    compare(comparator, getter) {
	        if (this.result) {
	            this.result = comparator(getter(this.first), getter(this.second));
	        }
	        return this;
	    }
	    equals() {
	        return this.result;
	    }
	}
	comparator_builder.EqualsBuilder = EqualsBuilder;
	
	return comparator_builder;
}

var hasRequiredPivot_table_types;

function requirePivot_table_types () {
	if (hasRequiredPivot_table_types) return pivot_table_types;
	hasRequiredPivot_table_types = 1;
	// Copyright (C) 2022 The Android Open Source Project
	//
	// Licensed under the Apache License, Version 2.0 (the "License");
	// you may not use this file except in compliance with the License.
	// You may obtain a copy of the License at
	//
	//      http://www.apache.org/licenses/LICENSE-2.0
	//
	// Unless required by applicable law or agreed to in writing, software
	// distributed under the License is distributed on an "AS IS" BASIS,
	// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	// See the License for the specific language governing permissions and
	// limitations under the License.
	Object.defineProperty(pivot_table_types, "__esModule", { value: true });
	pivot_table_types.aggregationKey = pivot_table_types.columnKey = pivot_table_types.aggregationEquals = pivot_table_types.toggleEnabled = pivot_table_types.tableColumnEquals = void 0;
	const comparator_builder_1 = requireComparator_builder();
	function tableColumnEquals(t1, t2) {
	    switch (t1.kind) {
	        case 'argument': {
	            return t2.kind === 'argument' && t1.argument === t2.argument;
	        }
	        case 'regular': {
	            return t2.kind === 'regular' && t1.table === t2.table &&
	                t1.column === t2.column;
	        }
	    }
	}
	pivot_table_types.tableColumnEquals = tableColumnEquals;
	function toggleEnabled(compare, arr, column, enabled) {
	    if (enabled && arr.find((value) => compare(column, value)) === undefined) {
	        arr.push(column);
	    }
	    if (!enabled) {
	        const index = arr.findIndex((value) => compare(column, value));
	        if (index !== -1) {
	            arr.splice(index, 1);
	        }
	    }
	}
	pivot_table_types.toggleEnabled = toggleEnabled;
	function aggregationEquals(agg1, agg2) {
	    return new comparator_builder_1.EqualsBuilder(agg1, agg2)
	        .comparePrimitive((agg) => agg.aggregationFunction)
	        .compare(tableColumnEquals, (agg) => agg.column)
	        .equals();
	}
	pivot_table_types.aggregationEquals = aggregationEquals;
	// Used to convert TableColumn to a string in order to store it in a Map, as
	// ES6 does not support compound Set/Map keys. This function should only be used
	// for interning keys, and does not have any requirements beyond different
	// TableColumn objects mapping to different strings.
	function columnKey(tableColumn) {
	    switch (tableColumn.kind) {
	        case 'argument': {
	            return `argument:${tableColumn.argument}`;
	        }
	        case 'regular': {
	            return `${tableColumn.table}.${tableColumn.column}`;
	        }
	    }
	}
	pivot_table_types.columnKey = columnKey;
	function aggregationKey(aggregation) {
	    return `${aggregation.aggregationFunction}:${columnKey(aggregation.column)}`;
	}
	pivot_table_types.aggregationKey = aggregationKey;
	
	return pivot_table_types;
}

var colorizer = {};

var colorName;
var hasRequiredColorName;

function requireColorName () {
	if (hasRequiredColorName) return colorName;
	hasRequiredColorName = 1;

	colorName = {
		"aliceblue": [240, 248, 255],
		"antiquewhite": [250, 235, 215],
		"aqua": [0, 255, 255],
		"aquamarine": [127, 255, 212],
		"azure": [240, 255, 255],
		"beige": [245, 245, 220],
		"bisque": [255, 228, 196],
		"black": [0, 0, 0],
		"blanchedalmond": [255, 235, 205],
		"blue": [0, 0, 255],
		"blueviolet": [138, 43, 226],
		"brown": [165, 42, 42],
		"burlywood": [222, 184, 135],
		"cadetblue": [95, 158, 160],
		"chartreuse": [127, 255, 0],
		"chocolate": [210, 105, 30],
		"coral": [255, 127, 80],
		"cornflowerblue": [100, 149, 237],
		"cornsilk": [255, 248, 220],
		"crimson": [220, 20, 60],
		"cyan": [0, 255, 255],
		"darkblue": [0, 0, 139],
		"darkcyan": [0, 139, 139],
		"darkgoldenrod": [184, 134, 11],
		"darkgray": [169, 169, 169],
		"darkgreen": [0, 100, 0],
		"darkgrey": [169, 169, 169],
		"darkkhaki": [189, 183, 107],
		"darkmagenta": [139, 0, 139],
		"darkolivegreen": [85, 107, 47],
		"darkorange": [255, 140, 0],
		"darkorchid": [153, 50, 204],
		"darkred": [139, 0, 0],
		"darksalmon": [233, 150, 122],
		"darkseagreen": [143, 188, 143],
		"darkslateblue": [72, 61, 139],
		"darkslategray": [47, 79, 79],
		"darkslategrey": [47, 79, 79],
		"darkturquoise": [0, 206, 209],
		"darkviolet": [148, 0, 211],
		"deeppink": [255, 20, 147],
		"deepskyblue": [0, 191, 255],
		"dimgray": [105, 105, 105],
		"dimgrey": [105, 105, 105],
		"dodgerblue": [30, 144, 255],
		"firebrick": [178, 34, 34],
		"floralwhite": [255, 250, 240],
		"forestgreen": [34, 139, 34],
		"fuchsia": [255, 0, 255],
		"gainsboro": [220, 220, 220],
		"ghostwhite": [248, 248, 255],
		"gold": [255, 215, 0],
		"goldenrod": [218, 165, 32],
		"gray": [128, 128, 128],
		"green": [0, 128, 0],
		"greenyellow": [173, 255, 47],
		"grey": [128, 128, 128],
		"honeydew": [240, 255, 240],
		"hotpink": [255, 105, 180],
		"indianred": [205, 92, 92],
		"indigo": [75, 0, 130],
		"ivory": [255, 255, 240],
		"khaki": [240, 230, 140],
		"lavender": [230, 230, 250],
		"lavenderblush": [255, 240, 245],
		"lawngreen": [124, 252, 0],
		"lemonchiffon": [255, 250, 205],
		"lightblue": [173, 216, 230],
		"lightcoral": [240, 128, 128],
		"lightcyan": [224, 255, 255],
		"lightgoldenrodyellow": [250, 250, 210],
		"lightgray": [211, 211, 211],
		"lightgreen": [144, 238, 144],
		"lightgrey": [211, 211, 211],
		"lightpink": [255, 182, 193],
		"lightsalmon": [255, 160, 122],
		"lightseagreen": [32, 178, 170],
		"lightskyblue": [135, 206, 250],
		"lightslategray": [119, 136, 153],
		"lightslategrey": [119, 136, 153],
		"lightsteelblue": [176, 196, 222],
		"lightyellow": [255, 255, 224],
		"lime": [0, 255, 0],
		"limegreen": [50, 205, 50],
		"linen": [250, 240, 230],
		"magenta": [255, 0, 255],
		"maroon": [128, 0, 0],
		"mediumaquamarine": [102, 205, 170],
		"mediumblue": [0, 0, 205],
		"mediumorchid": [186, 85, 211],
		"mediumpurple": [147, 112, 219],
		"mediumseagreen": [60, 179, 113],
		"mediumslateblue": [123, 104, 238],
		"mediumspringgreen": [0, 250, 154],
		"mediumturquoise": [72, 209, 204],
		"mediumvioletred": [199, 21, 133],
		"midnightblue": [25, 25, 112],
		"mintcream": [245, 255, 250],
		"mistyrose": [255, 228, 225],
		"moccasin": [255, 228, 181],
		"navajowhite": [255, 222, 173],
		"navy": [0, 0, 128],
		"oldlace": [253, 245, 230],
		"olive": [128, 128, 0],
		"olivedrab": [107, 142, 35],
		"orange": [255, 165, 0],
		"orangered": [255, 69, 0],
		"orchid": [218, 112, 214],
		"palegoldenrod": [238, 232, 170],
		"palegreen": [152, 251, 152],
		"paleturquoise": [175, 238, 238],
		"palevioletred": [219, 112, 147],
		"papayawhip": [255, 239, 213],
		"peachpuff": [255, 218, 185],
		"peru": [205, 133, 63],
		"pink": [255, 192, 203],
		"plum": [221, 160, 221],
		"powderblue": [176, 224, 230],
		"purple": [128, 0, 128],
		"rebeccapurple": [102, 51, 153],
		"red": [255, 0, 0],
		"rosybrown": [188, 143, 143],
		"royalblue": [65, 105, 225],
		"saddlebrown": [139, 69, 19],
		"salmon": [250, 128, 114],
		"sandybrown": [244, 164, 96],
		"seagreen": [46, 139, 87],
		"seashell": [255, 245, 238],
		"sienna": [160, 82, 45],
		"silver": [192, 192, 192],
		"skyblue": [135, 206, 235],
		"slateblue": [106, 90, 205],
		"slategray": [112, 128, 144],
		"slategrey": [112, 128, 144],
		"snow": [255, 250, 250],
		"springgreen": [0, 255, 127],
		"steelblue": [70, 130, 180],
		"tan": [210, 180, 140],
		"teal": [0, 128, 128],
		"thistle": [216, 191, 216],
		"tomato": [255, 99, 71],
		"turquoise": [64, 224, 208],
		"violet": [238, 130, 238],
		"wheat": [245, 222, 179],
		"white": [255, 255, 255],
		"whitesmoke": [245, 245, 245],
		"yellow": [255, 255, 0],
		"yellowgreen": [154, 205, 50]
	};
	return colorName;
}

/* MIT license */

var conversions;
var hasRequiredConversions;

function requireConversions () {
	if (hasRequiredConversions) return conversions;
	hasRequiredConversions = 1;
	/* eslint-disable no-mixed-operators */
	const cssKeywords = requireColorName();

	// NOTE: conversions should only return primitive values (i.e. arrays, or
	//       values that give correct `typeof` results).
	//       do not use box values types (i.e. Number(), String(), etc.)

	const reverseKeywords = {};
	for (const key of Object.keys(cssKeywords)) {
		reverseKeywords[cssKeywords[key]] = key;
	}

	const convert = {
		rgb: {channels: 3, labels: 'rgb'},
		hsl: {channels: 3, labels: 'hsl'},
		hsv: {channels: 3, labels: 'hsv'},
		hwb: {channels: 3, labels: 'hwb'},
		cmyk: {channels: 4, labels: 'cmyk'},
		xyz: {channels: 3, labels: 'xyz'},
		lab: {channels: 3, labels: 'lab'},
		lch: {channels: 3, labels: 'lch'},
		hex: {channels: 1, labels: ['hex']},
		keyword: {channels: 1, labels: ['keyword']},
		ansi16: {channels: 1, labels: ['ansi16']},
		ansi256: {channels: 1, labels: ['ansi256']},
		hcg: {channels: 3, labels: ['h', 'c', 'g']},
		apple: {channels: 3, labels: ['r16', 'g16', 'b16']},
		gray: {channels: 1, labels: ['gray']}
	};

	conversions = convert;

	// Hide .channels and .labels properties
	for (const model of Object.keys(convert)) {
		if (!('channels' in convert[model])) {
			throw new Error('missing channels property: ' + model);
		}

		if (!('labels' in convert[model])) {
			throw new Error('missing channel labels property: ' + model);
		}

		if (convert[model].labels.length !== convert[model].channels) {
			throw new Error('channel and label counts mismatch: ' + model);
		}

		const {channels, labels} = convert[model];
		delete convert[model].channels;
		delete convert[model].labels;
		Object.defineProperty(convert[model], 'channels', {value: channels});
		Object.defineProperty(convert[model], 'labels', {value: labels});
	}

	convert.rgb.hsl = function (rgb) {
		const r = rgb[0] / 255;
		const g = rgb[1] / 255;
		const b = rgb[2] / 255;
		const min = Math.min(r, g, b);
		const max = Math.max(r, g, b);
		const delta = max - min;
		let h;
		let s;

		if (max === min) {
			h = 0;
		} else if (r === max) {
			h = (g - b) / delta;
		} else if (g === max) {
			h = 2 + (b - r) / delta;
		} else if (b === max) {
			h = 4 + (r - g) / delta;
		}

		h = Math.min(h * 60, 360);

		if (h < 0) {
			h += 360;
		}

		const l = (min + max) / 2;

		if (max === min) {
			s = 0;
		} else if (l <= 0.5) {
			s = delta / (max + min);
		} else {
			s = delta / (2 - max - min);
		}

		return [h, s * 100, l * 100];
	};

	convert.rgb.hsv = function (rgb) {
		let rdif;
		let gdif;
		let bdif;
		let h;
		let s;

		const r = rgb[0] / 255;
		const g = rgb[1] / 255;
		const b = rgb[2] / 255;
		const v = Math.max(r, g, b);
		const diff = v - Math.min(r, g, b);
		const diffc = function (c) {
			return (v - c) / 6 / diff + 1 / 2;
		};

		if (diff === 0) {
			h = 0;
			s = 0;
		} else {
			s = diff / v;
			rdif = diffc(r);
			gdif = diffc(g);
			bdif = diffc(b);

			if (r === v) {
				h = bdif - gdif;
			} else if (g === v) {
				h = (1 / 3) + rdif - bdif;
			} else if (b === v) {
				h = (2 / 3) + gdif - rdif;
			}

			if (h < 0) {
				h += 1;
			} else if (h > 1) {
				h -= 1;
			}
		}

		return [
			h * 360,
			s * 100,
			v * 100
		];
	};

	convert.rgb.hwb = function (rgb) {
		const r = rgb[0];
		const g = rgb[1];
		let b = rgb[2];
		const h = convert.rgb.hsl(rgb)[0];
		const w = 1 / 255 * Math.min(r, Math.min(g, b));

		b = 1 - 1 / 255 * Math.max(r, Math.max(g, b));

		return [h, w * 100, b * 100];
	};

	convert.rgb.cmyk = function (rgb) {
		const r = rgb[0] / 255;
		const g = rgb[1] / 255;
		const b = rgb[2] / 255;

		const k = Math.min(1 - r, 1 - g, 1 - b);
		const c = (1 - r - k) / (1 - k) || 0;
		const m = (1 - g - k) / (1 - k) || 0;
		const y = (1 - b - k) / (1 - k) || 0;

		return [c * 100, m * 100, y * 100, k * 100];
	};

	function comparativeDistance(x, y) {
		/*
			See https://en.m.wikipedia.org/wiki/Euclidean_distance#Squared_Euclidean_distance
		*/
		return (
			((x[0] - y[0]) ** 2) +
			((x[1] - y[1]) ** 2) +
			((x[2] - y[2]) ** 2)
		);
	}

	convert.rgb.keyword = function (rgb) {
		const reversed = reverseKeywords[rgb];
		if (reversed) {
			return reversed;
		}

		let currentClosestDistance = Infinity;
		let currentClosestKeyword;

		for (const keyword of Object.keys(cssKeywords)) {
			const value = cssKeywords[keyword];

			// Compute comparative distance
			const distance = comparativeDistance(rgb, value);

			// Check if its less, if so set as closest
			if (distance < currentClosestDistance) {
				currentClosestDistance = distance;
				currentClosestKeyword = keyword;
			}
		}

		return currentClosestKeyword;
	};

	convert.keyword.rgb = function (keyword) {
		return cssKeywords[keyword];
	};

	convert.rgb.xyz = function (rgb) {
		let r = rgb[0] / 255;
		let g = rgb[1] / 255;
		let b = rgb[2] / 255;

		// Assume sRGB
		r = r > 0.04045 ? (((r + 0.055) / 1.055) ** 2.4) : (r / 12.92);
		g = g > 0.04045 ? (((g + 0.055) / 1.055) ** 2.4) : (g / 12.92);
		b = b > 0.04045 ? (((b + 0.055) / 1.055) ** 2.4) : (b / 12.92);

		const x = (r * 0.4124) + (g * 0.3576) + (b * 0.1805);
		const y = (r * 0.2126) + (g * 0.7152) + (b * 0.0722);
		const z = (r * 0.0193) + (g * 0.1192) + (b * 0.9505);

		return [x * 100, y * 100, z * 100];
	};

	convert.rgb.lab = function (rgb) {
		const xyz = convert.rgb.xyz(rgb);
		let x = xyz[0];
		let y = xyz[1];
		let z = xyz[2];

		x /= 95.047;
		y /= 100;
		z /= 108.883;

		x = x > 0.008856 ? (x ** (1 / 3)) : (7.787 * x) + (16 / 116);
		y = y > 0.008856 ? (y ** (1 / 3)) : (7.787 * y) + (16 / 116);
		z = z > 0.008856 ? (z ** (1 / 3)) : (7.787 * z) + (16 / 116);

		const l = (116 * y) - 16;
		const a = 500 * (x - y);
		const b = 200 * (y - z);

		return [l, a, b];
	};

	convert.hsl.rgb = function (hsl) {
		const h = hsl[0] / 360;
		const s = hsl[1] / 100;
		const l = hsl[2] / 100;
		let t2;
		let t3;
		let val;

		if (s === 0) {
			val = l * 255;
			return [val, val, val];
		}

		if (l < 0.5) {
			t2 = l * (1 + s);
		} else {
			t2 = l + s - l * s;
		}

		const t1 = 2 * l - t2;

		const rgb = [0, 0, 0];
		for (let i = 0; i < 3; i++) {
			t3 = h + 1 / 3 * -(i - 1);
			if (t3 < 0) {
				t3++;
			}

			if (t3 > 1) {
				t3--;
			}

			if (6 * t3 < 1) {
				val = t1 + (t2 - t1) * 6 * t3;
			} else if (2 * t3 < 1) {
				val = t2;
			} else if (3 * t3 < 2) {
				val = t1 + (t2 - t1) * (2 / 3 - t3) * 6;
			} else {
				val = t1;
			}

			rgb[i] = val * 255;
		}

		return rgb;
	};

	convert.hsl.hsv = function (hsl) {
		const h = hsl[0];
		let s = hsl[1] / 100;
		let l = hsl[2] / 100;
		let smin = s;
		const lmin = Math.max(l, 0.01);

		l *= 2;
		s *= (l <= 1) ? l : 2 - l;
		smin *= lmin <= 1 ? lmin : 2 - lmin;
		const v = (l + s) / 2;
		const sv = l === 0 ? (2 * smin) / (lmin + smin) : (2 * s) / (l + s);

		return [h, sv * 100, v * 100];
	};

	convert.hsv.rgb = function (hsv) {
		const h = hsv[0] / 60;
		const s = hsv[1] / 100;
		let v = hsv[2] / 100;
		const hi = Math.floor(h) % 6;

		const f = h - Math.floor(h);
		const p = 255 * v * (1 - s);
		const q = 255 * v * (1 - (s * f));
		const t = 255 * v * (1 - (s * (1 - f)));
		v *= 255;

		switch (hi) {
			case 0:
				return [v, t, p];
			case 1:
				return [q, v, p];
			case 2:
				return [p, v, t];
			case 3:
				return [p, q, v];
			case 4:
				return [t, p, v];
			case 5:
				return [v, p, q];
		}
	};

	convert.hsv.hsl = function (hsv) {
		const h = hsv[0];
		const s = hsv[1] / 100;
		const v = hsv[2] / 100;
		const vmin = Math.max(v, 0.01);
		let sl;
		let l;

		l = (2 - s) * v;
		const lmin = (2 - s) * vmin;
		sl = s * vmin;
		sl /= (lmin <= 1) ? lmin : 2 - lmin;
		sl = sl || 0;
		l /= 2;

		return [h, sl * 100, l * 100];
	};

	// http://dev.w3.org/csswg/css-color/#hwb-to-rgb
	convert.hwb.rgb = function (hwb) {
		const h = hwb[0] / 360;
		let wh = hwb[1] / 100;
		let bl = hwb[2] / 100;
		const ratio = wh + bl;
		let f;

		// Wh + bl cant be > 1
		if (ratio > 1) {
			wh /= ratio;
			bl /= ratio;
		}

		const i = Math.floor(6 * h);
		const v = 1 - bl;
		f = 6 * h - i;

		if ((i & 0x01) !== 0) {
			f = 1 - f;
		}

		const n = wh + f * (v - wh); // Linear interpolation

		let r;
		let g;
		let b;
		/* eslint-disable max-statements-per-line,no-multi-spaces */
		switch (i) {
			default:
			case 6:
			case 0: r = v;  g = n;  b = wh; break;
			case 1: r = n;  g = v;  b = wh; break;
			case 2: r = wh; g = v;  b = n; break;
			case 3: r = wh; g = n;  b = v; break;
			case 4: r = n;  g = wh; b = v; break;
			case 5: r = v;  g = wh; b = n; break;
		}
		/* eslint-enable max-statements-per-line,no-multi-spaces */

		return [r * 255, g * 255, b * 255];
	};

	convert.cmyk.rgb = function (cmyk) {
		const c = cmyk[0] / 100;
		const m = cmyk[1] / 100;
		const y = cmyk[2] / 100;
		const k = cmyk[3] / 100;

		const r = 1 - Math.min(1, c * (1 - k) + k);
		const g = 1 - Math.min(1, m * (1 - k) + k);
		const b = 1 - Math.min(1, y * (1 - k) + k);

		return [r * 255, g * 255, b * 255];
	};

	convert.xyz.rgb = function (xyz) {
		const x = xyz[0] / 100;
		const y = xyz[1] / 100;
		const z = xyz[2] / 100;
		let r;
		let g;
		let b;

		r = (x * 3.2406) + (y * -1.5372) + (z * -0.4986);
		g = (x * -0.9689) + (y * 1.8758) + (z * 0.0415);
		b = (x * 0.0557) + (y * -0.2040) + (z * 1.0570);

		// Assume sRGB
		r = r > 0.0031308
			? ((1.055 * (r ** (1.0 / 2.4))) - 0.055)
			: r * 12.92;

		g = g > 0.0031308
			? ((1.055 * (g ** (1.0 / 2.4))) - 0.055)
			: g * 12.92;

		b = b > 0.0031308
			? ((1.055 * (b ** (1.0 / 2.4))) - 0.055)
			: b * 12.92;

		r = Math.min(Math.max(0, r), 1);
		g = Math.min(Math.max(0, g), 1);
		b = Math.min(Math.max(0, b), 1);

		return [r * 255, g * 255, b * 255];
	};

	convert.xyz.lab = function (xyz) {
		let x = xyz[0];
		let y = xyz[1];
		let z = xyz[2];

		x /= 95.047;
		y /= 100;
		z /= 108.883;

		x = x > 0.008856 ? (x ** (1 / 3)) : (7.787 * x) + (16 / 116);
		y = y > 0.008856 ? (y ** (1 / 3)) : (7.787 * y) + (16 / 116);
		z = z > 0.008856 ? (z ** (1 / 3)) : (7.787 * z) + (16 / 116);

		const l = (116 * y) - 16;
		const a = 500 * (x - y);
		const b = 200 * (y - z);

		return [l, a, b];
	};

	convert.lab.xyz = function (lab) {
		const l = lab[0];
		const a = lab[1];
		const b = lab[2];
		let x;
		let y;
		let z;

		y = (l + 16) / 116;
		x = a / 500 + y;
		z = y - b / 200;

		const y2 = y ** 3;
		const x2 = x ** 3;
		const z2 = z ** 3;
		y = y2 > 0.008856 ? y2 : (y - 16 / 116) / 7.787;
		x = x2 > 0.008856 ? x2 : (x - 16 / 116) / 7.787;
		z = z2 > 0.008856 ? z2 : (z - 16 / 116) / 7.787;

		x *= 95.047;
		y *= 100;
		z *= 108.883;

		return [x, y, z];
	};

	convert.lab.lch = function (lab) {
		const l = lab[0];
		const a = lab[1];
		const b = lab[2];
		let h;

		const hr = Math.atan2(b, a);
		h = hr * 360 / 2 / Math.PI;

		if (h < 0) {
			h += 360;
		}

		const c = Math.sqrt(a * a + b * b);

		return [l, c, h];
	};

	convert.lch.lab = function (lch) {
		const l = lch[0];
		const c = lch[1];
		const h = lch[2];

		const hr = h / 360 * 2 * Math.PI;
		const a = c * Math.cos(hr);
		const b = c * Math.sin(hr);

		return [l, a, b];
	};

	convert.rgb.ansi16 = function (args, saturation = null) {
		const [r, g, b] = args;
		let value = saturation === null ? convert.rgb.hsv(args)[2] : saturation; // Hsv -> ansi16 optimization

		value = Math.round(value / 50);

		if (value === 0) {
			return 30;
		}

		let ansi = 30
			+ ((Math.round(b / 255) << 2)
			| (Math.round(g / 255) << 1)
			| Math.round(r / 255));

		if (value === 2) {
			ansi += 60;
		}

		return ansi;
	};

	convert.hsv.ansi16 = function (args) {
		// Optimization here; we already know the value and don't need to get
		// it converted for us.
		return convert.rgb.ansi16(convert.hsv.rgb(args), args[2]);
	};

	convert.rgb.ansi256 = function (args) {
		const r = args[0];
		const g = args[1];
		const b = args[2];

		// We use the extended greyscale palette here, with the exception of
		// black and white. normal palette only has 4 greyscale shades.
		if (r === g && g === b) {
			if (r < 8) {
				return 16;
			}

			if (r > 248) {
				return 231;
			}

			return Math.round(((r - 8) / 247) * 24) + 232;
		}

		const ansi = 16
			+ (36 * Math.round(r / 255 * 5))
			+ (6 * Math.round(g / 255 * 5))
			+ Math.round(b / 255 * 5);

		return ansi;
	};

	convert.ansi16.rgb = function (args) {
		let color = args % 10;

		// Handle greyscale
		if (color === 0 || color === 7) {
			if (args > 50) {
				color += 3.5;
			}

			color = color / 10.5 * 255;

			return [color, color, color];
		}

		const mult = (~~(args > 50) + 1) * 0.5;
		const r = ((color & 1) * mult) * 255;
		const g = (((color >> 1) & 1) * mult) * 255;
		const b = (((color >> 2) & 1) * mult) * 255;

		return [r, g, b];
	};

	convert.ansi256.rgb = function (args) {
		// Handle greyscale
		if (args >= 232) {
			const c = (args - 232) * 10 + 8;
			return [c, c, c];
		}

		args -= 16;

		let rem;
		const r = Math.floor(args / 36) / 5 * 255;
		const g = Math.floor((rem = args % 36) / 6) / 5 * 255;
		const b = (rem % 6) / 5 * 255;

		return [r, g, b];
	};

	convert.rgb.hex = function (args) {
		const integer = ((Math.round(args[0]) & 0xFF) << 16)
			+ ((Math.round(args[1]) & 0xFF) << 8)
			+ (Math.round(args[2]) & 0xFF);

		const string = integer.toString(16).toUpperCase();
		return '000000'.substring(string.length) + string;
	};

	convert.hex.rgb = function (args) {
		const match = args.toString(16).match(/[a-f0-9]{6}|[a-f0-9]{3}/i);
		if (!match) {
			return [0, 0, 0];
		}

		let colorString = match[0];

		if (match[0].length === 3) {
			colorString = colorString.split('').map(char => {
				return char + char;
			}).join('');
		}

		const integer = parseInt(colorString, 16);
		const r = (integer >> 16) & 0xFF;
		const g = (integer >> 8) & 0xFF;
		const b = integer & 0xFF;

		return [r, g, b];
	};

	convert.rgb.hcg = function (rgb) {
		const r = rgb[0] / 255;
		const g = rgb[1] / 255;
		const b = rgb[2] / 255;
		const max = Math.max(Math.max(r, g), b);
		const min = Math.min(Math.min(r, g), b);
		const chroma = (max - min);
		let grayscale;
		let hue;

		if (chroma < 1) {
			grayscale = min / (1 - chroma);
		} else {
			grayscale = 0;
		}

		if (chroma <= 0) {
			hue = 0;
		} else
		if (max === r) {
			hue = ((g - b) / chroma) % 6;
		} else
		if (max === g) {
			hue = 2 + (b - r) / chroma;
		} else {
			hue = 4 + (r - g) / chroma;
		}

		hue /= 6;
		hue %= 1;

		return [hue * 360, chroma * 100, grayscale * 100];
	};

	convert.hsl.hcg = function (hsl) {
		const s = hsl[1] / 100;
		const l = hsl[2] / 100;

		const c = l < 0.5 ? (2.0 * s * l) : (2.0 * s * (1.0 - l));

		let f = 0;
		if (c < 1.0) {
			f = (l - 0.5 * c) / (1.0 - c);
		}

		return [hsl[0], c * 100, f * 100];
	};

	convert.hsv.hcg = function (hsv) {
		const s = hsv[1] / 100;
		const v = hsv[2] / 100;

		const c = s * v;
		let f = 0;

		if (c < 1.0) {
			f = (v - c) / (1 - c);
		}

		return [hsv[0], c * 100, f * 100];
	};

	convert.hcg.rgb = function (hcg) {
		const h = hcg[0] / 360;
		const c = hcg[1] / 100;
		const g = hcg[2] / 100;

		if (c === 0.0) {
			return [g * 255, g * 255, g * 255];
		}

		const pure = [0, 0, 0];
		const hi = (h % 1) * 6;
		const v = hi % 1;
		const w = 1 - v;
		let mg = 0;

		/* eslint-disable max-statements-per-line */
		switch (Math.floor(hi)) {
			case 0:
				pure[0] = 1; pure[1] = v; pure[2] = 0; break;
			case 1:
				pure[0] = w; pure[1] = 1; pure[2] = 0; break;
			case 2:
				pure[0] = 0; pure[1] = 1; pure[2] = v; break;
			case 3:
				pure[0] = 0; pure[1] = w; pure[2] = 1; break;
			case 4:
				pure[0] = v; pure[1] = 0; pure[2] = 1; break;
			default:
				pure[0] = 1; pure[1] = 0; pure[2] = w;
		}
		/* eslint-enable max-statements-per-line */

		mg = (1.0 - c) * g;

		return [
			(c * pure[0] + mg) * 255,
			(c * pure[1] + mg) * 255,
			(c * pure[2] + mg) * 255
		];
	};

	convert.hcg.hsv = function (hcg) {
		const c = hcg[1] / 100;
		const g = hcg[2] / 100;

		const v = c + g * (1.0 - c);
		let f = 0;

		if (v > 0.0) {
			f = c / v;
		}

		return [hcg[0], f * 100, v * 100];
	};

	convert.hcg.hsl = function (hcg) {
		const c = hcg[1] / 100;
		const g = hcg[2] / 100;

		const l = g * (1.0 - c) + 0.5 * c;
		let s = 0;

		if (l > 0.0 && l < 0.5) {
			s = c / (2 * l);
		} else
		if (l >= 0.5 && l < 1.0) {
			s = c / (2 * (1 - l));
		}

		return [hcg[0], s * 100, l * 100];
	};

	convert.hcg.hwb = function (hcg) {
		const c = hcg[1] / 100;
		const g = hcg[2] / 100;
		const v = c + g * (1.0 - c);
		return [hcg[0], (v - c) * 100, (1 - v) * 100];
	};

	convert.hwb.hcg = function (hwb) {
		const w = hwb[1] / 100;
		const b = hwb[2] / 100;
		const v = 1 - b;
		const c = v - w;
		let g = 0;

		if (c < 1) {
			g = (v - c) / (1 - c);
		}

		return [hwb[0], c * 100, g * 100];
	};

	convert.apple.rgb = function (apple) {
		return [(apple[0] / 65535) * 255, (apple[1] / 65535) * 255, (apple[2] / 65535) * 255];
	};

	convert.rgb.apple = function (rgb) {
		return [(rgb[0] / 255) * 65535, (rgb[1] / 255) * 65535, (rgb[2] / 255) * 65535];
	};

	convert.gray.rgb = function (args) {
		return [args[0] / 100 * 255, args[0] / 100 * 255, args[0] / 100 * 255];
	};

	convert.gray.hsl = function (args) {
		return [0, 0, args[0]];
	};

	convert.gray.hsv = convert.gray.hsl;

	convert.gray.hwb = function (gray) {
		return [0, 100, gray[0]];
	};

	convert.gray.cmyk = function (gray) {
		return [0, 0, 0, gray[0]];
	};

	convert.gray.lab = function (gray) {
		return [gray[0], 0, 0];
	};

	convert.gray.hex = function (gray) {
		const val = Math.round(gray[0] / 100 * 255) & 0xFF;
		const integer = (val << 16) + (val << 8) + val;

		const string = integer.toString(16).toUpperCase();
		return '000000'.substring(string.length) + string;
	};

	convert.rgb.gray = function (rgb) {
		const val = (rgb[0] + rgb[1] + rgb[2]) / 3;
		return [val / 255 * 100];
	};
	return conversions;
}

var route;
var hasRequiredRoute;

function requireRoute () {
	if (hasRequiredRoute) return route;
	hasRequiredRoute = 1;
	const conversions = requireConversions();

	/*
		This function routes a model to all other models.

		all functions that are routed have a property `.conversion` attached
		to the returned synthetic function. This property is an array
		of strings, each with the steps in between the 'from' and 'to'
		color models (inclusive).

		conversions that are not possible simply are not included.
	*/

	function buildGraph() {
		const graph = {};
		// https://jsperf.com/object-keys-vs-for-in-with-closure/3
		const models = Object.keys(conversions);

		for (let len = models.length, i = 0; i < len; i++) {
			graph[models[i]] = {
				// http://jsperf.com/1-vs-infinity
				// micro-opt, but this is simple.
				distance: -1,
				parent: null
			};
		}

		return graph;
	}

	// https://en.wikipedia.org/wiki/Breadth-first_search
	function deriveBFS(fromModel) {
		const graph = buildGraph();
		const queue = [fromModel]; // Unshift -> queue -> pop

		graph[fromModel].distance = 0;

		while (queue.length) {
			const current = queue.pop();
			const adjacents = Object.keys(conversions[current]);

			for (let len = adjacents.length, i = 0; i < len; i++) {
				const adjacent = adjacents[i];
				const node = graph[adjacent];

				if (node.distance === -1) {
					node.distance = graph[current].distance + 1;
					node.parent = current;
					queue.unshift(adjacent);
				}
			}
		}

		return graph;
	}

	function link(from, to) {
		return function (args) {
			return to(from(args));
		};
	}

	function wrapConversion(toModel, graph) {
		const path = [graph[toModel].parent, toModel];
		let fn = conversions[graph[toModel].parent][toModel];

		let cur = graph[toModel].parent;
		while (graph[cur].parent) {
			path.unshift(graph[cur].parent);
			fn = link(conversions[graph[cur].parent][cur], fn);
			cur = graph[cur].parent;
		}

		fn.conversion = path;
		return fn;
	}

	route = function (fromModel) {
		const graph = deriveBFS(fromModel);
		const conversion = {};

		const models = Object.keys(graph);
		for (let len = models.length, i = 0; i < len; i++) {
			const toModel = models[i];
			const node = graph[toModel];

			if (node.parent === null) {
				// No possible conversion, or this node is the source model.
				continue;
			}

			conversion[toModel] = wrapConversion(toModel, graph);
		}

		return conversion;
	};
	return route;
}

var colorConvert;
var hasRequiredColorConvert;

function requireColorConvert () {
	if (hasRequiredColorConvert) return colorConvert;
	hasRequiredColorConvert = 1;
	const conversions = requireConversions();
	const route = requireRoute();

	const convert = {};

	const models = Object.keys(conversions);

	function wrapRaw(fn) {
		const wrappedFn = function (...args) {
			const arg0 = args[0];
			if (arg0 === undefined || arg0 === null) {
				return arg0;
			}

			if (arg0.length > 1) {
				args = arg0;
			}

			return fn(args);
		};

		// Preserve .conversion property if there is one
		if ('conversion' in fn) {
			wrappedFn.conversion = fn.conversion;
		}

		return wrappedFn;
	}

	function wrapRounded(fn) {
		const wrappedFn = function (...args) {
			const arg0 = args[0];

			if (arg0 === undefined || arg0 === null) {
				return arg0;
			}

			if (arg0.length > 1) {
				args = arg0;
			}

			const result = fn(args);

			// We're assuming the result is an array here.
			// see notice in conversions.js; don't use box types
			// in conversion functions.
			if (typeof result === 'object') {
				for (let len = result.length, i = 0; i < len; i++) {
					result[i] = Math.round(result[i]);
				}
			}

			return result;
		};

		// Preserve .conversion property if there is one
		if ('conversion' in fn) {
			wrappedFn.conversion = fn.conversion;
		}

		return wrappedFn;
	}

	models.forEach(fromModel => {
		convert[fromModel] = {};

		Object.defineProperty(convert[fromModel], 'channels', {value: conversions[fromModel].channels});
		Object.defineProperty(convert[fromModel], 'labels', {value: conversions[fromModel].labels});

		const routes = route(fromModel);
		const routeModels = Object.keys(routes);

		routeModels.forEach(toModel => {
			const fn = routes[toModel];

			convert[fromModel][toModel] = wrapRounded(fn);
			convert[fromModel][toModel].raw = wrapRaw(fn);
		});
	});

	colorConvert = convert;
	return colorConvert;
}

var hash = {};

var hasRequiredHash;

function requireHash () {
	if (hasRequiredHash) return hash;
	hasRequiredHash = 1;
	// Copyright (C) 2023 The Android Open Source Project
	//
	// Licensed under the Apache License, Version 2.0 (the "License");
	// you may not use this file except in compliance with the License.
	// You may obtain a copy of the License at
	//
	//      http://www.apache.org/licenses/LICENSE-2.0
	//
	// Unless required by applicable law or agreed to in writing, software
	// distributed under the License is distributed on an "AS IS" BASIS,
	// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	// See the License for the specific language governing permissions and
	// limitations under the License.
	Object.defineProperty(hash, "__esModule", { value: true });
	hash.hash = void 0;
	function hash$1(s, max) {
	    let hash = 0x811c9dc5 & 0xfffffff;
	    for (let i = 0; i < s.length; i++) {
	        hash ^= s.charCodeAt(i);
	        hash = (hash * 16777619) & 0xffffffff;
	    }
	    return Math.abs(hash) % max;
	}
	hash.hash = hash$1;
	
	return hash;
}

var hsluv_cache = {};

var hsluv_1;
var hasRequiredHsluv;

function requireHsluv () {
	if (hasRequiredHsluv) return hsluv_1;
	hasRequiredHsluv = 1;
	// Generated by Haxe 3.4.4
	var hsluv = hsluv || {};
	hsluv.Geometry = function() { };
	hsluv.Geometry.intersectLineLine = function(a,b) {
		var x = (a.intercept - b.intercept) / (b.slope - a.slope);
		var y = a.slope * x + a.intercept;
		return { x : x, y : y};
	};
	hsluv.Geometry.distanceFromOrigin = function(point) {
		return Math.sqrt(Math.pow(point.x,2) + Math.pow(point.y,2));
	};
	hsluv.Geometry.distanceLineFromOrigin = function(line) {
		return Math.abs(line.intercept) / Math.sqrt(Math.pow(line.slope,2) + 1);
	};
	hsluv.Geometry.perpendicularThroughPoint = function(line,point) {
		var slope = -1 / line.slope;
		var intercept = point.y - slope * point.x;
		return { slope : slope, intercept : intercept};
	};
	hsluv.Geometry.angleFromOrigin = function(point) {
		return Math.atan2(point.y,point.x);
	};
	hsluv.Geometry.normalizeAngle = function(angle) {
		var m = 2 * Math.PI;
		return (angle % m + m) % m;
	};
	hsluv.Geometry.lengthOfRayUntilIntersect = function(theta,line) {
		return line.intercept / (Math.sin(theta) - line.slope * Math.cos(theta));
	};
	hsluv.Hsluv = function() { };
	hsluv.Hsluv.getBounds = function(L) {
		var result = [];
		var sub1 = Math.pow(L + 16,3) / 1560896;
		var sub2 = sub1 > hsluv.Hsluv.epsilon ? sub1 : L / hsluv.Hsluv.kappa;
		var _g = 0;
		while(_g < 3) {
			var c = _g++;
			var m1 = hsluv.Hsluv.m[c][0];
			var m2 = hsluv.Hsluv.m[c][1];
			var m3 = hsluv.Hsluv.m[c][2];
			var _g1 = 0;
			while(_g1 < 2) {
				var t = _g1++;
				var top1 = (284517 * m1 - 94839 * m3) * sub2;
				var top2 = (838422 * m3 + 769860 * m2 + 731718 * m1) * L * sub2 - 769860 * t * L;
				var bottom = (632260 * m3 - 126452 * m2) * sub2 + 126452 * t;
				result.push({ slope : top1 / bottom, intercept : top2 / bottom});
			}
		}
		return result;
	};
	hsluv.Hsluv.maxSafeChromaForL = function(L) {
		var bounds = hsluv.Hsluv.getBounds(L);
		var min = Infinity;
		var _g = 0;
		while(_g < bounds.length) {
			var bound = bounds[_g];
			++_g;
			var length = hsluv.Geometry.distanceLineFromOrigin(bound);
			min = Math.min(min,length);
		}
		return min;
	};
	hsluv.Hsluv.maxChromaForLH = function(L,H) {
		var hrad = H / 360 * Math.PI * 2;
		var bounds = hsluv.Hsluv.getBounds(L);
		var min = Infinity;
		var _g = 0;
		while(_g < bounds.length) {
			var bound = bounds[_g];
			++_g;
			var length = hsluv.Geometry.lengthOfRayUntilIntersect(hrad,bound);
			if(length >= 0) {
				min = Math.min(min,length);
			}
		}
		return min;
	};
	hsluv.Hsluv.dotProduct = function(a,b) {
		var sum = 0;
		var _g1 = 0;
		var _g = a.length;
		while(_g1 < _g) {
			var i = _g1++;
			sum += a[i] * b[i];
		}
		return sum;
	};
	hsluv.Hsluv.fromLinear = function(c) {
		if(c <= 0.0031308) {
			return 12.92 * c;
		} else {
			return 1.055 * Math.pow(c,0.416666666666666685) - 0.055;
		}
	};
	hsluv.Hsluv.toLinear = function(c) {
		if(c > 0.04045) {
			return Math.pow((c + 0.055) / 1.055,2.4);
		} else {
			return c / 12.92;
		}
	};
	hsluv.Hsluv.xyzToRgb = function(tuple) {
		return [hsluv.Hsluv.fromLinear(hsluv.Hsluv.dotProduct(hsluv.Hsluv.m[0],tuple)),hsluv.Hsluv.fromLinear(hsluv.Hsluv.dotProduct(hsluv.Hsluv.m[1],tuple)),hsluv.Hsluv.fromLinear(hsluv.Hsluv.dotProduct(hsluv.Hsluv.m[2],tuple))];
	};
	hsluv.Hsluv.rgbToXyz = function(tuple) {
		var rgbl = [hsluv.Hsluv.toLinear(tuple[0]),hsluv.Hsluv.toLinear(tuple[1]),hsluv.Hsluv.toLinear(tuple[2])];
		return [hsluv.Hsluv.dotProduct(hsluv.Hsluv.minv[0],rgbl),hsluv.Hsluv.dotProduct(hsluv.Hsluv.minv[1],rgbl),hsluv.Hsluv.dotProduct(hsluv.Hsluv.minv[2],rgbl)];
	};
	hsluv.Hsluv.yToL = function(Y) {
		if(Y <= hsluv.Hsluv.epsilon) {
			return Y / hsluv.Hsluv.refY * hsluv.Hsluv.kappa;
		} else {
			return 116 * Math.pow(Y / hsluv.Hsluv.refY,0.333333333333333315) - 16;
		}
	};
	hsluv.Hsluv.lToY = function(L) {
		if(L <= 8) {
			return hsluv.Hsluv.refY * L / hsluv.Hsluv.kappa;
		} else {
			return hsluv.Hsluv.refY * Math.pow((L + 16) / 116,3);
		}
	};
	hsluv.Hsluv.xyzToLuv = function(tuple) {
		var X = tuple[0];
		var Y = tuple[1];
		var Z = tuple[2];
		var divider = X + 15 * Y + 3 * Z;
		var varU = 4 * X;
		var varV = 9 * Y;
		if(divider != 0) {
			varU /= divider;
			varV /= divider;
		} else {
			varU = NaN;
			varV = NaN;
		}
		var L = hsluv.Hsluv.yToL(Y);
		if(L == 0) {
			return [0,0,0];
		}
		var U = 13 * L * (varU - hsluv.Hsluv.refU);
		var V = 13 * L * (varV - hsluv.Hsluv.refV);
		return [L,U,V];
	};
	hsluv.Hsluv.luvToXyz = function(tuple) {
		var L = tuple[0];
		var U = tuple[1];
		var V = tuple[2];
		if(L == 0) {
			return [0,0,0];
		}
		var varU = U / (13 * L) + hsluv.Hsluv.refU;
		var varV = V / (13 * L) + hsluv.Hsluv.refV;
		var Y = hsluv.Hsluv.lToY(L);
		var X = 0 - 9 * Y * varU / ((varU - 4) * varV - varU * varV);
		var Z = (9 * Y - 15 * varV * Y - varV * X) / (3 * varV);
		return [X,Y,Z];
	};
	hsluv.Hsluv.luvToLch = function(tuple) {
		var L = tuple[0];
		var U = tuple[1];
		var V = tuple[2];
		var C = Math.sqrt(U * U + V * V);
		var H;
		if(C < 0.00000001) {
			H = 0;
		} else {
			var Hrad = Math.atan2(V,U);
			H = Hrad * 180.0 / Math.PI;
			if(H < 0) {
				H = 360 + H;
			}
		}
		return [L,C,H];
	};
	hsluv.Hsluv.lchToLuv = function(tuple) {
		var L = tuple[0];
		var C = tuple[1];
		var H = tuple[2];
		var Hrad = H / 360.0 * 2 * Math.PI;
		var U = Math.cos(Hrad) * C;
		var V = Math.sin(Hrad) * C;
		return [L,U,V];
	};
	hsluv.Hsluv.hsluvToLch = function(tuple) {
		var H = tuple[0];
		var S = tuple[1];
		var L = tuple[2];
		if(L > 99.9999999) {
			return [100,0,H];
		}
		if(L < 0.00000001) {
			return [0,0,H];
		}
		var max = hsluv.Hsluv.maxChromaForLH(L,H);
		var C = max / 100 * S;
		return [L,C,H];
	};
	hsluv.Hsluv.lchToHsluv = function(tuple) {
		var L = tuple[0];
		var C = tuple[1];
		var H = tuple[2];
		if(L > 99.9999999) {
			return [H,0,100];
		}
		if(L < 0.00000001) {
			return [H,0,0];
		}
		var max = hsluv.Hsluv.maxChromaForLH(L,H);
		var S = C / max * 100;
		return [H,S,L];
	};
	hsluv.Hsluv.hpluvToLch = function(tuple) {
		var H = tuple[0];
		var S = tuple[1];
		var L = tuple[2];
		if(L > 99.9999999) {
			return [100,0,H];
		}
		if(L < 0.00000001) {
			return [0,0,H];
		}
		var max = hsluv.Hsluv.maxSafeChromaForL(L);
		var C = max / 100 * S;
		return [L,C,H];
	};
	hsluv.Hsluv.lchToHpluv = function(tuple) {
		var L = tuple[0];
		var C = tuple[1];
		var H = tuple[2];
		if(L > 99.9999999) {
			return [H,0,100];
		}
		if(L < 0.00000001) {
			return [H,0,0];
		}
		var max = hsluv.Hsluv.maxSafeChromaForL(L);
		var S = C / max * 100;
		return [H,S,L];
	};
	hsluv.Hsluv.rgbToHex = function(tuple) {
		var h = "#";
		var _g = 0;
		while(_g < 3) {
			var i = _g++;
			var chan = tuple[i];
			var c = Math.round(chan * 255);
			var digit2 = c % 16;
			var digit1 = (c - digit2) / 16 | 0;
			h += hsluv.Hsluv.hexChars.charAt(digit1) + hsluv.Hsluv.hexChars.charAt(digit2);
		}
		return h;
	};
	hsluv.Hsluv.hexToRgb = function(hex) {
		hex = hex.toLowerCase();
		var ret = [];
		var _g = 0;
		while(_g < 3) {
			var i = _g++;
			var digit1 = hsluv.Hsluv.hexChars.indexOf(hex.charAt(i * 2 + 1));
			var digit2 = hsluv.Hsluv.hexChars.indexOf(hex.charAt(i * 2 + 2));
			var n = digit1 * 16 + digit2;
			ret.push(n / 255.0);
		}
		return ret;
	};
	hsluv.Hsluv.lchToRgb = function(tuple) {
		return hsluv.Hsluv.xyzToRgb(hsluv.Hsluv.luvToXyz(hsluv.Hsluv.lchToLuv(tuple)));
	};
	hsluv.Hsluv.rgbToLch = function(tuple) {
		return hsluv.Hsluv.luvToLch(hsluv.Hsluv.xyzToLuv(hsluv.Hsluv.rgbToXyz(tuple)));
	};
	hsluv.Hsluv.hsluvToRgb = function(tuple) {
		return hsluv.Hsluv.lchToRgb(hsluv.Hsluv.hsluvToLch(tuple));
	};
	hsluv.Hsluv.rgbToHsluv = function(tuple) {
		return hsluv.Hsluv.lchToHsluv(hsluv.Hsluv.rgbToLch(tuple));
	};
	hsluv.Hsluv.hpluvToRgb = function(tuple) {
		return hsluv.Hsluv.lchToRgb(hsluv.Hsluv.hpluvToLch(tuple));
	};
	hsluv.Hsluv.rgbToHpluv = function(tuple) {
		return hsluv.Hsluv.lchToHpluv(hsluv.Hsluv.rgbToLch(tuple));
	};
	hsluv.Hsluv.hsluvToHex = function(tuple) {
		return hsluv.Hsluv.rgbToHex(hsluv.Hsluv.hsluvToRgb(tuple));
	};
	hsluv.Hsluv.hpluvToHex = function(tuple) {
		return hsluv.Hsluv.rgbToHex(hsluv.Hsluv.hpluvToRgb(tuple));
	};
	hsluv.Hsluv.hexToHsluv = function(s) {
		return hsluv.Hsluv.rgbToHsluv(hsluv.Hsluv.hexToRgb(s));
	};
	hsluv.Hsluv.hexToHpluv = function(s) {
		return hsluv.Hsluv.rgbToHpluv(hsluv.Hsluv.hexToRgb(s));
	};
	hsluv.Hsluv.m = [[3.240969941904521,-1.537383177570093,-0.498610760293],[-0.96924363628087,1.87596750150772,0.041555057407175],[0.055630079696993,-0.20397695888897,1.056971514242878]];
	hsluv.Hsluv.minv = [[0.41239079926595,0.35758433938387,0.18048078840183],[0.21263900587151,0.71516867876775,0.072192315360733],[0.019330818715591,0.11919477979462,0.95053215224966]];
	hsluv.Hsluv.refY = 1.0;
	hsluv.Hsluv.refU = 0.19783000664283;
	hsluv.Hsluv.refV = 0.46831999493879;
	hsluv.Hsluv.kappa = 903.2962962;
	hsluv.Hsluv.epsilon = 0.0088564516;
	hsluv.Hsluv.hexChars = "0123456789abcdef";
	var root = {
	    "hsluvToRgb": hsluv.Hsluv.hsluvToRgb,
	    "rgbToHsluv": hsluv.Hsluv.rgbToHsluv,
	    "hpluvToRgb": hsluv.Hsluv.hpluvToRgb,
	    "rgbToHpluv": hsluv.Hsluv.rgbToHpluv,
	    "hsluvToHex": hsluv.Hsluv.hsluvToHex,
	    "hexToHsluv": hsluv.Hsluv.hexToHsluv,
	    "hpluvToHex": hsluv.Hsluv.hpluvToHex,
	    "hexToHpluv": hsluv.Hsluv.hexToHpluv,
	    "lchToHpluv": hsluv.Hsluv.lchToHpluv,
	    "hpluvToLch": hsluv.Hsluv.hpluvToLch,
	    "lchToHsluv": hsluv.Hsluv.lchToHsluv,
	    "hsluvToLch": hsluv.Hsluv.hsluvToLch,
	    "lchToLuv": hsluv.Hsluv.lchToLuv,
	    "luvToLch": hsluv.Hsluv.luvToLch,
	    "xyzToLuv": hsluv.Hsluv.xyzToLuv,
	    "luvToXyz": hsluv.Hsluv.luvToXyz,
	    "xyzToRgb": hsluv.Hsluv.xyzToRgb,
	    "rgbToXyz": hsluv.Hsluv.rgbToXyz,
	    "lchToRgb": hsluv.Hsluv.lchToRgb,
	    "rgbToLch": hsluv.Hsluv.rgbToLch
	};

	hsluv_1 = root;
	return hsluv_1;
}

var hasRequiredHsluv_cache;

function requireHsluv_cache () {
	if (hasRequiredHsluv_cache) return hsluv_cache;
	hasRequiredHsluv_cache = 1;
	// Copyright (C) 2022 The Android Open Source Project
	//
	// Licensed under the Apache License, Version 2.0 (the "License");
	// you may not use this file except in compliance with the License.
	// You may obtain a copy of the License at
	//
	//      http://www.apache.org/licenses/LICENSE-2.0
	//
	// Unless required by applicable law or agreed to in writing, software
	// distributed under the License is distributed on an "AS IS" BASIS,
	// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	// See the License for the specific language governing permissions and
	// limitations under the License.
	Object.defineProperty(hsluv_cache, "__esModule", { value: true });
	hsluv_cache.cachedHsluvToHex = void 0;
	const hsluv_1 = requireHsluv();
	class HsluvCache {
	    constructor() {
	        this.storage = new Map();
	    }
	    get(hue, saturation, lightness) {
	        const key = hue * 1e6 + saturation * 1e3 + lightness;
	        const value = this.storage.get(key);
	        if (value === undefined) {
	            const computed = (0, hsluv_1.hsluvToHex)([hue, saturation, lightness]);
	            this.storage.set(key, computed);
	            return computed;
	        }
	        return value;
	    }
	}
	const cache = new HsluvCache();
	function cachedHsluvToHex(hue, saturation, lightness) {
	    return cache.get(hue, saturation, lightness);
	}
	hsluv_cache.cachedHsluvToHex = cachedHsluvToHex;
	
	return hsluv_cache;
}

var hasRequiredColorizer;

function requireColorizer () {
	if (hasRequiredColorizer) return colorizer;
	hasRequiredColorizer = 1;
	(function (exports) {
		// Copyright (C) 2019 The Android Open Source Project
		//
		// Licensed under the Apache License, Version 2.0 (the "License");
		// you may not use this file except in compliance with the License.
		// You may obtain a copy of the License at
		//
		//      http://www.apache.org/licenses/LICENSE-2.0
		//
		// Unless required by applicable law or agreed to in writing, software
		// distributed under the License is distributed on an "AS IS" BASIS,
		// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
		// See the License for the specific language governing permissions and
		// limitations under the License.
		Object.defineProperty(exports, "__esModule", { value: true });
		exports.colorCompare = exports.colorToStr = exports.colorForThreadIdleSlice = exports.hslForSlice = exports.randomColor = exports.colorForThread = exports.colorForTid = exports.colorForString = exports.textColorForState = exports.colorForState = exports.hueForCpu = exports.UNEXPECTED_PINK_COLOR = exports.GRAY_COLOR = void 0;
		const color_convert_1 = requireColorConvert();
		const hash_1 = requireHash();
		const hsluv_cache_1 = requireHsluv_cache();
		const MD_PALETTE = [
		    { c: 'red', h: 4, s: 90, l: 58 },
		    { c: 'pink', h: 340, s: 82, l: 52 },
		    { c: 'purple', h: 291, s: 64, l: 42 },
		    { c: 'deep purple', h: 262, s: 52, l: 47 },
		    { c: 'indigo', h: 231, s: 48, l: 48 },
		    { c: 'blue', h: 207, s: 90, l: 54 },
		    { c: 'light blue', h: 199, s: 98, l: 48 },
		    { c: 'cyan', h: 187, s: 100, l: 42 },
		    { c: 'teal', h: 174, s: 100, l: 29 },
		    { c: 'green', h: 122, s: 39, l: 49 },
		    { c: 'light green', h: 88, s: 50, l: 53 },
		    { c: 'lime', h: 66, s: 70, l: 54 },
		    { c: 'amber', h: 45, s: 100, l: 51 },
		    { c: 'orange', h: 36, s: 100, l: 50 },
		    { c: 'deep orange', h: 14, s: 100, l: 57 },
		    { c: 'brown', h: 16, s: 25, l: 38 },
		    { c: 'blue gray', h: 200, s: 18, l: 46 },
		    { c: 'yellow', h: 54, s: 100, l: 62 },
		];
		exports.GRAY_COLOR = {
		    c: 'grey',
		    h: 0,
		    s: 0,
		    l: 62,
		};
		// A piece of wisdom from a long forgotten blog post: "Don't make
		// colors you want to change something normal like grey."
		exports.UNEXPECTED_PINK_COLOR = {
		    c: '#ff69b4',
		    h: 330,
		    s: 1.0,
		    l: 0.706,
		};
		function hueForCpu(cpu) {
		    return (128 + (32 * cpu)) % 256;
		}
		exports.hueForCpu = hueForCpu;
		const DESAT_RED = {
		    c: 'desat red',
		    h: 3,
		    s: 30,
		    l: 49,
		};
		const DARK_GREEN = {
		    c: 'dark green',
		    h: 120,
		    s: 44,
		    l: 34,
		};
		const LIME_GREEN = {
		    c: 'lime green',
		    h: 75,
		    s: 55,
		    l: 47,
		};
		const TRANSPARENT_WHITE = {
		    c: 'white',
		    h: 0,
		    s: 1,
		    l: 97,
		    a: 0.55,
		};
		const ORANGE = {
		    c: 'orange',
		    h: 36,
		    s: 100,
		    l: 50,
		};
		const INDIGO = {
		    c: 'indigo',
		    h: 231,
		    s: 48,
		    l: 48,
		};
		function colorForState(state) {
		    if (state === 'Running') {
		        return DARK_GREEN;
		    }
		    else if (state.startsWith('Runnable')) {
		        return LIME_GREEN;
		    }
		    else if (state.includes('Uninterruptible Sleep')) {
		        if (state.includes('non-IO')) {
		            return DESAT_RED;
		        }
		        return ORANGE;
		    }
		    else if (state.includes('Sleeping') || state.includes('Idle')) {
		        return TRANSPARENT_WHITE;
		    }
		    return INDIGO;
		}
		exports.colorForState = colorForState;
		function textColorForState(stateCode) {
		    const background = colorForState(stateCode);
		    return background.l > 80 ? '#404040' : '#fff';
		}
		exports.textColorForState = textColorForState;
		function colorForString(identifier) {
		    const colorIdx = (0, hash_1.hash)(identifier, MD_PALETTE.length);
		    return Object.assign({}, MD_PALETTE[colorIdx]);
		}
		exports.colorForString = colorForString;
		function colorForTid(tid) {
		    return colorForString(tid.toString());
		}
		exports.colorForTid = colorForTid;
		function colorForThread(thread) {
		    if (thread === undefined) {
		        return Object.assign({}, exports.GRAY_COLOR);
		    }
		    const tid = thread.pid ? thread.pid : thread.tid;
		    return colorForTid(tid);
		}
		exports.colorForThread = colorForThread;
		// 40 different random hues 9 degrees apart.
		function randomColor() {
		    const hue = Math.floor(Math.random() * 40) * 9;
		    return '#' + color_convert_1.hsl.hex([hue, 90, 30]);
		}
		exports.randomColor = randomColor;
		// Chooses a color uniform at random based on hash(sliceName).  Returns [hue,
		// saturation, lightness].
		//
		// Prefer converting this to an RGB color using hsluv, not the browser's
		// built-in vanilla HSL handling.  This is because this function chooses
		// hue/lightness uniform at random, but HSL is not perceptually uniform.  See
		// https://www.boronine.com/2012/03/26/Color-Spaces-for-Human-Beings/.
		//
		// If isSelected, the color will be particularly dark, making it stand out.
		function hslForSlice(sliceName, isSelected) {
		    const hue = (0, hash_1.hash)(sliceName, 360);
		    // Saturation 100 would give the most differentiation between colors, but it's
		    // garish.
		    const saturation = 80;
		    const lightness = isSelected ? 30 : (0, hash_1.hash)(sliceName + 'x', 40) + 40;
		    return [hue, saturation, lightness];
		}
		exports.hslForSlice = hslForSlice;
		// Lightens the color for thread slices to represent wall time.
		function colorForThreadIdleSlice(hue, saturation, lightness, isSelected) {
		    // Increase lightness by 80% when selected and 40% otherwise,
		    // without exceeding 88.
		    let newLightness = isSelected ? lightness * 1.8 : lightness * 1.4;
		    newLightness = Math.min(newLightness, 88);
		    return (0, hsluv_cache_1.cachedHsluvToHex)(hue, saturation, newLightness);
		}
		exports.colorForThreadIdleSlice = colorForThreadIdleSlice;
		function colorToStr(color) {
		    if (color.a !== undefined) {
		        return `hsla(${color.h}, ${color.s}%, ${color.l}%, ${color.a})`;
		    }
		    return `hsl(${color.h}, ${color.s}%, ${color.l}%)`;
		}
		exports.colorToStr = colorToStr;
		function colorCompare(x, y) {
		    return (x.h - y.h) || (x.s - y.s) || (x.l - y.l);
		}
		exports.colorCompare = colorCompare;
		
} (colorizer));
	return colorizer;
}

var dragndrop_logic = {};

var hasRequiredDragndrop_logic;

function requireDragndrop_logic () {
	if (hasRequiredDragndrop_logic) return dragndrop_logic;
	hasRequiredDragndrop_logic = 1;
	// Copyright (C) 2022 The Android Open Source Project
	//
	// Licensed under the Apache License, Version 2.0 (the "License");
	// you may not use this file except in compliance with the License.
	// You may obtain a copy of the License at
	//
	//      http://www.apache.org/licenses/LICENSE-2.0
	//
	// Unless required by applicable law or agreed to in writing, software
	// distributed under the License is distributed on an "AS IS" BASIS,
	// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	// See the License for the specific language governing permissions and
	// limitations under the License.
	Object.defineProperty(dragndrop_logic, "__esModule", { value: true });
	dragndrop_logic.performReordering = dragndrop_logic.computeIntervals = void 0;
	const logging_1 = requireLogging();
	/*
	 * When a drag'n'drop is performed in a linear sequence, the resulting reordered
	 * array will consist of several contiguous subarrays of the original glued
	 * together.
	 *
	 * This function implements the computation of these intervals.
	 *
	 * The drag'n'drop operation performed is as follows: in the sequence with given
	 * length, the element with index `dragFrom` is dropped on the `direction` to
	 * the element `dragTo`.
	 */
	function computeIntervals(length, dragFrom, dragTo, direction) {
	    (0, logging_1.assertTrue)(dragFrom !== dragTo);
	    if (dragTo < dragFrom) {
	        const prefixLen = direction == 'left' ? dragTo : dragTo + 1;
	        return [
	            // First goes unchanged prefix.
	            { from: 0, to: prefixLen },
	            // Then goes dragged element.
	            { from: dragFrom, to: dragFrom + 1 },
	            // Then goes suffix up to dragged element (which has already been moved).
	            { from: prefixLen, to: dragFrom },
	            // Then the rest of an array.
	            { from: dragFrom + 1, to: length },
	        ];
	    }
	    // Other case: dragTo > dragFrom
	    const prefixLen = direction == 'left' ? dragTo : dragTo + 1;
	    return [
	        { from: 0, to: dragFrom },
	        { from: dragFrom + 1, to: prefixLen },
	        { from: dragFrom, to: dragFrom + 1 },
	        { from: prefixLen, to: length },
	    ];
	}
	dragndrop_logic.computeIntervals = computeIntervals;
	function performReordering(intervals, arr) {
	    const result = [];
	    for (const interval of intervals) {
	        result.push(...arr.slice(interval.from, interval.to));
	    }
	    return result;
	}
	dragndrop_logic.performReordering = performReordering;
	
	return dragndrop_logic;
}

var flamegraph_util = {};

var hasRequiredFlamegraph_util;

function requireFlamegraph_util () {
	if (hasRequiredFlamegraph_util) return flamegraph_util;
	hasRequiredFlamegraph_util = 1;
	(function (exports) {
		// Copyright (C) 2019 The Android Open Source Project
		//
		// Licensed under the Apache License, Version 2.0 (the "License");
		// you may not use this file except in compliance with the License.
		// You may obtain a copy of the License at
		//
		//      http://www.apache.org/licenses/LICENSE-2.0
		//
		// Unless required by applicable law or agreed to in writing, software
		// distributed under the License is distributed on an "AS IS" BASIS,
		// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
		// See the License for the specific language governing permissions and
		// limitations under the License.
		Object.defineProperty(exports, "__esModule", { value: true });
		exports.findRootSize = exports.mergeCallsites = exports.expandCallsites = exports.DEFAULT_VIEWING_OPTION = exports.PERF_SAMPLES_KEY = exports.OBJECTS_ALLOCATED_KEY = exports.OBJECTS_ALLOCATED_NOT_FREED_KEY = exports.ALLOC_SPACE_MEMORY_ALLOCATED_KEY = exports.SPACE_MEMORY_ALLOCATED_NOT_FREED_KEY = void 0;
		exports.SPACE_MEMORY_ALLOCATED_NOT_FREED_KEY = 'SPACE';
		exports.ALLOC_SPACE_MEMORY_ALLOCATED_KEY = 'ALLOC_SPACE';
		exports.OBJECTS_ALLOCATED_NOT_FREED_KEY = 'OBJECTS';
		exports.OBJECTS_ALLOCATED_KEY = 'ALLOC_OBJECTS';
		exports.PERF_SAMPLES_KEY = 'PERF_SAMPLES';
		exports.DEFAULT_VIEWING_OPTION = exports.SPACE_MEMORY_ALLOCATED_NOT_FREED_KEY;
		function expandCallsites(data, clickedCallsiteIndex) {
		    if (clickedCallsiteIndex === -1)
		        return data;
		    const expandedCallsites = [];
		    if (clickedCallsiteIndex >= data.length || clickedCallsiteIndex < -1) {
		        return expandedCallsites;
		    }
		    const clickedCallsite = data[clickedCallsiteIndex];
		    expandedCallsites.unshift(clickedCallsite);
		    // Adding parents
		    let parentId = clickedCallsite.parentId;
		    while (parentId > -1) {
		        expandedCallsites.unshift(data[parentId]);
		        parentId = data[parentId].parentId;
		    }
		    // Adding children
		    const parents = [];
		    parents.push(clickedCallsiteIndex);
		    for (let i = clickedCallsiteIndex + 1; i < data.length; i++) {
		        const element = data[i];
		        if (parents.includes(element.parentId)) {
		            expandedCallsites.push(element);
		            parents.push(element.id);
		        }
		    }
		    return expandedCallsites;
		}
		exports.expandCallsites = expandCallsites;
		// Merge callsites that have approximately width less than
		// MIN_PIXEL_DISPLAYED. All small callsites in the same depth and with same
		// parent will be merged to one with total size of all merged callsites.
		function mergeCallsites(data, minSizeDisplayed) {
		    const mergedData = [];
		    const mergedCallsites = new Map();
		    for (let i = 0; i < data.length; i++) {
		        // When a small callsite is found, it will be merged with other small
		        // callsites of the same depth. So if the current callsite has already been
		        // merged we can skip it.
		        if (mergedCallsites.has(data[i].id)) {
		            continue;
		        }
		        const copiedCallsite = copyCallsite(data[i]);
		        copiedCallsite.parentId =
		            getCallsitesParentHash(copiedCallsite, mergedCallsites);
		        let mergedAny = false;
		        // If current callsite is small, find other small callsites with same depth
		        // and parent and merge them into the current one, marking them as merged.
		        if (copiedCallsite.totalSize <= minSizeDisplayed && i + 1 < data.length) {
		            let j = i + 1;
		            let nextCallsite = data[j];
		            while (j < data.length && copiedCallsite.depth === nextCallsite.depth) {
		                if (copiedCallsite.parentId ===
		                    getCallsitesParentHash(nextCallsite, mergedCallsites) &&
		                    nextCallsite.totalSize <= minSizeDisplayed) {
		                    copiedCallsite.totalSize += nextCallsite.totalSize;
		                    mergedCallsites.set(nextCallsite.id, copiedCallsite.id);
		                    mergedAny = true;
		                }
		                j++;
		                nextCallsite = data[j];
		            }
		            if (mergedAny) {
		                copiedCallsite.name = '[merged]';
		                copiedCallsite.merged = true;
		            }
		        }
		        mergedData.push(copiedCallsite);
		    }
		    return mergedData;
		}
		exports.mergeCallsites = mergeCallsites;
		function copyCallsite(callsite) {
		    return {
		        id: callsite.id,
		        parentId: callsite.parentId,
		        depth: callsite.depth,
		        name: callsite.name,
		        totalSize: callsite.totalSize,
		        mapping: callsite.mapping,
		        selfSize: callsite.selfSize,
		        merged: callsite.merged,
		        highlighted: callsite.highlighted,
		        location: callsite.location,
		    };
		}
		function getCallsitesParentHash(callsite, map) {
		    return map.has(callsite.parentId) ? +map.get(callsite.parentId) :
		        callsite.parentId;
		}
		function findRootSize(data) {
		    let totalSize = 0;
		    let i = 0;
		    while (i < data.length && data[i].depth === 0) {
		        totalSize += data[i].totalSize;
		        i++;
		    }
		    return totalSize;
		}
		exports.findRootSize = findRootSize;
		
} (flamegraph_util));
	return flamegraph_util;
}

var metatracing = {};

var protos$1 = {};

/*eslint-disable block-scoped-var, id-length, no-control-regex, no-magic-numbers, no-prototype-builtins, no-redeclare, no-shadow, no-var, sort-vars*/

var protos;
var hasRequiredProtos$1;

function requireProtos$1 () {
	if (hasRequiredProtos$1) return protos;
	hasRequiredProtos$1 = 1;

	var $protobuf = requireMinimal();

	// Common aliases
	var $Reader = $protobuf.Reader, $Writer = $protobuf.Writer, $util = $protobuf.util;

	// Exported root namespace
	var $root = $protobuf.roots["default"] || ($protobuf.roots["default"] = {});

	$root.perfetto = (function() {

	    /**
	     * Namespace perfetto.
	     * @exports perfetto
	     * @namespace
	     */
	    var perfetto = {};

	    perfetto.protos = (function() {

	        /**
	         * Namespace protos.
	         * @memberof perfetto
	         * @namespace
	         */
	        var protos = {};

	        protos.TraceStats = (function() {

	            /**
	             * Properties of a TraceStats.
	             * @memberof perfetto.protos
	             * @interface ITraceStats
	             * @property {Array.<perfetto.protos.TraceStats.IBufferStats>|null} [bufferStats] TraceStats bufferStats
	             * @property {Array.<number>|null} [chunkPayloadHistogramDef] TraceStats chunkPayloadHistogramDef
	             * @property {Array.<perfetto.protos.TraceStats.IWriterStats>|null} [writerStats] TraceStats writerStats
	             * @property {number|null} [producersConnected] TraceStats producersConnected
	             * @property {number|null} [producersSeen] TraceStats producersSeen
	             * @property {number|null} [dataSourcesRegistered] TraceStats dataSourcesRegistered
	             * @property {number|null} [dataSourcesSeen] TraceStats dataSourcesSeen
	             * @property {number|null} [tracingSessions] TraceStats tracingSessions
	             * @property {number|null} [totalBuffers] TraceStats totalBuffers
	             * @property {number|null} [chunksDiscarded] TraceStats chunksDiscarded
	             * @property {number|null} [patchesDiscarded] TraceStats patchesDiscarded
	             * @property {number|null} [invalidPackets] TraceStats invalidPackets
	             * @property {perfetto.protos.TraceStats.IFilterStats|null} [filterStats] TraceStats filterStats
	             * @property {number|null} [flushesRequested] TraceStats flushesRequested
	             * @property {number|null} [flushesSucceeded] TraceStats flushesSucceeded
	             * @property {number|null} [flushesFailed] TraceStats flushesFailed
	             * @property {perfetto.protos.TraceStats.FinalFlushOutcome|null} [finalFlushOutcome] TraceStats finalFlushOutcome
	             */

	            /**
	             * Constructs a new TraceStats.
	             * @memberof perfetto.protos
	             * @classdesc Represents a TraceStats.
	             * @implements ITraceStats
	             * @constructor
	             * @param {perfetto.protos.ITraceStats=} [p] Properties to set
	             */
	            function TraceStats(p) {
	                this.bufferStats = [];
	                this.chunkPayloadHistogramDef = [];
	                this.writerStats = [];
	                if (p)
	                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
	                        if (p[ks[i]] != null)
	                            this[ks[i]] = p[ks[i]];
	            }

	            /**
	             * TraceStats bufferStats.
	             * @member {Array.<perfetto.protos.TraceStats.IBufferStats>} bufferStats
	             * @memberof perfetto.protos.TraceStats
	             * @instance
	             */
	            TraceStats.prototype.bufferStats = $util.emptyArray;

	            /**
	             * TraceStats chunkPayloadHistogramDef.
	             * @member {Array.<number>} chunkPayloadHistogramDef
	             * @memberof perfetto.protos.TraceStats
	             * @instance
	             */
	            TraceStats.prototype.chunkPayloadHistogramDef = $util.emptyArray;

	            /**
	             * TraceStats writerStats.
	             * @member {Array.<perfetto.protos.TraceStats.IWriterStats>} writerStats
	             * @memberof perfetto.protos.TraceStats
	             * @instance
	             */
	            TraceStats.prototype.writerStats = $util.emptyArray;

	            /**
	             * TraceStats producersConnected.
	             * @member {number} producersConnected
	             * @memberof perfetto.protos.TraceStats
	             * @instance
	             */
	            TraceStats.prototype.producersConnected = 0;

	            /**
	             * TraceStats producersSeen.
	             * @member {number} producersSeen
	             * @memberof perfetto.protos.TraceStats
	             * @instance
	             */
	            TraceStats.prototype.producersSeen = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

	            /**
	             * TraceStats dataSourcesRegistered.
	             * @member {number} dataSourcesRegistered
	             * @memberof perfetto.protos.TraceStats
	             * @instance
	             */
	            TraceStats.prototype.dataSourcesRegistered = 0;

	            /**
	             * TraceStats dataSourcesSeen.
	             * @member {number} dataSourcesSeen
	             * @memberof perfetto.protos.TraceStats
	             * @instance
	             */
	            TraceStats.prototype.dataSourcesSeen = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

	            /**
	             * TraceStats tracingSessions.
	             * @member {number} tracingSessions
	             * @memberof perfetto.protos.TraceStats
	             * @instance
	             */
	            TraceStats.prototype.tracingSessions = 0;

	            /**
	             * TraceStats totalBuffers.
	             * @member {number} totalBuffers
	             * @memberof perfetto.protos.TraceStats
	             * @instance
	             */
	            TraceStats.prototype.totalBuffers = 0;

	            /**
	             * TraceStats chunksDiscarded.
	             * @member {number} chunksDiscarded
	             * @memberof perfetto.protos.TraceStats
	             * @instance
	             */
	            TraceStats.prototype.chunksDiscarded = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

	            /**
	             * TraceStats patchesDiscarded.
	             * @member {number} patchesDiscarded
	             * @memberof perfetto.protos.TraceStats
	             * @instance
	             */
	            TraceStats.prototype.patchesDiscarded = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

	            /**
	             * TraceStats invalidPackets.
	             * @member {number} invalidPackets
	             * @memberof perfetto.protos.TraceStats
	             * @instance
	             */
	            TraceStats.prototype.invalidPackets = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

	            /**
	             * TraceStats filterStats.
	             * @member {perfetto.protos.TraceStats.IFilterStats|null|undefined} filterStats
	             * @memberof perfetto.protos.TraceStats
	             * @instance
	             */
	            TraceStats.prototype.filterStats = null;

	            /**
	             * TraceStats flushesRequested.
	             * @member {number} flushesRequested
	             * @memberof perfetto.protos.TraceStats
	             * @instance
	             */
	            TraceStats.prototype.flushesRequested = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

	            /**
	             * TraceStats flushesSucceeded.
	             * @member {number} flushesSucceeded
	             * @memberof perfetto.protos.TraceStats
	             * @instance
	             */
	            TraceStats.prototype.flushesSucceeded = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

	            /**
	             * TraceStats flushesFailed.
	             * @member {number} flushesFailed
	             * @memberof perfetto.protos.TraceStats
	             * @instance
	             */
	            TraceStats.prototype.flushesFailed = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

	            /**
	             * TraceStats finalFlushOutcome.
	             * @member {perfetto.protos.TraceStats.FinalFlushOutcome} finalFlushOutcome
	             * @memberof perfetto.protos.TraceStats
	             * @instance
	             */
	            TraceStats.prototype.finalFlushOutcome = 0;

	            /**
	             * Creates a new TraceStats instance using the specified properties.
	             * @function create
	             * @memberof perfetto.protos.TraceStats
	             * @static
	             * @param {perfetto.protos.ITraceStats=} [properties] Properties to set
	             * @returns {perfetto.protos.TraceStats} TraceStats instance
	             */
	            TraceStats.create = function create(properties) {
	                return new TraceStats(properties);
	            };

	            /**
	             * Encodes the specified TraceStats message. Does not implicitly {@link perfetto.protos.TraceStats.verify|verify} messages.
	             * @function encode
	             * @memberof perfetto.protos.TraceStats
	             * @static
	             * @param {perfetto.protos.ITraceStats} m TraceStats message or plain object to encode
	             * @param {$protobuf.Writer} [w] Writer to encode to
	             * @returns {$protobuf.Writer} Writer
	             */
	            TraceStats.encode = function encode(m, w) {
	                if (!w)
	                    w = $Writer.create();
	                if (m.bufferStats != null && m.bufferStats.length) {
	                    for (var i = 0; i < m.bufferStats.length; ++i)
	                        $root.perfetto.protos.TraceStats.BufferStats.encode(m.bufferStats[i], w.uint32(10).fork()).ldelim();
	                }
	                if (m.producersConnected != null && Object.hasOwnProperty.call(m, "producersConnected"))
	                    w.uint32(16).uint32(m.producersConnected);
	                if (m.producersSeen != null && Object.hasOwnProperty.call(m, "producersSeen"))
	                    w.uint32(24).uint64(m.producersSeen);
	                if (m.dataSourcesRegistered != null && Object.hasOwnProperty.call(m, "dataSourcesRegistered"))
	                    w.uint32(32).uint32(m.dataSourcesRegistered);
	                if (m.dataSourcesSeen != null && Object.hasOwnProperty.call(m, "dataSourcesSeen"))
	                    w.uint32(40).uint64(m.dataSourcesSeen);
	                if (m.tracingSessions != null && Object.hasOwnProperty.call(m, "tracingSessions"))
	                    w.uint32(48).uint32(m.tracingSessions);
	                if (m.totalBuffers != null && Object.hasOwnProperty.call(m, "totalBuffers"))
	                    w.uint32(56).uint32(m.totalBuffers);
	                if (m.chunksDiscarded != null && Object.hasOwnProperty.call(m, "chunksDiscarded"))
	                    w.uint32(64).uint64(m.chunksDiscarded);
	                if (m.patchesDiscarded != null && Object.hasOwnProperty.call(m, "patchesDiscarded"))
	                    w.uint32(72).uint64(m.patchesDiscarded);
	                if (m.invalidPackets != null && Object.hasOwnProperty.call(m, "invalidPackets"))
	                    w.uint32(80).uint64(m.invalidPackets);
	                if (m.filterStats != null && Object.hasOwnProperty.call(m, "filterStats"))
	                    $root.perfetto.protos.TraceStats.FilterStats.encode(m.filterStats, w.uint32(90).fork()).ldelim();
	                if (m.flushesRequested != null && Object.hasOwnProperty.call(m, "flushesRequested"))
	                    w.uint32(96).uint64(m.flushesRequested);
	                if (m.flushesSucceeded != null && Object.hasOwnProperty.call(m, "flushesSucceeded"))
	                    w.uint32(104).uint64(m.flushesSucceeded);
	                if (m.flushesFailed != null && Object.hasOwnProperty.call(m, "flushesFailed"))
	                    w.uint32(112).uint64(m.flushesFailed);
	                if (m.finalFlushOutcome != null && Object.hasOwnProperty.call(m, "finalFlushOutcome"))
	                    w.uint32(120).int32(m.finalFlushOutcome);
	                if (m.chunkPayloadHistogramDef != null && m.chunkPayloadHistogramDef.length) {
	                    for (var i = 0; i < m.chunkPayloadHistogramDef.length; ++i)
	                        w.uint32(136).int64(m.chunkPayloadHistogramDef[i]);
	                }
	                if (m.writerStats != null && m.writerStats.length) {
	                    for (var i = 0; i < m.writerStats.length; ++i)
	                        $root.perfetto.protos.TraceStats.WriterStats.encode(m.writerStats[i], w.uint32(146).fork()).ldelim();
	                }
	                return w;
	            };

	            /**
	             * Decodes a TraceStats message from the specified reader or buffer.
	             * @function decode
	             * @memberof perfetto.protos.TraceStats
	             * @static
	             * @param {$protobuf.Reader|Uint8Array} r Reader or buffer to decode from
	             * @param {number} [l] Message length if known beforehand
	             * @returns {perfetto.protos.TraceStats} TraceStats
	             * @throws {Error} If the payload is not a reader or valid buffer
	             * @throws {$protobuf.util.ProtocolError} If required fields are missing
	             */
	            TraceStats.decode = function decode(r, l) {
	                if (!(r instanceof $Reader))
	                    r = $Reader.create(r);
	                var c = l === undefined ? r.len : r.pos + l, m = new $root.perfetto.protos.TraceStats();
	                while (r.pos < c) {
	                    var t = r.uint32();
	                    switch (t >>> 3) {
	                    case 1:
	                        if (!(m.bufferStats && m.bufferStats.length))
	                            m.bufferStats = [];
	                        m.bufferStats.push($root.perfetto.protos.TraceStats.BufferStats.decode(r, r.uint32()));
	                        break;
	                    case 17:
	                        if (!(m.chunkPayloadHistogramDef && m.chunkPayloadHistogramDef.length))
	                            m.chunkPayloadHistogramDef = [];
	                        if ((t & 7) === 2) {
	                            var c2 = r.uint32() + r.pos;
	                            while (r.pos < c2)
	                                m.chunkPayloadHistogramDef.push(r.int64());
	                        } else
	                            m.chunkPayloadHistogramDef.push(r.int64());
	                        break;
	                    case 18:
	                        if (!(m.writerStats && m.writerStats.length))
	                            m.writerStats = [];
	                        m.writerStats.push($root.perfetto.protos.TraceStats.WriterStats.decode(r, r.uint32()));
	                        break;
	                    case 2:
	                        m.producersConnected = r.uint32();
	                        break;
	                    case 3:
	                        m.producersSeen = r.uint64();
	                        break;
	                    case 4:
	                        m.dataSourcesRegistered = r.uint32();
	                        break;
	                    case 5:
	                        m.dataSourcesSeen = r.uint64();
	                        break;
	                    case 6:
	                        m.tracingSessions = r.uint32();
	                        break;
	                    case 7:
	                        m.totalBuffers = r.uint32();
	                        break;
	                    case 8:
	                        m.chunksDiscarded = r.uint64();
	                        break;
	                    case 9:
	                        m.patchesDiscarded = r.uint64();
	                        break;
	                    case 10:
	                        m.invalidPackets = r.uint64();
	                        break;
	                    case 11:
	                        m.filterStats = $root.perfetto.protos.TraceStats.FilterStats.decode(r, r.uint32());
	                        break;
	                    case 12:
	                        m.flushesRequested = r.uint64();
	                        break;
	                    case 13:
	                        m.flushesSucceeded = r.uint64();
	                        break;
	                    case 14:
	                        m.flushesFailed = r.uint64();
	                        break;
	                    case 15:
	                        m.finalFlushOutcome = r.int32();
	                        break;
	                    default:
	                        r.skipType(t & 7);
	                        break;
	                    }
	                }
	                return m;
	            };

	            /**
	             * Creates a TraceStats message from a plain object. Also converts values to their respective internal types.
	             * @function fromObject
	             * @memberof perfetto.protos.TraceStats
	             * @static
	             * @param {Object.<string,*>} d Plain object
	             * @returns {perfetto.protos.TraceStats} TraceStats
	             */
	            TraceStats.fromObject = function fromObject(d) {
	                if (d instanceof $root.perfetto.protos.TraceStats)
	                    return d;
	                var m = new $root.perfetto.protos.TraceStats();
	                if (d.bufferStats) {
	                    if (!Array.isArray(d.bufferStats))
	                        throw TypeError(".perfetto.protos.TraceStats.bufferStats: array expected");
	                    m.bufferStats = [];
	                    for (var i = 0; i < d.bufferStats.length; ++i) {
	                        if (typeof d.bufferStats[i] !== "object")
	                            throw TypeError(".perfetto.protos.TraceStats.bufferStats: object expected");
	                        m.bufferStats[i] = $root.perfetto.protos.TraceStats.BufferStats.fromObject(d.bufferStats[i]);
	                    }
	                }
	                if (d.chunkPayloadHistogramDef) {
	                    if (!Array.isArray(d.chunkPayloadHistogramDef))
	                        throw TypeError(".perfetto.protos.TraceStats.chunkPayloadHistogramDef: array expected");
	                    m.chunkPayloadHistogramDef = [];
	                    for (var i = 0; i < d.chunkPayloadHistogramDef.length; ++i) {
	                        if ($util.Long)
	                            (m.chunkPayloadHistogramDef[i] = $util.Long.fromValue(d.chunkPayloadHistogramDef[i])).unsigned = false;
	                        else if (typeof d.chunkPayloadHistogramDef[i] === "string")
	                            m.chunkPayloadHistogramDef[i] = parseInt(d.chunkPayloadHistogramDef[i], 10);
	                        else if (typeof d.chunkPayloadHistogramDef[i] === "number")
	                            m.chunkPayloadHistogramDef[i] = d.chunkPayloadHistogramDef[i];
	                        else if (typeof d.chunkPayloadHistogramDef[i] === "object")
	                            m.chunkPayloadHistogramDef[i] = new $util.LongBits(d.chunkPayloadHistogramDef[i].low >>> 0, d.chunkPayloadHistogramDef[i].high >>> 0).toNumber();
	                    }
	                }
	                if (d.writerStats) {
	                    if (!Array.isArray(d.writerStats))
	                        throw TypeError(".perfetto.protos.TraceStats.writerStats: array expected");
	                    m.writerStats = [];
	                    for (var i = 0; i < d.writerStats.length; ++i) {
	                        if (typeof d.writerStats[i] !== "object")
	                            throw TypeError(".perfetto.protos.TraceStats.writerStats: object expected");
	                        m.writerStats[i] = $root.perfetto.protos.TraceStats.WriterStats.fromObject(d.writerStats[i]);
	                    }
	                }
	                if (d.producersConnected != null) {
	                    m.producersConnected = d.producersConnected >>> 0;
	                }
	                if (d.producersSeen != null) {
	                    if ($util.Long)
	                        (m.producersSeen = $util.Long.fromValue(d.producersSeen)).unsigned = true;
	                    else if (typeof d.producersSeen === "string")
	                        m.producersSeen = parseInt(d.producersSeen, 10);
	                    else if (typeof d.producersSeen === "number")
	                        m.producersSeen = d.producersSeen;
	                    else if (typeof d.producersSeen === "object")
	                        m.producersSeen = new $util.LongBits(d.producersSeen.low >>> 0, d.producersSeen.high >>> 0).toNumber(true);
	                }
	                if (d.dataSourcesRegistered != null) {
	                    m.dataSourcesRegistered = d.dataSourcesRegistered >>> 0;
	                }
	                if (d.dataSourcesSeen != null) {
	                    if ($util.Long)
	                        (m.dataSourcesSeen = $util.Long.fromValue(d.dataSourcesSeen)).unsigned = true;
	                    else if (typeof d.dataSourcesSeen === "string")
	                        m.dataSourcesSeen = parseInt(d.dataSourcesSeen, 10);
	                    else if (typeof d.dataSourcesSeen === "number")
	                        m.dataSourcesSeen = d.dataSourcesSeen;
	                    else if (typeof d.dataSourcesSeen === "object")
	                        m.dataSourcesSeen = new $util.LongBits(d.dataSourcesSeen.low >>> 0, d.dataSourcesSeen.high >>> 0).toNumber(true);
	                }
	                if (d.tracingSessions != null) {
	                    m.tracingSessions = d.tracingSessions >>> 0;
	                }
	                if (d.totalBuffers != null) {
	                    m.totalBuffers = d.totalBuffers >>> 0;
	                }
	                if (d.chunksDiscarded != null) {
	                    if ($util.Long)
	                        (m.chunksDiscarded = $util.Long.fromValue(d.chunksDiscarded)).unsigned = true;
	                    else if (typeof d.chunksDiscarded === "string")
	                        m.chunksDiscarded = parseInt(d.chunksDiscarded, 10);
	                    else if (typeof d.chunksDiscarded === "number")
	                        m.chunksDiscarded = d.chunksDiscarded;
	                    else if (typeof d.chunksDiscarded === "object")
	                        m.chunksDiscarded = new $util.LongBits(d.chunksDiscarded.low >>> 0, d.chunksDiscarded.high >>> 0).toNumber(true);
	                }
	                if (d.patchesDiscarded != null) {
	                    if ($util.Long)
	                        (m.patchesDiscarded = $util.Long.fromValue(d.patchesDiscarded)).unsigned = true;
	                    else if (typeof d.patchesDiscarded === "string")
	                        m.patchesDiscarded = parseInt(d.patchesDiscarded, 10);
	                    else if (typeof d.patchesDiscarded === "number")
	                        m.patchesDiscarded = d.patchesDiscarded;
	                    else if (typeof d.patchesDiscarded === "object")
	                        m.patchesDiscarded = new $util.LongBits(d.patchesDiscarded.low >>> 0, d.patchesDiscarded.high >>> 0).toNumber(true);
	                }
	                if (d.invalidPackets != null) {
	                    if ($util.Long)
	                        (m.invalidPackets = $util.Long.fromValue(d.invalidPackets)).unsigned = true;
	                    else if (typeof d.invalidPackets === "string")
	                        m.invalidPackets = parseInt(d.invalidPackets, 10);
	                    else if (typeof d.invalidPackets === "number")
	                        m.invalidPackets = d.invalidPackets;
	                    else if (typeof d.invalidPackets === "object")
	                        m.invalidPackets = new $util.LongBits(d.invalidPackets.low >>> 0, d.invalidPackets.high >>> 0).toNumber(true);
	                }
	                if (d.filterStats != null) {
	                    if (typeof d.filterStats !== "object")
	                        throw TypeError(".perfetto.protos.TraceStats.filterStats: object expected");
	                    m.filterStats = $root.perfetto.protos.TraceStats.FilterStats.fromObject(d.filterStats);
	                }
	                if (d.flushesRequested != null) {
	                    if ($util.Long)
	                        (m.flushesRequested = $util.Long.fromValue(d.flushesRequested)).unsigned = true;
	                    else if (typeof d.flushesRequested === "string")
	                        m.flushesRequested = parseInt(d.flushesRequested, 10);
	                    else if (typeof d.flushesRequested === "number")
	                        m.flushesRequested = d.flushesRequested;
	                    else if (typeof d.flushesRequested === "object")
	                        m.flushesRequested = new $util.LongBits(d.flushesRequested.low >>> 0, d.flushesRequested.high >>> 0).toNumber(true);
	                }
	                if (d.flushesSucceeded != null) {
	                    if ($util.Long)
	                        (m.flushesSucceeded = $util.Long.fromValue(d.flushesSucceeded)).unsigned = true;
	                    else if (typeof d.flushesSucceeded === "string")
	                        m.flushesSucceeded = parseInt(d.flushesSucceeded, 10);
	                    else if (typeof d.flushesSucceeded === "number")
	                        m.flushesSucceeded = d.flushesSucceeded;
	                    else if (typeof d.flushesSucceeded === "object")
	                        m.flushesSucceeded = new $util.LongBits(d.flushesSucceeded.low >>> 0, d.flushesSucceeded.high >>> 0).toNumber(true);
	                }
	                if (d.flushesFailed != null) {
	                    if ($util.Long)
	                        (m.flushesFailed = $util.Long.fromValue(d.flushesFailed)).unsigned = true;
	                    else if (typeof d.flushesFailed === "string")
	                        m.flushesFailed = parseInt(d.flushesFailed, 10);
	                    else if (typeof d.flushesFailed === "number")
	                        m.flushesFailed = d.flushesFailed;
	                    else if (typeof d.flushesFailed === "object")
	                        m.flushesFailed = new $util.LongBits(d.flushesFailed.low >>> 0, d.flushesFailed.high >>> 0).toNumber(true);
	                }
	                switch (d.finalFlushOutcome) {
	                case "FINAL_FLUSH_UNSPECIFIED":
	                case 0:
	                    m.finalFlushOutcome = 0;
	                    break;
	                case "FINAL_FLUSH_SUCCEEDED":
	                case 1:
	                    m.finalFlushOutcome = 1;
	                    break;
	                case "FINAL_FLUSH_FAILED":
	                case 2:
	                    m.finalFlushOutcome = 2;
	                    break;
	                }
	                return m;
	            };

	            /**
	             * Creates a plain object from a TraceStats message. Also converts values to other types if specified.
	             * @function toObject
	             * @memberof perfetto.protos.TraceStats
	             * @static
	             * @param {perfetto.protos.TraceStats} m TraceStats
	             * @param {$protobuf.IConversionOptions} [o] Conversion options
	             * @returns {Object.<string,*>} Plain object
	             */
	            TraceStats.toObject = function toObject(m, o) {
	                if (!o)
	                    o = {};
	                var d = {};
	                if (o.arrays || o.defaults) {
	                    d.bufferStats = [];
	                    d.chunkPayloadHistogramDef = [];
	                    d.writerStats = [];
	                }
	                if (o.defaults) {
	                    d.producersConnected = 0;
	                    if ($util.Long) {
	                        var n = new $util.Long(0, 0, true);
	                        d.producersSeen = o.longs === String ? n.toString() : o.longs === Number ? n.toNumber() : n;
	                    } else
	                        d.producersSeen = o.longs === String ? "0" : 0;
	                    d.dataSourcesRegistered = 0;
	                    if ($util.Long) {
	                        var n = new $util.Long(0, 0, true);
	                        d.dataSourcesSeen = o.longs === String ? n.toString() : o.longs === Number ? n.toNumber() : n;
	                    } else
	                        d.dataSourcesSeen = o.longs === String ? "0" : 0;
	                    d.tracingSessions = 0;
	                    d.totalBuffers = 0;
	                    if ($util.Long) {
	                        var n = new $util.Long(0, 0, true);
	                        d.chunksDiscarded = o.longs === String ? n.toString() : o.longs === Number ? n.toNumber() : n;
	                    } else
	                        d.chunksDiscarded = o.longs === String ? "0" : 0;
	                    if ($util.Long) {
	                        var n = new $util.Long(0, 0, true);
	                        d.patchesDiscarded = o.longs === String ? n.toString() : o.longs === Number ? n.toNumber() : n;
	                    } else
	                        d.patchesDiscarded = o.longs === String ? "0" : 0;
	                    if ($util.Long) {
	                        var n = new $util.Long(0, 0, true);
	                        d.invalidPackets = o.longs === String ? n.toString() : o.longs === Number ? n.toNumber() : n;
	                    } else
	                        d.invalidPackets = o.longs === String ? "0" : 0;
	                    d.filterStats = null;
	                    if ($util.Long) {
	                        var n = new $util.Long(0, 0, true);
	                        d.flushesRequested = o.longs === String ? n.toString() : o.longs === Number ? n.toNumber() : n;
	                    } else
	                        d.flushesRequested = o.longs === String ? "0" : 0;
	                    if ($util.Long) {
	                        var n = new $util.Long(0, 0, true);
	                        d.flushesSucceeded = o.longs === String ? n.toString() : o.longs === Number ? n.toNumber() : n;
	                    } else
	                        d.flushesSucceeded = o.longs === String ? "0" : 0;
	                    if ($util.Long) {
	                        var n = new $util.Long(0, 0, true);
	                        d.flushesFailed = o.longs === String ? n.toString() : o.longs === Number ? n.toNumber() : n;
	                    } else
	                        d.flushesFailed = o.longs === String ? "0" : 0;
	                    d.finalFlushOutcome = o.enums === String ? "FINAL_FLUSH_UNSPECIFIED" : 0;
	                }
	                if (m.bufferStats && m.bufferStats.length) {
	                    d.bufferStats = [];
	                    for (var j = 0; j < m.bufferStats.length; ++j) {
	                        d.bufferStats[j] = $root.perfetto.protos.TraceStats.BufferStats.toObject(m.bufferStats[j], o);
	                    }
	                }
	                if (m.producersConnected != null && m.hasOwnProperty("producersConnected")) {
	                    d.producersConnected = m.producersConnected;
	                }
	                if (m.producersSeen != null && m.hasOwnProperty("producersSeen")) {
	                    if (typeof m.producersSeen === "number")
	                        d.producersSeen = o.longs === String ? String(m.producersSeen) : m.producersSeen;
	                    else
	                        d.producersSeen = o.longs === String ? $util.Long.prototype.toString.call(m.producersSeen) : o.longs === Number ? new $util.LongBits(m.producersSeen.low >>> 0, m.producersSeen.high >>> 0).toNumber(true) : m.producersSeen;
	                }
	                if (m.dataSourcesRegistered != null && m.hasOwnProperty("dataSourcesRegistered")) {
	                    d.dataSourcesRegistered = m.dataSourcesRegistered;
	                }
	                if (m.dataSourcesSeen != null && m.hasOwnProperty("dataSourcesSeen")) {
	                    if (typeof m.dataSourcesSeen === "number")
	                        d.dataSourcesSeen = o.longs === String ? String(m.dataSourcesSeen) : m.dataSourcesSeen;
	                    else
	                        d.dataSourcesSeen = o.longs === String ? $util.Long.prototype.toString.call(m.dataSourcesSeen) : o.longs === Number ? new $util.LongBits(m.dataSourcesSeen.low >>> 0, m.dataSourcesSeen.high >>> 0).toNumber(true) : m.dataSourcesSeen;
	                }
	                if (m.tracingSessions != null && m.hasOwnProperty("tracingSessions")) {
	                    d.tracingSessions = m.tracingSessions;
	                }
	                if (m.totalBuffers != null && m.hasOwnProperty("totalBuffers")) {
	                    d.totalBuffers = m.totalBuffers;
	                }
	                if (m.chunksDiscarded != null && m.hasOwnProperty("chunksDiscarded")) {
	                    if (typeof m.chunksDiscarded === "number")
	                        d.chunksDiscarded = o.longs === String ? String(m.chunksDiscarded) : m.chunksDiscarded;
	                    else
	                        d.chunksDiscarded = o.longs === String ? $util.Long.prototype.toString.call(m.chunksDiscarded) : o.longs === Number ? new $util.LongBits(m.chunksDiscarded.low >>> 0, m.chunksDiscarded.high >>> 0).toNumber(true) : m.chunksDiscarded;
	                }
	                if (m.patchesDiscarded != null && m.hasOwnProperty("patchesDiscarded")) {
	                    if (typeof m.patchesDiscarded === "number")
	                        d.patchesDiscarded = o.longs === String ? String(m.patchesDiscarded) : m.patchesDiscarded;
	                    else
	                        d.patchesDiscarded = o.longs === String ? $util.Long.prototype.toString.call(m.patchesDiscarded) : o.longs === Number ? new $util.LongBits(m.patchesDiscarded.low >>> 0, m.patchesDiscarded.high >>> 0).toNumber(true) : m.patchesDiscarded;
	                }
	                if (m.invalidPackets != null && m.hasOwnProperty("invalidPackets")) {
	                    if (typeof m.invalidPackets === "number")
	                        d.invalidPackets = o.longs === String ? String(m.invalidPackets) : m.invalidPackets;
	                    else
	                        d.invalidPackets = o.longs === String ? $util.Long.prototype.toString.call(m.invalidPackets) : o.longs === Number ? new $util.LongBits(m.invalidPackets.low >>> 0, m.invalidPackets.high >>> 0).toNumber(true) : m.invalidPackets;
	                }
	                if (m.filterStats != null && m.hasOwnProperty("filterStats")) {
	                    d.filterStats = $root.perfetto.protos.TraceStats.FilterStats.toObject(m.filterStats, o);
	                }
	                if (m.flushesRequested != null && m.hasOwnProperty("flushesRequested")) {
	                    if (typeof m.flushesRequested === "number")
	                        d.flushesRequested = o.longs === String ? String(m.flushesRequested) : m.flushesRequested;
	                    else
	                        d.flushesRequested = o.longs === String ? $util.Long.prototype.toString.call(m.flushesRequested) : o.longs === Number ? new $util.LongBits(m.flushesRequested.low >>> 0, m.flushesRequested.high >>> 0).toNumber(true) : m.flushesRequested;
	                }
	                if (m.flushesSucceeded != null && m.hasOwnProperty("flushesSucceeded")) {
	                    if (typeof m.flushesSucceeded === "number")
	                        d.flushesSucceeded = o.longs === String ? String(m.flushesSucceeded) : m.flushesSucceeded;
	                    else
	                        d.flushesSucceeded = o.longs === String ? $util.Long.prototype.toString.call(m.flushesSucceeded) : o.longs === Number ? new $util.LongBits(m.flushesSucceeded.low >>> 0, m.flushesSucceeded.high >>> 0).toNumber(true) : m.flushesSucceeded;
	                }
	                if (m.flushesFailed != null && m.hasOwnProperty("flushesFailed")) {
	                    if (typeof m.flushesFailed === "number")
	                        d.flushesFailed = o.longs === String ? String(m.flushesFailed) : m.flushesFailed;
	                    else
	                        d.flushesFailed = o.longs === String ? $util.Long.prototype.toString.call(m.flushesFailed) : o.longs === Number ? new $util.LongBits(m.flushesFailed.low >>> 0, m.flushesFailed.high >>> 0).toNumber(true) : m.flushesFailed;
	                }
	                if (m.finalFlushOutcome != null && m.hasOwnProperty("finalFlushOutcome")) {
	                    d.finalFlushOutcome = o.enums === String ? $root.perfetto.protos.TraceStats.FinalFlushOutcome[m.finalFlushOutcome] : m.finalFlushOutcome;
	                }
	                if (m.chunkPayloadHistogramDef && m.chunkPayloadHistogramDef.length) {
	                    d.chunkPayloadHistogramDef = [];
	                    for (var j = 0; j < m.chunkPayloadHistogramDef.length; ++j) {
	                        if (typeof m.chunkPayloadHistogramDef[j] === "number")
	                            d.chunkPayloadHistogramDef[j] = o.longs === String ? String(m.chunkPayloadHistogramDef[j]) : m.chunkPayloadHistogramDef[j];
	                        else
	                            d.chunkPayloadHistogramDef[j] = o.longs === String ? $util.Long.prototype.toString.call(m.chunkPayloadHistogramDef[j]) : o.longs === Number ? new $util.LongBits(m.chunkPayloadHistogramDef[j].low >>> 0, m.chunkPayloadHistogramDef[j].high >>> 0).toNumber() : m.chunkPayloadHistogramDef[j];
	                    }
	                }
	                if (m.writerStats && m.writerStats.length) {
	                    d.writerStats = [];
	                    for (var j = 0; j < m.writerStats.length; ++j) {
	                        d.writerStats[j] = $root.perfetto.protos.TraceStats.WriterStats.toObject(m.writerStats[j], o);
	                    }
	                }
	                return d;
	            };

	            /**
	             * Converts this TraceStats to JSON.
	             * @function toJSON
	             * @memberof perfetto.protos.TraceStats
	             * @instance
	             * @returns {Object.<string,*>} JSON object
	             */
	            TraceStats.prototype.toJSON = function toJSON() {
	                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
	            };

	            TraceStats.BufferStats = (function() {

	                /**
	                 * Properties of a BufferStats.
	                 * @memberof perfetto.protos.TraceStats
	                 * @interface IBufferStats
	                 * @property {number|null} [bufferSize] BufferStats bufferSize
	                 * @property {number|null} [bytesWritten] BufferStats bytesWritten
	                 * @property {number|null} [bytesOverwritten] BufferStats bytesOverwritten
	                 * @property {number|null} [bytesRead] BufferStats bytesRead
	                 * @property {number|null} [paddingBytesWritten] BufferStats paddingBytesWritten
	                 * @property {number|null} [paddingBytesCleared] BufferStats paddingBytesCleared
	                 * @property {number|null} [chunksWritten] BufferStats chunksWritten
	                 * @property {number|null} [chunksRewritten] BufferStats chunksRewritten
	                 * @property {number|null} [chunksOverwritten] BufferStats chunksOverwritten
	                 * @property {number|null} [chunksDiscarded] BufferStats chunksDiscarded
	                 * @property {number|null} [chunksRead] BufferStats chunksRead
	                 * @property {number|null} [chunksCommittedOutOfOrder] BufferStats chunksCommittedOutOfOrder
	                 * @property {number|null} [writeWrapCount] BufferStats writeWrapCount
	                 * @property {number|null} [patchesSucceeded] BufferStats patchesSucceeded
	                 * @property {number|null} [patchesFailed] BufferStats patchesFailed
	                 * @property {number|null} [readaheadsSucceeded] BufferStats readaheadsSucceeded
	                 * @property {number|null} [readaheadsFailed] BufferStats readaheadsFailed
	                 * @property {number|null} [abiViolations] BufferStats abiViolations
	                 * @property {number|null} [traceWriterPacketLoss] BufferStats traceWriterPacketLoss
	                 */

	                /**
	                 * Constructs a new BufferStats.
	                 * @memberof perfetto.protos.TraceStats
	                 * @classdesc Represents a BufferStats.
	                 * @implements IBufferStats
	                 * @constructor
	                 * @param {perfetto.protos.TraceStats.IBufferStats=} [p] Properties to set
	                 */
	                function BufferStats(p) {
	                    if (p)
	                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
	                            if (p[ks[i]] != null)
	                                this[ks[i]] = p[ks[i]];
	                }

	                /**
	                 * BufferStats bufferSize.
	                 * @member {number} bufferSize
	                 * @memberof perfetto.protos.TraceStats.BufferStats
	                 * @instance
	                 */
	                BufferStats.prototype.bufferSize = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

	                /**
	                 * BufferStats bytesWritten.
	                 * @member {number} bytesWritten
	                 * @memberof perfetto.protos.TraceStats.BufferStats
	                 * @instance
	                 */
	                BufferStats.prototype.bytesWritten = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

	                /**
	                 * BufferStats bytesOverwritten.
	                 * @member {number} bytesOverwritten
	                 * @memberof perfetto.protos.TraceStats.BufferStats
	                 * @instance
	                 */
	                BufferStats.prototype.bytesOverwritten = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

	                /**
	                 * BufferStats bytesRead.
	                 * @member {number} bytesRead
	                 * @memberof perfetto.protos.TraceStats.BufferStats
	                 * @instance
	                 */
	                BufferStats.prototype.bytesRead = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

	                /**
	                 * BufferStats paddingBytesWritten.
	                 * @member {number} paddingBytesWritten
	                 * @memberof perfetto.protos.TraceStats.BufferStats
	                 * @instance
	                 */
	                BufferStats.prototype.paddingBytesWritten = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

	                /**
	                 * BufferStats paddingBytesCleared.
	                 * @member {number} paddingBytesCleared
	                 * @memberof perfetto.protos.TraceStats.BufferStats
	                 * @instance
	                 */
	                BufferStats.prototype.paddingBytesCleared = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

	                /**
	                 * BufferStats chunksWritten.
	                 * @member {number} chunksWritten
	                 * @memberof perfetto.protos.TraceStats.BufferStats
	                 * @instance
	                 */
	                BufferStats.prototype.chunksWritten = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

	                /**
	                 * BufferStats chunksRewritten.
	                 * @member {number} chunksRewritten
	                 * @memberof perfetto.protos.TraceStats.BufferStats
	                 * @instance
	                 */
	                BufferStats.prototype.chunksRewritten = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

	                /**
	                 * BufferStats chunksOverwritten.
	                 * @member {number} chunksOverwritten
	                 * @memberof perfetto.protos.TraceStats.BufferStats
	                 * @instance
	                 */
	                BufferStats.prototype.chunksOverwritten = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

	                /**
	                 * BufferStats chunksDiscarded.
	                 * @member {number} chunksDiscarded
	                 * @memberof perfetto.protos.TraceStats.BufferStats
	                 * @instance
	                 */
	                BufferStats.prototype.chunksDiscarded = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

	                /**
	                 * BufferStats chunksRead.
	                 * @member {number} chunksRead
	                 * @memberof perfetto.protos.TraceStats.BufferStats
	                 * @instance
	                 */
	                BufferStats.prototype.chunksRead = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

	                /**
	                 * BufferStats chunksCommittedOutOfOrder.
	                 * @member {number} chunksCommittedOutOfOrder
	                 * @memberof perfetto.protos.TraceStats.BufferStats
	                 * @instance
	                 */
	                BufferStats.prototype.chunksCommittedOutOfOrder = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

	                /**
	                 * BufferStats writeWrapCount.
	                 * @member {number} writeWrapCount
	                 * @memberof perfetto.protos.TraceStats.BufferStats
	                 * @instance
	                 */
	                BufferStats.prototype.writeWrapCount = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

	                /**
	                 * BufferStats patchesSucceeded.
	                 * @member {number} patchesSucceeded
	                 * @memberof perfetto.protos.TraceStats.BufferStats
	                 * @instance
	                 */
	                BufferStats.prototype.patchesSucceeded = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

	                /**
	                 * BufferStats patchesFailed.
	                 * @member {number} patchesFailed
	                 * @memberof perfetto.protos.TraceStats.BufferStats
	                 * @instance
	                 */
	                BufferStats.prototype.patchesFailed = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

	                /**
	                 * BufferStats readaheadsSucceeded.
	                 * @member {number} readaheadsSucceeded
	                 * @memberof perfetto.protos.TraceStats.BufferStats
	                 * @instance
	                 */
	                BufferStats.prototype.readaheadsSucceeded = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

	                /**
	                 * BufferStats readaheadsFailed.
	                 * @member {number} readaheadsFailed
	                 * @memberof perfetto.protos.TraceStats.BufferStats
	                 * @instance
	                 */
	                BufferStats.prototype.readaheadsFailed = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

	                /**
	                 * BufferStats abiViolations.
	                 * @member {number} abiViolations
	                 * @memberof perfetto.protos.TraceStats.BufferStats
	                 * @instance
	                 */
	                BufferStats.prototype.abiViolations = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

	                /**
	                 * BufferStats traceWriterPacketLoss.
	                 * @member {number} traceWriterPacketLoss
	                 * @memberof perfetto.protos.TraceStats.BufferStats
	                 * @instance
	                 */
	                BufferStats.prototype.traceWriterPacketLoss = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

	                /**
	                 * Creates a new BufferStats instance using the specified properties.
	                 * @function create
	                 * @memberof perfetto.protos.TraceStats.BufferStats
	                 * @static
	                 * @param {perfetto.protos.TraceStats.IBufferStats=} [properties] Properties to set
	                 * @returns {perfetto.protos.TraceStats.BufferStats} BufferStats instance
	                 */
	                BufferStats.create = function create(properties) {
	                    return new BufferStats(properties);
	                };

	                /**
	                 * Encodes the specified BufferStats message. Does not implicitly {@link perfetto.protos.TraceStats.BufferStats.verify|verify} messages.
	                 * @function encode
	                 * @memberof perfetto.protos.TraceStats.BufferStats
	                 * @static
	                 * @param {perfetto.protos.TraceStats.IBufferStats} m BufferStats message or plain object to encode
	                 * @param {$protobuf.Writer} [w] Writer to encode to
	                 * @returns {$protobuf.Writer} Writer
	                 */
	                BufferStats.encode = function encode(m, w) {
	                    if (!w)
	                        w = $Writer.create();
	                    if (m.bytesWritten != null && Object.hasOwnProperty.call(m, "bytesWritten"))
	                        w.uint32(8).uint64(m.bytesWritten);
	                    if (m.chunksWritten != null && Object.hasOwnProperty.call(m, "chunksWritten"))
	                        w.uint32(16).uint64(m.chunksWritten);
	                    if (m.chunksOverwritten != null && Object.hasOwnProperty.call(m, "chunksOverwritten"))
	                        w.uint32(24).uint64(m.chunksOverwritten);
	                    if (m.writeWrapCount != null && Object.hasOwnProperty.call(m, "writeWrapCount"))
	                        w.uint32(32).uint64(m.writeWrapCount);
	                    if (m.patchesSucceeded != null && Object.hasOwnProperty.call(m, "patchesSucceeded"))
	                        w.uint32(40).uint64(m.patchesSucceeded);
	                    if (m.patchesFailed != null && Object.hasOwnProperty.call(m, "patchesFailed"))
	                        w.uint32(48).uint64(m.patchesFailed);
	                    if (m.readaheadsSucceeded != null && Object.hasOwnProperty.call(m, "readaheadsSucceeded"))
	                        w.uint32(56).uint64(m.readaheadsSucceeded);
	                    if (m.readaheadsFailed != null && Object.hasOwnProperty.call(m, "readaheadsFailed"))
	                        w.uint32(64).uint64(m.readaheadsFailed);
	                    if (m.abiViolations != null && Object.hasOwnProperty.call(m, "abiViolations"))
	                        w.uint32(72).uint64(m.abiViolations);
	                    if (m.chunksRewritten != null && Object.hasOwnProperty.call(m, "chunksRewritten"))
	                        w.uint32(80).uint64(m.chunksRewritten);
	                    if (m.chunksCommittedOutOfOrder != null && Object.hasOwnProperty.call(m, "chunksCommittedOutOfOrder"))
	                        w.uint32(88).uint64(m.chunksCommittedOutOfOrder);
	                    if (m.bufferSize != null && Object.hasOwnProperty.call(m, "bufferSize"))
	                        w.uint32(96).uint64(m.bufferSize);
	                    if (m.bytesOverwritten != null && Object.hasOwnProperty.call(m, "bytesOverwritten"))
	                        w.uint32(104).uint64(m.bytesOverwritten);
	                    if (m.bytesRead != null && Object.hasOwnProperty.call(m, "bytesRead"))
	                        w.uint32(112).uint64(m.bytesRead);
	                    if (m.paddingBytesWritten != null && Object.hasOwnProperty.call(m, "paddingBytesWritten"))
	                        w.uint32(120).uint64(m.paddingBytesWritten);
	                    if (m.paddingBytesCleared != null && Object.hasOwnProperty.call(m, "paddingBytesCleared"))
	                        w.uint32(128).uint64(m.paddingBytesCleared);
	                    if (m.chunksRead != null && Object.hasOwnProperty.call(m, "chunksRead"))
	                        w.uint32(136).uint64(m.chunksRead);
	                    if (m.chunksDiscarded != null && Object.hasOwnProperty.call(m, "chunksDiscarded"))
	                        w.uint32(144).uint64(m.chunksDiscarded);
	                    if (m.traceWriterPacketLoss != null && Object.hasOwnProperty.call(m, "traceWriterPacketLoss"))
	                        w.uint32(152).uint64(m.traceWriterPacketLoss);
	                    return w;
	                };

	                /**
	                 * Decodes a BufferStats message from the specified reader or buffer.
	                 * @function decode
	                 * @memberof perfetto.protos.TraceStats.BufferStats
	                 * @static
	                 * @param {$protobuf.Reader|Uint8Array} r Reader or buffer to decode from
	                 * @param {number} [l] Message length if known beforehand
	                 * @returns {perfetto.protos.TraceStats.BufferStats} BufferStats
	                 * @throws {Error} If the payload is not a reader or valid buffer
	                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
	                 */
	                BufferStats.decode = function decode(r, l) {
	                    if (!(r instanceof $Reader))
	                        r = $Reader.create(r);
	                    var c = l === undefined ? r.len : r.pos + l, m = new $root.perfetto.protos.TraceStats.BufferStats();
	                    while (r.pos < c) {
	                        var t = r.uint32();
	                        switch (t >>> 3) {
	                        case 12:
	                            m.bufferSize = r.uint64();
	                            break;
	                        case 1:
	                            m.bytesWritten = r.uint64();
	                            break;
	                        case 13:
	                            m.bytesOverwritten = r.uint64();
	                            break;
	                        case 14:
	                            m.bytesRead = r.uint64();
	                            break;
	                        case 15:
	                            m.paddingBytesWritten = r.uint64();
	                            break;
	                        case 16:
	                            m.paddingBytesCleared = r.uint64();
	                            break;
	                        case 2:
	                            m.chunksWritten = r.uint64();
	                            break;
	                        case 10:
	                            m.chunksRewritten = r.uint64();
	                            break;
	                        case 3:
	                            m.chunksOverwritten = r.uint64();
	                            break;
	                        case 18:
	                            m.chunksDiscarded = r.uint64();
	                            break;
	                        case 17:
	                            m.chunksRead = r.uint64();
	                            break;
	                        case 11:
	                            m.chunksCommittedOutOfOrder = r.uint64();
	                            break;
	                        case 4:
	                            m.writeWrapCount = r.uint64();
	                            break;
	                        case 5:
	                            m.patchesSucceeded = r.uint64();
	                            break;
	                        case 6:
	                            m.patchesFailed = r.uint64();
	                            break;
	                        case 7:
	                            m.readaheadsSucceeded = r.uint64();
	                            break;
	                        case 8:
	                            m.readaheadsFailed = r.uint64();
	                            break;
	                        case 9:
	                            m.abiViolations = r.uint64();
	                            break;
	                        case 19:
	                            m.traceWriterPacketLoss = r.uint64();
	                            break;
	                        default:
	                            r.skipType(t & 7);
	                            break;
	                        }
	                    }
	                    return m;
	                };

	                /**
	                 * Creates a BufferStats message from a plain object. Also converts values to their respective internal types.
	                 * @function fromObject
	                 * @memberof perfetto.protos.TraceStats.BufferStats
	                 * @static
	                 * @param {Object.<string,*>} d Plain object
	                 * @returns {perfetto.protos.TraceStats.BufferStats} BufferStats
	                 */
	                BufferStats.fromObject = function fromObject(d) {
	                    if (d instanceof $root.perfetto.protos.TraceStats.BufferStats)
	                        return d;
	                    var m = new $root.perfetto.protos.TraceStats.BufferStats();
	                    if (d.bufferSize != null) {
	                        if ($util.Long)
	                            (m.bufferSize = $util.Long.fromValue(d.bufferSize)).unsigned = true;
	                        else if (typeof d.bufferSize === "string")
	                            m.bufferSize = parseInt(d.bufferSize, 10);
	                        else if (typeof d.bufferSize === "number")
	                            m.bufferSize = d.bufferSize;
	                        else if (typeof d.bufferSize === "object")
	                            m.bufferSize = new $util.LongBits(d.bufferSize.low >>> 0, d.bufferSize.high >>> 0).toNumber(true);
	                    }
	                    if (d.bytesWritten != null) {
	                        if ($util.Long)
	                            (m.bytesWritten = $util.Long.fromValue(d.bytesWritten)).unsigned = true;
	                        else if (typeof d.bytesWritten === "string")
	                            m.bytesWritten = parseInt(d.bytesWritten, 10);
	                        else if (typeof d.bytesWritten === "number")
	                            m.bytesWritten = d.bytesWritten;
	                        else if (typeof d.bytesWritten === "object")
	                            m.bytesWritten = new $util.LongBits(d.bytesWritten.low >>> 0, d.bytesWritten.high >>> 0).toNumber(true);
	                    }
	                    if (d.bytesOverwritten != null) {
	                        if ($util.Long)
	                            (m.bytesOverwritten = $util.Long.fromValue(d.bytesOverwritten)).unsigned = true;
	                        else if (typeof d.bytesOverwritten === "string")
	                            m.bytesOverwritten = parseInt(d.bytesOverwritten, 10);
	                        else if (typeof d.bytesOverwritten === "number")
	                            m.bytesOverwritten = d.bytesOverwritten;
	                        else if (typeof d.bytesOverwritten === "object")
	                            m.bytesOverwritten = new $util.LongBits(d.bytesOverwritten.low >>> 0, d.bytesOverwritten.high >>> 0).toNumber(true);
	                    }
	                    if (d.bytesRead != null) {
	                        if ($util.Long)
	                            (m.bytesRead = $util.Long.fromValue(d.bytesRead)).unsigned = true;
	                        else if (typeof d.bytesRead === "string")
	                            m.bytesRead = parseInt(d.bytesRead, 10);
	                        else if (typeof d.bytesRead === "number")
	                            m.bytesRead = d.bytesRead;
	                        else if (typeof d.bytesRead === "object")
	                            m.bytesRead = new $util.LongBits(d.bytesRead.low >>> 0, d.bytesRead.high >>> 0).toNumber(true);
	                    }
	                    if (d.paddingBytesWritten != null) {
	                        if ($util.Long)
	                            (m.paddingBytesWritten = $util.Long.fromValue(d.paddingBytesWritten)).unsigned = true;
	                        else if (typeof d.paddingBytesWritten === "string")
	                            m.paddingBytesWritten = parseInt(d.paddingBytesWritten, 10);
	                        else if (typeof d.paddingBytesWritten === "number")
	                            m.paddingBytesWritten = d.paddingBytesWritten;
	                        else if (typeof d.paddingBytesWritten === "object")
	                            m.paddingBytesWritten = new $util.LongBits(d.paddingBytesWritten.low >>> 0, d.paddingBytesWritten.high >>> 0).toNumber(true);
	                    }
	                    if (d.paddingBytesCleared != null) {
	                        if ($util.Long)
	                            (m.paddingBytesCleared = $util.Long.fromValue(d.paddingBytesCleared)).unsigned = true;
	                        else if (typeof d.paddingBytesCleared === "string")
	                            m.paddingBytesCleared = parseInt(d.paddingBytesCleared, 10);
	                        else if (typeof d.paddingBytesCleared === "number")
	                            m.paddingBytesCleared = d.paddingBytesCleared;
	                        else if (typeof d.paddingBytesCleared === "object")
	                            m.paddingBytesCleared = new $util.LongBits(d.paddingBytesCleared.low >>> 0, d.paddingBytesCleared.high >>> 0).toNumber(true);
	                    }
	                    if (d.chunksWritten != null) {
	                        if ($util.Long)
	                            (m.chunksWritten = $util.Long.fromValue(d.chunksWritten)).unsigned = true;
	                        else if (typeof d.chunksWritten === "string")
	                            m.chunksWritten = parseInt(d.chunksWritten, 10);
	                        else if (typeof d.chunksWritten === "number")
	                            m.chunksWritten = d.chunksWritten;
	                        else if (typeof d.chunksWritten === "object")
	                            m.chunksWritten = new $util.LongBits(d.chunksWritten.low >>> 0, d.chunksWritten.high >>> 0).toNumber(true);
	                    }
	                    if (d.chunksRewritten != null) {
	                        if ($util.Long)
	                            (m.chunksRewritten = $util.Long.fromValue(d.chunksRewritten)).unsigned = true;
	                        else if (typeof d.chunksRewritten === "string")
	                            m.chunksRewritten = parseInt(d.chunksRewritten, 10);
	                        else if (typeof d.chunksRewritten === "number")
	                            m.chunksRewritten = d.chunksRewritten;
	                        else if (typeof d.chunksRewritten === "object")
	                            m.chunksRewritten = new $util.LongBits(d.chunksRewritten.low >>> 0, d.chunksRewritten.high >>> 0).toNumber(true);
	                    }
	                    if (d.chunksOverwritten != null) {
	                        if ($util.Long)
	                            (m.chunksOverwritten = $util.Long.fromValue(d.chunksOverwritten)).unsigned = true;
	                        else if (typeof d.chunksOverwritten === "string")
	                            m.chunksOverwritten = parseInt(d.chunksOverwritten, 10);
	                        else if (typeof d.chunksOverwritten === "number")
	                            m.chunksOverwritten = d.chunksOverwritten;
	                        else if (typeof d.chunksOverwritten === "object")
	                            m.chunksOverwritten = new $util.LongBits(d.chunksOverwritten.low >>> 0, d.chunksOverwritten.high >>> 0).toNumber(true);
	                    }
	                    if (d.chunksDiscarded != null) {
	                        if ($util.Long)
	                            (m.chunksDiscarded = $util.Long.fromValue(d.chunksDiscarded)).unsigned = true;
	                        else if (typeof d.chunksDiscarded === "string")
	                            m.chunksDiscarded = parseInt(d.chunksDiscarded, 10);
	                        else if (typeof d.chunksDiscarded === "number")
	                            m.chunksDiscarded = d.chunksDiscarded;
	                        else if (typeof d.chunksDiscarded === "object")
	                            m.chunksDiscarded = new $util.LongBits(d.chunksDiscarded.low >>> 0, d.chunksDiscarded.high >>> 0).toNumber(true);
	                    }
	                    if (d.chunksRead != null) {
	                        if ($util.Long)
	                            (m.chunksRead = $util.Long.fromValue(d.chunksRead)).unsigned = true;
	                        else if (typeof d.chunksRead === "string")
	                            m.chunksRead = parseInt(d.chunksRead, 10);
	                        else if (typeof d.chunksRead === "number")
	                            m.chunksRead = d.chunksRead;
	                        else if (typeof d.chunksRead === "object")
	                            m.chunksRead = new $util.LongBits(d.chunksRead.low >>> 0, d.chunksRead.high >>> 0).toNumber(true);
	                    }
	                    if (d.chunksCommittedOutOfOrder != null) {
	                        if ($util.Long)
	                            (m.chunksCommittedOutOfOrder = $util.Long.fromValue(d.chunksCommittedOutOfOrder)).unsigned = true;
	                        else if (typeof d.chunksCommittedOutOfOrder === "string")
	                            m.chunksCommittedOutOfOrder = parseInt(d.chunksCommittedOutOfOrder, 10);
	                        else if (typeof d.chunksCommittedOutOfOrder === "number")
	                            m.chunksCommittedOutOfOrder = d.chunksCommittedOutOfOrder;
	                        else if (typeof d.chunksCommittedOutOfOrder === "object")
	                            m.chunksCommittedOutOfOrder = new $util.LongBits(d.chunksCommittedOutOfOrder.low >>> 0, d.chunksCommittedOutOfOrder.high >>> 0).toNumber(true);
	                    }
	                    if (d.writeWrapCount != null) {
	                        if ($util.Long)
	                            (m.writeWrapCount = $util.Long.fromValue(d.writeWrapCount)).unsigned = true;
	                        else if (typeof d.writeWrapCount === "string")
	                            m.writeWrapCount = parseInt(d.writeWrapCount, 10);
	                        else if (typeof d.writeWrapCount === "number")
	                            m.writeWrapCount = d.writeWrapCount;
	                        else if (typeof d.writeWrapCount === "object")
	                            m.writeWrapCount = new $util.LongBits(d.writeWrapCount.low >>> 0, d.writeWrapCount.high >>> 0).toNumber(true);
	                    }
	                    if (d.patchesSucceeded != null) {
	                        if ($util.Long)
	                            (m.patchesSucceeded = $util.Long.fromValue(d.patchesSucceeded)).unsigned = true;
	                        else if (typeof d.patchesSucceeded === "string")
	                            m.patchesSucceeded = parseInt(d.patchesSucceeded, 10);
	                        else if (typeof d.patchesSucceeded === "number")
	                            m.patchesSucceeded = d.patchesSucceeded;
	                        else if (typeof d.patchesSucceeded === "object")
	                            m.patchesSucceeded = new $util.LongBits(d.patchesSucceeded.low >>> 0, d.patchesSucceeded.high >>> 0).toNumber(true);
	                    }
	                    if (d.patchesFailed != null) {
	                        if ($util.Long)
	                            (m.patchesFailed = $util.Long.fromValue(d.patchesFailed)).unsigned = true;
	                        else if (typeof d.patchesFailed === "string")
	                            m.patchesFailed = parseInt(d.patchesFailed, 10);
	                        else if (typeof d.patchesFailed === "number")
	                            m.patchesFailed = d.patchesFailed;
	                        else if (typeof d.patchesFailed === "object")
	                            m.patchesFailed = new $util.LongBits(d.patchesFailed.low >>> 0, d.patchesFailed.high >>> 0).toNumber(true);
	                    }
	                    if (d.readaheadsSucceeded != null) {
	                        if ($util.Long)
	                            (m.readaheadsSucceeded = $util.Long.fromValue(d.readaheadsSucceeded)).unsigned = true;
	                        else if (typeof d.readaheadsSucceeded === "string")
	                            m.readaheadsSucceeded = parseInt(d.readaheadsSucceeded, 10);
	                        else if (typeof d.readaheadsSucceeded === "number")
	                            m.readaheadsSucceeded = d.readaheadsSucceeded;
	                        else if (typeof d.readaheadsSucceeded === "object")
	                            m.readaheadsSucceeded = new $util.LongBits(d.readaheadsSucceeded.low >>> 0, d.readaheadsSucceeded.high >>> 0).toNumber(true);
	                    }
	                    if (d.readaheadsFailed != null) {
	                        if ($util.Long)
	                            (m.readaheadsFailed = $util.Long.fromValue(d.readaheadsFailed)).unsigned = true;
	                        else if (typeof d.readaheadsFailed === "string")
	                            m.readaheadsFailed = parseInt(d.readaheadsFailed, 10);
	                        else if (typeof d.readaheadsFailed === "number")
	                            m.readaheadsFailed = d.readaheadsFailed;
	                        else if (typeof d.readaheadsFailed === "object")
	                            m.readaheadsFailed = new $util.LongBits(d.readaheadsFailed.low >>> 0, d.readaheadsFailed.high >>> 0).toNumber(true);
	                    }
	                    if (d.abiViolations != null) {
	                        if ($util.Long)
	                            (m.abiViolations = $util.Long.fromValue(d.abiViolations)).unsigned = true;
	                        else if (typeof d.abiViolations === "string")
	                            m.abiViolations = parseInt(d.abiViolations, 10);
	                        else if (typeof d.abiViolations === "number")
	                            m.abiViolations = d.abiViolations;
	                        else if (typeof d.abiViolations === "object")
	                            m.abiViolations = new $util.LongBits(d.abiViolations.low >>> 0, d.abiViolations.high >>> 0).toNumber(true);
	                    }
	                    if (d.traceWriterPacketLoss != null) {
	                        if ($util.Long)
	                            (m.traceWriterPacketLoss = $util.Long.fromValue(d.traceWriterPacketLoss)).unsigned = true;
	                        else if (typeof d.traceWriterPacketLoss === "string")
	                            m.traceWriterPacketLoss = parseInt(d.traceWriterPacketLoss, 10);
	                        else if (typeof d.traceWriterPacketLoss === "number")
	                            m.traceWriterPacketLoss = d.traceWriterPacketLoss;
	                        else if (typeof d.traceWriterPacketLoss === "object")
	                            m.traceWriterPacketLoss = new $util.LongBits(d.traceWriterPacketLoss.low >>> 0, d.traceWriterPacketLoss.high >>> 0).toNumber(true);
	                    }
	                    return m;
	                };

	                /**
	                 * Creates a plain object from a BufferStats message. Also converts values to other types if specified.
	                 * @function toObject
	                 * @memberof perfetto.protos.TraceStats.BufferStats
	                 * @static
	                 * @param {perfetto.protos.TraceStats.BufferStats} m BufferStats
	                 * @param {$protobuf.IConversionOptions} [o] Conversion options
	                 * @returns {Object.<string,*>} Plain object
	                 */
	                BufferStats.toObject = function toObject(m, o) {
	                    if (!o)
	                        o = {};
	                    var d = {};
	                    if (o.defaults) {
	                        if ($util.Long) {
	                            var n = new $util.Long(0, 0, true);
	                            d.bytesWritten = o.longs === String ? n.toString() : o.longs === Number ? n.toNumber() : n;
	                        } else
	                            d.bytesWritten = o.longs === String ? "0" : 0;
	                        if ($util.Long) {
	                            var n = new $util.Long(0, 0, true);
	                            d.chunksWritten = o.longs === String ? n.toString() : o.longs === Number ? n.toNumber() : n;
	                        } else
	                            d.chunksWritten = o.longs === String ? "0" : 0;
	                        if ($util.Long) {
	                            var n = new $util.Long(0, 0, true);
	                            d.chunksOverwritten = o.longs === String ? n.toString() : o.longs === Number ? n.toNumber() : n;
	                        } else
	                            d.chunksOverwritten = o.longs === String ? "0" : 0;
	                        if ($util.Long) {
	                            var n = new $util.Long(0, 0, true);
	                            d.writeWrapCount = o.longs === String ? n.toString() : o.longs === Number ? n.toNumber() : n;
	                        } else
	                            d.writeWrapCount = o.longs === String ? "0" : 0;
	                        if ($util.Long) {
	                            var n = new $util.Long(0, 0, true);
	                            d.patchesSucceeded = o.longs === String ? n.toString() : o.longs === Number ? n.toNumber() : n;
	                        } else
	                            d.patchesSucceeded = o.longs === String ? "0" : 0;
	                        if ($util.Long) {
	                            var n = new $util.Long(0, 0, true);
	                            d.patchesFailed = o.longs === String ? n.toString() : o.longs === Number ? n.toNumber() : n;
	                        } else
	                            d.patchesFailed = o.longs === String ? "0" : 0;
	                        if ($util.Long) {
	                            var n = new $util.Long(0, 0, true);
	                            d.readaheadsSucceeded = o.longs === String ? n.toString() : o.longs === Number ? n.toNumber() : n;
	                        } else
	                            d.readaheadsSucceeded = o.longs === String ? "0" : 0;
	                        if ($util.Long) {
	                            var n = new $util.Long(0, 0, true);
	                            d.readaheadsFailed = o.longs === String ? n.toString() : o.longs === Number ? n.toNumber() : n;
	                        } else
	                            d.readaheadsFailed = o.longs === String ? "0" : 0;
	                        if ($util.Long) {
	                            var n = new $util.Long(0, 0, true);
	                            d.abiViolations = o.longs === String ? n.toString() : o.longs === Number ? n.toNumber() : n;
	                        } else
	                            d.abiViolations = o.longs === String ? "0" : 0;
	                        if ($util.Long) {
	                            var n = new $util.Long(0, 0, true);
	                            d.chunksRewritten = o.longs === String ? n.toString() : o.longs === Number ? n.toNumber() : n;
	                        } else
	                            d.chunksRewritten = o.longs === String ? "0" : 0;
	                        if ($util.Long) {
	                            var n = new $util.Long(0, 0, true);
	                            d.chunksCommittedOutOfOrder = o.longs === String ? n.toString() : o.longs === Number ? n.toNumber() : n;
	                        } else
	                            d.chunksCommittedOutOfOrder = o.longs === String ? "0" : 0;
	                        if ($util.Long) {
	                            var n = new $util.Long(0, 0, true);
	                            d.bufferSize = o.longs === String ? n.toString() : o.longs === Number ? n.toNumber() : n;
	                        } else
	                            d.bufferSize = o.longs === String ? "0" : 0;
	                        if ($util.Long) {
	                            var n = new $util.Long(0, 0, true);
	                            d.bytesOverwritten = o.longs === String ? n.toString() : o.longs === Number ? n.toNumber() : n;
	                        } else
	                            d.bytesOverwritten = o.longs === String ? "0" : 0;
	                        if ($util.Long) {
	                            var n = new $util.Long(0, 0, true);
	                            d.bytesRead = o.longs === String ? n.toString() : o.longs === Number ? n.toNumber() : n;
	                        } else
	                            d.bytesRead = o.longs === String ? "0" : 0;
	                        if ($util.Long) {
	                            var n = new $util.Long(0, 0, true);
	                            d.paddingBytesWritten = o.longs === String ? n.toString() : o.longs === Number ? n.toNumber() : n;
	                        } else
	                            d.paddingBytesWritten = o.longs === String ? "0" : 0;
	                        if ($util.Long) {
	                            var n = new $util.Long(0, 0, true);
	                            d.paddingBytesCleared = o.longs === String ? n.toString() : o.longs === Number ? n.toNumber() : n;
	                        } else
	                            d.paddingBytesCleared = o.longs === String ? "0" : 0;
	                        if ($util.Long) {
	                            var n = new $util.Long(0, 0, true);
	                            d.chunksRead = o.longs === String ? n.toString() : o.longs === Number ? n.toNumber() : n;
	                        } else
	                            d.chunksRead = o.longs === String ? "0" : 0;
	                        if ($util.Long) {
	                            var n = new $util.Long(0, 0, true);
	                            d.chunksDiscarded = o.longs === String ? n.toString() : o.longs === Number ? n.toNumber() : n;
	                        } else
	                            d.chunksDiscarded = o.longs === String ? "0" : 0;
	                        if ($util.Long) {
	                            var n = new $util.Long(0, 0, true);
	                            d.traceWriterPacketLoss = o.longs === String ? n.toString() : o.longs === Number ? n.toNumber() : n;
	                        } else
	                            d.traceWriterPacketLoss = o.longs === String ? "0" : 0;
	                    }
	                    if (m.bytesWritten != null && m.hasOwnProperty("bytesWritten")) {
	                        if (typeof m.bytesWritten === "number")
	                            d.bytesWritten = o.longs === String ? String(m.bytesWritten) : m.bytesWritten;
	                        else
	                            d.bytesWritten = o.longs === String ? $util.Long.prototype.toString.call(m.bytesWritten) : o.longs === Number ? new $util.LongBits(m.bytesWritten.low >>> 0, m.bytesWritten.high >>> 0).toNumber(true) : m.bytesWritten;
	                    }
	                    if (m.chunksWritten != null && m.hasOwnProperty("chunksWritten")) {
	                        if (typeof m.chunksWritten === "number")
	                            d.chunksWritten = o.longs === String ? String(m.chunksWritten) : m.chunksWritten;
	                        else
	                            d.chunksWritten = o.longs === String ? $util.Long.prototype.toString.call(m.chunksWritten) : o.longs === Number ? new $util.LongBits(m.chunksWritten.low >>> 0, m.chunksWritten.high >>> 0).toNumber(true) : m.chunksWritten;
	                    }
	                    if (m.chunksOverwritten != null && m.hasOwnProperty("chunksOverwritten")) {
	                        if (typeof m.chunksOverwritten === "number")
	                            d.chunksOverwritten = o.longs === String ? String(m.chunksOverwritten) : m.chunksOverwritten;
	                        else
	                            d.chunksOverwritten = o.longs === String ? $util.Long.prototype.toString.call(m.chunksOverwritten) : o.longs === Number ? new $util.LongBits(m.chunksOverwritten.low >>> 0, m.chunksOverwritten.high >>> 0).toNumber(true) : m.chunksOverwritten;
	                    }
	                    if (m.writeWrapCount != null && m.hasOwnProperty("writeWrapCount")) {
	                        if (typeof m.writeWrapCount === "number")
	                            d.writeWrapCount = o.longs === String ? String(m.writeWrapCount) : m.writeWrapCount;
	                        else
	                            d.writeWrapCount = o.longs === String ? $util.Long.prototype.toString.call(m.writeWrapCount) : o.longs === Number ? new $util.LongBits(m.writeWrapCount.low >>> 0, m.writeWrapCount.high >>> 0).toNumber(true) : m.writeWrapCount;
	                    }
	                    if (m.patchesSucceeded != null && m.hasOwnProperty("patchesSucceeded")) {
	                        if (typeof m.patchesSucceeded === "number")
	                            d.patchesSucceeded = o.longs === String ? String(m.patchesSucceeded) : m.patchesSucceeded;
	                        else
	                            d.patchesSucceeded = o.longs === String ? $util.Long.prototype.toString.call(m.patchesSucceeded) : o.longs === Number ? new $util.LongBits(m.patchesSucceeded.low >>> 0, m.patchesSucceeded.high >>> 0).toNumber(true) : m.patchesSucceeded;
	                    }
	                    if (m.patchesFailed != null && m.hasOwnProperty("patchesFailed")) {
	                        if (typeof m.patchesFailed === "number")
	                            d.patchesFailed = o.longs === String ? String(m.patchesFailed) : m.patchesFailed;
	                        else
	                            d.patchesFailed = o.longs === String ? $util.Long.prototype.toString.call(m.patchesFailed) : o.longs === Number ? new $util.LongBits(m.patchesFailed.low >>> 0, m.patchesFailed.high >>> 0).toNumber(true) : m.patchesFailed;
	                    }
	                    if (m.readaheadsSucceeded != null && m.hasOwnProperty("readaheadsSucceeded")) {
	                        if (typeof m.readaheadsSucceeded === "number")
	                            d.readaheadsSucceeded = o.longs === String ? String(m.readaheadsSucceeded) : m.readaheadsSucceeded;
	                        else
	                            d.readaheadsSucceeded = o.longs === String ? $util.Long.prototype.toString.call(m.readaheadsSucceeded) : o.longs === Number ? new $util.LongBits(m.readaheadsSucceeded.low >>> 0, m.readaheadsSucceeded.high >>> 0).toNumber(true) : m.readaheadsSucceeded;
	                    }
	                    if (m.readaheadsFailed != null && m.hasOwnProperty("readaheadsFailed")) {
	                        if (typeof m.readaheadsFailed === "number")
	                            d.readaheadsFailed = o.longs === String ? String(m.readaheadsFailed) : m.readaheadsFailed;
	                        else
	                            d.readaheadsFailed = o.longs === String ? $util.Long.prototype.toString.call(m.readaheadsFailed) : o.longs === Number ? new $util.LongBits(m.readaheadsFailed.low >>> 0, m.readaheadsFailed.high >>> 0).toNumber(true) : m.readaheadsFailed;
	                    }
	                    if (m.abiViolations != null && m.hasOwnProperty("abiViolations")) {
	                        if (typeof m.abiViolations === "number")
	                            d.abiViolations = o.longs === String ? String(m.abiViolations) : m.abiViolations;
	                        else
	                            d.abiViolations = o.longs === String ? $util.Long.prototype.toString.call(m.abiViolations) : o.longs === Number ? new $util.LongBits(m.abiViolations.low >>> 0, m.abiViolations.high >>> 0).toNumber(true) : m.abiViolations;
	                    }
	                    if (m.chunksRewritten != null && m.hasOwnProperty("chunksRewritten")) {
	                        if (typeof m.chunksRewritten === "number")
	                            d.chunksRewritten = o.longs === String ? String(m.chunksRewritten) : m.chunksRewritten;
	                        else
	                            d.chunksRewritten = o.longs === String ? $util.Long.prototype.toString.call(m.chunksRewritten) : o.longs === Number ? new $util.LongBits(m.chunksRewritten.low >>> 0, m.chunksRewritten.high >>> 0).toNumber(true) : m.chunksRewritten;
	                    }
	                    if (m.chunksCommittedOutOfOrder != null && m.hasOwnProperty("chunksCommittedOutOfOrder")) {
	                        if (typeof m.chunksCommittedOutOfOrder === "number")
	                            d.chunksCommittedOutOfOrder = o.longs === String ? String(m.chunksCommittedOutOfOrder) : m.chunksCommittedOutOfOrder;
	                        else
	                            d.chunksCommittedOutOfOrder = o.longs === String ? $util.Long.prototype.toString.call(m.chunksCommittedOutOfOrder) : o.longs === Number ? new $util.LongBits(m.chunksCommittedOutOfOrder.low >>> 0, m.chunksCommittedOutOfOrder.high >>> 0).toNumber(true) : m.chunksCommittedOutOfOrder;
	                    }
	                    if (m.bufferSize != null && m.hasOwnProperty("bufferSize")) {
	                        if (typeof m.bufferSize === "number")
	                            d.bufferSize = o.longs === String ? String(m.bufferSize) : m.bufferSize;
	                        else
	                            d.bufferSize = o.longs === String ? $util.Long.prototype.toString.call(m.bufferSize) : o.longs === Number ? new $util.LongBits(m.bufferSize.low >>> 0, m.bufferSize.high >>> 0).toNumber(true) : m.bufferSize;
	                    }
	                    if (m.bytesOverwritten != null && m.hasOwnProperty("bytesOverwritten")) {
	                        if (typeof m.bytesOverwritten === "number")
	                            d.bytesOverwritten = o.longs === String ? String(m.bytesOverwritten) : m.bytesOverwritten;
	                        else
	                            d.bytesOverwritten = o.longs === String ? $util.Long.prototype.toString.call(m.bytesOverwritten) : o.longs === Number ? new $util.LongBits(m.bytesOverwritten.low >>> 0, m.bytesOverwritten.high >>> 0).toNumber(true) : m.bytesOverwritten;
	                    }
	                    if (m.bytesRead != null && m.hasOwnProperty("bytesRead")) {
	                        if (typeof m.bytesRead === "number")
	                            d.bytesRead = o.longs === String ? String(m.bytesRead) : m.bytesRead;
	                        else
	                            d.bytesRead = o.longs === String ? $util.Long.prototype.toString.call(m.bytesRead) : o.longs === Number ? new $util.LongBits(m.bytesRead.low >>> 0, m.bytesRead.high >>> 0).toNumber(true) : m.bytesRead;
	                    }
	                    if (m.paddingBytesWritten != null && m.hasOwnProperty("paddingBytesWritten")) {
	                        if (typeof m.paddingBytesWritten === "number")
	                            d.paddingBytesWritten = o.longs === String ? String(m.paddingBytesWritten) : m.paddingBytesWritten;
	                        else
	                            d.paddingBytesWritten = o.longs === String ? $util.Long.prototype.toString.call(m.paddingBytesWritten) : o.longs === Number ? new $util.LongBits(m.paddingBytesWritten.low >>> 0, m.paddingBytesWritten.high >>> 0).toNumber(true) : m.paddingBytesWritten;
	                    }
	                    if (m.paddingBytesCleared != null && m.hasOwnProperty("paddingBytesCleared")) {
	                        if (typeof m.paddingBytesCleared === "number")
	                            d.paddingBytesCleared = o.longs === String ? String(m.paddingBytesCleared) : m.paddingBytesCleared;
	                        else
	                            d.paddingBytesCleared = o.longs === String ? $util.Long.prototype.toString.call(m.paddingBytesCleared) : o.longs === Number ? new $util.LongBits(m.paddingBytesCleared.low >>> 0, m.paddingBytesCleared.high >>> 0).toNumber(true) : m.paddingBytesCleared;
	                    }
	                    if (m.chunksRead != null && m.hasOwnProperty("chunksRead")) {
	                        if (typeof m.chunksRead === "number")
	                            d.chunksRead = o.longs === String ? String(m.chunksRead) : m.chunksRead;
	                        else
	                            d.chunksRead = o.longs === String ? $util.Long.prototype.toString.call(m.chunksRead) : o.longs === Number ? new $util.LongBits(m.chunksRead.low >>> 0, m.chunksRead.high >>> 0).toNumber(true) : m.chunksRead;
	                    }
	                    if (m.chunksDiscarded != null && m.hasOwnProperty("chunksDiscarded")) {
	                        if (typeof m.chunksDiscarded === "number")
	                            d.chunksDiscarded = o.longs === String ? String(m.chunksDiscarded) : m.chunksDiscarded;
	                        else
	                            d.chunksDiscarded = o.longs === String ? $util.Long.prototype.toString.call(m.chunksDiscarded) : o.longs === Number ? new $util.LongBits(m.chunksDiscarded.low >>> 0, m.chunksDiscarded.high >>> 0).toNumber(true) : m.chunksDiscarded;
	                    }
	                    if (m.traceWriterPacketLoss != null && m.hasOwnProperty("traceWriterPacketLoss")) {
	                        if (typeof m.traceWriterPacketLoss === "number")
	                            d.traceWriterPacketLoss = o.longs === String ? String(m.traceWriterPacketLoss) : m.traceWriterPacketLoss;
	                        else
	                            d.traceWriterPacketLoss = o.longs === String ? $util.Long.prototype.toString.call(m.traceWriterPacketLoss) : o.longs === Number ? new $util.LongBits(m.traceWriterPacketLoss.low >>> 0, m.traceWriterPacketLoss.high >>> 0).toNumber(true) : m.traceWriterPacketLoss;
	                    }
	                    return d;
	                };

	                /**
	                 * Converts this BufferStats to JSON.
	                 * @function toJSON
	                 * @memberof perfetto.protos.TraceStats.BufferStats
	                 * @instance
	                 * @returns {Object.<string,*>} JSON object
	                 */
	                BufferStats.prototype.toJSON = function toJSON() {
	                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
	                };

	                return BufferStats;
	            })();

	            TraceStats.WriterStats = (function() {

	                /**
	                 * Properties of a WriterStats.
	                 * @memberof perfetto.protos.TraceStats
	                 * @interface IWriterStats
	                 * @property {number|null} [sequenceId] WriterStats sequenceId
	                 * @property {Array.<number>|null} [chunkPayloadHistogramCounts] WriterStats chunkPayloadHistogramCounts
	                 * @property {Array.<number>|null} [chunkPayloadHistogramSum] WriterStats chunkPayloadHistogramSum
	                 */

	                /**
	                 * Constructs a new WriterStats.
	                 * @memberof perfetto.protos.TraceStats
	                 * @classdesc Represents a WriterStats.
	                 * @implements IWriterStats
	                 * @constructor
	                 * @param {perfetto.protos.TraceStats.IWriterStats=} [p] Properties to set
	                 */
	                function WriterStats(p) {
	                    this.chunkPayloadHistogramCounts = [];
	                    this.chunkPayloadHistogramSum = [];
	                    if (p)
	                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
	                            if (p[ks[i]] != null)
	                                this[ks[i]] = p[ks[i]];
	                }

	                /**
	                 * WriterStats sequenceId.
	                 * @member {number} sequenceId
	                 * @memberof perfetto.protos.TraceStats.WriterStats
	                 * @instance
	                 */
	                WriterStats.prototype.sequenceId = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

	                /**
	                 * WriterStats chunkPayloadHistogramCounts.
	                 * @member {Array.<number>} chunkPayloadHistogramCounts
	                 * @memberof perfetto.protos.TraceStats.WriterStats
	                 * @instance
	                 */
	                WriterStats.prototype.chunkPayloadHistogramCounts = $util.emptyArray;

	                /**
	                 * WriterStats chunkPayloadHistogramSum.
	                 * @member {Array.<number>} chunkPayloadHistogramSum
	                 * @memberof perfetto.protos.TraceStats.WriterStats
	                 * @instance
	                 */
	                WriterStats.prototype.chunkPayloadHistogramSum = $util.emptyArray;

	                /**
	                 * Creates a new WriterStats instance using the specified properties.
	                 * @function create
	                 * @memberof perfetto.protos.TraceStats.WriterStats
	                 * @static
	                 * @param {perfetto.protos.TraceStats.IWriterStats=} [properties] Properties to set
	                 * @returns {perfetto.protos.TraceStats.WriterStats} WriterStats instance
	                 */
	                WriterStats.create = function create(properties) {
	                    return new WriterStats(properties);
	                };

	                /**
	                 * Encodes the specified WriterStats message. Does not implicitly {@link perfetto.protos.TraceStats.WriterStats.verify|verify} messages.
	                 * @function encode
	                 * @memberof perfetto.protos.TraceStats.WriterStats
	                 * @static
	                 * @param {perfetto.protos.TraceStats.IWriterStats} m WriterStats message or plain object to encode
	                 * @param {$protobuf.Writer} [w] Writer to encode to
	                 * @returns {$protobuf.Writer} Writer
	                 */
	                WriterStats.encode = function encode(m, w) {
	                    if (!w)
	                        w = $Writer.create();
	                    if (m.sequenceId != null && Object.hasOwnProperty.call(m, "sequenceId"))
	                        w.uint32(8).uint64(m.sequenceId);
	                    if (m.chunkPayloadHistogramCounts != null && m.chunkPayloadHistogramCounts.length) {
	                        w.uint32(18).fork();
	                        for (var i = 0; i < m.chunkPayloadHistogramCounts.length; ++i)
	                            w.uint64(m.chunkPayloadHistogramCounts[i]);
	                        w.ldelim();
	                    }
	                    if (m.chunkPayloadHistogramSum != null && m.chunkPayloadHistogramSum.length) {
	                        w.uint32(26).fork();
	                        for (var i = 0; i < m.chunkPayloadHistogramSum.length; ++i)
	                            w.int64(m.chunkPayloadHistogramSum[i]);
	                        w.ldelim();
	                    }
	                    return w;
	                };

	                /**
	                 * Decodes a WriterStats message from the specified reader or buffer.
	                 * @function decode
	                 * @memberof perfetto.protos.TraceStats.WriterStats
	                 * @static
	                 * @param {$protobuf.Reader|Uint8Array} r Reader or buffer to decode from
	                 * @param {number} [l] Message length if known beforehand
	                 * @returns {perfetto.protos.TraceStats.WriterStats} WriterStats
	                 * @throws {Error} If the payload is not a reader or valid buffer
	                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
	                 */
	                WriterStats.decode = function decode(r, l) {
	                    if (!(r instanceof $Reader))
	                        r = $Reader.create(r);
	                    var c = l === undefined ? r.len : r.pos + l, m = new $root.perfetto.protos.TraceStats.WriterStats();
	                    while (r.pos < c) {
	                        var t = r.uint32();
	                        switch (t >>> 3) {
	                        case 1:
	                            m.sequenceId = r.uint64();
	                            break;
	                        case 2:
	                            if (!(m.chunkPayloadHistogramCounts && m.chunkPayloadHistogramCounts.length))
	                                m.chunkPayloadHistogramCounts = [];
	                            if ((t & 7) === 2) {
	                                var c2 = r.uint32() + r.pos;
	                                while (r.pos < c2)
	                                    m.chunkPayloadHistogramCounts.push(r.uint64());
	                            } else
	                                m.chunkPayloadHistogramCounts.push(r.uint64());
	                            break;
	                        case 3:
	                            if (!(m.chunkPayloadHistogramSum && m.chunkPayloadHistogramSum.length))
	                                m.chunkPayloadHistogramSum = [];
	                            if ((t & 7) === 2) {
	                                var c2 = r.uint32() + r.pos;
	                                while (r.pos < c2)
	                                    m.chunkPayloadHistogramSum.push(r.int64());
	                            } else
	                                m.chunkPayloadHistogramSum.push(r.int64());
	                            break;
	                        default:
	                            r.skipType(t & 7);
	                            break;
	                        }
	                    }
	                    return m;
	                };

	                /**
	                 * Creates a WriterStats message from a plain object. Also converts values to their respective internal types.
	                 * @function fromObject
	                 * @memberof perfetto.protos.TraceStats.WriterStats
	                 * @static
	                 * @param {Object.<string,*>} d Plain object
	                 * @returns {perfetto.protos.TraceStats.WriterStats} WriterStats
	                 */
	                WriterStats.fromObject = function fromObject(d) {
	                    if (d instanceof $root.perfetto.protos.TraceStats.WriterStats)
	                        return d;
	                    var m = new $root.perfetto.protos.TraceStats.WriterStats();
	                    if (d.sequenceId != null) {
	                        if ($util.Long)
	                            (m.sequenceId = $util.Long.fromValue(d.sequenceId)).unsigned = true;
	                        else if (typeof d.sequenceId === "string")
	                            m.sequenceId = parseInt(d.sequenceId, 10);
	                        else if (typeof d.sequenceId === "number")
	                            m.sequenceId = d.sequenceId;
	                        else if (typeof d.sequenceId === "object")
	                            m.sequenceId = new $util.LongBits(d.sequenceId.low >>> 0, d.sequenceId.high >>> 0).toNumber(true);
	                    }
	                    if (d.chunkPayloadHistogramCounts) {
	                        if (!Array.isArray(d.chunkPayloadHistogramCounts))
	                            throw TypeError(".perfetto.protos.TraceStats.WriterStats.chunkPayloadHistogramCounts: array expected");
	                        m.chunkPayloadHistogramCounts = [];
	                        for (var i = 0; i < d.chunkPayloadHistogramCounts.length; ++i) {
	                            if ($util.Long)
	                                (m.chunkPayloadHistogramCounts[i] = $util.Long.fromValue(d.chunkPayloadHistogramCounts[i])).unsigned = true;
	                            else if (typeof d.chunkPayloadHistogramCounts[i] === "string")
	                                m.chunkPayloadHistogramCounts[i] = parseInt(d.chunkPayloadHistogramCounts[i], 10);
	                            else if (typeof d.chunkPayloadHistogramCounts[i] === "number")
	                                m.chunkPayloadHistogramCounts[i] = d.chunkPayloadHistogramCounts[i];
	                            else if (typeof d.chunkPayloadHistogramCounts[i] === "object")
	                                m.chunkPayloadHistogramCounts[i] = new $util.LongBits(d.chunkPayloadHistogramCounts[i].low >>> 0, d.chunkPayloadHistogramCounts[i].high >>> 0).toNumber(true);
	                        }
	                    }
	                    if (d.chunkPayloadHistogramSum) {
	                        if (!Array.isArray(d.chunkPayloadHistogramSum))
	                            throw TypeError(".perfetto.protos.TraceStats.WriterStats.chunkPayloadHistogramSum: array expected");
	                        m.chunkPayloadHistogramSum = [];
	                        for (var i = 0; i < d.chunkPayloadHistogramSum.length; ++i) {
	                            if ($util.Long)
	                                (m.chunkPayloadHistogramSum[i] = $util.Long.fromValue(d.chunkPayloadHistogramSum[i])).unsigned = false;
	                            else if (typeof d.chunkPayloadHistogramSum[i] === "string")
	                                m.chunkPayloadHistogramSum[i] = parseInt(d.chunkPayloadHistogramSum[i], 10);
	                            else if (typeof d.chunkPayloadHistogramSum[i] === "number")
	                                m.chunkPayloadHistogramSum[i] = d.chunkPayloadHistogramSum[i];
	                            else if (typeof d.chunkPayloadHistogramSum[i] === "object")
	                                m.chunkPayloadHistogramSum[i] = new $util.LongBits(d.chunkPayloadHistogramSum[i].low >>> 0, d.chunkPayloadHistogramSum[i].high >>> 0).toNumber();
	                        }
	                    }
	                    return m;
	                };

	                /**
	                 * Creates a plain object from a WriterStats message. Also converts values to other types if specified.
	                 * @function toObject
	                 * @memberof perfetto.protos.TraceStats.WriterStats
	                 * @static
	                 * @param {perfetto.protos.TraceStats.WriterStats} m WriterStats
	                 * @param {$protobuf.IConversionOptions} [o] Conversion options
	                 * @returns {Object.<string,*>} Plain object
	                 */
	                WriterStats.toObject = function toObject(m, o) {
	                    if (!o)
	                        o = {};
	                    var d = {};
	                    if (o.arrays || o.defaults) {
	                        d.chunkPayloadHistogramCounts = [];
	                        d.chunkPayloadHistogramSum = [];
	                    }
	                    if (o.defaults) {
	                        if ($util.Long) {
	                            var n = new $util.Long(0, 0, true);
	                            d.sequenceId = o.longs === String ? n.toString() : o.longs === Number ? n.toNumber() : n;
	                        } else
	                            d.sequenceId = o.longs === String ? "0" : 0;
	                    }
	                    if (m.sequenceId != null && m.hasOwnProperty("sequenceId")) {
	                        if (typeof m.sequenceId === "number")
	                            d.sequenceId = o.longs === String ? String(m.sequenceId) : m.sequenceId;
	                        else
	                            d.sequenceId = o.longs === String ? $util.Long.prototype.toString.call(m.sequenceId) : o.longs === Number ? new $util.LongBits(m.sequenceId.low >>> 0, m.sequenceId.high >>> 0).toNumber(true) : m.sequenceId;
	                    }
	                    if (m.chunkPayloadHistogramCounts && m.chunkPayloadHistogramCounts.length) {
	                        d.chunkPayloadHistogramCounts = [];
	                        for (var j = 0; j < m.chunkPayloadHistogramCounts.length; ++j) {
	                            if (typeof m.chunkPayloadHistogramCounts[j] === "number")
	                                d.chunkPayloadHistogramCounts[j] = o.longs === String ? String(m.chunkPayloadHistogramCounts[j]) : m.chunkPayloadHistogramCounts[j];
	                            else
	                                d.chunkPayloadHistogramCounts[j] = o.longs === String ? $util.Long.prototype.toString.call(m.chunkPayloadHistogramCounts[j]) : o.longs === Number ? new $util.LongBits(m.chunkPayloadHistogramCounts[j].low >>> 0, m.chunkPayloadHistogramCounts[j].high >>> 0).toNumber(true) : m.chunkPayloadHistogramCounts[j];
	                        }
	                    }
	                    if (m.chunkPayloadHistogramSum && m.chunkPayloadHistogramSum.length) {
	                        d.chunkPayloadHistogramSum = [];
	                        for (var j = 0; j < m.chunkPayloadHistogramSum.length; ++j) {
	                            if (typeof m.chunkPayloadHistogramSum[j] === "number")
	                                d.chunkPayloadHistogramSum[j] = o.longs === String ? String(m.chunkPayloadHistogramSum[j]) : m.chunkPayloadHistogramSum[j];
	                            else
	                                d.chunkPayloadHistogramSum[j] = o.longs === String ? $util.Long.prototype.toString.call(m.chunkPayloadHistogramSum[j]) : o.longs === Number ? new $util.LongBits(m.chunkPayloadHistogramSum[j].low >>> 0, m.chunkPayloadHistogramSum[j].high >>> 0).toNumber() : m.chunkPayloadHistogramSum[j];
	                        }
	                    }
	                    return d;
	                };

	                /**
	                 * Converts this WriterStats to JSON.
	                 * @function toJSON
	                 * @memberof perfetto.protos.TraceStats.WriterStats
	                 * @instance
	                 * @returns {Object.<string,*>} JSON object
	                 */
	                WriterStats.prototype.toJSON = function toJSON() {
	                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
	                };

	                return WriterStats;
	            })();

	            TraceStats.FilterStats = (function() {

	                /**
	                 * Properties of a FilterStats.
	                 * @memberof perfetto.protos.TraceStats
	                 * @interface IFilterStats
	                 * @property {number|null} [inputPackets] FilterStats inputPackets
	                 * @property {number|null} [inputBytes] FilterStats inputBytes
	                 * @property {number|null} [outputBytes] FilterStats outputBytes
	                 * @property {number|null} [errors] FilterStats errors
	                 */

	                /**
	                 * Constructs a new FilterStats.
	                 * @memberof perfetto.protos.TraceStats
	                 * @classdesc Represents a FilterStats.
	                 * @implements IFilterStats
	                 * @constructor
	                 * @param {perfetto.protos.TraceStats.IFilterStats=} [p] Properties to set
	                 */
	                function FilterStats(p) {
	                    if (p)
	                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
	                            if (p[ks[i]] != null)
	                                this[ks[i]] = p[ks[i]];
	                }

	                /**
	                 * FilterStats inputPackets.
	                 * @member {number} inputPackets
	                 * @memberof perfetto.protos.TraceStats.FilterStats
	                 * @instance
	                 */
	                FilterStats.prototype.inputPackets = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

	                /**
	                 * FilterStats inputBytes.
	                 * @member {number} inputBytes
	                 * @memberof perfetto.protos.TraceStats.FilterStats
	                 * @instance
	                 */
	                FilterStats.prototype.inputBytes = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

	                /**
	                 * FilterStats outputBytes.
	                 * @member {number} outputBytes
	                 * @memberof perfetto.protos.TraceStats.FilterStats
	                 * @instance
	                 */
	                FilterStats.prototype.outputBytes = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

	                /**
	                 * FilterStats errors.
	                 * @member {number} errors
	                 * @memberof perfetto.protos.TraceStats.FilterStats
	                 * @instance
	                 */
	                FilterStats.prototype.errors = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

	                /**
	                 * Creates a new FilterStats instance using the specified properties.
	                 * @function create
	                 * @memberof perfetto.protos.TraceStats.FilterStats
	                 * @static
	                 * @param {perfetto.protos.TraceStats.IFilterStats=} [properties] Properties to set
	                 * @returns {perfetto.protos.TraceStats.FilterStats} FilterStats instance
	                 */
	                FilterStats.create = function create(properties) {
	                    return new FilterStats(properties);
	                };

	                /**
	                 * Encodes the specified FilterStats message. Does not implicitly {@link perfetto.protos.TraceStats.FilterStats.verify|verify} messages.
	                 * @function encode
	                 * @memberof perfetto.protos.TraceStats.FilterStats
	                 * @static
	                 * @param {perfetto.protos.TraceStats.IFilterStats} m FilterStats message or plain object to encode
	                 * @param {$protobuf.Writer} [w] Writer to encode to
	                 * @returns {$protobuf.Writer} Writer
	                 */
	                FilterStats.encode = function encode(m, w) {
	                    if (!w)
	                        w = $Writer.create();
	                    if (m.inputPackets != null && Object.hasOwnProperty.call(m, "inputPackets"))
	                        w.uint32(8).uint64(m.inputPackets);
	                    if (m.inputBytes != null && Object.hasOwnProperty.call(m, "inputBytes"))
	                        w.uint32(16).uint64(m.inputBytes);
	                    if (m.outputBytes != null && Object.hasOwnProperty.call(m, "outputBytes"))
	                        w.uint32(24).uint64(m.outputBytes);
	                    if (m.errors != null && Object.hasOwnProperty.call(m, "errors"))
	                        w.uint32(32).uint64(m.errors);
	                    return w;
	                };

	                /**
	                 * Decodes a FilterStats message from the specified reader or buffer.
	                 * @function decode
	                 * @memberof perfetto.protos.TraceStats.FilterStats
	                 * @static
	                 * @param {$protobuf.Reader|Uint8Array} r Reader or buffer to decode from
	                 * @param {number} [l] Message length if known beforehand
	                 * @returns {perfetto.protos.TraceStats.FilterStats} FilterStats
	                 * @throws {Error} If the payload is not a reader or valid buffer
	                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
	                 */
	                FilterStats.decode = function decode(r, l) {
	                    if (!(r instanceof $Reader))
	                        r = $Reader.create(r);
	                    var c = l === undefined ? r.len : r.pos + l, m = new $root.perfetto.protos.TraceStats.FilterStats();
	                    while (r.pos < c) {
	                        var t = r.uint32();
	                        switch (t >>> 3) {
	                        case 1:
	                            m.inputPackets = r.uint64();
	                            break;
	                        case 2:
	                            m.inputBytes = r.uint64();
	                            break;
	                        case 3:
	                            m.outputBytes = r.uint64();
	                            break;
	                        case 4:
	                            m.errors = r.uint64();
	                            break;
	                        default:
	                            r.skipType(t & 7);
	                            break;
	                        }
	                    }
	                    return m;
	                };

	                /**
	                 * Creates a FilterStats message from a plain object. Also converts values to their respective internal types.
	                 * @function fromObject
	                 * @memberof perfetto.protos.TraceStats.FilterStats
	                 * @static
	                 * @param {Object.<string,*>} d Plain object
	                 * @returns {perfetto.protos.TraceStats.FilterStats} FilterStats
	                 */
	                FilterStats.fromObject = function fromObject(d) {
	                    if (d instanceof $root.perfetto.protos.TraceStats.FilterStats)
	                        return d;
	                    var m = new $root.perfetto.protos.TraceStats.FilterStats();
	                    if (d.inputPackets != null) {
	                        if ($util.Long)
	                            (m.inputPackets = $util.Long.fromValue(d.inputPackets)).unsigned = true;
	                        else if (typeof d.inputPackets === "string")
	                            m.inputPackets = parseInt(d.inputPackets, 10);
	                        else if (typeof d.inputPackets === "number")
	                            m.inputPackets = d.inputPackets;
	                        else if (typeof d.inputPackets === "object")
	                            m.inputPackets = new $util.LongBits(d.inputPackets.low >>> 0, d.inputPackets.high >>> 0).toNumber(true);
	                    }
	                    if (d.inputBytes != null) {
	                        if ($util.Long)
	                            (m.inputBytes = $util.Long.fromValue(d.inputBytes)).unsigned = true;
	                        else if (typeof d.inputBytes === "string")
	                            m.inputBytes = parseInt(d.inputBytes, 10);
	                        else if (typeof d.inputBytes === "number")
	                            m.inputBytes = d.inputBytes;
	                        else if (typeof d.inputBytes === "object")
	                            m.inputBytes = new $util.LongBits(d.inputBytes.low >>> 0, d.inputBytes.high >>> 0).toNumber(true);
	                    }
	                    if (d.outputBytes != null) {
	                        if ($util.Long)
	                            (m.outputBytes = $util.Long.fromValue(d.outputBytes)).unsigned = true;
	                        else if (typeof d.outputBytes === "string")
	                            m.outputBytes = parseInt(d.outputBytes, 10);
	                        else if (typeof d.outputBytes === "number")
	                            m.outputBytes = d.outputBytes;
	                        else if (typeof d.outputBytes === "object")
	                            m.outputBytes = new $util.LongBits(d.outputBytes.low >>> 0, d.outputBytes.high >>> 0).toNumber(true);
	                    }
	                    if (d.errors != null) {
	                        if ($util.Long)
	                            (m.errors = $util.Long.fromValue(d.errors)).unsigned = true;
	                        else if (typeof d.errors === "string")
	                            m.errors = parseInt(d.errors, 10);
	                        else if (typeof d.errors === "number")
	                            m.errors = d.errors;
	                        else if (typeof d.errors === "object")
	                            m.errors = new $util.LongBits(d.errors.low >>> 0, d.errors.high >>> 0).toNumber(true);
	                    }
	                    return m;
	                };

	                /**
	                 * Creates a plain object from a FilterStats message. Also converts values to other types if specified.
	                 * @function toObject
	                 * @memberof perfetto.protos.TraceStats.FilterStats
	                 * @static
	                 * @param {perfetto.protos.TraceStats.FilterStats} m FilterStats
	                 * @param {$protobuf.IConversionOptions} [o] Conversion options
	                 * @returns {Object.<string,*>} Plain object
	                 */
	                FilterStats.toObject = function toObject(m, o) {
	                    if (!o)
	                        o = {};
	                    var d = {};
	                    if (o.defaults) {
	                        if ($util.Long) {
	                            var n = new $util.Long(0, 0, true);
	                            d.inputPackets = o.longs === String ? n.toString() : o.longs === Number ? n.toNumber() : n;
	                        } else
	                            d.inputPackets = o.longs === String ? "0" : 0;
	                        if ($util.Long) {
	                            var n = new $util.Long(0, 0, true);
	                            d.inputBytes = o.longs === String ? n.toString() : o.longs === Number ? n.toNumber() : n;
	                        } else
	                            d.inputBytes = o.longs === String ? "0" : 0;
	                        if ($util.Long) {
	                            var n = new $util.Long(0, 0, true);
	                            d.outputBytes = o.longs === String ? n.toString() : o.longs === Number ? n.toNumber() : n;
	                        } else
	                            d.outputBytes = o.longs === String ? "0" : 0;
	                        if ($util.Long) {
	                            var n = new $util.Long(0, 0, true);
	                            d.errors = o.longs === String ? n.toString() : o.longs === Number ? n.toNumber() : n;
	                        } else
	                            d.errors = o.longs === String ? "0" : 0;
	                    }
	                    if (m.inputPackets != null && m.hasOwnProperty("inputPackets")) {
	                        if (typeof m.inputPackets === "number")
	                            d.inputPackets = o.longs === String ? String(m.inputPackets) : m.inputPackets;
	                        else
	                            d.inputPackets = o.longs === String ? $util.Long.prototype.toString.call(m.inputPackets) : o.longs === Number ? new $util.LongBits(m.inputPackets.low >>> 0, m.inputPackets.high >>> 0).toNumber(true) : m.inputPackets;
	                    }
	                    if (m.inputBytes != null && m.hasOwnProperty("inputBytes")) {
	                        if (typeof m.inputBytes === "number")
	                            d.inputBytes = o.longs === String ? String(m.inputBytes) : m.inputBytes;
	                        else
	                            d.inputBytes = o.longs === String ? $util.Long.prototype.toString.call(m.inputBytes) : o.longs === Number ? new $util.LongBits(m.inputBytes.low >>> 0, m.inputBytes.high >>> 0).toNumber(true) : m.inputBytes;
	                    }
	                    if (m.outputBytes != null && m.hasOwnProperty("outputBytes")) {
	                        if (typeof m.outputBytes === "number")
	                            d.outputBytes = o.longs === String ? String(m.outputBytes) : m.outputBytes;
	                        else
	                            d.outputBytes = o.longs === String ? $util.Long.prototype.toString.call(m.outputBytes) : o.longs === Number ? new $util.LongBits(m.outputBytes.low >>> 0, m.outputBytes.high >>> 0).toNumber(true) : m.outputBytes;
	                    }
	                    if (m.errors != null && m.hasOwnProperty("errors")) {
	                        if (typeof m.errors === "number")
	                            d.errors = o.longs === String ? String(m.errors) : m.errors;
	                        else
	                            d.errors = o.longs === String ? $util.Long.prototype.toString.call(m.errors) : o.longs === Number ? new $util.LongBits(m.errors.low >>> 0, m.errors.high >>> 0).toNumber(true) : m.errors;
	                    }
	                    return d;
	                };

	                /**
	                 * Converts this FilterStats to JSON.
	                 * @function toJSON
	                 * @memberof perfetto.protos.TraceStats.FilterStats
	                 * @instance
	                 * @returns {Object.<string,*>} JSON object
	                 */
	                FilterStats.prototype.toJSON = function toJSON() {
	                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
	                };

	                return FilterStats;
	            })();

	            /**
	             * FinalFlushOutcome enum.
	             * @name perfetto.protos.TraceStats.FinalFlushOutcome
	             * @enum {number}
	             * @property {number} FINAL_FLUSH_UNSPECIFIED=0 FINAL_FLUSH_UNSPECIFIED value
	             * @property {number} FINAL_FLUSH_SUCCEEDED=1 FINAL_FLUSH_SUCCEEDED value
	             * @property {number} FINAL_FLUSH_FAILED=2 FINAL_FLUSH_FAILED value
	             */
	            TraceStats.FinalFlushOutcome = (function() {
	                var valuesById = {}, values = Object.create(valuesById);
	                values[valuesById[0] = "FINAL_FLUSH_UNSPECIFIED"] = 0;
	                values[valuesById[1] = "FINAL_FLUSH_SUCCEEDED"] = 1;
	                values[valuesById[2] = "FINAL_FLUSH_FAILED"] = 2;
	                return values;
	            })();

	            return TraceStats;
	        })();

	        protos.TracingServiceCapabilities = (function() {

	            /**
	             * Properties of a TracingServiceCapabilities.
	             * @memberof perfetto.protos
	             * @interface ITracingServiceCapabilities
	             * @property {boolean|null} [hasQueryCapabilities] TracingServiceCapabilities hasQueryCapabilities
	             * @property {Array.<perfetto.protos.ObservableEvents.Type>|null} [observableEvents] TracingServiceCapabilities observableEvents
	             * @property {boolean|null} [hasTraceConfigOutputPath] TracingServiceCapabilities hasTraceConfigOutputPath
	             */

	            /**
	             * Constructs a new TracingServiceCapabilities.
	             * @memberof perfetto.protos
	             * @classdesc Represents a TracingServiceCapabilities.
	             * @implements ITracingServiceCapabilities
	             * @constructor
	             * @param {perfetto.protos.ITracingServiceCapabilities=} [p] Properties to set
	             */
	            function TracingServiceCapabilities(p) {
	                this.observableEvents = [];
	                if (p)
	                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
	                        if (p[ks[i]] != null)
	                            this[ks[i]] = p[ks[i]];
	            }

	            /**
	             * TracingServiceCapabilities hasQueryCapabilities.
	             * @member {boolean} hasQueryCapabilities
	             * @memberof perfetto.protos.TracingServiceCapabilities
	             * @instance
	             */
	            TracingServiceCapabilities.prototype.hasQueryCapabilities = false;

	            /**
	             * TracingServiceCapabilities observableEvents.
	             * @member {Array.<perfetto.protos.ObservableEvents.Type>} observableEvents
	             * @memberof perfetto.protos.TracingServiceCapabilities
	             * @instance
	             */
	            TracingServiceCapabilities.prototype.observableEvents = $util.emptyArray;

	            /**
	             * TracingServiceCapabilities hasTraceConfigOutputPath.
	             * @member {boolean} hasTraceConfigOutputPath
	             * @memberof perfetto.protos.TracingServiceCapabilities
	             * @instance
	             */
	            TracingServiceCapabilities.prototype.hasTraceConfigOutputPath = false;

	            /**
	             * Creates a new TracingServiceCapabilities instance using the specified properties.
	             * @function create
	             * @memberof perfetto.protos.TracingServiceCapabilities
	             * @static
	             * @param {perfetto.protos.ITracingServiceCapabilities=} [properties] Properties to set
	             * @returns {perfetto.protos.TracingServiceCapabilities} TracingServiceCapabilities instance
	             */
	            TracingServiceCapabilities.create = function create(properties) {
	                return new TracingServiceCapabilities(properties);
	            };

	            /**
	             * Encodes the specified TracingServiceCapabilities message. Does not implicitly {@link perfetto.protos.TracingServiceCapabilities.verify|verify} messages.
	             * @function encode
	             * @memberof perfetto.protos.TracingServiceCapabilities
	             * @static
	             * @param {perfetto.protos.ITracingServiceCapabilities} m TracingServiceCapabilities message or plain object to encode
	             * @param {$protobuf.Writer} [w] Writer to encode to
	             * @returns {$protobuf.Writer} Writer
	             */
	            TracingServiceCapabilities.encode = function encode(m, w) {
	                if (!w)
	                    w = $Writer.create();
	                if (m.hasQueryCapabilities != null && Object.hasOwnProperty.call(m, "hasQueryCapabilities"))
	                    w.uint32(8).bool(m.hasQueryCapabilities);
	                if (m.observableEvents != null && m.observableEvents.length) {
	                    for (var i = 0; i < m.observableEvents.length; ++i)
	                        w.uint32(16).int32(m.observableEvents[i]);
	                }
	                if (m.hasTraceConfigOutputPath != null && Object.hasOwnProperty.call(m, "hasTraceConfigOutputPath"))
	                    w.uint32(24).bool(m.hasTraceConfigOutputPath);
	                return w;
	            };

	            /**
	             * Decodes a TracingServiceCapabilities message from the specified reader or buffer.
	             * @function decode
	             * @memberof perfetto.protos.TracingServiceCapabilities
	             * @static
	             * @param {$protobuf.Reader|Uint8Array} r Reader or buffer to decode from
	             * @param {number} [l] Message length if known beforehand
	             * @returns {perfetto.protos.TracingServiceCapabilities} TracingServiceCapabilities
	             * @throws {Error} If the payload is not a reader or valid buffer
	             * @throws {$protobuf.util.ProtocolError} If required fields are missing
	             */
	            TracingServiceCapabilities.decode = function decode(r, l) {
	                if (!(r instanceof $Reader))
	                    r = $Reader.create(r);
	                var c = l === undefined ? r.len : r.pos + l, m = new $root.perfetto.protos.TracingServiceCapabilities();
	                while (r.pos < c) {
	                    var t = r.uint32();
	                    switch (t >>> 3) {
	                    case 1:
	                        m.hasQueryCapabilities = r.bool();
	                        break;
	                    case 2:
	                        if (!(m.observableEvents && m.observableEvents.length))
	                            m.observableEvents = [];
	                        if ((t & 7) === 2) {
	                            var c2 = r.uint32() + r.pos;
	                            while (r.pos < c2)
	                                m.observableEvents.push(r.int32());
	                        } else
	                            m.observableEvents.push(r.int32());
	                        break;
	                    case 3:
	                        m.hasTraceConfigOutputPath = r.bool();
	                        break;
	                    default:
	                        r.skipType(t & 7);
	                        break;
	                    }
	                }
	                return m;
	            };

	            /**
	             * Creates a TracingServiceCapabilities message from a plain object. Also converts values to their respective internal types.
	             * @function fromObject
	             * @memberof perfetto.protos.TracingServiceCapabilities
	             * @static
	             * @param {Object.<string,*>} d Plain object
	             * @returns {perfetto.protos.TracingServiceCapabilities} TracingServiceCapabilities
	             */
	            TracingServiceCapabilities.fromObject = function fromObject(d) {
	                if (d instanceof $root.perfetto.protos.TracingServiceCapabilities)
	                    return d;
	                var m = new $root.perfetto.protos.TracingServiceCapabilities();
	                if (d.hasQueryCapabilities != null) {
	                    m.hasQueryCapabilities = Boolean(d.hasQueryCapabilities);
	                }
	                if (d.observableEvents) {
	                    if (!Array.isArray(d.observableEvents))
	                        throw TypeError(".perfetto.protos.TracingServiceCapabilities.observableEvents: array expected");
	                    m.observableEvents = [];
	                    for (var i = 0; i < d.observableEvents.length; ++i) {
	                        switch (d.observableEvents[i]) {
	                        default:
	                        case "TYPE_UNSPECIFIED":
	                        case 0:
	                            m.observableEvents[i] = 0;
	                            break;
	                        case "TYPE_DATA_SOURCES_INSTANCES":
	                        case 1:
	                            m.observableEvents[i] = 1;
	                            break;
	                        case "TYPE_ALL_DATA_SOURCES_STARTED":
	                        case 2:
	                            m.observableEvents[i] = 2;
	                            break;
	                        }
	                    }
	                }
	                if (d.hasTraceConfigOutputPath != null) {
	                    m.hasTraceConfigOutputPath = Boolean(d.hasTraceConfigOutputPath);
	                }
	                return m;
	            };

	            /**
	             * Creates a plain object from a TracingServiceCapabilities message. Also converts values to other types if specified.
	             * @function toObject
	             * @memberof perfetto.protos.TracingServiceCapabilities
	             * @static
	             * @param {perfetto.protos.TracingServiceCapabilities} m TracingServiceCapabilities
	             * @param {$protobuf.IConversionOptions} [o] Conversion options
	             * @returns {Object.<string,*>} Plain object
	             */
	            TracingServiceCapabilities.toObject = function toObject(m, o) {
	                if (!o)
	                    o = {};
	                var d = {};
	                if (o.arrays || o.defaults) {
	                    d.observableEvents = [];
	                }
	                if (o.defaults) {
	                    d.hasQueryCapabilities = false;
	                    d.hasTraceConfigOutputPath = false;
	                }
	                if (m.hasQueryCapabilities != null && m.hasOwnProperty("hasQueryCapabilities")) {
	                    d.hasQueryCapabilities = m.hasQueryCapabilities;
	                }
	                if (m.observableEvents && m.observableEvents.length) {
	                    d.observableEvents = [];
	                    for (var j = 0; j < m.observableEvents.length; ++j) {
	                        d.observableEvents[j] = o.enums === String ? $root.perfetto.protos.ObservableEvents.Type[m.observableEvents[j]] : m.observableEvents[j];
	                    }
	                }
	                if (m.hasTraceConfigOutputPath != null && m.hasOwnProperty("hasTraceConfigOutputPath")) {
	                    d.hasTraceConfigOutputPath = m.hasTraceConfigOutputPath;
	                }
	                return d;
	            };

	            /**
	             * Converts this TracingServiceCapabilities to JSON.
	             * @function toJSON
	             * @memberof perfetto.protos.TracingServiceCapabilities
	             * @instance
	             * @returns {Object.<string,*>} JSON object
	             */
	            TracingServiceCapabilities.prototype.toJSON = function toJSON() {
	                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
	            };

	            return TracingServiceCapabilities;
	        })();

	        protos.ObservableEvents = (function() {

	            /**
	             * Properties of an ObservableEvents.
	             * @memberof perfetto.protos
	             * @interface IObservableEvents
	             * @property {Array.<perfetto.protos.ObservableEvents.IDataSourceInstanceStateChange>|null} [instanceStateChanges] ObservableEvents instanceStateChanges
	             * @property {boolean|null} [allDataSourcesStarted] ObservableEvents allDataSourcesStarted
	             */

	            /**
	             * Constructs a new ObservableEvents.
	             * @memberof perfetto.protos
	             * @classdesc Represents an ObservableEvents.
	             * @implements IObservableEvents
	             * @constructor
	             * @param {perfetto.protos.IObservableEvents=} [p] Properties to set
	             */
	            function ObservableEvents(p) {
	                this.instanceStateChanges = [];
	                if (p)
	                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
	                        if (p[ks[i]] != null)
	                            this[ks[i]] = p[ks[i]];
	            }

	            /**
	             * ObservableEvents instanceStateChanges.
	             * @member {Array.<perfetto.protos.ObservableEvents.IDataSourceInstanceStateChange>} instanceStateChanges
	             * @memberof perfetto.protos.ObservableEvents
	             * @instance
	             */
	            ObservableEvents.prototype.instanceStateChanges = $util.emptyArray;

	            /**
	             * ObservableEvents allDataSourcesStarted.
	             * @member {boolean} allDataSourcesStarted
	             * @memberof perfetto.protos.ObservableEvents
	             * @instance
	             */
	            ObservableEvents.prototype.allDataSourcesStarted = false;

	            /**
	             * Creates a new ObservableEvents instance using the specified properties.
	             * @function create
	             * @memberof perfetto.protos.ObservableEvents
	             * @static
	             * @param {perfetto.protos.IObservableEvents=} [properties] Properties to set
	             * @returns {perfetto.protos.ObservableEvents} ObservableEvents instance
	             */
	            ObservableEvents.create = function create(properties) {
	                return new ObservableEvents(properties);
	            };

	            /**
	             * Encodes the specified ObservableEvents message. Does not implicitly {@link perfetto.protos.ObservableEvents.verify|verify} messages.
	             * @function encode
	             * @memberof perfetto.protos.ObservableEvents
	             * @static
	             * @param {perfetto.protos.IObservableEvents} m ObservableEvents message or plain object to encode
	             * @param {$protobuf.Writer} [w] Writer to encode to
	             * @returns {$protobuf.Writer} Writer
	             */
	            ObservableEvents.encode = function encode(m, w) {
	                if (!w)
	                    w = $Writer.create();
	                if (m.instanceStateChanges != null && m.instanceStateChanges.length) {
	                    for (var i = 0; i < m.instanceStateChanges.length; ++i)
	                        $root.perfetto.protos.ObservableEvents.DataSourceInstanceStateChange.encode(m.instanceStateChanges[i], w.uint32(10).fork()).ldelim();
	                }
	                if (m.allDataSourcesStarted != null && Object.hasOwnProperty.call(m, "allDataSourcesStarted"))
	                    w.uint32(16).bool(m.allDataSourcesStarted);
	                return w;
	            };

	            /**
	             * Decodes an ObservableEvents message from the specified reader or buffer.
	             * @function decode
	             * @memberof perfetto.protos.ObservableEvents
	             * @static
	             * @param {$protobuf.Reader|Uint8Array} r Reader or buffer to decode from
	             * @param {number} [l] Message length if known beforehand
	             * @returns {perfetto.protos.ObservableEvents} ObservableEvents
	             * @throws {Error} If the payload is not a reader or valid buffer
	             * @throws {$protobuf.util.ProtocolError} If required fields are missing
	             */
	            ObservableEvents.decode = function decode(r, l) {
	                if (!(r instanceof $Reader))
	                    r = $Reader.create(r);
	                var c = l === undefined ? r.len : r.pos + l, m = new $root.perfetto.protos.ObservableEvents();
	                while (r.pos < c) {
	                    var t = r.uint32();
	                    switch (t >>> 3) {
	                    case 1:
	                        if (!(m.instanceStateChanges && m.instanceStateChanges.length))
	                            m.instanceStateChanges = [];
	                        m.instanceStateChanges.push($root.perfetto.protos.ObservableEvents.DataSourceInstanceStateChange.decode(r, r.uint32()));
	                        break;
	                    case 2:
	                        m.allDataSourcesStarted = r.bool();
	                        break;
	                    default:
	                        r.skipType(t & 7);
	                        break;
	                    }
	                }
	                return m;
	            };

	            /**
	             * Creates an ObservableEvents message from a plain object. Also converts values to their respective internal types.
	             * @function fromObject
	             * @memberof perfetto.protos.ObservableEvents
	             * @static
	             * @param {Object.<string,*>} d Plain object
	             * @returns {perfetto.protos.ObservableEvents} ObservableEvents
	             */
	            ObservableEvents.fromObject = function fromObject(d) {
	                if (d instanceof $root.perfetto.protos.ObservableEvents)
	                    return d;
	                var m = new $root.perfetto.protos.ObservableEvents();
	                if (d.instanceStateChanges) {
	                    if (!Array.isArray(d.instanceStateChanges))
	                        throw TypeError(".perfetto.protos.ObservableEvents.instanceStateChanges: array expected");
	                    m.instanceStateChanges = [];
	                    for (var i = 0; i < d.instanceStateChanges.length; ++i) {
	                        if (typeof d.instanceStateChanges[i] !== "object")
	                            throw TypeError(".perfetto.protos.ObservableEvents.instanceStateChanges: object expected");
	                        m.instanceStateChanges[i] = $root.perfetto.protos.ObservableEvents.DataSourceInstanceStateChange.fromObject(d.instanceStateChanges[i]);
	                    }
	                }
	                if (d.allDataSourcesStarted != null) {
	                    m.allDataSourcesStarted = Boolean(d.allDataSourcesStarted);
	                }
	                return m;
	            };

	            /**
	             * Creates a plain object from an ObservableEvents message. Also converts values to other types if specified.
	             * @function toObject
	             * @memberof perfetto.protos.ObservableEvents
	             * @static
	             * @param {perfetto.protos.ObservableEvents} m ObservableEvents
	             * @param {$protobuf.IConversionOptions} [o] Conversion options
	             * @returns {Object.<string,*>} Plain object
	             */
	            ObservableEvents.toObject = function toObject(m, o) {
	                if (!o)
	                    o = {};
	                var d = {};
	                if (o.arrays || o.defaults) {
	                    d.instanceStateChanges = [];
	                }
	                if (o.defaults) {
	                    d.allDataSourcesStarted = false;
	                }
	                if (m.instanceStateChanges && m.instanceStateChanges.length) {
	                    d.instanceStateChanges = [];
	                    for (var j = 0; j < m.instanceStateChanges.length; ++j) {
	                        d.instanceStateChanges[j] = $root.perfetto.protos.ObservableEvents.DataSourceInstanceStateChange.toObject(m.instanceStateChanges[j], o);
	                    }
	                }
	                if (m.allDataSourcesStarted != null && m.hasOwnProperty("allDataSourcesStarted")) {
	                    d.allDataSourcesStarted = m.allDataSourcesStarted;
	                }
	                return d;
	            };

	            /**
	             * Converts this ObservableEvents to JSON.
	             * @function toJSON
	             * @memberof perfetto.protos.ObservableEvents
	             * @instance
	             * @returns {Object.<string,*>} JSON object
	             */
	            ObservableEvents.prototype.toJSON = function toJSON() {
	                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
	            };

	            /**
	             * Type enum.
	             * @name perfetto.protos.ObservableEvents.Type
	             * @enum {number}
	             * @property {number} TYPE_UNSPECIFIED=0 TYPE_UNSPECIFIED value
	             * @property {number} TYPE_DATA_SOURCES_INSTANCES=1 TYPE_DATA_SOURCES_INSTANCES value
	             * @property {number} TYPE_ALL_DATA_SOURCES_STARTED=2 TYPE_ALL_DATA_SOURCES_STARTED value
	             */
	            ObservableEvents.Type = (function() {
	                var valuesById = {}, values = Object.create(valuesById);
	                values[valuesById[0] = "TYPE_UNSPECIFIED"] = 0;
	                values[valuesById[1] = "TYPE_DATA_SOURCES_INSTANCES"] = 1;
	                values[valuesById[2] = "TYPE_ALL_DATA_SOURCES_STARTED"] = 2;
	                return values;
	            })();

	            /**
	             * DataSourceInstanceState enum.
	             * @name perfetto.protos.ObservableEvents.DataSourceInstanceState
	             * @enum {number}
	             * @property {number} DATA_SOURCE_INSTANCE_STATE_STOPPED=1 DATA_SOURCE_INSTANCE_STATE_STOPPED value
	             * @property {number} DATA_SOURCE_INSTANCE_STATE_STARTED=2 DATA_SOURCE_INSTANCE_STATE_STARTED value
	             */
	            ObservableEvents.DataSourceInstanceState = (function() {
	                var valuesById = {}, values = Object.create(valuesById);
	                values[valuesById[1] = "DATA_SOURCE_INSTANCE_STATE_STOPPED"] = 1;
	                values[valuesById[2] = "DATA_SOURCE_INSTANCE_STATE_STARTED"] = 2;
	                return values;
	            })();

	            ObservableEvents.DataSourceInstanceStateChange = (function() {

	                /**
	                 * Properties of a DataSourceInstanceStateChange.
	                 * @memberof perfetto.protos.ObservableEvents
	                 * @interface IDataSourceInstanceStateChange
	                 * @property {string|null} [producerName] DataSourceInstanceStateChange producerName
	                 * @property {string|null} [dataSourceName] DataSourceInstanceStateChange dataSourceName
	                 * @property {perfetto.protos.ObservableEvents.DataSourceInstanceState|null} [state] DataSourceInstanceStateChange state
	                 */

	                /**
	                 * Constructs a new DataSourceInstanceStateChange.
	                 * @memberof perfetto.protos.ObservableEvents
	                 * @classdesc Represents a DataSourceInstanceStateChange.
	                 * @implements IDataSourceInstanceStateChange
	                 * @constructor
	                 * @param {perfetto.protos.ObservableEvents.IDataSourceInstanceStateChange=} [p] Properties to set
	                 */
	                function DataSourceInstanceStateChange(p) {
	                    if (p)
	                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
	                            if (p[ks[i]] != null)
	                                this[ks[i]] = p[ks[i]];
	                }

	                /**
	                 * DataSourceInstanceStateChange producerName.
	                 * @member {string} producerName
	                 * @memberof perfetto.protos.ObservableEvents.DataSourceInstanceStateChange
	                 * @instance
	                 */
	                DataSourceInstanceStateChange.prototype.producerName = "";

	                /**
	                 * DataSourceInstanceStateChange dataSourceName.
	                 * @member {string} dataSourceName
	                 * @memberof perfetto.protos.ObservableEvents.DataSourceInstanceStateChange
	                 * @instance
	                 */
	                DataSourceInstanceStateChange.prototype.dataSourceName = "";

	                /**
	                 * DataSourceInstanceStateChange state.
	                 * @member {perfetto.protos.ObservableEvents.DataSourceInstanceState} state
	                 * @memberof perfetto.protos.ObservableEvents.DataSourceInstanceStateChange
	                 * @instance
	                 */
	                DataSourceInstanceStateChange.prototype.state = 1;

	                /**
	                 * Creates a new DataSourceInstanceStateChange instance using the specified properties.
	                 * @function create
	                 * @memberof perfetto.protos.ObservableEvents.DataSourceInstanceStateChange
	                 * @static
	                 * @param {perfetto.protos.ObservableEvents.IDataSourceInstanceStateChange=} [properties] Properties to set
	                 * @returns {perfetto.protos.ObservableEvents.DataSourceInstanceStateChange} DataSourceInstanceStateChange instance
	                 */
	                DataSourceInstanceStateChange.create = function create(properties) {
	                    return new DataSourceInstanceStateChange(properties);
	                };

	                /**
	                 * Encodes the specified DataSourceInstanceStateChange message. Does not implicitly {@link perfetto.protos.ObservableEvents.DataSourceInstanceStateChange.verify|verify} messages.
	                 * @function encode
	                 * @memberof perfetto.protos.ObservableEvents.DataSourceInstanceStateChange
	                 * @static
	                 * @param {perfetto.protos.ObservableEvents.IDataSourceInstanceStateChange} m DataSourceInstanceStateChange message or plain object to encode
	                 * @param {$protobuf.Writer} [w] Writer to encode to
	                 * @returns {$protobuf.Writer} Writer
	                 */
	                DataSourceInstanceStateChange.encode = function encode(m, w) {
	                    if (!w)
	                        w = $Writer.create();
	                    if (m.producerName != null && Object.hasOwnProperty.call(m, "producerName"))
	                        w.uint32(10).string(m.producerName);
	                    if (m.dataSourceName != null && Object.hasOwnProperty.call(m, "dataSourceName"))
	                        w.uint32(18).string(m.dataSourceName);
	                    if (m.state != null && Object.hasOwnProperty.call(m, "state"))
	                        w.uint32(24).int32(m.state);
	                    return w;
	                };

	                /**
	                 * Decodes a DataSourceInstanceStateChange message from the specified reader or buffer.
	                 * @function decode
	                 * @memberof perfetto.protos.ObservableEvents.DataSourceInstanceStateChange
	                 * @static
	                 * @param {$protobuf.Reader|Uint8Array} r Reader or buffer to decode from
	                 * @param {number} [l] Message length if known beforehand
	                 * @returns {perfetto.protos.ObservableEvents.DataSourceInstanceStateChange} DataSourceInstanceStateChange
	                 * @throws {Error} If the payload is not a reader or valid buffer
	                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
	                 */
	                DataSourceInstanceStateChange.decode = function decode(r, l) {
	                    if (!(r instanceof $Reader))
	                        r = $Reader.create(r);
	                    var c = l === undefined ? r.len : r.pos + l, m = new $root.perfetto.protos.ObservableEvents.DataSourceInstanceStateChange();
	                    while (r.pos < c) {
	                        var t = r.uint32();
	                        switch (t >>> 3) {
	                        case 1:
	                            m.producerName = r.string();
	                            break;
	                        case 2:
	                            m.dataSourceName = r.string();
	                            break;
	                        case 3:
	                            m.state = r.int32();
	                            break;
	                        default:
	                            r.skipType(t & 7);
	                            break;
	                        }
	                    }
	                    return m;
	                };

	                /**
	                 * Creates a DataSourceInstanceStateChange message from a plain object. Also converts values to their respective internal types.
	                 * @function fromObject
	                 * @memberof perfetto.protos.ObservableEvents.DataSourceInstanceStateChange
	                 * @static
	                 * @param {Object.<string,*>} d Plain object
	                 * @returns {perfetto.protos.ObservableEvents.DataSourceInstanceStateChange} DataSourceInstanceStateChange
	                 */
	                DataSourceInstanceStateChange.fromObject = function fromObject(d) {
	                    if (d instanceof $root.perfetto.protos.ObservableEvents.DataSourceInstanceStateChange)
	                        return d;
	                    var m = new $root.perfetto.protos.ObservableEvents.DataSourceInstanceStateChange();
	                    if (d.producerName != null) {
	                        m.producerName = String(d.producerName);
	                    }
	                    if (d.dataSourceName != null) {
	                        m.dataSourceName = String(d.dataSourceName);
	                    }
	                    switch (d.state) {
	                    case "DATA_SOURCE_INSTANCE_STATE_STOPPED":
	                    case 1:
	                        m.state = 1;
	                        break;
	                    case "DATA_SOURCE_INSTANCE_STATE_STARTED":
	                    case 2:
	                        m.state = 2;
	                        break;
	                    }
	                    return m;
	                };

	                /**
	                 * Creates a plain object from a DataSourceInstanceStateChange message. Also converts values to other types if specified.
	                 * @function toObject
	                 * @memberof perfetto.protos.ObservableEvents.DataSourceInstanceStateChange
	                 * @static
	                 * @param {perfetto.protos.ObservableEvents.DataSourceInstanceStateChange} m DataSourceInstanceStateChange
	                 * @param {$protobuf.IConversionOptions} [o] Conversion options
	                 * @returns {Object.<string,*>} Plain object
	                 */
	                DataSourceInstanceStateChange.toObject = function toObject(m, o) {
	                    if (!o)
	                        o = {};
	                    var d = {};
	                    if (o.defaults) {
	                        d.producerName = "";
	                        d.dataSourceName = "";
	                        d.state = o.enums === String ? "DATA_SOURCE_INSTANCE_STATE_STOPPED" : 1;
	                    }
	                    if (m.producerName != null && m.hasOwnProperty("producerName")) {
	                        d.producerName = m.producerName;
	                    }
	                    if (m.dataSourceName != null && m.hasOwnProperty("dataSourceName")) {
	                        d.dataSourceName = m.dataSourceName;
	                    }
	                    if (m.state != null && m.hasOwnProperty("state")) {
	                        d.state = o.enums === String ? $root.perfetto.protos.ObservableEvents.DataSourceInstanceState[m.state] : m.state;
	                    }
	                    return d;
	                };

	                /**
	                 * Converts this DataSourceInstanceStateChange to JSON.
	                 * @function toJSON
	                 * @memberof perfetto.protos.ObservableEvents.DataSourceInstanceStateChange
	                 * @instance
	                 * @returns {Object.<string,*>} JSON object
	                 */
	                DataSourceInstanceStateChange.prototype.toJSON = function toJSON() {
	                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
	                };

	                return DataSourceInstanceStateChange;
	            })();

	            return ObservableEvents;
	        })();

	        protos.FtraceDescriptor = (function() {

	            /**
	             * Properties of a FtraceDescriptor.
	             * @memberof perfetto.protos
	             * @interface IFtraceDescriptor
	             * @property {Array.<perfetto.protos.FtraceDescriptor.IAtraceCategory>|null} [atraceCategories] FtraceDescriptor atraceCategories
	             */

	            /**
	             * Constructs a new FtraceDescriptor.
	             * @memberof perfetto.protos
	             * @classdesc Represents a FtraceDescriptor.
	             * @implements IFtraceDescriptor
	             * @constructor
	             * @param {perfetto.protos.IFtraceDescriptor=} [p] Properties to set
	             */
	            function FtraceDescriptor(p) {
	                this.atraceCategories = [];
	                if (p)
	                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
	                        if (p[ks[i]] != null)
	                            this[ks[i]] = p[ks[i]];
	            }

	            /**
	             * FtraceDescriptor atraceCategories.
	             * @member {Array.<perfetto.protos.FtraceDescriptor.IAtraceCategory>} atraceCategories
	             * @memberof perfetto.protos.FtraceDescriptor
	             * @instance
	             */
	            FtraceDescriptor.prototype.atraceCategories = $util.emptyArray;

	            /**
	             * Creates a new FtraceDescriptor instance using the specified properties.
	             * @function create
	             * @memberof perfetto.protos.FtraceDescriptor
	             * @static
	             * @param {perfetto.protos.IFtraceDescriptor=} [properties] Properties to set
	             * @returns {perfetto.protos.FtraceDescriptor} FtraceDescriptor instance
	             */
	            FtraceDescriptor.create = function create(properties) {
	                return new FtraceDescriptor(properties);
	            };

	            /**
	             * Encodes the specified FtraceDescriptor message. Does not implicitly {@link perfetto.protos.FtraceDescriptor.verify|verify} messages.
	             * @function encode
	             * @memberof perfetto.protos.FtraceDescriptor
	             * @static
	             * @param {perfetto.protos.IFtraceDescriptor} m FtraceDescriptor message or plain object to encode
	             * @param {$protobuf.Writer} [w] Writer to encode to
	             * @returns {$protobuf.Writer} Writer
	             */
	            FtraceDescriptor.encode = function encode(m, w) {
	                if (!w)
	                    w = $Writer.create();
	                if (m.atraceCategories != null && m.atraceCategories.length) {
	                    for (var i = 0; i < m.atraceCategories.length; ++i)
	                        $root.perfetto.protos.FtraceDescriptor.AtraceCategory.encode(m.atraceCategories[i], w.uint32(10).fork()).ldelim();
	                }
	                return w;
	            };

	            /**
	             * Decodes a FtraceDescriptor message from the specified reader or buffer.
	             * @function decode
	             * @memberof perfetto.protos.FtraceDescriptor
	             * @static
	             * @param {$protobuf.Reader|Uint8Array} r Reader or buffer to decode from
	             * @param {number} [l] Message length if known beforehand
	             * @returns {perfetto.protos.FtraceDescriptor} FtraceDescriptor
	             * @throws {Error} If the payload is not a reader or valid buffer
	             * @throws {$protobuf.util.ProtocolError} If required fields are missing
	             */
	            FtraceDescriptor.decode = function decode(r, l) {
	                if (!(r instanceof $Reader))
	                    r = $Reader.create(r);
	                var c = l === undefined ? r.len : r.pos + l, m = new $root.perfetto.protos.FtraceDescriptor();
	                while (r.pos < c) {
	                    var t = r.uint32();
	                    switch (t >>> 3) {
	                    case 1:
	                        if (!(m.atraceCategories && m.atraceCategories.length))
	                            m.atraceCategories = [];
	                        m.atraceCategories.push($root.perfetto.protos.FtraceDescriptor.AtraceCategory.decode(r, r.uint32()));
	                        break;
	                    default:
	                        r.skipType(t & 7);
	                        break;
	                    }
	                }
	                return m;
	            };

	            /**
	             * Creates a FtraceDescriptor message from a plain object. Also converts values to their respective internal types.
	             * @function fromObject
	             * @memberof perfetto.protos.FtraceDescriptor
	             * @static
	             * @param {Object.<string,*>} d Plain object
	             * @returns {perfetto.protos.FtraceDescriptor} FtraceDescriptor
	             */
	            FtraceDescriptor.fromObject = function fromObject(d) {
	                if (d instanceof $root.perfetto.protos.FtraceDescriptor)
	                    return d;
	                var m = new $root.perfetto.protos.FtraceDescriptor();
	                if (d.atraceCategories) {
	                    if (!Array.isArray(d.atraceCategories))
	                        throw TypeError(".perfetto.protos.FtraceDescriptor.atraceCategories: array expected");
	                    m.atraceCategories = [];
	                    for (var i = 0; i < d.atraceCategories.length; ++i) {
	                        if (typeof d.atraceCategories[i] !== "object")
	                            throw TypeError(".perfetto.protos.FtraceDescriptor.atraceCategories: object expected");
	                        m.atraceCategories[i] = $root.perfetto.protos.FtraceDescriptor.AtraceCategory.fromObject(d.atraceCategories[i]);
	                    }
	                }
	                return m;
	            };

	            /**
	             * Creates a plain object from a FtraceDescriptor message. Also converts values to other types if specified.
	             * @function toObject
	             * @memberof perfetto.protos.FtraceDescriptor
	             * @static
	             * @param {perfetto.protos.FtraceDescriptor} m FtraceDescriptor
	             * @param {$protobuf.IConversionOptions} [o] Conversion options
	             * @returns {Object.<string,*>} Plain object
	             */
	            FtraceDescriptor.toObject = function toObject(m, o) {
	                if (!o)
	                    o = {};
	                var d = {};
	                if (o.arrays || o.defaults) {
	                    d.atraceCategories = [];
	                }
	                if (m.atraceCategories && m.atraceCategories.length) {
	                    d.atraceCategories = [];
	                    for (var j = 0; j < m.atraceCategories.length; ++j) {
	                        d.atraceCategories[j] = $root.perfetto.protos.FtraceDescriptor.AtraceCategory.toObject(m.atraceCategories[j], o);
	                    }
	                }
	                return d;
	            };

	            /**
	             * Converts this FtraceDescriptor to JSON.
	             * @function toJSON
	             * @memberof perfetto.protos.FtraceDescriptor
	             * @instance
	             * @returns {Object.<string,*>} JSON object
	             */
	            FtraceDescriptor.prototype.toJSON = function toJSON() {
	                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
	            };

	            FtraceDescriptor.AtraceCategory = (function() {

	                /**
	                 * Properties of an AtraceCategory.
	                 * @memberof perfetto.protos.FtraceDescriptor
	                 * @interface IAtraceCategory
	                 * @property {string|null} [name] AtraceCategory name
	                 * @property {string|null} [description] AtraceCategory description
	                 */

	                /**
	                 * Constructs a new AtraceCategory.
	                 * @memberof perfetto.protos.FtraceDescriptor
	                 * @classdesc Represents an AtraceCategory.
	                 * @implements IAtraceCategory
	                 * @constructor
	                 * @param {perfetto.protos.FtraceDescriptor.IAtraceCategory=} [p] Properties to set
	                 */
	                function AtraceCategory(p) {
	                    if (p)
	                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
	                            if (p[ks[i]] != null)
	                                this[ks[i]] = p[ks[i]];
	                }

	                /**
	                 * AtraceCategory name.
	                 * @member {string} name
	                 * @memberof perfetto.protos.FtraceDescriptor.AtraceCategory
	                 * @instance
	                 */
	                AtraceCategory.prototype.name = "";

	                /**
	                 * AtraceCategory description.
	                 * @member {string} description
	                 * @memberof perfetto.protos.FtraceDescriptor.AtraceCategory
	                 * @instance
	                 */
	                AtraceCategory.prototype.description = "";

	                /**
	                 * Creates a new AtraceCategory instance using the specified properties.
	                 * @function create
	                 * @memberof perfetto.protos.FtraceDescriptor.AtraceCategory
	                 * @static
	                 * @param {perfetto.protos.FtraceDescriptor.IAtraceCategory=} [properties] Properties to set
	                 * @returns {perfetto.protos.FtraceDescriptor.AtraceCategory} AtraceCategory instance
	                 */
	                AtraceCategory.create = function create(properties) {
	                    return new AtraceCategory(properties);
	                };

	                /**
	                 * Encodes the specified AtraceCategory message. Does not implicitly {@link perfetto.protos.FtraceDescriptor.AtraceCategory.verify|verify} messages.
	                 * @function encode
	                 * @memberof perfetto.protos.FtraceDescriptor.AtraceCategory
	                 * @static
	                 * @param {perfetto.protos.FtraceDescriptor.IAtraceCategory} m AtraceCategory message or plain object to encode
	                 * @param {$protobuf.Writer} [w] Writer to encode to
	                 * @returns {$protobuf.Writer} Writer
	                 */
	                AtraceCategory.encode = function encode(m, w) {
	                    if (!w)
	                        w = $Writer.create();
	                    if (m.name != null && Object.hasOwnProperty.call(m, "name"))
	                        w.uint32(10).string(m.name);
	                    if (m.description != null && Object.hasOwnProperty.call(m, "description"))
	                        w.uint32(18).string(m.description);
	                    return w;
	                };

	                /**
	                 * Decodes an AtraceCategory message from the specified reader or buffer.
	                 * @function decode
	                 * @memberof perfetto.protos.FtraceDescriptor.AtraceCategory
	                 * @static
	                 * @param {$protobuf.Reader|Uint8Array} r Reader or buffer to decode from
	                 * @param {number} [l] Message length if known beforehand
	                 * @returns {perfetto.protos.FtraceDescriptor.AtraceCategory} AtraceCategory
	                 * @throws {Error} If the payload is not a reader or valid buffer
	                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
	                 */
	                AtraceCategory.decode = function decode(r, l) {
	                    if (!(r instanceof $Reader))
	                        r = $Reader.create(r);
	                    var c = l === undefined ? r.len : r.pos + l, m = new $root.perfetto.protos.FtraceDescriptor.AtraceCategory();
	                    while (r.pos < c) {
	                        var t = r.uint32();
	                        switch (t >>> 3) {
	                        case 1:
	                            m.name = r.string();
	                            break;
	                        case 2:
	                            m.description = r.string();
	                            break;
	                        default:
	                            r.skipType(t & 7);
	                            break;
	                        }
	                    }
	                    return m;
	                };

	                /**
	                 * Creates an AtraceCategory message from a plain object. Also converts values to their respective internal types.
	                 * @function fromObject
	                 * @memberof perfetto.protos.FtraceDescriptor.AtraceCategory
	                 * @static
	                 * @param {Object.<string,*>} d Plain object
	                 * @returns {perfetto.protos.FtraceDescriptor.AtraceCategory} AtraceCategory
	                 */
	                AtraceCategory.fromObject = function fromObject(d) {
	                    if (d instanceof $root.perfetto.protos.FtraceDescriptor.AtraceCategory)
	                        return d;
	                    var m = new $root.perfetto.protos.FtraceDescriptor.AtraceCategory();
	                    if (d.name != null) {
	                        m.name = String(d.name);
	                    }
	                    if (d.description != null) {
	                        m.description = String(d.description);
	                    }
	                    return m;
	                };

	                /**
	                 * Creates a plain object from an AtraceCategory message. Also converts values to other types if specified.
	                 * @function toObject
	                 * @memberof perfetto.protos.FtraceDescriptor.AtraceCategory
	                 * @static
	                 * @param {perfetto.protos.FtraceDescriptor.AtraceCategory} m AtraceCategory
	                 * @param {$protobuf.IConversionOptions} [o] Conversion options
	                 * @returns {Object.<string,*>} Plain object
	                 */
	                AtraceCategory.toObject = function toObject(m, o) {
	                    if (!o)
	                        o = {};
	                    var d = {};
	                    if (o.defaults) {
	                        d.name = "";
	                        d.description = "";
	                    }
	                    if (m.name != null && m.hasOwnProperty("name")) {
	                        d.name = m.name;
	                    }
	                    if (m.description != null && m.hasOwnProperty("description")) {
	                        d.description = m.description;
	                    }
	                    return d;
	                };

	                /**
	                 * Converts this AtraceCategory to JSON.
	                 * @function toJSON
	                 * @memberof perfetto.protos.FtraceDescriptor.AtraceCategory
	                 * @instance
	                 * @returns {Object.<string,*>} JSON object
	                 */
	                AtraceCategory.prototype.toJSON = function toJSON() {
	                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
	                };

	                return AtraceCategory;
	            })();

	            return FtraceDescriptor;
	        })();

	        protos.GpuCounterDescriptor = (function() {

	            /**
	             * Properties of a GpuCounterDescriptor.
	             * @memberof perfetto.protos
	             * @interface IGpuCounterDescriptor
	             * @property {Array.<perfetto.protos.GpuCounterDescriptor.IGpuCounterSpec>|null} [specs] GpuCounterDescriptor specs
	             * @property {Array.<perfetto.protos.GpuCounterDescriptor.IGpuCounterBlock>|null} [blocks] GpuCounterDescriptor blocks
	             * @property {number|null} [minSamplingPeriodNs] GpuCounterDescriptor minSamplingPeriodNs
	             * @property {number|null} [maxSamplingPeriodNs] GpuCounterDescriptor maxSamplingPeriodNs
	             * @property {boolean|null} [supportsInstrumentedSampling] GpuCounterDescriptor supportsInstrumentedSampling
	             */

	            /**
	             * Constructs a new GpuCounterDescriptor.
	             * @memberof perfetto.protos
	             * @classdesc Represents a GpuCounterDescriptor.
	             * @implements IGpuCounterDescriptor
	             * @constructor
	             * @param {perfetto.protos.IGpuCounterDescriptor=} [p] Properties to set
	             */
	            function GpuCounterDescriptor(p) {
	                this.specs = [];
	                this.blocks = [];
	                if (p)
	                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
	                        if (p[ks[i]] != null)
	                            this[ks[i]] = p[ks[i]];
	            }

	            /**
	             * GpuCounterDescriptor specs.
	             * @member {Array.<perfetto.protos.GpuCounterDescriptor.IGpuCounterSpec>} specs
	             * @memberof perfetto.protos.GpuCounterDescriptor
	             * @instance
	             */
	            GpuCounterDescriptor.prototype.specs = $util.emptyArray;

	            /**
	             * GpuCounterDescriptor blocks.
	             * @member {Array.<perfetto.protos.GpuCounterDescriptor.IGpuCounterBlock>} blocks
	             * @memberof perfetto.protos.GpuCounterDescriptor
	             * @instance
	             */
	            GpuCounterDescriptor.prototype.blocks = $util.emptyArray;

	            /**
	             * GpuCounterDescriptor minSamplingPeriodNs.
	             * @member {number} minSamplingPeriodNs
	             * @memberof perfetto.protos.GpuCounterDescriptor
	             * @instance
	             */
	            GpuCounterDescriptor.prototype.minSamplingPeriodNs = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

	            /**
	             * GpuCounterDescriptor maxSamplingPeriodNs.
	             * @member {number} maxSamplingPeriodNs
	             * @memberof perfetto.protos.GpuCounterDescriptor
	             * @instance
	             */
	            GpuCounterDescriptor.prototype.maxSamplingPeriodNs = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

	            /**
	             * GpuCounterDescriptor supportsInstrumentedSampling.
	             * @member {boolean} supportsInstrumentedSampling
	             * @memberof perfetto.protos.GpuCounterDescriptor
	             * @instance
	             */
	            GpuCounterDescriptor.prototype.supportsInstrumentedSampling = false;

	            /**
	             * Creates a new GpuCounterDescriptor instance using the specified properties.
	             * @function create
	             * @memberof perfetto.protos.GpuCounterDescriptor
	             * @static
	             * @param {perfetto.protos.IGpuCounterDescriptor=} [properties] Properties to set
	             * @returns {perfetto.protos.GpuCounterDescriptor} GpuCounterDescriptor instance
	             */
	            GpuCounterDescriptor.create = function create(properties) {
	                return new GpuCounterDescriptor(properties);
	            };

	            /**
	             * Encodes the specified GpuCounterDescriptor message. Does not implicitly {@link perfetto.protos.GpuCounterDescriptor.verify|verify} messages.
	             * @function encode
	             * @memberof perfetto.protos.GpuCounterDescriptor
	             * @static
	             * @param {perfetto.protos.IGpuCounterDescriptor} m GpuCounterDescriptor message or plain object to encode
	             * @param {$protobuf.Writer} [w] Writer to encode to
	             * @returns {$protobuf.Writer} Writer
	             */
	            GpuCounterDescriptor.encode = function encode(m, w) {
	                if (!w)
	                    w = $Writer.create();
	                if (m.specs != null && m.specs.length) {
	                    for (var i = 0; i < m.specs.length; ++i)
	                        $root.perfetto.protos.GpuCounterDescriptor.GpuCounterSpec.encode(m.specs[i], w.uint32(10).fork()).ldelim();
	                }
	                if (m.blocks != null && m.blocks.length) {
	                    for (var i = 0; i < m.blocks.length; ++i)
	                        $root.perfetto.protos.GpuCounterDescriptor.GpuCounterBlock.encode(m.blocks[i], w.uint32(18).fork()).ldelim();
	                }
	                if (m.minSamplingPeriodNs != null && Object.hasOwnProperty.call(m, "minSamplingPeriodNs"))
	                    w.uint32(24).uint64(m.minSamplingPeriodNs);
	                if (m.maxSamplingPeriodNs != null && Object.hasOwnProperty.call(m, "maxSamplingPeriodNs"))
	                    w.uint32(32).uint64(m.maxSamplingPeriodNs);
	                if (m.supportsInstrumentedSampling != null && Object.hasOwnProperty.call(m, "supportsInstrumentedSampling"))
	                    w.uint32(40).bool(m.supportsInstrumentedSampling);
	                return w;
	            };

	            /**
	             * Decodes a GpuCounterDescriptor message from the specified reader or buffer.
	             * @function decode
	             * @memberof perfetto.protos.GpuCounterDescriptor
	             * @static
	             * @param {$protobuf.Reader|Uint8Array} r Reader or buffer to decode from
	             * @param {number} [l] Message length if known beforehand
	             * @returns {perfetto.protos.GpuCounterDescriptor} GpuCounterDescriptor
	             * @throws {Error} If the payload is not a reader or valid buffer
	             * @throws {$protobuf.util.ProtocolError} If required fields are missing
	             */
	            GpuCounterDescriptor.decode = function decode(r, l) {
	                if (!(r instanceof $Reader))
	                    r = $Reader.create(r);
	                var c = l === undefined ? r.len : r.pos + l, m = new $root.perfetto.protos.GpuCounterDescriptor();
	                while (r.pos < c) {
	                    var t = r.uint32();
	                    switch (t >>> 3) {
	                    case 1:
	                        if (!(m.specs && m.specs.length))
	                            m.specs = [];
	                        m.specs.push($root.perfetto.protos.GpuCounterDescriptor.GpuCounterSpec.decode(r, r.uint32()));
	                        break;
	                    case 2:
	                        if (!(m.blocks && m.blocks.length))
	                            m.blocks = [];
	                        m.blocks.push($root.perfetto.protos.GpuCounterDescriptor.GpuCounterBlock.decode(r, r.uint32()));
	                        break;
	                    case 3:
	                        m.minSamplingPeriodNs = r.uint64();
	                        break;
	                    case 4:
	                        m.maxSamplingPeriodNs = r.uint64();
	                        break;
	                    case 5:
	                        m.supportsInstrumentedSampling = r.bool();
	                        break;
	                    default:
	                        r.skipType(t & 7);
	                        break;
	                    }
	                }
	                return m;
	            };

	            /**
	             * Creates a GpuCounterDescriptor message from a plain object. Also converts values to their respective internal types.
	             * @function fromObject
	             * @memberof perfetto.protos.GpuCounterDescriptor
	             * @static
	             * @param {Object.<string,*>} d Plain object
	             * @returns {perfetto.protos.GpuCounterDescriptor} GpuCounterDescriptor
	             */
	            GpuCounterDescriptor.fromObject = function fromObject(d) {
	                if (d instanceof $root.perfetto.protos.GpuCounterDescriptor)
	                    return d;
	                var m = new $root.perfetto.protos.GpuCounterDescriptor();
	                if (d.specs) {
	                    if (!Array.isArray(d.specs))
	                        throw TypeError(".perfetto.protos.GpuCounterDescriptor.specs: array expected");
	                    m.specs = [];
	                    for (var i = 0; i < d.specs.length; ++i) {
	                        if (typeof d.specs[i] !== "object")
	                            throw TypeError(".perfetto.protos.GpuCounterDescriptor.specs: object expected");
	                        m.specs[i] = $root.perfetto.protos.GpuCounterDescriptor.GpuCounterSpec.fromObject(d.specs[i]);
	                    }
	                }
	                if (d.blocks) {
	                    if (!Array.isArray(d.blocks))
	                        throw TypeError(".perfetto.protos.GpuCounterDescriptor.blocks: array expected");
	                    m.blocks = [];
	                    for (var i = 0; i < d.blocks.length; ++i) {
	                        if (typeof d.blocks[i] !== "object")
	                            throw TypeError(".perfetto.protos.GpuCounterDescriptor.blocks: object expected");
	                        m.blocks[i] = $root.perfetto.protos.GpuCounterDescriptor.GpuCounterBlock.fromObject(d.blocks[i]);
	                    }
	                }
	                if (d.minSamplingPeriodNs != null) {
	                    if ($util.Long)
	                        (m.minSamplingPeriodNs = $util.Long.fromValue(d.minSamplingPeriodNs)).unsigned = true;
	                    else if (typeof d.minSamplingPeriodNs === "string")
	                        m.minSamplingPeriodNs = parseInt(d.minSamplingPeriodNs, 10);
	                    else if (typeof d.minSamplingPeriodNs === "number")
	                        m.minSamplingPeriodNs = d.minSamplingPeriodNs;
	                    else if (typeof d.minSamplingPeriodNs === "object")
	                        m.minSamplingPeriodNs = new $util.LongBits(d.minSamplingPeriodNs.low >>> 0, d.minSamplingPeriodNs.high >>> 0).toNumber(true);
	                }
	                if (d.maxSamplingPeriodNs != null) {
	                    if ($util.Long)
	                        (m.maxSamplingPeriodNs = $util.Long.fromValue(d.maxSamplingPeriodNs)).unsigned = true;
	                    else if (typeof d.maxSamplingPeriodNs === "string")
	                        m.maxSamplingPeriodNs = parseInt(d.maxSamplingPeriodNs, 10);
	                    else if (typeof d.maxSamplingPeriodNs === "number")
	                        m.maxSamplingPeriodNs = d.maxSamplingPeriodNs;
	                    else if (typeof d.maxSamplingPeriodNs === "object")
	                        m.maxSamplingPeriodNs = new $util.LongBits(d.maxSamplingPeriodNs.low >>> 0, d.maxSamplingPeriodNs.high >>> 0).toNumber(true);
	                }
	                if (d.supportsInstrumentedSampling != null) {
	                    m.supportsInstrumentedSampling = Boolean(d.supportsInstrumentedSampling);
	                }
	                return m;
	            };

	            /**
	             * Creates a plain object from a GpuCounterDescriptor message. Also converts values to other types if specified.
	             * @function toObject
	             * @memberof perfetto.protos.GpuCounterDescriptor
	             * @static
	             * @param {perfetto.protos.GpuCounterDescriptor} m GpuCounterDescriptor
	             * @param {$protobuf.IConversionOptions} [o] Conversion options
	             * @returns {Object.<string,*>} Plain object
	             */
	            GpuCounterDescriptor.toObject = function toObject(m, o) {
	                if (!o)
	                    o = {};
	                var d = {};
	                if (o.arrays || o.defaults) {
	                    d.specs = [];
	                    d.blocks = [];
	                }
	                if (o.defaults) {
	                    if ($util.Long) {
	                        var n = new $util.Long(0, 0, true);
	                        d.minSamplingPeriodNs = o.longs === String ? n.toString() : o.longs === Number ? n.toNumber() : n;
	                    } else
	                        d.minSamplingPeriodNs = o.longs === String ? "0" : 0;
	                    if ($util.Long) {
	                        var n = new $util.Long(0, 0, true);
	                        d.maxSamplingPeriodNs = o.longs === String ? n.toString() : o.longs === Number ? n.toNumber() : n;
	                    } else
	                        d.maxSamplingPeriodNs = o.longs === String ? "0" : 0;
	                    d.supportsInstrumentedSampling = false;
	                }
	                if (m.specs && m.specs.length) {
	                    d.specs = [];
	                    for (var j = 0; j < m.specs.length; ++j) {
	                        d.specs[j] = $root.perfetto.protos.GpuCounterDescriptor.GpuCounterSpec.toObject(m.specs[j], o);
	                    }
	                }
	                if (m.blocks && m.blocks.length) {
	                    d.blocks = [];
	                    for (var j = 0; j < m.blocks.length; ++j) {
	                        d.blocks[j] = $root.perfetto.protos.GpuCounterDescriptor.GpuCounterBlock.toObject(m.blocks[j], o);
	                    }
	                }
	                if (m.minSamplingPeriodNs != null && m.hasOwnProperty("minSamplingPeriodNs")) {
	                    if (typeof m.minSamplingPeriodNs === "number")
	                        d.minSamplingPeriodNs = o.longs === String ? String(m.minSamplingPeriodNs) : m.minSamplingPeriodNs;
	                    else
	                        d.minSamplingPeriodNs = o.longs === String ? $util.Long.prototype.toString.call(m.minSamplingPeriodNs) : o.longs === Number ? new $util.LongBits(m.minSamplingPeriodNs.low >>> 0, m.minSamplingPeriodNs.high >>> 0).toNumber(true) : m.minSamplingPeriodNs;
	                }
	                if (m.maxSamplingPeriodNs != null && m.hasOwnProperty("maxSamplingPeriodNs")) {
	                    if (typeof m.maxSamplingPeriodNs === "number")
	                        d.maxSamplingPeriodNs = o.longs === String ? String(m.maxSamplingPeriodNs) : m.maxSamplingPeriodNs;
	                    else
	                        d.maxSamplingPeriodNs = o.longs === String ? $util.Long.prototype.toString.call(m.maxSamplingPeriodNs) : o.longs === Number ? new $util.LongBits(m.maxSamplingPeriodNs.low >>> 0, m.maxSamplingPeriodNs.high >>> 0).toNumber(true) : m.maxSamplingPeriodNs;
	                }
	                if (m.supportsInstrumentedSampling != null && m.hasOwnProperty("supportsInstrumentedSampling")) {
	                    d.supportsInstrumentedSampling = m.supportsInstrumentedSampling;
	                }
	                return d;
	            };

	            /**
	             * Converts this GpuCounterDescriptor to JSON.
	             * @function toJSON
	             * @memberof perfetto.protos.GpuCounterDescriptor
	             * @instance
	             * @returns {Object.<string,*>} JSON object
	             */
	            GpuCounterDescriptor.prototype.toJSON = function toJSON() {
	                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
	            };

	            /**
	             * GpuCounterGroup enum.
	             * @name perfetto.protos.GpuCounterDescriptor.GpuCounterGroup
	             * @enum {number}
	             * @property {number} UNCLASSIFIED=0 UNCLASSIFIED value
	             * @property {number} SYSTEM=1 SYSTEM value
	             * @property {number} VERTICES=2 VERTICES value
	             * @property {number} FRAGMENTS=3 FRAGMENTS value
	             * @property {number} PRIMITIVES=4 PRIMITIVES value
	             * @property {number} MEMORY=5 MEMORY value
	             * @property {number} COMPUTE=6 COMPUTE value
	             */
	            GpuCounterDescriptor.GpuCounterGroup = (function() {
	                var valuesById = {}, values = Object.create(valuesById);
	                values[valuesById[0] = "UNCLASSIFIED"] = 0;
	                values[valuesById[1] = "SYSTEM"] = 1;
	                values[valuesById[2] = "VERTICES"] = 2;
	                values[valuesById[3] = "FRAGMENTS"] = 3;
	                values[valuesById[4] = "PRIMITIVES"] = 4;
	                values[valuesById[5] = "MEMORY"] = 5;
	                values[valuesById[6] = "COMPUTE"] = 6;
	                return values;
	            })();

	            GpuCounterDescriptor.GpuCounterSpec = (function() {

	                /**
	                 * Properties of a GpuCounterSpec.
	                 * @memberof perfetto.protos.GpuCounterDescriptor
	                 * @interface IGpuCounterSpec
	                 * @property {number|null} [counterId] GpuCounterSpec counterId
	                 * @property {string|null} [name] GpuCounterSpec name
	                 * @property {string|null} [description] GpuCounterSpec description
	                 * @property {number|null} [intPeakValue] GpuCounterSpec intPeakValue
	                 * @property {number|null} [doublePeakValue] GpuCounterSpec doublePeakValue
	                 * @property {Array.<perfetto.protos.GpuCounterDescriptor.MeasureUnit>|null} [numeratorUnits] GpuCounterSpec numeratorUnits
	                 * @property {Array.<perfetto.protos.GpuCounterDescriptor.MeasureUnit>|null} [denominatorUnits] GpuCounterSpec denominatorUnits
	                 * @property {boolean|null} [selectByDefault] GpuCounterSpec selectByDefault
	                 * @property {Array.<perfetto.protos.GpuCounterDescriptor.GpuCounterGroup>|null} [groups] GpuCounterSpec groups
	                 */

	                /**
	                 * Constructs a new GpuCounterSpec.
	                 * @memberof perfetto.protos.GpuCounterDescriptor
	                 * @classdesc Represents a GpuCounterSpec.
	                 * @implements IGpuCounterSpec
	                 * @constructor
	                 * @param {perfetto.protos.GpuCounterDescriptor.IGpuCounterSpec=} [p] Properties to set
	                 */
	                function GpuCounterSpec(p) {
	                    this.numeratorUnits = [];
	                    this.denominatorUnits = [];
	                    this.groups = [];
	                    if (p)
	                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
	                            if (p[ks[i]] != null)
	                                this[ks[i]] = p[ks[i]];
	                }

	                /**
	                 * GpuCounterSpec counterId.
	                 * @member {number} counterId
	                 * @memberof perfetto.protos.GpuCounterDescriptor.GpuCounterSpec
	                 * @instance
	                 */
	                GpuCounterSpec.prototype.counterId = 0;

	                /**
	                 * GpuCounterSpec name.
	                 * @member {string} name
	                 * @memberof perfetto.protos.GpuCounterDescriptor.GpuCounterSpec
	                 * @instance
	                 */
	                GpuCounterSpec.prototype.name = "";

	                /**
	                 * GpuCounterSpec description.
	                 * @member {string} description
	                 * @memberof perfetto.protos.GpuCounterDescriptor.GpuCounterSpec
	                 * @instance
	                 */
	                GpuCounterSpec.prototype.description = "";

	                /**
	                 * GpuCounterSpec intPeakValue.
	                 * @member {number|null|undefined} intPeakValue
	                 * @memberof perfetto.protos.GpuCounterDescriptor.GpuCounterSpec
	                 * @instance
	                 */
	                GpuCounterSpec.prototype.intPeakValue = null;

	                /**
	                 * GpuCounterSpec doublePeakValue.
	                 * @member {number|null|undefined} doublePeakValue
	                 * @memberof perfetto.protos.GpuCounterDescriptor.GpuCounterSpec
	                 * @instance
	                 */
	                GpuCounterSpec.prototype.doublePeakValue = null;

	                /**
	                 * GpuCounterSpec numeratorUnits.
	                 * @member {Array.<perfetto.protos.GpuCounterDescriptor.MeasureUnit>} numeratorUnits
	                 * @memberof perfetto.protos.GpuCounterDescriptor.GpuCounterSpec
	                 * @instance
	                 */
	                GpuCounterSpec.prototype.numeratorUnits = $util.emptyArray;

	                /**
	                 * GpuCounterSpec denominatorUnits.
	                 * @member {Array.<perfetto.protos.GpuCounterDescriptor.MeasureUnit>} denominatorUnits
	                 * @memberof perfetto.protos.GpuCounterDescriptor.GpuCounterSpec
	                 * @instance
	                 */
	                GpuCounterSpec.prototype.denominatorUnits = $util.emptyArray;

	                /**
	                 * GpuCounterSpec selectByDefault.
	                 * @member {boolean} selectByDefault
	                 * @memberof perfetto.protos.GpuCounterDescriptor.GpuCounterSpec
	                 * @instance
	                 */
	                GpuCounterSpec.prototype.selectByDefault = false;

	                /**
	                 * GpuCounterSpec groups.
	                 * @member {Array.<perfetto.protos.GpuCounterDescriptor.GpuCounterGroup>} groups
	                 * @memberof perfetto.protos.GpuCounterDescriptor.GpuCounterSpec
	                 * @instance
	                 */
	                GpuCounterSpec.prototype.groups = $util.emptyArray;

	                // OneOf field names bound to virtual getters and setters
	                var $oneOfFields;

	                /**
	                 * GpuCounterSpec peakValue.
	                 * @member {"intPeakValue"|"doublePeakValue"|undefined} peakValue
	                 * @memberof perfetto.protos.GpuCounterDescriptor.GpuCounterSpec
	                 * @instance
	                 */
	                Object.defineProperty(GpuCounterSpec.prototype, "peakValue", {
	                    get: $util.oneOfGetter($oneOfFields = ["intPeakValue", "doublePeakValue"]),
	                    set: $util.oneOfSetter($oneOfFields)
	                });

	                /**
	                 * Creates a new GpuCounterSpec instance using the specified properties.
	                 * @function create
	                 * @memberof perfetto.protos.GpuCounterDescriptor.GpuCounterSpec
	                 * @static
	                 * @param {perfetto.protos.GpuCounterDescriptor.IGpuCounterSpec=} [properties] Properties to set
	                 * @returns {perfetto.protos.GpuCounterDescriptor.GpuCounterSpec} GpuCounterSpec instance
	                 */
	                GpuCounterSpec.create = function create(properties) {
	                    return new GpuCounterSpec(properties);
	                };

	                /**
	                 * Encodes the specified GpuCounterSpec message. Does not implicitly {@link perfetto.protos.GpuCounterDescriptor.GpuCounterSpec.verify|verify} messages.
	                 * @function encode
	                 * @memberof perfetto.protos.GpuCounterDescriptor.GpuCounterSpec
	                 * @static
	                 * @param {perfetto.protos.GpuCounterDescriptor.IGpuCounterSpec} m GpuCounterSpec message or plain object to encode
	                 * @param {$protobuf.Writer} [w] Writer to encode to
	                 * @returns {$protobuf.Writer} Writer
	                 */
	                GpuCounterSpec.encode = function encode(m, w) {
	                    if (!w)
	                        w = $Writer.create();
	                    if (m.counterId != null && Object.hasOwnProperty.call(m, "counterId"))
	                        w.uint32(8).uint32(m.counterId);
	                    if (m.name != null && Object.hasOwnProperty.call(m, "name"))
	                        w.uint32(18).string(m.name);
	                    if (m.description != null && Object.hasOwnProperty.call(m, "description"))
	                        w.uint32(26).string(m.description);
	                    if (m.intPeakValue != null && Object.hasOwnProperty.call(m, "intPeakValue"))
	                        w.uint32(40).int64(m.intPeakValue);
	                    if (m.doublePeakValue != null && Object.hasOwnProperty.call(m, "doublePeakValue"))
	                        w.uint32(49).double(m.doublePeakValue);
	                    if (m.numeratorUnits != null && m.numeratorUnits.length) {
	                        for (var i = 0; i < m.numeratorUnits.length; ++i)
	                            w.uint32(56).int32(m.numeratorUnits[i]);
	                    }
	                    if (m.denominatorUnits != null && m.denominatorUnits.length) {
	                        for (var i = 0; i < m.denominatorUnits.length; ++i)
	                            w.uint32(64).int32(m.denominatorUnits[i]);
	                    }
	                    if (m.selectByDefault != null && Object.hasOwnProperty.call(m, "selectByDefault"))
	                        w.uint32(72).bool(m.selectByDefault);
	                    if (m.groups != null && m.groups.length) {
	                        for (var i = 0; i < m.groups.length; ++i)
	                            w.uint32(80).int32(m.groups[i]);
	                    }
	                    return w;
	                };

	                /**
	                 * Decodes a GpuCounterSpec message from the specified reader or buffer.
	                 * @function decode
	                 * @memberof perfetto.protos.GpuCounterDescriptor.GpuCounterSpec
	                 * @static
	                 * @param {$protobuf.Reader|Uint8Array} r Reader or buffer to decode from
	                 * @param {number} [l] Message length if known beforehand
	                 * @returns {perfetto.protos.GpuCounterDescriptor.GpuCounterSpec} GpuCounterSpec
	                 * @throws {Error} If the payload is not a reader or valid buffer
	                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
	                 */
	                GpuCounterSpec.decode = function decode(r, l) {
	                    if (!(r instanceof $Reader))
	                        r = $Reader.create(r);
	                    var c = l === undefined ? r.len : r.pos + l, m = new $root.perfetto.protos.GpuCounterDescriptor.GpuCounterSpec();
	                    while (r.pos < c) {
	                        var t = r.uint32();
	                        switch (t >>> 3) {
	                        case 1:
	                            m.counterId = r.uint32();
	                            break;
	                        case 2:
	                            m.name = r.string();
	                            break;
	                        case 3:
	                            m.description = r.string();
	                            break;
	                        case 5:
	                            m.intPeakValue = r.int64();
	                            break;
	                        case 6:
	                            m.doublePeakValue = r.double();
	                            break;
	                        case 7:
	                            if (!(m.numeratorUnits && m.numeratorUnits.length))
	                                m.numeratorUnits = [];
	                            if ((t & 7) === 2) {
	                                var c2 = r.uint32() + r.pos;
	                                while (r.pos < c2)
	                                    m.numeratorUnits.push(r.int32());
	                            } else
	                                m.numeratorUnits.push(r.int32());
	                            break;
	                        case 8:
	                            if (!(m.denominatorUnits && m.denominatorUnits.length))
	                                m.denominatorUnits = [];
	                            if ((t & 7) === 2) {
	                                var c2 = r.uint32() + r.pos;
	                                while (r.pos < c2)
	                                    m.denominatorUnits.push(r.int32());
	                            } else
	                                m.denominatorUnits.push(r.int32());
	                            break;
	                        case 9:
	                            m.selectByDefault = r.bool();
	                            break;
	                        case 10:
	                            if (!(m.groups && m.groups.length))
	                                m.groups = [];
	                            if ((t & 7) === 2) {
	                                var c2 = r.uint32() + r.pos;
	                                while (r.pos < c2)
	                                    m.groups.push(r.int32());
	                            } else
	                                m.groups.push(r.int32());
	                            break;
	                        default:
	                            r.skipType(t & 7);
	                            break;
	                        }
	                    }
	                    return m;
	                };

	                /**
	                 * Creates a GpuCounterSpec message from a plain object. Also converts values to their respective internal types.
	                 * @function fromObject
	                 * @memberof perfetto.protos.GpuCounterDescriptor.GpuCounterSpec
	                 * @static
	                 * @param {Object.<string,*>} d Plain object
	                 * @returns {perfetto.protos.GpuCounterDescriptor.GpuCounterSpec} GpuCounterSpec
	                 */
	                GpuCounterSpec.fromObject = function fromObject(d) {
	                    if (d instanceof $root.perfetto.protos.GpuCounterDescriptor.GpuCounterSpec)
	                        return d;
	                    var m = new $root.perfetto.protos.GpuCounterDescriptor.GpuCounterSpec();
	                    if (d.counterId != null) {
	                        m.counterId = d.counterId >>> 0;
	                    }
	                    if (d.name != null) {
	                        m.name = String(d.name);
	                    }
	                    if (d.description != null) {
	                        m.description = String(d.description);
	                    }
	                    if (d.intPeakValue != null) {
	                        if ($util.Long)
	                            (m.intPeakValue = $util.Long.fromValue(d.intPeakValue)).unsigned = false;
	                        else if (typeof d.intPeakValue === "string")
	                            m.intPeakValue = parseInt(d.intPeakValue, 10);
	                        else if (typeof d.intPeakValue === "number")
	                            m.intPeakValue = d.intPeakValue;
	                        else if (typeof d.intPeakValue === "object")
	                            m.intPeakValue = new $util.LongBits(d.intPeakValue.low >>> 0, d.intPeakValue.high >>> 0).toNumber();
	                    }
	                    if (d.doublePeakValue != null) {
	                        m.doublePeakValue = Number(d.doublePeakValue);
	                    }
	                    if (d.numeratorUnits) {
	                        if (!Array.isArray(d.numeratorUnits))
	                            throw TypeError(".perfetto.protos.GpuCounterDescriptor.GpuCounterSpec.numeratorUnits: array expected");
	                        m.numeratorUnits = [];
	                        for (var i = 0; i < d.numeratorUnits.length; ++i) {
	                            switch (d.numeratorUnits[i]) {
	                            default:
	                            case "NONE":
	                            case 0:
	                                m.numeratorUnits[i] = 0;
	                                break;
	                            case "BIT":
	                            case 1:
	                                m.numeratorUnits[i] = 1;
	                                break;
	                            case "KILOBIT":
	                            case 2:
	                                m.numeratorUnits[i] = 2;
	                                break;
	                            case "MEGABIT":
	                            case 3:
	                                m.numeratorUnits[i] = 3;
	                                break;
	                            case "GIGABIT":
	                            case 4:
	                                m.numeratorUnits[i] = 4;
	                                break;
	                            case "TERABIT":
	                            case 5:
	                                m.numeratorUnits[i] = 5;
	                                break;
	                            case "PETABIT":
	                            case 6:
	                                m.numeratorUnits[i] = 6;
	                                break;
	                            case "BYTE":
	                            case 7:
	                                m.numeratorUnits[i] = 7;
	                                break;
	                            case "KILOBYTE":
	                            case 8:
	                                m.numeratorUnits[i] = 8;
	                                break;
	                            case "MEGABYTE":
	                            case 9:
	                                m.numeratorUnits[i] = 9;
	                                break;
	                            case "GIGABYTE":
	                            case 10:
	                                m.numeratorUnits[i] = 10;
	                                break;
	                            case "TERABYTE":
	                            case 11:
	                                m.numeratorUnits[i] = 11;
	                                break;
	                            case "PETABYTE":
	                            case 12:
	                                m.numeratorUnits[i] = 12;
	                                break;
	                            case "HERTZ":
	                            case 13:
	                                m.numeratorUnits[i] = 13;
	                                break;
	                            case "KILOHERTZ":
	                            case 14:
	                                m.numeratorUnits[i] = 14;
	                                break;
	                            case "MEGAHERTZ":
	                            case 15:
	                                m.numeratorUnits[i] = 15;
	                                break;
	                            case "GIGAHERTZ":
	                            case 16:
	                                m.numeratorUnits[i] = 16;
	                                break;
	                            case "TERAHERTZ":
	                            case 17:
	                                m.numeratorUnits[i] = 17;
	                                break;
	                            case "PETAHERTZ":
	                            case 18:
	                                m.numeratorUnits[i] = 18;
	                                break;
	                            case "NANOSECOND":
	                            case 19:
	                                m.numeratorUnits[i] = 19;
	                                break;
	                            case "MICROSECOND":
	                            case 20:
	                                m.numeratorUnits[i] = 20;
	                                break;
	                            case "MILLISECOND":
	                            case 21:
	                                m.numeratorUnits[i] = 21;
	                                break;
	                            case "SECOND":
	                            case 22:
	                                m.numeratorUnits[i] = 22;
	                                break;
	                            case "MINUTE":
	                            case 23:
	                                m.numeratorUnits[i] = 23;
	                                break;
	                            case "HOUR":
	                            case 24:
	                                m.numeratorUnits[i] = 24;
	                                break;
	                            case "VERTEX":
	                            case 25:
	                                m.numeratorUnits[i] = 25;
	                                break;
	                            case "PIXEL":
	                            case 26:
	                                m.numeratorUnits[i] = 26;
	                                break;
	                            case "TRIANGLE":
	                            case 27:
	                                m.numeratorUnits[i] = 27;
	                                break;
	                            case "PRIMITIVE":
	                            case 38:
	                                m.numeratorUnits[i] = 38;
	                                break;
	                            case "FRAGMENT":
	                            case 39:
	                                m.numeratorUnits[i] = 39;
	                                break;
	                            case "MILLIWATT":
	                            case 28:
	                                m.numeratorUnits[i] = 28;
	                                break;
	                            case "WATT":
	                            case 29:
	                                m.numeratorUnits[i] = 29;
	                                break;
	                            case "KILOWATT":
	                            case 30:
	                                m.numeratorUnits[i] = 30;
	                                break;
	                            case "JOULE":
	                            case 31:
	                                m.numeratorUnits[i] = 31;
	                                break;
	                            case "VOLT":
	                            case 32:
	                                m.numeratorUnits[i] = 32;
	                                break;
	                            case "AMPERE":
	                            case 33:
	                                m.numeratorUnits[i] = 33;
	                                break;
	                            case "CELSIUS":
	                            case 34:
	                                m.numeratorUnits[i] = 34;
	                                break;
	                            case "FAHRENHEIT":
	                            case 35:
	                                m.numeratorUnits[i] = 35;
	                                break;
	                            case "KELVIN":
	                            case 36:
	                                m.numeratorUnits[i] = 36;
	                                break;
	                            case "PERCENT":
	                            case 37:
	                                m.numeratorUnits[i] = 37;
	                                break;
	                            case "INSTRUCTION":
	                            case 40:
	                                m.numeratorUnits[i] = 40;
	                                break;
	                            }
	                        }
	                    }
	                    if (d.denominatorUnits) {
	                        if (!Array.isArray(d.denominatorUnits))
	                            throw TypeError(".perfetto.protos.GpuCounterDescriptor.GpuCounterSpec.denominatorUnits: array expected");
	                        m.denominatorUnits = [];
	                        for (var i = 0; i < d.denominatorUnits.length; ++i) {
	                            switch (d.denominatorUnits[i]) {
	                            default:
	                            case "NONE":
	                            case 0:
	                                m.denominatorUnits[i] = 0;
	                                break;
	                            case "BIT":
	                            case 1:
	                                m.denominatorUnits[i] = 1;
	                                break;
	                            case "KILOBIT":
	                            case 2:
	                                m.denominatorUnits[i] = 2;
	                                break;
	                            case "MEGABIT":
	                            case 3:
	                                m.denominatorUnits[i] = 3;
	                                break;
	                            case "GIGABIT":
	                            case 4:
	                                m.denominatorUnits[i] = 4;
	                                break;
	                            case "TERABIT":
	                            case 5:
	                                m.denominatorUnits[i] = 5;
	                                break;
	                            case "PETABIT":
	                            case 6:
	                                m.denominatorUnits[i] = 6;
	                                break;
	                            case "BYTE":
	                            case 7:
	                                m.denominatorUnits[i] = 7;
	                                break;
	                            case "KILOBYTE":
	                            case 8:
	                                m.denominatorUnits[i] = 8;
	                                break;
	                            case "MEGABYTE":
	                            case 9:
	                                m.denominatorUnits[i] = 9;
	                                break;
	                            case "GIGABYTE":
	                            case 10:
	                                m.denominatorUnits[i] = 10;
	                                break;
	                            case "TERABYTE":
	                            case 11:
	                                m.denominatorUnits[i] = 11;
	                                break;
	                            case "PETABYTE":
	                            case 12:
	                                m.denominatorUnits[i] = 12;
	                                break;
	                            case "HERTZ":
	                            case 13:
	                                m.denominatorUnits[i] = 13;
	                                break;
	                            case "KILOHERTZ":
	                            case 14:
	                                m.denominatorUnits[i] = 14;
	                                break;
	                            case "MEGAHERTZ":
	                            case 15:
	                                m.denominatorUnits[i] = 15;
	                                break;
	                            case "GIGAHERTZ":
	                            case 16:
	                                m.denominatorUnits[i] = 16;
	                                break;
	                            case "TERAHERTZ":
	                            case 17:
	                                m.denominatorUnits[i] = 17;
	                                break;
	                            case "PETAHERTZ":
	                            case 18:
	                                m.denominatorUnits[i] = 18;
	                                break;
	                            case "NANOSECOND":
	                            case 19:
	                                m.denominatorUnits[i] = 19;
	                                break;
	                            case "MICROSECOND":
	                            case 20:
	                                m.denominatorUnits[i] = 20;
	                                break;
	                            case "MILLISECOND":
	                            case 21:
	                                m.denominatorUnits[i] = 21;
	                                break;
	                            case "SECOND":
	                            case 22:
	                                m.denominatorUnits[i] = 22;
	                                break;
	                            case "MINUTE":
	                            case 23:
	                                m.denominatorUnits[i] = 23;
	                                break;
	                            case "HOUR":
	                            case 24:
	                                m.denominatorUnits[i] = 24;
	                                break;
	                            case "VERTEX":
	                            case 25:
	                                m.denominatorUnits[i] = 25;
	                                break;
	                            case "PIXEL":
	                            case 26:
	                                m.denominatorUnits[i] = 26;
	                                break;
	                            case "TRIANGLE":
	                            case 27:
	                                m.denominatorUnits[i] = 27;
	                                break;
	                            case "PRIMITIVE":
	                            case 38:
	                                m.denominatorUnits[i] = 38;
	                                break;
	                            case "FRAGMENT":
	                            case 39:
	                                m.denominatorUnits[i] = 39;
	                                break;
	                            case "MILLIWATT":
	                            case 28:
	                                m.denominatorUnits[i] = 28;
	                                break;
	                            case "WATT":
	                            case 29:
	                                m.denominatorUnits[i] = 29;
	                                break;
	                            case "KILOWATT":
	                            case 30:
	                                m.denominatorUnits[i] = 30;
	                                break;
	                            case "JOULE":
	                            case 31:
	                                m.denominatorUnits[i] = 31;
	                                break;
	                            case "VOLT":
	                            case 32:
	                                m.denominatorUnits[i] = 32;
	                                break;
	                            case "AMPERE":
	                            case 33:
	                                m.denominatorUnits[i] = 33;
	                                break;
	                            case "CELSIUS":
	                            case 34:
	                                m.denominatorUnits[i] = 34;
	                                break;
	                            case "FAHRENHEIT":
	                            case 35:
	                                m.denominatorUnits[i] = 35;
	                                break;
	                            case "KELVIN":
	                            case 36:
	                                m.denominatorUnits[i] = 36;
	                                break;
	                            case "PERCENT":
	                            case 37:
	                                m.denominatorUnits[i] = 37;
	                                break;
	                            case "INSTRUCTION":
	                            case 40:
	                                m.denominatorUnits[i] = 40;
	                                break;
	                            }
	                        }
	                    }
	                    if (d.selectByDefault != null) {
	                        m.selectByDefault = Boolean(d.selectByDefault);
	                    }
	                    if (d.groups) {
	                        if (!Array.isArray(d.groups))
	                            throw TypeError(".perfetto.protos.GpuCounterDescriptor.GpuCounterSpec.groups: array expected");
	                        m.groups = [];
	                        for (var i = 0; i < d.groups.length; ++i) {
	                            switch (d.groups[i]) {
	                            default:
	                            case "UNCLASSIFIED":
	                            case 0:
	                                m.groups[i] = 0;
	                                break;
	                            case "SYSTEM":
	                            case 1:
	                                m.groups[i] = 1;
	                                break;
	                            case "VERTICES":
	                            case 2:
	                                m.groups[i] = 2;
	                                break;
	                            case "FRAGMENTS":
	                            case 3:
	                                m.groups[i] = 3;
	                                break;
	                            case "PRIMITIVES":
	                            case 4:
	                                m.groups[i] = 4;
	                                break;
	                            case "MEMORY":
	                            case 5:
	                                m.groups[i] = 5;
	                                break;
	                            case "COMPUTE":
	                            case 6:
	                                m.groups[i] = 6;
	                                break;
	                            }
	                        }
	                    }
	                    return m;
	                };

	                /**
	                 * Creates a plain object from a GpuCounterSpec message. Also converts values to other types if specified.
	                 * @function toObject
	                 * @memberof perfetto.protos.GpuCounterDescriptor.GpuCounterSpec
	                 * @static
	                 * @param {perfetto.protos.GpuCounterDescriptor.GpuCounterSpec} m GpuCounterSpec
	                 * @param {$protobuf.IConversionOptions} [o] Conversion options
	                 * @returns {Object.<string,*>} Plain object
	                 */
	                GpuCounterSpec.toObject = function toObject(m, o) {
	                    if (!o)
	                        o = {};
	                    var d = {};
	                    if (o.arrays || o.defaults) {
	                        d.numeratorUnits = [];
	                        d.denominatorUnits = [];
	                        d.groups = [];
	                    }
	                    if (o.defaults) {
	                        d.counterId = 0;
	                        d.name = "";
	                        d.description = "";
	                        d.selectByDefault = false;
	                    }
	                    if (m.counterId != null && m.hasOwnProperty("counterId")) {
	                        d.counterId = m.counterId;
	                    }
	                    if (m.name != null && m.hasOwnProperty("name")) {
	                        d.name = m.name;
	                    }
	                    if (m.description != null && m.hasOwnProperty("description")) {
	                        d.description = m.description;
	                    }
	                    if (m.intPeakValue != null && m.hasOwnProperty("intPeakValue")) {
	                        if (typeof m.intPeakValue === "number")
	                            d.intPeakValue = o.longs === String ? String(m.intPeakValue) : m.intPeakValue;
	                        else
	                            d.intPeakValue = o.longs === String ? $util.Long.prototype.toString.call(m.intPeakValue) : o.longs === Number ? new $util.LongBits(m.intPeakValue.low >>> 0, m.intPeakValue.high >>> 0).toNumber() : m.intPeakValue;
	                        if (o.oneofs)
	                            d.peakValue = "intPeakValue";
	                    }
	                    if (m.doublePeakValue != null && m.hasOwnProperty("doublePeakValue")) {
	                        d.doublePeakValue = o.json && !isFinite(m.doublePeakValue) ? String(m.doublePeakValue) : m.doublePeakValue;
	                        if (o.oneofs)
	                            d.peakValue = "doublePeakValue";
	                    }
	                    if (m.numeratorUnits && m.numeratorUnits.length) {
	                        d.numeratorUnits = [];
	                        for (var j = 0; j < m.numeratorUnits.length; ++j) {
	                            d.numeratorUnits[j] = o.enums === String ? $root.perfetto.protos.GpuCounterDescriptor.MeasureUnit[m.numeratorUnits[j]] : m.numeratorUnits[j];
	                        }
	                    }
	                    if (m.denominatorUnits && m.denominatorUnits.length) {
	                        d.denominatorUnits = [];
	                        for (var j = 0; j < m.denominatorUnits.length; ++j) {
	                            d.denominatorUnits[j] = o.enums === String ? $root.perfetto.protos.GpuCounterDescriptor.MeasureUnit[m.denominatorUnits[j]] : m.denominatorUnits[j];
	                        }
	                    }
	                    if (m.selectByDefault != null && m.hasOwnProperty("selectByDefault")) {
	                        d.selectByDefault = m.selectByDefault;
	                    }
	                    if (m.groups && m.groups.length) {
	                        d.groups = [];
	                        for (var j = 0; j < m.groups.length; ++j) {
	                            d.groups[j] = o.enums === String ? $root.perfetto.protos.GpuCounterDescriptor.GpuCounterGroup[m.groups[j]] : m.groups[j];
	                        }
	                    }
	                    return d;
	                };

	                /**
	                 * Converts this GpuCounterSpec to JSON.
	                 * @function toJSON
	                 * @memberof perfetto.protos.GpuCounterDescriptor.GpuCounterSpec
	                 * @instance
	                 * @returns {Object.<string,*>} JSON object
	                 */
	                GpuCounterSpec.prototype.toJSON = function toJSON() {
	                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
	                };

	                return GpuCounterSpec;
	            })();

	            GpuCounterDescriptor.GpuCounterBlock = (function() {

	                /**
	                 * Properties of a GpuCounterBlock.
	                 * @memberof perfetto.protos.GpuCounterDescriptor
	                 * @interface IGpuCounterBlock
	                 * @property {number|null} [blockId] GpuCounterBlock blockId
	                 * @property {number|null} [blockCapacity] GpuCounterBlock blockCapacity
	                 * @property {string|null} [name] GpuCounterBlock name
	                 * @property {string|null} [description] GpuCounterBlock description
	                 * @property {Array.<number>|null} [counterIds] GpuCounterBlock counterIds
	                 */

	                /**
	                 * Constructs a new GpuCounterBlock.
	                 * @memberof perfetto.protos.GpuCounterDescriptor
	                 * @classdesc Represents a GpuCounterBlock.
	                 * @implements IGpuCounterBlock
	                 * @constructor
	                 * @param {perfetto.protos.GpuCounterDescriptor.IGpuCounterBlock=} [p] Properties to set
	                 */
	                function GpuCounterBlock(p) {
	                    this.counterIds = [];
	                    if (p)
	                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
	                            if (p[ks[i]] != null)
	                                this[ks[i]] = p[ks[i]];
	                }

	                /**
	                 * GpuCounterBlock blockId.
	                 * @member {number} blockId
	                 * @memberof perfetto.protos.GpuCounterDescriptor.GpuCounterBlock
	                 * @instance
	                 */
	                GpuCounterBlock.prototype.blockId = 0;

	                /**
	                 * GpuCounterBlock blockCapacity.
	                 * @member {number} blockCapacity
	                 * @memberof perfetto.protos.GpuCounterDescriptor.GpuCounterBlock
	                 * @instance
	                 */
	                GpuCounterBlock.prototype.blockCapacity = 0;

	                /**
	                 * GpuCounterBlock name.
	                 * @member {string} name
	                 * @memberof perfetto.protos.GpuCounterDescriptor.GpuCounterBlock
	                 * @instance
	                 */
	                GpuCounterBlock.prototype.name = "";

	                /**
	                 * GpuCounterBlock description.
	                 * @member {string} description
	                 * @memberof perfetto.protos.GpuCounterDescriptor.GpuCounterBlock
	                 * @instance
	                 */
	                GpuCounterBlock.prototype.description = "";

	                /**
	                 * GpuCounterBlock counterIds.
	                 * @member {Array.<number>} counterIds
	                 * @memberof perfetto.protos.GpuCounterDescriptor.GpuCounterBlock
	                 * @instance
	                 */
	                GpuCounterBlock.prototype.counterIds = $util.emptyArray;

	                /**
	                 * Creates a new GpuCounterBlock instance using the specified properties.
	                 * @function create
	                 * @memberof perfetto.protos.GpuCounterDescriptor.GpuCounterBlock
	                 * @static
	                 * @param {perfetto.protos.GpuCounterDescriptor.IGpuCounterBlock=} [properties] Properties to set
	                 * @returns {perfetto.protos.GpuCounterDescriptor.GpuCounterBlock} GpuCounterBlock instance
	                 */
	                GpuCounterBlock.create = function create(properties) {
	                    return new GpuCounterBlock(properties);
	                };

	                /**
	                 * Encodes the specified GpuCounterBlock message. Does not implicitly {@link perfetto.protos.GpuCounterDescriptor.GpuCounterBlock.verify|verify} messages.
	                 * @function encode
	                 * @memberof perfetto.protos.GpuCounterDescriptor.GpuCounterBlock
	                 * @static
	                 * @param {perfetto.protos.GpuCounterDescriptor.IGpuCounterBlock} m GpuCounterBlock message or plain object to encode
	                 * @param {$protobuf.Writer} [w] Writer to encode to
	                 * @returns {$protobuf.Writer} Writer
	                 */
	                GpuCounterBlock.encode = function encode(m, w) {
	                    if (!w)
	                        w = $Writer.create();
	                    if (m.blockId != null && Object.hasOwnProperty.call(m, "blockId"))
	                        w.uint32(8).uint32(m.blockId);
	                    if (m.blockCapacity != null && Object.hasOwnProperty.call(m, "blockCapacity"))
	                        w.uint32(16).uint32(m.blockCapacity);
	                    if (m.name != null && Object.hasOwnProperty.call(m, "name"))
	                        w.uint32(26).string(m.name);
	                    if (m.description != null && Object.hasOwnProperty.call(m, "description"))
	                        w.uint32(34).string(m.description);
	                    if (m.counterIds != null && m.counterIds.length) {
	                        for (var i = 0; i < m.counterIds.length; ++i)
	                            w.uint32(40).uint32(m.counterIds[i]);
	                    }
	                    return w;
	                };

	                /**
	                 * Decodes a GpuCounterBlock message from the specified reader or buffer.
	                 * @function decode
	                 * @memberof perfetto.protos.GpuCounterDescriptor.GpuCounterBlock
	                 * @static
	                 * @param {$protobuf.Reader|Uint8Array} r Reader or buffer to decode from
	                 * @param {number} [l] Message length if known beforehand
	                 * @returns {perfetto.protos.GpuCounterDescriptor.GpuCounterBlock} GpuCounterBlock
	                 * @throws {Error} If the payload is not a reader or valid buffer
	                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
	                 */
	                GpuCounterBlock.decode = function decode(r, l) {
	                    if (!(r instanceof $Reader))
	                        r = $Reader.create(r);
	                    var c = l === undefined ? r.len : r.pos + l, m = new $root.perfetto.protos.GpuCounterDescriptor.GpuCounterBlock();
	                    while (r.pos < c) {
	                        var t = r.uint32();
	                        switch (t >>> 3) {
	                        case 1:
	                            m.blockId = r.uint32();
	                            break;
	                        case 2:
	                            m.blockCapacity = r.uint32();
	                            break;
	                        case 3:
	                            m.name = r.string();
	                            break;
	                        case 4:
	                            m.description = r.string();
	                            break;
	                        case 5:
	                            if (!(m.counterIds && m.counterIds.length))
	                                m.counterIds = [];
	                            if ((t & 7) === 2) {
	                                var c2 = r.uint32() + r.pos;
	                                while (r.pos < c2)
	                                    m.counterIds.push(r.uint32());
	                            } else
	                                m.counterIds.push(r.uint32());
	                            break;
	                        default:
	                            r.skipType(t & 7);
	                            break;
	                        }
	                    }
	                    return m;
	                };

	                /**
	                 * Creates a GpuCounterBlock message from a plain object. Also converts values to their respective internal types.
	                 * @function fromObject
	                 * @memberof perfetto.protos.GpuCounterDescriptor.GpuCounterBlock
	                 * @static
	                 * @param {Object.<string,*>} d Plain object
	                 * @returns {perfetto.protos.GpuCounterDescriptor.GpuCounterBlock} GpuCounterBlock
	                 */
	                GpuCounterBlock.fromObject = function fromObject(d) {
	                    if (d instanceof $root.perfetto.protos.GpuCounterDescriptor.GpuCounterBlock)
	                        return d;
	                    var m = new $root.perfetto.protos.GpuCounterDescriptor.GpuCounterBlock();
	                    if (d.blockId != null) {
	                        m.blockId = d.blockId >>> 0;
	                    }
	                    if (d.blockCapacity != null) {
	                        m.blockCapacity = d.blockCapacity >>> 0;
	                    }
	                    if (d.name != null) {
	                        m.name = String(d.name);
	                    }
	                    if (d.description != null) {
	                        m.description = String(d.description);
	                    }
	                    if (d.counterIds) {
	                        if (!Array.isArray(d.counterIds))
	                            throw TypeError(".perfetto.protos.GpuCounterDescriptor.GpuCounterBlock.counterIds: array expected");
	                        m.counterIds = [];
	                        for (var i = 0; i < d.counterIds.length; ++i) {
	                            m.counterIds[i] = d.counterIds[i] >>> 0;
	                        }
	                    }
	                    return m;
	                };

	                /**
	                 * Creates a plain object from a GpuCounterBlock message. Also converts values to other types if specified.
	                 * @function toObject
	                 * @memberof perfetto.protos.GpuCounterDescriptor.GpuCounterBlock
	                 * @static
	                 * @param {perfetto.protos.GpuCounterDescriptor.GpuCounterBlock} m GpuCounterBlock
	                 * @param {$protobuf.IConversionOptions} [o] Conversion options
	                 * @returns {Object.<string,*>} Plain object
	                 */
	                GpuCounterBlock.toObject = function toObject(m, o) {
	                    if (!o)
	                        o = {};
	                    var d = {};
	                    if (o.arrays || o.defaults) {
	                        d.counterIds = [];
	                    }
	                    if (o.defaults) {
	                        d.blockId = 0;
	                        d.blockCapacity = 0;
	                        d.name = "";
	                        d.description = "";
	                    }
	                    if (m.blockId != null && m.hasOwnProperty("blockId")) {
	                        d.blockId = m.blockId;
	                    }
	                    if (m.blockCapacity != null && m.hasOwnProperty("blockCapacity")) {
	                        d.blockCapacity = m.blockCapacity;
	                    }
	                    if (m.name != null && m.hasOwnProperty("name")) {
	                        d.name = m.name;
	                    }
	                    if (m.description != null && m.hasOwnProperty("description")) {
	                        d.description = m.description;
	                    }
	                    if (m.counterIds && m.counterIds.length) {
	                        d.counterIds = [];
	                        for (var j = 0; j < m.counterIds.length; ++j) {
	                            d.counterIds[j] = m.counterIds[j];
	                        }
	                    }
	                    return d;
	                };

	                /**
	                 * Converts this GpuCounterBlock to JSON.
	                 * @function toJSON
	                 * @memberof perfetto.protos.GpuCounterDescriptor.GpuCounterBlock
	                 * @instance
	                 * @returns {Object.<string,*>} JSON object
	                 */
	                GpuCounterBlock.prototype.toJSON = function toJSON() {
	                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
	                };

	                return GpuCounterBlock;
	            })();

	            /**
	             * MeasureUnit enum.
	             * @name perfetto.protos.GpuCounterDescriptor.MeasureUnit
	             * @enum {number}
	             * @property {number} NONE=0 NONE value
	             * @property {number} BIT=1 BIT value
	             * @property {number} KILOBIT=2 KILOBIT value
	             * @property {number} MEGABIT=3 MEGABIT value
	             * @property {number} GIGABIT=4 GIGABIT value
	             * @property {number} TERABIT=5 TERABIT value
	             * @property {number} PETABIT=6 PETABIT value
	             * @property {number} BYTE=7 BYTE value
	             * @property {number} KILOBYTE=8 KILOBYTE value
	             * @property {number} MEGABYTE=9 MEGABYTE value
	             * @property {number} GIGABYTE=10 GIGABYTE value
	             * @property {number} TERABYTE=11 TERABYTE value
	             * @property {number} PETABYTE=12 PETABYTE value
	             * @property {number} HERTZ=13 HERTZ value
	             * @property {number} KILOHERTZ=14 KILOHERTZ value
	             * @property {number} MEGAHERTZ=15 MEGAHERTZ value
	             * @property {number} GIGAHERTZ=16 GIGAHERTZ value
	             * @property {number} TERAHERTZ=17 TERAHERTZ value
	             * @property {number} PETAHERTZ=18 PETAHERTZ value
	             * @property {number} NANOSECOND=19 NANOSECOND value
	             * @property {number} MICROSECOND=20 MICROSECOND value
	             * @property {number} MILLISECOND=21 MILLISECOND value
	             * @property {number} SECOND=22 SECOND value
	             * @property {number} MINUTE=23 MINUTE value
	             * @property {number} HOUR=24 HOUR value
	             * @property {number} VERTEX=25 VERTEX value
	             * @property {number} PIXEL=26 PIXEL value
	             * @property {number} TRIANGLE=27 TRIANGLE value
	             * @property {number} PRIMITIVE=38 PRIMITIVE value
	             * @property {number} FRAGMENT=39 FRAGMENT value
	             * @property {number} MILLIWATT=28 MILLIWATT value
	             * @property {number} WATT=29 WATT value
	             * @property {number} KILOWATT=30 KILOWATT value
	             * @property {number} JOULE=31 JOULE value
	             * @property {number} VOLT=32 VOLT value
	             * @property {number} AMPERE=33 AMPERE value
	             * @property {number} CELSIUS=34 CELSIUS value
	             * @property {number} FAHRENHEIT=35 FAHRENHEIT value
	             * @property {number} KELVIN=36 KELVIN value
	             * @property {number} PERCENT=37 PERCENT value
	             * @property {number} INSTRUCTION=40 INSTRUCTION value
	             */
	            GpuCounterDescriptor.MeasureUnit = (function() {
	                var valuesById = {}, values = Object.create(valuesById);
	                values[valuesById[0] = "NONE"] = 0;
	                values[valuesById[1] = "BIT"] = 1;
	                values[valuesById[2] = "KILOBIT"] = 2;
	                values[valuesById[3] = "MEGABIT"] = 3;
	                values[valuesById[4] = "GIGABIT"] = 4;
	                values[valuesById[5] = "TERABIT"] = 5;
	                values[valuesById[6] = "PETABIT"] = 6;
	                values[valuesById[7] = "BYTE"] = 7;
	                values[valuesById[8] = "KILOBYTE"] = 8;
	                values[valuesById[9] = "MEGABYTE"] = 9;
	                values[valuesById[10] = "GIGABYTE"] = 10;
	                values[valuesById[11] = "TERABYTE"] = 11;
	                values[valuesById[12] = "PETABYTE"] = 12;
	                values[valuesById[13] = "HERTZ"] = 13;
	                values[valuesById[14] = "KILOHERTZ"] = 14;
	                values[valuesById[15] = "MEGAHERTZ"] = 15;
	                values[valuesById[16] = "GIGAHERTZ"] = 16;
	                values[valuesById[17] = "TERAHERTZ"] = 17;
	                values[valuesById[18] = "PETAHERTZ"] = 18;
	                values[valuesById[19] = "NANOSECOND"] = 19;
	                values[valuesById[20] = "MICROSECOND"] = 20;
	                values[valuesById[21] = "MILLISECOND"] = 21;
	                values[valuesById[22] = "SECOND"] = 22;
	                values[valuesById[23] = "MINUTE"] = 23;
	                values[valuesById[24] = "HOUR"] = 24;
	                values[valuesById[25] = "VERTEX"] = 25;
	                values[valuesById[26] = "PIXEL"] = 26;
	                values[valuesById[27] = "TRIANGLE"] = 27;
	                values[valuesById[38] = "PRIMITIVE"] = 38;
	                values[valuesById[39] = "FRAGMENT"] = 39;
	                values[valuesById[28] = "MILLIWATT"] = 28;
	                values[valuesById[29] = "WATT"] = 29;
	                values[valuesById[30] = "KILOWATT"] = 30;
	                values[valuesById[31] = "JOULE"] = 31;
	                values[valuesById[32] = "VOLT"] = 32;
	                values[valuesById[33] = "AMPERE"] = 33;
	                values[valuesById[34] = "CELSIUS"] = 34;
	                values[valuesById[35] = "FAHRENHEIT"] = 35;
	                values[valuesById[36] = "KELVIN"] = 36;
	                values[valuesById[37] = "PERCENT"] = 37;
	                values[valuesById[40] = "INSTRUCTION"] = 40;
	                return values;
	            })();

	            return GpuCounterDescriptor;
	        })();

	        protos.TrackEventCategory = (function() {

	            /**
	             * Properties of a TrackEventCategory.
	             * @memberof perfetto.protos
	             * @interface ITrackEventCategory
	             * @property {string|null} [name] TrackEventCategory name
	             * @property {string|null} [description] TrackEventCategory description
	             * @property {Array.<string>|null} [tags] TrackEventCategory tags
	             */

	            /**
	             * Constructs a new TrackEventCategory.
	             * @memberof perfetto.protos
	             * @classdesc Represents a TrackEventCategory.
	             * @implements ITrackEventCategory
	             * @constructor
	             * @param {perfetto.protos.ITrackEventCategory=} [p] Properties to set
	             */
	            function TrackEventCategory(p) {
	                this.tags = [];
	                if (p)
	                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
	                        if (p[ks[i]] != null)
	                            this[ks[i]] = p[ks[i]];
	            }

	            /**
	             * TrackEventCategory name.
	             * @member {string} name
	             * @memberof perfetto.protos.TrackEventCategory
	             * @instance
	             */
	            TrackEventCategory.prototype.name = "";

	            /**
	             * TrackEventCategory description.
	             * @member {string} description
	             * @memberof perfetto.protos.TrackEventCategory
	             * @instance
	             */
	            TrackEventCategory.prototype.description = "";

	            /**
	             * TrackEventCategory tags.
	             * @member {Array.<string>} tags
	             * @memberof perfetto.protos.TrackEventCategory
	             * @instance
	             */
	            TrackEventCategory.prototype.tags = $util.emptyArray;

	            /**
	             * Creates a new TrackEventCategory instance using the specified properties.
	             * @function create
	             * @memberof perfetto.protos.TrackEventCategory
	             * @static
	             * @param {perfetto.protos.ITrackEventCategory=} [properties] Properties to set
	             * @returns {perfetto.protos.TrackEventCategory} TrackEventCategory instance
	             */
	            TrackEventCategory.create = function create(properties) {
	                return new TrackEventCategory(properties);
	            };

	            /**
	             * Encodes the specified TrackEventCategory message. Does not implicitly {@link perfetto.protos.TrackEventCategory.verify|verify} messages.
	             * @function encode
	             * @memberof perfetto.protos.TrackEventCategory
	             * @static
	             * @param {perfetto.protos.ITrackEventCategory} m TrackEventCategory message or plain object to encode
	             * @param {$protobuf.Writer} [w] Writer to encode to
	             * @returns {$protobuf.Writer} Writer
	             */
	            TrackEventCategory.encode = function encode(m, w) {
	                if (!w)
	                    w = $Writer.create();
	                if (m.name != null && Object.hasOwnProperty.call(m, "name"))
	                    w.uint32(10).string(m.name);
	                if (m.description != null && Object.hasOwnProperty.call(m, "description"))
	                    w.uint32(18).string(m.description);
	                if (m.tags != null && m.tags.length) {
	                    for (var i = 0; i < m.tags.length; ++i)
	                        w.uint32(26).string(m.tags[i]);
	                }
	                return w;
	            };

	            /**
	             * Decodes a TrackEventCategory message from the specified reader or buffer.
	             * @function decode
	             * @memberof perfetto.protos.TrackEventCategory
	             * @static
	             * @param {$protobuf.Reader|Uint8Array} r Reader or buffer to decode from
	             * @param {number} [l] Message length if known beforehand
	             * @returns {perfetto.protos.TrackEventCategory} TrackEventCategory
	             * @throws {Error} If the payload is not a reader or valid buffer
	             * @throws {$protobuf.util.ProtocolError} If required fields are missing
	             */
	            TrackEventCategory.decode = function decode(r, l) {
	                if (!(r instanceof $Reader))
	                    r = $Reader.create(r);
	                var c = l === undefined ? r.len : r.pos + l, m = new $root.perfetto.protos.TrackEventCategory();
	                while (r.pos < c) {
	                    var t = r.uint32();
	                    switch (t >>> 3) {
	                    case 1:
	                        m.name = r.string();
	                        break;
	                    case 2:
	                        m.description = r.string();
	                        break;
	                    case 3:
	                        if (!(m.tags && m.tags.length))
	                            m.tags = [];
	                        m.tags.push(r.string());
	                        break;
	                    default:
	                        r.skipType(t & 7);
	                        break;
	                    }
	                }
	                return m;
	            };

	            /**
	             * Creates a TrackEventCategory message from a plain object. Also converts values to their respective internal types.
	             * @function fromObject
	             * @memberof perfetto.protos.TrackEventCategory
	             * @static
	             * @param {Object.<string,*>} d Plain object
	             * @returns {perfetto.protos.TrackEventCategory} TrackEventCategory
	             */
	            TrackEventCategory.fromObject = function fromObject(d) {
	                if (d instanceof $root.perfetto.protos.TrackEventCategory)
	                    return d;
	                var m = new $root.perfetto.protos.TrackEventCategory();
	                if (d.name != null) {
	                    m.name = String(d.name);
	                }
	                if (d.description != null) {
	                    m.description = String(d.description);
	                }
	                if (d.tags) {
	                    if (!Array.isArray(d.tags))
	                        throw TypeError(".perfetto.protos.TrackEventCategory.tags: array expected");
	                    m.tags = [];
	                    for (var i = 0; i < d.tags.length; ++i) {
	                        m.tags[i] = String(d.tags[i]);
	                    }
	                }
	                return m;
	            };

	            /**
	             * Creates a plain object from a TrackEventCategory message. Also converts values to other types if specified.
	             * @function toObject
	             * @memberof perfetto.protos.TrackEventCategory
	             * @static
	             * @param {perfetto.protos.TrackEventCategory} m TrackEventCategory
	             * @param {$protobuf.IConversionOptions} [o] Conversion options
	             * @returns {Object.<string,*>} Plain object
	             */
	            TrackEventCategory.toObject = function toObject(m, o) {
	                if (!o)
	                    o = {};
	                var d = {};
	                if (o.arrays || o.defaults) {
	                    d.tags = [];
	                }
	                if (o.defaults) {
	                    d.name = "";
	                    d.description = "";
	                }
	                if (m.name != null && m.hasOwnProperty("name")) {
	                    d.name = m.name;
	                }
	                if (m.description != null && m.hasOwnProperty("description")) {
	                    d.description = m.description;
	                }
	                if (m.tags && m.tags.length) {
	                    d.tags = [];
	                    for (var j = 0; j < m.tags.length; ++j) {
	                        d.tags[j] = m.tags[j];
	                    }
	                }
	                return d;
	            };

	            /**
	             * Converts this TrackEventCategory to JSON.
	             * @function toJSON
	             * @memberof perfetto.protos.TrackEventCategory
	             * @instance
	             * @returns {Object.<string,*>} JSON object
	             */
	            TrackEventCategory.prototype.toJSON = function toJSON() {
	                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
	            };

	            return TrackEventCategory;
	        })();

	        protos.TrackEventDescriptor = (function() {

	            /**
	             * Properties of a TrackEventDescriptor.
	             * @memberof perfetto.protos
	             * @interface ITrackEventDescriptor
	             * @property {Array.<perfetto.protos.ITrackEventCategory>|null} [availableCategories] TrackEventDescriptor availableCategories
	             */

	            /**
	             * Constructs a new TrackEventDescriptor.
	             * @memberof perfetto.protos
	             * @classdesc Represents a TrackEventDescriptor.
	             * @implements ITrackEventDescriptor
	             * @constructor
	             * @param {perfetto.protos.ITrackEventDescriptor=} [p] Properties to set
	             */
	            function TrackEventDescriptor(p) {
	                this.availableCategories = [];
	                if (p)
	                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
	                        if (p[ks[i]] != null)
	                            this[ks[i]] = p[ks[i]];
	            }

	            /**
	             * TrackEventDescriptor availableCategories.
	             * @member {Array.<perfetto.protos.ITrackEventCategory>} availableCategories
	             * @memberof perfetto.protos.TrackEventDescriptor
	             * @instance
	             */
	            TrackEventDescriptor.prototype.availableCategories = $util.emptyArray;

	            /**
	             * Creates a new TrackEventDescriptor instance using the specified properties.
	             * @function create
	             * @memberof perfetto.protos.TrackEventDescriptor
	             * @static
	             * @param {perfetto.protos.ITrackEventDescriptor=} [properties] Properties to set
	             * @returns {perfetto.protos.TrackEventDescriptor} TrackEventDescriptor instance
	             */
	            TrackEventDescriptor.create = function create(properties) {
	                return new TrackEventDescriptor(properties);
	            };

	            /**
	             * Encodes the specified TrackEventDescriptor message. Does not implicitly {@link perfetto.protos.TrackEventDescriptor.verify|verify} messages.
	             * @function encode
	             * @memberof perfetto.protos.TrackEventDescriptor
	             * @static
	             * @param {perfetto.protos.ITrackEventDescriptor} m TrackEventDescriptor message or plain object to encode
	             * @param {$protobuf.Writer} [w] Writer to encode to
	             * @returns {$protobuf.Writer} Writer
	             */
	            TrackEventDescriptor.encode = function encode(m, w) {
	                if (!w)
	                    w = $Writer.create();
	                if (m.availableCategories != null && m.availableCategories.length) {
	                    for (var i = 0; i < m.availableCategories.length; ++i)
	                        $root.perfetto.protos.TrackEventCategory.encode(m.availableCategories[i], w.uint32(10).fork()).ldelim();
	                }
	                return w;
	            };

	            /**
	             * Decodes a TrackEventDescriptor message from the specified reader or buffer.
	             * @function decode
	             * @memberof perfetto.protos.TrackEventDescriptor
	             * @static
	             * @param {$protobuf.Reader|Uint8Array} r Reader or buffer to decode from
	             * @param {number} [l] Message length if known beforehand
	             * @returns {perfetto.protos.TrackEventDescriptor} TrackEventDescriptor
	             * @throws {Error} If the payload is not a reader or valid buffer
	             * @throws {$protobuf.util.ProtocolError} If required fields are missing
	             */
	            TrackEventDescriptor.decode = function decode(r, l) {
	                if (!(r instanceof $Reader))
	                    r = $Reader.create(r);
	                var c = l === undefined ? r.len : r.pos + l, m = new $root.perfetto.protos.TrackEventDescriptor();
	                while (r.pos < c) {
	                    var t = r.uint32();
	                    switch (t >>> 3) {
	                    case 1:
	                        if (!(m.availableCategories && m.availableCategories.length))
	                            m.availableCategories = [];
	                        m.availableCategories.push($root.perfetto.protos.TrackEventCategory.decode(r, r.uint32()));
	                        break;
	                    default:
	                        r.skipType(t & 7);
	                        break;
	                    }
	                }
	                return m;
	            };

	            /**
	             * Creates a TrackEventDescriptor message from a plain object. Also converts values to their respective internal types.
	             * @function fromObject
	             * @memberof perfetto.protos.TrackEventDescriptor
	             * @static
	             * @param {Object.<string,*>} d Plain object
	             * @returns {perfetto.protos.TrackEventDescriptor} TrackEventDescriptor
	             */
	            TrackEventDescriptor.fromObject = function fromObject(d) {
	                if (d instanceof $root.perfetto.protos.TrackEventDescriptor)
	                    return d;
	                var m = new $root.perfetto.protos.TrackEventDescriptor();
	                if (d.availableCategories) {
	                    if (!Array.isArray(d.availableCategories))
	                        throw TypeError(".perfetto.protos.TrackEventDescriptor.availableCategories: array expected");
	                    m.availableCategories = [];
	                    for (var i = 0; i < d.availableCategories.length; ++i) {
	                        if (typeof d.availableCategories[i] !== "object")
	                            throw TypeError(".perfetto.protos.TrackEventDescriptor.availableCategories: object expected");
	                        m.availableCategories[i] = $root.perfetto.protos.TrackEventCategory.fromObject(d.availableCategories[i]);
	                    }
	                }
	                return m;
	            };

	            /**
	             * Creates a plain object from a TrackEventDescriptor message. Also converts values to other types if specified.
	             * @function toObject
	             * @memberof perfetto.protos.TrackEventDescriptor
	             * @static
	             * @param {perfetto.protos.TrackEventDescriptor} m TrackEventDescriptor
	             * @param {$protobuf.IConversionOptions} [o] Conversion options
	             * @returns {Object.<string,*>} Plain object
	             */
	            TrackEventDescriptor.toObject = function toObject(m, o) {
	                if (!o)
	                    o = {};
	                var d = {};
	                if (o.arrays || o.defaults) {
	                    d.availableCategories = [];
	                }
	                if (m.availableCategories && m.availableCategories.length) {
	                    d.availableCategories = [];
	                    for (var j = 0; j < m.availableCategories.length; ++j) {
	                        d.availableCategories[j] = $root.perfetto.protos.TrackEventCategory.toObject(m.availableCategories[j], o);
	                    }
	                }
	                return d;
	            };

	            /**
	             * Converts this TrackEventDescriptor to JSON.
	             * @function toJSON
	             * @memberof perfetto.protos.TrackEventDescriptor
	             * @instance
	             * @returns {Object.<string,*>} JSON object
	             */
	            TrackEventDescriptor.prototype.toJSON = function toJSON() {
	                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
	            };

	            return TrackEventDescriptor;
	        })();

	        protos.DataSourceDescriptor = (function() {

	            /**
	             * Properties of a DataSourceDescriptor.
	             * @memberof perfetto.protos
	             * @interface IDataSourceDescriptor
	             * @property {string|null} [name] DataSourceDescriptor name
	             * @property {number|null} [id] DataSourceDescriptor id
	             * @property {boolean|null} [willNotifyOnStop] DataSourceDescriptor willNotifyOnStop
	             * @property {boolean|null} [willNotifyOnStart] DataSourceDescriptor willNotifyOnStart
	             * @property {boolean|null} [handlesIncrementalStateClear] DataSourceDescriptor handlesIncrementalStateClear
	             * @property {perfetto.protos.IGpuCounterDescriptor|null} [gpuCounterDescriptor] DataSourceDescriptor gpuCounterDescriptor
	             * @property {perfetto.protos.ITrackEventDescriptor|null} [trackEventDescriptor] DataSourceDescriptor trackEventDescriptor
	             * @property {perfetto.protos.IFtraceDescriptor|null} [ftraceDescriptor] DataSourceDescriptor ftraceDescriptor
	             */

	            /**
	             * Constructs a new DataSourceDescriptor.
	             * @memberof perfetto.protos
	             * @classdesc Represents a DataSourceDescriptor.
	             * @implements IDataSourceDescriptor
	             * @constructor
	             * @param {perfetto.protos.IDataSourceDescriptor=} [p] Properties to set
	             */
	            function DataSourceDescriptor(p) {
	                if (p)
	                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
	                        if (p[ks[i]] != null)
	                            this[ks[i]] = p[ks[i]];
	            }

	            /**
	             * DataSourceDescriptor name.
	             * @member {string} name
	             * @memberof perfetto.protos.DataSourceDescriptor
	             * @instance
	             */
	            DataSourceDescriptor.prototype.name = "";

	            /**
	             * DataSourceDescriptor id.
	             * @member {number} id
	             * @memberof perfetto.protos.DataSourceDescriptor
	             * @instance
	             */
	            DataSourceDescriptor.prototype.id = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

	            /**
	             * DataSourceDescriptor willNotifyOnStop.
	             * @member {boolean} willNotifyOnStop
	             * @memberof perfetto.protos.DataSourceDescriptor
	             * @instance
	             */
	            DataSourceDescriptor.prototype.willNotifyOnStop = false;

	            /**
	             * DataSourceDescriptor willNotifyOnStart.
	             * @member {boolean} willNotifyOnStart
	             * @memberof perfetto.protos.DataSourceDescriptor
	             * @instance
	             */
	            DataSourceDescriptor.prototype.willNotifyOnStart = false;

	            /**
	             * DataSourceDescriptor handlesIncrementalStateClear.
	             * @member {boolean} handlesIncrementalStateClear
	             * @memberof perfetto.protos.DataSourceDescriptor
	             * @instance
	             */
	            DataSourceDescriptor.prototype.handlesIncrementalStateClear = false;

	            /**
	             * DataSourceDescriptor gpuCounterDescriptor.
	             * @member {perfetto.protos.IGpuCounterDescriptor|null|undefined} gpuCounterDescriptor
	             * @memberof perfetto.protos.DataSourceDescriptor
	             * @instance
	             */
	            DataSourceDescriptor.prototype.gpuCounterDescriptor = null;

	            /**
	             * DataSourceDescriptor trackEventDescriptor.
	             * @member {perfetto.protos.ITrackEventDescriptor|null|undefined} trackEventDescriptor
	             * @memberof perfetto.protos.DataSourceDescriptor
	             * @instance
	             */
	            DataSourceDescriptor.prototype.trackEventDescriptor = null;

	            /**
	             * DataSourceDescriptor ftraceDescriptor.
	             * @member {perfetto.protos.IFtraceDescriptor|null|undefined} ftraceDescriptor
	             * @memberof perfetto.protos.DataSourceDescriptor
	             * @instance
	             */
	            DataSourceDescriptor.prototype.ftraceDescriptor = null;

	            /**
	             * Creates a new DataSourceDescriptor instance using the specified properties.
	             * @function create
	             * @memberof perfetto.protos.DataSourceDescriptor
	             * @static
	             * @param {perfetto.protos.IDataSourceDescriptor=} [properties] Properties to set
	             * @returns {perfetto.protos.DataSourceDescriptor} DataSourceDescriptor instance
	             */
	            DataSourceDescriptor.create = function create(properties) {
	                return new DataSourceDescriptor(properties);
	            };

	            /**
	             * Encodes the specified DataSourceDescriptor message. Does not implicitly {@link perfetto.protos.DataSourceDescriptor.verify|verify} messages.
	             * @function encode
	             * @memberof perfetto.protos.DataSourceDescriptor
	             * @static
	             * @param {perfetto.protos.IDataSourceDescriptor} m DataSourceDescriptor message or plain object to encode
	             * @param {$protobuf.Writer} [w] Writer to encode to
	             * @returns {$protobuf.Writer} Writer
	             */
	            DataSourceDescriptor.encode = function encode(m, w) {
	                if (!w)
	                    w = $Writer.create();
	                if (m.name != null && Object.hasOwnProperty.call(m, "name"))
	                    w.uint32(10).string(m.name);
	                if (m.willNotifyOnStop != null && Object.hasOwnProperty.call(m, "willNotifyOnStop"))
	                    w.uint32(16).bool(m.willNotifyOnStop);
	                if (m.willNotifyOnStart != null && Object.hasOwnProperty.call(m, "willNotifyOnStart"))
	                    w.uint32(24).bool(m.willNotifyOnStart);
	                if (m.handlesIncrementalStateClear != null && Object.hasOwnProperty.call(m, "handlesIncrementalStateClear"))
	                    w.uint32(32).bool(m.handlesIncrementalStateClear);
	                if (m.gpuCounterDescriptor != null && Object.hasOwnProperty.call(m, "gpuCounterDescriptor"))
	                    $root.perfetto.protos.GpuCounterDescriptor.encode(m.gpuCounterDescriptor, w.uint32(42).fork()).ldelim();
	                if (m.trackEventDescriptor != null && Object.hasOwnProperty.call(m, "trackEventDescriptor"))
	                    $root.perfetto.protos.TrackEventDescriptor.encode(m.trackEventDescriptor, w.uint32(50).fork()).ldelim();
	                if (m.id != null && Object.hasOwnProperty.call(m, "id"))
	                    w.uint32(56).uint64(m.id);
	                if (m.ftraceDescriptor != null && Object.hasOwnProperty.call(m, "ftraceDescriptor"))
	                    $root.perfetto.protos.FtraceDescriptor.encode(m.ftraceDescriptor, w.uint32(66).fork()).ldelim();
	                return w;
	            };

	            /**
	             * Decodes a DataSourceDescriptor message from the specified reader or buffer.
	             * @function decode
	             * @memberof perfetto.protos.DataSourceDescriptor
	             * @static
	             * @param {$protobuf.Reader|Uint8Array} r Reader or buffer to decode from
	             * @param {number} [l] Message length if known beforehand
	             * @returns {perfetto.protos.DataSourceDescriptor} DataSourceDescriptor
	             * @throws {Error} If the payload is not a reader or valid buffer
	             * @throws {$protobuf.util.ProtocolError} If required fields are missing
	             */
	            DataSourceDescriptor.decode = function decode(r, l) {
	                if (!(r instanceof $Reader))
	                    r = $Reader.create(r);
	                var c = l === undefined ? r.len : r.pos + l, m = new $root.perfetto.protos.DataSourceDescriptor();
	                while (r.pos < c) {
	                    var t = r.uint32();
	                    switch (t >>> 3) {
	                    case 1:
	                        m.name = r.string();
	                        break;
	                    case 7:
	                        m.id = r.uint64();
	                        break;
	                    case 2:
	                        m.willNotifyOnStop = r.bool();
	                        break;
	                    case 3:
	                        m.willNotifyOnStart = r.bool();
	                        break;
	                    case 4:
	                        m.handlesIncrementalStateClear = r.bool();
	                        break;
	                    case 5:
	                        m.gpuCounterDescriptor = $root.perfetto.protos.GpuCounterDescriptor.decode(r, r.uint32());
	                        break;
	                    case 6:
	                        m.trackEventDescriptor = $root.perfetto.protos.TrackEventDescriptor.decode(r, r.uint32());
	                        break;
	                    case 8:
	                        m.ftraceDescriptor = $root.perfetto.protos.FtraceDescriptor.decode(r, r.uint32());
	                        break;
	                    default:
	                        r.skipType(t & 7);
	                        break;
	                    }
	                }
	                return m;
	            };

	            /**
	             * Creates a DataSourceDescriptor message from a plain object. Also converts values to their respective internal types.
	             * @function fromObject
	             * @memberof perfetto.protos.DataSourceDescriptor
	             * @static
	             * @param {Object.<string,*>} d Plain object
	             * @returns {perfetto.protos.DataSourceDescriptor} DataSourceDescriptor
	             */
	            DataSourceDescriptor.fromObject = function fromObject(d) {
	                if (d instanceof $root.perfetto.protos.DataSourceDescriptor)
	                    return d;
	                var m = new $root.perfetto.protos.DataSourceDescriptor();
	                if (d.name != null) {
	                    m.name = String(d.name);
	                }
	                if (d.id != null) {
	                    if ($util.Long)
	                        (m.id = $util.Long.fromValue(d.id)).unsigned = true;
	                    else if (typeof d.id === "string")
	                        m.id = parseInt(d.id, 10);
	                    else if (typeof d.id === "number")
	                        m.id = d.id;
	                    else if (typeof d.id === "object")
	                        m.id = new $util.LongBits(d.id.low >>> 0, d.id.high >>> 0).toNumber(true);
	                }
	                if (d.willNotifyOnStop != null) {
	                    m.willNotifyOnStop = Boolean(d.willNotifyOnStop);
	                }
	                if (d.willNotifyOnStart != null) {
	                    m.willNotifyOnStart = Boolean(d.willNotifyOnStart);
	                }
	                if (d.handlesIncrementalStateClear != null) {
	                    m.handlesIncrementalStateClear = Boolean(d.handlesIncrementalStateClear);
	                }
	                if (d.gpuCounterDescriptor != null) {
	                    if (typeof d.gpuCounterDescriptor !== "object")
	                        throw TypeError(".perfetto.protos.DataSourceDescriptor.gpuCounterDescriptor: object expected");
	                    m.gpuCounterDescriptor = $root.perfetto.protos.GpuCounterDescriptor.fromObject(d.gpuCounterDescriptor);
	                }
	                if (d.trackEventDescriptor != null) {
	                    if (typeof d.trackEventDescriptor !== "object")
	                        throw TypeError(".perfetto.protos.DataSourceDescriptor.trackEventDescriptor: object expected");
	                    m.trackEventDescriptor = $root.perfetto.protos.TrackEventDescriptor.fromObject(d.trackEventDescriptor);
	                }
	                if (d.ftraceDescriptor != null) {
	                    if (typeof d.ftraceDescriptor !== "object")
	                        throw TypeError(".perfetto.protos.DataSourceDescriptor.ftraceDescriptor: object expected");
	                    m.ftraceDescriptor = $root.perfetto.protos.FtraceDescriptor.fromObject(d.ftraceDescriptor);
	                }
	                return m;
	            };

	            /**
	             * Creates a plain object from a DataSourceDescriptor message. Also converts values to other types if specified.
	             * @function toObject
	             * @memberof perfetto.protos.DataSourceDescriptor
	             * @static
	             * @param {perfetto.protos.DataSourceDescriptor} m DataSourceDescriptor
	             * @param {$protobuf.IConversionOptions} [o] Conversion options
	             * @returns {Object.<string,*>} Plain object
	             */
	            DataSourceDescriptor.toObject = function toObject(m, o) {
	                if (!o)
	                    o = {};
	                var d = {};
	                if (o.defaults) {
	                    d.name = "";
	                    d.willNotifyOnStop = false;
	                    d.willNotifyOnStart = false;
	                    d.handlesIncrementalStateClear = false;
	                    d.gpuCounterDescriptor = null;
	                    d.trackEventDescriptor = null;
	                    if ($util.Long) {
	                        var n = new $util.Long(0, 0, true);
	                        d.id = o.longs === String ? n.toString() : o.longs === Number ? n.toNumber() : n;
	                    } else
	                        d.id = o.longs === String ? "0" : 0;
	                    d.ftraceDescriptor = null;
	                }
	                if (m.name != null && m.hasOwnProperty("name")) {
	                    d.name = m.name;
	                }
	                if (m.willNotifyOnStop != null && m.hasOwnProperty("willNotifyOnStop")) {
	                    d.willNotifyOnStop = m.willNotifyOnStop;
	                }
	                if (m.willNotifyOnStart != null && m.hasOwnProperty("willNotifyOnStart")) {
	                    d.willNotifyOnStart = m.willNotifyOnStart;
	                }
	                if (m.handlesIncrementalStateClear != null && m.hasOwnProperty("handlesIncrementalStateClear")) {
	                    d.handlesIncrementalStateClear = m.handlesIncrementalStateClear;
	                }
	                if (m.gpuCounterDescriptor != null && m.hasOwnProperty("gpuCounterDescriptor")) {
	                    d.gpuCounterDescriptor = $root.perfetto.protos.GpuCounterDescriptor.toObject(m.gpuCounterDescriptor, o);
	                }
	                if (m.trackEventDescriptor != null && m.hasOwnProperty("trackEventDescriptor")) {
	                    d.trackEventDescriptor = $root.perfetto.protos.TrackEventDescriptor.toObject(m.trackEventDescriptor, o);
	                }
	                if (m.id != null && m.hasOwnProperty("id")) {
	                    if (typeof m.id === "number")
	                        d.id = o.longs === String ? String(m.id) : m.id;
	                    else
	                        d.id = o.longs === String ? $util.Long.prototype.toString.call(m.id) : o.longs === Number ? new $util.LongBits(m.id.low >>> 0, m.id.high >>> 0).toNumber(true) : m.id;
	                }
	                if (m.ftraceDescriptor != null && m.hasOwnProperty("ftraceDescriptor")) {
	                    d.ftraceDescriptor = $root.perfetto.protos.FtraceDescriptor.toObject(m.ftraceDescriptor, o);
	                }
	                return d;
	            };

	            /**
	             * Converts this DataSourceDescriptor to JSON.
	             * @function toJSON
	             * @memberof perfetto.protos.DataSourceDescriptor
	             * @instance
	             * @returns {Object.<string,*>} JSON object
	             */
	            DataSourceDescriptor.prototype.toJSON = function toJSON() {
	                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
	            };

	            return DataSourceDescriptor;
	        })();

	        protos.TracingServiceState = (function() {

	            /**
	             * Properties of a TracingServiceState.
	             * @memberof perfetto.protos
	             * @interface ITracingServiceState
	             * @property {Array.<perfetto.protos.TracingServiceState.IProducer>|null} [producers] TracingServiceState producers
	             * @property {Array.<perfetto.protos.TracingServiceState.IDataSource>|null} [dataSources] TracingServiceState dataSources
	             * @property {Array.<perfetto.protos.TracingServiceState.ITracingSession>|null} [tracingSessions] TracingServiceState tracingSessions
	             * @property {boolean|null} [supportsTracingSessions] TracingServiceState supportsTracingSessions
	             * @property {number|null} [numSessions] TracingServiceState numSessions
	             * @property {number|null} [numSessionsStarted] TracingServiceState numSessionsStarted
	             * @property {string|null} [tracingServiceVersion] TracingServiceState tracingServiceVersion
	             */

	            /**
	             * Constructs a new TracingServiceState.
	             * @memberof perfetto.protos
	             * @classdesc Represents a TracingServiceState.
	             * @implements ITracingServiceState
	             * @constructor
	             * @param {perfetto.protos.ITracingServiceState=} [p] Properties to set
	             */
	            function TracingServiceState(p) {
	                this.producers = [];
	                this.dataSources = [];
	                this.tracingSessions = [];
	                if (p)
	                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
	                        if (p[ks[i]] != null)
	                            this[ks[i]] = p[ks[i]];
	            }

	            /**
	             * TracingServiceState producers.
	             * @member {Array.<perfetto.protos.TracingServiceState.IProducer>} producers
	             * @memberof perfetto.protos.TracingServiceState
	             * @instance
	             */
	            TracingServiceState.prototype.producers = $util.emptyArray;

	            /**
	             * TracingServiceState dataSources.
	             * @member {Array.<perfetto.protos.TracingServiceState.IDataSource>} dataSources
	             * @memberof perfetto.protos.TracingServiceState
	             * @instance
	             */
	            TracingServiceState.prototype.dataSources = $util.emptyArray;

	            /**
	             * TracingServiceState tracingSessions.
	             * @member {Array.<perfetto.protos.TracingServiceState.ITracingSession>} tracingSessions
	             * @memberof perfetto.protos.TracingServiceState
	             * @instance
	             */
	            TracingServiceState.prototype.tracingSessions = $util.emptyArray;

	            /**
	             * TracingServiceState supportsTracingSessions.
	             * @member {boolean} supportsTracingSessions
	             * @memberof perfetto.protos.TracingServiceState
	             * @instance
	             */
	            TracingServiceState.prototype.supportsTracingSessions = false;

	            /**
	             * TracingServiceState numSessions.
	             * @member {number} numSessions
	             * @memberof perfetto.protos.TracingServiceState
	             * @instance
	             */
	            TracingServiceState.prototype.numSessions = 0;

	            /**
	             * TracingServiceState numSessionsStarted.
	             * @member {number} numSessionsStarted
	             * @memberof perfetto.protos.TracingServiceState
	             * @instance
	             */
	            TracingServiceState.prototype.numSessionsStarted = 0;

	            /**
	             * TracingServiceState tracingServiceVersion.
	             * @member {string} tracingServiceVersion
	             * @memberof perfetto.protos.TracingServiceState
	             * @instance
	             */
	            TracingServiceState.prototype.tracingServiceVersion = "";

	            /**
	             * Creates a new TracingServiceState instance using the specified properties.
	             * @function create
	             * @memberof perfetto.protos.TracingServiceState
	             * @static
	             * @param {perfetto.protos.ITracingServiceState=} [properties] Properties to set
	             * @returns {perfetto.protos.TracingServiceState} TracingServiceState instance
	             */
	            TracingServiceState.create = function create(properties) {
	                return new TracingServiceState(properties);
	            };

	            /**
	             * Encodes the specified TracingServiceState message. Does not implicitly {@link perfetto.protos.TracingServiceState.verify|verify} messages.
	             * @function encode
	             * @memberof perfetto.protos.TracingServiceState
	             * @static
	             * @param {perfetto.protos.ITracingServiceState} m TracingServiceState message or plain object to encode
	             * @param {$protobuf.Writer} [w] Writer to encode to
	             * @returns {$protobuf.Writer} Writer
	             */
	            TracingServiceState.encode = function encode(m, w) {
	                if (!w)
	                    w = $Writer.create();
	                if (m.producers != null && m.producers.length) {
	                    for (var i = 0; i < m.producers.length; ++i)
	                        $root.perfetto.protos.TracingServiceState.Producer.encode(m.producers[i], w.uint32(10).fork()).ldelim();
	                }
	                if (m.dataSources != null && m.dataSources.length) {
	                    for (var i = 0; i < m.dataSources.length; ++i)
	                        $root.perfetto.protos.TracingServiceState.DataSource.encode(m.dataSources[i], w.uint32(18).fork()).ldelim();
	                }
	                if (m.numSessions != null && Object.hasOwnProperty.call(m, "numSessions"))
	                    w.uint32(24).int32(m.numSessions);
	                if (m.numSessionsStarted != null && Object.hasOwnProperty.call(m, "numSessionsStarted"))
	                    w.uint32(32).int32(m.numSessionsStarted);
	                if (m.tracingServiceVersion != null && Object.hasOwnProperty.call(m, "tracingServiceVersion"))
	                    w.uint32(42).string(m.tracingServiceVersion);
	                if (m.tracingSessions != null && m.tracingSessions.length) {
	                    for (var i = 0; i < m.tracingSessions.length; ++i)
	                        $root.perfetto.protos.TracingServiceState.TracingSession.encode(m.tracingSessions[i], w.uint32(50).fork()).ldelim();
	                }
	                if (m.supportsTracingSessions != null && Object.hasOwnProperty.call(m, "supportsTracingSessions"))
	                    w.uint32(56).bool(m.supportsTracingSessions);
	                return w;
	            };

	            /**
	             * Decodes a TracingServiceState message from the specified reader or buffer.
	             * @function decode
	             * @memberof perfetto.protos.TracingServiceState
	             * @static
	             * @param {$protobuf.Reader|Uint8Array} r Reader or buffer to decode from
	             * @param {number} [l] Message length if known beforehand
	             * @returns {perfetto.protos.TracingServiceState} TracingServiceState
	             * @throws {Error} If the payload is not a reader or valid buffer
	             * @throws {$protobuf.util.ProtocolError} If required fields are missing
	             */
	            TracingServiceState.decode = function decode(r, l) {
	                if (!(r instanceof $Reader))
	                    r = $Reader.create(r);
	                var c = l === undefined ? r.len : r.pos + l, m = new $root.perfetto.protos.TracingServiceState();
	                while (r.pos < c) {
	                    var t = r.uint32();
	                    switch (t >>> 3) {
	                    case 1:
	                        if (!(m.producers && m.producers.length))
	                            m.producers = [];
	                        m.producers.push($root.perfetto.protos.TracingServiceState.Producer.decode(r, r.uint32()));
	                        break;
	                    case 2:
	                        if (!(m.dataSources && m.dataSources.length))
	                            m.dataSources = [];
	                        m.dataSources.push($root.perfetto.protos.TracingServiceState.DataSource.decode(r, r.uint32()));
	                        break;
	                    case 6:
	                        if (!(m.tracingSessions && m.tracingSessions.length))
	                            m.tracingSessions = [];
	                        m.tracingSessions.push($root.perfetto.protos.TracingServiceState.TracingSession.decode(r, r.uint32()));
	                        break;
	                    case 7:
	                        m.supportsTracingSessions = r.bool();
	                        break;
	                    case 3:
	                        m.numSessions = r.int32();
	                        break;
	                    case 4:
	                        m.numSessionsStarted = r.int32();
	                        break;
	                    case 5:
	                        m.tracingServiceVersion = r.string();
	                        break;
	                    default:
	                        r.skipType(t & 7);
	                        break;
	                    }
	                }
	                return m;
	            };

	            /**
	             * Creates a TracingServiceState message from a plain object. Also converts values to their respective internal types.
	             * @function fromObject
	             * @memberof perfetto.protos.TracingServiceState
	             * @static
	             * @param {Object.<string,*>} d Plain object
	             * @returns {perfetto.protos.TracingServiceState} TracingServiceState
	             */
	            TracingServiceState.fromObject = function fromObject(d) {
	                if (d instanceof $root.perfetto.protos.TracingServiceState)
	                    return d;
	                var m = new $root.perfetto.protos.TracingServiceState();
	                if (d.producers) {
	                    if (!Array.isArray(d.producers))
	                        throw TypeError(".perfetto.protos.TracingServiceState.producers: array expected");
	                    m.producers = [];
	                    for (var i = 0; i < d.producers.length; ++i) {
	                        if (typeof d.producers[i] !== "object")
	                            throw TypeError(".perfetto.protos.TracingServiceState.producers: object expected");
	                        m.producers[i] = $root.perfetto.protos.TracingServiceState.Producer.fromObject(d.producers[i]);
	                    }
	                }
	                if (d.dataSources) {
	                    if (!Array.isArray(d.dataSources))
	                        throw TypeError(".perfetto.protos.TracingServiceState.dataSources: array expected");
	                    m.dataSources = [];
	                    for (var i = 0; i < d.dataSources.length; ++i) {
	                        if (typeof d.dataSources[i] !== "object")
	                            throw TypeError(".perfetto.protos.TracingServiceState.dataSources: object expected");
	                        m.dataSources[i] = $root.perfetto.protos.TracingServiceState.DataSource.fromObject(d.dataSources[i]);
	                    }
	                }
	                if (d.tracingSessions) {
	                    if (!Array.isArray(d.tracingSessions))
	                        throw TypeError(".perfetto.protos.TracingServiceState.tracingSessions: array expected");
	                    m.tracingSessions = [];
	                    for (var i = 0; i < d.tracingSessions.length; ++i) {
	                        if (typeof d.tracingSessions[i] !== "object")
	                            throw TypeError(".perfetto.protos.TracingServiceState.tracingSessions: object expected");
	                        m.tracingSessions[i] = $root.perfetto.protos.TracingServiceState.TracingSession.fromObject(d.tracingSessions[i]);
	                    }
	                }
	                if (d.supportsTracingSessions != null) {
	                    m.supportsTracingSessions = Boolean(d.supportsTracingSessions);
	                }
	                if (d.numSessions != null) {
	                    m.numSessions = d.numSessions | 0;
	                }
	                if (d.numSessionsStarted != null) {
	                    m.numSessionsStarted = d.numSessionsStarted | 0;
	                }
	                if (d.tracingServiceVersion != null) {
	                    m.tracingServiceVersion = String(d.tracingServiceVersion);
	                }
	                return m;
	            };

	            /**
	             * Creates a plain object from a TracingServiceState message. Also converts values to other types if specified.
	             * @function toObject
	             * @memberof perfetto.protos.TracingServiceState
	             * @static
	             * @param {perfetto.protos.TracingServiceState} m TracingServiceState
	             * @param {$protobuf.IConversionOptions} [o] Conversion options
	             * @returns {Object.<string,*>} Plain object
	             */
	            TracingServiceState.toObject = function toObject(m, o) {
	                if (!o)
	                    o = {};
	                var d = {};
	                if (o.arrays || o.defaults) {
	                    d.producers = [];
	                    d.dataSources = [];
	                    d.tracingSessions = [];
	                }
	                if (o.defaults) {
	                    d.numSessions = 0;
	                    d.numSessionsStarted = 0;
	                    d.tracingServiceVersion = "";
	                    d.supportsTracingSessions = false;
	                }
	                if (m.producers && m.producers.length) {
	                    d.producers = [];
	                    for (var j = 0; j < m.producers.length; ++j) {
	                        d.producers[j] = $root.perfetto.protos.TracingServiceState.Producer.toObject(m.producers[j], o);
	                    }
	                }
	                if (m.dataSources && m.dataSources.length) {
	                    d.dataSources = [];
	                    for (var j = 0; j < m.dataSources.length; ++j) {
	                        d.dataSources[j] = $root.perfetto.protos.TracingServiceState.DataSource.toObject(m.dataSources[j], o);
	                    }
	                }
	                if (m.numSessions != null && m.hasOwnProperty("numSessions")) {
	                    d.numSessions = m.numSessions;
	                }
	                if (m.numSessionsStarted != null && m.hasOwnProperty("numSessionsStarted")) {
	                    d.numSessionsStarted = m.numSessionsStarted;
	                }
	                if (m.tracingServiceVersion != null && m.hasOwnProperty("tracingServiceVersion")) {
	                    d.tracingServiceVersion = m.tracingServiceVersion;
	                }
	                if (m.tracingSessions && m.tracingSessions.length) {
	                    d.tracingSessions = [];
	                    for (var j = 0; j < m.tracingSessions.length; ++j) {
	                        d.tracingSessions[j] = $root.perfetto.protos.TracingServiceState.TracingSession.toObject(m.tracingSessions[j], o);
	                    }
	                }
	                if (m.supportsTracingSessions != null && m.hasOwnProperty("supportsTracingSessions")) {
	                    d.supportsTracingSessions = m.supportsTracingSessions;
	                }
	                return d;
	            };

	            /**
	             * Converts this TracingServiceState to JSON.
	             * @function toJSON
	             * @memberof perfetto.protos.TracingServiceState
	             * @instance
	             * @returns {Object.<string,*>} JSON object
	             */
	            TracingServiceState.prototype.toJSON = function toJSON() {
	                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
	            };

	            TracingServiceState.Producer = (function() {

	                /**
	                 * Properties of a Producer.
	                 * @memberof perfetto.protos.TracingServiceState
	                 * @interface IProducer
	                 * @property {number|null} [id] Producer id
	                 * @property {string|null} [name] Producer name
	                 * @property {number|null} [pid] Producer pid
	                 * @property {number|null} [uid] Producer uid
	                 * @property {string|null} [sdkVersion] Producer sdkVersion
	                 */

	                /**
	                 * Constructs a new Producer.
	                 * @memberof perfetto.protos.TracingServiceState
	                 * @classdesc Represents a Producer.
	                 * @implements IProducer
	                 * @constructor
	                 * @param {perfetto.protos.TracingServiceState.IProducer=} [p] Properties to set
	                 */
	                function Producer(p) {
	                    if (p)
	                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
	                            if (p[ks[i]] != null)
	                                this[ks[i]] = p[ks[i]];
	                }

	                /**
	                 * Producer id.
	                 * @member {number} id
	                 * @memberof perfetto.protos.TracingServiceState.Producer
	                 * @instance
	                 */
	                Producer.prototype.id = 0;

	                /**
	                 * Producer name.
	                 * @member {string} name
	                 * @memberof perfetto.protos.TracingServiceState.Producer
	                 * @instance
	                 */
	                Producer.prototype.name = "";

	                /**
	                 * Producer pid.
	                 * @member {number} pid
	                 * @memberof perfetto.protos.TracingServiceState.Producer
	                 * @instance
	                 */
	                Producer.prototype.pid = 0;

	                /**
	                 * Producer uid.
	                 * @member {number} uid
	                 * @memberof perfetto.protos.TracingServiceState.Producer
	                 * @instance
	                 */
	                Producer.prototype.uid = 0;

	                /**
	                 * Producer sdkVersion.
	                 * @member {string} sdkVersion
	                 * @memberof perfetto.protos.TracingServiceState.Producer
	                 * @instance
	                 */
	                Producer.prototype.sdkVersion = "";

	                /**
	                 * Creates a new Producer instance using the specified properties.
	                 * @function create
	                 * @memberof perfetto.protos.TracingServiceState.Producer
	                 * @static
	                 * @param {perfetto.protos.TracingServiceState.IProducer=} [properties] Properties to set
	                 * @returns {perfetto.protos.TracingServiceState.Producer} Producer instance
	                 */
	                Producer.create = function create(properties) {
	                    return new Producer(properties);
	                };

	                /**
	                 * Encodes the specified Producer message. Does not implicitly {@link perfetto.protos.TracingServiceState.Producer.verify|verify} messages.
	                 * @function encode
	                 * @memberof perfetto.protos.TracingServiceState.Producer
	                 * @static
	                 * @param {perfetto.protos.TracingServiceState.IProducer} m Producer message or plain object to encode
	                 * @param {$protobuf.Writer} [w] Writer to encode to
	                 * @returns {$protobuf.Writer} Writer
	                 */
	                Producer.encode = function encode(m, w) {
	                    if (!w)
	                        w = $Writer.create();
	                    if (m.id != null && Object.hasOwnProperty.call(m, "id"))
	                        w.uint32(8).int32(m.id);
	                    if (m.name != null && Object.hasOwnProperty.call(m, "name"))
	                        w.uint32(18).string(m.name);
	                    if (m.uid != null && Object.hasOwnProperty.call(m, "uid"))
	                        w.uint32(24).int32(m.uid);
	                    if (m.sdkVersion != null && Object.hasOwnProperty.call(m, "sdkVersion"))
	                        w.uint32(34).string(m.sdkVersion);
	                    if (m.pid != null && Object.hasOwnProperty.call(m, "pid"))
	                        w.uint32(40).int32(m.pid);
	                    return w;
	                };

	                /**
	                 * Decodes a Producer message from the specified reader or buffer.
	                 * @function decode
	                 * @memberof perfetto.protos.TracingServiceState.Producer
	                 * @static
	                 * @param {$protobuf.Reader|Uint8Array} r Reader or buffer to decode from
	                 * @param {number} [l] Message length if known beforehand
	                 * @returns {perfetto.protos.TracingServiceState.Producer} Producer
	                 * @throws {Error} If the payload is not a reader or valid buffer
	                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
	                 */
	                Producer.decode = function decode(r, l) {
	                    if (!(r instanceof $Reader))
	                        r = $Reader.create(r);
	                    var c = l === undefined ? r.len : r.pos + l, m = new $root.perfetto.protos.TracingServiceState.Producer();
	                    while (r.pos < c) {
	                        var t = r.uint32();
	                        switch (t >>> 3) {
	                        case 1:
	                            m.id = r.int32();
	                            break;
	                        case 2:
	                            m.name = r.string();
	                            break;
	                        case 5:
	                            m.pid = r.int32();
	                            break;
	                        case 3:
	                            m.uid = r.int32();
	                            break;
	                        case 4:
	                            m.sdkVersion = r.string();
	                            break;
	                        default:
	                            r.skipType(t & 7);
	                            break;
	                        }
	                    }
	                    return m;
	                };

	                /**
	                 * Creates a Producer message from a plain object. Also converts values to their respective internal types.
	                 * @function fromObject
	                 * @memberof perfetto.protos.TracingServiceState.Producer
	                 * @static
	                 * @param {Object.<string,*>} d Plain object
	                 * @returns {perfetto.protos.TracingServiceState.Producer} Producer
	                 */
	                Producer.fromObject = function fromObject(d) {
	                    if (d instanceof $root.perfetto.protos.TracingServiceState.Producer)
	                        return d;
	                    var m = new $root.perfetto.protos.TracingServiceState.Producer();
	                    if (d.id != null) {
	                        m.id = d.id | 0;
	                    }
	                    if (d.name != null) {
	                        m.name = String(d.name);
	                    }
	                    if (d.pid != null) {
	                        m.pid = d.pid | 0;
	                    }
	                    if (d.uid != null) {
	                        m.uid = d.uid | 0;
	                    }
	                    if (d.sdkVersion != null) {
	                        m.sdkVersion = String(d.sdkVersion);
	                    }
	                    return m;
	                };

	                /**
	                 * Creates a plain object from a Producer message. Also converts values to other types if specified.
	                 * @function toObject
	                 * @memberof perfetto.protos.TracingServiceState.Producer
	                 * @static
	                 * @param {perfetto.protos.TracingServiceState.Producer} m Producer
	                 * @param {$protobuf.IConversionOptions} [o] Conversion options
	                 * @returns {Object.<string,*>} Plain object
	                 */
	                Producer.toObject = function toObject(m, o) {
	                    if (!o)
	                        o = {};
	                    var d = {};
	                    if (o.defaults) {
	                        d.id = 0;
	                        d.name = "";
	                        d.uid = 0;
	                        d.sdkVersion = "";
	                        d.pid = 0;
	                    }
	                    if (m.id != null && m.hasOwnProperty("id")) {
	                        d.id = m.id;
	                    }
	                    if (m.name != null && m.hasOwnProperty("name")) {
	                        d.name = m.name;
	                    }
	                    if (m.uid != null && m.hasOwnProperty("uid")) {
	                        d.uid = m.uid;
	                    }
	                    if (m.sdkVersion != null && m.hasOwnProperty("sdkVersion")) {
	                        d.sdkVersion = m.sdkVersion;
	                    }
	                    if (m.pid != null && m.hasOwnProperty("pid")) {
	                        d.pid = m.pid;
	                    }
	                    return d;
	                };

	                /**
	                 * Converts this Producer to JSON.
	                 * @function toJSON
	                 * @memberof perfetto.protos.TracingServiceState.Producer
	                 * @instance
	                 * @returns {Object.<string,*>} JSON object
	                 */
	                Producer.prototype.toJSON = function toJSON() {
	                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
	                };

	                return Producer;
	            })();

	            TracingServiceState.DataSource = (function() {

	                /**
	                 * Properties of a DataSource.
	                 * @memberof perfetto.protos.TracingServiceState
	                 * @interface IDataSource
	                 * @property {perfetto.protos.IDataSourceDescriptor|null} [dsDescriptor] DataSource dsDescriptor
	                 * @property {number|null} [producerId] DataSource producerId
	                 */

	                /**
	                 * Constructs a new DataSource.
	                 * @memberof perfetto.protos.TracingServiceState
	                 * @classdesc Represents a DataSource.
	                 * @implements IDataSource
	                 * @constructor
	                 * @param {perfetto.protos.TracingServiceState.IDataSource=} [p] Properties to set
	                 */
	                function DataSource(p) {
	                    if (p)
	                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
	                            if (p[ks[i]] != null)
	                                this[ks[i]] = p[ks[i]];
	                }

	                /**
	                 * DataSource dsDescriptor.
	                 * @member {perfetto.protos.IDataSourceDescriptor|null|undefined} dsDescriptor
	                 * @memberof perfetto.protos.TracingServiceState.DataSource
	                 * @instance
	                 */
	                DataSource.prototype.dsDescriptor = null;

	                /**
	                 * DataSource producerId.
	                 * @member {number} producerId
	                 * @memberof perfetto.protos.TracingServiceState.DataSource
	                 * @instance
	                 */
	                DataSource.prototype.producerId = 0;

	                /**
	                 * Creates a new DataSource instance using the specified properties.
	                 * @function create
	                 * @memberof perfetto.protos.TracingServiceState.DataSource
	                 * @static
	                 * @param {perfetto.protos.TracingServiceState.IDataSource=} [properties] Properties to set
	                 * @returns {perfetto.protos.TracingServiceState.DataSource} DataSource instance
	                 */
	                DataSource.create = function create(properties) {
	                    return new DataSource(properties);
	                };

	                /**
	                 * Encodes the specified DataSource message. Does not implicitly {@link perfetto.protos.TracingServiceState.DataSource.verify|verify} messages.
	                 * @function encode
	                 * @memberof perfetto.protos.TracingServiceState.DataSource
	                 * @static
	                 * @param {perfetto.protos.TracingServiceState.IDataSource} m DataSource message or plain object to encode
	                 * @param {$protobuf.Writer} [w] Writer to encode to
	                 * @returns {$protobuf.Writer} Writer
	                 */
	                DataSource.encode = function encode(m, w) {
	                    if (!w)
	                        w = $Writer.create();
	                    if (m.dsDescriptor != null && Object.hasOwnProperty.call(m, "dsDescriptor"))
	                        $root.perfetto.protos.DataSourceDescriptor.encode(m.dsDescriptor, w.uint32(10).fork()).ldelim();
	                    if (m.producerId != null && Object.hasOwnProperty.call(m, "producerId"))
	                        w.uint32(16).int32(m.producerId);
	                    return w;
	                };

	                /**
	                 * Decodes a DataSource message from the specified reader or buffer.
	                 * @function decode
	                 * @memberof perfetto.protos.TracingServiceState.DataSource
	                 * @static
	                 * @param {$protobuf.Reader|Uint8Array} r Reader or buffer to decode from
	                 * @param {number} [l] Message length if known beforehand
	                 * @returns {perfetto.protos.TracingServiceState.DataSource} DataSource
	                 * @throws {Error} If the payload is not a reader or valid buffer
	                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
	                 */
	                DataSource.decode = function decode(r, l) {
	                    if (!(r instanceof $Reader))
	                        r = $Reader.create(r);
	                    var c = l === undefined ? r.len : r.pos + l, m = new $root.perfetto.protos.TracingServiceState.DataSource();
	                    while (r.pos < c) {
	                        var t = r.uint32();
	                        switch (t >>> 3) {
	                        case 1:
	                            m.dsDescriptor = $root.perfetto.protos.DataSourceDescriptor.decode(r, r.uint32());
	                            break;
	                        case 2:
	                            m.producerId = r.int32();
	                            break;
	                        default:
	                            r.skipType(t & 7);
	                            break;
	                        }
	                    }
	                    return m;
	                };

	                /**
	                 * Creates a DataSource message from a plain object. Also converts values to their respective internal types.
	                 * @function fromObject
	                 * @memberof perfetto.protos.TracingServiceState.DataSource
	                 * @static
	                 * @param {Object.<string,*>} d Plain object
	                 * @returns {perfetto.protos.TracingServiceState.DataSource} DataSource
	                 */
	                DataSource.fromObject = function fromObject(d) {
	                    if (d instanceof $root.perfetto.protos.TracingServiceState.DataSource)
	                        return d;
	                    var m = new $root.perfetto.protos.TracingServiceState.DataSource();
	                    if (d.dsDescriptor != null) {
	                        if (typeof d.dsDescriptor !== "object")
	                            throw TypeError(".perfetto.protos.TracingServiceState.DataSource.dsDescriptor: object expected");
	                        m.dsDescriptor = $root.perfetto.protos.DataSourceDescriptor.fromObject(d.dsDescriptor);
	                    }
	                    if (d.producerId != null) {
	                        m.producerId = d.producerId | 0;
	                    }
	                    return m;
	                };

	                /**
	                 * Creates a plain object from a DataSource message. Also converts values to other types if specified.
	                 * @function toObject
	                 * @memberof perfetto.protos.TracingServiceState.DataSource
	                 * @static
	                 * @param {perfetto.protos.TracingServiceState.DataSource} m DataSource
	                 * @param {$protobuf.IConversionOptions} [o] Conversion options
	                 * @returns {Object.<string,*>} Plain object
	                 */
	                DataSource.toObject = function toObject(m, o) {
	                    if (!o)
	                        o = {};
	                    var d = {};
	                    if (o.defaults) {
	                        d.dsDescriptor = null;
	                        d.producerId = 0;
	                    }
	                    if (m.dsDescriptor != null && m.hasOwnProperty("dsDescriptor")) {
	                        d.dsDescriptor = $root.perfetto.protos.DataSourceDescriptor.toObject(m.dsDescriptor, o);
	                    }
	                    if (m.producerId != null && m.hasOwnProperty("producerId")) {
	                        d.producerId = m.producerId;
	                    }
	                    return d;
	                };

	                /**
	                 * Converts this DataSource to JSON.
	                 * @function toJSON
	                 * @memberof perfetto.protos.TracingServiceState.DataSource
	                 * @instance
	                 * @returns {Object.<string,*>} JSON object
	                 */
	                DataSource.prototype.toJSON = function toJSON() {
	                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
	                };

	                return DataSource;
	            })();

	            TracingServiceState.TracingSession = (function() {

	                /**
	                 * Properties of a TracingSession.
	                 * @memberof perfetto.protos.TracingServiceState
	                 * @interface ITracingSession
	                 * @property {number|null} [id] TracingSession id
	                 * @property {number|null} [consumerUid] TracingSession consumerUid
	                 * @property {string|null} [state] TracingSession state
	                 * @property {string|null} [uniqueSessionName] TracingSession uniqueSessionName
	                 * @property {Array.<number>|null} [bufferSizeKb] TracingSession bufferSizeKb
	                 * @property {number|null} [durationMs] TracingSession durationMs
	                 * @property {number|null} [numDataSources] TracingSession numDataSources
	                 * @property {number|null} [startRealtimeNs] TracingSession startRealtimeNs
	                 */

	                /**
	                 * Constructs a new TracingSession.
	                 * @memberof perfetto.protos.TracingServiceState
	                 * @classdesc Represents a TracingSession.
	                 * @implements ITracingSession
	                 * @constructor
	                 * @param {perfetto.protos.TracingServiceState.ITracingSession=} [p] Properties to set
	                 */
	                function TracingSession(p) {
	                    this.bufferSizeKb = [];
	                    if (p)
	                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
	                            if (p[ks[i]] != null)
	                                this[ks[i]] = p[ks[i]];
	                }

	                /**
	                 * TracingSession id.
	                 * @member {number} id
	                 * @memberof perfetto.protos.TracingServiceState.TracingSession
	                 * @instance
	                 */
	                TracingSession.prototype.id = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

	                /**
	                 * TracingSession consumerUid.
	                 * @member {number} consumerUid
	                 * @memberof perfetto.protos.TracingServiceState.TracingSession
	                 * @instance
	                 */
	                TracingSession.prototype.consumerUid = 0;

	                /**
	                 * TracingSession state.
	                 * @member {string} state
	                 * @memberof perfetto.protos.TracingServiceState.TracingSession
	                 * @instance
	                 */
	                TracingSession.prototype.state = "";

	                /**
	                 * TracingSession uniqueSessionName.
	                 * @member {string} uniqueSessionName
	                 * @memberof perfetto.protos.TracingServiceState.TracingSession
	                 * @instance
	                 */
	                TracingSession.prototype.uniqueSessionName = "";

	                /**
	                 * TracingSession bufferSizeKb.
	                 * @member {Array.<number>} bufferSizeKb
	                 * @memberof perfetto.protos.TracingServiceState.TracingSession
	                 * @instance
	                 */
	                TracingSession.prototype.bufferSizeKb = $util.emptyArray;

	                /**
	                 * TracingSession durationMs.
	                 * @member {number} durationMs
	                 * @memberof perfetto.protos.TracingServiceState.TracingSession
	                 * @instance
	                 */
	                TracingSession.prototype.durationMs = 0;

	                /**
	                 * TracingSession numDataSources.
	                 * @member {number} numDataSources
	                 * @memberof perfetto.protos.TracingServiceState.TracingSession
	                 * @instance
	                 */
	                TracingSession.prototype.numDataSources = 0;

	                /**
	                 * TracingSession startRealtimeNs.
	                 * @member {number} startRealtimeNs
	                 * @memberof perfetto.protos.TracingServiceState.TracingSession
	                 * @instance
	                 */
	                TracingSession.prototype.startRealtimeNs = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

	                /**
	                 * Creates a new TracingSession instance using the specified properties.
	                 * @function create
	                 * @memberof perfetto.protos.TracingServiceState.TracingSession
	                 * @static
	                 * @param {perfetto.protos.TracingServiceState.ITracingSession=} [properties] Properties to set
	                 * @returns {perfetto.protos.TracingServiceState.TracingSession} TracingSession instance
	                 */
	                TracingSession.create = function create(properties) {
	                    return new TracingSession(properties);
	                };

	                /**
	                 * Encodes the specified TracingSession message. Does not implicitly {@link perfetto.protos.TracingServiceState.TracingSession.verify|verify} messages.
	                 * @function encode
	                 * @memberof perfetto.protos.TracingServiceState.TracingSession
	                 * @static
	                 * @param {perfetto.protos.TracingServiceState.ITracingSession} m TracingSession message or plain object to encode
	                 * @param {$protobuf.Writer} [w] Writer to encode to
	                 * @returns {$protobuf.Writer} Writer
	                 */
	                TracingSession.encode = function encode(m, w) {
	                    if (!w)
	                        w = $Writer.create();
	                    if (m.id != null && Object.hasOwnProperty.call(m, "id"))
	                        w.uint32(8).uint64(m.id);
	                    if (m.consumerUid != null && Object.hasOwnProperty.call(m, "consumerUid"))
	                        w.uint32(16).int32(m.consumerUid);
	                    if (m.state != null && Object.hasOwnProperty.call(m, "state"))
	                        w.uint32(26).string(m.state);
	                    if (m.uniqueSessionName != null && Object.hasOwnProperty.call(m, "uniqueSessionName"))
	                        w.uint32(34).string(m.uniqueSessionName);
	                    if (m.bufferSizeKb != null && m.bufferSizeKb.length) {
	                        for (var i = 0; i < m.bufferSizeKb.length; ++i)
	                            w.uint32(40).uint32(m.bufferSizeKb[i]);
	                    }
	                    if (m.durationMs != null && Object.hasOwnProperty.call(m, "durationMs"))
	                        w.uint32(48).uint32(m.durationMs);
	                    if (m.numDataSources != null && Object.hasOwnProperty.call(m, "numDataSources"))
	                        w.uint32(56).uint32(m.numDataSources);
	                    if (m.startRealtimeNs != null && Object.hasOwnProperty.call(m, "startRealtimeNs"))
	                        w.uint32(64).int64(m.startRealtimeNs);
	                    return w;
	                };

	                /**
	                 * Decodes a TracingSession message from the specified reader or buffer.
	                 * @function decode
	                 * @memberof perfetto.protos.TracingServiceState.TracingSession
	                 * @static
	                 * @param {$protobuf.Reader|Uint8Array} r Reader or buffer to decode from
	                 * @param {number} [l] Message length if known beforehand
	                 * @returns {perfetto.protos.TracingServiceState.TracingSession} TracingSession
	                 * @throws {Error} If the payload is not a reader or valid buffer
	                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
	                 */
	                TracingSession.decode = function decode(r, l) {
	                    if (!(r instanceof $Reader))
	                        r = $Reader.create(r);
	                    var c = l === undefined ? r.len : r.pos + l, m = new $root.perfetto.protos.TracingServiceState.TracingSession();
	                    while (r.pos < c) {
	                        var t = r.uint32();
	                        switch (t >>> 3) {
	                        case 1:
	                            m.id = r.uint64();
	                            break;
	                        case 2:
	                            m.consumerUid = r.int32();
	                            break;
	                        case 3:
	                            m.state = r.string();
	                            break;
	                        case 4:
	                            m.uniqueSessionName = r.string();
	                            break;
	                        case 5:
	                            if (!(m.bufferSizeKb && m.bufferSizeKb.length))
	                                m.bufferSizeKb = [];
	                            if ((t & 7) === 2) {
	                                var c2 = r.uint32() + r.pos;
	                                while (r.pos < c2)
	                                    m.bufferSizeKb.push(r.uint32());
	                            } else
	                                m.bufferSizeKb.push(r.uint32());
	                            break;
	                        case 6:
	                            m.durationMs = r.uint32();
	                            break;
	                        case 7:
	                            m.numDataSources = r.uint32();
	                            break;
	                        case 8:
	                            m.startRealtimeNs = r.int64();
	                            break;
	                        default:
	                            r.skipType(t & 7);
	                            break;
	                        }
	                    }
	                    return m;
	                };

	                /**
	                 * Creates a TracingSession message from a plain object. Also converts values to their respective internal types.
	                 * @function fromObject
	                 * @memberof perfetto.protos.TracingServiceState.TracingSession
	                 * @static
	                 * @param {Object.<string,*>} d Plain object
	                 * @returns {perfetto.protos.TracingServiceState.TracingSession} TracingSession
	                 */
	                TracingSession.fromObject = function fromObject(d) {
	                    if (d instanceof $root.perfetto.protos.TracingServiceState.TracingSession)
	                        return d;
	                    var m = new $root.perfetto.protos.TracingServiceState.TracingSession();
	                    if (d.id != null) {
	                        if ($util.Long)
	                            (m.id = $util.Long.fromValue(d.id)).unsigned = true;
	                        else if (typeof d.id === "string")
	                            m.id = parseInt(d.id, 10);
	                        else if (typeof d.id === "number")
	                            m.id = d.id;
	                        else if (typeof d.id === "object")
	                            m.id = new $util.LongBits(d.id.low >>> 0, d.id.high >>> 0).toNumber(true);
	                    }
	                    if (d.consumerUid != null) {
	                        m.consumerUid = d.consumerUid | 0;
	                    }
	                    if (d.state != null) {
	                        m.state = String(d.state);
	                    }
	                    if (d.uniqueSessionName != null) {
	                        m.uniqueSessionName = String(d.uniqueSessionName);
	                    }
	                    if (d.bufferSizeKb) {
	                        if (!Array.isArray(d.bufferSizeKb))
	                            throw TypeError(".perfetto.protos.TracingServiceState.TracingSession.bufferSizeKb: array expected");
	                        m.bufferSizeKb = [];
	                        for (var i = 0; i < d.bufferSizeKb.length; ++i) {
	                            m.bufferSizeKb[i] = d.bufferSizeKb[i] >>> 0;
	                        }
	                    }
	                    if (d.durationMs != null) {
	                        m.durationMs = d.durationMs >>> 0;
	                    }
	                    if (d.numDataSources != null) {
	                        m.numDataSources = d.numDataSources >>> 0;
	                    }
	                    if (d.startRealtimeNs != null) {
	                        if ($util.Long)
	                            (m.startRealtimeNs = $util.Long.fromValue(d.startRealtimeNs)).unsigned = false;
	                        else if (typeof d.startRealtimeNs === "string")
	                            m.startRealtimeNs = parseInt(d.startRealtimeNs, 10);
	                        else if (typeof d.startRealtimeNs === "number")
	                            m.startRealtimeNs = d.startRealtimeNs;
	                        else if (typeof d.startRealtimeNs === "object")
	                            m.startRealtimeNs = new $util.LongBits(d.startRealtimeNs.low >>> 0, d.startRealtimeNs.high >>> 0).toNumber();
	                    }
	                    return m;
	                };

	                /**
	                 * Creates a plain object from a TracingSession message. Also converts values to other types if specified.
	                 * @function toObject
	                 * @memberof perfetto.protos.TracingServiceState.TracingSession
	                 * @static
	                 * @param {perfetto.protos.TracingServiceState.TracingSession} m TracingSession
	                 * @param {$protobuf.IConversionOptions} [o] Conversion options
	                 * @returns {Object.<string,*>} Plain object
	                 */
	                TracingSession.toObject = function toObject(m, o) {
	                    if (!o)
	                        o = {};
	                    var d = {};
	                    if (o.arrays || o.defaults) {
	                        d.bufferSizeKb = [];
	                    }
	                    if (o.defaults) {
	                        if ($util.Long) {
	                            var n = new $util.Long(0, 0, true);
	                            d.id = o.longs === String ? n.toString() : o.longs === Number ? n.toNumber() : n;
	                        } else
	                            d.id = o.longs === String ? "0" : 0;
	                        d.consumerUid = 0;
	                        d.state = "";
	                        d.uniqueSessionName = "";
	                        d.durationMs = 0;
	                        d.numDataSources = 0;
	                        if ($util.Long) {
	                            var n = new $util.Long(0, 0, false);
	                            d.startRealtimeNs = o.longs === String ? n.toString() : o.longs === Number ? n.toNumber() : n;
	                        } else
	                            d.startRealtimeNs = o.longs === String ? "0" : 0;
	                    }
	                    if (m.id != null && m.hasOwnProperty("id")) {
	                        if (typeof m.id === "number")
	                            d.id = o.longs === String ? String(m.id) : m.id;
	                        else
	                            d.id = o.longs === String ? $util.Long.prototype.toString.call(m.id) : o.longs === Number ? new $util.LongBits(m.id.low >>> 0, m.id.high >>> 0).toNumber(true) : m.id;
	                    }
	                    if (m.consumerUid != null && m.hasOwnProperty("consumerUid")) {
	                        d.consumerUid = m.consumerUid;
	                    }
	                    if (m.state != null && m.hasOwnProperty("state")) {
	                        d.state = m.state;
	                    }
	                    if (m.uniqueSessionName != null && m.hasOwnProperty("uniqueSessionName")) {
	                        d.uniqueSessionName = m.uniqueSessionName;
	                    }
	                    if (m.bufferSizeKb && m.bufferSizeKb.length) {
	                        d.bufferSizeKb = [];
	                        for (var j = 0; j < m.bufferSizeKb.length; ++j) {
	                            d.bufferSizeKb[j] = m.bufferSizeKb[j];
	                        }
	                    }
	                    if (m.durationMs != null && m.hasOwnProperty("durationMs")) {
	                        d.durationMs = m.durationMs;
	                    }
	                    if (m.numDataSources != null && m.hasOwnProperty("numDataSources")) {
	                        d.numDataSources = m.numDataSources;
	                    }
	                    if (m.startRealtimeNs != null && m.hasOwnProperty("startRealtimeNs")) {
	                        if (typeof m.startRealtimeNs === "number")
	                            d.startRealtimeNs = o.longs === String ? String(m.startRealtimeNs) : m.startRealtimeNs;
	                        else
	                            d.startRealtimeNs = o.longs === String ? $util.Long.prototype.toString.call(m.startRealtimeNs) : o.longs === Number ? new $util.LongBits(m.startRealtimeNs.low >>> 0, m.startRealtimeNs.high >>> 0).toNumber() : m.startRealtimeNs;
	                    }
	                    return d;
	                };

	                /**
	                 * Converts this TracingSession to JSON.
	                 * @function toJSON
	                 * @memberof perfetto.protos.TracingServiceState.TracingSession
	                 * @instance
	                 * @returns {Object.<string,*>} JSON object
	                 */
	                TracingSession.prototype.toJSON = function toJSON() {
	                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
	                };

	                return TracingSession;
	            })();

	            return TracingServiceState;
	        })();

	        /**
	         * BuiltinClock enum.
	         * @name perfetto.protos.BuiltinClock
	         * @enum {number}
	         * @property {number} BUILTIN_CLOCK_UNKNOWN=0 BUILTIN_CLOCK_UNKNOWN value
	         * @property {number} BUILTIN_CLOCK_REALTIME=1 BUILTIN_CLOCK_REALTIME value
	         * @property {number} BUILTIN_CLOCK_REALTIME_COARSE=2 BUILTIN_CLOCK_REALTIME_COARSE value
	         * @property {number} BUILTIN_CLOCK_MONOTONIC=3 BUILTIN_CLOCK_MONOTONIC value
	         * @property {number} BUILTIN_CLOCK_MONOTONIC_COARSE=4 BUILTIN_CLOCK_MONOTONIC_COARSE value
	         * @property {number} BUILTIN_CLOCK_MONOTONIC_RAW=5 BUILTIN_CLOCK_MONOTONIC_RAW value
	         * @property {number} BUILTIN_CLOCK_BOOTTIME=6 BUILTIN_CLOCK_BOOTTIME value
	         * @property {number} BUILTIN_CLOCK_MAX_ID=63 BUILTIN_CLOCK_MAX_ID value
	         */
	        protos.BuiltinClock = (function() {
	            var valuesById = {}, values = Object.create(valuesById);
	            values[valuesById[0] = "BUILTIN_CLOCK_UNKNOWN"] = 0;
	            values[valuesById[1] = "BUILTIN_CLOCK_REALTIME"] = 1;
	            values[valuesById[2] = "BUILTIN_CLOCK_REALTIME_COARSE"] = 2;
	            values[valuesById[3] = "BUILTIN_CLOCK_MONOTONIC"] = 3;
	            values[valuesById[4] = "BUILTIN_CLOCK_MONOTONIC_COARSE"] = 4;
	            values[valuesById[5] = "BUILTIN_CLOCK_MONOTONIC_RAW"] = 5;
	            values[valuesById[6] = "BUILTIN_CLOCK_BOOTTIME"] = 6;
	            values[valuesById[63] = "BUILTIN_CLOCK_MAX_ID"] = 63;
	            return values;
	        })();

	        protos.AndroidGameInterventionListConfig = (function() {

	            /**
	             * Properties of an AndroidGameInterventionListConfig.
	             * @memberof perfetto.protos
	             * @interface IAndroidGameInterventionListConfig
	             * @property {Array.<string>|null} [packageNameFilter] AndroidGameInterventionListConfig packageNameFilter
	             */

	            /**
	             * Constructs a new AndroidGameInterventionListConfig.
	             * @memberof perfetto.protos
	             * @classdesc Represents an AndroidGameInterventionListConfig.
	             * @implements IAndroidGameInterventionListConfig
	             * @constructor
	             * @param {perfetto.protos.IAndroidGameInterventionListConfig=} [p] Properties to set
	             */
	            function AndroidGameInterventionListConfig(p) {
	                this.packageNameFilter = [];
	                if (p)
	                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
	                        if (p[ks[i]] != null)
	                            this[ks[i]] = p[ks[i]];
	            }

	            /**
	             * AndroidGameInterventionListConfig packageNameFilter.
	             * @member {Array.<string>} packageNameFilter
	             * @memberof perfetto.protos.AndroidGameInterventionListConfig
	             * @instance
	             */
	            AndroidGameInterventionListConfig.prototype.packageNameFilter = $util.emptyArray;

	            /**
	             * Creates a new AndroidGameInterventionListConfig instance using the specified properties.
	             * @function create
	             * @memberof perfetto.protos.AndroidGameInterventionListConfig
	             * @static
	             * @param {perfetto.protos.IAndroidGameInterventionListConfig=} [properties] Properties to set
	             * @returns {perfetto.protos.AndroidGameInterventionListConfig} AndroidGameInterventionListConfig instance
	             */
	            AndroidGameInterventionListConfig.create = function create(properties) {
	                return new AndroidGameInterventionListConfig(properties);
	            };

	            /**
	             * Encodes the specified AndroidGameInterventionListConfig message. Does not implicitly {@link perfetto.protos.AndroidGameInterventionListConfig.verify|verify} messages.
	             * @function encode
	             * @memberof perfetto.protos.AndroidGameInterventionListConfig
	             * @static
	             * @param {perfetto.protos.IAndroidGameInterventionListConfig} m AndroidGameInterventionListConfig message or plain object to encode
	             * @param {$protobuf.Writer} [w] Writer to encode to
	             * @returns {$protobuf.Writer} Writer
	             */
	            AndroidGameInterventionListConfig.encode = function encode(m, w) {
	                if (!w)
	                    w = $Writer.create();
	                if (m.packageNameFilter != null && m.packageNameFilter.length) {
	                    for (var i = 0; i < m.packageNameFilter.length; ++i)
	                        w.uint32(10).string(m.packageNameFilter[i]);
	                }
	                return w;
	            };

	            /**
	             * Decodes an AndroidGameInterventionListConfig message from the specified reader or buffer.
	             * @function decode
	             * @memberof perfetto.protos.AndroidGameInterventionListConfig
	             * @static
	             * @param {$protobuf.Reader|Uint8Array} r Reader or buffer to decode from
	             * @param {number} [l] Message length if known beforehand
	             * @returns {perfetto.protos.AndroidGameInterventionListConfig} AndroidGameInterventionListConfig
	             * @throws {Error} If the payload is not a reader or valid buffer
	             * @throws {$protobuf.util.ProtocolError} If required fields are missing
	             */
	            AndroidGameInterventionListConfig.decode = function decode(r, l) {
	                if (!(r instanceof $Reader))
	                    r = $Reader.create(r);
	                var c = l === undefined ? r.len : r.pos + l, m = new $root.perfetto.protos.AndroidGameInterventionListConfig();
	                while (r.pos < c) {
	                    var t = r.uint32();
	                    switch (t >>> 3) {
	                    case 1:
	                        if (!(m.packageNameFilter && m.packageNameFilter.length))
	                            m.packageNameFilter = [];
	                        m.packageNameFilter.push(r.string());
	                        break;
	                    default:
	                        r.skipType(t & 7);
	                        break;
	                    }
	                }
	                return m;
	            };

	            /**
	             * Creates an AndroidGameInterventionListConfig message from a plain object. Also converts values to their respective internal types.
	             * @function fromObject
	             * @memberof perfetto.protos.AndroidGameInterventionListConfig
	             * @static
	             * @param {Object.<string,*>} d Plain object
	             * @returns {perfetto.protos.AndroidGameInterventionListConfig} AndroidGameInterventionListConfig
	             */
	            AndroidGameInterventionListConfig.fromObject = function fromObject(d) {
	                if (d instanceof $root.perfetto.protos.AndroidGameInterventionListConfig)
	                    return d;
	                var m = new $root.perfetto.protos.AndroidGameInterventionListConfig();
	                if (d.packageNameFilter) {
	                    if (!Array.isArray(d.packageNameFilter))
	                        throw TypeError(".perfetto.protos.AndroidGameInterventionListConfig.packageNameFilter: array expected");
	                    m.packageNameFilter = [];
	                    for (var i = 0; i < d.packageNameFilter.length; ++i) {
	                        m.packageNameFilter[i] = String(d.packageNameFilter[i]);
	                    }
	                }
	                return m;
	            };

	            /**
	             * Creates a plain object from an AndroidGameInterventionListConfig message. Also converts values to other types if specified.
	             * @function toObject
	             * @memberof perfetto.protos.AndroidGameInterventionListConfig
	             * @static
	             * @param {perfetto.protos.AndroidGameInterventionListConfig} m AndroidGameInterventionListConfig
	             * @param {$protobuf.IConversionOptions} [o] Conversion options
	             * @returns {Object.<string,*>} Plain object
	             */
	            AndroidGameInterventionListConfig.toObject = function toObject(m, o) {
	                if (!o)
	                    o = {};
	                var d = {};
	                if (o.arrays || o.defaults) {
	                    d.packageNameFilter = [];
	                }
	                if (m.packageNameFilter && m.packageNameFilter.length) {
	                    d.packageNameFilter = [];
	                    for (var j = 0; j < m.packageNameFilter.length; ++j) {
	                        d.packageNameFilter[j] = m.packageNameFilter[j];
	                    }
	                }
	                return d;
	            };

	            /**
	             * Converts this AndroidGameInterventionListConfig to JSON.
	             * @function toJSON
	             * @memberof perfetto.protos.AndroidGameInterventionListConfig
	             * @instance
	             * @returns {Object.<string,*>} JSON object
	             */
	            AndroidGameInterventionListConfig.prototype.toJSON = function toJSON() {
	                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
	            };

	            return AndroidGameInterventionListConfig;
	        })();

	        /**
	         * AndroidLogId enum.
	         * @name perfetto.protos.AndroidLogId
	         * @enum {number}
	         * @property {number} LID_DEFAULT=0 LID_DEFAULT value
	         * @property {number} LID_RADIO=1 LID_RADIO value
	         * @property {number} LID_EVENTS=2 LID_EVENTS value
	         * @property {number} LID_SYSTEM=3 LID_SYSTEM value
	         * @property {number} LID_CRASH=4 LID_CRASH value
	         * @property {number} LID_STATS=5 LID_STATS value
	         * @property {number} LID_SECURITY=6 LID_SECURITY value
	         * @property {number} LID_KERNEL=7 LID_KERNEL value
	         */
	        protos.AndroidLogId = (function() {
	            var valuesById = {}, values = Object.create(valuesById);
	            values[valuesById[0] = "LID_DEFAULT"] = 0;
	            values[valuesById[1] = "LID_RADIO"] = 1;
	            values[valuesById[2] = "LID_EVENTS"] = 2;
	            values[valuesById[3] = "LID_SYSTEM"] = 3;
	            values[valuesById[4] = "LID_CRASH"] = 4;
	            values[valuesById[5] = "LID_STATS"] = 5;
	            values[valuesById[6] = "LID_SECURITY"] = 6;
	            values[valuesById[7] = "LID_KERNEL"] = 7;
	            return values;
	        })();

	        /**
	         * AndroidLogPriority enum.
	         * @name perfetto.protos.AndroidLogPriority
	         * @enum {number}
	         * @property {number} PRIO_UNSPECIFIED=0 PRIO_UNSPECIFIED value
	         * @property {number} PRIO_UNUSED=1 PRIO_UNUSED value
	         * @property {number} PRIO_VERBOSE=2 PRIO_VERBOSE value
	         * @property {number} PRIO_DEBUG=3 PRIO_DEBUG value
	         * @property {number} PRIO_INFO=4 PRIO_INFO value
	         * @property {number} PRIO_WARN=5 PRIO_WARN value
	         * @property {number} PRIO_ERROR=6 PRIO_ERROR value
	         * @property {number} PRIO_FATAL=7 PRIO_FATAL value
	         */
	        protos.AndroidLogPriority = (function() {
	            var valuesById = {}, values = Object.create(valuesById);
	            values[valuesById[0] = "PRIO_UNSPECIFIED"] = 0;
	            values[valuesById[1] = "PRIO_UNUSED"] = 1;
	            values[valuesById[2] = "PRIO_VERBOSE"] = 2;
	            values[valuesById[3] = "PRIO_DEBUG"] = 3;
	            values[valuesById[4] = "PRIO_INFO"] = 4;
	            values[valuesById[5] = "PRIO_WARN"] = 5;
	            values[valuesById[6] = "PRIO_ERROR"] = 6;
	            values[valuesById[7] = "PRIO_FATAL"] = 7;
	            return values;
	        })();

	        protos.AndroidLogConfig = (function() {

	            /**
	             * Properties of an AndroidLogConfig.
	             * @memberof perfetto.protos
	             * @interface IAndroidLogConfig
	             * @property {Array.<perfetto.protos.AndroidLogId>|null} [logIds] AndroidLogConfig logIds
	             * @property {perfetto.protos.AndroidLogPriority|null} [minPrio] AndroidLogConfig minPrio
	             * @property {Array.<string>|null} [filterTags] AndroidLogConfig filterTags
	             */

	            /**
	             * Constructs a new AndroidLogConfig.
	             * @memberof perfetto.protos
	             * @classdesc Represents an AndroidLogConfig.
	             * @implements IAndroidLogConfig
	             * @constructor
	             * @param {perfetto.protos.IAndroidLogConfig=} [p] Properties to set
	             */
	            function AndroidLogConfig(p) {
	                this.logIds = [];
	                this.filterTags = [];
	                if (p)
	                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
	                        if (p[ks[i]] != null)
	                            this[ks[i]] = p[ks[i]];
	            }

	            /**
	             * AndroidLogConfig logIds.
	             * @member {Array.<perfetto.protos.AndroidLogId>} logIds
	             * @memberof perfetto.protos.AndroidLogConfig
	             * @instance
	             */
	            AndroidLogConfig.prototype.logIds = $util.emptyArray;

	            /**
	             * AndroidLogConfig minPrio.
	             * @member {perfetto.protos.AndroidLogPriority} minPrio
	             * @memberof perfetto.protos.AndroidLogConfig
	             * @instance
	             */
	            AndroidLogConfig.prototype.minPrio = 0;

	            /**
	             * AndroidLogConfig filterTags.
	             * @member {Array.<string>} filterTags
	             * @memberof perfetto.protos.AndroidLogConfig
	             * @instance
	             */
	            AndroidLogConfig.prototype.filterTags = $util.emptyArray;

	            /**
	             * Creates a new AndroidLogConfig instance using the specified properties.
	             * @function create
	             * @memberof perfetto.protos.AndroidLogConfig
	             * @static
	             * @param {perfetto.protos.IAndroidLogConfig=} [properties] Properties to set
	             * @returns {perfetto.protos.AndroidLogConfig} AndroidLogConfig instance
	             */
	            AndroidLogConfig.create = function create(properties) {
	                return new AndroidLogConfig(properties);
	            };

	            /**
	             * Encodes the specified AndroidLogConfig message. Does not implicitly {@link perfetto.protos.AndroidLogConfig.verify|verify} messages.
	             * @function encode
	             * @memberof perfetto.protos.AndroidLogConfig
	             * @static
	             * @param {perfetto.protos.IAndroidLogConfig} m AndroidLogConfig message or plain object to encode
	             * @param {$protobuf.Writer} [w] Writer to encode to
	             * @returns {$protobuf.Writer} Writer
	             */
	            AndroidLogConfig.encode = function encode(m, w) {
	                if (!w)
	                    w = $Writer.create();
	                if (m.logIds != null && m.logIds.length) {
	                    for (var i = 0; i < m.logIds.length; ++i)
	                        w.uint32(8).int32(m.logIds[i]);
	                }
	                if (m.minPrio != null && Object.hasOwnProperty.call(m, "minPrio"))
	                    w.uint32(24).int32(m.minPrio);
	                if (m.filterTags != null && m.filterTags.length) {
	                    for (var i = 0; i < m.filterTags.length; ++i)
	                        w.uint32(34).string(m.filterTags[i]);
	                }
	                return w;
	            };

	            /**
	             * Decodes an AndroidLogConfig message from the specified reader or buffer.
	             * @function decode
	             * @memberof perfetto.protos.AndroidLogConfig
	             * @static
	             * @param {$protobuf.Reader|Uint8Array} r Reader or buffer to decode from
	             * @param {number} [l] Message length if known beforehand
	             * @returns {perfetto.protos.AndroidLogConfig} AndroidLogConfig
	             * @throws {Error} If the payload is not a reader or valid buffer
	             * @throws {$protobuf.util.ProtocolError} If required fields are missing
	             */
	            AndroidLogConfig.decode = function decode(r, l) {
	                if (!(r instanceof $Reader))
	                    r = $Reader.create(r);
	                var c = l === undefined ? r.len : r.pos + l, m = new $root.perfetto.protos.AndroidLogConfig();
	                while (r.pos < c) {
	                    var t = r.uint32();
	                    switch (t >>> 3) {
	                    case 1:
	                        if (!(m.logIds && m.logIds.length))
	                            m.logIds = [];
	                        if ((t & 7) === 2) {
	                            var c2 = r.uint32() + r.pos;
	                            while (r.pos < c2)
	                                m.logIds.push(r.int32());
	                        } else
	                            m.logIds.push(r.int32());
	                        break;
	                    case 3:
	                        m.minPrio = r.int32();
	                        break;
	                    case 4:
	                        if (!(m.filterTags && m.filterTags.length))
	                            m.filterTags = [];
	                        m.filterTags.push(r.string());
	                        break;
	                    default:
	                        r.skipType(t & 7);
	                        break;
	                    }
	                }
	                return m;
	            };

	            /**
	             * Creates an AndroidLogConfig message from a plain object. Also converts values to their respective internal types.
	             * @function fromObject
	             * @memberof perfetto.protos.AndroidLogConfig
	             * @static
	             * @param {Object.<string,*>} d Plain object
	             * @returns {perfetto.protos.AndroidLogConfig} AndroidLogConfig
	             */
	            AndroidLogConfig.fromObject = function fromObject(d) {
	                if (d instanceof $root.perfetto.protos.AndroidLogConfig)
	                    return d;
	                var m = new $root.perfetto.protos.AndroidLogConfig();
	                if (d.logIds) {
	                    if (!Array.isArray(d.logIds))
	                        throw TypeError(".perfetto.protos.AndroidLogConfig.logIds: array expected");
	                    m.logIds = [];
	                    for (var i = 0; i < d.logIds.length; ++i) {
	                        switch (d.logIds[i]) {
	                        default:
	                        case "LID_DEFAULT":
	                        case 0:
	                            m.logIds[i] = 0;
	                            break;
	                        case "LID_RADIO":
	                        case 1:
	                            m.logIds[i] = 1;
	                            break;
	                        case "LID_EVENTS":
	                        case 2:
	                            m.logIds[i] = 2;
	                            break;
	                        case "LID_SYSTEM":
	                        case 3:
	                            m.logIds[i] = 3;
	                            break;
	                        case "LID_CRASH":
	                        case 4:
	                            m.logIds[i] = 4;
	                            break;
	                        case "LID_STATS":
	                        case 5:
	                            m.logIds[i] = 5;
	                            break;
	                        case "LID_SECURITY":
	                        case 6:
	                            m.logIds[i] = 6;
	                            break;
	                        case "LID_KERNEL":
	                        case 7:
	                            m.logIds[i] = 7;
	                            break;
	                        }
	                    }
	                }
	                switch (d.minPrio) {
	                case "PRIO_UNSPECIFIED":
	                case 0:
	                    m.minPrio = 0;
	                    break;
	                case "PRIO_UNUSED":
	                case 1:
	                    m.minPrio = 1;
	                    break;
	                case "PRIO_VERBOSE":
	                case 2:
	                    m.minPrio = 2;
	                    break;
	                case "PRIO_DEBUG":
	                case 3:
	                    m.minPrio = 3;
	                    break;
	                case "PRIO_INFO":
	                case 4:
	                    m.minPrio = 4;
	                    break;
	                case "PRIO_WARN":
	                case 5:
	                    m.minPrio = 5;
	                    break;
	                case "PRIO_ERROR":
	                case 6:
	                    m.minPrio = 6;
	                    break;
	                case "PRIO_FATAL":
	                case 7:
	                    m.minPrio = 7;
	                    break;
	                }
	                if (d.filterTags) {
	                    if (!Array.isArray(d.filterTags))
	                        throw TypeError(".perfetto.protos.AndroidLogConfig.filterTags: array expected");
	                    m.filterTags = [];
	                    for (var i = 0; i < d.filterTags.length; ++i) {
	                        m.filterTags[i] = String(d.filterTags[i]);
	                    }
	                }
	                return m;
	            };

	            /**
	             * Creates a plain object from an AndroidLogConfig message. Also converts values to other types if specified.
	             * @function toObject
	             * @memberof perfetto.protos.AndroidLogConfig
	             * @static
	             * @param {perfetto.protos.AndroidLogConfig} m AndroidLogConfig
	             * @param {$protobuf.IConversionOptions} [o] Conversion options
	             * @returns {Object.<string,*>} Plain object
	             */
	            AndroidLogConfig.toObject = function toObject(m, o) {
	                if (!o)
	                    o = {};
	                var d = {};
	                if (o.arrays || o.defaults) {
	                    d.logIds = [];
	                    d.filterTags = [];
	                }
	                if (o.defaults) {
	                    d.minPrio = o.enums === String ? "PRIO_UNSPECIFIED" : 0;
	                }
	                if (m.logIds && m.logIds.length) {
	                    d.logIds = [];
	                    for (var j = 0; j < m.logIds.length; ++j) {
	                        d.logIds[j] = o.enums === String ? $root.perfetto.protos.AndroidLogId[m.logIds[j]] : m.logIds[j];
	                    }
	                }
	                if (m.minPrio != null && m.hasOwnProperty("minPrio")) {
	                    d.minPrio = o.enums === String ? $root.perfetto.protos.AndroidLogPriority[m.minPrio] : m.minPrio;
	                }
	                if (m.filterTags && m.filterTags.length) {
	                    d.filterTags = [];
	                    for (var j = 0; j < m.filterTags.length; ++j) {
	                        d.filterTags[j] = m.filterTags[j];
	                    }
	                }
	                return d;
	            };

	            /**
	             * Converts this AndroidLogConfig to JSON.
	             * @function toJSON
	             * @memberof perfetto.protos.AndroidLogConfig
	             * @instance
	             * @returns {Object.<string,*>} JSON object
	             */
	            AndroidLogConfig.prototype.toJSON = function toJSON() {
	                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
	            };

	            return AndroidLogConfig;
	        })();

	        protos.AndroidPolledStateConfig = (function() {

	            /**
	             * Properties of an AndroidPolledStateConfig.
	             * @memberof perfetto.protos
	             * @interface IAndroidPolledStateConfig
	             * @property {number|null} [pollMs] AndroidPolledStateConfig pollMs
	             */

	            /**
	             * Constructs a new AndroidPolledStateConfig.
	             * @memberof perfetto.protos
	             * @classdesc Represents an AndroidPolledStateConfig.
	             * @implements IAndroidPolledStateConfig
	             * @constructor
	             * @param {perfetto.protos.IAndroidPolledStateConfig=} [p] Properties to set
	             */
	            function AndroidPolledStateConfig(p) {
	                if (p)
	                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
	                        if (p[ks[i]] != null)
	                            this[ks[i]] = p[ks[i]];
	            }

	            /**
	             * AndroidPolledStateConfig pollMs.
	             * @member {number} pollMs
	             * @memberof perfetto.protos.AndroidPolledStateConfig
	             * @instance
	             */
	            AndroidPolledStateConfig.prototype.pollMs = 0;

	            /**
	             * Creates a new AndroidPolledStateConfig instance using the specified properties.
	             * @function create
	             * @memberof perfetto.protos.AndroidPolledStateConfig
	             * @static
	             * @param {perfetto.protos.IAndroidPolledStateConfig=} [properties] Properties to set
	             * @returns {perfetto.protos.AndroidPolledStateConfig} AndroidPolledStateConfig instance
	             */
	            AndroidPolledStateConfig.create = function create(properties) {
	                return new AndroidPolledStateConfig(properties);
	            };

	            /**
	             * Encodes the specified AndroidPolledStateConfig message. Does not implicitly {@link perfetto.protos.AndroidPolledStateConfig.verify|verify} messages.
	             * @function encode
	             * @memberof perfetto.protos.AndroidPolledStateConfig
	             * @static
	             * @param {perfetto.protos.IAndroidPolledStateConfig} m AndroidPolledStateConfig message or plain object to encode
	             * @param {$protobuf.Writer} [w] Writer to encode to
	             * @returns {$protobuf.Writer} Writer
	             */
	            AndroidPolledStateConfig.encode = function encode(m, w) {
	                if (!w)
	                    w = $Writer.create();
	                if (m.pollMs != null && Object.hasOwnProperty.call(m, "pollMs"))
	                    w.uint32(8).uint32(m.pollMs);
	                return w;
	            };

	            /**
	             * Decodes an AndroidPolledStateConfig message from the specified reader or buffer.
	             * @function decode
	             * @memberof perfetto.protos.AndroidPolledStateConfig
	             * @static
	             * @param {$protobuf.Reader|Uint8Array} r Reader or buffer to decode from
	             * @param {number} [l] Message length if known beforehand
	             * @returns {perfetto.protos.AndroidPolledStateConfig} AndroidPolledStateConfig
	             * @throws {Error} If the payload is not a reader or valid buffer
	             * @throws {$protobuf.util.ProtocolError} If required fields are missing
	             */
	            AndroidPolledStateConfig.decode = function decode(r, l) {
	                if (!(r instanceof $Reader))
	                    r = $Reader.create(r);
	                var c = l === undefined ? r.len : r.pos + l, m = new $root.perfetto.protos.AndroidPolledStateConfig();
	                while (r.pos < c) {
	                    var t = r.uint32();
	                    switch (t >>> 3) {
	                    case 1:
	                        m.pollMs = r.uint32();
	                        break;
	                    default:
	                        r.skipType(t & 7);
	                        break;
	                    }
	                }
	                return m;
	            };

	            /**
	             * Creates an AndroidPolledStateConfig message from a plain object. Also converts values to their respective internal types.
	             * @function fromObject
	             * @memberof perfetto.protos.AndroidPolledStateConfig
	             * @static
	             * @param {Object.<string,*>} d Plain object
	             * @returns {perfetto.protos.AndroidPolledStateConfig} AndroidPolledStateConfig
	             */
	            AndroidPolledStateConfig.fromObject = function fromObject(d) {
	                if (d instanceof $root.perfetto.protos.AndroidPolledStateConfig)
	                    return d;
	                var m = new $root.perfetto.protos.AndroidPolledStateConfig();
	                if (d.pollMs != null) {
	                    m.pollMs = d.pollMs >>> 0;
	                }
	                return m;
	            };

	            /**
	             * Creates a plain object from an AndroidPolledStateConfig message. Also converts values to other types if specified.
	             * @function toObject
	             * @memberof perfetto.protos.AndroidPolledStateConfig
	             * @static
	             * @param {perfetto.protos.AndroidPolledStateConfig} m AndroidPolledStateConfig
	             * @param {$protobuf.IConversionOptions} [o] Conversion options
	             * @returns {Object.<string,*>} Plain object
	             */
	            AndroidPolledStateConfig.toObject = function toObject(m, o) {
	                if (!o)
	                    o = {};
	                var d = {};
	                if (o.defaults) {
	                    d.pollMs = 0;
	                }
	                if (m.pollMs != null && m.hasOwnProperty("pollMs")) {
	                    d.pollMs = m.pollMs;
	                }
	                return d;
	            };

	            /**
	             * Converts this AndroidPolledStateConfig to JSON.
	             * @function toJSON
	             * @memberof perfetto.protos.AndroidPolledStateConfig
	             * @instance
	             * @returns {Object.<string,*>} JSON object
	             */
	            AndroidPolledStateConfig.prototype.toJSON = function toJSON() {
	                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
	            };

	            return AndroidPolledStateConfig;
	        })();

	        protos.AndroidSystemPropertyConfig = (function() {

	            /**
	             * Properties of an AndroidSystemPropertyConfig.
	             * @memberof perfetto.protos
	             * @interface IAndroidSystemPropertyConfig
	             * @property {number|null} [pollMs] AndroidSystemPropertyConfig pollMs
	             * @property {Array.<string>|null} [propertyName] AndroidSystemPropertyConfig propertyName
	             */

	            /**
	             * Constructs a new AndroidSystemPropertyConfig.
	             * @memberof perfetto.protos
	             * @classdesc Represents an AndroidSystemPropertyConfig.
	             * @implements IAndroidSystemPropertyConfig
	             * @constructor
	             * @param {perfetto.protos.IAndroidSystemPropertyConfig=} [p] Properties to set
	             */
	            function AndroidSystemPropertyConfig(p) {
	                this.propertyName = [];
	                if (p)
	                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
	                        if (p[ks[i]] != null)
	                            this[ks[i]] = p[ks[i]];
	            }

	            /**
	             * AndroidSystemPropertyConfig pollMs.
	             * @member {number} pollMs
	             * @memberof perfetto.protos.AndroidSystemPropertyConfig
	             * @instance
	             */
	            AndroidSystemPropertyConfig.prototype.pollMs = 0;

	            /**
	             * AndroidSystemPropertyConfig propertyName.
	             * @member {Array.<string>} propertyName
	             * @memberof perfetto.protos.AndroidSystemPropertyConfig
	             * @instance
	             */
	            AndroidSystemPropertyConfig.prototype.propertyName = $util.emptyArray;

	            /**
	             * Creates a new AndroidSystemPropertyConfig instance using the specified properties.
	             * @function create
	             * @memberof perfetto.protos.AndroidSystemPropertyConfig
	             * @static
	             * @param {perfetto.protos.IAndroidSystemPropertyConfig=} [properties] Properties to set
	             * @returns {perfetto.protos.AndroidSystemPropertyConfig} AndroidSystemPropertyConfig instance
	             */
	            AndroidSystemPropertyConfig.create = function create(properties) {
	                return new AndroidSystemPropertyConfig(properties);
	            };

	            /**
	             * Encodes the specified AndroidSystemPropertyConfig message. Does not implicitly {@link perfetto.protos.AndroidSystemPropertyConfig.verify|verify} messages.
	             * @function encode
	             * @memberof perfetto.protos.AndroidSystemPropertyConfig
	             * @static
	             * @param {perfetto.protos.IAndroidSystemPropertyConfig} m AndroidSystemPropertyConfig message or plain object to encode
	             * @param {$protobuf.Writer} [w] Writer to encode to
	             * @returns {$protobuf.Writer} Writer
	             */
	            AndroidSystemPropertyConfig.encode = function encode(m, w) {
	                if (!w)
	                    w = $Writer.create();
	                if (m.pollMs != null && Object.hasOwnProperty.call(m, "pollMs"))
	                    w.uint32(8).uint32(m.pollMs);
	                if (m.propertyName != null && m.propertyName.length) {
	                    for (var i = 0; i < m.propertyName.length; ++i)
	                        w.uint32(18).string(m.propertyName[i]);
	                }
	                return w;
	            };

	            /**
	             * Decodes an AndroidSystemPropertyConfig message from the specified reader or buffer.
	             * @function decode
	             * @memberof perfetto.protos.AndroidSystemPropertyConfig
	             * @static
	             * @param {$protobuf.Reader|Uint8Array} r Reader or buffer to decode from
	             * @param {number} [l] Message length if known beforehand
	             * @returns {perfetto.protos.AndroidSystemPropertyConfig} AndroidSystemPropertyConfig
	             * @throws {Error} If the payload is not a reader or valid buffer
	             * @throws {$protobuf.util.ProtocolError} If required fields are missing
	             */
	            AndroidSystemPropertyConfig.decode = function decode(r, l) {
	                if (!(r instanceof $Reader))
	                    r = $Reader.create(r);
	                var c = l === undefined ? r.len : r.pos + l, m = new $root.perfetto.protos.AndroidSystemPropertyConfig();
	                while (r.pos < c) {
	                    var t = r.uint32();
	                    switch (t >>> 3) {
	                    case 1:
	                        m.pollMs = r.uint32();
	                        break;
	                    case 2:
	                        if (!(m.propertyName && m.propertyName.length))
	                            m.propertyName = [];
	                        m.propertyName.push(r.string());
	                        break;
	                    default:
	                        r.skipType(t & 7);
	                        break;
	                    }
	                }
	                return m;
	            };

	            /**
	             * Creates an AndroidSystemPropertyConfig message from a plain object. Also converts values to their respective internal types.
	             * @function fromObject
	             * @memberof perfetto.protos.AndroidSystemPropertyConfig
	             * @static
	             * @param {Object.<string,*>} d Plain object
	             * @returns {perfetto.protos.AndroidSystemPropertyConfig} AndroidSystemPropertyConfig
	             */
	            AndroidSystemPropertyConfig.fromObject = function fromObject(d) {
	                if (d instanceof $root.perfetto.protos.AndroidSystemPropertyConfig)
	                    return d;
	                var m = new $root.perfetto.protos.AndroidSystemPropertyConfig();
	                if (d.pollMs != null) {
	                    m.pollMs = d.pollMs >>> 0;
	                }
	                if (d.propertyName) {
	                    if (!Array.isArray(d.propertyName))
	                        throw TypeError(".perfetto.protos.AndroidSystemPropertyConfig.propertyName: array expected");
	                    m.propertyName = [];
	                    for (var i = 0; i < d.propertyName.length; ++i) {
	                        m.propertyName[i] = String(d.propertyName[i]);
	                    }
	                }
	                return m;
	            };

	            /**
	             * Creates a plain object from an AndroidSystemPropertyConfig message. Also converts values to other types if specified.
	             * @function toObject
	             * @memberof perfetto.protos.AndroidSystemPropertyConfig
	             * @static
	             * @param {perfetto.protos.AndroidSystemPropertyConfig} m AndroidSystemPropertyConfig
	             * @param {$protobuf.IConversionOptions} [o] Conversion options
	             * @returns {Object.<string,*>} Plain object
	             */
	            AndroidSystemPropertyConfig.toObject = function toObject(m, o) {
	                if (!o)
	                    o = {};
	                var d = {};
	                if (o.arrays || o.defaults) {
	                    d.propertyName = [];
	                }
	                if (o.defaults) {
	                    d.pollMs = 0;
	                }
	                if (m.pollMs != null && m.hasOwnProperty("pollMs")) {
	                    d.pollMs = m.pollMs;
	                }
	                if (m.propertyName && m.propertyName.length) {
	                    d.propertyName = [];
	                    for (var j = 0; j < m.propertyName.length; ++j) {
	                        d.propertyName[j] = m.propertyName[j];
	                    }
	                }
	                return d;
	            };

	            /**
	             * Converts this AndroidSystemPropertyConfig to JSON.
	             * @function toJSON
	             * @memberof perfetto.protos.AndroidSystemPropertyConfig
	             * @instance
	             * @returns {Object.<string,*>} JSON object
	             */
	            AndroidSystemPropertyConfig.prototype.toJSON = function toJSON() {
	                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
	            };

	            return AndroidSystemPropertyConfig;
	        })();

	        protos.NetworkPacketTraceConfig = (function() {

	            /**
	             * Properties of a NetworkPacketTraceConfig.
	             * @memberof perfetto.protos
	             * @interface INetworkPacketTraceConfig
	             * @property {number|null} [pollMs] NetworkPacketTraceConfig pollMs
	             * @property {number|null} [aggregationThreshold] record per-packet details. A value of 1 always records aggregate details.
	             * @property {number|null} [internLimit] NetworkPacketTraceConfig internLimit
	             * @property {boolean|null} [dropLocalPort] NetworkPacketTraceConfig dropLocalPort
	             * @property {boolean|null} [dropRemotePort] NetworkPacketTraceConfig dropRemotePort
	             * @property {boolean|null} [dropTcpFlags] NetworkPacketTraceConfig dropTcpFlags
	             */

	            /**
	             * Constructs a new NetworkPacketTraceConfig.
	             * @memberof perfetto.protos
	             * @classdesc Represents a NetworkPacketTraceConfig.
	             * @implements INetworkPacketTraceConfig
	             * @constructor
	             * @param {perfetto.protos.INetworkPacketTraceConfig=} [p] Properties to set
	             */
	            function NetworkPacketTraceConfig(p) {
	                if (p)
	                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
	                        if (p[ks[i]] != null)
	                            this[ks[i]] = p[ks[i]];
	            }

	            /**
	             * NetworkPacketTraceConfig pollMs.
	             * @member {number} pollMs
	             * @memberof perfetto.protos.NetworkPacketTraceConfig
	             * @instance
	             */
	            NetworkPacketTraceConfig.prototype.pollMs = 0;

	            /**
	             * record per-packet details. A value of 1 always records aggregate details.
	             * @member {number} aggregationThreshold
	             * @memberof perfetto.protos.NetworkPacketTraceConfig
	             * @instance
	             */
	            NetworkPacketTraceConfig.prototype.aggregationThreshold = 0;

	            /**
	             * NetworkPacketTraceConfig internLimit.
	             * @member {number} internLimit
	             * @memberof perfetto.protos.NetworkPacketTraceConfig
	             * @instance
	             */
	            NetworkPacketTraceConfig.prototype.internLimit = 0;

	            /**
	             * NetworkPacketTraceConfig dropLocalPort.
	             * @member {boolean} dropLocalPort
	             * @memberof perfetto.protos.NetworkPacketTraceConfig
	             * @instance
	             */
	            NetworkPacketTraceConfig.prototype.dropLocalPort = false;

	            /**
	             * NetworkPacketTraceConfig dropRemotePort.
	             * @member {boolean} dropRemotePort
	             * @memberof perfetto.protos.NetworkPacketTraceConfig
	             * @instance
	             */
	            NetworkPacketTraceConfig.prototype.dropRemotePort = false;

	            /**
	             * NetworkPacketTraceConfig dropTcpFlags.
	             * @member {boolean} dropTcpFlags
	             * @memberof perfetto.protos.NetworkPacketTraceConfig
	             * @instance
	             */
	            NetworkPacketTraceConfig.prototype.dropTcpFlags = false;

	            /**
	             * Creates a new NetworkPacketTraceConfig instance using the specified properties.
	             * @function create
	             * @memberof perfetto.protos.NetworkPacketTraceConfig
	             * @static
	             * @param {perfetto.protos.INetworkPacketTraceConfig=} [properties] Properties to set
	             * @returns {perfetto.protos.NetworkPacketTraceConfig} NetworkPacketTraceConfig instance
	             */
	            NetworkPacketTraceConfig.create = function create(properties) {
	                return new NetworkPacketTraceConfig(properties);
	            };

	            /**
	             * Encodes the specified NetworkPacketTraceConfig message. Does not implicitly {@link perfetto.protos.NetworkPacketTraceConfig.verify|verify} messages.
	             * @function encode
	             * @memberof perfetto.protos.NetworkPacketTraceConfig
	             * @static
	             * @param {perfetto.protos.INetworkPacketTraceConfig} m NetworkPacketTraceConfig message or plain object to encode
	             * @param {$protobuf.Writer} [w] Writer to encode to
	             * @returns {$protobuf.Writer} Writer
	             */
	            NetworkPacketTraceConfig.encode = function encode(m, w) {
	                if (!w)
	                    w = $Writer.create();
	                if (m.pollMs != null && Object.hasOwnProperty.call(m, "pollMs"))
	                    w.uint32(8).uint32(m.pollMs);
	                if (m.aggregationThreshold != null && Object.hasOwnProperty.call(m, "aggregationThreshold"))
	                    w.uint32(16).uint32(m.aggregationThreshold);
	                if (m.internLimit != null && Object.hasOwnProperty.call(m, "internLimit"))
	                    w.uint32(24).uint32(m.internLimit);
	                if (m.dropLocalPort != null && Object.hasOwnProperty.call(m, "dropLocalPort"))
	                    w.uint32(32).bool(m.dropLocalPort);
	                if (m.dropRemotePort != null && Object.hasOwnProperty.call(m, "dropRemotePort"))
	                    w.uint32(40).bool(m.dropRemotePort);
	                if (m.dropTcpFlags != null && Object.hasOwnProperty.call(m, "dropTcpFlags"))
	                    w.uint32(48).bool(m.dropTcpFlags);
	                return w;
	            };

	            /**
	             * Decodes a NetworkPacketTraceConfig message from the specified reader or buffer.
	             * @function decode
	             * @memberof perfetto.protos.NetworkPacketTraceConfig
	             * @static
	             * @param {$protobuf.Reader|Uint8Array} r Reader or buffer to decode from
	             * @param {number} [l] Message length if known beforehand
	             * @returns {perfetto.protos.NetworkPacketTraceConfig} NetworkPacketTraceConfig
	             * @throws {Error} If the payload is not a reader or valid buffer
	             * @throws {$protobuf.util.ProtocolError} If required fields are missing
	             */
	            NetworkPacketTraceConfig.decode = function decode(r, l) {
	                if (!(r instanceof $Reader))
	                    r = $Reader.create(r);
	                var c = l === undefined ? r.len : r.pos + l, m = new $root.perfetto.protos.NetworkPacketTraceConfig();
	                while (r.pos < c) {
	                    var t = r.uint32();
	                    switch (t >>> 3) {
	                    case 1:
	                        m.pollMs = r.uint32();
	                        break;
	                    case 2:
	                        m.aggregationThreshold = r.uint32();
	                        break;
	                    case 3:
	                        m.internLimit = r.uint32();
	                        break;
	                    case 4:
	                        m.dropLocalPort = r.bool();
	                        break;
	                    case 5:
	                        m.dropRemotePort = r.bool();
	                        break;
	                    case 6:
	                        m.dropTcpFlags = r.bool();
	                        break;
	                    default:
	                        r.skipType(t & 7);
	                        break;
	                    }
	                }
	                return m;
	            };

	            /**
	             * Creates a NetworkPacketTraceConfig message from a plain object. Also converts values to their respective internal types.
	             * @function fromObject
	             * @memberof perfetto.protos.NetworkPacketTraceConfig
	             * @static
	             * @param {Object.<string,*>} d Plain object
	             * @returns {perfetto.protos.NetworkPacketTraceConfig} NetworkPacketTraceConfig
	             */
	            NetworkPacketTraceConfig.fromObject = function fromObject(d) {
	                if (d instanceof $root.perfetto.protos.NetworkPacketTraceConfig)
	                    return d;
	                var m = new $root.perfetto.protos.NetworkPacketTraceConfig();
	                if (d.pollMs != null) {
	                    m.pollMs = d.pollMs >>> 0;
	                }
	                if (d.aggregationThreshold != null) {
	                    m.aggregationThreshold = d.aggregationThreshold >>> 0;
	                }
	                if (d.internLimit != null) {
	                    m.internLimit = d.internLimit >>> 0;
	                }
	                if (d.dropLocalPort != null) {
	                    m.dropLocalPort = Boolean(d.dropLocalPort);
	                }
	                if (d.dropRemotePort != null) {
	                    m.dropRemotePort = Boolean(d.dropRemotePort);
	                }
	                if (d.dropTcpFlags != null) {
	                    m.dropTcpFlags = Boolean(d.dropTcpFlags);
	                }
	                return m;
	            };

	            /**
	             * Creates a plain object from a NetworkPacketTraceConfig message. Also converts values to other types if specified.
	             * @function toObject
	             * @memberof perfetto.protos.NetworkPacketTraceConfig
	             * @static
	             * @param {perfetto.protos.NetworkPacketTraceConfig} m NetworkPacketTraceConfig
	             * @param {$protobuf.IConversionOptions} [o] Conversion options
	             * @returns {Object.<string,*>} Plain object
	             */
	            NetworkPacketTraceConfig.toObject = function toObject(m, o) {
	                if (!o)
	                    o = {};
	                var d = {};
	                if (o.defaults) {
	                    d.pollMs = 0;
	                    d.aggregationThreshold = 0;
	                    d.internLimit = 0;
	                    d.dropLocalPort = false;
	                    d.dropRemotePort = false;
	                    d.dropTcpFlags = false;
	                }
	                if (m.pollMs != null && m.hasOwnProperty("pollMs")) {
	                    d.pollMs = m.pollMs;
	                }
	                if (m.aggregationThreshold != null && m.hasOwnProperty("aggregationThreshold")) {
	                    d.aggregationThreshold = m.aggregationThreshold;
	                }
	                if (m.internLimit != null && m.hasOwnProperty("internLimit")) {
	                    d.internLimit = m.internLimit;
	                }
	                if (m.dropLocalPort != null && m.hasOwnProperty("dropLocalPort")) {
	                    d.dropLocalPort = m.dropLocalPort;
	                }
	                if (m.dropRemotePort != null && m.hasOwnProperty("dropRemotePort")) {
	                    d.dropRemotePort = m.dropRemotePort;
	                }
	                if (m.dropTcpFlags != null && m.hasOwnProperty("dropTcpFlags")) {
	                    d.dropTcpFlags = m.dropTcpFlags;
	                }
	                return d;
	            };

	            /**
	             * Converts this NetworkPacketTraceConfig to JSON.
	             * @function toJSON
	             * @memberof perfetto.protos.NetworkPacketTraceConfig
	             * @instance
	             * @returns {Object.<string,*>} JSON object
	             */
	            NetworkPacketTraceConfig.prototype.toJSON = function toJSON() {
	                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
	            };

	            return NetworkPacketTraceConfig;
	        })();

	        protos.PackagesListConfig = (function() {

	            /**
	             * Properties of a PackagesListConfig.
	             * @memberof perfetto.protos
	             * @interface IPackagesListConfig
	             * @property {Array.<string>|null} [packageNameFilter] PackagesListConfig packageNameFilter
	             */

	            /**
	             * Constructs a new PackagesListConfig.
	             * @memberof perfetto.protos
	             * @classdesc Represents a PackagesListConfig.
	             * @implements IPackagesListConfig
	             * @constructor
	             * @param {perfetto.protos.IPackagesListConfig=} [p] Properties to set
	             */
	            function PackagesListConfig(p) {
	                this.packageNameFilter = [];
	                if (p)
	                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
	                        if (p[ks[i]] != null)
	                            this[ks[i]] = p[ks[i]];
	            }

	            /**
	             * PackagesListConfig packageNameFilter.
	             * @member {Array.<string>} packageNameFilter
	             * @memberof perfetto.protos.PackagesListConfig
	             * @instance
	             */
	            PackagesListConfig.prototype.packageNameFilter = $util.emptyArray;

	            /**
	             * Creates a new PackagesListConfig instance using the specified properties.
	             * @function create
	             * @memberof perfetto.protos.PackagesListConfig
	             * @static
	             * @param {perfetto.protos.IPackagesListConfig=} [properties] Properties to set
	             * @returns {perfetto.protos.PackagesListConfig} PackagesListConfig instance
	             */
	            PackagesListConfig.create = function create(properties) {
	                return new PackagesListConfig(properties);
	            };

	            /**
	             * Encodes the specified PackagesListConfig message. Does not implicitly {@link perfetto.protos.PackagesListConfig.verify|verify} messages.
	             * @function encode
	             * @memberof perfetto.protos.PackagesListConfig
	             * @static
	             * @param {perfetto.protos.IPackagesListConfig} m PackagesListConfig message or plain object to encode
	             * @param {$protobuf.Writer} [w] Writer to encode to
	             * @returns {$protobuf.Writer} Writer
	             */
	            PackagesListConfig.encode = function encode(m, w) {
	                if (!w)
	                    w = $Writer.create();
	                if (m.packageNameFilter != null && m.packageNameFilter.length) {
	                    for (var i = 0; i < m.packageNameFilter.length; ++i)
	                        w.uint32(10).string(m.packageNameFilter[i]);
	                }
	                return w;
	            };

	            /**
	             * Decodes a PackagesListConfig message from the specified reader or buffer.
	             * @function decode
	             * @memberof perfetto.protos.PackagesListConfig
	             * @static
	             * @param {$protobuf.Reader|Uint8Array} r Reader or buffer to decode from
	             * @param {number} [l] Message length if known beforehand
	             * @returns {perfetto.protos.PackagesListConfig} PackagesListConfig
	             * @throws {Error} If the payload is not a reader or valid buffer
	             * @throws {$protobuf.util.ProtocolError} If required fields are missing
	             */
	            PackagesListConfig.decode = function decode(r, l) {
	                if (!(r instanceof $Reader))
	                    r = $Reader.create(r);
	                var c = l === undefined ? r.len : r.pos + l, m = new $root.perfetto.protos.PackagesListConfig();
	                while (r.pos < c) {
	                    var t = r.uint32();
	                    switch (t >>> 3) {
	                    case 1:
	                        if (!(m.packageNameFilter && m.packageNameFilter.length))
	                            m.packageNameFilter = [];
	                        m.packageNameFilter.push(r.string());
	                        break;
	                    default:
	                        r.skipType(t & 7);
	                        break;
	                    }
	                }
	                return m;
	            };

	            /**
	             * Creates a PackagesListConfig message from a plain object. Also converts values to their respective internal types.
	             * @function fromObject
	             * @memberof perfetto.protos.PackagesListConfig
	             * @static
	             * @param {Object.<string,*>} d Plain object
	             * @returns {perfetto.protos.PackagesListConfig} PackagesListConfig
	             */
	            PackagesListConfig.fromObject = function fromObject(d) {
	                if (d instanceof $root.perfetto.protos.PackagesListConfig)
	                    return d;
	                var m = new $root.perfetto.protos.PackagesListConfig();
	                if (d.packageNameFilter) {
	                    if (!Array.isArray(d.packageNameFilter))
	                        throw TypeError(".perfetto.protos.PackagesListConfig.packageNameFilter: array expected");
	                    m.packageNameFilter = [];
	                    for (var i = 0; i < d.packageNameFilter.length; ++i) {
	                        m.packageNameFilter[i] = String(d.packageNameFilter[i]);
	                    }
	                }
	                return m;
	            };

	            /**
	             * Creates a plain object from a PackagesListConfig message. Also converts values to other types if specified.
	             * @function toObject
	             * @memberof perfetto.protos.PackagesListConfig
	             * @static
	             * @param {perfetto.protos.PackagesListConfig} m PackagesListConfig
	             * @param {$protobuf.IConversionOptions} [o] Conversion options
	             * @returns {Object.<string,*>} Plain object
	             */
	            PackagesListConfig.toObject = function toObject(m, o) {
	                if (!o)
	                    o = {};
	                var d = {};
	                if (o.arrays || o.defaults) {
	                    d.packageNameFilter = [];
	                }
	                if (m.packageNameFilter && m.packageNameFilter.length) {
	                    d.packageNameFilter = [];
	                    for (var j = 0; j < m.packageNameFilter.length; ++j) {
	                        d.packageNameFilter[j] = m.packageNameFilter[j];
	                    }
	                }
	                return d;
	            };

	            /**
	             * Converts this PackagesListConfig to JSON.
	             * @function toJSON
	             * @memberof perfetto.protos.PackagesListConfig
	             * @instance
	             * @returns {Object.<string,*>} JSON object
	             */
	            PackagesListConfig.prototype.toJSON = function toJSON() {
	                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
	            };

	            return PackagesListConfig;
	        })();

	        protos.ChromeConfig = (function() {

	            /**
	             * Properties of a ChromeConfig.
	             * @memberof perfetto.protos
	             * @interface IChromeConfig
	             * @property {string|null} [traceConfig] ChromeConfig traceConfig
	             * @property {boolean|null} [privacyFilteringEnabled] ChromeConfig privacyFilteringEnabled
	             * @property {boolean|null} [convertToLegacyJson] ChromeConfig convertToLegacyJson
	             * @property {perfetto.protos.ChromeConfig.ClientPriority|null} [clientPriority] ChromeConfig clientPriority
	             * @property {string|null} [jsonAgentLabelFilter] ChromeConfig jsonAgentLabelFilter
	             */

	            /**
	             * Constructs a new ChromeConfig.
	             * @memberof perfetto.protos
	             * @classdesc Represents a ChromeConfig.
	             * @implements IChromeConfig
	             * @constructor
	             * @param {perfetto.protos.IChromeConfig=} [p] Properties to set
	             */
	            function ChromeConfig(p) {
	                if (p)
	                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
	                        if (p[ks[i]] != null)
	                            this[ks[i]] = p[ks[i]];
	            }

	            /**
	             * ChromeConfig traceConfig.
	             * @member {string} traceConfig
	             * @memberof perfetto.protos.ChromeConfig
	             * @instance
	             */
	            ChromeConfig.prototype.traceConfig = "";

	            /**
	             * ChromeConfig privacyFilteringEnabled.
	             * @member {boolean} privacyFilteringEnabled
	             * @memberof perfetto.protos.ChromeConfig
	             * @instance
	             */
	            ChromeConfig.prototype.privacyFilteringEnabled = false;

	            /**
	             * ChromeConfig convertToLegacyJson.
	             * @member {boolean} convertToLegacyJson
	             * @memberof perfetto.protos.ChromeConfig
	             * @instance
	             */
	            ChromeConfig.prototype.convertToLegacyJson = false;

	            /**
	             * ChromeConfig clientPriority.
	             * @member {perfetto.protos.ChromeConfig.ClientPriority} clientPriority
	             * @memberof perfetto.protos.ChromeConfig
	             * @instance
	             */
	            ChromeConfig.prototype.clientPriority = 0;

	            /**
	             * ChromeConfig jsonAgentLabelFilter.
	             * @member {string} jsonAgentLabelFilter
	             * @memberof perfetto.protos.ChromeConfig
	             * @instance
	             */
	            ChromeConfig.prototype.jsonAgentLabelFilter = "";

	            /**
	             * Creates a new ChromeConfig instance using the specified properties.
	             * @function create
	             * @memberof perfetto.protos.ChromeConfig
	             * @static
	             * @param {perfetto.protos.IChromeConfig=} [properties] Properties to set
	             * @returns {perfetto.protos.ChromeConfig} ChromeConfig instance
	             */
	            ChromeConfig.create = function create(properties) {
	                return new ChromeConfig(properties);
	            };

	            /**
	             * Encodes the specified ChromeConfig message. Does not implicitly {@link perfetto.protos.ChromeConfig.verify|verify} messages.
	             * @function encode
	             * @memberof perfetto.protos.ChromeConfig
	             * @static
	             * @param {perfetto.protos.IChromeConfig} m ChromeConfig message or plain object to encode
	             * @param {$protobuf.Writer} [w] Writer to encode to
	             * @returns {$protobuf.Writer} Writer
	             */
	            ChromeConfig.encode = function encode(m, w) {
	                if (!w)
	                    w = $Writer.create();
	                if (m.traceConfig != null && Object.hasOwnProperty.call(m, "traceConfig"))
	                    w.uint32(10).string(m.traceConfig);
	                if (m.privacyFilteringEnabled != null && Object.hasOwnProperty.call(m, "privacyFilteringEnabled"))
	                    w.uint32(16).bool(m.privacyFilteringEnabled);
	                if (m.convertToLegacyJson != null && Object.hasOwnProperty.call(m, "convertToLegacyJson"))
	                    w.uint32(24).bool(m.convertToLegacyJson);
	                if (m.clientPriority != null && Object.hasOwnProperty.call(m, "clientPriority"))
	                    w.uint32(32).int32(m.clientPriority);
	                if (m.jsonAgentLabelFilter != null && Object.hasOwnProperty.call(m, "jsonAgentLabelFilter"))
	                    w.uint32(42).string(m.jsonAgentLabelFilter);
	                return w;
	            };

	            /**
	             * Decodes a ChromeConfig message from the specified reader or buffer.
	             * @function decode
	             * @memberof perfetto.protos.ChromeConfig
	             * @static
	             * @param {$protobuf.Reader|Uint8Array} r Reader or buffer to decode from
	             * @param {number} [l] Message length if known beforehand
	             * @returns {perfetto.protos.ChromeConfig} ChromeConfig
	             * @throws {Error} If the payload is not a reader or valid buffer
	             * @throws {$protobuf.util.ProtocolError} If required fields are missing
	             */
	            ChromeConfig.decode = function decode(r, l) {
	                if (!(r instanceof $Reader))
	                    r = $Reader.create(r);
	                var c = l === undefined ? r.len : r.pos + l, m = new $root.perfetto.protos.ChromeConfig();
	                while (r.pos < c) {
	                    var t = r.uint32();
	                    switch (t >>> 3) {
	                    case 1:
	                        m.traceConfig = r.string();
	                        break;
	                    case 2:
	                        m.privacyFilteringEnabled = r.bool();
	                        break;
	                    case 3:
	                        m.convertToLegacyJson = r.bool();
	                        break;
	                    case 4:
	                        m.clientPriority = r.int32();
	                        break;
	                    case 5:
	                        m.jsonAgentLabelFilter = r.string();
	                        break;
	                    default:
	                        r.skipType(t & 7);
	                        break;
	                    }
	                }
	                return m;
	            };

	            /**
	             * Creates a ChromeConfig message from a plain object. Also converts values to their respective internal types.
	             * @function fromObject
	             * @memberof perfetto.protos.ChromeConfig
	             * @static
	             * @param {Object.<string,*>} d Plain object
	             * @returns {perfetto.protos.ChromeConfig} ChromeConfig
	             */
	            ChromeConfig.fromObject = function fromObject(d) {
	                if (d instanceof $root.perfetto.protos.ChromeConfig)
	                    return d;
	                var m = new $root.perfetto.protos.ChromeConfig();
	                if (d.traceConfig != null) {
	                    m.traceConfig = String(d.traceConfig);
	                }
	                if (d.privacyFilteringEnabled != null) {
	                    m.privacyFilteringEnabled = Boolean(d.privacyFilteringEnabled);
	                }
	                if (d.convertToLegacyJson != null) {
	                    m.convertToLegacyJson = Boolean(d.convertToLegacyJson);
	                }
	                switch (d.clientPriority) {
	                case "UNKNOWN":
	                case 0:
	                    m.clientPriority = 0;
	                    break;
	                case "BACKGROUND":
	                case 1:
	                    m.clientPriority = 1;
	                    break;
	                case "USER_INITIATED":
	                case 2:
	                    m.clientPriority = 2;
	                    break;
	                }
	                if (d.jsonAgentLabelFilter != null) {
	                    m.jsonAgentLabelFilter = String(d.jsonAgentLabelFilter);
	                }
	                return m;
	            };

	            /**
	             * Creates a plain object from a ChromeConfig message. Also converts values to other types if specified.
	             * @function toObject
	             * @memberof perfetto.protos.ChromeConfig
	             * @static
	             * @param {perfetto.protos.ChromeConfig} m ChromeConfig
	             * @param {$protobuf.IConversionOptions} [o] Conversion options
	             * @returns {Object.<string,*>} Plain object
	             */
	            ChromeConfig.toObject = function toObject(m, o) {
	                if (!o)
	                    o = {};
	                var d = {};
	                if (o.defaults) {
	                    d.traceConfig = "";
	                    d.privacyFilteringEnabled = false;
	                    d.convertToLegacyJson = false;
	                    d.clientPriority = o.enums === String ? "UNKNOWN" : 0;
	                    d.jsonAgentLabelFilter = "";
	                }
	                if (m.traceConfig != null && m.hasOwnProperty("traceConfig")) {
	                    d.traceConfig = m.traceConfig;
	                }
	                if (m.privacyFilteringEnabled != null && m.hasOwnProperty("privacyFilteringEnabled")) {
	                    d.privacyFilteringEnabled = m.privacyFilteringEnabled;
	                }
	                if (m.convertToLegacyJson != null && m.hasOwnProperty("convertToLegacyJson")) {
	                    d.convertToLegacyJson = m.convertToLegacyJson;
	                }
	                if (m.clientPriority != null && m.hasOwnProperty("clientPriority")) {
	                    d.clientPriority = o.enums === String ? $root.perfetto.protos.ChromeConfig.ClientPriority[m.clientPriority] : m.clientPriority;
	                }
	                if (m.jsonAgentLabelFilter != null && m.hasOwnProperty("jsonAgentLabelFilter")) {
	                    d.jsonAgentLabelFilter = m.jsonAgentLabelFilter;
	                }
	                return d;
	            };

	            /**
	             * Converts this ChromeConfig to JSON.
	             * @function toJSON
	             * @memberof perfetto.protos.ChromeConfig
	             * @instance
	             * @returns {Object.<string,*>} JSON object
	             */
	            ChromeConfig.prototype.toJSON = function toJSON() {
	                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
	            };

	            /**
	             * ClientPriority enum.
	             * @name perfetto.protos.ChromeConfig.ClientPriority
	             * @enum {number}
	             * @property {number} UNKNOWN=0 UNKNOWN value
	             * @property {number} BACKGROUND=1 BACKGROUND value
	             * @property {number} USER_INITIATED=2 USER_INITIATED value
	             */
	            ChromeConfig.ClientPriority = (function() {
	                var valuesById = {}, values = Object.create(valuesById);
	                values[valuesById[0] = "UNKNOWN"] = 0;
	                values[valuesById[1] = "BACKGROUND"] = 1;
	                values[valuesById[2] = "USER_INITIATED"] = 2;
	                return values;
	            })();

	            return ChromeConfig;
	        })();

	        protos.FtraceConfig = (function() {

	            /**
	             * Properties of a FtraceConfig.
	             * @memberof perfetto.protos
	             * @interface IFtraceConfig
	             * @property {Array.<string>|null} [ftraceEvents] FtraceConfig ftraceEvents
	             * @property {Array.<string>|null} [atraceCategories] FtraceConfig atraceCategories
	             * @property {Array.<string>|null} [atraceApps] FtraceConfig atraceApps
	             * @property {number|null} [bufferSizeKb] FtraceConfig bufferSizeKb
	             * @property {number|null} [drainPeriodMs] FtraceConfig drainPeriodMs
	             * @property {perfetto.protos.FtraceConfig.ICompactSchedConfig|null} [compactSched] FtraceConfig compactSched
	             * @property {perfetto.protos.FtraceConfig.IPrintFilter|null} [printFilter] FtraceConfig printFilter
	             * @property {boolean|null} [symbolizeKsyms] FtraceConfig symbolizeKsyms
	             * @property {perfetto.protos.FtraceConfig.KsymsMemPolicy|null} [ksymsMemPolicy] FtraceConfig ksymsMemPolicy
	             * @property {boolean|null} [initializeKsymsSynchronouslyForTesting] FtraceConfig initializeKsymsSynchronouslyForTesting
	             * @property {boolean|null} [throttleRssStat] FtraceConfig throttleRssStat
	             * @property {boolean|null} [disableGenericEvents] FtraceConfig disableGenericEvents
	             * @property {Array.<string>|null} [syscallEvents] FtraceConfig syscallEvents
	             * @property {boolean|null} [enableFunctionGraph] FtraceConfig enableFunctionGraph
	             * @property {Array.<string>|null} [functionFilters] FtraceConfig functionFilters
	             * @property {Array.<string>|null} [functionGraphRoots] FtraceConfig functionGraphRoots
	             * @property {boolean|null} [preserveFtraceBuffer] FtraceConfig preserveFtraceBuffer
	             * @property {boolean|null} [useMonotonicRawClock] FtraceConfig useMonotonicRawClock
	             * @property {string|null} [instanceName] FtraceConfig instanceName
	             */

	            /**
	             * Constructs a new FtraceConfig.
	             * @memberof perfetto.protos
	             * @classdesc Represents a FtraceConfig.
	             * @implements IFtraceConfig
	             * @constructor
	             * @param {perfetto.protos.IFtraceConfig=} [p] Properties to set
	             */
	            function FtraceConfig(p) {
	                this.ftraceEvents = [];
	                this.atraceCategories = [];
	                this.atraceApps = [];
	                this.syscallEvents = [];
	                this.functionFilters = [];
	                this.functionGraphRoots = [];
	                if (p)
	                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
	                        if (p[ks[i]] != null)
	                            this[ks[i]] = p[ks[i]];
	            }

	            /**
	             * FtraceConfig ftraceEvents.
	             * @member {Array.<string>} ftraceEvents
	             * @memberof perfetto.protos.FtraceConfig
	             * @instance
	             */
	            FtraceConfig.prototype.ftraceEvents = $util.emptyArray;

	            /**
	             * FtraceConfig atraceCategories.
	             * @member {Array.<string>} atraceCategories
	             * @memberof perfetto.protos.FtraceConfig
	             * @instance
	             */
	            FtraceConfig.prototype.atraceCategories = $util.emptyArray;

	            /**
	             * FtraceConfig atraceApps.
	             * @member {Array.<string>} atraceApps
	             * @memberof perfetto.protos.FtraceConfig
	             * @instance
	             */
	            FtraceConfig.prototype.atraceApps = $util.emptyArray;

	            /**
	             * FtraceConfig bufferSizeKb.
	             * @member {number} bufferSizeKb
	             * @memberof perfetto.protos.FtraceConfig
	             * @instance
	             */
	            FtraceConfig.prototype.bufferSizeKb = 0;

	            /**
	             * FtraceConfig drainPeriodMs.
	             * @member {number} drainPeriodMs
	             * @memberof perfetto.protos.FtraceConfig
	             * @instance
	             */
	            FtraceConfig.prototype.drainPeriodMs = 0;

	            /**
	             * FtraceConfig compactSched.
	             * @member {perfetto.protos.FtraceConfig.ICompactSchedConfig|null|undefined} compactSched
	             * @memberof perfetto.protos.FtraceConfig
	             * @instance
	             */
	            FtraceConfig.prototype.compactSched = null;

	            /**
	             * FtraceConfig printFilter.
	             * @member {perfetto.protos.FtraceConfig.IPrintFilter|null|undefined} printFilter
	             * @memberof perfetto.protos.FtraceConfig
	             * @instance
	             */
	            FtraceConfig.prototype.printFilter = null;

	            /**
	             * FtraceConfig symbolizeKsyms.
	             * @member {boolean} symbolizeKsyms
	             * @memberof perfetto.protos.FtraceConfig
	             * @instance
	             */
	            FtraceConfig.prototype.symbolizeKsyms = false;

	            /**
	             * FtraceConfig ksymsMemPolicy.
	             * @member {perfetto.protos.FtraceConfig.KsymsMemPolicy} ksymsMemPolicy
	             * @memberof perfetto.protos.FtraceConfig
	             * @instance
	             */
	            FtraceConfig.prototype.ksymsMemPolicy = 0;

	            /**
	             * FtraceConfig initializeKsymsSynchronouslyForTesting.
	             * @member {boolean} initializeKsymsSynchronouslyForTesting
	             * @memberof perfetto.protos.FtraceConfig
	             * @instance
	             */
	            FtraceConfig.prototype.initializeKsymsSynchronouslyForTesting = false;

	            /**
	             * FtraceConfig throttleRssStat.
	             * @member {boolean} throttleRssStat
	             * @memberof perfetto.protos.FtraceConfig
	             * @instance
	             */
	            FtraceConfig.prototype.throttleRssStat = false;

	            /**
	             * FtraceConfig disableGenericEvents.
	             * @member {boolean} disableGenericEvents
	             * @memberof perfetto.protos.FtraceConfig
	             * @instance
	             */
	            FtraceConfig.prototype.disableGenericEvents = false;

	            /**
	             * FtraceConfig syscallEvents.
	             * @member {Array.<string>} syscallEvents
	             * @memberof perfetto.protos.FtraceConfig
	             * @instance
	             */
	            FtraceConfig.prototype.syscallEvents = $util.emptyArray;

	            /**
	             * FtraceConfig enableFunctionGraph.
	             * @member {boolean} enableFunctionGraph
	             * @memberof perfetto.protos.FtraceConfig
	             * @instance
	             */
	            FtraceConfig.prototype.enableFunctionGraph = false;

	            /**
	             * FtraceConfig functionFilters.
	             * @member {Array.<string>} functionFilters
	             * @memberof perfetto.protos.FtraceConfig
	             * @instance
	             */
	            FtraceConfig.prototype.functionFilters = $util.emptyArray;

	            /**
	             * FtraceConfig functionGraphRoots.
	             * @member {Array.<string>} functionGraphRoots
	             * @memberof perfetto.protos.FtraceConfig
	             * @instance
	             */
	            FtraceConfig.prototype.functionGraphRoots = $util.emptyArray;

	            /**
	             * FtraceConfig preserveFtraceBuffer.
	             * @member {boolean} preserveFtraceBuffer
	             * @memberof perfetto.protos.FtraceConfig
	             * @instance
	             */
	            FtraceConfig.prototype.preserveFtraceBuffer = false;

	            /**
	             * FtraceConfig useMonotonicRawClock.
	             * @member {boolean} useMonotonicRawClock
	             * @memberof perfetto.protos.FtraceConfig
	             * @instance
	             */
	            FtraceConfig.prototype.useMonotonicRawClock = false;

	            /**
	             * FtraceConfig instanceName.
	             * @member {string} instanceName
	             * @memberof perfetto.protos.FtraceConfig
	             * @instance
	             */
	            FtraceConfig.prototype.instanceName = "";

	            /**
	             * Creates a new FtraceConfig instance using the specified properties.
	             * @function create
	             * @memberof perfetto.protos.FtraceConfig
	             * @static
	             * @param {perfetto.protos.IFtraceConfig=} [properties] Properties to set
	             * @returns {perfetto.protos.FtraceConfig} FtraceConfig instance
	             */
	            FtraceConfig.create = function create(properties) {
	                return new FtraceConfig(properties);
	            };

	            /**
	             * Encodes the specified FtraceConfig message. Does not implicitly {@link perfetto.protos.FtraceConfig.verify|verify} messages.
	             * @function encode
	             * @memberof perfetto.protos.FtraceConfig
	             * @static
	             * @param {perfetto.protos.IFtraceConfig} m FtraceConfig message or plain object to encode
	             * @param {$protobuf.Writer} [w] Writer to encode to
	             * @returns {$protobuf.Writer} Writer
	             */
	            FtraceConfig.encode = function encode(m, w) {
	                if (!w)
	                    w = $Writer.create();
	                if (m.ftraceEvents != null && m.ftraceEvents.length) {
	                    for (var i = 0; i < m.ftraceEvents.length; ++i)
	                        w.uint32(10).string(m.ftraceEvents[i]);
	                }
	                if (m.atraceCategories != null && m.atraceCategories.length) {
	                    for (var i = 0; i < m.atraceCategories.length; ++i)
	                        w.uint32(18).string(m.atraceCategories[i]);
	                }
	                if (m.atraceApps != null && m.atraceApps.length) {
	                    for (var i = 0; i < m.atraceApps.length; ++i)
	                        w.uint32(26).string(m.atraceApps[i]);
	                }
	                if (m.bufferSizeKb != null && Object.hasOwnProperty.call(m, "bufferSizeKb"))
	                    w.uint32(80).uint32(m.bufferSizeKb);
	                if (m.drainPeriodMs != null && Object.hasOwnProperty.call(m, "drainPeriodMs"))
	                    w.uint32(88).uint32(m.drainPeriodMs);
	                if (m.compactSched != null && Object.hasOwnProperty.call(m, "compactSched"))
	                    $root.perfetto.protos.FtraceConfig.CompactSchedConfig.encode(m.compactSched, w.uint32(98).fork()).ldelim();
	                if (m.symbolizeKsyms != null && Object.hasOwnProperty.call(m, "symbolizeKsyms"))
	                    w.uint32(104).bool(m.symbolizeKsyms);
	                if (m.initializeKsymsSynchronouslyForTesting != null && Object.hasOwnProperty.call(m, "initializeKsymsSynchronouslyForTesting"))
	                    w.uint32(112).bool(m.initializeKsymsSynchronouslyForTesting);
	                if (m.throttleRssStat != null && Object.hasOwnProperty.call(m, "throttleRssStat"))
	                    w.uint32(120).bool(m.throttleRssStat);
	                if (m.disableGenericEvents != null && Object.hasOwnProperty.call(m, "disableGenericEvents"))
	                    w.uint32(128).bool(m.disableGenericEvents);
	                if (m.ksymsMemPolicy != null && Object.hasOwnProperty.call(m, "ksymsMemPolicy"))
	                    w.uint32(136).int32(m.ksymsMemPolicy);
	                if (m.syscallEvents != null && m.syscallEvents.length) {
	                    for (var i = 0; i < m.syscallEvents.length; ++i)
	                        w.uint32(146).string(m.syscallEvents[i]);
	                }
	                if (m.enableFunctionGraph != null && Object.hasOwnProperty.call(m, "enableFunctionGraph"))
	                    w.uint32(152).bool(m.enableFunctionGraph);
	                if (m.functionFilters != null && m.functionFilters.length) {
	                    for (var i = 0; i < m.functionFilters.length; ++i)
	                        w.uint32(162).string(m.functionFilters[i]);
	                }
	                if (m.functionGraphRoots != null && m.functionGraphRoots.length) {
	                    for (var i = 0; i < m.functionGraphRoots.length; ++i)
	                        w.uint32(170).string(m.functionGraphRoots[i]);
	                }
	                if (m.printFilter != null && Object.hasOwnProperty.call(m, "printFilter"))
	                    $root.perfetto.protos.FtraceConfig.PrintFilter.encode(m.printFilter, w.uint32(178).fork()).ldelim();
	                if (m.preserveFtraceBuffer != null && Object.hasOwnProperty.call(m, "preserveFtraceBuffer"))
	                    w.uint32(184).bool(m.preserveFtraceBuffer);
	                if (m.useMonotonicRawClock != null && Object.hasOwnProperty.call(m, "useMonotonicRawClock"))
	                    w.uint32(192).bool(m.useMonotonicRawClock);
	                if (m.instanceName != null && Object.hasOwnProperty.call(m, "instanceName"))
	                    w.uint32(202).string(m.instanceName);
	                return w;
	            };

	            /**
	             * Decodes a FtraceConfig message from the specified reader or buffer.
	             * @function decode
	             * @memberof perfetto.protos.FtraceConfig
	             * @static
	             * @param {$protobuf.Reader|Uint8Array} r Reader or buffer to decode from
	             * @param {number} [l] Message length if known beforehand
	             * @returns {perfetto.protos.FtraceConfig} FtraceConfig
	             * @throws {Error} If the payload is not a reader or valid buffer
	             * @throws {$protobuf.util.ProtocolError} If required fields are missing
	             */
	            FtraceConfig.decode = function decode(r, l) {
	                if (!(r instanceof $Reader))
	                    r = $Reader.create(r);
	                var c = l === undefined ? r.len : r.pos + l, m = new $root.perfetto.protos.FtraceConfig();
	                while (r.pos < c) {
	                    var t = r.uint32();
	                    switch (t >>> 3) {
	                    case 1:
	                        if (!(m.ftraceEvents && m.ftraceEvents.length))
	                            m.ftraceEvents = [];
	                        m.ftraceEvents.push(r.string());
	                        break;
	                    case 2:
	                        if (!(m.atraceCategories && m.atraceCategories.length))
	                            m.atraceCategories = [];
	                        m.atraceCategories.push(r.string());
	                        break;
	                    case 3:
	                        if (!(m.atraceApps && m.atraceApps.length))
	                            m.atraceApps = [];
	                        m.atraceApps.push(r.string());
	                        break;
	                    case 10:
	                        m.bufferSizeKb = r.uint32();
	                        break;
	                    case 11:
	                        m.drainPeriodMs = r.uint32();
	                        break;
	                    case 12:
	                        m.compactSched = $root.perfetto.protos.FtraceConfig.CompactSchedConfig.decode(r, r.uint32());
	                        break;
	                    case 22:
	                        m.printFilter = $root.perfetto.protos.FtraceConfig.PrintFilter.decode(r, r.uint32());
	                        break;
	                    case 13:
	                        m.symbolizeKsyms = r.bool();
	                        break;
	                    case 17:
	                        m.ksymsMemPolicy = r.int32();
	                        break;
	                    case 14:
	                        m.initializeKsymsSynchronouslyForTesting = r.bool();
	                        break;
	                    case 15:
	                        m.throttleRssStat = r.bool();
	                        break;
	                    case 16:
	                        m.disableGenericEvents = r.bool();
	                        break;
	                    case 18:
	                        if (!(m.syscallEvents && m.syscallEvents.length))
	                            m.syscallEvents = [];
	                        m.syscallEvents.push(r.string());
	                        break;
	                    case 19:
	                        m.enableFunctionGraph = r.bool();
	                        break;
	                    case 20:
	                        if (!(m.functionFilters && m.functionFilters.length))
	                            m.functionFilters = [];
	                        m.functionFilters.push(r.string());
	                        break;
	                    case 21:
	                        if (!(m.functionGraphRoots && m.functionGraphRoots.length))
	                            m.functionGraphRoots = [];
	                        m.functionGraphRoots.push(r.string());
	                        break;
	                    case 23:
	                        m.preserveFtraceBuffer = r.bool();
	                        break;
	                    case 24:
	                        m.useMonotonicRawClock = r.bool();
	                        break;
	                    case 25:
	                        m.instanceName = r.string();
	                        break;
	                    default:
	                        r.skipType(t & 7);
	                        break;
	                    }
	                }
	                return m;
	            };

	            /**
	             * Creates a FtraceConfig message from a plain object. Also converts values to their respective internal types.
	             * @function fromObject
	             * @memberof perfetto.protos.FtraceConfig
	             * @static
	             * @param {Object.<string,*>} d Plain object
	             * @returns {perfetto.protos.FtraceConfig} FtraceConfig
	             */
	            FtraceConfig.fromObject = function fromObject(d) {
	                if (d instanceof $root.perfetto.protos.FtraceConfig)
	                    return d;
	                var m = new $root.perfetto.protos.FtraceConfig();
	                if (d.ftraceEvents) {
	                    if (!Array.isArray(d.ftraceEvents))
	                        throw TypeError(".perfetto.protos.FtraceConfig.ftraceEvents: array expected");
	                    m.ftraceEvents = [];
	                    for (var i = 0; i < d.ftraceEvents.length; ++i) {
	                        m.ftraceEvents[i] = String(d.ftraceEvents[i]);
	                    }
	                }
	                if (d.atraceCategories) {
	                    if (!Array.isArray(d.atraceCategories))
	                        throw TypeError(".perfetto.protos.FtraceConfig.atraceCategories: array expected");
	                    m.atraceCategories = [];
	                    for (var i = 0; i < d.atraceCategories.length; ++i) {
	                        m.atraceCategories[i] = String(d.atraceCategories[i]);
	                    }
	                }
	                if (d.atraceApps) {
	                    if (!Array.isArray(d.atraceApps))
	                        throw TypeError(".perfetto.protos.FtraceConfig.atraceApps: array expected");
	                    m.atraceApps = [];
	                    for (var i = 0; i < d.atraceApps.length; ++i) {
	                        m.atraceApps[i] = String(d.atraceApps[i]);
	                    }
	                }
	                if (d.bufferSizeKb != null) {
	                    m.bufferSizeKb = d.bufferSizeKb >>> 0;
	                }
	                if (d.drainPeriodMs != null) {
	                    m.drainPeriodMs = d.drainPeriodMs >>> 0;
	                }
	                if (d.compactSched != null) {
	                    if (typeof d.compactSched !== "object")
	                        throw TypeError(".perfetto.protos.FtraceConfig.compactSched: object expected");
	                    m.compactSched = $root.perfetto.protos.FtraceConfig.CompactSchedConfig.fromObject(d.compactSched);
	                }
	                if (d.printFilter != null) {
	                    if (typeof d.printFilter !== "object")
	                        throw TypeError(".perfetto.protos.FtraceConfig.printFilter: object expected");
	                    m.printFilter = $root.perfetto.protos.FtraceConfig.PrintFilter.fromObject(d.printFilter);
	                }
	                if (d.symbolizeKsyms != null) {
	                    m.symbolizeKsyms = Boolean(d.symbolizeKsyms);
	                }
	                switch (d.ksymsMemPolicy) {
	                case "KSYMS_UNSPECIFIED":
	                case 0:
	                    m.ksymsMemPolicy = 0;
	                    break;
	                case "KSYMS_CLEANUP_ON_STOP":
	                case 1:
	                    m.ksymsMemPolicy = 1;
	                    break;
	                case "KSYMS_RETAIN":
	                case 2:
	                    m.ksymsMemPolicy = 2;
	                    break;
	                }
	                if (d.initializeKsymsSynchronouslyForTesting != null) {
	                    m.initializeKsymsSynchronouslyForTesting = Boolean(d.initializeKsymsSynchronouslyForTesting);
	                }
	                if (d.throttleRssStat != null) {
	                    m.throttleRssStat = Boolean(d.throttleRssStat);
	                }
	                if (d.disableGenericEvents != null) {
	                    m.disableGenericEvents = Boolean(d.disableGenericEvents);
	                }
	                if (d.syscallEvents) {
	                    if (!Array.isArray(d.syscallEvents))
	                        throw TypeError(".perfetto.protos.FtraceConfig.syscallEvents: array expected");
	                    m.syscallEvents = [];
	                    for (var i = 0; i < d.syscallEvents.length; ++i) {
	                        m.syscallEvents[i] = String(d.syscallEvents[i]);
	                    }
	                }
	                if (d.enableFunctionGraph != null) {
	                    m.enableFunctionGraph = Boolean(d.enableFunctionGraph);
	                }
	                if (d.functionFilters) {
	                    if (!Array.isArray(d.functionFilters))
	                        throw TypeError(".perfetto.protos.FtraceConfig.functionFilters: array expected");
	                    m.functionFilters = [];
	                    for (var i = 0; i < d.functionFilters.length; ++i) {
	                        m.functionFilters[i] = String(d.functionFilters[i]);
	                    }
	                }
	                if (d.functionGraphRoots) {
	                    if (!Array.isArray(d.functionGraphRoots))
	                        throw TypeError(".perfetto.protos.FtraceConfig.functionGraphRoots: array expected");
	                    m.functionGraphRoots = [];
	                    for (var i = 0; i < d.functionGraphRoots.length; ++i) {
	                        m.functionGraphRoots[i] = String(d.functionGraphRoots[i]);
	                    }
	                }
	                if (d.preserveFtraceBuffer != null) {
	                    m.preserveFtraceBuffer = Boolean(d.preserveFtraceBuffer);
	                }
	                if (d.useMonotonicRawClock != null) {
	                    m.useMonotonicRawClock = Boolean(d.useMonotonicRawClock);
	                }
	                if (d.instanceName != null) {
	                    m.instanceName = String(d.instanceName);
	                }
	                return m;
	            };

	            /**
	             * Creates a plain object from a FtraceConfig message. Also converts values to other types if specified.
	             * @function toObject
	             * @memberof perfetto.protos.FtraceConfig
	             * @static
	             * @param {perfetto.protos.FtraceConfig} m FtraceConfig
	             * @param {$protobuf.IConversionOptions} [o] Conversion options
	             * @returns {Object.<string,*>} Plain object
	             */
	            FtraceConfig.toObject = function toObject(m, o) {
	                if (!o)
	                    o = {};
	                var d = {};
	                if (o.arrays || o.defaults) {
	                    d.ftraceEvents = [];
	                    d.atraceCategories = [];
	                    d.atraceApps = [];
	                    d.syscallEvents = [];
	                    d.functionFilters = [];
	                    d.functionGraphRoots = [];
	                }
	                if (o.defaults) {
	                    d.bufferSizeKb = 0;
	                    d.drainPeriodMs = 0;
	                    d.compactSched = null;
	                    d.symbolizeKsyms = false;
	                    d.initializeKsymsSynchronouslyForTesting = false;
	                    d.throttleRssStat = false;
	                    d.disableGenericEvents = false;
	                    d.ksymsMemPolicy = o.enums === String ? "KSYMS_UNSPECIFIED" : 0;
	                    d.enableFunctionGraph = false;
	                    d.printFilter = null;
	                    d.preserveFtraceBuffer = false;
	                    d.useMonotonicRawClock = false;
	                    d.instanceName = "";
	                }
	                if (m.ftraceEvents && m.ftraceEvents.length) {
	                    d.ftraceEvents = [];
	                    for (var j = 0; j < m.ftraceEvents.length; ++j) {
	                        d.ftraceEvents[j] = m.ftraceEvents[j];
	                    }
	                }
	                if (m.atraceCategories && m.atraceCategories.length) {
	                    d.atraceCategories = [];
	                    for (var j = 0; j < m.atraceCategories.length; ++j) {
	                        d.atraceCategories[j] = m.atraceCategories[j];
	                    }
	                }
	                if (m.atraceApps && m.atraceApps.length) {
	                    d.atraceApps = [];
	                    for (var j = 0; j < m.atraceApps.length; ++j) {
	                        d.atraceApps[j] = m.atraceApps[j];
	                    }
	                }
	                if (m.bufferSizeKb != null && m.hasOwnProperty("bufferSizeKb")) {
	                    d.bufferSizeKb = m.bufferSizeKb;
	                }
	                if (m.drainPeriodMs != null && m.hasOwnProperty("drainPeriodMs")) {
	                    d.drainPeriodMs = m.drainPeriodMs;
	                }
	                if (m.compactSched != null && m.hasOwnProperty("compactSched")) {
	                    d.compactSched = $root.perfetto.protos.FtraceConfig.CompactSchedConfig.toObject(m.compactSched, o);
	                }
	                if (m.symbolizeKsyms != null && m.hasOwnProperty("symbolizeKsyms")) {
	                    d.symbolizeKsyms = m.symbolizeKsyms;
	                }
	                if (m.initializeKsymsSynchronouslyForTesting != null && m.hasOwnProperty("initializeKsymsSynchronouslyForTesting")) {
	                    d.initializeKsymsSynchronouslyForTesting = m.initializeKsymsSynchronouslyForTesting;
	                }
	                if (m.throttleRssStat != null && m.hasOwnProperty("throttleRssStat")) {
	                    d.throttleRssStat = m.throttleRssStat;
	                }
	                if (m.disableGenericEvents != null && m.hasOwnProperty("disableGenericEvents")) {
	                    d.disableGenericEvents = m.disableGenericEvents;
	                }
	                if (m.ksymsMemPolicy != null && m.hasOwnProperty("ksymsMemPolicy")) {
	                    d.ksymsMemPolicy = o.enums === String ? $root.perfetto.protos.FtraceConfig.KsymsMemPolicy[m.ksymsMemPolicy] : m.ksymsMemPolicy;
	                }
	                if (m.syscallEvents && m.syscallEvents.length) {
	                    d.syscallEvents = [];
	                    for (var j = 0; j < m.syscallEvents.length; ++j) {
	                        d.syscallEvents[j] = m.syscallEvents[j];
	                    }
	                }
	                if (m.enableFunctionGraph != null && m.hasOwnProperty("enableFunctionGraph")) {
	                    d.enableFunctionGraph = m.enableFunctionGraph;
	                }
	                if (m.functionFilters && m.functionFilters.length) {
	                    d.functionFilters = [];
	                    for (var j = 0; j < m.functionFilters.length; ++j) {
	                        d.functionFilters[j] = m.functionFilters[j];
	                    }
	                }
	                if (m.functionGraphRoots && m.functionGraphRoots.length) {
	                    d.functionGraphRoots = [];
	                    for (var j = 0; j < m.functionGraphRoots.length; ++j) {
	                        d.functionGraphRoots[j] = m.functionGraphRoots[j];
	                    }
	                }
	                if (m.printFilter != null && m.hasOwnProperty("printFilter")) {
	                    d.printFilter = $root.perfetto.protos.FtraceConfig.PrintFilter.toObject(m.printFilter, o);
	                }
	                if (m.preserveFtraceBuffer != null && m.hasOwnProperty("preserveFtraceBuffer")) {
	                    d.preserveFtraceBuffer = m.preserveFtraceBuffer;
	                }
	                if (m.useMonotonicRawClock != null && m.hasOwnProperty("useMonotonicRawClock")) {
	                    d.useMonotonicRawClock = m.useMonotonicRawClock;
	                }
	                if (m.instanceName != null && m.hasOwnProperty("instanceName")) {
	                    d.instanceName = m.instanceName;
	                }
	                return d;
	            };

	            /**
	             * Converts this FtraceConfig to JSON.
	             * @function toJSON
	             * @memberof perfetto.protos.FtraceConfig
	             * @instance
	             * @returns {Object.<string,*>} JSON object
	             */
	            FtraceConfig.prototype.toJSON = function toJSON() {
	                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
	            };

	            FtraceConfig.CompactSchedConfig = (function() {

	                /**
	                 * Properties of a CompactSchedConfig.
	                 * @memberof perfetto.protos.FtraceConfig
	                 * @interface ICompactSchedConfig
	                 * @property {boolean|null} [enabled] CompactSchedConfig enabled
	                 */

	                /**
	                 * Constructs a new CompactSchedConfig.
	                 * @memberof perfetto.protos.FtraceConfig
	                 * @classdesc Represents a CompactSchedConfig.
	                 * @implements ICompactSchedConfig
	                 * @constructor
	                 * @param {perfetto.protos.FtraceConfig.ICompactSchedConfig=} [p] Properties to set
	                 */
	                function CompactSchedConfig(p) {
	                    if (p)
	                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
	                            if (p[ks[i]] != null)
	                                this[ks[i]] = p[ks[i]];
	                }

	                /**
	                 * CompactSchedConfig enabled.
	                 * @member {boolean} enabled
	                 * @memberof perfetto.protos.FtraceConfig.CompactSchedConfig
	                 * @instance
	                 */
	                CompactSchedConfig.prototype.enabled = false;

	                /**
	                 * Creates a new CompactSchedConfig instance using the specified properties.
	                 * @function create
	                 * @memberof perfetto.protos.FtraceConfig.CompactSchedConfig
	                 * @static
	                 * @param {perfetto.protos.FtraceConfig.ICompactSchedConfig=} [properties] Properties to set
	                 * @returns {perfetto.protos.FtraceConfig.CompactSchedConfig} CompactSchedConfig instance
	                 */
	                CompactSchedConfig.create = function create(properties) {
	                    return new CompactSchedConfig(properties);
	                };

	                /**
	                 * Encodes the specified CompactSchedConfig message. Does not implicitly {@link perfetto.protos.FtraceConfig.CompactSchedConfig.verify|verify} messages.
	                 * @function encode
	                 * @memberof perfetto.protos.FtraceConfig.CompactSchedConfig
	                 * @static
	                 * @param {perfetto.protos.FtraceConfig.ICompactSchedConfig} m CompactSchedConfig message or plain object to encode
	                 * @param {$protobuf.Writer} [w] Writer to encode to
	                 * @returns {$protobuf.Writer} Writer
	                 */
	                CompactSchedConfig.encode = function encode(m, w) {
	                    if (!w)
	                        w = $Writer.create();
	                    if (m.enabled != null && Object.hasOwnProperty.call(m, "enabled"))
	                        w.uint32(8).bool(m.enabled);
	                    return w;
	                };

	                /**
	                 * Decodes a CompactSchedConfig message from the specified reader or buffer.
	                 * @function decode
	                 * @memberof perfetto.protos.FtraceConfig.CompactSchedConfig
	                 * @static
	                 * @param {$protobuf.Reader|Uint8Array} r Reader or buffer to decode from
	                 * @param {number} [l] Message length if known beforehand
	                 * @returns {perfetto.protos.FtraceConfig.CompactSchedConfig} CompactSchedConfig
	                 * @throws {Error} If the payload is not a reader or valid buffer
	                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
	                 */
	                CompactSchedConfig.decode = function decode(r, l) {
	                    if (!(r instanceof $Reader))
	                        r = $Reader.create(r);
	                    var c = l === undefined ? r.len : r.pos + l, m = new $root.perfetto.protos.FtraceConfig.CompactSchedConfig();
	                    while (r.pos < c) {
	                        var t = r.uint32();
	                        switch (t >>> 3) {
	                        case 1:
	                            m.enabled = r.bool();
	                            break;
	                        default:
	                            r.skipType(t & 7);
	                            break;
	                        }
	                    }
	                    return m;
	                };

	                /**
	                 * Creates a CompactSchedConfig message from a plain object. Also converts values to their respective internal types.
	                 * @function fromObject
	                 * @memberof perfetto.protos.FtraceConfig.CompactSchedConfig
	                 * @static
	                 * @param {Object.<string,*>} d Plain object
	                 * @returns {perfetto.protos.FtraceConfig.CompactSchedConfig} CompactSchedConfig
	                 */
	                CompactSchedConfig.fromObject = function fromObject(d) {
	                    if (d instanceof $root.perfetto.protos.FtraceConfig.CompactSchedConfig)
	                        return d;
	                    var m = new $root.perfetto.protos.FtraceConfig.CompactSchedConfig();
	                    if (d.enabled != null) {
	                        m.enabled = Boolean(d.enabled);
	                    }
	                    return m;
	                };

	                /**
	                 * Creates a plain object from a CompactSchedConfig message. Also converts values to other types if specified.
	                 * @function toObject
	                 * @memberof perfetto.protos.FtraceConfig.CompactSchedConfig
	                 * @static
	                 * @param {perfetto.protos.FtraceConfig.CompactSchedConfig} m CompactSchedConfig
	                 * @param {$protobuf.IConversionOptions} [o] Conversion options
	                 * @returns {Object.<string,*>} Plain object
	                 */
	                CompactSchedConfig.toObject = function toObject(m, o) {
	                    if (!o)
	                        o = {};
	                    var d = {};
	                    if (o.defaults) {
	                        d.enabled = false;
	                    }
	                    if (m.enabled != null && m.hasOwnProperty("enabled")) {
	                        d.enabled = m.enabled;
	                    }
	                    return d;
	                };

	                /**
	                 * Converts this CompactSchedConfig to JSON.
	                 * @function toJSON
	                 * @memberof perfetto.protos.FtraceConfig.CompactSchedConfig
	                 * @instance
	                 * @returns {Object.<string,*>} JSON object
	                 */
	                CompactSchedConfig.prototype.toJSON = function toJSON() {
	                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
	                };

	                return CompactSchedConfig;
	            })();

	            FtraceConfig.PrintFilter = (function() {

	                /**
	                 * Properties of a PrintFilter.
	                 * @memberof perfetto.protos.FtraceConfig
	                 * @interface IPrintFilter
	                 * @property {Array.<perfetto.protos.FtraceConfig.PrintFilter.IRule>|null} [rules] PrintFilter rules
	                 */

	                /**
	                 * Constructs a new PrintFilter.
	                 * @memberof perfetto.protos.FtraceConfig
	                 * @classdesc Represents a PrintFilter.
	                 * @implements IPrintFilter
	                 * @constructor
	                 * @param {perfetto.protos.FtraceConfig.IPrintFilter=} [p] Properties to set
	                 */
	                function PrintFilter(p) {
	                    this.rules = [];
	                    if (p)
	                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
	                            if (p[ks[i]] != null)
	                                this[ks[i]] = p[ks[i]];
	                }

	                /**
	                 * PrintFilter rules.
	                 * @member {Array.<perfetto.protos.FtraceConfig.PrintFilter.IRule>} rules
	                 * @memberof perfetto.protos.FtraceConfig.PrintFilter
	                 * @instance
	                 */
	                PrintFilter.prototype.rules = $util.emptyArray;

	                /**
	                 * Creates a new PrintFilter instance using the specified properties.
	                 * @function create
	                 * @memberof perfetto.protos.FtraceConfig.PrintFilter
	                 * @static
	                 * @param {perfetto.protos.FtraceConfig.IPrintFilter=} [properties] Properties to set
	                 * @returns {perfetto.protos.FtraceConfig.PrintFilter} PrintFilter instance
	                 */
	                PrintFilter.create = function create(properties) {
	                    return new PrintFilter(properties);
	                };

	                /**
	                 * Encodes the specified PrintFilter message. Does not implicitly {@link perfetto.protos.FtraceConfig.PrintFilter.verify|verify} messages.
	                 * @function encode
	                 * @memberof perfetto.protos.FtraceConfig.PrintFilter
	                 * @static
	                 * @param {perfetto.protos.FtraceConfig.IPrintFilter} m PrintFilter message or plain object to encode
	                 * @param {$protobuf.Writer} [w] Writer to encode to
	                 * @returns {$protobuf.Writer} Writer
	                 */
	                PrintFilter.encode = function encode(m, w) {
	                    if (!w)
	                        w = $Writer.create();
	                    if (m.rules != null && m.rules.length) {
	                        for (var i = 0; i < m.rules.length; ++i)
	                            $root.perfetto.protos.FtraceConfig.PrintFilter.Rule.encode(m.rules[i], w.uint32(10).fork()).ldelim();
	                    }
	                    return w;
	                };

	                /**
	                 * Decodes a PrintFilter message from the specified reader or buffer.
	                 * @function decode
	                 * @memberof perfetto.protos.FtraceConfig.PrintFilter
	                 * @static
	                 * @param {$protobuf.Reader|Uint8Array} r Reader or buffer to decode from
	                 * @param {number} [l] Message length if known beforehand
	                 * @returns {perfetto.protos.FtraceConfig.PrintFilter} PrintFilter
	                 * @throws {Error} If the payload is not a reader or valid buffer
	                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
	                 */
	                PrintFilter.decode = function decode(r, l) {
	                    if (!(r instanceof $Reader))
	                        r = $Reader.create(r);
	                    var c = l === undefined ? r.len : r.pos + l, m = new $root.perfetto.protos.FtraceConfig.PrintFilter();
	                    while (r.pos < c) {
	                        var t = r.uint32();
	                        switch (t >>> 3) {
	                        case 1:
	                            if (!(m.rules && m.rules.length))
	                                m.rules = [];
	                            m.rules.push($root.perfetto.protos.FtraceConfig.PrintFilter.Rule.decode(r, r.uint32()));
	                            break;
	                        default:
	                            r.skipType(t & 7);
	                            break;
	                        }
	                    }
	                    return m;
	                };

	                /**
	                 * Creates a PrintFilter message from a plain object. Also converts values to their respective internal types.
	                 * @function fromObject
	                 * @memberof perfetto.protos.FtraceConfig.PrintFilter
	                 * @static
	                 * @param {Object.<string,*>} d Plain object
	                 * @returns {perfetto.protos.FtraceConfig.PrintFilter} PrintFilter
	                 */
	                PrintFilter.fromObject = function fromObject(d) {
	                    if (d instanceof $root.perfetto.protos.FtraceConfig.PrintFilter)
	                        return d;
	                    var m = new $root.perfetto.protos.FtraceConfig.PrintFilter();
	                    if (d.rules) {
	                        if (!Array.isArray(d.rules))
	                            throw TypeError(".perfetto.protos.FtraceConfig.PrintFilter.rules: array expected");
	                        m.rules = [];
	                        for (var i = 0; i < d.rules.length; ++i) {
	                            if (typeof d.rules[i] !== "object")
	                                throw TypeError(".perfetto.protos.FtraceConfig.PrintFilter.rules: object expected");
	                            m.rules[i] = $root.perfetto.protos.FtraceConfig.PrintFilter.Rule.fromObject(d.rules[i]);
	                        }
	                    }
	                    return m;
	                };

	                /**
	                 * Creates a plain object from a PrintFilter message. Also converts values to other types if specified.
	                 * @function toObject
	                 * @memberof perfetto.protos.FtraceConfig.PrintFilter
	                 * @static
	                 * @param {perfetto.protos.FtraceConfig.PrintFilter} m PrintFilter
	                 * @param {$protobuf.IConversionOptions} [o] Conversion options
	                 * @returns {Object.<string,*>} Plain object
	                 */
	                PrintFilter.toObject = function toObject(m, o) {
	                    if (!o)
	                        o = {};
	                    var d = {};
	                    if (o.arrays || o.defaults) {
	                        d.rules = [];
	                    }
	                    if (m.rules && m.rules.length) {
	                        d.rules = [];
	                        for (var j = 0; j < m.rules.length; ++j) {
	                            d.rules[j] = $root.perfetto.protos.FtraceConfig.PrintFilter.Rule.toObject(m.rules[j], o);
	                        }
	                    }
	                    return d;
	                };

	                /**
	                 * Converts this PrintFilter to JSON.
	                 * @function toJSON
	                 * @memberof perfetto.protos.FtraceConfig.PrintFilter
	                 * @instance
	                 * @returns {Object.<string,*>} JSON object
	                 */
	                PrintFilter.prototype.toJSON = function toJSON() {
	                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
	                };

	                PrintFilter.Rule = (function() {

	                    /**
	                     * Properties of a Rule.
	                     * @memberof perfetto.protos.FtraceConfig.PrintFilter
	                     * @interface IRule
	                     * @property {string|null} [prefix] Rule prefix
	                     * @property {perfetto.protos.FtraceConfig.PrintFilter.Rule.IAtraceMessage|null} [atraceMsg] Rule atraceMsg
	                     * @property {boolean|null} [allow] Rule allow
	                     */

	                    /**
	                     * Constructs a new Rule.
	                     * @memberof perfetto.protos.FtraceConfig.PrintFilter
	                     * @classdesc Represents a Rule.
	                     * @implements IRule
	                     * @constructor
	                     * @param {perfetto.protos.FtraceConfig.PrintFilter.IRule=} [p] Properties to set
	                     */
	                    function Rule(p) {
	                        if (p)
	                            for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
	                                if (p[ks[i]] != null)
	                                    this[ks[i]] = p[ks[i]];
	                    }

	                    /**
	                     * Rule prefix.
	                     * @member {string|null|undefined} prefix
	                     * @memberof perfetto.protos.FtraceConfig.PrintFilter.Rule
	                     * @instance
	                     */
	                    Rule.prototype.prefix = null;

	                    /**
	                     * Rule atraceMsg.
	                     * @member {perfetto.protos.FtraceConfig.PrintFilter.Rule.IAtraceMessage|null|undefined} atraceMsg
	                     * @memberof perfetto.protos.FtraceConfig.PrintFilter.Rule
	                     * @instance
	                     */
	                    Rule.prototype.atraceMsg = null;

	                    /**
	                     * Rule allow.
	                     * @member {boolean} allow
	                     * @memberof perfetto.protos.FtraceConfig.PrintFilter.Rule
	                     * @instance
	                     */
	                    Rule.prototype.allow = false;

	                    // OneOf field names bound to virtual getters and setters
	                    var $oneOfFields;

	                    /**
	                     * Rule match.
	                     * @member {"prefix"|"atraceMsg"|undefined} match
	                     * @memberof perfetto.protos.FtraceConfig.PrintFilter.Rule
	                     * @instance
	                     */
	                    Object.defineProperty(Rule.prototype, "match", {
	                        get: $util.oneOfGetter($oneOfFields = ["prefix", "atraceMsg"]),
	                        set: $util.oneOfSetter($oneOfFields)
	                    });

	                    /**
	                     * Creates a new Rule instance using the specified properties.
	                     * @function create
	                     * @memberof perfetto.protos.FtraceConfig.PrintFilter.Rule
	                     * @static
	                     * @param {perfetto.protos.FtraceConfig.PrintFilter.IRule=} [properties] Properties to set
	                     * @returns {perfetto.protos.FtraceConfig.PrintFilter.Rule} Rule instance
	                     */
	                    Rule.create = function create(properties) {
	                        return new Rule(properties);
	                    };

	                    /**
	                     * Encodes the specified Rule message. Does not implicitly {@link perfetto.protos.FtraceConfig.PrintFilter.Rule.verify|verify} messages.
	                     * @function encode
	                     * @memberof perfetto.protos.FtraceConfig.PrintFilter.Rule
	                     * @static
	                     * @param {perfetto.protos.FtraceConfig.PrintFilter.IRule} m Rule message or plain object to encode
	                     * @param {$protobuf.Writer} [w] Writer to encode to
	                     * @returns {$protobuf.Writer} Writer
	                     */
	                    Rule.encode = function encode(m, w) {
	                        if (!w)
	                            w = $Writer.create();
	                        if (m.prefix != null && Object.hasOwnProperty.call(m, "prefix"))
	                            w.uint32(10).string(m.prefix);
	                        if (m.allow != null && Object.hasOwnProperty.call(m, "allow"))
	                            w.uint32(16).bool(m.allow);
	                        if (m.atraceMsg != null && Object.hasOwnProperty.call(m, "atraceMsg"))
	                            $root.perfetto.protos.FtraceConfig.PrintFilter.Rule.AtraceMessage.encode(m.atraceMsg, w.uint32(26).fork()).ldelim();
	                        return w;
	                    };

	                    /**
	                     * Decodes a Rule message from the specified reader or buffer.
	                     * @function decode
	                     * @memberof perfetto.protos.FtraceConfig.PrintFilter.Rule
	                     * @static
	                     * @param {$protobuf.Reader|Uint8Array} r Reader or buffer to decode from
	                     * @param {number} [l] Message length if known beforehand
	                     * @returns {perfetto.protos.FtraceConfig.PrintFilter.Rule} Rule
	                     * @throws {Error} If the payload is not a reader or valid buffer
	                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
	                     */
	                    Rule.decode = function decode(r, l) {
	                        if (!(r instanceof $Reader))
	                            r = $Reader.create(r);
	                        var c = l === undefined ? r.len : r.pos + l, m = new $root.perfetto.protos.FtraceConfig.PrintFilter.Rule();
	                        while (r.pos < c) {
	                            var t = r.uint32();
	                            switch (t >>> 3) {
	                            case 1:
	                                m.prefix = r.string();
	                                break;
	                            case 3:
	                                m.atraceMsg = $root.perfetto.protos.FtraceConfig.PrintFilter.Rule.AtraceMessage.decode(r, r.uint32());
	                                break;
	                            case 2:
	                                m.allow = r.bool();
	                                break;
	                            default:
	                                r.skipType(t & 7);
	                                break;
	                            }
	                        }
	                        return m;
	                    };

	                    /**
	                     * Creates a Rule message from a plain object. Also converts values to their respective internal types.
	                     * @function fromObject
	                     * @memberof perfetto.protos.FtraceConfig.PrintFilter.Rule
	                     * @static
	                     * @param {Object.<string,*>} d Plain object
	                     * @returns {perfetto.protos.FtraceConfig.PrintFilter.Rule} Rule
	                     */
	                    Rule.fromObject = function fromObject(d) {
	                        if (d instanceof $root.perfetto.protos.FtraceConfig.PrintFilter.Rule)
	                            return d;
	                        var m = new $root.perfetto.protos.FtraceConfig.PrintFilter.Rule();
	                        if (d.prefix != null) {
	                            m.prefix = String(d.prefix);
	                        }
	                        if (d.atraceMsg != null) {
	                            if (typeof d.atraceMsg !== "object")
	                                throw TypeError(".perfetto.protos.FtraceConfig.PrintFilter.Rule.atraceMsg: object expected");
	                            m.atraceMsg = $root.perfetto.protos.FtraceConfig.PrintFilter.Rule.AtraceMessage.fromObject(d.atraceMsg);
	                        }
	                        if (d.allow != null) {
	                            m.allow = Boolean(d.allow);
	                        }
	                        return m;
	                    };

	                    /**
	                     * Creates a plain object from a Rule message. Also converts values to other types if specified.
	                     * @function toObject
	                     * @memberof perfetto.protos.FtraceConfig.PrintFilter.Rule
	                     * @static
	                     * @param {perfetto.protos.FtraceConfig.PrintFilter.Rule} m Rule
	                     * @param {$protobuf.IConversionOptions} [o] Conversion options
	                     * @returns {Object.<string,*>} Plain object
	                     */
	                    Rule.toObject = function toObject(m, o) {
	                        if (!o)
	                            o = {};
	                        var d = {};
	                        if (o.defaults) {
	                            d.allow = false;
	                        }
	                        if (m.prefix != null && m.hasOwnProperty("prefix")) {
	                            d.prefix = m.prefix;
	                            if (o.oneofs)
	                                d.match = "prefix";
	                        }
	                        if (m.allow != null && m.hasOwnProperty("allow")) {
	                            d.allow = m.allow;
	                        }
	                        if (m.atraceMsg != null && m.hasOwnProperty("atraceMsg")) {
	                            d.atraceMsg = $root.perfetto.protos.FtraceConfig.PrintFilter.Rule.AtraceMessage.toObject(m.atraceMsg, o);
	                            if (o.oneofs)
	                                d.match = "atraceMsg";
	                        }
	                        return d;
	                    };

	                    /**
	                     * Converts this Rule to JSON.
	                     * @function toJSON
	                     * @memberof perfetto.protos.FtraceConfig.PrintFilter.Rule
	                     * @instance
	                     * @returns {Object.<string,*>} JSON object
	                     */
	                    Rule.prototype.toJSON = function toJSON() {
	                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
	                    };

	                    Rule.AtraceMessage = (function() {

	                        /**
	                         * Properties of an AtraceMessage.
	                         * @memberof perfetto.protos.FtraceConfig.PrintFilter.Rule
	                         * @interface IAtraceMessage
	                         * @property {string|null} [type] AtraceMessage type
	                         * @property {string|null} [prefix] AtraceMessage prefix
	                         */

	                        /**
	                         * Constructs a new AtraceMessage.
	                         * @memberof perfetto.protos.FtraceConfig.PrintFilter.Rule
	                         * @classdesc Represents an AtraceMessage.
	                         * @implements IAtraceMessage
	                         * @constructor
	                         * @param {perfetto.protos.FtraceConfig.PrintFilter.Rule.IAtraceMessage=} [p] Properties to set
	                         */
	                        function AtraceMessage(p) {
	                            if (p)
	                                for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
	                                    if (p[ks[i]] != null)
	                                        this[ks[i]] = p[ks[i]];
	                        }

	                        /**
	                         * AtraceMessage type.
	                         * @member {string} type
	                         * @memberof perfetto.protos.FtraceConfig.PrintFilter.Rule.AtraceMessage
	                         * @instance
	                         */
	                        AtraceMessage.prototype.type = "";

	                        /**
	                         * AtraceMessage prefix.
	                         * @member {string} prefix
	                         * @memberof perfetto.protos.FtraceConfig.PrintFilter.Rule.AtraceMessage
	                         * @instance
	                         */
	                        AtraceMessage.prototype.prefix = "";

	                        /**
	                         * Creates a new AtraceMessage instance using the specified properties.
	                         * @function create
	                         * @memberof perfetto.protos.FtraceConfig.PrintFilter.Rule.AtraceMessage
	                         * @static
	                         * @param {perfetto.protos.FtraceConfig.PrintFilter.Rule.IAtraceMessage=} [properties] Properties to set
	                         * @returns {perfetto.protos.FtraceConfig.PrintFilter.Rule.AtraceMessage} AtraceMessage instance
	                         */
	                        AtraceMessage.create = function create(properties) {
	                            return new AtraceMessage(properties);
	                        };

	                        /**
	                         * Encodes the specified AtraceMessage message. Does not implicitly {@link perfetto.protos.FtraceConfig.PrintFilter.Rule.AtraceMessage.verify|verify} messages.
	                         * @function encode
	                         * @memberof perfetto.protos.FtraceConfig.PrintFilter.Rule.AtraceMessage
	                         * @static
	                         * @param {perfetto.protos.FtraceConfig.PrintFilter.Rule.IAtraceMessage} m AtraceMessage message or plain object to encode
	                         * @param {$protobuf.Writer} [w] Writer to encode to
	                         * @returns {$protobuf.Writer} Writer
	                         */
	                        AtraceMessage.encode = function encode(m, w) {
	                            if (!w)
	                                w = $Writer.create();
	                            if (m.type != null && Object.hasOwnProperty.call(m, "type"))
	                                w.uint32(10).string(m.type);
	                            if (m.prefix != null && Object.hasOwnProperty.call(m, "prefix"))
	                                w.uint32(18).string(m.prefix);
	                            return w;
	                        };

	                        /**
	                         * Decodes an AtraceMessage message from the specified reader or buffer.
	                         * @function decode
	                         * @memberof perfetto.protos.FtraceConfig.PrintFilter.Rule.AtraceMessage
	                         * @static
	                         * @param {$protobuf.Reader|Uint8Array} r Reader or buffer to decode from
	                         * @param {number} [l] Message length if known beforehand
	                         * @returns {perfetto.protos.FtraceConfig.PrintFilter.Rule.AtraceMessage} AtraceMessage
	                         * @throws {Error} If the payload is not a reader or valid buffer
	                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
	                         */
	                        AtraceMessage.decode = function decode(r, l) {
	                            if (!(r instanceof $Reader))
	                                r = $Reader.create(r);
	                            var c = l === undefined ? r.len : r.pos + l, m = new $root.perfetto.protos.FtraceConfig.PrintFilter.Rule.AtraceMessage();
	                            while (r.pos < c) {
	                                var t = r.uint32();
	                                switch (t >>> 3) {
	                                case 1:
	                                    m.type = r.string();
	                                    break;
	                                case 2:
	                                    m.prefix = r.string();
	                                    break;
	                                default:
	                                    r.skipType(t & 7);
	                                    break;
	                                }
	                            }
	                            return m;
	                        };

	                        /**
	                         * Creates an AtraceMessage message from a plain object. Also converts values to their respective internal types.
	                         * @function fromObject
	                         * @memberof perfetto.protos.FtraceConfig.PrintFilter.Rule.AtraceMessage
	                         * @static
	                         * @param {Object.<string,*>} d Plain object
	                         * @returns {perfetto.protos.FtraceConfig.PrintFilter.Rule.AtraceMessage} AtraceMessage
	                         */
	                        AtraceMessage.fromObject = function fromObject(d) {
	                            if (d instanceof $root.perfetto.protos.FtraceConfig.PrintFilter.Rule.AtraceMessage)
	                                return d;
	                            var m = new $root.perfetto.protos.FtraceConfig.PrintFilter.Rule.AtraceMessage();
	                            if (d.type != null) {
	                                m.type = String(d.type);
	                            }
	                            if (d.prefix != null) {
	                                m.prefix = String(d.prefix);
	                            }
	                            return m;
	                        };

	                        /**
	                         * Creates a plain object from an AtraceMessage message. Also converts values to other types if specified.
	                         * @function toObject
	                         * @memberof perfetto.protos.FtraceConfig.PrintFilter.Rule.AtraceMessage
	                         * @static
	                         * @param {perfetto.protos.FtraceConfig.PrintFilter.Rule.AtraceMessage} m AtraceMessage
	                         * @param {$protobuf.IConversionOptions} [o] Conversion options
	                         * @returns {Object.<string,*>} Plain object
	                         */
	                        AtraceMessage.toObject = function toObject(m, o) {
	                            if (!o)
	                                o = {};
	                            var d = {};
	                            if (o.defaults) {
	                                d.type = "";
	                                d.prefix = "";
	                            }
	                            if (m.type != null && m.hasOwnProperty("type")) {
	                                d.type = m.type;
	                            }
	                            if (m.prefix != null && m.hasOwnProperty("prefix")) {
	                                d.prefix = m.prefix;
	                            }
	                            return d;
	                        };

	                        /**
	                         * Converts this AtraceMessage to JSON.
	                         * @function toJSON
	                         * @memberof perfetto.protos.FtraceConfig.PrintFilter.Rule.AtraceMessage
	                         * @instance
	                         * @returns {Object.<string,*>} JSON object
	                         */
	                        AtraceMessage.prototype.toJSON = function toJSON() {
	                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
	                        };

	                        return AtraceMessage;
	                    })();

	                    return Rule;
	                })();

	                return PrintFilter;
	            })();

	            /**
	             * KsymsMemPolicy enum.
	             * @name perfetto.protos.FtraceConfig.KsymsMemPolicy
	             * @enum {number}
	             * @property {number} KSYMS_UNSPECIFIED=0 KSYMS_UNSPECIFIED value
	             * @property {number} KSYMS_CLEANUP_ON_STOP=1 KSYMS_CLEANUP_ON_STOP value
	             * @property {number} KSYMS_RETAIN=2 KSYMS_RETAIN value
	             */
	            FtraceConfig.KsymsMemPolicy = (function() {
	                var valuesById = {}, values = Object.create(valuesById);
	                values[valuesById[0] = "KSYMS_UNSPECIFIED"] = 0;
	                values[valuesById[1] = "KSYMS_CLEANUP_ON_STOP"] = 1;
	                values[valuesById[2] = "KSYMS_RETAIN"] = 2;
	                return values;
	            })();

	            return FtraceConfig;
	        })();

	        protos.GpuCounterConfig = (function() {

	            /**
	             * Properties of a GpuCounterConfig.
	             * @memberof perfetto.protos
	             * @interface IGpuCounterConfig
	             * @property {number|null} [counterPeriodNs] GpuCounterConfig counterPeriodNs
	             * @property {Array.<number>|null} [counterIds] GpuCounterConfig counterIds
	             * @property {boolean|null} [instrumentedSampling] GpuCounterConfig instrumentedSampling
	             * @property {boolean|null} [fixGpuClock] GpuCounterConfig fixGpuClock
	             */

	            /**
	             * Constructs a new GpuCounterConfig.
	             * @memberof perfetto.protos
	             * @classdesc Represents a GpuCounterConfig.
	             * @implements IGpuCounterConfig
	             * @constructor
	             * @param {perfetto.protos.IGpuCounterConfig=} [p] Properties to set
	             */
	            function GpuCounterConfig(p) {
	                this.counterIds = [];
	                if (p)
	                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
	                        if (p[ks[i]] != null)
	                            this[ks[i]] = p[ks[i]];
	            }

	            /**
	             * GpuCounterConfig counterPeriodNs.
	             * @member {number} counterPeriodNs
	             * @memberof perfetto.protos.GpuCounterConfig
	             * @instance
	             */
	            GpuCounterConfig.prototype.counterPeriodNs = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

	            /**
	             * GpuCounterConfig counterIds.
	             * @member {Array.<number>} counterIds
	             * @memberof perfetto.protos.GpuCounterConfig
	             * @instance
	             */
	            GpuCounterConfig.prototype.counterIds = $util.emptyArray;

	            /**
	             * GpuCounterConfig instrumentedSampling.
	             * @member {boolean} instrumentedSampling
	             * @memberof perfetto.protos.GpuCounterConfig
	             * @instance
	             */
	            GpuCounterConfig.prototype.instrumentedSampling = false;

	            /**
	             * GpuCounterConfig fixGpuClock.
	             * @member {boolean} fixGpuClock
	             * @memberof perfetto.protos.GpuCounterConfig
	             * @instance
	             */
	            GpuCounterConfig.prototype.fixGpuClock = false;

	            /**
	             * Creates a new GpuCounterConfig instance using the specified properties.
	             * @function create
	             * @memberof perfetto.protos.GpuCounterConfig
	             * @static
	             * @param {perfetto.protos.IGpuCounterConfig=} [properties] Properties to set
	             * @returns {perfetto.protos.GpuCounterConfig} GpuCounterConfig instance
	             */
	            GpuCounterConfig.create = function create(properties) {
	                return new GpuCounterConfig(properties);
	            };

	            /**
	             * Encodes the specified GpuCounterConfig message. Does not implicitly {@link perfetto.protos.GpuCounterConfig.verify|verify} messages.
	             * @function encode
	             * @memberof perfetto.protos.GpuCounterConfig
	             * @static
	             * @param {perfetto.protos.IGpuCounterConfig} m GpuCounterConfig message or plain object to encode
	             * @param {$protobuf.Writer} [w] Writer to encode to
	             * @returns {$protobuf.Writer} Writer
	             */
	            GpuCounterConfig.encode = function encode(m, w) {
	                if (!w)
	                    w = $Writer.create();
	                if (m.counterPeriodNs != null && Object.hasOwnProperty.call(m, "counterPeriodNs"))
	                    w.uint32(8).uint64(m.counterPeriodNs);
	                if (m.counterIds != null && m.counterIds.length) {
	                    for (var i = 0; i < m.counterIds.length; ++i)
	                        w.uint32(16).uint32(m.counterIds[i]);
	                }
	                if (m.instrumentedSampling != null && Object.hasOwnProperty.call(m, "instrumentedSampling"))
	                    w.uint32(24).bool(m.instrumentedSampling);
	                if (m.fixGpuClock != null && Object.hasOwnProperty.call(m, "fixGpuClock"))
	                    w.uint32(32).bool(m.fixGpuClock);
	                return w;
	            };

	            /**
	             * Decodes a GpuCounterConfig message from the specified reader or buffer.
	             * @function decode
	             * @memberof perfetto.protos.GpuCounterConfig
	             * @static
	             * @param {$protobuf.Reader|Uint8Array} r Reader or buffer to decode from
	             * @param {number} [l] Message length if known beforehand
	             * @returns {perfetto.protos.GpuCounterConfig} GpuCounterConfig
	             * @throws {Error} If the payload is not a reader or valid buffer
	             * @throws {$protobuf.util.ProtocolError} If required fields are missing
	             */
	            GpuCounterConfig.decode = function decode(r, l) {
	                if (!(r instanceof $Reader))
	                    r = $Reader.create(r);
	                var c = l === undefined ? r.len : r.pos + l, m = new $root.perfetto.protos.GpuCounterConfig();
	                while (r.pos < c) {
	                    var t = r.uint32();
	                    switch (t >>> 3) {
	                    case 1:
	                        m.counterPeriodNs = r.uint64();
	                        break;
	                    case 2:
	                        if (!(m.counterIds && m.counterIds.length))
	                            m.counterIds = [];
	                        if ((t & 7) === 2) {
	                            var c2 = r.uint32() + r.pos;
	                            while (r.pos < c2)
	                                m.counterIds.push(r.uint32());
	                        } else
	                            m.counterIds.push(r.uint32());
	                        break;
	                    case 3:
	                        m.instrumentedSampling = r.bool();
	                        break;
	                    case 4:
	                        m.fixGpuClock = r.bool();
	                        break;
	                    default:
	                        r.skipType(t & 7);
	                        break;
	                    }
	                }
	                return m;
	            };

	            /**
	             * Creates a GpuCounterConfig message from a plain object. Also converts values to their respective internal types.
	             * @function fromObject
	             * @memberof perfetto.protos.GpuCounterConfig
	             * @static
	             * @param {Object.<string,*>} d Plain object
	             * @returns {perfetto.protos.GpuCounterConfig} GpuCounterConfig
	             */
	            GpuCounterConfig.fromObject = function fromObject(d) {
	                if (d instanceof $root.perfetto.protos.GpuCounterConfig)
	                    return d;
	                var m = new $root.perfetto.protos.GpuCounterConfig();
	                if (d.counterPeriodNs != null) {
	                    if ($util.Long)
	                        (m.counterPeriodNs = $util.Long.fromValue(d.counterPeriodNs)).unsigned = true;
	                    else if (typeof d.counterPeriodNs === "string")
	                        m.counterPeriodNs = parseInt(d.counterPeriodNs, 10);
	                    else if (typeof d.counterPeriodNs === "number")
	                        m.counterPeriodNs = d.counterPeriodNs;
	                    else if (typeof d.counterPeriodNs === "object")
	                        m.counterPeriodNs = new $util.LongBits(d.counterPeriodNs.low >>> 0, d.counterPeriodNs.high >>> 0).toNumber(true);
	                }
	                if (d.counterIds) {
	                    if (!Array.isArray(d.counterIds))
	                        throw TypeError(".perfetto.protos.GpuCounterConfig.counterIds: array expected");
	                    m.counterIds = [];
	                    for (var i = 0; i < d.counterIds.length; ++i) {
	                        m.counterIds[i] = d.counterIds[i] >>> 0;
	                    }
	                }
	                if (d.instrumentedSampling != null) {
	                    m.instrumentedSampling = Boolean(d.instrumentedSampling);
	                }
	                if (d.fixGpuClock != null) {
	                    m.fixGpuClock = Boolean(d.fixGpuClock);
	                }
	                return m;
	            };

	            /**
	             * Creates a plain object from a GpuCounterConfig message. Also converts values to other types if specified.
	             * @function toObject
	             * @memberof perfetto.protos.GpuCounterConfig
	             * @static
	             * @param {perfetto.protos.GpuCounterConfig} m GpuCounterConfig
	             * @param {$protobuf.IConversionOptions} [o] Conversion options
	             * @returns {Object.<string,*>} Plain object
	             */
	            GpuCounterConfig.toObject = function toObject(m, o) {
	                if (!o)
	                    o = {};
	                var d = {};
	                if (o.arrays || o.defaults) {
	                    d.counterIds = [];
	                }
	                if (o.defaults) {
	                    if ($util.Long) {
	                        var n = new $util.Long(0, 0, true);
	                        d.counterPeriodNs = o.longs === String ? n.toString() : o.longs === Number ? n.toNumber() : n;
	                    } else
	                        d.counterPeriodNs = o.longs === String ? "0" : 0;
	                    d.instrumentedSampling = false;
	                    d.fixGpuClock = false;
	                }
	                if (m.counterPeriodNs != null && m.hasOwnProperty("counterPeriodNs")) {
	                    if (typeof m.counterPeriodNs === "number")
	                        d.counterPeriodNs = o.longs === String ? String(m.counterPeriodNs) : m.counterPeriodNs;
	                    else
	                        d.counterPeriodNs = o.longs === String ? $util.Long.prototype.toString.call(m.counterPeriodNs) : o.longs === Number ? new $util.LongBits(m.counterPeriodNs.low >>> 0, m.counterPeriodNs.high >>> 0).toNumber(true) : m.counterPeriodNs;
	                }
	                if (m.counterIds && m.counterIds.length) {
	                    d.counterIds = [];
	                    for (var j = 0; j < m.counterIds.length; ++j) {
	                        d.counterIds[j] = m.counterIds[j];
	                    }
	                }
	                if (m.instrumentedSampling != null && m.hasOwnProperty("instrumentedSampling")) {
	                    d.instrumentedSampling = m.instrumentedSampling;
	                }
	                if (m.fixGpuClock != null && m.hasOwnProperty("fixGpuClock")) {
	                    d.fixGpuClock = m.fixGpuClock;
	                }
	                return d;
	            };

	            /**
	             * Converts this GpuCounterConfig to JSON.
	             * @function toJSON
	             * @memberof perfetto.protos.GpuCounterConfig
	             * @instance
	             * @returns {Object.<string,*>} JSON object
	             */
	            GpuCounterConfig.prototype.toJSON = function toJSON() {
	                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
	            };

	            return GpuCounterConfig;
	        })();

	        protos.VulkanMemoryConfig = (function() {

	            /**
	             * Properties of a VulkanMemoryConfig.
	             * @memberof perfetto.protos
	             * @interface IVulkanMemoryConfig
	             * @property {boolean|null} [trackDriverMemoryUsage] VulkanMemoryConfig trackDriverMemoryUsage
	             * @property {boolean|null} [trackDeviceMemoryUsage] VulkanMemoryConfig trackDeviceMemoryUsage
	             */

	            /**
	             * Constructs a new VulkanMemoryConfig.
	             * @memberof perfetto.protos
	             * @classdesc Represents a VulkanMemoryConfig.
	             * @implements IVulkanMemoryConfig
	             * @constructor
	             * @param {perfetto.protos.IVulkanMemoryConfig=} [p] Properties to set
	             */
	            function VulkanMemoryConfig(p) {
	                if (p)
	                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
	                        if (p[ks[i]] != null)
	                            this[ks[i]] = p[ks[i]];
	            }

	            /**
	             * VulkanMemoryConfig trackDriverMemoryUsage.
	             * @member {boolean} trackDriverMemoryUsage
	             * @memberof perfetto.protos.VulkanMemoryConfig
	             * @instance
	             */
	            VulkanMemoryConfig.prototype.trackDriverMemoryUsage = false;

	            /**
	             * VulkanMemoryConfig trackDeviceMemoryUsage.
	             * @member {boolean} trackDeviceMemoryUsage
	             * @memberof perfetto.protos.VulkanMemoryConfig
	             * @instance
	             */
	            VulkanMemoryConfig.prototype.trackDeviceMemoryUsage = false;

	            /**
	             * Creates a new VulkanMemoryConfig instance using the specified properties.
	             * @function create
	             * @memberof perfetto.protos.VulkanMemoryConfig
	             * @static
	             * @param {perfetto.protos.IVulkanMemoryConfig=} [properties] Properties to set
	             * @returns {perfetto.protos.VulkanMemoryConfig} VulkanMemoryConfig instance
	             */
	            VulkanMemoryConfig.create = function create(properties) {
	                return new VulkanMemoryConfig(properties);
	            };

	            /**
	             * Encodes the specified VulkanMemoryConfig message. Does not implicitly {@link perfetto.protos.VulkanMemoryConfig.verify|verify} messages.
	             * @function encode
	             * @memberof perfetto.protos.VulkanMemoryConfig
	             * @static
	             * @param {perfetto.protos.IVulkanMemoryConfig} m VulkanMemoryConfig message or plain object to encode
	             * @param {$protobuf.Writer} [w] Writer to encode to
	             * @returns {$protobuf.Writer} Writer
	             */
	            VulkanMemoryConfig.encode = function encode(m, w) {
	                if (!w)
	                    w = $Writer.create();
	                if (m.trackDriverMemoryUsage != null && Object.hasOwnProperty.call(m, "trackDriverMemoryUsage"))
	                    w.uint32(8).bool(m.trackDriverMemoryUsage);
	                if (m.trackDeviceMemoryUsage != null && Object.hasOwnProperty.call(m, "trackDeviceMemoryUsage"))
	                    w.uint32(16).bool(m.trackDeviceMemoryUsage);
	                return w;
	            };

	            /**
	             * Decodes a VulkanMemoryConfig message from the specified reader or buffer.
	             * @function decode
	             * @memberof perfetto.protos.VulkanMemoryConfig
	             * @static
	             * @param {$protobuf.Reader|Uint8Array} r Reader or buffer to decode from
	             * @param {number} [l] Message length if known beforehand
	             * @returns {perfetto.protos.VulkanMemoryConfig} VulkanMemoryConfig
	             * @throws {Error} If the payload is not a reader or valid buffer
	             * @throws {$protobuf.util.ProtocolError} If required fields are missing
	             */
	            VulkanMemoryConfig.decode = function decode(r, l) {
	                if (!(r instanceof $Reader))
	                    r = $Reader.create(r);
	                var c = l === undefined ? r.len : r.pos + l, m = new $root.perfetto.protos.VulkanMemoryConfig();
	                while (r.pos < c) {
	                    var t = r.uint32();
	                    switch (t >>> 3) {
	                    case 1:
	                        m.trackDriverMemoryUsage = r.bool();
	                        break;
	                    case 2:
	                        m.trackDeviceMemoryUsage = r.bool();
	                        break;
	                    default:
	                        r.skipType(t & 7);
	                        break;
	                    }
	                }
	                return m;
	            };

	            /**
	             * Creates a VulkanMemoryConfig message from a plain object. Also converts values to their respective internal types.
	             * @function fromObject
	             * @memberof perfetto.protos.VulkanMemoryConfig
	             * @static
	             * @param {Object.<string,*>} d Plain object
	             * @returns {perfetto.protos.VulkanMemoryConfig} VulkanMemoryConfig
	             */
	            VulkanMemoryConfig.fromObject = function fromObject(d) {
	                if (d instanceof $root.perfetto.protos.VulkanMemoryConfig)
	                    return d;
	                var m = new $root.perfetto.protos.VulkanMemoryConfig();
	                if (d.trackDriverMemoryUsage != null) {
	                    m.trackDriverMemoryUsage = Boolean(d.trackDriverMemoryUsage);
	                }
	                if (d.trackDeviceMemoryUsage != null) {
	                    m.trackDeviceMemoryUsage = Boolean(d.trackDeviceMemoryUsage);
	                }
	                return m;
	            };

	            /**
	             * Creates a plain object from a VulkanMemoryConfig message. Also converts values to other types if specified.
	             * @function toObject
	             * @memberof perfetto.protos.VulkanMemoryConfig
	             * @static
	             * @param {perfetto.protos.VulkanMemoryConfig} m VulkanMemoryConfig
	             * @param {$protobuf.IConversionOptions} [o] Conversion options
	             * @returns {Object.<string,*>} Plain object
	             */
	            VulkanMemoryConfig.toObject = function toObject(m, o) {
	                if (!o)
	                    o = {};
	                var d = {};
	                if (o.defaults) {
	                    d.trackDriverMemoryUsage = false;
	                    d.trackDeviceMemoryUsage = false;
	                }
	                if (m.trackDriverMemoryUsage != null && m.hasOwnProperty("trackDriverMemoryUsage")) {
	                    d.trackDriverMemoryUsage = m.trackDriverMemoryUsage;
	                }
	                if (m.trackDeviceMemoryUsage != null && m.hasOwnProperty("trackDeviceMemoryUsage")) {
	                    d.trackDeviceMemoryUsage = m.trackDeviceMemoryUsage;
	                }
	                return d;
	            };

	            /**
	             * Converts this VulkanMemoryConfig to JSON.
	             * @function toJSON
	             * @memberof perfetto.protos.VulkanMemoryConfig
	             * @instance
	             * @returns {Object.<string,*>} JSON object
	             */
	            VulkanMemoryConfig.prototype.toJSON = function toJSON() {
	                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
	            };

	            return VulkanMemoryConfig;
	        })();

	        protos.InodeFileConfig = (function() {

	            /**
	             * Properties of an InodeFileConfig.
	             * @memberof perfetto.protos
	             * @interface IInodeFileConfig
	             * @property {number|null} [scanIntervalMs] InodeFileConfig scanIntervalMs
	             * @property {number|null} [scanDelayMs] InodeFileConfig scanDelayMs
	             * @property {number|null} [scanBatchSize] InodeFileConfig scanBatchSize
	             * @property {boolean|null} [doNotScan] InodeFileConfig doNotScan
	             * @property {Array.<string>|null} [scanMountPoints] InodeFileConfig scanMountPoints
	             * @property {Array.<perfetto.protos.InodeFileConfig.IMountPointMappingEntry>|null} [mountPointMapping] InodeFileConfig mountPointMapping
	             */

	            /**
	             * Constructs a new InodeFileConfig.
	             * @memberof perfetto.protos
	             * @classdesc Represents an InodeFileConfig.
	             * @implements IInodeFileConfig
	             * @constructor
	             * @param {perfetto.protos.IInodeFileConfig=} [p] Properties to set
	             */
	            function InodeFileConfig(p) {
	                this.scanMountPoints = [];
	                this.mountPointMapping = [];
	                if (p)
	                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
	                        if (p[ks[i]] != null)
	                            this[ks[i]] = p[ks[i]];
	            }

	            /**
	             * InodeFileConfig scanIntervalMs.
	             * @member {number} scanIntervalMs
	             * @memberof perfetto.protos.InodeFileConfig
	             * @instance
	             */
	            InodeFileConfig.prototype.scanIntervalMs = 0;

	            /**
	             * InodeFileConfig scanDelayMs.
	             * @member {number} scanDelayMs
	             * @memberof perfetto.protos.InodeFileConfig
	             * @instance
	             */
	            InodeFileConfig.prototype.scanDelayMs = 0;

	            /**
	             * InodeFileConfig scanBatchSize.
	             * @member {number} scanBatchSize
	             * @memberof perfetto.protos.InodeFileConfig
	             * @instance
	             */
	            InodeFileConfig.prototype.scanBatchSize = 0;

	            /**
	             * InodeFileConfig doNotScan.
	             * @member {boolean} doNotScan
	             * @memberof perfetto.protos.InodeFileConfig
	             * @instance
	             */
	            InodeFileConfig.prototype.doNotScan = false;

	            /**
	             * InodeFileConfig scanMountPoints.
	             * @member {Array.<string>} scanMountPoints
	             * @memberof perfetto.protos.InodeFileConfig
	             * @instance
	             */
	            InodeFileConfig.prototype.scanMountPoints = $util.emptyArray;

	            /**
	             * InodeFileConfig mountPointMapping.
	             * @member {Array.<perfetto.protos.InodeFileConfig.IMountPointMappingEntry>} mountPointMapping
	             * @memberof perfetto.protos.InodeFileConfig
	             * @instance
	             */
	            InodeFileConfig.prototype.mountPointMapping = $util.emptyArray;

	            /**
	             * Creates a new InodeFileConfig instance using the specified properties.
	             * @function create
	             * @memberof perfetto.protos.InodeFileConfig
	             * @static
	             * @param {perfetto.protos.IInodeFileConfig=} [properties] Properties to set
	             * @returns {perfetto.protos.InodeFileConfig} InodeFileConfig instance
	             */
	            InodeFileConfig.create = function create(properties) {
	                return new InodeFileConfig(properties);
	            };

	            /**
	             * Encodes the specified InodeFileConfig message. Does not implicitly {@link perfetto.protos.InodeFileConfig.verify|verify} messages.
	             * @function encode
	             * @memberof perfetto.protos.InodeFileConfig
	             * @static
	             * @param {perfetto.protos.IInodeFileConfig} m InodeFileConfig message or plain object to encode
	             * @param {$protobuf.Writer} [w] Writer to encode to
	             * @returns {$protobuf.Writer} Writer
	             */
	            InodeFileConfig.encode = function encode(m, w) {
	                if (!w)
	                    w = $Writer.create();
	                if (m.scanIntervalMs != null && Object.hasOwnProperty.call(m, "scanIntervalMs"))
	                    w.uint32(8).uint32(m.scanIntervalMs);
	                if (m.scanDelayMs != null && Object.hasOwnProperty.call(m, "scanDelayMs"))
	                    w.uint32(16).uint32(m.scanDelayMs);
	                if (m.scanBatchSize != null && Object.hasOwnProperty.call(m, "scanBatchSize"))
	                    w.uint32(24).uint32(m.scanBatchSize);
	                if (m.doNotScan != null && Object.hasOwnProperty.call(m, "doNotScan"))
	                    w.uint32(32).bool(m.doNotScan);
	                if (m.scanMountPoints != null && m.scanMountPoints.length) {
	                    for (var i = 0; i < m.scanMountPoints.length; ++i)
	                        w.uint32(42).string(m.scanMountPoints[i]);
	                }
	                if (m.mountPointMapping != null && m.mountPointMapping.length) {
	                    for (var i = 0; i < m.mountPointMapping.length; ++i)
	                        $root.perfetto.protos.InodeFileConfig.MountPointMappingEntry.encode(m.mountPointMapping[i], w.uint32(50).fork()).ldelim();
	                }
	                return w;
	            };

	            /**
	             * Decodes an InodeFileConfig message from the specified reader or buffer.
	             * @function decode
	             * @memberof perfetto.protos.InodeFileConfig
	             * @static
	             * @param {$protobuf.Reader|Uint8Array} r Reader or buffer to decode from
	             * @param {number} [l] Message length if known beforehand
	             * @returns {perfetto.protos.InodeFileConfig} InodeFileConfig
	             * @throws {Error} If the payload is not a reader or valid buffer
	             * @throws {$protobuf.util.ProtocolError} If required fields are missing
	             */
	            InodeFileConfig.decode = function decode(r, l) {
	                if (!(r instanceof $Reader))
	                    r = $Reader.create(r);
	                var c = l === undefined ? r.len : r.pos + l, m = new $root.perfetto.protos.InodeFileConfig();
	                while (r.pos < c) {
	                    var t = r.uint32();
	                    switch (t >>> 3) {
	                    case 1:
	                        m.scanIntervalMs = r.uint32();
	                        break;
	                    case 2:
	                        m.scanDelayMs = r.uint32();
	                        break;
	                    case 3:
	                        m.scanBatchSize = r.uint32();
	                        break;
	                    case 4:
	                        m.doNotScan = r.bool();
	                        break;
	                    case 5:
	                        if (!(m.scanMountPoints && m.scanMountPoints.length))
	                            m.scanMountPoints = [];
	                        m.scanMountPoints.push(r.string());
	                        break;
	                    case 6:
	                        if (!(m.mountPointMapping && m.mountPointMapping.length))
	                            m.mountPointMapping = [];
	                        m.mountPointMapping.push($root.perfetto.protos.InodeFileConfig.MountPointMappingEntry.decode(r, r.uint32()));
	                        break;
	                    default:
	                        r.skipType(t & 7);
	                        break;
	                    }
	                }
	                return m;
	            };

	            /**
	             * Creates an InodeFileConfig message from a plain object. Also converts values to their respective internal types.
	             * @function fromObject
	             * @memberof perfetto.protos.InodeFileConfig
	             * @static
	             * @param {Object.<string,*>} d Plain object
	             * @returns {perfetto.protos.InodeFileConfig} InodeFileConfig
	             */
	            InodeFileConfig.fromObject = function fromObject(d) {
	                if (d instanceof $root.perfetto.protos.InodeFileConfig)
	                    return d;
	                var m = new $root.perfetto.protos.InodeFileConfig();
	                if (d.scanIntervalMs != null) {
	                    m.scanIntervalMs = d.scanIntervalMs >>> 0;
	                }
	                if (d.scanDelayMs != null) {
	                    m.scanDelayMs = d.scanDelayMs >>> 0;
	                }
	                if (d.scanBatchSize != null) {
	                    m.scanBatchSize = d.scanBatchSize >>> 0;
	                }
	                if (d.doNotScan != null) {
	                    m.doNotScan = Boolean(d.doNotScan);
	                }
	                if (d.scanMountPoints) {
	                    if (!Array.isArray(d.scanMountPoints))
	                        throw TypeError(".perfetto.protos.InodeFileConfig.scanMountPoints: array expected");
	                    m.scanMountPoints = [];
	                    for (var i = 0; i < d.scanMountPoints.length; ++i) {
	                        m.scanMountPoints[i] = String(d.scanMountPoints[i]);
	                    }
	                }
	                if (d.mountPointMapping) {
	                    if (!Array.isArray(d.mountPointMapping))
	                        throw TypeError(".perfetto.protos.InodeFileConfig.mountPointMapping: array expected");
	                    m.mountPointMapping = [];
	                    for (var i = 0; i < d.mountPointMapping.length; ++i) {
	                        if (typeof d.mountPointMapping[i] !== "object")
	                            throw TypeError(".perfetto.protos.InodeFileConfig.mountPointMapping: object expected");
	                        m.mountPointMapping[i] = $root.perfetto.protos.InodeFileConfig.MountPointMappingEntry.fromObject(d.mountPointMapping[i]);
	                    }
	                }
	                return m;
	            };

	            /**
	             * Creates a plain object from an InodeFileConfig message. Also converts values to other types if specified.
	             * @function toObject
	             * @memberof perfetto.protos.InodeFileConfig
	             * @static
	             * @param {perfetto.protos.InodeFileConfig} m InodeFileConfig
	             * @param {$protobuf.IConversionOptions} [o] Conversion options
	             * @returns {Object.<string,*>} Plain object
	             */
	            InodeFileConfig.toObject = function toObject(m, o) {
	                if (!o)
	                    o = {};
	                var d = {};
	                if (o.arrays || o.defaults) {
	                    d.scanMountPoints = [];
	                    d.mountPointMapping = [];
	                }
	                if (o.defaults) {
	                    d.scanIntervalMs = 0;
	                    d.scanDelayMs = 0;
	                    d.scanBatchSize = 0;
	                    d.doNotScan = false;
	                }
	                if (m.scanIntervalMs != null && m.hasOwnProperty("scanIntervalMs")) {
	                    d.scanIntervalMs = m.scanIntervalMs;
	                }
	                if (m.scanDelayMs != null && m.hasOwnProperty("scanDelayMs")) {
	                    d.scanDelayMs = m.scanDelayMs;
	                }
	                if (m.scanBatchSize != null && m.hasOwnProperty("scanBatchSize")) {
	                    d.scanBatchSize = m.scanBatchSize;
	                }
	                if (m.doNotScan != null && m.hasOwnProperty("doNotScan")) {
	                    d.doNotScan = m.doNotScan;
	                }
	                if (m.scanMountPoints && m.scanMountPoints.length) {
	                    d.scanMountPoints = [];
	                    for (var j = 0; j < m.scanMountPoints.length; ++j) {
	                        d.scanMountPoints[j] = m.scanMountPoints[j];
	                    }
	                }
	                if (m.mountPointMapping && m.mountPointMapping.length) {
	                    d.mountPointMapping = [];
	                    for (var j = 0; j < m.mountPointMapping.length; ++j) {
	                        d.mountPointMapping[j] = $root.perfetto.protos.InodeFileConfig.MountPointMappingEntry.toObject(m.mountPointMapping[j], o);
	                    }
	                }
	                return d;
	            };

	            /**
	             * Converts this InodeFileConfig to JSON.
	             * @function toJSON
	             * @memberof perfetto.protos.InodeFileConfig
	             * @instance
	             * @returns {Object.<string,*>} JSON object
	             */
	            InodeFileConfig.prototype.toJSON = function toJSON() {
	                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
	            };

	            InodeFileConfig.MountPointMappingEntry = (function() {

	                /**
	                 * Properties of a MountPointMappingEntry.
	                 * @memberof perfetto.protos.InodeFileConfig
	                 * @interface IMountPointMappingEntry
	                 * @property {string|null} [mountpoint] MountPointMappingEntry mountpoint
	                 * @property {Array.<string>|null} [scanRoots] MountPointMappingEntry scanRoots
	                 */

	                /**
	                 * Constructs a new MountPointMappingEntry.
	                 * @memberof perfetto.protos.InodeFileConfig
	                 * @classdesc Represents a MountPointMappingEntry.
	                 * @implements IMountPointMappingEntry
	                 * @constructor
	                 * @param {perfetto.protos.InodeFileConfig.IMountPointMappingEntry=} [p] Properties to set
	                 */
	                function MountPointMappingEntry(p) {
	                    this.scanRoots = [];
	                    if (p)
	                        for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
	                            if (p[ks[i]] != null)
	                                this[ks[i]] = p[ks[i]];
	                }

	                /**
	                 * MountPointMappingEntry mountpoint.
	                 * @member {string} mountpoint
	                 * @memberof perfetto.protos.InodeFileConfig.MountPointMappingEntry
	                 * @instance
	                 */
	                MountPointMappingEntry.prototype.mountpoint = "";

	                /**
	                 * MountPointMappingEntry scanRoots.
	                 * @member {Array.<string>} scanRoots
	                 * @memberof perfetto.protos.InodeFileConfig.MountPointMappingEntry
	                 * @instance
	                 */
	                MountPointMappingEntry.prototype.scanRoots = $util.emptyArray;

	                /**
	                 * Creates a new MountPointMappingEntry instance using the specified properties.
	                 * @function create
	                 * @memberof perfetto.protos.InodeFileConfig.MountPointMappingEntry
	                 * @static
	                 * @param {perfetto.protos.InodeFileConfig.IMountPointMappingEntry=} [properties] Properties to set
	                 * @returns {perfetto.protos.InodeFileConfig.MountPointMappingEntry} MountPointMappingEntry instance
	                 */
	                MountPointMappingEntry.create = function create(properties) {
	                    return new MountPointMappingEntry(properties);
	                };

	                /**
	                 * Encodes the specified MountPointMappingEntry message. Does not implicitly {@link perfetto.protos.InodeFileConfig.MountPointMappingEntry.verify|verify} messages.
	                 * @function encode
	                 * @memberof perfetto.protos.InodeFileConfig.MountPointMappingEntry
	                 * @static
	                 * @param {perfetto.protos.InodeFileConfig.IMountPointMappingEntry} m MountPointMappingEntry message or plain object to encode
	                 * @param {$protobuf.Writer} [w] Writer to encode to
	                 * @returns {$protobuf.Writer} Writer
	                 */
	                MountPointMappingEntry.encode = function encode(m, w) {
	                    if (!w)
	                        w = $Writer.create();
	                    if (m.mountpoint != null && Object.hasOwnProperty.call(m, "mountpoint"))
	                        w.uint32(10).string(m.mountpoint);
	                    if (m.scanRoots != null && m.scanRoots.length) {
	                        for (var i = 0; i < m.scanRoots.length; ++i)
	                            w.uint32(18).string(m.scanRoots[i]);
	                    }
	                    return w;
	                };

	                /**
	                 * Decodes a MountPointMappingEntry message from the specified reader or buffer.
	                 * @function decode
	                 * @memberof perfetto.protos.InodeFileConfig.MountPointMappingEntry
	                 * @static
	                 * @param {$protobuf.Reader|Uint8Array} r Reader or buffer to decode from
	                 * @param {number} [l] Message length if known beforehand
	                 * @returns {perfetto.protos.InodeFileConfig.MountPointMappingEntry} MountPointMappingEntry
	                 * @throws {Error} If the payload is not a reader or valid buffer
	                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
	                 */
	                MountPointMappingEntry.decode = function decode(r, l) {
	                    if (!(r instanceof $Reader))
	                        r = $Reader.create(r);
	                    var c = l === undefined ? r.len : r.pos + l, m = new $root.perfetto.protos.InodeFileConfig.MountPointMappingEntry();
	                    while (r.pos < c) {
	                        var t = r.uint32();
	                        switch (t >>> 3) {
	                        case 1:
	                            m.mountpoint = r.string();
	                            break;
	                        case 2:
	                            if (!(m.scanRoots && m.scanRoots.length))
	                                m.scanRoots = [];
	                            m.scanRoots.push(r.string());
	                            break;
	                        default:
	                            r.skipType(t & 7);
	                            break;
	                        }
	                    }
	                    return m;
	                };

	                /**
	                 * Creates a MountPointMappingEntry message from a plain object. Also converts values to their respective internal types.
	                 * @function fromObject
	                 * @memberof perfetto.protos.InodeFileConfig.MountPointMappingEntry
	                 * @static
	                 * @param {Object.<string,*>} d Plain object
	                 * @returns {perfetto.protos.InodeFileConfig.MountPointMappingEntry} MountPointMappingEntry
	                 */
	                MountPointMappingEntry.fromObject = function fromObject(d) {
	                    if (d instanceof $root.perfetto.protos.InodeFileConfig.MountPointMappingEntry)
	                        return d;
	                    var m = new $root.perfetto.protos.InodeFileConfig.MountPointMappingEntry();
	                    if (d.mountpoint != null) {
	                        m.mountpoint = String(d.mountpoint);
	                    }
	                    if (d.scanRoots) {
	                        if (!Array.isArray(d.scanRoots))
	                            throw TypeError(".perfetto.protos.InodeFileConfig.MountPointMappingEntry.scanRoots: array expected");
	                        m.scanRoots = [];
	                        for (var i = 0; i < d.scanRoots.length; ++i) {
	                            m.scanRoots[i] = String(d.scanRoots[i]);
	                        }
	                    }
	                    return m;
	                };

	                /**
	                 * Creates a plain object from a MountPointMappingEntry message. Also converts values to other types if specified.
	                 * @function toObject
	                 * @memberof perfetto.protos.InodeFileConfig.MountPointMappingEntry
	                 * @static
	                 * @param {perfetto.protos.InodeFileConfig.MountPointMappingEntry} m MountPointMappingEntry
	                 * @param {$protobuf.IConversionOptions} [o] Conversion options
	                 * @returns {Object.<string,*>} Plain object
	                 */
	                MountPointMappingEntry.toObject = function toObject(m, o) {
	                    if (!o)
	                        o = {};
	                    var d = {};
	                    if (o.arrays || o.defaults) {
	                        d.scanRoots = [];
	                    }
	                    if (o.defaults) {
	                        d.mountpoint = "";
	                    }
	                    if (m.mountpoint != null && m.hasOwnProperty("mountpoint")) {
	                        d.mountpoint = m.mountpoint;
	                    }
	                    if (m.scanRoots && m.scanRoots.length) {
	                        d.scanRoots = [];
	                        for (var j = 0; j < m.scanRoots.length; ++j) {
	                            d.scanRoots[j] = m.scanRoots[j];
	                        }
	                    }
	                    return d;
	                };

	                /**
	                 * Converts this MountPointMappingEntry to JSON.
	                 * @function toJSON
	                 * @memberof perfetto.protos.InodeFileConfig.MountPointMappingEntry
	                 * @instance
	                 * @returns {Object.<string,*>} JSON object
	                 */
	                MountPointMappingEntry.prototype.toJSON = function toJSON() {
	                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
	                };

	                return MountPointMappingEntry;
	            })();

	            return InodeFileConfig;
	        })();

	        protos.ConsoleConfig = (function() {

	            /**
	             * Properties of a ConsoleConfig.
	             * @memberof perfetto.protos
	             * @interface IConsoleConfig
	             * @property {perfetto.protos.ConsoleConfig.Output|null} [output] ConsoleConfig output
	             * @property {boolean|null} [enableColors] ConsoleConfig enableColors
	             */

	            /**
	             * Constructs a new ConsoleConfig.
	             * @memberof perfetto.protos
	             * @classdesc Represents a ConsoleConfig.
	             * @implements IConsoleConfig
	             * @constructor
	             * @param {perfetto.protos.IConsoleConfig=} [p] Properties to set
	             */
	            function ConsoleConfig(p) {
	                if (p)
	                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
	                        if (p[ks[i]] != null)
	                            this[ks[i]] = p[ks[i]];
	            }

	            /**
	             * ConsoleConfig output.
	             * @member {perfetto.protos.ConsoleConfig.Output} output
	             * @memberof perfetto.protos.ConsoleConfig
	             * @instance
	             */
	            ConsoleConfig.prototype.output = 0;

	            /**
	             * ConsoleConfig enableColors.
	             * @member {boolean} enableColors
	             * @memberof perfetto.protos.ConsoleConfig
	             * @instance
	             */
	            ConsoleConfig.prototype.enableColors = false;

	            /**
	             * Creates a new ConsoleConfig instance using the specified properties.
	             * @function create
	             * @memberof perfetto.protos.ConsoleConfig
	             * @static
	             * @param {perfetto.protos.IConsoleConfig=} [properties] Properties to set
	             * @returns {perfetto.protos.ConsoleConfig} ConsoleConfig instance
	             */
	            ConsoleConfig.create = function create(properties) {
	                return new ConsoleConfig(properties);
	            };

	            /**
	             * Encodes the specified ConsoleConfig message. Does not implicitly {@link perfetto.protos.ConsoleConfig.verify|verify} messages.
	             * @function encode
	             * @memberof perfetto.protos.ConsoleConfig
	             * @static
	             * @param {perfetto.protos.IConsoleConfig} m ConsoleConfig message or plain object to encode
	             * @param {$protobuf.Writer} [w] Writer to encode to
	             * @returns {$protobuf.Writer} Writer
	             */
	            ConsoleConfig.encode = function encode(m, w) {
	                if (!w)
	                    w = $Writer.create();
	                if (m.output != null && Object.hasOwnProperty.call(m, "output"))
	                    w.uint32(8).int32(m.output);
	                if (m.enableColors != null && Object.hasOwnProperty.call(m, "enableColors"))
	                    w.uint32(16).bool(m.enableColors);
	                return w;
	            };

	            /**
	             * Decodes a ConsoleConfig message from the specified reader or buffer.
	             * @function decode
	             * @memberof perfetto.protos.ConsoleConfig
	             * @static
	             * @param {$protobuf.Reader|Uint8Array} r Reader or buffer to decode from
	             * @param {number} [l] Message length if known beforehand
	             * @returns {perfetto.protos.ConsoleConfig} ConsoleConfig
	             * @throws {Error} If the payload is not a reader or valid buffer
	             * @throws {$protobuf.util.ProtocolError} If required fields are missing
	             */
	            ConsoleConfig.decode = function decode(r, l) {
	                if (!(r instanceof $Reader))
	                    r = $Reader.create(r);
	                var c = l === undefined ? r.len : r.pos + l, m = new $root.perfetto.protos.ConsoleConfig();
	                while (r.pos < c) {
	                    var t = r.uint32();
	                    switch (t >>> 3) {
	                    case 1:
	                        m.output = r.int32();
	                        break;
	                    case 2:
	                        m.enableColors = r.bool();
	                        break;
	                    default:
	                        r.skipType(t & 7);
	                        break;
	                    }
	                }
	                return m;
	            };

	            /**
	             * Creates a ConsoleConfig message from a plain object. Also converts values to their respective internal types.
	             * @function fromObject
	             * @memberof perfetto.protos.ConsoleConfig
	             * @static
	             * @param {Object.<string,*>} d Plain object
	             * @returns {perfetto.protos.ConsoleConfig} ConsoleConfig
	             */
	            ConsoleConfig.fromObject = function fromObject(d) {
	                if (d instanceof $root.perfetto.protos.ConsoleConfig)
	                    return d;
	                var m = new $root.perfetto.protos.ConsoleConfig();
	                switch (d.output) {
	                case "OUTPUT_UNSPECIFIED":
	                case 0:
	                    m.output = 0;
	                    break;
	                case "OUTPUT_STDOUT":
	                case 1:
	                    m.output = 1;
	                    break;
	                case "OUTPUT_STDERR":
	                case 2:
	                    m.output = 2;
	                    break;
	                }
	                if (d.enableColors != null) {
	                    m.enableColors = Boolean(d.enableColors);
	                }
	                return m;
	            };

	            /**
	             * Creates a plain object from a ConsoleConfig message. Also converts values to other types if specified.
	             * @function toObject
	             * @memberof perfetto.protos.ConsoleConfig
	             * @static
	             * @param {perfetto.protos.ConsoleConfig} m ConsoleConfig
	             * @param {$protobuf.IConversionOptions} [o] Conversion options
	             * @returns {Object.<string,*>} Plain object
	             */
	            ConsoleConfig.toObject = function toObject(m, o) {
	                if (!o)
	                    o = {};
	                var d = {};
	                if (o.defaults) {
	                    d.output = o.enums === String ? "OUTPUT_UNSPECIFIED" : 0;
	                    d.enableColors = false;
	                }
	                if (m.output != null && m.hasOwnProperty("output")) {
	                    d.output = o.enums === String ? $root.perfetto.protos.ConsoleConfig.Output[m.output] : m.output;
	                }
	                if (m.enableColors != null && m.hasOwnProperty("enableColors")) {
	                    d.enableColors = m.enableColors;
	                }
	                return d;
	            };

	            /**
	             * Converts this ConsoleConfig to JSON.
	             * @function toJSON
	             * @memberof perfetto.protos.ConsoleConfig
	             * @instance
	             * @returns {Object.<string,*>} JSON object
	             */
	            ConsoleConfig.prototype.toJSON = function toJSON() {
	                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
	            };

	            /**
	             * Output enum.
	             * @name perfetto.protos.ConsoleConfig.Output
	             * @enum {number}
	             * @property {number} OUTPUT_UNSPECIFIED=0 OUTPUT_UNSPECIFIED value
	             * @property {number} OUTPUT_STDOUT=1 OUTPUT_STDOUT value
	             * @property {number} OUTPUT_STDERR=2 OUTPUT_STDERR value
	             */
	            ConsoleConfig.Output = (function() {
	                var valuesById = {}, values = Object.create(valuesById);
	                values[valuesById[0] = "OUTPUT_UNSPECIFIED"] = 0;
	                values[valuesById[1] = "OUTPUT_STDOUT"] = 1;
	                values[valuesById[2] = "OUTPUT_STDERR"] = 2;
	                return values;
	            })();

	            return ConsoleConfig;
	        })();

	        protos.InterceptorConfig = (function() {

	            /**
	             * Properties of an InterceptorConfig.
	             * @memberof perfetto.protos
	             * @interface IInterceptorConfig
	             * @property {string|null} [name] InterceptorConfig name
	             * @property {perfetto.protos.IConsoleConfig|null} [consoleConfig] InterceptorConfig consoleConfig
	             */

	            /**
	             * Constructs a new InterceptorConfig.
	             * @memberof perfetto.protos
	             * @classdesc Represents an InterceptorConfig.
	             * @implements IInterceptorConfig
	             * @constructor
	             * @param {perfetto.protos.IInterceptorConfig=} [p] Properties to set
	             */
	            function InterceptorConfig(p) {
	                if (p)
	                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
	                        if (p[ks[i]] != null)
	                            this[ks[i]] = p[ks[i]];
	            }

	            /**
	             * InterceptorConfig name.
	             * @member {string} name
	             * @memberof perfetto.protos.InterceptorConfig
	             * @instance
	             */
	            InterceptorConfig.prototype.name = "";

	            /**
	             * InterceptorConfig consoleConfig.
	             * @member {perfetto.protos.IConsoleConfig|null|undefined} consoleConfig
	             * @memberof perfetto.protos.InterceptorConfig
	             * @instance
	             */
	            InterceptorConfig.prototype.consoleConfig = null;

	            /**
	             * Creates a new InterceptorConfig instance using the specified properties.
	             * @function create
	             * @memberof perfetto.protos.InterceptorConfig
	             * @static
	             * @param {perfetto.protos.IInterceptorConfig=} [properties] Properties to set
	             * @returns {perfetto.protos.InterceptorConfig} InterceptorConfig instance
	             */
	            InterceptorConfig.create = function create(properties) {
	                return new InterceptorConfig(properties);
	            };

	            /**
	             * Encodes the specified InterceptorConfig message. Does not implicitly {@link perfetto.protos.InterceptorConfig.verify|verify} messages.
	             * @function encode
	             * @memberof perfetto.protos.InterceptorConfig
	             * @static
	             * @param {perfetto.protos.IInterceptorConfig} m InterceptorConfig message or plain object to encode
	             * @param {$protobuf.Writer} [w] Writer to encode to
	             * @returns {$protobuf.Writer} Writer
	             */
	            InterceptorConfig.encode = function encode(m, w) {
	                if (!w)
	                    w = $Writer.create();
	                if (m.name != null && Object.hasOwnProperty.call(m, "name"))
	                    w.uint32(10).string(m.name);
	                if (m.consoleConfig != null && Object.hasOwnProperty.call(m, "consoleConfig"))
	                    $root.perfetto.protos.ConsoleConfig.encode(m.consoleConfig, w.uint32(802).fork()).ldelim();
	                return w;
	            };

	            /**
	             * Decodes an InterceptorConfig message from the specified reader or buffer.
	             * @function decode
	             * @memberof perfetto.protos.InterceptorConfig
	             * @static
	             * @param {$protobuf.Reader|Uint8Array} r Reader or buffer to decode from
	             * @param {number} [l] Message length if known beforehand
	             * @returns {perfetto.protos.InterceptorConfig} InterceptorConfig
	             * @throws {Error} If the payload is not a reader or valid buffer
	             * @throws {$protobuf.util.ProtocolError} If required fields are missing
	             */
	            InterceptorConfig.decode = function decode(r, l) {
	                if (!(r instanceof $Reader))
	                    r = $Reader.create(r);
	                var c = l === undefined ? r.len : r.pos + l, m = new $root.perfetto.protos.InterceptorConfig();
	                while (r.pos < c) {
	                    var t = r.uint32();
	                    switch (t >>> 3) {
	                    case 1:
	                        m.name = r.string();
	                        break;
	                    case 100:
	                        m.consoleConfig = $root.perfetto.protos.ConsoleConfig.decode(r, r.uint32());
	                        break;
	                    default:
	                        r.skipType(t & 7);
	                        break;
	                    }
	                }
	                return m;
	            };

	            /**
	             * Creates an InterceptorConfig message from a plain object. Also converts values to their respective internal types.
	             * @function fromObject
	             * @memberof perfetto.protos.InterceptorConfig
	             * @static
	             * @param {Object.<string,*>} d Plain object
	             * @returns {perfetto.protos.InterceptorConfig} InterceptorConfig
	             */
	            InterceptorConfig.fromObject = function fromObject(d) {
	                if (d instanceof $root.perfetto.protos.InterceptorConfig)
	                    return d;
	                var m = new $root.perfetto.protos.InterceptorConfig();
	                if (d.name != null) {
	                    m.name = String(d.name);
	                }
	                if (d.consoleConfig != null) {
	                    if (typeof d.consoleConfig !== "object")
	                        throw TypeError(".perfetto.protos.InterceptorConfig.consoleConfig: object expected");
	                    m.consoleConfig = $root.perfetto.protos.ConsoleConfig.fromObject(d.consoleConfig);
	                }
	                return m;
	            };

	            /**
	             * Creates a plain object from an InterceptorConfig message. Also converts values to other types if specified.
	             * @function toObject
	             * @memberof perfetto.protos.InterceptorConfig
	             * @static
	             * @param {perfetto.protos.InterceptorConfig} m InterceptorConfig
	             * @param {$protobuf.IConversionOptions} [o] Conversion options
	             * @returns {Object.<string,*>} Plain object
	             */
	            InterceptorConfig.toObject = function toObject(m, o) {
	                if (!o)
	                    o = {};
	                var d = {};
	                if (o.defaults) {
	                    d.name = "";
	                    d.consoleConfig = null;
	                }
	                if (m.name != null && m.hasOwnProperty("name")) {
	                    d.name = m.name;
	                }
	                if (m.consoleConfig != null && m.hasOwnProperty("consoleConfig")) {
	                    d.consoleConfig = $root.perfetto.protos.ConsoleConfig.toObject(m.consoleConfig, o);
	                }
	                return d;
	            };

	            /**
	             * Converts this InterceptorConfig to JSON.
	             * @function toJSON
	             * @memberof perfetto.protos.InterceptorConfig
	             * @instance
	             * @returns {Object.<string,*>} JSON object
	             */
	            InterceptorConfig.prototype.toJSON = function toJSON() {
	                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
	            };

	            return InterceptorConfig;
	        })();

	        protos.AndroidPowerConfig = (function() {

	            /**
	             * Properties of an AndroidPowerConfig.
	             * @memberof perfetto.protos
	             * @interface IAndroidPowerConfig
	             * @property {number|null} [batteryPollMs] AndroidPowerConfig batteryPollMs
	             * @property {Array.<perfetto.protos.AndroidPowerConfig.BatteryCounters>|null} [batteryCounters] AndroidPowerConfig batteryCounters
	             * @property {boolean|null} [collectPowerRails] AndroidPowerConfig collectPowerRails
	             * @property {boolean|null} [collectEnergyEstimationBreakdown] AndroidPowerConfig collectEnergyEstimationBreakdown
	             * @property {boolean|null} [collectEntityStateResidency] AndroidPowerConfig collectEntityStateResidency
	             */

	            /**
	             * Constructs a new AndroidPowerConfig.
	             * @memberof perfetto.protos
	             * @classdesc Represents an AndroidPowerConfig.
	             * @implements IAndroidPowerConfig
	             * @constructor
	             * @param {perfetto.protos.IAndroidPowerConfig=} [p] Properties to set
	             */
	            function AndroidPowerConfig(p) {
	                this.batteryCounters = [];
	                if (p)
	                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
	                        if (p[ks[i]] != null)
	                            this[ks[i]] = p[ks[i]];
	            }

	            /**
	             * AndroidPowerConfig batteryPollMs.
	             * @member {number} batteryPollMs
	             * @memberof perfetto.protos.AndroidPowerConfig
	             * @instance
	             */
	            AndroidPowerConfig.prototype.batteryPollMs = 0;

	            /**
	             * AndroidPowerConfig batteryCounters.
	             * @member {Array.<perfetto.protos.AndroidPowerConfig.BatteryCounters>} batteryCounters
	             * @memberof perfetto.protos.AndroidPowerConfig
	             * @instance
	             */
	            AndroidPowerConfig.prototype.batteryCounters = $util.emptyArray;

	            /**
	             * AndroidPowerConfig collectPowerRails.
	             * @member {boolean} collectPowerRails
	             * @memberof perfetto.protos.AndroidPowerConfig
	             * @instance
	             */
	            AndroidPowerConfig.prototype.collectPowerRails = false;

	            /**
	             * AndroidPowerConfig collectEnergyEstimationBreakdown.
	             * @member {boolean} collectEnergyEstimationBreakdown
	             * @memberof perfetto.protos.AndroidPowerConfig
	             * @instance
	             */
	            AndroidPowerConfig.prototype.collectEnergyEstimationBreakdown = false;

	            /**
	             * AndroidPowerConfig collectEntityStateResidency.
	             * @member {boolean} collectEntityStateResidency
	             * @memberof perfetto.protos.AndroidPowerConfig
	             * @instance
	             */
	            AndroidPowerConfig.prototype.collectEntityStateResidency = false;

	            /**
	             * Creates a new AndroidPowerConfig instance using the specified properties.
	             * @function create
	             * @memberof perfetto.protos.AndroidPowerConfig
	             * @static
	             * @param {perfetto.protos.IAndroidPowerConfig=} [properties] Properties to set
	             * @returns {perfetto.protos.AndroidPowerConfig} AndroidPowerConfig instance
	             */
	            AndroidPowerConfig.create = function create(properties) {
	                return new AndroidPowerConfig(properties);
	            };

	            /**
	             * Encodes the specified AndroidPowerConfig message. Does not implicitly {@link perfetto.protos.AndroidPowerConfig.verify|verify} messages.
	             * @function encode
	             * @memberof perfetto.protos.AndroidPowerConfig
	             * @static
	             * @param {perfetto.protos.IAndroidPowerConfig} m AndroidPowerConfig message or plain object to encode
	             * @param {$protobuf.Writer} [w] Writer to encode to
	             * @returns {$protobuf.Writer} Writer
	             */
	            AndroidPowerConfig.encode = function encode(m, w) {
	                if (!w)
	                    w = $Writer.create();
	                if (m.batteryPollMs != null && Object.hasOwnProperty.call(m, "batteryPollMs"))
	                    w.uint32(8).uint32(m.batteryPollMs);
	                if (m.batteryCounters != null && m.batteryCounters.length) {
	                    for (var i = 0; i < m.batteryCounters.length; ++i)
	                        w.uint32(16).int32(m.batteryCounters[i]);
	                }
	                if (m.collectPowerRails != null && Object.hasOwnProperty.call(m, "collectPowerRails"))
	                    w.uint32(24).bool(m.collectPowerRails);
	                if (m.collectEnergyEstimationBreakdown != null && Object.hasOwnProperty.call(m, "collectEnergyEstimationBreakdown"))
	                    w.uint32(32).bool(m.collectEnergyEstimationBreakdown);
	                if (m.collectEntityStateResidency != null && Object.hasOwnProperty.call(m, "collectEntityStateResidency"))
	                    w.uint32(40).bool(m.collectEntityStateResidency);
	                return w;
	            };

	            /**
	             * Decodes an AndroidPowerConfig message from the specified reader or buffer.
	             * @function decode
	             * @memberof perfetto.protos.AndroidPowerConfig
	             * @static
	             * @param {$protobuf.Reader|Uint8Array} r Reader or buffer to decode from
	             * @param {number} [l] Message length if known beforehand
	             * @returns {perfetto.protos.AndroidPowerConfig} AndroidPowerConfig
	             * @throws {Error} If the payload is not a reader or valid buffer
	             * @throws {$protobuf.util.ProtocolError} If required fields are missing
	             */
	            AndroidPowerConfig.decode = function decode(r, l) {
	                if (!(r instanceof $Reader))
	                    r = $Reader.create(r);
	                var c = l === undefined ? r.len : r.pos + l, m = new $root.perfetto.protos.AndroidPowerConfig();
	                while (r.pos < c) {
	                    var t = r.uint32();
	                    switch (t >>> 3) {
	                    case 1:
	                        m.batteryPollMs = r.uint32();
	                        break;
	                    case 2:
	                        if (!(m.batteryCounters && m.batteryCounters.length))
	                            m.batteryCounters = [];
	                        if ((t & 7) === 2) {
	                            var c2 = r.uint32() + r.pos;
	                            while (r.pos < c2)
	                                m.batteryCounters.push(r.int32());
	                        } else
	                            m.batteryCounters.push(r.int32());
	                        break;
	                    case 3:
	                        m.collectPowerRails = r.bool();
	                        break;
	                    case 4:
	                        m.collectEnergyEstimationBreakdown = r.bool();
	                        break;
	                    case 5:
	                        m.collectEntityStateResidency = r.bool();
	                        break;
	                    default:
	                        r.skipType(t & 7);
	                        break;
	                    }
	                }
	                return m;
	            };

	            /**
	             * Creates an AndroidPowerConfig message from a plain object. Also converts values to their respective internal types.
	             * @function fromObject
	             * @memberof perfetto.protos.AndroidPowerConfig
	             * @static
	             * @param {Object.<string,*>} d Plain object
	             * @returns {perfetto.protos.AndroidPowerConfig} AndroidPowerConfig
	             */
	            AndroidPowerConfig.fromObject = function fromObject(d) {
	                if (d instanceof $root.perfetto.protos.AndroidPowerConfig)
	                    return d;
	                var m = new $root.perfetto.protos.AndroidPowerConfig();
	                if (d.batteryPollMs != null) {
	                    m.batteryPollMs = d.batteryPollMs >>> 0;
	                }
	                if (d.batteryCounters) {
	                    if (!Array.isArray(d.batteryCounters))
	                        throw TypeError(".perfetto.protos.AndroidPowerConfig.batteryCounters: array expected");
	                    m.batteryCounters = [];
	                    for (var i = 0; i < d.batteryCounters.length; ++i) {
	                        switch (d.batteryCounters[i]) {
	                        default:
	                        case "BATTERY_COUNTER_UNSPECIFIED":
	                        case 0:
	                            m.batteryCounters[i] = 0;
	                            break;
	                        case "BATTERY_COUNTER_CHARGE":
	                        case 1:
	                            m.batteryCounters[i] = 1;
	                            break;
	                        case "BATTERY_COUNTER_CAPACITY_PERCENT":
	                        case 2:
	                            m.batteryCounters[i] = 2;
	                            break;
	                        case "BATTERY_COUNTER_CURRENT":
	                        case 3:
	                            m.batteryCounters[i] = 3;
	                            break;
	                        case "BATTERY_COUNTER_CURRENT_AVG":
	                        case 4:
	                            m.batteryCounters[i] = 4;
	                            break;
	                        }
	                    }
	                }
	                if (d.collectPowerRails != null) {
	                    m.collectPowerRails = Boolean(d.collectPowerRails);
	                }
	                if (d.collectEnergyEstimationBreakdown != null) {
	                    m.collectEnergyEstimationBreakdown = Boolean(d.collectEnergyEstimationBreakdown);
	                }
	                if (d.collectEntityStateResidency != null) {
	                    m.collectEntityStateResidency = Boolean(d.collectEntityStateResidency);
	                }
	                return m;
	            };

	            /**
	             * Creates a plain object from an AndroidPowerConfig message. Also converts values to other types if specified.
	             * @function toObject
	             * @memberof perfetto.protos.AndroidPowerConfig
	             * @static
	             * @param {perfetto.protos.AndroidPowerConfig} m AndroidPowerConfig
	             * @param {$protobuf.IConversionOptions} [o] Conversion options
	             * @returns {Object.<string,*>} Plain object
	             */
	            AndroidPowerConfig.toObject = function toObject(m, o) {
	                if (!o)
	                    o = {};
	                var d = {};
	                if (o.arrays || o.defaults) {
	                    d.batteryCounters = [];
	                }
	                if (o.defaults) {
	                    d.batteryPollMs = 0;
	                    d.collectPowerRails = false;
	                    d.collectEnergyEstimationBreakdown = false;
	                    d.collectEntityStateResidency = false;
	                }
	                if (m.batteryPollMs != null && m.hasOwnProperty("batteryPollMs")) {
	                    d.batteryPollMs = m.batteryPollMs;
	                }
	                if (m.batteryCounters && m.batteryCounters.length) {
	                    d.batteryCounters = [];
	                    for (var j = 0; j < m.batteryCounters.length; ++j) {
	                        d.batteryCounters[j] = o.enums === String ? $root.perfetto.protos.AndroidPowerConfig.BatteryCounters[m.batteryCounters[j]] : m.batteryCounters[j];
	                    }
	                }
	                if (m.collectPowerRails != null && m.hasOwnProperty("collectPowerRails")) {
	                    d.collectPowerRails = m.collectPowerRails;
	                }
	                if (m.collectEnergyEstimationBreakdown != null && m.hasOwnProperty("collectEnergyEstimationBreakdown")) {
	                    d.collectEnergyEstimationBreakdown = m.collectEnergyEstimationBreakdown;
	                }
	                if (m.collectEntityStateResidency != null && m.hasOwnProperty("collectEntityStateResidency")) {
	                    d.collectEntityStateResidency = m.collectEntityStateResidency;
	                }
	                return d;
	            };

	            /**
	             * Converts this AndroidPowerConfig to JSON.
	             * @function toJSON
	             * @memberof perfetto.protos.AndroidPowerConfig
	             * @instance
	             * @returns {Object.<string,*>} JSON object
	             */
	            AndroidPowerConfig.prototype.toJSON = function toJSON() {
	                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
	            };

	            /**
	             * BatteryCounters enum.
	             * @name perfetto.protos.AndroidPowerConfig.BatteryCounters
	             * @enum {number}
	             * @property {number} BATTERY_COUNTER_UNSPECIFIED=0 BATTERY_COUNTER_UNSPECIFIED value
	             * @property {number} BATTERY_COUNTER_CHARGE=1 BATTERY_COUNTER_CHARGE value
	             * @property {number} BATTERY_COUNTER_CAPACITY_PERCENT=2 BATTERY_COUNTER_CAPACITY_PERCENT value
	             * @property {number} BATTERY_COUNTER_CURRENT=3 BATTERY_COUNTER_CURRENT value
	             * @property {number} BATTERY_COUNTER_CURRENT_AVG=4 BATTERY_COUNTER_CURRENT_AVG value
	             */
	            AndroidPowerConfig.BatteryCounters = (function() {
	                var valuesById = {}, values = Object.create(valuesById);
	                values[valuesById[0] = "BATTERY_COUNTER_UNSPECIFIED"] = 0;
	                values[valuesById[1] = "BATTERY_COUNTER_CHARGE"] = 1;
	                values[valuesById[2] = "BATTERY_COUNTER_CAPACITY_PERCENT"] = 2;
	                values[valuesById[3] = "BATTERY_COUNTER_CURRENT"] = 3;
	                values[valuesById[4] = "BATTERY_COUNTER_CURRENT_AVG"] = 4;
	                return values;
	            })();

	            return AndroidPowerConfig;
	        })();

	        protos.ProcessStatsConfig = (function() {

	            /**
	             * Properties of a ProcessStatsConfig.
	             * @memberof perfetto.protos
	             * @interface IProcessStatsConfig
	             * @property {Array.<perfetto.protos.ProcessStatsConfig.Quirks>|null} [quirks] ProcessStatsConfig quirks
	             * @property {boolean|null} [scanAllProcessesOnStart] ProcessStatsConfig scanAllProcessesOnStart
	             * @property {boolean|null} [recordThreadNames] ProcessStatsConfig recordThreadNames
	             * @property {number|null} [procStatsPollMs] ProcessStatsConfig procStatsPollMs
	             * @property {number|null} [procStatsCacheTtlMs] ProcessStatsConfig procStatsCacheTtlMs
	             * @property {boolean|null} [resolveProcessFds] ProcessStatsConfig resolveProcessFds
	             */

	            /**
	             * Constructs a new ProcessStatsConfig.
	             * @memberof perfetto.protos
	             * @classdesc Represents a ProcessStatsConfig.
	             * @implements IProcessStatsConfig
	             * @constructor
	             * @param {perfetto.protos.IProcessStatsConfig=} [p] Properties to set
	             */
	            function ProcessStatsConfig(p) {
	                this.quirks = [];
	                if (p)
	                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
	                        if (p[ks[i]] != null)
	                            this[ks[i]] = p[ks[i]];
	            }

	            /**
	             * ProcessStatsConfig quirks.
	             * @member {Array.<perfetto.protos.ProcessStatsConfig.Quirks>} quirks
	             * @memberof perfetto.protos.ProcessStatsConfig
	             * @instance
	             */
	            ProcessStatsConfig.prototype.quirks = $util.emptyArray;

	            /**
	             * ProcessStatsConfig scanAllProcessesOnStart.
	             * @member {boolean} scanAllProcessesOnStart
	             * @memberof perfetto.protos.ProcessStatsConfig
	             * @instance
	             */
	            ProcessStatsConfig.prototype.scanAllProcessesOnStart = false;

	            /**
	             * ProcessStatsConfig recordThreadNames.
	             * @member {boolean} recordThreadNames
	             * @memberof perfetto.protos.ProcessStatsConfig
	             * @instance
	             */
	            ProcessStatsConfig.prototype.recordThreadNames = false;

	            /**
	             * ProcessStatsConfig procStatsPollMs.
	             * @member {number} procStatsPollMs
	             * @memberof perfetto.protos.ProcessStatsConfig
	             * @instance
	             */
	            ProcessStatsConfig.prototype.procStatsPollMs = 0;

	            /**
	             * ProcessStatsConfig procStatsCacheTtlMs.
	             * @member {number} procStatsCacheTtlMs
	             * @memberof perfetto.protos.ProcessStatsConfig
	             * @instance
	             */
	            ProcessStatsConfig.prototype.procStatsCacheTtlMs = 0;

	            /**
	             * ProcessStatsConfig resolveProcessFds.
	             * @member {boolean} resolveProcessFds
	             * @memberof perfetto.protos.ProcessStatsConfig
	             * @instance
	             */
	            ProcessStatsConfig.prototype.resolveProcessFds = false;

	            /**
	             * Creates a new ProcessStatsConfig instance using the specified properties.
	             * @function create
	             * @memberof perfetto.protos.ProcessStatsConfig
	             * @static
	             * @param {perfetto.protos.IProcessStatsConfig=} [properties] Properties to set
	             * @returns {perfetto.protos.ProcessStatsConfig} ProcessStatsConfig instance
	             */
	            ProcessStatsConfig.create = function create(properties) {
	                return new ProcessStatsConfig(properties);
	            };

	            /**
	             * Encodes the specified ProcessStatsConfig message. Does not implicitly {@link perfetto.protos.ProcessStatsConfig.verify|verify} messages.
	             * @function encode
	             * @memberof perfetto.protos.ProcessStatsConfig
	             * @static
	             * @param {perfetto.protos.IProcessStatsConfig} m ProcessStatsConfig message or plain object to encode
	             * @param {$protobuf.Writer} [w] Writer to encode to
	             * @returns {$protobuf.Writer} Writer
	             */
	            ProcessStatsConfig.encode = function encode(m, w) {
	                if (!w)
	                    w = $Writer.create();
	                if (m.quirks != null && m.quirks.length) {
	                    for (var i = 0; i < m.quirks.length; ++i)
	                        w.uint32(8).int32(m.quirks[i]);
	                }
	                if (m.scanAllProcessesOnStart != null && Object.hasOwnProperty.call(m, "scanAllProcessesOnStart"))
	                    w.uint32(16).bool(m.scanAllProcessesOnStart);
	                if (m.recordThreadNames != null && Object.hasOwnProperty.call(m, "recordThreadNames"))
	                    w.uint32(24).bool(m.recordThreadNames);
	                if (m.procStatsPollMs != null && Object.hasOwnProperty.call(m, "procStatsPollMs"))
	                    w.uint32(32).uint32(m.procStatsPollMs);
	                if (m.procStatsCacheTtlMs != null && Object.hasOwnProperty.call(m, "procStatsCacheTtlMs"))
	                    w.uint32(48).uint32(m.procStatsCacheTtlMs);
	                if (m.resolveProcessFds != null && Object.hasOwnProperty.call(m, "resolveProcessFds"))
	                    w.uint32(72).bool(m.resolveProcessFds);
	                return w;
	            };

	            /**
	             * Decodes a ProcessStatsConfig message from the specified reader or buffer.
	             * @function decode
	             * @memberof perfetto.protos.ProcessStatsConfig
	             * @static
	             * @param {$protobuf.Reader|Uint8Array} r Reader or buffer to decode from
	             * @param {number} [l] Message length if known beforehand
	             * @returns {perfetto.protos.ProcessStatsConfig} ProcessStatsConfig
	             * @throws {Error} If the payload is not a reader or valid buffer
	             * @throws {$protobuf.util.ProtocolError} If required fields are missing
	             */
	            ProcessStatsConfig.decode = function decode(r, l) {
	                if (!(r instanceof $Reader))
	                    r = $Reader.create(r);
	                var c = l === undefined ? r.len : r.pos + l, m = new $root.perfetto.protos.ProcessStatsConfig();
	                while (r.pos < c) {
	                    var t = r.uint32();
	                    switch (t >>> 3) {
	                    case 1:
	                        if (!(m.quirks && m.quirks.length))
	                            m.quirks = [];
	                        if ((t & 7) === 2) {
	                            var c2 = r.uint32() + r.pos;
	                            while (r.pos < c2)
	                                m.quirks.push(r.int32());
	                        } else
	                            m.quirks.push(r.int32());
	                        break;
	                    case 2:
	                        m.scanAllProcessesOnStart = r.bool();
	                        break;
	                    case 3:
	                        m.recordThreadNames = r.bool();
	                        break;
	                    case 4:
	                        m.procStatsPollMs = r.uint32();
	                        break;
	                    case 6:
	                        m.procStatsCacheTtlMs = r.uint32();
	                        break;
	                    case 9:
	                        m.resolveProcessFds = r.bool();
	                        break;
	                    default:
	                        r.skipType(t & 7);
	                        break;
	                    }
	                }
	                return m;
	            };

	            /**
	             * Creates a ProcessStatsConfig message from a plain object. Also converts values to their respective internal types.
	             * @function fromObject
	             * @memberof perfetto.protos.ProcessStatsConfig
	             * @static
	             * @param {Object.<string,*>} d Plain object
	             * @returns {perfetto.protos.ProcessStatsConfig} ProcessStatsConfig
	             */
	            ProcessStatsConfig.fromObject = function fromObject(d) {
	                if (d instanceof $root.perfetto.protos.ProcessStatsConfig)
	                    return d;
	                var m = new $root.perfetto.protos.ProcessStatsConfig();
	                if (d.quirks) {
	                    if (!Array.isArray(d.quirks))
	                        throw TypeError(".perfetto.protos.ProcessStatsConfig.quirks: array expected");
	                    m.quirks = [];
	                    for (var i = 0; i < d.quirks.length; ++i) {
	                        switch (d.quirks[i]) {
	                        default:
	                        case "QUIRKS_UNSPECIFIED":
	                        case 0:
	                            m.quirks[i] = 0;
	                            break;
	                        case "DISABLE_INITIAL_DUMP":
	                        case 1:
	                            m.quirks[i] = 1;
	                            break;
	                        case "DISABLE_ON_DEMAND":
	                        case 2:
	                            m.quirks[i] = 2;
	                            break;
	                        }
	                    }
	                }
	                if (d.scanAllProcessesOnStart != null) {
	                    m.scanAllProcessesOnStart = Boolean(d.scanAllProcessesOnStart);
	                }
	                if (d.recordThreadNames != null) {
	                    m.recordThreadNames = Boolean(d.recordThreadNames);
	                }
	                if (d.procStatsPollMs != null) {
	                    m.procStatsPollMs = d.procStatsPollMs >>> 0;
	                }
	                if (d.procStatsCacheTtlMs != null) {
	                    m.procStatsCacheTtlMs = d.procStatsCacheTtlMs >>> 0;
	                }
	                if (d.resolveProcessFds != null) {
	                    m.resolveProcessFds = Boolean(d.resolveProcessFds);
	                }
	                return m;
	            };

	            /**
	             * Creates a plain object from a ProcessStatsConfig message. Also converts values to other types if specified.
	             * @function toObject
	             * @memberof perfetto.protos.ProcessStatsConfig
	             * @static
	             * @param {perfetto.protos.ProcessStatsConfig} m ProcessStatsConfig
	             * @param {$protobuf.IConversionOptions} [o] Conversion options
	             * @returns {Object.<string,*>} Plain object
	             */
	            ProcessStatsConfig.toObject = function toObject(m, o) {
	                if (!o)
	                    o = {};
	                var d = {};
	                if (o.arrays || o.defaults) {
	                    d.quirks = [];
	                }
	                if (o.defaults) {
	                    d.scanAllProcessesOnStart = false;
	                    d.recordThreadNames = false;
	                    d.procStatsPollMs = 0;
	                    d.procStatsCacheTtlMs = 0;
	                    d.resolveProcessFds = false;
	                }
	                if (m.quirks && m.quirks.length) {
	                    d.quirks = [];
	                    for (var j = 0; j < m.quirks.length; ++j) {
	                        d.quirks[j] = o.enums === String ? $root.perfetto.protos.ProcessStatsConfig.Quirks[m.quirks[j]] : m.quirks[j];
	                    }
	                }
	                if (m.scanAllProcessesOnStart != null && m.hasOwnProperty("scanAllProcessesOnStart")) {
	                    d.scanAllProcessesOnStart = m.scanAllProcessesOnStart;
	                }
	                if (m.recordThreadNames != null && m.hasOwnProperty("recordThreadNames")) {
	                    d.recordThreadNames = m.recordThreadNames;
	                }
	                if (m.procStatsPollMs != null && m.hasOwnProperty("procStatsPollMs")) {
	                    d.procStatsPollMs = m.procStatsPollMs;
	                }
	                if (m.procStatsCacheTtlMs != null && m.hasOwnProperty("procStatsCacheTtlMs")) {
	                    d.procStatsCacheTtlMs = m.procStatsCacheTtlMs;
	                }
	                if (m.resolveProcessFds != null && m.hasOwnProperty("resolveProcessFds")) {
	                    d.resolveProcessFds = m.resolveProcessFds;
	                }
	                return d;
	            };

	            /**
	             * Converts this ProcessStatsConfig to JSON.
	             * @function toJSON
	             * @memberof perfetto.protos.ProcessStatsConfig
	             * @instance
	             * @returns {Object.<string,*>} JSON object
	             */
	            ProcessStatsConfig.prototype.toJSON = function toJSON() {
	                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
	            };

	            /**
	             * Quirks enum.
	             * @name perfetto.protos.ProcessStatsConfig.Quirks
	             * @enum {number}
	             * @property {number} QUIRKS_UNSPECIFIED=0 QUIRKS_UNSPECIFIED value
	             * @property {number} DISABLE_INITIAL_DUMP=1 DISABLE_INITIAL_DUMP value
	             * @property {number} DISABLE_ON_DEMAND=2 DISABLE_ON_DEMAND value
	             */
	            ProcessStatsConfig.Quirks = (function() {
	                var valuesById = {}, values = Object.create(valuesById);
	                values[valuesById[0] = "QUIRKS_UNSPECIFIED"] = 0;
	                values[valuesById[1] = "DISABLE_INITIAL_DUMP"] = 1;
	                values[valuesById[2] = "DISABLE_ON_DEMAND"] = 2;
	                return values;
	            })();

	            return ProcessStatsConfig;
	        })();

	        protos.HeapprofdConfig = (function() {

	            /**
	             * Properties of a HeapprofdConfig.
	             * @memberof perfetto.protos
	             * @interface IHeapprofdConfig
	             * @property {number|null} [samplingIntervalBytes] HeapprofdConfig samplingIntervalBytes
	             * @property {number|null} [adaptiveSamplingShmemThreshold] HeapprofdConfig adaptiveSamplingShmemThreshold
	             * @property {number|null} [adaptiveSamplingMaxSamplingIntervalBytes] HeapprofdConfig adaptiveSamplingMaxSamplingIntervalBytes
	             * @property {Array.<string>|null} [processCmdline] HeapprofdConfig processCmdline
	             * @property {Array.<number>|null} [pid] HeapprofdConfig pid
	             * @property {Array.<string>|null} [targetInstalledBy] HeapprofdConfig targetInstalledBy
	             * @property {Array.<string>|null} [heaps] HeapprofdConfig heaps
	             * @property {Array.<string>|null} [excludeHeaps] HeapprofdConfig excludeHeaps
	             * @property {boolean|null} [streamAllocations] HeapprofdConfig streamAllocations
	             * @property {Array.<number>|null} [heapSamplingIntervals] HeapprofdConfig heapSamplingIntervals
	             * @property {boolean|null} [allHeaps] HeapprofdConfig allHeaps
	             * @property {boolean|null} [all] HeapprofdConfig all
	             * @property {number|null} [minAnonymousMemoryKb] HeapprofdConfig minAnonymousMemoryKb
	             * @property {number|null} [maxHeapprofdMemoryKb] HeapprofdConfig maxHeapprofdMemoryKb
	             * @property {number|null} [maxHeapprofdCpuSecs] HeapprofdConfig maxHeapprofdCpuSecs
	             * @property {Array.<string>|null} [skipSymbolPrefix] HeapprofdConfig skipSymbolPrefix
	             * @property {perfetto.protos.HeapprofdConfig.IContinuousDumpConfig|null} [continuousDumpConfig] HeapprofdConfig continuousDumpConfig
	             * @property {number|null} [shmemSizeBytes] HeapprofdConfig shmemSizeBytes
	             * @property {boolean|null} [blockClient] HeapprofdConfig blockClient
	             * @property {number|null} [blockClientTimeoutUs] HeapprofdConfig blockClientTimeoutUs
	             * @property {boolean|null} [noStartup] HeapprofdConfig noStartup
	             * @property {boolean|null} [noRunning] HeapprofdConfig noRunning
	             * @property {boolean|null} [dumpAtMax] HeapprofdConfig dumpAtMax
	             * @property {boolean|null} [disableForkTeardown] HeapprofdConfig disableForkTeardown
	             * @property {boolean|null} [disableVforkDetection] HeapprofdConfig disableVforkDetection
	             */

	            /**
	             * Constructs a new HeapprofdConfig.
	             * @memberof perfetto.protos
	             * @classdesc Represents a HeapprofdConfig.
	             * @implements IHeapprofdConfig
	             * @constructor
	             * @param {perfetto.protos.IHeapprofdConfig=} [p] Properties to set
	             */
	            function HeapprofdConfig(p) {
	                this.processCmdline = [];
	                this.pid = [];
	                this.targetInstalledBy = [];
	                this.heaps = [];
	                this.excludeHeaps = [];
	                this.heapSamplingIntervals = [];
	                this.skipSymbolPrefix = [];
	                if (p)
	                    for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
	                        if (p[ks[i]] != null)
	                            this[ks[i]] = p[ks[i]];
	            }

	            /**
	             * HeapprofdConfig samplingIntervalBytes.
	             * @member {number} samplingIntervalBytes
	             * @memberof perfetto.protos.HeapprofdConfig
	             * @instance
	             */
	            HeapprofdConfig.prototype.samplingIntervalBytes = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

	            /**
	             * HeapprofdConfig adaptiveSamplingShmemThreshold.
	             * @member {number} adaptiveSamplingShmemThreshold
	             * @memberof perfetto.protos.HeapprofdConfig
	             * @instance
	             */
	            HeapprofdConfig.prototype.adaptiveSamplingShmemThreshold = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

	            /**
	             * HeapprofdConfig adaptiveSamplingMaxSamplingIntervalBytes.
	             * @member {number} adaptiveSamplingMaxSamplingIntervalBytes
	             * @memberof perfetto.protos.HeapprofdConfig
	             * @instance
	             */
	            HeapprofdConfig.prototype.adaptiveSamplingMaxSamplingIntervalBytes = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

	            /**
	             * HeapprofdConfig processCmdline.
	             * @member {Array.<string>} processCmdline
	             * @memberof perfetto.protos.HeapprofdConfig
	             * @instance
	             */
	            HeapprofdConfig.prototype.processCmdline = $util.emptyArray;

	            /**
	             * HeapprofdConfig pid.
	             * @member {Array.<number>} pid
	             * @memberof perfetto.protos.HeapprofdConfig
	             * @instance
	             */
	            HeapprofdConfig.prototype.pid = $util.emptyArray;

	            /**
	             * HeapprofdConfig targetInstalledBy.
	             * @member {Array.<string>} targetInstalledBy
	             * @memberof perfetto.protos.HeapprofdConfig
	             * @instance
	             */
	            HeapprofdConfig.prototype.targetInstalledBy = $util.emptyArray;

	            /**
	             * HeapprofdConfig heaps.
	             * @member {Array.<string>} heaps
	             * @memberof perfetto.protos.HeapprofdConfig
	             * @instance
	             */
	            HeapprofdConfig.prototype.heaps = $util.emptyArray;

	            /**
	             * HeapprofdConfig excludeHeaps.
	             * @member {Array.<string>} excludeHeaps
	             * @memberof perfetto.protos.HeapprofdConfig
	             * @instance
	             */
	            HeapprofdConfig.prototype.excludeHeaps = $util.emptyArray;

	            /**
	             * HeapprofdConfig streamAllocations.
	             * @member {boolean} streamAllocations
	             * @memberof perfetto.protos.HeapprofdConfig
	             * @instance
	             */
	            HeapprofdConfig.prototype.streamAllocations = false;

	            /**
	             * HeapprofdConfig heapSamplingIntervals.
	             * @member {Array.<number>} heapSamplingIntervals
	             * @memberof perfetto.protos.HeapprofdConfig
	             * @instance
	             */
	            HeapprofdConfig.prototype.heapSamplingIntervals = $util.emptyArray;

	            /**
	             * HeapprofdConfig allHeaps.
	             * @member {boolean} allHeaps
	             * @memberof perfetto.protos.HeapprofdConfig
	             * @instance
	             */
	            HeapprofdConfig.prototype.allHeaps = false;

	            /**
	             * HeapprofdConfig all.
	             * @member {boolean} all
	             * @memberof perfetto.protos.HeapprofdConfig
	             * @instance
	             */
	            HeapprofdConfig.prototype.all = false;

	            /**
	             * HeapprofdConfig minAnonymousMemoryKb.
	             * @member {number} minAnonymousMemoryKb
	             * @memberof perfetto.protos.HeapprofdConfig
	             * @instance
	             */
	            HeapprofdConfig.prototype.minAnonymousMemoryKb = 0;

	            /**
	             * HeapprofdConfig maxHeapprofdMemoryKb.
	             * @member {number} maxHeapprofdMemoryKb
	             * @memberof perfetto.protos.HeapprofdConfig
	             * @instance
	             */
	            HeapprofdConfig.prototype.maxHeapprofdMemoryKb = 0;

	            /**
	             * HeapprofdConfig maxHeapprofdCpuSecs.
	             * @member {number} maxHeapprofdCpuSecs
	             * @memberof perfetto.protos.HeapprofdConfig
	             * @instance
	             */
	            HeapprofdConfig.prototype.maxHeapprofdCpuSecs = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

	            /**
	             * HeapprofdConfig skipSymbolPrefix.
	             * @member {Array.<string>} skipSymbolPrefix
	             * @memberof perfetto.protos.HeapprofdConfig
	             * @instance
	             */
	            HeapprofdConfig.prototype.skipSymbolPrefix = $util.emptyArray;

	            /**
	             * HeapprofdConfig continuousDumpConfig.
	             * @member {perfetto.protos.HeapprofdConfig.IContinuousDumpConfig|null|undefined} continuousDumpConfig
	             * @memberof perfetto.protos.HeapprofdConfig
	             * @instance
	             */
	            HeapprofdConfig.prototype.continuousDumpConfig = null;

	            /**
	             * HeapprofdConfig shmemSizeBytes.
	             * @member {number} shmemSizeBytes
	             * @memberof perfetto.protos.HeapprofdConfig
	             * @instance
	             */
	            HeapprofdConfig.prototype.shmemSizeBytes = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

	            /**
	             * HeapprofdConfig blockClient.
	             * @member {boolean} blockClient
	             * @memberof perfetto.protos.HeapprofdConfig
	             * @instance
	             */
	            HeapprofdConfig.prototype.blockClient = false;

	            /**
	             * HeapprofdConfig blockClientTimeoutUs.
	             * @member {number} blockClientTimeoutUs
	             * @memberof perfetto.protos.HeapprofdConfig
	             * @instance
	             */
	            HeapprofdConfig.prototype.blockClientTimeoutUs = 0;

	            /**
	             * HeapprofdConfig noStartup.
	             * @member {boolean} noStartup
	             * @memberof perfetto.protos.HeapprofdConfig
	             * @instance
	             */
	            HeapprofdConfig.prototype.noStartup = false;

	            /**
	             * HeapprofdConfig noRunning.
	             * @member {boolean} noRunning
	             * @memberof perfetto.protos.HeapprofdConfig
	             * @instance
	             */
	            HeapprofdConfig.prototype.noRunning = false;

	            /**
	             * HeapprofdConfig dumpAtMax.
	             * @member {boolean} dumpAtMax
	             * @memberof perfetto.protos.HeapprofdConfig
	             * @instance
	             */
	            HeapprofdConfig.prototype.dumpAtMax = false;

	            /**
	             * HeapprofdConfig disableForkTeardown.
	             * @member {boolean} disableForkTeardown
	             * @memberof perfetto.protos.HeapprofdConfig
	             * @instance
	             */
	            HeapprofdConfig.prototype.disableForkTeardown = false;

	            /**
	             * HeapprofdConfig disableVforkDetection.
	             * @member {boolean} disableVforkDetection
	             * @memberof perfetto.protos.HeapprofdConfig
	             * @instance
	             */
	            HeapprofdConfig.prototype.disableVforkDetection = false;

	            /**
	             * Creates a new HeapprofdConfig instance using the specified properties.
	             * @function create
	             * @memberof perfetto.protos.HeapprofdConfig
	             * @static
	             * @param {perfetto.protos.IHeapprofdConfig=} [properties] Properties to set
	             * @returns {perfetto.protos.HeapprofdConfig} HeapprofdConfig instance
	             */
	            HeapprofdConfig.create = function create(properties) {
	                return new HeapprofdConfig(properties);
	            };

	            /**
	             * Encodes the specified HeapprofdConfig message. Does not implicitly {@link perfetto.protos.HeapprofdConfig.verify|verify} messages.
	             * @function encode
	             * @memberof perfetto.protos.HeapprofdConfig
	             * @static
	             * @param {perfetto.protos.IHeapprofdConfig} m HeapprofdConfig message or plain object to encode
	             * @param {$protobuf.Writer} [w] Writer to encode to
	             * @returns {$protobuf.Writer} Writer
	             */
	            HeapprofdConfig.encode = function encode(m, w) {
	                if (!w)
	                    w = $Writer.create();
	                if (m.samplingIntervalBytes != null && Object.hasOwnProperty.call(m, "samplingIntervalBytes"))
	                    w.uint32(8).uint64(m.samplingIntervalBytes);
	                if (m.processCmdline != null && m.processCmdline.length) {
	                    for (var i = 0; i < m.processCmdline.length; ++i)
	                        w.uint32(18).string(m.processCmdline[i]);
	                }
	                if (m.pid != null && m.pid.length) {
	                    for (var i = 0; i < m.pid.length; ++i)
	                        w.uint32(32).uint64(m.pid[i]);
	                }
	                if (m.all != null && Object.hasOwnProperty.call(m, "all"))
	                    w.uint32(40).bool(m.all);
	                if (m.continuousDumpConfig != null && Object.hasOwnProperty.call(m, "continuousDumpConfig"))
	                    $root.perfetto.protos.HeapprofdConfig.ContinuousDumpConfig.encode(m.continuousDumpConfig, w.uint32(50).fork()).ldelim();
	                if (m.skipSymbolPrefix != null && m.skipSymbolPrefix.length) {
	                    for (var i = 0; i < m.skipSymbolPrefix.length; ++i)
	                        w.uint32(58).string(m.skipSymbolPrefix[i]);
	                }
	                if (m.shmemSizeBytes != null && Object.hasOwnProperty.call(m, "shmemSizeBytes"))
	                    w.uint32(64).uint64(m.shmemSizeBytes);
	                if (m.blockClient != null && Object.hasOwnProperty.call(m, "blockClient"))
	                    w.uint32(72).bool(m.blockClient);
	                if (m.noStartup != null && Object.hasOwnProperty.call(m, "noStartup"))
	                    w.uint32(80).bool(m.noStartup);
	                if (m.noRunning != null && Object.hasOwnProperty.call(m, "noRunning"))
	                    w.uint32(88).bool(m.noRunning);
	                if (m.dumpAtMax != null && Object.hasOwnProperty.call(m, "dumpAtMax"))
	                    w.uint32(104).bool(m.dumpAtMax);
	                if (m.blockClientTimeoutUs != null && Object.hasOwnProperty.call(m, "blockClientTimeoutUs"))
	                    w.uint32(112).uint32(m.blockClientTimeoutUs);
	                if (m.minAnonymousMemoryKb != null && Object.hasOwnProperty.call(m, "minAnonymousMemoryKb"))
	                    w.uint32(120).uint32(m.minAnonymousMemoryKb);
	                if (m.maxHeapprofdMemoryKb != null && Object.hasOwnProperty.call(m, "maxHeapprofdMemoryKb"))
	                    w.uint32(128).uint32(m.maxHeapprofdMemoryKb);
	                if (m.maxHeapprofdCpuSecs != null && Object.hasOwnProperty.call(m, "maxHeapprofdCpuSecs"))
	                    w.uint32(136).uint64(m.maxHeapprofdCpuSecs);
	                if (m.disableForkTeardown != null && Object.hasOwnProperty.call(m, "disableForkTeardown"))
	                    w.uint32(144).bool(m.disableForkTeardown);
	                if (m.disableVforkDetection != null && Object.hasOwnProperty.call(m, "disableVforkDetection"))
	                    w.uint32(152).bool(m.disableVforkDetection);
	                if (m.heaps != null && m.heaps.length) {
	                    for (var i = 0; i < m.heaps.length; ++i)
	                        w.uint32(162).string(m.heaps[i]);
	                }
	                if (m.allHeaps != null && Object.hasOwnProperty.call(m, "allHeaps"))
	                    w.uint32(168).bool(m.allHeaps);
	                if (m.heapSamplingIntervals != null && m.heapSamplingIntervals.length) {
	                    for (var i = 0; i < m.heapSamplingIntervals.length; ++i)
	                        w.uint32(176).uint64(m.heapSamplingIntervals[i]);
	                }
	                if (m.streamAllocations != null && Object.hasOwnProperty.call(m, "streamAllocations"))
	                    w.uint32(184).bool(m.streamAllocations);
	                if (m.adaptiveSamplingShmemThreshold != null && Object.hasOwnProperty.call(m, "adaptiveSamplingShmemThreshold"))
	                    w.uint32(192).uint64(m.adaptiveSamplingShmemThreshold);
	                if (m.adaptiveSamplingMaxSamplingIntervalBytes != null && Object.hasOwnProperty.call(m, "adaptiveSamplingMaxSamplingIntervalBytes"))
	                    w.uint32(200).uint64(m.adaptiveSamplingMaxSamplingIntervalBytes);
	                if (m.targetInstalledBy != null && m.targetInstalledBy.length) {
	                    for (var i = 0; i < m.targetInstalledBy.length; ++i)
	                        w.uint32(210).string(m.targetInstalledBy[i]);
	                }
	                if (m.excludeHeaps != null && m.excludeHeaps.length) {
	                    for (var i = 0; i < m.excludeHeaps.length; ++i)
	                        w.uint32(218).string(m.excludeHeaps[i]);
	                }
	                return w;
	            };

	            /**
	             * Decodes a HeapprofdConfig message from the specified reader or buffer.
	             * @function decode
	             * @memberof perfetto.protos.HeapprofdConfig
	             * @static
	             * @param {$protobuf.Reader|Uint8Array} r Reader or buffer to decode from
	             * @param {number} [l] Message length if known beforehand
	             * @returns {perfetto.protos.HeapprofdConfig} HeapprofdConfig
	             * @throws {Error} If the payload is not a reader or valid buffer
	             * @throws {$protobuf.util.ProtocolError} If required fields are missing
	             */
	            HeapprofdConfig.decode = function decode(r, l) {
	                if (!(r instanceof $Reader))
	                    r = $Reader.create(r);
	                var c = l === undefined ? r.len : r.pos + l, m = new $root.perfetto.protos.HeapprofdConfig();
	                while (r.pos < c) {
	                    var t = r.uint32();
	                    switch (t >>> 3) {
	                    case 1:
	                        m.samplingIntervalBytes = r.uint64();
	                        break;
	                    case 24:
	                        m.adaptiveSamplingShmemThreshold = r.uint64();
	                        break;
	                    case 25:
	                        m.adaptiveSamplingMaxSamplingIntervalBytes = r.uint64();
	                        break;
	                    case 2:
	                        if (!(m.processCmdline && m.processCmdline.length))
	                            m.processCmdline = [];
	                        m.processCmdline.push(r.string());
	                        break;
	                    case 4:
	                        if (!(m.pid && m.pid.length))
	                            m.pid = [];
	                        if ((t & 7) === 2) {
	                            var c2 = r.uint32() + r.pos;
	                            while (r.pos < c2)
	                                m.pid.push(r.uint64());
	                        } else
	                            m.pid.push(r.uint64());
	                        break;
	                    case 26:
	                        if (!(m.targetInstalledBy && m.targetInstalledBy.length))
	                            m.targetInstalledBy = [];
	                        m.targetInstalledBy.push(r.string());
	                        break;
	                    case 20:
	                        if (!(m.heaps && m.heaps.length))
	                            m.heaps = [];
	                        m.heaps.push(r.string());
	                        break;
	                    case 27:
	                        if (!(m.excludeHeaps && m.excludeHeaps.length))
	                            m.excludeHeaps = [];
	                        m.excludeHeaps.push(r.string());
	                        break;
	                    case 23:
	                        m.streamAllocations = r.bool();
	                        break;
	                    case 22:
	                        if (!(m.heapSamplingIntervals && m.heapSamplingIntervals.length))
	                            m.heapSamplingIntervals = [];
	                        if ((t & 7) === 2) {
	                            var c2 = r.uint32() + r.pos;
	                            while (r.pos < c2)
	                                m.heapSamplingIntervals.push(r.uint64());
	                        } else
	                            m.heapSamplingIntervals.push(r.uint64());
	                        break;
	                    case 21:
	                        m.allHeaps = r.bool();
	                        break;
	                    case 5:
	                        m.all = r.bool();
	                        break;
	                    case 15:
	                        m.minAnonymousMemoryKb = r.uint32();
	                        break;
	                    case 16:
	                        m.maxHeapprofdMemoryKb = r.uint32();
	                        break;
	                    case 17:
	                        m.maxHeapprofdCpuSecs = r.uint64();
	                        break;
	                    case 7:
	                        if (!(m.skipSymbolPrefix && m.skipSymbolPrefix.length))
	                            m.skipSymbolPrefix = [];
	                        m.skipSymbolPrefix.push(r.string());
	                        break;
	                    case 6:
	                        m.continuousDumpConfig = $root.perfetto.protos.HeapprofdConfig.ContinuousDumpConfig.decode(r, r.uint32());
	                        break;
	                    case 8:
	                        m.shmemSizeBytes = r.uint64();
	                        break;
	                    case 9:
	                        m.blockClient = r.bool();
	                        break;
	                    case 14:
	                        m.blockClientTimeoutUs = r.uint32();
	                        break;
	                    case 10:
	                        m.noStartup = r.bool();
	                        break;
	                    case 11:
	                        m.noRunning = r.bool();
	                        break;
	                    case 13:
	                        m.dumpAtMax = r.bool();
	                        break;
	                    case 18:
	                        m.disableForkTeardown = r.bool();
	                        break;
	                    case 19:
	                        m.disableVforkDetection = r.bool();
	                        break;
	                    default:
	                        r.skipType(t & 7);
	                        break;
	                    }
	                }
	                return m;
	            };

	            /**
	             * Creates a HeapprofdConfig message from a plain object. Also converts values to their respective internal types.
	             * @function fromObject
	             * @memberof perfetto.protos.HeapprofdConfig
	             * @static
	             * @param {Object.<string,*>} d Plain object
	             * @returns {perfetto.protos.HeapprofdConfig} HeapprofdConfig
	             */
	            HeapprofdConfig.fromObject = function fromObject(d) {
	                if (d instanceof $root.perfetto.protos.HeapprofdConfig)
	                    return d;
	                var m = new $root.perfetto.protos.HeapprofdConfig();
	                if (d.samplingIntervalBytes != null) {
	                    if ($util.Long)
	                        (m.samplingIntervalBytes = $util.Long.fromValue(d.samplingIntervalBytes)).unsigned = true;
	                    else if (typeof d.samplingIntervalBytes === "string")
	                        m.samplingIntervalBytes = parseInt(d.samplingIntervalBytes, 10);
	                    else if (typeof d.samplingIntervalBytes === "number")
	                        m.samplingIntervalBytes = d.samplingIntervalBytes;
	                    else if (typeof d.samplingIntervalBytes === "object")
	                        m.samplingIntervalBytes = new $util.LongBits(d.samplingIntervalBytes.low >>> 0, d.samplingIntervalBytes.high >>> 0).toNumber(true);
	                }
	                if (d.adaptiveSamplingShmemThreshold != null) {
	                    if ($util.Long)
	                        (m.adaptiveSamplingShmemThreshold = $util.Long.fromValue(d.adaptiveSamplingShmemThreshold)).unsigned = true;
	                    else if (typeof d.adaptiveSamplingShmemThreshold === "string")
	                        m.adaptiveSamplingShmemThreshold = parseInt(d.adaptiveSamplingShmemThreshold, 10);
	                    else if (typeof d.adaptiveSamplingShmemThreshold === "number")
	                        m.adaptiveSamplingShmemThreshold = d.adaptiveSamplingShmemThreshold;
	                    else if (typeof d.adaptiveSamplingShmemThreshold === "object")
	                        m.adaptiveSamplingShmemThreshold = new $util.LongBits(d.adaptiveSamplingShmemThreshold.low >>> 0, d.adaptiveSamplingShmemThreshold.high >>> 0).toNumber(true);
	                }
	                if (d.adaptiveSamplingMaxSamplingIntervalBytes != null) {
	                    if ($util.Long)
	                        (m.adaptiveSamplingMaxSamplingIntervalBytes = $util.Long.fromValue(d.adaptiveSamplingMaxSamplingIntervalBytes)).unsigned = true;
	                    else if (typeof d.adaptiveSamplingMaxSamplingIntervalBytes === "string")
	                        m.adaptiveSamplingMaxSamplingIntervalBytes = parseInt(d.adaptiveSamplingMaxSamplingIntervalBytes, 10);
	                    else if (typeof d.adaptiveSamplingMaxSamplingIntervalBytes === "number")
	                        m.adaptiveSamplingMaxSamplingIntervalBytes = d.adaptiveSamplingMaxSamplingIntervalBytes;
	                    else if (typeof d.adaptiveSamplingMaxSamplingIntervalBytes === "object")
	                        m.adaptiveSamplingMaxSamplingIntervalBytes = new $util.LongBits(d.adaptiveSamplingMaxSamplingIntervalBytes.low >>> 0, d.adaptiveSamplingMaxSamplingIntervalBytes.high >>> 0).toNumber(true);
	                }
	                if (d.processCmdline) {
	                    if (!Array.isArray(d.processCmdline))
	                        throw TypeError(".perfetto.protos.HeapprofdConfig.processCmdline: array expected");
	                    m.processCmdline = [];
	                    for (var i = 0; i < d.processCmdline.length; ++i) {
	                        m.processCmdline[i] = String(d.processCmdline[i]);
	                    }
	                }
	                if (d.pid) {
	                    if (!Array.isArray(d.pid))
	                        throw TypeError(".perfetto.protos.HeapprofdConfig.pid: array expected");
	                    m.pid = [];
	                    for (var i = 0; i < d.pid.length; ++i) {
	                        if ($util.Long)
	                            (m.pid[i] = $util.Long.fromValue(d.pid[i])).unsigned = true;
	                        else if (typeof d.pid[i] === "string")
	                            m.pid[i] = parseInt(d.pid[i], 10);
	                        else if (typeof d.pid[i] === "number")
	                            m.pid[i] = d.pid[i];
	                        else if (typeof d.pid[i] === "object")
	                            m.pid[i] = new $util.LongBits(d.pid[i].low >>> 0, d.pid[i].high >>> 0).toNumber(true);
	                    }
	                }
	                if (d.targetInstalledBy) {
	                    if (!Array.isArray(d.targetInstalledBy))
	                        throw TypeError(".perfetto.protos.HeapprofdConfig.targetInstalledBy: array expected");
	                    m.targetInstalledBy = [];
	                    for (var i = 0; i < d.targetInstalledBy.length; ++i) {
	                        m.targetInstalledBy[i] = String(d.targetInstalledBy[i]);
	                    }
	                }
	                if (d.heaps) {
	                    if (!Array.isArray(d.heaps))
	                        throw TypeError(".perfetto.protos.HeapprofdConfig.heaps: array expected");
	                    m.heaps = [];
	                    for (var i = 0; i < d.heaps.length; ++i) {
	                        m.heaps[i] = String(d.heaps[i]);
	                    }
	                }
	                if (d.excludeHeaps) {
	                    if (!Array.isArray(d.excludeHeaps))
	                        throw TypeError(".perfetto.protos.HeapprofdConfig.excludeHeaps: array expected");
	                    m.excludeHeaps = [];
	                    for (var i = 0; i < d.excludeHeaps.length; ++i) {
	                        m.excludeHeaps[i] = String(d.excludeHeaps[i]);
	                    }
	                }
	                if (d.streamAllocations != null) {
	                    m.streamAllocations = Boolean(d.streamAllocations);
	                }
	                if (d.heapSamplingIntervals) {
	                    if (!Array.isArray(d.heapSamplingIntervals))
	                        throw TypeError(".perfetto.protos.HeapprofdConfig.heapSamplingIntervals: array expected");
	                    m.heapSamplingIntervals = [];
	                    for (var i = 0; i < d.heapSamplingIntervals.length; ++i) {
	                        if ($util.Long)
	                            (m.heapSamplingIntervals[i] = $util.Long.fromValue(d.heapSamplingIntervals[i])).unsigned = true;
	                        else if (typeof d.heapSamplingIntervals[i] === "string")
	                            m.heapSamplingIntervals[i] = parseInt(d.heapSamplingIntervals[i], 10);
	                        else if (typeof d.heapSamplingIntervals[i] === "number")
	                            m.heapSamplingIntervals[i] = d.heapSamplingIntervals[i];
	                        else if (typeof d.heapSamplingIntervals[i] === "object")
	                            m.heapSamplingIntervals[i] = new $util.LongBits(d.heapSamplingIntervals[i].low >>> 0, d.heapSamplingIntervals[i].high >>> 0).toNumber(true);
	                    }
	                }
	                if (d.allHeaps != null) {
	                    m.allHeaps = Boolean(d.allHeaps);
	                }
	                if (d.all != null) {
	                    m.all = Boolean(d.all);
	                }
	                if (d.minAnonymousMemoryKb != null) {
	                    m.minAnonymousMemoryKb = d.minAnonymousMemoryKb >>> 0;
	                }
	                if (d.maxHeapprofdMemoryKb != null) {
	                    m.maxHeapprofdMemoryKb = d.maxHeapprofdMemoryKb >>> 0;
	                }
	                if (d.maxHeapprofdCpuSecs != null) {
	                    if ($util.Long)
	                        (m.maxHeapprofdCpuSecs = $util.Long.fromValue(d.maxHeapprofdCpuSecs)).unsigned = true;
	                    else if (typeof d.maxHeapprofdCpuSecs === "string")
	                        m.maxHeapprofdCpuSecs = parseInt(d.maxHeapprofdCpuSecs, 10);
	                    else if (typeof d.maxHeapprofdCpuSecs === "number")
	                        m.maxHeapprofdCpuSecs = d.maxHeapprofdCpuSecs;
	                    else if (typeof d.maxHeapprofdCpuSecs === "object")
	                        m.maxHeapprofdCpuSecs = new $util.LongBits(d.maxHeapprofdCpuSecs.low >>> 0, d.maxHeapprofdCpuSecs.high >>> 0).toNumber(true);
	                }
	                if (d.skipSymbolPrefix) {
	                    if (!Array.isArray(d.skipSymbolPrefix))
	                        throw TypeError(".perfetto.protos.HeapprofdConfig.skipSymbolPrefix: array expected");
	                    m.skipSymbolPrefix = [];
	                    for (var i = 0; i < d.skipSymbolPrefix.length; ++i) {
	                        m.skipSymbolPrefix[i] = String(d.skipSymbolPrefix[i]);
	                    }
	                }
	                if (d.continuousDumpConfig != null) {
	                    if (typeof d.continuousDumpConfig !== "object")
	                        throw TypeError(".perfetto.protos.HeapprofdConfig.continuousDumpConfig: object expected");
	                    m.continuousDumpConfig = $root.perfetto.protos.HeapprofdConfig.ContinuousDumpConfig.fromObject(d.continuousDumpConfig);
	                }
	                if (d.shmemSizeBytes != null) {
	                    if ($util.Long)
	                        (m.shmemSizeBytes = $util.Long.fromValue(d.shmemSizeBytes)).unsigned = true;
	                    else if (typeof d.shmemSizeBytes === "string")
	                        m.shmemSizeBytes = parseInt(d.shmemSizeBytes, 10);
	                    else if (typeof d.shmemSizeBytes === "number")
	                        m.shmemSizeBytes = d.shmemSizeBytes;
	                    else if (typeof d.shmemSizeBytes === "object")
	                        m.shmemSizeBytes = new $util.LongBits(d.shmemSizeBytes.low >>> 0, d.shmemSizeBytes.high >>> 0).toNumber(true);
	                }
	                if (d.blockClient != null) {
	                    m.blockClient = Boolean(d.blockClient);
	                }
	                if (d.blockClientTimeoutUs != null) {
	                    m.blockClientTimeoutUs = d.blockClientTimeoutUs >>> 0;
	                }
	                if (d.noStartup != null) {
	                    m.noStartup = Boolean(d.noStartup);
	                }
	                if (d.noRunning != null) {
	                    m.noRunning = Boolean(d.noRunning);
	                }
	                if (d.dumpAtMax != null) {
	                    m.dumpAtMax = Boolean(d.dumpAtMax);
	                }
	                if (d.disableForkTeardown != null) {
	                    m.disableForkTeardown = Boolean(d.disableForkTeardown);
	                }
	                if (d.disableVforkDetection != null) {
	                    m.disableVforkDetection = Boolean(d.disableVforkDetection);
	                }
	                return m;
	            };

	            /**
	             * Creates a plain object from a HeapprofdConfig message. Also converts values to other types if specified.
	             * @function toObject
	             * @memberof perfetto.protos.HeapprofdConfig
	             * @static
	             * @param {perfetto.protos.HeapprofdConfig} m HeapprofdConfig
	             * @param {$protobuf.IConversionOptions} [o] Conversion options
	             * @returns {Object.<string,*>} Plain object
	             */
	            HeapprofdConfig.toObject = function toObject(m, o) {
	                if (!o)
	                    o = {};
	                var d = {};
	                if (o.arrays || o.defaults) {
	                    d.processCmdline = [];
	                    d.pid = [];
	                    d.skipSymbolPrefix = [];
	                    d.heaps = [];
	                    d.heapSamplingIntervals = [];
	                    d.targetInstalledBy = [];
	                    d.excludeHeaps = [];
	                }
	                if (o.defaults) {
	                    if ($util.Long) {
	                        var n = new $util.Long(0, 0, true);
	                        d.samplingIntervalBytes = o.longs === String ? n.toString() : o.longs === Number ? n.toNumber() : n;
	                    } else
	                        d.samplingIntervalBytes = o.longs === String ? "0" : 0;
	                    d.all = false;
	                    d.continuousDumpConfig = null;
	                    if ($util.Long) {
	                        var n = new $util.Long(0, 0, true);
	                        d.shmemSizeBytes = o.longs === String ? n.toString() : o.longs === Number ? n.toNumber() : n;
	                    } else
	                        d.shmemSizeBytes = o.longs === String ? "0" : 0;
	                    d.blockClient = false;
	                    d.noStartup = false;
	                    d.noRunning = false;
	                    d.dumpAtMax = false;
	                    d.blockClientTimeoutUs = 0;
	                    d.minAnonymousMemoryKb = 0;
	                    d.maxHeapprofdMemoryKb = 0;
	                    if ($util.Long) {
	                        var n = new $util.Long(0, 0, true);
	                        d.maxHeapprofdCpuSecs = o.longs === String ? n.toString() : o.longs === Number ? n.toNumber() : n;
	                    } else
	                        d.maxHeapprofdCpuSecs = o.longs === String ? "0" : 0;
	                    d.disableForkTeardown = false;
	                    d.disableVforkDetection = false;
	                    d.allHeaps = false;
	                    d.streamAllocations = false;
	                    if ($util.Long) {
	                        var n = new $util.Long(0, 0, true);
	                        d.adaptiveSamplingShmemThreshold = o.longs === String ? n.toString() : o.longs === Number ? n.toNumber() : n;
	                    } else
	                        d.adaptiveSamplingShmemThreshold = o.longs === String ? "0" : 0;
	                    if ($util.Long) {
	                        var n = new $util.Long(0, 0, true);
	                        d.adaptiveSamplingMaxSamplingIntervalBytes = o.longs === String ? n.toString() : o.longs === Num