.\" dpkg manual page - update-alternatives(1)
.\"
.\" Copyright © 1997-1998 Charles Briscoe-Smith
.\" Copyright © 1999 Ben Collins <bcollins@debian.org>
.\" Copyright © 2000 Wichert Akkerman <wakkerma@debian.org>
.\" Copyright © 2003 Adam Heath <doogie@debian.org>
.\" Copyright © 2005 Scott James Remnant <scott@netsplit.com>
.\" Copyright © 2006-2015 Guillem Jover <guillem@debian.org>
.\" Copyright © 2008 Pierre Habouzit <madcoder@debian.org>
.\" Copyright © 2009-2011 Raphaël Hertzog <hertzog@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH update\-alternatives 1 %RELEASE_DATE% %VERSION% "suite dpkg"
.nh
.SH NOM
update\-alternatives \- maintenance des liens symboliques déterminant les noms
par défaut de certaines commandes
.
.SH SYNOPSIS
\fBupdate\-alternatives\fP [\fIoption\fP...] \fIcommande\fP
.
.SH DESCRIPTION
\fBupdate\-alternatives\fP crée, enlève, conserve et affiche des informations
concernant les liens symboliques qui forment le système Debian des
«\ alternatives\ ».
.PP
Il est possible d'installer, sur un même système et en même temps, des
programmes qui remplissent des fonctions identiques ou semblables. Par
exemple, beaucoup de systèmes installent plusieurs éditeurs de texte en même
temps. Cela permet à chaque utilisateur d'un système de choisir, s'il le
désire, un éditeur de texte différent\ ; mais cela rend les choses difficiles
pour le programme qui doit choisir un bon éditeur de texte quand
l'utilisateur n'a pas fait de choix précis.
.PP
Le système Debian des «\ alternatives\ » essaie de résoudre ce problème. Tous
les fichiers qui proposent des fonctions interchangeables se servent d'un
nom générique qui se trouve dans l'arborescence. Le système des
«\ alternatives\ » et l'administrateur système font connaître ensemble le
fichier qui est réellement visé par ce nom générique. Par exemple, si les
éditeurs de texte \fBed\fP(1) et \fBnvi\fP(1) sont tous les deux installés, le
système des «\ alternatives\ » fait que le nom générique \fI/usr/bin/editor\fP
renvoie par défaut à \fI/usr/bin/nvi\fP. L'administrateur système peut
remplacer cette assignation par \fI/usr/bin/ed\fP et le système des
«\ alternatives\ » ne la changera pas tant qu'on ne lui aura pas demandé
explicitement de le faire.
.PP
Le nom générique n'est pas un lien symbolique direct vers l'alternative
choisie. C'est en fait un lien symbolique vers un nom situé dans le
\fIrépertoire\fP \fIdes «\ alternatives\ »\fP, lequel nom est à son tour un lien
symbolique vers le fichier réellement visé. Les modifications faites par
l'administrateur système sont ainsi confinées dans le répertoire
\fI%CONFDIR%\fP\ ; le FHS (lisez\-le) donne de Bonnes Raisons de faire ainsi.
.PP
Chaque fois qu'un paquet, proposant un fichier pour une fonction déterminée,
est installé, modifié ou désinstallé, \fBupdate\-alternatives\fP est appelé pour
mettre à jour les informations concernant ce fichier dans le système des
«\ alternatives\ ». En général, \fBupdate\-alternatives\fP est appelé dans les
scripts \fBpostinst\fP (configure) et \fBprerm\fP (remove and deconfigure) des
paquets Debian.
.PP
Il est souvent utile de synchroniser certaines alternatives, de manière à
pouvoir les manipuler globalement\ ; par exemple, quand plusieurs versions de
\fBvi\fP(1) sont installées, la page de manuel qui est visée par
\fI/usr/share/man/man1/vi.1\fP devrait correspondre à
\fI/usr/bin/vi\fP. \fBupdate\-alternatives\fP gère ce problème avec les liens
\fIprincipaux («\ master\ »)\fP et les liens \fIsecondaires («\ slave\ »)\fP. Quand le
lien principal est changé, tous les liens secondaires associés sont
changés. Un lien principal et ses liens secondaires associés composent un
\fIgroupe\fP de \fIliens.\fP
.PP
À tout moment, un groupe de liens est dans l'un des deux modes suivants\ :
automatique ou manuel. Quand un groupe est dans le mode automatique et que
des paquets sont installés ou désinstallés, le système des «\ alternatives\ »
décide automatiquement s'il doit mettre à jour les liens et comment le
faire. Dans le mode manuel, le système des «\ alternatives\ » ne change pas
les liens et laisse l'administrateur système prendre toutes les décisions
(sauf si quelque chose est cassé).
.PP
Un groupe de liens est en mode automatique quand il est créé sur un système
pour la première fois. Quand l'administrateur système modifie le paramétrage
automatique du système, \fBupdate\-alternatives\fP le remarquera la prochaine
fois qu'il sera lancé pour ce groupe aux liens modifiés et il fera passer ce
groupe en mode manuel.
.PP
À chaque alternative est associée une \fIpriorité\fP. Quand un groupe de liens
est en mode automatique, l'alternative visée par les éléments du groupe est
celle qui possède la priorité la plus élevée.
.PP
When using the \fB\-\-config\fP option, \fBupdate\-alternatives\fP will list all of
the choices for the link group of which given \fIname\fP is the master
alternative name.  The current choice is marked with a ‘*’.  You will then
be prompted for your choice regarding this link group.  Depending on the
choice made, the link group might no longer be in \fIauto\fP mode. You will
need to use the \fB\-\-auto\fP option in order to return to the automatic mode
(or you can rerun \fB\-\-config\fP and select the entry marked as automatic).
.PP
Si vous voulez configurer de manière non interactive, vous pouvez utiliser
l'option \fB\-\-set\fP (voyez ci\-dessous).
.PP
Les différents paquets qui fournissent un même fichier doivent le faire en
\fBcollaborant\fP. En d'autres termes, l'utilisation de \fBupdate\-alternatives\fP
est \fBobligatoire\fP pour tous les paquets qui sont dans ce cas et il n'est
pas possible de remplacer un fichier d'un paquet qui n'utilise pas le
mécanisme offert par \fBupdate\-alternatives\fP.
.
.SH TERMINOLOGIE
Comme les opérations de \fBupdate\-alternatives\fP sont très compliquées, voici
quelques termes qui faciliteront l'explication.
.TP 
nom générique (ou lien alternatif)
C'est un nom, par exemple \fI/usr/bin/editor\fP, qui renvoie, à travers le
système des «\ alternatives\ », à l'un des fichiers qui remplissent des
fonctions similaires.
.TP 
nom alternatif
Nom d'un lien symbolique dans le répertoire des alternatives.
.TP 
alternative (ou chemin alternatif)
C'est le nom d'un fichier particulier dans l'arborescence\ ; il peut être
accessible avec un nom générique grâce au système d'alternatives.
.TP 
répertoire des alternatives 
C'est le répertoire qui contient les liens symboliques\ ; il s'agit par
défaut de \fI%CONFDIR%/alternatives.\fP
.TP 
répertoire administratif
C'est le répertoire qui contient des renseignements sur l'état de
\fBupdate\-alternatives.\fP Il s'agit par défaut de \fI%ADMINDIR%/alternatives.\fP
.TP 
groupe de liens
C'est un ensemble de liens symboliques corrélés, de manière qu'on puisse les
mettre à jour en une seule fois.
.TP 
lien principal
Dans un groupe de liens, c'est le lien alternatif qui détermine comment sont
configurés les autres liens du groupe.
.TP 
lien secondaire («\ slave\ »)
Dans un groupe de liens, c'est un lien alternatif contrôlé par la
configuration du lien principal.
.TP 
mode automatique
Quand un groupe de liens est en mode automatique, le système des
«\ alternatives\ » assure que les liens dans le groupe pointent vers
l'alternative possédant la priorité la plus élevée dans ce groupe.
.TP 
mode manuel 
Quand un groupe de liens est en mode manuel, le système des «\ alternatives\ »
ne modifie pas le paramétrage de l'administrateur système.
.
.SH COMMANDES
.TP 
\fB\-\-install\fP \fIlien nom chemin priorité\fP [\fB\-\-slave\fP \fIlien nom chemin\fP]...
Ajoute un groupe d'alternatives au système. \fIlien\fP est le nom générique du
lien principal, \fInom\fP est le nom de son lien symbolique, et \fIchemin\fP est
l'alternative présentée pour le lien principal. Les paramètres qui suivent
\fB\-\-slave\fP sont le nom générique, le lien symbolique dans le répertoire des
alternatives et l'alternative pour un lien secondaire. On peut indiquer zéro
ou plusieurs options \fB\-\-slave\fP, chacune suivie par trois
paramètres. L'alternative principale doit exister, sinon la commande
échouera. Cependant, si une alternative secondaire n'existe pas, le lien
secondaire ne sera simplement pas installé (mais un avertissement sera
affiché). Si un fichier existe à l'emplacement où l'alternative doit être
installée, il est conservé sauf si \fB\-\-force\fP est utilisé.
.IP
Quand le lien principal spécifié existe déjà dans les enregistrements du
système des «\ alternatives\ », les renseignements fournis sont ajoutés dans
un nouvel ensemble d'alternatives pour le groupe. Sinon, un nouveau groupe
contenant ces informations est ajouté et mis en mode automatique. Quand un
groupe est en mode automatique, et que la priorité des alternatives
nouvellement ajoutées est supérieure à celle de toutes les alternatives
installées dans ce groupe, les liens symboliques sont mis à jour et pointent
vers les alternatives nouvellement ajoutées.
.TP 
\fB\-\-set\fP \fInom chemin\fP
Ajoute le programme \fIchemin\fP comme alternative pour \fInom\fP. C'est
équivalent à \fB\-\-config\fP mais ce n'est pas interactif et on peut donc écrire
un script.
.TP 
\fB\-\-remove\fP \fInom chemin\fP
Enlève une alternative et tous les liens secondaires associés. \fInom\fP est un
nom dans le répertoire des «\ alternatives\ », et \fIchemin\fP est un nom de
fichier auquel \fInom\fP peut être lié. Quand \fInom\fP est en effet lié à
\fIchemin\fP, \fInom\fP est mis à jour et pointe vers une autre alternative
adéquate ou bien est enlevé s'il n'y en a pas d'autre. De même, les liens
secondaires associés sont mis à jour ou enlevés. Quand le lien ne pointe pas
déjà sur \fIchemin\fP, aucun lien n'est modifié\ ; seules les informations sur
l'alternative sont supprimées.
.TP 
\fB\-\-remove\-all\fP \fInom\fP
Supprime toutes les alternatives et tous les liens secondaires
associés. \fInom\fP est un nom dans le répertoire des alternatives.
.TP 
\fB\-\-all\fP
Utilise \fB\-\-config\fP sur toutes les alternatives. Cette option peut être
combinée avec \fB\-\-skip\-auto\fP pour revoir et configurer toutes les
alternatives qui ne sont pas en mode automatique. Les alternatives erronées
sont aussi affichées. Ainsi, une méthode simple pour corriger les
alternatives cassées est d'utiliser \fByes \*(rq | update\-alternatives \-\-force
\-\-all\fP.
.TP 
\fB\-\-auto\fP \fInom\fP
Passe le groupe de liens suivant l'alternative de \fInom\fP en mode
automatique. En même temps, le lien symbolique principal et ses liens
secondaires sont mis à jour et pointent vers les alternatives avec les
priorités les plus élevées.
.TP 
\fB\-\-display\fP \fInom\fP
Display information about the link group.  Information displayed includes
the group's mode (auto or manual), the master and slave links, which
alternative the master link currently points to, what other alternatives are
available (and their corresponding slave alternatives), and the highest
priority alternative currently installed.
.TP 
\fB\-\-get\-selections\fP
List all master alternative names (those controlling a link group)  and
their status (since version 1.15.0).  Each line contains up to 3 fields
(separated by one or more spaces). The first field is the alternative name,
the second one is the status (either \fBauto\fP or \fBmanual\fP), and the last one
contains the current choice in the alternative (beware: it's a filename and
thus might contain spaces).
.TP 
\fB\-\-set\-selections\fP
Read configuration of alternatives on standard input in the format generated
by \fB\-\-get\-selections\fP and reconfigure them accordingly (since version
1.15.0).
.TP 
\fB\-\-query\fP \fInom\fP
Display information about the link group like \fB\-\-display\fP does, but in a
machine parseable way (since version 1.15.0, see section \fBQUERY FORMAT\fP
below).
.TP 
\fB\-\-list\fP \fInom\fP
Affiche toutes les cibles du groupe de liens.
.TP 
\fB\-\-config\fP \fInom\fP
Affiche les alternatives disponibles pour un groupe de liens et permet de
choisir interactivement laquelle doit être utilisée. Le groupe de liens est
mis à jour.
.TP 
\fB\-\-help\fP
Affiche un message d'aide puis quitte.
.TP 
\fB\-\-version\fP
Affiche le numéro de version puis quitte.
.
.SH OPTIONS
.TP 
\fB\-\-altdir\fP\fI répertoire\fP
Donne le répertoire des alternatives, quand il est différent de celui par
défaut.
.TP 
\fB\-\-admindir\fP\fI répertoire\fP
Donne le répertoire administratif, quand il est différent de celui par
défaut.
.TP 
\fB\-\-log\fP\fI fichier\fP
Specifies the log file (since version 1.15.0), when this is to be different
from the default (%LOGDIR%/alternatives.log).
.TP 
\fB\-\-force\fP
Allow replacing or dropping any real file that is installed where an
alternative link has to be installed or removed.
.TP 
\fB\-\-skip\-auto\fP
Passe l'invite de configuration pour les alternatives qui sont correctement
configurées en mode automatique. Cette option n'est pertinente qu'avec
\fB\-\-config\fP ou \fB\-\-all\fP.
.TP 
\fB\-\-quiet\fP
Do not generate any comments unless errors occur.
.TP 
\fB\-\-verbose\fP
Generate more comments about what is being done.
.TP 
\fB\-\-debug\fP
Generate even more comments, helpful for debugging, about what is being done
(since version 1.19.3).
.
.SH "CODE DE SORTIE"
.TP 
\fB0\fP
L'action demandée s'est correctement déroulée.
.TP 
\fB2\fP
Des problèmes sont survenus lors de l'analyse de la ligne de commande ou
bien pendant l'exécution de l'action.
.
.SH ENVIRONNEMENT
.TP 
\fBDPKG_ADMINDIR\fP
Si cette variable est positionnée et que l'option \fB\-\-admindir\fP n'est pas
précisée, ce répertoire sera utilisé comme répertoire de base pour
l'administration.
.
.SH FICHIERS
.TP 
\fI%CONFDIR%/alternatives/\fP
Le répertoire des «\ alternatives\ » par défaut. Peut être remplacé avec
l'option \fB\-\-altdir\fP.
.TP 
\fI%ADMINDIR%/alternatives/\fP
Le répertoire administratif par défaut. Peut être remplacé avec l'option
\fB\-\-admindir\fP
.
.SH "FORMAT DE REQUÊTE"
The \fB\-\-query\fP format is using an RFC822\-like flat format. It's made of \fIn\fP
+ 1 blocks where \fIn\fP is the number of alternatives available in the queried
link group. The first block contains the following fields:
.TP 
\fBName:\fP\fI nom\fP
Nom de l'alternative dans le répertoire des alternatives.
.TP 
\fBLink:\fP\fI lien\fP
Nom générique de l'alternative.
.TP 
\fBSlaves:\fP \fI liste\-des\-liens\-secondaires\fP
Lorsque cet en\-tête est présent, les lignes \fBsuivantes\fP contiennent tous
les liens secondaires associés au lien principal de cette alternative, à
raison d'un lien secondaire par ligne. Chaque ligne comporte une espace, le
nom de l'alternative secondaire, une espace et le chemin vers le lien
secondaire.
.TP 
\fBStatus:\fP\fI état\fP
État de l'alternative (\fBauto\fP ou \fBmanual\fP).
.TP 
\fBBest:\fP\fI meilleur\-choix\fP
Chemin de la meilleure alternative pour ce groupe de liens. N'est pas
présent si aucune alternative n'est disponible.
.TP 
\fBValue:\fP \fI alternative\-actuellement\-choisie\fP
Chemin de l'alternative actuellement choisie. Peut aussi prendre la valeur
spéciale \fBnone\fP, utilisée si le lien n'existe pas.
.PP
Les autres blocs décrivent les alternatives disponibles dans le groupe de
liens interrogé.
.TP 
\fBAlternative:\fP \fI chemin\-de\-cette\-alternative\fP
Chemin vers l'alternative de ce bloc
.TP 
\fBPriority:\fP \fI valeur\-de\-la\-priorité\fP
Valeur de la priorité de cette alternative.
.TP 
\fBSlaves:\fP \fI liste\-des\-liens\-secondaires\fP
Lorsque ce champ est présent, les lignes \fBsuivantes\fP contiennent toutes les
alternatives secondaires associées au lien principal de cette alternative, à
raison d'une alternative secondaire par ligne. Chaque ligne comporte une
espace, le nom de l'alternative secondaire, une espace et le chemin vers
l'alternative secondaire.
.
.SS Example
.nf
$ update\-alternatives \-\-query editor
Name: editor
Link: /usr/bin/editor
Slaves:
 editor.1.gz /usr/share/man/man1/editor.1.gz
 editor.fr.1.gz /usr/share/man/fr/man1/editor.1.gz
 editor.it.1.gz /usr/share/man/it/man1/editor.1.gz
 editor.pl.1.gz /usr/share/man/pl/man1/editor.1.gz
 editor.ru.1.gz /usr/share/man/ru/man1/editor.1.gz
Status: auto
Best: /usr/bin/vim.basic
Value: /usr/bin/vim.basic

Alternative: /bin/ed
Priority: \-100
Slaves:
 editor.1.gz /usr/share/man/man1/ed.1.gz

Alternative: /usr/bin/vim.basic
Priority: 50
Slaves:
 editor.1.gz /usr/share/man/man1/vim.1.gz
 editor.fr.1.gz /usr/share/man/fr/man1/vim.1.gz
 editor.it.1.gz /usr/share/man/it/man1/vim.1.gz
 editor.pl.1.gz /usr/share/man/pl/man1/vim.1.gz
 editor.ru.1.gz /usr/share/man/ru/man1/vim.1.gz
.fi
.
.SH DIAGNOSTICS
Avec l'option \fB\-\-verbose\fP, \fBupdate\-alternatives\fP affiche de très
nombreuses informations sur la sortie standard. Quand un problème survient,
\fBupdate\-alternatives\fP envoie des messages d'erreur sur la sortie d'erreur
standard et retourne un état de sortie égal à 2. Ces diagnostics devraient
être simples à comprendre\ ; si ce n'est pas le cas, veuillez envoyer un
rapport de bogue.
.
.SH EXEMPLES
Plusieurs paquets fournissent un éditeur de texte compatible avec \fBvi\fP, par
exemple \fBnvi\fP et \fBvim\fP. Celui qui sera utilisé est déterminé par le groupe
de liens \fBvi\fP, qui comprend des liens pour le programme lui\-même et sa page
de manuel.
.PP
Pour afficher les paquets disponibles qui fournissent \fBvi\fP et son
paramétrage actuel, on peut utiliser l'action \fB\-\-display\fP\ :
.PP
.RS
\fBupdate\-alternatives \-\-display vi\fP
.RE
.PP
Pour choisir une implémentation particulière de \fBvi\fP, on peut utiliser
cette commande en tant que superutilisateur et choisir un nombre dans la
liste\ :
.PP
.RS
\fBupdate\-alternatives \-\-config vi\fP
.RE
.PP
Pour retrouver l'implémentation par défaut de \fBvi\fP, on peut utiliser cette
commande en tant que superutilisateur\ :
.PP
.RS
\fBupdate\-alternatives \-\-auto vi\fP
.RE
.
.SH "VOIR AUSSI"
\fBln\fP(1), FHS, le standard pour l'organisation du système de fichiers.
.SH TRADUCTION
Ariel VARDI <ariel.vardi@freesbee.fr>, 2002.
Philippe Batailler, 2006.
Nicolas François, 2006.
Veuillez signaler toute erreur à <debian\-l10n\-french@lists.debian.org>.
