.\" dpkg manual page - dpkg-source(1)
.\"
.\" Copyright © 1995-1996 Ian Jackson <ijackson@chiark.greenend.org.uk>
.\" Copyright © 2000 Wichert Akkerman <wakkerma@debian.org>
.\" Copyright © 2006-2007 Frank Lichtenheld <djpig@debian.org>
.\" Copyright © 2006-2015 Guillem Jover <guillem@debian.org>
.\" Copyright © 2008-2011 Raphaël Hertzog <hertzog@debian.org>
.\" Copyright © 2010 Joey Hess <joeyh@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH dpkg\-source 1 %RELEASE_DATE% %VERSION% dpkg\-Programmsammlung
.ad l
.nh
.SH BEZEICHNUNG
dpkg\-source \- Debian Quellpaket\- (.dsc) Manipulations\-Werkzeuge
.
.SH ÜBERSICHT
\fBdpkg\-source\fP [\fIOption\fP …] \fIBefehl\fP
.
.SH BESCHREIBUNG
\fBdpkg\-source\fP packt und entpackt Debian\-Quellarchive.

Keiner dieser Befehle erlaubt es, mehrere Optionen zu einer zu kombinieren,
und sie erlauben es nicht, den Wert einer Option in einem separaten Argument
zu speichern.
.
.SH BEFEHLE
.TP 
\fB\-x\fP, \fB\-\-extract\fP \fIDateiname\fP.dsc [\fIAusgabe\-Verzeichnis\fP]
Entpackt ein Quellpaket (\fB\-\-extract\fP seit Dpkg 1.17.14). Ein
nicht\-Options\-Argument muss angegeben werden, der Name der Debian
Quell\-Steuer\-Datei (\fB.dsc\fP). Optional kann ein zweites
nicht\-Options\-Argument angegeben werden, um das Verzeichnis anzugeben, in
das das Quellpaket entpackt werden soll. Dieses Verzeichnis darf dann nicht
existieren. Falls kein Ausgabeverzeichnis angegeben ist, wird das Quellpaket
in das Verzeichnis namens \fIQuelle\fP\-\fIVersion\fP unterhalb des aktuellen
Arbeitsverzeichnisses entpackt.

\fBdpkg\-source\fP wird die Namen der anderen Datei(en) aus der Steuerdatei
einlesen, die das Quellpaket ergeben; es wird angenommen, dass diese im
gleichen Verzeichnis wie die \fB.dsc\fP liegen.

Die Dateien in dem entpackten Paket werden die Rechte und Eigentümer haben,
die erwartet würden, falls die Dateien und Verzeichnisse einfach angelegt
worden wären \- Verzeichnisse und Programmdateien werden 0777 und einfache
Dateien 0666, beide durch die umask der Person, die entpackt, entsprechend
angepasst; falls das übergeordnete Verzeichnis setgid ist, werden dies die
entpackten Verzeichnisse auch sein, und alle Dateien und Verzeichnisse
werden die Gruppeneigentümerschaft erben.

Falls das Quellpaket ein nicht\-Standard\-Format verwendet (derzeit bedeutet
dies alle Formate außer „1.0“)) wird sein Name in \fBdebian/source/format\fP
gespeichert, so dass alle folgenden Bauversuchen des Quellpakets
standardmäßig das gleiche Format verwenden.

.TP 
\fB\-b\fP, \fB\-\-build\fP \fIVerzeichnis\fP [\fIFormat\-abhängige\-Parameter\fP]
Baut ein Quellpaket (\fB\-\-build\fP seit Dpkg 1.17.14). Das erste
nicht\-Options\-Argument wird als Name des Verzeichnisses verwandt, das den
debianisierten (d.h. mit einem Unterverzeichnis „debian“ und ggf. Änderungen
an den Originaldateien versehenen) Quellbaum enthält. Abhängig vom dem zum
Bau verwandten Quellpaketformat könnten zusätzliche Parameter akzeptiert
werden.

\fBdpkg\-source\fP wird das Quellpaket mit dem ersten gefundenen Format aus der
folgenden geordneten Liste bauen: dem mit der Befehlszeilenoption(en)
\fI\-\-format\fP angegebenen Format, dem in \fBdebian/source/format\fP angegebenen
Format, „1.0“. Die Rückfalloption „1.0“ ist veraltet und wird irgendwann in
der Zukunft entfernt werden, Sie sollten das gewünschte Quellformat immer in
\fBdebian/source/format\fP dokumentieren. Die verschiedenen Quellpaketformate
werden im Abschnitt \fBQUELLPAKET\-FORMATE\fP ausführlich beschrieben.

.TP 
\fB\-\-print\-format\fP \fIVerzeichnis\fP
Gibt das Quellformat aus, dass zum Bau des Quellpakets verwandt würde, falls
\fBdpkg\-source \-\-build \fP\fIVerzeichnis\fP aufgerufen würde (unter den gleichen
Bedingungen und mit den gleichen Parametern, seit Dpkg 1.15.5).

.TP 
\fB\-\-before\-build\fP \fIVerzeichnis\fP
Der entsprechende Hook des Quellpaketformats soll ausgeführt werden (seit
Dpkg 1.15.8). Dieser Hook wird vor jedem Bau des Pakets aufgerufen
(\fBdpkg\-buildpackage\fP ruft ihn sehr früh, sogar vor \fBdebian/rules clean\fP
auf). Dieser Befehl ist idempotent und kann mehrfach aufgerufen
werden. Nicht alle Quellformate implementieren in diesem Hook etwas und wenn
dies erfolgt, dann gewöhnlich zur Vorbereitung des Quellbaums für den Bau,
in dem beispielsweise sichergestellt wird, dass alle Debian\-Patches
angewandt sind.

.TP 
\fB\-\-after\-build\fP \fIVerzeichnis\fP
Der entsprechende Hook des Quellpaketformats soll ausgeführt werden (seit
Dpkg 1.15.8). Dieser Hook wird nach jedem Bau des Pakets aufgerufen
(\fBdpkg\-buildpackage\fP ruft als Letztes auf). Dieser Befehl ist idempotent
und kann mehrfach aufgerufen werden. Nicht alle Quellformate implementieren
in diesem Hook etwas und wenn dies erfolgt, dann gewöhnlich um rückgängig zu
machen, was \fB\-\-before\-build\fP durchgeführt hat.

.TP 
\fB\-\-commit\fP [\fIVerzeichnis\fP] …
Zeichnet Änderungen am in \fIVerzeichnis\fP entpackten Quellbaum auf (seit Dpkg
1.16.1). Dieser Befehl kann zusätzliche Parameter akzeptieren, abhängig vom
Quellformat. Er wird zu einer Fehlermeldung bei Formaten, für denen dieser
Vorgang keine Bedeutung hat, führen.

.TP 
\fB\-?\fP, \fB\-\-help\fP
Zeigt die Hinweise zur Benutzung und beendet das Programm. Die
formatspezifischen Bau\- und Entpackoptionen können mit der Option
\fB\-\-format\fP angezeigt werden.
.TP 
\fB\-\-version\fP
Gibt die Version aus und beendet das Programm.
.
.SH OPTIONEN
.SS "Generische Bau\-Optionen"
.TP 
\fB\-c\fP\fISteuerdatei\fP
Bestimmt die Hauptquell\-\fBcontrol\fP\-Datei, aus der Informationen ausgelesen
werden sollen. Der Standardwert ist \fBdebian/control\fP. Falls der Pfadname
relativ ist, wird dieser relativ zum obersten Verzeichnis des Quellbaums
interpretiert.
.TP 
\fB\-l\fP\fIChangelog\-Datei\fP
Bestimmt die Changelog\-Datei, aus der Informationen ausgelesen werden
sollen. Der Standardwert ist \fBdebian/changelog\fP. Falls der Pfadname relativ
ist, wird dieser relativ zum obersten Verzeichnis des Quellbaums
interpretiert.
.TP 
\fB\-F\fP\fIChangelog\-Format\fP
Spezifiziert das Format des Changelogs. Lesen Sie \fBdpkg\-parsechangelog\fP(1)
für Informationen über alternative Formate.
.TP 
\fB\-\-format=\fP\fIWert\fP
Verwendet das angegebene Format zum Bau des Quellpakets (seit Dpkg
1.14.17). Es überschreibt jedes in \fBdebian/source/format\fP angegebene
Format.
.TP 
\fB\-V\fP\fIName\fP\fB=\fP\fIWert\fP
Setzt eine Ausgabeersetzungsvariable. Lesen Sie \fBdeb\-substvars\fP(5) für eine
Besprechung der Ausgabeersetzung.
.TP 
\fB\-T\fP\fISubstvars\-Datei\fP
Liest Ersetzungsvariablen aus \fISubstvars\-Datei\fP; standardmäßig wird keine
Datei gelesen. Diese Option kann mehrfach verwandt werden, um
Ersetzungsvariablen aus mehreren Dateien einzulesen (seit Dpkg 1.15.6).
.TP 
\fB\-D\fP\fIFeld\fP\fB=\fP\fIWert\fP
Überschreibt oder ergänzt ein Ausgabesteuerdateifeld.
.TP 
\fB\-U\fP\fIfield\fP
Entfernt ein Ausgabesteuerdateifeld.
.TP 
\fB\-Z\fP\fIKomprimierung\fP, \fB\-\-compression\fP=\fIKomprimierung\fP
Gibt die Komprimierung an, die für die angelegten Tarbälle und Diff\-Dateien
verwendet wird (\fB\-\-compression\fP seit Dpkg 1.15.5). Beachten Sie, dass diese
Option nicht dazu führt, dass existierende Tarbälle rekomprimiert werden,
sie betrifft nur neue Dateien. Unterstützte Werte sind \fIgzip\fP, \fIbzip2\fP,
\fIlzma\fP und \fIxz\fP. \fIxz\fP ist für Format 2.0 und neuer, \fIgzip\fP für Format
1.0 voreingestellt. \fIxz\fP wird erst seit Dpkg 1.15.5 unterstützt.
.TP 
\fB\-z\fP\fIStufe\fP, \fB\-\-compression\-level\fP=\fIStufe\fP
Zu verwendende Komprimierstufe (\fB\-\-compression\-level\fP seit Dpkg
1.15.5). Wie bei \fB\-Z\fP betrifft dies nur neu angelegte Dateien. Unterstützte
Werte sind \fI1\fP bis \fI9\fP, \fIbest\fP (am besten) und \fIfast\fP (schnell). Der
Standardwert ist \fI9\fP für Gzip und Bzip2, \fI6\fP für Xz und Lzma.
.TP 
\fB\-i\fP[\fIregex\fP], \fB\-\-diff\-ignore\fP[=\fIregex\fP]
Sie können einen regulären Perl\-Ausdruck angeben, der auf Dateien passt, die
Sie aus der Liste der Dateien für den Diff entfernen möchten
((\fB\-\-diff\-ignore\fP seit Dpkg 1.15.6); diese Liste wird von einem Find\-Befehl
generiert. Falls das Quellpaket als Version 3\-Quellpaket mittels eines VCS
gebaut wird, ignoriert dies stattdessen Änderungen an bestimmten Dateien,
die noch nicht übertragen („committed“) wurden (mit \-i.* werden alle davon
ignoriert).

Die Option \fB\-i\fP selbst aktiviert diese Einstellung mit einem
voreingestellten regulären Ausdruck (der alle Änderungen durch einen
standardmäßigen regulären Ausdruck erhält, die durch einen früheren Aufruf
von \fB\-\-extend\-diff\-ignore\fP erfolgten), der Steuerdateien und \-Verzeichnisse
der häufigsten Revisionskontrollsysteme, Sicherungskopien, Swap\-Dateien und
Bau\-Ausgabeverzeichnisse von Libtool herausgefiltert. Es kann nur einen
aktiven regulären Ausdruck geben, von mehrfach angegebenen Optionen \fB\-i\fP
wird nur die letzte berücksichtigt.

Dies ist sehr hilfreich, um irrelevante Dateien, die im Diff aufgenommen
werden, zu entfernen. Falls Sie zum Beispiel Ihre Quellen in einem
Revisionskontrollsystem speichern und „Checkout“ verwenden möchten, um Ihr
Quellpaket zu bauen, ohne die zusätzlichen Dateien und Verzeichnisse, die
darin typischerweise enthalten sind (z.B. CVS/, .cvsignore, .svn/), mit
aufzunehmen. Der voreingestellte reguläre Ausdruck ist bereits sehr
erschöpfend, aber falls Sie ihn ersetzen müssen, beachten Sie, dass er
standardmäßig auf alle Teile des Pfades passen kann. Falls Sie daher nur den
Anfang eines Pfades oder komplette Dateinamen vergleichen wollen, müssen Sie
die notwendigen Anker (z.B. ‚(^|/)’, ‚($|/)’) selbst bereitstellen.
.TP 
\fB\-\-extend\-diff\-ignore\fP=\fIregex\fP
Der angegebene reguläre Ausdruck (Perl\-Format) wird den standardmäßigen von
\fB\-\-diff\-ignore\fP verwandten Wert und dessen aktuellen Wert, falls gesetzt,
erweitern (seit Dpkg 1.15.6). Dies erfolgt, indem „\fB|\fP\fIregex\fP“ an den
existierenden Wert angehängt wird. Diese Option ist bequem in
\fBdebian/source/options\fP zu nutzen, um einige automatisch erstellte Dateien
von der automatischen Patch\-Erzeugung auszuschließen.
.TP 
\fB\-I\fP[\fIDateimuster\fP], \fB\-\-tar\-ignore\fP[=\fIDateimuster\fP]
Falls diese Option angegeben wird, wird der Dateiname an die Option
\fB\-\-exclude\fP von \fBtar\fP(1) weitergegeben, wenn es zur Erstellung der Datei
\&.orig.tar oder .tar aufgerufen wird (\fB\-\-tar\-ignore\fP seit Dpkg 1.15.6). Zum
Beispiel führt \fB\-I\fPCVS dazu, dass Tar CVS\-Verzeichnisse überspringt, wenn
es eine .tar\-Datei erstellt. Diese Option kann mehrfach wiederholt werden,
um mehrere Muster aufzuführen, die ausgeschlossen werden sollen.

\fB\-I\fP fügt standardmäßig von selbst \fB\-\-exclude\fP\-Optionen hinzu, die die
Steuerdateien und \-verzeichnisse der häufigsten Revisionskontrollsysteme,
Sicherungs\- und Swap\-Dateien sowie Bau\-Ausgabeverzeichnisse von Libtool
herausfiltern.
.PP
\fBHinweis\fP: Obwohl sie ähnlichen Zwecken dienen, haben \fB\-i\fP und \fB\-I\fP eine
sehr verschiedene Syntax und Semantik. \fB\-i\fP kann nur einmal angegeben
werden und nimmt einen regulären Perl\-Ausdruck an, der gegen den vollen
relativen Pfad jeder Datei geprüft wird. \fB\-I\fP kann mehrfach angegeben
werden und nimmt ein Dateinamen\-Muster mit Shell\-Jokerzeichen an. Das Muster
wird gegen den vollen relativen Pfad, aber auch individuell auf jeden Teil
des Pfades angewendet. Die exakte Semantik der Option \fB\-\-exclude\fP ist etwas
kompliziert, lesen Sie
https://www.gnu.org/software/tar/manual/tar.html#wildcards für eine
komplette Dokumentation.

Der voreingestellte reguläre Ausdruck und Muster für beide Optionen können
in der Ausgabe des Befehls \fB\-\-help\fP gesehen werden.
.SS "Generische Entpackoptionen"
.TP 
\fB\-\-no\-copy\fP
Kopiert die Original\-Tarbälle nicht in die Nähe des entpackten Quellpakets
(seit 1.14.17).
.TP 
\fB\-\-no\-check\fP
Prüft Signaturen und Prüfsummen vor dem Entpacken nicht (seit Dpkg 1.14.17).
.TP 
\fB\-\-no\-overwrite\-dir\fP
Das Entpackverzeichnis nicht überschreiben, falls es bereits existiert (seit
Dpkg 1.18.8).
.TP 
\fB\-\-require\-valid\-signature\fP
Lehnt das Entpacken des Quellpakets ab, falls es keine OpenPGP\-Signatur
enthält, die entweder mit dem \fItrustedkeys.gpg\fP\-Schlüsselbund des
Benutzers, mit einem der Schlüsselbunde des Lieferanten oder mit einem der
offiziellen Debian\-Schüsselbunde (\fI/usr/share/keyrings/debian\-keyring.gpg\fP
und \fI/usr/share/keyrings/debian\-maintainers.gpg\fP) überprüft werden kann
(seit Dpkg 1.15.0).
.TP 
\fB\-\-require\-strong\-checksums\fP
Lehnt das Entpacken des Quellpakets ab, falls es keine starken Prüfsummen
enthält (seit Dpkg 1.18.7). Derzeit wird nur die Prüfsumme \fBSHA\-256\fP als
stark betrachtet.
.TP 
\fB\-\-ignore\-bad\-version\fP
Wandelt die Prüfung auf eine defekte Quellpaketversion in eine nicht\-fatale
Warnung (seit Dpkg 1.17.7). Diese Option sollte nur notwendig sein, wenn ein
historisches Quellpaket mit defekten Versionen entpackt wird, lediglich zur
Rückwärtskompatibilität.

.SH QUELLPAKET\-FORMATE
Falls Sie nicht wissen, welches Quellformat Sie verwenden sollen, verwenden
Sie wahrscheinlich am besten entweder „3.0 (quilt)“ oder „3.0
(native)“. Lesen Sie https://wiki.debian.org/Projects/DebSrc3.0 für
Informationen über den Einsatz dieser Formate innerhalb von Debian.

.SS "Format: 1.0"
Ein Quellpaket in diesem Format besteht entweder aus einem \fB.orig.tar.gz\fP
mit zugehörigem \fB.diff.gz\fP oder einem einzelnen \fB.tar.gz\fP (in diesem Fall
wird das Paket als \fInativ\fP bezeichnet). Optional kann der ursprüngliche
Tarball von einer separaten Signatur der Originalautoren \fB.orig.tar.gz.asc\fP
begleitet werden. Das Entpacken wird seit Dpkg 1.18.5 unterstützt.

\fBEntpacken\fP

Entpacken eines nativen Pakets ist ein einfaches Entpacken eines einzelnen
Tarballs in das Zielverzeichnis. Entpacken eines nicht\-nativen Pakets
erfolgt zuerst durch Entpacken des \fB.orig.tar.gz\fP und dann durch Anwendung
des Patches aus der \fB.diff.gz\fP\-Datei. Der Zeitstempel aller gepatchten
Dateien wird auf den Zeitpunkt des Entpackens des Quellpakets zurückgesetzt
(das vermeidet Zeitstempelversätze, die zu Problemen führen, wenn
autogenerierte Dateien gepatcht werden). Der Diff kann neue Dateien anlegen
(das gesamte Debian\-Verzeichnis wird auf diese Weise erstellt), kann aber
keine Dateien entfernen (leere Dateien bleiben zurück).

\fBBauen\fP

Bauen eines nativen Pakets besteht nur aus dem Erstellen eines einzigen
Tarballs mit dem Quellverzeichnis. Bauen eines nicht\-nativen Pakets schließt
das Entpacken des Original\-Tarballs in ein separates Verzeichnis „.orig“ und
die Neuerstellung des \fB.diff.gz\fP durch Vergleich des
Quellpaket\-\fIVerzeichnisses\fP mit dem Verzeichnis .orig ein.

\fBBau\-Optionen (mit \-\-build):\fP

Falls ein zweites nicht\-Options\-Argument angegeben ist, sollte es der Name
des Originalquellverzeichnisses oder der Tar\-Datei sein. Falls das Paket
Debian\-spezifisch ist, dann sollte dieses Argument die leere Zeichenkette
sein, da es keinen Debianisierungs\-Diff gibt. Falls kein zweites Argument
übergeben wird, dann schaut \fBdpkg\-source\fP nach der ursprünglichen Tar\-Datei
\fIPaket\fP\fB_\fP\fIUpstream\-Version\fP\fB.orig.tar.\fP\fIErweiterung\fP oder dem
ursprünglichen Quellverzeichnis \fIVerzeichnis\fP\fB.orig\fP, abhängig von den
\fB\-sX\fP\-Argumenten.

\fB\-sa\fP, \fB\-sp\fP, \fB\-sk\fP, \fB\-su\fP und \fB\-sr\fP werden keine existierenden
Tar\-Dateien oder Verzeichnisse überschreiben. Falls dies gewünscht ist,
sollten stattdessen \fB\-sA\fP, \fB\-sP\fP, \fB\-sK\fP, \fB\-sU\fP und \fB\-sR\fP verwendet
werden.
.PP
.TP 
\fB\-sk\fP
Gibt an, dass die Originalquellen als Tar\-Datei erwartet werden sollen,
standardmäßig \fIPaket\fP\fB_\fP\fIUrsprungsversion\fP\fB.orig.tar\fP\fIErweiterung\fP. Es
wird diese Originalquellen als Tar\-Datei am Platz belassen, oder sie in das
aktuelle Verzeichnis kopieren, falls sie dort noch nicht sind. Der Tarball
wird nach \fIVerzeichnis\fP\fB.orig\fP für die Erstellung des Diffs entpackt.
.TP 
\fB\-sp\fP
Wie \fB\-sk\fP, aber das Verzeichnis wird danach entfernt.
.TP 
\fB\-su\fP
Gibt an, dass die Originalquellen als Verzeichnis erwartet werden,
standardmäßig \fIPaket\fP\fB\-\fP\fIUrsprungsversion\fP\fB.orig\fP. \fBdpkg\-source\fP wird
daraus ein neues Original\-Quellarchiv erstellen.
.TP 
\fB\-sr\fP
Wie \fB\-su\fP, aber das Verzeichnis wird nach der Verwendung entfernt.
.TP 
\fB\-ss\fP
Gibt an, dass die Originalquellen sowohl als Verzeichnis als auch als
Tar\-Datei verfügbar sind. \fBdpkg\-source\fP wird das Verzeichnis zur Erstellung
des Diffs verwenden, aber die Tar\-Datei für die \fB.dsc\fP. Diese Option muss
mit Vorsicht verwendet werden \- falls das Verzeichnis und die Tar\-Datei
nicht zusammen passen, wird ein fehlerhaftes Quellarchiv erstellt.
.TP 
\fB\-sn\fP
Gibt an, dass nicht nach Originalquellen geschaut und kein Diff erstellt
werden soll. Das zweite Argument, falls angegeben, muss die leere
Zeichenkette sein. Dies wird für Debian\-spezifische Pakete verwendet, die
keine Quellen von Originalautoren und somit keinen Debianisierungs\-Diff
haben.
.TP 
\fB\-sa\fP oder \fB\-sA\fP
Gibt an, dass nach dem Original\-Quellarchiv als Tar\-Datei oder als
Verzeichnis gesucht werden soll \- das zweite Argument, falls vorhanden, kann
eines von beiden sein, oder die leere Zeichenkette (dies ist äquivalent zur
Verwendung von \fB\-sn\fP). Falls eine Tar\-Datei gefunden wird, wird diese zur
Erstellung eines Diffs entpackt und danach entfernt (dies ist äquivalent zu
\fB\-sp\fP); falls ein Verzeichnis gefunden wird, wird dieses gepackt, um die
Originalquellen zu erstellen und danach entfernt (dies ist äquivalent zu
\fB\-sr\fP); falls keines von beiden gefunden wird, wird angenommen, dass das
Paket keinen Debianisierungs\-Diff, sondern nur ein direktes Quellarchiv hat
(dies ist äquivalent zu \fB\-sn\fP). Falls sowohl ein Verzeichnis als auch eine
Tar\-Datei gefunden werden, dann ignoriert \fBdpkg\-source\fP das Verzeichnis,
und überschreibt es, falls \fB\-sA\fP angegeben wurde (dies ist äquivalent zu
\fB\-sP\fP) oder löst einen Fehler aus, falls \fB\-sa\fP angegeben wurde. \fB\-sa\fP ist
die Voreinstellung.
.TP 
\fB\-\-abort\-on\-upstream\-changes\fP
Der Prozess schlägt fehl, falls der erstellte Diff Änderungen an Dateien
außerhalb des Unterverzeichnisses „debian“ enthält (seit Dpkg 1.15.8). Diese
Option ist in \fBdebian/source/options\fP nicht erlaubt, kann aber in
\fBdebian/source/local\-options\fP verwandt werden.
.PP

\fBEntpackoptionen (mit \-\-extract):\fP

In allen Fällen werden die Originalquellbäume entfernt.
.TP 
\fB\-sp\fP
Wird beim Entpacken verwandt. Die Originalquellen (falls vorhanden) werden
als Tar\-Datei belassen. Falls diese sich nicht im aktuellen Verzeichnis
befinden oder falls eine existierende, aber davon verschiedene Datei bereits
vorhanden ist, wird sie dort hin kopiert. (\fBDies ist die Voreinstellung.\fP)
.TP 
\fB\-su\fP
Entpackt den Originalquellbaum.
.TP 
\fB\-sn\fP
Stellt sicher, dass die Originalquellen weder in das aktuelle Verzeichnis
kopiert noch entpackt werden. Jeder Originalquellbaum, der im aktuellen
Verzeichnis war, wird dennoch entfernt.
.PP
Alle \fB\-s\fP\fIX\fP\-Optionen schließen sich gegenseitig aus. Falls Sie mehr als
eine angeben, wird nur die letzte verwendet.
.TP 
\fB\-\-skip\-debianization\fP
Überspringt die Anwendung des Debian\-Diffs über die Quellen der
Originalautoren (seit Dpkg 1.15.1).
.
.SS "Format: 2.0"
Seit Dpkg 1.13.9 Unterstützung des Entpackens, seit Dpkg 1.14.8
Unterstützung des Bauens. Auch als „wig&pen“ bekannt. Dieses Format wird
nicht für den breiten Einsatz empfohlen, es wird durch das Format „3.0
(quilt)“ ersetzt. Wig&pen war die erste Spezifikation eines Paketformats der
nächsten Generation.

Das Verhalten dieses Formats ist identisch zum Format „3.0 (quilt)“,
abgesehen davon, dass es keine explizite Liste von Patches verwendet. Alle
Dateien in \fBdebian/patches/\fP, die auf den regulären Perl\-Ausdruck
\fB[\ew\-]+\fP passen, müssen gültige Patches sein: sie werden zum Zeitpunkt des
Entpackens angewandt.

Wenn ein neues Quellpaket gebaut wird, werden alle Änderungen an den Quellen
der Originalautoren in einem Patch mit Namen \fBzz_debian\-diff\-auto\fP
gespeichert.
.
.SS "Format: 3.0 (native)"
Seit Dpkg 1.14.17 unterstützt. Dieses Format ist eine Erweiterung des
nativen Paketformats, wie es im 1.0\-Format definiert ist. Es unterstützt
alle Kompressionsmethoden und ignoriert standardmäßig alle VCS\-spezifischen
Dateien und Verzeichnisse sowie viele temporäre Dateien (lesen Sie den
Standardwert der Option \fB\-I\fP bei der Ausgabe von \fB\-\-help\fP).
.
.SS "Format: 3.0 (quilt)"
Seit Dpkg 1.14.17 unterstützt. Ein Quellpaket in diesem Format enthält
mindestens einen Original\-Tarball (\fB.orig.tar.\fP\fIErw\fP, wobei \fIErw\fP \fBgz\fP,
\fBbz2\fP, \fBlzma\fP und \fBxz\fP sein kann) und einen Debian\-Tarball
(\fB.debian.tar.\fP\fIErw\fP). Es kann auch zusätzliche Original\-Tarbälle
(\fB.orig\-\fP\fIKomponente\fP\fB.tar.\fP\fIErw\fP) enthalten. \fIKomponente\fP kann nur
alphanumerische Zeichen (‚a\-zA\-Z0\-9’) und Bindestriche (‚\-’)
enthalten. Optional kann jeder Original\-Tarball von einer separaten Signatur
der Originalautoren (\fB.orig.tar.\fP\fIErw\fP\fB.asc\fP und
\&\fB.orig\-\fP\fIKomponente\fP\fB.tar.\fP\fIErw\fP\fB.asc\fP) begleitet werden. Das Entpacken
wird seit Dpkg 1.17.20, das Bauen seit Dpkg 1.18.5 unterstützt.

.PP
\fBEntpacken\fP
.PP
Der Haupt\-Originaltarball wird zuerst entpackt, dann werden alle
zusätzlichen Originaltarbälle in Unterverzeichnisse entpackt, die nach dem
\fIKomponente\fPn\-Teil ihres Dateinamens benannt werden (jedes bereits
existierende Verzeichnis wird ersetzt). Der Debian\-Tarball wird über das
Quellverzeichnis entpackt, nachdem jedes bereits existierende
\fBdebian\fP\-Verzeichnis entfernt wurde. Beachten Sie, dass der Debian\-Tarball
ein \fBdebian\fP\-Unterverzeichnis enthalten muss, er aber auch Binärdateien
außerhalb dieses Verzeichnisses enthalten darf (sehen Sie hierzu die Option
\fB\-\-include\-binaries\fP).
.PP
Dann werden alle in \fBdebian/patches/\fP\fILieferant\fP\fB.series\fP oder
\fBdebian/patches/series\fP aufgeführten Patches angewandt, wobei \fILieferant\fP
der Name des aktuellen Lieferanten in Kleinbuchstaben ist oder \fBdebian\fP,
falls kein Lieferant definiert ist. Falls die erstere Datei verwandt wird
und die Letztere nicht existiert (oder ein Symlink ist), dann wird die
Letztere durch einen Symlink zu Ersterer ersetzt. Dies ist zur Vereinfachung
der Verwendung von \fBquilt\fP gedacht, um die Gruppe von Patches zu
verwalten. Lieferantenspezifische Seriendateien sind dazu gedacht, es zu
ermöglichen, mehrere Entwicklungszweige basierend auf dem Lieferanten auf
eine deklarative Art zu serialisieren, und diese gegenüber der offenen
Codierung dieser Handhabung in \fBdebian/rules\fP zu bevorzugen. Dies ist
insbesondere nützlich, wenn die Quellen mit Bedingungen gepacht werden
müssten, da die betroffenen Dateien keine eingebaute abhängige
Okklusionsunterstützung haben. Beachten Sie allerdings, dass \fBdpkg\-source\fP
zwar Seriendateien auswertet, in denen explizite Optionen für die Anwendung
der Patches verwandt werden (diese werden auf jede Zeile nach dem
Patch\-Dateinamen und einem oder mehreren Leerzeichen gespeichert), diese
Optionen dann aber ignoriert und immer erwartet, dass die Patches mit der
Option \fB\-p1\fP von \fBpatch\fP angewandt werden können. Es wird daher eine
Warnung ausgegeben, wenn es auf solche Optionen trifft, und der Bau wird
wahrscheinlich fehlschlagen.
.PP
Beachten Sie, dass \fBlintian\fP(1) aufgrund Debian\-spezifischer Regularien
bedingungslos Warnungen ausgeben wird, wenn Lieferantenserien verwandt
werden. Dies sollte die Verwendung außerhalb von Debian nicht betreffen. Um
diese Warnungen auszublenden, kann das Dpkg\-Lintian\-Profil mittels Übergabe
von „\fB\-\-profile dpkg\fP“ an \fBlintian\fP(1) verwandt werden.
.PP
Der Zeitstempel aller gepatchten Dateien wird auf die Entpackzeit des
Quellpakets zurückgesetzt. Damit werden Zeitstempelversätze vermieden, die
zu Problemen führen, wenn automatisch erzeugte Dateien gepatcht werden.
.PP
Im Gegensatz zum Standardverhalten bei \fBquilt\fP wird erwartet, dass die
Patches ohne Unschärfe angewandt werden können. Wenn das nicht der Fall ist,
sollten Sie die Patches mit \fBquilt\fP erneuern oder \fBdpkg\-source\fP wird mit
einer Fehlermeldung beim Versuch, sie anzuwenden, abbrechen.
.PP
Ähnlich wie bei \fBquilt\fP können Patches auch Dateien entfernen.
.PP
Die Datei \fB.pc/applied\-patches\fP wird angelegt, falls einige Patches während
des Entpackens angewandt wurden.
.PP
\fBBauen\fP
.PP
Alle im aktuellen Verzeichnis gefundenen Original\-Tarbälle werden in ein
temporäres Verzeichnis entpackt. Hierbei wird die gleiche Logik wie für das
Entpacken verwandt, das debian\-Verzeichnis wird in das temporäre Verzeichnis
kopiert und alle Patches außer dem automatischen Patch
(\fBdebian\-changes\-\fP\fIVersion\fP oder \fBdebian\-changes\fP, abhängig von
\fB\-\-single\-debian\-patch\fP) werden angewandt. Das temporäre Verzeichnis wird
mit dem Quellpaketverzeichnis verglichen. Wenn der Diff nicht leer ist,
schlägt der Bau fehl, falls nicht \fB\-\-single\-debian\-patch\fP oder
\fB\-\-auto\-commit\fP verwandt wurde; in diesem Fall wird der Diff im
automatischen Patch gespeichert. Falls der automatische Patch
erzeugt/gelöscht wird, wird er zu der Datei „series“ und den
\fBquilt\fP\-Metadaten hinzugefügt bzw. aus diesen gelöscht.

Änderungen an Binärdateien können in einem Diff nicht dargestellt werden und
führen daher zu einem Fehlschlag, es sei denn, der Betreuer hat sich
absichtlich dazu entschlossen, die veränderte Binärdatei dem Debian\-Tarball
hinzuzufügen (indem er sie in \fBdebian/source/include\-binaries\fP aufgeführt
hat). Der Bau wird auch fehlschlagen, falls er Binärdateien im
„debian“\-Unterverzeichnis findet, die nicht über
\fBdebian/source/include\-binaries\fP freigegeben wurden.

Das aktualisierte debian\-Verzeichnis und die Liste der veränderten Programme
wird dann zur Erstellung des Debian\-Tarballs verwandt.

Der automatisch erstellte Diff enthält keine Änderungen an VCS\-spezifischen
sowie vielen temporären Dateien (lesen Sie hierzu den zur Option \fB\-i\fP
zugeordneten Standardwert in der Ausgabe von \fB\-\-help\fP). Insbesondere wird
das von \fBquilt\fP verwandte \fB.pc\fP\-Verzeichnis während der Erstellung des
automatischen Patches ignoriert.

Hinweis: \fBdpkg\-source\fP \fB\-\-before\-build\fP (und \fB\-\-build\fP) stellen sicher,
dass alle in der Series\-Datei aufgeführten Patches angewendet sind, so dass
ein Paketbau immer mit allen angewandten Patches durchgeführt wird. Dies
erfolgt, indem nicht angewandte Patches ermittelt werden (sie sind in der
Datei \fBseries\fP, aber nicht in der Datei \fB.pc/applied\-patches\fP aufgeführt)
und wenn der erste Patch in dem Satz ohne Fehler angewandt werden kann,
werden sie alle angewandt. Die Option \fB\-\-no\-preparation\fP kann zum
Abschalten dieses Verhaltens verwandt werden.

.PP
\fBÄnderungen aufzeichnen\fP
.TP 
\fB\-\-commit\fP [\fIVerzeichnis\fP] [\fIPatch\-Name\fP] [\fIPatch\-Datei\fP]
Erstellt einen Patch, der den lokalen Änderungen entspricht, die nicht vom
\fBquilt\fP\-Patch\-System verwaltet werden und integriert ihn unter dem Namen
\fIPatch\-Name\fP in das Patch\-System. Falls der Name fehlt, wird er interaktiv
erfragt. Falls \fIPatch\-Datei\fP angegeben ist, wird er als Patch, der zu den
lokalen Änderungen, die integriert werden sollen, gehört, verwandt. Sobald
der Patch integriert wurde, wird ein Editor gestartet, so dass Sie die
Metainformationen in den Kopfzeilen des Patches einfügen können.

Die Verwendung von \fIpatch\-Datei\fP ist primär nach einem Baufehler nützlich,
der diese Datei vorgenerierte und daher wird die übergebene Datei nach der
Integration entfernt. Beachten Sie auch, dass die Änderungen, die in der
Patch\-Datei angegeben sind, bereits im Baum angewandt worden sein müssen und
dass die Dateien, die von diesem Patch geändert werden, keine zusätzlichen,
nicht aufgezeichneten Änderungen enthalten dürfen.

Falls die Patch\-Erzeugung veränderte Binärdateien erkennt, werden diese
automatisch zu \fBdebian/source/include\-binaries\fP hinzugefügt, so dass sie im
Debian\-Tarball landen (genau wie dies \fBdpkg\-source \-\-include\-binaries
\-\-build\fP machen würde).
.PP
\fBBau\-Optionen\fP
.TP 
\fB\-\-allow\-version\-of\-quilt\-db=\fP\fIVersion\fP
Erlaubt es \fBdpkg\-source\fP, ein Quellpaket zu bauen, falls die Version der
\fBquilt\fP\-Metadaten die angegebene ist, selbst falls \fBdpkg\-source\fP nichts
davon weiß (seit Dpkg 1.15.5.4). Effektiv teilt dies mit, dass die
angegebene Version der \fBquilt\fP\-Metadaten zu Version 2, die \fBdpkg\-source\fP
derzeit unterstützt, kompatibel ist. Die Version der \fBquilt\fP\-Metadaten wird
in \fB.pc/.version\fP gespeichert.
.TP 
\fB\-\-include\-removal\fP
Ignoriert entfernte Dateien nicht und fügt sie zu dem automatisch
generierten Patch hinzu.
.TP 
\fB\-\-include\-timestamp\fP
Fügt Zeitstempel zu dem automatisch generierten Patch hinzu.
.TP 
\fB\-\-include\-binaries\fP
Fügt alle veränderten Programme zu dem debian\-Tarball hinzu. Fügt sie auch
in \fBdebian/source/include\-binaries\fP hinzu: sie werden in folgenden Bauten
standardmäßig hinzugefügt und diese Option wird daher dann nicht mehr
benötigt.
.TP 
\fB\-\-no\-preparation\fP
Versucht nicht, den Bau\-Baum durch Anwenden aller derzeit nicht angewandten
Patches vorzubereiten (seit Dpkg 1.14.18).
.TP 
\fB\-\-single\-debian\-patch\fP
Verwendet \fBdebian/patches/debian\-changes\fP statt
\fBdebian/patches/debian\-changes\-\fP\fIVersion\fP als Namen für den während des
Baus automatisch generierten Patch (seit Dpkg 1.15.5.4). Diese Option ist
insbesondere nützlich, wenn das Paket in einem VCS betreut wird und ein
Patch\-Satz nicht zuverlässig erstellt werden kann. Stattdessen sollte der
aktuelle Diff zu den Quellen der Originalautoren in einem einzelnen Patch
gespeichert werden. Diese Option sollte in \fBdebian/source/local\-options\fP
eingestellt werden und würde dann von einer Datei
\fBdebian/source/local\-patch\-header\fP begleitet, in der erklärt wird, wie die
Debian\-Änderungen am besten begutachtet werden können, beispielsweise im
eingesetzten VCS.
.TP 
\fB\-\-create\-empty\-orig\fP
Erstellt den Hauptoriginal\-Tarball automatisch als leer, falls er fehlt und
falls es ergänzende Original\-Tarbälle gibt (seit Dpkg 1.15.6). Diese Option
ist dafür gedacht, wenn das Quellpaket nur eine Sammlung von mehreren
Stücken Software der Originalautoren ist und es keine „Haupt“\-Software gibt.
.TP 
\fB\-\-no\-unapply\-patches, \-\-unapply\-patches\fP
Standardmäßig wird \fBdpkg\-source\fP die Patches im \fB\-\-after\-build\fP\-Hook
entfernen, falls es sie in \fB\-\-before\-build\fP angewandt hat
(\fB\-\-unapply\-patches\fP seit Dpkg 1.15.8, \fB\-\-no\-unapply\-patches\fP seit Dpkg
1.16.5). Diese Optionen erlauben es Ihnen, den Patch\-Anwendungs\- oder
\-Entfernungs\-Prozess zwangsweise zu aktivieren bzw. zu deaktivieren. Diese
Optionen sind nur in \fBdebian/source/local\-options\fP erlaubt, so dass alle
erstellten Quellpakete standardmäßig das gleiche Verhalten zeigen.
.TP 
\fB\-\-abort\-on\-upstream\-changes\fP
Dieser Prozess schlägt fehl, falls ein automatischer Patch erstellt wurde
(seit Dpkg 1.15.8). Diese Option kann dazu verwandt werden, sicherzustellen,
dass alle Änderungen korrekt in separaten \fBquilt\fP\-Patches aufgezeichnet
wurden, bevor das Paket gebaut wurde. Diese Option ist in
\fBdebian/source/options\fP nicht erlaubt, kann aber in
\fBdebian/source/local\-options\fP verwandt werden.
.TP 
\fB\-\-auto\-commit\fP
Der Vorgang schlägt nicht fehl, falls ein automatischer Patch erstellt
wurde, stattdessen wird dieser sofort in die \fBquilt\fP\-Serie aufgenommen.

.PP
\fBEntpackoptionen\fP
.TP 
\fB\-\-skip\-debianization\fP
Überspringt das Entpacken des Debian\-Tarballs über die Quellen der
Originalautoren (seit Dpkg 1.15.1).
.TP 
\fB\-\-skip\-patches\fP
Wendet am Ende des Entpackens keine Patches an (seit Dpkg 1.14.18).
.
.SS "Format: 3.0 (custom)"
Seit Dpkg 1.14.17 unterstützt. Dieses Format ist besonders. Es stellt kein
echtes Quellpaket dar, kann aber zur Erstellung eines Quellpakets mit
beliebigen Dateien verwandt werden.
.PP
\fBBau\-Optionen\fP
.PP
Alle Argumente, die keine Optionen sind, werden als Dateien verstanden, die
in das generierte Quellpaket integriert werden sollen. Sie müssen existieren
und sich bevorzugt im aktuellen Verzeichnis befinden. Mindestens eine Datei
muss angegeben werden.
.TP 
\fB\-\-target\-format=\fP\fIWert\fP
\fBNotwendig\fP. Definiert das echte Format des generierten Quellpakets. Die
generierte .dsc\-Datei wird diesen Wert und nicht „3.0 (custom)“ in ihrem
\fBFormat\fP\-Feld enthalten.
.
.SS "Format: 3.0 (git)"
Seit Dpkg 1.14.17 unterstützt. Dieses Format ist experimentell.
.PP
Ein Quellpaket in diesem Format besteht aus einem einzelnen Bündel eines
Git\-Depots \fB.git\fP, um die Quellen des Pakets zu verwahren. Es kann auch
eine Datei \fB.gitshallow\fP geben, die die Revisionen für einen flachen
Git\-Clone aufführt.
.PP
\fBEntpacken\fP
.PP
Das Bündel wird als Git\-Depot in das Zielverzeichnis geklont. Falls es eine
gitshallow\-Datei gibt, wird diese als \fI.git/shallow\fP innerhalb des
geklonten Git\-Depots installiert.
.PP
Beachten Sie, dass standardmäßig im neuen Depot der gleiche Zweig
ausgecheckt ist, der auch in der ursprünglichen Quelle ausgecheckt war
(typischerweise „master“, es könnte aber auch was beliebig anderes
sein). Alle anderen Zweige sind unter \fIremotes/origin/\fP verfügbar.
.PP
\fBBauen\fP
.PP
Bevor fortgefahren wird, werden einige Überprüfungen ausgeführt, um
sicherzustellen, dass keine nicht\-ignorierten, nicht\-übertragenen
(„uncommitted“) Änderungen vorliegen.
.PP
\fBgit\-bundle\fP(1) wird zur Erstellung des Bündels des Git\-Depots
verwandt. Standardmäßig werden alle Zweige und Markierungen im Depot im
Bündel einbezogen.
.PP
\fBBau\-Optionen\fP
.TP 
\fB\-\-git\-ref=\fP\fIReferenz\fP
Erlaubt die Angabe einer Git\-Referenz zur Aufnahme in dem Git\-Bündel. Die
Verwendung deaktiviert das standardmäßige Verhalten, alle Zweige und
Markierungen aufzunehmen. Kann mehrfach angegeben werden. \fIReferenz\fP kann
der Name eines Zweiges oder einer Markierung, der/die aufgenommen werden
soll, sein. Es kann auch ein Parameter sein, der an \fBgit\-rev\-list\fP(1)
übergeben werden kann. Verwenden Sie beispielsweise \fB\-\-git\-ref=\fPmaster, um
nur den Master\-Zweig aufzunehmen. Um alle Markierungen und Zweige außer dem
Zweig „private“ aufzunehmen, verwenden Sie \fB\-\-git\-ref=\fP\-\-all
\fB\-\-git\-ref=\fP^private.
.TP 
\fB\-\-git\-depth=\fP\fIZahl\fP
Erstellt einen flachen Klon mit einem Verlauf, der bei der angegebenen
Anzahl an Revisionen abgeschnitten wird.
.SS "Format: 3.0 (bzr)"
Seit Dpkg 1.14.17 unterstützt. Dieses Format ist experimentell. Es erstellt
einen einzigen Tarball, der das Bzr\-Depot enthält.
.PP
\fBEntpacken\fP
.PP
Der Tarball wird entpackt und dann wird Bzr verwandt, um den aktuellen Zweig
auszuchecken.
.PP
\fBBauen\fP
.PP
Bevor fortgefahren wird, werden einige Überprüfungen ausgeführt, um
sicherzustellen, dass keine nicht\-ignorierten, nicht\-übertragenen
(„uncommitted“) Änderungen vorliegen.
.PP
Dann wird der VCS\-spezifische Teil des Quellpakets in ein temporäres
Verzeichnis kopiert. Bevor dieses temporäre Verzeichnis in einen Tarball
gepackt wird, werden verschiedene Bereinigungen durchgeführt, um Platz zu
sparen.
.SH DIAGNOSE
.SS "kein Quellformat in debian/source/format angegeben"
Die Datei \fBdebian/source/format\fP sollte immer existieren und das gewünschte
Quellformat angeben. Für Rückwärtskompatibilität wird das Format „1.0“
angenommen, wenn die Datei nicht existiert, aber Sie sollten sich nicht
darauf verlassen: Irgendwann in der Zukunft wird \fBdpkg\-source\fP verändert
und dann fehlschlagen, wenn diese Datei nicht existiert.

Die Begründung liegt darin, dass „1.0“ nicht mehr das empfohlene Format ist,
Sie sollten normalerweise eines der neueren Formate („3.0 (quilt)“, „3.0
(native)“) auswählen, aber \fBdpkg\-source\fP wird dies nicht für Sie
automatisch vornehmen. Falls Sie weiterhin das alte Format verwenden
möchten, sollten Sie dies explizit angeben und „1.0“ in
\fBdebian/source/format\fP eintragen.
.SS "der Diff verändert die folgenden Dateien der Originalautoren"
Beim Einsatz des Quellformats „1.0“ ist es normalerweise keine gute Idee,
die Dateien der Originalautoren direkt zu verändern, da die Änderungen
größtenteils versteckt und undokumentiert in der diff.gz\-Datei
verschwinden. Stattdessen sollten Sie Ihre Änderungen als Patches im
debian\-Verzeichnis speichern und während des Baus anwenden. Um diese
Komplexität zu vermeiden, können Sie auch das Format „3.0 (quilt)“
verwenden, das dies von sich aus anbietet.
.SS "kann Änderungen an \fIDatei\fP nicht darstellen"
Änderungen an den Quellen der Originalautoren werden normalerweise als
Patch\-Dateien gespeichert, aber nicht alle Änderungen können als Patches
dargestellt werden: Sie können nur Änderungen am Inhalt einfacher
Textdateien vornehmen. Falls Sie versuchen, eine Datei durch etwas eines
anderen Typs zu ersetzen (beispielsweise eine einfache Datei durch einen
Symlink oder ein Verzeichnis), werden Sie diese Fehlermeldung erhalten.
.SS "neu angelegte leere Datei \fIDatei\fP wird im Diff nicht dargestellt werden"
Leere Dateien können nicht mit Patchdateien erstellt werden. Daher wird
diese Änderung nicht im Quellpaket aufgezeichnet und Sie erhalten dazu diese
Warnung.
.SS "ausführbarer Modus \fIRechte\fP von \fIDatei\fP wird nicht im Diff dargestellt werden"
Patch\-Dateien speichern nicht die Rechte von Dateien und daher werden
Ausführbarkeitsrechte nicht im Quellpaket gespeichert. Diese Warnung
erinnert Sie an diese Tatsache.
.SS "besonderer Modus \fIRechte\fP von \fIDatei\fP wird nicht im Diff dargestellt werden"
Patch\-Dateien speichern nicht die Rechte von Dateien und daher werden
geänderte Rechte nicht im Quellpaket gespeichert. Diese Warnung erinnert Sie
an diese Tatsache.
.
.SH UMGEBUNG
.TP 
\fBDPKG_COLORS\fP
Setzt den Farbmodus (seit Dpkg 1.18.5). Die derzeit unterstützten Werte
sind: \fBauto\fP (Vorgabe), \fBalways\fP und \fBnever\fP.
.TP 
\fBDPKG_NLS\fP
Falls dies gesetzt ist, wird es zur Entscheidung, ob Native Language
Support, auch als Unterstützung für Internationalisierung (oder i18n)
bekannt, aktiviert wird (seit Dpkg 1.19.0). Die akzeptierten Werte sind:
\fB0\fP und \fB1\fP (Vorgabe).
.TP 
\fBSOURCE_DATE_EPOCH\fP
Falls gesetzt, wird sie als Zeitstempel (als Sekunden seit der Epoche) zum
Festlegen der Mtime in den Dateieinträgen von \fBtar\fP(5) verwandt.
.TP 
\fBVISUAL\fP
.TQ
\fBEDITOR\fP
Von den „2.0“\- und „3.0 (quilt)“\-Quellformatmodulen verwandt.
.TP 
\fBGIT_DIR\fP
.TQ
\fBGIT_INDEX_FILE\fP
.TQ
\fBGIT_OBJECT_DIRECTORY\fP
.TQ
\fBGIT_ALTERNATE_OBJECT_DIRECTORIES\fP
.TQ
\fBGIT_WORK_TREE\fP
Von dem „3.0 (quilt)“\-Quellformatmodul verwandt.
.
.SH DATEIEN
.SS debian/source/format
Diese Datei enthält auf einer einzelnen Zeile das Format, das zum Bau des
Quellpakets verwandt werden soll (mögliche Formate sind oben
beschrieben). Leerzeichen am Zeilenanfang oder \-ende sind nicht erlaubt.
.SS debian/source/include\-binaries
Diese Datei enthält eine Liste von Pfadnamen von Binärdateien (eine pro
Zeile), relativ zum Quellwurzelverzeichnis, die in den Debian\-Tarball
aufgenommen werden sollen. Leerzeichen am Anfang und Ende der Zeile werden
entfernt. Zeilen, die mit ‚\fB#\fP’ anfangen, sind Kommentare und werden
übersprungen. Leere Zeilen werden ignoriert.
.SS debian/source/options
Diese Datei enhält eine Liste an Optionen, die automatisch vor den Satz an
Befehlszeilenoptionen bei einem Aufruf \fBdpkg\-source \-\-build\fP oder
\fBdpkg\-source \-\-print\-format\fP gesetzt werden sollen. Optionen wie
\fB\-compression\fP und \fB\-\-compression\-level\fP sind für diese Datei gut
geeignet.
.P
Jede Option sollte auf einer separaten Zeile stehen. Leerzeilen und Zeilen,
die mit ‚\fB#\fP’ beginnen, werden ignoriert. Das einleitende ‚\fB\-\-\fP’ sollte
entfernt werden und kurze Optionen sind nicht erlaubt. Optionale Leerzeichen
um das ‚\fB=\fP’\-Symbol sowie optionale Anführungszeichen um den Wert sind
erlaubt. Hier ist ein Beispiel für so eine Datei:
.P
  # lass dpkg\-source ein debian.tar.bz2 mit maximaler Komprimierung
  # erstellen
  compression = "bzip2"
  compression\-level = 9
  # verwende debian/patches/debian\-changes als automatischen Patch
  single\-debian\-patch
  # ignoriere Änderungen von config.{sub,guess}
  extend\-diff\-ignore = "(^|/)(config.sub|config.guess)$"
.P
Hinweis: \fB\-\-format\fP\-Optionen werden in dieser Datei nicht akzeptiert, Sie
sollten stattdessen \fBdebian/source/format\fP verwenden.
.SS debian/source/local\-options
Genau wie \fBdebian/source/options\fP, außer dass die Datei nicht in das
erstellte Quellpaket aufgenommen wird. Dies kann nützlich sein, um
Voreinstellungen zu speichern, die an einen bestimmten Betreuer oder an ein
bestimmtes VCS, in dem das Paket gewartet wird, gebunden sind.
.SS "debian/source/local\-patch\-header \fRund\fP debian/source/patch\-header"
Formloser Text, der an den Anfang des in den Formaten „2.0“ und „3.0
(quilt)“ generierten automatischen Patches gestellt
wird. \fBlocal\-patch\-header\fP wird dem erstellten Quellpaket nicht
hinzugefügt, \fBpatch\-header\fP dagegen schon.
.SS debian/patches/\fILieferant\fP.series
.SS debian/patches/series
Diese Datei führt alle Patches auf, die (in der angegebenen Reihenfolge) auf
das Quellpaket der Originalautoren angewandt werden müssen. Leerzeichen am
Anfang und Ende werden entfernt. \fILieferant\fP ist der Name des aktuellen
Lieferanten in Kleinschreibung oder \fBdebian\fP, falls kein Lieferant
definiert ist. Falls die lieferantenspezifische Seriendatei nicht existiert,
wird eine lieferantenfreie Seriendatei verwandt. Zeilen, die mit ‚\fB#\fP’
anfangen, sind Kommentare und werden übersprungen. Leere Zeilen werden
ignoriert. Die verbleibenden Zeilen beginnen mit dem Dateinamen eines
Patches (relativ zum Verzeichnis \fBdebian/patches/\fP) bis zum ersten
Leerzeichen oder bis zum Zeilenende. Bis zum Ende der Zeile oder bis zum
ersten ‚\fB#\fP’ gefolgt von einem oder mehreren Leerzeichen (dies markiert den
Beginn eines Kommentars, der bis zum Zeilenende geht) können optionale
\fBquilt\fP\-Befehle folgen.
.SH FEHLER
Die Stelle, an der das Überschreiben von Feldern passiert, verglichen mit
bestimmten Standard\-Ausgabe\-Feldeinstellungen, ist eher verwirrend.
.SH "SIEHE AUCH"
\fBdeb\-src\-control\fP(5), \fBdeb\-changelog\fP(5), \fBdsc\fP(5).
.SH ÜBERSETZUNG
Die deutsche Übersetzung wurde 2004, 2006-2020 von Helge Kreutzmann
<debian@helgefjell.de>, 2007 von Florian Rehnisch <eixman@gmx.de> und
2008 von Sven Joachim <svenjoac@gmx.de>
angefertigt. Diese Übersetzung ist Freie Dokumentation; lesen Sie die
GNU General Public License Version 2 oder neuer für die Kopierbedingungen.
Es gibt KEINE HAFTUNG.
