.\" dpkg manual page - dpkg(1)
.\"
.\" Copyright © 1996 Juho Vuori <javuori@cc.helsinki.fi>
.\" Copyright © 1999 Jim Van Zandt <jrv@vanzandt.mv.com>
.\" Copyright © 1999-2003 Wichert Akkerman <wakkerma@debian.org>
.\" Copyright © 2000-2003 Adam Heath <doogie@debian.org>
.\" Copyright © 2002 Josip Rodin
.\" Copyright © 2004-2005 Scott James Remnant <keybuk@debian.org>
.\" Copyright © 2006-2016 Guillem Jover <guillem@debian.org>
.\" Copyright © 2007-2008 Ian Jackson <ijackson@chiark.greenend.org.uk>
.\" Copyright © 2008-2011 Raphaël Hertzog <hertzog@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH dpkg 1 %RELEASE_DATE% %VERSION% dpkg\-Programmsammlung
.ad l
.nh
.SH BEZEICHNUNG
dpkg \- Paketverwalter für Debian
.
.SH ÜBERSICHT
\fBdpkg\fP [\fIOption\fP …] \fIAktionen\fP
.
.SH WARNUNG
Dieses Handbuch ist für Benutzer gedacht, die die Befehlszeilenoptionen und
Paketzustände von \fBdpkg\fP detaillierter verstehen wollen, als durch \fBdpkg
\-\-help\fP beschrieben ist.

Es sollte \fInicht\fP von Paketbetreuern verwendet werden, die verstehen
wollen, wie \fBdpkg\fP ihr Paket installieren wird. Die Beschreibung der
Aktionen von \fBdpkg\fP beim Installieren und Entfernen von Paketen ist
besonders unzulänglich.
.
.SH BESCHREIBUNG
\fBdpkg\fP ist ein Werkzeug, um Debian\-Pakete zu installieren, zu bauen, zu
entfernen und zu verwalten. Die primäre und benutzerfreundlichere Oberfläche
für \fBdpkg\fP ist \fBaptitude\fP(1). \fBdpkg\fP selbst wird komplett über
Befehlszeilenoptionen gesteuert, die aus genau einer Aktion und Null oder
mehreren Optionen bestehen. Der Aktionsparameter teilt \fBdpkg\fP mit, was zu
tun ist, und die Optionen steuern die Aktionen in irgendeiner Weise.

\fBdpkg\fP kann auch als Oberfläche für \fBdpkg\-deb\fP(1) und \fBdpkg\-query\fP(1)
verwendet werden. Die Liste der unterstützten Aktionen kann im Abschnitt
\fBAKTIONEN\fP gefunden werden. Falls so eine Aktion angetroffen wird, führt
\fBdpkg\fP einfach \fBdpkg\-deb\fP oder \fBdpkg\-query\fP mit den übergebenen
Parametern aus, allerdings werden derzeit keine spezifischen Optionen an
diese übergeben. Um solche Optionen zu verwenden, müssen die Backends direkt
aufgerufen werden.
.
.SH "INFORMATIONEN ÜBER PAKETE"
\fBdpkg\fP verwaltet einige nützliche Informationen über verfügbare Pakete. Die
Informationen sind in drei Klassen unterteilt: \fBStatus\fP, \fBAuswahlstatus\fP
und \fBSchalter\fP. Diese Werte sind hauptsächlich zur Änderung durch
\fBdselect\fP gedacht.
.SS Paketstatus
.TP 
\fBnot\-installed\fP (nicht\-installiert)
Das Paket ist nicht auf Ihrem System installiert.
.TP 
\fBconfig\-files\fP (Config\-Dateien)
Nur die Konfigurationsdateien des Pakets existieren auf dem System.
.TP 
\fBhalf\-installed\fP (halb\-installiert)
Die Installation des Paketes wurde begonnen, aber aus irgendeinem Grund
nicht abgeschlossen.
.TP 
\fBunpacked\fP (entpackt)
Das Paket ist entpackt, aber nicht konfiguriert.
.TP 
\fBhalf\-configured\fP (halb\-konfiguriert)
Das Paket ist entpackt und die Konfiguration wurde begonnen, aber aus
irgendeinem Grund nicht abgeschlossen.
.TP 
\fBtriggers\-awaited\fP (Trigger\-erwartend)
Das Paket erwartet Trigger\-Verarbeitung durch ein anderes Paket.
.TP 
\fBtriggers\-pending\fP (Trigger\-anhängig)
Das Paket wurde getriggert.
.TP 
\fBinstalled\fP (installiert)
Das Paket ist korrekt entpackt und konfiguriert.
.SS Paketauswahlstatus
.TP 
\fBinstall\fP (installiere)
Das Paket ist zur Installation ausgewählt.
.TP 
\fBhold\fP (halten)
Eine mit \fBhalten\fP markierte Version wird auf der gleichen Version gehalten,
d.h. keine automatischen Installationen, Upgrades oder Entfernungen werden
mit ihnen durchgeführt, außer diese Aktionen werden explizit angefordert
oder mit der Option \fB\-\-force\-hold\fP automatisch durchgeführt.
.TP 
\fBdeinstall\fP (deinstalliere)
Das Paket ist zur Deinstallation ausgewählt (d.h. wir wollen alle Dateien
außer den Konfigurationsdateien entfernen).
.TP 
\fBpurge\fP (vollständig löschen)
Das Paket ist zum vollständigen Löschen („purge“) ausgewählt (d.h. wir
wollen alle Dateien aus den Systemverzeichnissen inklusive der
Konfigurationsdateien entfernen).
.TP 
\fBunknown\fP (unbekannt)
Die Paketauswahl ist unbekannt. Ein Paket, das auch im Zustand
\fBnot\-installed\fP und ohne Schalter \fBok\fP ist, wird beim nächsten Abspeichern
der Datenbank vergessen.
.SS Paketschalter
.TP 
\fBok\fP
Ein mit \fBok\fP markiertes Paket ist in einem bekannten Zustand, kann aber
weitere Verarbeitung benötigen.
.TP 
\fBreinstreq\fP (Neuinstnotwendig)
Ein mit \fBNeuinstnotwendig\fP markiertes Paket ist defekt und muss erneut
installiert werden. Diese Pakete können nicht entfernt werden, es sei denn,
Sie erzwingen dies mit der Option \fB\-\-force\-remove\-reinstreq\fP.
.
.SH AKTIONEN
.TP 
\fB\-i\fP, \fB\-\-install\fP \fIPaketdatei\fP …
Installiert das Paket. Falls die Option \fB\-\-recursive\fP oder \fB\-R\fP angegeben
ist, muss sich \fIPaketdatei\fP stattdessen auf ein Verzeichnis beziehen.

Die Installation besteht aus folgenden Schritten:
.br

\fB1.\fP Die Steuerdateien aus dem neuen Paket werden entpackt.
.br

\fB2.\fP Falls eine andere Version des gleichen Pakets vor der neuen
Installation installiert war, dann wird das \fIprerm\fP\-Skript des alten
Paketes ausgeführt.
.br

\fB3.\fP Das \fIpreinst\fP\-Skript wird ausgeführt, falls dies vom Paket
bereitgestellt wird.
.br

\fB4.\fP Die neuen Dateien werden entpackt und gleichzeitig die alten Dateien
gesichert, so dass diese, falls etwas schief geht, wiederhergestellt werden
können.
.br

\fB5.\fP Falls eine andere Version des gleichen Pakets vor der neuen
Installation installiert war, dann wird das \fIpostrm\fP\-Skript des alten
Paketes ausgeführt. Beachten Sie, dass dieses Skript nach dem
\fIpreinst\fP\-Skript des neuen Pakets ausgeführt wird, da neue Dateien
zeitgleich zu der Entfernung alter Dateien geschrieben werden.
.br

\fB6.\fP Das Paket wird konfiguriert. Lesen Sie \fB\-\-configure\fP für detaillierte
Informationen, wie dies geschieht.
.TP 
\fB\-\-unpack \fP\fIPaketdatei\fP …
Entpackt das Paket, konfiguriert es aber nicht. Falls die Option
\fB\-\-recursive\fP oder \fB\-R\fP angegeben ist, muss sich \fIPaketdatei\fP stattdessen
auf ein Verzeichnis beziehen.
.TP 
\fB\-\-configure \fP\fIPaket\fP …|\fB\-a\fP|\fB\-\-pending\fP
Konfiguriert ein entpacktes, aber noch nicht konfiguriertes Paket. Falls
\fB\-a\fP oder \fB\-\-pending\fP anstelle von \fIPaket\fP angegeben ist, werden alle
entpackten, aber nicht konfigurierten Pakete konfiguriert.

Um ein Paket zu rekonfigurieren, das bereits konfiguriert wurde, verwenden
Sie stattdessen den Befehl \fBdpkg\-reconfigure\fP(8).

Die Konfiguration besteht aus folgenden Schritten:
.br

\fB1.\fP Die Conffiles werden entpackt und gleichzeitig die alten Conffiles
gesichert, so dass diese, falls etwas schief geht, wiederhergestellt werden
können.
.br

\fB2.\fP Das \fIpostinst\fP\-Skript wird ausgeführt, falls dies vom Paket
bereitgestellt wird.
.TP 
\fB\-\-triggers\-only\fP \fIPaket\fP …|\fB\-a\fP|\fB\-\-pending\fP
Verarbeitet nur Trigger (seit Dpkg 1.14.17). Alle ausstehenden Trigger
werden verarbeitet. Falls Paketnamen übergeben werden, werden nur die
Trigger dieser Pakete verarbeitet, jedes genau einmal, wo notwendig. Die
Verwendung dieser Option kann Pakete in die unzulässigen Zustände
\fBtriggers\-awaited\fP und \fBtriggers\-pending\fP bringen. Durch die Ausführung
von „\fBdpkg \-\-configure \-\-pending\fP“ kann dies später behoben werden.
.TP 
\fB\-r\fP, \fB\-\-remove\fP \fIPaket\fP…|\fB\-a\fP|\fB\-\-pending\fP
Entfernt ein installiertes Paket. Dies entfernt alles außer Conffiles und
anderen Daten, die vom Skript \fIpostrm\fP bereinigt werden, da damit eine
erneute Konfiguration des Paketes vermieden wird, falls es später nochmals
installiert wird. Conffiles sind Konfigurationsdateien, die in der
Steuerdatei \fIDEBIAN/conffiles\fP aufgeführt sind. Falls es keine Steuerdatei
\fIDEBIAN/conffiles\fP oder kein Skript \fIDEBIAN/postrm\fP gibt, ist dieser
Befehl äquivalent zum Aufruf von \fB\-\-purge\fP. Falls statt des Paketnamens
\fB\-a\fP oder \fB\-\-pending\fP angegeben wird, werden alle Pakete, die entpackt,
aber in der Datei \fI%ADMINDIR%/status\fP zur Entfernung vorgemerkt sind,
entfernt.

Entfernung eines Paketes besteht aus den folgenden Schritten:
.br

\fB1.\fP Das \fIprerm\fP\-Skript wird ausgeführt
.br

\fB2.\fP Die installierten Dateien werden entfernt
.br

\fB3.\fP Das \fIpostrm\fP\-Skript wird ausgeführt
.br

.TP 
\fB\-P\fP, \fB\-\-purge\fP \fIPaket\fP…|\fB\-a\fP|\fB\-\-pending\fP
Löscht ein installiertes oder bereits entferntes Paket vollständig. Damit
wird alles entfernt, auch Conffiles und alles, was im Skript \fIpostrm\fP
bereinigt wird. Falls statt des Paketnamens \fB\-a\fP oder \fB\-\-pending\fP
angegeben wird, werden alle Pakete, die entpackt oder entfernt, aber in der
Datei \fI%ADMINDIR%/status\fP zum vollständigen Löschen vorgemerkt sind,
vollständig gelöscht.

Hinweis: Einige Konfigurationsdateien können \fBdpkg\fP nicht bekannt sein, da
sie separat durch die Konfigurationsskripte angelegt und verwaltet
werden. In diesem Fall wird \fBdpkg\fP sie nicht selbst entfernen, sondern das
Skript \fIpostrm\fP (das von \fBdpkg\fP aufgerufen wird) des Pakets muss sich
während des vollständigen Löschens um das Entfernen kümmern. Natürlich
betrifft dies nur Dateien in den Systemverzeichnissen, nicht
Konfigurationsdateien, die in die Home\-Verzeichnisse der individuellen
Benutzer geschrieben werden.

Endgültiges Löschen eines Paketes besteht aus den folgenden Schritten:
.br

\fB1.\fP Das Paket wird entfernt, falls es noch nicht entfernt ist. Lesen Sie
\fB\-\-remove\fP für detaillierte Informationen, wie dies erfolgt.
.br

\fB2.\fP Das \fIpostrm\fP\-Skript wird ausgeführt.
.br
.TP 
\fB\-V\fP, \fB\-\-verify\fP [\fIPaketname\fP …]
Überprüft die Integrität von \fIPaketname\fP oder allen Paketen, falls nicht
angegeben, indem Informationen aus den durch ein Paket installierten Dateien
mit den in der \fBdpkg\fP\-Datenbank gespeicherten Dateimetadateninformationen
verglichen werden (seit Dpkg 1.17.2). Die Quelle der
Dateimetadateninformationen in der Datenbank ist das Binärpaket
selbst. Diese Metadaten werden zum Zeitpunkt des Entpackens während des
Installationsprozesses gesammelt.

Derzeit ist die einzige funktionale Prüfung eine Md5sum\-Überprüfung der
Dateiinhalte mit dem gespeicherten Wert in der Datei\-Datenbank. Er wird nur
geprüft, falls die Datenbank die Md5sum der Datei enthält. Um auf fehlende
Metadaten in der Datenbank zu prüfen, kann der Befehl \fB\-\-audit\fP verwandt
werden.

Das Ausgabeformat kann mit der Option \fB\-\-verify\-format\fP ausgewählt
werden. Standardmäßig wird das Format \fBrpm\fP verwandt. Das kann sich in der
Zukunft aber ändern und daher sollten Programme, die die Ausgabe dieses
Befehls auswerten, explizit das Format angeben, das sie erwarten.
.TP 
\fB\-C\fP, \fB\-\-audit\fP [\fIPaketname\fP …]
Führt Plausibilitäts\- und Konsistenzprüfungen der Datenbank für \fIPaketname\fP
oder alle Pakete, falls das Argument fehlt, durch (pro\-Paket\-Prüfungen seit
Dpkg 1.17.10). Sucht beispielsweise nach Paketen, die auf Ihrem System nur
teilweise installiert wurden oder fehlende, falsche oder veraltete
Steuerdaten oder \-dateien haben. \fBdpkg\fP wird einen Vorschlag machen, was
mit ihnen zur Korrektur gemacht werden sollte.
.TP 
\fB\-\-update\-avail\fP [\fIPackages\-Datei\fP]
.TQ
\fB\-\-merge\-avail\fP [\fIPackages\-Datei\fP]
Aktualisiert \fBdpkg\fPs und \fBdselect\fPs Verständnis darüber, welche Pakete
verfügbar sind. Mit der Aktion \fB\-\-merge\-avail\fP wird alte Information mit
der Information aus der \fIPackages\-Datei\fP zusammengeführt. Mit der Aktion
\fB\-\-update\-avail\fP wird die alte Information durch die Information aus der
\fIPackages\-Datei\fP ersetzt. Die mit Debian vertriebene \fIPackages\-Datei\fP
heißt einfach „\fIPackages\fP“. Falls das Argument \fIPackages\-file\fP fehlt oder
„\fB\-\fP“ benannt ist, wird es aus der Standardeingabe lesen (seit Dpkg
1.17.7). \fBdpkg\fP hält seine Aufzeichnungen über die verfügbaren Pakete in
\fI%ADMINDIR%/available\fP.

Ein einfacher Befehl, um die Datei \fIavailable\fP in einem Rutsch zu holen und
zu aktualisieren, ist \fBdselect update\fP. Beachten Sie, dass diese Datei
nahezu nutzlos ist, falls Sie nicht \fBdselect\fP sondern eine APT\-basierte
Oberfläche verwenden: APT verfügt über sein eigenes System, die verfügbaren
Pakete zu überwachen.
.TP 
\fB\-A\fP, \fB\-\-record\-avail\fP \fIPaketdatei\fP …
Aktualisiert mit den Informationen aus dem Paket \fIPaketdatei\fP \fBdpkg\fPs und
\fBdselect\fPs Verständnis darüber, welche Pakete verfügbar sind. Falls die
Option \fB\-\-recursive\fP oder \fB\-R\fP angegeben ist, muss sich \fIPaketdatei\fP
stattdessen auf ein Verzeichnis beziehen.
.TP 
\fB\-\-forget\-old\-unavail\fP
Jetzt \fBveraltet\fP und ohne Funktion, da \fBdpkg\fP automatisch nicht
installierte nicht verfügbare Pakete vergisst (seit Dpkg 1.15.4). Allerdings
nur solche, die keine Benutzerinformationen enthalten, wie Paketauswahlen.
.TP 
\fB\-\-clear\-avail\fP
Löscht die existierenden Informationen darüber, welche Pakete verfügbar
sind.
.TP 
\fB\-\-get\-selections\fP [\fIPaket\-Name\-Muster\fP …]
Holt die Liste von Paketauswahlen und schreibt sie in die
Standardausgabe. Ohne Muster werden nicht\-installierte Pakete (d.h. solche,
die vorher „vollständig gelöscht“ wurden) nicht angezeigt.
.TP 
\fB\-\-set\-selections\fP
Setzt die Paketauswahl durch Einlesen einer Datei von der
Standardeingabe. Diese Datei sollte im Format „\fIPaket\fP \fIZustand\fP“ sein,
wobei Zustand einer aus \fBinstall\fP, \fBhold\fP, \fBdeinstall\fP oder \fBpurge\fP
ist. Leerzeilen und Kommentarzeilen (beginnend mit ‚\fB#\fP’) sind auch
erlaubt.

Die Datei \fIavailable\fP muss für diesen Befehl aktuell sein, damit dies
Nutzen hat, andernfalls werden unbekannte Pakete mit einer Warnung
ignoriert. Siehe die Befehle \fB\-\-update\-avail\fP und \fB\-\-merge\-avail\fP für
weitere Informationen.
.TP 
\fB\-\-clear\-selections\fP
Setzt den erbetenen Zustand von jedem nicht\-essenziellen Paket auf
„Deinstallation“ (seit Dpkg 1.13.18). Dies ist dazu gedacht, direkt vor
\fB\-\-set\-selections\fP verwendet zu werden, um jedes Paket, das nicht in der
Liste von \fB\-\-set\-selections\fP vorkommt, zu deinstallieren.
.TP 
\fB\-\-yet\-to\-unpack\fP
Sucht nach Paketen, die zur Installation ausgewählt wurden, die aber aus
irgendeinem Grund noch nicht installiert wurden.
.IP
Beachten Sie: Dieser Befehl verwendet sowohl die Datei „available“ als auch
die Paketauswahlen.
.TP 
\fB\-\-predep\-package\fP
Gibt ein einzelnes Paket aus, das das Ziel einer oder mehrerer relevanter
Vorabhängigkeiten ist und selbst keine unerfüllten Vorabhängigkeiten hat.
.IP
Falls ein solches Paket vorhanden ist, wird es als Dateieintrag für
„Packages“ ausgegeben, der passend weiterverarbeitet werden kann.
.IP
Beachten Sie: Dieser Befehl verwendet sowohl die Datei „available“ als auch
die Paketauswahlen.
.IP
Liefert 0 zurück, wenn ein Paket ausgegeben wird und 1, wenn kein passendes
Paket verfügbar ist und 2 im Fehlerfall.
.TP 
\fB\-\-add\-architecture \fP\fIArchitektur\fP
Fügt \fIArchitektur\fP zu der Liste von Architekturen hinzu, für die Pakete
ohne die Verwendung von \fB\-\-force\-architecture\fP installiert werden können
(seit Dpkg 1.16.2). Die Architektur, für die \fBdpkg\fP gebaut wurde (d.h. die
Ausgabe von \fB\-\-print\-architecture\fP), ist immer Teil der Liste.
.TP 
\fB\-\-remove\-architecture \fP\fIArchitektur\fP
Entfernt \fIArchitektur\fP von der Liste von Architekturen, für die Pakete ohne
die Verwendung von \fB\-\-force\-architecture\fP installiert werden können (seit
Dpkg 1.16.2). Falls die Architektur derzeit in der Datenbank benutzt wird,
dann wird die Durchführung verweigert, falls nicht \fB\-\-force\-architecture\fP
verwandt wird. Die Architektur, für die \fBdpkg\fP gebaut wurde (d.h. die
Ausgabe von \fB\-\-print\-architecture\fP), kann niemals von der Liste entfernt
werden.
.TP 
\fB\-\-print\-architecture\fP
Gibt die Architektur der Pakete aus, die \fBdpkg\fP installiert (beispielsweise
„i386“).
.TP 
\fB\-\-print\-foreign\-architectures\fP
Gibt eine durch Zeilenumbrüche getrennte Liste von zusätzlichen
Architekturen aus, für die \fBdpkg\fP konfiguriert ist, Paketinstallationen zu
erlauben (seit Dpkg 1.16.2).
.TP 
\fB\-\-assert\-\fP\fIFunktionalität\fP
Bestätigt, dass \fBdpkg\fP die erbetene Funktionalität unterstützt. Liefert 0,
falls die Funktionalität voll unterstützt wird, 1, falls die Funktionalität
bekannt ist, aber noch keine Unterstützung dafür geliefert werden kann und
2, falls die Funktionalität unbekannt ist. Die aktuelle Liste von
bestätigbaren Funktionalitäten ist wie folgt:
.RS
.TP 
\fBsupport\-predepends\fP
Unterstützt das Feld \fBPre\-Depends\fP (seit Dpkg 1.1.0).
.TP 
\fBworking\-epoch\fP
Unterstützt Epochen in Versionszeichenketten (seit Dpkg 1.4.0.7).
.TP 
\fBlong\-filenames\fP
Unterstützt in \fBdeb\fP(5)\-Archiven lange Dateinamen (seit Dpkg 1.4.1.17).
.TP 
\fBmulti\-conrep\fP
Unterstützt mehrere \fBConflicts\fP und \fBReplaces\fP (seit Dpkg 1.4.1.19).
.TP 
\fBmulti\-arch\fP
Unterstützt Multi\-Arch\-Felder und deren Semantik (seit Dpkg 1.16.2).
.TP 
\fBversioned\-provides\fP
Unterstützt versionierte \fBProvides\fP (seit Dpkg 1.17.11).
.RE
.TP 
\fB\-\-validate\-\fP\fISachenzeichenkette\fP
Bestätigt, dass die \fISachenzeichenkette\fP eine korrekte Syntax hat (seit
Dpkg 1.18.16). Liefert 0 zurück, falls die \fIZeichenkette\fP gültig ist, 1
falls die \fIZeichenkette\fP ungültig ist, aber in lockeren Umgebungen
akzeptiert werden könnte und 2, falls die \fIZeichenkette\fP ungültig ist. Die
aktuelle Liste der überprüfbaren \fISachen\fP ist:
.RS
.TP 
\fBpkgname\fP
Überprüft den übergebenen Paketnamen (seit Dpkg 1.18.16).
.TP 
\fBtrigname\fP
Überprüft den übergebenen Triggernamen (seit Dpkg 1.18.16).
.TP 
\fBarchname\fP
Überprüft den übergebenen Architekturnamen (seit Dpkg 1.18.16).
.TP 
\fBversion\fP
Überprüft die übergebene Version (seit Dpkg 1.18.16).
.RE
.TP 
\fB\-\-compare\-versions \fP\fIVer1 Op Ver2\fP
.\" .TP
.\" .B \-\-command\-fd \fIn\fP
.\" Accept a series of commands on input file descriptor \fIn\fP. Note:
.\" additional options set on the command line, and through this file descriptor,
.\" are not reset for subsequent commands executed during the same run.
Vergleicht Versionsnummern, wobei \fIOp\fP ein binärer Operator ist. \fBdpkg\fP
liefert wahr (\fB0\fP), falls die angegebene Bedingung erfüllt ist und falsch
(\fB1\fP) andernfalls. Es gibt zwei Gruppen von Operatoren, die sich in der
Behandlung von leeren \fIVer1\fP oder \fIVer2\fP unterscheiden. Die folgenden
behandeln leere Versionen als jünger als jede andere Version: \fBlt le eq ne
ge gt\fP. Die folgenden behandeln eine leere Version als älter als jede
Version: \fBlt\-nl le\-nl ge\-nl gt\-nl\fP. Die folgenden sind nur aus
Kompatibilität zu der Steuerdateisyntax bereitgestellt: \fB< <<
<= = >= >> >\fP. Die Operatoren \fB<\fP und \fB>\fP sind
obsolet und sollten \fBnicht\fP verwandt werden, da ihre Semantik verwirrend
ist. Beispielsweise ergibt \fB0.1 < 0.1\fP wahr.
.TP 
\fB\-?\fP, \fB\-\-help\fP
Zeigt eine kurze Hilfenachricht an.
.TP 
\fB\-\-force\-help\fP
Gibt Hilfe zu den Optionen \fB\-\-force\-\fP\fISache\fP aus.
.TP 
\fB\-Dh\fP, \fB\-\-debug=help\fP
Gibt Hilfe zu Fehlersuchoptionen aus.
.TP 
\fB\-\-version\fP
Zeigt \fBdpkg\fP Versionsinformationen an.
.TP 
\fBdpkg\-deb\-Aktionen\fP
Lesen Sie \fBdpkg\-deb\fP(1) für weitere Informationen über die folgenden
Aktionen.

.nf
\fB\-b\fP, \fB\-\-build\fP \fIVerzeichnis\fP [\fIArchiv\fP|\fIVerzeichnis\fP]
    Baut ein deb\-Paket.
\fB\-c\fP, \fB\-\-contents\fP \fIArchiv\fP
    Listet den Inhalt eines deb\-Paketes auf.
\fB\-e\fP, \fB\-\-control\fP \fIArchiv\fP [\fIVerzeichnis\fP]
    Entpackt Steuerinformationen von einem Paket.
\fB\-x\fP, \fB\-\-extract\fP \fIArchiv Verzeichnis\fP
    Entpackt die vom Paket enthaltenen Dateien.
\fB\-f\fP, \fB\-\-field\fP \fIArchiv\fP [\fISteuerfeld\fP] …
    Zeigt das/die Steuerfeld(er) eines Paketes an.
\fB\-\-ctrl\-tarfile\fP \fIArchive\fP
    Gibt die von einem Debian\-Paket enthaltene Steuer\-Tar\-Datei aus.
\fB\-\-fsys\-tarfile\fP \fIArchiv\fP
    Gibt die von einem Debian\-Paket enthaltene Dateisystem\-Tar\-Datei aus.
\fB\-I\fP, \fB\-\-info\fP \fIArchiv\fP [\fISteuerdatei\fP …]
    Zeigt Informationen über ein Paket.
.fi

.TP 
\fBdpkg\-query\-Aktionen\fP
Lesen Sie \fBdpkg\-query\fP(1) für weitere Informationen über die folgenden
Aktionen.

.nf

\fB\-l\fP, \fB\-\-list\fP \fIPaketnamen\-Muster\fP …
    Listet auf das übergebene Suchmuster passende Pakete auf.
\fB\-s\fP, \fB\-\-status\fP \fIPaketname\fP …
    Meldet den Status des angegebenen Pakets.
\fB\-L\fP, \fB\-\-listfiles\fP \fIPaketname\fP …
    Listet die aus \fBPaketname\fP auf Ihrem System installierten Dateien auf.
\fB\-S\fP, \fB\-\-search\fP \fIDateinamen\-Suchmuster\fP …
    Sucht nach einem Dateinamen in installierten Paketen.
\fB\-p\fP, \fB\-\-print\-avail\fP \fIPaketname\fP
    Zeigt Details über \fIPaketname\fP, wie in \fI%ADMINDIR%/available\fP
    gefunden. Benutzer von APT\-basierten Oberflächen sollten stattdessen
    \fBapt\-cache show\fP \fIPaketname\fP verwenden.
.fi
.
.SH OPTIONEN
Alle Optionen können auf der Befehlszeile, in der
\fBdpkg\fP\-Konfigurationsdatei \fI%PKGCONFDIR%/dpkg.cfg\fP oder Fragmentdateien
(mit Namen, die auf das Shell\-Muster ‚[0\-9a\-zA\-Z_\-]*’ passen) in den Dateien
im Konfigurationsverzeichnis \fI%PKGCONFDIR%/dpkg.cfg.d/\fP angegeben
werden. Jede Zeile in der Konfigurationsdatei ist entweder eine Option
(exakt die gleiche wie die Befehlszeilenoption, nur ohne führende
Bindestriche) oder ein Kommentar (falls sie mit ‚\fB#\fP’ beginnt).
.br
.TP 
\fB\-\-abort\-after=\fP\fIZahl\fP
Ändert, nach wie vielen Fehlern \fBdpkg\fP abbrechen wird. Der Standardwert ist
50.
.TP 
\fB\-B\fP, \fB\-\-auto\-deconfigure\fP
Wenn ein Paket entfernt wird, besteht die Möglichkeit, dass ein anderes
installiertes Paket von dem entfernten Paket abhängt. Die Angabe dieser
Option führt zur automatischen Dekonfiguration des Paketes, das von dem
entfernten Paket abhängt.
.TP 
\fB\-D\fP\fIOktal\fP\fB, \-\-debug=\fP\fIOktal\fP
Schaltet Fehlersuche ein. \fIOktal\fP wird durch bitweise Oder\-Verknüpfung der
gewünschten Werte aus der nachfolgenden Liste gebildet (beachten Sie, dass
sich diese Werte in zukünftigen Veröffentlichungen verändern können). \fB\-Dh\fP
oder \fB\-\-debug=help\fP zeigen diese Fehlersuchwerte an.

  Nummer  Beschreibung
      1   Allgemein hilfreiche Fortschrittsinformationen
      2   Aufruf und Status der Betreuerskripte
     10   Ausgabe für jede verarbeitete Datei
    100   Umfangreiche Ausgabe für jede verarbeitete Datei
     20   Ausgabe für jede Konfigurationsdatei
    200   Umfangreiche Ausgabe für jede Konfigurationsdatei
     40   Abhängigkeiten und Konflikte
    400   Umfangreiche Abhängigkeiten/Konflikte\-Ausgabe
  10000   Trigger\-Aktivierung und \-Verarbeitung
  20000   Umfangreiche Ausgabe bezüglich Trigger
  40000   Alberne Menge an Ausgabe bezüglich Trigger
   1000   Umfangreiches Gelaber beispielsweise über das dpkg/info\-Verzeichnis
   2000   Verrückte Mengen an Gelaber
.TP 
\fB\-\-force\-\fP\fISachen\fP
.TQ
\fB\-\-no\-force\-\fP\fISachen\fP, \fB\-\-refuse\-\fP\fISachen\fP
Erzwingt oder verweigert (\fBno\-force\fP und \fBrefuse\fP bedeuten das gleiche)
bestimmte Sachen. \fISachen\fP ist eine Kommata\-getrennte Liste von Dingen, die
im Folgenden beschrieben sind. \fB\-\-force\-help\fP zeigt eine Meldung an, die
diese beschreibt. Mit (*) markierte Dinge werden standardmäßig erzwungen.

\fIWarnung: Diese Optionen sind hauptsächlich für den Einsatz durch Experten
gedacht. Der Einsatz ohne komplettes Verständnis der Effekte kann Ihr
gesamtes System zerstören.\fP

\fBall\fP: Schaltet alle „force“\-Optionen ein (oder aus).

\fBdowngrade\fP(*): Installiert ein Paket, selbst wenn eine neuere Version
davon bereits installiert ist.

\fIWarnung: Derzeit führt \fP\fBdpkg\fP\fI keine Abhängigkeitsüberprüfung bei der
Installation älterer Versionen (als bereits installiert) durch
(sog. Downgrade) und wird Sie daher nicht warnen, falls dadurch die
Abhängigkeit eines anderen Pakets nicht mehr erfüllt ist. Dies kann
ernsthafte Seiteneffekte haben, ein Downgrade einer essenziellen
Systemkomponente kann Ihr gesamtes System unbrauchbar machen. Verwenden Sie
diese Option mit Vorsicht.\fP

\fBconfigure\-any\fP: Konfiguriert auch jedes entpackte, aber unkonfigurierte
Paket, von dem das aktuelle Paket abhängt.

\fBhold\fP: Erlaubt automatische Installationen, Upgrades und Entfernungen von
Paketen, selbst wenn sie mit „halten“ markiert sind: Beachten Sie: Dies
verhindert die Aktionen nicht, wenn sie explizit angefordert werden.

\fBremove\-reinstreq\fP: Entfernt ein Paket, selbst falls es defekt ist und zur
Neuinstallation markiert ist. Dies kann beispielsweise dazu führen, dass
Teile des Pakets auf dem System bleiben und von \fBdpkg\fP vergessen werden.

\fBremove\-essential\fP: Entfernt, selbst falls das Paket als essenziell
betrachtet wird. Essenzielle Pakete enthalten hauptsächlich sehr
grundlegende Unix\-Befehle. Diese zu entfernen kann dazu führen, dass das
gesamte System nicht mehr arbeitet \- verwenden Sie diese Option daher mit
Vorsicht.

\fBdepends\fP: Verwandelt alle Abhängigkeitsprobleme in Warnungen. Dies
betrifft die Felder \fBPre\-Depends\fP und \fBDepends\fP.

\fBdepends\-version\fP: Ignoriert Versionen bei der Prüfung von
Abhängigkeiten. Dies betrifft die Felder \fBPre\-Depends\fP und \fBDepends\fP.

\fBbreaks\fP: Installiert, selbst falls dies ein anderes Paket beschädigt (seit
Dpkg 1.14.6). Dies betrifft das Feld \fBBreaks\fP.

\fBconflicts\fP: Installiert, selbst wenn es mit einem anderen Paket in
Konflikt steht. Dies ist gefährlich, da dies gewöhnlich dazu führt, dass
einige Dateien überschrieben werden. Dies betrifft das Feld \fBConflicts\fP.

\fBconfmiss\fP: Installiert die fehlende Conffile immer ohne Rückfrage. Dies
ist gefährlich, da es bedeutet, dass eine Änderung (die Entfernung) an der
Datei nicht erhalten wird.

\fBconfnew\fP: Falls eine Conffile modifiziert wurde und sich die Version im
Paket geändert hat, wird immer die neue Version ohne Rückfrage installiert,
es sei denn, \fB\-\-force\-confdef\fP ist ebenfalls angegeben, in welchem Falle
die Standardaktion bevorzugt wird.

\fBconfold\fP: Falls eine Conffile modifiziert wurde und sich die Version im
Paket geändert hat, wird immer die alte Version ohne Rückfrage behalten, es
sei denn, \fB\-\-force\-confdef\fP ist ebenfalls angegeben, in welchem Falle die
Standardaktion bevorzugt wird.

\fBconfdef\fP: Falls eine Conffile verändert wurde und sich die Version im
Paket geändert hat, wird immer die Standardaktion ohne Rückfrage
gewählt. Falls es keine Standardaktion gibt, wird angehalten, um den
Benutzer zu fragen, es sei denn, \fB\-\-force\-confnew\fP oder \fB\-\-force\-confold\fP
sind ebenfalls angegeben, in welchem Falle dies verwendet wird, um die
letztendliche Aktion zu bestimmen.

\fBconfask\fP: Falls eine Conffile verändert wurde, wird immer angeboten, sie
durch die Version aus dem Paket zu ersetzen, selbst falls sich die Version
in dem Paket nicht geändert hat (seit Dpkg 1.15.8). Falls auch einer von
\fB\-\-force\-confnew\fP, \fB\-\-force\-confold\fP oder \fB\-\-force\-confdef\fP angegeben
wird, wird sie dazu verwandt, die letztendliche Aktion zu ermitteln.

\fBoverwrite\fP: Überschreibt die Datei aus einem Paket mit einer Datei aus
einem anderen Paket.

\fBoverwrite\-dir\fP: Überschreibt das Verzeichnis aus einem Paket mit einer
Datei aus einem anderen Paket.

\fBoverwrite\-diverted\fP: Überschreibt eine umgeleitete („diverted“) Datei mit
einer nicht umgeleiteten.

\fBstatoverride\-add\fP: Überschreibt eine existierende Status\-Hinwegsetzung
beim Hinzufügen (seit Dpkg 1.19.5).

\fBstatoverride\-remove\fP: Ignoriert eine fehlende Status\-Hinwegsetzung beim
Entfernen (seit Dpkg 1.19.5).

\fBsecurity\-mac\fP(*): Verwendet plattformspezifische „Mandatory Access Control
(MAC)“\-basierende Sicherheit bei der Installation von Dateien in das
Dateisystem (seit Dpkg 1.19.5). Auf Linux\-Systemen verwendet die
Implementierung SELinux.

\fBunsafe\-io\fP: Führt beim Entpacken keine sicheren E/A\-Aktionen durch (seit
Dpkg 1.15.8.6). Derzeit impliziert dies, dass vor Dateiumbenennungen kein
Systemsync durchgeführt wird. Dieser Sync führt bei einigen Dateisystemen zu
erheblichen Leistungseinbußen, unglücklicherweise bei solchen, die überhaupt
sichere E/A aufgrund ihres unzuverlässigen Verhaltens benötigen, auf denen
bei abrupten Systemabstürzen Dateien der Länge Null entstehen können.

\fIHinweis\fP: Für den Hauptmissetäter Ext4 sollten Sie stattdessen die
Einhängeoption \fBnodelalloc\fP verwenden, die sowohl die Leistungseinbuße
verhindert als auch Datensicherheitsprobleme vermeidet. Letzteres bedeutet,
dass bei abrupten Systemabstürzen bei jeder Software, die keine Syncs vor
atomaren Umbenennungen durchführt, keine Dateien der Länge Null generiert
werden.

\fIWarnung: Die Verwendung dieser Option kann die Leistung erhöhen,
allerdings können dabei Daten verloren gehen. Verwenden Sie die Option
vorsichtig.\fP

\fBscript\-chrootless\fP: Führt Skripte aus, ohne per \fBchroot\fP(2) in das
\fBinstdir\fP zu wechseln, selbst falls das Paket diese Vorgehensweise nicht
unterstützt (seit Dpkg 1.18.5).

\fIWarnung: Dies kann Ihr Wirtsystem beschädigen, passen Sie sehr gut auf!\fP

\fBarchitecture\fP: Verarbeitet sogar Pakete mit der falschen oder keiner
Architektur.

\fBbad\-version\fP: Verarbeitet sogar Pakete mit falschen Versionen (seit Dpkg
1.16.1).

\fBbad\-path\fP: Im \fBPATH\fP fehlen wichtige Programme, daher sind Probleme
wahrscheinlich.

\fBnot\-root\fP: Versucht Sachen zu (de)installieren, selbst falls nicht root.

\fBbad\-verify\fP: Installiert ein Paket, selbst wenn die Authentizitätsprüfung
fehlschlägt.

.TP 
\fB\-\-ignore\-depends\fP=\fIPaket\fP, …
Ignoriert Abhängigkeitsüberprüfungen für bestimmte Pakete (tatsächlich wird
die Überprüfung durchgeführt, aber nur Warnungen über Konflikte werden
angezeigt, sonst nichts). Dies betrifft die Felder \fBPre\-Depends\fP,
\fBDepends\fP und \fBBreaks\fP.
.TP 
\fB\-\-no\-act\fP, \fB\-\-dry\-run\fP, \fB\-\-simulate\fP
Erledigt alles, was gemacht werden soll, aber schreibt keine
Änderungen. Dies wird verwendet, um zu sehen, was mit der spezifizierten
Änderung passieren würde, ohne tatsächlich etwas zu modifizieren.

Stellen Sie sicher, dass \fB\-\-no\-act\fP vor dem Aktions\-Parameter steht,
andernfalls könnte dies zu unerwünschten Ergebnissen führen. (Beispielsweise
wird \fBdpkg \-\-purge foo \-\-no\-act\fP zuerst das Paket foo bereinigen und dann
versuchen, das Paket \-\-no\-act zu bereinigen, obwohl Sie wahrscheinlich davon
ausgingen, dass tatsächlich gar nichts passieren sollte)
.TP 
\fB\-R\fP, \fB\-\-recursive\fP
Behandelt rekursiv alle regulären Dateien, die auf das Muster \fB*.deb\fP
passen und im angegeben Verzeichnis sowie allen Unterverzeichnissen
liegen. Dies kann mit den Aktionen \fB\-i\fP, \fB\-A\fP, \fB\-\-install\fP, \fB\-\-unpack\fP
und \fB\-\-record\-avail\fP verwendet werden.
.TP 
\fB\-G\fP
Installiert ein Paket nicht, falls bereits eine neuere Version des gleichen
Paketes installiert ist. Dies ist ein Alias für \fB\-\-refuse\-downgrade\fP.
.TP 
\fB\-\-admindir=\fP\fIVerz\fP
Setzt das Standardadministrationsverzeichnis auf \fIVerzeichnis\fP. Dieses
Verzeichnis enthält viele Dateien, die Informationen über den Status von
installierten und deinstallierten Paketen usw. enthalten. Standardmäßig
„\fI%ADMINDIR%\fP“.
.TP 
\fB\-\-instdir=\fP\fIVerz\fP
Setzt das voreingestellte Installationsverzeichnis. Dieses Verzeichnis gibt
an, wo Pakete installiert werden. \fBinstdir\fP ist auch das Verzeichnis, das
an \fBchroot\fP(2) vor dem Aufruf der Installationsskripte des Paketes
übergeben wird, was bedeutet, dass die Skripte \fBinstdir\fP als ein
Wurzelverzeichnis sehen. Standardmäßig „\fI/\fP“.
.TP 
\fB\-root=\fP\fIVerz\fP
Setzt das Wurzelverzeichnis auf \fIVerzeichnis\fP, wodurch das
Installationsverzeichnis auf „\fIVerz\fP“ und das administrative Verzeichnis
auf „\fIVerz\fP\fB%ADMINDIR%\fP“ gesetzt wird.
.TP 
\fB\-O\fP, \fB\-\-selected\-only\fP
Bearbeitet nur die Pakete, die zur Installation ausgewählt sind. Die
eigentliche Markierung erfolgt mit \fBdselect\fP oder durch \fBdpkg\fP, wenn es
Pakete bearbeitet. Beispielsweise wird ein Paket bei der Entfernung als „zur
Deinstallation ausgewählt“ markiert.
.TP 
\fB\-E\fP, \fB\-\-skip\-same\-version\fP
Installiert das Paket nicht, falls die gleiche Version des Pakets bereits
installiert ist.
.TP 
\fB\-\-pre\-invoke=\fP\fIBefehl\fP
.TQ
\fB\-\-post\-invoke=\fP\fIBefehl\fP
Setzt einen Aufruf\-Hook \fIBefehl\fP, der via „sh \-c“ vor oder nach dem
\fBdpkg\fP\-Aufruf der \fBdpkg\fP\-Aktionen \fIunpack\fP, \fIconfigure\fP, \fIinstall\fP,
\fItriggers\-only\fP, \fIremove\fP, \fIpurge\fP, \fIadd\-architecture\fP und
\fIremove\-architecture\fP ausgeführt wird (seit Dpkg 1.15.4; Aktionen
\fIadd\-architecture\fP und \fIremove\-architecture\fP seit Dpkg 1.17.19). Diese
Option kann mehrfach angegeben werden. Die Reihenfolge der Optionen wird
erhalten, wobei Einträge aus den Konfigurationsdateien Vorrang haben. Die
Umgebungsvariable \fBDPKG_HOOK_ACTION\fP wird für die Hooks auf die aktuelle
\fBdpkg\fP\-Aktion gesetzt. Hinweis: Oberflächen könnten \fBdpkg\fP mehrere Male
pro Ausführung aufrufen, wodurch die Hooks öfter als erwartet ausgeführt
werden könnten.
.TP 
\fB\-\-path\-exclude=\fP\fIGlob\-Muster\fP
.TQ
\fB\-\-path\-include=\fP\fIGlob\-Muster\fP
Setzt \fIGlob\-Muster\fP als Pfadfilter, entweder durch Ausschluss oder durch
Wiedereinschluss vorher ausgeschlossener Pfade, die während der Installation
auf bestimmte Muster passen (seit Dpkg 1.15.8).

\fIWarnung: Beachten Sie, dass abhängig von den ausgeschlossenen Pfaden Sie
Ihr System komplett beschädigen könnten. Verwenden Sie dies daher
vorsichtig.\fP

Das Glob\-Muster kann die gleichen Platzhalter wie in der Shell verwenden,
wobei ‚*’ auf eine beliebige Folge von Zeichen, auch dem Leerzeichen und
‚/’, passt. Beispielsweise passt „\fI/usr/*/READ*\fP“ auf
„\fI/usr/share/doc/package/README\fP“. Wie gewöhnlich passt ‚?’ auf ein
einzelnes Zeichen (wieder auch auf ‚/’). Und ‚[’ beginnt eine Zeichenklasse,
die eine Liste von Zeichen, Bereiche und Komplemente enthalten kann. Lesen
Sie \fBglob\fP(7) für detaillierte Informationen über das Globben. Hinweis:
Aktuelle Implementierungen könnten mehr Verzeichnisse und symbolische Links
als benötigt wieder einschließen. Um auf der sicheren Seite zu sein und in
der Zukunft mögliche Entpackfehler zu vermeiden, könnte dies durch
zukünftige Arbeiten behoben werden.

Dies kann dazu verwandt werden, alle Pfade außer bestimmten zu entferen, ein
typischer Fall lautet:

.nf
\fB\-\-path\-exclude=/usr/share/doc/*\fP
\fB\-\-path\-include=/usr/share/doc/*/copyright\fP
.fi

Hiermit werden alle Dokumentationsdateien (außer den Copyright\-Dateien)
entfernt.

Diese zwei Optionen können mehrfach angegeben und miteinander verschachtelt
werden. Beide werden in der angegebenen Reihenfolge ausgewertet, wobei die
letzte Regel, die auf eine Datei passt, die Entscheidung fällt.

Die Filter werden beim Entpacken des Binärpakets angewandt und haben daher
nur Wissen über den Typ des derzeit gefilterten Objekts (d.h. eine normale
Datei oder ein Verzeichnis) und sehen daher nicht, welche Objekte als
nächstes kommen. Da diese Filter Seiteneffekte haben (im Gegensatz zu
\fBfind\fP(1)\-Filtern) wird das Ausschließen eines genauen Pfadnamens, der ein
Verzeichnisobjekt wie \fI/usr/share/doc\fP ist, nicht den gewünschten Effekt
haben und nur der Pfadname wird ausgeschlossen (der automatisch wieder
eingeschlossen werden könnte, falls der Code eine Notwendigkeit hierfür
sieht). Alle folgenden Dateien innerhalb des Verzeichnisses werden beim
Entpacken fehlschlagen.

Tipp: Stellen Sie sicher, dass die Metazeichen nicht durch Ihre Shell
expandiert werden.
.TP 
\fB\-\-verify\-format=\fP\fIFormatname\fP
Setzt das Ausgabeformat für den Befehl \fB\-\-verify\fP (seit Dpkg 1.17.2).

Derzeit wird nur das Ausgabeformat \fBrpm\fP unterstützt. Es besteht aus einer
Zeile für jeden Pfad, der bei der Prüfung fehlschlug. Die Zeilen starten mit
9 Zeichen, um die Ergebnisse jeder angegebenen Prüfung zu melden. Ein ‚\fB?\fP’
impliziert, dass die Prüfung nicht durchgeführt werden konnte (keine
Unterstützung dafür, Dateirechte usw.). ‚\fB.\fP’ impliziert, dass die Prüfung
erfolgreich durchgeführt wurde und ein alphanumerisches Zeichen impliziert,
dass eine angegebene Prüfung fehlschlug. Der Md5sum\-Überprüfungsfehlschlag
(die Dateiinhalte haben sich geändert) wird durch ein ‚\fB5\fP’ als drittes
Zeichen angezeigt. Der Zeile folgt ein Leerzeichen und ein Attributszeichen
(derzeit ‚\fBc\fP’ für Conffiles), ein weiteres Leerzeichen und der Pfadnmae.
.TP 
\fB\-\-status\-fd \fP\fIn\fP
Schickt maschinenlesbare Paketstatus\- und Fortschrittsinformationen an den
Dateideskriptor \fIn\fP. Diese Option kann mehrfach angegeben werden. Die
Information besteht typischerweise aus einem Datensatz pro Zeile in
folgendem Format:
.RS
.TP 
\fBstatus: \fP\fIPaket\fP\fB: \fP\fIStatus\fP
Paketstatus geändert; \fIStatus\fP entsprechend der Statusdatei.
.TP 
\fBstatus: \fP\fIPaket\fP\fB : error : \fP\fIausführliche\-Fehlermeldung\fP
Ein Fehler ist aufgetreten. Alle möglichen Zeilenumbrüche in
\fIausführliche\-Fehlermeldung\fP werden vor der Ausgabe in Leerzeichen
gewandelt.
.TP 
\fBstatus: \fP\fIDatei\fP\fB : conffile\-prompt : „\fP\fIecht\-alt\fP\fB“ „\fP\fIecht\-neu\fP\fB“ \fP\fIbenutzer\-edit\fP\fB \fP\fIdist\-edit\fP
Dem Benutzer wird eine Conffile\-Frage gestellt.
.TP 
\fBprocessing: \fP\fIStufe\fP\fB: \fP\fIPaket\fP
Versendet genau bevor eine Verarbeitungsstufe beginnt. \fIStufe\fP ist eine der
folgenden: \fBupgrade\fP, \fBinstall\fP (beide werden vor dem Entpacken versandt),
\fBconfigure\fP, \fBtrigproc\fP, \fBdisappear\fP, \fBremove\fP, \fBpurge\fP.
.RE
.TP 
\fB\-\-status\-logger\fP=\fIBefehl\fP
Schickt maschinenlesbare Paketstatus\- und Fortschrittsinformationen an die
Standardeingabe des \fIBefehl\fPs der Shell, was dann mittels „sh \-c“
ausgeführt wird (seit Dpkg 1.16.0). Diese Option kann mehrfach angegeben
werden. Das verwandte Ausgabeformat ist identisch zu dem in \fB\-\-status\-fd\fP.
.TP 
\fB\-\-log=\fP\fIDateiname\fP
Protokolliert Statusänderungen und \-aktionen in \fIDateiname\fP statt in das
standardmäßigen \fI%LOGDIR%/dpkg.log\fP. Falls diese Option mehrfach angegeben
ist, wird der letzte Dateiname verwandt. Protokollnachrichten haben die
Form:
.RS
.TP 
YYYY\-MM\-DD HH:MM:SS \fBstartup\fP \fITyp\fP \fIBefehl\fP
Für jeden Dpkg\-Aufruf, wobei \fITyp\fP entweder \fBarchives\fP (mit einem
\fIBefehl\fP \fBunpack\fP oder \fBinstall\fP) oder \fBpackages\fP (mit einem \fIBefehl\fP
\fBconfigure\fP, \fBtriggers\-only\fP, \fBremove\fP oder \fBpurge\fP) ist.
.TP 
YYYY\-MM\-DD HH:MM:SS \fBstatus\fP \fIZustand\fP \fIPkt\fP \fIinstallierte_Version\fP
Für Statusaktualisierungen.
.TP 
YYYY\-MM\-DD HH:MM:SS \fIAktion\fP \fIPkt\fP \fIinstallierte_Version\fP \fIverfügbar_Version\fP
Für Aktionen, wobei \fIAktion\fP eine aus \fBinstall\fP, \fBupgrade\fP, \fBconfigure\fP,
\fBtrigproc\fP, \fBdisappear\fP, \fBremove\fP oder \fBpurge\fP ist.
.TP 
YYYY\-MM\-DD HH:MM:SS \fBconffile\fP \fIDateiname\fP \fIEntscheidung\fP
Für Conffile\-Änderungen, wobei \fIEntscheidung\fP entweder \fBinstall\fP oder
\fBkeep\fP ist.
.RE
.TP 
\fB\-\-no\-pager\fP
Deaktiviert die Verwendung jeglichen Pagers bei der Anzeige von
Informationen (seit Dpkg 1.19.2).
.TP 
\fB\-\-no\-debsig\fP
Versucht nicht, Paketsignaturen zu überprüfen.
.TP 
\fB\-\-no\-triggers\fP
Führt keine Trigger in diesem Durchlauf aus (seit Dpkg
1.14.17). Aktivierungen werden aber dennoch aufgezeichnet. Falls dies mit
\fB\-\-configure\fP \fIPaket\fP oder \fB\-\-triggers\-only\fP \fIPaket\fP verwandt wird, wird
das Postinst des benannten Pakets dennoch ausgeführt, selbst falls nur ein
Trigger\-Lauf notwendig ist. Die Verwendung dieser Option kann Pakete in die
unzulässigen Zustände \fBtriggers\-awaited\fP und \fBtriggers\-pending\fP
bringen. Durch die Ausführung von „\fBdpkg \-\-configure \-\-pending\fP“ kann dies
später behoben werden.
.TP 
\fB\-\-triggers\fP
Annulliert ein vorheriges \fB\-\-no\-triggers\fP (seit Dpkg 1.14.17).
.
.SH RÜCKGABEWERT
.TP 
\fB0\fP
Die angeforderte Aktion wurde erfolgreich ausgeführt. Oder ein Prüfausdruck
oder eine Zusicherung (Assertion) lieferte Wahr zurück.
.TP 
\fB1\fP
Ein Prüfausdruck oder eine Zusicherung lieferte Falsch zurück.
.TP 
\fB2\fP
Fataler oder nicht behebbarer Fehler aufgrund eines ungültigen
Befehlszeilenaufrufs oder Interaktionen mit dem System, wie Zugriffe auf die
Datenbank, Speicherzuweisungen usw.
.
.SH UMGEBUNG
.SS "Externe Umgebung"
.TP 
\fBPATH\fP
Es wird erwartet, dass diese Variable in der Umgebung gesetzt ist und auf
die Systempfade zeigt, in denen eine Reihe von benötigten Programmen
gefunden werden können. Falls sie nicht gesetzt ist oder die Programme nicht
gefunden werden können, wird \fBdpkg\fP die Bearbeitung abbrechen.
.TP 
\fBHOME\fP
Falls gesetzt, wird \fBdpkg\fP sie als das Verzeichnis verwenden, aus dem die
benutzerspezifische Konfigurationsdatei gelesen wird.
.TP 
\fBTMPDIR\fP
Falls gesetzt, wird \fBdpkg\fP sie als das Verzeichnis verwenden, in dem
temporäre Dateien und Verzeichnisse erstellt werden.
.TP 
\fBSHELL\fP
Das Programm, das \fBdpkg\fP ausführen wird, wenn es eine neue interaktive
Shell startet oder einen Befehl über eine Shell ausführt.
.TP 
\fBPAGER\fP
.TQ
\fBDPKG_PAGER\fP
Das Programm, das \fBdpkg\fP ausführen wird, wenn es einen Pager mit „\fB$SHELL
\-c\fP“ ausführt, beispielsweise zur Anzeige von
Conffile\-Dateiunterschieden. Falls \fBSHELL\fP nicht gesetzt ist, wird
stattdessen „\fBsh\fP“ verwandt. \fBDPKG_PAGER\fP setzt die Umgebungsvariable
\fBPAGER\fP außer Kraft (seit Dpkg 1.19.2).
.TP 
\fBDPKG_COLORS\fP
Setzt den Farbmodus (seit Dpkg 1.18.5). Die derzeit unterstützten Werte
sind: \fBauto\fP (Vorgabe), \fBalways\fP und \fBnever\fP.
.TP 
\fBDPKG_FORCE\fP
Setzt die Erzwingungsschalter (seit Dpkg 1.19.5). Wenn diese Variable
vorhanden ist, werden keine eingebauten Vorgaben für Erzwingungen
angewandt. Falls diese Variable vorhanden, aber leer ist, werden alle
Erzwingungsschalter deaktiviert.
.TP 
\fBDPKG_ADMINDIR\fP
Falls gesetzt und die Option \fB\-\-admindir\fP oder \fB\-\-root\fP nicht verwandt
wurde, wird dies als administratives Verzeichnis von \fBdpkg\fP verwandt (seit
Dpkg 1.20.0).
.TP 
\fBDPKG_FRONTEND_LOCKED\fP
Wird von einer Paketverwalterprogrammoberfläche gesetzt, um Dpkg zu
informieren, dass es nicht die Sperre der Oberfläche erlangen soll (seit
Dpkg 1.19.1).
.SS "Interne Umgebung"
.TP 
\fBLESS\fP
Von \fBdpkg\fP auf „\fB\-FRSXMQ\fP“ definiert, falls es nicht bereits gesetzt ist
oder wenn ein Pager gestartet wird (seit Dpkg 1.19.2). Um das
Vorgabeverhalten zu verändern, kann diese Variable auf einen anderen Wert
einschließlich der leeren Zeichenkette voreingestellt werden oder die
Variablen \fBPAGER\fP oder \fBDPKG_PAGER\fP können gesetzt werden, um bestimmte
Optionen mit „\fB\-+\fP“ zu deaktivieren, beispielsweise \fBDPKG_PAGER="less
\-+F"\fP.
.TP 
\fBDPKG_ROOT\fP
Durch \fBdpkg\fP in der Betreuerskriptumgebung definiert, um anzuzeigen, auf
welche Installation gehandelt werden soll (seit Dpkg 1.18.5). Der Wert soll
jedem Pfad, auf den Betreuerskripte agieren, vorangestellt werden. Während
des Normalbetriebs ist diese Variable leer. Bei der Installation von Paketen
in ein anderes \fBinstdir\fP wird \fBdpkg\fP normalerweise Betreuerskripte mittels
\fBchroot\fP(2) aufrufen und diese Variable leer lassen. Falls aber
\fB\-\-force\-script\-chrootless\fP angegeben ist, wird dieser \fBchroot\fP(2)\-Aufruf
übersprungen und \fBinstdir\fP ist nicht leer.
.TP 
\fBDPKG_ADMINDIR\fP
Wird von \fBdpkg\fP für die Betreuer\-Skript\-Umgebung gesetzt, um das zu
verwendende administrative Verzeichnis von \fBdpkg\fP anzuzeigen (seit Dpkg
1.16.0). Diese Variable wird immer auf den aktuellen Wert von \fB\-\-admindir\fP
gesetzt.
.TP 
\fBDPKG_FORCE\fP
Wird von \fBdpkg\fP für alle Unterprozessumgebungen auf alle aktuell
aktivierten Erzwingungsoptionennamen (getrennt durch Kommata) gesetzt (seit
Dpkg 1.19.5).
.TP 
\fBDPKG_SHELL_REASON\fP
Wird von \fBdpkg\fP auf der Shell, die von der Conffile\-Eingabeaufforderung
gestartet wird, um die Situation zu analysieren, gesetzt (seit Dpkg
1.15.6). Derzeit gültiger Wert: \fBconffile\-prompt\fP.
.TP 
\fBDPKG_CONFFILE_OLD\fP
Wird von \fBdpkg\fP auf der Shell, die von der Conffile\-Eingabeaufforderung
gestartet wird, um die Situation zu analysieren, gesetzt (seit Dpkg
1.15.6). Enthält den Pfad zu der alten Conffile.
.TP 
\fBDPKG_CONFFILE_NEW\fP
Wird von \fBdpkg\fP auf der Shell, die von der Conffile\-Eingabeaufforderung
gestartet wird, um die Situation zu analysieren, gesetzt (seit Dpkg
1.15.6). Enthält den Pfad zu der neuen Conffile.
.TP 
\fBDPKG_HOOK_ACTION\fP
Wird von \fBdpkg\fP auf der Shell, die beim Ausführen von Hook\-Aktionen
gestartet wird, gesetzt (seit Dpkg 1.15.4). Enthält die aktuelle
\fBdpkg\fP\-Aktion.
.TP 
\fBDPKG_RUNNING_VERSION\fP
Wird von \fBdpkg\fP für die Betreuer\-Skript\-Umgebung auf die Version der
aktuell laufenden Instanz von \fBdpkg\fP gesetzt (seit Dpkg 1.14.17).
.TP 
\fBDPKG_MAINTSCRIPT_PACKAGE\fP
Wird von \fBdpkg\fP für die Betreuer\-Skript\-Umgebung auf den in Arbeit
befindlichen (nicht architekturspezifizierte) Paketnamen gesetzt (seit Dpkg
1.14.17).
.TP 
\fBDPKG_MAINTSCRIPT_PACKAGE_REFCOUNT\fP
Wird von \fBdpkg\fP für die Betreuer\-Skript\-Umgebung auf die Paketreferenzzahl
gesetzt, d.h. die Anzahl der Paketinstanzen mit einem Status größer als
\fBnot\-installed\fP (seit Dpkg 1.17.2).
.TP 
\fBDPKG_MAINTSCRIPT_ARCH\fP
Wird von \fBdpkg\fP für die Betreuer\-Skript\-Umgebung auf die Architektur
gesetzt, für die das Paket gebaut wurde (seit Dpkg 1.15.4).
.TP 
\fBDPKG_MAINTSCRIPT_NAME\fP
Wird von \fBdpkg\fP für die Betreuer\-Skript\-Umgebung auf den Namen des
laufenden Skripts definiert, eines von \fBpreinst\fP, \fBpostinst\fP, \fBprerm\fP
oder \fBpostrm\fP (seit Dpkg 1.15.7).
.TP 
\fBDPKG_MAINTSCRIPT_DEBUG\fP
Wird von \fBdpkg\fP für die Betreuer\-Skript\-Umgebung auf einen Wert (‚\fB0\fP’
oder ‚\fB1\fP’) gesetzt, der angibt, ob die Fehlersuche (mit der Option
\fB\-\-debug\fP) für die Betreuerskripte angefordert wurde (seit Dpkg 1.18.4).
.
.SH DATEIEN
.TP 
\fI%PKGCONFDIR%/dpkg.cfg.d/[0\-9a\-zA\-Z_\-]*\fP
Konfigurationsfragmentdateien (seit Dpkg 1.15.4).
.TP 
\fI%PKGCONFDIR%/dpkg.cfg\fP
Konfigurationsdatei mit Standardeinstellungen der Optionen.
.TP 
\fI%LOGDIR%/dpkg.log\fP
Standard\-Protokolldatei (lesen Sie \fI%PKGCONFDIR%/dpkg.cfg\fP und die Option
\fB\-\-log\fP).
.P
Die anderen unten aufgeführten Dateien sind in ihren Standardverzeichnissen,
lesen Sie den Text zur Option \fB\-\-admindir\fP, um zu sehen, wie Sie den Ort
dieser Dateien ändern können.
.TP 
\fI%ADMINDIR%/available\fP
Liste der verfügbaren Pakete.
.TP 
\fI%ADMINDIR%/status\fP
Statusse der verfügbaren Pakete. Diese Datei enthält Informationen darüber,
ob ein Paket zur Entfernung markiert ist oder nicht, ob es installiert ist
oder nicht usw. Lesen Sie den Abschnitt \fBINFORMATIONEN ÜBER PAKETE\fP für
weitere Informationen.

Die Statusdatei wird täglich nach \fI/var/backups\fP gesichert. Dies kann
hilfreich sein, falls sie aufgrund von Problemen mit dem Dateisystem
verloren gegangen oder beschädigt worden ist.
.P
Das Format und die Inhalte eines Binärpakets sind in \fBdeb\fP(5) beschrieben.
.
.SH FEHLER
\fB\-\-no\-act\fP gibt gewöhnlich weniger Informationen, als hilfreich sein
könnten.
.
.SH BEISPIELE
Um die installierten Pakete mit Bezug zum Editor \fBvi\fP(1) aufzulisten
(beachten Sie, dass \fBdpkg\-query\fP nicht mehr standardmäßig die Datei
\fIavailable\fP lädt und stattdessen dafür die Option \fBdpkg\-query\fP
\fB\-\-load\-avail\fP verwandt werden sollte):
.br
     \fBdpkg \-l '*vi*'\fP
.br

Um die Einträge von zwei Paketen in \fI%ADMINDIR%/available\fP zu sehen:
.br
     \fBdpkg \-\-print\-avail elvis vim | less\fP
.br

Wenn Sie die Liste der Pakete selbst durchsuchen wollen:
.br
     \fBless %ADMINDIR%/available\fP
.br

Um ein installiertes Elvis\-Paket zu entfernen:
.br
     \fBdpkg \-r elvis\fP
.br

Um ein Paket zu installieren, müssen Sie es erst in einem Archiv oder auf
einer CD\-ROM finden. Die Datei \fIavailable\fP zeigt, dass das vim\-Paket in der
Sektion \fBeditors\fP ist:
.br
     \fBcd /media/cdrom/pool/main/v/vim\fP
     \fBdpkg \-i vim_4.5\-3.deb\fP
.br

Um eine lokale Kopie der Paketauswahl\-Zustände zu erstellen:
.br
     \fBdpkg \-\-get\-selections >meine_auswahl\fP
.br

Sie könnten diese Datei auf einen anderen Rechner übertragen und dann die
Datei \fIavailable\fP dort mit dem Paketverwalter Ihrer Wahl (siehe
https://wiki.debian.org/Teams/Dpkg/FAQ für weitere Details) aktualisieren,
zum Beispiel:
.br
     \fBapt\-cache dumpavail | dpkg \-\-merge\-avail\fP
.br
Oder mit Dpkg 1.17.6 oder älter:
.br
     \fBavail=`mktemp`\fP
     \fBapt\-cache dumpavail >"$avail"\fP
     \fBdpkg \-\-merge\-avail "$avail"\fP
     \fBrm "$avail"\fP
.br
Sie können sie dann wie folgt installieren:
.br
     \fBdpkg \-\-clear\-selections\fP
     \fBdpkg \-\-set\-selections <meine_auswahl\fP
.br

Beachten Sie, dass dies nichts wirklich installiert oder entfernt, sondern
lediglich den Auswahlzustand der angeforderten Pakete setzt. Sie werden eine
andere Anwendung benötigen, um die angeforderten Pakete tatsächlich
herunterzuladen und zu installieren. Führen Sie beispielsweise \fBapt\-get
dselect\-upgrade\fP aus.

Gewöhnlich werden Sie feststellen, dass \fBdselect\fP(1) eine bequemere Art
ist, den Paketauswahlzustand zu ändern.
.br
.
.SH "ZUSÄTZLICHE FUNKTIONALITÄT"
Zusätzliche Funktionalität kann durch die Installation jedes der folgenden
Pakete erhalten werden: \fBapt\fP, \fBaptitude\fP und \fBdebsums\fP.
.
.SH "SIEHE AUCH"
\fBaptitude\fP(1), \fBapt\fP(1), \fBdselect\fP(1), \fBdpkg\-deb\fP(1), \fBdpkg\-query\fP(1),
\fBdeb\fP(5), \fBdeb\-control\fP(5), \fBdpkg.cfg\fP(5) und \fBdpkg\-reconfigure\fP(8).
.
.SH AUTOREN
Lesen Sie \fI%PKGDOCDIR%/THANKS\fP für die Liste der Leute, die zu \fBdpkg\fP
beigetragen haben.
.SH ÜBERSETZUNG
Die deutsche Übersetzung wurde 2004, 2006-2020 von Helge Kreutzmann
<debian@helgefjell.de>, 2007 von Florian Rehnisch <eixman@gmx.de> und
2008 von Sven Joachim <svenjoac@gmx.de>
angefertigt. Diese Übersetzung ist Freie Dokumentation; lesen Sie die
GNU General Public License Version 2 oder neuer für die Kopierbedingungen.
Es gibt KEINE HAFTUNG.
