.\" dpkg manual page - dpkg-checkbuilddeps(1)
.\"
.\" Copyright © 2001 Joey Hess <joeyh@debian.org>
.\" Copyright © 2007-2013, 2015 Guillem Jover <guillem@debian.org>
.\" Copyright © 2008-2011 Raphaël Hertzog <hertzog@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.TH dpkg\-checkbuilddeps 1 "%RELEASE_DATE%" "%VERSION%" "dpkg suite"
.ad l
.nh
.SH NAME
dpkg\-checkbuilddeps \- check build dependencies and conflicts
.
.SH SYNOPSIS
.B dpkg\-checkbuilddeps
.RI [ option ...]
.RI [ control-file ]
.
.SH DESCRIPTION
This program checks the installed packages in the system against the build
dependencies and build conflicts listed in the control file. If any are
not met, it displays them and exits with a nonzero return code.
.P
By default, \fBdebian/control\fR is read, but an alternate control filename
may be specified on the command line.
.
.SH OPTIONS
.TP
.BI \-\-admindir= dir
Change the location of the \fBdpkg\fR database (since dpkg 1.14.0).
The default location is \fI%ADMINDIR%\fP.
.TP
.B \-A
Ignore \fBBuild\-Depends\-Arch\fP and \fBBuild\-Conflicts\-Arch\fP
lines (since dpkg 1.16.4).
Use when only arch-indep packages will be built, or combine with
\fB\-B\fP when only a source package is to be built.
.TP
.B \-B
Ignore \fBBuild\-Depends\-Indep\fP and \fBBuild\-Conflicts\-Indep\fP
lines. Use when only arch-dep packages will be built, or combine with
\fB\-A\fP when only a source package is to be built.
.TP
.B \-I
Ignore built-in build depends and conflicts (since dpkg 1.18.2).
These are implicit dependencies that are usually required on a specific
distribution, the so called Build-Essential package set.
.TP
.BI "\-d " build-depends-string
.TP
.BI "\-c " build-conflicts-string
Use the given build dependencies/conflicts instead of those contained in the
\fIdebian/control\fP file (since dpkg 1.14.17).
.TP
.BI "\-a " arch
Check build dependencies/conflicts assuming that the package described in
the control file is to be built for the given host architecture instead of
the architecture of the current system (since dpkg 1.16.2).
.TP
.BR "\-P " \fIprofile\fP[ , ...]
Check build dependencies/conflicts assuming that the package described
in the control file is to be built for the given build profile(s)
(since dpkg 1.17.2).
The argument is a comma-separated list of profile names.
.TP
.BR \-? ", " \-\-help
Show the usage message and exit.
.TP
.BR \-\-version
Show the version and exit.
.
.SH ENVIRONMENT
.TP
.B DEB_BUILD_PROFILES
If set, it will be used as the active build profile(s) for the package
being built. It is a space separated list of profile names. Overridden
by the \fB\-P\fP option.
.TP
.B DPKG_COLORS
Sets the color mode (since dpkg 1.18.5).
The currently accepted values are: \fBauto\fP (default), \fBalways\fP and
\fBnever\fP.
.TP
.B DPKG_NLS
If set, it will be used to decide whether to activate Native Language Support,
also known as internationalization (or i18n) support (since dpkg 1.19.0).
The accepted values are: \fB0\fP and \fB1\fP (default).
