.\" dpkg manual page - dpkg-deb(1)
.\"
.\" Copyright © 1995-1996 Ian Jackson <ijackson@chiark.greenend.org.uk>
.\" Copyright © 1999 Wichert Akkerman <wakkerma@debian.org>
.\" Copyright © 2006 Frank Lichtenheld <djpig@debian.org>
.\" Copyright © 2007-2015 Guillem Jover <guillem@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH dpkg\-deb 1 %RELEASE_DATE% %VERSION% "suite dpkg"
.ad l
.nh
.SH NOM
dpkg\-deb \- Outil pour la manipulation des archives (.deb) des paquets Debian
.
.SH SYNOPSIS
\fBdpkg\-deb\fP [\fIoptions\fP...] \fIcommande\fP
.
.SH DESCRIPTION
\fBdpkg\-deb\fP crée un paquet, dépaquette une archive ou donne des
renseignements sur les archives Debian
.PP
\fBdpkg\fP sert à installer ou à supprimer des paquets sur le système.
.PP
Il est possible d'exécuter \fBdpkg\-deb\fP en appelant \fBdpkg\fP avec les options
de \fBdpkg\-deb\fP. \fBdpkg\fP comprend que \fBdpkg\-deb\fP est appelé et le lance.
.PP
Pour la plupart des commandes recevant un argument d'entrée d'archive,
l'archive peut être lue à partir de l'entrée standard si le nom d'archive
est donné sous la forme d'un caractère moins («\fB\-\fP») unique\ ; sinon,
l'absence de prise en charge sera documentée dans leurs descriptions de
commande respectives.
.
.SH COMMANDES
.TP 
\fB\-b\fP, \fB\-\-build\fP \fIrépertoire\-binaire\fP [\fIarchive\fP|\fIrépertoire\fP]
Crée une archive Debian avec l'arborescence contenue dans
\fIrépertoire\-binaire\fP. \fIrépertoire\-binaire\fP doit posséder un
sous\-répertoire \fBDEBIAN\fP qui contient les fichiers de contrôle tels que le
fichier «\ control\ » lui\-même. Ce répertoire \fIn'apparaît pas\fP dans l'archive
de l'arborescence du paquet binaire\ ; mais les fichiers qu'il contient sont
mis dans la zone de contrôle du paquet binaire.

À moins de préciser \fB\-\-nocheck\fP, \fBdpkg\-deb\fP lit \fBDEBIAN/control\fP et
l'analyse. Il cherche dans le fichier les erreurs de syntaxe et d'autres
problèmes existants\ ; puis il affiche le nom du paquet binaire qu'il
construit. \fBdpkg\-deb\fP vérifie aussi les permissions des scripts du
responsable et des autres fichiers qu'il trouve dans le répertoire de
contrôle \fBDEBIAN\fP.

Quand aucune \fIarchive\fP n'est donnée, \fBdpkg\-deb\fP écrit le paquet
dans\fIrépertoire\-binaire\fP\fB.deb\fP.

Si l'archive qui doit être créée existe déjà, elle est remplacée.

Quand le second argument est un répertoire, \fBdpkg\-deb\fP écrira dans le
fichier \fIrépertoire\fP\fB/\fP\fIpaquet\fP\fB_\fP\fIversion\fP\fB_\fP\fIarch\fP\fB.deb\fP. Quand un
répertoire cible est précisé à la place d'un fichier, l'option \fB\-\-nocheck\fP
ne doit pas être utilisée (puisque \fBdpkg\-deb\fP a besoin de lire et
d'analyser le fichier de contrôle du paquet pour connaître le nom de fichier
à utiliser).
.TP 
\fB\-I\fP, \fB\-\-info\fP \fIarchive\fP [\fInom\-fichier\-control\fP...]
Donne des renseignements sur une archive de paquet binaire.

Quand aucun argument \fIfichier\-control\fP n'est précisé, un résumé du contenu
du paquet ainsi que son fichier «\ control\ » sont affichés.

Quand un argument \fIfichier\-control\fP est précisé, \fBdpkg\-deb\fP affiche les
éléments dans l'ordre d'apparition\ ; quand l'un des éléments n'est pas
présent, il affiche un message d'erreur sur «\ stderr\ » et quitte avec un
code égal à \fB2\fP.
.TP 
\fB\-W\fP, \fB\-\-show\fP \fIarchive\fP
Cette option donne des informations sur l'archive d'un paquet binaire selon
le format spécifié par l'argument \fB\-\-showformat\fP. Le format par défaut
affiche le nom et la version du paquet sur une seule ligne, séparés par une
tabulation.
.TP 
\fB\-f\fP, \fB\-\-field\fP \fIarchive\fP [\fInom\-du\-champ\-de\-control\fP...]
Extrait les renseignements du fichier «\ control\ » de l'archive du paquet
binaire.

Quand aucun \fInom\-du\-champ\-de\-control\fP n'est précisé, le fichier «\ control\ »
est affiché en entier.

Quand il y en a un, \fBdpkg\-deb\fP affiche ses éléments en suivant leur ordre
d'apparition dans le fichier «\ control\ ». Quand il y a plus d'un argument
\fInom\-champ\-control\fP, \fBdpkg\-deb\fP fait précéder chacun par le nom de son
champ (puis par un «\ deux\-points\ » et une espace).

L'absence des champs demandés ne provoque pas de message d'erreur.
.TP 
\fB\-c\fP, \fB\-\-contents\fP \fIarchive\fP
Liste la partie arborescence des fichiers d'une archive de paquet. Elle est
actuellement produite dans le format généré par un listing verbeux de
\fBtar\fP.
.TP 
\fB\-x\fP, \fB\-\-extract\fP \fIarchive répertoire\fP
Extrait l'arborescence des fichiers d'un paquet archive dans le répertoire
spécifié.

Il faut remarquer que l'extraction d'un paquet dans le répertoire root \fIne
produit pas\fP une installation correcte\ ! Utilisez \fBdpkg\fP pour
l'installation des paquets.

\fIrépertoire\fP est créé si nécessaire (mais pas ses répertoires parents) et
ses permissions sont modifiées pour correspondre au contenu du paquet.
.TP 
\fB\-X\fP, \fB\-\-vextract\fP \fIarchive répertoire\fP
Comme \fB\-\-extract\fP (\fB\-x\fP) avec \fB\-\-verbose\fP (\fB\-v\fP), ce qui affiche la
liste des fichiers au fur et à mesure qu'ils sont extraits.
.TP 
\fB\-R\fP, \fB\-\-raw\-extract\fP \fIarchive répertoire\fP
Extrait l'arborescence des fichiers d'un paquet archive dans le répertoire
spécifié et les fichiers d'information de contrôle dans un sous\-répertoire
nommé \fBDEBIAN\fP de ce répertoire (depuis dpkg\ 1.16.1).

Le répertoire cible est créé si nécessaire (mais pas ses répertoires
parents).

L'archive d'entrée n'est pas actuellement traitée de façon séquentielle,
aussi, sa lecture à partir de l'entrée standard («\ \fB\-\fP\ ») n'est \fBpas\fP
prise en charge.
.TP 
\fB\-\-ctrl\-tarfile\fP \fIarchive\fP
Extrait les données de contrôle d'un paquet binaire et les envoie sur la
sortie standard dans le format propre à la commande \fBtar\fP (depuis
dpkg\ 1.17.14). En combinant cette option avec la commande \fBtar\fP(1), on peut
ainsi extraire un fichier de contrôle précis d'une archive de
paquet. L'archive d'entrée sera toujours traitée séquentiellement.
.TP 
\fB\-\-fsys\-tarfile\fP \fIarchive\fP
Extrait les données de l'arborescence d'un paquet binaire et les envoie sur
la sortie standard dans le format propre à la commande \fBtar\fP. En combinant
cette option avec la commande \fBtar\fP(1), on peut ainsi extraire un fichier
précis d'une archive de paquet. L'archive d'entrée sera toujours traitée
séquentiellement.
.TP 
\fB\-e\fP, \fB\-\-control\fP \fIarchive\fP [\fIrépertoire\fP]
Extrait les fichiers de contrôle d'une archive de paquet dans le répertoire
spécifié.

Quand aucun répertoire n'est précisé, on utilise un sous\-répertoire
\fBDEBIAN\fP du répertoire actuel.

Le répertoire cible est créé si nécessaire (mais pas ses répertoires
parents).
.TP 
\fB\-?\fP, \fB\-\-help\fP
Affiche un message d'aide puis quitte.
.TP 
\fB\-\-version\fP
Affiche le numéro de version puis quitte.
.
.SH OPTIONS
.TP 
\fB\-\-showformat=\fP\fIformat\fP
Cette option sert à spécifier le format de sortie de l'option \fB\-\-show\fP. Ce
format sera utilisé pour chaque paquet listé.

Cet argument est une chaîne qui peut référencer tout champ avec la forme
«\ ${\fIfield\-name\fP}\ »\ ; une liste des champs valables peut être facilement
produite avec l'option \fB\-I\fP sur le même paquet. Une explication complète
des options de formatage (avec les séquences d'échappement et les espaces
entre les champs) se trouve dans la page \fBdpkg\-query\fP(1), option
\fB\-\-showformat\fP.

Par défaut, la valeur de ce champ est «\ ${Package}\et${Version}\en\ ».
.TP 
\fB\-z\fP\fIniveau_compression\fP
Indique le niveau de compression à fournir au logiciel de compression appelé
en sous\-main lors de la compression du paquet. La valeur par défaut est\ 9
pour gzip et\ 6 pour xz. Les valeurs possibles sont les entiers compris
entre\ 0 et\ 9\ : 0\ correspond à aucune compression pour gzip. Avant la
version\ 1.16.2, la valeur\ 0 correspondait à «\ aucune compression\ » pour tous
les logiciels de compression.
.TP 
\fB\-S\fP\fIstratégie\-compression\fP
Indique la stratégie de compression à fournir au logiciel de compression
appelé en sous\-main lors de la construction du paquet (depuis
dpkg\ 1.16.2). Les valeurs autorisées sont \fBnone\fP (depuis dpkg\ 1.16.4),
\fBfiltered\fP, \fBhuffman\fP, \fBrle\fP et \fBfixed\fP pour gzip (depuis dpkg\ 1.17.0)
et \fBextreme\fP pour xz.
.TP 
\fB\-Z\fP\fItype_compression\fP
Indique le type de compression à utiliser lors de la construction d'un
paquet. Les valeurs autorisées sont \fBgzip\fP, \fBxz\fP (depuis dpkg\ 1.15.6) et
\fBnone\fP (\fBxz\fP est la valeur par défaut).
.TP 
\fB\-\-[no\-]uniform\-compression\fP
Indique que les mêmes paramètres de compression doivent être utilisés pour
tous les membres de l'archive (c'est\-à\-dire \fBcontrol.tar\fP et \fBdata.tar\fP\ ;
depuis dpkg\ 1.17.6). Sinon, seul le membre \fBdata.tar\fP utilisera ces
paramètres. \fBnone\fP, \fBgzip\fP et \fBxz\fP sont les seuls types de compression
pris en charge pour cette option d'uniformité (depuis dpkg\ 1.19.0). La
compression uniforme est l'option par défaut (depuis dpkg\ 1.19.0).
.TP 
\fB\-\-root\-owner\-group\fP
Fixe le propriétaire et le groupe de chaque entrée dans les données de
l'arborescence du système de fichiers à root avec l'identité\ 0 (depuis
dpkg\ 1.19.0).

\fBNote\fP\ : cette option peut être utile pour les constructions sans root
(voir \fIrootless\-builds.txt\fP) mais ne devrait \fBpas\fP être utilisée si les
entrées ont un propriétaire ou un groupe qui n'est pas root. Leur prise en
charge sera ajoutée plus tard sous la forme d'un méta\-manifeste.
.TP 
\fB\-\-deb\-format=\fP\fIformat\fP
Indique la version du format d'archive utilisé lors de la construction
(depuis dpkg\ 1.17.0). Les valeurs autorisées sont \fB2.0\fP pour le nouveau
format et \fB0.939000\fP pour l'ancien (la valeur par défaut est \fB2.0\fP).

L'ancien format d'archive, moins facilement compris par les outils
non\-Debian, est maintenant dépassé. On l'utilise seulement quand on
construit des paquets qui doivent être analysés par des versions de dpkg
plus anciennes que la version\ 0.93.76 (septembre 1995), qui fut produite
uniquement pour le format «\ i386 a.out\ ».
.TP 
\fB\-\-nocheck\fP
Empêche les vérifications normales de \fBdpkg\-deb \-\-build\fP quant au contenu
proposé d'une archive. De cette façon, on peut construire n'importe quelle
archive, aussi défectueuse soit\-elle.
.TP 
\fB\-v\fP, \fB\-\-verbose\fP
Active l'affichage bavard (depuis dpkg\ 1.16.1). Cela n'affecte actuellement
que \fB\-\-extract\fP et le rend analogue à \fB\-\-vextract\fP.
.TP 
\fB\-D\fP, \fB\-\-debug\fP
Permet les messages de débogage. Ce n'est pas très intéressant.
.
.SH "CODE DE SORTIE"
.TP 
\fB0\fP
L'action demandée s'est correctement déroulée.
.TP 
\fB2\fP
Erreur fatale ou irrécupérable due à l'utilisation d'une ligne de commande
non valable, ou interactions avec le système, telles que des accès à la base
de données, des allocations de mémoire,\ etc.
.
.SH ENVIRONNEMENT
.TP 
\fBDPKG_COLORS\fP
Définit le mode de couleur (depuis dpkg\ 1.18.5). Les valeurs actuellement
acceptées sont \fBauto\fP (par défaut), \fBalways\fP et \fBnever\fP.
.TP 
\fBTMPDIR\fP
Si cette option est utilisée, \fBdpkg\-deb\fP l'utilisera comme répertoire pour
créer les fichiers et répertoires temporaires.
.TP 
\fBSOURCE_DATE_EPOCH\fP
Si cette option est utilisée, elle sera utilisée comme horodatage (en
seconde à partir de «\ l'epoch\ ») dans le conteneur \fBar\fP(5) de \fBdeb\fP(5), et
pour fixer le «\ mtime\ » dans les entrées du fichier \fBtar\fP(5).
.
.SH NOTES
N'essayez pas d'installer un logiciel avec \fBdpkg\-deb\fP\ ! Vous devez utiliser
\fBdpkg\fP pour être sûr que tous ses fichiers sont correctement mis en place,
que les scripts du paquet sont exécutés et que son contenu et son état sont
enregistrés.
.
.SH BOGUES
\fBdpkg\-deb \-I\fP \fIpaquet1\fP\fB.deb\fP \fIpaquet2\fP\fB.deb\fP se trompe.

Il n'existe pas d'authentification des fichiers \fB.deb\fP. Il n'existe même
pas de système de somme de contrôle immédiat. Les outils de haut niveau
comme APT gèrent l'authentification des paquets \fB.deb\fP récupérés depuis un
dépôt donné et la plupart des paquets fournissent désormais une somme de
contrôle MD5 créée par debian/rules. Cependant, cela n'est pas directement
géré par les outils de plus bas niveau.
.
.SH "VOIR AUSSI"
\fBdeb\fP(5), \fBdeb\-control\fP(5), \fBdpkg\fP(1), \fBdselect\fP(1).
.SH TRADUCTION
Ariel VARDI <ariel.vardi@freesbee.fr>, 2002.
Philippe Batailler, 2006.
Nicolas François, 2006.
Veuillez signaler toute erreur à <debian\-l10n\-french@lists.debian.org>.
