.\" dpkg manual page - dpkg-parsechangelog(1)
.\"
.\" Copyright © 1995-1996 Ian Jackson <ijackson@chiark.greenend.org.uk>
.\" Copyright © 2000 Wichert Akkerman <wakkerma@debian.org>
.\" Copyright © 2006, 2011-2015 Guillem Jover <guillem@debian.org>
.\" Copyright © 2007-2008 Frank Lichtenheld <djpig@debian.org>
.\" Copyright © 2009 Raphaël Hertzog <hertzog@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH dpkg\-parsechangelog 1 %RELEASE_DATE% %VERSION% "suite dpkg"
.ad l
.nh
.SH NOM
dpkg\-parsechangelog \- Analyse un fichier changelog Debian.
.
.SH SYNOPSIS
\fBdpkg\-parsechangelog\fP [\fIoption\fP...]
.
.SH DESCRIPTION
\fBdpkg\-parsechangelog\fP lit et fait l'analyse du fichier «\ changelog\ » d'une
arborescence source dépaquetée et affiche les informations qu'il contient
sur la sortie standard et sous une forme lisible par la machine.
.
.SH OPTIONS
.TP 
\fB\-l\fP, \fB\-\-file\fP \fIfichier\-des\-changements\fP
Indique le fichier des changements où trouver des renseignements. Un «\ \-\ »
peut être utilisé pour spécifier une lecture à partir de l'entrée
standard. Par défaut, c'est le fichier \fBdebian/changelog\fP.
.TP 
\fB\-F\fP \fIformat\-du\-fichier\-des\-changements\fP
Indique le format du fichier changelog. Par défaut, c'est une ligne
spéciale, près de la fin du fichier, qui l'indique\ ; sinon, on utilise le
format classique \fBdebian\fP. Voir aussi \fBFORMATS DES FICHIERS DE
CHANGEMENTS\fP.
.TP 
\fB\-L\fP \fIrep_lib\fP
Option obsolète sans effet (depuis dpkg\ 1.18.8). Fixer les variables
d'environnement de Perl \fBPERL5LIB\fP ou \fBPERLLIB\fP a un effet similaire lors
de la recherche des modules d'analyse de Perl.
.TP 
\fB\-S\fP, \fB\-\-show\-field\fP \fIchamp\fP
Indique le nom du champ à afficher (depuis dpkg\ 1.17.0). Le nom du champ
n'est pas affiché, mais seulement sa valeur.
.TP 
\fB\-?\fP, \fB\-\-help\fP
Affiche un message d'aide puis quitte.
.TP 
\fB\-\-version\fP
Affiche le numéro de version puis quitte.
.SS "Options de filtrage"
Les options suivantes peuvent être utilisées pour influencer la sortie de
l'analyseur du journal des modifications («\ changelog\ »), par exemple la
gamme d'entrées ou le format de sortie.
.TP 
\fB\-\-format\fP\fI format\-de\-sortie\fP
Règle le format de sortie. Actuellement les valeurs gérées sont \fIdpkg\fP et
\fBrfc822\fP. \fIdpkg\fP est le format classique de sortie (avant que cette option
n'existe) et l'option par défaut. Il se compose d'un paragraphe dans le
format du fichier de contrôle Debian (voir \fBdeb\-control\fP(5)). Si plus d'une
entrée est demandée, alors la plupart des champs sont tirés de la première
entrée (habituellement la plus récente), sauf si c'est indiqué autrement.
.RS
.TP 
\fBSource:\fP\fI nom\-du\-paquet\fP
.TP 
\fBVersion:\fP\fI version\fP
.TP 
\fBDistribution:\fP\fI distribution\-cible\fP
.TP 
\fBUrgency:\fP\fI priorité\fP
La priorité la plus élevée de toutes les entrées incluses est utilisée,
suivie par les commentaires concaténés et séparés par des espaces pour
toutes les versions demandées.
.TP 
\fBMaintainer:\fP\fI auteur\fP
.TP 
\fBDate:\fP\fI date\fP
La date de l'entrée sous forme d'une chaîne, telle qu'elle apparaît dans le
changelog. Avec un format \fBstrptime\fP(3) «\ \fB%a, %d %b %Y %T %z\fP\ » mais où
le nom du jour de la semaine pourrait ne pas vraiment correspondre au jour
réel obtenu à partir du reste de la chaîne de date. Si une représentation
plus précise du jour est nécessaire, utilisez le champ \fBTimestamp\fP, mais il
faut prendre en compte qu'il pourrait ne pas être possible de la faire
correspondre à la valeur exacte de ce champ.
.TP 
\fBTimestamp:\fP \fIhorodatage\fP
La date de l'entrée comme horodatage en secondes depuis «\ l'epoch\ » (depuis
dpkg\ 1.18.8).
.TP 
\fBCloses:\fP\fI numéro\-bogue\fP
Les champs «\ Closes\ » de toutes les entrées incluses sont fusionnés.
.TP 
\fBChanges:\fP\fI entrées\-du\-fichier\-des\-changements\fP
Les textes de toutes les entrées de changelog sont concaténés. Pour faire de
ce champ un champ de contrôle Debian valable, les lignes multiples qui sont
vides sont remplacées par un point \fB«\ .\ »\fP et toutes les lignes sont
indentées par une seule espace. Le contenu exact dépend du format du
changelog.
.RE
.IP
Les champs \fBVersion\fP, \fBDistribution\fP, \fBUrgency\fP, \fBMaintainer\fP et
\fBChanges\fP sont obligatoires.
.IP
Il est possible d'avoir d'autres champs qui sont définis par l'utilisateur.
.IP
Le format \fBrfc822\fP utilise les mêmes champs mais le résultat est un
paragraphe distinct pour chaque entrée du changelog afin que toutes les
métadonnées de chaque entrée soit préservées.
.TP 
\fB\-\-reverse\fP
Inclut toutes les modifications en ordre inverse (depuis
dpkg\ 1.19.1). Note\ : pour le format de \fBdpkg\fP, la première entrée sera
l'entrée la plus ancienne.
.TP 
\fB\-\-all\fP
Inclut toutes les modifications. Note\ :\ d'autres options deviennent sans
effet lorsque celle\-ci est utilisée.
.TP 
\fB\-s\fP, \fB\-\-since\fP \fIversion\fP
.TQ
\fB\-v\fP \fIversion\fP
Inclut tous les changements qui ont suivi la \fIversion\fP.
.TP 
\fB\-u\fP, \fB\-\-until\fP \fIversion\fP
Inclut tous les changements qui ont eu lieu avant la \fIversion\fP.
.TP 
\fB\-f\fP, \fB\-\-from\fP \fIversion\fP
Inclut tous les changements depuis la \fIversion\fP (incluse).
.TP 
\fB\-t\fP, \fB\-\-to\fP \fIversion\fP
Inclut tous les changements apportés jusqu'à la \fIversion\fP comprise.
.TP 
\fB\-c\fP, \fB\-\-count\fP \fInombre\fP
.TQ
\fB\-n\fP \fInombre\fP
Inclut ce \fInombre\fP d'entrées depuis le début (ou la fin si le \fInombre\fP est
inférieur à\ 0).
.TP 
\fB\-o\fP, \fB\-\-offset\fP \fInombre\fP
Modifie le point de départ pour \fB\-\-count\fP, à compter du début (ou la fin si
le \fInombre\fP est inférieur à\ 0).
.
.SH "FORMATS DE JOURNAUX DE MODIFICATIONS"
Il est possible d'utiliser un format différent de celui utilisé
habituellement, en fournissant un analyseur pour le format alternatif.

Afin que \fBdpkg\-parsechangelog\fP utilise le nouvel analyseur, il doit exister
une ligne, parmi les 40\ dernières du fichier, qui corresponde à l'expression
régulière Perl “\fB\eschangelog\-format:\es+([0\-9a\-z]+)\eW\fP\ (la partie entre
parenthèses doit être le nom du format). Exemple\ :

       @@@ changelog\-format: \fIautreformat\fP @@@

Les noms de formats de journaux de modifications sont des chaînes non vides
de caractères alphanumériques en minuscules («\ a\-z0\-9\ »).

Si une telle ligne existe, \fBdpkg\-parsechangelog\fP recherchera l'analyseur
sous le nom du module Perl \fBDpkg::Changelog::\fP\fIautreformat\fP\ ; s'il n'est
pas présent, c'est une condition d'erreur. Le nom de l'analyseur dans le
module Perl sera automatiquement mis en capitale. Le format de journaux des
modifications par défaut est \fBdebian\fP et un analyseur pour ce format est
fourni par défaut.

L'analyseur doit être dérivée de la classe Dpkg::Changelog et implémenter
l'interface documentée requise.

Si le format du journal des modifications analysé laisse toujours ou presque
une ligne blanche entre chaque changement, ces lignes blanches devraient
être retirées, afin de rendre l'affichage de sortie plus compact.

Si le journal des modifications ne contient pas d'informations de date ou de
nom de paquet, cette information doit être omise de l'affichage. L'analyseur
ne doit pas essayer de les calculer ou de les retrouver depuis d'autres
sources.

Si le journal des modifications n'utilise pas le format attendu, l'analyseur
produira une erreur, plutôt que d'essayer de s'en tirer comme il peut et
produire une sortie incorrecte.

Un analyseur de journal de modifications ne doit pas du tout interagir avec
l'utilisateur.
.
.SH NOTES
Toutes les \fBoptions d'analyse\fP sauf \fB\-v\fP sont gérées par \fBdpkg\fP seulement
depuis la version\ 1.14.16.
.PP
Analyse des options courtes avec des valeurs non\-groupées, disponible
seulement à partir de dpkg 1.18.0.
.
.SH ENVIRONNEMENT
.TP 
\fBDPKG_COLORS\fP
Définit le mode de couleur (depuis dpkg\ 1.18.5). Les valeurs actuellement
acceptées sont \fBauto\fP (par défaut), \fBalways\fP et \fBnever\fP.
.TP 
\fBDPKG_NLS\fP
Si cette variable est définie, elle sera utilisée pour décider l'activation
de la prise en charge des langues (NLS –\ Native Language Support), connu
aussi comme la gestion de l'internationalisation (ou i18n) (depuis
dpkg\ 1.19.0). Les valeurs permises sont\ : \fB0\fP et \fB1\fP (par défaut).
.
.SH FICHIERS
.TP 
\fBdebian/changelog\fP
Le journal des modifications\ ; on s'en sert pour connaître les informations
qui dépendent d'une version du paquet source, par exemple l'urgence ou la
distribution d'une installation sur le serveur, les modifications faites
depuis telle édition et le numéro de la version source lui\-même.
.
.SH "VOIR AUSSI"
\fBdeb\-changelog\fP(5).
.SH TRADUCTION
Ariel VARDI <ariel.vardi@freesbee.fr>, 2002.
Philippe Batailler, 2006.
Nicolas François, 2006.
Veuillez signaler toute erreur à <debian\-l10n\-french@lists.debian.org>.
