.\" dpkg manual page - dpkg-gensymbols(1)
.\"
.\" Copyright © 2007-2011 Raphaël Hertzog <hertzog@debian.org>
.\" Copyright © 2009-2010 Modestas Vainius <modestas@vainius.eu>
.\" Copyright © 2012-2015 Guillem Jover <guillem@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH dpkg\-gensymbols 1 %RELEASE_DATE% %VERSION% dpkg\-suite
.ad l
.nh
.SH NAAM
dpkg\-gensymbols \- genereer symbolenbestanden (informatie over
afhankelijkheidsrelaties met gedeelde bibliotheken)
.
.SH OVERZICHT
\fBdpkg\-gensymbols\fP [\fIoptie\fP...]
.
.SH BESCHRIJVING
\fBdpkg\-gensymbols\fP doorzoekt een tijdelijke bouwboom (standaard is dat
debian/tmp) op zoek naar bibliotheken en genereert een \fIsymbols\fP\-bestand
dat ze beschrijft. Dit bestand wordt dan als het niet leeg is, geïnstalleerd
in een onderliggende map van de bouwboom met de naam DEBIAN, zodat het
uiteindelijk opgenomen geraakt in de controle\-informatie van het pakket.
.P
Bij het genereren van deze bestanden gebruikt het als invoer bepaalde
symbolenbestanden die door de onderhouder aangeleverd worden. Het zoekt naar
de volgende bestanden (en gebruikt het eerste dat gevonden wordt):
.IP • 4
debian/\fIpakket\fP.symbols.\fIarch\fP
.IP • 4
debian/symbols.\fIarch\fP
.IP • 4
debian/\fIpakket\fP.symbols
.IP • 4
debian/symbols
.P
Het hoofddoel van deze bestanden is aan te geven welke de minimale versie is
die behoort bij elk van de symbolen die door de bibliotheken aangeleverd
worden. Gewoonlijk komt dit overeen met de eerste versie van het pakket dat
in dat symbool voorzag, maar dit kan door de onderhouder manueel verhoogd
worden indien de ABI van het symbool uitgebreid werd zonder dat daardoor de
neerwaartse compatibiliteit verbroken wordt. Het is de verantwoordelijkheid
van de onderhouder om deze bestanden up\-to\-date en accuraat te houden, maar
\fBdpkg\-gensymbols\fP helpt hierbij.
.P
Indien het gegenereerde symbolenbestand verschilt van datgene wat de
onderhouder aanlevert, zal \fBdpkg\-gensymbols\fP de verschillen tussen de twee
versies tonen in diff\-formaat. Bovendien kan dit zelfs tot een mislukking
leiden als de verschillen te significant zijn (u kunt aanpassen hoeveel
verschil u kunt tolereren; zie de optie \fB\-c\fP).
.SH "HET ONDERHOUD VAN SYMBOLENBESTANDEN"
The base interchange format of the symbols file is described in
\fBdeb\-symbols\fP(5), which is used by the symbols files included in binary
packages. These are generated from template symbols files with a format
based on the former, described in \fBdeb\-src\-symbols\fP(5)  and included in
source packages.
.P
The symbols files are really useful only if they reflect the evolution of
the package through several releases. Thus the maintainer has to update them
every time that a new symbol is added so that its associated minimal version
matches reality.
.P
The diffs contained in the build logs can be used as a starting point, but
the maintainer, additionally, has to make sure that the behaviour of those
symbols has not changed in a way that would make anything using those
symbols and linking against the new version, stop working with the old
version.
.P
In most cases, the diff applies directly to the debian/\fIpackage\fP.symbols
file. That said, further tweaks are usually needed: it's recommended for
example to drop the Debian revision from the minimal version so that
backports with a lower version number but the same upstream version still
satisfy the generated dependencies.  If the Debian revision can't be dropped
because the symbol really got added by the Debian specific change, then one
should suffix the version with ‘\fB~\fP’.
.P
Vooraleer een patch toe te passen op een symbolenbestand, moet de
onderhouder grondig controleren of dat wel correct is. Publieke symbolen
worden verondersteld niet te verdwijnen. Een patch zou dus idealiter enkel
nieuwe regels mogen toevoegen.
.P
Note that you can put comments in symbols files.
.P
Vergeet niet na te gaan of oudere symboolversies niet verhoogd moeten
worden. Er bestaat geen manier voor \fBdpkg\-gensymbols\fP om in dit verband
waarschuwingen te geven. Een diff (weergave van de verschillen) blindweg
toepassen of ervan uitgaan dat er niets aangepast moet worden als er geen
diff is zonder zelf op eventuele wijzigingen te controleren, kan leiden tot
pakketten met verslapte afhankelijkheidsrelaties die onterecht laten
veronderstellen dat ze met oudere pakketten kunnen samenwerken. Dit kan bij
(gedeeltelijke) opwaarderingen leiden tot moeilijk te vinden bugs.
.SS "Goed beheer van bibliotheken"
.P
Een goed onderhouden bibliotheek heeft de volgende functionaliteit:
.IP • 4
haar API is stabiel (publieke symbolen worden nooit verwijderd, enkel worden
nieuwe publieke symbolen toegevoegd) en zij ondergaat enkel op een
incompatibele manier veranderingen als de SONAME verandert;
.IP • 4
idealiter gebruikt zij symboolversienummering om ondanks interne wijzigingen
en API\-uitbreidingen ABI\-stabiliteit te bekomen;
.IP • 4
zij exporteert geen private symbolen (dergelijke symbolen kunnen de tag
optional krijgen om dat te omzeilen).
.P
Bij het onderhoud van een symbolenbestand is het gemakkelijk om het
verschijnen en verdwijnen van symbolen op te merken. Maar het is moeilijker
om incompatibele API\- en ABI\-wijzigingen op te merken. Daarom moet de
onderhouder het changelog\-bestand van de toeleveraar grondig nakijken op
situaties waarbij de regels van goed bibliotheekbeheer geschonden
worden. Indien mogelijke problemen ontdekt worden, zou de toeleverende
auteur erover ingelicht moeten worden, aangezien een reparatie op het niveau
van de toeleveraar altijd te verkiezen valt boven een Debian\-specifieke
tijdelijke oplossing.
.SH OPTIES
.TP 
\fB\-P\fP\fIpakketbouwmap\fP
Zoek in \fIpakketbouwmap\fP in plaats van in debian/tmp.
.TP 
\fB\-p\fP\fIpakket\fP
Definieer de pakketnaam. Is vereist als meer dan één binair pakket vermeld
wordt in debian/control (of indien er geen bestand debian/control is).
.TP 
\fB\-v\fP\fIversie\fP
Definieer de pakketversie. Standaard is dat de versie die uit
debian/changelog gehaald wordt. Is vereist indien het aanroepen gebeurt van
buiten de boom van het broncodepakket.
.TP 
\fB\-e\fP\fIbibliotheekbestand\fP
Analyseer enkel de expliciet vermelde bibliotheken in plaats van alle
publieke bibliotheken te zoeken. U kunt in \fIbibliotheekbestand\fP gebruik
maken van shell\-patronen met het oog op padnaamexpansie (zie de man\-pagina
\fBFile::Glob\fP(3perl) voor details) om met één enkel argument meerdere
bibliotheken aan te duiden (anders heeft u meerdere malen \fB\-e\fP nodig).
.TP 
\fB\-l\fP\fImap\fP
Voeg \fImap\fP vooraan toe aan de lijst van mappen waarin naar private gedeelde
bibliotheken gezocht moet worden (sinds dpkg 1.19.1). Deze optie kan
meermaals gebruikt worden.

Opmerking: gebruik deze optie in de plaats van het instellen van
\fBLD_LIBRARY_PATH\fP, aangezien die omgevingsvariabele gebruikt wordt om de
runtime linker aan te sturen. Daarvan misbruik maken om de paden van
gedeelde bibliotheken in te stellen tijdens het bouwen van het programma,
kan problematisch zijn, bijvoorbeeld bij het cross\-compileren.
.TP 
\fB\-I\fP\fIbestandsnaam\fP
Gebruik \fIbestandsnaam\fP als referentiebestand om het symbolenbestand te
genereren dat in het pakket zelf geïntegreerd wordt.
.TP 
\fB\-O\fP[\fIbestandsnaam\fP]
Geef het gegenereerde symbolenbestand uit weer op de standaarduitvoer of
schrijf het naar \fIbestandsnaam\fP als dat opgegeven werd, eerder dan naar
\fBdebian/tmp/DEBIAN/symbols\fP (of \fIpakketbouwmap\fP\fB/DEBIAN/symbols\fP indien
\fB\-P\fP gebruikt werd). Indien \fIbestandsnaam\fP reeds bestond, wordt de inhoud
ervan gebruikt als basis voor het gegenereerde symbolenbestand. U kunt van
deze functionaliteit gebruik maken om een symbolenbestand bij te werken
zodat het in overeenstemming is met een nieuwere toeleveraarsversie van uw
bibliotheek.
.TP 
\fB\-t\fP
Schrijf het symbolenbestand in sjabloonmodus eerder dan in de indeling die
compatibel is met \fBdeb\-symbols\fP(5). Het grootste verschil is dat in de
sjabloonmodus symboolnamen en tags geschreven worden in hun originele vorm
in tegenstelling tot in de compatibele modus waarin de verwerkte
symboolnamen ontdaan van hun tags gebruikt worden. Daarenboven kunnen bij
het schrijven van een standaard \fBdeb\-symbols\fP(5)\-bestand sommige symbolen
weggelaten worden (overeenkomstig de regels voor het verwerken van tags),
terwijl in een symbolenbestandsjabloon steeds alle symbolen neergeschreven
worden.
.TP 
\fB\-c\fP\fI[0\-4]\fP
Definieer de controles die moeten gebeuren bij het vergelijken van het
gegenereerde symbolenbestand met het sjabloonbestand dat als vertrekpunt
gebruikt werd. Standaard is dat volgens niveau 1. Het verhogen van het
niveau leidt tot meer controles, terwijl alle controles van lagere niveaus
behouden blijven. Niveau 0 leidt nooit tot een mislukking. Niveau 1 mislukt
als er symbolen verdwenen zijn. Niveau 2 geeft een mislukking als nieuwe
symbolen geïntroduceerd werden. Niveau 3 mislukt als er bibliotheken
verdwenen zijn. Niveau 4 geeft een mislukking als nieuwe bibliotheken
geïntroduceerd werden.

Deze waarde kan vervangen worden door de omgevingsvariabele
\fBDPKG_GENSYMBOLS_CHECK_LEVEL\fP.
.TP 
\fB\-q\fP
Gedraag u rustig en genereer nooit een diff (een overzicht van de
verschillen) tussen het gegenereerde symbolenbestand en het sjabloonbestand
dat als vertrekpunt gebruikt werd en toon geen enkele waarschuwing in
verband met nieuwe/verloren bibliotheken of nieuwe/verloren symbolen. Deze
optie schakelt enkel de informatieve uitvoer uit, maar niet de controles
zelf (zie de optie \fB\-c\fP).
.TP 
\fB\-a\fP\fIarch\fP
Ga uit van \fIarch\fP als hostarchitectuur bij het verwerken van
symbolenbestanden. Gebruik deze optie om een symbolenbestand of een diff
(overzicht van de verschillen) voor een willekeurige architectuur te
genereren op voorwaarde dat de binaire bestanden ervan reeds voorhanden
zijn.
.TP 
\fB\-d\fP
Zet debug\-modus aan. Talrijke berichten worden dan getoond om toe te lichten
wat \fBdpkg\-gensymbols\fP doet.
.TP 
\fB\-V\fP
Schakel de breedsprakige modus in. Het gegenereerde symbolenbestand bevat
dan verouderde symbolen in de vorm van commentaar. In sjabloonmodus worden
daarenboven patroonsymbolen gevolgd door commentaar met daarin een opsomming
van de echte symbolen die met het patroon overeenkwamen.
.TP 
\fB\-?\fP, \fB\-\-help\fP
Toon info over het gebruik en sluit af.
.TP 
\fB\-\-version\fP
Toon de versie en sluit af.
.
.SH OMGEVING
.TP 
\fBDPKG_GENSYMBOLS_CHECK_LEVEL\fP
Overschrijft het controleniveau van het commando, zelfs als het argument
\fB\-c\fP opgegeven werd aan de commandoregel (merk op dat dit ingaat tegen de
algemeen geldende afspraak dat commandoregel\-argumenten voorrang hebben op
omgevingsvariabelen).
.TP 
\fBDPKG_COLORS\fP
Stelt de kleurmodus in (sinds dpkg 1.18.5). Waarden die momenteel gebruikt
mogen worden zijn: \fBauto\fP (standaard), \fBalways\fP en \fBnever\fP.
.TP 
\fBDPKG_NLS\fP
Indien dit ingesteld is, zal het gebruikt worden om te beslissen over het
activeren van moedertaalondersteuning, ook gekend als
internationaliseringsondersteuning (of i18n) (sinds dpkg 1.19.0). Geldige
waarden zijn: \fB0\fP and \fB1\fP (standaard).
.
.SH "ZIE OOK"
\fBhttps://people.redhat.com/drepper/symbol\-versioning\fP
.br
\fBhttps://people.redhat.com/drepper/goodpractice.pdf\fP
.br
\fBhttps://people.redhat.com/drepper/dsohowto.pdf\fP
.br
\fBdeb\-src\-symbol\fP(5), \fBdeb\-symbols\fP(5), \fBdpkg\-shlibdeps\fP(1).
