.\" dpkg manual page - dpkg-gensymbols(1)
.\"
.\" Copyright © 2007-2011 Raphaël Hertzog <hertzog@debian.org>
.\" Copyright © 2009-2010 Modestas Vainius <modestas@vainius.eu>
.\" Copyright © 2012-2015 Guillem Jover <guillem@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH dpkg\-gensymbols 1 %RELEASE_DATE% %VERSION% Dpkg\-sviten
.ad l
.nh
.SH NAMN
dpkg\-gensymbols \- generera symbolfiler (information om delade bibliotek)
.
.SH SYNOPS
\fBdpkg\-gensymbols\fP [\fIflagga\fP...]
.
.SH BESKRIVNING
\fBdpkg\-gensymbols\fP söker genom en temporärt byggträd (som standard
debian/tmp) efter bibliotek och skapar en \fIsymbols\fP\-fil som beskriver
dem. Denna fil kommer sedan, såvida den inte är tom, att installeras i
DEBIAN\-underkatalogen i byggträdet så att den hamnar i styrinformationen i
paketet.
.P
När dessa filer skapas, används ett par symbolfiler från paketansvariga som
indata. Programmet söker efter följande filer (och använder den första det
finner):
.IP • 4
debian/\fIpaket\fP.symbols.\fIarkitektur\fP
.IP • 4
debian/symbols.\fIarkitektur\fP
.IP • 4
debian/\fIpaket\fP.symbols
.IP • 4
debian/symbols
.P
Dessa filer är i huvudsak intressanta för att kunna tillhandahålla den
minimala version associerad med varje symbol i biblioteken. Detta motsvarar
normalt den första version av paketet som tillhandahöll symbolen, men det
kan manuellt inkrementeras av de ansvariga om symbolens ABI utökas med
bibehållen bakåtkompatibilitet. Det är den ansvarigas ansvar att hålla dessa
filer àjourförda och korrekta, men \fBdpkg\-gensymbols\fP kan hjälpa till med
detta.
.P
När den genererade symbolfilen skiljer sig mot den version som
tillhandahållits av de paketansvariga kommer \fBdpkg\-gensymbols\fP att skriva
ut en differens mellan de två versionerna. Om ändringarna är för stora
kommer programmet dessutom att misslyckas (du kan justera hur stora
ändringar du kan tolerera, se flaggan \fB\-c\fP).
.SH "UNDERHÅLLA SYMBOLFILER"
The base interchange format of the symbols file is described in
\fBdeb\-symbols\fP(5), which is used by the symbols files included in binary
packages. These are generated from template symbols files with a format
based on the former, described in \fBdeb\-src\-symbols\fP(5)  and included in
source packages.
.P
The symbols files are really useful only if they reflect the evolution of
the package through several releases. Thus the maintainer has to update them
every time that a new symbol is added so that its associated minimal version
matches reality.
.P
The diffs contained in the build logs can be used as a starting point, but
the maintainer, additionally, has to make sure that the behaviour of those
symbols has not changed in a way that would make anything using those
symbols and linking against the new version, stop working with the old
version.
.P
In most cases, the diff applies directly to the debian/\fIpackage\fP.symbols
file. That said, further tweaks are usually needed: it's recommended for
example to drop the Debian revision from the minimal version so that
backports with a lower version number but the same upstream version still
satisfy the generated dependencies.  If the Debian revision can't be dropped
because the symbol really got added by the Debian specific change, then one
should suffix the version with ‘\fB~\fP’.
.P
Innan man applicerar en patch på symbolfilen bör de ansvariga dubbelchecka
att den är korrekt. Publicerade symboler bör inte försvinna, så patchen bör
ideellt sett bara lägga till nya rader.
.P
Note that you can put comments in symbols files.
.P
Glöm inte att kontrollera om de gamla symbolversionerna måste ökas. Det
finns inget sätt för \fBdpkg\-gensymbols\fP att varna om detta. Att blint
applicera diffen eller utgå från att inget har ändrats om diffen är tom,
utan att se efter sådana ändringar, kan leda till att paket med lösa
beroenden kan deklarera att de fungerar med äldre paket de inte kan fungera
tillsammans med. Detta kommer introducera svårfunna problem vid (delvisa)
uppgraderingar.{
.SS "God hantering av bibliotek"
.P
Ett välunderhållet bibliotek har följande funktioner:
.IP • 4
dess API är stabilt (publika symboler tas aldrig bort, endast nya publika
symboler läggs till) och inkompatibla ändringar görs endast när SONAMNet
ändras;
.IP • 4
ideellt använder det en versionhanterade symboler för att upprätthålla
ABI\-stabilitet trots interna ändringar och API\-utökningar;
.IP • 4
det exporterar inte privata symboler (sådana symboler kan taggas med
"optional" för att gå runt detta).
.P
När man underhåller symbolfilen är det lätt att upptäcka symboler som dyker
upp och försvinner. Det är svårare att upptäcka inkompatibla API\- och
ABI\-ändringar. Den paketansvarige bör därför noggrant läsa igenom
uppströmsändringsloggen för fall då reglerna för god hantering av bibliotek
bryts. Om ett möjligt fel upptäcks bör uppströmsförfattaren meddelas, då det
alltid är bättre att problemet rättas uppströms än specifikt i Debian.
.SH FLAGGOR
.TP 
\fB\-P\fP\fIpaketbyggkatalog\fP
Sök \fIpaketbyggkatalog\fP istället för debian/tmp.
.TP 
\fB\-p\fP\fIpaket\fP
Definiera paketnamnet. Krävs om mer än ett binärpaket listas i
debian/control (eller om det inte finns någon debian/control\-fil).
.TP 
\fB\-v\fP\fIversion\fP
Definiera paketversion. Standardvärdet är versionen som hämtas från
debian/changelog. Krävs om programmet anropas utanför ett källkodspaketträd.
.TP 
\fB\-e\fP\fIbiblioteksfil\fP
Analyserar endast bibliotek som listats explicit istället för att hitta alla
publika bibliotek. Du kan använda ett jokertecken för filnamn (se
manualsidan \fBFile::Glob\fP(3perl) för detaljer) i \fIbiblioteksfil\fP för att
träffa multipla bibliotek med ett enda argument (annars behöver du flera
\fB\-e\fP).
.TP 
\fB\-l\fP\fIkatalog\fP
Prepend \fIdirectory\fP to the list of directories to search for private shared
libraries (since dpkg 1.19.1). This option can be used multiple times.

Observera: Använd den här flaggan istället för att sätta \fBLD_LIBRARY_PATH\fP,
eftersom miljövariabeln används för att styra körtidslänkaren, och genom att
utnyttja det för att ange sökvägen till delade bibliotek vid kompilering kan
det uppstå problem, till exempel vid korskompilering.
.TP 
\fB\-I\fP\fIfilnamn\fP
Använd \fIfilnamn\fP som referensfil för att generera symbolfilen som
integreras i själva paketet.
.TP 
\fB\-O\fP[\fIfilnamn\fP]
Visa den genererade symbolfilen på standard ut eller spara som \fIfilnamn\fP om
det anges, istället för \fBdebian/tmp/DEBIAN/symbols\fP (eller
\fIpaketbyggkatalog\fP\fB/DEBIAN/symbols\fP om \fB\-P\fP användes). Om \fIfilnamn\fP
redan existerar kommer dess innehåll att användas som bas för den genererade
symbolfilen. Du kan använda den här funktionen för att uppdatera en
symbolfil så att den motsvarar en nyare uppströmsversion av ditt bibliotek.
.TP 
\fB\-t\fP
Skriv symbolfilen i mall\-läge istället för i formatet kompatibelt med
\fBdeb\-symbols\fP(5). Huvudskillnaden är att symbolnamn och taggar skrivs i sin
originalform i mall\-läget, till skillnad från de efterbehandlade
symbolnamnen med borttagna taggar som skrivs i det kompatibla
läget. Dessutom kan vissa symboler uteslutas när en vanlig
\fBdeb\-symbols\fP(5)\-fil skrivs (i enlighet med tagghanteringsreglerna) medan
alla symboler alltid skrivs till symbolfilsmallen.
.TP 
\fB\-c\fP\fI[0\-4]\fP
Definiera vilka kontroller som skall utföras när den genererade symbolfilen
jämförs med den mallfil som används som startpunkt. Som standard är nivån
1. Genom att öka nivån utförs flera kontroller, inklusive alla kontroller på
lägre nivå. Nivå 2 misslyckas om nya symboler har introducerats. Nivå 3
misslyckas om några bibliotek har försvunnit. Nivå 4 misslyckas om några
bibliotek har introducerats.

Värdet kan överstyras med miljövariabeln \fBDPKG_GENSYMBOLS_CHECK_LEVEL\fP.
.TP 
\fB\-q\fP
Håll tyst och generera aldrig en differens mellan den genererade symbolfilen
och mallfilen som användes som startpunkt eller visa varningar om
nya/förlorade bibliotek eller nya/förlorade symboler. Den här flaggan tar
endast bort informationsutdata, inte själva kontrolleran (se flaggan \fB\-c\fP).
.TP 
\fB\-a\fP\fIarkitektur\fP
Anta \fIarkitektur\fP som värdarkitektur vid hantering av symbolfiler. Använd
den här flaggan för att generera en symbolfil eller differens för valfri
arkitektur så länge dess binärer är tillgängliga.
.TP 
\fB\-d\fP
Aktiverar felsökningsläge. Flera meddelanden visas för att förklara vad
\fBdpkg\-gensymbols\fP gör.
.TP 
\fB\-V\fP
Aktivera pratsamt läge. Den genererade symbolfilen innehåller ej längre
rekommenderade symboler som kommentarer. I mall\-läge följs dessutom
mönstersymboler av kommentarer som visar vilka verkliga symboler som har
träffats av mönstret.
.TP 
\fB\-?\fP, \fB\-\-help\fP
Visar hjälpskärm och avslutar.
.TP 
\fB\-\-version\fP
Visar version och avslutar.
.
.SH MILJÖVARIABLER
.TP 
\fBDPKG_GENSYMBOLS_CHECK_LEVEL\fP
Overrides the command check level, even if the \fB\-c\fP command\-line argument
was given (note that this goes against the common convention of command\-line
arguments having precedence over environment variables).
.TP 
\fBDPKG_COLORS\fP
Sets the color mode (since dpkg 1.18.5).  The currently accepted values are:
\fBauto\fP (default), \fBalways\fP and \fBnever\fP.
.TP 
\fBDPKG_NLS\fP
If set, it will be used to decide whether to activate Native Language
Support, also known as internationalization (or i18n) support (since dpkg
1.19.0).  The accepted values are: \fB0\fP and \fB1\fP (default).
.
.SH "SE ÄVEN"
\fBhttps://people.redhat.com/drepper/symbol\-versioning\fP
.br
\fBhttps://people.redhat.com/drepper/goodpractice.pdf\fP
.br
\fBhttps://people.redhat.com/drepper/dsohowto.pdf\fP
.br
\fBdeb\-src\-symbol\fP(5), \fBdeb\-symbols\fP(5), \fBdpkg\-shlibdeps\fP(1).
.SH ÖVERSÄTTNING
Peter Krefting och Daniel Nylander.
