/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.classify.tui;

import cc.mallet.types.Alphabet;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.InfoGain;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.util.CommandOption;
import cc.mallet.util.MalletLogger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Logger;

public class Vectors2Info {
    private static Logger logger = MalletLogger.getLogger(Vectors2Info.class.getName());
    static CommandOption.File inputFile = new CommandOption.File(Vectors2Info.class, "input", "FILE", true, new File("-"), "Read the instance list from this file; Using - indicates stdin.", null);
    static CommandOption.Integer printInfogain = new CommandOption.Integer(Vectors2Info.class, "print-infogain", "N", false, 0, "Print top N words by information gain, sorted.", null);
    static CommandOption.Boolean printLabels = new CommandOption.Boolean(Vectors2Info.class, "print-labels", "[TRUE|FALSE]", false, false, "Print class labels known to instance list, one per line.", null);
    static CommandOption.String printMatrix = new CommandOption.String(Vectors2Info.class, "print-matrix", "STRING", false, "sic", "Print word/document matrix in the specified format (a|s)(b|i)(n|w|c|e)", null){

        public void parseArg(String arg) {
            if (arg == null) {
                arg = this.defaultValue;
            }
            char c0 = arg.charAt(0);
            char c1 = arg.charAt(1);
            char c2 = arg.charAt(2);
            if (arg.length() != 3 || c0 != 's' && c0 != 'a' || c1 != 'b' && c1 != 'i' || c2 != 'n' && c2 != 'w' && c2 != 'c' && c2 != 'e') {
                throw new IllegalArgumentException("Illegal argument = " + arg + " in --print-matrix=" + arg);
            }
            this.value = arg;
        }
    };

    public static void main(String[] args) throws FileNotFoundException, IOException {
        int i;
        CommandOption.setSummary(Vectors2Info.class, "A tool for printing information about instance lists of feature vectors.");
        CommandOption.process(Vectors2Info.class, args);
        if (args.length == 0) {
            CommandOption.getList(Vectors2Info.class).printUsage(false);
            System.exit(-1);
        }
        InstanceList ilist = InstanceList.load(Vectors2Info.inputFile.value);
        if (Vectors2Info.printLabels.value) {
            Alphabet la = ilist.getTargetAlphabet();
            for (i = 0; i < la.size(); ++i) {
                System.out.println(la.lookupObject(i));
            }
            System.out.print("\n");
        }
        if (Vectors2Info.printInfogain.value > 0) {
            InfoGain ig = new InfoGain(ilist);
            for (i = 0; i < Vectors2Info.printInfogain.value; ++i) {
                System.out.println("" + i + " " + ig.getObjectAtRank(i));
            }
            System.out.print("\n");
        }
        if (printMatrix.wasInvoked()) {
            Vectors2Info.printInstanceList(ilist, Vectors2Info.printMatrix.value);
        }
    }

    private static void printInstanceList(InstanceList ilist, String formatString) {
        int numInstances = ilist.size();
        int numClasses = ilist.getTargetAlphabet().size();
        int numFeatures = ilist.getDataAlphabet().size();
        Alphabet dataAlphabet = ilist.getDataAlphabet();
        double[] counts = new double[numFeatures];
        for (int i = 0; i < ilist.size(); ++i) {
            Instance inst = (Instance)ilist.get(i);
            if (!(inst.getData() instanceof FeatureVector)) {
                throw new IllegalArgumentException("Currently only handles FeatureVector data");
            }
            FeatureVector fv = (FeatureVector)inst.getData();
            System.out.print(inst.getName() + " " + inst.getTarget());
            if (formatString.charAt(0) == 'a') {
                for (int fvi = 0; fvi < numFeatures; ++fvi) {
                    Vectors2Info.printFeature(dataAlphabet.lookupObject(fvi), fvi, fv.value(fvi), formatString);
                }
            } else {
                for (int l = 0; l < fv.numLocations(); ++l) {
                    int fvi = fv.indexAtLocation(l);
                    Vectors2Info.printFeature(dataAlphabet.lookupObject(fvi), fvi, fv.valueAtLocation(l), formatString);
                }
            }
            System.out.println();
        }
        System.out.println();
    }

    private static void printFeature(Object o, int fvi, double featureValue, String formatString) {
        char c1 = formatString.charAt(2);
        if (c1 == 'w') {
            System.out.print("  " + o);
        } else if (c1 == 'n') {
            System.out.print("  " + fvi);
        } else if (c1 == 'c') {
            System.out.print("  " + o + ":" + fvi);
        } else if (c1 == 'e') {
            // empty if block
        }
        char c2 = formatString.charAt(1);
        if (c2 == 'i') {
            System.out.print(" " + (int)(featureValue + 0.5));
        } else if (c2 == 'b') {
            System.out.print(" " + (featureValue > 0.5 ? "1" : "0"));
        }
    }
}

