/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.cluster;

import cc.mallet.cluster.Clustering;
import cc.mallet.cluster.KBestClusterer;
import cc.mallet.cluster.neighbor_evaluator.NeighborEvaluator;
import cc.mallet.pipe.Pipe;
import cc.mallet.types.InstanceList;
import java.util.LinkedList;

public abstract class HillClimbingClusterer
extends KBestClusterer {
    protected NeighborEvaluator evaluator;

    public HillClimbingClusterer(Pipe instancePipe, NeighborEvaluator evaluator) {
        super(instancePipe);
        this.evaluator = evaluator;
    }

    public NeighborEvaluator getEvaluator() {
        return this.evaluator;
    }

    public Clustering cluster(InstanceList instances) {
        return this.clusterKBest(instances, 1)[0];
    }

    public Clustering[] clusterKBest(InstanceList instances, int k) {
        this.reset();
        return this.clusterKBest(instances, Integer.MAX_VALUE, null, k);
    }

    public Clustering cluster(InstanceList instances, int iterations, Clustering initialClustering) {
        return this.clusterKBest(instances, iterations, initialClustering, 1)[0];
    }

    public Clustering[] clusterKBest(InstanceList instances, int iterations, Clustering initialClustering, int k) {
        LinkedList<Clustering> solutions = new LinkedList<Clustering>();
        Clustering bestsofar = initialClustering == null ? this.initializeClustering(instances) : initialClustering;
        solutions.addFirst(bestsofar);
        int iter = 0;
        do {
            if (!(bestsofar = this.improveClustering(((Clustering)solutions.getFirst()).shallowCopy())).equals(solutions.getFirst())) {
                solutions.addFirst(bestsofar);
            }
            if (solutions.size() != k + 1) continue;
            solutions.removeLast();
        } while (!this.converged(bestsofar) && iter++ < iterations);
        return solutions.toArray(new Clustering[0]);
    }

    public abstract boolean converged(Clustering var1);

    public abstract Clustering improveClustering(Clustering var1);

    public abstract Clustering initializeClustering(InstanceList var1);

    public abstract void reset();
}

