/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.cluster.neighbor_evaluator;

import cc.mallet.cluster.Clustering;
import cc.mallet.cluster.neighbor_evaluator.Neighbor;
import cc.mallet.util.ArrayUtils;

public class AgglomerativeNeighbor
extends Neighbor {
    private static final long serialVersionUID = 1L;
    int[] newCluster;
    int[][] oldClusters;

    public AgglomerativeNeighbor(Clustering original, Clustering modified, int[][] oldClusters) {
        super(original, modified);
        if (oldClusters.length != 2) {
            throw new IllegalArgumentException("Agglomerations of more than 2 clusters not yet implemented.");
        }
        this.oldClusters = oldClusters;
        this.newCluster = ArrayUtils.append(oldClusters[0], oldClusters[1]);
    }

    public AgglomerativeNeighbor(Clustering original, Clustering modified, int[] oldCluster1, int[] oldCluster2) {
        this(original, modified, new int[][]{oldCluster1, oldCluster2});
    }

    public AgglomerativeNeighbor(Clustering original, Clustering modified, int oldCluster1, int oldCluster2) {
        this(original, modified, new int[][]{{oldCluster1}, {oldCluster2}});
    }

    public int[] getNewCluster() {
        return this.newCluster;
    }

    public int[][] getOldClusters() {
        return this.oldClusters;
    }

    public String toString() {
        String ret = super.toString() + "\nnewcluster=";
        for (int i = 0; i < this.newCluster.length; ++i) {
            ret = ret + this.newCluster[i] + " ";
        }
        return ret;
    }
}

