/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst;

import cc.mallet.fst.SegmentationEvaluator;
import cc.mallet.fst.Transducer;
import cc.mallet.fst.TransducerEvaluator;
import cc.mallet.fst.TransducerTrainer;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.Instance;
import cc.mallet.types.InstanceList;
import cc.mallet.types.Sequence;
import cc.mallet.types.Token;
import cc.mallet.util.MalletLogger;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiSegmentationEvaluator
extends TransducerEvaluator {
    private static Logger logger = MalletLogger.getLogger(SegmentationEvaluator.class.getName());
    Object[] segmentStartTags;
    Object[] segmentContinueTags;
    Object[] segmentStartOrContinueTags;

    public MultiSegmentationEvaluator(InstanceList[] instanceLists, String[] instanceListDescriptions, Object[] segmentStartTags, Object[] segmentContinueTags) {
        super(instanceLists, instanceListDescriptions);
        this.segmentStartTags = segmentStartTags;
        this.segmentContinueTags = segmentContinueTags;
        assert (segmentStartTags.length == segmentContinueTags.length);
    }

    public MultiSegmentationEvaluator(InstanceList instanceList1, String description1, Object[] segmentStartTags, Object[] segmentContinueTags) {
        this(new InstanceList[]{instanceList1}, new String[]{description1}, segmentStartTags, segmentContinueTags);
    }

    public MultiSegmentationEvaluator(InstanceList instanceList1, String description1, InstanceList instanceList2, String description2, Object[] segmentStartTags, Object[] segmentContinueTags) {
        this(new InstanceList[]{instanceList1, instanceList2}, new String[]{description1, description2}, segmentStartTags, segmentContinueTags);
    }

    public MultiSegmentationEvaluator(InstanceList instanceList1, String description1, InstanceList instanceList2, String description2, InstanceList instanceList3, String description3, Object[] segmentStartTags, Object[] segmentContinueTags) {
        this(new InstanceList[]{instanceList1, instanceList2, instanceList3}, new String[]{description1, description2, description3}, segmentStartTags, segmentContinueTags);
    }

    @Override
    public void evaluateInstanceList(TransducerTrainer tt, InstanceList data, String description) {
        Transducer model = tt.getTransducer();
        int allIndex = this.segmentStartTags.length;
        int[] numTrueSegments = new int[allIndex + 1];
        int[] numPredictedSegments = new int[allIndex + 1];
        int[] numCorrectSegments = new int[allIndex + 1];
        int numCorrectTokens = 0;
        int totalTokens = 0;
        for (int n = 0; n < numTrueSegments.length; ++n) {
            numCorrectSegments[n] = 0;
            numPredictedSegments[n] = 0;
            numTrueSegments[n] = 0;
        }
        for (int i = 0; i < data.size(); ++i) {
            Instance instance = (Instance)data.get(i);
            Sequence input = (Sequence)instance.getData();
            Sequence trueOutput = (Sequence)instance.getTarget();
            assert (input.size() == trueOutput.size());
            Sequence predOutput = model.transduce(input);
            assert (predOutput.size() == trueOutput.size());
            for (int j = 0; j < trueOutput.size(); ++j) {
                int m;
                int n;
                ++totalTokens;
                if (trueOutput.get(j).equals(predOutput.get(j))) {
                    ++numCorrectTokens;
                }
                int predStart = -1;
                int trueStart = -1;
                for (n = 0; n < this.segmentStartTags.length; ++n) {
                    if (!this.segmentStartTags[n].equals(trueOutput.get(j))) continue;
                    int n2 = n;
                    numTrueSegments[n2] = numTrueSegments[n2] + 1;
                    int n3 = allIndex;
                    numTrueSegments[n3] = numTrueSegments[n3] + 1;
                    trueStart = n;
                    break;
                }
                for (n = 0; n < this.segmentStartTags.length; ++n) {
                    if (!this.segmentStartTags[n].equals(predOutput.get(j))) continue;
                    int n4 = n;
                    numPredictedSegments[n4] = numPredictedSegments[n4] + 1;
                    int n5 = allIndex;
                    numPredictedSegments[n5] = numPredictedSegments[n5] + 1;
                    predStart = n;
                }
                if (trueStart == -1 || trueStart != predStart) continue;
                boolean trueContinue = false;
                boolean predContinue = false;
                for (m = j + 1; m < trueOutput.size(); ++m) {
                    trueContinue = this.segmentContinueTags[predStart].equals(trueOutput.get(m));
                    predContinue = this.segmentContinueTags[predStart].equals(predOutput.get(m));
                    if (trueContinue && predContinue) continue;
                    if (trueContinue != predContinue) break;
                    int n6 = predStart;
                    numCorrectSegments[n6] = numCorrectSegments[n6] + 1;
                    int n7 = allIndex;
                    numCorrectSegments[n7] = numCorrectSegments[n7] + 1;
                    break;
                }
                if (m != trueOutput.size() || trueContinue != predContinue) continue;
                int n8 = predStart;
                numCorrectSegments[n8] = numCorrectSegments[n8] + 1;
                int n9 = allIndex;
                numCorrectSegments[n9] = numCorrectSegments[n9] + 1;
            }
        }
        DecimalFormat f = new DecimalFormat("0.####");
        logger.info(description + " tokenaccuracy=" + f.format((double)numCorrectTokens / (double)totalTokens));
        for (int n = 0; n < numCorrectSegments.length; ++n) {
            logger.info((n < allIndex ? this.segmentStartTags[n].toString() : "OVERALL") + ' ');
            double precision = numPredictedSegments[n] == 0 ? 1.0 : (double)numCorrectSegments[n] / (double)numPredictedSegments[n];
            double recall = numTrueSegments[n] == 0 ? 1.0 : (double)numCorrectSegments[n] / (double)numTrueSegments[n];
            double f1 = recall + precision == 0.0 ? 0.0 : 2.0 * recall * precision / (recall + precision);
            logger.info(" " + description + " segments true=" + numTrueSegments[n] + " pred=" + numPredictedSegments[n] + " correct=" + numCorrectSegments[n] + " misses=" + (numTrueSegments[n] - numCorrectSegments[n]) + " alarms=" + (numPredictedSegments[n] - numCorrectSegments[n]));
            logger.info(" " + description + " precision=" + f.format(precision) + " recall=" + f.format(recall) + " f1=" + f.format(f1));
        }
    }

    public int numIncorrectSegments(Sequence trueOutput, Sequence predOutput) {
        int n;
        int allIndex = this.segmentStartTags.length;
        int[] numTrueSegments = new int[allIndex + 1];
        int[] numPredictedSegments = new int[allIndex + 1];
        int[] numCorrectSegments = new int[allIndex + 1];
        int numCorrectTokens = 0;
        int totalTokens = 0;
        for (int n2 = 0; n2 < numTrueSegments.length; ++n2) {
            numCorrectSegments[n2] = 0;
            numPredictedSegments[n2] = 0;
            numTrueSegments[n2] = 0;
        }
        assert (predOutput.size() == trueOutput.size());
        for (int j = 0; j < trueOutput.size(); ++j) {
            int m;
            ++totalTokens;
            if (trueOutput.get(j).equals(predOutput.get(j))) {
                ++numCorrectTokens;
            }
            int predStart = -1;
            int trueStart = -1;
            for (n = 0; n < this.segmentStartTags.length; ++n) {
                if (!this.segmentStartTags[n].equals(trueOutput.get(j))) continue;
                int n3 = n;
                numTrueSegments[n3] = numTrueSegments[n3] + 1;
                int n4 = allIndex;
                numTrueSegments[n4] = numTrueSegments[n4] + 1;
                trueStart = n;
                break;
            }
            for (n = 0; n < this.segmentStartTags.length; ++n) {
                if (!this.segmentStartTags[n].equals(predOutput.get(j))) continue;
                int n5 = n;
                numPredictedSegments[n5] = numPredictedSegments[n5] + 1;
                int n6 = allIndex;
                numPredictedSegments[n6] = numPredictedSegments[n6] + 1;
                predStart = n;
            }
            if (trueStart == -1 || trueStart != predStart) continue;
            boolean trueContinue = false;
            boolean predContinue = false;
            for (m = j + 1; m < trueOutput.size(); ++m) {
                trueContinue = this.segmentContinueTags[predStart].equals(trueOutput.get(m));
                predContinue = this.segmentContinueTags[predStart].equals(predOutput.get(m));
                if (trueContinue && predContinue) continue;
                if (trueContinue != predContinue) break;
                int n7 = predStart;
                numCorrectSegments[n7] = numCorrectSegments[n7] + 1;
                int n8 = allIndex;
                numCorrectSegments[n8] = numCorrectSegments[n8] + 1;
                break;
            }
            if (m != trueOutput.size() || trueContinue != predContinue) continue;
            int n9 = predStart;
            numCorrectSegments[n9] = numCorrectSegments[n9] + 1;
            int n10 = allIndex;
            numCorrectSegments[n10] = numCorrectSegments[n10] + 1;
        }
        int wrong = 0;
        for (n = 0; n < numCorrectSegments.length; ++n) {
            wrong += numTrueSegments[n] - numCorrectSegments[n];
        }
        return wrong;
    }

    public void batchTest(InstanceList data, List<Sequence> predictedSequences, String description, PrintStream viterbiOutputStream) {
        int allIndex = this.segmentStartTags.length;
        int[] numTrueSegments = new int[allIndex + 1];
        int[] numPredictedSegments = new int[allIndex + 1];
        int[] numCorrectSegments = new int[allIndex + 1];
        ArrayList sourceTokenSequence = null;
        int numCorrectTokens = 0;
        int totalTokens = 0;
        for (int n = 0; n < numTrueSegments.length; ++n) {
            numCorrectSegments[n] = 0;
            numPredictedSegments[n] = 0;
            numTrueSegments[n] = 0;
        }
        for (int i = 0; i < data.size(); ++i) {
            if (viterbiOutputStream != null) {
                viterbiOutputStream.println("Viterbi path for " + description + " instance #" + i);
            }
            Instance instance = (Instance)data.get(i);
            Sequence input = (Sequence)instance.getData();
            Sequence trueOutput = (Sequence)instance.getTarget();
            assert (input.size() == trueOutput.size());
            Sequence predOutput = predictedSequences.get(i);
            if (predOutput == null) continue;
            assert (predOutput.size() == trueOutput.size());
            for (int j = 0; j < trueOutput.size(); ++j) {
                int n;
                ++totalTokens;
                if (trueOutput.get(j).equals(predOutput.get(j))) {
                    ++numCorrectTokens;
                }
                int predStart = -1;
                int trueStart = -1;
                for (n = 0; n < this.segmentStartTags.length; ++n) {
                    if (!this.segmentStartTags[n].equals(trueOutput.get(j))) continue;
                    int n2 = n;
                    numTrueSegments[n2] = numTrueSegments[n2] + 1;
                    int n3 = allIndex;
                    numTrueSegments[n3] = numTrueSegments[n3] + 1;
                    trueStart = n;
                    break;
                }
                for (n = 0; n < this.segmentStartTags.length; ++n) {
                    if (!this.segmentStartTags[n].equals(predOutput.get(j))) continue;
                    int n4 = n;
                    numPredictedSegments[n4] = numPredictedSegments[n4] + 1;
                    int n5 = allIndex;
                    numPredictedSegments[n5] = numPredictedSegments[n5] + 1;
                    predStart = n;
                }
                if (trueStart != -1 && trueStart == predStart) {
                    int m;
                    boolean trueContinue = false;
                    boolean predContinue = false;
                    for (m = j + 1; m < trueOutput.size(); ++m) {
                        trueContinue = this.segmentContinueTags[predStart].equals(trueOutput.get(m));
                        predContinue = this.segmentContinueTags[predStart].equals(predOutput.get(m));
                        if (trueContinue && predContinue) continue;
                        if (trueContinue != predContinue) break;
                        int n6 = predStart;
                        numCorrectSegments[n6] = numCorrectSegments[n6] + 1;
                        int n7 = allIndex;
                        numCorrectSegments[n7] = numCorrectSegments[n7] + 1;
                        break;
                    }
                    if (m == trueOutput.size() && trueContinue == predContinue) {
                        int n8 = predStart;
                        numCorrectSegments[n8] = numCorrectSegments[n8] + 1;
                        int n9 = allIndex;
                        numCorrectSegments[n9] = numCorrectSegments[n9] + 1;
                    }
                }
                if (viterbiOutputStream == null) continue;
                FeatureVector fv = (FeatureVector)input.get(j);
                if (sourceTokenSequence != null) {
                    viterbiOutputStream.print(((Token)sourceTokenSequence.get(j)).getText() + ": ");
                }
                viterbiOutputStream.println(trueOutput.get(j).toString() + '/' + predOutput.get(j).toString() + "  " + fv.toString(true));
            }
        }
        DecimalFormat f = new DecimalFormat("0.####");
        logger.info(description + " tokenaccuracy=" + f.format((double)numCorrectTokens / (double)totalTokens));
        for (int n = 0; n < numCorrectSegments.length; ++n) {
            logger.info((n < allIndex ? this.segmentStartTags[n].toString() : "OVERALL") + ' ');
            double precision = numPredictedSegments[n] == 0 ? 1.0 : (double)numCorrectSegments[n] / (double)numPredictedSegments[n];
            double recall = numTrueSegments[n] == 0 ? 1.0 : (double)numCorrectSegments[n] / (double)numTrueSegments[n];
            double f1 = recall + precision == 0.0 ? 0.0 : 2.0 * recall * precision / (recall + precision);
            logger.info(" segments true=" + numTrueSegments[n] + " pred=" + numPredictedSegments[n] + " correct=" + numCorrectSegments[n] + " misses=" + (numTrueSegments[n] - numCorrectSegments[n]) + " alarms=" + (numPredictedSegments[n] - numCorrectSegments[n]));
            logger.info(" precision=" + f.format(precision) + " recall=" + f.format(recall) + " f1=" + f.format(f1));
        }
    }
}

