/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.FeatureVector;
import cc.mallet.types.Instance;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterEmptyFeatureVectors
extends Pipe {
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;

    @Override
    public Iterator<Instance> newIteratorFrom(Iterator<Instance> source) {
        return new FilteringPipeInstanceIterator(source);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FilteringPipeInstanceIterator
    implements Iterator<Instance> {
        Iterator<Instance> source;
        Instance nextInstance = null;
        boolean doesHaveNext = false;

        public FilteringPipeInstanceIterator(Iterator<Instance> source) {
            this.source = source;
            if (source.hasNext()) {
                this.nextInstance = source.next();
                this.doesHaveNext = true;
            } else {
                this.doesHaveNext = false;
            }
        }

        @Override
        public boolean hasNext() {
            return this.doesHaveNext;
        }

        @Override
        public Instance next() {
            Instance ret = this.nextInstance;
            this.doesHaveNext = false;
            while (this.source.hasNext()) {
                this.nextInstance = this.source.next();
                if (((FeatureVector)this.nextInstance.getData()).numLocations() <= 0) continue;
                this.doesHaveNext = true;
                break;
            }
            if (!this.doesHaveNext) {
                this.nextInstance = null;
            }
            return ret;
        }

        @Override
        public void remove() {
            throw new IllegalStateException("This iterator does not support remove().");
        }

        public Pipe getPipe() {
            return null;
        }

        public Iterator<Instance> getSourceIterator() {
            return this.source;
        }
    }
}

