/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.pipe;

import cc.mallet.pipe.Pipe;
import cc.mallet.types.Instance;
import cc.mallet.types.Token;
import cc.mallet.types.TokenSequence;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenSequenceRemoveStopwords
extends Pipe
implements Serializable {
    HashSet<String> stoplist = null;
    boolean caseSensitive = true;
    boolean markDeletions = false;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 2;
    static final String[] stopwords = new String[]{"a", "able", "about", "above", "according", "accordingly", "across", "actually", "after", "afterwards", "again", "against", "all", "allow", "allows", "almost", "alone", "along", "already", "also", "although", "always", "am", "among", "amongst", "an", "and", "another", "any", "anybody", "anyhow", "anyone", "anything", "anyway", "anyways", "anywhere", "apart", "appear", "appreciate", "appropriate", "are", "around", "as", "aside", "ask", "asking", "associated", "at", "available", "away", "awfully", "b", "be", "became", "because", "become", "becomes", "becoming", "been", "before", "beforehand", "behind", "being", "believe", "below", "beside", "besides", "best", "better", "between", "beyond", "both", "brief", "but", "by", "c", "came", "can", "cannot", "cant", "cause", "causes", "certain", "certainly", "changes", "clearly", "co", "com", "come", "comes", "concerning", "consequently", "consider", "considering", "contain", "containing", "contains", "corresponding", "could", "course", "currently", "d", "definitely", "described", "despite", "did", "different", "do", "does", "doing", "done", "down", "downwards", "during", "e", "each", "edu", "eg", "eight", "either", "else", "elsewhere", "enough", "entirely", "especially", "et", "etc", "even", "ever", "every", "everybody", "everyone", "everything", "everywhere", "ex", "exactly", "example", "except", "f", "far", "few", "fifth", "first", "five", "followed", "following", "follows", "for", "former", "formerly", "forth", "four", "from", "further", "furthermore", "g", "get", "gets", "getting", "given", "gives", "go", "goes", "going", "gone", "got", "gotten", "greetings", "h", "had", "happens", "hardly", "has", "have", "having", "he", "hello", "help", "hence", "her", "here", "hereafter", "hereby", "herein", "hereupon", "hers", "herself", "hi", "him", "himself", "his", "hither", "hopefully", "how", "howbeit", "however", "i", "ie", "if", "ignored", "immediate", "in", "inasmuch", "inc", "indeed", "indicate", "indicated", "indicates", "inner", "insofar", "instead", "into", "inward", "is", "it", "its", "itself", "j", "just", "k", "keep", "keeps", "kept", "know", "knows", "known", "l", "last", "lately", "later", "latter", "latterly", "least", "less", "lest", "let", "like", "liked", "likely", "little", "look", "looking", "looks", "ltd", "m", "mainly", "many", "may", "maybe", "me", "mean", "meanwhile", "merely", "might", "more", "moreover", "most", "mostly", "much", "must", "my", "myself", "n", "name", "namely", "nd", "near", "nearly", "necessary", "need", "needs", "neither", "never", "nevertheless", "new", "next", "nine", "no", "nobody", "non", "none", "noone", "nor", "normally", "not", "nothing", "novel", "now", "nowhere", "o", "obviously", "of", "off", "often", "oh", "ok", "okay", "old", "on", "once", "one", "ones", "only", "onto", "or", "other", "others", "otherwise", "ought", "our", "ours", "ourselves", "out", "outside", "over", "overall", "own", "p", "particular", "particularly", "per", "perhaps", "placed", "please", "plus", "possible", "presumably", "probably", "provides", "q", "que", "quite", "qv", "r", "rather", "rd", "re", "really", "reasonably", "regarding", "regardless", "regards", "relatively", "respectively", "right", "s", "said", "same", "saw", "say", "saying", "says", "second", "secondly", "see", "seeing", "seem", "seemed", "seeming", "seems", "seen", "self", "selves", "sensible", "sent", "serious", "seriously", "seven", "several", "shall", "she", "should", "since", "six", "so", "some", "somebody", "somehow", "someone", "something", "sometime", "sometimes", "somewhat", "somewhere", "soon", "sorry", "specified", "specify", "specifying", "still", "sub", "such", "sup", "sure", "t", "take", "taken", "tell", "tends", "th", "than", "thank", "thanks", "thanx", "that", "thats", "the", "their", "theirs", "them", "themselves", "then", "thence", "there", "thereafter", "thereby", "therefore", "therein", "theres", "thereupon", "these", "they", "think", "third", "this", "thorough", "thoroughly", "those", "though", "three", "through", "throughout", "thru", "thus", "to", "together", "too", "took", "toward", "towards", "tried", "tries", "truly", "try", "trying", "twice", "two", "u", "un", "under", "unfortunately", "unless", "unlikely", "until", "unto", "up", "upon", "us", "use", "used", "useful", "uses", "using", "usually", "uucp", "v", "value", "various", "very", "via", "viz", "vs", "w", "want", "wants", "was", "way", "we", "welcome", "well", "went", "were", "what", "whatever", "when", "whence", "whenever", "where", "whereafter", "whereas", "whereby", "wherein", "whereupon", "wherever", "whether", "which", "while", "whither", "who", "whoever", "whole", "whom", "whose", "why", "will", "willing", "wish", "with", "within", "without", "wonder", "would", "would", "x", "y", "yes", "yet", "you", "your", "yours", "yourself", "yourselves", "z", "zero"};
    static final String[] stopwordsFrench = new String[]{"fut", "S", "ces", "ral", "new", "tr", "arm", "y", "autres", "o", "tait", "dont", "ann", "apr", "sous", "ans", "cette", "politique", "of", "c", "contre", "leur", "ville", "fait", "res", "on", "deux", "cle", "v", "publique", "france", "te", "guerre", "sident", "unis", "mais", "entre", "aussi", "tat", "ais", "ses", "sa", "ont", "tre", "d", "pays", "en", "Il", "tats", "comme", "am", "si", "c", "fran", "pas", "g", "qu", "R", "aux", "ce", "f", "p", "ne", "son", "me", "avec", "l", "se", "ou", "sont", "il", "Les", "re", "plus", "m", "es", "pr", "la", "sur", "que", "pour", "modifier", "a", "qui", "Le", "t", "n", "au", "dans", "une", "par", "un", "r", "est", "e", "du", "s", "les", "en", "des", "le", "et", "l", "d", "la", "de"};

    private HashSet<String> newDefaultStopList() {
        HashSet<String> sl = new HashSet<String>();
        for (int i = 0; i < stopwords.length; ++i) {
            sl.add(stopwords[i]);
        }
        return sl;
    }

    public TokenSequenceRemoveStopwords(boolean caseSensitive, boolean markDeletions) {
        this.stoplist = this.newDefaultStopList();
        this.caseSensitive = caseSensitive;
        this.markDeletions = markDeletions;
    }

    public TokenSequenceRemoveStopwords(boolean caseSensitive) {
        this.stoplist = this.newDefaultStopList();
        this.caseSensitive = caseSensitive;
    }

    public TokenSequenceRemoveStopwords() {
        this(false);
    }

    public TokenSequenceRemoveStopwords(File stoplistFile, String encoding, boolean includeDefault, boolean caseSensitive, boolean markDeletions) {
        this.stoplist = !includeDefault ? new HashSet() : this.newDefaultStopList();
        this.addStopWords(this.fileToStringArray(stoplistFile, encoding));
        this.caseSensitive = caseSensitive;
        this.markDeletions = markDeletions;
    }

    public TokenSequenceRemoveStopwords setCaseSensitive(boolean flag) {
        this.caseSensitive = flag;
        return this;
    }

    public TokenSequenceRemoveStopwords setMarkDeletions(boolean flag) {
        this.markDeletions = flag;
        return this;
    }

    public TokenSequenceRemoveStopwords addStopWords(String[] words) {
        for (int i = 0; i < words.length; ++i) {
            this.stoplist.add(words[i]);
        }
        return this;
    }

    public TokenSequenceRemoveStopwords removeStopWords(String[] words) {
        for (int i = 0; i < words.length; ++i) {
            this.stoplist.remove(words[i]);
        }
        return this;
    }

    public TokenSequenceRemoveStopwords removeStopWords(File wordlist) {
        this.removeStopWords(this.fileToStringArray(wordlist, null));
        return this;
    }

    public TokenSequenceRemoveStopwords addStopWords(File wordlist) {
        if (wordlist != null) {
            this.addStopWords(this.fileToStringArray(wordlist, null));
        }
        return this;
    }

    private String[] fileToStringArray(File f, String encoding) {
        ArrayList<String> wordarray = new ArrayList<String>();
        try {
            String line;
            BufferedReader input = null;
            input = encoding == null ? new BufferedReader(new FileReader(f)) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), encoding));
            while ((line = input.readLine()) != null) {
                String[] words = line.split("\\s+");
                for (int i = 0; i < words.length; ++i) {
                    wordarray.add(words[i]);
                }
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Trouble reading file " + f);
        }
        return wordarray.toArray(new String[0]);
    }

    @Override
    public Instance pipe(Instance carrier) {
        TokenSequence ts = (TokenSequence)carrier.getData();
        TokenSequence ret = new TokenSequence();
        Token prevToken = null;
        for (int i = 0; i < ts.size(); ++i) {
            Token t = (Token)ts.get(i);
            if (!this.stoplist.contains(this.caseSensitive ? t.getText() : t.getText().toLowerCase())) {
                ret.add(t);
                prevToken = t;
                continue;
            }
            if (!this.markDeletions || prevToken == null) continue;
            prevToken.setProperty("NextTokenDeleted", t.getText());
        }
        carrier.setData(ret);
        return carrier;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(2);
        out.writeBoolean(this.caseSensitive);
        out.writeBoolean(this.markDeletions);
        out.writeObject(this.stoplist);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        this.caseSensitive = in.readBoolean();
        if (version > 0) {
            this.markDeletions = in.readBoolean();
        }
        if (version > 1) {
            this.stoplist = (HashSet)in.readObject();
        }
    }
}

