/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.types.ConstantMatrix;
import cc.mallet.types.Matrix;
import cc.mallet.util.Maths;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public abstract class DenseMatrix
implements Matrix,
Serializable {
    double[] values;
    protected boolean hasInfinite;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 0;
    private static final int NULL_INTEGER = -1;

    public abstract int getNumDimensions();

    public abstract int getDimensions(int[] var1);

    public abstract double value(int[] var1);

    public abstract void setValue(int[] var1, double var2);

    public abstract ConstantMatrix cloneMatrix();

    public abstract int singleIndex(int[] var1);

    public abstract void singleToIndices(int var1, int[] var2);

    public double singleValue(int i) {
        return this.values[i];
    }

    public void setSingleValue(int i, double value) {
        this.values[i] = value;
    }

    public void incrementSingleValue(int i, double delta) {
        int n = i;
        this.values[n] = this.values[n] + delta;
    }

    public void setValueAtLocation(int loc, double value) {
        this.setSingleValue(loc, value);
    }

    public int singleSize() {
        return this.values.length;
    }

    public int numLocations() {
        return this.values.length;
    }

    public int location(int index) {
        return index;
    }

    public double valueAtLocation(int location) {
        return this.values[location];
    }

    public int indexAtLocation(int location) {
        return location;
    }

    public void setAll(double v) {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = v;
        }
    }

    public void set(ConstantMatrix m) {
        if (m instanceof DenseMatrix) {
            assert (m.singleSize() == this.values.length);
            System.arraycopy(((DenseMatrix)m).values, 0, this.values, 0, this.values.length);
        } else {
            for (int i = m.numLocations() - 1; i >= 0; --i) {
                this.values[m.indexAtLocation((int)i)] = m.valueAtLocation(i);
            }
        }
    }

    public void setWithAddend(ConstantMatrix m, double addend) {
        if (m instanceof DenseMatrix) {
            assert (m.singleSize() == this.values.length);
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = ((DenseMatrix)m).values[i] + addend;
            }
        } else {
            for (int i = m.numLocations() - 1; i >= 0; --i) {
                this.values[m.indexAtLocation((int)i)] = m.valueAtLocation(i) + addend;
            }
        }
    }

    public void setWithFactor(ConstantMatrix m, double factor) {
        if (m instanceof DenseMatrix) {
            assert (m.singleSize() == this.values.length);
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = ((DenseMatrix)m).values[i] * factor;
            }
        } else {
            for (int i = m.numLocations() - 1; i >= 0; --i) {
                this.values[m.indexAtLocation((int)i)] = m.valueAtLocation(i) * factor;
            }
        }
    }

    public void plusEquals(double v) {
        int i = 0;
        while (i < this.values.length) {
            int n = i++;
            this.values[n] = this.values[n] + v;
        }
    }

    public void plusEquals(ConstantMatrix m) {
        if (m instanceof DenseMatrix) {
            assert (m.singleSize() == this.values.length);
            for (int i = 0; i < this.values.length; ++i) {
                if (Double.isInfinite(this.values[i]) && Double.isInfinite(m.valueAtLocation(i))) {
                    double newValue = m.valueAtLocation(i);
                    if (newValue * this.values[i] < 0.0) {
                        this.values[i] = 0.0;
                        continue;
                    }
                    int n = i;
                    this.values[n] = this.values[n] + newValue;
                    continue;
                }
                int n = i;
                this.values[n] = this.values[n] + m.valueAtLocation(i);
            }
        } else {
            for (int i = m.numLocations() - 1; i >= 0; --i) {
                if (Double.isInfinite(this.values[m.indexAtLocation(i)]) && Double.isInfinite(((DenseMatrix)m).values[i])) {
                    double newValue = m.valueAtLocation(i);
                    if (newValue * this.values[m.indexAtLocation(i)] < 0.0) {
                        this.values[m.indexAtLocation((int)i)] = 0.0;
                        continue;
                    }
                    int n = m.indexAtLocation(i);
                    this.values[n] = this.values[n] + newValue;
                    continue;
                }
                int n = m.indexAtLocation(i);
                this.values[n] = this.values[n] + m.valueAtLocation(i);
            }
        }
    }

    public void plusEquals(ConstantMatrix m, double factor) {
        if (m instanceof DenseMatrix) {
            assert (m.singleSize() == this.values.length);
            for (int i = 0; i < this.values.length; ++i) {
                if (Double.isInfinite(this.values[i]) && Double.isInfinite(m.valueAtLocation(i))) {
                    double newValue = factor * m.valueAtLocation(i);
                    if (newValue * this.values[i] < 0.0) {
                        this.values[i] = 0.0;
                        continue;
                    }
                    int n = i;
                    this.values[n] = this.values[n] + newValue;
                    continue;
                }
                int n = i;
                this.values[n] = this.values[n] + m.valueAtLocation(i) * factor;
            }
        } else {
            for (int i = m.numLocations() - 1; i >= 0; --i) {
                if (Double.isInfinite(this.values[m.indexAtLocation(i)]) && Double.isInfinite(m.valueAtLocation(i))) {
                    double newValue = factor * m.valueAtLocation(i);
                    if (newValue * this.values[m.indexAtLocation(i)] < 0.0) {
                        this.values[m.indexAtLocation((int)i)] = 0.0;
                        continue;
                    }
                    int n = m.indexAtLocation(i);
                    this.values[n] = this.values[n] + newValue;
                    continue;
                }
                int n = m.indexAtLocation(i);
                this.values[n] = this.values[n] + m.valueAtLocation(i) * factor;
            }
        }
    }

    public void equalsPlus(double factor, ConstantMatrix m) {
        if (m instanceof DenseMatrix) {
            assert (m.singleSize() == this.values.length);
            for (int i = 0; i < this.values.length; ++i) {
                if (Double.isInfinite(this.values[i]) && Double.isInfinite(((DenseMatrix)m).values[i])) {
                    double lhs = factor * this.values[i];
                    double rhs = ((DenseMatrix)m).values[i];
                    if (lhs * rhs < 0.0) {
                        this.values[i] = 0.0;
                        continue;
                    }
                    this.values[i] = lhs + rhs;
                    continue;
                }
                this.values[i] = factor * this.values[i] + ((DenseMatrix)m).values[i];
            }
        } else {
            for (int i = m.numLocations() - 1; i >= 0; --i) {
                if (Double.isInfinite(this.values[m.indexAtLocation(i)]) && Double.isInfinite(((DenseMatrix)m).values[i])) {
                    double rhs;
                    double lhs = factor * this.values[m.indexAtLocation(i)];
                    if (lhs * (rhs = m.valueAtLocation(i)) < 0.0) {
                        this.values[m.indexAtLocation((int)i)] = 0.0;
                        continue;
                    }
                    this.values[m.indexAtLocation((int)i)] = lhs + rhs;
                    continue;
                }
                this.values[m.indexAtLocation((int)i)] = factor * this.values[m.indexAtLocation(i)] + m.valueAtLocation(i);
            }
        }
    }

    public void timesEquals(double factor) {
        int i = 0;
        while (i < this.values.length) {
            int n = i++;
            this.values[n] = this.values[n] * factor;
        }
    }

    public void elementwiseTimesEquals(ConstantMatrix m) {
        if (m instanceof DenseMatrix) {
            assert (m.singleSize() == this.values.length);
            for (int i = 0; i < this.values.length; ++i) {
                int n = i;
                this.values[n] = this.values[n] * ((DenseMatrix)m).values[i];
            }
        } else {
            for (int i = m.numLocations() - 1; i >= 0; --i) {
                int n = m.indexAtLocation(i);
                this.values[n] = this.values[n] * m.valueAtLocation(i);
            }
        }
    }

    public void elementwiseTimesEquals(ConstantMatrix m, double factor) {
        if (m instanceof DenseMatrix) {
            assert (m.singleSize() == this.values.length);
            for (int i = 0; i < this.values.length; ++i) {
                int n = i;
                this.values[n] = this.values[n] * (((DenseMatrix)m).values[i] * factor);
            }
        } else {
            for (int i = m.numLocations() - 1; i >= 0; --i) {
                int n = m.indexAtLocation(i);
                this.values[n] = this.values[n] * (m.valueAtLocation(i) * factor);
            }
        }
    }

    public void divideEquals(double factor) {
        int i = 0;
        while (i < this.values.length) {
            int n = i++;
            this.values[n] = this.values[n] / factor;
        }
    }

    public void elementwiseDivideEquals(ConstantMatrix m) {
        if (m instanceof DenseMatrix) {
            assert (m.singleSize() == this.values.length);
            for (int i = 0; i < this.values.length; ++i) {
                int n = i;
                this.values[n] = this.values[n] / ((DenseMatrix)m).values[i];
            }
        } else {
            for (int i = m.numLocations() - 1; i >= 0; --i) {
                int n = m.indexAtLocation(i);
                this.values[n] = this.values[n] / m.valueAtLocation(i);
            }
        }
    }

    public void elementwiseDivideEquals(ConstantMatrix m, double factor) {
        if (m instanceof DenseMatrix) {
            assert (m.singleSize() == this.values.length);
            for (int i = 0; i < this.values.length; ++i) {
                int n = i;
                this.values[n] = this.values[n] / (((DenseMatrix)m).values[i] * factor);
            }
        } else {
            for (int i = m.numLocations() - 1; i >= 0; --i) {
                int n = m.indexAtLocation(i);
                this.values[n] = this.values[n] / (m.valueAtLocation(i) * factor);
            }
        }
    }

    public double dotProduct(ConstantMatrix m) {
        double ret = 0.0;
        if (m instanceof DenseMatrix) {
            assert (m.singleSize() == this.values.length);
            for (int i = 0; i < this.values.length; ++i) {
                ret += this.values[i] * ((DenseMatrix)m).values[i];
            }
        } else {
            for (int i = m.numLocations() - 1; i >= 0; --i) {
                if (m.indexAtLocation(i) >= this.values.length) continue;
                ret += this.values[m.indexAtLocation(i)] * m.valueAtLocation(i);
            }
        }
        return ret;
    }

    public double absNorm() {
        double ret = 0.0;
        for (int i = 0; i < this.values.length; ++i) {
            ret += Math.abs(this.values[i]);
        }
        return ret;
    }

    public double oneNorm() {
        double ret = 0.0;
        for (int i = 0; i < this.values.length; ++i) {
            ret += this.values[i];
        }
        return ret;
    }

    public double twoNorm() {
        double ret = 0.0;
        for (int i = 0; i < this.values.length; ++i) {
            ret += this.values[i] * this.values[i];
        }
        return Math.sqrt(ret);
    }

    public double infinityNorm() {
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.values.length; ++i) {
            if (!(Math.abs(this.values[i]) > max)) continue;
            max = Math.abs(this.values[i]);
        }
        return max;
    }

    public double oneNormalize() {
        double norm = this.oneNorm();
        int i = 0;
        while (i < this.values.length) {
            int n = i++;
            this.values[n] = this.values[n] / norm;
        }
        return norm;
    }

    public double twoNormalize() {
        double norm = this.twoNorm();
        int i = 0;
        while (i < this.values.length) {
            int n = i++;
            this.values[n] = this.values[n] / norm;
        }
        return norm;
    }

    public double absNormalize() {
        double norm = this.absNorm();
        if (norm > 0.0) {
            int i = 0;
            while (i < this.values.length) {
                int n = i++;
                this.values[n] = this.values[n] / norm;
            }
        }
        return norm;
    }

    public double infinityNormalize() {
        double norm = this.infinityNorm();
        int i = 0;
        while (i < this.values.length) {
            int n = i++;
            this.values[n] = this.values[n] / norm;
        }
        return norm;
    }

    public void print() {
        for (int i = 0; i < this.values.length; ++i) {
            System.out.println("DenseMatrix[" + i + "] = " + this.values[i]);
        }
    }

    public boolean isNaN() {
        for (int i = 0; i < this.values.length; ++i) {
            if (!Double.isNaN(this.values[i])) continue;
            return true;
        }
        return false;
    }

    public final void substitute(double oldValue, double newValue) {
        for (int i = this.values.length - 1; i >= 0; --i) {
            if (this.values[i] != oldValue) continue;
            this.values[i] = newValue;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(0);
        if (this.values != null) {
            int size = this.values.length;
            out.writeInt(size);
            for (int i = 0; i < size; ++i) {
                out.writeDouble(this.values[i]);
            }
        } else {
            out.writeInt(-1);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.hasInfinite = false;
        int version = in.readInt();
        int size = in.readInt();
        if (size != -1) {
            this.values = new double[size];
            for (int i = 0; i < size; ++i) {
                this.values[i] = in.readDouble();
                if (!Double.isInfinite(this.values[i])) continue;
                this.hasInfinite = true;
            }
        } else {
            this.values = null;
        }
    }

    public static void plusEquals(double[] accumulator, double[] addend) {
        assert (accumulator.length == addend.length);
        for (int i = 0; i < addend.length; ++i) {
            int n = i;
            accumulator[n] = accumulator[n] + addend[i];
        }
    }

    public static void plusEquals(double[] accumulator, double[] addend, double factor) {
        assert (accumulator.length == addend.length);
        for (int i = 0; i < addend.length; ++i) {
            int n = i;
            accumulator[n] = accumulator[n] + factor * addend[i];
        }
    }

    public static void timesEquals(double[] accumulator, double[] product) {
        assert (accumulator.length == product.length);
        for (int i = 0; i < product.length; ++i) {
            int n = i;
            accumulator[n] = accumulator[n] * product[i];
        }
    }

    public static double infinityNorm(double[] vector) {
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < vector.length; ++i) {
            if (!(Math.abs(vector[i]) > max)) continue;
            max = Math.abs(vector[i]);
        }
        return max;
    }

    public boolean almostEquals(ConstantMatrix m2) {
        int i;
        if (this.getNumDimensions() != m2.getNumDimensions()) {
            return false;
        }
        if (this.numLocations() != m2.numLocations()) {
            return false;
        }
        int[] dims1 = new int[this.getNumDimensions()];
        int[] dims2 = new int[this.getNumDimensions()];
        this.getDimensions(dims1);
        m2.getDimensions(dims2);
        for (i = 0; i < dims1.length; ++i) {
            if (dims1[i] == dims2[i]) continue;
            return false;
        }
        for (i = 0; i < this.numLocations(); ++i) {
            if (Maths.almostEquals(this.valueAtLocation(i), m2.valueAtLocation(i))) continue;
            return false;
        }
        return true;
    }
}

