/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.util.tests;

import cc.mallet.util.search.MinHeap;
import cc.mallet.util.search.QueueElement;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestPriorityQueue
extends TestCase {
    private static final int N = 100;

    public TestPriorityQueue(String name) {
        super(name);
    }

    public void testAscending() {
        MinHeap q = new MinHeap(100);
        double[] p = new double[100];
        for (int i = 0; i < 100; ++i) {
            p[i] = i;
            Item e = new Item(i);
            q.insert(e);
        }
        int j = 0;
        double pr = Double.NEGATIVE_INFINITY;
        TestPriorityQueue.assertTrue((String)"ascending size", (q.size() == 100 ? 1 : 0) != 0);
        while (q.size() > 0) {
            TestPriorityQueue.assertTrue((String)"ascending extract", (j < 100 ? 1 : 0) != 0);
            QueueElement e = q.extractMin();
            TestPriorityQueue.assertTrue((String)"ascending order", (e.getPriority() > pr ? 1 : 0) != 0);
            TestPriorityQueue.assertEquals((String)"ascending priority", (double)e.getPriority(), (double)p[j++], (double)1.0E-5);
            pr = e.getPriority();
        }
    }

    public void testDescending() {
        MinHeap q = new MinHeap(100);
        double[] p = new double[100];
        for (int i = 0; i < 100; ++i) {
            p[i] = i;
            Item e = new Item(100 - i - 1);
            q.insert(e);
        }
        int j = 0;
        double pr = Double.NEGATIVE_INFINITY;
        TestPriorityQueue.assertTrue((String)"descending size", (q.size() == 100 ? 1 : 0) != 0);
        while (q.size() > 0) {
            TestPriorityQueue.assertTrue((String)"descending extract", (j < 100 ? 1 : 0) != 0);
            QueueElement e = q.extractMin();
            TestPriorityQueue.assertTrue((String)"descending order", (e.getPriority() > pr ? 1 : 0) != 0);
            TestPriorityQueue.assertEquals((String)"descending priority", (double)e.getPriority(), (double)p[j++], (double)1.0E-5);
            pr = e.getPriority();
        }
    }

    public void testChangePriority() {
        MinHeap q = new MinHeap(100);
        Item[] items = new Item[100];
        for (int i = 0; i < 100; ++i) {
            Item e = new Item(100 - i - 1);
            q.insert(e);
            items[i] = e;
        }
        q.changePriority(items[99], -2.0);
        q.changePriority(items[50], -1.0);
        q.changePriority(items[51], 200.0);
        int j = 0;
        double pr_last = Double.NEGATIVE_INFINITY;
        TestPriorityQueue.assertTrue((String)"descending size", (q.size() == 100 ? 1 : 0) != 0);
        while (q.size() > 0) {
            TestPriorityQueue.assertTrue((String)"descending extract", (j < 100 ? 1 : 0) != 0);
            QueueElement e = q.extractMin();
            TestPriorityQueue.assertTrue((String)"descending order", (e.getPriority() > pr_last ? 1 : 0) != 0);
            pr_last = e.getPriority();
            if (j == 0) {
                TestPriorityQueue.assertTrue((String)"lowest elt", (e.getPriority() == -2.0 ? 1 : 0) != 0);
            }
            if (j == 1) {
                TestPriorityQueue.assertTrue((String)"second-lowest elt", (e.getPriority() == -1.0 ? 1 : 0) != 0);
            }
            if (q.size() == 1) {
                TestPriorityQueue.assertTrue((String)"penultimate elt", (e.getPriority() == 99.0 ? 1 : 0) != 0);
            }
            if (q.size() == 0) {
                TestPriorityQueue.assertTrue((String)"final elt", (e.getPriority() == 200.0 ? 1 : 0) != 0);
            }
            ++j;
        }
    }

    public void testReverse() {
        int i;
        MinHeap q = new MinHeap(100);
        Item[] items = new Item[100];
        for (i = 0; i < 100; ++i) {
            Item e = new Item(100 - i - 1);
            q.insert(e);
            items[i] = e;
        }
        for (i = 0; i < 100; ++i) {
            q.changePriority(items[i], i);
        }
        int j = 0;
        double pr_last = Double.NEGATIVE_INFINITY;
        TestPriorityQueue.assertTrue((String)"ascending size", (q.size() == 100 ? 1 : 0) != 0);
        while (q.size() > 0) {
            TestPriorityQueue.assertTrue((String)"ascending extract", (j < 100 ? 1 : 0) != 0);
            QueueElement e = q.extractMin();
            TestPriorityQueue.assertTrue((String)"ascending order", (e.getPriority() > pr_last ? 1 : 0) != 0);
            pr_last = e.getPriority();
            TestPriorityQueue.assertEquals((String)"ascending priority", (Object)items[j].getPriority(), (Object)e.getPriority());
            TestPriorityQueue.assertEquals((String)"ascending identity", (Object)items[j], (Object)e);
            ++j;
        }
    }

    public void testEqualKeys() {
        QueueElement e;
        int i;
        MinHeap q = new MinHeap(100);
        Item[] items = new Item[20];
        int j = 0;
        for (i = 0; i < 5; ++i) {
            items[j] = new Item(5.0);
            q.insert(items[j]);
            ++j;
        }
        for (i = 0; i < 5; ++i) {
            items[j] = new Item(3.0);
            q.insert(items[j]);
            ++j;
        }
        for (i = 0; i < 5; ++i) {
            items[j] = new Item(4.0);
            q.insert(items[j]);
            ++j;
        }
        for (i = 0; i < 5; ++i) {
            items[j] = new Item(7.0);
            q.insert(items[j]);
            ++j;
        }
        TestPriorityQueue.assertEquals((int)20, (int)q.size());
        for (i = 0; i < items.length; ++i) {
            TestPriorityQueue.assertTrue((boolean)q.contains(items[i]));
        }
        for (i = 0; i < 5; ++i) {
            e = q.extractMin();
            TestPriorityQueue.assertTrue((boolean)q.contains(q.min()));
            TestPriorityQueue.assertEquals((Object)3.0, (Object)e.getPriority());
        }
        for (i = 0; i < 5; ++i) {
            e = q.extractMin();
            TestPriorityQueue.assertTrue((boolean)q.contains(q.min()));
            TestPriorityQueue.assertEquals((Object)4.0, (Object)e.getPriority());
        }
        for (i = 0; i < 5; ++i) {
            e = q.extractMin();
            TestPriorityQueue.assertTrue((boolean)q.contains(q.min()));
            TestPriorityQueue.assertEquals((Object)5.0, (Object)e.getPriority());
        }
        for (i = 0; i < 5; ++i) {
            e = q.extractMin();
            if (q.size() > 0) {
                TestPriorityQueue.assertTrue((boolean)q.contains(q.min()));
            }
            TestPriorityQueue.assertEquals((Object)7.0, (Object)e.getPriority());
        }
    }

    public static Test suite() {
        return new TestSuite(TestPriorityQueue.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestPriorityQueue.suite());
    }

    private static class Item
    implements QueueElement {
        private int position;
        private double priority;

        private Item(double p) {
            this.priority = p;
        }

        public double getPriority() {
            return this.priority;
        }

        public void setPriority(double p) {
            this.priority = p;
        }

        public int getPosition() {
            return this.position;
        }

        public void setPosition(int p) {
            this.position = p;
        }
    }
}

