note

	description:

		"Objects that implement the XPath QName() function"

	library: "Gobo Eiffel XPath Library"
	copyright: "Copyright (c) 2005-2015, Colin Adams and others"
	license: "MIT License"
	date: "$Date: 2016-05-06 19:15:38 +0000 (Fri, 06 May 2016) $"
	revision: "$Revision: 98678 $"

class XM_XPATH_QNAME

inherit

	XM_XPATH_SYSTEM_FUNCTION
		redefine
			evaluate_item
		end

	-- TODO: pre-evaluate

create

	make

feature {NONE} -- Initialization

	make
			-- Establish invariant
		do
			name := "QName"; namespace_uri := Xpath_standard_functions_uri
			fingerprint := Qname_function_type_code
			minimum_argument_count := 2
			maximum_argument_count := 2
			create arguments.make (2)
			arguments.set_equality_tester (expression_tester)
			initialized := True
		end

feature -- Access

	item_type: XM_XPATH_ITEM_TYPE
			-- Data type of the expression, where known
		do
			Result := type_factory.qname_type
			if Result /= Void then
				-- Bug in SE 1.0 and 1.1: Make sure that
				-- that `Result' is not optimized away.
			end
		end

feature -- Status report

	required_type (argument_number: INTEGER): XM_XPATH_SEQUENCE_TYPE
			-- Type of argument number `argument_number'
		do
			if argument_number = 1 then
				create Result.make_optional_string
			else
				create Result.make_single_string
			end
		end

feature -- Evaluation

	evaluate_item (a_result: DS_CELL [detachable XM_XPATH_ITEM]; a_context: XM_XPATH_CONTEXT)
			-- Evaluate as a single item to `a_result'.
		local
			l_parser: XM_XPATH_QNAME_PARSER
			l_uri: detachable STRING
			l_name_code: INTEGER
		do
			arguments.item (1).evaluate_item (a_result, a_context)
			if not attached a_result.item as a_result_item_1 then
				l_uri := ""
			elseif a_result_item_1.is_error then
				-- nothing to do
			else
				l_uri := a_result_item_1.string_value
			end
			if l_uri /= Void then
				a_result.put (Void)
				arguments.item (2).evaluate_item (a_result, a_context)
				check attached a_result.item as a_result_item_2 then
					if not a_result_item_2.is_error then
						create l_parser.make (a_result_item_2.string_value)
						if l_parser.is_valid then
							check attached l_parser.optional_prefix as l_parser_optional_prefix and attached l_parser.local_name as l_parser_local_name then
								if not shared_name_pool.is_name_code_allocated (l_parser_optional_prefix, l_uri, l_parser_local_name) then
									shared_name_pool.allocate_name (l_parser_optional_prefix, l_uri, l_parser_local_name)
									l_name_code := shared_name_pool.last_name_code
								else
									l_name_code := shared_name_pool.name_code (l_parser_optional_prefix, l_uri, l_parser_local_name)
								end
								a_result.put (create {XM_XPATH_QNAME_VALUE}.make (l_name_code))
							end
						else
							a_result.put (create {XM_XPATH_INVALID_ITEM}.make_from_string ("Second argument to fn:QName() is not a lexical QName",
								Xpath_errors_uri, "FOCA0002", Dynamic_error))
						end
					end
				end
			end
		end

feature {XM_XPATH_EXPRESSION} -- Restricted

	compute_cardinality
			-- Compute cardinality.
		do
			set_cardinality_exactly_one
		end

end

