/*
 * Code for class PATH
 */

#include "eif_eiffel.h"
#include "../E1/estructure.h"
#include "../E1/eoffsets.h"

#include "pa608.h"
#include "eif_built_in.h"
#include "eif_path_name.h"
#include "eif_eiffel.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifndef INLINE_F1196_11136
static int inline_F1196_11136 (EIF_POINTER arg1, EIF_POINTER arg2)
{
	EIF_BOOLEAN Result = EIF_FALSE;
#ifdef EIF_WINDOWS
		/* To check this, we use `CreateFileW' to open both file, and then using the information
		 * returned by `GetFileInformationByHandle' we can check whether or not they are indeed
		 * the same.
		 * Note: it is important to use the W version of CreateFileW because arguments
		 * are Unicode, not ASCII. */
	BY_HANDLE_FILE_INFORMATION l_path1_info, l_path2_info;
	HANDLE l_path2_file = CreateFileW ((LPCWSTR) arg2, GENERIC_READ, FILE_SHARE_READ, NULL,
		OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	HANDLE l_path1_file = CreateFileW ((LPCWSTR) arg1, GENERIC_READ, FILE_SHARE_READ, NULL,
			OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);

	if ((l_path2_file == INVALID_HANDLE_VALUE) || (l_path1_file == INVALID_HANDLE_VALUE)) {
			/* We do not need the handles anymore, simply close them. Since Microsoft
			 * API accepts INVALID_HANDLE_VALUE we don't check the validity of arguments. */
		CloseHandle(l_path2_file);
		CloseHandle(l_path1_file);
	} else {
		BOOL success = GetFileInformationByHandle (l_path2_file, &l_path2_info);
		success = success && GetFileInformationByHandle (l_path1_file, &l_path1_info);
			/* We do not need the handles anymore, simply close them. */
		CloseHandle(l_path2_file);
		CloseHandle(l_path1_file);
		if (success) {
				/* Check that `path2' and `path1' do not represent the same file. */
			if
				((l_path2_info.dwVolumeSerialNumber == l_path1_info.dwVolumeSerialNumber) &&
				(l_path2_info.nFileIndexLow == l_path1_info.nFileIndexLow) &&
				(l_path2_info.nFileIndexHigh == l_path1_info.nFileIndexHigh))
			{
				Result = EIF_TRUE;
			}
		}
	}
#else
	struct stat buf1, buf2;
	int status;
	#ifdef HAS_LSTAT
		status = lstat(arg1, &buf1);
		if (status == 0) {
				/* We found a file, now let's check if it is not a symbolic link. If it is, we use `stat'
			 	 * to ensure the validity of the link. */
			if ((buf1.st_mode & S_IFLNK) == S_IFLNK) {
				status = stat (arg1, &buf1);
			}
		}
		
		if (status == 0) {
			status = lstat(arg2, &buf2);
			if (status == 0) {
					/* We found a file, now let's check if it is not a symbolic link. If it is, we use `stat'
				 	 * to ensure the validity of the link. */
				if ((buf2.st_mode & S_IFLNK) == S_IFLNK) {
					status = stat (arg2, &buf2);
				}
			}
		}
	#else
		status = stat (arg1, &buf1);
		if (status == 0) {
			status = stat (arg2, &buf2);
		}
	#endif
	if (status == 0) {
			/* Both files are present, check they represent the same one. */
		if ((buf1.st_dev == buf2.st_dev) && (buf1.st_ino == buf2.st_ino)) {
			Result = EIF_TRUE;
		}
	}
#endif
return Result;
	;
}
#define INLINE_F1196_11136
#endif

#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
extern "C" {
#endif

/* {PATH}.make_empty */
void F1196_11075 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTGC;
	tr1 = RTLNSMART(eif_new_type(1178, 1).id);
	F1171_10143(RTCW(tr1));
	RTAR(Current, tr1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	*(EIF_BOOLEAN *)(Current+ _CHROFF_2_0_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	F1196_11122(Current);
	RTLE;
}

/* {PATH}.make_current */
void F1196_11076 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTGC;
	tr1 = RTLNSMART(eif_new_type(1178, 1).id);
	ti4_1 = F1196_11121(Current);
	F1177_10440(RTCW(tr1), ti4_1);
	RTAR(Current, tr1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	tr1 = *(EIF_REFERENCE *)(Current);
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R8856[Dtype(RTCW(tr1))-1178])(tr1, (EIF_CHARACTER_8) '.');
	if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
		tr1 = *(EIF_REFERENCE *)(Current);
		(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R8856[Dtype(RTCW(tr1))-1178])(tr1, (EIF_CHARACTER_8) '\000');
	}
	*(EIF_BOOLEAN *)(Current+ _CHROFF_2_0_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	F1196_11122(Current);
	RTLE;
}

/* {PATH}.make_from_string */
void F1196_11077 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	RTLD;
	
	RTLI(3);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,arg1);
	RTLIU(3);
	
	RTGC;
	tr1 = RTLNSMART(eif_new_type(1178, 1).id);
	ti4_1 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R8629[Dtype(RTCW(arg1))-1174])(arg1);
	ti4_2 = F1196_11121(Current);
	F1177_10440(RTCW(tr1), (EIF_INTEGER_32) (ti4_1 * ti4_2));
	RTAR(Current, tr1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	tb1 = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE)) R8607[Dtype(RTCW(arg1))-1174])(arg1);
	if ((EIF_BOOLEAN) !tb1) {
		F1196_11130(Current, *(EIF_REFERENCE *)(Current), arg1, (EIF_CHARACTER_8) '\000');
		F1196_11123(Current);
	} else {
		*(EIF_BOOLEAN *)(Current+ _CHROFF_2_0_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	}
	F1196_11122(Current);
	RTLE;
}

/* {PATH}.make_from_storage */
void F1196_11079 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,arg1);
	RTLIU(2);
	
	RTGC;
	RTAR(Current, arg1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) arg1;
	F1196_11123(Current);
	F1196_11122(Current);
	RTLE;
}

/* {PATH}.make_from_normalized_storage */
void F1196_11080 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,arg1);
	RTLIU(2);
	
	RTGC;
	RTAR(Current, arg1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) arg1;
	*(EIF_BOOLEAN *)(Current+ _CHROFF_2_0_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	F1196_11122(Current);
	RTLE;
}

/* {PATH}.make_from_pointer */
void F1196_11081 (EIF_REFERENCE Current, EIF_POINTER arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_BOOLEAN tb1;
	RTLD;
	
	RTLI(3);
	RTLR(0,Current);
	RTLR(1,loc1);
	RTLR(2,tr1);
	RTLIU(3);
	
	RTGC;
	loc2 = F456_6143(Current, arg1);
	loc2 -= (EIF_INTEGER_32) (loc2 % F1196_11121(Current));
	loc1 = RTLNS(eif_new_type(486, 0x01).id, 486, _OBJSIZ_1_0_0_1_0_0_0_0_);
	F487_6367(RTCW(loc1), arg1, loc2);
	tr1 = F487_6375(RTCW(loc1), ((EIF_INTEGER_32) 1L), loc2);
	RTAR(Current, tr1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	tr1 = *(EIF_REFERENCE *)(Current);
	tb1 = F783_8140(RTCW(tr1));
	if ((EIF_BOOLEAN) !tb1) {
		F1196_11123(Current);
	}
	F1196_11122(Current);
	RTLE;
}

/* {PATH}.is_current_symbol */
EIF_BOOLEAN F1196_11082 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O8828[Dtype(tr1)-1176]);
	if ((EIF_BOOLEAN)(ti4_1 == F1196_11121(Current))) {
		RTLE;
		return (EIF_BOOLEAN) F1196_11133(Current, *(EIF_REFERENCE *)(Current), ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '.');
	}
	RTLE;
	return (EIF_BOOLEAN) 0;
}

/* {PATH}.is_parent_symbol */
EIF_BOOLEAN F1196_11083 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O8828[Dtype(tr1)-1176]);
	if ((EIF_BOOLEAN)(ti4_1 == (EIF_INTEGER_32) (((EIF_INTEGER_32) 2L) * F1196_11121(Current)))) {
		Result = F1196_11133(Current, *(EIF_REFERENCE *)(Current), ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '.');
		tr1 = *(EIF_REFERENCE *)(Current);
		ti4_1 = F1196_11121(Current);
		Result = F1196_11133(Current, tr1, (EIF_INTEGER_32) (((EIF_INTEGER_32) 1L) + ti4_1), (EIF_CHARACTER_8) '.');
	}
	RTLE;
	return Result;
}

/* {PATH}.has_root */
EIF_BOOLEAN F1196_11084 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTGC;
	ti4_1 = F1196_11127(Current);
	Result = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 != ((EIF_INTEGER_32) 0L));
	RTLE;
	return Result;
}

/* {PATH}.is_empty */
EIF_BOOLEAN F1196_11085 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current);
	Result = F783_8140(RTCW(tr1));
	RTLE;
	return Result;
}

/* {PATH}.is_relative */
EIF_BOOLEAN F1196_11086 (EIF_REFERENCE Current)
{
	GTCX
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTGC;
	Result = F1196_11087(Current);
	Result = (EIF_BOOLEAN) (EIF_BOOLEAN) !Result;
	RTLE;
	return Result;
}

/* {PATH}.is_absolute */
EIF_BOOLEAN F1196_11087 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_CHARACTER_8 tc1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTGC;
	loc1 = F1196_11127(Current);
	if ((EIF_BOOLEAN) (loc1 > ((EIF_INTEGER_32) 0L))) {
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = F1196_11121(Current);
			tc1 = F1196_11103(Current);
			Result = F1196_11133(Current, tr1, (EIF_INTEGER_32) ((EIF_INTEGER_32) (loc1 - ti4_1) + ((EIF_INTEGER_32) 1L)), tc1);
		} else {
			RTLE;
			return (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
		}
	}
	RTLE;
	return Result;
}

/* {PATH}.is_same_file_as */
EIF_BOOLEAN F1196_11089 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_POINTER tp2;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,loc2);
	RTLR(3,arg1);
	RTLIU(4);
	
	RTGC;
	loc1 = F1196_11118(Current);
	loc2 = F1196_11118(RTCW(arg1));
	tp1 = *(EIF_POINTER *)(RTCW(loc1)+ _PTROFF_0_1_0_1_0_0_);
	tp2 = *(EIF_POINTER *)(RTCW(loc2)+ _PTROFF_0_1_0_1_0_0_);
	Result = EIF_TEST (inline_F1196_11136(tp1, tp2));
	RTLE;
	return Result;
}

/* {PATH}.has_extension */
EIF_BOOLEAN F1196_11090 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,arg1);
	RTLIU(4);
	
	RTGC;
	Result = '\0';
	tr1 = F1196_11094(Current);
	loc1 = tr1;
	if (EIF_TEST(loc1)) {
		tb1 = F1171_10185(loc1, arg1);
		Result = tb1;
	}
	RTLE;
	return Result;
}

/* {PATH}.root */
EIF_REFERENCE F1196_11091 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(3);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,Result);
	RTLIU(3);
	
	RTGC;
	loc1 = F1196_11127(Current);
	if ((EIF_BOOLEAN)(loc1 != ((EIF_INTEGER_32) 0L))) {
		tr1 = *(EIF_REFERENCE *)(Current);
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O8828[Dtype(tr1)-1176]);
		if ((EIF_BOOLEAN)(loc1 == ti4_1)) {
			tr1 = RTLNS(eif_new_type(1195, 0x01).id, 1195, _OBJSIZ_2_1_0_0_0_0_0_0_);
			F1196_11080(RTCW(tr1), *(EIF_REFERENCE *)(Current));
			RTLE;
			return (EIF_REFERENCE) tr1;
		} else {
			Result = RTLNS(eif_new_type(1195, 0x01).id, 1195, _OBJSIZ_2_1_0_0_0_0_0_0_);
			tr1 = *(EIF_REFERENCE *)(Current);
			tr1 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R8670[Dtype(RTCW(tr1))-1174])(tr1, ((EIF_INTEGER_32) 1L), loc1);
			F1196_11080(RTCW(Result), tr1);
		}
	}
	RTLE;
	return Result;
}

/* {PATH}.parent */
EIF_REFERENCE F1196_11092 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,Current);
	RTLR(1,loc3);
	RTLR(2,tr1);
	RTLR(3,Result);
	RTLIU(4);
	
	RTGC;
	loc1 = F1196_11128(Current);
	if ((EIF_BOOLEAN)(loc1 == ((EIF_INTEGER_32) 0L))) {
		tr1 = F1196_11091(Current);
		loc3 = tr1;
		if (EIF_TEST(loc3)) {
			RTLE;
			return (EIF_REFERENCE) loc3;
		} else {
			tr1 = RTLNS(eif_new_type(1195, 0x01).id, 1195, _OBJSIZ_2_1_0_0_0_0_0_0_);
			F1196_11076(RTCW(tr1));
			RTLE;
			return (EIF_REFERENCE) tr1;
		}
	} else {
		if ((EIF_BOOLEAN)(loc1 == F1196_11121(Current))) {
			Result = RTLNS(eif_new_type(1195, 0x01).id, 1195, _OBJSIZ_2_1_0_0_0_0_0_0_);
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = F1196_11121(Current);
			tr1 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R8670[Dtype(RTCW(tr1))-1174])(tr1, ((EIF_INTEGER_32) 1L), ti4_1);
			F1196_11080(RTCW(Result), tr1);
		} else {
			loc2 = F1196_11127(Current);
			if ((EIF_BOOLEAN) (loc1 <= loc2)) {
				tr1 = *(EIF_REFERENCE *)(Current);
				ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O8828[Dtype(tr1)-1176]);
				if ((EIF_BOOLEAN)(loc2 == ti4_1)) {
					RTLE;
					return (EIF_REFERENCE) Current;
				} else {
					Result = RTLNS(eif_new_type(1195, 0x01).id, 1195, _OBJSIZ_2_1_0_0_0_0_0_0_);
					tr1 = *(EIF_REFERENCE *)(Current);
					tr1 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R8670[Dtype(RTCW(tr1))-1174])(tr1, ((EIF_INTEGER_32) 1L), loc2);
					F1196_11080(RTCW(Result), tr1);
				}
			} else {
				Result = RTLNS(eif_new_type(1195, 0x01).id, 1195, _OBJSIZ_2_1_0_0_0_0_0_0_);
				tr1 = *(EIF_REFERENCE *)(Current);
				ti4_1 = F1196_11121(Current);
				tr1 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R8670[Dtype(RTCW(tr1))-1174])(tr1, ((EIF_INTEGER_32) 1L), (EIF_INTEGER_32) (loc1 - ti4_1));
				F1196_11080(RTCW(Result), tr1);
			}
		}
	}
	RTLE;
	return Result;
}

/* {PATH}.entry */
EIF_REFERENCE F1196_11093 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_BOOLEAN tb4;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,tr2);
	RTLR(3,Result);
	RTLIU(4);
	
	RTGC;
	loc1 = F1196_11128(Current);
	if ((EIF_BOOLEAN)(loc1 == ((EIF_INTEGER_32) 0L))) {
		loc2 = F1196_11127(Current);
		if ((EIF_BOOLEAN) (loc2 > ((EIF_INTEGER_32) 0L))) {
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O8828[Dtype(tr1)-1176]);
			if ((EIF_BOOLEAN) (loc2 < ti4_1)) {
				Result = RTLNS(eif_new_type(1195, 0x01).id, 1195, _OBJSIZ_2_1_0_0_0_0_0_0_);
				tr1 = *(EIF_REFERENCE *)(Current);
				tr2 = *(EIF_REFERENCE *)(Current);
				ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr2) + O8828[Dtype(tr2)-1176]);
				tr1 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R8670[Dtype(RTCW(tr1))-1174])(tr1, (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L)), ti4_1);
				F1196_11080(RTCW(Result), tr1);
			}
		} else {
			Result = (EIF_REFERENCE) Current;
		}
	} else {
		loc2 = F1196_11127(Current);
		if ((EIF_BOOLEAN) (loc1 <= loc2)) {
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O8828[Dtype(tr1)-1176]);
			if ((EIF_BOOLEAN) (loc2 < ti4_1)) {
				Result = RTLNS(eif_new_type(1195, 0x01).id, 1195, _OBJSIZ_2_1_0_0_0_0_0_0_);
				tr1 = *(EIF_REFERENCE *)(Current);
				tr2 = *(EIF_REFERENCE *)(Current);
				ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr2) + O8828[Dtype(tr2)-1176]);
				tr1 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R8670[Dtype(RTCW(tr1))-1174])(tr1, (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L)), ti4_1);
				F1196_11080(RTCW(Result), tr1);
			}
		} else {
			Result = RTLNS(eif_new_type(1195, 0x01).id, 1195, _OBJSIZ_2_1_0_0_0_0_0_0_);
			tr1 = *(EIF_REFERENCE *)(Current);
			tr2 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr2) + O8828[Dtype(tr2)-1176]);
			tr1 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R8670[Dtype(RTCW(tr1))-1174])(tr1, (EIF_INTEGER_32) (loc1 + ((EIF_INTEGER_32) 1L)), ti4_1);
			F1196_11080(RTCW(Result), tr1);
		}
	}
	tb1 = '\0';
	if ((EIF_BOOLEAN)(Result != NULL)) {
		tb2 = '\01';
		tb3 = '\01';
		tb4 = F1196_11085(RTCW(Result));
		if (!tb4) {
			tb4 = F1196_11082(RTCW(Result));
			tb3 = tb4;
		}
		if (!tb3) {
			tb3 = F1196_11083(RTCW(Result));
			tb2 = tb3;
		}
		tb1 = tb2;
	}
	if (tb1) {
		RTLE;
		return (EIF_REFERENCE) NULL;
	}
	RTLE;
	return Result;
}

/* {PATH}.extension */
EIF_REFERENCE F1196_11094 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc3 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE loc4 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_CHARACTER_32 tw1;
	RTLD;
	
	RTLI(4);
	RTLR(0,loc4);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,loc1);
	RTLIU(4);
	
	RTGC;
	tr1 = F1196_11093(Current);
	loc4 = tr1;
	if (EIF_TEST(loc4)) {
		loc1 = F1196_11116(loc4);
		loc3 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_0_0_2_);
		tw1 = (EIF_CHARACTER_32) (EIF_CHARACTER_8) '.';
		loc2 = F1174_10286(RTCW(loc1), tw1, loc3);
		if ((EIF_BOOLEAN) ((EIF_BOOLEAN)(loc2 != ((EIF_INTEGER_32) 0L)) && (EIF_BOOLEAN)(loc2 != loc3))) {
			tr1 = F1175_10342(RTCW(loc1), (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L)), loc3);
			RTLE;
			return (EIF_REFERENCE) tr1;
		}
	}
	RTLE;
	return (EIF_REFERENCE) 0;
}

/* {PATH}.components */
EIF_REFERENCE F1196_11095 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc3 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,Current);
	RTLR(1,Result);
	RTLR(2,loc1);
	RTLR(3,tr1);
	RTLIU(4);
	
	RTGC;
	{
		static EIF_TYPE_INDEX typarr0[] = {0xFF01,1061,0xFF01,1195,0xFFFF};
		EIF_TYPE typres0;
		static EIF_TYPE typcache0 = {INVALID_DTYPE, 0};
		
		typres0 = (typcache0.id != INVALID_DTYPE ? typcache0 : (typcache0 = eif_compound_id(Dftype(Current), typarr0)));
		Result = RTLNS(typres0.id, 1061, _OBJSIZ_1_1_0_1_0_0_0_0_);
	}
	F1062_9044(RTCW(Result), ((EIF_INTEGER_32) 10L));
	loc3 = F1196_11127(Current);
	if ((EIF_BOOLEAN) (loc3 > ((EIF_INTEGER_32) 0L))) {
		loc1 = RTLNS(eif_new_type(1178, 0x01).id, 1178, _OBJSIZ_1_1_0_3_0_0_0_0_);
		F1177_10440(RTCW(loc1), loc3);
		F1179_10554(RTCW(loc1), *(EIF_REFERENCE *)(Current), ((EIF_INTEGER_32) 1L), loc3);
		tr1 = RTLNS(eif_new_type(1195, 0x01).id, 1195, _OBJSIZ_2_1_0_0_0_0_0_0_);
		F1196_11080(RTCW(tr1), loc1);
		(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R7195[Dtype(RTCW(Result))-915])(Result, tr1);
		loc3++;
	} else {
		loc3 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
	}
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O8828[Dtype(tr1)-1176]);
	if ((EIF_BOOLEAN) (loc3 <= ti4_1)) {
		loc2 = (EIF_INTEGER_32) loc3;
		loc3 = F1196_11129(Current, loc2);
		for (;;) {
			if ((EIF_BOOLEAN)(loc3 == ((EIF_INTEGER_32) 0L))) break;
			loc1 = RTLNS(eif_new_type(1178, 0x01).id, 1178, _OBJSIZ_1_1_0_3_0_0_0_0_);
			F1177_10440(RTCW(loc1), (EIF_INTEGER_32) (loc3 - loc2));
			F1179_10554(RTCW(loc1), *(EIF_REFERENCE *)(Current), loc2, (EIF_INTEGER_32) (loc3 - ((EIF_INTEGER_32) 1L)));
			tr1 = RTLNS(eif_new_type(1195, 0x01).id, 1195, _OBJSIZ_2_1_0_0_0_0_0_0_);
			F1196_11080(RTCW(tr1), loc1);
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R7195[Dtype(RTCW(Result))-915])(Result, tr1);
			loc2 = F1196_11121(Current);
			loc2 = (EIF_INTEGER_32) (EIF_INTEGER_32) (loc3 + loc2);
			loc3 = F1196_11129(Current, loc2);
		}
		tr1 = *(EIF_REFERENCE *)(Current);
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O8828[Dtype(tr1)-1176]);
		if ((EIF_BOOLEAN) (loc2 <= ti4_1)) {
			loc1 = RTLNS(eif_new_type(1178, 0x01).id, 1178, _OBJSIZ_1_1_0_3_0_0_0_0_);
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O8828[Dtype(tr1)-1176]);
			F1177_10440(RTCW(loc1), (EIF_INTEGER_32) (ti4_1 - loc2));
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O8828[Dtype(tr1)-1176]);
			F1179_10554(RTCW(loc1), *(EIF_REFERENCE *)(Current), loc2, ti4_1);
			tr1 = RTLNS(eif_new_type(1195, 0x01).id, 1195, _OBJSIZ_2_1_0_0_0_0_0_0_);
			F1196_11080(RTCW(tr1), loc1);
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R7195[Dtype(RTCW(Result))-915])(Result, tr1);
		}
	}
	RTLE;
	return Result;
}

/* {PATH}.absolute_path */
EIF_REFERENCE F1196_11096 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(3);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,Result);
	RTLIU(3);
	
	RTGC;
	tr1 = F458_6168(RTCV(RTOUCR(178,F1196_11126, (Current))));
	Result = F1196_11097(Current, tr1);
	RTLE;
	return Result;
}

/* {PATH}.absolute_path_in */
EIF_REFERENCE F1196_11097 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_REFERENCE tr3 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_CHARACTER_8 tc1;
	EIF_CHARACTER_8 tc2;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(8);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,arg1);
	RTLR(3,loc1);
	RTLR(4,Result);
	RTLR(5,tr2);
	RTLR(6,tr3);
	RTLR(7,loc2);
	RTLIU(8);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current);
	tb1 = F783_8140(RTCW(tr1));
	if (tb1) {
		RTLE;
		return (EIF_REFERENCE) arg1;
	} else {
		if (F1196_11087(Current)) {
			RTLE;
			return (EIF_REFERENCE) Current;
		} else {
			if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
				tr1 = F1196_11091(Current);
				loc1 = tr1;
				if (EIF_TEST(loc1)) {
					tb1 = '\0';
					tb2 = '\0';
					tr1 = *(EIF_REFERENCE *)(loc1);
					ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O8828[Dtype(tr1)-1176]);
					if ((EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 4L))) {
						tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
						ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O8828[Dtype(tr1)-1176]);
						tb2 = (EIF_BOOLEAN) (ti4_1 >= ((EIF_INTEGER_32) 4L));
					}
					if (tb2) {
						tb2 = '\0';
						tr1 = *(EIF_REFERENCE *)(loc1);
						tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R7494[Dtype(RTCW(tr1))-963])(tr1, ((EIF_INTEGER_32) 1L)));
						tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
						tc2 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R7494[Dtype(RTCW(tr1))-963])(tr1, ((EIF_INTEGER_32) 1L)));
						if ((EIF_BOOLEAN)(tc1 == tc2)) {
							tr1 = *(EIF_REFERENCE *)(loc1);
							tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R7494[Dtype(RTCW(tr1))-963])(tr1, ((EIF_INTEGER_32) 3L)));
							tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
							tc2 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R7494[Dtype(RTCW(tr1))-963])(tr1, ((EIF_INTEGER_32) 3L)));
							tb2 = (EIF_BOOLEAN)(tc1 == tc2);
						}
						tb1 = tb2;
					}
					if (tb1) {
						Result = F1_14(arg1);
					} else {
						Result = (EIF_REFERENCE) loc1;
					}
					tr1 = *(EIF_REFERENCE *)(RTCW(Result));
					tr2 = *(EIF_REFERENCE *)(Current);
					tr3 = *(EIF_REFERENCE *)(loc1);
					ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr3) + O8828[Dtype(tr3)-1176]);
					tr3 = *(EIF_REFERENCE *)(Current);
					ti4_2 = *(EIF_INTEGER_32 *)(RTCW(tr3) + O8828[Dtype(tr3)-1176]);
					tc1 = F1196_11103(Current);
					F1196_11132(Current, tr1, tr2, (EIF_INTEGER_32) (ti4_1 + ((EIF_INTEGER_32) 1L)), ti4_2, tc1);
				} else {
					if (F1196_11133(Current, *(EIF_REFERENCE *)(Current), ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '\\')) {
						Result = F1_14(arg1);
						tr1 = F1196_11091(RTCW(Result));
						loc2 = tr1;
						if (EIF_TEST(loc2)) {
							Result = (EIF_REFERENCE) loc2;
						}
					} else {
						Result = F1_14(arg1);
					}
					tr1 = *(EIF_REFERENCE *)(RTCW(Result));
					tr2 = *(EIF_REFERENCE *)(Current);
					tc1 = F1196_11103(Current);
					F1196_11131(Current, tr1, tr2, tc1);
				}
			} else {
				Result = F1_14(arg1);
				tr1 = *(EIF_REFERENCE *)(RTCW(Result));
				tr2 = *(EIF_REFERENCE *)(Current);
				tc1 = F1196_11103(Current);
				F1196_11131(Current, tr1, tr2, tc1);
			}
			F1196_11122(RTCW(Result));
		}
	}
	RTLE;
	return Result;
}

/* {PATH}.canonical_path */
EIF_REFERENCE F1196_11098 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc4 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc5 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_CHARACTER_8 tc1;
	RTLD;
	
	RTLI(7);
	RTLR(0,loc2);
	RTLR(1,Current);
	RTLR(2,loc4);
	RTLR(3,tr1);
	RTLR(4,loc3);
	RTLR(5,loc1);
	RTLR(6,loc5);
	RTLIU(7);
	
	RTGC;
	loc2 = F1196_11096(Current);
	tr1 = F1196_11091(RTCW(loc2));
	loc4 = tr1;
	if (EIF_TEST(loc4)) {
		loc3 = RTLNSMART(eif_new_type(1178, 1).id);
		tr1 = *(EIF_REFERENCE *)(RTCW(loc2));
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O8828[Dtype(tr1)-1176]);
		F1177_10440(RTCW(loc3), ti4_1);
		loc1 = F1196_11095(RTCW(loc2));
		F1062_9075(RTCW(loc1));
		tr1 = F1062_9049(RTCW(loc1));
		tr1 = *(EIF_REFERENCE *)(RTCW(tr1));
		tc1 = F1196_11103(Current);
		F1196_11131(Current, loc3, tr1, tc1);
		(FUNCTION_CAST(void, (EIF_REFERENCE)) R7213[Dtype(RTCW(loc1))-915])(loc1);
		for (;;) {
			tb1 = F1033_8961(RTCW(loc1));
			if (tb1) break;
			tr1 = F1062_9049(RTCW(loc1));
			tb2 = F1196_11082(RTCW(tr1));
			if (tb2) {
				(FUNCTION_CAST(void, (EIF_REFERENCE)) R7213[Dtype(RTCW(loc1))-915])(loc1);
			} else {
				tr1 = F1062_9049(RTCW(loc1));
				tb2 = F1196_11083(RTCW(tr1));
				if (tb2) {
					tb2 = F1009_8927(RTCW(loc1));
					if ((EIF_BOOLEAN) !tb2) {
						F1062_9078(RTCW(loc1));
						(FUNCTION_CAST(void, (EIF_REFERENCE)) R7213[Dtype(RTCW(loc1))-915])(loc1);
					}
					(FUNCTION_CAST(void, (EIF_REFERENCE)) R7213[Dtype(RTCW(loc1))-915])(loc1);
				} else {
					F1062_9077(RTCW(loc1));
				}
			}
		}
		loc5 = F1062_9058(RTCW(loc1));
		for (;;) {
			tb2 = F662_8015(loc5);
			if (tb2) break;
			tr1 = F662_8006(loc5);
			tr1 = *(EIF_REFERENCE *)(RTCW(tr1));
			tc1 = F1196_11103(Current);
			F1196_11131(Current, loc3, tr1, tc1);
			F662_8021(loc5);
		}
		tr1 = RTLNS(eif_new_type(1195, 0x01).id, 1195, _OBJSIZ_2_1_0_0_0_0_0_0_);
		F1196_11080(RTCW(tr1), loc3);
		RTLE;
		return (EIF_REFERENCE) tr1;
	} else {
		RTLE;
		return (EIF_REFERENCE) loc2;
	}/* NOTREACHED */
	
}

/* {PATH}.hash_code */
EIF_INTEGER_32 F1196_11099 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTGC;
	if ((EIF_BOOLEAN) EIF_TEST(eif_case_sensitive_path_names())) {
		tr1 = *(EIF_REFERENCE *)(Current);
		Result = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R8241[Dtype(RTCW(tr1))-1116])(tr1);
	} else {
		Result = F1171_10153(RTCV(F1196_11116(Current)));
	}
	RTLE;
	return Result;
}

/* {PATH}.directory_separator */
EIF_CHARACTER_8 F1196_11103 (EIF_REFERENCE Current)
{
	GTCX
	
	
	RTGC;
	if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
		return (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
	} else {
		return (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
	}/* NOTREACHED */
	
}

/* {PATH}.extended */
EIF_REFERENCE F1196_11104 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_INTEGER_32 ti4_4;
	EIF_BOOLEAN tb1;
	EIF_CHARACTER_8 tc1;
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,arg1);
	RTLIU(4);
	
	RTGC;
	loc1 = RTLNSMART(eif_new_type(1178, 1).id);
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O8828[Dtype(tr1)-1176]);
	ti4_2 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R8629[Dtype(RTCW(arg1))-1174])(arg1);
	ti4_3 = F1196_11121(Current);
	ti4_4 = F1196_11121(Current);
	F1177_10440(RTCW(loc1), (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 + (EIF_INTEGER_32) (ti4_2 * ti4_3)) + ti4_4));
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R8852[Dtype(RTCW(loc1))-1178])(loc1, *(EIF_REFERENCE *)(Current));
	tb1 = '\0';
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1) + O8828[Dtype(loc1)-1176]);
	if ((EIF_BOOLEAN) (ti4_1 > ((EIF_INTEGER_32) 0L))) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1) + O8828[Dtype(loc1)-1176]);
		tb1 = (EIF_BOOLEAN)(F1196_11127(Current) == ti4_1);
	}
	if (tb1) {
		F1196_11130(Current, loc1, arg1, (EIF_CHARACTER_8) '\000');
	} else {
		tc1 = F1196_11103(Current);
		F1196_11130(Current, loc1, arg1, tc1);
	}
	tr1 = RTLNS(eif_new_type(1195, 0x01).id, 1195, _OBJSIZ_2_1_0_0_0_0_0_0_);
	F1196_11079(RTCW(tr1), loc1);
	RTLE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.extended_path */
EIF_REFERENCE F1196_11105 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_BOOLEAN tb1;
	EIF_CHARACTER_8 tc1;
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,arg1);
	RTLIU(4);
	
	RTGC;
	loc1 = RTLNSMART(eif_new_type(1178, 1).id);
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O8828[Dtype(tr1)-1176]);
	tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
	ti4_2 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O8828[Dtype(tr1)-1176]);
	ti4_3 = F1196_11121(Current);
	F1177_10440(RTCW(loc1), (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 + ti4_2) + ti4_3));
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R8852[Dtype(RTCW(loc1))-1178])(loc1, *(EIF_REFERENCE *)(Current));
	tb1 = '\0';
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1) + O8828[Dtype(loc1)-1176]);
	if ((EIF_BOOLEAN) (ti4_1 > ((EIF_INTEGER_32) 0L))) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1) + O8828[Dtype(loc1)-1176]);
		tb1 = (EIF_BOOLEAN)(F1196_11127(Current) == ti4_1);
	}
	if (tb1) {
		tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
		F1196_11131(Current, loc1, tr1, (EIF_CHARACTER_8) '\000');
	} else {
		tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
		tc1 = F1196_11103(Current);
		F1196_11131(Current, loc1, tr1, tc1);
	}
	tr1 = RTLNS(eif_new_type(1195, 0x01).id, 1195, _OBJSIZ_2_1_0_0_0_0_0_0_);
	F1196_11080(RTCW(tr1), loc1);
	RTLE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.appended */
EIF_REFERENCE F1196_11106 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,arg1);
	RTLIU(4);
	
	RTGC;
	loc1 = RTLNSMART(eif_new_type(1178, 1).id);
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O8828[Dtype(tr1)-1176]);
	ti4_2 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R8629[Dtype(RTCW(arg1))-1174])(arg1);
	ti4_3 = F1196_11121(Current);
	F1177_10440(RTCW(loc1), (EIF_INTEGER_32) (ti4_1 + (EIF_INTEGER_32) (ti4_2 * ti4_3)));
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R8852[Dtype(RTCW(loc1))-1178])(loc1, *(EIF_REFERENCE *)(Current));
	F1196_11130(Current, loc1, arg1, (EIF_CHARACTER_8) '\000');
	tr1 = RTLNS(eif_new_type(1195, 0x01).id, 1195, _OBJSIZ_2_1_0_0_0_0_0_0_);
	F1196_11079(RTCW(tr1), loc1);
	RTLE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.appended_with_extension */
EIF_REFERENCE F1196_11107 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_INTEGER_32 ti4_4;
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,arg1);
	RTLIU(4);
	
	RTGC;
	loc1 = RTLNSMART(eif_new_type(1178, 1).id);
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O8828[Dtype(tr1)-1176]);
	ti4_2 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R8629[Dtype(RTCW(arg1))-1174])(arg1);
	ti4_3 = F1196_11121(Current);
	ti4_4 = F1196_11121(Current);
	F1177_10440(RTCW(loc1), (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 + (EIF_INTEGER_32) (ti4_2 * ti4_3)) + ti4_4));
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R8852[Dtype(RTCW(loc1))-1178])(loc1, *(EIF_REFERENCE *)(Current));
	F1196_11130(Current, loc1, arg1, (EIF_CHARACTER_8) '.');
	tr1 = RTLNS(eif_new_type(1195, 0x01).id, 1195, _OBJSIZ_2_1_0_0_0_0_0_0_);
	F1196_11080(RTCW(tr1), loc1);
	RTLE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.same_as */
EIF_BOOLEAN F1196_11108 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTLD;
	
	RTLI(2);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLIU(2);
	
	RTGC;
	if ((EIF_BOOLEAN)(arg1 == NULL)) {
	} else {
		if ((EIF_BOOLEAN)(arg1 == Current)) {
			RTLE;
			return (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
		} else {
			if ((EIF_BOOLEAN) EIF_TEST(eif_case_sensitive_path_names())) {
				RTLE;
				return (EIF_BOOLEAN) F1196_11111(Current, arg1);
			} else {
				RTLE;
				return (EIF_BOOLEAN) F1196_11112(Current, arg1);
			}
		}
	}
	RTLE;
	return (EIF_BOOLEAN) 0;
}

/* {PATH}.is_less */
EIF_BOOLEAN F1196_11109 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,arg1);
	RTLR(3,tr2);
	RTLIU(4);
	
	RTGC;
	if ((EIF_BOOLEAN) EIF_TEST(eif_case_sensitive_path_names())) {
		tr1 = *(EIF_REFERENCE *)(Current);
		tr2 = *(EIF_REFERENCE *)(RTCW(arg1));
		Result = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE, EIF_REFERENCE)) R4891[Dtype(RTCW(tr1))-414])(tr1, tr2);
	} else {
		tr1 = F1175_10339(RTCV(F1196_11116(Current)));
		tr2 = F1196_11116(RTCW(arg1));
		tr2 = F1175_10339(RTCW(tr2));
		Result = F1174_10302(RTCW(tr1), tr2);
	}
	RTLE;
	return Result;
}

/* {PATH}.is_equal */
EIF_BOOLEAN F1196_11110 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	
	
	return (EIF_BOOLEAN) F1196_11108(Current, arg1);
}

/* {PATH}.is_case_sensitive_equal */
EIF_BOOLEAN F1196_11111 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,tr2);
	RTLIU(4);
	
	RTGC;
	if ((EIF_BOOLEAN)(arg1 == Current)) {
		RTLE;
		return (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	} else {
		tr1 = *(EIF_REFERENCE *)(Current);
		tr2 = *(EIF_REFERENCE *)(RTCW(arg1));
		Result = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE, EIF_REFERENCE)) R11[Dtype(RTCW(tr1))-1])(tr1, tr2);
	}
	RTLE;
	return Result;
}

/* {PATH}.is_case_insensitive_equal */
EIF_BOOLEAN F1196_11112 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,tr2);
	RTLIU(4);
	
	RTGC;
	if ((EIF_BOOLEAN)(arg1 == Current)) {
		RTLE;
		return (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	} else {
		tr1 = F1196_11116(Current);
		tr2 = F1196_11116(RTCW(arg1));
		Result = F1174_10298(RTCW(tr1), tr2);
	}
	RTLE;
	return Result;
}

/* {PATH}.copy */
void F1196_11113 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(3);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLIU(3);
	
	RTGC;
	if ((EIF_BOOLEAN)(arg1 != Current)) {
		eif_builtin_ANY_standard_copy__o_ (Current, arg1);
		tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
		tr1 = F1_14(tr1);
		RTAR(Current, tr1);
		*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	}
	RTLE;
}

/* {PATH}.out */
EIF_REFERENCE F1196_11114 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(3);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLIU(3);
	
	RTGC;
	tr1 = F1196_11116(Current);
	loc1 = tr1;
	loc1 = RTRV(eif_new_type(1176, 0x01),loc1);
	if (EIF_TEST(loc1)) {
		tr1 = RTLNS(eif_new_type(1178, 0x01).id, 1178, _OBJSIZ_1_1_0_3_0_0_0_0_);
		F1177_10442(RTCW(tr1), loc1);
		RTLE;
		return (EIF_REFERENCE) tr1;
	} else {
		RTLE;
		return (EIF_REFERENCE) F1196_11115(Current);
	}/* NOTREACHED */
	
}

/* {PATH}.utf_8_name */
EIF_REFERENCE F1196_11115 (EIF_REFERENCE Current)
{
	GTCX
	struct eif_ex_79 sloc1;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) sloc1.data;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	memset (&sloc1.overhead, 0, OVERHEAD + _OBJSIZ_0_0_0_0_0_0_0_0_);
	sloc1.overhead.ov_flags = EO_EXP | EO_STACK;
	RT_DFS(&sloc1.overhead, eif_new_type(85, 0x00).id);
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,Result);
	RTLIU(4);
	
	RTGC;
	tr1 = F1196_11116(Current);
	Result = F86_1637(RTCW(loc1), tr1);
	RTLE;
	return Result;
}

/* {PATH}.name */
EIF_REFERENCE F1196_11116 (EIF_REFERENCE Current)
{
	GTCX
	struct eif_ex_79 sloc1;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) sloc1.data;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	memset (&sloc1.overhead, 0, OVERHEAD + _OBJSIZ_0_0_0_0_0_0_0_0_);
	sloc1.overhead.ov_flags = EO_EXP | EO_STACK;
	RT_DFS(&sloc1.overhead, eif_new_type(85, 0x00).id);
	RTLI(5);
	RTLR(0,loc2);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,loc1);
	RTLR(4,Result);
	RTLIU(5);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current + _REFACS_1_);
	loc2 = tr1;
	if (EIF_TEST(loc2)) {
		RTLE;
		return (EIF_REFERENCE) loc2;
	} else {
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
			Result = RTLNS(eif_new_type(1174, 0x01).id, 1174, _OBJSIZ_1_0_0_4_0_0_0_0_);
			tr1 = F86_1676(RTCW(loc1), *(EIF_REFERENCE *)(Current));
			F1174_10275(RTCW(Result), tr1);
		} else {
			Result = RTLNS(eif_new_type(1174, 0x01).id, 1174, _OBJSIZ_1_0_0_4_0_0_0_0_);
			tr1 = F86_1649(RTCW(loc1), *(EIF_REFERENCE *)(Current));
			F1174_10275(RTCW(Result), tr1);
		}
		RTAR(Current, Result);
		*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) Result;
	}
	RTLE;
	return Result;
}

/* {PATH}.to_pointer */
EIF_REFERENCE F1196_11118 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	RTLD;
	
	RTLI(3);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLIU(3);
	
	RTGC;
	loc1 = RTLNS(eif_new_type(486, 0x01).id, 486, _OBJSIZ_1_0_0_1_0_0_0_0_);
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O8828[Dtype(tr1)-1176]);
	ti4_2 = F1196_11121(Current);
	F487_6363(RTCW(loc1), (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 + ti4_2) - ((EIF_INTEGER_32) 1L)));
	F487_6390(RTCW(loc1), *(EIF_REFERENCE *)(Current));
	tr1 = *(EIF_REFERENCE *)(RTCW(loc1));
	RTLE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.unit_size */
EIF_INTEGER_32 F1196_11121 (EIF_REFERENCE Current)
{
	GTCX
	
	
	RTGC;
	if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
		return (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
	} else {
		return (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
	}/* NOTREACHED */
	
}

/* {PATH}.reset_internal_data */
void F1196_11122 (EIF_REFERENCE Current)
{
	GTCX
	
	
	*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) NULL;
}

/* {PATH}.normalize */
void F1196_11123 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc3 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc4 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc5 = (EIF_INTEGER_32) 0;
	EIF_BOOLEAN loc6 = (EIF_BOOLEAN) 0;
	EIF_BOOLEAN loc7 = (EIF_BOOLEAN) 0;
	EIF_BOOLEAN loc8 = (EIF_BOOLEAN) 0;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_CHARACTER_8 tc1;
	RTLD;
	
	RTLI(2);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLIU(2);
	
	RTGC;
	loc1 = *(EIF_REFERENCE *)(Current);
	loc4 = *(EIF_INTEGER_32 *)(RTCW(loc1) + O8828[Dtype(loc1)-1176]);
	if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
		loc2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
		if ((EIF_BOOLEAN) (loc4 >= ((EIF_INTEGER_32) 10L))) {
			tb1 = '\01';
			tb2 = '\0';
			if (F1196_11133(Current, loc1, ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '/')) {
				tb3 = '\01';
				if (!F1196_11133(Current, loc1, ((EIF_INTEGER_32) 3L), (EIF_CHARACTER_8) '/')) {
					tb3 = F1196_11133(Current, loc1, ((EIF_INTEGER_32) 3L), (EIF_CHARACTER_8) '\\');
				}
				tb2 = tb3;
			}
			if (!tb2) {
				tb2 = '\0';
				if (F1196_11133(Current, loc1, ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '\\')) {
					tb3 = '\01';
					if (!F1196_11133(Current, loc1, ((EIF_INTEGER_32) 3L), (EIF_CHARACTER_8) '\\')) {
						tb3 = F1196_11133(Current, loc1, ((EIF_INTEGER_32) 3L), (EIF_CHARACTER_8) '/');
					}
					tb2 = tb3;
				}
				tb1 = tb2;
			}
			if (tb1) {
				tb1 = '\0';
				if ((EIF_BOOLEAN) !F1196_11133(Current, loc1, ((EIF_INTEGER_32) 5L), (EIF_CHARACTER_8) '/')) {
					tb1 = (EIF_BOOLEAN) !F1196_11133(Current, loc1, ((EIF_INTEGER_32) 5L), (EIF_CHARACTER_8) '\\');
				}
				if (tb1) {
					loc2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 5L);
					loc8 = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
				}
			}
		}
		loc3 = (EIF_INTEGER_32) loc2;
		loc7 = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
		for (;;) {
			if ((EIF_BOOLEAN) (loc2 > loc4)) break;
			if (loc6) {
				loc7 = '\0';
				if ((EIF_BOOLEAN) !F1196_11133(Current, loc1, loc2, (EIF_CHARACTER_8) '\\')) {
					loc7 = (EIF_BOOLEAN) !F1196_11133(Current, loc1, loc2, (EIF_CHARACTER_8) '/');
				}
				loc6 = (EIF_BOOLEAN) (EIF_BOOLEAN) !loc7;
			} else {
				if (F1196_11133(Current, loc1, loc2, (EIF_CHARACTER_8) '/')) {
					tc1 = (EIF_CHARACTER_8) '\\';
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE, EIF_REFERENCE)) R7204[Dtype(RTCW(loc1))-963])(loc1, (EIF_REFERENCE) &tc1, (EIF_REFERENCE) &loc2);
					loc6 = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
				} else {
					loc6 = F1196_11133(Current, loc1, loc2, (EIF_CHARACTER_8) '\\');
				}
			}
			if (loc7) {
				if ((EIF_BOOLEAN)(loc2 != loc3)) {
					tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R7494[Dtype(RTCW(loc1))-963])(loc1, loc2));
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE, EIF_REFERENCE)) R7204[Dtype(RTCW(loc1))-963])(loc1, (EIF_REFERENCE) &tc1, (EIF_REFERENCE) &loc3);
					tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R7494[Dtype(RTCW(loc1))-963])(loc1, (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L))));
					ti4_1 = (EIF_INTEGER_32) (loc3 + ((EIF_INTEGER_32) 1L));
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE, EIF_REFERENCE)) R7204[Dtype(RTCW(loc1))-963])(loc1, (EIF_REFERENCE) &tc1, (EIF_REFERENCE) &ti4_1);
				}
				loc3 += ((EIF_INTEGER_32) 2L);
			}
			loc2 += ((EIF_INTEGER_32) 2L);
		}
	} else {
		loc2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
		loc3 = (EIF_INTEGER_32) loc2;
		loc7 = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
		for (;;) {
			if ((EIF_BOOLEAN) (loc2 > loc4)) break;
			if (loc6) {
				loc7 = F1196_11133(Current, loc1, loc2, (EIF_CHARACTER_8) '/');
				loc7 = (EIF_BOOLEAN) (EIF_BOOLEAN) !loc7;
				loc6 = (EIF_BOOLEAN) (EIF_BOOLEAN) !loc7;
			} else {
				loc6 = F1196_11133(Current, loc1, loc2, (EIF_CHARACTER_8) '/');
			}
			if (loc7) {
				if ((EIF_BOOLEAN)(loc2 != loc3)) {
					tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R7494[Dtype(RTCW(loc1))-963])(loc1, loc2));
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE, EIF_REFERENCE)) R7204[Dtype(RTCW(loc1))-963])(loc1, (EIF_REFERENCE) &tc1, (EIF_REFERENCE) &loc3);
				}
				loc3++;
			}
			loc2++;
		}
	}
	if ((EIF_BOOLEAN)(loc2 != loc3)) {
		(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_INTEGER_32)) R8708[Dtype(RTCW(loc1))-1175])(loc1, (EIF_INTEGER_32) (loc3 - ((EIF_INTEGER_32) 1L)));
	}
	*(EIF_BOOLEAN *)(Current+ _CHROFF_2_0_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	if (loc8) {
		loc5 = F1196_11127(Current);
		if ((EIF_BOOLEAN)(loc5 == ((EIF_INTEGER_32) 0L))) {
			ti4_1 = F1196_11121(Current);
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_INTEGER_32)) R8714[Dtype(RTCW(loc1))-1175])(loc1, ti4_1);
		}
	}
	tb1 = '\0';
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1) + O8828[Dtype(loc1)-1176]);
	ti4_2 = F1196_11121(Current);
	tc1 = F1196_11103(Current);
	if (F1196_11133(Current, loc1, (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 - ti4_2) + ((EIF_INTEGER_32) 1L)), tc1)) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1) + O8828[Dtype(loc1)-1176]);
		tb1 = (EIF_BOOLEAN) (F1196_11127(Current) < ti4_1);
	}
	if (tb1) {
		ti4_1 = F1196_11121(Current);
		(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_INTEGER_32)) R8716[Dtype(RTCW(loc1))-1175])(loc1, ti4_1);
	}
	RTLE;
}

/* {PATH}.env */
static EIF_REFERENCE F1196_11126_body (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
#define Result RTOTRR
	RTOUDR(178)

	RTLI(1);
	RTLR(0,tr1);
	RTLIU(1);
	
	RTEV;
	RTGC;
	RTOTP;
	tr1 = RTLNS(eif_new_type(457, 0x01).id, 457, _OBJSIZ_0_0_0_1_0_0_0_0_);
	Result = (EIF_REFERENCE) tr1;
	RTOTE;
	RTLE;
	RTEE;
	return Result;
#undef Result
}

EIF_REFERENCE F1196_11126 (EIF_REFERENCE Current)
{
	GTCX
	return RTOUCR(178,F1196_11126_body,(Current));
}

/* {PATH}.root_end_position */
EIF_INTEGER_32 F1196_11127 (EIF_REFERENCE Current)
{
	GTCX
	EIF_CHARACTER_8 loc1 = (EIF_CHARACTER_8) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_CHARACTER_8 tc1;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current);
	tb1 = F783_8140(RTCW(tr1));
	if ((EIF_BOOLEAN) !tb1) {
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
			tb1 = '\0';
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O8828[Dtype(tr1)-1176]);
			if ((EIF_BOOLEAN)(ti4_1 == F1196_11121(Current))) {
				tb1 = F1196_11133(Current, *(EIF_REFERENCE *)(Current), ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '\\');
			}
			if (tb1) {
				RTLE;
				return (EIF_INTEGER_32) F1196_11121(Current);
			} else {
				tb1 = '\0';
				tr1 = *(EIF_REFERENCE *)(Current);
				ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O8828[Dtype(tr1)-1176]);
				if ((EIF_BOOLEAN) (ti4_1 >= ((EIF_INTEGER_32) 4L))) {
					tb2 = '\0';
					tr1 = *(EIF_REFERENCE *)(Current);
					tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R7494[Dtype(RTCW(tr1))-963])(tr1, ((EIF_INTEGER_32) 2L)));
					if ((EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) '\000')) {
						tr1 = *(EIF_REFERENCE *)(Current);
						tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R7494[Dtype(RTCW(tr1))-963])(tr1, ((EIF_INTEGER_32) 4L)));
						tb2 = (EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) '\000');
					}
					tb1 = tb2;
				}
				if (tb1) {
					tr1 = *(EIF_REFERENCE *)(Current);
					tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R7494[Dtype(RTCW(tr1))-963])(tr1, ((EIF_INTEGER_32) 1L)));
					loc1 = eif_builtin_CHARACTER_8_as_lower__c1_c1(tc1);
					tb1 = '\0';
					if ((EIF_BOOLEAN) ((EIF_BOOLEAN) (loc1 >= (EIF_CHARACTER_8) 'a') && (EIF_BOOLEAN) (loc1 <= (EIF_CHARACTER_8) 'z'))) {
						tr1 = *(EIF_REFERENCE *)(Current);
						tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R7494[Dtype(RTCW(tr1))-963])(tr1, ((EIF_INTEGER_32) 3L)));
						tb1 = (EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) ':');
					}
					if (tb1) {
						tb1 = '\0';
						tr1 = *(EIF_REFERENCE *)(Current);
						ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O8828[Dtype(tr1)-1176]);
						if ((EIF_BOOLEAN) (ti4_1 >= (EIF_INTEGER_32) (((EIF_INTEGER_32) 3L) * F1196_11121(Current)))) {
							tb1 = F1196_11133(Current, *(EIF_REFERENCE *)(Current), ((EIF_INTEGER_32) 5L), (EIF_CHARACTER_8) '\\');
						}
						if (tb1) {
							RTLE;
							return (EIF_INTEGER_32) ((EIF_INTEGER_32) 6L);
						} else {
							RTLE;
							return (EIF_INTEGER_32) ((EIF_INTEGER_32) 4L);
						}
					} else {
						tb1 = '\0';
						if ((EIF_BOOLEAN)(loc1 == (EIF_CHARACTER_8) '\\')) {
							tr1 = *(EIF_REFERENCE *)(Current);
							tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R7494[Dtype(RTCW(tr1))-963])(tr1, ((EIF_INTEGER_32) 3L)));
							tb1 = (EIF_BOOLEAN)(tc1 != (EIF_CHARACTER_8) '\\');
						}
						if (tb1) {
							Result = F1196_11121(Current);
						} else {
							tb1 = '\0';
							tb2 = '\0';
							tb3 = '\0';
							tr1 = *(EIF_REFERENCE *)(Current);
							ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O8828[Dtype(tr1)-1176]);
							if ((EIF_BOOLEAN) (ti4_1 >= ((EIF_INTEGER_32) 10L))) {
								tb3 = (EIF_BOOLEAN)(loc1 == (EIF_CHARACTER_8) '\\');
							}
							if (tb3) {
								tr1 = *(EIF_REFERENCE *)(Current);
								tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R7494[Dtype(RTCW(tr1))-963])(tr1, ((EIF_INTEGER_32) 3L)));
								tb2 = (EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) '\\');
							}
							if (tb2) {
								tr1 = *(EIF_REFERENCE *)(Current);
								tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R7494[Dtype(RTCW(tr1))-963])(tr1, ((EIF_INTEGER_32) 5L)));
								tb1 = (EIF_BOOLEAN)(tc1 != (EIF_CHARACTER_8) '\\');
							}
							if (tb1) {
								loc2 = F1196_11129(Current, ((EIF_INTEGER_32) 7L));
								tb1 = '\0';
								if ((EIF_BOOLEAN) (loc2 > ((EIF_INTEGER_32) 0L))) {
									tr1 = *(EIF_REFERENCE *)(Current);
									ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1) + O8828[Dtype(tr1)-1176]);
									tb1 = (EIF_BOOLEAN) ((EIF_INTEGER_32) (loc2 + F1196_11121(Current)) <= ti4_1);
								}
								if (tb1) {
									ti4_1 = F1196_11121(Current);
									ti4_1 = F1196_11129(Current, (EIF_INTEGER_32) (loc2 + ti4_1));
									loc2 = (EIF_INTEGER_32) ti4_1;
									if ((EIF_BOOLEAN) (loc2 > ((EIF_INTEGER_32) 0L))) {
										RTLE;
										return (EIF_INTEGER_32) (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L));
									} else {
										tr1 = *(EIF_REFERENCE *)(Current);
										Result = *(EIF_INTEGER_32 *)(RTCW(tr1) + O8828[Dtype(tr1)-1176]);
									}
								}
							}
						}
					}
				}
			}
		} else {
			tr1 = *(EIF_REFERENCE *)(Current);
			tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R7494[Dtype(RTCW(tr1))-963])(tr1, ((EIF_INTEGER_32) 1L)));
			if ((EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) '/')) {
				RTLE;
				return (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
			}
		}
	}
	RTLE;
	return Result;
}

/* {PATH}.end_position_of_last_directory_separator */
EIF_INTEGER_32 F1196_11128 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	EIF_CHARACTER_8 tc1;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current);
	tb1 = F783_8140(RTCW(tr1));
	if ((EIF_BOOLEAN) !tb1) {
		tr1 = *(EIF_REFERENCE *)(Current);
		Result = *(EIF_INTEGER_32 *)(RTCW(tr1) + O8828[Dtype(tr1)-1176]);
		ti4_1 = F1196_11121(Current);
		Result = (EIF_INTEGER_32) (EIF_INTEGER_32) ((EIF_INTEGER_32) (Result - ti4_1) + ((EIF_INTEGER_32) 1L));
		if ((EIF_BOOLEAN) (Result >= ((EIF_INTEGER_32) 1L))) {
			for (;;) {
				tb1 = '\01';
				if (!(EIF_BOOLEAN) (Result < ((EIF_INTEGER_32) 1L))) {
					tr1 = *(EIF_REFERENCE *)(Current);
					tc1 = F1196_11103(Current);
					tb1 = F1196_11133(Current, tr1, Result, tc1);
				}
				if (tb1) break;
				Result -= F1196_11121(Current);
			}
		}
		if ((EIF_BOOLEAN) (Result < ((EIF_INTEGER_32) 0L))) {
			RTLE;
			return (EIF_INTEGER_32) ((EIF_INTEGER_32) 0L);
		} else {
			ti4_1 = F1196_11121(Current);
			Result = (EIF_INTEGER_32) (EIF_INTEGER_32) ((EIF_INTEGER_32) (Result + ti4_1) - ((EIF_INTEGER_32) 1L));
		}
	}
	RTLE;
	return Result;
}

/* {PATH}.next_directory_separator */
EIF_INTEGER_32 F1196_11129 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_CHARACTER_8 loc3 = (EIF_CHARACTER_8) 0;
	EIF_REFERENCE loc4 = (EIF_REFERENCE) 0;
	EIF_BOOLEAN tb1;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,loc4);
	RTLIU(2);
	
	RTGC;
	loc2 = F1196_11121(Current);
	loc3 = F1196_11103(Current);
	Result = (EIF_INTEGER_32) arg1;
	loc4 = *(EIF_REFERENCE *)(Current);
	loc1 = *(EIF_INTEGER_32 *)(RTCW(loc4) + O8828[Dtype(loc4)-1176]);
	for (;;) {
		tb1 = '\01';
		if (!(EIF_BOOLEAN) ((EIF_BOOLEAN) (Result < ((EIF_INTEGER_32) 1L)) || (EIF_BOOLEAN) (Result > loc1))) {
			tb1 = F1196_11133(Current, loc4, Result, loc3);
		}
		if (tb1) break;
		Result += loc2;
	}
	if ((EIF_BOOLEAN) (Result > loc1)) {
		RTLE;
		return (EIF_INTEGER_32) ((EIF_INTEGER_32) 0L);
	}
	RTLE;
	return Result;
}

/* {PATH}.internal_append_into */
void F1196_11130 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2, EIF_CHARACTER_8 arg3)
{
	GTCX
	struct eif_ex_79 sloc1;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) sloc1.data;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_CHARACTER_32 tw1;
	EIF_CHARACTER_32 tw2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_BOOLEAN tb4;
	RTLD;
	
	memset (&sloc1.overhead, 0, OVERHEAD + _OBJSIZ_0_0_0_0_0_0_0_0_);
	sloc1.overhead.ov_flags = EO_EXP | EO_STACK;
	RT_DFS(&sloc1.overhead, eif_new_type(85, 0x00).id);
	RTLI(4);
	RTLR(0,arg2);
	RTLR(1,arg1);
	RTLR(2,Current);
	RTLR(3,loc1);
	RTLIU(4);
	
	RTGC;
	tb1 = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE)) R8607[Dtype(RTCW(arg2))-1174])(arg2);
	if ((EIF_BOOLEAN) !tb1) {
		tb1 = '\0';
		tb2 = '\0';
		tb3 = '\0';
		if ((EIF_BOOLEAN)(arg3 != (EIF_CHARACTER_8) '\000')) {
			tb4 = F783_8140(RTCW(arg1));
			tb3 = (EIF_BOOLEAN) !tb4;
		}
		if (tb3) {
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(arg1) + O8828[Dtype(arg1)-1176]);
			ti4_2 = F1196_11121(Current);
			tb2 = (EIF_BOOLEAN) !F1196_11133(Current, arg1, (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 - ti4_2) + ((EIF_INTEGER_32) 1L)), arg3);
		}
		if (tb2) {
			tw1 = (FUNCTION_CAST(EIF_CHARACTER_32, (EIF_REFERENCE, EIF_INTEGER_32)) R8593[Dtype(RTCW(arg2))-1174])(arg2, ((EIF_INTEGER_32) 1L));
			tw2 = (EIF_CHARACTER_32) (EIF_CHARACTER_8) '/';
			tb1 = (EIF_BOOLEAN)(tw1 != tw2);
		}
		if (tb1) {
			if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
				tw1 = (FUNCTION_CAST(EIF_CHARACTER_32, (EIF_REFERENCE, EIF_INTEGER_32)) R8593[Dtype(RTCW(arg2))-1174])(arg2, ((EIF_INTEGER_32) 1L));
				tw2 = (EIF_CHARACTER_32) (EIF_CHARACTER_8) '\\';
				if ((EIF_BOOLEAN)(tw1 != tw2)) {
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R8856[Dtype(RTCW(arg1))-1178])(arg1, arg3);
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R8856[Dtype(RTCW(arg1))-1178])(arg1, (EIF_CHARACTER_8) '\000');
				}
			} else {
				(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R8856[Dtype(RTCW(arg1))-1178])(arg1, arg3);
			}
		}
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
			F86_1663(RTCW(loc1), arg2, arg1);
		} else {
			F86_1638(RTCW(loc1), arg2, arg1);
		}
	}
	RTLE;
}

/* {PATH}.internal_path_append_into */
void F1196_11131 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2, EIF_CHARACTER_8 arg3)
{
	GTCX
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_BOOLEAN tb4;
	RTLD;
	
	RTLI(3);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,arg2);
	RTLIU(3);
	
	RTGC;
	tb1 = '\0';
	tb2 = '\0';
	tb3 = '\0';
	if ((EIF_BOOLEAN)(arg3 != (EIF_CHARACTER_8) '\000')) {
		tb4 = F783_8140(RTCW(arg1));
		tb3 = (EIF_BOOLEAN) !tb4;
	}
	if (tb3) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(arg1) + O8828[Dtype(arg1)-1176]);
		ti4_2 = F1196_11121(Current);
		tb2 = (EIF_BOOLEAN) !F1196_11133(Current, arg1, (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 - ti4_2) + ((EIF_INTEGER_32) 1L)), arg3);
	}
	if (tb2) {
		tb1 = (EIF_BOOLEAN) !F1196_11133(Current, arg2, ((EIF_INTEGER_32) 1L), arg3);
	}
	if (tb1) {
		(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R8856[Dtype(RTCW(arg1))-1178])(arg1, arg3);
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R8856[Dtype(RTCW(arg1))-1178])(arg1, (EIF_CHARACTER_8) '\000');
		}
	}
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R8852[Dtype(RTCW(arg1))-1178])(arg1, arg2);
	RTLE;
}

/* {PATH}.internal_path_append_substring_into */
void F1196_11132 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2, EIF_INTEGER_32 arg3, EIF_INTEGER_32 arg4, EIF_CHARACTER_8 arg5)
{
	GTCX
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_BOOLEAN tb4;
	RTLD;
	
	RTLI(3);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,arg2);
	RTLIU(3);
	
	RTGC;
	tb1 = '\0';
	tb2 = '\0';
	tb3 = '\0';
	if ((EIF_BOOLEAN)(arg5 != (EIF_CHARACTER_8) '\000')) {
		tb4 = F783_8140(RTCW(arg1));
		tb3 = (EIF_BOOLEAN) !tb4;
	}
	if (tb3) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(arg1) + O8828[Dtype(arg1)-1176]);
		ti4_2 = F1196_11121(Current);
		tb2 = (EIF_BOOLEAN) !F1196_11133(Current, arg1, (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 - ti4_2) + ((EIF_INTEGER_32) 1L)), arg5);
	}
	if (tb2) {
		tb1 = (EIF_BOOLEAN) !F1196_11133(Current, arg2, arg3, arg5);
	}
	if (tb1) {
		(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R8856[Dtype(RTCW(arg1))-1178])(arg1, arg5);
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R8856[Dtype(RTCW(arg1))-1178])(arg1, (EIF_CHARACTER_8) '\000');
		}
	}
	F1179_10554(RTCW(arg1), arg2, arg3, arg4);
	RTLE;
}

/* {PATH}.is_character */
EIF_BOOLEAN F1196_11133 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_INTEGER_32 arg2, EIF_CHARACTER_8 arg3)
{
	GTCX
	EIF_CHARACTER_8 tc1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,arg1);
	RTLIU(1);
	
	RTGC;
	if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
		Result = '\0';
		tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R7494[Dtype(RTCW(arg1))-963])(arg1, arg2));
		if ((EIF_BOOLEAN)(tc1 == arg3)) {
			tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R7494[Dtype(RTCW(arg1))-963])(arg1, (EIF_INTEGER_32) (arg2 + ((EIF_INTEGER_32) 1L))));
			Result = (EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) '\000');
		}
	} else {
		tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R7494[Dtype(RTCW(arg1))-963])(arg1, arg2));
		Result = (EIF_BOOLEAN) (EIF_BOOLEAN)(tc1 == arg3);
	}
	RTLE;
	return Result;
}

/* {PATH}.c_same_files */
EIF_BOOLEAN F1196_11136 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2)
{
	GTCX
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	
	
	Result = EIF_TEST(inline_F1196_11136 ((EIF_POINTER) arg1, (EIF_POINTER) arg2));
	return Result;
}

void EIF_Minit608 (void)
{
	GTCX
}


#ifdef __cplusplus
}
#endif
