note
	description: "Objects that represent an EV_TITLED_WINDOW generated by Build."
	legal: "See notice at end of class."
	status: "See notice at end of class."
	date: "$Date: 2021-03-15 14:43:14 +0000 (Mon, 15 Mar 2021) $"
	revision: "$Revision: 96855 $"

class
	ACTIVATION_KEY_VALIDATOR_WINDOW

inherit
	ACTIVATION_KEY_VALIDATOR_WINDOW_IMP

	EV_SHARED_APPLICATION
		undefine
			default_create,
			copy
		end

	PRODUCT_INFO
		rename
			Name as Product_name,
			Version as Product_version
		export
			{NONE} all
		undefine
			default_create,
			copy
		end

	KG_CONSTANTS
		export
			{NONE} all
		undefine
			default_create,
			copy
		end

	KG_ENVIRONMENT_VARIABLES_IMP
		export
			{NONE} all
		undefine
			default_create,
			copy
		end

create
	default_create

feature {NONE} -- Initialization

	user_create_interface_objects
		do
			create activation_date.make_now
			create default_link_color
		end

	user_initialization
			-- called by `initialize'.
			-- Any custom user initialization that
			-- could not be performed in `initialize',
			-- (due to regeneration of implementation class)
			-- can be added here.
		local
			engine: KG_ENGINE
			l_cd_key: STRING
			i: INTEGER
			font: EV_FONT
			p: EV_PIXMAP
			l_screen: EV_SCREEN
		do
			create engine.make (Product_name, Product_version)
			check
				not_activated: engine.is_initialized implies not engine.is_activated
			end
			engine.check_license
			if engine.can_run then
				exit_button.hide
				cancel_button.enable_sensitive
				cancel_button.select_actions.extend (agent on_cancel)
				i := engine.remaining_executions
				if i > 1 then
					exp_label_2.set_text ("This product will run " + i.out + " more times before you will be")
				elseif i = 1 then
					exp_label_2.set_text ("This product will run one more time before you will be")
				elseif i = 0 then
					exp_label_2.set_text ("This is the last time you can run this product before you will be")
				end
			else
				exp_label_2.set_text ("This product must be activated before you can run it.")
				exp_label_3.set_text ("")
			end
			exp_label_7.set_text (" " + Displayed_activation_site)
			exp_label_7.pointer_enter_actions.extend (agent on_highlight_hyperlink)
			exp_label_7.pointer_leave_actions.extend (agent on_unhighlight_hyperlink)
			exp_label_7.pointer_button_press_actions.force_extend (agent on_link_click)
			exp_label_7.set_foreground_color (create {EV_COLOR}.make_with_8_bit_rgb (0, 0, 255))
			activation_key_field_1.change_actions.extend (agent on_activation_key_change (activation_key_field_1))
			activation_key_field_2.change_actions.extend (agent on_activation_key_change (activation_key_field_2))
			activation_key_field_3.change_actions.extend (agent on_activation_key_change (activation_key_field_3))
			activation_key_field_4.change_actions.extend (agent on_activation_key_change (activation_key_field_4))
			activation_key_field_5.change_actions.extend (agent on_activation_key_change (activation_key_field_5))

			activation_key_field_1.set_minimum_width_in_characters (5)
			activation_key_field_2.set_minimum_width_in_characters (5)
			activation_key_field_3.set_minimum_width_in_characters (5)
			activation_key_field_4.set_minimum_width_in_characters (5)
			activation_key_field_5.set_minimum_width_in_characters (5)

			date_value_label.set_text (formatted_date (activation_date))
			if engine.username /= Void then
				username_field.set_text (engine.username)
			end
			username_field.focus_out_actions.extend (agent on_username_return)
			cd_key_field.focus_out_actions.extend (agent on_cd_key_field_return)
			l_cd_key := engine.cd_key
			if l_cd_key /= Void then
				cd_key_field.set_text (l_cd_key)
			end
			cd_key_field.change_actions.extend (agent on_cd_key_change)
			activate_button.select_actions.extend (agent on_activate_button_click)
			username_button.select_actions.extend (agent on_username_button_click)
			cd_key_button.select_actions.extend (agent on_cd_key_button_click)
			exit_button.select_actions.extend (agent ev_application.destroy)
			create font
			cd_key_field.set_minimum_width (font.string_width (Key_template))
			username_field.set_minimum_width (font.string_width (Key_template))
			create p
			if (create {RAW_FILE}.make_with_path (Left_image_path)).exists then
				activation_pixmap.set_with_named_path (Left_image_path)
			end
			if (create {RAW_FILE}.make_with_path (Logo_path)).exists then
				p.set_with_named_path (Logo_path)
				icon_fixed.set_background_pixmap (p)
			end
			description_label.set_text ("Activate " + Product_name)
			exp_label_1.set_text ("You have not yet activated your copy of "+ Short_name)
			set_title (Product_name + " Activation Wizard")

			create l_screen
			set_position ((l_screen.width - width) // 2, (l_screen.height - height) // 3)

				-- Ensure that we kill application when closing the dialog.
			close_request_actions.extend (agent ev_application.destroy)
		end

feature -- Settings

	set_actions (a_on_run, a_on_close: detachable PROCEDURE)
			-- Set `on_run' with `a_on_run', and `on_close' with `a_on_close'.
		do
			on_run := a_on_run
			on_close := a_on_close
		ensure
			on_run_set: on_run = a_on_run
			on_close_set: on_close = a_on_close
		end

feature {NONE} -- Event handlers

	on_run: detachable PROCEDURE
			-- Called after button "Activate later" or "Activate" is clicked

	on_close: detachable PROCEDURE
			-- Called after processing.

	on_cd_key_button_click
			-- CD Key button click event handler
		do
			cd_key_field.enable_edit
			cd_key_field.set_focus
			if cd_key_field.text_length > 0 then
				cd_key_field.select_all
			end
		end

	on_username_button_click
			-- Username button click event handler
		do
			username_field.enable_edit
			username_field.set_focus
			if username_field.text_length > 0 then
				username_field.select_all
			end
		end

	on_highlight_hyperlink
			-- Highlight link to web site
		do
			default_link_color := exp_label_7.foreground_color
			exp_label_7.set_foreground_color (create {EV_COLOR}.make_with_8_bit_rgb (255, 0, 0))
		end

	on_unhighlight_hyperlink
			-- Remove highlight from link to web site.
		do
			exp_label_7.set_foreground_color (default_link_color)
		end

	on_cd_key_change
			-- Called by `change_actions' of `cd_key_field'.
		local
			s: STRING
			i: INTEGER
		do
			s := cd_key_field.text
			from
				i := 1
			until
				i > s.count
			loop
				if not s.item (i).is_digit and s.item (i) /= Key_separator.item (1) then
					s.remove (i)
					i := i - 1
				end
				i := i + 1
			end
			if s.count > Cd_key_length then
				s.keep_head (Cd_key_length)
			end
			if s.count /= cd_key_field.text.count then
				cd_key_field.set_text (s)
			end
			if can_activate then
				test_activation
			else
				activate_button.disable_sensitive
			end
		end

	on_username_return
			-- Called by `return_actions' of `username_field'.
		do
			username_field.disable_edit
			if can_activate then
				test_activation
			end
		end

	on_cd_key_field_return
			-- Called by `return_actions' of `cd_key_field_1'.
		do
			if has_valid_cd_key_format (cd_key_field.text) then
				cd_key_field.disable_edit
			end
			if can_activate then
				test_activation
			else
				activate_button.disable_sensitive
			end
		end

	on_activation_key_change (a_field: EV_TEXT_FIELD)
			-- Called by `change_actions' of `activation_key_field_1'.
		local
			l_field: EV_TEXT_FIELD
			pos, i:INTEGER
			s: STRING
			changed: BOOLEAN
		do
			pos := a_field.caret_position
			s := a_field.text
			s.adjust -- Make sure to ignore any unwanted white space.
			if has_valid_activation_key_format (s) then
				activation_key_field_1.set_text (s.substring (1, 5))
				activation_key_field_2.set_text (s.substring (7, 11))
				activation_key_field_3.set_text (s.substring (13, 17))
				activation_key_field_4.set_text (s.substring (19, 23))
				activation_key_field_5.set_text (s.substring (25, 29))
			else
				from
					i := 1
				until
					i > s.count
				loop
					if not s.item (i).is_digit then
						s.remove (i)
						i := i - 1
						if i <= pos then
							pos := pos - 1
						end
						changed := True
					end
					i := i + 1
				end
				if s.count > 5 then
					s.keep_head (5)
					changed := True
				end
				if changed then
					a_field.set_text (s)
					if a_field.valid_caret_position (pos) then
						a_field.set_caret_position (pos)
					else
						a_field.set_caret_position (a_field.text_length + 1)
					end
				end
				if s.count = 5 and a_field.caret_position >= 6 then
					l_field := next_activation_field (a_field)
					l_field.set_focus
					l_field.set_caret_position (1)
				end
			end
			if can_activate then
				test_activation
			end
		end

	on_link_click
			-- Display web page to get activation code.
		local
			exec: EXECUTION_ENVIRONMENT
			l_url: STRING
		do
			create exec
			l_url := Activation_site + "?username=" + username_field.text + "&cdkey=" + cd_key_field.text +
				"&platform=" + Platform
			l_url.replace_substring_all (" ", "%%20")
			exec.launch (browser_command + " %"" + l_url + "%"")
		end

	on_activate_button_click
			-- Register product
		local
			engine: KG_ENGINE
		do
			create engine.make (Product_name, Product_version)
			engine.activate (current_activation_key, activation_date)
			hide
			if attached on_run as l_on_run then
				l_on_run.call (Void)
			end
			if attached on_close as l_on_close then
				l_on_close.call (Void)
			end
		end

	on_cancel
			-- Will register later
		do
			hide
			if attached on_run as l_on_run then
				l_on_run.call (Void)
			end
			if attached on_close as l_on_close then
				l_on_close.call (Void)
			end
		end

feature {NONE} -- Implementation

	Key_template: STRING = "*55555-55555-55555-55555-55555-55555*I"
			-- Key template used to calculate minimum width

	formatted_date (date: DATE): STRING
			-- Formatted version of `a_date'
		local
			names: DATE_TIME_TOOLS
			s: STRING
		do
			create names
			Result := names.Long_days_text.item (date.day_of_the_week).as_lower
			Result.put (Result.item (1).upper, 1)
			Result.append (", ")
			s := names.Long_months_text.item (date.month).as_lower
			s.put (s.item (1).upper, 1)
			Result.append (s)
			Result.append (" ")
			Result.append (date.day.out)
			inspect
				date.day
			when 1 then
				Result.append ("st ")
			when 2 then
				Result.append ("nd ")
			when 3 then
				Result.append ("rd ")
			else
				Result.append ("th ")
			end
			Result.append (date.year.out)
		end

	activation_date: DATE
			-- Activation date

	default_link_color: EV_COLOR
			-- Backup of web site link text color

	can_activate: BOOLEAN
			-- Are all fields filled in?
		do
			Result := not username_field.text.is_empty and cd_key_field.text.count = Cd_key_length and
						activation_key_field_1.text.count = 5 and activation_key_field_2.text.count = 5 and
						activation_key_field_3.text.count = 5 and activation_key_field_4.text.count = 5
		end

	test_activation
			-- Test if activation key is correct and enable `activate' button if so.
		require
			can_activate: can_activate
		local
			validator: KG_ACTIVATION_KEY_GENERATOR
			now: DATE
			now_utc: DATE
		do
			set_user_cd_key (current_cd_key, Product_name, Product_version)
			set_user_username (username_field.text, Product_name, Product_version)
			if (create {KG_CD_KEY_GENERATOR}.make (Product_name, Product_version)).is_valid_cd_key (user_cd_key (Product_name, Product_version)) then
				create now.make_now
				create now_utc.make_now_utc
				create validator.make (activation_date + create {DATE_DURATION}.make_by_days (now_utc.days - now.days), Product_name, Product_version, user_username (Product_name, Product_version), user_cd_key (Product_name, Product_version), platform)
				if validator.has_valid_activation_key_format (current_activation_key) and then validator.is_valid_activation_key (current_activation_key) then
					activate_button.enable_sensitive
				else
					activate_button.disable_sensitive
				end
			end
		end

	current_activation_key: STRING
			-- Activation key built from fields
		do
			Result := activation_key_field_1.text + Key_separator +
						activation_key_field_2.text + Key_separator +
						activation_key_field_3.text + Key_separator +
						activation_key_field_4.text + Key_separator +
						activation_key_field_5.text
		end

	current_cd_key: STRING
			-- CD key built from fields
		do
			Result := cd_key_field.text
		end

	next_activation_field (field: EV_TEXT_FIELD): EV_TEXT_FIELD
			-- CD Key field following `field' if any
		require
			non_void_field: field /= Void
			valid_field: field = activation_key_field_1 or field = activation_key_field_2 or
									field = activation_key_field_3 or field = activation_key_field_4 or
									field = activation_key_field_5
		do
			if field = activation_key_field_1 then
				Result := activation_key_field_2
			elseif field = activation_key_field_2 then
				Result := activation_key_field_3
			elseif field = activation_key_field_3 then
				Result := activation_key_field_4
			elseif field = activation_key_field_4 then
				Result := activation_key_field_5
			else
				check field = activation_key_field_5 end
				Result := activation_key_field_1
			end
		ensure
			definition: (field = activation_key_field_1 implies Result = activation_key_field_2) and
						(field = activation_key_field_2 implies Result = activation_key_field_3) and
						(field = activation_key_field_3 implies Result = activation_key_field_4) and
						(field = activation_key_field_4 implies Result = activation_key_field_5) and
						(field = activation_key_field_5 implies Result = activation_key_field_1)
		end

note
	copyright:	"Copyright (c) 1984-2006, Eiffel Software and others"
	license:	"Eiffel Forum License v2 (see http://www.eiffel.com/licensing/forum.txt)"
	source: "[
			 Eiffel Software
			 356 Storke Road, Goleta, CA 93117 USA
			 Telephone 805-685-1006, Fax 805-685-6869
			 Website http://www.eiffel.com
			 Customer support http://support.eiffel.com
		]"




end -- class ACTIVATION_KEY_VALIDATOR_WINDOW

