note
	description: "Keygen environment variables setting and reading"
	legal: "See notice at end of class."
	status: "See notice at end of class."
	date: "$Date: 2016-11-05 05:32:47 +0000 (Sat, 05 Nov 2016) $"
	revision: "$Revision: 96701 $"

class
	KG_ENVIRONMENT_VARIABLES_IMP

inherit
	KG_ENVIRONMENT_VARIABLES

	EIFFEL_LAYOUT

feature -- Access

	global_stored_value (name: STRING): STRING
			-- Value associated with storage name `name'.
		do
			if attached license_resources (False).get_string (name) as l_string then
				Result := l_string
			else
				Result := ""
			end
		end

	user_stored_value (name: STRING): STRING
			-- User specific value associated with storage name `name'.
		do
			if attached license_resources (True).get_string (name) as l_string then
				Result := l_string
			else
				Result := ""
			end
		end

	browser_command: STRING_32
			-- Retrieve internet browser command line
		do
			Result := "firefox"
		end

feature -- Settings

	set_global_stored_value (storage_name, value: STRING)
			-- Set `storage_name' with `value'.
		local
			l_table: RESOURCE_TABLE
		do
			l_table := license_resources (False)
			l_table.force (value, storage_name)
			save_data (Eiffel_global_license_path, l_table)
		end

	set_user_stored_value (storage_name, value: STRING)
			-- Set user specific `storage_name' with `value'.
		local
			l_table: RESOURCE_TABLE
		do
			l_table := license_resources (True)
			l_table.force (value, storage_name)
			save_data (Eiffel_user_license_path, l_table)
		end

feature {NONE} -- Implementation

	license_resources (is_local: BOOLEAN): RESOURCE_TABLE
			-- Hold data of current licensing.
		local
			l_parser: RESOURCE_PARSER
		do
			create Result.make (0)
			if is_local then
				create l_parser.parse_file (eiffel_user_license_path, Result)
			else
				create l_parser.parse_file (eiffel_global_license_path, Result)
			end
		end

	eiffel_user_license_path: PATH
			-- Path to file where license is stored.
		once
			Result := eiffel_layout.hidden_files_path.extended (".ec_license")
		end

	eiffel_global_license_path: PATH
			-- Path to file where license is stored.
		once
			Result := eiffel_layout.shared_path.extended (".ec_license")
		end

	save_data (a_filename: PATH; a_data: RESOURCE_TABLE)
			-- Store `a_data' into `a_filename'.
		require
			filename_not_void: a_filename /= Void
			data_not_void: a_data /= Void
		local
			l_file: PLAIN_TEXT_FILE
			retried: BOOLEAN
		do
			if not retried then
				create l_file.make_with_path (a_filename)
				l_file.open_write
				from
					a_data.start
				until
					a_data.after
				loop
					l_file.put_string (a_data.key_for_iteration)
					l_file.put_string (":%"")
					if a_data.item_for_iteration = Void then
						l_file.put_string ("")
					else
						l_file.put_string (a_data.item_for_iteration)
					end
					l_file.put_character ('"')
					l_file.put_new_line
					a_data.forth
				end
				l_file.close
			else
				io.error.put_string ("%NCould not write to file:%N")
				io.error.put_string (a_filename.name.as_string_8)
				io.error.put_string ("%NMake sure you have write permission to this file.%N")
			end
		rescue
			retried := True
			retry
		end

note
	copyright:	"Copyright (c) 1984-2006, Eiffel Software and others"
	license:	"Eiffel Forum License v2 (see http://www.eiffel.com/licensing/forum.txt)"
	source: "[
			 Eiffel Software
			 356 Storke Road, Goleta, CA 93117 USA
			 Telephone 805-685-1006, Fax 805-685-6869
			 Website http://www.eiffel.com
			 Customer support http://support.eiffel.com
		]"




end -- class KG_ENVIRONMENT_VARIABLES
