/*
 * Code for class PATH
 */

#include "eif_eiffel.h"
#include "../E1/estructure.h"
#include "../E1/eoffsets.h"

#include "pa513.h"
#include "eif_eiffel.h"
#include "eif_built_in.h"
#include "eif_path_name.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifndef INLINE_F1115_10527
static int inline_F1115_10527 (EIF_POINTER arg1, EIF_POINTER arg2)
{
	EIF_BOOLEAN Result = EIF_FALSE;
#ifdef EIF_WINDOWS
		/* To check this, we use `CreateFileW' to open both file, and then using the information
		 * returned by `GetFileInformationByHandle' we can check whether or not they are indeed
		 * the same.
		 * Note: it is important to use the W version of CreateFileW because arguments
		 * are Unicode, not ASCII. */
	BY_HANDLE_FILE_INFORMATION l_path1_info, l_path2_info;
	HANDLE l_path2_file = CreateFileW ((LPCWSTR) arg2, GENERIC_READ, FILE_SHARE_READ, NULL,
		OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	HANDLE l_path1_file = CreateFileW ((LPCWSTR) arg1, GENERIC_READ, FILE_SHARE_READ, NULL,
			OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);

	if ((l_path2_file == INVALID_HANDLE_VALUE) || (l_path1_file == INVALID_HANDLE_VALUE)) {
			/* We do not need the handles anymore, simply close them. Since Microsoft
			 * API accepts INVALID_HANDLE_VALUE we don't check the validity of arguments. */
		CloseHandle(l_path2_file);
		CloseHandle(l_path1_file);
	} else {
		BOOL success = GetFileInformationByHandle (l_path2_file, &l_path2_info);
		success = success && GetFileInformationByHandle (l_path1_file, &l_path1_info);
			/* We do not need the handles anymore, simply close them. */
		CloseHandle(l_path2_file);
		CloseHandle(l_path1_file);
		if (success) {
				/* Check that `path2' and `path1' do not represent the same file. */
			if
				((l_path2_info.dwVolumeSerialNumber == l_path1_info.dwVolumeSerialNumber) &&
				(l_path2_info.nFileIndexLow == l_path1_info.nFileIndexLow) &&
				(l_path2_info.nFileIndexHigh == l_path1_info.nFileIndexHigh))
			{
				Result = EIF_TRUE;
			}
		}
	}
#else
	struct stat buf1, buf2;
	int status;
	#ifdef HAS_LSTAT
		status = lstat(arg1, &buf1);
		if (status == 0) {
				/* We found a file, now let's check if it is not a symbolic link. If it is, we use `stat'
			 	 * to ensure the validity of the link. */
			if ((buf1.st_mode & S_IFLNK) == S_IFLNK) {
				status = stat (arg1, &buf1);
			}
		}
		
		if (status == 0) {
			status = lstat(arg2, &buf2);
			if (status == 0) {
					/* We found a file, now let's check if it is not a symbolic link. If it is, we use `stat'
				 	 * to ensure the validity of the link. */
				if ((buf2.st_mode & S_IFLNK) == S_IFLNK) {
					status = stat (arg2, &buf2);
				}
			}
		}
	#else
		status = stat (arg1, &buf1);
		if (status == 0) {
			status = stat (arg2, &buf2);
		}
	#endif
	if (status == 0) {
			/* Both files are present, check they represent the same one. */
		if ((buf1.st_dev == buf2.st_dev) && (buf1.st_ino == buf2.st_ino)) {
			Result = EIF_TRUE;
		}
	}
#endif
return Result;
	;
}
#define INLINE_F1115_10527
#endif

#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
extern "C" {
#endif

/* {PATH}.make_empty */
void F1115_10466 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTEAA("make_empty", 1114, Current, 0, 0, 14348);
	RTGC;
	RTHOOK(1);
	tr1 = RTLNSMART(eif_new_type(1098, 1).id);
	F1091_9529(RTCW(tr1));
	RTAR(Current, tr1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	RTHOOK(2);
	*(EIF_BOOLEAN *)(Current+ _CHROFF_2_0_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	RTHOOK(3);
	F1115_10513(Current);
	RTHOOK(6);
	RTLE;
	RTEE;
}

/* {PATH}.make_current */
void F1115_10467 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTEAA("make_current", 1114, Current, 0, 0, 14349);
	RTGC;
	RTHOOK(1);
	tr1 = RTLNSMART(eif_new_type(1098, 1).id);
	ti4_1 = F1115_10512(Current);
	F1097_9826(RTCW(tr1), ti4_1);
	RTAR(Current, tr1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	RTHOOK(2);
	tr1 = *(EIF_REFERENCE *)(Current);
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R7758[Dtype(RTCW(tr1))-1098])(tr1, (EIF_CHARACTER_8) '.');
	RTHOOK(3);
	if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
		RTHOOK(4);
		tr1 = *(EIF_REFERENCE *)(Current);
		(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R7758[Dtype(RTCW(tr1))-1098])(tr1, (EIF_CHARACTER_8) '\000');
	}
	RTHOOK(5);
	*(EIF_BOOLEAN *)(Current+ _CHROFF_2_0_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	RTHOOK(6);
	F1115_10513(Current);
	RTHOOK(10);
	RTLE;
	RTEE;
}

/* {PATH}.make_from_string */
void F1115_10468 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	RTLD;
	
	RTLI(3);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,arg1);
	RTLIU(3);
	
	RTEAA("make_from_string", 1114, Current, 0, 1, 14350);
	RTGC;
	RTHOOK(1);
	tr1 = RTLNSMART(eif_new_type(1098, 1).id);
	ti4_1 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R7531[Dtype(RTCW(arg1))-1094])(arg1);
	ti4_2 = F1115_10512(Current);
	F1097_9826(RTCW(tr1), (EIF_INTEGER_32) (ti4_1 * ti4_2));
	RTAR(Current, tr1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	RTHOOK(2);
	tb1 = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE)) R7509[Dtype(RTCW(arg1))-1094])(arg1);
	if ((EIF_BOOLEAN) !tb1) {
		RTHOOK(3);
		F1115_10521(Current, *(EIF_REFERENCE *)(Current), arg1, (EIF_CHARACTER_8) '\000');
		RTHOOK(4);
		F1115_10514(Current);
	} else {
		RTHOOK(5);
		*(EIF_BOOLEAN *)(Current+ _CHROFF_2_0_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	}
	RTHOOK(6);
	F1115_10513(Current);
	RTHOOK(11);
	RTLE;
	RTEE;
}

/* {PATH}.make_from_storage */
void F1115_10470 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,arg1);
	RTLIU(2);
	
	RTEAA("make_from_storage", 1114, Current, 0, 1, 14352);
	RTGC;
	RTHOOK(1);
	RTAR(Current, arg1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) arg1;
	RTHOOK(2);
	F1115_10514(Current);
	RTHOOK(3);
	F1115_10513(Current);
	RTHOOK(6);
	RTLE;
	RTEE;
}

/* {PATH}.make_from_normalized_storage */
void F1115_10471 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,arg1);
	RTLIU(2);
	
	RTEAA("make_from_normalized_storage", 1114, Current, 0, 1, 14353);
	RTGC;
	RTHOOK(1);
	RTAR(Current, arg1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) arg1;
	RTHOOK(2);
	*(EIF_BOOLEAN *)(Current+ _CHROFF_2_0_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	RTHOOK(3);
	F1115_10513(Current);
	RTHOOK(6);
	RTLE;
	RTEE;
}

/* {PATH}.make_from_pointer */
void F1115_10472 (EIF_REFERENCE Current, EIF_POINTER arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_BOOLEAN tb1;
	RTLD;
	
	RTLI(3);
	RTLR(0,Current);
	RTLR(1,loc1);
	RTLR(2,tr1);
	RTLIU(3);
	
	RTEAA("make_from_pointer", 1114, Current, 2, 1, 14354);
	RTGC;
	RTHOOK(1);
	loc2 = F430_5945(Current, arg1);
	RTHOOK(2);
	loc2 -= (EIF_INTEGER_32) (loc2 % F1115_10512(Current));
	RTHOOK(3);
	loc1 = RTLNS(eif_new_type(1003, 0x01).id, 1003, _OBJSIZ_1_0_0_1_0_0_0_0_);
	F1004_8427(RTCW(loc1), arg1, loc2);
	RTHOOK(4);
	tr1 = F1004_8435(RTCW(loc1), ((EIF_INTEGER_32) 1L), loc2);
	RTAR(Current, tr1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	RTHOOK(5);
	tr1 = *(EIF_REFERENCE *)(Current);
	tb1 = F759_7351(RTCW(tr1));
	if ((EIF_BOOLEAN) !tb1) {
		RTHOOK(6);
		F1115_10514(Current);
	}
	RTHOOK(7);
	F1115_10513(Current);
	RTHOOK(8);
	RTLE;
	RTEE;
}

/* {PATH}.is_current_symbol */
EIF_BOOLEAN F1115_10473 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTEAA("is_current_symbol", 1114, Current, 0, 0, 14355);
	RTGC;
	RTHOOK(1);
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
	if ((EIF_BOOLEAN)(ti4_1 == F1115_10512(Current))) {
		RTHOOK(2);
		RTHOOK(3);
		RTLE;
		RTEE;
		return (EIF_BOOLEAN) F1115_10524(Current, *(EIF_REFERENCE *)(Current), ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '.');
	}
	RTHOOK(4);
	RTLE;
	RTEE;
	return (EIF_BOOLEAN) 0;
}

/* {PATH}.is_parent_symbol */
EIF_BOOLEAN F1115_10474 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTEAA("is_parent_symbol", 1114, Current, 0, 0, 14356);
	RTGC;
	RTHOOK(1);
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
	if ((EIF_BOOLEAN)(ti4_1 == (EIF_INTEGER_32) (((EIF_INTEGER_32) 2L) * F1115_10512(Current)))) {
		RTHOOK(2);
		Result = F1115_10524(Current, *(EIF_REFERENCE *)(Current), ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '.');
		RTHOOK(3);
		tr1 = *(EIF_REFERENCE *)(Current);
		ti4_1 = F1115_10512(Current);
		Result = F1115_10524(Current, tr1, (EIF_INTEGER_32) (((EIF_INTEGER_32) 1L) + ti4_1), (EIF_CHARACTER_8) '.');
	}
	RTHOOK(4);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.has_root */
EIF_BOOLEAN F1115_10475 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("has_root", 1114, Current, 0, 0, 14357);
	RTGC;
	RTHOOK(1);
	ti4_1 = F1115_10518(Current);
	Result = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 != ((EIF_INTEGER_32) 0L));
	RTHOOK(3);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.is_empty */
EIF_BOOLEAN F1115_10476 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTEAA("is_empty", 1114, Current, 0, 0, 14358);
	RTGC;
	RTHOOK(1);
	tr1 = *(EIF_REFERENCE *)(Current);
	Result = F759_7351(RTCW(tr1));
	RTHOOK(2);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.is_relative */
EIF_BOOLEAN F1115_10477 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("is_relative", 1114, Current, 0, 0, 14359);
	RTGC;
	RTHOOK(1);
	Result = F1115_10478(Current);
	Result = (EIF_BOOLEAN) (EIF_BOOLEAN) !Result;
	RTHOOK(2);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.is_absolute */
EIF_BOOLEAN F1115_10478 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_CHARACTER_8 tc1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTEAA("is_absolute", 1114, Current, 1, 0, 14360);
	RTGC;
	RTHOOK(1);
	loc1 = F1115_10518(Current);
	RTHOOK(2);
	if ((EIF_BOOLEAN) (loc1 > ((EIF_INTEGER_32) 0L))) {
		RTHOOK(3);
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
			RTHOOK(4);
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = F1115_10512(Current);
			tc1 = F1115_10494(Current);
			Result = F1115_10524(Current, tr1, (EIF_INTEGER_32) ((EIF_INTEGER_32) (loc1 - ti4_1) + ((EIF_INTEGER_32) 1L)), tc1);
		} else {
			RTHOOK(5);
			RTHOOK(6);
			RTLE;
			RTEE;
			return (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
		}
	}
	RTHOOK(7);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.is_same_file_as */
EIF_BOOLEAN F1115_10480 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_POINTER tp2;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,loc2);
	RTLR(3,arg1);
	RTLIU(4);
	
	RTEAA("is_same_file_as", 1114, Current, 2, 1, 14362);
	RTGC;
	RTHOOK(1);
	loc1 = F1115_10509(Current);
	RTHOOK(2);
	loc2 = F1115_10509(RTCW(arg1));
	RTHOOK(3);
	tp1 = *(EIF_POINTER *)(RTCW(loc1)+ _PTROFF_0_1_0_1_0_0_);
	tp2 = *(EIF_POINTER *)(RTCW(loc2)+ _PTROFF_0_1_0_1_0_0_);
	Result = EIF_TEST (inline_F1115_10527(tp1, tp2));
	RTHOOK(4);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.has_extension */
EIF_BOOLEAN F1115_10481 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,arg1);
	RTLIU(4);
	
	RTEAA("has_extension", 1114, Current, 1, 1, 14363);
	RTGC;
	RTHOOK(1);
	Result = '\0';
	tr1 = F1115_10485(Current);
	loc1 = tr1;
	if (EIF_TEST(loc1)) {
		tb1 = F1091_9571(loc1, arg1);
		Result = tb1;
	}
	RTHOOK(2);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.root */
EIF_REFERENCE F1115_10482 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(3);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,Result);
	RTLIU(3);
	
	RTEAA("root", 1114, Current, 1, 0, 14364);
	RTGC;
	RTHOOK(1);
	loc1 = F1115_10518(Current);
	RTHOOK(2);
	if ((EIF_BOOLEAN)(loc1 != ((EIF_INTEGER_32) 0L))) {
		RTHOOK(3);
		tr1 = *(EIF_REFERENCE *)(Current);
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
		if ((EIF_BOOLEAN)(loc1 == ti4_1)) {
			RTHOOK(4);
			tr1 = RTLNS(eif_new_type(1114, 0x01).id, 1114, _OBJSIZ_2_1_0_0_0_0_0_0_);
			F1115_10471(RTCW(tr1), *(EIF_REFERENCE *)(Current));
			RTHOOK(5);
			RTLE;
			RTEE;
			return (EIF_REFERENCE) tr1;
		} else {
			RTHOOK(6);
			Result = RTLNS(eif_new_type(1114, 0x01).id, 1114, _OBJSIZ_2_1_0_0_0_0_0_0_);
			tr1 = *(EIF_REFERENCE *)(Current);
			tr1 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R7572[Dtype(RTCW(tr1))-1094])(tr1, ((EIF_INTEGER_32) 1L), loc1);
			F1115_10471(RTCW(Result), tr1);
		}
	}
	RTHOOK(8);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.parent */
EIF_REFERENCE F1115_10483 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,Current);
	RTLR(1,loc3);
	RTLR(2,tr1);
	RTLR(3,Result);
	RTLIU(4);
	
	RTEAA("parent", 1114, Current, 3, 0, 14365);
	RTGC;
	RTHOOK(1);
	loc1 = F1115_10519(Current);
	RTHOOK(2);
	if ((EIF_BOOLEAN)(loc1 == ((EIF_INTEGER_32) 0L))) {
		RTHOOK(3);
		tr1 = F1115_10482(Current);
		loc3 = tr1;
		if (EIF_TEST(loc3)) {
			
			RTHOOK(5);
			RTHOOK(6);
			RTLE;
			RTEE;
			return (EIF_REFERENCE) loc3;
		} else {
			RTHOOK(7);
			tr1 = RTLNS(eif_new_type(1114, 0x01).id, 1114, _OBJSIZ_2_1_0_0_0_0_0_0_);
			F1115_10467(RTCW(tr1));
			RTHOOK(8);
			RTLE;
			RTEE;
			return (EIF_REFERENCE) tr1;
		}
	} else {
		RTHOOK(9);
		if ((EIF_BOOLEAN)(loc1 == F1115_10512(Current))) {
			RTHOOK(10);
			Result = RTLNS(eif_new_type(1114, 0x01).id, 1114, _OBJSIZ_2_1_0_0_0_0_0_0_);
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = F1115_10512(Current);
			tr1 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R7572[Dtype(RTCW(tr1))-1094])(tr1, ((EIF_INTEGER_32) 1L), ti4_1);
			F1115_10471(RTCW(Result), tr1);
		} else {
			RTHOOK(11);
			loc2 = F1115_10518(Current);
			RTHOOK(12);
			if ((EIF_BOOLEAN) (loc1 <= loc2)) {
				RTHOOK(13);
				tr1 = *(EIF_REFERENCE *)(Current);
				ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
				if ((EIF_BOOLEAN)(loc2 == ti4_1)) {
					RTHOOK(14);
					RTHOOK(15);
					RTLE;
					RTEE;
					return (EIF_REFERENCE) Current;
				} else {
					RTHOOK(16);
					Result = RTLNS(eif_new_type(1114, 0x01).id, 1114, _OBJSIZ_2_1_0_0_0_0_0_0_);
					tr1 = *(EIF_REFERENCE *)(Current);
					tr1 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R7572[Dtype(RTCW(tr1))-1094])(tr1, ((EIF_INTEGER_32) 1L), loc2);
					F1115_10471(RTCW(Result), tr1);
				}
			} else {
				RTHOOK(17);
				Result = RTLNS(eif_new_type(1114, 0x01).id, 1114, _OBJSIZ_2_1_0_0_0_0_0_0_);
				tr1 = *(EIF_REFERENCE *)(Current);
				ti4_1 = F1115_10512(Current);
				tr1 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R7572[Dtype(RTCW(tr1))-1094])(tr1, ((EIF_INTEGER_32) 1L), (EIF_INTEGER_32) (loc1 - ti4_1));
				F1115_10471(RTCW(Result), tr1);
			}
		}
	}
	RTHOOK(18);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.entry */
EIF_REFERENCE F1115_10484 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_BOOLEAN tb4;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,tr2);
	RTLR(3,Result);
	RTLIU(4);
	
	RTEAA("entry", 1114, Current, 2, 0, 14366);
	RTGC;
	RTHOOK(1);
	loc1 = F1115_10519(Current);
	RTHOOK(2);
	if ((EIF_BOOLEAN)(loc1 == ((EIF_INTEGER_32) 0L))) {
		RTHOOK(3);
		loc2 = F1115_10518(Current);
		RTHOOK(4);
		if ((EIF_BOOLEAN) (loc2 > ((EIF_INTEGER_32) 0L))) {
			RTHOOK(5);
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
			if ((EIF_BOOLEAN) (loc2 < ti4_1)) {
				RTHOOK(6);
				Result = RTLNS(eif_new_type(1114, 0x01).id, 1114, _OBJSIZ_2_1_0_0_0_0_0_0_);
				tr1 = *(EIF_REFERENCE *)(Current);
				tr2 = *(EIF_REFERENCE *)(Current);
				ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr2)+ _LNGOFF_1_1_0_2_);
				tr1 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R7572[Dtype(RTCW(tr1))-1094])(tr1, (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L)), ti4_1);
				F1115_10471(RTCW(Result), tr1);
			}
		} else {
			RTHOOK(7);
			Result = (EIF_REFERENCE) Current;
		}
	} else {
		RTHOOK(8);
		loc2 = F1115_10518(Current);
		RTHOOK(9);
		if ((EIF_BOOLEAN) (loc1 <= loc2)) {
			RTHOOK(10);
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
			if ((EIF_BOOLEAN) (loc2 < ti4_1)) {
				RTHOOK(11);
				Result = RTLNS(eif_new_type(1114, 0x01).id, 1114, _OBJSIZ_2_1_0_0_0_0_0_0_);
				tr1 = *(EIF_REFERENCE *)(Current);
				tr2 = *(EIF_REFERENCE *)(Current);
				ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr2)+ _LNGOFF_1_1_0_2_);
				tr1 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R7572[Dtype(RTCW(tr1))-1094])(tr1, (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L)), ti4_1);
				F1115_10471(RTCW(Result), tr1);
			}
		} else {
			RTHOOK(12);
			Result = RTLNS(eif_new_type(1114, 0x01).id, 1114, _OBJSIZ_2_1_0_0_0_0_0_0_);
			tr1 = *(EIF_REFERENCE *)(Current);
			tr2 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr2)+ _LNGOFF_1_1_0_2_);
			tr1 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R7572[Dtype(RTCW(tr1))-1094])(tr1, (EIF_INTEGER_32) (loc1 + ((EIF_INTEGER_32) 1L)), ti4_1);
			F1115_10471(RTCW(Result), tr1);
		}
	}
	RTHOOK(13);
	tb1 = '\0';
	if ((EIF_BOOLEAN)(Result != NULL)) {
		tb2 = '\01';
		tb3 = '\01';
		tb4 = F1115_10476(RTCW(Result));
		if (!tb4) {
			tb4 = F1115_10473(RTCW(Result));
			tb3 = tb4;
		}
		if (!tb3) {
			tb3 = F1115_10474(RTCW(Result));
			tb2 = tb3;
		}
		tb1 = tb2;
	}
	if (tb1) {
		RTHOOK(14);
		RTHOOK(15);
		RTLE;
		RTEE;
		return (EIF_REFERENCE) NULL;
	}
	RTHOOK(17);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.extension */
EIF_REFERENCE F1115_10485 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc3 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE loc4 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_CHARACTER_32 tw1;
	RTLD;
	
	RTLI(4);
	RTLR(0,loc4);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,loc1);
	RTLIU(4);
	
	RTEAA("extension", 1114, Current, 4, 0, 14367);
	RTGC;
	RTHOOK(1);
	tr1 = F1115_10484(Current);
	loc4 = tr1;
	if (EIF_TEST(loc4)) {
		RTHOOK(2);
		loc1 = F1115_10507(loc4);
		RTHOOK(3);
		loc3 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_0_0_2_);
		RTHOOK(4);
		tw1 = (EIF_CHARACTER_32) (EIF_CHARACTER_8) '.';
		loc2 = F1094_9672(RTCW(loc1), tw1, loc3);
		RTHOOK(5);
		if ((EIF_BOOLEAN) ((EIF_BOOLEAN)(loc2 != ((EIF_INTEGER_32) 0L)) && (EIF_BOOLEAN)(loc2 != loc3))) {
			RTHOOK(6);
			tr1 = F1095_9728(RTCW(loc1), (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L)), loc3);
			RTHOOK(7);
			RTLE;
			RTEE;
			return (EIF_REFERENCE) tr1;
		}
	}
	RTHOOK(10);
	RTLE;
	RTEE;
	return (EIF_REFERENCE) 0;
}

/* {PATH}.components */
EIF_REFERENCE F1115_10486 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc3 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,Current);
	RTLR(1,Result);
	RTLR(2,loc1);
	RTLR(3,tr1);
	RTLIU(4);
	
	RTEAA("components", 1114, Current, 3, 0, 14368);
	RTGC;
	RTHOOK(1);
	{
		static EIF_TYPE_INDEX typarr0[] = {0xFF01,949,0xFF01,1114,0xFFFF};
		EIF_TYPE typres0;
		static EIF_TYPE typcache0 = {INVALID_DTYPE, 0};
		
		typres0 = (typcache0.id != INVALID_DTYPE ? typcache0 : (typcache0 = eif_compound_id(Dftype(Current), typarr0)));
		Result = RTLNS(typres0.id, 949, _OBJSIZ_1_1_0_1_0_0_0_0_);
	}
	F950_7843(RTCW(Result), ((EIF_INTEGER_32) 10L));
	RTHOOK(2);
	loc3 = F1115_10518(Current);
	RTHOOK(3);
	if ((EIF_BOOLEAN) (loc3 > ((EIF_INTEGER_32) 0L))) {
		RTHOOK(4);
		loc1 = RTLNS(eif_new_type(1098, 0x01).id, 1098, _OBJSIZ_1_1_0_3_0_0_0_0_);
		F1097_9826(RTCW(loc1), loc3);
		RTHOOK(5);
		F1099_9940(RTCW(loc1), *(EIF_REFERENCE *)(Current), ((EIF_INTEGER_32) 1L), loc3);
		RTHOOK(6);
		tr1 = RTLNS(eif_new_type(1114, 0x01).id, 1114, _OBJSIZ_2_1_0_0_0_0_0_0_);
		F1115_10471(RTCW(tr1), loc1);
		(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R5866[Dtype(RTCW(Result))-754])(Result, tr1);
		RTHOOK(7);
		loc3++;
	} else {
		RTHOOK(8);
		loc3 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
	}
	RTHOOK(9);
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
	if ((EIF_BOOLEAN) (loc3 <= ti4_1)) {
		RTHOOK(10);
		loc2 = (EIF_INTEGER_32) loc3;
		RTHOOK(11);
		loc3 = F1115_10520(Current, loc2);
		for (;;) {
			RTHOOK(12);
			if ((EIF_BOOLEAN)(loc3 == ((EIF_INTEGER_32) 0L))) break;
			RTHOOK(13);
			loc1 = RTLNS(eif_new_type(1098, 0x01).id, 1098, _OBJSIZ_1_1_0_3_0_0_0_0_);
			F1097_9826(RTCW(loc1), (EIF_INTEGER_32) (loc3 - loc2));
			RTHOOK(14);
			F1099_9940(RTCW(loc1), *(EIF_REFERENCE *)(Current), loc2, (EIF_INTEGER_32) (loc3 - ((EIF_INTEGER_32) 1L)));
			RTHOOK(15);
			tr1 = RTLNS(eif_new_type(1114, 0x01).id, 1114, _OBJSIZ_2_1_0_0_0_0_0_0_);
			F1115_10471(RTCW(tr1), loc1);
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R5866[Dtype(RTCW(Result))-754])(Result, tr1);
			RTHOOK(16);
			loc2 = F1115_10512(Current);
			loc2 = (EIF_INTEGER_32) (EIF_INTEGER_32) (loc3 + loc2);
			RTHOOK(17);
			loc3 = F1115_10520(Current, loc2);
		}
		RTHOOK(18);
		tr1 = *(EIF_REFERENCE *)(Current);
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
		if ((EIF_BOOLEAN) (loc2 <= ti4_1)) {
			RTHOOK(19);
			loc1 = RTLNS(eif_new_type(1098, 0x01).id, 1098, _OBJSIZ_1_1_0_3_0_0_0_0_);
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
			F1097_9826(RTCW(loc1), (EIF_INTEGER_32) (ti4_1 - loc2));
			RTHOOK(20);
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
			F1099_9940(RTCW(loc1), *(EIF_REFERENCE *)(Current), loc2, ti4_1);
			RTHOOK(21);
			tr1 = RTLNS(eif_new_type(1114, 0x01).id, 1114, _OBJSIZ_2_1_0_0_0_0_0_0_);
			F1115_10471(RTCW(tr1), loc1);
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R5866[Dtype(RTCW(Result))-754])(Result, tr1);
		}
	}
	RTHOOK(22);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.absolute_path */
EIF_REFERENCE F1115_10487 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(3);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,Result);
	RTLIU(3);
	
	RTEAA("absolute_path", 1114, Current, 0, 0, 14369);
	RTGC;
	RTHOOK(1);
	tr1 = F432_5970(RTCV(RTOSCF(10517,F1115_10517, (Current))));
	Result = F1115_10488(Current, tr1);
	RTHOOK(2);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.absolute_path_in */
EIF_REFERENCE F1115_10488 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_REFERENCE tr3 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_CHARACTER_8 tc1;
	EIF_CHARACTER_8 tc2;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(8);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,arg1);
	RTLR(3,loc1);
	RTLR(4,Result);
	RTLR(5,tr2);
	RTLR(6,tr3);
	RTLR(7,loc2);
	RTLIU(8);
	
	RTEAA("absolute_path_in", 1114, Current, 2, 1, 14370);
	RTGC;
	RTHOOK(1);
	tr1 = *(EIF_REFERENCE *)(Current);
	tb1 = F759_7351(RTCW(tr1));
	if (tb1) {
		RTHOOK(2);
		RTHOOK(3);
		RTLE;
		RTEE;
		return (EIF_REFERENCE) arg1;
	} else {
		RTHOOK(4);
		if (F1115_10478(Current)) {
			RTHOOK(5);
			RTHOOK(6);
			RTLE;
			RTEE;
			return (EIF_REFERENCE) Current;
		} else {
			RTHOOK(7);
			if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
				RTHOOK(8);
				tr1 = F1115_10482(Current);
				loc1 = tr1;
				if (EIF_TEST(loc1)) {
					RTHOOK(9);
					tb1 = '\0';
					tb2 = '\0';
					tr1 = *(EIF_REFERENCE *)(loc1);
					ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
					if ((EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 4L))) {
						tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
						ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
						tb2 = (EIF_BOOLEAN) (ti4_1 >= ((EIF_INTEGER_32) 4L));
					}
					if (tb2) {
						tb2 = '\0';
						tr1 = *(EIF_REFERENCE *)(loc1);
						tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R5979[Dtype(RTCW(tr1))-845])(tr1, ((EIF_INTEGER_32) 1L)));
						tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
						tc2 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R5979[Dtype(RTCW(tr1))-845])(tr1, ((EIF_INTEGER_32) 1L)));
						if ((EIF_BOOLEAN)(tc1 == tc2)) {
							tr1 = *(EIF_REFERENCE *)(loc1);
							tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R5979[Dtype(RTCW(tr1))-845])(tr1, ((EIF_INTEGER_32) 3L)));
							tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
							tc2 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R5979[Dtype(RTCW(tr1))-845])(tr1, ((EIF_INTEGER_32) 3L)));
							tb2 = (EIF_BOOLEAN)(tc1 == tc2);
						}
						tb1 = tb2;
					}
					if (tb1) {
						RTHOOK(10);
						Result = F1_14(arg1);
					} else {
						RTHOOK(11);
						Result = (EIF_REFERENCE) loc1;
					}
					RTHOOK(12);
					tr1 = *(EIF_REFERENCE *)(RTCW(Result));
					tr2 = *(EIF_REFERENCE *)(Current);
					tr3 = *(EIF_REFERENCE *)(loc1);
					ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr3)+ _LNGOFF_1_1_0_2_);
					tr3 = *(EIF_REFERENCE *)(Current);
					ti4_2 = *(EIF_INTEGER_32 *)(RTCW(tr3)+ _LNGOFF_1_1_0_2_);
					tc1 = F1115_10494(Current);
					F1115_10523(Current, tr1, tr2, (EIF_INTEGER_32) (ti4_1 + ((EIF_INTEGER_32) 1L)), ti4_2, tc1);
				} else {
					RTHOOK(13);
					if (F1115_10524(Current, *(EIF_REFERENCE *)(Current), ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '\\')) {
						RTHOOK(14);
						Result = F1_14(arg1);
						RTHOOK(15);
						tr1 = F1115_10482(RTCW(Result));
						loc2 = tr1;
						if (EIF_TEST(loc2)) {
							RTHOOK(16);
							Result = (EIF_REFERENCE) loc2;
						}
					} else {
						RTHOOK(17);
						Result = F1_14(arg1);
					}
					RTHOOK(18);
					tr1 = *(EIF_REFERENCE *)(RTCW(Result));
					tr2 = *(EIF_REFERENCE *)(Current);
					tc1 = F1115_10494(Current);
					F1115_10522(Current, tr1, tr2, tc1);
				}
			} else {
				RTHOOK(19);
				Result = F1_14(arg1);
				RTHOOK(20);
				tr1 = *(EIF_REFERENCE *)(RTCW(Result));
				tr2 = *(EIF_REFERENCE *)(Current);
				tc1 = F1115_10494(Current);
				F1115_10522(Current, tr1, tr2, tc1);
			}
			RTHOOK(21);
			F1115_10513(RTCW(Result));
		}
	}
	RTHOOK(23);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.canonical_path */
EIF_REFERENCE F1115_10489 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc4 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc5 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_CHARACTER_8 tc1;
	RTLD;
	
	RTLI(7);
	RTLR(0,loc2);
	RTLR(1,Current);
	RTLR(2,loc4);
	RTLR(3,tr1);
	RTLR(4,loc3);
	RTLR(5,loc1);
	RTLR(6,loc5);
	RTLIU(7);
	
	RTEAA("canonical_path", 1114, Current, 5, 0, 14371);
	RTGC;
	RTHOOK(1);
	loc2 = F1115_10487(Current);
	RTHOOK(2);
	tr1 = F1115_10482(RTCW(loc2));
	loc4 = tr1;
	if (EIF_TEST(loc4)) {
		RTHOOK(3);
		loc3 = RTLNSMART(eif_new_type(1098, 1).id);
		tr1 = *(EIF_REFERENCE *)(RTCW(loc2));
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
		F1097_9826(RTCW(loc3), ti4_1);
		RTHOOK(4);
		loc1 = F1115_10486(RTCW(loc2));
		
		RTHOOK(7);
		F950_7874(RTCW(loc1));
		RTHOOK(8);
		tr1 = F950_7848(RTCW(loc1));
		tr1 = *(EIF_REFERENCE *)(RTCW(tr1));
		tc1 = F1115_10494(Current);
		F1115_10522(Current, loc3, tr1, tc1);
		RTHOOK(9);
		(FUNCTION_CAST(void, (EIF_REFERENCE)) R5884[Dtype(RTCW(loc1))-796])(loc1);
		for (;;) {
			RTHOOK(10);
			tb1 = F914_7703(RTCW(loc1));
			if (tb1) break;
			RTHOOK(11);
			tr1 = F950_7848(RTCW(loc1));
			tb2 = F1115_10473(RTCW(tr1));
			if (tb2) {
				RTHOOK(12);
				(FUNCTION_CAST(void, (EIF_REFERENCE)) R5884[Dtype(RTCW(loc1))-796])(loc1);
			} else {
				RTHOOK(13);
				tr1 = F950_7848(RTCW(loc1));
				tb2 = F1115_10474(RTCW(tr1));
				if (tb2) {
					RTHOOK(14);
					tb2 = F890_7677(RTCW(loc1));
					if ((EIF_BOOLEAN) !tb2) {
						RTHOOK(15);
						F950_7877(RTCW(loc1));
						RTHOOK(16);
						(FUNCTION_CAST(void, (EIF_REFERENCE)) R5884[Dtype(RTCW(loc1))-796])(loc1);
					}
					RTHOOK(17);
					(FUNCTION_CAST(void, (EIF_REFERENCE)) R5884[Dtype(RTCW(loc1))-796])(loc1);
				} else {
					RTHOOK(18);
					F950_7876(RTCW(loc1));
				}
			}
		}
		RTHOOK(19);
		loc5 = F950_7857(RTCW(loc1));
		for (;;) {
			tb2 = F552_7140(loc5);
			if (tb2) break;
			RTHOOK(20);
			tr1 = F552_7131(loc5);
			tr1 = *(EIF_REFERENCE *)(RTCW(tr1));
			tc1 = F1115_10494(Current);
			F1115_10522(Current, loc3, tr1, tc1);
			RTHOOK(21);
			F552_7146(loc5);
		}
		RTHOOK(22);
		tr1 = RTLNS(eif_new_type(1114, 0x01).id, 1114, _OBJSIZ_2_1_0_0_0_0_0_0_);
		F1115_10471(RTCW(tr1), loc3);
		RTHOOK(23);
		RTLE;
		RTEE;
		return (EIF_REFERENCE) tr1;
	} else {
		
		RTHOOK(25);
		RTHOOK(26);
		RTLE;
		RTEE;
		return (EIF_REFERENCE) loc2;
	}/* NOTREACHED */
	
}

/* {PATH}.hash_code */
EIF_INTEGER_32 F1115_10490 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTEAA("hash_code", 1114, Current, 0, 0, 14372);
	RTGC;
	RTHOOK(1);
	if ((EIF_BOOLEAN) EIF_TEST(eif_case_sensitive_path_names())) {
		RTHOOK(2);
		tr1 = *(EIF_REFERENCE *)(Current);
		Result = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R7172[Dtype(RTCW(tr1))-1039])(tr1);
	} else {
		RTHOOK(3);
		Result = F1091_9539(RTCV(F1115_10507(Current)));
	}
	RTHOOK(4);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.directory_separator */
EIF_CHARACTER_8 F1115_10494 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("directory_separator", 1114, Current, 0, 0, 14376);
	RTGC;
	RTHOOK(1);
	if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
		RTHOOK(2);
		RTHOOK(3);
		RTLE;
		RTEE;
		return (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
	} else {
		RTHOOK(4);
		RTHOOK(5);
		RTLE;
		RTEE;
		return (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
	}/* NOTREACHED */
	
}

/* {PATH}.extended */
EIF_REFERENCE F1115_10495 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_INTEGER_32 ti4_4;
	EIF_BOOLEAN tb1;
	EIF_CHARACTER_8 tc1;
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,arg1);
	RTLIU(4);
	
	RTEAA("extended", 1114, Current, 2, 1, 14377);
	RTGC;
	RTHOOK(1);
	loc1 = RTLNSMART(eif_new_type(1098, 1).id);
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
	ti4_2 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R7531[Dtype(RTCW(arg1))-1094])(arg1);
	ti4_3 = F1115_10512(Current);
	ti4_4 = F1115_10512(Current);
	F1097_9826(RTCW(loc1), (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 + (EIF_INTEGER_32) (ti4_2 * ti4_3)) + ti4_4));
	RTHOOK(2);
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R7754[Dtype(RTCW(loc1))-1098])(loc1, *(EIF_REFERENCE *)(Current));
	RTHOOK(3);
	tb1 = '\0';
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_);
	if ((EIF_BOOLEAN) (ti4_1 > ((EIF_INTEGER_32) 0L))) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_);
		tb1 = (EIF_BOOLEAN)(F1115_10518(Current) == ti4_1);
	}
	if (tb1) {
		RTHOOK(4);
		F1115_10521(Current, loc1, arg1, (EIF_CHARACTER_8) '\000');
	} else {
		RTHOOK(5);
		tc1 = F1115_10494(Current);
		F1115_10521(Current, loc1, arg1, tc1);
	}
	RTHOOK(6);
	tr1 = RTLNS(eif_new_type(1114, 0x01).id, 1114, _OBJSIZ_2_1_0_0_0_0_0_0_);
	F1115_10470(RTCW(tr1), loc1);
	RTHOOK(7);
	RTLE;
	RTEE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.extended_path */
EIF_REFERENCE F1115_10496 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_BOOLEAN tb1;
	EIF_CHARACTER_8 tc1;
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,arg1);
	RTLIU(4);
	
	RTEAA("extended_path", 1114, Current, 1, 1, 14378);
	RTGC;
	RTHOOK(1);
	loc1 = RTLNSMART(eif_new_type(1098, 1).id);
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
	tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
	ti4_2 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
	ti4_3 = F1115_10512(Current);
	F1097_9826(RTCW(loc1), (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 + ti4_2) + ti4_3));
	RTHOOK(2);
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R7754[Dtype(RTCW(loc1))-1098])(loc1, *(EIF_REFERENCE *)(Current));
	RTHOOK(3);
	tb1 = '\0';
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_);
	if ((EIF_BOOLEAN) (ti4_1 > ((EIF_INTEGER_32) 0L))) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_);
		tb1 = (EIF_BOOLEAN)(F1115_10518(Current) == ti4_1);
	}
	if (tb1) {
		RTHOOK(4);
		tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
		F1115_10522(Current, loc1, tr1, (EIF_CHARACTER_8) '\000');
	} else {
		RTHOOK(5);
		tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
		tc1 = F1115_10494(Current);
		F1115_10522(Current, loc1, tr1, tc1);
	}
	RTHOOK(6);
	tr1 = RTLNS(eif_new_type(1114, 0x01).id, 1114, _OBJSIZ_2_1_0_0_0_0_0_0_);
	F1115_10471(RTCW(tr1), loc1);
	RTHOOK(7);
	RTLE;
	RTEE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.appended */
EIF_REFERENCE F1115_10497 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,arg1);
	RTLIU(4);
	
	RTEAA("appended", 1114, Current, 1, 1, 14379);
	RTGC;
	RTHOOK(1);
	loc1 = RTLNSMART(eif_new_type(1098, 1).id);
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
	ti4_2 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R7531[Dtype(RTCW(arg1))-1094])(arg1);
	ti4_3 = F1115_10512(Current);
	F1097_9826(RTCW(loc1), (EIF_INTEGER_32) (ti4_1 + (EIF_INTEGER_32) (ti4_2 * ti4_3)));
	RTHOOK(2);
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R7754[Dtype(RTCW(loc1))-1098])(loc1, *(EIF_REFERENCE *)(Current));
	RTHOOK(3);
	F1115_10521(Current, loc1, arg1, (EIF_CHARACTER_8) '\000');
	RTHOOK(4);
	tr1 = RTLNS(eif_new_type(1114, 0x01).id, 1114, _OBJSIZ_2_1_0_0_0_0_0_0_);
	F1115_10470(RTCW(tr1), loc1);
	RTHOOK(5);
	RTLE;
	RTEE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.appended_with_extension */
EIF_REFERENCE F1115_10498 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_INTEGER_32 ti4_4;
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,arg1);
	RTLIU(4);
	
	RTEAA("appended_with_extension", 1114, Current, 2, 1, 14380);
	RTGC;
	RTHOOK(1);
	loc1 = RTLNSMART(eif_new_type(1098, 1).id);
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
	ti4_2 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R7531[Dtype(RTCW(arg1))-1094])(arg1);
	ti4_3 = F1115_10512(Current);
	ti4_4 = F1115_10512(Current);
	F1097_9826(RTCW(loc1), (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 + (EIF_INTEGER_32) (ti4_2 * ti4_3)) + ti4_4));
	RTHOOK(2);
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R7754[Dtype(RTCW(loc1))-1098])(loc1, *(EIF_REFERENCE *)(Current));
	RTHOOK(3);
	F1115_10521(Current, loc1, arg1, (EIF_CHARACTER_8) '.');
	RTHOOK(4);
	tr1 = RTLNS(eif_new_type(1114, 0x01).id, 1114, _OBJSIZ_2_1_0_0_0_0_0_0_);
	F1115_10471(RTCW(tr1), loc1);
	RTHOOK(5);
	RTLE;
	RTEE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.same_as */
EIF_BOOLEAN F1115_10499 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(2);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLIU(2);
	
	RTEAA("same_as", 1114, Current, 0, 1, 14381);
	RTGC;
	RTHOOK(1);
	if ((EIF_BOOLEAN)(arg1 == NULL)) {
	} else {
		RTHOOK(2);
		if ((EIF_BOOLEAN)(arg1 == Current)) {
			RTHOOK(3);
			RTHOOK(4);
			RTLE;
			RTEE;
			return (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
		} else {
			RTHOOK(5);
			if ((EIF_BOOLEAN) EIF_TEST(eif_case_sensitive_path_names())) {
				RTHOOK(6);
				RTHOOK(7);
				RTLE;
				RTEE;
				return (EIF_BOOLEAN) F1115_10502(Current, arg1);
			} else {
				RTHOOK(8);
				RTHOOK(9);
				RTLE;
				RTEE;
				return (EIF_BOOLEAN) F1115_10503(Current, arg1);
			}
		}
	}
	RTHOOK(10);
	RTLE;
	RTEE;
	return (EIF_BOOLEAN) 0;
}

/* {PATH}.is_less */
EIF_BOOLEAN F1115_10500 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,arg1);
	RTLR(3,tr2);
	RTLIU(4);
	
	RTEAA("is_less", 1114, Current, 0, 1, 14382);
	RTGC;
	RTHOOK(1);
	if ((EIF_BOOLEAN) EIF_TEST(eif_case_sensitive_path_names())) {
		RTHOOK(2);
		tr1 = *(EIF_REFERENCE *)(Current);
		tr2 = *(EIF_REFERENCE *)(RTCW(arg1));
		Result = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE, EIF_REFERENCE)) R4370[Dtype(RTCW(tr1))-380])(tr1, tr2);
	} else {
		RTHOOK(3);
		tr1 = F1095_9725(RTCV(F1115_10507(Current)));
		tr2 = F1115_10507(RTCW(arg1));
		tr2 = F1095_9725(RTCW(tr2));
		Result = F1094_9688(RTCW(tr1), tr2);
	}
	RTHOOK(4);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.is_equal */
EIF_BOOLEAN F1115_10501 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	
	
	RTEAA("is_equal", 1114, Current, 0, 1, 14383);
	RTHOOK(1);
	RTHOOK(2);
	RTEE;
	return (EIF_BOOLEAN) F1115_10499(Current, arg1);
}

/* {PATH}.is_case_sensitive_equal */
EIF_BOOLEAN F1115_10502 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,tr2);
	RTLIU(4);
	
	RTEAA("is_case_sensitive_equal", 1114, Current, 0, 1, 14384);
	RTGC;
	RTHOOK(1);
	if ((EIF_BOOLEAN)(arg1 == Current)) {
		RTHOOK(2);
		RTHOOK(3);
		RTLE;
		RTEE;
		return (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	} else {
		RTHOOK(4);
		tr1 = *(EIF_REFERENCE *)(Current);
		tr2 = *(EIF_REFERENCE *)(RTCW(arg1));
		Result = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE, EIF_REFERENCE)) R11[Dtype(RTCW(tr1))-1])(tr1, tr2);
	}
	RTHOOK(5);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.is_case_insensitive_equal */
EIF_BOOLEAN F1115_10503 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,tr2);
	RTLIU(4);
	
	RTEAA("is_case_insensitive_equal", 1114, Current, 0, 1, 14385);
	RTGC;
	RTHOOK(1);
	if ((EIF_BOOLEAN)(arg1 == Current)) {
		RTHOOK(2);
		RTHOOK(3);
		RTLE;
		RTEE;
		return (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	} else {
		RTHOOK(4);
		tr1 = F1115_10507(Current);
		tr2 = F1115_10507(RTCW(arg1));
		Result = F1094_9684(RTCW(tr1), tr2);
	}
	RTHOOK(5);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.copy */
void F1115_10504 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(3);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLIU(3);
	
	RTEAA("copy", 1114, Current, 0, 1, 14386);
	RTGC;
	RTHOOK(1);
	if ((EIF_BOOLEAN)(arg1 != Current)) {
		RTHOOK(2);
		eif_builtin_ANY_standard_copy__o_ (Current, arg1);
		RTHOOK(3);
		tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
		tr1 = F1_14(tr1);
		RTAR(Current, tr1);
		*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	}
	RTHOOK(4);
	RTLE;
	RTEE;
}

/* {PATH}.out */
EIF_REFERENCE F1115_10505 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(3);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLIU(3);
	
	RTEAA("out", 1114, Current, 1, 0, 14387);
	RTGC;
	RTHOOK(1);
	tr1 = F1115_10507(Current);
	loc1 = tr1;
	loc1 = RTRV(eif_new_type(1096, 0x01),loc1);
	if (EIF_TEST(loc1)) {
		RTHOOK(2);
		tr1 = RTLNS(eif_new_type(1098, 0x01).id, 1098, _OBJSIZ_1_1_0_3_0_0_0_0_);
		F1097_9828(RTCW(tr1), loc1);
		RTHOOK(3);
		RTLE;
		RTEE;
		return (EIF_REFERENCE) tr1;
	} else {
		RTHOOK(4);
		RTHOOK(5);
		RTLE;
		RTEE;
		return (EIF_REFERENCE) F1115_10506(Current);
	}/* NOTREACHED */
	
}

/* {PATH}.utf_8_name */
EIF_REFERENCE F1115_10506 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	struct eif_ex_71 sloc1;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) sloc1.data;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	memset (&sloc1.overhead, 0, OVERHEAD + _OBJSIZ_0_0_0_0_0_0_0_0_);
	sloc1.overhead.ov_flags = EO_EXP | EO_STACK;
	RT_DFS(&sloc1.overhead, eif_new_type(78, 0x00).id);
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,Result);
	RTLIU(4);
	
	RTEAA("utf_8_name", 1114, Current, 1, 0, 14388);
	RTGC;
	RTHOOK(1);
	tr1 = F1115_10507(Current);
	Result = F79_1092(RTCW(loc1), tr1);
	RTHOOK(2);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.name */
EIF_REFERENCE F1115_10507 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	struct eif_ex_71 sloc1;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) sloc1.data;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	memset (&sloc1.overhead, 0, OVERHEAD + _OBJSIZ_0_0_0_0_0_0_0_0_);
	sloc1.overhead.ov_flags = EO_EXP | EO_STACK;
	RT_DFS(&sloc1.overhead, eif_new_type(78, 0x00).id);
	RTLI(5);
	RTLR(0,loc2);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,loc1);
	RTLR(4,Result);
	RTLIU(5);
	
	RTEAA("name", 1114, Current, 2, 0, 14389);
	RTGC;
	RTHOOK(1);
	tr1 = *(EIF_REFERENCE *)(Current + _REFACS_1_);
	loc2 = tr1;
	if (EIF_TEST(loc2)) {
		RTHOOK(2);
		RTHOOK(3);
		RTLE;
		RTEE;
		return (EIF_REFERENCE) loc2;
	} else {
		RTHOOK(4);
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
			RTHOOK(5);
			Result = RTLNS(eif_new_type(1094, 0x01).id, 1094, _OBJSIZ_1_0_0_4_0_0_0_0_);
			tr1 = F79_1131(RTCW(loc1), *(EIF_REFERENCE *)(Current));
			F1094_9661(RTCW(Result), tr1);
		} else {
			RTHOOK(6);
			Result = RTLNS(eif_new_type(1094, 0x01).id, 1094, _OBJSIZ_1_0_0_4_0_0_0_0_);
			tr1 = F79_1104(RTCW(loc1), *(EIF_REFERENCE *)(Current));
			F1094_9661(RTCW(Result), tr1);
		}
		RTHOOK(7);
		RTAR(Current, Result);
		*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) Result;
	}
	RTHOOK(9);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.to_pointer */
EIF_REFERENCE F1115_10509 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	RTLD;
	
	RTLI(3);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLIU(3);
	
	RTEAA("to_pointer", 1114, Current, 1, 0, 14391);
	RTGC;
	RTHOOK(1);
	loc1 = RTLNS(eif_new_type(1003, 0x01).id, 1003, _OBJSIZ_1_0_0_1_0_0_0_0_);
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
	ti4_2 = F1115_10512(Current);
	F1004_8423(RTCW(loc1), (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 + ti4_2) - ((EIF_INTEGER_32) 1L)));
	RTHOOK(2);
	F1004_8450(RTCW(loc1), *(EIF_REFERENCE *)(Current));
	RTHOOK(3);
	tr1 = *(EIF_REFERENCE *)(RTCW(loc1));
	RTHOOK(4);
	RTLE;
	RTEE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.unit_size */
EIF_INTEGER_32 F1115_10512 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("unit_size", 1114, Current, 0, 0, 14394);
	RTGC;
	RTHOOK(1);
	if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
		RTHOOK(2);
		RTHOOK(3);
		RTLE;
		RTEE;
		return (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
	} else {
		RTHOOK(4);
		RTHOOK(5);
		RTLE;
		RTEE;
		return (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
	}/* NOTREACHED */
	
}

/* {PATH}.reset_internal_data */
void F1115_10513 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	
	
	RTEAA("reset_internal_data", 1114, Current, 0, 0, 14395);
	RTHOOK(1);
	*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) NULL;
	RTHOOK(2);
	RTEE;
}

/* {PATH}.normalize */
void F1115_10514 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc3 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc4 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc5 = (EIF_INTEGER_32) 0;
	EIF_BOOLEAN loc6 = (EIF_BOOLEAN) 0;
	EIF_BOOLEAN loc7 = (EIF_BOOLEAN) 0;
	EIF_BOOLEAN loc8 = (EIF_BOOLEAN) 0;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_CHARACTER_8 tc1;
	RTLD;
	
	RTLI(2);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLIU(2);
	
	RTEAA("normalize", 1114, Current, 8, 0, 14396);
	RTGC;
	RTHOOK(1);
	loc1 = *(EIF_REFERENCE *)(Current);
	RTHOOK(2);
	loc4 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_);
	RTHOOK(3);
	if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
		RTHOOK(4);
		loc2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
		RTHOOK(5);
		if ((EIF_BOOLEAN) (loc4 >= ((EIF_INTEGER_32) 10L))) {
			RTHOOK(6);
			tb1 = '\01';
			tb2 = '\0';
			if (F1115_10524(Current, loc1, ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '/')) {
				tb3 = '\01';
				if (!F1115_10524(Current, loc1, ((EIF_INTEGER_32) 3L), (EIF_CHARACTER_8) '/')) {
					tb3 = F1115_10524(Current, loc1, ((EIF_INTEGER_32) 3L), (EIF_CHARACTER_8) '\\');
				}
				tb2 = tb3;
			}
			if (!tb2) {
				tb2 = '\0';
				if (F1115_10524(Current, loc1, ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '\\')) {
					tb3 = '\01';
					if (!F1115_10524(Current, loc1, ((EIF_INTEGER_32) 3L), (EIF_CHARACTER_8) '\\')) {
						tb3 = F1115_10524(Current, loc1, ((EIF_INTEGER_32) 3L), (EIF_CHARACTER_8) '/');
					}
					tb2 = tb3;
				}
				tb1 = tb2;
			}
			if (tb1) {
				RTHOOK(7);
				tb1 = '\0';
				if ((EIF_BOOLEAN) !F1115_10524(Current, loc1, ((EIF_INTEGER_32) 5L), (EIF_CHARACTER_8) '/')) {
					tb1 = (EIF_BOOLEAN) !F1115_10524(Current, loc1, ((EIF_INTEGER_32) 5L), (EIF_CHARACTER_8) '\\');
				}
				if (tb1) {
					RTHOOK(8);
					loc2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 5L);
					RTHOOK(9);
					loc8 = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
				}
			}
		}
		RTHOOK(10);
		loc3 = (EIF_INTEGER_32) loc2;
		RTHOOK(11);
		loc7 = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
		for (;;) {
			RTHOOK(12);
			if ((EIF_BOOLEAN) (loc2 > loc4)) break;
			RTHOOK(13);
			if (loc6) {
				RTHOOK(14);
				loc7 = '\0';
				if ((EIF_BOOLEAN) !F1115_10524(Current, loc1, loc2, (EIF_CHARACTER_8) '\\')) {
					loc7 = (EIF_BOOLEAN) !F1115_10524(Current, loc1, loc2, (EIF_CHARACTER_8) '/');
				}
				RTHOOK(15);
				loc6 = (EIF_BOOLEAN) (EIF_BOOLEAN) !loc7;
			} else {
				RTHOOK(16);
				if (F1115_10524(Current, loc1, loc2, (EIF_CHARACTER_8) '/')) {
					RTHOOK(17);
					tc1 = (EIF_CHARACTER_8) '\\';
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE, EIF_REFERENCE)) R5875[Dtype(RTCW(loc1))-845])(loc1, (EIF_REFERENCE) &tc1, (EIF_REFERENCE) &loc2);
					RTHOOK(18);
					loc6 = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
				} else {
					RTHOOK(19);
					loc6 = F1115_10524(Current, loc1, loc2, (EIF_CHARACTER_8) '\\');
				}
			}
			RTHOOK(20);
			if (loc7) {
				RTHOOK(21);
				if ((EIF_BOOLEAN)(loc2 != loc3)) {
					RTHOOK(22);
					tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R5979[Dtype(RTCW(loc1))-845])(loc1, loc2));
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE, EIF_REFERENCE)) R5875[Dtype(RTCW(loc1))-845])(loc1, (EIF_REFERENCE) &tc1, (EIF_REFERENCE) &loc3);
					RTHOOK(23);
					tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R5979[Dtype(RTCW(loc1))-845])(loc1, (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L))));
					ti4_1 = (EIF_INTEGER_32) (loc3 + ((EIF_INTEGER_32) 1L));
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE, EIF_REFERENCE)) R5875[Dtype(RTCW(loc1))-845])(loc1, (EIF_REFERENCE) &tc1, (EIF_REFERENCE) &ti4_1);
				}
				RTHOOK(24);
				loc3 += ((EIF_INTEGER_32) 2L);
			}
			RTHOOK(25);
			loc2 += ((EIF_INTEGER_32) 2L);
		}
	} else {
		RTHOOK(26);
		loc2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
		RTHOOK(27);
		loc3 = (EIF_INTEGER_32) loc2;
		RTHOOK(28);
		loc7 = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
		for (;;) {
			RTHOOK(29);
			if ((EIF_BOOLEAN) (loc2 > loc4)) break;
			RTHOOK(30);
			if (loc6) {
				RTHOOK(31);
				loc7 = F1115_10524(Current, loc1, loc2, (EIF_CHARACTER_8) '/');
				loc7 = (EIF_BOOLEAN) (EIF_BOOLEAN) !loc7;
				RTHOOK(32);
				loc6 = (EIF_BOOLEAN) (EIF_BOOLEAN) !loc7;
			} else {
				RTHOOK(33);
				loc6 = F1115_10524(Current, loc1, loc2, (EIF_CHARACTER_8) '/');
			}
			RTHOOK(34);
			if (loc7) {
				RTHOOK(35);
				if ((EIF_BOOLEAN)(loc2 != loc3)) {
					RTHOOK(36);
					tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R5979[Dtype(RTCW(loc1))-845])(loc1, loc2));
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE, EIF_REFERENCE)) R5875[Dtype(RTCW(loc1))-845])(loc1, (EIF_REFERENCE) &tc1, (EIF_REFERENCE) &loc3);
				}
				RTHOOK(37);
				loc3++;
			}
			RTHOOK(38);
			loc2++;
		}
	}
	RTHOOK(39);
	if ((EIF_BOOLEAN)(loc2 != loc3)) {
		RTHOOK(40);
		(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_INTEGER_32)) R7610[Dtype(RTCW(loc1))-1095])(loc1, (EIF_INTEGER_32) (loc3 - ((EIF_INTEGER_32) 1L)));
	}
	RTHOOK(41);
	*(EIF_BOOLEAN *)(Current+ _CHROFF_2_0_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	RTHOOK(42);
	if (loc8) {
		RTHOOK(43);
		loc5 = F1115_10518(Current);
		RTHOOK(44);
		if ((EIF_BOOLEAN)(loc5 == ((EIF_INTEGER_32) 0L))) {
			RTHOOK(45);
			ti4_1 = F1115_10512(Current);
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_INTEGER_32)) R7616[Dtype(RTCW(loc1))-1095])(loc1, ti4_1);
		}
	}
	RTHOOK(46);
	tb1 = '\0';
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_);
	ti4_2 = F1115_10512(Current);
	tc1 = F1115_10494(Current);
	if (F1115_10524(Current, loc1, (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 - ti4_2) + ((EIF_INTEGER_32) 1L)), tc1)) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_);
		tb1 = (EIF_BOOLEAN) (F1115_10518(Current) < ti4_1);
	}
	if (tb1) {
		RTHOOK(47);
		ti4_1 = F1115_10512(Current);
		(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_INTEGER_32)) R7618[Dtype(RTCW(loc1))-1095])(loc1, ti4_1);
	}
	RTHOOK(49);
	RTLE;
	RTEE;
}

/* {PATH}.env */
static EIF_REFERENCE F1115_10517_body (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	

	RTLI(2);
	RTLR(0,tr1);
	RTLR(1,Current);
	RTLIU(2);
	
	RTEAA("env", 1114, Current, 0, 0, 14399);
	RTGC;
	RTOSP (10517);
#define Result RTOSR(10517)
	RTOC_NEW(Result);
	RTHOOK(1);
	tr1 = RTLNS(eif_new_type(431, 0x01).id, 431, _OBJSIZ_0_0_0_1_0_0_0_0_);
	Result = (EIF_REFERENCE) tr1;
	RTOSE (10517);
	RTHOOK(2);
	RTLE;
	RTEE;
	return Result;
#undef Result
}

EIF_REFERENCE F1115_10517 (EIF_REFERENCE Current)
{
	GTCX
	return RTOSCF(10517,F1115_10517_body,(Current));
}

/* {PATH}.root_end_position */
EIF_INTEGER_32 F1115_10518 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_CHARACTER_8 loc1 = (EIF_CHARACTER_8) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_CHARACTER_8 tc1;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTEAA("root_end_position", 1114, Current, 2, 0, 14400);
	RTGC;
	RTHOOK(1);
	tr1 = *(EIF_REFERENCE *)(Current);
	tb1 = F759_7351(RTCW(tr1));
	if ((EIF_BOOLEAN) !tb1) {
		RTHOOK(2);
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
			RTHOOK(3);
			tb1 = '\0';
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
			if ((EIF_BOOLEAN)(ti4_1 == F1115_10512(Current))) {
				tb1 = F1115_10524(Current, *(EIF_REFERENCE *)(Current), ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '\\');
			}
			if (tb1) {
				RTHOOK(4);
				RTHOOK(5);
				RTLE;
				RTEE;
				return (EIF_INTEGER_32) F1115_10512(Current);
			} else {
				RTHOOK(6);
				tb1 = '\0';
				tr1 = *(EIF_REFERENCE *)(Current);
				ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
				if ((EIF_BOOLEAN) (ti4_1 >= ((EIF_INTEGER_32) 4L))) {
					tb2 = '\0';
					tr1 = *(EIF_REFERENCE *)(Current);
					tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R5979[Dtype(RTCW(tr1))-845])(tr1, ((EIF_INTEGER_32) 2L)));
					if ((EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) '\000')) {
						tr1 = *(EIF_REFERENCE *)(Current);
						tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R5979[Dtype(RTCW(tr1))-845])(tr1, ((EIF_INTEGER_32) 4L)));
						tb2 = (EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) '\000');
					}
					tb1 = tb2;
				}
				if (tb1) {
					RTHOOK(7);
					tr1 = *(EIF_REFERENCE *)(Current);
					tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R5979[Dtype(RTCW(tr1))-845])(tr1, ((EIF_INTEGER_32) 1L)));
					loc1 = eif_builtin_CHARACTER_8_as_lower__c1_c1(tc1);
					RTHOOK(8);
					tb1 = '\0';
					if ((EIF_BOOLEAN) ((EIF_BOOLEAN) (loc1 >= (EIF_CHARACTER_8) 'a') && (EIF_BOOLEAN) (loc1 <= (EIF_CHARACTER_8) 'z'))) {
						tr1 = *(EIF_REFERENCE *)(Current);
						tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R5979[Dtype(RTCW(tr1))-845])(tr1, ((EIF_INTEGER_32) 3L)));
						tb1 = (EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) ':');
					}
					if (tb1) {
						RTHOOK(9);
						tb1 = '\0';
						tr1 = *(EIF_REFERENCE *)(Current);
						ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
						if ((EIF_BOOLEAN) (ti4_1 >= (EIF_INTEGER_32) (((EIF_INTEGER_32) 3L) * F1115_10512(Current)))) {
							tb1 = F1115_10524(Current, *(EIF_REFERENCE *)(Current), ((EIF_INTEGER_32) 5L), (EIF_CHARACTER_8) '\\');
						}
						if (tb1) {
							RTHOOK(10);
							RTHOOK(11);
							RTLE;
							RTEE;
							return (EIF_INTEGER_32) ((EIF_INTEGER_32) 6L);
						} else {
							RTHOOK(12);
							RTHOOK(13);
							RTLE;
							RTEE;
							return (EIF_INTEGER_32) ((EIF_INTEGER_32) 4L);
						}
					} else {
						RTHOOK(14);
						tb1 = '\0';
						if ((EIF_BOOLEAN)(loc1 == (EIF_CHARACTER_8) '\\')) {
							tr1 = *(EIF_REFERENCE *)(Current);
							tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R5979[Dtype(RTCW(tr1))-845])(tr1, ((EIF_INTEGER_32) 3L)));
							tb1 = (EIF_BOOLEAN)(tc1 != (EIF_CHARACTER_8) '\\');
						}
						if (tb1) {
							RTHOOK(15);
							Result = F1115_10512(Current);
						} else {
							RTHOOK(16);
							tb1 = '\0';
							tb2 = '\0';
							tb3 = '\0';
							tr1 = *(EIF_REFERENCE *)(Current);
							ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
							if ((EIF_BOOLEAN) (ti4_1 >= ((EIF_INTEGER_32) 10L))) {
								tb3 = (EIF_BOOLEAN)(loc1 == (EIF_CHARACTER_8) '\\');
							}
							if (tb3) {
								tr1 = *(EIF_REFERENCE *)(Current);
								tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R5979[Dtype(RTCW(tr1))-845])(tr1, ((EIF_INTEGER_32) 3L)));
								tb2 = (EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) '\\');
							}
							if (tb2) {
								tr1 = *(EIF_REFERENCE *)(Current);
								tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R5979[Dtype(RTCW(tr1))-845])(tr1, ((EIF_INTEGER_32) 5L)));
								tb1 = (EIF_BOOLEAN)(tc1 != (EIF_CHARACTER_8) '\\');
							}
							if (tb1) {
								RTHOOK(17);
								loc2 = F1115_10520(Current, ((EIF_INTEGER_32) 7L));
								RTHOOK(18);
								tb1 = '\0';
								if ((EIF_BOOLEAN) (loc2 > ((EIF_INTEGER_32) 0L))) {
									tr1 = *(EIF_REFERENCE *)(Current);
									ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
									tb1 = (EIF_BOOLEAN) ((EIF_INTEGER_32) (loc2 + F1115_10512(Current)) <= ti4_1);
								}
								if (tb1) {
									RTHOOK(19);
									ti4_1 = F1115_10512(Current);
									ti4_1 = F1115_10520(Current, (EIF_INTEGER_32) (loc2 + ti4_1));
									loc2 = (EIF_INTEGER_32) ti4_1;
									RTHOOK(20);
									if ((EIF_BOOLEAN) (loc2 > ((EIF_INTEGER_32) 0L))) {
										RTHOOK(21);
										RTHOOK(22);
										RTLE;
										RTEE;
										return (EIF_INTEGER_32) (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L));
									} else {
										RTHOOK(23);
										tr1 = *(EIF_REFERENCE *)(Current);
										Result = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
									}
								}
							}
						}
					}
				}
			}
		} else {
			RTHOOK(24);
			tr1 = *(EIF_REFERENCE *)(Current);
			tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R5979[Dtype(RTCW(tr1))-845])(tr1, ((EIF_INTEGER_32) 1L)));
			if ((EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) '/')) {
				RTHOOK(25);
				RTHOOK(26);
				RTLE;
				RTEE;
				return (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
			}
		}
	}
	RTHOOK(30);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.end_position_of_last_directory_separator */
EIF_INTEGER_32 F1115_10519 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	EIF_CHARACTER_8 tc1;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTEAA("end_position_of_last_directory_separator", 1114, Current, 0, 0, 14401);
	RTGC;
	RTHOOK(1);
	tr1 = *(EIF_REFERENCE *)(Current);
	tb1 = F759_7351(RTCW(tr1));
	if ((EIF_BOOLEAN) !tb1) {
		RTHOOK(2);
		tr1 = *(EIF_REFERENCE *)(Current);
		Result = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
		ti4_1 = F1115_10512(Current);
		Result = (EIF_INTEGER_32) (EIF_INTEGER_32) ((EIF_INTEGER_32) (Result - ti4_1) + ((EIF_INTEGER_32) 1L));
		RTHOOK(3);
		if ((EIF_BOOLEAN) (Result >= ((EIF_INTEGER_32) 1L))) {
			for (;;) {
				RTHOOK(4);
				tb1 = '\01';
				if (!(EIF_BOOLEAN) (Result < ((EIF_INTEGER_32) 1L))) {
					tr1 = *(EIF_REFERENCE *)(Current);
					tc1 = F1115_10494(Current);
					tb1 = F1115_10524(Current, tr1, Result, tc1);
				}
				if (tb1) break;
				RTHOOK(5);
				Result -= F1115_10512(Current);
			}
		}
		RTHOOK(6);
		if ((EIF_BOOLEAN) (Result < ((EIF_INTEGER_32) 0L))) {
			RTHOOK(7);
			RTHOOK(8);
			RTLE;
			RTEE;
			return (EIF_INTEGER_32) ((EIF_INTEGER_32) 0L);
		} else {
			RTHOOK(9);
			ti4_1 = F1115_10512(Current);
			Result = (EIF_INTEGER_32) (EIF_INTEGER_32) ((EIF_INTEGER_32) (Result + ti4_1) - ((EIF_INTEGER_32) 1L));
		}
	}
	RTHOOK(13);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.next_directory_separator */
EIF_INTEGER_32 F1115_10520 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_CHARACTER_8 loc3 = (EIF_CHARACTER_8) 0;
	EIF_REFERENCE loc4 = (EIF_REFERENCE) 0;
	EIF_BOOLEAN tb1;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,loc4);
	RTLIU(2);
	
	RTEAA("next_directory_separator", 1114, Current, 4, 1, 14402);
	RTGC;
	RTHOOK(1);
	loc2 = F1115_10512(Current);
	RTHOOK(2);
	loc3 = F1115_10494(Current);
	RTHOOK(3);
	Result = (EIF_INTEGER_32) arg1;
	RTHOOK(4);
	loc4 = *(EIF_REFERENCE *)(Current);
	RTHOOK(5);
	loc1 = *(EIF_INTEGER_32 *)(RTCW(loc4)+ _LNGOFF_1_1_0_2_);
	for (;;) {
		RTHOOK(6);
		tb1 = '\01';
		if (!(EIF_BOOLEAN) ((EIF_BOOLEAN) (Result < ((EIF_INTEGER_32) 1L)) || (EIF_BOOLEAN) (Result > loc1))) {
			tb1 = F1115_10524(Current, loc4, Result, loc3);
		}
		if (tb1) break;
		RTHOOK(7);
		Result += loc2;
	}
	RTHOOK(8);
	if ((EIF_BOOLEAN) (Result > loc1)) {
		RTHOOK(9);
		RTHOOK(10);
		RTLE;
		RTEE;
		return (EIF_INTEGER_32) ((EIF_INTEGER_32) 0L);
	}
	RTHOOK(14);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.internal_append_into */
void F1115_10521 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2, EIF_CHARACTER_8 arg3)
{
	GTCX
	RTEX;
	struct eif_ex_71 sloc1;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) sloc1.data;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_CHARACTER_32 tw1;
	EIF_CHARACTER_32 tw2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_BOOLEAN tb4;
	RTLD;
	
	memset (&sloc1.overhead, 0, OVERHEAD + _OBJSIZ_0_0_0_0_0_0_0_0_);
	sloc1.overhead.ov_flags = EO_EXP | EO_STACK;
	RT_DFS(&sloc1.overhead, eif_new_type(78, 0x00).id);
	RTLI(4);
	RTLR(0,arg2);
	RTLR(1,arg1);
	RTLR(2,Current);
	RTLR(3,loc1);
	RTLIU(4);
	
	RTEAA("internal_append_into", 1114, Current, 1, 3, 14403);
	RTGC;
	RTHOOK(1);
	tb1 = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE)) R7509[Dtype(RTCW(arg2))-1094])(arg2);
	if ((EIF_BOOLEAN) !tb1) {
		RTHOOK(2);
		tb1 = '\0';
		tb2 = '\0';
		tb3 = '\0';
		if ((EIF_BOOLEAN)(arg3 != (EIF_CHARACTER_8) '\000')) {
			tb4 = F759_7351(RTCW(arg1));
			tb3 = (EIF_BOOLEAN) !tb4;
		}
		if (tb3) {
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(arg1)+ _LNGOFF_1_1_0_2_);
			ti4_2 = F1115_10512(Current);
			tb2 = (EIF_BOOLEAN) !F1115_10524(Current, arg1, (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 - ti4_2) + ((EIF_INTEGER_32) 1L)), arg3);
		}
		if (tb2) {
			tw1 = (FUNCTION_CAST(EIF_CHARACTER_32, (EIF_REFERENCE, EIF_INTEGER_32)) R7495[Dtype(RTCW(arg2))-1094])(arg2, ((EIF_INTEGER_32) 1L));
			tw2 = (EIF_CHARACTER_32) (EIF_CHARACTER_8) '/';
			tb1 = (EIF_BOOLEAN)(tw1 != tw2);
		}
		if (tb1) {
			RTHOOK(3);
			if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
				RTHOOK(4);
				tw1 = (FUNCTION_CAST(EIF_CHARACTER_32, (EIF_REFERENCE, EIF_INTEGER_32)) R7495[Dtype(RTCW(arg2))-1094])(arg2, ((EIF_INTEGER_32) 1L));
				tw2 = (EIF_CHARACTER_32) (EIF_CHARACTER_8) '\\';
				if ((EIF_BOOLEAN)(tw1 != tw2)) {
					RTHOOK(5);
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R7758[Dtype(RTCW(arg1))-1098])(arg1, arg3);
					RTHOOK(6);
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R7758[Dtype(RTCW(arg1))-1098])(arg1, (EIF_CHARACTER_8) '\000');
				}
			} else {
				RTHOOK(7);
				(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R7758[Dtype(RTCW(arg1))-1098])(arg1, arg3);
			}
		}
		RTHOOK(8);
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
			RTHOOK(9);
			F79_1118(RTCW(loc1), arg2, arg1);
		} else {
			RTHOOK(10);
			F79_1093(RTCW(loc1), arg2, arg1);
		}
	}
	RTHOOK(11);
	RTLE;
	RTEE;
}

/* {PATH}.internal_path_append_into */
void F1115_10522 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2, EIF_CHARACTER_8 arg3)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_BOOLEAN tb4;
	RTLD;
	
	RTLI(3);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,arg2);
	RTLIU(3);
	
	RTEAA("internal_path_append_into", 1114, Current, 0, 3, 14404);
	RTGC;
	RTHOOK(1);
	tb1 = '\0';
	tb2 = '\0';
	tb3 = '\0';
	if ((EIF_BOOLEAN)(arg3 != (EIF_CHARACTER_8) '\000')) {
		tb4 = F759_7351(RTCW(arg1));
		tb3 = (EIF_BOOLEAN) !tb4;
	}
	if (tb3) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(arg1)+ _LNGOFF_1_1_0_2_);
		ti4_2 = F1115_10512(Current);
		tb2 = (EIF_BOOLEAN) !F1115_10524(Current, arg1, (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 - ti4_2) + ((EIF_INTEGER_32) 1L)), arg3);
	}
	if (tb2) {
		tb1 = (EIF_BOOLEAN) !F1115_10524(Current, arg2, ((EIF_INTEGER_32) 1L), arg3);
	}
	if (tb1) {
		RTHOOK(2);
		(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R7758[Dtype(RTCW(arg1))-1098])(arg1, arg3);
		RTHOOK(3);
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
			RTHOOK(4);
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R7758[Dtype(RTCW(arg1))-1098])(arg1, (EIF_CHARACTER_8) '\000');
		}
	}
	RTHOOK(5);
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R7754[Dtype(RTCW(arg1))-1098])(arg1, arg2);
	RTHOOK(6);
	RTLE;
	RTEE;
}

/* {PATH}.internal_path_append_substring_into */
void F1115_10523 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2, EIF_INTEGER_32 arg3, EIF_INTEGER_32 arg4, EIF_CHARACTER_8 arg5)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_BOOLEAN tb4;
	RTLD;
	
	RTLI(3);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,arg2);
	RTLIU(3);
	
	RTEAA("internal_path_append_substring_into", 1114, Current, 0, 5, 14405);
	RTGC;
	RTHOOK(1);
	tb1 = '\0';
	tb2 = '\0';
	tb3 = '\0';
	if ((EIF_BOOLEAN)(arg5 != (EIF_CHARACTER_8) '\000')) {
		tb4 = F759_7351(RTCW(arg1));
		tb3 = (EIF_BOOLEAN) !tb4;
	}
	if (tb3) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(arg1)+ _LNGOFF_1_1_0_2_);
		ti4_2 = F1115_10512(Current);
		tb2 = (EIF_BOOLEAN) !F1115_10524(Current, arg1, (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 - ti4_2) + ((EIF_INTEGER_32) 1L)), arg5);
	}
	if (tb2) {
		tb1 = (EIF_BOOLEAN) !F1115_10524(Current, arg2, arg3, arg5);
	}
	if (tb1) {
		RTHOOK(2);
		(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R7758[Dtype(RTCW(arg1))-1098])(arg1, arg5);
		RTHOOK(3);
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
			RTHOOK(4);
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R7758[Dtype(RTCW(arg1))-1098])(arg1, (EIF_CHARACTER_8) '\000');
		}
	}
	RTHOOK(5);
	F1099_9940(RTCW(arg1), arg2, arg3, arg4);
	RTHOOK(6);
	RTLE;
	RTEE;
}

/* {PATH}.is_character */
EIF_BOOLEAN F1115_10524 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_INTEGER_32 arg2, EIF_CHARACTER_8 arg3)
{
	GTCX
	RTEX;
	EIF_CHARACTER_8 tc1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLIU(2);
	
	RTEAA("is_character", 1114, Current, 0, 3, 14406);
	RTGC;
	RTHOOK(1);
	if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
		RTHOOK(2);
		Result = '\0';
		tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R5979[Dtype(RTCW(arg1))-845])(arg1, arg2));
		if ((EIF_BOOLEAN)(tc1 == arg3)) {
			tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R5979[Dtype(RTCW(arg1))-845])(arg1, (EIF_INTEGER_32) (arg2 + ((EIF_INTEGER_32) 1L))));
			Result = (EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) '\000');
		}
	} else {
		RTHOOK(3);
		tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R5979[Dtype(RTCW(arg1))-845])(arg1, arg2));
		Result = (EIF_BOOLEAN) (EIF_BOOLEAN)(tc1 == arg3);
	}
	RTHOOK(5);
	RTLE;
	RTEE;
	return Result;
}

/* {PATH}.c_same_files */
EIF_BOOLEAN F1115_10527 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2)
{
	GTCX
	RTEX;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("c_same_files", 1114, Current, 0, 2, 14409);
	Result = EIF_TEST(inline_F1115_10527 ((EIF_POINTER) arg1, (EIF_POINTER) arg2));
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

void EIF_Minit513 (void)
{
	GTCX
}


#ifdef __cplusplus
}
#endif
