/*
 * Code for class PROCESS_UNIX_OS
 */

#include "eif_eiffel.h"
#include "../E1/estructure.h"
#include "../E1/eoffsets.h"

#include "pr183.h"
#include <fcntl.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include "eif_process.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifndef INLINE_F218_2800
static void inline_F218_2800 (EIF_INTEGER_32 arg1, EIF_INTEGER_32 arg2)
{
	{
  int rc;
  rc = dup2(arg1, arg2);
  if (rc < 0) {
	    eraise(Strerror(errno), EN_SYS);
  }
}
	;
}
#define INLINE_F218_2800
#endif
#ifndef INLINE_F218_2801
static void inline_F218_2801 (EIF_INTEGER_32 arg1)
{
	{
	 int rc;
	  rc = close(arg1);
	  if (rc != 0) {
	    eraise(Strerror(errno), EN_SYS);
	  }
}
	;
}
#define INLINE_F218_2801
#endif
#ifndef INLINE_F218_2804
static void inline_F218_2804 (void)
{
	{
	setpgid (0, 0);
}
	;
}
#define INLINE_F218_2804
#endif
#ifndef INLINE_F218_2818
static void inline_F218_2818 (EIF_POINTER arg1, EIF_INTEGER_32 arg2, EIF_POINTER arg3)
{
	{
				  char ** arguments;
 				  arguments = (char **) arg1;
				  arguments[arg2] = (char *) arg3;
				}
	;
}
#define INLINE_F218_2818
#endif
#ifndef INLINE_F218_2816
static void inline_F218_2816 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4)
{
	{
				  int max_descriptors;
				  int k, rc;
  				  if (arg4 == EIF_TRUE) {
				    max_descriptors = getdtablesize();
					for (k = 3; k < max_descriptors; k++) {
					    rc = fcntl(k, F_SETFD, 1);
					    if (rc == -1 && errno != EBADF) {
						      eraise(Strerror(errno), EN_SYS);
					    }
			  	    }
				  }
				  if (arg3 == NULL) {
				    (void) execv((char *) arg1, (char **) arg2);
				  } else {
				    (void) execve((char *) arg1, (char **) arg2, (char **) arg3);
				  }
				  _exit(127);
				}
	;
}
#define INLINE_F218_2816
#endif
#ifndef INLINE_F218_2815
static void inline_F218_2815 (EIF_INTEGER_32* arg1)
{
	{
  pid_t pid;
  pid = fork();
  *arg1 = (EIF_INTEGER)pid;
}
	;
}
#define INLINE_F218_2815
#endif
#ifndef INLINE_F218_2811
static void inline_F218_2811 (EIF_POINTER arg1, EIF_POINTER* arg2)
{
	{
	  char *result;
	  result = (char *) malloc((unsigned) (strlen((char *) arg1) + 1));
	  if (result == NULL) {
    	enomem();
	  }
	  strcpy(result, arg1);
	  *arg2 = result;
	}
	;
}
#define INLINE_F218_2811
#endif
#ifndef INLINE_F218_2817
static void inline_F218_2817 (EIF_INTEGER_32 arg1, EIF_POINTER* arg2)
{
	{
	EIF_POINTER result;
	result = (EIF_POINTER) malloc((size_t) (arg1 * sizeof(char *)));
	if (result == NULL) {
		enomem();
	}
	*arg2 = result;
}
	;
}
#define INLINE_F218_2817
#endif
#ifndef INLINE_F218_2812
static void inline_F218_2812 (EIF_POINTER arg1, EIF_POINTER arg2)
{
	{
  int rc;
  int fd[2];
  EIF_INTEGER * read_ptr;
  EIF_INTEGER * write_ptr;
  rc = pipe(fd);
  if (rc != 0) {
    eraise(Strerror(errno), EN_SYS);
  }
  read_ptr = (EIF_INTEGER *) arg1;
  write_ptr = (EIF_INTEGER *) arg2;
  *read_ptr = fd[0];
  *write_ptr = fd[1];
}
	;
}
#define INLINE_F218_2812
#endif
#ifndef INLINE_F218_2814
static void inline_F218_2814 (EIF_INTEGER_32 arg1, EIF_BOOLEAN arg2, EIF_BOOLEAN* arg3, EIF_INTEGER_32* arg4, EIF_BOOLEAN* arg5)
{
	{
  pid_t rc;
  int status;
  
  rc = waitpid((pid_t) arg1, &status, (arg2 ? 0 : WNOHANG) | WUNTRACED);
  *(EIF_BOOLEAN *) arg5 = (rc != -1);
  if (rc != -1) {				    
	  if (rc == 0) { /* No process has status to report yet */
	    *(EIF_BOOLEAN *) arg3 = EIF_FALSE;
	  } else { /* Process reported status */
	    *(EIF_BOOLEAN *) arg3 = EIF_TRUE;
	  }
	  *(EIF_INTEGER *) arg4 = (EIF_INTEGER) status;
  }
}
	;
}
#define INLINE_F218_2814
#endif
#ifndef INLINE_F218_2819
static void inline_F218_2819 (EIF_INTEGER_32 arg1)
{
	{
	pid_t pgid = getpgid (arg1);
	tcsetpgrp (1, pgid);
	tcsetpgrp (2, pgid);
}
	;
}
#define INLINE_F218_2819
#endif

#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
extern "C" {
#endif

/* {PROCESS_UNIX_OS}.duplicate_file_descriptor */
void F218_2800 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1, EIF_INTEGER_32 arg2)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("duplicate_file_descriptor", 217, Current, 0, 2, 2953);
	inline_F218_2800 ((EIF_INTEGER_32) arg1, (EIF_INTEGER_32) arg2);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.close_file_descriptor */
void F218_2801 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("close_file_descriptor", 217, Current, 0, 1, 2954);
	inline_F218_2801 ((EIF_INTEGER_32) arg1);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.fork_process */
EIF_INTEGER_32 F218_2803 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	
	
	RTEAA("fork_process", 217, Current, 0, 0, 2956);
	RTHOOK(1);
	RTHOOK(2);
	RTEE;
	return (EIF_INTEGER_32) F218_2808(Current);
}

/* {PROCESS_UNIX_OS}.new_process_group */
void F218_2804 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("new_process_group", 217, Current, 0, 0, 2957);
	inline_F218_2804 ();
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.exec_process */
void F218_2805 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2, EIF_BOOLEAN arg3, EIF_POINTER arg4)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc3 = (EIF_INTEGER_32) 0;
	EIF_POINTER loc4 = (EIF_POINTER) 0;
	EIF_REFERENCE loc5 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_POINTER tp2;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(5);
	RTLR(0,arg2);
	RTLR(1,Current);
	RTLR(2,loc5);
	RTLR(3,tr1);
	RTLR(4,arg1);
	RTLIU(5);
	
	RTEAA("exec_process", 217, Current, 5, 4, 2958);
	RTGC;
	RTHOOK(1);
	loc2 = F879_6904(RTCW(arg2));
	RTHOOK(2);
	loc3 = *(EIF_INTEGER_32 *)(RTCW(arg2)+ _LNGOFF_1_1_0_1_);
	RTHOOK(3);
	loc4 = F218_2810(Current, (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L)));
	RTHOOK(4);
	loc5 = RTLNS(eif_new_type(431, 0x01).id, 431, _OBJSIZ_1_0_0_1_0_0_0_0_);
	F432_4983(RTCW(loc5), ((EIF_INTEGER_32) 0L));
	RTHOOK(5);
	loc1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
	for (;;) {
		RTHOOK(6);
		if ((EIF_BOOLEAN) (loc1 > loc2)) break;
		RTHOOK(7);
		tr1 = F879_6897(RTCW(arg2), (EIF_INTEGER_32) ((EIF_INTEGER_32) (loc3 + loc1) - ((EIF_INTEGER_32) 1L)));
		F432_4997(RTCW(loc5), tr1);
		RTHOOK(8);
		tp1 = F432_4989(RTCW(loc5));
		tp1 = F218_2809(Current, tp1);
		inline_F218_2818(loc4, (EIF_INTEGER_32) (loc1 - ((EIF_INTEGER_32) 1L)), tp1);
		RTHOOK(9);
		loc1++;
	}
	RTHOOK(10);
	{
		/* INLINED CODE (ANY.default_pointer) */
		tp1 = (EIF_POINTER)  0;
		/* END INLINED CODE */
	}
	tp2 = tp1;
	inline_F218_2818(loc4, loc2, tp2);
	RTHOOK(11);
	loc5 = RTLNS(eif_new_type(431, 0x01).id, 431, _OBJSIZ_1_0_0_1_0_0_0_0_);
	F432_4982(RTCW(loc5), arg1);
	RTHOOK(12);
	tp1 = F432_4989(RTCW(loc5));
	inline_F218_2816(tp1, loc4, arg4, arg3);
	RTHOOK(13);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.unix_fork_process */
EIF_INTEGER_32 F218_2808 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	
	
	RTEAA("unix_fork_process", 217, Current, 0, 0, 2961);
	RTHOOK(1);
	inline_F218_2815((EIF_INTEGER_32 *) &(Result));
	RTHOOK(2);
	RTEE;
	return Result;
}

/* {PROCESS_UNIX_OS}.str_dup */
EIF_POINTER F218_2809 (EIF_REFERENCE Current, EIF_POINTER arg1)
{
	GTCX
	RTEX;
	EIF_POINTER Result = ((EIF_POINTER) 0);
	
	
	
	RTEAA("str_dup", 217, Current, 0, 1, 2962);
	RTHOOK(1);
	inline_F218_2811(arg1, (EIF_POINTER *) &(Result));
	RTHOOK(2);
	RTEE;
	return Result;
}

/* {PROCESS_UNIX_OS}.unix_allocate_arg_memory */
EIF_POINTER F218_2810 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	RTEX;
	EIF_POINTER Result = ((EIF_POINTER) 0);
	
	
	
	RTEAA("unix_allocate_arg_memory", 217, Current, 0, 1, 2963);
	RTHOOK(1);
	inline_F218_2817(arg1, (EIF_POINTER *) &(Result));
	RTHOOK(2);
	RTEE;
	return Result;
}

/* {PROCESS_UNIX_OS}.c_str_dup */
void F218_2811 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER* arg2)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("c_str_dup", 217, Current, 0, 2, 2964);
	inline_F218_2811 ((EIF_POINTER) arg1, (EIF_POINTER*) arg2);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.unix_pipe */
void F218_2812 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("unix_pipe", 217, Current, 0, 2, 2965);
	inline_F218_2812 ((EIF_POINTER) arg1, (EIF_POINTER) arg2);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.unix_waitpid */
void F218_2814 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1, EIF_BOOLEAN arg2, EIF_BOOLEAN* arg3, EIF_INTEGER_32* arg4, EIF_BOOLEAN* arg5)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("unix_waitpid", 217, Current, 0, 5, 2967);
	EIF_ENTER_C;
	inline_F218_2814 ((EIF_INTEGER_32) arg1, (EIF_BOOLEAN) arg2, (EIF_BOOLEAN*) arg3, (EIF_INTEGER_32*) arg4, (EIF_BOOLEAN*) arg5);
	EIF_EXIT_C;
	RTGC;
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.c_unix_fork_process */
void F218_2815 (EIF_REFERENCE Current, EIF_INTEGER_32* arg1)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("c_unix_fork_process", 217, Current, 0, 1, 2968);
	inline_F218_2815 ((EIF_INTEGER_32*) arg1);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.unix_exec_process */
void F218_2816 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("unix_exec_process", 217, Current, 0, 4, 2969);
	inline_F218_2816 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_POINTER) arg3, (EIF_BOOLEAN) arg4);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.c_unix_allocate_arg_memory */
void F218_2817 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1, EIF_POINTER* arg2)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("c_unix_allocate_arg_memory", 217, Current, 0, 2, 2970);
	inline_F218_2817 ((EIF_INTEGER_32) arg1, (EIF_POINTER*) arg2);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.unix_set_arg_value */
void F218_2818 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_INTEGER_32 arg2, EIF_POINTER arg3)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("unix_set_arg_value", 217, Current, 0, 3, 2971);
	inline_F218_2818 ((EIF_POINTER) arg1, (EIF_INTEGER_32) arg2, (EIF_POINTER) arg3);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {PROCESS_UNIX_OS}.attach_terminals */
void F218_2819 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("attach_terminals", 217, Current, 0, 1, 2972);
	inline_F218_2819 ((EIF_INTEGER_32) arg1);
	RTHOOK(1);
	RTLE;
	RTEE;
}

void EIF_Minit183 (void)
{
	GTCX
}


#ifdef __cplusplus
}
#endif
