note
	description: "Shared class for setting/retrieving ISE_PLATFORM"
	legal: "See notice at end of class."
	status: "See notice at end of class."
	date: "$Date: 2012-12-20 17:10:02 -0800 (Thu, 20 Dec 2012) $"
	revision: "$Revision: 96472 $"

class
	KG_PLATFORM

inherit
	EIFFEL_LAYOUT

feature -- Access

	platform: STRING
			-- ISE_PLATFORM environment variable value
		do
			if is_eiffel_layout_defined and then not eiffel_layout.eiffel_platform.is_empty then
				Result := eiffel_layout.eiffel_platform
			else
				if attached platform_cell.item as l_platform and then l_platform.is_valid_as_string_8 then
					create Result.make (l_platform.count)
					Result.append_string_general (l_platform)
				else
					Result := ""
					check False end
				end
			end
		ensure
			platform_not_void: Result /= Void
			platform_not_empty: not Result.is_empty
		end

	platform_cell: CELL [READABLE_STRING_GENERAL]
			-- User set value for ISE_PLATFORM
		once
			create Result.put ("")
		ensure
			platform_cell_not_void: Result /= Void
		end

invariant
	platform_cell_not_void_string: platform_cell.item /= Void
	platform_cell_not_empty_string: not platform_cell.item.is_empty

note
	copyright:	"Copyright (c) 1984-2006, Eiffel Software and others"
	license:	"Eiffel Forum License v2 (see http://www.eiffel.com/licensing/forum.txt)"
	source: "[
			 Eiffel Software
			 356 Storke Road, Goleta, CA 93117 USA
			 Telephone 805-685-1006, Fax 805-685-6869
			 Website http://www.eiffel.com
			 Customer support http://support.eiffel.com
		]"




end
