note

	description:

		"ECF adapted class library lists"

	library: "Gobo Eiffel Tools Library"
	copyright: "Copyright (c) 2008, Eric Bezault and others"
	license: "MIT License"
	date: "$Date: 2016-05-06 12:15:38 -0700 (Fri, 06 May 2016) $"
	revision: "$Revision: 98678 $"

class ET_ECF_ADAPTED_LIBRARIES

inherit

	ET_ADAPTED_LIBRARIES
		redefine
			library,
			do_adapted,
			do_adapted_if
		end

create

	make, make_empty

feature -- Access

	library (i: INTEGER): ET_ECF_ADAPTED_LIBRARY
			-- `i'-th library
		do
			Result := libraries.item (i)
		end

feature -- Iteration

	do_adapted (an_action: PROCEDURE [ANY, TUPLE [ET_ADAPTED_LIBRARY]])
			-- Apply `an_action' to every library, from first to last.
			-- (Semantics not guaranteed if `an_action' changes the list.)
		local
			i, nb: INTEGER
		do
			nb := libraries.count
			from i := 1 until i > nb loop
				an_action.call ([libraries.item (i)])
				i := i + 1
			end
		end

	do_adapted_if (an_action: PROCEDURE [ANY, TUPLE [ET_ADAPTED_LIBRARY]]; a_test: FUNCTION [ANY, TUPLE [ET_ADAPTED_LIBRARY], BOOLEAN])
			-- Apply `an_action' to every library which satisfies `a_test', from first to last.
			-- (Semantics not guaranteed if `an_action' changes the list.)
		local
			i, nb: INTEGER
			l_library: ET_ECF_ADAPTED_LIBRARY
		do
			nb := libraries.count
			from i := 1 until i > nb loop
				l_library := libraries.item (i)
				if a_test.item ([l_library]) then
					an_action.call ([l_library])
				end
				i := i + 1
			end
		end

end
