note
	description: "Summary description for {}."
	author: ""
	date: "$Date: 2015-06-10 09:48:30 -0700 (Wed, 10 Jun 2015) $"
	revision: "$Revision: 97452 $"

class
	TEST_EXECUTION

inherit
	TEST_EXECUTION_I

create
	make

feature -- Helper

	server_log_path: STRING
		local
			fn: FILE_NAME
		once
			create fn.make_from_string ("server_test.log")
			Result := fn.string
		end

	server_log (m: STRING_8)
		local
			f: RAW_FILE
		do
			create f.make (server_log_path)
			f.open_append
			f.put_string (m)
			f.put_character ('%N')
			f.close
		end

	base_url: detachable STRING

	test_url (a_query_url: READABLE_STRING_8): READABLE_STRING_8
		local
			b: like base_url
		do
			b := base_url
			if b = Void then
				b := ""
			end
			Result := "/" + b + a_query_url
		end

end

