note
	description: "Objects that allow access to the operating system clipboard. Cocoa implementation"
	author: "Daniel Furrer."
	date: "$Date: 2013-05-20 16:15:17 -0700 (Mon, 20 May 2013) $"
	revision: "$Revision: 92557 $"

class
	EV_CLIPBOARD_IMP

inherit
	EV_CLIPBOARD_I

create
	make

feature {NONE}-- Initialization

	old_make (an_interface: like interface)
			-- Create `Current' with interface `an_interface'.
		do
			assign_interface (an_interface)
		end

	make
			-- initialize `Current'.
		do
			set_is_initialized (True)
		end

feature -- Access

	has_text: BOOLEAN
			-- Does the clipboard currently contain text?
		do
		end

	text: STRING_32
			-- `Result' is current clipboard content.
		do
			create Result.make_empty
		end

feature -- Status Setting

	set_text (a_text: READABLE_STRING_GENERAL)
			-- Assign `a_text' to clipboard.
		do
		end

feature {EV_ANY_I}

	destroy
			-- Destroy `Current'
		do
		end

end -- class EV_CLIPBOARD_IMP
