note
	description: "This error indicates that some operation didn't meet the ACID requirements for transactions and therefore it has been aborted"
	author: "Roman Schmocker"
	date: "$Date: 2013-09-27 15:40:01 -0700 (Fri, 27 Sep 2013) $"
	revision: "$Revision: 93025 $"

class
	PS_TRANSACTION_ABORTED_ERROR

inherit
	PS_OPERATION_ERROR
		redefine
			tag, accept, default_create
		end

feature -- Access

	tag: IMMUTABLE_STRING_32
			-- A short message describing what the current error is
		once
			create Result.make_from_string_8 ("Transaction aborted")
		end

feature {PS_ERROR_VISITOR} -- Visitor pattern

	accept (a_visitor: PS_ERROR_VISITOR)
			-- `accept' function of the visitor pattern
		do
			a_visitor.visit_transaction_aborted_error (Current)
		end

feature {NONE} -- Initialization

	default_create
			-- Create a new instance of this error
		do
			backend_error_code := -1
			set_description ("The current transaction has been aborted.")
		end
end
