note
	description: "[
		An SQLite database source.
	]"
	legal: "See notice at end of class."
	status: "See notice at end of class."
	date: "$Date: 2013-11-07 12:09:47 -0800 (Thu, 07 Nov 2013) $"
	revision: "$Revision: 93250 $"

deferred class
	SQLITE_SOURCE

feature -- Access

	locator: IMMUTABLE_STRING_8
			-- Locator string for the SQLite database source.
			--| For file source, `locator' is UTF-8 encoded.
		deferred
		ensure
			result_attached: attached Result
		end

feature -- Status report

	exists: BOOLEAN
			-- Indicates if the source exists, where ever it is located.
		deferred
		end

	is_special: BOOLEAN
			-- Indicates if the database source is special source.
		local
			l_locator: like locator
		do
			l_locator := locator
			Result := l_locator.item (1) = ':' and then l_locator.item (l_locator.count) = ':'
		end

;note
	copyright: "Copyright (c) 1984-2013, Eiffel Software"
	license: "GPL version 2 (see http://www.eiffel.com/licensing/gpl.txt)"
	licensing_options: "http://www.eiffel.com/licensing"
	copying: "[
			This file is part of Eiffel Software's Eiffel Development Environment.
			
			Eiffel Software's Eiffel Development Environment is free
			software; you can redistribute it and/or modify it under
			the terms of the GNU General Public License as published
			by the Free Software Foundation, version 2 of the License
			(available at the URL listed under "license" above).
			
			Eiffel Software's Eiffel Development Environment is
			distributed in the hope that it will be useful, but
			WITHOUT ANY WARRANTY; without even the implied warranty
			of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
			See the GNU General Public License for more details.
			
			You should have received a copy of the GNU General Public
			License along with Eiffel Software's Eiffel Development
			Environment; if not, write to the Free Software Foundation,
			Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
		]"
	source: "[
			Eiffel Software
			5949 Hollister Ave., Goleta, CA 93117 USA
			Telephone 805-685-1006, Fax 805-685-6869
			Website http://www.eiffel.com
			Customer support http://support.eiffel.com
		]"

end
