/*
 * Code for class PROCESS_UNIX_OS
 */

#include "eif_eiffel.h"
#include "../E1/estructure.h"
#include "../E1/eoffsets.h"

#include "pr195.h"
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <fcntl.h>
#include "eif_process.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifndef INLINE_F233_3410
static void inline_F233_3410 (EIF_INTEGER_32 arg1, EIF_INTEGER_32 arg2)
{
	{
  int rc;
  rc = dup2(arg1, arg2);
  if (rc < 0) {
	    eraise(Strerror(errno), EN_SYS);
  }
}
	;
}
#define INLINE_F233_3410
#endif
#ifndef INLINE_F233_3411
static void inline_F233_3411 (EIF_INTEGER_32 arg1)
{
	{
	 int rc;
	  rc = close(arg1);
	  if (rc != 0) {
	    eraise(Strerror(errno), EN_SYS);
	  }
}
	;
}
#define INLINE_F233_3411
#endif
#ifndef INLINE_F233_3414
static void inline_F233_3414 (void)
{
	{
	setpgid (0, 0);
}
	;
}
#define INLINE_F233_3414
#endif
#ifndef INLINE_F233_3428
static void inline_F233_3428 (EIF_POINTER arg1, EIF_INTEGER_32 arg2, EIF_POINTER arg3)
{
	{
				  char ** arguments;
 				  arguments = (char **) arg1;
				  arguments[arg2] = (char *) arg3;
				}
	;
}
#define INLINE_F233_3428
#endif
#ifndef INLINE_F233_3426
static void inline_F233_3426 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4)
{
	{
				  int max_descriptors;
				  int k, rc;
  				  if (arg4 == EIF_TRUE) {
				    max_descriptors = getdtablesize();
					for (k = 3; k < max_descriptors; k++) {
					    rc = fcntl(k, F_SETFD, 1);
					    if (rc == -1 && errno != EBADF) {
						      eraise(Strerror(errno), EN_SYS);
					    }
			  	    }
				  }
				  if (arg3 == NULL) {
				    (void) execv((char *) arg1, (char **) arg2);
				  } else {
				    (void) execve((char *) arg1, (char **) arg2, (char **) arg3);
				  }
				  _exit(127);
				}
	;
}
#define INLINE_F233_3426
#endif
#ifndef INLINE_F233_3425
static void inline_F233_3425 (EIF_INTEGER_32* arg1)
{
	{
  pid_t pid;
  pid = fork();
  *arg1 = (EIF_INTEGER)pid;
}
	;
}
#define INLINE_F233_3425
#endif
#ifndef INLINE_F233_3421
static void inline_F233_3421 (EIF_POINTER arg1, EIF_POINTER* arg2)
{
	{
	  char *result;
	  result = (char *) malloc((unsigned) (strlen((char *) arg1) + 1));
	  if (result == NULL) {
    	enomem();
	  }
	  strcpy(result, arg1);
	  *arg2 = result;
	}
	;
}
#define INLINE_F233_3421
#endif
#ifndef INLINE_F233_3427
static void inline_F233_3427 (EIF_INTEGER_32 arg1, EIF_POINTER* arg2)
{
	{
	EIF_POINTER result;
	result = (EIF_POINTER) malloc((size_t) (arg1 * sizeof(char *)));
	if (result == NULL) {
		enomem();
	}
	*arg2 = result;
}
	;
}
#define INLINE_F233_3427
#endif
#ifndef INLINE_F233_3422
static void inline_F233_3422 (EIF_POINTER arg1, EIF_POINTER arg2)
{
	{
  int rc;
  int fd[2];
  EIF_INTEGER * read_ptr;
  EIF_INTEGER * write_ptr;
  rc = pipe(fd);
  if (rc != 0) {
    eraise(Strerror(errno), EN_SYS);
  }
  read_ptr = (EIF_INTEGER *) arg1;
  write_ptr = (EIF_INTEGER *) arg2;
  *read_ptr = fd[0];
  *write_ptr = fd[1];
}
	;
}
#define INLINE_F233_3422
#endif
#ifndef INLINE_F233_3424
static void inline_F233_3424 (EIF_INTEGER_32 arg1, EIF_BOOLEAN arg2, EIF_BOOLEAN* arg3, EIF_INTEGER_32* arg4, EIF_BOOLEAN* arg5)
{
	{
  pid_t rc;
  int status;
  
  rc = waitpid((pid_t) arg1, &status, (arg2 ? 0 : WNOHANG) | WUNTRACED);
  *(EIF_BOOLEAN *) arg5 = (rc != -1);
  if (rc != -1) {				    
	  if (rc == 0) { /* No process has status to report yet */
	    *(EIF_BOOLEAN *) arg3 = EIF_FALSE;
	  } else { /* Process reported status */
	    *(EIF_BOOLEAN *) arg3 = EIF_TRUE;
	  }
	  *(EIF_INTEGER *) arg4 = (EIF_INTEGER) status;
  }
}
	;
}
#define INLINE_F233_3424
#endif
#ifndef INLINE_F233_3429
static void inline_F233_3429 (EIF_INTEGER_32 arg1)
{
	{
	pid_t pgid = getpgid (arg1);
	tcsetpgrp (1, pgid);
	tcsetpgrp (2, pgid);
}
	;
}
#define INLINE_F233_3429
#endif

#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
extern "C" {
#endif

/* {PROCESS_UNIX_OS}.duplicate_file_descriptor */
void F233_3410 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1, EIF_INTEGER_32 arg2)
{
	GTCX
	
	
	inline_F233_3410 ((EIF_INTEGER_32) arg1, (EIF_INTEGER_32) arg2);
}

/* {PROCESS_UNIX_OS}.close_file_descriptor */
void F233_3411 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	
	
	inline_F233_3411 ((EIF_INTEGER_32) arg1);
}

/* {PROCESS_UNIX_OS}.fork_process */
EIF_INTEGER_32 F233_3413 (EIF_REFERENCE Current)
{
	GTCX
	
	
	return (EIF_INTEGER_32) F233_3418(Current);
}

/* {PROCESS_UNIX_OS}.new_process_group */
void F233_3414 (EIF_REFERENCE Current)
{
	GTCX
	
	
	inline_F233_3414 ();
}

/* {PROCESS_UNIX_OS}.exec_process */
void F233_3415 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2, EIF_BOOLEAN arg3, EIF_POINTER arg4)
{
	GTCX
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc3 = (EIF_INTEGER_32) 0;
	EIF_POINTER loc4 = (EIF_POINTER) 0;
	EIF_POINTER loc5 = (EIF_POINTER) 0;
	EIF_POINTER loc6 = (EIF_POINTER) 0;
	EIF_REFERENCE loc7 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(5);
	RTLR(0,arg2);
	RTLR(1,Current);
	RTLR(2,loc7);
	RTLR(3,tr1);
	RTLR(4,arg1);
	RTLIU(5);
	
	RTGC;
	loc2 = F903_7753(RTCW(arg2));
	loc3 = *(EIF_INTEGER_32 *)(RTCW(arg2)+ _LNGOFF_1_1_0_1_);
	loc4 = F233_3420(Current, (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L)));
	tr1 = RTLNS(eif_new_type(647, 0x01).id, 647, _OBJSIZ_1_0_0_1_0_0_0_0_);
	F648_5614(RTCW(tr1), ((EIF_INTEGER_32) 0L));
	loc7 = (EIF_REFERENCE) tr1;
	loc1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
	for (;;) {
		if ((EIF_BOOLEAN) (loc1 > loc2)) break;
		tr1 = F903_7746(RTCW(arg2), (EIF_INTEGER_32) ((EIF_INTEGER_32) (loc3 + loc1) - ((EIF_INTEGER_32) 1L)));
		F648_5628(RTCW(loc7), tr1);
		tp1 = F648_5620(RTCW(loc7));
		loc5 = F233_3419(Current, tp1);
		inline_F233_3428(loc4, (EIF_INTEGER_32) (loc1 - ((EIF_INTEGER_32) 1L)), loc5);
		loc1++;
	}
	inline_F233_3428(loc4, loc2, loc6);
	tr1 = RTLNS(eif_new_type(647, 0x01).id, 647, _OBJSIZ_1_0_0_1_0_0_0_0_);
	F648_5613(RTCW(tr1), arg1);
	loc7 = (EIF_REFERENCE) tr1;
	tp1 = F648_5620(RTCW(loc7));
	inline_F233_3426(tp1, loc4, arg4, arg3);
	RTLE;
}

/* {PROCESS_UNIX_OS}.unix_fork_process */
EIF_INTEGER_32 F233_3418 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	
	
	inline_F233_3425((EIF_INTEGER_32 *) &(Result));
	return Result;
}

/* {PROCESS_UNIX_OS}.str_dup */
EIF_POINTER F233_3419 (EIF_REFERENCE Current, EIF_POINTER arg1)
{
	GTCX
	EIF_POINTER Result = ((EIF_POINTER) 0);
	
	
	
	inline_F233_3421(arg1, (EIF_POINTER *) &(Result));
	return Result;
}

/* {PROCESS_UNIX_OS}.unix_allocate_arg_memory */
EIF_POINTER F233_3420 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	EIF_POINTER Result = ((EIF_POINTER) 0);
	
	
	
	inline_F233_3427(arg1, (EIF_POINTER *) &(Result));
	return Result;
}

/* {PROCESS_UNIX_OS}.c_str_dup */
void F233_3421 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER* arg2)
{
	GTCX
	
	
	inline_F233_3421 ((EIF_POINTER) arg1, (EIF_POINTER*) arg2);
}

/* {PROCESS_UNIX_OS}.unix_pipe */
void F233_3422 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2)
{
	GTCX
	
	
	inline_F233_3422 ((EIF_POINTER) arg1, (EIF_POINTER) arg2);
}

/* {PROCESS_UNIX_OS}.unix_waitpid */
void F233_3424 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1, EIF_BOOLEAN arg2, EIF_BOOLEAN* arg3, EIF_INTEGER_32* arg4, EIF_BOOLEAN* arg5)
{
	GTCX
	
	
	EIF_ENTER_C;
	inline_F233_3424 ((EIF_INTEGER_32) arg1, (EIF_BOOLEAN) arg2, (EIF_BOOLEAN*) arg3, (EIF_INTEGER_32*) arg4, (EIF_BOOLEAN*) arg5);
	EIF_EXIT_C;
	RTGC;
}

/* {PROCESS_UNIX_OS}.c_unix_fork_process */
void F233_3425 (EIF_REFERENCE Current, EIF_INTEGER_32* arg1)
{
	GTCX
	
	
	inline_F233_3425 ((EIF_INTEGER_32*) arg1);
}

/* {PROCESS_UNIX_OS}.unix_exec_process */
void F233_3426 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4)
{
	GTCX
	
	
	inline_F233_3426 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_POINTER) arg3, (EIF_BOOLEAN) arg4);
}

/* {PROCESS_UNIX_OS}.c_unix_allocate_arg_memory */
void F233_3427 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1, EIF_POINTER* arg2)
{
	GTCX
	
	
	inline_F233_3427 ((EIF_INTEGER_32) arg1, (EIF_POINTER*) arg2);
}

/* {PROCESS_UNIX_OS}.unix_set_arg_value */
void F233_3428 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_INTEGER_32 arg2, EIF_POINTER arg3)
{
	GTCX
	
	
	inline_F233_3428 ((EIF_POINTER) arg1, (EIF_INTEGER_32) arg2, (EIF_POINTER) arg3);
}

/* {PROCESS_UNIX_OS}.attach_terminals */
void F233_3429 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	
	
	inline_F233_3429 ((EIF_INTEGER_32) arg1);
}

void EIF_Minit195 (void)
{
	GTCX
}


#ifdef __cplusplus
}
#endif
