/*
	description:	"Helper functions used by the SCOOP runtime."
	date:		"$Date: 2015-12-02 08:31:02 -0800 (Wed, 02 Dec 2015) $"
	revision:	"$Revision: 98184 $"
	copyright:	"Copyright (c) 2010-2012, Eiffel Software."
	license:	"GPL version 2 see http://www.eiffel.com/licensing/gpl.txt)"
	licensing_options:	"Commercial license is available at http://www.eiffel.com/licensing"
	copying: "[
			This file is part of Eiffel Software's Runtime.

			Eiffel Software's Runtime is free software; you can
			redistribute it and/or modify it under the terms of the
			GNU General Public License as published by the Free
			Software Foundation, version 2 of the License
			(available at the URL listed under "license" above).

			Eiffel Software's Runtime is distributed in the hope
			that it will be useful,	but WITHOUT ANY WARRANTY;
			without even the implied warranty of MERCHANTABILITY
			or FITNESS FOR A PARTICULAR PURPOSE.
			See the	GNU General Public License for more details.

			You should have received a copy of the GNU General Public
			License along with Eiffel Software's Runtime; if not,
			write to the Free Software Foundation, Inc.,
			51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA
		]"
	source: "[
			Eiffel Software
			5949 Hollister Ave., Goleta, CA 93117 USA
			Telephone 805-685-1006, Fax 805-685-6869
			Website http://www.eiffel.com
			Customer support http://support.eiffel.com
		]"
*/

#ifndef _rt_scoop_helpers_h_
#define _rt_scoop_helpers_h_

#include "eif_portable.h"
#include "rt_garcol.h" /* TODO: It would be nice if we wouldn't have to pull in as many dependencies for the definition of MARKER. */

/* Forward declaration */
struct eif_scoop_call_data;

EIF_BOOLEAN rt_try_execute_scoop_call (struct eif_scoop_call_data *call); /* Execute 'call' and return EIF_FALSE if an exception happened. */

void rt_set_processor_id (EIF_SCP_PID pid, rt_global_context_t* rt_globals); /* Associate processor of ID `pid' with the current thread. */
void rt_unset_processor_id (rt_global_context_t* rt_globals);	/* Dissociate processor from the current thread. */

void rt_mark_call_data (MARKER marking, struct eif_scoop_call_data* call); /* Mark references in 'call' with the MARKER function. */
rt_shared void rt_request_gc_cycle (int* fingerprint); /* Request a GC cycle if the fingerprint hasn't changed since last invocation. */

#endif /* _rt_scoop_helpers_h_ */
