/*
 * Code for class EW_UNIX_EXTERNALS
 */

#include "eif_eiffel.h"
#include "../E1/estructure.h"
#include "../E1/eoffsets.h"

#include "ew39.h"
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <sys/wait.h>
#include <time.h>

#ifdef __cplusplus
extern "C" {
#endif

#ifndef INLINE_F59_768
static void inline_F59_768 (EIF_INTEGER_32 arg1)
{
	int rc;
rc = close(arg1);
if (rc != 0) {
	xraise(EN_SYS);
}
	;
}
#define INLINE_F59_768
#endif
#ifndef INLINE_F59_769
static void inline_F59_769 (EIF_INTEGER_32 arg1, EIF_INTEGER_32 arg2)
{
	int rc;

  				rc = dup2(arg1, arg2);
				if (rc < 0) {
					xraise(EN_SYS);
  				}
	;
}
#define INLINE_F59_769
#endif
#ifndef INLINE_F59_772
static EIF_INTEGER_32 inline_F59_772 (void)
{
	time_t current_time;

  				current_time = time(&current_time);
  				if (current_time == (time_t) -1) {
    					eraise("time() call failed", EN_PROG);
  				}
  				return (EIF_INTEGER) current_time;
	;
}
#define INLINE_F59_772
#endif
#ifndef INLINE_F59_774
static EIF_POINTER inline_F59_774 (EIF_POINTER arg1)
{
	void * result;

  				result = (char *) malloc((size_t) (strlen((char *) arg1) + 1));
  				if (result == NULL) {
    					enomem();
  				}
  				strcpy(result, arg1);
  				return (EIF_POINTER) result;
	;
}
#define INLINE_F59_774
#endif
#ifndef INLINE_F59_775
static void inline_F59_775 (EIF_POINTER arg1, EIF_POINTER arg2)
{
	int rc;
  				int fd[2];
  				EIF_INTEGER * read_ptr;
  				EIF_INTEGER * write_ptr;

  				rc = pipe(fd);
  				if (rc != 0) {
    					xraise(EN_SYS);
  				}
  				read_ptr = (EIF_INTEGER *) arg1;
  				write_ptr = (EIF_INTEGER *) arg2;
  				*read_ptr = fd[0];
  				*write_ptr = fd[1];
	;
}
#define INLINE_F59_775
#endif
#ifndef INLINE_F59_776
static EIF_POINTER inline_F59_776 (EIF_INTEGER_32 arg1)
{
	char ** result;

  				result = (char **) malloc((size_t) (arg1 * sizeof(char *)));
  				if (result == NULL) {
    					enomem();
  				}
  				return (EIF_POINTER) result;
	;
}
#define INLINE_F59_776
#endif
#ifndef INLINE_F59_777
static void inline_F59_777 (EIF_POINTER arg1, EIF_INTEGER_32 arg2, EIF_POINTER arg3)
{
	char ** arguments;

				arguments = (char **) arg1;
				arguments[arg2] = (char *) arg3;
	;
}
#define INLINE_F59_777
#endif
#ifndef INLINE_F59_778
static EIF_INTEGER_32 inline_F59_778 (void)
{
	pid_t pid;

  				pid = eif_thread_fork();
  				if (pid == (pid_t) -1) {
    					xraise(EN_SYS);
  				}
  				return (EIF_INTEGER) pid;
	;
}
#define INLINE_F59_778
#endif
#ifndef INLINE_F59_779
static void inline_F59_779 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4)
{
	int getdtablesize(void);
  				int max_descriptors;
  				int k, rc;
  
  				if (arg4 == EIF_TRUE) {
    					max_descriptors = getdtablesize();
  					for (k = 3; k < max_descriptors; k++) {
    						rc = fcntl(k, F_SETFD, 1);
    						if (rc == -1 && errno != EBADF) {
      							xraise(EN_SYS);
    						}
  					}
  				}
  				if (arg3 == NULL) {
    					(void) execv((char *) arg1, (char **) arg2);
  				} else {
    					(void) execve((char *) arg1, (char **) arg2, (char **) arg3);
  				}
  				xraise(EN_SYS);
	;
}
#define INLINE_F59_779
#endif
#ifndef INLINE_F59_780
static void inline_F59_780 (EIF_INTEGER_32 arg1, EIF_INTEGER_32 arg2)
{
	int rc;

  				rc = kill((pid_t) arg1, (int) arg2);
  				if (rc != 0 && errno != ESRCH) {
    					xraise(EN_SYS);
  				}
	;
}
#define INLINE_F59_780
#endif
#ifndef INLINE_F59_781
static EIF_INTEGER_32 inline_F59_781 (EIF_INTEGER_32 arg1, EIF_BOOLEAN arg2, EIF_POINTER arg3)
{
	pid_t rc;
  				int status, options;
  				EIF_BOOLEAN * ptr;

  				options = ((arg2 == EIF_TRUE) ? 0 : WNOHANG) | WUNTRACED;
  				ptr = (EIF_BOOLEAN *) arg3;
  				rc = waitpid((pid_t) arg1, &status, options);
  				if (rc == (pid_t) -1) {
    					xraise(EN_SYS);
  				} else if (rc == (pid_t) 0) {	/* No process has status to report yet */
    					*ptr = EIF_FALSE;
  				} else {		/* Process reported status */
    					*ptr = EIF_TRUE;
  				}
  				return (EIF_INTEGER) status;
	;
}
#define INLINE_F59_781
#endif

#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
extern "C" {
#endif

/* {EW_UNIX_EXTERNALS}.close_file_descriptor */
void F59_768 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("close_file_descriptor", 58, Current, 0, 1, 841);
	inline_F59_768 ((EIF_INTEGER_32) arg1);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {EW_UNIX_EXTERNALS}.duplicate_file_descriptor */
void F59_769 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1, EIF_INTEGER_32 arg2)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("duplicate_file_descriptor", 58, Current, 0, 2, 842);
	inline_F59_769 ((EIF_INTEGER_32) arg1, (EIF_INTEGER_32) arg2);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {EW_UNIX_EXTERNALS}.valid_file_descriptor */
EIF_BOOLEAN F59_770 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	RTEX;
	
	
	RTEAA("valid_file_descriptor", 58, Current, 0, 1, 843);
	RTHOOK(1);
	RTHOOK(2);
	RTEE;
	return (EIF_BOOLEAN) (EIF_BOOLEAN) (arg1 >= ((EIF_INTEGER_32) 0L));
}

/* {EW_UNIX_EXTERNALS}.current_time_in_seconds */
EIF_INTEGER_32 F59_772 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("current_time_in_seconds", 58, Current, 0, 0, 845);
	Result = inline_F59_772 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {EW_UNIX_EXTERNALS}.str_dup */
EIF_POINTER F59_774 (EIF_REFERENCE Current, EIF_POINTER arg1)
{
	GTCX
	RTEX;
	EIF_POINTER Result = ((EIF_POINTER) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("str_dup", 58, Current, 0, 1, 847);
	Result = inline_F59_774 ((EIF_POINTER) arg1);
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {EW_UNIX_EXTERNALS}.unix_pipe */
void F59_775 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("unix_pipe", 58, Current, 0, 2, 834);
	inline_F59_775 ((EIF_POINTER) arg1, (EIF_POINTER) arg2);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {EW_UNIX_EXTERNALS}.unix_allocate_arg_memory */
EIF_POINTER F59_776 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	RTEX;
	EIF_POINTER Result = ((EIF_POINTER) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("unix_allocate_arg_memory", 58, Current, 0, 1, 835);
	Result = inline_F59_776 ((EIF_INTEGER_32) arg1);
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {EW_UNIX_EXTERNALS}.unix_set_arg_value */
void F59_777 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_INTEGER_32 arg2, EIF_POINTER arg3)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("unix_set_arg_value", 58, Current, 0, 3, 836);
	inline_F59_777 ((EIF_POINTER) arg1, (EIF_INTEGER_32) arg2, (EIF_POINTER) arg3);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {EW_UNIX_EXTERNALS}.unix_fork_process */
EIF_INTEGER_32 F59_778 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("unix_fork_process", 58, Current, 0, 0, 837);
	Result = inline_F59_778 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {EW_UNIX_EXTERNALS}.unix_exec_process */
void F59_779 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("unix_exec_process", 58, Current, 0, 4, 838);
	inline_F59_779 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_POINTER) arg3, (EIF_BOOLEAN) arg4);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {EW_UNIX_EXTERNALS}.unix_kill */
void F59_780 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1, EIF_INTEGER_32 arg2)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("unix_kill", 58, Current, 0, 2, 839);
	inline_F59_780 ((EIF_INTEGER_32) arg1, (EIF_INTEGER_32) arg2);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {EW_UNIX_EXTERNALS}.unix_waitpid */
EIF_INTEGER_32 F59_781 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1, EIF_BOOLEAN arg2, EIF_POINTER arg3)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("unix_waitpid", 58, Current, 0, 3, 840);
	Result = inline_F59_781 ((EIF_INTEGER_32) arg1, (EIF_BOOLEAN) arg2, (EIF_POINTER) arg3);
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

void EIF_Minit39 (void)
{
	GTCX
}


#ifdef __cplusplus
}
#endif
