/*
 * Code for class EW_UNIX_EXTERNALS
 */

#include "eif_eiffel.h"
#include "../E1/estructure.h"
#include "../E1/eoffsets.h"

#include "ew39.h"
#include <sys/wait.h>
#include <time.h>
#include <signal.h>
#include <errno.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>

#ifdef __cplusplus
extern "C" {
#endif

#ifndef INLINE_F58_770
static void inline_F58_770 (EIF_INTEGER_32 arg1)
{
	int rc;
rc = close(arg1);
if (rc != 0) {
	xraise(EN_SYS);
}
	;
}
#define INLINE_F58_770
#endif
#ifndef INLINE_F58_771
static void inline_F58_771 (EIF_INTEGER_32 arg1, EIF_INTEGER_32 arg2)
{
	int rc;

  				rc = dup2(arg1, arg2);
				if (rc < 0) {
					xraise(EN_SYS);
  				}
	;
}
#define INLINE_F58_771
#endif
#ifndef INLINE_F58_774
static EIF_INTEGER_32 inline_F58_774 (void)
{
	time_t current_time;

  				current_time = time(&current_time);
  				if (current_time == (time_t) -1) {
    					eraise("time() call failed", EN_PROG);
  				}
  				return (EIF_INTEGER) current_time;
	;
}
#define INLINE_F58_774
#endif
#ifndef INLINE_F58_776
static EIF_POINTER inline_F58_776 (EIF_POINTER arg1)
{
	void * result;

  				result = (char *) malloc((size_t) (strlen((char *) arg1) + 1));
  				if (result == NULL) {
    					enomem();
  				}
  				strcpy(result, arg1);
  				return (EIF_POINTER) result;
	;
}
#define INLINE_F58_776
#endif
#ifndef INLINE_F58_777
static void inline_F58_777 (EIF_POINTER arg1, EIF_POINTER arg2)
{
	int rc;
  				int fd[2];
  				EIF_INTEGER * read_ptr;
  				EIF_INTEGER * write_ptr;

  				rc = pipe(fd);
  				if (rc != 0) {
    					xraise(EN_SYS);
  				}
  				read_ptr = (EIF_INTEGER *) arg1;
  				write_ptr = (EIF_INTEGER *) arg2;
  				*read_ptr = fd[0];
  				*write_ptr = fd[1];
	;
}
#define INLINE_F58_777
#endif
#ifndef INLINE_F58_778
static EIF_POINTER inline_F58_778 (EIF_INTEGER_32 arg1)
{
	char ** result;

  				result = (char **) malloc((size_t) (arg1 * sizeof(char *)));
  				if (result == NULL) {
    					enomem();
  				}
  				return (EIF_POINTER) result;
	;
}
#define INLINE_F58_778
#endif
#ifndef INLINE_F58_779
static void inline_F58_779 (EIF_POINTER arg1, EIF_INTEGER_32 arg2, EIF_POINTER arg3)
{
	char ** arguments;

				arguments = (char **) arg1;
				arguments[arg2] = (char *) arg3;
	;
}
#define INLINE_F58_779
#endif
#ifndef INLINE_F58_780
static EIF_INTEGER_32 inline_F58_780 (void)
{
	pid_t pid;

  				pid = eif_thread_fork();
  				if (pid == (pid_t) -1) {
    					xraise(EN_SYS);
  				}
  				return (EIF_INTEGER) pid;
	;
}
#define INLINE_F58_780
#endif
#ifndef INLINE_F58_781
static void inline_F58_781 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4)
{
	int getdtablesize(void);
  				int max_descriptors;
  				int k, rc;
  
  				if (arg4 == EIF_TRUE) {
    					max_descriptors = getdtablesize();
  					for (k = 3; k < max_descriptors; k++) {
    						rc = fcntl(k, F_SETFD, 1);
    						if (rc == -1 && errno != EBADF) {
      							xraise(EN_SYS);
    						}
  					}
  				}
  				if (arg3 == NULL) {
    					(void) execv((char *) arg1, (char **) arg2);
  				} else {
    					(void) execve((char *) arg1, (char **) arg2, (char **) arg3);
  				}
  				xraise(EN_SYS);
	;
}
#define INLINE_F58_781
#endif
#ifndef INLINE_F58_782
static void inline_F58_782 (EIF_INTEGER_32 arg1, EIF_INTEGER_32 arg2)
{
	int rc;

  				rc = kill((pid_t) arg1, (int) arg2);
  				if (rc != 0 && errno != ESRCH) {
    					xraise(EN_SYS);
  				}
	;
}
#define INLINE_F58_782
#endif
#ifndef INLINE_F58_783
static EIF_INTEGER_32 inline_F58_783 (EIF_INTEGER_32 arg1, EIF_BOOLEAN arg2, EIF_POINTER arg3)
{
	pid_t rc;
  				int status, options;
  				EIF_BOOLEAN * ptr;

  				options = ((arg2 == EIF_TRUE) ? 0 : WNOHANG) | WUNTRACED;
  				ptr = (EIF_BOOLEAN *) arg3;
  				rc = waitpid((pid_t) arg1, &status, options);
  				if (rc == (pid_t) -1) {
    					xraise(EN_SYS);
  				} else if (rc == (pid_t) 0) {	/* No process has status to report yet */
    					*ptr = EIF_FALSE;
  				} else {		/* Process reported status */
    					*ptr = EIF_TRUE;
  				}
  				return (EIF_INTEGER) status;
	;
}
#define INLINE_F58_783
#endif

#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
extern "C" {
#endif

/* {EW_UNIX_EXTERNALS}.close_file_descriptor */
void F58_770 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("close_file_descriptor", 57, Current, 0, 1, 842);
	inline_F58_770 ((EIF_INTEGER_32) arg1);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {EW_UNIX_EXTERNALS}.duplicate_file_descriptor */
void F58_771 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1, EIF_INTEGER_32 arg2)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("duplicate_file_descriptor", 57, Current, 0, 2, 843);
	inline_F58_771 ((EIF_INTEGER_32) arg1, (EIF_INTEGER_32) arg2);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {EW_UNIX_EXTERNALS}.valid_file_descriptor */
EIF_BOOLEAN F58_772 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	RTEX;
	
	
	RTEAA("valid_file_descriptor", 57, Current, 0, 1, 844);
	RTHOOK(1);
	RTHOOK(2);
	RTEE;
	return (EIF_BOOLEAN) (EIF_BOOLEAN) (arg1 >= ((EIF_INTEGER_32) 0L));
}

/* {EW_UNIX_EXTERNALS}.current_time_in_seconds */
EIF_INTEGER_32 F58_774 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("current_time_in_seconds", 57, Current, 0, 0, 846);
	Result = inline_F58_774 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {EW_UNIX_EXTERNALS}.str_dup */
EIF_POINTER F58_776 (EIF_REFERENCE Current, EIF_POINTER arg1)
{
	GTCX
	RTEX;
	EIF_POINTER Result = ((EIF_POINTER) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("str_dup", 57, Current, 0, 1, 834);
	Result = inline_F58_776 ((EIF_POINTER) arg1);
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {EW_UNIX_EXTERNALS}.unix_pipe */
void F58_777 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("unix_pipe", 57, Current, 0, 2, 835);
	inline_F58_777 ((EIF_POINTER) arg1, (EIF_POINTER) arg2);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {EW_UNIX_EXTERNALS}.unix_allocate_arg_memory */
EIF_POINTER F58_778 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	RTEX;
	EIF_POINTER Result = ((EIF_POINTER) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("unix_allocate_arg_memory", 57, Current, 0, 1, 836);
	Result = inline_F58_778 ((EIF_INTEGER_32) arg1);
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {EW_UNIX_EXTERNALS}.unix_set_arg_value */
void F58_779 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_INTEGER_32 arg2, EIF_POINTER arg3)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("unix_set_arg_value", 57, Current, 0, 3, 837);
	inline_F58_779 ((EIF_POINTER) arg1, (EIF_INTEGER_32) arg2, (EIF_POINTER) arg3);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {EW_UNIX_EXTERNALS}.unix_fork_process */
EIF_INTEGER_32 F58_780 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("unix_fork_process", 57, Current, 0, 0, 838);
	Result = inline_F58_780 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {EW_UNIX_EXTERNALS}.unix_exec_process */
void F58_781 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("unix_exec_process", 57, Current, 0, 4, 839);
	inline_F58_781 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_POINTER) arg3, (EIF_BOOLEAN) arg4);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {EW_UNIX_EXTERNALS}.unix_kill */
void F58_782 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1, EIF_INTEGER_32 arg2)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("unix_kill", 57, Current, 0, 2, 840);
	inline_F58_782 ((EIF_INTEGER_32) arg1, (EIF_INTEGER_32) arg2);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {EW_UNIX_EXTERNALS}.unix_waitpid */
EIF_INTEGER_32 F58_783 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1, EIF_BOOLEAN arg2, EIF_POINTER arg3)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("unix_waitpid", 57, Current, 0, 3, 841);
	Result = inline_F58_783 ((EIF_INTEGER_32) arg1, (EIF_BOOLEAN) arg2, (EIF_POINTER) arg3);
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

void EIF_Minit39 (void)
{
	GTCX
}


#ifdef __cplusplus
}
#endif
