﻿note
	description: "Simple example program for ECLOP"
	copyright: "[
			Copyright (c) 2003 Paul Cohen.
			Copyright (c) 2017 Eiffel Software.
		]"
	license: "Eiffel Forum License v2 (see license.txt)"
	author: "Paul Cohen"
	date: "$Date: 2017-05-12 09:10:47 -0700 (Fri, 12 May 2017) $"
	revision: "$Revision: 100385 $"

class APPLICATION

create
	make

feature {NONE} -- Initialization

	make
			-- Run the program.
		local
			cls: COMMAND_LINE_SYNTAX
			clp: COMMAND_LINE_PARSER
			bad_options: BOOLEAN
			output_file: STRING
		do
			create cls.make (option_specifications)
			create clp.make (cls)
			clp.parse ((create {ARGUMENTS}).argument_array)
			exe_name := clp.executable_without_suffix
			if clp.valid_options.has ("-v") then
				print_version_info
			elseif clp.valid_options.has ("-h") then
				print (cls.program_help (exe_name, Void, Void))
			elseif not clp.invalid_options_found then
				if attached clp.valid_options ["-i"] as input_file_names then
					if attached clp.valid_options ["-o"] as o then
						if o.count > 1 then
							print (exe_name + ": Only one output file allowed" + "%N")
							bad_options := True
						else
							output_file := o.first
						end
					end
					if not bad_options then
						if clp.valid_options.has ("-a") then
							algorithm_a_chosen := True
						elseif clp.valid_options.has ("-b") then
							algorithm_a_chosen := False
						else
							print ("Defaulting to use algorithm A!" + "%N")
							algorithm_a_chosen := True
						end
						operate_on_files (input_file_names, output_file)
					end
				end
			else
				print (clp.error_message)
				print (cls.program_usage (exe_name) + "%N")
				print ("Use -h/--help for more help." + "%N")
			end
		end

feature {NONE} -- Implementation

	print_version_info
			-- Print version information.
		local
			s: STRING
		do
			s := exe_name + " 0.1.0 build 0" + "%N"
			s.append ("Copyright (c) 2003, Foo Software." + "%N")
			s.append ("Send bugs, problems or suggestions to support@foosoft.com" + "%N")
			print (s)
		end

	operate_on_files (input_file_names: LIST [STRING]; output_file: detachable STRING)
			-- Main body of program. Operates on `file_names'.
		do
			if output_file = Void then
				print ("Sending output to standard output." + "%N")
			else
				print ("Sending output to %"" + output_file + "%"%N")
			end
			from
				input_file_names.start
			until
				input_file_names.after
			loop
				-- Do something with each file!
				print ("Operating on file %"" + input_file_names.item + "%"")
				if algorithm_a_chosen then
					print (" using algorithm A%N")
				else
					print (" using algorithm B%N")
				end
				input_file_names.forth
			end
		end

	option_specifications: ARRAY [STRING]
			-- The recognized options of this program
		once
			Result := <<"-v,--version#Print version information.",
				    "-h,--help#Print help on how to use the program.",
				    "-a#Use algorithm A. Can't be used with -b.",
				    "-b#Use algorithm B. Can't be used with -a.",
				    "(-a|-b)",
				    "-i!=INPUTFILE!#Use INPUTFILE as input.",
				    "-o=OUTPUTFILE!#Use OUTPUTFILE as ouput. Default is stdout.">>
		end

	algorithm_a_chosen: BOOLEAN
			-- Is algorithm A chosen? If not assume B!

	exe_name: STRING
			-- Name of this executable

end
