note

	description:

		"Objects that represent the compiled form of xsl:with-param"

	library: "Gobo Eiffel XSLT Library"
	copyright: "Copyright (c) 2004-2015, Colin Adams and others"
	license: "MIT License"
	date: "$Date: 2016-05-06 12:15:38 -0700 (Fri, 06 May 2016) $"
	revision: "$Revision: 98678 $"

class XM_XSLT_COMPILED_WITH_PARAM

inherit

	XM_XSLT_COMPILED_GENERAL_VARIABLE

	XM_XSLT_WITH_PARAM_ROUTINES

create

	make

feature {NONE} -- Initialization

	make (an_executable: XM_XSLT_EXECUTABLE; a_variable_name: STRING)
			-- Establish invariant.
		require
			executable_not_void: an_executable /= Void
			variable_name_not_void: a_variable_name /= Void
		do
			executable := an_executable
			variable_name := a_variable_name
			compute_static_properties
			initialized := True
		ensure
			executable_set: executable = an_executable
			name_set: variable_name = a_variable_name
		end

feature -- Status report

	display (a_level: INTEGER)
			-- Diagnostic print of expression structure to `std.error'
		local
			a_string: STRING
		do
			a_string := STRING_.appended_string (indentation (a_level), "Passed parameter: ")
			std.error.put_string (a_string);
			std.error.put_string (variable_name);
			std.error.put_new_line
			if attached select_expression as l_select_expression then
				l_select_expression.display (a_level + 1)
			end
		end

feature -- Evaluation

	generate_tail_call (a_tail: DS_CELL [detachable XM_XPATH_TAIL_CALL]; a_context: XM_XSLT_EVALUATION_CONTEXT)
			-- Execute `Current', writing results to the current `XM_XPATH_RECEIVER'.
		do
			check
				process_leaving_tail_not_used: False
			end
		end

	evaluate_variable (a_context: XM_XPATH_CONTEXT)
			-- Evaluate variable
		do
			check
				evaluate_variable_not_used: False
			end
		end

end
