note
	description: "Task Scheduler interface. Provides location transparent manipulation of task and/or queue objects within the Tasks folder. Task Scheduler."
	generator: "Automatically generated by the EiffelCOM Wizard."

deferred class
	ITASK_SCHEDULER_INTERFACE

inherit
	ECOM_INTERFACE

feature -- Basic Operations

	set_target_computer (pwsz_computer: STRING)
			-- Selects the computer that the ITaskScheduler interface operates on.
			-- `pwsz_computer' [in].  
		deferred

		end

	get_target_computer (ppwsz_computer: CELL [STRING])
			-- Returns the name of the computer on which ITaskScheduler is currently targeted.
			-- `ppwsz_computer' [out].  
		require
			attached_ppwsz_computer: ppwsz_computer /= Void
		deferred

		ensure
			valid_ppwsz_computer: ppwsz_computer.item /= Void
		end

	enum (pp_enum_work_items: CELL [IENUM_WORK_ITEMS_INTERFACE])
			-- Retrieves a pointer to an OLE enumerator object that enumerates the tasks in the current task folder.
			-- `pp_enum_work_items' [out].  
		require
			attached_pp_enum_work_items: pp_enum_work_items /= Void
		deferred

		ensure
			valid_pp_enum_work_items: pp_enum_work_items.item /= Void
		end

	activate (pwsz_name: STRING; a_riid: ECOM_GUID; pp_unk: CELL [ECOM_INTERFACE])
			-- Returns an active interface to the specified task.
			-- `pwsz_name' [in].  
			-- `a_riid' [in].  
			-- `pp_unk' [out].  
		require
			attached_a_riid: a_riid /= Void
			valid_a_riid: a_riid.item /= default_pointer
			attached_pp_unk: pp_unk /= Void
		deferred

		ensure
			valid_pp_unk: pp_unk.item /= Void
		end

	delete (pwsz_name: STRING)
			-- Deletes a task.
			-- `pwsz_name' [in].  
		deferred

		end

	new_work_item (pwsz_task_name: STRING; rclsid: ECOM_GUID; a_riid: ECOM_GUID; pp_unk: CELL [ECOM_INTERFACE])
			-- Allocates space for a new task and retrieves its address.
			-- `pwsz_task_name' [in].  
			-- `rclsid' [in].  
			-- `a_riid' [in].  
			-- `pp_unk' [out].  
		require
			attached_rclsid: rclsid /= Void
			valid_rclsid: rclsid.item /= default_pointer
			attached_a_riid: a_riid /= Void
			valid_a_riid: a_riid.item /= default_pointer
			attached_pp_unk: pp_unk /= Void
		deferred

		ensure
			valid_pp_unk: pp_unk.item /= Void
		end

	add_work_item (pwsz_task_name: STRING; p_work_item: ISCHEDULED_WORK_ITEM_INTERFACE)
			-- Adds a task to the schedule of tasks.
			-- `pwsz_task_name' [in].  
			-- `p_work_item' [in].  
		deferred

		end

	is_of_type (pwsz_name: STRING; a_riid: ECOM_GUID)
			-- Checks the object type.
			-- `pwsz_name' [in].  
			-- `a_riid' [in].  
		require
			attached_a_riid: a_riid /= Void
			valid_a_riid: a_riid.item /= default_pointer
		deferred

		end

end -- ITASK_SCHEDULER_INTERFACE


