note
	description: "Represents any error related to invalid operations in the database."
	author: "Roman Schmocker"
	date: "$Date: 2013-09-27 16:17:24 -0700 (Fri, 27 Sep 2013) $"
	revision: "$Revision: 93026 $"

class
	PS_OPERATION_ERROR

inherit
	PS_ERROR
		redefine
			tag, accept, default_create
		end

feature -- Access

	tag: IMMUTABLE_STRING_32
			-- A short message describing what the current error is
		once
			create Result.make_from_string_8 ("Invalid operation")
		end

feature {PS_ERROR_VISITOR} -- Visitor pattern

	accept (a_visitor: PS_ERROR_VISITOR)
			-- `accept' function of the visitor pattern
		do
			a_visitor.visit_operation_error (Current)
		end

feature {NONE} -- Initialization

	default_create
			-- Create a new instance of this error
		do
			backend_error_code := -1
			set_description ("The operation is not supported by the backend.")
		end

end
