# Gobo Eiffel C Compilation

This folder contains the source code of *Gobo Eiffel C Compilation*
(`gecc`). `gecc` is a tool which is able to compile the C code
generated by `gec` in a multi-threaded environment.
It takes as argument the filename of the script generated by `gec`,
and optionally the number of threads to be used (the number of CPUs
available on the machine by default). It will execute all lines
except the last one concurrently given the chosen number of threads,
and then will execute the last line (which is supposed to be the link
command to generate the executable file).

**Included in this folder:**

* `doc`: this folder contains the documentation for this tool,
  in HTML format. Start with `index.html`.
* `src`: this folder contains the classes necessary to compile this tool.
* `test`: this folder contains tests to exercise this tool.

**To compile and run this tool:**

1. Go to folder `src`.

2. Use your favorite Eiffel compiler to compile the Eiffel system using
   the provided Xace or ECF file (e.g. `<compiler>.ecf`). Alternatively
   you can use `geant` to launch the compilation:
   
        geant compile_<compiler>
       
    where `<compiler>` is either `ise` or `ge`.

3. Run `gecc` using:

        gecc --thread=<thread_count> <script_filename>

    where `<script_filename>` is either the file `<system_name>.bat`
    or `<system_name>.sh` generated by `gec`.

## Authors

Copyright (c) 2018, Eric Bezault and others
