/*
 * Code for class I18N_HOST_LOCALE_IMP
 */

#include "eif_eiffel.h"
#include "../E1/estructure.h"
#include "../E1/eoffsets.h"

#include "i11977.h"
#include "eif_langinfo.h"
#include <eif_langinfo.h>
#include <iconv.h>
#include <eif_eiffel.h>
#include <locale.h>
#include "eif_built_in.h"
#include <string.h>
#include "eif_dir.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifndef INLINE_F2931_33583
static int inline_F2931_33583 (void)
{
	#if EIF_OS == EIF_OS_SUNOS
	return (EIF_BOOLEAN)1;
#else
	return (EIF_BOOLEAN)0;
#endif
	;
}
#define INLINE_F2931_33583
#endif
#ifndef INLINE_F214_3664
static EIF_INTEGER_32 inline_F214_3664 (void)
{
	return D_T_FMT;
	;
}
#define INLINE_F214_3664
#endif
#ifndef INLINE_F214_3665
static EIF_INTEGER_32 inline_F214_3665 (void)
{
	return D_FMT;
	;
}
#define INLINE_F214_3665
#endif
#ifndef INLINE_F214_3666
static EIF_INTEGER_32 inline_F214_3666 (void)
{
	return T_FMT;
	;
}
#define INLINE_F214_3666
#endif
#ifndef INLINE_F214_3662
static EIF_INTEGER_32 inline_F214_3662 (void)
{
	return AM_STR;
	;
}
#define INLINE_F214_3662
#endif
#ifndef INLINE_F214_3663
static EIF_INTEGER_32 inline_F214_3663 (void)
{
	return PM_STR;
	;
}
#define INLINE_F214_3663
#endif
#ifndef INLINE_F214_3668
static EIF_INTEGER_32 inline_F214_3668 (void)
{
	return CRNCYSTR;
	;
}
#define INLINE_F214_3668
#endif
#ifndef INLINE_F213_3619
static EIF_POINTER inline_F213_3619 (void)
{
	#if EIF_OS == EIF_OS_OPENBSD
	return locale_charset ();
#else
	return nl_langinfo (CODESET);
#endif
	;
}
#define INLINE_F213_3619
#endif
#ifndef INLINE_F213_3617
static EIF_POINTER inline_F213_3617 (EIF_INTEGER_32 arg1)
{
	char *dname;
				wchar_t *out = NULL;
				size_t insize, outsize = 0;

				dname = nl_langinfo(arg1);
				insize = strlen(dname) + 1;
				
				{
					iconv_t cd;
					size_t nconv, avail, alloc;
					char *res, *tres, *wrptr, *inptr;
					char **l_inptr = &inptr;

					alloc = avail = insize + insize/4;
					if (!(res = malloc(alloc))) {
					  perror("malloc");
					  return NULL;
					}

					wrptr = res;   /* duplicate pointers because they */
					inptr = dname; /* get modified by iconv */
					
					/*get charset used by current locale */
					#if EIF_OS == EIF_OS_OPENBSD
						char *charset = locale_charset ();
					#else
						char *charset = nl_langinfo (CODESET);
					#endif
					
					cd = iconv_open ("UTF-8", charset);
					if (cd == (iconv_t)(-1)) {
							perror("iconv_open");
							free(res);
							return NULL;
					}

					do {
							nconv = iconv (cd, l_inptr, &insize, &wrptr, &avail); /*convertions */
							if (nconv == (size_t)(-1)) {
									if (errno == E2BIG) { /* need more room for result */
											tres = realloc(res, alloc += 20);
											avail += 20;
											if (!tres) {
													perror("realloc");
													break;
											}
											wrptr = tres + (wrptr - res);
											res = tres;
									}
									else /* something wrong with input */
											break;
							}
					} while (insize);

					if (iconv_close(cd))
							perror("iconv_close");
				   
					out = (wchar_t*) res;
					outsize = wrptr - res; /* should be == to (alloc - avail + 1) */
					/* TODO: should possibly null-terminate the result */
				}
				return out;
	;
}
#define INLINE_F213_3617
#endif
#ifndef INLINE_F214_3631
static EIF_INTEGER_32 inline_F214_3631 (void)
{
	return DAY_1;
	;
}
#define INLINE_F214_3631
#endif
#ifndef INLINE_F214_3650
static EIF_INTEGER_32 inline_F214_3650 (void)
{
	return MON_1;
	;
}
#define INLINE_F214_3650
#endif
#ifndef INLINE_F214_3624
static EIF_INTEGER_32 inline_F214_3624 (void)
{
	return ABDAY_1;
	;
}
#define INLINE_F214_3624
#endif
#ifndef INLINE_F214_3638
static EIF_INTEGER_32 inline_F214_3638 (void)
{
	return ABMON_1;
	;
}
#define INLINE_F214_3638
#endif
#ifndef INLINE_F213_3623
static EIF_INTEGER_32 inline_F213_3623 (void)
{
	return LC_ALL;
	;
}
#define INLINE_F213_3623
#endif
#ifndef INLINE_F213_3622
static EIF_POINTER inline_F213_3622 (EIF_INTEGER_32 arg1, EIF_POINTER arg2)
{
	return setlocale((int) arg1, (const char *) arg2);
	;
}
#define INLINE_F213_3622
#endif

#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
extern "C" {
#endif

/* {I18N_HOST_LOCALE_IMP}.create_locale_info */
EIF_REFERENCE F2931_33547 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,arg1);
	RTLR(1,tr1);
	RTLR(2,Current);
	RTLR(3,Result);
	RTLIU(4);
	
	RTGC;
	if (EIF_TEST (inline_F2931_33583())) {
		tr1 = *(EIF_REFERENCE *)(RTCW(arg1) + _REFACS_1_);
		tr1 = F2213_21595(RTCW(tr1));
		tr1 = F2931_33585(Current, tr1);
		F213_3615(Current, tr1);
	} else {
		tr1 = *(EIF_REFERENCE *)(RTCW(arg1) + _REFACS_1_);
		tr1 = F2213_21595(RTCW(tr1));
		F213_3615(Current, tr1);
	}
	Result = RTLNS(eif_new_type(218, 0x00).id, 218, _OBJSIZ_35_0_0_5_0_0_0_0_);
	F219_3787(RTCW(Result));
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.fill) */
		F2931_33555(Current, Result);
		F2931_33556(Current, Result);
		F2931_33557(Current, Result);
		F2931_33558(Current, Result);
		/* END INLINED CODE */
	}
	;
	{
		/* INLINED CODE (I18N_LOCALE_INFO.set_id) */
		RTAR(Result, arg1);
		*(EIF_REFERENCE *)(RTCW(Result) + _REFACS_34_) = (EIF_REFERENCE) arg1;
		/* END INLINED CODE */
	}
	;
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.is_available */
EIF_BOOLEAN F2931_33548 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(3);
	RTLR(0,arg1);
	RTLR(1,tr1);
	RTLR(2,Current);
	RTLIU(3);
	
	RTGC;
	if (EIF_TEST (inline_F2931_33583())) {
		tr1 = *(EIF_REFERENCE *)(RTCW(arg1) + _REFACS_1_);
		tr1 = F2213_21595(RTCW(tr1));
		tr1 = F2931_33585(Current, tr1);
		Result = F213_3618(Current, tr1);
	} else {
		tr1 = *(EIF_REFERENCE *)(RTCW(arg1) + _REFACS_1_);
		Result = F213_3618(Current, tr1);
	}
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.available_locales */
EIF_REFERENCE F2931_33549 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(6);
	RTLR(0,Current);
	RTLR(1,Result);
	RTLR(2,loc2);
	RTLR(3,tr1);
	RTLR(4,loc3);
	RTLR(5,loc1);
	RTLIU(6);
	
	RTGC;
	{
		static EIF_TYPE_INDEX typarr0[] = {1496,2885,0xFFFF};
		EIF_TYPE typres0;
		static EIF_TYPE typcache0 = {INVALID_DTYPE, 0};
		
		typres0 = (typcache0.id != INVALID_DTYPE ? typcache0 : (typcache0 = eif_compound_id(Dftype(Current), typarr0)));
		Result = RTLNS(typres0.id, 1496, _OBJSIZ_2_3_0_1_0_0_0_0_);
	}
	F1497_14713(RTCW(Result));
	loc2 = RTLNS(eif_new_type(767, 0x00).id, 767, _OBJSIZ_3_0_0_1_0_2_0_0_);
	tr1 = RTMS_EX_H("/usr/share/i18n/locales/",24,2077116975);
	F768_10899(RTCW(loc2), tr1);
	{
		/* INLINED CODE (DIRECTORY.exists) */
		tb1 = (EIF_BOOLEAN)  0;
		tr1 = F768_10938(RTCW(loc2));
		tp1 = *(EIF_POINTER *)(RTCW(tr1)+ _PTROFF_0_1_0_1_0_0_);
		tb1 = (EIF_BOOLEAN) EIF_TEST(eif_dir_exists((EIF_FILENAME) tp1));
		/* END INLINED CODE */
	}
	tb1 = tb1;
	if ((EIF_BOOLEAN) !tb1) {
		tr1 = RTMS_EX_H("/usr/lib/locale",15,443040613);
		{
			/* INLINED CODE (DIRECTORY.make) */
			F768_10900(RTCW(loc2), tr1);
			/* END INLINED CODE */
		}
		;
	}
	{
		/* INLINED CODE (DIRECTORY.exists) */
		tb1 = (EIF_BOOLEAN)  0;
		tr1 = F768_10938(RTCW(loc2));
		tp1 = *(EIF_POINTER *)(RTCW(tr1)+ _PTROFF_0_1_0_1_0_0_);
		tb1 = (EIF_BOOLEAN) EIF_TEST(eif_dir_exists((EIF_FILENAME) tp1));
		/* END INLINED CODE */
	}
	tb1 = tb1;
	if (tb1) {
		loc3 = F768_10918(RTCW(loc2));
		{
			/* INLINED CODE (ARRAYED_LIST.start) */
			*(EIF_INTEGER_32 *)(RTCW(loc3) + O12384[Dtype(loc3)-1522]) = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
			/* END INLINED CODE */
		}
		;
		for (;;) {
			{
				/* INLINED CODE (LIST.after) */
				tb1 = (EIF_BOOLEAN)  0;
				ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc3) + O12384[Dtype(loc3)-1522]);
				ti4_2 = F1523_14961(RTCW(loc3));
				tb1 = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 == (EIF_INTEGER_32) (ti4_2 + ((EIF_INTEGER_32) 1L)));
				/* END INLINED CODE */
			}
			tb1 = tb1;
			if (tb1) break;
			loc1 = RTLNS(eif_new_type(2885, 0x00).id, 2885, _OBJSIZ_6_0_0_0_0_0_0_0_);
			tr1 = F1523_14945(RTCW(loc3));
			F2886_32812(RTCW(loc1), tr1);
			tr1 = *(EIF_REFERENCE *)(RTCW(loc1) + _REFACS_1_);
			if (F213_3618(Current, tr1)) {
				(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R11865[Dtype(RTCW(Result))-1210])(Result, loc1);
			}
			{
				/* INLINED CODE (ARRAYED_LIST.forth) */
				(*(EIF_INTEGER_32 *)(RTCW(loc3) + O12384[Dtype(loc3)-1522]))++;
				/* END INLINED CODE */
			}
			;
		}
	}
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.default_locale_id */
EIF_REFERENCE F2931_33550 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	RTLD;
	
	RTLI(3);
	RTLR(0,tr1);
	RTLR(1,Current);
	RTLR(2,tr2);
	RTLIU(3);
	
	RTGC;
	tr1 = RTMS_EX_H("",0,0);
	F213_3615(Current, tr1);
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.current_locale_id) */
		tr1 = (EIF_REFERENCE)  0;
		tr1 = RTLNS(eif_new_type(2885, 0x00).id, 2885, _OBJSIZ_6_0_0_0_0_0_0_0_);
		tr2 = F2931_33553(Current);
		F2886_32812(RTCW(tr1), tr2);
		/* END INLINED CODE */
	}
	RTLE;
	return (EIF_REFERENCE) tr1;
}

/* {I18N_HOST_LOCALE_IMP}.system_locale_id */
EIF_REFERENCE F2931_33551 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	RTLD;
	
	RTLI(3);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,tr2);
	RTLIU(3);
	
	RTGC;
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.default_locale_id) */
		tr1 = (EIF_REFERENCE)  0;
		tr2 = RTMS_EX_H("",0,0);
		F213_3615(Current, tr2);
		tr1 = F2931_33552(Current);
		/* END INLINED CODE */
	}
	RTLE;
	return (EIF_REFERENCE) tr1;
}

/* {I18N_HOST_LOCALE_IMP}.current_locale_id */
EIF_REFERENCE F2931_33552 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(3);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,Result);
	RTLIU(3);
	
	RTGC;
	Result = RTLNS(eif_new_type(2885, 0x00).id, 2885, _OBJSIZ_6_0_0_0_0_0_0_0_);
	tr1 = F2931_33553(Current);
	F2886_32812(RTCW(Result), tr1);
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.locale_name */
EIF_REFERENCE F2931_33553 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(3);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,Result);
	RTLIU(3);
	
	RTGC;
	tr1 = F213_3620(Current);
	Result = F2213_21598(RTCW(tr1));
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.fill */
void F2931_33554 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTLD;
	
	RTLI(2);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLIU(2);
	
	RTGC;
	F2931_33555(Current, arg1);
	F2931_33556(Current, arg1);
	F2931_33557(Current, arg1);
	F2931_33558(Current, arg1);
	RTLE;
}

/* {I18N_HOST_LOCALE_IMP}.fill_date_time_info */
void F2931_33555 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_REFERENCE tr3 = NULL;
	EIF_INTEGER_32 ti4_1;
	RTLD;
	
	RTLI(5);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,tr2);
	RTLR(4,tr3);
	RTLIU(5);
	
	RTGC;
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.get_date_time_format) */
		tr1 = (EIF_REFERENCE)  0;
		ti4_1 = inline_F214_3664();
		tr2 = F213_3616(Current, ti4_1);
		tr1 = F2931_33584(Current, tr2);
		tr2 = RTMS32_EX_H("%\000\000\000",1,37);
		tr3 = RTMS32_EX_H("&\000\000\000",1,38);
		F2222_21922(RTCW(tr1), tr2, tr3);
		/* END INLINED CODE */
	}
	tr2 = tr1;
	{
		/* INLINED CODE (I18N_DATE_TIME_INFO.set_date_time_format) */
		tr3 = F2213_21599(RTCW(tr2));
		RTAR(arg1, tr3);
		*(EIF_REFERENCE *)(RTCW(arg1) + _REFACS_3_) = (EIF_REFERENCE) tr3;
		/* END INLINED CODE */
	}
	;
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.get_long_date_format) */
		tr1 = (EIF_REFERENCE)  0;
		ti4_1 = inline_F214_3665();
		tr2 = F213_3616(Current, ti4_1);
		tr1 = F2931_33584(Current, tr2);
		tr2 = RTMS32_EX_H("%\000\000\000",1,37);
		tr3 = RTMS32_EX_H("&\000\000\000",1,38);
		F2222_21922(RTCW(tr1), tr2, tr3);
		/* END INLINED CODE */
	}
	tr2 = tr1;
	{
		/* INLINED CODE (I18N_DATE_TIME_INFO.set_long_date_format) */
		tr3 = F2213_21599(RTCW(tr2));
		RTAR(arg1, tr3);
		*(EIF_REFERENCE *)(RTCW(arg1) + _REFACS_4_) = (EIF_REFERENCE) tr3;
		/* END INLINED CODE */
	}
	;
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.get_long_time_format) */
		tr1 = (EIF_REFERENCE)  0;
		ti4_1 = inline_F214_3666();
		tr2 = F213_3616(Current, ti4_1);
		tr1 = F2931_33584(Current, tr2);
		tr2 = RTMS32_EX_H("%\000\000\000",1,37);
		tr3 = RTMS32_EX_H("&\000\000\000",1,38);
		F2222_21922(RTCW(tr1), tr2, tr3);
		/* END INLINED CODE */
	}
	tr2 = tr1;
	{
		/* INLINED CODE (I18N_DATE_TIME_INFO.set_long_time_format) */
		tr3 = F2213_21599(RTCW(tr2));
		RTAR(arg1, tr3);
		*(EIF_REFERENCE *)(RTCW(arg1) + _REFACS_6_) = (EIF_REFERENCE) tr3;
		/* END INLINED CODE */
	}
	;
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.get_am_suffix) */
		tr1 = (EIF_REFERENCE)  0;
		ti4_1 = inline_F214_3662();
		tr2 = F213_3616(Current, ti4_1);
		tr1 = F2931_33584(Current, tr2);
		/* END INLINED CODE */
	}
	tr2 = tr1;
	{
		/* INLINED CODE (I18N_DATE_TIME_INFO.set_am_suffix) */
		tr3 = F2213_21599(RTCW(tr2));
		RTAR(arg1, tr3);
		*(EIF_REFERENCE *)(RTCW(arg1) + _REFACS_8_) = (EIF_REFERENCE) tr3;
		/* END INLINED CODE */
	}
	;
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.get_pm_suffix) */
		tr1 = (EIF_REFERENCE)  0;
		ti4_1 = inline_F214_3663();
		tr2 = F213_3616(Current, ti4_1);
		tr1 = F2931_33584(Current, tr2);
		/* END INLINED CODE */
	}
	tr2 = tr1;
	{
		/* INLINED CODE (I18N_DATE_TIME_INFO.set_pm_suffix) */
		tr3 = F2213_21599(RTCW(tr2));
		RTAR(arg1, tr3);
		*(EIF_REFERENCE *)(RTCW(arg1) + _REFACS_9_) = (EIF_REFERENCE) tr3;
		/* END INLINED CODE */
	}
	;
	tr1 = F2931_33564(Current);
	{
		/* INLINED CODE (I18N_DATE_TIME_INFO.set_day_names) */
		RTAR(arg1, tr1);
		*(EIF_REFERENCE *)(RTCW(arg1) + _REFACS_12_) = (EIF_REFERENCE) tr1;
		/* END INLINED CODE */
	}
	;
	tr1 = F2931_33565(Current);
	{
		/* INLINED CODE (I18N_DATE_TIME_INFO.set_month_names) */
		RTAR(arg1, tr1);
		*(EIF_REFERENCE *)(RTCW(arg1) + _REFACS_13_) = (EIF_REFERENCE) tr1;
		/* END INLINED CODE */
	}
	;
	tr1 = F2931_33566(Current);
	{
		/* INLINED CODE (I18N_DATE_TIME_INFO.set_abbreviated_day_names) */
		RTAR(arg1, tr1);
		*(EIF_REFERENCE *)(RTCW(arg1) + _REFACS_14_) = (EIF_REFERENCE) tr1;
		/* END INLINED CODE */
	}
	;
	tr1 = F2931_33567(Current);
	{
		/* INLINED CODE (I18N_DATE_TIME_INFO.set_abbreviated_month_names) */
		RTAR(arg1, tr1);
		*(EIF_REFERENCE *)(RTCW(arg1) + _REFACS_15_) = (EIF_REFERENCE) tr1;
		/* END INLINED CODE */
	}
	;
	RTLE;
}

/* {I18N_HOST_LOCALE_IMP}.fill_numeric_info */
void F2931_33556 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_REFERENCE tr3 = NULL;
	RTLD;
	
	RTLI(5);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,tr2);
	RTLR(4,tr3);
	RTLIU(5);
	
	RTGC;
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.get_value_decimal_separator) */
		tr1 = (EIF_REFERENCE)  0;
		tr1 = RTLNS(eif_new_type(2221, 0x00).id, 2221, _OBJSIZ_1_1_0_3_0_0_0_0_);
		tp1 = (EIF_POINTER) localeconv();
		tp1 = (EIF_POINTER) (((struct lconv *)tp1)->decimal_point);
		F2220_21836(RTCW(tr1), tp1);
		/* END INLINED CODE */
	}
	tr2 = tr1;
	{
		/* INLINED CODE (I18N_NUMERIC_INFO.set_value_decimal_separator) */
		tr3 = F2213_21598(RTCW(tr2));
		RTAR(arg1, tr3);
		*(EIF_REFERENCE *)(RTCW(arg1) + _REFACS_16_) = (EIF_REFERENCE) tr3;
		/* END INLINED CODE */
	}
	;
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.get_value_group_separator) */
		tr1 = (EIF_REFERENCE)  0;
		tr1 = RTLNS(eif_new_type(2221, 0x00).id, 2221, _OBJSIZ_1_1_0_3_0_0_0_0_);
		tp1 = (EIF_POINTER) localeconv();
		tp1 = (EIF_POINTER) (((struct lconv *)tp1)->thousands_sep);
		F2220_21836(RTCW(tr1), tp1);
		/* END INLINED CODE */
	}
	tr2 = tr1;
	{
		/* INLINED CODE (I18N_NUMERIC_INFO.set_value_group_separator) */
		tr3 = F2213_21598(RTCW(tr2));
		RTAR(arg1, tr3);
		*(EIF_REFERENCE *)(RTCW(arg1) + _REFACS_17_) = (EIF_REFERENCE) tr3;
		/* END INLINED CODE */
	}
	;
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.get_value_grouping) */
		tr1 = (EIF_REFERENCE)  0;
		tp1 = (EIF_POINTER) localeconv();
		tp1 = (EIF_POINTER) (((struct lconv *)tp1)->grouping);
		tr1 = F2931_33582(Current, tp1);
		/* END INLINED CODE */
	}
	tr2 = tr1;
	{
		/* INLINED CODE (I18N_NUMERIC_INFO.set_value_grouping) */
		RTAR(arg1, tr2);
		*(EIF_REFERENCE *)(RTCW(arg1) + _REFACS_21_) = (EIF_REFERENCE) tr2;
		/* END INLINED CODE */
	}
	;
	RTLE;
}

/* {I18N_HOST_LOCALE_IMP}.fill_currency_info */
void F2931_33557 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_REFERENCE tr3 = NULL;
	EIF_INTEGER_32 ti4_1;
	RTLD;
	
	RTLI(5);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,tr2);
	RTLR(4,tr3);
	RTLIU(5);
	
	RTGC;
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.get_currency_symbol) */
		tr1 = (EIF_REFERENCE)  0;
		ti4_1 = inline_F214_3668();
		tr2 = F213_3616(Current, ti4_1);
		tr1 = F2931_33584(Current, tr2);
		F2222_21966(RTCW(tr1), ((EIF_INTEGER_32) 1L));
		/* END INLINED CODE */
	}
	tr2 = tr1;
	{
		/* INLINED CODE (I18N_CURRENCY_INFO.set_currency_symbol) */
		tr3 = F2213_21598(RTCW(tr2));
		RTAR(arg1, tr3);
		*(EIF_REFERENCE *)(RTCW(arg1) + O3707[Dtype(arg1)-217]) = (EIF_REFERENCE) tr3;
		/* END INLINED CODE */
	}
	;
	ti4_1 = F2931_33572(Current);
	{
		/* INLINED CODE (I18N_CURRENCY_INFO.set_currency_symbol_location) */
		*(EIF_INTEGER_32 *)(RTCW(arg1) + O3708[Dtype(arg1)-217]) = (EIF_INTEGER_32) ti4_1;
		/* END INLINED CODE */
	}
	;
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.get_currency_decimal_separator) */
		tr1 = (EIF_REFERENCE)  0;
		tr1 = RTLNS(eif_new_type(2221, 0x00).id, 2221, _OBJSIZ_1_1_0_3_0_0_0_0_);
		tp1 = (EIF_POINTER) localeconv();
		tp1 = (EIF_POINTER) (((struct lconv *)tp1)->mon_decimal_point);
		F2220_21836(RTCW(tr1), tp1);
		/* END INLINED CODE */
	}
	tr2 = tr1;
	{
		/* INLINED CODE (I18N_CURRENCY_INFO.set_currency_decimal_separator) */
		tr3 = F2213_21599(RTCW(tr2));
		RTAR(arg1, tr3);
		*(EIF_REFERENCE *)(RTCW(arg1) + O3712[Dtype(arg1)-217]) = (EIF_REFERENCE) tr3;
		/* END INLINED CODE */
	}
	;
	ti4_1 = F2931_33574(Current);
	{
		/* INLINED CODE (I18N_CURRENCY_INFO.set_currency_numbers_after_decimal_separator) */
		*(EIF_INTEGER_32 *)(RTCW(arg1) + O3713[Dtype(arg1)-217]) = (EIF_INTEGER_32) ti4_1;
		/* END INLINED CODE */
	}
	;
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.get_currency_group_separator) */
		tr1 = (EIF_REFERENCE)  0;
		tr1 = RTLNS(eif_new_type(2221, 0x00).id, 2221, _OBJSIZ_1_1_0_3_0_0_0_0_);
		tp1 = (EIF_POINTER) localeconv();
		tp1 = (EIF_POINTER) (((struct lconv *)tp1)->mon_thousands_sep);
		F2220_21836(RTCW(tr1), tp1);
		/* END INLINED CODE */
	}
	tr2 = tr1;
	{
		/* INLINED CODE (I18N_CURRENCY_INFO.set_currency_group_separator) */
		tr3 = F2213_21599(RTCW(tr2));
		RTAR(arg1, tr3);
		*(EIF_REFERENCE *)(RTCW(arg1) + O3714[Dtype(arg1)-217]) = (EIF_REFERENCE) tr3;
		/* END INLINED CODE */
	}
	;
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.get_currency_positive_sign) */
		tr1 = (EIF_REFERENCE)  0;
		tr1 = RTLNS(eif_new_type(2221, 0x00).id, 2221, _OBJSIZ_1_1_0_3_0_0_0_0_);
		tp1 = (EIF_POINTER) localeconv();
		tp1 = (EIF_POINTER) (((struct lconv *)tp1)->positive_sign);
		F2220_21836(RTCW(tr1), tp1);
		/* END INLINED CODE */
	}
	tr2 = tr1;
	{
		/* INLINED CODE (I18N_CURRENCY_INFO.set_currency_positive_sign) */
		tr3 = F2213_21599(RTCW(tr2));
		RTAR(arg1, tr3);
		*(EIF_REFERENCE *)(RTCW(arg1) + O3716[Dtype(arg1)-217]) = (EIF_REFERENCE) tr3;
		/* END INLINED CODE */
	}
	;
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.get_currency_negative_sign) */
		tr1 = (EIF_REFERENCE)  0;
		tr1 = RTLNS(eif_new_type(2221, 0x00).id, 2221, _OBJSIZ_1_1_0_3_0_0_0_0_);
		tp1 = (EIF_POINTER) localeconv();
		tp1 = (EIF_POINTER) (((struct lconv *)tp1)->negative_sign);
		F2220_21836(RTCW(tr1), tp1);
		/* END INLINED CODE */
	}
	tr2 = tr1;
	{
		/* INLINED CODE (I18N_CURRENCY_INFO.set_currency_negative_sign) */
		tr3 = F2213_21599(RTCW(tr2));
		RTAR(arg1, tr3);
		*(EIF_REFERENCE *)(RTCW(arg1) + O3717[Dtype(arg1)-217]) = (EIF_REFERENCE) tr3;
		/* END INLINED CODE */
	}
	;
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.get_currency_grouping) */
		tr1 = (EIF_REFERENCE)  0;
		tp1 = (EIF_POINTER) localeconv();
		tp1 = (EIF_POINTER) (((struct lconv *)tp1)->mon_grouping);
		tr1 = F2931_33582(Current, tp1);
		/* END INLINED CODE */
	}
	tr2 = tr1;
	{
		/* INLINED CODE (I18N_CURRENCY_INFO.set_currency_grouping) */
		RTAR(arg1, tr2);
		*(EIF_REFERENCE *)(RTCW(arg1) + O3718[Dtype(arg1)-217]) = (EIF_REFERENCE) tr2;
		/* END INLINED CODE */
	}
	;
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.get_int_currency_symbol) */
		tr1 = (EIF_REFERENCE)  0;
		tr1 = RTLNS(eif_new_type(2221, 0x00).id, 2221, _OBJSIZ_1_1_0_3_0_0_0_0_);
		tp1 = (EIF_POINTER) localeconv();
		tp1 = (EIF_POINTER) (((struct lconv *)tp1)->int_curr_symbol);
		F2220_21836(RTCW(tr1), tp1);
		/* END INLINED CODE */
	}
	tr2 = tr1;
	{
		/* INLINED CODE (I18N_CURRENCY_INFO.set_international_currency_symbol) */
		tr3 = F2213_21598(RTCW(tr2));
		RTAR(arg1, tr3);
		*(EIF_REFERENCE *)(RTCW(arg1) + O3719[Dtype(arg1)-217]) = (EIF_REFERENCE) tr3;
		/* END INLINED CODE */
	}
	;
	ti4_1 = F2931_33581(Current);
	{
		/* INLINED CODE (I18N_CURRENCY_INFO.set_international_currency_numbers_after_decimal_separator) */
		*(EIF_INTEGER_32 *)(RTCW(arg1) + O3725[Dtype(arg1)-217]) = (EIF_INTEGER_32) ti4_1;
		/* END INLINED CODE */
	}
	;
	RTLE;
}

/* {I18N_HOST_LOCALE_IMP}.fill_code_page_info */
void F2931_33558 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_REFERENCE tr3 = NULL;
	RTLD;
	
	RTLI(6);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,tr2);
	RTLR(4,tr3);
	RTLR(5,arg1);
	RTLIU(6);
	
	RTGC;
	{
		/* INLINED CODE (I18N_HOST_LOCALE_IMP.get_code_page) */
		tr1 = (EIF_REFERENCE)  0;
		tr2 = (EIF_REFERENCE)  0;
		tr1 = RTLNS(eif_new_type(877, 0x00).id, 877, _OBJSIZ_1_0_0_1_0_0_0_0_);
		tp1 = inline_F213_3619();
		F878_12744(RTCW(tr1), tp1);
		tr3 = *(EIF_REFERENCE *)(RTCW(tr1));
		tr2 = F2931_33584(Current, tr3);
		/* END INLINED CODE */
	}
	loc1 = F2213_21595(RTCV(tr2));
	{
		/* INLINED CODE (I18N_CODE_PAGE_INFO.set_ansi_code_page) */
		tr1 = (EIF_REFERENCE)  0;
		if ((EIF_BOOLEAN)(loc1 != NULL)) {
			tr2 = F2213_21592(RTCW(loc1));
			RTAR(arg1, tr2);
			*(EIF_REFERENCE *)(RTCW(arg1)) = (EIF_REFERENCE) tr2;
		} else {
			*(EIF_REFERENCE *)(RTCW(arg1)) = (EIF_REFERENCE) NULL;
		}
		/* END INLINED CODE */
	}
	;
	{
		/* INLINED CODE (I18N_CODE_PAGE_INFO.set_oem_code_page) */
		tr1 = (EIF_REFERENCE)  0;
		if ((EIF_BOOLEAN)(loc1 != NULL)) {
			tr2 = F2213_21592(RTCW(loc1));
			RTAR(arg1, tr2);
			*(EIF_REFERENCE *)(RTCW(arg1) + _REFACS_1_) = (EIF_REFERENCE) tr2;
		} else {
			*(EIF_REFERENCE *)(RTCW(arg1) + _REFACS_1_) = (EIF_REFERENCE) NULL;
		}
		/* END INLINED CODE */
	}
	;
	{
		/* INLINED CODE (I18N_CODE_PAGE_INFO.set_mac_code_page) */
		tr1 = (EIF_REFERENCE)  0;
		if ((EIF_BOOLEAN)(loc1 != NULL)) {
			tr2 = F2213_21592(RTCW(loc1));
			RTAR(arg1, tr2);
			*(EIF_REFERENCE *)(RTCW(arg1) + _REFACS_2_) = (EIF_REFERENCE) tr2;
		} else {
			*(EIF_REFERENCE *)(RTCW(arg1) + _REFACS_2_) = (EIF_REFERENCE) NULL;
		}
		/* END INLINED CODE */
	}
	;
	RTLE;
}

/* {I18N_HOST_LOCALE_IMP}.get_long_date_format */
EIF_REFERENCE F2931_33559 (EIF_REFERENCE Current)
{
	GTCX
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,tr2);
	RTLR(3,Result);
	RTLIU(4);
	
	RTGC;
	ti4_1 = inline_F214_3665();
	{
		/* INLINED CODE (I18N_UNIX_C_FUNCTIONS.unix_get_locale_info_managed) */
		tr1 = (EIF_REFERENCE)  0;
		tr1 = RTLNS(eif_new_type(765, 0x00).id, 765, _OBJSIZ_0_1_0_1_0_1_1_0_);
		tp1 = inline_F213_3617(ti4_1);
		F766_10799(RTCW(tr1), tp1, ((EIF_INTEGER_32) 0L));
		/* END INLINED CODE */
	}
	tr2 = tr1;
	Result = F2931_33584(Current, tr2);
	tr1 = RTMS32_EX_H("%\000\000\000",1,37);
	tr2 = RTMS32_EX_H("&\000\000\000",1,38);
	F2222_21922(RTCW(Result), tr1, tr2);
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_long_time_format */
EIF_REFERENCE F2931_33560 (EIF_REFERENCE Current)
{
	GTCX
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,tr2);
	RTLR(3,Result);
	RTLIU(4);
	
	RTGC;
	ti4_1 = inline_F214_3666();
	{
		/* INLINED CODE (I18N_UNIX_C_FUNCTIONS.unix_get_locale_info_managed) */
		tr1 = (EIF_REFERENCE)  0;
		tr1 = RTLNS(eif_new_type(765, 0x00).id, 765, _OBJSIZ_0_1_0_1_0_1_1_0_);
		tp1 = inline_F213_3617(ti4_1);
		F766_10799(RTCW(tr1), tp1, ((EIF_INTEGER_32) 0L));
		/* END INLINED CODE */
	}
	tr2 = tr1;
	Result = F2931_33584(Current, tr2);
	tr1 = RTMS32_EX_H("%\000\000\000",1,37);
	tr2 = RTMS32_EX_H("&\000\000\000",1,38);
	F2222_21922(RTCW(Result), tr1, tr2);
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_am_suffix */
EIF_REFERENCE F2931_33561 (EIF_REFERENCE Current)
{
	GTCX
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,tr2);
	RTLR(3,Result);
	RTLIU(4);
	
	RTGC;
	ti4_1 = inline_F214_3662();
	{
		/* INLINED CODE (I18N_UNIX_C_FUNCTIONS.unix_get_locale_info_managed) */
		tr1 = (EIF_REFERENCE)  0;
		tr1 = RTLNS(eif_new_type(765, 0x00).id, 765, _OBJSIZ_0_1_0_1_0_1_1_0_);
		tp1 = inline_F213_3617(ti4_1);
		F766_10799(RTCW(tr1), tp1, ((EIF_INTEGER_32) 0L));
		/* END INLINED CODE */
	}
	tr2 = tr1;
	Result = F2931_33584(Current, tr2);
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_pm_suffix */
EIF_REFERENCE F2931_33562 (EIF_REFERENCE Current)
{
	GTCX
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,tr2);
	RTLR(3,Result);
	RTLIU(4);
	
	RTGC;
	ti4_1 = inline_F214_3663();
	{
		/* INLINED CODE (I18N_UNIX_C_FUNCTIONS.unix_get_locale_info_managed) */
		tr1 = (EIF_REFERENCE)  0;
		tr1 = RTLNS(eif_new_type(765, 0x00).id, 765, _OBJSIZ_0_1_0_1_0_1_1_0_);
		tp1 = inline_F213_3617(ti4_1);
		F766_10799(RTCW(tr1), tp1, ((EIF_INTEGER_32) 0L));
		/* END INLINED CODE */
	}
	tr2 = tr1;
	Result = F2931_33584(Current, tr2);
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_date_time_format */
EIF_REFERENCE F2931_33563 (EIF_REFERENCE Current)
{
	GTCX
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,tr2);
	RTLR(3,Result);
	RTLIU(4);
	
	RTGC;
	ti4_1 = inline_F214_3664();
	{
		/* INLINED CODE (I18N_UNIX_C_FUNCTIONS.unix_get_locale_info_managed) */
		tr1 = (EIF_REFERENCE)  0;
		tr1 = RTLNS(eif_new_type(765, 0x00).id, 765, _OBJSIZ_0_1_0_1_0_1_1_0_);
		tp1 = inline_F213_3617(ti4_1);
		F766_10799(RTCW(tr1), tp1, ((EIF_INTEGER_32) 0L));
		/* END INLINED CODE */
	}
	tr2 = tr1;
	Result = F2931_33584(Current, tr2);
	tr1 = RTMS32_EX_H("%\000\000\000",1,37);
	tr2 = RTMS32_EX_H("&\000\000\000",1,38);
	F2222_21922(RTCW(Result), tr1, tr2);
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_day_names */
EIF_REFERENCE F2931_33564 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(5);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,Result);
	RTLR(3,loc3);
	RTLR(4,tr2);
	RTLIU(5);
	
	RTGC;
	loc2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 7L);
	{
		static EIF_TYPE_INDEX typarr0[] = {1558,2221,0xFFFF};
		EIF_TYPE typres0;
		static EIF_TYPE typcache0 = {INVALID_DTYPE, 0};
		
		typres0 = (typcache0.id != INVALID_DTYPE ? typcache0 : (typcache0 = eif_compound_id(Dftype(Current), typarr0)));
		Result = RTLNS(typres0.id, 1558, _OBJSIZ_1_1_0_2_0_0_0_0_);
	}
	tr1 = RTMS32_EX_H("",0,0);
	F1559_15130(RTCW(Result), tr1, ((EIF_INTEGER_32) 1L), loc2);
	loc1 = *(EIF_INTEGER_32 *)(RTCW(Result) + O12501[Dtype(Result)-1558]);
	for (;;) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(Result) + O12500[Dtype(Result)-1558]);
		if ((EIF_BOOLEAN) (loc1 > ti4_1)) break;
		ti4_2 = inline_F214_3631();
		{
			/* INLINED CODE (I18N_UNIX_C_FUNCTIONS.unix_get_locale_info_managed) */
			ti4_2 = (EIF_INTEGER_32) (ti4_2 + ((EIF_INTEGER_32) ((EIF_INTEGER_32) (loc1 - ((EIF_INTEGER_32) 1L)) % loc2)));
			tr1 = (EIF_REFERENCE)  0;
			tr1 = RTLNS(eif_new_type(765, 0x00).id, 765, _OBJSIZ_0_1_0_1_0_1_1_0_);
			tp1 = inline_F213_3617(ti4_2);
			F766_10799(RTCW(tr1), tp1, ((EIF_INTEGER_32) 0L));
			/* END INLINED CODE */
		}
		tr2 = tr1;
		loc3 = F2931_33584(Current, tr2);
		{
			/* INLINED CODE (ARRAY.put) */
			tr1 = *(EIF_REFERENCE *)(RTCW(Result));
			ti4_2 = *(EIF_INTEGER_32 *)(RTCW(Result) + O12501[Dtype(Result)-1558]);
			/* INLINED CODE (SPECIAL.put) */
			*((EIF_REFERENCE *)RTCW(tr1) + ((EIF_INTEGER_32) (loc1 - ti4_2))) = loc3;
			RTAR(tr1,loc3);
			/* END INLINED CODE */;
			/* END INLINED CODE */
		}
		;
		loc1++;
	}
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_month_names */
EIF_REFERENCE F2931_33565 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(5);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,Result);
	RTLR(3,loc2);
	RTLR(4,tr2);
	RTLIU(5);
	
	RTGC;
	{
		static EIF_TYPE_INDEX typarr0[] = {1558,2221,0xFFFF};
		EIF_TYPE typres0;
		static EIF_TYPE typcache0 = {INVALID_DTYPE, 0};
		
		typres0 = (typcache0.id != INVALID_DTYPE ? typcache0 : (typcache0 = eif_compound_id(Dftype(Current), typarr0)));
		Result = RTLNS(typres0.id, 1558, _OBJSIZ_1_1_0_2_0_0_0_0_);
	}
	tr1 = RTMS32_EX_H("",0,0);
	F1559_15130(RTCW(Result), tr1, ((EIF_INTEGER_32) 1L), ((EIF_INTEGER_32) 12L));
	loc1 = *(EIF_INTEGER_32 *)(RTCW(Result) + O12501[Dtype(Result)-1558]);
	for (;;) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(Result) + O12500[Dtype(Result)-1558]);
		if ((EIF_BOOLEAN) (loc1 > ti4_1)) break;
		ti4_2 = inline_F214_3650();
		{
			/* INLINED CODE (I18N_UNIX_C_FUNCTIONS.unix_get_locale_info_managed) */
			ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_2 + loc1) - ((EIF_INTEGER_32) 1L));
			tr1 = (EIF_REFERENCE)  0;
			tr1 = RTLNS(eif_new_type(765, 0x00).id, 765, _OBJSIZ_0_1_0_1_0_1_1_0_);
			tp1 = inline_F213_3617(ti4_2);
			F766_10799(RTCW(tr1), tp1, ((EIF_INTEGER_32) 0L));
			/* END INLINED CODE */
		}
		tr2 = tr1;
		loc2 = F2931_33584(Current, tr2);
		{
			/* INLINED CODE (ARRAY.put) */
			tr1 = *(EIF_REFERENCE *)(RTCW(Result));
			ti4_2 = *(EIF_INTEGER_32 *)(RTCW(Result) + O12501[Dtype(Result)-1558]);
			/* INLINED CODE (SPECIAL.put) */
			*((EIF_REFERENCE *)RTCW(tr1) + ((EIF_INTEGER_32) (loc1 - ti4_2))) = loc2;
			RTAR(tr1,loc2);
			/* END INLINED CODE */;
			/* END INLINED CODE */
		}
		;
		loc1++;
	}
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_abbreviated_day_names */
EIF_REFERENCE F2931_33566 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(5);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,Result);
	RTLR(3,loc3);
	RTLR(4,tr2);
	RTLIU(5);
	
	RTGC;
	loc2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 7L);
	{
		static EIF_TYPE_INDEX typarr0[] = {1558,2221,0xFFFF};
		EIF_TYPE typres0;
		static EIF_TYPE typcache0 = {INVALID_DTYPE, 0};
		
		typres0 = (typcache0.id != INVALID_DTYPE ? typcache0 : (typcache0 = eif_compound_id(Dftype(Current), typarr0)));
		Result = RTLNS(typres0.id, 1558, _OBJSIZ_1_1_0_2_0_0_0_0_);
	}
	tr1 = RTMS32_EX_H("",0,0);
	F1559_15130(RTCW(Result), tr1, ((EIF_INTEGER_32) 1L), loc2);
	loc1 = *(EIF_INTEGER_32 *)(RTCW(Result) + O12501[Dtype(Result)-1558]);
	for (;;) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(Result) + O12500[Dtype(Result)-1558]);
		if ((EIF_BOOLEAN) (loc1 > ti4_1)) break;
		ti4_2 = inline_F214_3624();
		{
			/* INLINED CODE (I18N_UNIX_C_FUNCTIONS.unix_get_locale_info_managed) */
			ti4_2 = (EIF_INTEGER_32) (ti4_2 + ((EIF_INTEGER_32) ((EIF_INTEGER_32) (loc1 - ((EIF_INTEGER_32) 1L)) % loc2)));
			tr1 = (EIF_REFERENCE)  0;
			tr1 = RTLNS(eif_new_type(765, 0x00).id, 765, _OBJSIZ_0_1_0_1_0_1_1_0_);
			tp1 = inline_F213_3617(ti4_2);
			F766_10799(RTCW(tr1), tp1, ((EIF_INTEGER_32) 0L));
			/* END INLINED CODE */
		}
		tr2 = tr1;
		loc3 = F2931_33584(Current, tr2);
		{
			/* INLINED CODE (ARRAY.put) */
			tr1 = *(EIF_REFERENCE *)(RTCW(Result));
			ti4_2 = *(EIF_INTEGER_32 *)(RTCW(Result) + O12501[Dtype(Result)-1558]);
			/* INLINED CODE (SPECIAL.put) */
			*((EIF_REFERENCE *)RTCW(tr1) + ((EIF_INTEGER_32) (loc1 - ti4_2))) = loc3;
			RTAR(tr1,loc3);
			/* END INLINED CODE */;
			/* END INLINED CODE */
		}
		;
		loc1++;
	}
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_abbreviated_month_names */
EIF_REFERENCE F2931_33567 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(5);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,Result);
	RTLR(3,loc2);
	RTLR(4,tr2);
	RTLIU(5);
	
	RTGC;
	{
		static EIF_TYPE_INDEX typarr0[] = {1558,2221,0xFFFF};
		EIF_TYPE typres0;
		static EIF_TYPE typcache0 = {INVALID_DTYPE, 0};
		
		typres0 = (typcache0.id != INVALID_DTYPE ? typcache0 : (typcache0 = eif_compound_id(Dftype(Current), typarr0)));
		Result = RTLNS(typres0.id, 1558, _OBJSIZ_1_1_0_2_0_0_0_0_);
	}
	tr1 = RTMS32_EX_H("",0,0);
	F1559_15130(RTCW(Result), tr1, ((EIF_INTEGER_32) 1L), ((EIF_INTEGER_32) 12L));
	loc1 = *(EIF_INTEGER_32 *)(RTCW(Result) + O12501[Dtype(Result)-1558]);
	for (;;) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(Result) + O12500[Dtype(Result)-1558]);
		if ((EIF_BOOLEAN) (loc1 > ti4_1)) break;
		ti4_2 = inline_F214_3638();
		{
			/* INLINED CODE (I18N_UNIX_C_FUNCTIONS.unix_get_locale_info_managed) */
			ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_2 + loc1) - ((EIF_INTEGER_32) 1L));
			tr1 = (EIF_REFERENCE)  0;
			tr1 = RTLNS(eif_new_type(765, 0x00).id, 765, _OBJSIZ_0_1_0_1_0_1_1_0_);
			tp1 = inline_F213_3617(ti4_2);
			F766_10799(RTCW(tr1), tp1, ((EIF_INTEGER_32) 0L));
			/* END INLINED CODE */
		}
		tr2 = tr1;
		loc2 = F2931_33584(Current, tr2);
		{
			/* INLINED CODE (ARRAY.put) */
			tr1 = *(EIF_REFERENCE *)(RTCW(Result));
			ti4_2 = *(EIF_INTEGER_32 *)(RTCW(Result) + O12501[Dtype(Result)-1558]);
			/* INLINED CODE (SPECIAL.put) */
			*((EIF_REFERENCE *)RTCW(tr1) + ((EIF_INTEGER_32) (loc1 - ti4_2))) = loc2;
			RTAR(tr1,loc2);
			/* END INLINED CODE */;
			/* END INLINED CODE */
		}
		;
		loc1++;
	}
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_value_decimal_separator */
EIF_REFERENCE F2931_33568 (EIF_REFERENCE Current)
{
	GTCX
	EIF_POINTER tp1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Result);
	RTLIU(1);
	
	RTGC;
	Result = RTLNS(eif_new_type(2221, 0x00).id, 2221, _OBJSIZ_1_1_0_3_0_0_0_0_);
	tp1 = (EIF_POINTER) localeconv();
	tp1 = (EIF_POINTER) (((struct lconv *)tp1)->decimal_point);
	F2220_21836(RTCW(Result), tp1);
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_value_group_separator */
EIF_REFERENCE F2931_33569 (EIF_REFERENCE Current)
{
	GTCX
	EIF_POINTER tp1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Result);
	RTLIU(1);
	
	RTGC;
	Result = RTLNS(eif_new_type(2221, 0x00).id, 2221, _OBJSIZ_1_1_0_3_0_0_0_0_);
	tp1 = (EIF_POINTER) localeconv();
	tp1 = (EIF_POINTER) (((struct lconv *)tp1)->thousands_sep);
	F2220_21836(RTCW(Result), tp1);
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_value_grouping */
EIF_REFERENCE F2931_33570 (EIF_REFERENCE Current)
{
	GTCX
	EIF_POINTER tp1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,Result);
	RTLIU(2);
	
	RTGC;
	tp1 = (EIF_POINTER) localeconv();
	tp1 = (EIF_POINTER) (((struct lconv *)tp1)->grouping);
	Result = F2931_33582(Current, tp1);
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_currency_symbol */
EIF_REFERENCE F2931_33571 (EIF_REFERENCE Current)
{
	GTCX
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,tr2);
	RTLR(3,Result);
	RTLIU(4);
	
	RTGC;
	ti4_1 = inline_F214_3668();
	{
		/* INLINED CODE (I18N_UNIX_C_FUNCTIONS.unix_get_locale_info_managed) */
		tr1 = (EIF_REFERENCE)  0;
		tr1 = RTLNS(eif_new_type(765, 0x00).id, 765, _OBJSIZ_0_1_0_1_0_1_1_0_);
		tp1 = inline_F213_3617(ti4_1);
		F766_10799(RTCW(tr1), tp1, ((EIF_INTEGER_32) 0L));
		/* END INLINED CODE */
	}
	tr2 = tr1;
	Result = F2931_33584(Current, tr2);
	{
		/* INLINED CODE (STRING_32.remove_head) */
		ti4_1 = ((EIF_INTEGER_32) 1L);
		if ((EIF_BOOLEAN) (ti4_1 > *(EIF_INTEGER_32 *)(RTCW(Result)+ _LNGOFF_1_1_0_2_))) {
			*(EIF_INTEGER_32 *)(RTCW(Result)+ _LNGOFF_1_1_0_2_) = (EIF_INTEGER_32) ((EIF_INTEGER_32) 0L);
			F2215_21637(RTCW(Result));
		} else {
			F2222_21928(RTCW(Result), (EIF_INTEGER_32) (*(EIF_INTEGER_32 *)(RTCW(Result)+ _LNGOFF_1_1_0_2_) - ti4_1));
		}
		/* END INLINED CODE */
	}
	;
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_currency_symbol_location */
EIF_INTEGER_32 F2931_33572 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_CHARACTER_32 tw1;
	EIF_CHARACTER_32 tw2;
	EIF_BOOLEAN tb1;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,tr2);
	RTLIU(4);
	
	RTGC;
	ti4_1 = inline_F214_3668();
	{
		/* INLINED CODE (I18N_UNIX_C_FUNCTIONS.unix_get_locale_info_managed) */
		tr1 = (EIF_REFERENCE)  0;
		tr1 = RTLNS(eif_new_type(765, 0x00).id, 765, _OBJSIZ_0_1_0_1_0_1_1_0_);
		tp1 = inline_F213_3617(ti4_1);
		F766_10799(RTCW(tr1), tp1, ((EIF_INTEGER_32) 0L));
		/* END INLINED CODE */
	}
	tr2 = tr1;
	loc1 = F2931_33584(Current, tr2);
	{
		/* INLINED CODE (FINITE.is_empty) */
		tb1 = (EIF_BOOLEAN)  0;
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_);
		tb1 = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 0L));
		/* END INLINED CODE */
	}
	tb1 = tb1;
	if ((EIF_BOOLEAN) !tb1) {
		{
			/* INLINED CODE (STRING_32.item) */
			ti4_1 = ((EIF_INTEGER_32) 1L);
			tw1 = (EIF_CHARACTER_32)  0;
			tr1 = *(EIF_REFERENCE *)(RTCW(loc1));
			tw1 = 
				/* INLINED CODE (SPECIAL.item) */
				*((EIF_CHARACTER_32 *)RTCW(tr1) + ((EIF_INTEGER_32) (ti4_1 - ((EIF_INTEGER_32) 1L))))
				/* END INLINED CODE */;
			/* END INLINED CODE */
		}
		tw1 = tw1;
		tw2 = (EIF_CHARACTER_32) (EIF_CHARACTER_8) '-';
		tb1 = tw1 == tw2;
		if (tb1) {
			RTLE;
			return (EIF_INTEGER_32) ((EIF_INTEGER_32) 0L);
		} else {
			{
				/* INLINED CODE (STRING_32.item) */
				ti4_1 = ((EIF_INTEGER_32) 1L);
				tw1 = (EIF_CHARACTER_32)  0;
				tr1 = *(EIF_REFERENCE *)(RTCW(loc1));
				tw1 = 
					/* INLINED CODE (SPECIAL.item) */
					*((EIF_CHARACTER_32 *)RTCW(tr1) + ((EIF_INTEGER_32) (ti4_1 - ((EIF_INTEGER_32) 1L))))
					/* END INLINED CODE */;
				/* END INLINED CODE */
			}
			tw1 = tw1;
			tw2 = (EIF_CHARACTER_32) (EIF_CHARACTER_8) '+';
			tb1 = tw1 == tw2;
			if (tb1) {
				Result = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
			} else {
				{
					/* INLINED CODE (STRING_32.item) */
					ti4_1 = ((EIF_INTEGER_32) 1L);
					tw1 = (EIF_CHARACTER_32)  0;
					tr1 = *(EIF_REFERENCE *)(RTCW(loc1));
					tw1 = 
						/* INLINED CODE (SPECIAL.item) */
						*((EIF_CHARACTER_32 *)RTCW(tr1) + ((EIF_INTEGER_32) (ti4_1 - ((EIF_INTEGER_32) 1L))))
						/* END INLINED CODE */;
					/* END INLINED CODE */
				}
				tw1 = tw1;
				tw2 = (EIF_CHARACTER_32) (EIF_CHARACTER_8) '.';
				tb1 = tw1 == tw2;
				if (tb1) {
					RTLE;
					return (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
				} else {
					RTLE;
					return (EIF_INTEGER_32) ((EIF_INTEGER_32) 0L);
				}
			}
		}
	} else {
		RTLE;
		return (EIF_INTEGER_32) ((EIF_INTEGER_32) 0L);
	}
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_currency_decimal_separator */
EIF_REFERENCE F2931_33573 (EIF_REFERENCE Current)
{
	GTCX
	EIF_POINTER tp1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Result);
	RTLIU(1);
	
	RTGC;
	Result = RTLNS(eif_new_type(2221, 0x00).id, 2221, _OBJSIZ_1_1_0_3_0_0_0_0_);
	tp1 = (EIF_POINTER) localeconv();
	tp1 = (EIF_POINTER) (((struct lconv *)tp1)->mon_decimal_point);
	F2220_21836(RTCW(Result), tp1);
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_currency_numbers_after_decimal_separator */
EIF_INTEGER_32 F2931_33574 (EIF_REFERENCE Current)
{
	GTCX
	EIF_POINTER tp1;
	EIF_NATURAL_32 tu4_1;
	EIF_CHARACTER_8 tc1;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	
	
	RTGC;
	tp1 = (EIF_POINTER) localeconv();
	tc1 = (EIF_CHARACTER_8) (((struct lconv *)tp1)->frac_digits);
	tu4_1 = (EIF_NATURAL_32) tc1;
	Result = (EIF_INTEGER_32) tu4_1;
	if ((EIF_BOOLEAN)(Result == ((EIF_INTEGER_32) 255L))) {
		return (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
	}
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_currency_group_separator */
EIF_REFERENCE F2931_33575 (EIF_REFERENCE Current)
{
	GTCX
	EIF_POINTER tp1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Result);
	RTLIU(1);
	
	RTGC;
	Result = RTLNS(eif_new_type(2221, 0x00).id, 2221, _OBJSIZ_1_1_0_3_0_0_0_0_);
	tp1 = (EIF_POINTER) localeconv();
	tp1 = (EIF_POINTER) (((struct lconv *)tp1)->mon_thousands_sep);
	F2220_21836(RTCW(Result), tp1);
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_currency_positive_sign */
EIF_REFERENCE F2931_33576 (EIF_REFERENCE Current)
{
	GTCX
	EIF_POINTER tp1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Result);
	RTLIU(1);
	
	RTGC;
	Result = RTLNS(eif_new_type(2221, 0x00).id, 2221, _OBJSIZ_1_1_0_3_0_0_0_0_);
	tp1 = (EIF_POINTER) localeconv();
	tp1 = (EIF_POINTER) (((struct lconv *)tp1)->positive_sign);
	F2220_21836(RTCW(Result), tp1);
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_currency_negative_sign */
EIF_REFERENCE F2931_33577 (EIF_REFERENCE Current)
{
	GTCX
	EIF_POINTER tp1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Result);
	RTLIU(1);
	
	RTGC;
	Result = RTLNS(eif_new_type(2221, 0x00).id, 2221, _OBJSIZ_1_1_0_3_0_0_0_0_);
	tp1 = (EIF_POINTER) localeconv();
	tp1 = (EIF_POINTER) (((struct lconv *)tp1)->negative_sign);
	F2220_21836(RTCW(Result), tp1);
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_currency_grouping */
EIF_REFERENCE F2931_33578 (EIF_REFERENCE Current)
{
	GTCX
	EIF_POINTER tp1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,Result);
	RTLIU(2);
	
	RTGC;
	tp1 = (EIF_POINTER) localeconv();
	tp1 = (EIF_POINTER) (((struct lconv *)tp1)->mon_grouping);
	Result = F2931_33582(Current, tp1);
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_code_page */
EIF_REFERENCE F2931_33579 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,tr1);
	RTLR(2,Current);
	RTLR(3,Result);
	RTLIU(4);
	
	RTGC;
	loc1 = RTLNS(eif_new_type(877, 0x00).id, 877, _OBJSIZ_1_0_0_1_0_0_0_0_);
	tp1 = inline_F213_3619();
	F878_12744(RTCW(loc1), tp1);
	tr1 = *(EIF_REFERENCE *)(RTCW(loc1));
	Result = F2931_33584(Current, tr1);
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_int_currency_symbol */
EIF_REFERENCE F2931_33580 (EIF_REFERENCE Current)
{
	GTCX
	EIF_POINTER tp1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Result);
	RTLIU(1);
	
	RTGC;
	Result = RTLNS(eif_new_type(2221, 0x00).id, 2221, _OBJSIZ_1_1_0_3_0_0_0_0_);
	tp1 = (EIF_POINTER) localeconv();
	tp1 = (EIF_POINTER) (((struct lconv *)tp1)->int_curr_symbol);
	F2220_21836(RTCW(Result), tp1);
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.get_int_currency_numbers_after_decimal_separator */
EIF_INTEGER_32 F2931_33581 (EIF_REFERENCE Current)
{
	GTCX
	EIF_POINTER tp1;
	EIF_NATURAL_32 tu4_1;
	EIF_CHARACTER_8 tc1;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	
	
	RTGC;
	tp1 = (EIF_POINTER) localeconv();
	tc1 = (EIF_CHARACTER_8) (((struct lconv *)tp1)->int_frac_digits);
	tu4_1 = (EIF_NATURAL_32) tc1;
	Result = (EIF_INTEGER_32) tu4_1;
	if ((EIF_BOOLEAN)(Result == ((EIF_INTEGER_32) 255L))) {
		return (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
	}
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.pointer_to_array */
EIF_REFERENCE F2931_33582 (EIF_REFERENCE Current, EIF_POINTER arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc3 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_NATURAL_32 tu4_1;
	EIF_CHARACTER_32 tw1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,Result);
	RTLR(3,tr1);
	RTLIU(4);
	
	RTGC;
	loc1 = RTLNS(eif_new_type(2221, 0x00).id, 2221, _OBJSIZ_1_1_0_3_0_0_0_0_);
	F2220_21836(RTCW(loc1), arg1);
	{
		static EIF_TYPE_INDEX typarr0[] = {1560,2020,0xFFFF};
		EIF_TYPE typres0;
		static EIF_TYPE typcache0 = {INVALID_DTYPE, 0};
		
		typres0 = (typcache0.id != INVALID_DTYPE ? typcache0 : (typcache0 = eif_compound_id(Dftype(Current), typarr0)));
		Result = RTLNS(typres0.id, 1560, _OBJSIZ_1_1_0_2_0_0_0_0_);
	}
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_);
	F1561_15130(RTCW(Result), ((EIF_INTEGER_32) 0L), ((EIF_INTEGER_32) 1L), ti4_1);
	loc2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
	for (;;) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_);
		if ((EIF_BOOLEAN) (loc2 > ti4_1)) break;
		tw1 = F2222_21911(RTCW(loc1), loc2);
		tu4_1 = (EIF_NATURAL_32) tw1;
		loc3 = (EIF_INTEGER_32) tu4_1;
		if ((EIF_BOOLEAN)(loc3 == ((EIF_INTEGER_32) 255L))) {
			loc2 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_);
		} else {
			{
				/* INLINED CODE (ARRAY.put) */
				tr1 = *(EIF_REFERENCE *)(RTCW(Result));
				/* INLINED CODE (SPECIAL.put) */
				*((EIF_INTEGER_32 *)RTCW(tr1) + ((EIF_INTEGER_32) (loc2 - *(EIF_INTEGER_32 *)(RTCW(Result)+ _LNGOFF_1_1_0_1_)))) = loc3;
				/* END INLINED CODE */;
				/* END INLINED CODE */
			}
			;
		}
		loc2++;
	}
	if ((EIF_BOOLEAN)(loc3 != ((EIF_INTEGER_32) 255L))) {
		F1561_15156(RTCW(Result), ((EIF_INTEGER_32) 0L), loc2);
	}
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.c_is_solaris */
EIF_BOOLEAN F2931_33583 (EIF_REFERENCE Current)
{
	GTCX
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	
	
	Result = EIF_TEST(inline_F2931_33583 ());
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.utf8_pointer_to_string */
EIF_REFERENCE F2931_33584 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(5);
	RTLR(0,loc1);
	RTLR(1,arg1);
	RTLR(2,tr1);
	RTLR(3,Current);
	RTLR(4,Result);
	RTLIU(5);
	
	RTGC;
	loc1 = RTLNS(eif_new_type(877, 0x00).id, 877, _OBJSIZ_1_0_0_1_0_0_0_0_);
	tp1 = *(EIF_POINTER *)(RTCW(arg1)+ _PTROFF_0_1_0_1_0_0_);
	F878_12744(RTCW(loc1), tp1);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_0_0_0_);
	if ((EIF_BOOLEAN) (ti4_1 > ((EIF_INTEGER_32) 0L))) {
		{
			/* INLINED CODE (C_STRING.string) */
			tr1 = (EIF_REFERENCE)  0;
			tp1 = F878_12759(RTCW(loc1));
			ti4_1 = (EIF_INTEGER_32) strlen((char*) tp1);
			tr1 = F878_12752(RTCW(loc1), ((EIF_INTEGER_32) 1L), ti4_1);
			/* END INLINED CODE */
		}
		tr1 = tr1;
		Result = F2929_33539(Current, tr1);
	} else {
		Result = RTLNS(eif_new_type(2221, 0x00).id, 2221, _OBJSIZ_1_1_0_3_0_0_0_0_);
		F2213_21539(RTCW(Result));
		RTLE;
		return (EIF_REFERENCE) Result;
	}
	RTLE;
	return Result;
}

/* {I18N_HOST_LOCALE_IMP}.guess_proper_locale */
EIF_REFERENCE F2931_33585 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_POINTER loc2 = (EIF_POINTER) 0;
	EIF_POINTER loc3 = (EIF_POINTER) 0;
	EIF_REFERENCE loc4 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc5 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc6 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc7 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	RTLD;
	
	RTLI(8);
	RTLR(0,arg1);
	RTLR(1,loc1);
	RTLR(2,tr1);
	RTLR(3,loc5);
	RTLR(4,loc4);
	RTLR(5,loc7);
	RTLR(6,loc6);
	RTLR(7,Current);
	RTLIU(8);
	
	RTGC;
	tb1 = F2216_21703(RTCW(arg1), (EIF_CHARACTER_8) '_');
	if (tb1) {
		loc1 = RTLNS(eif_new_type(877, 0x00).id, 877, _OBJSIZ_1_0_0_1_0_0_0_0_);
		F878_12740(RTCW(loc1), arg1);
		ti4_1 = inline_F213_3623();
		{
			/* INLINED CODE (C_STRING.item) */
			tp1 = (EIF_POINTER)  0;
			tr1 = *(EIF_REFERENCE *)(RTCW(loc1));
			tp1 = *(EIF_POINTER *)(RTCW(tr1)+ _PTROFF_0_1_0_1_0_0_);
			/* END INLINED CODE */
		}
		tp1 = tp1;
		loc2 = inline_F213_3622(ti4_1, tp1);
		if ((EIF_BOOLEAN)(loc2 == loc3)) {
			{
				/* INLINED CODE (STRING_8.as_lower) */
				tr1 = (EIF_REFERENCE)  0;
				tr1 = (EIF_REFERENCE) eif_builtin_ANY_twin (arg1);
				F2218_21820(RTCW(tr1));
				/* END INLINED CODE */
			}
			loc5 = tr1;
			loc1 = RTLNS(eif_new_type(877, 0x00).id, 877, _OBJSIZ_1_0_0_1_0_0_0_0_);
			tr1 = RTMS_EX_H("",0,0);
			F878_12740(RTCW(loc1), tr1);
			ti4_1 = inline_F213_3623();
			{
				/* INLINED CODE (C_STRING.item) */
				tp1 = (EIF_POINTER)  0;
				tr1 = *(EIF_REFERENCE *)(RTCW(loc1));
				tp1 = *(EIF_POINTER *)(RTCW(tr1)+ _PTROFF_0_1_0_1_0_0_);
				/* END INLINED CODE */
			}
			tp1 = tp1;
			loc2 = inline_F213_3622(ti4_1, tp1);
			if ((EIF_BOOLEAN)(loc2 != loc3)) {
				loc1 = RTLNS(eif_new_type(877, 0x00).id, 877, _OBJSIZ_1_0_0_1_0_0_0_0_);
				F878_12744(RTCW(loc1), loc2);
				{
					/* INLINED CODE (C_STRING.string) */
					tr1 = (EIF_REFERENCE)  0;
					tp1 = F878_12759(RTCW(loc1));
					ti4_1 = (EIF_INTEGER_32) strlen((char*) tp1);
					tr1 = F878_12752(RTCW(loc1), ((EIF_INTEGER_32) 1L), ti4_1);
					/* END INLINED CODE */
				}
				loc4 = tr1;
				{
					/* INLINED CODE (STRING_8.as_lower) */
					tr1 = (EIF_REFERENCE)  0;
					tr1 = (EIF_REFERENCE) eif_builtin_ANY_twin (loc4);
					F2218_21820(RTCW(tr1));
					/* END INLINED CODE */
				}
				tr1 = tr1;
				tb1 = F2213_21583(RTCW(tr1), loc5);
				if (tb1) {
					loc7 = (EIF_REFERENCE) loc4;
				}
			}
			if ((EIF_BOOLEAN)(loc7 == NULL)) {
				loc6 = F2931_33549(Current);
				{
					/* INLINED CODE (LINKED_LIST.start) */
					if ((EIF_BOOLEAN)(*(EIF_REFERENCE *)(RTCW(loc6)) != NULL)) {
						tr1 = *(EIF_REFERENCE *)(RTCW(loc6));
						RTAR(loc6, tr1);
						*(EIF_REFERENCE *)(RTCW(loc6) + _REFACS_1_) = (EIF_REFERENCE) tr1;
						*(EIF_BOOLEAN *)(RTCW(loc6) + O12270[Dtype(loc6)-1496]) = (EIF_BOOLEAN) (EIF_BOOLEAN) 0;
					} else {
						*(EIF_BOOLEAN *)(RTCW(loc6) + O12270[Dtype(loc6)-1496]) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
					}
					*(EIF_BOOLEAN *)(RTCW(loc6) + O12269[Dtype(loc6)-1496]) = (EIF_BOOLEAN) (EIF_BOOLEAN) 0;
					/* END INLINED CODE */
				}
				;
				for (;;) {
					tb1 = '\01';
					tb2 = *(EIF_BOOLEAN *)(RTCW(loc6) + O12270[Dtype(loc6)-1496]);
					if (!tb2) {
						tb1 = (EIF_BOOLEAN)(loc7 != NULL);
					}
					if (tb1) break;
					tr1 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE)) R11911[Dtype(RTCW(loc6))-1301])(loc6);
					tr1 = *(EIF_REFERENCE *)(RTCW(tr1) + _REFACS_1_);
					loc4 = F2213_21595(RTCW(tr1));
					{
						/* INLINED CODE (STRING_8.as_lower) */
						tr1 = (EIF_REFERENCE)  0;
						tr1 = (EIF_REFERENCE) eif_builtin_ANY_twin (loc4);
						F2218_21820(RTCW(tr1));
						/* END INLINED CODE */
					}
					tr1 = tr1;
					tb2 = F2213_21583(RTCW(tr1), loc5);
					if (tb2) {
						loc7 = (EIF_REFERENCE) loc4;
					}
					(FUNCTION_CAST(void, (EIF_REFERENCE)) R11855[Dtype(RTCW(loc6))-1210])(loc6);
				}
			}
		}
	}
	if ((EIF_BOOLEAN)(loc7 == NULL)) {
		RTLE;
		return (EIF_REFERENCE) arg1;
	} else {
		RTLE;
		return (EIF_REFERENCE) loc7;
	}/* NOTREACHED */
	
}

void EIF_Minit1977 (void)
{
	GTCX
}


#ifdef __cplusplus
}
#endif
