/*
 * Code for class PATH
 */

#include "eif_eiffel.h"
#include "../E1/estructure.h"
#include "../E1/eoffsets.h"

#include "pa1252.h"
#include "eif_eiffel.h"
#include "eif_built_in.h"
#include "eif_path_name.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifndef INLINE_F2102_21784
static int inline_F2102_21784 (EIF_POINTER arg1, EIF_POINTER arg2)
{
	EIF_BOOLEAN Result = EIF_FALSE;
#ifdef EIF_WINDOWS
		/* To check this, we use `CreateFileW' to open both file, and then using the information
		 * returned by `GetFileInformationByHandle' we can check whether or not they are indeed
		 * the same.
		 * Note: it is important to use the W version of CreateFileW because arguments
		 * are Unicode, not ASCII. */
	BY_HANDLE_FILE_INFORMATION l_path1_info, l_path2_info;
	HANDLE l_path2_file = CreateFileW ((LPCWSTR) arg2, GENERIC_READ, FILE_SHARE_READ, NULL,
		OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
	HANDLE l_path1_file = CreateFileW ((LPCWSTR) arg1, GENERIC_READ, FILE_SHARE_READ, NULL,
			OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);

	if ((l_path2_file == INVALID_HANDLE_VALUE) || (l_path1_file == INVALID_HANDLE_VALUE)) {
			/* We do not need the handles anymore, simply close them. Since Microsoft
			 * API accepts INVALID_HANDLE_VALUE we don't check the validity of arguments. */
		CloseHandle(l_path2_file);
		CloseHandle(l_path1_file);
	} else {
		BOOL success = GetFileInformationByHandle (l_path2_file, &l_path2_info);
		success = success && GetFileInformationByHandle (l_path1_file, &l_path1_info);
			/* We do not need the handles anymore, simply close them. */
		CloseHandle(l_path2_file);
		CloseHandle(l_path1_file);
		if (success) {
				/* Check that `path2' and `path1' do not represent the same file. */
			if
				((l_path2_info.dwVolumeSerialNumber == l_path1_info.dwVolumeSerialNumber) &&
				(l_path2_info.nFileIndexLow == l_path1_info.nFileIndexLow) &&
				(l_path2_info.nFileIndexHigh == l_path1_info.nFileIndexHigh))
			{
				Result = EIF_TRUE;
			}
		}
	}
#else
	struct stat buf1, buf2;
	int status;
	#ifdef HAS_LSTAT
		status = lstat(arg1, &buf1);
		if (status == 0) {
				/* We found a file, now let's check if it is not a symbolic link. If it is, we use `stat'
			 	 * to ensure the validity of the link. */
			if ((buf1.st_mode & S_IFLNK) == S_IFLNK) {
				status = stat (arg1, &buf1);
			}
		}
		
		if (status == 0) {
			status = lstat(arg2, &buf2);
			if (status == 0) {
					/* We found a file, now let's check if it is not a symbolic link. If it is, we use `stat'
				 	 * to ensure the validity of the link. */
				if ((buf2.st_mode & S_IFLNK) == S_IFLNK) {
					status = stat (arg2, &buf2);
				}
			}
		}
	#else
		status = stat (arg1, &buf1);
		if (status == 0) {
			status = stat (arg2, &buf2);
		}
	#endif
	if (status == 0) {
			/* Both files are present, check they represent the same one. */
		if ((buf1.st_dev == buf2.st_dev) && (buf1.st_ino == buf2.st_ino)) {
			Result = EIF_TRUE;
		}
	}
#endif
return Result;
	;
}
#define INLINE_F2102_21784
#endif

#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
extern "C" {
#endif

/* {PATH}.make_empty */
void F2102_21723 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTGC;
	tr1 = RTLNSMART(eif_new_type(2071, 0).id);
	F2067_20682(RTCW(tr1));
	RTAR(Current, tr1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	*(EIF_BOOLEAN *)(Current+ _CHROFF_2_0_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	{
		/* INLINED CODE (PATH.reset_internal_data) */
		*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) NULL;
		/* END INLINED CODE */
	}
	;
	RTLE;
}

/* {PATH}.make_current */
void F2102_21724 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTGC;
	tr1 = RTLNSMART(eif_new_type(2071, 0).id);
	ti4_1 = F2102_21769(Current);
	F2070_20812(RTCW(tr1), ti4_1);
	RTAR(Current, tr1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	tr1 = *(EIF_REFERENCE *)(Current);
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R17250[Dtype(RTCW(tr1))-2071])(tr1, (EIF_CHARACTER_8) '.');
	if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
		tr1 = *(EIF_REFERENCE *)(Current);
		(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R17250[Dtype(RTCW(tr1))-2071])(tr1, (EIF_CHARACTER_8) '\000');
	}
	*(EIF_BOOLEAN *)(Current+ _CHROFF_2_0_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	{
		/* INLINED CODE (PATH.reset_internal_data) */
		*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) NULL;
		/* END INLINED CODE */
	}
	;
	RTLE;
}

/* {PATH}.make_from_string */
void F2102_21725 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	RTLD;
	
	RTLI(3);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,arg1);
	RTLIU(3);
	
	RTGC;
	tr1 = RTLNSMART(eif_new_type(2071, 0).id);
	ti4_1 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R17099[Dtype(RTCW(arg1))-2070])(arg1);
	ti4_2 = F2102_21769(Current);
	F2070_20812(RTCW(tr1), (EIF_INTEGER_32) (ti4_1 * ti4_2));
	RTAR(Current, tr1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	tb1 = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE)) R17077[Dtype(RTCW(arg1))-2070])(arg1);
	if ((EIF_BOOLEAN) !tb1) {
		F2102_21778(Current, *(EIF_REFERENCE *)(Current), arg1, (EIF_CHARACTER_8) '\000');
		F2102_21771(Current);
	} else {
		*(EIF_BOOLEAN *)(Current+ _CHROFF_2_0_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	}
	{
		/* INLINED CODE (PATH.reset_internal_data) */
		*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) NULL;
		/* END INLINED CODE */
	}
	;
	RTLE;
}

/* {PATH}.make_from_storage */
void F2102_21727 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,arg1);
	RTLIU(2);
	
	RTGC;
	RTAR(Current, arg1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) arg1;
	F2102_21771(Current);
	{
		/* INLINED CODE (PATH.reset_internal_data) */
		*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) NULL;
		/* END INLINED CODE */
	}
	;
	RTLE;
}

/* {PATH}.make_from_normalized_storage */
void F2102_21728 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,arg1);
	RTLIU(2);
	
	RTGC;
	RTAR(Current, arg1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) arg1;
	*(EIF_BOOLEAN *)(Current+ _CHROFF_2_0_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	{
		/* INLINED CODE (PATH.reset_internal_data) */
		*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) NULL;
		/* END INLINED CODE */
	}
	;
	RTLE;
}

/* {PATH}.make_from_pointer */
void F2102_21729 (EIF_REFERENCE Current, EIF_POINTER arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	RTLD;
	
	RTLI(3);
	RTLR(0,Current);
	RTLR(1,loc1);
	RTLR(2,tr1);
	RTLIU(3);
	
	RTGC;
	loc2 = F913_12964(Current, arg1);
	{
		/* INLINED CODE (PATH.unit_size) */
		ti4_1 = (EIF_INTEGER_32)  0;
		tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
		if (tb1) {
			ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
		} else {
			ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
		}
		/* END INLINED CODE */
	}
	loc2 -= (EIF_INTEGER_32) (loc2 % ti4_1);
	loc1 = RTLNS(eif_new_type(1047, 0x00).id, 1047, _OBJSIZ_1_0_0_1_0_0_0_0_);
	F1048_14933(RTCW(loc1), arg1, loc2);
	tr1 = F1048_14941(RTCW(loc1), ((EIF_INTEGER_32) 1L), loc2);
	RTAR(Current, tr1);
	*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	tr1 = *(EIF_REFERENCE *)(Current);
	{
		/* INLINED CODE (FINITE.is_empty) */
		tb1 = (EIF_BOOLEAN)  0;
		(void) RTCW(tr1);
		ti4_1 = *(EIF_INTEGER_32 *)(tr1+ _LNGOFF_1_1_0_2_);
		tb1 = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 0L));
		/* END INLINED CODE */
	}
	tb1 = tb1;
	if ((EIF_BOOLEAN) !tb1) {
		F2102_21771(Current);
	}
	{
		/* INLINED CODE (PATH.reset_internal_data) */
		*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) NULL;
		/* END INLINED CODE */
	}
	;
	RTLE;
}

/* {PATH}.is_current_symbol */
EIF_BOOLEAN F2102_21730 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
	{
		/* INLINED CODE (PATH.unit_size) */
		ti4_2 = (EIF_INTEGER_32)  0;
		tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
		if (tb1) {
			ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
		} else {
			ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
		}
		/* END INLINED CODE */
	}
	if ((EIF_BOOLEAN)(ti4_1 == ti4_2)) {
		RTLE;
		return (EIF_BOOLEAN) F2102_21781(Current, *(EIF_REFERENCE *)(Current), ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '.');
	}
	RTLE;
	return (EIF_BOOLEAN) 0;
}

/* {PATH}.is_parent_symbol */
EIF_BOOLEAN F2102_21731 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
	{
		/* INLINED CODE (PATH.unit_size) */
		ti4_2 = (EIF_INTEGER_32)  0;
		tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
		if (tb1) {
			ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
		} else {
			ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
		}
		/* END INLINED CODE */
	}
	if ((EIF_BOOLEAN)(ti4_1 == (EIF_INTEGER_32) (((EIF_INTEGER_32) 2L) * ti4_2))) {
		Result = F2102_21781(Current, *(EIF_REFERENCE *)(Current), ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '.');
		tr1 = *(EIF_REFERENCE *)(Current);
		{
			/* INLINED CODE (PATH.unit_size) */
			ti4_1 = (EIF_INTEGER_32)  0;
			tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
			if (tb1) {
				ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
			} else {
				ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
			}
			/* END INLINED CODE */
		}
		ti4_2 = ti4_1;
		Result = F2102_21781(Current, tr1, (EIF_INTEGER_32) (((EIF_INTEGER_32) 1L) + ti4_2), (EIF_CHARACTER_8) '.');
	}
	RTLE;
	return Result;
}

/* {PATH}.has_root */
EIF_BOOLEAN F2102_21732 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTGC;
	ti4_1 = F2102_21775(Current);
	Result = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 != ((EIF_INTEGER_32) 0L));
	RTLE;
	return Result;
}

/* {PATH}.is_empty */
EIF_BOOLEAN F2102_21733 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current);
	{
		/* INLINED CODE (FINITE.is_empty) */
		tb1 = (EIF_BOOLEAN)  0;
		(void) RTCW(tr1);
		ti4_1 = *(EIF_INTEGER_32 *)(tr1+ _LNGOFF_1_1_0_2_);
		tb1 = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 0L));
		/* END INLINED CODE */
	}
	Result = tb1;
	RTLE;
	return Result;
}

/* {PATH}.is_relative */
EIF_BOOLEAN F2102_21734 (EIF_REFERENCE Current)
{
	GTCX
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTGC;
	Result = F2102_21735(Current);
	Result = (EIF_BOOLEAN) (EIF_BOOLEAN) !Result;
	RTLE;
	return Result;
}

/* {PATH}.is_absolute */
EIF_BOOLEAN F2102_21735 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_CHARACTER_8 tc1;
	EIF_CHARACTER_8 tc2;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTGC;
	loc1 = F2102_21775(Current);
	if ((EIF_BOOLEAN) (loc1 > ((EIF_INTEGER_32) 0L))) {
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
			tr1 = *(EIF_REFERENCE *)(Current);
			{
				/* INLINED CODE (PATH.unit_size) */
				ti4_1 = (EIF_INTEGER_32)  0;
				tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
				if (tb1) {
					ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
				} else {
					ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
				}
				/* END INLINED CODE */
			}
			ti4_2 = ti4_1;
			{
				/* INLINED CODE (PATH.directory_separator) */
				tc1 = (EIF_CHARACTER_8)  0;
				tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
				if (tb1) {
					tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
				} else {
					tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
				}
				/* END INLINED CODE */
			}
			tc2 = tc1;
			Result = F2102_21781(Current, tr1, (EIF_INTEGER_32) ((EIF_INTEGER_32) (loc1 - ti4_2) + ((EIF_INTEGER_32) 1L)), tc2);
		} else {
			RTLE;
			return (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
		}
	}
	RTLE;
	return Result;
}

/* {PATH}.is_same_file_as */
EIF_BOOLEAN F2102_21737 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_POINTER tp1;
	EIF_POINTER tp2;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,loc2);
	RTLR(3,arg1);
	RTLIU(4);
	
	RTGC;
	loc1 = F2102_21766(Current);
	loc2 = F2102_21766(RTCW(arg1));
	tp1 = *(EIF_POINTER *)(RTCW(loc1)+ _PTROFF_0_1_0_1_0_0_);
	tp2 = *(EIF_POINTER *)(RTCW(loc2)+ _PTROFF_0_1_0_1_0_0_);
	Result = EIF_TEST (inline_F2102_21784(tp1, tp2));
	RTLE;
	return Result;
}

/* {PATH}.has_extension */
EIF_BOOLEAN F2102_21738 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,arg1);
	RTLIU(4);
	
	RTGC;
	Result = '\0';
	tr1 = F2102_21742(Current);
	loc1 = tr1;
	if (EIF_TEST(loc1)) {
		tb1 = F2067_20724(loc1, arg1);
		Result = tb1;
	}
	RTLE;
	return Result;
}

/* {PATH}.root */
EIF_REFERENCE F2102_21739 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(3);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,Result);
	RTLIU(3);
	
	RTGC;
	loc1 = F2102_21775(Current);
	if ((EIF_BOOLEAN)(loc1 != ((EIF_INTEGER_32) 0L))) {
		tr1 = *(EIF_REFERENCE *)(Current);
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
		if ((EIF_BOOLEAN)(loc1 == ti4_1)) {
			tr1 = RTLNS(eif_new_type(2101, 0x00).id, 2101, _OBJSIZ_2_1_0_0_0_0_0_0_);
			F2102_21728(RTCW(tr1), *(EIF_REFERENCE *)(Current));
			RTLE;
			return (EIF_REFERENCE) tr1;
		} else {
			Result = RTLNS(eif_new_type(2101, 0x00).id, 2101, _OBJSIZ_2_1_0_0_0_0_0_0_);
			tr1 = *(EIF_REFERENCE *)(Current);
			tr1 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R17140[Dtype(RTCW(tr1))-2070])(tr1, ((EIF_INTEGER_32) 1L), loc1);
			F2102_21728(RTCW(Result), tr1);
		}
	}
	RTLE;
	return Result;
}

/* {PATH}.parent */
EIF_REFERENCE F2102_21740 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,Current);
	RTLR(1,loc3);
	RTLR(2,tr1);
	RTLR(3,Result);
	RTLIU(4);
	
	RTGC;
	loc1 = F2102_21776(Current);
	if ((EIF_BOOLEAN)(loc1 == ((EIF_INTEGER_32) 0L))) {
		tr1 = F2102_21739(Current);
		loc3 = tr1;
		if (EIF_TEST(loc3)) {
			RTLE;
			return (EIF_REFERENCE) loc3;
		} else {
			tr1 = RTLNS(eif_new_type(2101, 0x00).id, 2101, _OBJSIZ_2_1_0_0_0_0_0_0_);
			F2102_21724(RTCW(tr1));
			RTLE;
			return (EIF_REFERENCE) tr1;
		}
	} else {
		{
			/* INLINED CODE (PATH.unit_size) */
			ti4_1 = (EIF_INTEGER_32)  0;
			tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
			if (tb1) {
				ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
			} else {
				ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
			}
			/* END INLINED CODE */
		}
		if ((EIF_BOOLEAN)(loc1 == ti4_1)) {
			Result = RTLNS(eif_new_type(2101, 0x00).id, 2101, _OBJSIZ_2_1_0_0_0_0_0_0_);
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = F2102_21769(Current);
			tr1 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R17140[Dtype(RTCW(tr1))-2070])(tr1, ((EIF_INTEGER_32) 1L), ti4_1);
			F2102_21728(RTCW(Result), tr1);
		} else {
			loc2 = F2102_21775(Current);
			if ((EIF_BOOLEAN) (loc1 <= loc2)) {
				tr1 = *(EIF_REFERENCE *)(Current);
				ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
				if ((EIF_BOOLEAN)(loc2 == ti4_1)) {
					RTLE;
					return (EIF_REFERENCE) Current;
				} else {
					Result = RTLNS(eif_new_type(2101, 0x00).id, 2101, _OBJSIZ_2_1_0_0_0_0_0_0_);
					tr1 = *(EIF_REFERENCE *)(Current);
					tr1 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R17140[Dtype(RTCW(tr1))-2070])(tr1, ((EIF_INTEGER_32) 1L), loc2);
					F2102_21728(RTCW(Result), tr1);
				}
			} else {
				Result = RTLNS(eif_new_type(2101, 0x00).id, 2101, _OBJSIZ_2_1_0_0_0_0_0_0_);
				tr1 = *(EIF_REFERENCE *)(Current);
				ti4_1 = F2102_21769(Current);
				tr1 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R17140[Dtype(RTCW(tr1))-2070])(tr1, ((EIF_INTEGER_32) 1L), (EIF_INTEGER_32) (loc1 - ti4_1));
				F2102_21728(RTCW(Result), tr1);
			}
		}
	}
	RTLE;
	return Result;
}

/* {PATH}.entry */
EIF_REFERENCE F2102_21741 (EIF_REFERENCE Current)
{
	GTCX
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_BOOLEAN tb4;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,tr2);
	RTLR(3,Result);
	RTLIU(4);
	
	RTGC;
	loc1 = F2102_21776(Current);
	if ((EIF_BOOLEAN)(loc1 == ((EIF_INTEGER_32) 0L))) {
		loc2 = F2102_21775(Current);
		if ((EIF_BOOLEAN) (loc2 > ((EIF_INTEGER_32) 0L))) {
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
			if ((EIF_BOOLEAN) (loc2 < ti4_1)) {
				Result = RTLNS(eif_new_type(2101, 0x00).id, 2101, _OBJSIZ_2_1_0_0_0_0_0_0_);
				tr1 = *(EIF_REFERENCE *)(Current);
				tr2 = *(EIF_REFERENCE *)(Current);
				ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr2)+ _LNGOFF_1_1_0_2_);
				tr1 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R17140[Dtype(RTCW(tr1))-2070])(tr1, (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L)), ti4_1);
				F2102_21728(RTCW(Result), tr1);
			}
		} else {
			Result = (EIF_REFERENCE) Current;
		}
	} else {
		loc2 = F2102_21775(Current);
		if ((EIF_BOOLEAN) (loc1 <= loc2)) {
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
			if ((EIF_BOOLEAN) (loc2 < ti4_1)) {
				Result = RTLNS(eif_new_type(2101, 0x00).id, 2101, _OBJSIZ_2_1_0_0_0_0_0_0_);
				tr1 = *(EIF_REFERENCE *)(Current);
				tr2 = *(EIF_REFERENCE *)(Current);
				ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr2)+ _LNGOFF_1_1_0_2_);
				tr1 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R17140[Dtype(RTCW(tr1))-2070])(tr1, (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L)), ti4_1);
				F2102_21728(RTCW(Result), tr1);
			}
		} else {
			Result = RTLNS(eif_new_type(2101, 0x00).id, 2101, _OBJSIZ_2_1_0_0_0_0_0_0_);
			tr1 = *(EIF_REFERENCE *)(Current);
			tr2 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr2)+ _LNGOFF_1_1_0_2_);
			tr1 = (FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32, EIF_INTEGER_32)) R17140[Dtype(RTCW(tr1))-2070])(tr1, (EIF_INTEGER_32) (loc1 + ((EIF_INTEGER_32) 1L)), ti4_1);
			F2102_21728(RTCW(Result), tr1);
		}
	}
	tb1 = '\0';
	if ((EIF_BOOLEAN)(Result != NULL)) {
		tb2 = '\01';
		tb3 = '\01';
		{
			/* INLINED CODE (PATH.is_empty) */
			tb4 = (EIF_BOOLEAN)  0;
			(void) RTCW(Result);
			tr1 = *(EIF_REFERENCE *)(Result);
			tb4 = F1485_16066(RTCW(tr1));
			/* END INLINED CODE */
		}
		tb4 = tb4;
		if (!tb4) {
			{
				/* INLINED CODE (PATH.is_current_symbol) */
				tb4 = (EIF_BOOLEAN)  0;
				(void) RTCW(Result);
				tr1 = *(EIF_REFERENCE *)(Result);
				ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
				ti4_2 = F2102_21769(Result);
				if ((EIF_BOOLEAN)(ti4_1 == ti4_2)) {
					tb4 = F2102_21781(Result, *(EIF_REFERENCE *)(Result), ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '.');
				}
				/* END INLINED CODE */
			}
			tb4 = tb4;
			tb3 = tb4;
		}
		if (!tb3) {
			tb3 = F2102_21731(RTCW(Result));
			tb2 = tb3;
		}
		tb1 = tb2;
	}
	if (tb1) {
		RTLE;
		return (EIF_REFERENCE) NULL;
	}
	RTLE;
	return Result;
}

/* {PATH}.extension */
EIF_REFERENCE F2102_21742 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc3 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE loc4 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_CHARACTER_32 tw1;
	RTLD;
	
	RTLI(4);
	RTLR(0,loc4);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,loc1);
	RTLIU(4);
	
	RTGC;
	tr1 = F2102_21741(Current);
	loc4 = tr1;
	if (EIF_TEST(loc4)) {
		loc1 = F2102_21764(loc4);
		loc3 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_0_0_2_);
		tw1 = (EIF_CHARACTER_32) (EIF_CHARACTER_8) '.';
		loc2 = F2074_20991(RTCW(loc1), tw1, loc3);
		if ((EIF_BOOLEAN) ((EIF_BOOLEAN)(loc2 != ((EIF_INTEGER_32) 0L)) && (EIF_BOOLEAN)(loc2 != loc3))) {
			tr1 = F2075_21047(RTCW(loc1), (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L)), loc3);
			RTLE;
			return (EIF_REFERENCE) tr1;
		}
	}
	RTLE;
	return (EIF_REFERENCE) 0;
}

/* {PATH}.components */
EIF_REFERENCE F2102_21743 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc3 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,Current);
	RTLR(1,Result);
	RTLR(2,loc1);
	RTLR(3,tr1);
	RTLIU(4);
	
	RTGC;
	{
		static EIF_TYPE_INDEX typarr0[] = {1712,2101,0xFFFF};
		EIF_TYPE typres0;
		static EIF_TYPE typcache0 = {INVALID_DTYPE, 0};
		
		typres0 = (typcache0.id != INVALID_DTYPE ? typcache0 : (typcache0 = eif_compound_id(Dftype(Current), typarr0)));
		Result = RTLNS(typres0.id, 1712, _OBJSIZ_1_1_0_1_0_0_0_0_);
	}
	F1713_16935(RTCW(Result), ((EIF_INTEGER_32) 10L));
	loc3 = F2102_21775(Current);
	if ((EIF_BOOLEAN) (loc3 > ((EIF_INTEGER_32) 0L))) {
		loc1 = RTLNS(eif_new_type(2071, 0x00).id, 2071, _OBJSIZ_1_1_0_3_0_0_0_0_);
		F2070_20812(RTCW(loc1), loc3);
		F2072_20926(RTCW(loc1), *(EIF_REFERENCE *)(Current), ((EIF_INTEGER_32) 1L), loc3);
		tr1 = RTLNS(eif_new_type(2101, 0x00).id, 2101, _OBJSIZ_2_1_0_0_0_0_0_0_);
		F2102_21728(RTCW(tr1), loc1);
		(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R13744[Dtype(RTCW(Result))-1451])(Result, tr1);
		loc3++;
	} else {
		loc3 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
	}
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
	if ((EIF_BOOLEAN) (loc3 <= ti4_1)) {
		loc2 = (EIF_INTEGER_32) loc3;
		loc3 = F2102_21777(Current, loc2);
		for (;;) {
			if ((EIF_BOOLEAN)(loc3 == ((EIF_INTEGER_32) 0L))) break;
			loc1 = RTLNS(eif_new_type(2071, 0x00).id, 2071, _OBJSIZ_1_1_0_3_0_0_0_0_);
			F2070_20812(RTCW(loc1), (EIF_INTEGER_32) (loc3 - loc2));
			F2072_20926(RTCW(loc1), *(EIF_REFERENCE *)(Current), loc2, (EIF_INTEGER_32) (loc3 - ((EIF_INTEGER_32) 1L)));
			tr1 = RTLNS(eif_new_type(2101, 0x00).id, 2101, _OBJSIZ_2_1_0_0_0_0_0_0_);
			F2102_21728(RTCW(tr1), loc1);
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R13744[Dtype(RTCW(Result))-1451])(Result, tr1);
			{
				/* INLINED CODE (PATH.unit_size) */
				ti4_1 = (EIF_INTEGER_32)  0;
				tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
				if (tb1) {
					ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
				} else {
					ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
				}
				/* END INLINED CODE */
			}
			loc2 = ti4_1;
			loc2 = (EIF_INTEGER_32) (EIF_INTEGER_32) (loc3 + loc2);
			loc3 = F2102_21777(Current, loc2);
		}
		tr1 = *(EIF_REFERENCE *)(Current);
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
		if ((EIF_BOOLEAN) (loc2 <= ti4_1)) {
			loc1 = RTLNS(eif_new_type(2071, 0x00).id, 2071, _OBJSIZ_1_1_0_3_0_0_0_0_);
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
			F2070_20812(RTCW(loc1), (EIF_INTEGER_32) (ti4_1 - loc2));
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
			F2072_20926(RTCW(loc1), *(EIF_REFERENCE *)(Current), loc2, ti4_1);
			tr1 = RTLNS(eif_new_type(2101, 0x00).id, 2101, _OBJSIZ_2_1_0_0_0_0_0_0_);
			F2102_21728(RTCW(tr1), loc1);
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R13744[Dtype(RTCW(Result))-1451])(Result, tr1);
		}
	}
	RTLE;
	return Result;
}

/* {PATH}.absolute_path */
EIF_REFERENCE F2102_21744 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(3);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,Result);
	RTLIU(3);
	
	RTGC;
	tr1 = F916_13048(RTCV(RTOSCF(21774,F2102_21774, (Current))));
	Result = F2102_21745(Current, tr1);
	RTLE;
	return Result;
}

/* {PATH}.absolute_path_in */
EIF_REFERENCE F2102_21745 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_REFERENCE tr3 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_CHARACTER_8 tc1;
	EIF_CHARACTER_8 tc2;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	RTLI(8);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,arg1);
	RTLR(3,loc1);
	RTLR(4,Result);
	RTLR(5,tr2);
	RTLR(6,tr3);
	RTLR(7,loc2);
	RTLIU(8);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current);
	{
		/* INLINED CODE (FINITE.is_empty) */
		tb1 = (EIF_BOOLEAN)  0;
		(void) RTCW(tr1);
		ti4_1 = *(EIF_INTEGER_32 *)(tr1+ _LNGOFF_1_1_0_2_);
		tb1 = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 0L));
		/* END INLINED CODE */
	}
	tb1 = tb1;
	if (tb1) {
		RTLE;
		return (EIF_REFERENCE) arg1;
	} else {
		if (F2102_21735(Current)) {
			RTLE;
			return (EIF_REFERENCE) Current;
		} else {
			if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
				tr1 = F2102_21739(Current);
				loc1 = tr1;
				if (EIF_TEST(loc1)) {
					tb1 = '\0';
					tb2 = '\0';
					tr1 = *(EIF_REFERENCE *)(loc1);
					ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
					if ((EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 4L))) {
						tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
						ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
						tb2 = (EIF_BOOLEAN) (ti4_1 >= ((EIF_INTEGER_32) 4L));
					}
					if (tb2) {
						tb2 = '\0';
						tr1 = *(EIF_REFERENCE *)(loc1);
						tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R14092[Dtype(RTCW(tr1))-1618])(tr1, ((EIF_INTEGER_32) 1L)));
						tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
						tc2 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R14092[Dtype(RTCW(tr1))-1618])(tr1, ((EIF_INTEGER_32) 1L)));
						if ((EIF_BOOLEAN)(tc1 == tc2)) {
							tr1 = *(EIF_REFERENCE *)(loc1);
							tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R14092[Dtype(RTCW(tr1))-1618])(tr1, ((EIF_INTEGER_32) 3L)));
							tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
							tc2 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R14092[Dtype(RTCW(tr1))-1618])(tr1, ((EIF_INTEGER_32) 3L)));
							tb2 = (EIF_BOOLEAN)(tc1 == tc2);
						}
						tb1 = tb2;
					}
					if (tb1) {
						Result = (EIF_REFERENCE) eif_builtin_ANY_twin__o (arg1);
					} else {
						Result = (EIF_REFERENCE) loc1;
					}
					tr1 = *(EIF_REFERENCE *)(RTCW(Result));
					tr2 = *(EIF_REFERENCE *)(Current);
					tr3 = *(EIF_REFERENCE *)(loc1);
					ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr3)+ _LNGOFF_1_1_0_2_);
					tr3 = *(EIF_REFERENCE *)(Current);
					ti4_2 = *(EIF_INTEGER_32 *)(RTCW(tr3)+ _LNGOFF_1_1_0_2_);
					{
						/* INLINED CODE (PATH.directory_separator) */
						tc1 = (EIF_CHARACTER_8)  0;
						tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
						if (tb1) {
							tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
						} else {
							tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
						}
						/* END INLINED CODE */
					}
					tc2 = tc1;
					F2102_21780(Current, tr1, tr2, (EIF_INTEGER_32) (ti4_1 + ((EIF_INTEGER_32) 1L)), ti4_2, tc2);
				} else {
					if (F2102_21781(Current, *(EIF_REFERENCE *)(Current), ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '\\')) {
						Result = (EIF_REFERENCE) eif_builtin_ANY_twin__o (arg1);
						tr1 = F2102_21739(RTCW(Result));
						loc2 = tr1;
						if (EIF_TEST(loc2)) {
							Result = (EIF_REFERENCE) loc2;
						}
					} else {
						Result = (EIF_REFERENCE) eif_builtin_ANY_twin__o (arg1);
					}
					tr1 = *(EIF_REFERENCE *)(RTCW(Result));
					tr2 = *(EIF_REFERENCE *)(Current);
					{
						/* INLINED CODE (PATH.directory_separator) */
						tc1 = (EIF_CHARACTER_8)  0;
						tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
						if (tb1) {
							tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
						} else {
							tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
						}
						/* END INLINED CODE */
					}
					tc2 = tc1;
					F2102_21779(Current, tr1, tr2, tc2);
				}
			} else {
				Result = (EIF_REFERENCE) eif_builtin_ANY_twin__o (arg1);
				tr1 = *(EIF_REFERENCE *)(RTCW(Result));
				tr2 = *(EIF_REFERENCE *)(Current);
				{
					/* INLINED CODE (PATH.directory_separator) */
					tc1 = (EIF_CHARACTER_8)  0;
					tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
					if (tb1) {
						tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
					} else {
						tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
					}
					/* END INLINED CODE */
				}
				tc2 = tc1;
				F2102_21779(Current, tr1, tr2, tc2);
			}
			{
				/* INLINED CODE (PATH.reset_internal_data) */
				(void) RTCW(Result);
				*(EIF_REFERENCE *)(Result + _REFACS_1_) = (EIF_REFERENCE) NULL;
				/* END INLINED CODE */
			}
			;
		}
	}
	RTLE;
	return Result;
}

/* {PATH}.canonical_path */
EIF_REFERENCE F2102_21746 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc3 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc4 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc5 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_CHARACTER_8 tc1;
	EIF_CHARACTER_8 tc2;
	RTLD;
	
	RTLI(8);
	RTLR(0,loc2);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,tr2);
	RTLR(4,loc4);
	RTLR(5,loc3);
	RTLR(6,loc1);
	RTLR(7,loc5);
	RTLIU(8);
	
	RTGC;
	{
		/* INLINED CODE (PATH.absolute_path) */
		tr1 = (EIF_REFERENCE)  0;
		tr2 = F916_13048(RTCV(RTOSCF(21774,F2102_21774, (Current))));
		tr1 = F2102_21745(Current, tr2);
		/* END INLINED CODE */
	}
	loc2 = tr1;
	tr1 = F2102_21739(RTCW(loc2));
	loc4 = tr1;
	if (EIF_TEST(loc4)) {
		loc3 = RTLNSMART(eif_new_type(2071, 0).id);
		tr1 = *(EIF_REFERENCE *)(RTCW(loc2));
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
		F2070_20812(RTCW(loc3), ti4_1);
		loc1 = F2102_21743(RTCW(loc2));
		{
			/* INLINED CODE (ARRAYED_LIST.start) */
			(void) RTCW(loc1);
			*(EIF_INTEGER_32 *)(loc1 + O14285[Dtype(loc1)-1712]) = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
			/* END INLINED CODE */
		}
		;
		{
			/* INLINED CODE (ARRAYED_LIST.item) */
			tr1 = (EIF_REFERENCE)  0;
			(void) RTCW(loc1);
			tr2 = *(EIF_REFERENCE *)(loc1);
			tr1 = 
				/* INLINED CODE (SPECIAL.item) */
				*((EIF_REFERENCE *)RTCW(tr2) + ((EIF_INTEGER_32) (*(EIF_INTEGER_32 *)(loc1 + O14285[Dtype(loc1)-1712]) - ((EIF_INTEGER_32) 1L))))
				/* END INLINED CODE */;
			/* END INLINED CODE */
		}
		tr1 = tr1;
		tr1 = *(EIF_REFERENCE *)(RTCW(tr1));
		{
			/* INLINED CODE (PATH.directory_separator) */
			tc1 = (EIF_CHARACTER_8)  0;
			tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
			if (tb1) {
				tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
			} else {
				tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
			}
			/* END INLINED CODE */
		}
		tc2 = tc1;
		F2102_21779(Current, loc3, tr1, tc2);
		(FUNCTION_CAST(void, (EIF_REFERENCE)) R13762[Dtype(RTCW(loc1))-1544])(loc1);
		for (;;) {
			{
				/* INLINED CODE (LIST.after) */
				tb1 = (EIF_BOOLEAN)  0;
				(void) RTCW(loc1);
				ti4_1 = *(EIF_INTEGER_32 *)(loc1 + O14285[Dtype(loc1)-1712]);
				ti4_2 = F1713_16956(loc1);
				tb1 = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 == (EIF_INTEGER_32) (ti4_2 + ((EIF_INTEGER_32) 1L)));
				/* END INLINED CODE */
			}
			tb1 = tb1;
			if (tb1) break;
			{
				/* INLINED CODE (ARRAYED_LIST.item) */
				tr1 = (EIF_REFERENCE)  0;
				(void) RTCW(loc1);
				tr2 = *(EIF_REFERENCE *)(loc1);
				tr1 = 
					/* INLINED CODE (SPECIAL.item) */
					*((EIF_REFERENCE *)RTCW(tr2) + ((EIF_INTEGER_32) (*(EIF_INTEGER_32 *)(loc1 + O14285[Dtype(loc1)-1712]) - ((EIF_INTEGER_32) 1L))))
					/* END INLINED CODE */;
				/* END INLINED CODE */
			}
			tr1 = tr1;
			{
				/* INLINED CODE (PATH.is_current_symbol) */
				tb2 = (EIF_BOOLEAN)  0;
				(void) RTCW(tr1);
				tr2 = *(EIF_REFERENCE *)(tr1);
				ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr2)+ _LNGOFF_1_1_0_2_);
				ti4_2 = F2102_21769(tr1);
				if ((EIF_BOOLEAN)(ti4_1 == ti4_2)) {
					tb2 = F2102_21781(tr1, *(EIF_REFERENCE *)(tr1), ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '.');
				}
				/* END INLINED CODE */
			}
			tb2 = tb2;
			if (tb2) {
				(FUNCTION_CAST(void, (EIF_REFERENCE)) R13762[Dtype(RTCW(loc1))-1544])(loc1);
			} else {
				{
					/* INLINED CODE (ARRAYED_LIST.item) */
					tr1 = (EIF_REFERENCE)  0;
					(void) RTCW(loc1);
					tr2 = *(EIF_REFERENCE *)(loc1);
					tr1 = 
						/* INLINED CODE (SPECIAL.item) */
						*((EIF_REFERENCE *)RTCW(tr2) + ((EIF_INTEGER_32) (*(EIF_INTEGER_32 *)(loc1 + O14285[Dtype(loc1)-1712]) - ((EIF_INTEGER_32) 1L))))
						/* END INLINED CODE */;
					/* END INLINED CODE */
				}
				tr1 = tr1;
				tb2 = F2102_21731(RTCW(tr1));
				if (tb2) {
					{
						/* INLINED CODE (CHAIN.isfirst) */
						tb2 = (EIF_BOOLEAN)  0;
						(void) RTCW(loc1);
						tb2 = '\0';
						tb3 = F1476_16066(loc1);
						if ((EIF_BOOLEAN) !tb3) {
							ti4_1 = *(EIF_INTEGER_32 *)(loc1 + O14285[Dtype(loc1)-1712]);
							tb2 = (EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 1L));
						}
						/* END INLINED CODE */
					}
					tb2 = tb2;
					if ((EIF_BOOLEAN) !tb2) {
						{
							/* INLINED CODE (ARRAYED_LIST.back) */
							(void) RTCW(loc1);
							(*(EIF_INTEGER_32 *)(loc1 + O14285[Dtype(loc1)-1712]))--;
							/* END INLINED CODE */
						}
						;
						(FUNCTION_CAST(void, (EIF_REFERENCE)) R13762[Dtype(RTCW(loc1))-1544])(loc1);
					}
					(FUNCTION_CAST(void, (EIF_REFERENCE)) R13762[Dtype(RTCW(loc1))-1544])(loc1);
				} else {
					{
						/* INLINED CODE (ARRAYED_LIST.forth) */
						(void) RTCW(loc1);
						(*(EIF_INTEGER_32 *)(loc1 + O14285[Dtype(loc1)-1712]))++;
						/* END INLINED CODE */
					}
					;
				}
			}
		}
		loc5 = F1713_16949(RTCW(loc1));
		for (;;) {
			{
				/* INLINED CODE (GENERAL_SPECIAL_ITERATION_CURSOR.after) */
				tb2 = (EIF_BOOLEAN)  0;
				(void) loc5;
				ti4_1 = *(EIF_INTEGER_32 *)(loc5+ _LNGOFF_2_0_0_0_);
				ti4_2 = *(EIF_INTEGER_32 *)(loc5+ _LNGOFF_2_0_0_1_);
				tb2 = (EIF_BOOLEAN) (EIF_BOOLEAN) (ti4_1 > ti4_2);
				/* END INLINED CODE */
			}
			tb2 = tb2;
			if (tb2) break;
			{
				/* INLINED CODE (GENERAL_SPECIAL_ITERATION_CURSOR.item) */
				tr1 = (EIF_REFERENCE)  0;
				(void) loc5;
				tr2 = *(EIF_REFERENCE *)(loc5);
				tr1 = 
					/* INLINED CODE (SPECIAL.item) */
					*((EIF_REFERENCE *)RTCW(tr2) + (*(EIF_INTEGER_32 *)(loc5+ _LNGOFF_2_0_0_0_)))
					/* END INLINED CODE */;
				/* END INLINED CODE */
			}
			tr1 = tr1;
			tr1 = *(EIF_REFERENCE *)(RTCW(tr1));
			{
				/* INLINED CODE (PATH.directory_separator) */
				tc1 = (EIF_CHARACTER_8)  0;
				tb3 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
				if (tb3) {
					tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
				} else {
					tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
				}
				/* END INLINED CODE */
			}
			tc2 = tc1;
			F2102_21779(Current, loc3, tr1, tc2);
			{
				/* INLINED CODE (GENERAL_SPECIAL_ITERATION_CURSOR.forth) */
				(void) loc5;
				(*(EIF_INTEGER_32 *)(loc5+ _LNGOFF_2_0_0_0_))++;
				/* END INLINED CODE */
			}
			;
		}
		tr1 = RTLNS(eif_new_type(2101, 0x00).id, 2101, _OBJSIZ_2_1_0_0_0_0_0_0_);
		F2102_21728(RTCW(tr1), loc3);
		RTLE;
		return (EIF_REFERENCE) tr1;
	} else {
		RTLE;
		return (EIF_REFERENCE) loc2;
	}/* NOTREACHED */
	
}

/* {PATH}.hash_code */
EIF_INTEGER_32 F2102_21747 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTGC;
	if ((EIF_BOOLEAN) EIF_TEST(eif_case_sensitive_path_names())) {
		tr1 = *(EIF_REFERENCE *)(Current);
		Result = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R16211[Dtype(RTCW(tr1))-1959])(tr1);
	} else {
		Result = F2067_20692(RTCV(F2102_21764(Current)));
	}
	RTLE;
	return Result;
}

/* {PATH}.directory_separator */
EIF_CHARACTER_8 F2102_21751 (EIF_REFERENCE Current)
{
	GTCX
	
	
	RTGC;
	if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
		return (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
	} else {
		return (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
	}/* NOTREACHED */
	
}

/* {PATH}.extended */
EIF_REFERENCE F2102_21752 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_INTEGER_32 ti4_4;
	EIF_BOOLEAN tb1;
	EIF_CHARACTER_8 tc1;
	EIF_CHARACTER_8 tc2;
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,arg1);
	RTLIU(4);
	
	RTGC;
	loc1 = RTLNSMART(eif_new_type(2071, 0).id);
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
	ti4_2 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R17099[Dtype(RTCW(arg1))-2070])(arg1);
	ti4_3 = F2102_21769(Current);
	ti4_4 = F2102_21769(Current);
	F2070_20812(RTCW(loc1), (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 + (EIF_INTEGER_32) (ti4_2 * ti4_3)) + ti4_4));
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R17246[Dtype(RTCW(loc1))-2071])(loc1, *(EIF_REFERENCE *)(Current));
	tb1 = '\0';
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_);
	if ((EIF_BOOLEAN) (ti4_1 > ((EIF_INTEGER_32) 0L))) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_);
		tb1 = (EIF_BOOLEAN)(F2102_21775(Current) == ti4_1);
	}
	if (tb1) {
		F2102_21778(Current, loc1, arg1, (EIF_CHARACTER_8) '\000');
	} else {
		{
			/* INLINED CODE (PATH.directory_separator) */
			tc1 = (EIF_CHARACTER_8)  0;
			tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
			if (tb1) {
				tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
			} else {
				tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
			}
			/* END INLINED CODE */
		}
		tc2 = tc1;
		F2102_21778(Current, loc1, arg1, tc2);
	}
	tr1 = RTLNS(eif_new_type(2101, 0x00).id, 2101, _OBJSIZ_2_1_0_0_0_0_0_0_);
	F2102_21727(RTCW(tr1), loc1);
	RTLE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.extended_path */
EIF_REFERENCE F2102_21753 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_BOOLEAN tb1;
	EIF_CHARACTER_8 tc1;
	EIF_CHARACTER_8 tc2;
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,arg1);
	RTLIU(4);
	
	RTGC;
	loc1 = RTLNSMART(eif_new_type(2071, 0).id);
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
	tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
	ti4_2 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
	ti4_3 = F2102_21769(Current);
	F2070_20812(RTCW(loc1), (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 + ti4_2) + ti4_3));
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R17246[Dtype(RTCW(loc1))-2071])(loc1, *(EIF_REFERENCE *)(Current));
	tb1 = '\0';
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_);
	if ((EIF_BOOLEAN) (ti4_1 > ((EIF_INTEGER_32) 0L))) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_);
		tb1 = (EIF_BOOLEAN)(F2102_21775(Current) == ti4_1);
	}
	if (tb1) {
		tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
		F2102_21779(Current, loc1, tr1, (EIF_CHARACTER_8) '\000');
	} else {
		tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
		{
			/* INLINED CODE (PATH.directory_separator) */
			tc1 = (EIF_CHARACTER_8)  0;
			tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
			if (tb1) {
				tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
			} else {
				tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
			}
			/* END INLINED CODE */
		}
		tc2 = tc1;
		F2102_21779(Current, loc1, tr1, tc2);
	}
	tr1 = RTLNS(eif_new_type(2101, 0x00).id, 2101, _OBJSIZ_2_1_0_0_0_0_0_0_);
	F2102_21728(RTCW(tr1), loc1);
	RTLE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.appended */
EIF_REFERENCE F2102_21754 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,arg1);
	RTLIU(4);
	
	RTGC;
	loc1 = RTLNSMART(eif_new_type(2071, 0).id);
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
	ti4_2 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R17099[Dtype(RTCW(arg1))-2070])(arg1);
	ti4_3 = F2102_21769(Current);
	F2070_20812(RTCW(loc1), (EIF_INTEGER_32) (ti4_1 + (EIF_INTEGER_32) (ti4_2 * ti4_3)));
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R17246[Dtype(RTCW(loc1))-2071])(loc1, *(EIF_REFERENCE *)(Current));
	F2102_21778(Current, loc1, arg1, (EIF_CHARACTER_8) '\000');
	tr1 = RTLNS(eif_new_type(2101, 0x00).id, 2101, _OBJSIZ_2_1_0_0_0_0_0_0_);
	F2102_21727(RTCW(tr1), loc1);
	RTLE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.appended_with_extension */
EIF_REFERENCE F2102_21755 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_INTEGER_32 ti4_4;
	RTLD;
	
	RTLI(4);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,arg1);
	RTLIU(4);
	
	RTGC;
	loc1 = RTLNSMART(eif_new_type(2071, 0).id);
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
	ti4_2 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R17099[Dtype(RTCW(arg1))-2070])(arg1);
	ti4_3 = F2102_21769(Current);
	ti4_4 = F2102_21769(Current);
	F2070_20812(RTCW(loc1), (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 + (EIF_INTEGER_32) (ti4_2 * ti4_3)) + ti4_4));
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R17246[Dtype(RTCW(loc1))-2071])(loc1, *(EIF_REFERENCE *)(Current));
	F2102_21778(Current, loc1, arg1, (EIF_CHARACTER_8) '.');
	tr1 = RTLNS(eif_new_type(2101, 0x00).id, 2101, _OBJSIZ_2_1_0_0_0_0_0_0_);
	F2102_21728(RTCW(tr1), loc1);
	RTLE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.same_as */
EIF_BOOLEAN F2102_21756 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_BOOLEAN tb1;
	RTLD;
	
	RTLI(4);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,tr2);
	RTLIU(4);
	
	RTGC;
	if ((EIF_BOOLEAN)(arg1 == NULL)) {
	} else {
		if ((EIF_BOOLEAN)(arg1 == Current)) {
			RTLE;
			return (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
		} else {
			if ((EIF_BOOLEAN) EIF_TEST(eif_case_sensitive_path_names())) {
				{
					/* INLINED CODE (PATH.is_case_sensitive_equal) */
					tb1 = (EIF_BOOLEAN)  0;
					if ((EIF_BOOLEAN)(arg1 == Current)) {
						tb1 = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
					} else {
						tr1 = *(EIF_REFERENCE *)(Current);
						tr2 = *(EIF_REFERENCE *)(RTCW(arg1));
						tb1 = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE, EIF_REFERENCE)) R11[Dtype(RTCW(tr1))-35])(tr1, tr2);
					}
					/* END INLINED CODE */
				}
				RTLE;
				return (EIF_BOOLEAN) tb1;
			} else {
				RTLE;
				return (EIF_BOOLEAN) F2102_21760(Current, arg1);
			}
		}
	}
	RTLE;
	return (EIF_BOOLEAN) 0;
}

/* {PATH}.is_less */
EIF_BOOLEAN F2102_21757 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLR(2,arg1);
	RTLR(3,tr2);
	RTLIU(4);
	
	RTGC;
	if ((EIF_BOOLEAN) EIF_TEST(eif_case_sensitive_path_names())) {
		tr1 = *(EIF_REFERENCE *)(Current);
		tr2 = *(EIF_REFERENCE *)(RTCW(arg1));
		Result = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE, EIF_REFERENCE)) R11511[Dtype(RTCW(tr1))-930])(tr1, tr2);
	} else {
		tr1 = F2075_21044(RTCV(F2102_21764(Current)));
		tr2 = F2102_21764(RTCW(arg1));
		tr2 = F2075_21044(RTCW(tr2));
		Result = F2074_21007(RTCW(tr1), tr2);
	}
	RTLE;
	return Result;
}

/* {PATH}.is_equal */
EIF_BOOLEAN F2102_21758 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	
	
	return (EIF_BOOLEAN) F2102_21756(Current, arg1);
}

/* {PATH}.is_case_sensitive_equal */
EIF_BOOLEAN F2102_21759 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,tr2);
	RTLIU(4);
	
	RTGC;
	if ((EIF_BOOLEAN)(arg1 == Current)) {
		RTLE;
		return (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	} else {
		tr1 = *(EIF_REFERENCE *)(Current);
		tr2 = *(EIF_REFERENCE *)(RTCW(arg1));
		Result = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE, EIF_REFERENCE)) R11[Dtype(RTCW(tr1))-35])(tr1, tr2);
	}
	RTLE;
	return Result;
}

/* {PATH}.is_case_insensitive_equal */
EIF_BOOLEAN F2102_21760 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(4);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,tr2);
	RTLIU(4);
	
	RTGC;
	if ((EIF_BOOLEAN)(arg1 == Current)) {
		RTLE;
		return (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	} else {
		tr1 = F2102_21764(Current);
		tr2 = F2102_21764(RTCW(arg1));
		Result = F2074_21003(RTCW(tr1), tr2);
	}
	RTLE;
	return Result;
}

/* {PATH}.copy */
void F2102_21761 (EIF_REFERENCE Current, EIF_REFERENCE arg1)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(3);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLIU(3);
	
	RTGC;
	if ((EIF_BOOLEAN)(arg1 != Current)) {
		eif_builtin_ANY_standard_copy__o_ (Current, arg1);
		tr1 = *(EIF_REFERENCE *)(RTCW(arg1));
		tr1 = (EIF_REFERENCE) eif_builtin_ANY_twin__o (tr1);
		RTAR(Current, tr1);
		*(EIF_REFERENCE *)(Current) = (EIF_REFERENCE) tr1;
	}
	RTLE;
}

/* {PATH}.out */
EIF_REFERENCE F2102_21762 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	
	RTLI(3);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLIU(3);
	
	RTGC;
	tr1 = F2102_21764(Current);
	loc1 = tr1;
	loc1 = RTRV(eif_new_type(2069, 0x00),loc1);
	if (EIF_TEST(loc1)) {
		tr1 = RTLNS(eif_new_type(2071, 0x00).id, 2071, _OBJSIZ_1_1_0_3_0_0_0_0_);
		F2070_20814(RTCW(tr1), loc1);
		RTLE;
		return (EIF_REFERENCE) tr1;
	} else {
		RTLE;
		return (EIF_REFERENCE) F2102_21763(Current);
	}/* NOTREACHED */
	
}

/* {PATH}.utf_8_name */
EIF_REFERENCE F2102_21763 (EIF_REFERENCE Current)
{
	GTCX
	struct eif_ex_207 sloc1;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) sloc1.data;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE tr2 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	memset (&sloc1.overhead, 0, OVERHEAD + _OBJSIZ_0_0_0_0_0_0_0_0_);
	sloc1.overhead.ov_flags = EO_EXP | EO_STACK;
	RT_DFS(&sloc1.overhead, eif_new_type(240, 0x00).id);
	RTLI(5);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,tr2);
	RTLR(4,Result);
	RTLIU(5);
	
	RTGC;
	tr1 = F2102_21764(Current);
	{
		/* INLINED CODE (UTF_CONVERTER.escaped_utf_32_string_to_utf_8_string_8) */
		tr2 = (EIF_REFERENCE)  0;
		(void) RTCW(loc1);
		tr2 = RTLNS(eif_new_type(2071, 0x00).id, 2071, _OBJSIZ_1_1_0_3_0_0_0_0_);
		ti4_1 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R17099[Dtype(RTCW(tr1))-2070])(tr1);
		F2070_20812(RTCW(tr2), ti4_1);
		F241_4205(loc1, tr1, tr2);
		/* END INLINED CODE */
	}
	Result = tr2;
	RTLE;
	return Result;
}

/* {PATH}.name */
EIF_REFERENCE F2102_21764 (EIF_REFERENCE Current)
{
	GTCX
	struct eif_ex_207 sloc1;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) sloc1.data;
	EIF_REFERENCE loc2 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_REFERENCE Result = ((EIF_REFERENCE) 0);
	
	RTLD;
	
	memset (&sloc1.overhead, 0, OVERHEAD + _OBJSIZ_0_0_0_0_0_0_0_0_);
	sloc1.overhead.ov_flags = EO_EXP | EO_STACK;
	RT_DFS(&sloc1.overhead, eif_new_type(240, 0x00).id);
	RTLI(5);
	RTLR(0,loc2);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLR(3,loc1);
	RTLR(4,Result);
	RTLIU(5);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current + _REFACS_1_);
	loc2 = tr1;
	if (EIF_TEST(loc2)) {
		RTLE;
		return (EIF_REFERENCE) loc2;
	} else {
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
			Result = RTLNS(eif_new_type(2074, 0x00).id, 2074, _OBJSIZ_1_0_0_4_0_0_0_0_);
			tr1 = F241_4243(RTCW(loc1), *(EIF_REFERENCE *)(Current));
			F2074_20980(RTCW(Result), tr1);
		} else {
			Result = RTLNS(eif_new_type(2074, 0x00).id, 2074, _OBJSIZ_1_0_0_4_0_0_0_0_);
			tr1 = F241_4216(RTCW(loc1), *(EIF_REFERENCE *)(Current));
			F2074_20980(RTCW(Result), tr1);
		}
		RTAR(Current, Result);
		*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) Result;
	}
	RTLE;
	return Result;
}

/* {PATH}.to_pointer */
EIF_REFERENCE F2102_21766 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	RTLD;
	
	RTLI(3);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLR(2,tr1);
	RTLIU(3);
	
	RTGC;
	loc1 = RTLNS(eif_new_type(1047, 0x00).id, 1047, _OBJSIZ_1_0_0_1_0_0_0_0_);
	tr1 = *(EIF_REFERENCE *)(Current);
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
	ti4_2 = F2102_21769(Current);
	F1048_14929(RTCW(loc1), (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 + ti4_2) - ((EIF_INTEGER_32) 1L)));
	{
		/* INLINED CODE (C_STRING.set_string) */
		tr1 = *(EIF_REFERENCE *)(Current);
		(void) RTCW(loc1);
		ti4_1 = (FUNCTION_CAST(EIF_INTEGER_32, (EIF_REFERENCE)) R17099[Dtype(RTCW(tr1))-2070])(tr1);
		F1048_14957(loc1, tr1, ((EIF_INTEGER_32) 1L), ti4_1);
		/* END INLINED CODE */
	}
	;
	tr1 = *(EIF_REFERENCE *)(RTCW(loc1));
	RTLE;
	return (EIF_REFERENCE) tr1;
}

/* {PATH}.unit_size */
EIF_INTEGER_32 F2102_21769 (EIF_REFERENCE Current)
{
	GTCX
	
	
	RTGC;
	if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
		return (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
	} else {
		return (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
	}/* NOTREACHED */
	
}

/* {PATH}.reset_internal_data */
void F2102_21770 (EIF_REFERENCE Current)
{
	GTCX
	
	
	*(EIF_REFERENCE *)(Current + _REFACS_1_) = (EIF_REFERENCE) NULL;
}

/* {PATH}.normalize */
void F2102_21771 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE loc1 = (EIF_REFERENCE) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc3 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc4 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc5 = (EIF_INTEGER_32) 0;
	EIF_BOOLEAN loc6 = (EIF_BOOLEAN) 0;
	EIF_BOOLEAN loc7 = (EIF_BOOLEAN) 0;
	EIF_BOOLEAN loc8 = (EIF_BOOLEAN) 0;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_CHARACTER_8 tc1;
	EIF_CHARACTER_8 tc2;
	RTLD;
	
	RTLI(2);
	RTLR(0,loc1);
	RTLR(1,Current);
	RTLIU(2);
	
	RTGC;
	loc1 = *(EIF_REFERENCE *)(Current);
	loc4 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_);
	if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
		loc2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
		if ((EIF_BOOLEAN) (loc4 >= ((EIF_INTEGER_32) 10L))) {
			tb1 = '\01';
			tb2 = '\0';
			if (F2102_21781(Current, loc1, ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '/')) {
				tb3 = '\01';
				if (!F2102_21781(Current, loc1, ((EIF_INTEGER_32) 3L), (EIF_CHARACTER_8) '/')) {
					tb3 = F2102_21781(Current, loc1, ((EIF_INTEGER_32) 3L), (EIF_CHARACTER_8) '\\');
				}
				tb2 = tb3;
			}
			if (!tb2) {
				tb2 = '\0';
				if (F2102_21781(Current, loc1, ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '\\')) {
					tb3 = '\01';
					if (!F2102_21781(Current, loc1, ((EIF_INTEGER_32) 3L), (EIF_CHARACTER_8) '\\')) {
						tb3 = F2102_21781(Current, loc1, ((EIF_INTEGER_32) 3L), (EIF_CHARACTER_8) '/');
					}
					tb2 = tb3;
				}
				tb1 = tb2;
			}
			if (tb1) {
				tb1 = '\0';
				if ((EIF_BOOLEAN) !F2102_21781(Current, loc1, ((EIF_INTEGER_32) 5L), (EIF_CHARACTER_8) '/')) {
					tb1 = (EIF_BOOLEAN) !F2102_21781(Current, loc1, ((EIF_INTEGER_32) 5L), (EIF_CHARACTER_8) '\\');
				}
				if (tb1) {
					loc2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 5L);
					loc8 = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
				}
			}
		}
		loc3 = (EIF_INTEGER_32) loc2;
		loc7 = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
		for (;;) {
			if ((EIF_BOOLEAN) (loc2 > loc4)) break;
			if (loc6) {
				loc7 = '\0';
				if ((EIF_BOOLEAN) !F2102_21781(Current, loc1, loc2, (EIF_CHARACTER_8) '\\')) {
					loc7 = (EIF_BOOLEAN) !F2102_21781(Current, loc1, loc2, (EIF_CHARACTER_8) '/');
				}
				loc6 = (EIF_BOOLEAN) (EIF_BOOLEAN) !loc7;
			} else {
				if (F2102_21781(Current, loc1, loc2, (EIF_CHARACTER_8) '/')) {
					tc1 = (EIF_CHARACTER_8) '\\';
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE, EIF_REFERENCE)) R13753[Dtype(RTCW(loc1))-1618])(loc1, (EIF_REFERENCE) &tc1, (EIF_REFERENCE) &loc2);
					loc6 = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
				} else {
					loc6 = F2102_21781(Current, loc1, loc2, (EIF_CHARACTER_8) '\\');
				}
			}
			if (loc7) {
				if ((EIF_BOOLEAN)(loc2 != loc3)) {
					tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R14092[Dtype(RTCW(loc1))-1618])(loc1, loc2));
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE, EIF_REFERENCE)) R13753[Dtype(RTCW(loc1))-1618])(loc1, (EIF_REFERENCE) &tc1, (EIF_REFERENCE) &loc3);
					tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R14092[Dtype(RTCW(loc1))-1618])(loc1, (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L))));
					ti4_1 = (EIF_INTEGER_32) (loc3 + ((EIF_INTEGER_32) 1L));
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE, EIF_REFERENCE)) R13753[Dtype(RTCW(loc1))-1618])(loc1, (EIF_REFERENCE) &tc1, (EIF_REFERENCE) &ti4_1);
				}
				loc3 += ((EIF_INTEGER_32) 2L);
			}
			loc2 += ((EIF_INTEGER_32) 2L);
		}
	} else {
		loc2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
		loc3 = (EIF_INTEGER_32) loc2;
		loc7 = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
		for (;;) {
			if ((EIF_BOOLEAN) (loc2 > loc4)) break;
			if (loc6) {
				loc7 = F2102_21781(Current, loc1, loc2, (EIF_CHARACTER_8) '/');
				loc7 = (EIF_BOOLEAN) (EIF_BOOLEAN) !loc7;
				loc6 = (EIF_BOOLEAN) (EIF_BOOLEAN) !loc7;
			} else {
				loc6 = F2102_21781(Current, loc1, loc2, (EIF_CHARACTER_8) '/');
			}
			if (loc7) {
				if ((EIF_BOOLEAN)(loc2 != loc3)) {
					tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R14092[Dtype(RTCW(loc1))-1618])(loc1, loc2));
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE, EIF_REFERENCE)) R13753[Dtype(RTCW(loc1))-1618])(loc1, (EIF_REFERENCE) &tc1, (EIF_REFERENCE) &loc3);
				}
				loc3++;
			}
			loc2++;
		}
	}
	if ((EIF_BOOLEAN)(loc2 != loc3)) {
		(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_INTEGER_32)) R17178[Dtype(RTCW(loc1))-2071])(loc1, (EIF_INTEGER_32) (loc3 - ((EIF_INTEGER_32) 1L)));
	}
	*(EIF_BOOLEAN *)(Current+ _CHROFF_2_0_) = (EIF_BOOLEAN) (EIF_BOOLEAN) 1;
	if (loc8) {
		loc5 = F2102_21775(Current);
		if ((EIF_BOOLEAN)(loc5 == ((EIF_INTEGER_32) 0L))) {
			{
				/* INLINED CODE (PATH.unit_size) */
				ti4_1 = (EIF_INTEGER_32)  0;
				tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
				if (tb1) {
					ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
				} else {
					ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
				}
				/* END INLINED CODE */
			}
			ti4_2 = ti4_1;
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_INTEGER_32)) R17184[Dtype(RTCW(loc1))-2071])(loc1, ti4_2);
		}
	}
	tb1 = '\0';
	ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_);
	{
		/* INLINED CODE (PATH.unit_size) */
		ti4_2 = (EIF_INTEGER_32)  0;
		tb2 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
		if (tb2) {
			ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
		} else {
			ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
		}
		/* END INLINED CODE */
	}
	ti4_3 = ti4_2;
	{
		/* INLINED CODE (PATH.directory_separator) */
		tc1 = (EIF_CHARACTER_8)  0;
		tb2 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
		if (tb2) {
			tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
		} else {
			tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
		}
		/* END INLINED CODE */
	}
	tc2 = tc1;
	if (F2102_21781(Current, loc1, (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 - ti4_3) + ((EIF_INTEGER_32) 1L)), tc2)) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(loc1)+ _LNGOFF_1_1_0_2_);
		tb1 = (EIF_BOOLEAN) (F2102_21775(Current) < ti4_1);
	}
	if (tb1) {
		{
			/* INLINED CODE (PATH.unit_size) */
			ti4_1 = (EIF_INTEGER_32)  0;
			tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
			if (tb1) {
				ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
			} else {
				ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
			}
			/* END INLINED CODE */
		}
		ti4_2 = ti4_1;
		(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_INTEGER_32)) R17186[Dtype(RTCW(loc1))-2071])(loc1, ti4_2);
	}
	RTLE;
}

/* {PATH}.env */
static EIF_REFERENCE F2102_21774_body (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_REFERENCE tr1 = NULL;
	RTLD;
	

	RTLI(1);
	RTLR(0,tr1);
	RTLIU(1);
	
	RTEV;
	RTGC;
	RTOSP (21774);
#define Result RTOSR(21774)
	RTOC_NEW(Result);
	tr1 = RTLNS(eif_new_type(915, 0x00).id, 915, _OBJSIZ_0_0_0_1_0_0_0_0_);
	Result = (EIF_REFERENCE) tr1;
	RTOSE (21774);
	RTLE;
	RTEE;
	return Result;
#undef Result
}

EIF_REFERENCE F2102_21774 (EIF_REFERENCE Current)
{
	GTCX
	return RTOSCF(21774,F2102_21774_body,(Current));
}

/* {PATH}.root_end_position */
EIF_INTEGER_32 F2102_21775 (EIF_REFERENCE Current)
{
	GTCX
	EIF_CHARACTER_8 loc1 = (EIF_CHARACTER_8) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_CHARACTER_8 tc1;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current);
	{
		/* INLINED CODE (FINITE.is_empty) */
		tb1 = (EIF_BOOLEAN)  0;
		(void) RTCW(tr1);
		ti4_1 = *(EIF_INTEGER_32 *)(tr1+ _LNGOFF_1_1_0_2_);
		tb1 = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 0L));
		/* END INLINED CODE */
	}
	tb1 = tb1;
	if ((EIF_BOOLEAN) !tb1) {
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
			tb1 = '\0';
			tr1 = *(EIF_REFERENCE *)(Current);
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
			{
				/* INLINED CODE (PATH.unit_size) */
				ti4_2 = (EIF_INTEGER_32)  0;
				tb2 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
				if (tb2) {
					ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
				} else {
					ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
				}
				/* END INLINED CODE */
			}
			if ((EIF_BOOLEAN)(ti4_1 == ti4_2)) {
				tb1 = F2102_21781(Current, *(EIF_REFERENCE *)(Current), ((EIF_INTEGER_32) 1L), (EIF_CHARACTER_8) '\\');
			}
			if (tb1) {
				{
					/* INLINED CODE (PATH.unit_size) */
					ti4_1 = (EIF_INTEGER_32)  0;
					tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
					if (tb1) {
						ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
					} else {
						ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
					}
					/* END INLINED CODE */
				}
				RTLE;
				return (EIF_INTEGER_32) ti4_1;
			} else {
				tb1 = '\0';
				tr1 = *(EIF_REFERENCE *)(Current);
				ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
				if ((EIF_BOOLEAN) (ti4_1 >= ((EIF_INTEGER_32) 4L))) {
					tb2 = '\0';
					tr1 = *(EIF_REFERENCE *)(Current);
					tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R14092[Dtype(RTCW(tr1))-1618])(tr1, ((EIF_INTEGER_32) 2L)));
					if ((EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) '\000')) {
						tr1 = *(EIF_REFERENCE *)(Current);
						tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R14092[Dtype(RTCW(tr1))-1618])(tr1, ((EIF_INTEGER_32) 4L)));
						tb2 = (EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) '\000');
					}
					tb1 = tb2;
				}
				if (tb1) {
					tr1 = *(EIF_REFERENCE *)(Current);
					tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R14092[Dtype(RTCW(tr1))-1618])(tr1, ((EIF_INTEGER_32) 1L)));
					loc1 = eif_builtin_CHARACTER_8_as_lower__c1_c1(tc1);
					tb1 = '\0';
					if ((EIF_BOOLEAN) ((EIF_BOOLEAN) (loc1 >= (EIF_CHARACTER_8) 'a') && (EIF_BOOLEAN) (loc1 <= (EIF_CHARACTER_8) 'z'))) {
						tr1 = *(EIF_REFERENCE *)(Current);
						tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R14092[Dtype(RTCW(tr1))-1618])(tr1, ((EIF_INTEGER_32) 3L)));
						tb1 = (EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) ':');
					}
					if (tb1) {
						tb1 = '\0';
						tr1 = *(EIF_REFERENCE *)(Current);
						ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
						{
							/* INLINED CODE (PATH.unit_size) */
							ti4_2 = (EIF_INTEGER_32)  0;
							tb2 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
							if (tb2) {
								ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
							} else {
								ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
							}
							/* END INLINED CODE */
						}
						if ((EIF_BOOLEAN) (ti4_1 >= (EIF_INTEGER_32) (((EIF_INTEGER_32) 3L) * ti4_2))) {
							tb1 = F2102_21781(Current, *(EIF_REFERENCE *)(Current), ((EIF_INTEGER_32) 5L), (EIF_CHARACTER_8) '\\');
						}
						if (tb1) {
							RTLE;
							return (EIF_INTEGER_32) ((EIF_INTEGER_32) 6L);
						} else {
							RTLE;
							return (EIF_INTEGER_32) ((EIF_INTEGER_32) 4L);
						}
					} else {
						tb1 = '\0';
						if ((EIF_BOOLEAN)(loc1 == (EIF_CHARACTER_8) '\\')) {
							tr1 = *(EIF_REFERENCE *)(Current);
							tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R14092[Dtype(RTCW(tr1))-1618])(tr1, ((EIF_INTEGER_32) 3L)));
							tb1 = (EIF_BOOLEAN)(tc1 != (EIF_CHARACTER_8) '\\');
						}
						if (tb1) {
							{
								/* INLINED CODE (PATH.unit_size) */
								ti4_1 = (EIF_INTEGER_32)  0;
								tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
								if (tb1) {
									ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
								} else {
									ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
								}
								/* END INLINED CODE */
							}
							Result = ti4_1;
						} else {
							tb1 = '\0';
							tb2 = '\0';
							tb3 = '\0';
							tr1 = *(EIF_REFERENCE *)(Current);
							ti4_1 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
							if ((EIF_BOOLEAN) (ti4_1 >= ((EIF_INTEGER_32) 10L))) {
								tb3 = (EIF_BOOLEAN)(loc1 == (EIF_CHARACTER_8) '\\');
							}
							if (tb3) {
								tr1 = *(EIF_REFERENCE *)(Current);
								tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R14092[Dtype(RTCW(tr1))-1618])(tr1, ((EIF_INTEGER_32) 3L)));
								tb2 = (EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) '\\');
							}
							if (tb2) {
								tr1 = *(EIF_REFERENCE *)(Current);
								tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R14092[Dtype(RTCW(tr1))-1618])(tr1, ((EIF_INTEGER_32) 5L)));
								tb1 = (EIF_BOOLEAN)(tc1 != (EIF_CHARACTER_8) '\\');
							}
							if (tb1) {
								loc2 = F2102_21777(Current, ((EIF_INTEGER_32) 7L));
								tb1 = '\0';
								if ((EIF_BOOLEAN) (loc2 > ((EIF_INTEGER_32) 0L))) {
									{
										/* INLINED CODE (PATH.unit_size) */
										ti4_1 = (EIF_INTEGER_32)  0;
										tb2 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
										if (tb2) {
											ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
										} else {
											ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
										}
										/* END INLINED CODE */
									}
									tr1 = *(EIF_REFERENCE *)(Current);
									ti4_2 = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
									tb1 = (EIF_BOOLEAN) ((EIF_INTEGER_32) (loc2 + ti4_1) <= ti4_2);
								}
								if (tb1) {
									{
										/* INLINED CODE (PATH.unit_size) */
										ti4_1 = (EIF_INTEGER_32)  0;
										tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
										if (tb1) {
											ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
										} else {
											ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
										}
										/* END INLINED CODE */
									}
									ti4_2 = ti4_1;
									ti4_1 = F2102_21777(Current, (EIF_INTEGER_32) (loc2 + ti4_2));
									loc2 = (EIF_INTEGER_32) ti4_1;
									if ((EIF_BOOLEAN) (loc2 > ((EIF_INTEGER_32) 0L))) {
										RTLE;
										return (EIF_INTEGER_32) (EIF_INTEGER_32) (loc2 + ((EIF_INTEGER_32) 1L));
									} else {
										tr1 = *(EIF_REFERENCE *)(Current);
										Result = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
									}
								}
							}
						}
					}
				}
			}
		} else {
			tr1 = *(EIF_REFERENCE *)(Current);
			tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R14092[Dtype(RTCW(tr1))-1618])(tr1, ((EIF_INTEGER_32) 1L)));
			if ((EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) '/')) {
				RTLE;
				return (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
			}
		}
	}
	RTLE;
	return Result;
}

/* {PATH}.end_position_of_last_directory_separator */
EIF_INTEGER_32 F2102_21776 (EIF_REFERENCE Current)
{
	GTCX
	EIF_REFERENCE tr1 = NULL;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_CHARACTER_8 tc1;
	EIF_CHARACTER_8 tc2;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,tr1);
	RTLIU(2);
	
	RTGC;
	tr1 = *(EIF_REFERENCE *)(Current);
	{
		/* INLINED CODE (FINITE.is_empty) */
		tb1 = (EIF_BOOLEAN)  0;
		(void) RTCW(tr1);
		ti4_1 = *(EIF_INTEGER_32 *)(tr1+ _LNGOFF_1_1_0_2_);
		tb1 = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 0L));
		/* END INLINED CODE */
	}
	tb1 = tb1;
	if ((EIF_BOOLEAN) !tb1) {
		tr1 = *(EIF_REFERENCE *)(Current);
		Result = *(EIF_INTEGER_32 *)(RTCW(tr1)+ _LNGOFF_1_1_0_2_);
		{
			/* INLINED CODE (PATH.unit_size) */
			ti4_1 = (EIF_INTEGER_32)  0;
			tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
			if (tb1) {
				ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
			} else {
				ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
			}
			/* END INLINED CODE */
		}
		ti4_2 = ti4_1;
		Result = (EIF_INTEGER_32) (EIF_INTEGER_32) ((EIF_INTEGER_32) (Result - ti4_2) + ((EIF_INTEGER_32) 1L));
		if ((EIF_BOOLEAN) (Result >= ((EIF_INTEGER_32) 1L))) {
			for (;;) {
				tb1 = '\01';
				if (!(EIF_BOOLEAN) (Result < ((EIF_INTEGER_32) 1L))) {
					tr1 = *(EIF_REFERENCE *)(Current);
					{
						/* INLINED CODE (PATH.directory_separator) */
						tc1 = (EIF_CHARACTER_8)  0;
						tb2 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
						if (tb2) {
							tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
						} else {
							tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
						}
						/* END INLINED CODE */
					}
					tc2 = tc1;
					tb1 = F2102_21781(Current, tr1, Result, tc2);
				}
				if (tb1) break;
				{
					/* INLINED CODE (PATH.unit_size) */
					ti4_1 = (EIF_INTEGER_32)  0;
					tb2 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
					if (tb2) {
						ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
					} else {
						ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
					}
					/* END INLINED CODE */
				}
				Result -= ti4_1;
			}
		}
		if ((EIF_BOOLEAN) (Result < ((EIF_INTEGER_32) 0L))) {
			RTLE;
			return (EIF_INTEGER_32) ((EIF_INTEGER_32) 0L);
		} else {
			{
				/* INLINED CODE (PATH.unit_size) */
				ti4_1 = (EIF_INTEGER_32)  0;
				tb2 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
				if (tb2) {
					ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
				} else {
					ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
				}
				/* END INLINED CODE */
			}
			ti4_2 = ti4_1;
			Result = (EIF_INTEGER_32) (EIF_INTEGER_32) ((EIF_INTEGER_32) (Result + ti4_2) - ((EIF_INTEGER_32) 1L));
		}
	}
	RTLE;
	return Result;
}

/* {PATH}.next_directory_separator */
EIF_INTEGER_32 F2102_21777 (EIF_REFERENCE Current, EIF_INTEGER_32 arg1)
{
	GTCX
	EIF_INTEGER_32 loc1 = (EIF_INTEGER_32) 0;
	EIF_INTEGER_32 loc2 = (EIF_INTEGER_32) 0;
	EIF_CHARACTER_8 loc3 = (EIF_CHARACTER_8) 0;
	EIF_REFERENCE loc4 = (EIF_REFERENCE) 0;
	EIF_INTEGER_32 ti4_1;
	EIF_BOOLEAN tb1;
	EIF_CHARACTER_8 tc1;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(2);
	RTLR(0,Current);
	RTLR(1,loc4);
	RTLIU(2);
	
	RTGC;
	{
		/* INLINED CODE (PATH.unit_size) */
		ti4_1 = (EIF_INTEGER_32)  0;
		tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
		if (tb1) {
			ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
		} else {
			ti4_1 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
		}
		/* END INLINED CODE */
	}
	loc2 = ti4_1;
	{
		/* INLINED CODE (PATH.directory_separator) */
		tc1 = (EIF_CHARACTER_8)  0;
		tb1 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
		if (tb1) {
			tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '\\';
		} else {
			tc1 = (EIF_CHARACTER_8) (EIF_CHARACTER_8) '/';
		}
		/* END INLINED CODE */
	}
	loc3 = tc1;
	Result = (EIF_INTEGER_32) arg1;
	loc4 = *(EIF_REFERENCE *)(Current);
	loc1 = *(EIF_INTEGER_32 *)(RTCW(loc4)+ _LNGOFF_1_1_0_2_);
	for (;;) {
		tb1 = '\01';
		if (!(EIF_BOOLEAN) ((EIF_BOOLEAN) (Result < ((EIF_INTEGER_32) 1L)) || (EIF_BOOLEAN) (Result > loc1))) {
			tb1 = F2102_21781(Current, loc4, Result, loc3);
		}
		if (tb1) break;
		Result += loc2;
	}
	if ((EIF_BOOLEAN) (Result > loc1)) {
		RTLE;
		return (EIF_INTEGER_32) ((EIF_INTEGER_32) 0L);
	}
	RTLE;
	return Result;
}

/* {PATH}.internal_append_into */
void F2102_21778 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2, EIF_CHARACTER_8 arg3)
{
	GTCX
	struct eif_ex_207 sloc1;
	EIF_REFERENCE loc1 = (EIF_REFERENCE) sloc1.data;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_CHARACTER_32 tw1;
	EIF_CHARACTER_32 tw2;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_BOOLEAN tb4;
	RTLD;
	
	memset (&sloc1.overhead, 0, OVERHEAD + _OBJSIZ_0_0_0_0_0_0_0_0_);
	sloc1.overhead.ov_flags = EO_EXP | EO_STACK;
	RT_DFS(&sloc1.overhead, eif_new_type(240, 0x00).id);
	RTLI(4);
	RTLR(0,arg2);
	RTLR(1,arg1);
	RTLR(2,Current);
	RTLR(3,loc1);
	RTLIU(4);
	
	RTGC;
	tb1 = (FUNCTION_CAST(EIF_BOOLEAN, (EIF_REFERENCE)) R17077[Dtype(RTCW(arg2))-2070])(arg2);
	if ((EIF_BOOLEAN) !tb1) {
		tb1 = '\0';
		tb2 = '\0';
		tb3 = '\0';
		if ((EIF_BOOLEAN)(arg3 != (EIF_CHARACTER_8) '\000')) {
			{
				/* INLINED CODE (FINITE.is_empty) */
				tb4 = (EIF_BOOLEAN)  0;
				(void) RTCW(arg1);
				ti4_1 = *(EIF_INTEGER_32 *)(arg1+ _LNGOFF_1_1_0_2_);
				tb4 = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 0L));
				/* END INLINED CODE */
			}
			tb4 = tb4;
			tb3 = (EIF_BOOLEAN) !tb4;
		}
		if (tb3) {
			ti4_1 = *(EIF_INTEGER_32 *)(RTCW(arg1)+ _LNGOFF_1_1_0_2_);
			{
				/* INLINED CODE (PATH.unit_size) */
				ti4_2 = (EIF_INTEGER_32)  0;
				tb3 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
				if (tb3) {
					ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
				} else {
					ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
				}
				/* END INLINED CODE */
			}
			ti4_3 = ti4_2;
			tb2 = (EIF_BOOLEAN) !F2102_21781(Current, arg1, (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 - ti4_3) + ((EIF_INTEGER_32) 1L)), arg3);
		}
		if (tb2) {
			tw1 = (FUNCTION_CAST(EIF_CHARACTER_32, (EIF_REFERENCE, EIF_INTEGER_32)) R17063[Dtype(RTCW(arg2))-2070])(arg2, ((EIF_INTEGER_32) 1L));
			tw2 = (EIF_CHARACTER_32) (EIF_CHARACTER_8) '/';
			tb1 = (EIF_BOOLEAN)(tw1 != tw2);
		}
		if (tb1) {
			if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
				tw1 = (FUNCTION_CAST(EIF_CHARACTER_32, (EIF_REFERENCE, EIF_INTEGER_32)) R17063[Dtype(RTCW(arg2))-2070])(arg2, ((EIF_INTEGER_32) 1L));
				tw2 = (EIF_CHARACTER_32) (EIF_CHARACTER_8) '\\';
				if ((EIF_BOOLEAN)(tw1 != tw2)) {
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R17250[Dtype(RTCW(arg1))-2071])(arg1, arg3);
					(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R17250[Dtype(RTCW(arg1))-2071])(arg1, (EIF_CHARACTER_8) '\000');
				}
			} else {
				(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R17250[Dtype(RTCW(arg1))-2071])(arg1, arg3);
			}
		}
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
			F241_4230(RTCW(loc1), arg2, arg1);
		} else {
			F241_4205(RTCW(loc1), arg2, arg1);
		}
	}
	RTLE;
}

/* {PATH}.internal_path_append_into */
void F2102_21779 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2, EIF_CHARACTER_8 arg3)
{
	GTCX
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_BOOLEAN tb4;
	RTLD;
	
	RTLI(3);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,arg2);
	RTLIU(3);
	
	RTGC;
	tb1 = '\0';
	tb2 = '\0';
	tb3 = '\0';
	if ((EIF_BOOLEAN)(arg3 != (EIF_CHARACTER_8) '\000')) {
		{
			/* INLINED CODE (FINITE.is_empty) */
			tb4 = (EIF_BOOLEAN)  0;
			(void) RTCW(arg1);
			ti4_1 = *(EIF_INTEGER_32 *)(arg1+ _LNGOFF_1_1_0_2_);
			tb4 = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 0L));
			/* END INLINED CODE */
		}
		tb4 = tb4;
		tb3 = (EIF_BOOLEAN) !tb4;
	}
	if (tb3) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(arg1)+ _LNGOFF_1_1_0_2_);
		{
			/* INLINED CODE (PATH.unit_size) */
			ti4_2 = (EIF_INTEGER_32)  0;
			tb3 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
			if (tb3) {
				ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
			} else {
				ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
			}
			/* END INLINED CODE */
		}
		ti4_3 = ti4_2;
		tb2 = (EIF_BOOLEAN) !F2102_21781(Current, arg1, (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 - ti4_3) + ((EIF_INTEGER_32) 1L)), arg3);
	}
	if (tb2) {
		tb1 = (EIF_BOOLEAN) !F2102_21781(Current, arg2, ((EIF_INTEGER_32) 1L), arg3);
	}
	if (tb1) {
		(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R17250[Dtype(RTCW(arg1))-2071])(arg1, arg3);
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R17250[Dtype(RTCW(arg1))-2071])(arg1, (EIF_CHARACTER_8) '\000');
		}
	}
	(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_REFERENCE)) R17246[Dtype(RTCW(arg1))-2071])(arg1, arg2);
	RTLE;
}

/* {PATH}.internal_path_append_substring_into */
void F2102_21780 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_REFERENCE arg2, EIF_INTEGER_32 arg3, EIF_INTEGER_32 arg4, EIF_CHARACTER_8 arg5)
{
	GTCX
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_BOOLEAN tb1;
	EIF_BOOLEAN tb2;
	EIF_BOOLEAN tb3;
	EIF_BOOLEAN tb4;
	RTLD;
	
	RTLI(3);
	RTLR(0,arg1);
	RTLR(1,Current);
	RTLR(2,arg2);
	RTLIU(3);
	
	RTGC;
	tb1 = '\0';
	tb2 = '\0';
	tb3 = '\0';
	if ((EIF_BOOLEAN)(arg5 != (EIF_CHARACTER_8) '\000')) {
		{
			/* INLINED CODE (FINITE.is_empty) */
			tb4 = (EIF_BOOLEAN)  0;
			(void) RTCW(arg1);
			ti4_1 = *(EIF_INTEGER_32 *)(arg1+ _LNGOFF_1_1_0_2_);
			tb4 = (EIF_BOOLEAN) (EIF_BOOLEAN)(ti4_1 == ((EIF_INTEGER_32) 0L));
			/* END INLINED CODE */
		}
		tb4 = tb4;
		tb3 = (EIF_BOOLEAN) !tb4;
	}
	if (tb3) {
		ti4_1 = *(EIF_INTEGER_32 *)(RTCW(arg1)+ _LNGOFF_1_1_0_2_);
		{
			/* INLINED CODE (PATH.unit_size) */
			ti4_2 = (EIF_INTEGER_32)  0;
			tb3 = (EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b;
			if (tb3) {
				ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 2L);
			} else {
				ti4_2 = (EIF_INTEGER_32) ((EIF_INTEGER_32) 1L);
			}
			/* END INLINED CODE */
		}
		ti4_3 = ti4_2;
		tb2 = (EIF_BOOLEAN) !F2102_21781(Current, arg1, (EIF_INTEGER_32) ((EIF_INTEGER_32) (ti4_1 - ti4_3) + ((EIF_INTEGER_32) 1L)), arg5);
	}
	if (tb2) {
		tb1 = (EIF_BOOLEAN) !F2102_21781(Current, arg2, arg3, arg5);
	}
	if (tb1) {
		(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R17250[Dtype(RTCW(arg1))-2071])(arg1, arg5);
		if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
			(FUNCTION_CAST(void, (EIF_REFERENCE, EIF_CHARACTER_8)) R17250[Dtype(RTCW(arg1))-2071])(arg1, (EIF_CHARACTER_8) '\000');
		}
	}
	F2072_20926(RTCW(arg1), arg2, arg3, arg4);
	RTLE;
}

/* {PATH}.is_character */
EIF_BOOLEAN F2102_21781 (EIF_REFERENCE Current, EIF_REFERENCE arg1, EIF_INTEGER_32 arg2, EIF_CHARACTER_8 arg3)
{
	GTCX
	EIF_CHARACTER_8 tc1;
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,arg1);
	RTLIU(1);
	
	RTGC;
	if ((EIF_BOOLEAN) eif_builtin_PLATFORM_is_windows__b) {
		Result = '\0';
		tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R14092[Dtype(RTCW(arg1))-1618])(arg1, arg2));
		if ((EIF_BOOLEAN)(tc1 == arg3)) {
			tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R14092[Dtype(RTCW(arg1))-1618])(arg1, (EIF_INTEGER_32) (arg2 + ((EIF_INTEGER_32) 1L))));
			Result = (EIF_BOOLEAN)(tc1 == (EIF_CHARACTER_8) '\000');
		}
	} else {
		tc1 = (eif_optimize_return = 1, *(EIF_CHARACTER_8 *)(FUNCTION_CAST(EIF_REFERENCE, (EIF_REFERENCE, EIF_INTEGER_32)) R14092[Dtype(RTCW(arg1))-1618])(arg1, arg2));
		Result = (EIF_BOOLEAN) (EIF_BOOLEAN)(tc1 == arg3);
	}
	RTLE;
	return Result;
}

/* {PATH}.c_same_files */
EIF_BOOLEAN F2102_21784 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2)
{
	GTCX
	EIF_BOOLEAN Result = ((EIF_BOOLEAN) 0);
	
	
	
	Result = EIF_TEST(inline_F2102_21784 ((EIF_POINTER) arg1, (EIF_POINTER) arg2));
	return Result;
}

void EIF_Minit1252 (void)
{
	GTCX
}


#ifdef __cplusplus
}
#endif
