/*
 * Code for class GDK_X11
 */

#include "eif_eiffel.h"
#include "../E1/estructure.h"
#include "../E1/eoffsets.h"

#include "gd723.h"
#include <ev_gtk.h>
#include "eif_misc.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifndef INLINE_F795_12210
static void inline_F795_12210 (EIF_POINTER arg1)
{
	#ifdef GDK_WINDOWING_X11
	return gdk_x11_display_error_trap_push ((GdkDisplay *)arg1);
#endif
	;
}
#define INLINE_F795_12210
#endif
#ifndef INLINE_F795_12212
static EIF_POINTER inline_F795_12212 (EIF_POINTER arg1)
{
	#ifdef GDK_WINDOWING_X11 
		/* Declarations */
	GC gc;									/* handle of newly created GC.  */
	unsigned long valuemask = 0;			/* which values in 'values' to  */
	Window win =  gdk_x11_window_get_xid ((GdkWindow *)arg1);
	Display* display = GDK_SCREEN_XDISPLAY(gdk_window_get_screen ((GdkWindow *)arg1));
		/* Define properties/values for the GC.  */
	XGCValues values;						/* initial values for the GC.   */
	unsigned int line_width = 1;			/* line width for the GC.       */
	int line_style = LineSolid;				/* style for lines drawing and  */
	int cap_style = CapButt;				/* style of the line's edje and */
	int join_style = JoinBevel;				/* joined lines.		*/
	values.function = GXcopy;               /* src */
	values.subwindow_mode = ClipByChildren; /* GCSubwindowMode */
	values.line_width = line_width;
	values.fill_style = FillSolid;
	values.arc_mode = ArcPieSlice;
	values.graphics_exposures = False;
	valuemask = GCFunction | GCFillStyle | GCArcMode | GCSubwindowMode | GCGraphicsExposures;
		/* Create the GC object */
	gc = XCreateGC(display, win, valuemask, &values);
	if (gc < 0) {
		fprintf(stderr, "XCreateGC: \n");
	}
	return gc;
#endif
	;
}
#define INLINE_F795_12212
#endif
#ifndef INLINE_F795_12216
static EIF_POINTER inline_F795_12216 (EIF_POINTER arg1)
{
	#ifdef GDK_WINDOWING_X11 
	return (EIF_POINTER) GDK_SCREEN_XDISPLAY(gdk_window_get_screen ((GdkWindow *)arg1));
#endif
	;
}
#define INLINE_F795_12216
#endif
#ifndef INLINE_F795_12231
static EIF_INTEGER_32 inline_F795_12231 (void)
{
	#ifdef GDK_WINDOWING_X11
return LineSolid;
#endif
	;
}
#define INLINE_F795_12231
#endif
#ifndef INLINE_F795_12232
static EIF_INTEGER_32 inline_F795_12232 (void)
{
	#ifdef GDK_WINDOWING_X11
return CapButt;
#endif
	;
}
#define INLINE_F795_12232
#endif
#ifndef INLINE_F795_12233
static EIF_INTEGER_32 inline_F795_12233 (void)
{
	#ifdef GDK_WINDOWING_X11
return JoinBevel;
#endif
	;
}
#define INLINE_F795_12233
#endif
#ifndef INLINE_F795_12220
static void inline_F795_12220 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5, EIF_INTEGER_32 arg6)
{
	#ifdef GDK_WINDOWING_X11 
				XSetLineAttributes((Display*) arg1, (GC) arg2, 
					(unsigned int) arg3,
      				(int) arg4, (int) arg5, (int) arg6);
				#endif
	;
}
#define INLINE_F795_12220
#endif
#ifndef INLINE_F795_12221
static void inline_F795_12221 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3, EIF_POINTER arg4, EIF_INTEGER_32 arg5)
{
	#ifdef GDK_WINDOWING_X11 
	XSetDashes ((Display*) arg1, (GC) arg2, (int) arg3, (char*) arg4, (int) arg5);
#endif
	;
}
#define INLINE_F795_12221
#endif
#ifndef INLINE_F795_12230
static EIF_INTEGER_32 inline_F795_12230 (void)
{
	#ifdef GDK_WINDOWING_X11
return LineOnOffDash;
#endif
	;
}
#define INLINE_F795_12230
#endif
#ifndef INLINE_F795_12217
static EIF_POINTER inline_F795_12217 (EIF_POINTER arg1)
{
	#ifdef GDK_WINDOWING_X11 
	return (EIF_POINTER) gdk_x11_window_get_xid ((GdkWindow *) arg1);
#endif
	;
}
#define INLINE_F795_12217
#endif
#ifndef INLINE_F795_12218
static void inline_F795_12218 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3)
{
	#ifdef GDK_WINDOWING_X11 
XSetFunction((Display*) arg1, (GC) arg2, (int) arg3);
#endif
	;
}
#define INLINE_F795_12218
#endif
#ifndef INLINE_F795_12219
static void inline_F795_12219 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3)
{
	#ifdef GDK_WINDOWING_X11 
XSetSubwindowMode((Display *)arg1, (GC)arg2, (int)arg3);
#endif
	;
}
#define INLINE_F795_12219
#endif
#ifndef INLINE_F795_12222
static void inline_F795_12222 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3)
{
	#ifdef GDK_WINDOWING_X11 
XSetFillStyle((Display*)arg1, (GC) arg2, (int)arg3);	
#endif
	;
}
#define INLINE_F795_12222
#endif
#ifndef INLINE_F795_12224
static void inline_F795_12224 (EIF_POINTER arg1)
{
	#ifdef GDK_WINDOWING_X11 
	XFlush((Display*) arg1);
#endif
	;
}
#define INLINE_F795_12224
#endif
#ifndef INLINE_F795_12225
static EIF_INTEGER_32 inline_F795_12225 (void)
{
	#ifdef GDK_WINDOWING_X11
return FillSolid;
#endif
	;
}
#define INLINE_F795_12225
#endif
#ifndef INLINE_F795_12226
static EIF_INTEGER_32 inline_F795_12226 (void)
{
	#ifdef GDK_WINDOWING_X11
return FillTiled;
#endif
	;
}
#define INLINE_F795_12226
#endif
#ifndef INLINE_F795_12235
static EIF_INTEGER_32 inline_F795_12235 (void)
{
	#ifdef GDK_WINDOWING_X11 
return IncludeInferiors;
#endif
	;
}
#define INLINE_F795_12235
#endif
#ifndef INLINE_F795_12238
static void inline_F795_12238 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5)
{
	#ifdef GDK_WINDOWING_X11 
XColor color;
/* */
Colormap cmap =  DefaultColormap((Display*) arg1, DefaultScreen((Display*) arg1) );
color.red =   arg3;
color.green = arg4;
color.blue =  arg5;
color.flags = DoRed | DoGreen | DoBlue;
/* */
XAllocColor((Display*) arg1, cmap, &color);
XSetBackground((Display*) arg1, (GC) arg2, (unsigned long) color.pixel);
#endif
	;
}
#define INLINE_F795_12238
#endif
#ifndef INLINE_F795_12239
static void inline_F795_12239 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5)
{
	#ifdef GDK_WINDOWING_X11 
XColor color;
Colormap cmap = DefaultColormap((Display*) arg1, DefaultScreen((Display*) arg1));
color.red =   arg3;
color.green = arg4;
color.blue =  arg5;
color.flags = DoRed | DoGreen | DoBlue;
XAllocColor((Display*) arg1, cmap, &color);
XSetForeground((Display*) arg1, (GC) arg2, (unsigned long) color.pixel);
#endif
	;
}
#define INLINE_F795_12239
#endif
#ifndef INLINE_F795_12241
static EIF_INTEGER_32 inline_F795_12241 (void)
{
	#ifdef GDK_WINDOWING_X11
return GXand;
#endif
	;
}
#define INLINE_F795_12241
#endif
#ifndef INLINE_F795_12243
static EIF_INTEGER_32 inline_F795_12243 (void)
{
	#ifdef GDK_WINDOWING_X11
return GXcopy;
#endif
	;
}
#define INLINE_F795_12243
#endif
#ifndef INLINE_F795_12246
static EIF_INTEGER_32 inline_F795_12246 (void)
{
	#ifdef GDK_WINDOWING_X11
return GXxor;
#endif
	;
}
#define INLINE_F795_12246
#endif
#ifndef INLINE_F795_12247
static EIF_INTEGER_32 inline_F795_12247 (void)
{
	#ifdef GDK_WINDOWING_X11
return GXor;
#endif
	;
}
#define INLINE_F795_12247
#endif
#ifndef INLINE_F795_12250
static EIF_INTEGER_32 inline_F795_12250 (void)
{
	#ifdef GDK_WINDOWING_X11
return GXinvert;
#endif
	;
}
#define INLINE_F795_12250
#endif
#ifndef INLINE_F795_12256
static void inline_F795_12256 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5, EIF_INTEGER_32 arg6, EIF_INTEGER_32 arg7)
{
	#ifdef GDK_WINDOWING_X11 
	Window win = (Window) arg1;
	/*
	 * TODO check Gdkgc-x11 _gdk_x11_gc_flush implementation 
	 * that's used before
	 * for example gdk_x11_draw_segments the usage of
	 * GDK_GC_GET_XGC (gc),
	 * https://github.com/coapp-packages/gtk/blob/master/gdk/x11/gdkdrawable-x11.c
	 */
						
	XDrawLine((Display*) arg2, win, arg3, arg4, arg5, arg6, arg7);
	
#endif
	;
}
#define INLINE_F795_12256
#endif
#ifndef INLINE_F795_12257
static void inline_F795_12257 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5)
{
	#ifdef GDK_WINDOWING_X11 
	XDrawPoint ((Display*) arg2, (Drawable) arg1, arg3, arg4, arg5);
#endif
	;
}
#define INLINE_F795_12257
#endif
#ifndef INLINE_F795_12258
static void inline_F795_12258 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4, EIF_INTEGER_32 arg5, EIF_INTEGER_32 arg6, EIF_INTEGER_32 arg7, EIF_INTEGER_32 arg8, EIF_INTEGER_32 arg9, EIF_INTEGER_32 arg10)
{
	#ifdef GDK_WINDOWING_X11 
					Window win = (Window) arg1;
					if (arg7 < 0 || arg8 < 0)
					{
						gint real_width;
						gint real_height;
						XWindowAttributes wa;
						XGetWindowAttributes((Display*) arg2, win, &wa);
						real_width = wa.width;
						real_height = wa.height;

						if (arg7 < 0)
							arg7 = real_width;
						if (arg8 < 0)
							arg8 = real_height;
					}

					if (arg4)
					    XFillArc ((Display*) arg2, win, arg3, arg5, arg6, arg7, arg8, arg9, arg10);
					else
					    XDrawArc ((Display*) arg2, win, arg3, arg5, arg6, arg7, arg8, arg9, arg10);	
	
				#endif
	;
}
#define INLINE_F795_12258
#endif
#ifndef INLINE_F795_12259
static void inline_F795_12259 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4, EIF_INTEGER_32 arg5, EIF_INTEGER_32 arg6, EIF_INTEGER_32 arg7, EIF_INTEGER_32 arg8)
{
	#ifdef GDK_WINDOWING_X11 
					Window win = (Window) arg1;
					if (arg7 < 0 || arg8 < 0)
					{
						gint real_width;
						gint real_height;
						
						XWindowAttributes wa;
						XGetWindowAttributes((Display*) arg2, win, &wa);
						real_width = wa.width;
						real_height = wa.height;
					   
					   	if (arg7 < 0)
							arg7 = real_width;
						if (arg8 < 0)
							arg8 = real_height;
					}

					if (arg4)
					    XFillRectangle ((Display*) arg2, win, arg3, arg5, arg6, arg7, arg8);
					else
					    XDrawRectangle ((Display*) arg2, win, arg3, arg5, arg6, arg7, arg8);

				#endif
	;
}
#define INLINE_F795_12259
#endif
#ifndef INLINE_F795_12260
static void inline_F795_12260 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_POINTER arg4, EIF_INTEGER_32 arg5)
{
	#ifdef GDK_WINDOWING_X11 
					Window win = (Window) arg1;
					gint i;
					XPoint *tmp_points = g_new (XPoint, arg5);

					for (i=0; i<arg5; i++)
				    {
				      tmp_points[i].x = ((GdkPoint *)arg4)[i].x;
				      tmp_points[i].y = ((GdkPoint *)arg4)[i].y;
				    }
				    					
					XDrawLines ((Display*) arg2, win, arg3, tmp_points, arg5, CoordModeOrigin);
					g_free (tmp_points);
				#endif
	;
}
#define INLINE_F795_12260
#endif
#ifndef INLINE_F795_12261
static void inline_F795_12261 (EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4, EIF_POINTER arg5, EIF_INTEGER_32 arg6)
{
	#ifdef GDK_WINDOWING_X11 
					Window win = (Window) arg1;
					XPoint *tmp_points;
 					gint tmp_npoints, i;


					if (!(arg4) &&
				      ( ((GdkPoint *)arg5)[0].x != ((GdkPoint *)arg5)[arg6-1].x || ((GdkPoint *)arg5)[0].y != ((GdkPoint *)arg5)[arg6-1].y))
				    {
				      tmp_npoints = arg6 + 1;
				      tmp_points = g_new (XPoint, tmp_npoints);
				      tmp_points[arg6].x = ((GdkPoint *)arg5)[0].x;
				      tmp_points[arg6].y = ((GdkPoint *)arg5)[0].y;
				    }
				  	else
				    {
				      tmp_npoints = arg6;
				      tmp_points = g_new (XPoint, tmp_npoints);
				    }

				  	for (i=0; i<arg6; i++)
				    {
				      tmp_points[i].x = ((GdkPoint *)arg5)[i].x;
				      tmp_points[i].y = ((GdkPoint *)arg5)[i].y;
				    }


				    if (arg4)
						XFillPolygon ((Display*) arg2, win, arg3, tmp_points, tmp_npoints, Complex, CoordModeOrigin);					
					else	
						XDrawLines ((Display*) arg2, win, arg3, tmp_points, tmp_npoints, CoordModeOrigin);
						
					g_free (tmp_points);
				#endif
	;
}
#define INLINE_F795_12261
#endif

#ifdef __cplusplus
}
#endif


#ifdef __cplusplus
extern "C" {
#endif

/* {GDK_X11}.gdk_x11_display_error_trap_push */
void F795_12210 (EIF_REFERENCE Current, EIF_POINTER arg1)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("gdk_x11_display_error_trap_push", 794, Current, 0, 1, 11037);
	inline_F795_12210 ((EIF_POINTER) arg1);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.create_gc */
EIF_POINTER F795_12212 (EIF_REFERENCE Current, EIF_POINTER arg1)
{
	GTCX
	RTEX;
	EIF_POINTER Result = ((EIF_POINTER) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("create_gc", 794, Current, 0, 1, 10986);
	Result = inline_F795_12212 ((EIF_POINTER) arg1);
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.set_line_attributes_to_solid_style */
void F795_12213 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3)
{
	GTCX
	RTEX;
	EIF_POINTER tp1;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("set_line_attributes_to_solid_style", 794, Current, 0, 3, 10987);
	RTGC;
	RTHOOK(1);
	tp1 = inline_F795_12216(arg1);
	ti4_1 = inline_F795_12231();
	ti4_2 = inline_F795_12232();
	ti4_3 = inline_F795_12233();
	inline_F795_12220(tp1, arg2, arg3, ti4_1, ti4_2, ti4_3);
	RTHOOK(2);
	RTLE;
	RTEE;
}

/* {GDK_X11}.set_line_attributes_to_dashed_style */
void F795_12214 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3)
{
	GTCX
	RTEX;
	EIF_POINTER loc1 = (EIF_POINTER) 0;
	EIF_INTEGER_16 loc2 = (EIF_INTEGER_16) 0;
	EIF_INTEGER_32 ti4_1;
	EIF_INTEGER_32 ti4_2;
	EIF_INTEGER_32 ti4_3;
	EIF_INTEGER_16 ti2_1;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("set_line_attributes_to_dashed_style", 794, Current, 2, 3, 10988);
	RTGC;
	RTHOOK(1);
	loc1 = inline_F795_12216(arg1);
	RTHOOK(2);
	ti2_1 = eif_bit_shift_left(((EIF_INTEGER_16) 3L),((EIF_INTEGER_32) 8L));
	loc2 = eif_bit_or(((EIF_INTEGER_16) 3L),ti2_1);
	RTHOOK(3);
	inline_F795_12221(loc1, arg2, ((EIF_INTEGER_32) 0L), (EIF_INTEGER_16 *) &(loc2), ((EIF_INTEGER_32) 2L));
	RTHOOK(4);
	ti4_1 = inline_F795_12230();
	ti4_2 = inline_F795_12232();
	ti4_3 = inline_F795_12233();
	inline_F795_12220(loc1, arg2, arg3, ti4_1, ti4_2, ti4_3);
	RTHOOK(5);
	RTLE;
	RTEE;
}

/* {GDK_X11}.x_display */
EIF_POINTER F795_12216 (EIF_REFERENCE Current, EIF_POINTER arg1)
{
	GTCX
	RTEX;
	EIF_POINTER Result = ((EIF_POINTER) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_display", 794, Current, 0, 1, 10990);
	Result = inline_F795_12216 ((EIF_POINTER) arg1);
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.x_window */
EIF_POINTER F795_12217 (EIF_REFERENCE Current, EIF_POINTER arg1)
{
	GTCX
	RTEX;
	EIF_POINTER Result = ((EIF_POINTER) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_window", 794, Current, 0, 1, 10991);
	Result = inline_F795_12217 ((EIF_POINTER) arg1);
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.x_set_function */
void F795_12218 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_set_function", 794, Current, 0, 3, 10992);
	inline_F795_12218 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_INTEGER_32) arg3);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.x_set_subwindow_mode */
void F795_12219 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_set_subwindow_mode", 794, Current, 0, 3, 10993);
	inline_F795_12219 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_INTEGER_32) arg3);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.x_set_line_attributes */
void F795_12220 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5, EIF_INTEGER_32 arg6)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_set_line_attributes", 794, Current, 0, 6, 10994);
	inline_F795_12220 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_INTEGER_32) arg3, (EIF_INTEGER_32) arg4, (EIF_INTEGER_32) arg5, (EIF_INTEGER_32) arg6);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.x_set_dashes */
void F795_12221 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3, EIF_POINTER arg4, EIF_INTEGER_32 arg5)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_set_dashes", 794, Current, 0, 5, 10995);
	inline_F795_12221 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_INTEGER_32) arg3, (EIF_POINTER) arg4, (EIF_INTEGER_32) arg5);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.x_set_fill_style */
void F795_12222 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_set_fill_style", 794, Current, 0, 3, 10996);
	inline_F795_12222 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_INTEGER_32) arg3);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.x_flush */
void F795_12224 (EIF_REFERENCE Current, EIF_POINTER arg1)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_flush", 794, Current, 0, 1, 10998);
	inline_F795_12224 ((EIF_POINTER) arg1);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.x_fill_solid */
EIF_INTEGER_32 F795_12225 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_fill_solid", 794, Current, 0, 0, 10999);
	Result = inline_F795_12225 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.x_fill_tiled */
EIF_INTEGER_32 F795_12226 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_fill_tiled", 794, Current, 0, 0, 11000);
	Result = inline_F795_12226 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.x_style_line_on_off_dash */
EIF_INTEGER_32 F795_12230 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_style_line_on_off_dash", 794, Current, 0, 0, 11004);
	Result = inline_F795_12230 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.x_style_line_solid */
EIF_INTEGER_32 F795_12231 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_style_line_solid", 794, Current, 0, 0, 11005);
	Result = inline_F795_12231 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.x_style_cap_butt */
EIF_INTEGER_32 F795_12232 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_style_cap_butt", 794, Current, 0, 0, 11006);
	Result = inline_F795_12232 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.x_style_join_bevel */
EIF_INTEGER_32 F795_12233 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_style_join_bevel", 794, Current, 0, 0, 11007);
	Result = inline_F795_12233 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.x_subwindow_mode_include_inferiors */
EIF_INTEGER_32 F795_12235 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_subwindow_mode_include_inferiors", 794, Current, 0, 0, 11009);
	Result = inline_F795_12235 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.set_drawable_background */
void F795_12236 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5)
{
	GTCX
	RTEX;
	EIF_POINTER loc1 = (EIF_POINTER) 0;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("set_drawable_background", 794, Current, 1, 5, 11010);
	RTGC;
	RTHOOK(1);
	loc1 = inline_F795_12216(arg1);
	RTHOOK(2);
	inline_F795_12238(loc1, arg2, arg3, arg4, arg5);
	RTHOOK(3);
	RTLE;
	RTEE;
}

/* {GDK_X11}.set_drawable_foreground */
void F795_12237 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5)
{
	GTCX
	RTEX;
	EIF_POINTER loc1 = (EIF_POINTER) 0;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("set_drawable_foreground", 794, Current, 1, 5, 11011);
	RTGC;
	RTHOOK(1);
	loc1 = inline_F795_12216(arg1);
	RTHOOK(2);
	inline_F795_12239(loc1, arg2, arg3, arg4, arg5);
	RTHOOK(3);
	RTLE;
	RTEE;
}

/* {GDK_X11}.x_set_background */
void F795_12238 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_set_background", 794, Current, 0, 5, 11012);
	inline_F795_12238 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_INTEGER_32) arg3, (EIF_INTEGER_32) arg4, (EIF_INTEGER_32) arg5);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.x_set_foreground */
void F795_12239 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_INTEGER_32 arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_set_foreground", 794, Current, 0, 5, 11013);
	inline_F795_12239 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_INTEGER_32) arg3, (EIF_INTEGER_32) arg4, (EIF_INTEGER_32) arg5);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.x_function_gxand */
EIF_INTEGER_32 F795_12241 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_function_gxand", 794, Current, 0, 0, 11015);
	Result = inline_F795_12241 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.x_function_gxcopy */
EIF_INTEGER_32 F795_12243 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_function_gxcopy", 794, Current, 0, 0, 11017);
	Result = inline_F795_12243 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.x_function_gxxor */
EIF_INTEGER_32 F795_12246 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_function_gxxor", 794, Current, 0, 0, 11020);
	Result = inline_F795_12246 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.x_function_gxor */
EIF_INTEGER_32 F795_12247 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_function_gxor", 794, Current, 0, 0, 11021);
	Result = inline_F795_12247 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.x_function_gxinvert */
EIF_INTEGER_32 F795_12250 (EIF_REFERENCE Current)
{
	GTCX
	RTEX;
	EIF_INTEGER_32 Result = ((EIF_INTEGER_32) 0);
	
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("x_function_gxinvert", 794, Current, 0, 0, 11024);
	Result = inline_F795_12250 ();
	RTHOOK(1);
	RTLE;
	RTEE;
	return Result;
}

/* {GDK_X11}.draw_line */
void F795_12256 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5, EIF_INTEGER_32 arg6, EIF_INTEGER_32 arg7)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("draw_line", 794, Current, 0, 7, 11030);
	inline_F795_12256 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_POINTER) arg3, (EIF_INTEGER_32) arg4, (EIF_INTEGER_32) arg5, (EIF_INTEGER_32) arg6, (EIF_INTEGER_32) arg7);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.draw_point */
void F795_12257 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_INTEGER_32 arg4, EIF_INTEGER_32 arg5)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("draw_point", 794, Current, 0, 5, 11031);
	inline_F795_12257 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_POINTER) arg3, (EIF_INTEGER_32) arg4, (EIF_INTEGER_32) arg5);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.draw_arc */
void F795_12258 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4, EIF_INTEGER_32 arg5, EIF_INTEGER_32 arg6, EIF_INTEGER_32 arg7, EIF_INTEGER_32 arg8, EIF_INTEGER_32 arg9, EIF_INTEGER_32 arg10)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("draw_arc", 794, Current, 0, 10, 11032);
	inline_F795_12258 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_POINTER) arg3, (EIF_BOOLEAN) arg4, (EIF_INTEGER_32) arg5, (EIF_INTEGER_32) arg6, (EIF_INTEGER_32) arg7, (EIF_INTEGER_32) arg8, (EIF_INTEGER_32) arg9, (EIF_INTEGER_32) arg10);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.draw_rectangle */
void F795_12259 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4, EIF_INTEGER_32 arg5, EIF_INTEGER_32 arg6, EIF_INTEGER_32 arg7, EIF_INTEGER_32 arg8)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("draw_rectangle", 794, Current, 0, 8, 11033);
	inline_F795_12259 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_POINTER) arg3, (EIF_BOOLEAN) arg4, (EIF_INTEGER_32) arg5, (EIF_INTEGER_32) arg6, (EIF_INTEGER_32) arg7, (EIF_INTEGER_32) arg8);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.draw_lines */
void F795_12260 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_POINTER arg4, EIF_INTEGER_32 arg5)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("draw_lines", 794, Current, 0, 5, 11034);
	inline_F795_12260 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_POINTER) arg3, (EIF_POINTER) arg4, (EIF_INTEGER_32) arg5);
	RTHOOK(1);
	RTLE;
	RTEE;
}

/* {GDK_X11}.draw_polygon */
void F795_12261 (EIF_REFERENCE Current, EIF_POINTER arg1, EIF_POINTER arg2, EIF_POINTER arg3, EIF_BOOLEAN arg4, EIF_POINTER arg5, EIF_INTEGER_32 arg6)
{
	GTCX
	RTEX;
	RTLD;
	
	RTLI(1);
	RTLR(0,Current);
	RTLIU(1);
	
	RTEAA("draw_polygon", 794, Current, 0, 6, 11035);
	inline_F795_12261 ((EIF_POINTER) arg1, (EIF_POINTER) arg2, (EIF_POINTER) arg3, (EIF_BOOLEAN) arg4, (EIF_POINTER) arg5, (EIF_INTEGER_32) arg6);
	RTHOOK(1);
	RTLE;
	RTEE;
}

void EIF_Minit723 (void)
{
	GTCX
}


#ifdef __cplusplus
}
#endif
