note
	description: "[
		IO failure
		]"
	library: "Free implementation of ELKS library"
	copyright: "Copyright (c) 1986-2006, Eiffel Software and others"
	license: "Eiffel Forum License v2 (see forum.txt)"
	date: "$Date: 2009-01-19 07:34:21 -0800 (Mon, 19 Jan 2009) $"
	revision: "$Revision: 76753 $"

class
	IO_FAILURE

inherit
	DATA_EXCEPTION

feature -- Access

	frozen code: INTEGER
			-- Exception code
		do
			if internal_code = {EXCEP_CONST}.Io_exception then
				Result := internal_code
			else
					-- Default to `Runtime_io_exception'.
				Result := {EXCEP_CONST}.Runtime_io_exception
			end
		end

	error_code: INTEGER
			-- Error code

feature {EXCEPTION_MANAGER} -- Status setting

	set_error_code (a_code: like error_code)
			-- Set `error_code' with `a_code'
		do
			error_code := a_code
		end

	set_code (a_code: like code)
			-- Set `code' with `a_code'.
		do
			internal_code := code
		end

feature {NONE} -- Accesss

	frozen internal_meaning: STRING = "I/O error."

	internal_code: like code
			-- Internal code
end
