note

	status: "See notice at end of class.";
	date: "$Date: 2009-04-10 20:38:01 -0700 (Fri, 10 Apr 2009) $"
--	revision: "$Revision: 78205 $"
	product: "EiffelStore"
	database: "All bases"

class DB_ALL_TYPES inherit

	HANDLE_USE

create

	make

feature -- Initialization

	make
			-- Create an interface object to register
			-- all types for active base.
		do
			implementation := handle.database.db_all_types
			implementation.register_all
		end

feature -- Access

	db_type (object: ANY): DB_TYPE
			-- DB_TYPE instance of `object'
		require
			object_not_void: object /= Void
			object_is_register: is_registered (object)
		local
			l_result: detachable DB_TYPE
		do
			l_result := implementation.db_type (object)
			check l_result /= Void end -- implied by precondition `object_is_register'
			Result := l_result
		ensure
			Result = implementation.db_type (object)
		end

feature -- Status report

	is_registered (object: ANY): BOOLEAN
			-- Is `object' type registered?
		require
			object_not_void: object /= Void
		do
			Result := implementation.is_registered (object)
		ensure
			Result = implementation.is_registered (object)
		end

feature {NONE} -- Implementation

	implementation: DATABASE_ALL_TYPES [DATABASE]
		-- Handle reference to specific database implementation

invariant

	implementation_not_void: implementation /= Void

note
	copyright:	"Copyright (c) 1984-2006, Eiffel Software and others"
	license:	"Eiffel Forum License v2 (see http://www.eiffel.com/licensing/forum.txt)"
	source: "[
			 Eiffel Software
			 356 Storke Road, Goleta, CA 93117 USA
			 Telephone 805-685-1006, Fax 805-685-6869
			 Website http://www.eiffel.com
			 Customer support http://support.eiffel.com
		]"




end -- class DB_ALL_TYPES



