note
	description: "EiffelVision check menu. Cocoa implementation."
	legal: "See notice at end of class."
	status: "See notice at end of class."
	date: "$Date: 2009-05-27 07:19:24 -0700 (Wed, 27 May 2009) $";
	revision: "$Revision: 78896 $"

class
	EV_CHECK_MENU_ITEM_IMP

inherit
	EV_CHECK_MENU_ITEM_I
		redefine
			interface
		end

	EV_MENU_ITEM_IMP
		redefine
			make,
			interface
		end

create
	make

feature {NONE} -- Initialization

	make (an_interface: like interface)
			-- Create a menu.
		do
			base_make (an_interface)
			create {NS_MENU_ITEM}cocoa_item.make
		end

feature -- Status report

	is_selected: BOOLEAN
			-- Is this menu item checked?

feature -- Status setting

	enable_select
			-- Select this menu item.
		do
			is_selected := True
			menu_item.set_state ({NS_CELL}.on_state)
		end

	disable_select
			-- Deselect this menu item.
		do
			is_selected := False
			menu_item.set_state ({NS_CELL}.off_state)
		end

feature {NONE} -- Implementation

	interface: EV_CHECK_MENU_ITEM;

note
	copyright:	"Copyright (c) 2009, Daniel Furrer"
end -- class EV_CHECK_MENU_ITEM_IMP

