note
	description: "EiffelVision2 toolbar, Cocoa implementation."
	legal: "See notice at end of class."
	status: "See notice at end of class."
	date: "$Date: 2009-06-02 10:03:59 -0700 (Tue, 02 Jun 2009) $"
	revision: "$Revision: 79030 $"

class
	EV_TOOL_BAR_IMP

inherit
	EV_TOOL_BAR_I
		redefine
			interface
		end

	EV_PRIMITIVE_IMP
		undefine
			update_for_pick_and_drop, minimum_width, minimum_height,
			internal_set_minimum_height, internal_set_minimum_width, internal_set_minimum_size
		redefine
			interface,
			initialize,
			set_parent_imp,
			ev_apply_new_size
		end

	EV_ITEM_LIST_IMP [EV_TOOL_BAR_ITEM, EV_ITEM_IMP]
		undefine
			item_by_data
		redefine
			interface,
			initialize
		end

	EV_SIZEABLE_CONTAINER_IMP
		redefine
			interface
		end

create
	make

feature {NONE} -- Initialization

	make (an_interface: like interface)
			-- Create the tool-bar.
		do
			base_make (an_interface)
			create {NS_BOX}cocoa_item.make
			box.set_title_position ({NS_BOX}.no_title)
		end

	initialize
			-- Initialize `Current'.
		do
			Precursor {EV_ITEM_LIST_IMP}
			Precursor {EV_PRIMITIVE_IMP}
			has_vertical_button_style := True
		end

	set_parent_imp (a_container_imp: EV_CONTAINER_IMP)
			-- Set `parent_imp' to `a_container_imp'.
		do
			parent_imp := a_container_imp
		end

feature -- Status report

	has_vertical_button_style: BOOLEAN
			-- Is the `pixmap' displayed vertically above `text' for
			-- all buttons contained in `Current'? If `False', then
			-- the `pixmap' is displayed to left of `text'.

	is_vertical: BOOLEAN
			-- Are the buttons in `Current' arranged vertically?

feature -- Status setting

	enable_vertical_button_style
			-- Ensure `has_vertical_button_style' is `True'.
		do
			has_vertical_button_style := True
		end

	disable_vertical_button_style
			-- Ensure `has_vertical_button_style' is `False'.
		do
			has_vertical_button_style := False
		end

	enable_vertical
			-- Enable vertical toolbar style.
		do
			is_vertical := True
		end

	disable_vertical
			-- Disable vertical toolbar style (ie: Horizontal).
		do
			is_vertical := False
		end

feature -- Access

	insert_item (v: EV_ITEM_IMP; i: INTEGER_32)
		local
			l_view: NS_VIEW
		do
			l_view ?= v.cocoa_item
			box.add_subview (l_view)
			notify_change (nc_minsize, Current)
		end

	remove_item (button: EV_ITEM_IMP)
			-- Remove `button' from `current'.
		do
			-- TODO remove
			notify_change (nc_minsize, Current)
		end

feature -- Implementation

	compute_minimum_width
			-- Update the minimum-size of `Current'.
		do
			internal_set_minimum_width (20 * count)
		end

	compute_minimum_height
			-- Update the minimum-size of `Current'.
		do
			internal_set_minimum_height (30)
		end

	compute_minimum_size
			-- Recompute both the minimum_width and then
			-- minimum_height of `Current'.
		do
			compute_minimum_height
			compute_minimum_width
		end

	ev_apply_new_size (a_x_position, a_y_position, a_width, a_height: INTEGER_32; repaint: BOOLEAN)
			-- Precursor		
		local
			litem: EV_NS_VIEW
			x: INTEGER
			item_width, item_height: INTEGER
		do
			ev_move_and_resize (a_x_position, a_y_position, a_width, a_height, repaint)
			item_height := box.content_view.bounds.size.height
			from
				ev_children.start
				x := 0
			until
				ev_children.after
			loop
				litem ?= ev_children.item
				item_width := litem.minimum_width
				litem.cocoa_set_size (x, 0, item_width, item_height)
				x := x + item_width
				ev_children.forth
			end
		end

feature {EV_TOOL_BAR_RADIO_BUTTON_IMP} -- Radio button handling

	add_radio_button (w: EV_RADIO_PEER_IMP)
			-- Connect radio button to tool bar group.
		require
			w_not_void: w /= Void
		do
		end

	radio_group: POINTER

feature {EV_DOCKABLE_SOURCE_I} -- Implementation (obsolete?)

	block_selection_for_docking
			--
		do
		end

	insertion_position: INTEGER
			-- `Result' is index - 1 of item beneath the
			-- current mouse pointer or count + 1 if over the toolbar
			-- and not over a button.
		do
		end

feature {EV_ANY_I} -- Interface

	interface: EV_TOOL_BAR;

	box: NS_BOX
		do
			Result ?= cocoa_item
		end

note
	copyright:	"Copyright (c) 2009, Daniel Furrer"
end -- class EV_TOOL_BAR_IMP

