note

	description:

		"Routines for determining class of Unicode characters"

	generator: "geuc"

	library: "Gobo Eiffel String Library"
	copyright: "Copyright (c) 2005, Colin Adams and others"
	license: "MIT License"
	date: "$Date: 2012-08-22 12:54:13 -0700 (Wed, 22 Aug 2012) $"
	revision: "$Revision: 89387 $"

class ST_UNICODE_V510_CHARACTER_CLASS_ROUTINES

inherit

	ST_UNICODE_CHARACTER_CLASS_INTERFACE


feature -- Access

	major_version: INTEGER
			-- Major version number of Unicode
		once
			Result := 5
		end

	minor_version: INTEGER
			-- Minor version number of Unicode
		once
			Result := 1
		end

	update_version: INTEGER
			-- Update version number of Unicode
		once
			Result := 0
		end

feature {NONE} -- Implementation

	character_class_plane_0_segment_0: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/26/%/26/%/26/%/26/%/26/%/26/%/26/%/26/%/26/%/26/%/26/%/26/%/26/%/26/%/26/%/26/%/26/%/26/%/26/%/26/%/26/%/26/%/26/%/26/%/26/%/26/%/26/%/26/%/26/%/26/%/26/%/26/%/23/%/18/%/18/%/18/%/20/%/18/%/18/%/18/%/14/%/15/%/18/%/19/%/18/%/13/%/18/%/18/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/18/%/18/%/19/%/19/%/19/%/18/%/18/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/14/%/18/%/15/%/21/%/12/%/21/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/14/%/19/%/15/%/19/%/26/%/26/%/26/%/26/%/26/%/26/%/26/%/26/%/26/%/26/%/26/%/26/%/26/%/26/%/26/%/26/%/26/%/26/%/26/%/26/%/26/%/26/%/26/%/26/%/26/%/26/%/26/%/26/%/26/%/26/%/26/%/26/%/26/%/23/%/18/%/20/%/20/%/20/%/20/%/22/%/22/%/21/%/22/%/2/%/16/%/19/%/27/%/22/%/21/%/22/%/19/%/11/%/11/%/21/%/2/%/22/%/18/%/21/%/11/%/2/%/17/%/11/%/11/%/11/%/18/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/19/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/19/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_1: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/1/%/2/%/1/%/2/%/1/%/2/%/2/%/2/%/1/%/1/%/2/%/1/%/2/%/1/%/1/%/2/%/1/%/1/%/1/%/2/%/2/%/1/%/1/%/1/%/1/%/2/%/1/%/1/%/2/%/1/%/1/%/1/%/2/%/2/%/2/%/1/%/1/%/2/%/1/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/1/%/2/%/1/%/2/%/2/%/1/%/2/%/1/%/1/%/2/%/1/%/1/%/1/%/2/%/1/%/2/%/1/%/1/%/2/%/2/%/5/%/1/%/2/%/2/%/2/%/5/%/5/%/5/%/5/%/1/%/3/%/2/%/1/%/3/%/2/%/1/%/3/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/2/%/1/%/3/%/2/%/1/%/2/%/1/%/1/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_2: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/1/%/1/%/2/%/1/%/1/%/2/%/2/%/1/%/2/%/1/%/1/%/1/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/5/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/21/%/21/%/21/%/21/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/21/%/21/%/21/%/21/%/21/%/21/%/21/%/21/%/21/%/21/%/21/%/21/%/21/%/21/%/4/%/4/%/4/%/4/%/4/%/21/%/21/%/21/%/21/%/21/%/21/%/21/%/4/%/21/%/4/%/21/%/21/%/21/%/21/%/21/%/21/%/21/%/21/%/21/%/21/%/21/%/21/%/21/%/21/%/21/%/21/%/21/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_3: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/1/%/2/%/1/%/2/%/4/%/21/%/1/%/2/%/0/%/0/%/4/%/2/%/2/%/2/%/18/%/0/%/0/%/0/%/0/%/0/%/21/%/21/%/1/%/18/%/1/%/1/%/1/%/0/%/1/%/0/%/1/%/1/%/2/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/0/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/1/%/2/%/2/%/1/%/1/%/1/%/2/%/2/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/2/%/2/%/2/%/2/%/1/%/2/%/19/%/1/%/2/%/1/%/1/%/2/%/2/%/1/%/1/%/1/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_4: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/22/%/6/%/6/%/6/%/6/%/6/%/8/%/8/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_5: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/0/%/0/%/4/%/18/%/18/%/18/%/18/%/18/%/18/%/0/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/0/%/18/%/13/%/0/%/0/%/0/%/0/%/0/%/0/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/13/%/6/%/18/%/6/%/6/%/18/%/6/%/6/%/18/%/6/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/0/%/0/%/0/%/5/%/5/%/5/%/18/%/18/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_6: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/27/%/27/%/27/%/27/%/0/%/0/%/19/%/19/%/19/%/18/%/18/%/20/%/18/%/18/%/22/%/22/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/18/%/0/%/0/%/18/%/18/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/4/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/0/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/18/%/18/%/18/%/18/%/5/%/5/%/6/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/18/%/5/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/27/%/8/%/6/%/6/%/6/%/6/%/6/%/6/%/4/%/4/%/6/%/6/%/22/%/6/%/6/%/6/%/6/%/5/%/5/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/5/%/5/%/5/%/22/%/22/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_7: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/18/%/18/%/18/%/18/%/18/%/18/%/18/%/18/%/18/%/18/%/18/%/18/%/18/%/18/%/0/%/27/%/5/%/6/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/0/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/5/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/4/%/4/%/22/%/18/%/18/%/18/%/4/%/0/%/0/%/0/%/0/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	empty_character_class_segment: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_9: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/6/%/6/%/7/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/6/%/5/%/7/%/7/%/7/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/7/%/7/%/7/%/7/%/6/%/0/%/0/%/5/%/6/%/6/%/6/%/6/%/0/%/0/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/6/%/6/%/18/%/18/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/18/%/4/%/5/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/5/%/5/%/5/%/5/%/5/%/0/%/6/%/7/%/7/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/5/%/5/%/0/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/5/%/0/%/0/%/0/%/5/%/5/%/5/%/5/%/0/%/0/%/6/%/5/%/7/%/7/%/7/%/6/%/6/%/6/%/6/%/0/%/0/%/7/%/7/%/0/%/0/%/7/%/7/%/6/%/5/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/7/%/0/%/0/%/0/%/0/%/5/%/5/%/0/%/5/%/5/%/5/%/6/%/6/%/0/%/0/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/5/%/5/%/20/%/20/%/11/%/11/%/11/%/11/%/11/%/11/%/22/%/0/%/0/%/0/%/0/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_10: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/6/%/6/%/7/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/0/%/0/%/5/%/5/%/0/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/5/%/5/%/0/%/5/%/5/%/0/%/5/%/5/%/0/%/0/%/6/%/0/%/7/%/7/%/7/%/6/%/6/%/0/%/0/%/0/%/0/%/6/%/6/%/0/%/0/%/6/%/6/%/6/%/0/%/0/%/0/%/6/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/5/%/5/%/5/%/5/%/0/%/5/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/6/%/6/%/5/%/5/%/5/%/6/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/6/%/6/%/7/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/5/%/5/%/5/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/5/%/5/%/0/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/6/%/5/%/7/%/7/%/7/%/6/%/6/%/6/%/6/%/6/%/0/%/6/%/6/%/7/%/0/%/7/%/7/%/6/%/0/%/0/%/5/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/5/%/5/%/6/%/6/%/0/%/0/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/0/%/20/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_11: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/6/%/7/%/7/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/5/%/5/%/0/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/5/%/5/%/0/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/6/%/5/%/7/%/6/%/7/%/6/%/6/%/6/%/6/%/0/%/0/%/7/%/7/%/0/%/0/%/7/%/7/%/6/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/6/%/7/%/0/%/0/%/0/%/0/%/5/%/5/%/0/%/5/%/5/%/5/%/6/%/6/%/0/%/0/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/22/%/5/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/6/%/5/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/0/%/5/%/5/%/5/%/0/%/5/%/5/%/5/%/5/%/0/%/0/%/0/%/5/%/5/%/0/%/5/%/0/%/5/%/5/%/0/%/0/%/0/%/5/%/5/%/0/%/0/%/0/%/5/%/5/%/5/%/0/%/0/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/0/%/0/%/7/%/7/%/6/%/7/%/7/%/0/%/0/%/0/%/7/%/7/%/7/%/0/%/7/%/7/%/7/%/6/%/0/%/0/%/5/%/0/%/0/%/0/%/0/%/0/%/0/%/7/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/11/%/11/%/11/%/22/%/22/%/22/%/22/%/22/%/22/%/20/%/22/%/0/%/0/%/0/%/0/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_12: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/7/%/7/%/7/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/5/%/5/%/5/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/0/%/5/%/6/%/6/%/6/%/7/%/7/%/7/%/7/%/0/%/6/%/6/%/6/%/0/%/6/%/6/%/6/%/6/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/6/%/6/%/0/%/5/%/5/%/0/%/0/%/0/%/0/%/0/%/0/%/5/%/5/%/6/%/6/%/0/%/0/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/22/%/0/%/0/%/7/%/7/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/5/%/5/%/5/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/6/%/5/%/7/%/6/%/7/%/7/%/7/%/7/%/7/%/0/%/6/%/7/%/7/%/0/%/7/%/7/%/6/%/6/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/7/%/7/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/5/%/0/%/5/%/5/%/6/%/6/%/0/%/0/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/0/%/22/%/22/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_13: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/7/%/7/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/5/%/5/%/5/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/0/%/5/%/7/%/7/%/7/%/6/%/6/%/6/%/6/%/0/%/7/%/7/%/7/%/0/%/7/%/7/%/7/%/6/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/7/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/5/%/5/%/6/%/6/%/0/%/0/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/11/%/11/%/11/%/11/%/11/%/11/%/0/%/0/%/0/%/22/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/7/%/7/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/5/%/0/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/0/%/6/%/0/%/0/%/0/%/0/%/7/%/7/%/7/%/6/%/6/%/6/%/0/%/6/%/0/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/7/%/7/%/18/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_14: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/6/%/5/%/5/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/0/%/0/%/0/%/0/%/20/%/5/%/5/%/5/%/5/%/5/%/5/%/4/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/18/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/18/%/18/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/5/%/5/%/0/%/5/%/0/%/0/%/5/%/5/%/0/%/5/%/0/%/0/%/5/%/0/%/0/%/0/%/0/%/0/%/0/%/5/%/5/%/5/%/5/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/5/%/5/%/5/%/0/%/5/%/0/%/5/%/0/%/0/%/5/%/5/%/0/%/5/%/5/%/5/%/5/%/6/%/5/%/5/%/6/%/6/%/6/%/6/%/6/%/6/%/0/%/6/%/6/%/5/%/0/%/0/%/5/%/5/%/5/%/5/%/5/%/0/%/4/%/0/%/6/%/6/%/6/%/6/%/6/%/6/%/0/%/0/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/0/%/0/%/5/%/5/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_15: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/22/%/22/%/22/%/18/%/18/%/18/%/18/%/18/%/18/%/18/%/18/%/18/%/18/%/18/%/18/%/18/%/18/%/18/%/22/%/22/%/22/%/22/%/22/%/6/%/6/%/22/%/22/%/22/%/22/%/22/%/22/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/22/%/6/%/22/%/6/%/22/%/6/%/14/%/15/%/14/%/15/%/7/%/7/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/0/%/0/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/7/%/6/%/6/%/6/%/6/%/6/%/18/%/6/%/6/%/5/%/5/%/5/%/5/%/0/%/0/%/0/%/0/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/0/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/0/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/6/%/22/%/22/%/22/%/22/%/22/%/22/%/0/%/22/%/22/%/18/%/18/%/18/%/18/%/18/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_16: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/7/%/7/%/6/%/6/%/6/%/6/%/7/%/6/%/6/%/6/%/6/%/6/%/6/%/7/%/6/%/6/%/7/%/7/%/6/%/6/%/5/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/18/%/18/%/18/%/18/%/18/%/18/%/5/%/5/%/5/%/5/%/5/%/5/%/7/%/7/%/6/%/6/%/5/%/5/%/5/%/5/%/6/%/6/%/6/%/5/%/7/%/7/%/7/%/5/%/5/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/5/%/5/%/5/%/6/%/6/%/6/%/6/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/6/%/7/%/7/%/6/%/6/%/7/%/7/%/7/%/7/%/7/%/7/%/6/%/5/%/7/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/0/%/0/%/0/%/0/%/22/%/22/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/18/%/4/%/0/%/0/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_17: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/0/%/0/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/0/%/0/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_18: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/5/%/5/%/5/%/5/%/0/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/5/%/0/%/5/%/5/%/5/%/5/%/0/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/5/%/5/%/5/%/5/%/0/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/5/%/5/%/5/%/5/%/0/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/5/%/0/%/5/%/5/%/5/%/5/%/0/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_19: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/5/%/5/%/5/%/5/%/0/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/0/%/0/%/6/%/22/%/18/%/18/%/18/%/18/%/18/%/18/%/18/%/18/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/0/%/0/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/0/%/0/%/0/%/0/%/0/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_20: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_21: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_22: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/18/%/18/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/23/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/14/%/15/%/0/%/0/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/18/%/18/%/18/%/10/%/10/%/10/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_23: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/5/%/5/%/5/%/5/%/6/%/6/%/6/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/6/%/6/%/6/%/18/%/18/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/6/%/6/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/5/%/5/%/5/%/0/%/6/%/6/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/27/%/27/%/7/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/6/%/7/%/7/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/18/%/18/%/18/%/4/%/18/%/18/%/18/%/20/%/5/%/6/%/0/%/0/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/0/%/0/%/0/%/0/%/0/%/0/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_24: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/18/%/18/%/18/%/18/%/18/%/18/%/13/%/18/%/18/%/18/%/18/%/6/%/6/%/6/%/23/%/0/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/0/%/0/%/0/%/0/%/0/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/4/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/6/%/5/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_25: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/0/%/6/%/6/%/6/%/7/%/7/%/7/%/7/%/6/%/6/%/7/%/7/%/7/%/0/%/0/%/0/%/0/%/7/%/7/%/6/%/7/%/7/%/7/%/7/%/7/%/7/%/6/%/6/%/6/%/0/%/0/%/0/%/0/%/22/%/0/%/0/%/0/%/18/%/18/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/0/%/0/%/0/%/0/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/7/%/7/%/0/%/0/%/0/%/0/%/0/%/0/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/0/%/0/%/0/%/0/%/18/%/18/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_26: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/6/%/6/%/7/%/7/%/7/%/0/%/0/%/18/%/18/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_27: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/6/%/6/%/6/%/6/%/7/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/6/%/7/%/6/%/6/%/6/%/6/%/6/%/7/%/6/%/7/%/7/%/7/%/7/%/7/%/6/%/7/%/7/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/0/%/0/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/18/%/18/%/18/%/18/%/18/%/18/%/18/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/0/%/0/%/0/%/6/%/6/%/7/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/7/%/6/%/6/%/6/%/6/%/7/%/7/%/6/%/6/%/7/%/0/%/0/%/0/%/5/%/5/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_28: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/7/%/7/%/6/%/6/%/0/%/0/%/0/%/18/%/18/%/18/%/18/%/18/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/0/%/0/%/0/%/5/%/5/%/5/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/4/%/4/%/4/%/4/%/4/%/4/%/18/%/18/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_29: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/4/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/6/%/6/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_30: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_31: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/2/%/2/%/2/%/2/%/2/%/2/%/0/%/0/%/1/%/1/%/1/%/1/%/1/%/1/%/0/%/0/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/2/%/2/%/2/%/2/%/2/%/2/%/0/%/0/%/1/%/1/%/1/%/1/%/1/%/1/%/0/%/0/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/0/%/1/%/0/%/1/%/0/%/1/%/0/%/1/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/0/%/0/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/3/%/2/%/2/%/2/%/2/%/2/%/0/%/2/%/2/%/1/%/1/%/1/%/1/%/3/%/21/%/2/%/21/%/21/%/21/%/2/%/2/%/2/%/0/%/2/%/2/%/1/%/1/%/1/%/1/%/3/%/21/%/21/%/21/%/2/%/2/%/2/%/2/%/0/%/0/%/2/%/2/%/1/%/1/%/1/%/1/%/0/%/21/%/21/%/21/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/1/%/1/%/1/%/1/%/1/%/21/%/21/%/21/%/0/%/0/%/2/%/2/%/2/%/0/%/2/%/2/%/1/%/1/%/1/%/1/%/3/%/21/%/21/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_32: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/23/%/23/%/23/%/23/%/23/%/23/%/23/%/23/%/23/%/23/%/23/%/27/%/27/%/27/%/27/%/27/%/13/%/13/%/13/%/13/%/13/%/13/%/18/%/18/%/16/%/17/%/14/%/16/%/16/%/17/%/14/%/16/%/18/%/18/%/18/%/18/%/18/%/18/%/18/%/18/%/24/%/25/%/27/%/27/%/27/%/27/%/27/%/23/%/18/%/18/%/18/%/18/%/18/%/18/%/18/%/18/%/18/%/16/%/17/%/18/%/18/%/18/%/18/%/12/%/12/%/18/%/18/%/18/%/19/%/14/%/15/%/18/%/18/%/18/%/18/%/18/%/18/%/18/%/18/%/18/%/18/%/18/%/19/%/18/%/12/%/18/%/18/%/18/%/18/%/18/%/18/%/18/%/18/%/18/%/18/%/23/%/27/%/27/%/27/%/27/%/27/%/0/%/0/%/0/%/0/%/0/%/27/%/27/%/27/%/27/%/27/%/27/%/11/%/2/%/0/%/0/%/11/%/11/%/11/%/11/%/11/%/11/%/19/%/19/%/19/%/14/%/15/%/2/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/19/%/19/%/19/%/14/%/15/%/0/%/4/%/4/%/4/%/4/%/4/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/20/%/20/%/20/%/20/%/20/%/20/%/20/%/20/%/20/%/20/%/20/%/20/%/20/%/20/%/20/%/20/%/20/%/20/%/20/%/20/%/20/%/20/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/8/%/8/%/8/%/8/%/6/%/8/%/8/%/8/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_33: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/22/%/22/%/1/%/22/%/22/%/22/%/22/%/1/%/22/%/22/%/2/%/1/%/1/%/1/%/2/%/2/%/1/%/1/%/1/%/2/%/22/%/1/%/22/%/22/%/22/%/1/%/1/%/1/%/1/%/1/%/22/%/22/%/22/%/22/%/22/%/22/%/1/%/22/%/1/%/22/%/1/%/22/%/1/%/1/%/1/%/1/%/22/%/2/%/1/%/1/%/1/%/1/%/2/%/5/%/5/%/5/%/5/%/2/%/22/%/22/%/2/%/2/%/1/%/1/%/19/%/19/%/19/%/19/%/19/%/1/%/2/%/2/%/2/%/2/%/22/%/19/%/22/%/22/%/2/%/22/%/0/%/0/%/0/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/1/%/2/%/10/%/10/%/10/%/10/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/19/%/19/%/19/%/19/%/19/%/22/%/22/%/22/%/22/%/22/%/19/%/19/%/22/%/22/%/22/%/22/%/19/%/22/%/22/%/19/%/22/%/22/%/19/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/19/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/19/%/19/%/22/%/22/%/19/%/22/%/19/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_34: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_35: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/19/%/19/%/19/%/19/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/19/%/19/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/14/%/15/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/19/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/19/%/19/%/19/%/19/%/19/%/19/%/22/%/22/%/22/%/22/%/22/%/22/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_36: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_37: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/19/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/19/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_38: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/19/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/0/%/0/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/0/%/0/%/0/%/22/%/22/%/22/%/22/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_39: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/22/%/22/%/22/%/22/%/0/%/22/%/22/%/22/%/22/%/0/%/0/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/0/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/0/%/22/%/0/%/22/%/22/%/22/%/22/%/0/%/0/%/0/%/22/%/0/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/0/%/0/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/14/%/15/%/14/%/15/%/14/%/15/%/14/%/15/%/14/%/15/%/14/%/15/%/14/%/15/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/22/%/0/%/0/%/0/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/0/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/0/%/19/%/19/%/19/%/19/%/19/%/14/%/15/%/19/%/19/%/19/%/19/%/0/%/19/%/0/%/0/%/0/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/14/%/15/%/14/%/15/%/14/%/15/%/14/%/15/%/14/%/15/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_40: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_41: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/14/%/15/%/14/%/15/%/14/%/15/%/14/%/15/%/14/%/15/%/14/%/15/%/14/%/15/%/14/%/15/%/14/%/15/%/14/%/15/%/14/%/15/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/14/%/15/%/14/%/15/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/14/%/15/%/19/%/19/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_42: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_43: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/19/%/22/%/22/%/19/%/19/%/19/%/19/%/19/%/19/%/0/%/0/%/0/%/22/%/22/%/22/%/22/%/22/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_44: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/0/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/0/%/1/%/2/%/1/%/1/%/1/%/2/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/1/%/1/%/0/%/2/%/1/%/2/%/2/%/1/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/4/%/0/%/0/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/2/%/22/%/22/%/22/%/22/%/22/%/22/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/18/%/18/%/18/%/18/%/11/%/18/%/18/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_45: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/4/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_46: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/18/%/18/%/16/%/17/%/16/%/17/%/18/%/18/%/18/%/16/%/17/%/18/%/16/%/17/%/18/%/18/%/18/%/18/%/18/%/18/%/18/%/18/%/18/%/13/%/18/%/18/%/13/%/18/%/16/%/17/%/18/%/18/%/16/%/17/%/14/%/15/%/14/%/15/%/14/%/15/%/14/%/15/%/18/%/18/%/18/%/18/%/18/%/4/%/18/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/0/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_47: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/0/%/0/%/0/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_48: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/23/%/18/%/18/%/18/%/22/%/4/%/5/%/10/%/14/%/15/%/14/%/15/%/14/%/15/%/14/%/15/%/14/%/15/%/22/%/22/%/14/%/15/%/14/%/15/%/14/%/15/%/14/%/15/%/13/%/14/%/15/%/15/%/22/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/6/%/6/%/6/%/6/%/6/%/6/%/13/%/4/%/4/%/4/%/4/%/4/%/22/%/22/%/10/%/10/%/10/%/4/%/5/%/18/%/22/%/22/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/6/%/6/%/21/%/21/%/4/%/4/%/5/%/13/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/18/%/4/%/4/%/4/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_49: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/22/%/22/%/11/%/11/%/11/%/11/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_50: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/0/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/22/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_51: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_52: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_53: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_54: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_55: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_56: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_57: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_58: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_59: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_60: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_61: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_62: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_63: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_64: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_65: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_66: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_67: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_68: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_69: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_70: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_71: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_72: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_73: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_74: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_75: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_76: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_77: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_78: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_79: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_80: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_81: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_82: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_83: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_84: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_85: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_86: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_87: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_88: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_89: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_90: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_91: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_92: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_93: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_94: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_95: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_96: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_97: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_98: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_99: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_100: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_101: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_102: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_103: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_104: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_105: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_106: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_107: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_108: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_109: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_110: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_111: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_112: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_113: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_114: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_115: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_116: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_117: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_118: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_119: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_120: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_121: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_122: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_123: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_124: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_125: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_126: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_127: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_128: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_129: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_130: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_131: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_132: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_133: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_134: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_135: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_136: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_137: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_138: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_139: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_140: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_141: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_142: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_143: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_144: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_145: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_146: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_147: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_148: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_149: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_150: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_151: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_152: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_153: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_154: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_155: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_156: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_157: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_158: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_159: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_160: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/4/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_161: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_162: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_163: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_164: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/0/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_165: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_166: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/4/%/18/%/18/%/18/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/5/%/5/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/0/%/0/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/5/%/6/%/8/%/8/%/8/%/18/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/6/%/6/%/18/%/4/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_167: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/21/%/21/%/21/%/21/%/21/%/21/%/21/%/21/%/21/%/21/%/21/%/21/%/21/%/21/%/21/%/21/%/21/%/21/%/21/%/21/%/21/%/21/%/21/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/4/%/21/%/21/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/2/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/4/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/1/%/2/%/1/%/2/%/1/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/1/%/2/%/4/%/21/%/21/%/1/%/2/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_168: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/6/%/5/%/5/%/5/%/6/%/5/%/5/%/5/%/5/%/6/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/7/%/7/%/6/%/6/%/7/%/22/%/22/%/22/%/22/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/18/%/18/%/18/%/18/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/7/%/7/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/7/%/6/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/18/%/18/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_169: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/18/%/18/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/7/%/7/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/18/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_170: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/6/%/6/%/6/%/6/%/6/%/6/%/7/%/7/%/6/%/6/%/7/%/7/%/6/%/6/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/5/%/5/%/5/%/6/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/6/%/7/%/0/%/0/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/0/%/0/%/18/%/18/%/18/%/18/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_172: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_173: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_174: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_175: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_176: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_177: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_178: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_179: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_180: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_181: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_182: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_183: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_184: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_185: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_186: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_187: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_188: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_189: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_190: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_191: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_192: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_193: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_194: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_195: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_196: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_197: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_198: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_199: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_200: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_201: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_202: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_203: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_204: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_205: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_206: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_207: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_208: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_209: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_210: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_211: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_212: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_213: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_214: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_215: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_216: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_217: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_218: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_219: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_220: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_221: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_222: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_223: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/%/28/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_224: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_225: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_226: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_227: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_228: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_229: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_230: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_231: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_232: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_233: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_234: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_235: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_236: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_237: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_238: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_239: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_240: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_241: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_242: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_243: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_244: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_245: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_246: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_247: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_248: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_249: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_250: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/0/%/0/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_251: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/2/%/2/%/2/%/2/%/2/%/0/%/0/%/0/%/0/%/0/%/5/%/6/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/19/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/5/%/5/%/5/%/5/%/5/%/0/%/5/%/0/%/5/%/5/%/0/%/5/%/5/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_252: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_253: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/14/%/15/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/20/%/22/%/0/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_254: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/18/%/18/%/18/%/18/%/18/%/18/%/18/%/14/%/15/%/18/%/0/%/0/%/0/%/0/%/0/%/0/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/18/%/13/%/13/%/12/%/12/%/14/%/15/%/14/%/15/%/14/%/15/%/14/%/15/%/14/%/15/%/14/%/15/%/14/%/15/%/14/%/15/%/18/%/18/%/14/%/15/%/18/%/18/%/18/%/18/%/12/%/12/%/12/%/18/%/18/%/18/%/0/%/18/%/18/%/18/%/18/%/13/%/14/%/15/%/14/%/15/%/14/%/15/%/18/%/18/%/18/%/19/%/13/%/19/%/19/%/19/%/0/%/18/%/20/%/18/%/18/%/0/%/0/%/0/%/0/%/5/%/5/%/5/%/5/%/5/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/27/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0_segment_255: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/18/%/18/%/18/%/20/%/18/%/18/%/18/%/14/%/15/%/18/%/19/%/18/%/13/%/18/%/18/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/18/%/18/%/19/%/19/%/19/%/18/%/18/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/14/%/18/%/15/%/21/%/12/%/21/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/14/%/19/%/15/%/19/%/14/%/15/%/18/%/14/%/15/%/18/%/18/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/4/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/4/%/4/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/5/%/5/%/5/%/0/%/0/%/0/%/20/%/20/%/19/%/21/%/22/%/20/%/20/%/0/%/22/%/19/%/19/%/19/%/19/%/22/%/22/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/27/%/27/%/27/%/22/%/22/%/0/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_0: SPECIAL [ARRAY [INTEGER_8]]
			-- Generated character class array plane
		once
			create Result.make_filled (Void, 256)
			Result.put (character_class_plane_0_segment_0, 0)
			Result.put (character_class_plane_0_segment_1, 1)
			Result.put (character_class_plane_0_segment_2, 2)
			Result.put (character_class_plane_0_segment_3, 3)
			Result.put (character_class_plane_0_segment_4, 4)
			Result.put (character_class_plane_0_segment_5, 5)
			Result.put (character_class_plane_0_segment_6, 6)
			Result.put (character_class_plane_0_segment_7, 7)
			Result.put (empty_character_class_segment, 8)
			Result.put (character_class_plane_0_segment_9, 9)
			Result.put (character_class_plane_0_segment_10, 10)
			Result.put (character_class_plane_0_segment_11, 11)
			Result.put (character_class_plane_0_segment_12, 12)
			Result.put (character_class_plane_0_segment_13, 13)
			Result.put (character_class_plane_0_segment_14, 14)
			Result.put (character_class_plane_0_segment_15, 15)
			Result.put (character_class_plane_0_segment_16, 16)
			Result.put (character_class_plane_0_segment_17, 17)
			Result.put (character_class_plane_0_segment_18, 18)
			Result.put (character_class_plane_0_segment_19, 19)
			Result.put (character_class_plane_0_segment_20, 20)
			Result.put (character_class_plane_0_segment_21, 21)
			Result.put (character_class_plane_0_segment_22, 22)
			Result.put (character_class_plane_0_segment_23, 23)
			Result.put (character_class_plane_0_segment_24, 24)
			Result.put (character_class_plane_0_segment_25, 25)
			Result.put (character_class_plane_0_segment_26, 26)
			Result.put (character_class_plane_0_segment_27, 27)
			Result.put (character_class_plane_0_segment_28, 28)
			Result.put (character_class_plane_0_segment_29, 29)
			Result.put (character_class_plane_0_segment_30, 30)
			Result.put (character_class_plane_0_segment_31, 31)
			Result.put (character_class_plane_0_segment_32, 32)
			Result.put (character_class_plane_0_segment_33, 33)
			Result.put (character_class_plane_0_segment_34, 34)
			Result.put (character_class_plane_0_segment_35, 35)
			Result.put (character_class_plane_0_segment_36, 36)
			Result.put (character_class_plane_0_segment_37, 37)
			Result.put (character_class_plane_0_segment_38, 38)
			Result.put (character_class_plane_0_segment_39, 39)
			Result.put (character_class_plane_0_segment_40, 40)
			Result.put (character_class_plane_0_segment_41, 41)
			Result.put (character_class_plane_0_segment_42, 42)
			Result.put (character_class_plane_0_segment_43, 43)
			Result.put (character_class_plane_0_segment_44, 44)
			Result.put (character_class_plane_0_segment_45, 45)
			Result.put (character_class_plane_0_segment_46, 46)
			Result.put (character_class_plane_0_segment_47, 47)
			Result.put (character_class_plane_0_segment_48, 48)
			Result.put (character_class_plane_0_segment_49, 49)
			Result.put (character_class_plane_0_segment_50, 50)
			Result.put (character_class_plane_0_segment_51, 51)
			Result.put (character_class_plane_0_segment_52, 52)
			Result.put (character_class_plane_0_segment_53, 53)
			Result.put (character_class_plane_0_segment_54, 54)
			Result.put (character_class_plane_0_segment_55, 55)
			Result.put (character_class_plane_0_segment_56, 56)
			Result.put (character_class_plane_0_segment_57, 57)
			Result.put (character_class_plane_0_segment_58, 58)
			Result.put (character_class_plane_0_segment_59, 59)
			Result.put (character_class_plane_0_segment_60, 60)
			Result.put (character_class_plane_0_segment_61, 61)
			Result.put (character_class_plane_0_segment_62, 62)
			Result.put (character_class_plane_0_segment_63, 63)
			Result.put (character_class_plane_0_segment_64, 64)
			Result.put (character_class_plane_0_segment_65, 65)
			Result.put (character_class_plane_0_segment_66, 66)
			Result.put (character_class_plane_0_segment_67, 67)
			Result.put (character_class_plane_0_segment_68, 68)
			Result.put (character_class_plane_0_segment_69, 69)
			Result.put (character_class_plane_0_segment_70, 70)
			Result.put (character_class_plane_0_segment_71, 71)
			Result.put (character_class_plane_0_segment_72, 72)
			Result.put (character_class_plane_0_segment_73, 73)
			Result.put (character_class_plane_0_segment_74, 74)
			Result.put (character_class_plane_0_segment_75, 75)
			Result.put (character_class_plane_0_segment_76, 76)
			Result.put (character_class_plane_0_segment_77, 77)
			Result.put (character_class_plane_0_segment_78, 78)
			Result.put (character_class_plane_0_segment_79, 79)
			Result.put (character_class_plane_0_segment_80, 80)
			Result.put (character_class_plane_0_segment_81, 81)
			Result.put (character_class_plane_0_segment_82, 82)
			Result.put (character_class_plane_0_segment_83, 83)
			Result.put (character_class_plane_0_segment_84, 84)
			Result.put (character_class_plane_0_segment_85, 85)
			Result.put (character_class_plane_0_segment_86, 86)
			Result.put (character_class_plane_0_segment_87, 87)
			Result.put (character_class_plane_0_segment_88, 88)
			Result.put (character_class_plane_0_segment_89, 89)
			Result.put (character_class_plane_0_segment_90, 90)
			Result.put (character_class_plane_0_segment_91, 91)
			Result.put (character_class_plane_0_segment_92, 92)
			Result.put (character_class_plane_0_segment_93, 93)
			Result.put (character_class_plane_0_segment_94, 94)
			Result.put (character_class_plane_0_segment_95, 95)
			Result.put (character_class_plane_0_segment_96, 96)
			Result.put (character_class_plane_0_segment_97, 97)
			Result.put (character_class_plane_0_segment_98, 98)
			Result.put (character_class_plane_0_segment_99, 99)
			Result.put (character_class_plane_0_segment_100, 100)
			Result.put (character_class_plane_0_segment_101, 101)
			Result.put (character_class_plane_0_segment_102, 102)
			Result.put (character_class_plane_0_segment_103, 103)
			Result.put (character_class_plane_0_segment_104, 104)
			Result.put (character_class_plane_0_segment_105, 105)
			Result.put (character_class_plane_0_segment_106, 106)
			Result.put (character_class_plane_0_segment_107, 107)
			Result.put (character_class_plane_0_segment_108, 108)
			Result.put (character_class_plane_0_segment_109, 109)
			Result.put (character_class_plane_0_segment_110, 110)
			Result.put (character_class_plane_0_segment_111, 111)
			Result.put (character_class_plane_0_segment_112, 112)
			Result.put (character_class_plane_0_segment_113, 113)
			Result.put (character_class_plane_0_segment_114, 114)
			Result.put (character_class_plane_0_segment_115, 115)
			Result.put (character_class_plane_0_segment_116, 116)
			Result.put (character_class_plane_0_segment_117, 117)
			Result.put (character_class_plane_0_segment_118, 118)
			Result.put (character_class_plane_0_segment_119, 119)
			Result.put (character_class_plane_0_segment_120, 120)
			Result.put (character_class_plane_0_segment_121, 121)
			Result.put (character_class_plane_0_segment_122, 122)
			Result.put (character_class_plane_0_segment_123, 123)
			Result.put (character_class_plane_0_segment_124, 124)
			Result.put (character_class_plane_0_segment_125, 125)
			Result.put (character_class_plane_0_segment_126, 126)
			Result.put (character_class_plane_0_segment_127, 127)
			Result.put (character_class_plane_0_segment_128, 128)
			Result.put (character_class_plane_0_segment_129, 129)
			Result.put (character_class_plane_0_segment_130, 130)
			Result.put (character_class_plane_0_segment_131, 131)
			Result.put (character_class_plane_0_segment_132, 132)
			Result.put (character_class_plane_0_segment_133, 133)
			Result.put (character_class_plane_0_segment_134, 134)
			Result.put (character_class_plane_0_segment_135, 135)
			Result.put (character_class_plane_0_segment_136, 136)
			Result.put (character_class_plane_0_segment_137, 137)
			Result.put (character_class_plane_0_segment_138, 138)
			Result.put (character_class_plane_0_segment_139, 139)
			Result.put (character_class_plane_0_segment_140, 140)
			Result.put (character_class_plane_0_segment_141, 141)
			Result.put (character_class_plane_0_segment_142, 142)
			Result.put (character_class_plane_0_segment_143, 143)
			Result.put (character_class_plane_0_segment_144, 144)
			Result.put (character_class_plane_0_segment_145, 145)
			Result.put (character_class_plane_0_segment_146, 146)
			Result.put (character_class_plane_0_segment_147, 147)
			Result.put (character_class_plane_0_segment_148, 148)
			Result.put (character_class_plane_0_segment_149, 149)
			Result.put (character_class_plane_0_segment_150, 150)
			Result.put (character_class_plane_0_segment_151, 151)
			Result.put (character_class_plane_0_segment_152, 152)
			Result.put (character_class_plane_0_segment_153, 153)
			Result.put (character_class_plane_0_segment_154, 154)
			Result.put (character_class_plane_0_segment_155, 155)
			Result.put (character_class_plane_0_segment_156, 156)
			Result.put (character_class_plane_0_segment_157, 157)
			Result.put (character_class_plane_0_segment_158, 158)
			Result.put (character_class_plane_0_segment_159, 159)
			Result.put (character_class_plane_0_segment_160, 160)
			Result.put (character_class_plane_0_segment_161, 161)
			Result.put (character_class_plane_0_segment_162, 162)
			Result.put (character_class_plane_0_segment_163, 163)
			Result.put (character_class_plane_0_segment_164, 164)
			Result.put (character_class_plane_0_segment_165, 165)
			Result.put (character_class_plane_0_segment_166, 166)
			Result.put (character_class_plane_0_segment_167, 167)
			Result.put (character_class_plane_0_segment_168, 168)
			Result.put (character_class_plane_0_segment_169, 169)
			Result.put (character_class_plane_0_segment_170, 170)
			Result.put (empty_character_class_segment, 171)
			Result.put (character_class_plane_0_segment_172, 172)
			Result.put (character_class_plane_0_segment_173, 173)
			Result.put (character_class_plane_0_segment_174, 174)
			Result.put (character_class_plane_0_segment_175, 175)
			Result.put (character_class_plane_0_segment_176, 176)
			Result.put (character_class_plane_0_segment_177, 177)
			Result.put (character_class_plane_0_segment_178, 178)
			Result.put (character_class_plane_0_segment_179, 179)
			Result.put (character_class_plane_0_segment_180, 180)
			Result.put (character_class_plane_0_segment_181, 181)
			Result.put (character_class_plane_0_segment_182, 182)
			Result.put (character_class_plane_0_segment_183, 183)
			Result.put (character_class_plane_0_segment_184, 184)
			Result.put (character_class_plane_0_segment_185, 185)
			Result.put (character_class_plane_0_segment_186, 186)
			Result.put (character_class_plane_0_segment_187, 187)
			Result.put (character_class_plane_0_segment_188, 188)
			Result.put (character_class_plane_0_segment_189, 189)
			Result.put (character_class_plane_0_segment_190, 190)
			Result.put (character_class_plane_0_segment_191, 191)
			Result.put (character_class_plane_0_segment_192, 192)
			Result.put (character_class_plane_0_segment_193, 193)
			Result.put (character_class_plane_0_segment_194, 194)
			Result.put (character_class_plane_0_segment_195, 195)
			Result.put (character_class_plane_0_segment_196, 196)
			Result.put (character_class_plane_0_segment_197, 197)
			Result.put (character_class_plane_0_segment_198, 198)
			Result.put (character_class_plane_0_segment_199, 199)
			Result.put (character_class_plane_0_segment_200, 200)
			Result.put (character_class_plane_0_segment_201, 201)
			Result.put (character_class_plane_0_segment_202, 202)
			Result.put (character_class_plane_0_segment_203, 203)
			Result.put (character_class_plane_0_segment_204, 204)
			Result.put (character_class_plane_0_segment_205, 205)
			Result.put (character_class_plane_0_segment_206, 206)
			Result.put (character_class_plane_0_segment_207, 207)
			Result.put (character_class_plane_0_segment_208, 208)
			Result.put (character_class_plane_0_segment_209, 209)
			Result.put (character_class_plane_0_segment_210, 210)
			Result.put (character_class_plane_0_segment_211, 211)
			Result.put (character_class_plane_0_segment_212, 212)
			Result.put (character_class_plane_0_segment_213, 213)
			Result.put (character_class_plane_0_segment_214, 214)
			Result.put (character_class_plane_0_segment_215, 215)
			Result.put (character_class_plane_0_segment_216, 216)
			Result.put (character_class_plane_0_segment_217, 217)
			Result.put (character_class_plane_0_segment_218, 218)
			Result.put (character_class_plane_0_segment_219, 219)
			Result.put (character_class_plane_0_segment_220, 220)
			Result.put (character_class_plane_0_segment_221, 221)
			Result.put (character_class_plane_0_segment_222, 222)
			Result.put (character_class_plane_0_segment_223, 223)
			Result.put (character_class_plane_0_segment_224, 224)
			Result.put (character_class_plane_0_segment_225, 225)
			Result.put (character_class_plane_0_segment_226, 226)
			Result.put (character_class_plane_0_segment_227, 227)
			Result.put (character_class_plane_0_segment_228, 228)
			Result.put (character_class_plane_0_segment_229, 229)
			Result.put (character_class_plane_0_segment_230, 230)
			Result.put (character_class_plane_0_segment_231, 231)
			Result.put (character_class_plane_0_segment_232, 232)
			Result.put (character_class_plane_0_segment_233, 233)
			Result.put (character_class_plane_0_segment_234, 234)
			Result.put (character_class_plane_0_segment_235, 235)
			Result.put (character_class_plane_0_segment_236, 236)
			Result.put (character_class_plane_0_segment_237, 237)
			Result.put (character_class_plane_0_segment_238, 238)
			Result.put (character_class_plane_0_segment_239, 239)
			Result.put (character_class_plane_0_segment_240, 240)
			Result.put (character_class_plane_0_segment_241, 241)
			Result.put (character_class_plane_0_segment_242, 242)
			Result.put (character_class_plane_0_segment_243, 243)
			Result.put (character_class_plane_0_segment_244, 244)
			Result.put (character_class_plane_0_segment_245, 245)
			Result.put (character_class_plane_0_segment_246, 246)
			Result.put (character_class_plane_0_segment_247, 247)
			Result.put (character_class_plane_0_segment_248, 248)
			Result.put (character_class_plane_0_segment_249, 249)
			Result.put (character_class_plane_0_segment_250, 250)
			Result.put (character_class_plane_0_segment_251, 251)
			Result.put (character_class_plane_0_segment_252, 252)
			Result.put (character_class_plane_0_segment_253, 253)
			Result.put (character_class_plane_0_segment_254, 254)
			Result.put (character_class_plane_0_segment_255, 255)
		ensure
			result_not_void: Result /= Void
			sub_arrays_not_void: True --not Result.has (Void)
		end

	character_class_plane_1_segment_0: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/5/%/5/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/0/%/0/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_1_segment_1: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/18/%/18/%/22/%/0/%/0/%/0/%/0/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/0/%/0/%/0/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/11/%/11/%/11/%/11/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/11/%/0/%/0/%/0/%/0/%/0/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/6/%/0/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_1_segment_2: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_1_segment_3: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/11/%/11/%/11/%/11/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/10/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/10/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/18/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/0/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/18/%/10/%/10/%/10/%/10/%/10/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_1_segment_4: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_1_segment_8: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/5/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/5/%/5/%/0/%/0/%/0/%/5/%/0/%/0/%/5/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_1_segment_9: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/11/%/11/%/11/%/11/%/0/%/0/%/0/%/0/%/0/%/18/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/0/%/0/%/0/%/18/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_1_segment_10: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/6/%/6/%/6/%/0/%/6/%/6/%/0/%/0/%/0/%/0/%/0/%/6/%/6/%/6/%/6/%/5/%/5/%/5/%/5/%/0/%/5/%/5/%/5/%/0/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/0/%/0/%/6/%/6/%/6/%/0/%/0/%/0/%/0/%/6/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/18/%/18/%/18/%/18/%/18/%/18/%/18/%/18/%/18/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_1_segment_32: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_1_segment_33: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_1_segment_34: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_1_segment_35: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_1_segment_36: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/10/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/18/%/18/%/18/%/18/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_1_segment_208: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_1_segment_209: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/0/%/0/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/7/%/7/%/6/%/6/%/6/%/22/%/22/%/22/%/7/%/7/%/7/%/7/%/7/%/7/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/22/%/22/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/6/%/6/%/6/%/6/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_1_segment_210: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/6/%/6/%/6/%/22/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_1_segment_211: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/11/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_1_segment_212: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/0/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/1/%/0/%/1/%/1/%/0/%/0/%/1/%/0/%/0/%/1/%/1/%/0/%/0/%/1/%/1/%/1/%/1/%/0/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/2/%/2/%/2/%/2/%/0/%/2/%/0/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/0/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_1_segment_213: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/2/%/2/%/2/%/2/%/1/%/1/%/0/%/1/%/1/%/1/%/1/%/0/%/0/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/0/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/0/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/1/%/1/%/0/%/1/%/1/%/1/%/1/%/0/%/1/%/1/%/1/%/1/%/1/%/0/%/1/%/0/%/0/%/0/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/0/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_1_segment_214: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/0/%/0/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/19/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/19/%/2/%/2/%/2/%/2/%/2/%/2/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/19/%/2/%/2/%/2/%/2/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_1_segment_215: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/19/%/2/%/2/%/2/%/2/%/2/%/2/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/19/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/19/%/2/%/2/%/2/%/2/%/2/%/2/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/19/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/19/%/2/%/2/%/2/%/2/%/2/%/2/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/1/%/19/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/2/%/19/%/2/%/2/%/2/%/2/%/2/%/2/%/1/%/2/%/0/%/0/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/%/9/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_1_segment_240: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/0/%/0/%/0/%/0/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/22/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_1: SPECIAL [ARRAY [INTEGER_8]]
			-- Generated character class array plane
		once
			create Result.make_filled (Void, 256)
			Result.put (character_class_plane_1_segment_0, 0)
			Result.put (character_class_plane_1_segment_1, 1)
			Result.put (character_class_plane_1_segment_2, 2)
			Result.put (character_class_plane_1_segment_3, 3)
			Result.put (character_class_plane_1_segment_4, 4)
			Result.put (empty_character_class_segment, 5)
			Result.put (empty_character_class_segment, 6)
			Result.put (empty_character_class_segment, 7)
			Result.put (character_class_plane_1_segment_8, 8)
			Result.put (character_class_plane_1_segment_9, 9)
			Result.put (character_class_plane_1_segment_10, 10)
			Result.put (empty_character_class_segment, 11)
			Result.put (empty_character_class_segment, 12)
			Result.put (empty_character_class_segment, 13)
			Result.put (empty_character_class_segment, 14)
			Result.put (empty_character_class_segment, 15)
			Result.put (empty_character_class_segment, 16)
			Result.put (empty_character_class_segment, 17)
			Result.put (empty_character_class_segment, 18)
			Result.put (empty_character_class_segment, 19)
			Result.put (empty_character_class_segment, 20)
			Result.put (empty_character_class_segment, 21)
			Result.put (empty_character_class_segment, 22)
			Result.put (empty_character_class_segment, 23)
			Result.put (empty_character_class_segment, 24)
			Result.put (empty_character_class_segment, 25)
			Result.put (empty_character_class_segment, 26)
			Result.put (empty_character_class_segment, 27)
			Result.put (empty_character_class_segment, 28)
			Result.put (empty_character_class_segment, 29)
			Result.put (empty_character_class_segment, 30)
			Result.put (empty_character_class_segment, 31)
			Result.put (character_class_plane_1_segment_32, 32)
			Result.put (character_class_plane_1_segment_33, 33)
			Result.put (character_class_plane_1_segment_34, 34)
			Result.put (character_class_plane_1_segment_35, 35)
			Result.put (character_class_plane_1_segment_36, 36)
			Result.put (empty_character_class_segment, 37)
			Result.put (empty_character_class_segment, 38)
			Result.put (empty_character_class_segment, 39)
			Result.put (empty_character_class_segment, 40)
			Result.put (empty_character_class_segment, 41)
			Result.put (empty_character_class_segment, 42)
			Result.put (empty_character_class_segment, 43)
			Result.put (empty_character_class_segment, 44)
			Result.put (empty_character_class_segment, 45)
			Result.put (empty_character_class_segment, 46)
			Result.put (empty_character_class_segment, 47)
			Result.put (empty_character_class_segment, 48)
			Result.put (empty_character_class_segment, 49)
			Result.put (empty_character_class_segment, 50)
			Result.put (empty_character_class_segment, 51)
			Result.put (empty_character_class_segment, 52)
			Result.put (empty_character_class_segment, 53)
			Result.put (empty_character_class_segment, 54)
			Result.put (empty_character_class_segment, 55)
			Result.put (empty_character_class_segment, 56)
			Result.put (empty_character_class_segment, 57)
			Result.put (empty_character_class_segment, 58)
			Result.put (empty_character_class_segment, 59)
			Result.put (empty_character_class_segment, 60)
			Result.put (empty_character_class_segment, 61)
			Result.put (empty_character_class_segment, 62)
			Result.put (empty_character_class_segment, 63)
			Result.put (empty_character_class_segment, 64)
			Result.put (empty_character_class_segment, 65)
			Result.put (empty_character_class_segment, 66)
			Result.put (empty_character_class_segment, 67)
			Result.put (empty_character_class_segment, 68)
			Result.put (empty_character_class_segment, 69)
			Result.put (empty_character_class_segment, 70)
			Result.put (empty_character_class_segment, 71)
			Result.put (empty_character_class_segment, 72)
			Result.put (empty_character_class_segment, 73)
			Result.put (empty_character_class_segment, 74)
			Result.put (empty_character_class_segment, 75)
			Result.put (empty_character_class_segment, 76)
			Result.put (empty_character_class_segment, 77)
			Result.put (empty_character_class_segment, 78)
			Result.put (empty_character_class_segment, 79)
			Result.put (empty_character_class_segment, 80)
			Result.put (empty_character_class_segment, 81)
			Result.put (empty_character_class_segment, 82)
			Result.put (empty_character_class_segment, 83)
			Result.put (empty_character_class_segment, 84)
			Result.put (empty_character_class_segment, 85)
			Result.put (empty_character_class_segment, 86)
			Result.put (empty_character_class_segment, 87)
			Result.put (empty_character_class_segment, 88)
			Result.put (empty_character_class_segment, 89)
			Result.put (empty_character_class_segment, 90)
			Result.put (empty_character_class_segment, 91)
			Result.put (empty_character_class_segment, 92)
			Result.put (empty_character_class_segment, 93)
			Result.put (empty_character_class_segment, 94)
			Result.put (empty_character_class_segment, 95)
			Result.put (empty_character_class_segment, 96)
			Result.put (empty_character_class_segment, 97)
			Result.put (empty_character_class_segment, 98)
			Result.put (empty_character_class_segment, 99)
			Result.put (empty_character_class_segment, 100)
			Result.put (empty_character_class_segment, 101)
			Result.put (empty_character_class_segment, 102)
			Result.put (empty_character_class_segment, 103)
			Result.put (empty_character_class_segment, 104)
			Result.put (empty_character_class_segment, 105)
			Result.put (empty_character_class_segment, 106)
			Result.put (empty_character_class_segment, 107)
			Result.put (empty_character_class_segment, 108)
			Result.put (empty_character_class_segment, 109)
			Result.put (empty_character_class_segment, 110)
			Result.put (empty_character_class_segment, 111)
			Result.put (empty_character_class_segment, 112)
			Result.put (empty_character_class_segment, 113)
			Result.put (empty_character_class_segment, 114)
			Result.put (empty_character_class_segment, 115)
			Result.put (empty_character_class_segment, 116)
			Result.put (empty_character_class_segment, 117)
			Result.put (empty_character_class_segment, 118)
			Result.put (empty_character_class_segment, 119)
			Result.put (empty_character_class_segment, 120)
			Result.put (empty_character_class_segment, 121)
			Result.put (empty_character_class_segment, 122)
			Result.put (empty_character_class_segment, 123)
			Result.put (empty_character_class_segment, 124)
			Result.put (empty_character_class_segment, 125)
			Result.put (empty_character_class_segment, 126)
			Result.put (empty_character_class_segment, 127)
			Result.put (empty_character_class_segment, 128)
			Result.put (empty_character_class_segment, 129)
			Result.put (empty_character_class_segment, 130)
			Result.put (empty_character_class_segment, 131)
			Result.put (empty_character_class_segment, 132)
			Result.put (empty_character_class_segment, 133)
			Result.put (empty_character_class_segment, 134)
			Result.put (empty_character_class_segment, 135)
			Result.put (empty_character_class_segment, 136)
			Result.put (empty_character_class_segment, 137)
			Result.put (empty_character_class_segment, 138)
			Result.put (empty_character_class_segment, 139)
			Result.put (empty_character_class_segment, 140)
			Result.put (empty_character_class_segment, 141)
			Result.put (empty_character_class_segment, 142)
			Result.put (empty_character_class_segment, 143)
			Result.put (empty_character_class_segment, 144)
			Result.put (empty_character_class_segment, 145)
			Result.put (empty_character_class_segment, 146)
			Result.put (empty_character_class_segment, 147)
			Result.put (empty_character_class_segment, 148)
			Result.put (empty_character_class_segment, 149)
			Result.put (empty_character_class_segment, 150)
			Result.put (empty_character_class_segment, 151)
			Result.put (empty_character_class_segment, 152)
			Result.put (empty_character_class_segment, 153)
			Result.put (empty_character_class_segment, 154)
			Result.put (empty_character_class_segment, 155)
			Result.put (empty_character_class_segment, 156)
			Result.put (empty_character_class_segment, 157)
			Result.put (empty_character_class_segment, 158)
			Result.put (empty_character_class_segment, 159)
			Result.put (empty_character_class_segment, 160)
			Result.put (empty_character_class_segment, 161)
			Result.put (empty_character_class_segment, 162)
			Result.put (empty_character_class_segment, 163)
			Result.put (empty_character_class_segment, 164)
			Result.put (empty_character_class_segment, 165)
			Result.put (empty_character_class_segment, 166)
			Result.put (empty_character_class_segment, 167)
			Result.put (empty_character_class_segment, 168)
			Result.put (empty_character_class_segment, 169)
			Result.put (empty_character_class_segment, 170)
			Result.put (empty_character_class_segment, 171)
			Result.put (empty_character_class_segment, 172)
			Result.put (empty_character_class_segment, 173)
			Result.put (empty_character_class_segment, 174)
			Result.put (empty_character_class_segment, 175)
			Result.put (empty_character_class_segment, 176)
			Result.put (empty_character_class_segment, 177)
			Result.put (empty_character_class_segment, 178)
			Result.put (empty_character_class_segment, 179)
			Result.put (empty_character_class_segment, 180)
			Result.put (empty_character_class_segment, 181)
			Result.put (empty_character_class_segment, 182)
			Result.put (empty_character_class_segment, 183)
			Result.put (empty_character_class_segment, 184)
			Result.put (empty_character_class_segment, 185)
			Result.put (empty_character_class_segment, 186)
			Result.put (empty_character_class_segment, 187)
			Result.put (empty_character_class_segment, 188)
			Result.put (empty_character_class_segment, 189)
			Result.put (empty_character_class_segment, 190)
			Result.put (empty_character_class_segment, 191)
			Result.put (empty_character_class_segment, 192)
			Result.put (empty_character_class_segment, 193)
			Result.put (empty_character_class_segment, 194)
			Result.put (empty_character_class_segment, 195)
			Result.put (empty_character_class_segment, 196)
			Result.put (empty_character_class_segment, 197)
			Result.put (empty_character_class_segment, 198)
			Result.put (empty_character_class_segment, 199)
			Result.put (empty_character_class_segment, 200)
			Result.put (empty_character_class_segment, 201)
			Result.put (empty_character_class_segment, 202)
			Result.put (empty_character_class_segment, 203)
			Result.put (empty_character_class_segment, 204)
			Result.put (empty_character_class_segment, 205)
			Result.put (empty_character_class_segment, 206)
			Result.put (empty_character_class_segment, 207)
			Result.put (character_class_plane_1_segment_208, 208)
			Result.put (character_class_plane_1_segment_209, 209)
			Result.put (character_class_plane_1_segment_210, 210)
			Result.put (character_class_plane_1_segment_211, 211)
			Result.put (character_class_plane_1_segment_212, 212)
			Result.put (character_class_plane_1_segment_213, 213)
			Result.put (character_class_plane_1_segment_214, 214)
			Result.put (character_class_plane_1_segment_215, 215)
			Result.put (empty_character_class_segment, 216)
			Result.put (empty_character_class_segment, 217)
			Result.put (empty_character_class_segment, 218)
			Result.put (empty_character_class_segment, 219)
			Result.put (empty_character_class_segment, 220)
			Result.put (empty_character_class_segment, 221)
			Result.put (empty_character_class_segment, 222)
			Result.put (empty_character_class_segment, 223)
			Result.put (empty_character_class_segment, 224)
			Result.put (empty_character_class_segment, 225)
			Result.put (empty_character_class_segment, 226)
			Result.put (empty_character_class_segment, 227)
			Result.put (empty_character_class_segment, 228)
			Result.put (empty_character_class_segment, 229)
			Result.put (empty_character_class_segment, 230)
			Result.put (empty_character_class_segment, 231)
			Result.put (empty_character_class_segment, 232)
			Result.put (empty_character_class_segment, 233)
			Result.put (empty_character_class_segment, 234)
			Result.put (empty_character_class_segment, 235)
			Result.put (empty_character_class_segment, 236)
			Result.put (empty_character_class_segment, 237)
			Result.put (empty_character_class_segment, 238)
			Result.put (empty_character_class_segment, 239)
			Result.put (character_class_plane_1_segment_240, 240)
			Result.put (empty_character_class_segment, 241)
			Result.put (empty_character_class_segment, 242)
			Result.put (empty_character_class_segment, 243)
			Result.put (empty_character_class_segment, 244)
			Result.put (empty_character_class_segment, 245)
			Result.put (empty_character_class_segment, 246)
			Result.put (empty_character_class_segment, 247)
			Result.put (empty_character_class_segment, 248)
			Result.put (empty_character_class_segment, 249)
			Result.put (empty_character_class_segment, 250)
			Result.put (empty_character_class_segment, 251)
			Result.put (empty_character_class_segment, 252)
			Result.put (empty_character_class_segment, 253)
			Result.put (empty_character_class_segment, 254)
			Result.put (empty_character_class_segment, 255)
		ensure
			result_not_void: Result /= Void
			sub_arrays_not_void: True --not Result.has (Void)
		end

	character_class_plane_2_segment_0: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_1: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_2: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_3: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_4: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_5: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_6: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_7: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_8: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_9: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_10: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_11: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_12: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_13: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_14: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_15: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_16: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_17: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_18: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_19: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_20: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_21: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_22: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_23: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_24: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_25: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_26: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_27: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_28: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_29: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_30: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_31: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_32: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_33: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_34: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_35: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_36: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_37: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_38: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_39: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_40: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_41: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_42: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_43: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_44: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_45: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_46: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_47: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_48: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_49: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_50: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_51: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_52: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_53: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_54: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_55: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_56: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_57: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_58: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_59: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_60: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_61: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_62: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_63: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_64: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_65: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_66: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_67: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_68: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_69: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_70: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_71: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_72: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_73: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_74: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_75: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_76: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_77: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_78: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_79: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_80: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_81: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_82: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_83: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_84: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_85: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_86: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_87: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_88: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_89: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_90: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_91: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_92: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_93: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_94: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_95: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_96: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_97: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_98: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_99: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_100: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_101: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_102: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_103: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_104: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_105: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_106: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_107: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_108: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_109: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_110: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_111: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_112: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_113: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_114: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_115: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_116: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_117: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_118: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_119: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_120: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_121: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_122: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_123: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_124: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_125: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_126: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_127: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_128: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_129: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_130: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_131: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_132: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_133: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_134: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_135: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_136: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_137: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_138: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_139: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_140: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_141: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_142: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_143: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_144: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_145: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_146: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_147: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_148: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_149: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_150: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_151: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_152: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_153: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_154: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_155: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_156: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_157: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_158: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_159: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_160: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_161: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_162: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_163: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_164: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_165: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_166: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_248: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_249: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2_segment_250: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/5/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_2: SPECIAL [ARRAY [INTEGER_8]]
			-- Generated character class array plane
		once
			create Result.make_filled (Void, 256)
			Result.put (character_class_plane_2_segment_0, 0)
			Result.put (character_class_plane_2_segment_1, 1)
			Result.put (character_class_plane_2_segment_2, 2)
			Result.put (character_class_plane_2_segment_3, 3)
			Result.put (character_class_plane_2_segment_4, 4)
			Result.put (character_class_plane_2_segment_5, 5)
			Result.put (character_class_plane_2_segment_6, 6)
			Result.put (character_class_plane_2_segment_7, 7)
			Result.put (character_class_plane_2_segment_8, 8)
			Result.put (character_class_plane_2_segment_9, 9)
			Result.put (character_class_plane_2_segment_10, 10)
			Result.put (character_class_plane_2_segment_11, 11)
			Result.put (character_class_plane_2_segment_12, 12)
			Result.put (character_class_plane_2_segment_13, 13)
			Result.put (character_class_plane_2_segment_14, 14)
			Result.put (character_class_plane_2_segment_15, 15)
			Result.put (character_class_plane_2_segment_16, 16)
			Result.put (character_class_plane_2_segment_17, 17)
			Result.put (character_class_plane_2_segment_18, 18)
			Result.put (character_class_plane_2_segment_19, 19)
			Result.put (character_class_plane_2_segment_20, 20)
			Result.put (character_class_plane_2_segment_21, 21)
			Result.put (character_class_plane_2_segment_22, 22)
			Result.put (character_class_plane_2_segment_23, 23)
			Result.put (character_class_plane_2_segment_24, 24)
			Result.put (character_class_plane_2_segment_25, 25)
			Result.put (character_class_plane_2_segment_26, 26)
			Result.put (character_class_plane_2_segment_27, 27)
			Result.put (character_class_plane_2_segment_28, 28)
			Result.put (character_class_plane_2_segment_29, 29)
			Result.put (character_class_plane_2_segment_30, 30)
			Result.put (character_class_plane_2_segment_31, 31)
			Result.put (character_class_plane_2_segment_32, 32)
			Result.put (character_class_plane_2_segment_33, 33)
			Result.put (character_class_plane_2_segment_34, 34)
			Result.put (character_class_plane_2_segment_35, 35)
			Result.put (character_class_plane_2_segment_36, 36)
			Result.put (character_class_plane_2_segment_37, 37)
			Result.put (character_class_plane_2_segment_38, 38)
			Result.put (character_class_plane_2_segment_39, 39)
			Result.put (character_class_plane_2_segment_40, 40)
			Result.put (character_class_plane_2_segment_41, 41)
			Result.put (character_class_plane_2_segment_42, 42)
			Result.put (character_class_plane_2_segment_43, 43)
			Result.put (character_class_plane_2_segment_44, 44)
			Result.put (character_class_plane_2_segment_45, 45)
			Result.put (character_class_plane_2_segment_46, 46)
			Result.put (character_class_plane_2_segment_47, 47)
			Result.put (character_class_plane_2_segment_48, 48)
			Result.put (character_class_plane_2_segment_49, 49)
			Result.put (character_class_plane_2_segment_50, 50)
			Result.put (character_class_plane_2_segment_51, 51)
			Result.put (character_class_plane_2_segment_52, 52)
			Result.put (character_class_plane_2_segment_53, 53)
			Result.put (character_class_plane_2_segment_54, 54)
			Result.put (character_class_plane_2_segment_55, 55)
			Result.put (character_class_plane_2_segment_56, 56)
			Result.put (character_class_plane_2_segment_57, 57)
			Result.put (character_class_plane_2_segment_58, 58)
			Result.put (character_class_plane_2_segment_59, 59)
			Result.put (character_class_plane_2_segment_60, 60)
			Result.put (character_class_plane_2_segment_61, 61)
			Result.put (character_class_plane_2_segment_62, 62)
			Result.put (character_class_plane_2_segment_63, 63)
			Result.put (character_class_plane_2_segment_64, 64)
			Result.put (character_class_plane_2_segment_65, 65)
			Result.put (character_class_plane_2_segment_66, 66)
			Result.put (character_class_plane_2_segment_67, 67)
			Result.put (character_class_plane_2_segment_68, 68)
			Result.put (character_class_plane_2_segment_69, 69)
			Result.put (character_class_plane_2_segment_70, 70)
			Result.put (character_class_plane_2_segment_71, 71)
			Result.put (character_class_plane_2_segment_72, 72)
			Result.put (character_class_plane_2_segment_73, 73)
			Result.put (character_class_plane_2_segment_74, 74)
			Result.put (character_class_plane_2_segment_75, 75)
			Result.put (character_class_plane_2_segment_76, 76)
			Result.put (character_class_plane_2_segment_77, 77)
			Result.put (character_class_plane_2_segment_78, 78)
			Result.put (character_class_plane_2_segment_79, 79)
			Result.put (character_class_plane_2_segment_80, 80)
			Result.put (character_class_plane_2_segment_81, 81)
			Result.put (character_class_plane_2_segment_82, 82)
			Result.put (character_class_plane_2_segment_83, 83)
			Result.put (character_class_plane_2_segment_84, 84)
			Result.put (character_class_plane_2_segment_85, 85)
			Result.put (character_class_plane_2_segment_86, 86)
			Result.put (character_class_plane_2_segment_87, 87)
			Result.put (character_class_plane_2_segment_88, 88)
			Result.put (character_class_plane_2_segment_89, 89)
			Result.put (character_class_plane_2_segment_90, 90)
			Result.put (character_class_plane_2_segment_91, 91)
			Result.put (character_class_plane_2_segment_92, 92)
			Result.put (character_class_plane_2_segment_93, 93)
			Result.put (character_class_plane_2_segment_94, 94)
			Result.put (character_class_plane_2_segment_95, 95)
			Result.put (character_class_plane_2_segment_96, 96)
			Result.put (character_class_plane_2_segment_97, 97)
			Result.put (character_class_plane_2_segment_98, 98)
			Result.put (character_class_plane_2_segment_99, 99)
			Result.put (character_class_plane_2_segment_100, 100)
			Result.put (character_class_plane_2_segment_101, 101)
			Result.put (character_class_plane_2_segment_102, 102)
			Result.put (character_class_plane_2_segment_103, 103)
			Result.put (character_class_plane_2_segment_104, 104)
			Result.put (character_class_plane_2_segment_105, 105)
			Result.put (character_class_plane_2_segment_106, 106)
			Result.put (character_class_plane_2_segment_107, 107)
			Result.put (character_class_plane_2_segment_108, 108)
			Result.put (character_class_plane_2_segment_109, 109)
			Result.put (character_class_plane_2_segment_110, 110)
			Result.put (character_class_plane_2_segment_111, 111)
			Result.put (character_class_plane_2_segment_112, 112)
			Result.put (character_class_plane_2_segment_113, 113)
			Result.put (character_class_plane_2_segment_114, 114)
			Result.put (character_class_plane_2_segment_115, 115)
			Result.put (character_class_plane_2_segment_116, 116)
			Result.put (character_class_plane_2_segment_117, 117)
			Result.put (character_class_plane_2_segment_118, 118)
			Result.put (character_class_plane_2_segment_119, 119)
			Result.put (character_class_plane_2_segment_120, 120)
			Result.put (character_class_plane_2_segment_121, 121)
			Result.put (character_class_plane_2_segment_122, 122)
			Result.put (character_class_plane_2_segment_123, 123)
			Result.put (character_class_plane_2_segment_124, 124)
			Result.put (character_class_plane_2_segment_125, 125)
			Result.put (character_class_plane_2_segment_126, 126)
			Result.put (character_class_plane_2_segment_127, 127)
			Result.put (character_class_plane_2_segment_128, 128)
			Result.put (character_class_plane_2_segment_129, 129)
			Result.put (character_class_plane_2_segment_130, 130)
			Result.put (character_class_plane_2_segment_131, 131)
			Result.put (character_class_plane_2_segment_132, 132)
			Result.put (character_class_plane_2_segment_133, 133)
			Result.put (character_class_plane_2_segment_134, 134)
			Result.put (character_class_plane_2_segment_135, 135)
			Result.put (character_class_plane_2_segment_136, 136)
			Result.put (character_class_plane_2_segment_137, 137)
			Result.put (character_class_plane_2_segment_138, 138)
			Result.put (character_class_plane_2_segment_139, 139)
			Result.put (character_class_plane_2_segment_140, 140)
			Result.put (character_class_plane_2_segment_141, 141)
			Result.put (character_class_plane_2_segment_142, 142)
			Result.put (character_class_plane_2_segment_143, 143)
			Result.put (character_class_plane_2_segment_144, 144)
			Result.put (character_class_plane_2_segment_145, 145)
			Result.put (character_class_plane_2_segment_146, 146)
			Result.put (character_class_plane_2_segment_147, 147)
			Result.put (character_class_plane_2_segment_148, 148)
			Result.put (character_class_plane_2_segment_149, 149)
			Result.put (character_class_plane_2_segment_150, 150)
			Result.put (character_class_plane_2_segment_151, 151)
			Result.put (character_class_plane_2_segment_152, 152)
			Result.put (character_class_plane_2_segment_153, 153)
			Result.put (character_class_plane_2_segment_154, 154)
			Result.put (character_class_plane_2_segment_155, 155)
			Result.put (character_class_plane_2_segment_156, 156)
			Result.put (character_class_plane_2_segment_157, 157)
			Result.put (character_class_plane_2_segment_158, 158)
			Result.put (character_class_plane_2_segment_159, 159)
			Result.put (character_class_plane_2_segment_160, 160)
			Result.put (character_class_plane_2_segment_161, 161)
			Result.put (character_class_plane_2_segment_162, 162)
			Result.put (character_class_plane_2_segment_163, 163)
			Result.put (character_class_plane_2_segment_164, 164)
			Result.put (character_class_plane_2_segment_165, 165)
			Result.put (character_class_plane_2_segment_166, 166)
			Result.put (empty_character_class_segment, 167)
			Result.put (empty_character_class_segment, 168)
			Result.put (empty_character_class_segment, 169)
			Result.put (empty_character_class_segment, 170)
			Result.put (empty_character_class_segment, 171)
			Result.put (empty_character_class_segment, 172)
			Result.put (empty_character_class_segment, 173)
			Result.put (empty_character_class_segment, 174)
			Result.put (empty_character_class_segment, 175)
			Result.put (empty_character_class_segment, 176)
			Result.put (empty_character_class_segment, 177)
			Result.put (empty_character_class_segment, 178)
			Result.put (empty_character_class_segment, 179)
			Result.put (empty_character_class_segment, 180)
			Result.put (empty_character_class_segment, 181)
			Result.put (empty_character_class_segment, 182)
			Result.put (empty_character_class_segment, 183)
			Result.put (empty_character_class_segment, 184)
			Result.put (empty_character_class_segment, 185)
			Result.put (empty_character_class_segment, 186)
			Result.put (empty_character_class_segment, 187)
			Result.put (empty_character_class_segment, 188)
			Result.put (empty_character_class_segment, 189)
			Result.put (empty_character_class_segment, 190)
			Result.put (empty_character_class_segment, 191)
			Result.put (empty_character_class_segment, 192)
			Result.put (empty_character_class_segment, 193)
			Result.put (empty_character_class_segment, 194)
			Result.put (empty_character_class_segment, 195)
			Result.put (empty_character_class_segment, 196)
			Result.put (empty_character_class_segment, 197)
			Result.put (empty_character_class_segment, 198)
			Result.put (empty_character_class_segment, 199)
			Result.put (empty_character_class_segment, 200)
			Result.put (empty_character_class_segment, 201)
			Result.put (empty_character_class_segment, 202)
			Result.put (empty_character_class_segment, 203)
			Result.put (empty_character_class_segment, 204)
			Result.put (empty_character_class_segment, 205)
			Result.put (empty_character_class_segment, 206)
			Result.put (empty_character_class_segment, 207)
			Result.put (empty_character_class_segment, 208)
			Result.put (empty_character_class_segment, 209)
			Result.put (empty_character_class_segment, 210)
			Result.put (empty_character_class_segment, 211)
			Result.put (empty_character_class_segment, 212)
			Result.put (empty_character_class_segment, 213)
			Result.put (empty_character_class_segment, 214)
			Result.put (empty_character_class_segment, 215)
			Result.put (empty_character_class_segment, 216)
			Result.put (empty_character_class_segment, 217)
			Result.put (empty_character_class_segment, 218)
			Result.put (empty_character_class_segment, 219)
			Result.put (empty_character_class_segment, 220)
			Result.put (empty_character_class_segment, 221)
			Result.put (empty_character_class_segment, 222)
			Result.put (empty_character_class_segment, 223)
			Result.put (empty_character_class_segment, 224)
			Result.put (empty_character_class_segment, 225)
			Result.put (empty_character_class_segment, 226)
			Result.put (empty_character_class_segment, 227)
			Result.put (empty_character_class_segment, 228)
			Result.put (empty_character_class_segment, 229)
			Result.put (empty_character_class_segment, 230)
			Result.put (empty_character_class_segment, 231)
			Result.put (empty_character_class_segment, 232)
			Result.put (empty_character_class_segment, 233)
			Result.put (empty_character_class_segment, 234)
			Result.put (empty_character_class_segment, 235)
			Result.put (empty_character_class_segment, 236)
			Result.put (empty_character_class_segment, 237)
			Result.put (empty_character_class_segment, 238)
			Result.put (empty_character_class_segment, 239)
			Result.put (empty_character_class_segment, 240)
			Result.put (empty_character_class_segment, 241)
			Result.put (empty_character_class_segment, 242)
			Result.put (empty_character_class_segment, 243)
			Result.put (empty_character_class_segment, 244)
			Result.put (empty_character_class_segment, 245)
			Result.put (empty_character_class_segment, 246)
			Result.put (empty_character_class_segment, 247)
			Result.put (character_class_plane_2_segment_248, 248)
			Result.put (character_class_plane_2_segment_249, 249)
			Result.put (character_class_plane_2_segment_250, 250)
			Result.put (empty_character_class_segment, 251)
			Result.put (empty_character_class_segment, 252)
			Result.put (empty_character_class_segment, 253)
			Result.put (empty_character_class_segment, 254)
			Result.put (empty_character_class_segment, 255)
		ensure
			result_not_void: Result /= Void
			sub_arrays_not_void: True --not Result.has (Void)
		end

	empty_character_class_plane: SPECIAL [ARRAY [INTEGER_8]]
			-- Generated character class array plane
		once
			create Result.make_filled (Void, 256)
			Result.put (empty_character_class_segment, 0)
			Result.put (empty_character_class_segment, 1)
			Result.put (empty_character_class_segment, 2)
			Result.put (empty_character_class_segment, 3)
			Result.put (empty_character_class_segment, 4)
			Result.put (empty_character_class_segment, 5)
			Result.put (empty_character_class_segment, 6)
			Result.put (empty_character_class_segment, 7)
			Result.put (empty_character_class_segment, 8)
			Result.put (empty_character_class_segment, 9)
			Result.put (empty_character_class_segment, 10)
			Result.put (empty_character_class_segment, 11)
			Result.put (empty_character_class_segment, 12)
			Result.put (empty_character_class_segment, 13)
			Result.put (empty_character_class_segment, 14)
			Result.put (empty_character_class_segment, 15)
			Result.put (empty_character_class_segment, 16)
			Result.put (empty_character_class_segment, 17)
			Result.put (empty_character_class_segment, 18)
			Result.put (empty_character_class_segment, 19)
			Result.put (empty_character_class_segment, 20)
			Result.put (empty_character_class_segment, 21)
			Result.put (empty_character_class_segment, 22)
			Result.put (empty_character_class_segment, 23)
			Result.put (empty_character_class_segment, 24)
			Result.put (empty_character_class_segment, 25)
			Result.put (empty_character_class_segment, 26)
			Result.put (empty_character_class_segment, 27)
			Result.put (empty_character_class_segment, 28)
			Result.put (empty_character_class_segment, 29)
			Result.put (empty_character_class_segment, 30)
			Result.put (empty_character_class_segment, 31)
			Result.put (empty_character_class_segment, 32)
			Result.put (empty_character_class_segment, 33)
			Result.put (empty_character_class_segment, 34)
			Result.put (empty_character_class_segment, 35)
			Result.put (empty_character_class_segment, 36)
			Result.put (empty_character_class_segment, 37)
			Result.put (empty_character_class_segment, 38)
			Result.put (empty_character_class_segment, 39)
			Result.put (empty_character_class_segment, 40)
			Result.put (empty_character_class_segment, 41)
			Result.put (empty_character_class_segment, 42)
			Result.put (empty_character_class_segment, 43)
			Result.put (empty_character_class_segment, 44)
			Result.put (empty_character_class_segment, 45)
			Result.put (empty_character_class_segment, 46)
			Result.put (empty_character_class_segment, 47)
			Result.put (empty_character_class_segment, 48)
			Result.put (empty_character_class_segment, 49)
			Result.put (empty_character_class_segment, 50)
			Result.put (empty_character_class_segment, 51)
			Result.put (empty_character_class_segment, 52)
			Result.put (empty_character_class_segment, 53)
			Result.put (empty_character_class_segment, 54)
			Result.put (empty_character_class_segment, 55)
			Result.put (empty_character_class_segment, 56)
			Result.put (empty_character_class_segment, 57)
			Result.put (empty_character_class_segment, 58)
			Result.put (empty_character_class_segment, 59)
			Result.put (empty_character_class_segment, 60)
			Result.put (empty_character_class_segment, 61)
			Result.put (empty_character_class_segment, 62)
			Result.put (empty_character_class_segment, 63)
			Result.put (empty_character_class_segment, 64)
			Result.put (empty_character_class_segment, 65)
			Result.put (empty_character_class_segment, 66)
			Result.put (empty_character_class_segment, 67)
			Result.put (empty_character_class_segment, 68)
			Result.put (empty_character_class_segment, 69)
			Result.put (empty_character_class_segment, 70)
			Result.put (empty_character_class_segment, 71)
			Result.put (empty_character_class_segment, 72)
			Result.put (empty_character_class_segment, 73)
			Result.put (empty_character_class_segment, 74)
			Result.put (empty_character_class_segment, 75)
			Result.put (empty_character_class_segment, 76)
			Result.put (empty_character_class_segment, 77)
			Result.put (empty_character_class_segment, 78)
			Result.put (empty_character_class_segment, 79)
			Result.put (empty_character_class_segment, 80)
			Result.put (empty_character_class_segment, 81)
			Result.put (empty_character_class_segment, 82)
			Result.put (empty_character_class_segment, 83)
			Result.put (empty_character_class_segment, 84)
			Result.put (empty_character_class_segment, 85)
			Result.put (empty_character_class_segment, 86)
			Result.put (empty_character_class_segment, 87)
			Result.put (empty_character_class_segment, 88)
			Result.put (empty_character_class_segment, 89)
			Result.put (empty_character_class_segment, 90)
			Result.put (empty_character_class_segment, 91)
			Result.put (empty_character_class_segment, 92)
			Result.put (empty_character_class_segment, 93)
			Result.put (empty_character_class_segment, 94)
			Result.put (empty_character_class_segment, 95)
			Result.put (empty_character_class_segment, 96)
			Result.put (empty_character_class_segment, 97)
			Result.put (empty_character_class_segment, 98)
			Result.put (empty_character_class_segment, 99)
			Result.put (empty_character_class_segment, 100)
			Result.put (empty_character_class_segment, 101)
			Result.put (empty_character_class_segment, 102)
			Result.put (empty_character_class_segment, 103)
			Result.put (empty_character_class_segment, 104)
			Result.put (empty_character_class_segment, 105)
			Result.put (empty_character_class_segment, 106)
			Result.put (empty_character_class_segment, 107)
			Result.put (empty_character_class_segment, 108)
			Result.put (empty_character_class_segment, 109)
			Result.put (empty_character_class_segment, 110)
			Result.put (empty_character_class_segment, 111)
			Result.put (empty_character_class_segment, 112)
			Result.put (empty_character_class_segment, 113)
			Result.put (empty_character_class_segment, 114)
			Result.put (empty_character_class_segment, 115)
			Result.put (empty_character_class_segment, 116)
			Result.put (empty_character_class_segment, 117)
			Result.put (empty_character_class_segment, 118)
			Result.put (empty_character_class_segment, 119)
			Result.put (empty_character_class_segment, 120)
			Result.put (empty_character_class_segment, 121)
			Result.put (empty_character_class_segment, 122)
			Result.put (empty_character_class_segment, 123)
			Result.put (empty_character_class_segment, 124)
			Result.put (empty_character_class_segment, 125)
			Result.put (empty_character_class_segment, 126)
			Result.put (empty_character_class_segment, 127)
			Result.put (empty_character_class_segment, 128)
			Result.put (empty_character_class_segment, 129)
			Result.put (empty_character_class_segment, 130)
			Result.put (empty_character_class_segment, 131)
			Result.put (empty_character_class_segment, 132)
			Result.put (empty_character_class_segment, 133)
			Result.put (empty_character_class_segment, 134)
			Result.put (empty_character_class_segment, 135)
			Result.put (empty_character_class_segment, 136)
			Result.put (empty_character_class_segment, 137)
			Result.put (empty_character_class_segment, 138)
			Result.put (empty_character_class_segment, 139)
			Result.put (empty_character_class_segment, 140)
			Result.put (empty_character_class_segment, 141)
			Result.put (empty_character_class_segment, 142)
			Result.put (empty_character_class_segment, 143)
			Result.put (empty_character_class_segment, 144)
			Result.put (empty_character_class_segment, 145)
			Result.put (empty_character_class_segment, 146)
			Result.put (empty_character_class_segment, 147)
			Result.put (empty_character_class_segment, 148)
			Result.put (empty_character_class_segment, 149)
			Result.put (empty_character_class_segment, 150)
			Result.put (empty_character_class_segment, 151)
			Result.put (empty_character_class_segment, 152)
			Result.put (empty_character_class_segment, 153)
			Result.put (empty_character_class_segment, 154)
			Result.put (empty_character_class_segment, 155)
			Result.put (empty_character_class_segment, 156)
			Result.put (empty_character_class_segment, 157)
			Result.put (empty_character_class_segment, 158)
			Result.put (empty_character_class_segment, 159)
			Result.put (empty_character_class_segment, 160)
			Result.put (empty_character_class_segment, 161)
			Result.put (empty_character_class_segment, 162)
			Result.put (empty_character_class_segment, 163)
			Result.put (empty_character_class_segment, 164)
			Result.put (empty_character_class_segment, 165)
			Result.put (empty_character_class_segment, 166)
			Result.put (empty_character_class_segment, 167)
			Result.put (empty_character_class_segment, 168)
			Result.put (empty_character_class_segment, 169)
			Result.put (empty_character_class_segment, 170)
			Result.put (empty_character_class_segment, 171)
			Result.put (empty_character_class_segment, 172)
			Result.put (empty_character_class_segment, 173)
			Result.put (empty_character_class_segment, 174)
			Result.put (empty_character_class_segment, 175)
			Result.put (empty_character_class_segment, 176)
			Result.put (empty_character_class_segment, 177)
			Result.put (empty_character_class_segment, 178)
			Result.put (empty_character_class_segment, 179)
			Result.put (empty_character_class_segment, 180)
			Result.put (empty_character_class_segment, 181)
			Result.put (empty_character_class_segment, 182)
			Result.put (empty_character_class_segment, 183)
			Result.put (empty_character_class_segment, 184)
			Result.put (empty_character_class_segment, 185)
			Result.put (empty_character_class_segment, 186)
			Result.put (empty_character_class_segment, 187)
			Result.put (empty_character_class_segment, 188)
			Result.put (empty_character_class_segment, 189)
			Result.put (empty_character_class_segment, 190)
			Result.put (empty_character_class_segment, 191)
			Result.put (empty_character_class_segment, 192)
			Result.put (empty_character_class_segment, 193)
			Result.put (empty_character_class_segment, 194)
			Result.put (empty_character_class_segment, 195)
			Result.put (empty_character_class_segment, 196)
			Result.put (empty_character_class_segment, 197)
			Result.put (empty_character_class_segment, 198)
			Result.put (empty_character_class_segment, 199)
			Result.put (empty_character_class_segment, 200)
			Result.put (empty_character_class_segment, 201)
			Result.put (empty_character_class_segment, 202)
			Result.put (empty_character_class_segment, 203)
			Result.put (empty_character_class_segment, 204)
			Result.put (empty_character_class_segment, 205)
			Result.put (empty_character_class_segment, 206)
			Result.put (empty_character_class_segment, 207)
			Result.put (empty_character_class_segment, 208)
			Result.put (empty_character_class_segment, 209)
			Result.put (empty_character_class_segment, 210)
			Result.put (empty_character_class_segment, 211)
			Result.put (empty_character_class_segment, 212)
			Result.put (empty_character_class_segment, 213)
			Result.put (empty_character_class_segment, 214)
			Result.put (empty_character_class_segment, 215)
			Result.put (empty_character_class_segment, 216)
			Result.put (empty_character_class_segment, 217)
			Result.put (empty_character_class_segment, 218)
			Result.put (empty_character_class_segment, 219)
			Result.put (empty_character_class_segment, 220)
			Result.put (empty_character_class_segment, 221)
			Result.put (empty_character_class_segment, 222)
			Result.put (empty_character_class_segment, 223)
			Result.put (empty_character_class_segment, 224)
			Result.put (empty_character_class_segment, 225)
			Result.put (empty_character_class_segment, 226)
			Result.put (empty_character_class_segment, 227)
			Result.put (empty_character_class_segment, 228)
			Result.put (empty_character_class_segment, 229)
			Result.put (empty_character_class_segment, 230)
			Result.put (empty_character_class_segment, 231)
			Result.put (empty_character_class_segment, 232)
			Result.put (empty_character_class_segment, 233)
			Result.put (empty_character_class_segment, 234)
			Result.put (empty_character_class_segment, 235)
			Result.put (empty_character_class_segment, 236)
			Result.put (empty_character_class_segment, 237)
			Result.put (empty_character_class_segment, 238)
			Result.put (empty_character_class_segment, 239)
			Result.put (empty_character_class_segment, 240)
			Result.put (empty_character_class_segment, 241)
			Result.put (empty_character_class_segment, 242)
			Result.put (empty_character_class_segment, 243)
			Result.put (empty_character_class_segment, 244)
			Result.put (empty_character_class_segment, 245)
			Result.put (empty_character_class_segment, 246)
			Result.put (empty_character_class_segment, 247)
			Result.put (empty_character_class_segment, 248)
			Result.put (empty_character_class_segment, 249)
			Result.put (empty_character_class_segment, 250)
			Result.put (empty_character_class_segment, 251)
			Result.put (empty_character_class_segment, 252)
			Result.put (empty_character_class_segment, 253)
			Result.put (empty_character_class_segment, 254)
			Result.put (empty_character_class_segment, 255)
		ensure
			result_not_void: Result /= Void
			sub_arrays_not_void: True --not Result.has (Void)
		end

	character_class_plane_14_segment_0: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/0/%/27/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/27/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_14_segment_1: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/6/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/%/0/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_14: SPECIAL [ARRAY [INTEGER_8]]
			-- Generated character class array plane
		once
			create Result.make_filled (Void, 256)
			Result.put (character_class_plane_14_segment_0, 0)
			Result.put (character_class_plane_14_segment_1, 1)
			Result.put (empty_character_class_segment, 2)
			Result.put (empty_character_class_segment, 3)
			Result.put (empty_character_class_segment, 4)
			Result.put (empty_character_class_segment, 5)
			Result.put (empty_character_class_segment, 6)
			Result.put (empty_character_class_segment, 7)
			Result.put (empty_character_class_segment, 8)
			Result.put (empty_character_class_segment, 9)
			Result.put (empty_character_class_segment, 10)
			Result.put (empty_character_class_segment, 11)
			Result.put (empty_character_class_segment, 12)
			Result.put (empty_character_class_segment, 13)
			Result.put (empty_character_class_segment, 14)
			Result.put (empty_character_class_segment, 15)
			Result.put (empty_character_class_segment, 16)
			Result.put (empty_character_class_segment, 17)
			Result.put (empty_character_class_segment, 18)
			Result.put (empty_character_class_segment, 19)
			Result.put (empty_character_class_segment, 20)
			Result.put (empty_character_class_segment, 21)
			Result.put (empty_character_class_segment, 22)
			Result.put (empty_character_class_segment, 23)
			Result.put (empty_character_class_segment, 24)
			Result.put (empty_character_class_segment, 25)
			Result.put (empty_character_class_segment, 26)
			Result.put (empty_character_class_segment, 27)
			Result.put (empty_character_class_segment, 28)
			Result.put (empty_character_class_segment, 29)
			Result.put (empty_character_class_segment, 30)
			Result.put (empty_character_class_segment, 31)
			Result.put (empty_character_class_segment, 32)
			Result.put (empty_character_class_segment, 33)
			Result.put (empty_character_class_segment, 34)
			Result.put (empty_character_class_segment, 35)
			Result.put (empty_character_class_segment, 36)
			Result.put (empty_character_class_segment, 37)
			Result.put (empty_character_class_segment, 38)
			Result.put (empty_character_class_segment, 39)
			Result.put (empty_character_class_segment, 40)
			Result.put (empty_character_class_segment, 41)
			Result.put (empty_character_class_segment, 42)
			Result.put (empty_character_class_segment, 43)
			Result.put (empty_character_class_segment, 44)
			Result.put (empty_character_class_segment, 45)
			Result.put (empty_character_class_segment, 46)
			Result.put (empty_character_class_segment, 47)
			Result.put (empty_character_class_segment, 48)
			Result.put (empty_character_class_segment, 49)
			Result.put (empty_character_class_segment, 50)
			Result.put (empty_character_class_segment, 51)
			Result.put (empty_character_class_segment, 52)
			Result.put (empty_character_class_segment, 53)
			Result.put (empty_character_class_segment, 54)
			Result.put (empty_character_class_segment, 55)
			Result.put (empty_character_class_segment, 56)
			Result.put (empty_character_class_segment, 57)
			Result.put (empty_character_class_segment, 58)
			Result.put (empty_character_class_segment, 59)
			Result.put (empty_character_class_segment, 60)
			Result.put (empty_character_class_segment, 61)
			Result.put (empty_character_class_segment, 62)
			Result.put (empty_character_class_segment, 63)
			Result.put (empty_character_class_segment, 64)
			Result.put (empty_character_class_segment, 65)
			Result.put (empty_character_class_segment, 66)
			Result.put (empty_character_class_segment, 67)
			Result.put (empty_character_class_segment, 68)
			Result.put (empty_character_class_segment, 69)
			Result.put (empty_character_class_segment, 70)
			Result.put (empty_character_class_segment, 71)
			Result.put (empty_character_class_segment, 72)
			Result.put (empty_character_class_segment, 73)
			Result.put (empty_character_class_segment, 74)
			Result.put (empty_character_class_segment, 75)
			Result.put (empty_character_class_segment, 76)
			Result.put (empty_character_class_segment, 77)
			Result.put (empty_character_class_segment, 78)
			Result.put (empty_character_class_segment, 79)
			Result.put (empty_character_class_segment, 80)
			Result.put (empty_character_class_segment, 81)
			Result.put (empty_character_class_segment, 82)
			Result.put (empty_character_class_segment, 83)
			Result.put (empty_character_class_segment, 84)
			Result.put (empty_character_class_segment, 85)
			Result.put (empty_character_class_segment, 86)
			Result.put (empty_character_class_segment, 87)
			Result.put (empty_character_class_segment, 88)
			Result.put (empty_character_class_segment, 89)
			Result.put (empty_character_class_segment, 90)
			Result.put (empty_character_class_segment, 91)
			Result.put (empty_character_class_segment, 92)
			Result.put (empty_character_class_segment, 93)
			Result.put (empty_character_class_segment, 94)
			Result.put (empty_character_class_segment, 95)
			Result.put (empty_character_class_segment, 96)
			Result.put (empty_character_class_segment, 97)
			Result.put (empty_character_class_segment, 98)
			Result.put (empty_character_class_segment, 99)
			Result.put (empty_character_class_segment, 100)
			Result.put (empty_character_class_segment, 101)
			Result.put (empty_character_class_segment, 102)
			Result.put (empty_character_class_segment, 103)
			Result.put (empty_character_class_segment, 104)
			Result.put (empty_character_class_segment, 105)
			Result.put (empty_character_class_segment, 106)
			Result.put (empty_character_class_segment, 107)
			Result.put (empty_character_class_segment, 108)
			Result.put (empty_character_class_segment, 109)
			Result.put (empty_character_class_segment, 110)
			Result.put (empty_character_class_segment, 111)
			Result.put (empty_character_class_segment, 112)
			Result.put (empty_character_class_segment, 113)
			Result.put (empty_character_class_segment, 114)
			Result.put (empty_character_class_segment, 115)
			Result.put (empty_character_class_segment, 116)
			Result.put (empty_character_class_segment, 117)
			Result.put (empty_character_class_segment, 118)
			Result.put (empty_character_class_segment, 119)
			Result.put (empty_character_class_segment, 120)
			Result.put (empty_character_class_segment, 121)
			Result.put (empty_character_class_segment, 122)
			Result.put (empty_character_class_segment, 123)
			Result.put (empty_character_class_segment, 124)
			Result.put (empty_character_class_segment, 125)
			Result.put (empty_character_class_segment, 126)
			Result.put (empty_character_class_segment, 127)
			Result.put (empty_character_class_segment, 128)
			Result.put (empty_character_class_segment, 129)
			Result.put (empty_character_class_segment, 130)
			Result.put (empty_character_class_segment, 131)
			Result.put (empty_character_class_segment, 132)
			Result.put (empty_character_class_segment, 133)
			Result.put (empty_character_class_segment, 134)
			Result.put (empty_character_class_segment, 135)
			Result.put (empty_character_class_segment, 136)
			Result.put (empty_character_class_segment, 137)
			Result.put (empty_character_class_segment, 138)
			Result.put (empty_character_class_segment, 139)
			Result.put (empty_character_class_segment, 140)
			Result.put (empty_character_class_segment, 141)
			Result.put (empty_character_class_segment, 142)
			Result.put (empty_character_class_segment, 143)
			Result.put (empty_character_class_segment, 144)
			Result.put (empty_character_class_segment, 145)
			Result.put (empty_character_class_segment, 146)
			Result.put (empty_character_class_segment, 147)
			Result.put (empty_character_class_segment, 148)
			Result.put (empty_character_class_segment, 149)
			Result.put (empty_character_class_segment, 150)
			Result.put (empty_character_class_segment, 151)
			Result.put (empty_character_class_segment, 152)
			Result.put (empty_character_class_segment, 153)
			Result.put (empty_character_class_segment, 154)
			Result.put (empty_character_class_segment, 155)
			Result.put (empty_character_class_segment, 156)
			Result.put (empty_character_class_segment, 157)
			Result.put (empty_character_class_segment, 158)
			Result.put (empty_character_class_segment, 159)
			Result.put (empty_character_class_segment, 160)
			Result.put (empty_character_class_segment, 161)
			Result.put (empty_character_class_segment, 162)
			Result.put (empty_character_class_segment, 163)
			Result.put (empty_character_class_segment, 164)
			Result.put (empty_character_class_segment, 165)
			Result.put (empty_character_class_segment, 166)
			Result.put (empty_character_class_segment, 167)
			Result.put (empty_character_class_segment, 168)
			Result.put (empty_character_class_segment, 169)
			Result.put (empty_character_class_segment, 170)
			Result.put (empty_character_class_segment, 171)
			Result.put (empty_character_class_segment, 172)
			Result.put (empty_character_class_segment, 173)
			Result.put (empty_character_class_segment, 174)
			Result.put (empty_character_class_segment, 175)
			Result.put (empty_character_class_segment, 176)
			Result.put (empty_character_class_segment, 177)
			Result.put (empty_character_class_segment, 178)
			Result.put (empty_character_class_segment, 179)
			Result.put (empty_character_class_segment, 180)
			Result.put (empty_character_class_segment, 181)
			Result.put (empty_character_class_segment, 182)
			Result.put (empty_character_class_segment, 183)
			Result.put (empty_character_class_segment, 184)
			Result.put (empty_character_class_segment, 185)
			Result.put (empty_character_class_segment, 186)
			Result.put (empty_character_class_segment, 187)
			Result.put (empty_character_class_segment, 188)
			Result.put (empty_character_class_segment, 189)
			Result.put (empty_character_class_segment, 190)
			Result.put (empty_character_class_segment, 191)
			Result.put (empty_character_class_segment, 192)
			Result.put (empty_character_class_segment, 193)
			Result.put (empty_character_class_segment, 194)
			Result.put (empty_character_class_segment, 195)
			Result.put (empty_character_class_segment, 196)
			Result.put (empty_character_class_segment, 197)
			Result.put (empty_character_class_segment, 198)
			Result.put (empty_character_class_segment, 199)
			Result.put (empty_character_class_segment, 200)
			Result.put (empty_character_class_segment, 201)
			Result.put (empty_character_class_segment, 202)
			Result.put (empty_character_class_segment, 203)
			Result.put (empty_character_class_segment, 204)
			Result.put (empty_character_class_segment, 205)
			Result.put (empty_character_class_segment, 206)
			Result.put (empty_character_class_segment, 207)
			Result.put (empty_character_class_segment, 208)
			Result.put (empty_character_class_segment, 209)
			Result.put (empty_character_class_segment, 210)
			Result.put (empty_character_class_segment, 211)
			Result.put (empty_character_class_segment, 212)
			Result.put (empty_character_class_segment, 213)
			Result.put (empty_character_class_segment, 214)
			Result.put (empty_character_class_segment, 215)
			Result.put (empty_character_class_segment, 216)
			Result.put (empty_character_class_segment, 217)
			Result.put (empty_character_class_segment, 218)
			Result.put (empty_character_class_segment, 219)
			Result.put (empty_character_class_segment, 220)
			Result.put (empty_character_class_segment, 221)
			Result.put (empty_character_class_segment, 222)
			Result.put (empty_character_class_segment, 223)
			Result.put (empty_character_class_segment, 224)
			Result.put (empty_character_class_segment, 225)
			Result.put (empty_character_class_segment, 226)
			Result.put (empty_character_class_segment, 227)
			Result.put (empty_character_class_segment, 228)
			Result.put (empty_character_class_segment, 229)
			Result.put (empty_character_class_segment, 230)
			Result.put (empty_character_class_segment, 231)
			Result.put (empty_character_class_segment, 232)
			Result.put (empty_character_class_segment, 233)
			Result.put (empty_character_class_segment, 234)
			Result.put (empty_character_class_segment, 235)
			Result.put (empty_character_class_segment, 236)
			Result.put (empty_character_class_segment, 237)
			Result.put (empty_character_class_segment, 238)
			Result.put (empty_character_class_segment, 239)
			Result.put (empty_character_class_segment, 240)
			Result.put (empty_character_class_segment, 241)
			Result.put (empty_character_class_segment, 242)
			Result.put (empty_character_class_segment, 243)
			Result.put (empty_character_class_segment, 244)
			Result.put (empty_character_class_segment, 245)
			Result.put (empty_character_class_segment, 246)
			Result.put (empty_character_class_segment, 247)
			Result.put (empty_character_class_segment, 248)
			Result.put (empty_character_class_segment, 249)
			Result.put (empty_character_class_segment, 250)
			Result.put (empty_character_class_segment, 251)
			Result.put (empty_character_class_segment, 252)
			Result.put (empty_character_class_segment, 253)
			Result.put (empty_character_class_segment, 254)
			Result.put (empty_character_class_segment, 255)
		ensure
			result_not_void: Result /= Void
			sub_arrays_not_void: True --not Result.has (Void)
		end

	character_class_plane_15_segment_0: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_1: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_2: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_3: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_4: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_5: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_6: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_7: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_8: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_9: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_10: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_11: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_12: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_13: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_14: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_15: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_16: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_17: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_18: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_19: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_20: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_21: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_22: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_23: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_24: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_25: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_26: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_27: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_28: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_29: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_30: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_31: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_32: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_33: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_34: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_35: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_36: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_37: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_38: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_39: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_40: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_41: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_42: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_43: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_44: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_45: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_46: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_47: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_48: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_49: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_50: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_51: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_52: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_53: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_54: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_55: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_56: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_57: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_58: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_59: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_60: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_61: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_62: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_63: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_64: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_65: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_66: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_67: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_68: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_69: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_70: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_71: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_72: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_73: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_74: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_75: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_76: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_77: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_78: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_79: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_80: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_81: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_82: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_83: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_84: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_85: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_86: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_87: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_88: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_89: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_90: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_91: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_92: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_93: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_94: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_95: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_96: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_97: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_98: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_99: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_100: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_101: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_102: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_103: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_104: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_105: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_106: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_107: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_108: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_109: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_110: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_111: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_112: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_113: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_114: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_115: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_116: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_117: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_118: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_119: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_120: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_121: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_122: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_123: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_124: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_125: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_126: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_127: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_128: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_129: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_130: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_131: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_132: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_133: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_134: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_135: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_136: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_137: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_138: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_139: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_140: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_141: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_142: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_143: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_144: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_145: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_146: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_147: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_148: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_149: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_150: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_151: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_152: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_153: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_154: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_155: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_156: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_157: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_158: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_159: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_160: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_161: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_162: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_163: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_164: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_165: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_166: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_167: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_168: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_169: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_170: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_171: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_172: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_173: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_174: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_175: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_176: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_177: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_178: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_179: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_180: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_181: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_182: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_183: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_184: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_185: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_186: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_187: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_188: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_189: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_190: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_191: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_192: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_193: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_194: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_195: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_196: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_197: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_198: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_199: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_200: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_201: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_202: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_203: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_204: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_205: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_206: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_207: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_208: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_209: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_210: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_211: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_212: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_213: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_214: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_215: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_216: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_217: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_218: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_219: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_220: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_221: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_222: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_223: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_224: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_225: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_226: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_227: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_228: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_229: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_230: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_231: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_232: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_233: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_234: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_235: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_236: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_237: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_238: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_239: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_240: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_241: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_242: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_243: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_244: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_245: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_246: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_247: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_248: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_249: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/")
		ensure
			result_not_void: Result /= Void
		end

	character_class_plane_15_segment_250: ARRAY [INTEGER_8]
			-- Generated character class array segment
		once
			Result := string_to_array8 ("%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/%/29/